// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [Horizontal Device Metrics](https://learn.microsoft.com/en-us/typography/opentype/spec/hdmx) table.
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct HdmxMarker {
    num_glyphs: u16,
    records_byte_len: usize,
}

impl HdmxMarker {
    fn version_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }
    fn num_records_byte_range(&self) -> Range<usize> {
        let start = self.version_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }
    fn size_device_record_byte_range(&self) -> Range<usize> {
        let start = self.num_records_byte_range().end;
        start..start + u32::RAW_BYTE_LEN
    }
    fn records_byte_range(&self) -> Range<usize> {
        let start = self.size_device_record_byte_range().end;
        start..start + self.records_byte_len
    }
}

impl TopLevelTable for Hdmx<'_> {
    /// `hdmx`
    const TAG: Tag = Tag::new(b"hdmx");
}

impl ReadArgs for Hdmx<'_> {
    type Args = u16;
}

impl<'a> FontReadWithArgs<'a> for Hdmx<'a> {
    fn read_with_args(data: FontData<'a>, args: &u16) -> Result<Self, ReadError> {
        let num_glyphs = *args;
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        let num_records: u16 = cursor.read()?;
        cursor.advance::<u32>();
        let records_byte_len = (num_records as usize)
            .checked_mul(<DeviceRecord as ComputeSize>::compute_size(&num_glyphs)?)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(records_byte_len);
        cursor.finish(HdmxMarker {
            num_glyphs,
            records_byte_len,
        })
    }
}

impl<'a> Hdmx<'a> {
    /// A constructor that requires additional arguments.
    ///
    /// This type requires some external state in order to be
    /// parsed.
    pub fn read(data: FontData<'a>, num_glyphs: u16) -> Result<Self, ReadError> {
        let args = num_glyphs;
        Self::read_with_args(data, &args)
    }
}

/// The [Horizontal Device Metrics](https://learn.microsoft.com/en-us/typography/opentype/spec/hdmx) table.
pub type Hdmx<'a> = TableRef<'a, HdmxMarker>;

impl<'a> Hdmx<'a> {
    /// Table version number (set to 0).
    pub fn version(&self) -> u16 {
        let range = self.shape.version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Number of device records.
    pub fn num_records(&self) -> u16 {
        let range = self.shape.num_records_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Size of device record, 32-bit aligned.
    pub fn size_device_record(&self) -> u32 {
        let range = self.shape.size_device_record_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Array of device records.
    pub fn records(&self) -> ComputedArray<'a, DeviceRecord<'a>> {
        let range = self.shape.records_byte_range();
        self.data.read_with_args(range, &self.num_glyphs()).unwrap()
    }

    pub(crate) fn num_glyphs(&self) -> u16 {
        self.shape.num_glyphs
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Hdmx<'a> {
    fn type_name(&self) -> &str {
        "Hdmx"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("version", self.version())),
            1usize => Some(Field::new("num_records", self.num_records())),
            2usize => Some(Field::new("size_device_record", self.size_device_record())),
            3usize => Some(Field::new(
                "records",
                traversal::FieldType::computed_array(
                    "DeviceRecord",
                    self.records(),
                    self.offset_data(),
                ),
            )),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> std::fmt::Debug for Hdmx<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub struct DeviceRecord<'a> {
    /// Pixel size for following widths (as ppem).
    pub pixel_size: u8,
    /// Maximum width.
    pub max_width: u8,
    /// Array of glyphs (numgGlyphs is from the 'maxp' table).
    pub widths: &'a [u8],
}

impl<'a> DeviceRecord<'a> {
    /// Pixel size for following widths (as ppem).
    pub fn pixel_size(&self) -> u8 {
        self.pixel_size
    }

    /// Maximum width.
    pub fn max_width(&self) -> u8 {
        self.max_width
    }

    /// Array of glyphs (numgGlyphs is from the 'maxp' table).
    pub fn widths(&self) -> &'a [u8] {
        self.widths
    }
}

impl ReadArgs for DeviceRecord<'_> {
    type Args = u16;
}

impl ComputeSize for DeviceRecord<'_> {
    #[allow(clippy::needless_question_mark)]
    fn compute_size(args: &u16) -> Result<usize, ReadError> {
        let num_glyphs = *args;
        let mut result = 0usize;
        result = result
            .checked_add(u8::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        result = result
            .checked_add(u8::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        result = result
            .checked_add(
                (num_glyphs as usize)
                    .checked_mul(u8::RAW_BYTE_LEN)
                    .ok_or(ReadError::OutOfBounds)?,
            )
            .ok_or(ReadError::OutOfBounds)?;
        Ok(result)
    }
}

impl<'a> FontReadWithArgs<'a> for DeviceRecord<'a> {
    fn read_with_args(data: FontData<'a>, args: &u16) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        let num_glyphs = *args;
        Ok(Self {
            pixel_size: cursor.read()?,
            max_width: cursor.read()?,
            widths: cursor.read_array(num_glyphs as usize)?,
        })
    }
}

impl<'a> DeviceRecord<'a> {
    /// A constructor that requires additional arguments.
    ///
    /// This type requires some external state in order to be
    /// parsed.
    pub fn read(data: FontData<'a>, num_glyphs: u16) -> Result<Self, ReadError> {
        let args = num_glyphs;
        Self::read_with_args(data, &args)
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeRecord<'a> for DeviceRecord<'a> {
    fn traverse(self, data: FontData<'a>) -> RecordResolver<'a> {
        RecordResolver {
            name: "DeviceRecord",
            get_field: Box::new(move |idx, _data| match idx {
                0usize => Some(Field::new("pixel_size", self.pixel_size())),
                1usize => Some(Field::new("max_width", self.max_width())),
                2usize => Some(Field::new("widths", self.widths())),
                _ => None,
            }),
            data,
        }
    }
}
