// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [cvar](https://learn.microsoft.com/en-us/typography/opentype/spec/cvar) table.
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct CvarMarker {
    tuple_variation_headers_byte_len: usize,
}

impl CvarMarker {
    fn version_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + MajorMinor::RAW_BYTE_LEN
    }
    fn tuple_variation_count_byte_range(&self) -> Range<usize> {
        let start = self.version_byte_range().end;
        start..start + TupleVariationCount::RAW_BYTE_LEN
    }
    fn data_offset_byte_range(&self) -> Range<usize> {
        let start = self.tuple_variation_count_byte_range().end;
        start..start + Offset16::RAW_BYTE_LEN
    }
    fn tuple_variation_headers_byte_range(&self) -> Range<usize> {
        let start = self.data_offset_byte_range().end;
        start..start + self.tuple_variation_headers_byte_len
    }
}

impl TopLevelTable for Cvar<'_> {
    /// `cvar`
    const TAG: Tag = Tag::new(b"cvar");
}

impl<'a> FontRead<'a> for Cvar<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<MajorMinor>();
        cursor.advance::<TupleVariationCount>();
        cursor.advance::<Offset16>();
        let tuple_variation_headers_byte_len = cursor.remaining_bytes();
        cursor.advance_by(tuple_variation_headers_byte_len);
        cursor.finish(CvarMarker {
            tuple_variation_headers_byte_len,
        })
    }
}

/// The [cvar](https://learn.microsoft.com/en-us/typography/opentype/spec/cvar) table.
pub type Cvar<'a> = TableRef<'a, CvarMarker>;

impl<'a> Cvar<'a> {
    /// Major/minor version number of the CVT variations table — set to (1,0).
    pub fn version(&self) -> MajorMinor {
        let range = self.shape.version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// A packed field. The high 4 bits are flags, and the low 12 bits
    /// are the number of tuple variation tables for this glyph. The
    /// number of tuple variation tables can be any number between 1
    /// and 4095.
    pub fn tuple_variation_count(&self) -> TupleVariationCount {
        let range = self.shape.tuple_variation_count_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Offset from the start of the 'cvar' table to the serialized data.
    pub fn data_offset(&self) -> Offset16 {
        let range = self.shape.data_offset_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Attempt to resolve [`data_offset`][Self::data_offset].
    pub fn data(&self) -> Result<FontData<'a>, ReadError> {
        let data = self.data;
        self.data_offset().resolve(data)
    }

    /// Array of tuple variation headers.
    pub fn tuple_variation_headers(&self) -> VarLenArray<'a, TupleVariationHeader> {
        let range = self.shape.tuple_variation_headers_byte_range();
        VarLenArray::read(self.data.split_off(range.start).unwrap()).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Cvar<'a> {
    fn type_name(&self) -> &str {
        "Cvar"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("version", self.version())),
            1usize => Some(Field::new(
                "tuple_variation_count",
                traversal::FieldType::Unknown,
            )),
            2usize => Some(Field::new("data_offset", traversal::FieldType::Unknown)),
            3usize => Some(Field::new(
                "tuple_variation_headers",
                traversal::FieldType::Unknown,
            )),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> std::fmt::Debug for Cvar<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}
