//! Autogenerated: fiat-crypto word-by-word-montgomery --lang Rust --inline p521_scalar 64 0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffa51868783bf2f966b7fcc0148f709a5d03bb5c9b8899c47aebb6fb71e91386409
//! curve description: p521_scalar
//! machine_wordsize = 64 (from "64")
//! requested operations: (all)
//! m = 0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffa51868783bf2f966b7fcc0148f709a5d03bb5c9b8899c47aebb6fb71e91386409 (from "0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffa51868783bf2f966b7fcc0148f709a5d03bb5c9b8899c47aebb6fb71e91386409")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) + (z[6] << 0x180) + (z[7] << 0x1c0) + (z[8] << 2^9)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8) + (z[56] << 0x1c0) + (z[57] << 0x1c8) + (z[58] << 0x1d0) + (z[59] << 0x1d8) + (z[60] << 0x1e0) + (z[61] << 0x1e8) + (z[62] << 0x1f0) + (z[63] << 0x1f8) + (z[64] << 2^9) + (z[65] << 0x208)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) + (z[6] << 0x180) + (z[7] << 0x1c0) + (z[8] << 2^9) in
//!                            if x1 & (2^576-1) < 2^575 then x1 & (2^576-1) else (x1 & (2^576-1)) - 2^576

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

/// Since `Index` and `IndexMut` aren't callable in `const` contexts yet, this helper type helps unify
/// arrays and user-defined array-wrapper types into a single type which can be indexed in `const`
/// contexts. Once `const trait`s are stabilized this type can go away
struct IndexConst<T: ?Sized>(T);

impl<'a, T, const N: usize> IndexConst<&'a [T; N]> {
    #[inline(always)]
    #[allow(unused)]
    const fn index(self, i: usize) -> &'a T {
        &self.0[i]
    }
}
impl<'a, 'b, T, const N: usize> IndexConst<&'a mut &'b mut [T; N]> {
    #[inline(always)]
    #[allow(unused)]
    const fn index_mut(self, i: usize) -> &'a mut T {
        &mut self.0[i]
    }
}

/** fiat_p521_scalar_u1 represents values of 1 bits, stored in one byte. */
pub type fiat_p521_scalar_u1 = u8;
/** fiat_p521_scalar_i1 represents values of 1 bits, stored in one byte. */
pub type fiat_p521_scalar_i1 = i8;
/** fiat_p521_scalar_u2 represents values of 2 bits, stored in one byte. */
pub type fiat_p521_scalar_u2 = u8;
/** fiat_p521_scalar_i2 represents values of 2 bits, stored in one byte. */
pub type fiat_p521_scalar_i2 = i8;

/** The type fiat_p521_scalar_montgomery_domain_field_element is a field element in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_p521_scalar_montgomery_domain_field_element(pub [u64; 9]);

impl core::ops::Index<usize> for fiat_p521_scalar_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p521_scalar_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

impl<'a> IndexConst<&'a fiat_p521_scalar_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index(self, i: usize) -> &'a u64 {
        &self.0.0[i]
    }
}

impl<'a, 'b> IndexConst<&'a mut &'b mut fiat_p521_scalar_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index_mut(self, i: usize) -> &'a mut u64 {
        &mut self.0.0[i]
    }
}

/** The type fiat_p521_scalar_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_p521_scalar_non_montgomery_domain_field_element(pub [u64; 9]);

impl core::ops::Index<usize> for fiat_p521_scalar_non_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p521_scalar_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

impl<'a> IndexConst<&'a fiat_p521_scalar_non_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index(self, i: usize) -> &'a u64 {
        &self.0.0[i]
    }
}

impl<'a, 'b> IndexConst<&'a mut &'b mut fiat_p521_scalar_non_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index_mut(self, i: usize) -> &'a mut u64 {
        &mut self.0.0[i]
    }
}

/// The function fiat_p521_scalar_addcarryx_u64 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^64
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub const fn fiat_p521_scalar_addcarryx_u64(
    out1: &mut u64,
    out2: &mut fiat_p521_scalar_u1,
    arg1: fiat_p521_scalar_u1,
    arg2: u64,
    arg3: u64,
) {
    let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
    let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
    let x3: fiat_p521_scalar_u1 = ((x1 >> 64) as fiat_p521_scalar_u1);
    *out1 = x2;
    *out2 = x3;
}

/// The function fiat_p521_scalar_subborrowx_u64 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^64
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub const fn fiat_p521_scalar_subborrowx_u64(
    out1: &mut u64,
    out2: &mut fiat_p521_scalar_u1,
    arg1: fiat_p521_scalar_u1,
    arg2: u64,
    arg3: u64,
) {
    let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
    let x2: fiat_p521_scalar_i1 = ((x1 >> 64) as fiat_p521_scalar_i1);
    let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
    *out1 = x3;
    *out2 = (((0x0 as fiat_p521_scalar_i2) - (x2 as fiat_p521_scalar_i2)) as fiat_p521_scalar_u1);
}

/// The function fiat_p521_scalar_mulx_u64 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^64
///   out2 = ⌊arg1 * arg2 / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub const fn fiat_p521_scalar_mulx_u64(out1: &mut u64, out2: &mut u64, arg1: u64, arg2: u64) {
    let x1: u128 = ((arg1 as u128) * (arg2 as u128));
    let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
    let x3: u64 = ((x1 >> 64) as u64);
    *out1 = x2;
    *out2 = x3;
}

/// The function fiat_p521_scalar_cmovznz_u64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub const fn fiat_p521_scalar_cmovznz_u64(
    out1: &mut u64,
    arg1: fiat_p521_scalar_u1,
    arg2: u64,
    arg3: u64,
) {
    let x1: fiat_p521_scalar_u1 = (!(!arg1));
    let x2: u64 = ((((((0x0 as fiat_p521_scalar_i2) - (x1 as fiat_p521_scalar_i2))
        as fiat_p521_scalar_i1) as i128)
        & (0xffffffffffffffff as i128)) as u64);
    let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
    *out1 = x3;
}

/// The function fiat_p521_scalar_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_p521_scalar_mul(
    mut out1: &mut fiat_p521_scalar_montgomery_domain_field_element,
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
    arg2: &fiat_p521_scalar_montgomery_domain_field_element,
) {
    let x1: u64 = (*IndexConst(arg1).index(1));
    let x2: u64 = (*IndexConst(arg1).index(2));
    let x3: u64 = (*IndexConst(arg1).index(3));
    let x4: u64 = (*IndexConst(arg1).index(4));
    let x5: u64 = (*IndexConst(arg1).index(5));
    let x6: u64 = (*IndexConst(arg1).index(6));
    let x7: u64 = (*IndexConst(arg1).index(7));
    let x8: u64 = (*IndexConst(arg1).index(8));
    let x9: u64 = (*IndexConst(arg1).index(0));
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x10, &mut x11, x9, (*IndexConst(arg2).index(8)));
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x12, &mut x13, x9, (*IndexConst(arg2).index(7)));
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x14, &mut x15, x9, (*IndexConst(arg2).index(6)));
    let mut x16: u64 = 0;
    let mut x17: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x16, &mut x17, x9, (*IndexConst(arg2).index(5)));
    let mut x18: u64 = 0;
    let mut x19: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x18, &mut x19, x9, (*IndexConst(arg2).index(4)));
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x20, &mut x21, x9, (*IndexConst(arg2).index(3)));
    let mut x22: u64 = 0;
    let mut x23: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x22, &mut x23, x9, (*IndexConst(arg2).index(2)));
    let mut x24: u64 = 0;
    let mut x25: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x24, &mut x25, x9, (*IndexConst(arg2).index(1)));
    let mut x26: u64 = 0;
    let mut x27: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x26, &mut x27, x9, (*IndexConst(arg2).index(0)));
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x28, &mut x29, 0x0, x27, x24);
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x30, &mut x31, x29, x25, x22);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x32, &mut x33, x31, x23, x20);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x34, &mut x35, x33, x21, x18);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x36, &mut x37, x35, x19, x16);
    let mut x38: u64 = 0;
    let mut x39: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x38, &mut x39, x37, x17, x14);
    let mut x40: u64 = 0;
    let mut x41: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x40, &mut x41, x39, x15, x12);
    let mut x42: u64 = 0;
    let mut x43: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x42, &mut x43, x41, x13, x10);
    let x44: u64 = ((x43 as u64) + x11);
    let mut x45: u64 = 0;
    let mut x46: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x45, &mut x46, x26, 0x1d2f5ccd79a995c7);
    let mut x47: u64 = 0;
    let mut x48: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x47, &mut x48, x45, 0x1ff);
    let mut x49: u64 = 0;
    let mut x50: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x49, &mut x50, x45, 0xffffffffffffffff);
    let mut x51: u64 = 0;
    let mut x52: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x51, &mut x52, x45, 0xffffffffffffffff);
    let mut x53: u64 = 0;
    let mut x54: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x53, &mut x54, x45, 0xffffffffffffffff);
    let mut x55: u64 = 0;
    let mut x56: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x55, &mut x56, x45, 0xfffffffffffffffa);
    let mut x57: u64 = 0;
    let mut x58: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x57, &mut x58, x45, 0x51868783bf2f966b);
    let mut x59: u64 = 0;
    let mut x60: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x59, &mut x60, x45, 0x7fcc0148f709a5d0);
    let mut x61: u64 = 0;
    let mut x62: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x61, &mut x62, x45, 0x3bb5c9b8899c47ae);
    let mut x63: u64 = 0;
    let mut x64: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x63, &mut x64, x45, 0xbb6fb71e91386409);
    let mut x65: u64 = 0;
    let mut x66: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x65, &mut x66, 0x0, x64, x61);
    let mut x67: u64 = 0;
    let mut x68: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x67, &mut x68, x66, x62, x59);
    let mut x69: u64 = 0;
    let mut x70: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x69, &mut x70, x68, x60, x57);
    let mut x71: u64 = 0;
    let mut x72: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x71, &mut x72, x70, x58, x55);
    let mut x73: u64 = 0;
    let mut x74: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x73, &mut x74, x72, x56, x53);
    let mut x75: u64 = 0;
    let mut x76: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x75, &mut x76, x74, x54, x51);
    let mut x77: u64 = 0;
    let mut x78: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x77, &mut x78, x76, x52, x49);
    let mut x79: u64 = 0;
    let mut x80: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x79, &mut x80, x78, x50, x47);
    let x81: u64 = ((x80 as u64) + x48);
    let mut x82: u64 = 0;
    let mut x83: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x82, &mut x83, 0x0, x26, x63);
    let mut x84: u64 = 0;
    let mut x85: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x84, &mut x85, x83, x28, x65);
    let mut x86: u64 = 0;
    let mut x87: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x86, &mut x87, x85, x30, x67);
    let mut x88: u64 = 0;
    let mut x89: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x88, &mut x89, x87, x32, x69);
    let mut x90: u64 = 0;
    let mut x91: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x90, &mut x91, x89, x34, x71);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x92, &mut x93, x91, x36, x73);
    let mut x94: u64 = 0;
    let mut x95: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x94, &mut x95, x93, x38, x75);
    let mut x96: u64 = 0;
    let mut x97: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x40, x77);
    let mut x98: u64 = 0;
    let mut x99: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x42, x79);
    let mut x100: u64 = 0;
    let mut x101: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x44, x81);
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x102, &mut x103, x1, (*IndexConst(arg2).index(8)));
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x104, &mut x105, x1, (*IndexConst(arg2).index(7)));
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x106, &mut x107, x1, (*IndexConst(arg2).index(6)));
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x108, &mut x109, x1, (*IndexConst(arg2).index(5)));
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x110, &mut x111, x1, (*IndexConst(arg2).index(4)));
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x112, &mut x113, x1, (*IndexConst(arg2).index(3)));
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x114, &mut x115, x1, (*IndexConst(arg2).index(2)));
    let mut x116: u64 = 0;
    let mut x117: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x116, &mut x117, x1, (*IndexConst(arg2).index(1)));
    let mut x118: u64 = 0;
    let mut x119: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x118, &mut x119, x1, (*IndexConst(arg2).index(0)));
    let mut x120: u64 = 0;
    let mut x121: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x120, &mut x121, 0x0, x119, x116);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x122, &mut x123, x121, x117, x114);
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x124, &mut x125, x123, x115, x112);
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x126, &mut x127, x125, x113, x110);
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x111, x108);
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x130, &mut x131, x129, x109, x106);
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x132, &mut x133, x131, x107, x104);
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x134, &mut x135, x133, x105, x102);
    let x136: u64 = ((x135 as u64) + x103);
    let mut x137: u64 = 0;
    let mut x138: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x137, &mut x138, 0x0, x84, x118);
    let mut x139: u64 = 0;
    let mut x140: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x139, &mut x140, x138, x86, x120);
    let mut x141: u64 = 0;
    let mut x142: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x141, &mut x142, x140, x88, x122);
    let mut x143: u64 = 0;
    let mut x144: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x143, &mut x144, x142, x90, x124);
    let mut x145: u64 = 0;
    let mut x146: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x145, &mut x146, x144, x92, x126);
    let mut x147: u64 = 0;
    let mut x148: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x147, &mut x148, x146, x94, x128);
    let mut x149: u64 = 0;
    let mut x150: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x149, &mut x150, x148, x96, x130);
    let mut x151: u64 = 0;
    let mut x152: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x151, &mut x152, x150, x98, x132);
    let mut x153: u64 = 0;
    let mut x154: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x153, &mut x154, x152, x100, x134);
    let mut x155: u64 = 0;
    let mut x156: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x155, &mut x156, x154, (x101 as u64), x136);
    let mut x157: u64 = 0;
    let mut x158: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x157, &mut x158, x137, 0x1d2f5ccd79a995c7);
    let mut x159: u64 = 0;
    let mut x160: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x159, &mut x160, x157, 0x1ff);
    let mut x161: u64 = 0;
    let mut x162: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x161, &mut x162, x157, 0xffffffffffffffff);
    let mut x163: u64 = 0;
    let mut x164: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x163, &mut x164, x157, 0xffffffffffffffff);
    let mut x165: u64 = 0;
    let mut x166: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x165, &mut x166, x157, 0xffffffffffffffff);
    let mut x167: u64 = 0;
    let mut x168: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x167, &mut x168, x157, 0xfffffffffffffffa);
    let mut x169: u64 = 0;
    let mut x170: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x169, &mut x170, x157, 0x51868783bf2f966b);
    let mut x171: u64 = 0;
    let mut x172: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x171, &mut x172, x157, 0x7fcc0148f709a5d0);
    let mut x173: u64 = 0;
    let mut x174: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x173, &mut x174, x157, 0x3bb5c9b8899c47ae);
    let mut x175: u64 = 0;
    let mut x176: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x175, &mut x176, x157, 0xbb6fb71e91386409);
    let mut x177: u64 = 0;
    let mut x178: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x177, &mut x178, 0x0, x176, x173);
    let mut x179: u64 = 0;
    let mut x180: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x179, &mut x180, x178, x174, x171);
    let mut x181: u64 = 0;
    let mut x182: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x181, &mut x182, x180, x172, x169);
    let mut x183: u64 = 0;
    let mut x184: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x183, &mut x184, x182, x170, x167);
    let mut x185: u64 = 0;
    let mut x186: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x185, &mut x186, x184, x168, x165);
    let mut x187: u64 = 0;
    let mut x188: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x187, &mut x188, x186, x166, x163);
    let mut x189: u64 = 0;
    let mut x190: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x189, &mut x190, x188, x164, x161);
    let mut x191: u64 = 0;
    let mut x192: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x191, &mut x192, x190, x162, x159);
    let x193: u64 = ((x192 as u64) + x160);
    let mut x194: u64 = 0;
    let mut x195: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x194, &mut x195, 0x0, x137, x175);
    let mut x196: u64 = 0;
    let mut x197: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x196, &mut x197, x195, x139, x177);
    let mut x198: u64 = 0;
    let mut x199: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x198, &mut x199, x197, x141, x179);
    let mut x200: u64 = 0;
    let mut x201: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x200, &mut x201, x199, x143, x181);
    let mut x202: u64 = 0;
    let mut x203: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x202, &mut x203, x201, x145, x183);
    let mut x204: u64 = 0;
    let mut x205: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x204, &mut x205, x203, x147, x185);
    let mut x206: u64 = 0;
    let mut x207: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x206, &mut x207, x205, x149, x187);
    let mut x208: u64 = 0;
    let mut x209: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x208, &mut x209, x207, x151, x189);
    let mut x210: u64 = 0;
    let mut x211: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x210, &mut x211, x209, x153, x191);
    let mut x212: u64 = 0;
    let mut x213: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x212, &mut x213, x211, x155, x193);
    let x214: u64 = ((x213 as u64) + (x156 as u64));
    let mut x215: u64 = 0;
    let mut x216: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x215, &mut x216, x2, (*IndexConst(arg2).index(8)));
    let mut x217: u64 = 0;
    let mut x218: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x217, &mut x218, x2, (*IndexConst(arg2).index(7)));
    let mut x219: u64 = 0;
    let mut x220: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x219, &mut x220, x2, (*IndexConst(arg2).index(6)));
    let mut x221: u64 = 0;
    let mut x222: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x221, &mut x222, x2, (*IndexConst(arg2).index(5)));
    let mut x223: u64 = 0;
    let mut x224: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x223, &mut x224, x2, (*IndexConst(arg2).index(4)));
    let mut x225: u64 = 0;
    let mut x226: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x225, &mut x226, x2, (*IndexConst(arg2).index(3)));
    let mut x227: u64 = 0;
    let mut x228: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x227, &mut x228, x2, (*IndexConst(arg2).index(2)));
    let mut x229: u64 = 0;
    let mut x230: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x229, &mut x230, x2, (*IndexConst(arg2).index(1)));
    let mut x231: u64 = 0;
    let mut x232: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x231, &mut x232, x2, (*IndexConst(arg2).index(0)));
    let mut x233: u64 = 0;
    let mut x234: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x233, &mut x234, 0x0, x232, x229);
    let mut x235: u64 = 0;
    let mut x236: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x235, &mut x236, x234, x230, x227);
    let mut x237: u64 = 0;
    let mut x238: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x237, &mut x238, x236, x228, x225);
    let mut x239: u64 = 0;
    let mut x240: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x239, &mut x240, x238, x226, x223);
    let mut x241: u64 = 0;
    let mut x242: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x241, &mut x242, x240, x224, x221);
    let mut x243: u64 = 0;
    let mut x244: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x243, &mut x244, x242, x222, x219);
    let mut x245: u64 = 0;
    let mut x246: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x245, &mut x246, x244, x220, x217);
    let mut x247: u64 = 0;
    let mut x248: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x247, &mut x248, x246, x218, x215);
    let x249: u64 = ((x248 as u64) + x216);
    let mut x250: u64 = 0;
    let mut x251: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x250, &mut x251, 0x0, x196, x231);
    let mut x252: u64 = 0;
    let mut x253: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x252, &mut x253, x251, x198, x233);
    let mut x254: u64 = 0;
    let mut x255: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x254, &mut x255, x253, x200, x235);
    let mut x256: u64 = 0;
    let mut x257: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x256, &mut x257, x255, x202, x237);
    let mut x258: u64 = 0;
    let mut x259: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x258, &mut x259, x257, x204, x239);
    let mut x260: u64 = 0;
    let mut x261: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x260, &mut x261, x259, x206, x241);
    let mut x262: u64 = 0;
    let mut x263: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x262, &mut x263, x261, x208, x243);
    let mut x264: u64 = 0;
    let mut x265: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x264, &mut x265, x263, x210, x245);
    let mut x266: u64 = 0;
    let mut x267: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x266, &mut x267, x265, x212, x247);
    let mut x268: u64 = 0;
    let mut x269: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x268, &mut x269, x267, x214, x249);
    let mut x270: u64 = 0;
    let mut x271: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x270, &mut x271, x250, 0x1d2f5ccd79a995c7);
    let mut x272: u64 = 0;
    let mut x273: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x272, &mut x273, x270, 0x1ff);
    let mut x274: u64 = 0;
    let mut x275: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x274, &mut x275, x270, 0xffffffffffffffff);
    let mut x276: u64 = 0;
    let mut x277: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x276, &mut x277, x270, 0xffffffffffffffff);
    let mut x278: u64 = 0;
    let mut x279: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x278, &mut x279, x270, 0xffffffffffffffff);
    let mut x280: u64 = 0;
    let mut x281: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x280, &mut x281, x270, 0xfffffffffffffffa);
    let mut x282: u64 = 0;
    let mut x283: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x282, &mut x283, x270, 0x51868783bf2f966b);
    let mut x284: u64 = 0;
    let mut x285: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x284, &mut x285, x270, 0x7fcc0148f709a5d0);
    let mut x286: u64 = 0;
    let mut x287: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x286, &mut x287, x270, 0x3bb5c9b8899c47ae);
    let mut x288: u64 = 0;
    let mut x289: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x288, &mut x289, x270, 0xbb6fb71e91386409);
    let mut x290: u64 = 0;
    let mut x291: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x290, &mut x291, 0x0, x289, x286);
    let mut x292: u64 = 0;
    let mut x293: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x292, &mut x293, x291, x287, x284);
    let mut x294: u64 = 0;
    let mut x295: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x294, &mut x295, x293, x285, x282);
    let mut x296: u64 = 0;
    let mut x297: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x296, &mut x297, x295, x283, x280);
    let mut x298: u64 = 0;
    let mut x299: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x298, &mut x299, x297, x281, x278);
    let mut x300: u64 = 0;
    let mut x301: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x300, &mut x301, x299, x279, x276);
    let mut x302: u64 = 0;
    let mut x303: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x302, &mut x303, x301, x277, x274);
    let mut x304: u64 = 0;
    let mut x305: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x304, &mut x305, x303, x275, x272);
    let x306: u64 = ((x305 as u64) + x273);
    let mut x307: u64 = 0;
    let mut x308: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x307, &mut x308, 0x0, x250, x288);
    let mut x309: u64 = 0;
    let mut x310: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x309, &mut x310, x308, x252, x290);
    let mut x311: u64 = 0;
    let mut x312: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x311, &mut x312, x310, x254, x292);
    let mut x313: u64 = 0;
    let mut x314: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x313, &mut x314, x312, x256, x294);
    let mut x315: u64 = 0;
    let mut x316: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x315, &mut x316, x314, x258, x296);
    let mut x317: u64 = 0;
    let mut x318: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x317, &mut x318, x316, x260, x298);
    let mut x319: u64 = 0;
    let mut x320: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x319, &mut x320, x318, x262, x300);
    let mut x321: u64 = 0;
    let mut x322: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x321, &mut x322, x320, x264, x302);
    let mut x323: u64 = 0;
    let mut x324: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x323, &mut x324, x322, x266, x304);
    let mut x325: u64 = 0;
    let mut x326: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x325, &mut x326, x324, x268, x306);
    let x327: u64 = ((x326 as u64) + (x269 as u64));
    let mut x328: u64 = 0;
    let mut x329: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x328, &mut x329, x3, (*IndexConst(arg2).index(8)));
    let mut x330: u64 = 0;
    let mut x331: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x330, &mut x331, x3, (*IndexConst(arg2).index(7)));
    let mut x332: u64 = 0;
    let mut x333: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x332, &mut x333, x3, (*IndexConst(arg2).index(6)));
    let mut x334: u64 = 0;
    let mut x335: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x334, &mut x335, x3, (*IndexConst(arg2).index(5)));
    let mut x336: u64 = 0;
    let mut x337: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x336, &mut x337, x3, (*IndexConst(arg2).index(4)));
    let mut x338: u64 = 0;
    let mut x339: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x338, &mut x339, x3, (*IndexConst(arg2).index(3)));
    let mut x340: u64 = 0;
    let mut x341: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x340, &mut x341, x3, (*IndexConst(arg2).index(2)));
    let mut x342: u64 = 0;
    let mut x343: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x342, &mut x343, x3, (*IndexConst(arg2).index(1)));
    let mut x344: u64 = 0;
    let mut x345: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x344, &mut x345, x3, (*IndexConst(arg2).index(0)));
    let mut x346: u64 = 0;
    let mut x347: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x346, &mut x347, 0x0, x345, x342);
    let mut x348: u64 = 0;
    let mut x349: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x348, &mut x349, x347, x343, x340);
    let mut x350: u64 = 0;
    let mut x351: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x350, &mut x351, x349, x341, x338);
    let mut x352: u64 = 0;
    let mut x353: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x352, &mut x353, x351, x339, x336);
    let mut x354: u64 = 0;
    let mut x355: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x354, &mut x355, x353, x337, x334);
    let mut x356: u64 = 0;
    let mut x357: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x356, &mut x357, x355, x335, x332);
    let mut x358: u64 = 0;
    let mut x359: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x358, &mut x359, x357, x333, x330);
    let mut x360: u64 = 0;
    let mut x361: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x360, &mut x361, x359, x331, x328);
    let x362: u64 = ((x361 as u64) + x329);
    let mut x363: u64 = 0;
    let mut x364: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x363, &mut x364, 0x0, x309, x344);
    let mut x365: u64 = 0;
    let mut x366: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x365, &mut x366, x364, x311, x346);
    let mut x367: u64 = 0;
    let mut x368: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x367, &mut x368, x366, x313, x348);
    let mut x369: u64 = 0;
    let mut x370: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x369, &mut x370, x368, x315, x350);
    let mut x371: u64 = 0;
    let mut x372: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x371, &mut x372, x370, x317, x352);
    let mut x373: u64 = 0;
    let mut x374: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x373, &mut x374, x372, x319, x354);
    let mut x375: u64 = 0;
    let mut x376: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x375, &mut x376, x374, x321, x356);
    let mut x377: u64 = 0;
    let mut x378: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x377, &mut x378, x376, x323, x358);
    let mut x379: u64 = 0;
    let mut x380: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x379, &mut x380, x378, x325, x360);
    let mut x381: u64 = 0;
    let mut x382: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x381, &mut x382, x380, x327, x362);
    let mut x383: u64 = 0;
    let mut x384: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x383, &mut x384, x363, 0x1d2f5ccd79a995c7);
    let mut x385: u64 = 0;
    let mut x386: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x385, &mut x386, x383, 0x1ff);
    let mut x387: u64 = 0;
    let mut x388: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x387, &mut x388, x383, 0xffffffffffffffff);
    let mut x389: u64 = 0;
    let mut x390: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x389, &mut x390, x383, 0xffffffffffffffff);
    let mut x391: u64 = 0;
    let mut x392: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x391, &mut x392, x383, 0xffffffffffffffff);
    let mut x393: u64 = 0;
    let mut x394: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x393, &mut x394, x383, 0xfffffffffffffffa);
    let mut x395: u64 = 0;
    let mut x396: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x395, &mut x396, x383, 0x51868783bf2f966b);
    let mut x397: u64 = 0;
    let mut x398: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x397, &mut x398, x383, 0x7fcc0148f709a5d0);
    let mut x399: u64 = 0;
    let mut x400: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x399, &mut x400, x383, 0x3bb5c9b8899c47ae);
    let mut x401: u64 = 0;
    let mut x402: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x401, &mut x402, x383, 0xbb6fb71e91386409);
    let mut x403: u64 = 0;
    let mut x404: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x403, &mut x404, 0x0, x402, x399);
    let mut x405: u64 = 0;
    let mut x406: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x405, &mut x406, x404, x400, x397);
    let mut x407: u64 = 0;
    let mut x408: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x407, &mut x408, x406, x398, x395);
    let mut x409: u64 = 0;
    let mut x410: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x409, &mut x410, x408, x396, x393);
    let mut x411: u64 = 0;
    let mut x412: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x411, &mut x412, x410, x394, x391);
    let mut x413: u64 = 0;
    let mut x414: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x413, &mut x414, x412, x392, x389);
    let mut x415: u64 = 0;
    let mut x416: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x415, &mut x416, x414, x390, x387);
    let mut x417: u64 = 0;
    let mut x418: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x417, &mut x418, x416, x388, x385);
    let x419: u64 = ((x418 as u64) + x386);
    let mut x420: u64 = 0;
    let mut x421: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x420, &mut x421, 0x0, x363, x401);
    let mut x422: u64 = 0;
    let mut x423: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x422, &mut x423, x421, x365, x403);
    let mut x424: u64 = 0;
    let mut x425: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x424, &mut x425, x423, x367, x405);
    let mut x426: u64 = 0;
    let mut x427: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x426, &mut x427, x425, x369, x407);
    let mut x428: u64 = 0;
    let mut x429: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x428, &mut x429, x427, x371, x409);
    let mut x430: u64 = 0;
    let mut x431: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x430, &mut x431, x429, x373, x411);
    let mut x432: u64 = 0;
    let mut x433: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x432, &mut x433, x431, x375, x413);
    let mut x434: u64 = 0;
    let mut x435: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x434, &mut x435, x433, x377, x415);
    let mut x436: u64 = 0;
    let mut x437: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x436, &mut x437, x435, x379, x417);
    let mut x438: u64 = 0;
    let mut x439: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x438, &mut x439, x437, x381, x419);
    let x440: u64 = ((x439 as u64) + (x382 as u64));
    let mut x441: u64 = 0;
    let mut x442: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x441, &mut x442, x4, (*IndexConst(arg2).index(8)));
    let mut x443: u64 = 0;
    let mut x444: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x443, &mut x444, x4, (*IndexConst(arg2).index(7)));
    let mut x445: u64 = 0;
    let mut x446: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x445, &mut x446, x4, (*IndexConst(arg2).index(6)));
    let mut x447: u64 = 0;
    let mut x448: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x447, &mut x448, x4, (*IndexConst(arg2).index(5)));
    let mut x449: u64 = 0;
    let mut x450: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x449, &mut x450, x4, (*IndexConst(arg2).index(4)));
    let mut x451: u64 = 0;
    let mut x452: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x451, &mut x452, x4, (*IndexConst(arg2).index(3)));
    let mut x453: u64 = 0;
    let mut x454: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x453, &mut x454, x4, (*IndexConst(arg2).index(2)));
    let mut x455: u64 = 0;
    let mut x456: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x455, &mut x456, x4, (*IndexConst(arg2).index(1)));
    let mut x457: u64 = 0;
    let mut x458: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x457, &mut x458, x4, (*IndexConst(arg2).index(0)));
    let mut x459: u64 = 0;
    let mut x460: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x459, &mut x460, 0x0, x458, x455);
    let mut x461: u64 = 0;
    let mut x462: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x461, &mut x462, x460, x456, x453);
    let mut x463: u64 = 0;
    let mut x464: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x463, &mut x464, x462, x454, x451);
    let mut x465: u64 = 0;
    let mut x466: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x465, &mut x466, x464, x452, x449);
    let mut x467: u64 = 0;
    let mut x468: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x467, &mut x468, x466, x450, x447);
    let mut x469: u64 = 0;
    let mut x470: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x469, &mut x470, x468, x448, x445);
    let mut x471: u64 = 0;
    let mut x472: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x471, &mut x472, x470, x446, x443);
    let mut x473: u64 = 0;
    let mut x474: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x473, &mut x474, x472, x444, x441);
    let x475: u64 = ((x474 as u64) + x442);
    let mut x476: u64 = 0;
    let mut x477: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x476, &mut x477, 0x0, x422, x457);
    let mut x478: u64 = 0;
    let mut x479: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x478, &mut x479, x477, x424, x459);
    let mut x480: u64 = 0;
    let mut x481: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x480, &mut x481, x479, x426, x461);
    let mut x482: u64 = 0;
    let mut x483: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x482, &mut x483, x481, x428, x463);
    let mut x484: u64 = 0;
    let mut x485: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x484, &mut x485, x483, x430, x465);
    let mut x486: u64 = 0;
    let mut x487: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x486, &mut x487, x485, x432, x467);
    let mut x488: u64 = 0;
    let mut x489: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x488, &mut x489, x487, x434, x469);
    let mut x490: u64 = 0;
    let mut x491: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x490, &mut x491, x489, x436, x471);
    let mut x492: u64 = 0;
    let mut x493: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x492, &mut x493, x491, x438, x473);
    let mut x494: u64 = 0;
    let mut x495: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x494, &mut x495, x493, x440, x475);
    let mut x496: u64 = 0;
    let mut x497: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x496, &mut x497, x476, 0x1d2f5ccd79a995c7);
    let mut x498: u64 = 0;
    let mut x499: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x498, &mut x499, x496, 0x1ff);
    let mut x500: u64 = 0;
    let mut x501: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x500, &mut x501, x496, 0xffffffffffffffff);
    let mut x502: u64 = 0;
    let mut x503: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x502, &mut x503, x496, 0xffffffffffffffff);
    let mut x504: u64 = 0;
    let mut x505: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x504, &mut x505, x496, 0xffffffffffffffff);
    let mut x506: u64 = 0;
    let mut x507: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x506, &mut x507, x496, 0xfffffffffffffffa);
    let mut x508: u64 = 0;
    let mut x509: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x508, &mut x509, x496, 0x51868783bf2f966b);
    let mut x510: u64 = 0;
    let mut x511: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x510, &mut x511, x496, 0x7fcc0148f709a5d0);
    let mut x512: u64 = 0;
    let mut x513: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x512, &mut x513, x496, 0x3bb5c9b8899c47ae);
    let mut x514: u64 = 0;
    let mut x515: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x514, &mut x515, x496, 0xbb6fb71e91386409);
    let mut x516: u64 = 0;
    let mut x517: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x516, &mut x517, 0x0, x515, x512);
    let mut x518: u64 = 0;
    let mut x519: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x518, &mut x519, x517, x513, x510);
    let mut x520: u64 = 0;
    let mut x521: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x520, &mut x521, x519, x511, x508);
    let mut x522: u64 = 0;
    let mut x523: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x522, &mut x523, x521, x509, x506);
    let mut x524: u64 = 0;
    let mut x525: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x524, &mut x525, x523, x507, x504);
    let mut x526: u64 = 0;
    let mut x527: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x526, &mut x527, x525, x505, x502);
    let mut x528: u64 = 0;
    let mut x529: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x528, &mut x529, x527, x503, x500);
    let mut x530: u64 = 0;
    let mut x531: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x530, &mut x531, x529, x501, x498);
    let x532: u64 = ((x531 as u64) + x499);
    let mut x533: u64 = 0;
    let mut x534: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x533, &mut x534, 0x0, x476, x514);
    let mut x535: u64 = 0;
    let mut x536: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x535, &mut x536, x534, x478, x516);
    let mut x537: u64 = 0;
    let mut x538: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x537, &mut x538, x536, x480, x518);
    let mut x539: u64 = 0;
    let mut x540: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x539, &mut x540, x538, x482, x520);
    let mut x541: u64 = 0;
    let mut x542: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x541, &mut x542, x540, x484, x522);
    let mut x543: u64 = 0;
    let mut x544: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x543, &mut x544, x542, x486, x524);
    let mut x545: u64 = 0;
    let mut x546: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x545, &mut x546, x544, x488, x526);
    let mut x547: u64 = 0;
    let mut x548: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x547, &mut x548, x546, x490, x528);
    let mut x549: u64 = 0;
    let mut x550: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x549, &mut x550, x548, x492, x530);
    let mut x551: u64 = 0;
    let mut x552: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x551, &mut x552, x550, x494, x532);
    let x553: u64 = ((x552 as u64) + (x495 as u64));
    let mut x554: u64 = 0;
    let mut x555: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x554, &mut x555, x5, (*IndexConst(arg2).index(8)));
    let mut x556: u64 = 0;
    let mut x557: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x556, &mut x557, x5, (*IndexConst(arg2).index(7)));
    let mut x558: u64 = 0;
    let mut x559: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x558, &mut x559, x5, (*IndexConst(arg2).index(6)));
    let mut x560: u64 = 0;
    let mut x561: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x560, &mut x561, x5, (*IndexConst(arg2).index(5)));
    let mut x562: u64 = 0;
    let mut x563: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x562, &mut x563, x5, (*IndexConst(arg2).index(4)));
    let mut x564: u64 = 0;
    let mut x565: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x564, &mut x565, x5, (*IndexConst(arg2).index(3)));
    let mut x566: u64 = 0;
    let mut x567: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x566, &mut x567, x5, (*IndexConst(arg2).index(2)));
    let mut x568: u64 = 0;
    let mut x569: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x568, &mut x569, x5, (*IndexConst(arg2).index(1)));
    let mut x570: u64 = 0;
    let mut x571: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x570, &mut x571, x5, (*IndexConst(arg2).index(0)));
    let mut x572: u64 = 0;
    let mut x573: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x572, &mut x573, 0x0, x571, x568);
    let mut x574: u64 = 0;
    let mut x575: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x574, &mut x575, x573, x569, x566);
    let mut x576: u64 = 0;
    let mut x577: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x576, &mut x577, x575, x567, x564);
    let mut x578: u64 = 0;
    let mut x579: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x578, &mut x579, x577, x565, x562);
    let mut x580: u64 = 0;
    let mut x581: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x580, &mut x581, x579, x563, x560);
    let mut x582: u64 = 0;
    let mut x583: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x582, &mut x583, x581, x561, x558);
    let mut x584: u64 = 0;
    let mut x585: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x584, &mut x585, x583, x559, x556);
    let mut x586: u64 = 0;
    let mut x587: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x586, &mut x587, x585, x557, x554);
    let x588: u64 = ((x587 as u64) + x555);
    let mut x589: u64 = 0;
    let mut x590: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x589, &mut x590, 0x0, x535, x570);
    let mut x591: u64 = 0;
    let mut x592: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x591, &mut x592, x590, x537, x572);
    let mut x593: u64 = 0;
    let mut x594: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x593, &mut x594, x592, x539, x574);
    let mut x595: u64 = 0;
    let mut x596: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x595, &mut x596, x594, x541, x576);
    let mut x597: u64 = 0;
    let mut x598: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x597, &mut x598, x596, x543, x578);
    let mut x599: u64 = 0;
    let mut x600: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x599, &mut x600, x598, x545, x580);
    let mut x601: u64 = 0;
    let mut x602: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x601, &mut x602, x600, x547, x582);
    let mut x603: u64 = 0;
    let mut x604: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x603, &mut x604, x602, x549, x584);
    let mut x605: u64 = 0;
    let mut x606: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x605, &mut x606, x604, x551, x586);
    let mut x607: u64 = 0;
    let mut x608: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x607, &mut x608, x606, x553, x588);
    let mut x609: u64 = 0;
    let mut x610: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x609, &mut x610, x589, 0x1d2f5ccd79a995c7);
    let mut x611: u64 = 0;
    let mut x612: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x611, &mut x612, x609, 0x1ff);
    let mut x613: u64 = 0;
    let mut x614: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x613, &mut x614, x609, 0xffffffffffffffff);
    let mut x615: u64 = 0;
    let mut x616: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x615, &mut x616, x609, 0xffffffffffffffff);
    let mut x617: u64 = 0;
    let mut x618: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x617, &mut x618, x609, 0xffffffffffffffff);
    let mut x619: u64 = 0;
    let mut x620: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x619, &mut x620, x609, 0xfffffffffffffffa);
    let mut x621: u64 = 0;
    let mut x622: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x621, &mut x622, x609, 0x51868783bf2f966b);
    let mut x623: u64 = 0;
    let mut x624: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x623, &mut x624, x609, 0x7fcc0148f709a5d0);
    let mut x625: u64 = 0;
    let mut x626: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x625, &mut x626, x609, 0x3bb5c9b8899c47ae);
    let mut x627: u64 = 0;
    let mut x628: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x627, &mut x628, x609, 0xbb6fb71e91386409);
    let mut x629: u64 = 0;
    let mut x630: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x629, &mut x630, 0x0, x628, x625);
    let mut x631: u64 = 0;
    let mut x632: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x631, &mut x632, x630, x626, x623);
    let mut x633: u64 = 0;
    let mut x634: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x633, &mut x634, x632, x624, x621);
    let mut x635: u64 = 0;
    let mut x636: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x635, &mut x636, x634, x622, x619);
    let mut x637: u64 = 0;
    let mut x638: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x637, &mut x638, x636, x620, x617);
    let mut x639: u64 = 0;
    let mut x640: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x639, &mut x640, x638, x618, x615);
    let mut x641: u64 = 0;
    let mut x642: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x641, &mut x642, x640, x616, x613);
    let mut x643: u64 = 0;
    let mut x644: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x643, &mut x644, x642, x614, x611);
    let x645: u64 = ((x644 as u64) + x612);
    let mut x646: u64 = 0;
    let mut x647: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x646, &mut x647, 0x0, x589, x627);
    let mut x648: u64 = 0;
    let mut x649: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x648, &mut x649, x647, x591, x629);
    let mut x650: u64 = 0;
    let mut x651: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x650, &mut x651, x649, x593, x631);
    let mut x652: u64 = 0;
    let mut x653: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x652, &mut x653, x651, x595, x633);
    let mut x654: u64 = 0;
    let mut x655: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x654, &mut x655, x653, x597, x635);
    let mut x656: u64 = 0;
    let mut x657: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x656, &mut x657, x655, x599, x637);
    let mut x658: u64 = 0;
    let mut x659: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x658, &mut x659, x657, x601, x639);
    let mut x660: u64 = 0;
    let mut x661: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x660, &mut x661, x659, x603, x641);
    let mut x662: u64 = 0;
    let mut x663: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x662, &mut x663, x661, x605, x643);
    let mut x664: u64 = 0;
    let mut x665: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x664, &mut x665, x663, x607, x645);
    let x666: u64 = ((x665 as u64) + (x608 as u64));
    let mut x667: u64 = 0;
    let mut x668: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x667, &mut x668, x6, (*IndexConst(arg2).index(8)));
    let mut x669: u64 = 0;
    let mut x670: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x669, &mut x670, x6, (*IndexConst(arg2).index(7)));
    let mut x671: u64 = 0;
    let mut x672: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x671, &mut x672, x6, (*IndexConst(arg2).index(6)));
    let mut x673: u64 = 0;
    let mut x674: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x673, &mut x674, x6, (*IndexConst(arg2).index(5)));
    let mut x675: u64 = 0;
    let mut x676: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x675, &mut x676, x6, (*IndexConst(arg2).index(4)));
    let mut x677: u64 = 0;
    let mut x678: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x677, &mut x678, x6, (*IndexConst(arg2).index(3)));
    let mut x679: u64 = 0;
    let mut x680: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x679, &mut x680, x6, (*IndexConst(arg2).index(2)));
    let mut x681: u64 = 0;
    let mut x682: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x681, &mut x682, x6, (*IndexConst(arg2).index(1)));
    let mut x683: u64 = 0;
    let mut x684: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x683, &mut x684, x6, (*IndexConst(arg2).index(0)));
    let mut x685: u64 = 0;
    let mut x686: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x685, &mut x686, 0x0, x684, x681);
    let mut x687: u64 = 0;
    let mut x688: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x687, &mut x688, x686, x682, x679);
    let mut x689: u64 = 0;
    let mut x690: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x689, &mut x690, x688, x680, x677);
    let mut x691: u64 = 0;
    let mut x692: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x691, &mut x692, x690, x678, x675);
    let mut x693: u64 = 0;
    let mut x694: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x693, &mut x694, x692, x676, x673);
    let mut x695: u64 = 0;
    let mut x696: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x695, &mut x696, x694, x674, x671);
    let mut x697: u64 = 0;
    let mut x698: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x697, &mut x698, x696, x672, x669);
    let mut x699: u64 = 0;
    let mut x700: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x699, &mut x700, x698, x670, x667);
    let x701: u64 = ((x700 as u64) + x668);
    let mut x702: u64 = 0;
    let mut x703: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x702, &mut x703, 0x0, x648, x683);
    let mut x704: u64 = 0;
    let mut x705: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x704, &mut x705, x703, x650, x685);
    let mut x706: u64 = 0;
    let mut x707: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x706, &mut x707, x705, x652, x687);
    let mut x708: u64 = 0;
    let mut x709: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x708, &mut x709, x707, x654, x689);
    let mut x710: u64 = 0;
    let mut x711: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x710, &mut x711, x709, x656, x691);
    let mut x712: u64 = 0;
    let mut x713: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x712, &mut x713, x711, x658, x693);
    let mut x714: u64 = 0;
    let mut x715: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x714, &mut x715, x713, x660, x695);
    let mut x716: u64 = 0;
    let mut x717: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x716, &mut x717, x715, x662, x697);
    let mut x718: u64 = 0;
    let mut x719: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x718, &mut x719, x717, x664, x699);
    let mut x720: u64 = 0;
    let mut x721: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x720, &mut x721, x719, x666, x701);
    let mut x722: u64 = 0;
    let mut x723: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x722, &mut x723, x702, 0x1d2f5ccd79a995c7);
    let mut x724: u64 = 0;
    let mut x725: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x724, &mut x725, x722, 0x1ff);
    let mut x726: u64 = 0;
    let mut x727: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x726, &mut x727, x722, 0xffffffffffffffff);
    let mut x728: u64 = 0;
    let mut x729: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x728, &mut x729, x722, 0xffffffffffffffff);
    let mut x730: u64 = 0;
    let mut x731: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x730, &mut x731, x722, 0xffffffffffffffff);
    let mut x732: u64 = 0;
    let mut x733: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x732, &mut x733, x722, 0xfffffffffffffffa);
    let mut x734: u64 = 0;
    let mut x735: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x734, &mut x735, x722, 0x51868783bf2f966b);
    let mut x736: u64 = 0;
    let mut x737: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x736, &mut x737, x722, 0x7fcc0148f709a5d0);
    let mut x738: u64 = 0;
    let mut x739: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x738, &mut x739, x722, 0x3bb5c9b8899c47ae);
    let mut x740: u64 = 0;
    let mut x741: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x740, &mut x741, x722, 0xbb6fb71e91386409);
    let mut x742: u64 = 0;
    let mut x743: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x742, &mut x743, 0x0, x741, x738);
    let mut x744: u64 = 0;
    let mut x745: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x744, &mut x745, x743, x739, x736);
    let mut x746: u64 = 0;
    let mut x747: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x746, &mut x747, x745, x737, x734);
    let mut x748: u64 = 0;
    let mut x749: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x748, &mut x749, x747, x735, x732);
    let mut x750: u64 = 0;
    let mut x751: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x750, &mut x751, x749, x733, x730);
    let mut x752: u64 = 0;
    let mut x753: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x752, &mut x753, x751, x731, x728);
    let mut x754: u64 = 0;
    let mut x755: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x754, &mut x755, x753, x729, x726);
    let mut x756: u64 = 0;
    let mut x757: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x756, &mut x757, x755, x727, x724);
    let x758: u64 = ((x757 as u64) + x725);
    let mut x759: u64 = 0;
    let mut x760: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x759, &mut x760, 0x0, x702, x740);
    let mut x761: u64 = 0;
    let mut x762: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x761, &mut x762, x760, x704, x742);
    let mut x763: u64 = 0;
    let mut x764: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x763, &mut x764, x762, x706, x744);
    let mut x765: u64 = 0;
    let mut x766: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x765, &mut x766, x764, x708, x746);
    let mut x767: u64 = 0;
    let mut x768: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x767, &mut x768, x766, x710, x748);
    let mut x769: u64 = 0;
    let mut x770: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x769, &mut x770, x768, x712, x750);
    let mut x771: u64 = 0;
    let mut x772: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x771, &mut x772, x770, x714, x752);
    let mut x773: u64 = 0;
    let mut x774: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x773, &mut x774, x772, x716, x754);
    let mut x775: u64 = 0;
    let mut x776: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x775, &mut x776, x774, x718, x756);
    let mut x777: u64 = 0;
    let mut x778: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x777, &mut x778, x776, x720, x758);
    let x779: u64 = ((x778 as u64) + (x721 as u64));
    let mut x780: u64 = 0;
    let mut x781: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x780, &mut x781, x7, (*IndexConst(arg2).index(8)));
    let mut x782: u64 = 0;
    let mut x783: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x782, &mut x783, x7, (*IndexConst(arg2).index(7)));
    let mut x784: u64 = 0;
    let mut x785: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x784, &mut x785, x7, (*IndexConst(arg2).index(6)));
    let mut x786: u64 = 0;
    let mut x787: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x786, &mut x787, x7, (*IndexConst(arg2).index(5)));
    let mut x788: u64 = 0;
    let mut x789: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x788, &mut x789, x7, (*IndexConst(arg2).index(4)));
    let mut x790: u64 = 0;
    let mut x791: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x790, &mut x791, x7, (*IndexConst(arg2).index(3)));
    let mut x792: u64 = 0;
    let mut x793: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x792, &mut x793, x7, (*IndexConst(arg2).index(2)));
    let mut x794: u64 = 0;
    let mut x795: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x794, &mut x795, x7, (*IndexConst(arg2).index(1)));
    let mut x796: u64 = 0;
    let mut x797: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x796, &mut x797, x7, (*IndexConst(arg2).index(0)));
    let mut x798: u64 = 0;
    let mut x799: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x798, &mut x799, 0x0, x797, x794);
    let mut x800: u64 = 0;
    let mut x801: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x800, &mut x801, x799, x795, x792);
    let mut x802: u64 = 0;
    let mut x803: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x802, &mut x803, x801, x793, x790);
    let mut x804: u64 = 0;
    let mut x805: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x804, &mut x805, x803, x791, x788);
    let mut x806: u64 = 0;
    let mut x807: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x806, &mut x807, x805, x789, x786);
    let mut x808: u64 = 0;
    let mut x809: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x808, &mut x809, x807, x787, x784);
    let mut x810: u64 = 0;
    let mut x811: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x810, &mut x811, x809, x785, x782);
    let mut x812: u64 = 0;
    let mut x813: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x812, &mut x813, x811, x783, x780);
    let x814: u64 = ((x813 as u64) + x781);
    let mut x815: u64 = 0;
    let mut x816: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x815, &mut x816, 0x0, x761, x796);
    let mut x817: u64 = 0;
    let mut x818: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x817, &mut x818, x816, x763, x798);
    let mut x819: u64 = 0;
    let mut x820: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x819, &mut x820, x818, x765, x800);
    let mut x821: u64 = 0;
    let mut x822: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x821, &mut x822, x820, x767, x802);
    let mut x823: u64 = 0;
    let mut x824: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x823, &mut x824, x822, x769, x804);
    let mut x825: u64 = 0;
    let mut x826: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x825, &mut x826, x824, x771, x806);
    let mut x827: u64 = 0;
    let mut x828: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x827, &mut x828, x826, x773, x808);
    let mut x829: u64 = 0;
    let mut x830: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x829, &mut x830, x828, x775, x810);
    let mut x831: u64 = 0;
    let mut x832: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x831, &mut x832, x830, x777, x812);
    let mut x833: u64 = 0;
    let mut x834: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x833, &mut x834, x832, x779, x814);
    let mut x835: u64 = 0;
    let mut x836: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x835, &mut x836, x815, 0x1d2f5ccd79a995c7);
    let mut x837: u64 = 0;
    let mut x838: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x837, &mut x838, x835, 0x1ff);
    let mut x839: u64 = 0;
    let mut x840: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x839, &mut x840, x835, 0xffffffffffffffff);
    let mut x841: u64 = 0;
    let mut x842: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x841, &mut x842, x835, 0xffffffffffffffff);
    let mut x843: u64 = 0;
    let mut x844: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x843, &mut x844, x835, 0xffffffffffffffff);
    let mut x845: u64 = 0;
    let mut x846: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x845, &mut x846, x835, 0xfffffffffffffffa);
    let mut x847: u64 = 0;
    let mut x848: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x847, &mut x848, x835, 0x51868783bf2f966b);
    let mut x849: u64 = 0;
    let mut x850: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x849, &mut x850, x835, 0x7fcc0148f709a5d0);
    let mut x851: u64 = 0;
    let mut x852: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x851, &mut x852, x835, 0x3bb5c9b8899c47ae);
    let mut x853: u64 = 0;
    let mut x854: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x853, &mut x854, x835, 0xbb6fb71e91386409);
    let mut x855: u64 = 0;
    let mut x856: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x855, &mut x856, 0x0, x854, x851);
    let mut x857: u64 = 0;
    let mut x858: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x857, &mut x858, x856, x852, x849);
    let mut x859: u64 = 0;
    let mut x860: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x859, &mut x860, x858, x850, x847);
    let mut x861: u64 = 0;
    let mut x862: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x861, &mut x862, x860, x848, x845);
    let mut x863: u64 = 0;
    let mut x864: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x863, &mut x864, x862, x846, x843);
    let mut x865: u64 = 0;
    let mut x866: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x865, &mut x866, x864, x844, x841);
    let mut x867: u64 = 0;
    let mut x868: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x867, &mut x868, x866, x842, x839);
    let mut x869: u64 = 0;
    let mut x870: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x869, &mut x870, x868, x840, x837);
    let x871: u64 = ((x870 as u64) + x838);
    let mut x872: u64 = 0;
    let mut x873: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x872, &mut x873, 0x0, x815, x853);
    let mut x874: u64 = 0;
    let mut x875: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x874, &mut x875, x873, x817, x855);
    let mut x876: u64 = 0;
    let mut x877: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x876, &mut x877, x875, x819, x857);
    let mut x878: u64 = 0;
    let mut x879: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x878, &mut x879, x877, x821, x859);
    let mut x880: u64 = 0;
    let mut x881: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x880, &mut x881, x879, x823, x861);
    let mut x882: u64 = 0;
    let mut x883: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x882, &mut x883, x881, x825, x863);
    let mut x884: u64 = 0;
    let mut x885: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x884, &mut x885, x883, x827, x865);
    let mut x886: u64 = 0;
    let mut x887: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x886, &mut x887, x885, x829, x867);
    let mut x888: u64 = 0;
    let mut x889: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x888, &mut x889, x887, x831, x869);
    let mut x890: u64 = 0;
    let mut x891: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x890, &mut x891, x889, x833, x871);
    let x892: u64 = ((x891 as u64) + (x834 as u64));
    let mut x893: u64 = 0;
    let mut x894: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x893, &mut x894, x8, (*IndexConst(arg2).index(8)));
    let mut x895: u64 = 0;
    let mut x896: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x895, &mut x896, x8, (*IndexConst(arg2).index(7)));
    let mut x897: u64 = 0;
    let mut x898: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x897, &mut x898, x8, (*IndexConst(arg2).index(6)));
    let mut x899: u64 = 0;
    let mut x900: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x899, &mut x900, x8, (*IndexConst(arg2).index(5)));
    let mut x901: u64 = 0;
    let mut x902: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x901, &mut x902, x8, (*IndexConst(arg2).index(4)));
    let mut x903: u64 = 0;
    let mut x904: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x903, &mut x904, x8, (*IndexConst(arg2).index(3)));
    let mut x905: u64 = 0;
    let mut x906: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x905, &mut x906, x8, (*IndexConst(arg2).index(2)));
    let mut x907: u64 = 0;
    let mut x908: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x907, &mut x908, x8, (*IndexConst(arg2).index(1)));
    let mut x909: u64 = 0;
    let mut x910: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x909, &mut x910, x8, (*IndexConst(arg2).index(0)));
    let mut x911: u64 = 0;
    let mut x912: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x911, &mut x912, 0x0, x910, x907);
    let mut x913: u64 = 0;
    let mut x914: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x913, &mut x914, x912, x908, x905);
    let mut x915: u64 = 0;
    let mut x916: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x915, &mut x916, x914, x906, x903);
    let mut x917: u64 = 0;
    let mut x918: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x917, &mut x918, x916, x904, x901);
    let mut x919: u64 = 0;
    let mut x920: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x919, &mut x920, x918, x902, x899);
    let mut x921: u64 = 0;
    let mut x922: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x921, &mut x922, x920, x900, x897);
    let mut x923: u64 = 0;
    let mut x924: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x923, &mut x924, x922, x898, x895);
    let mut x925: u64 = 0;
    let mut x926: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x925, &mut x926, x924, x896, x893);
    let x927: u64 = ((x926 as u64) + x894);
    let mut x928: u64 = 0;
    let mut x929: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x928, &mut x929, 0x0, x874, x909);
    let mut x930: u64 = 0;
    let mut x931: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x930, &mut x931, x929, x876, x911);
    let mut x932: u64 = 0;
    let mut x933: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x932, &mut x933, x931, x878, x913);
    let mut x934: u64 = 0;
    let mut x935: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x934, &mut x935, x933, x880, x915);
    let mut x936: u64 = 0;
    let mut x937: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x936, &mut x937, x935, x882, x917);
    let mut x938: u64 = 0;
    let mut x939: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x938, &mut x939, x937, x884, x919);
    let mut x940: u64 = 0;
    let mut x941: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x940, &mut x941, x939, x886, x921);
    let mut x942: u64 = 0;
    let mut x943: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x942, &mut x943, x941, x888, x923);
    let mut x944: u64 = 0;
    let mut x945: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x944, &mut x945, x943, x890, x925);
    let mut x946: u64 = 0;
    let mut x947: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x946, &mut x947, x945, x892, x927);
    let mut x948: u64 = 0;
    let mut x949: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x948, &mut x949, x928, 0x1d2f5ccd79a995c7);
    let mut x950: u64 = 0;
    let mut x951: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x950, &mut x951, x948, 0x1ff);
    let mut x952: u64 = 0;
    let mut x953: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x952, &mut x953, x948, 0xffffffffffffffff);
    let mut x954: u64 = 0;
    let mut x955: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x954, &mut x955, x948, 0xffffffffffffffff);
    let mut x956: u64 = 0;
    let mut x957: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x956, &mut x957, x948, 0xffffffffffffffff);
    let mut x958: u64 = 0;
    let mut x959: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x958, &mut x959, x948, 0xfffffffffffffffa);
    let mut x960: u64 = 0;
    let mut x961: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x960, &mut x961, x948, 0x51868783bf2f966b);
    let mut x962: u64 = 0;
    let mut x963: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x962, &mut x963, x948, 0x7fcc0148f709a5d0);
    let mut x964: u64 = 0;
    let mut x965: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x964, &mut x965, x948, 0x3bb5c9b8899c47ae);
    let mut x966: u64 = 0;
    let mut x967: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x966, &mut x967, x948, 0xbb6fb71e91386409);
    let mut x968: u64 = 0;
    let mut x969: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x968, &mut x969, 0x0, x967, x964);
    let mut x970: u64 = 0;
    let mut x971: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x970, &mut x971, x969, x965, x962);
    let mut x972: u64 = 0;
    let mut x973: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x972, &mut x973, x971, x963, x960);
    let mut x974: u64 = 0;
    let mut x975: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x974, &mut x975, x973, x961, x958);
    let mut x976: u64 = 0;
    let mut x977: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x976, &mut x977, x975, x959, x956);
    let mut x978: u64 = 0;
    let mut x979: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x978, &mut x979, x977, x957, x954);
    let mut x980: u64 = 0;
    let mut x981: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x980, &mut x981, x979, x955, x952);
    let mut x982: u64 = 0;
    let mut x983: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x982, &mut x983, x981, x953, x950);
    let x984: u64 = ((x983 as u64) + x951);
    let mut x985: u64 = 0;
    let mut x986: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x985, &mut x986, 0x0, x928, x966);
    let mut x987: u64 = 0;
    let mut x988: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x987, &mut x988, x986, x930, x968);
    let mut x989: u64 = 0;
    let mut x990: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x989, &mut x990, x988, x932, x970);
    let mut x991: u64 = 0;
    let mut x992: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x991, &mut x992, x990, x934, x972);
    let mut x993: u64 = 0;
    let mut x994: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x993, &mut x994, x992, x936, x974);
    let mut x995: u64 = 0;
    let mut x996: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x995, &mut x996, x994, x938, x976);
    let mut x997: u64 = 0;
    let mut x998: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x997, &mut x998, x996, x940, x978);
    let mut x999: u64 = 0;
    let mut x1000: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x999, &mut x1000, x998, x942, x980);
    let mut x1001: u64 = 0;
    let mut x1002: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x1001, &mut x1002, x1000, x944, x982);
    let mut x1003: u64 = 0;
    let mut x1004: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x1003, &mut x1004, x1002, x946, x984);
    let x1005: u64 = ((x1004 as u64) + (x947 as u64));
    let mut x1006: u64 = 0;
    let mut x1007: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1006, &mut x1007, 0x0, x987, 0xbb6fb71e91386409);
    let mut x1008: u64 = 0;
    let mut x1009: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1008, &mut x1009, x1007, x989, 0x3bb5c9b8899c47ae);
    let mut x1010: u64 = 0;
    let mut x1011: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1010, &mut x1011, x1009, x991, 0x7fcc0148f709a5d0);
    let mut x1012: u64 = 0;
    let mut x1013: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1012, &mut x1013, x1011, x993, 0x51868783bf2f966b);
    let mut x1014: u64 = 0;
    let mut x1015: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1014, &mut x1015, x1013, x995, 0xfffffffffffffffa);
    let mut x1016: u64 = 0;
    let mut x1017: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1016, &mut x1017, x1015, x997, 0xffffffffffffffff);
    let mut x1018: u64 = 0;
    let mut x1019: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1018, &mut x1019, x1017, x999, 0xffffffffffffffff);
    let mut x1020: u64 = 0;
    let mut x1021: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1020, &mut x1021, x1019, x1001, 0xffffffffffffffff);
    let mut x1022: u64 = 0;
    let mut x1023: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1022, &mut x1023, x1021, x1003, 0x1ff);
    let mut x1024: u64 = 0;
    let mut x1025: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1024, &mut x1025, x1023, x1005, (0x0 as u64));
    let mut x1026: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1026, x1025, x1006, x987);
    let mut x1027: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1027, x1025, x1008, x989);
    let mut x1028: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1028, x1025, x1010, x991);
    let mut x1029: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1029, x1025, x1012, x993);
    let mut x1030: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1030, x1025, x1014, x995);
    let mut x1031: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1031, x1025, x1016, x997);
    let mut x1032: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1032, x1025, x1018, x999);
    let mut x1033: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1033, x1025, x1020, x1001);
    let mut x1034: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1034, x1025, x1022, x1003);
    *IndexConst(&mut out1).index_mut(0) = x1026;
    *IndexConst(&mut out1).index_mut(1) = x1027;
    *IndexConst(&mut out1).index_mut(2) = x1028;
    *IndexConst(&mut out1).index_mut(3) = x1029;
    *IndexConst(&mut out1).index_mut(4) = x1030;
    *IndexConst(&mut out1).index_mut(5) = x1031;
    *IndexConst(&mut out1).index_mut(6) = x1032;
    *IndexConst(&mut out1).index_mut(7) = x1033;
    *IndexConst(&mut out1).index_mut(8) = x1034;
}

/// The function fiat_p521_scalar_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_p521_scalar_square(
    mut out1: &mut fiat_p521_scalar_montgomery_domain_field_element,
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
) {
    let x1: u64 = (*IndexConst(arg1).index(1));
    let x2: u64 = (*IndexConst(arg1).index(2));
    let x3: u64 = (*IndexConst(arg1).index(3));
    let x4: u64 = (*IndexConst(arg1).index(4));
    let x5: u64 = (*IndexConst(arg1).index(5));
    let x6: u64 = (*IndexConst(arg1).index(6));
    let x7: u64 = (*IndexConst(arg1).index(7));
    let x8: u64 = (*IndexConst(arg1).index(8));
    let x9: u64 = (*IndexConst(arg1).index(0));
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x10, &mut x11, x9, (*IndexConst(arg1).index(8)));
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x12, &mut x13, x9, (*IndexConst(arg1).index(7)));
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x14, &mut x15, x9, (*IndexConst(arg1).index(6)));
    let mut x16: u64 = 0;
    let mut x17: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x16, &mut x17, x9, (*IndexConst(arg1).index(5)));
    let mut x18: u64 = 0;
    let mut x19: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x18, &mut x19, x9, (*IndexConst(arg1).index(4)));
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x20, &mut x21, x9, (*IndexConst(arg1).index(3)));
    let mut x22: u64 = 0;
    let mut x23: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x22, &mut x23, x9, (*IndexConst(arg1).index(2)));
    let mut x24: u64 = 0;
    let mut x25: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x24, &mut x25, x9, (*IndexConst(arg1).index(1)));
    let mut x26: u64 = 0;
    let mut x27: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x26, &mut x27, x9, (*IndexConst(arg1).index(0)));
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x28, &mut x29, 0x0, x27, x24);
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x30, &mut x31, x29, x25, x22);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x32, &mut x33, x31, x23, x20);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x34, &mut x35, x33, x21, x18);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x36, &mut x37, x35, x19, x16);
    let mut x38: u64 = 0;
    let mut x39: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x38, &mut x39, x37, x17, x14);
    let mut x40: u64 = 0;
    let mut x41: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x40, &mut x41, x39, x15, x12);
    let mut x42: u64 = 0;
    let mut x43: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x42, &mut x43, x41, x13, x10);
    let x44: u64 = ((x43 as u64) + x11);
    let mut x45: u64 = 0;
    let mut x46: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x45, &mut x46, x26, 0x1d2f5ccd79a995c7);
    let mut x47: u64 = 0;
    let mut x48: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x47, &mut x48, x45, 0x1ff);
    let mut x49: u64 = 0;
    let mut x50: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x49, &mut x50, x45, 0xffffffffffffffff);
    let mut x51: u64 = 0;
    let mut x52: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x51, &mut x52, x45, 0xffffffffffffffff);
    let mut x53: u64 = 0;
    let mut x54: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x53, &mut x54, x45, 0xffffffffffffffff);
    let mut x55: u64 = 0;
    let mut x56: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x55, &mut x56, x45, 0xfffffffffffffffa);
    let mut x57: u64 = 0;
    let mut x58: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x57, &mut x58, x45, 0x51868783bf2f966b);
    let mut x59: u64 = 0;
    let mut x60: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x59, &mut x60, x45, 0x7fcc0148f709a5d0);
    let mut x61: u64 = 0;
    let mut x62: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x61, &mut x62, x45, 0x3bb5c9b8899c47ae);
    let mut x63: u64 = 0;
    let mut x64: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x63, &mut x64, x45, 0xbb6fb71e91386409);
    let mut x65: u64 = 0;
    let mut x66: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x65, &mut x66, 0x0, x64, x61);
    let mut x67: u64 = 0;
    let mut x68: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x67, &mut x68, x66, x62, x59);
    let mut x69: u64 = 0;
    let mut x70: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x69, &mut x70, x68, x60, x57);
    let mut x71: u64 = 0;
    let mut x72: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x71, &mut x72, x70, x58, x55);
    let mut x73: u64 = 0;
    let mut x74: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x73, &mut x74, x72, x56, x53);
    let mut x75: u64 = 0;
    let mut x76: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x75, &mut x76, x74, x54, x51);
    let mut x77: u64 = 0;
    let mut x78: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x77, &mut x78, x76, x52, x49);
    let mut x79: u64 = 0;
    let mut x80: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x79, &mut x80, x78, x50, x47);
    let x81: u64 = ((x80 as u64) + x48);
    let mut x82: u64 = 0;
    let mut x83: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x82, &mut x83, 0x0, x26, x63);
    let mut x84: u64 = 0;
    let mut x85: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x84, &mut x85, x83, x28, x65);
    let mut x86: u64 = 0;
    let mut x87: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x86, &mut x87, x85, x30, x67);
    let mut x88: u64 = 0;
    let mut x89: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x88, &mut x89, x87, x32, x69);
    let mut x90: u64 = 0;
    let mut x91: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x90, &mut x91, x89, x34, x71);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x92, &mut x93, x91, x36, x73);
    let mut x94: u64 = 0;
    let mut x95: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x94, &mut x95, x93, x38, x75);
    let mut x96: u64 = 0;
    let mut x97: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x40, x77);
    let mut x98: u64 = 0;
    let mut x99: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x42, x79);
    let mut x100: u64 = 0;
    let mut x101: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x44, x81);
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x102, &mut x103, x1, (*IndexConst(arg1).index(8)));
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x104, &mut x105, x1, (*IndexConst(arg1).index(7)));
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x106, &mut x107, x1, (*IndexConst(arg1).index(6)));
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x108, &mut x109, x1, (*IndexConst(arg1).index(5)));
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x110, &mut x111, x1, (*IndexConst(arg1).index(4)));
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x112, &mut x113, x1, (*IndexConst(arg1).index(3)));
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x114, &mut x115, x1, (*IndexConst(arg1).index(2)));
    let mut x116: u64 = 0;
    let mut x117: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x116, &mut x117, x1, (*IndexConst(arg1).index(1)));
    let mut x118: u64 = 0;
    let mut x119: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x118, &mut x119, x1, (*IndexConst(arg1).index(0)));
    let mut x120: u64 = 0;
    let mut x121: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x120, &mut x121, 0x0, x119, x116);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x122, &mut x123, x121, x117, x114);
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x124, &mut x125, x123, x115, x112);
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x126, &mut x127, x125, x113, x110);
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x111, x108);
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x130, &mut x131, x129, x109, x106);
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x132, &mut x133, x131, x107, x104);
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x134, &mut x135, x133, x105, x102);
    let x136: u64 = ((x135 as u64) + x103);
    let mut x137: u64 = 0;
    let mut x138: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x137, &mut x138, 0x0, x84, x118);
    let mut x139: u64 = 0;
    let mut x140: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x139, &mut x140, x138, x86, x120);
    let mut x141: u64 = 0;
    let mut x142: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x141, &mut x142, x140, x88, x122);
    let mut x143: u64 = 0;
    let mut x144: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x143, &mut x144, x142, x90, x124);
    let mut x145: u64 = 0;
    let mut x146: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x145, &mut x146, x144, x92, x126);
    let mut x147: u64 = 0;
    let mut x148: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x147, &mut x148, x146, x94, x128);
    let mut x149: u64 = 0;
    let mut x150: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x149, &mut x150, x148, x96, x130);
    let mut x151: u64 = 0;
    let mut x152: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x151, &mut x152, x150, x98, x132);
    let mut x153: u64 = 0;
    let mut x154: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x153, &mut x154, x152, x100, x134);
    let mut x155: u64 = 0;
    let mut x156: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x155, &mut x156, x154, (x101 as u64), x136);
    let mut x157: u64 = 0;
    let mut x158: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x157, &mut x158, x137, 0x1d2f5ccd79a995c7);
    let mut x159: u64 = 0;
    let mut x160: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x159, &mut x160, x157, 0x1ff);
    let mut x161: u64 = 0;
    let mut x162: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x161, &mut x162, x157, 0xffffffffffffffff);
    let mut x163: u64 = 0;
    let mut x164: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x163, &mut x164, x157, 0xffffffffffffffff);
    let mut x165: u64 = 0;
    let mut x166: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x165, &mut x166, x157, 0xffffffffffffffff);
    let mut x167: u64 = 0;
    let mut x168: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x167, &mut x168, x157, 0xfffffffffffffffa);
    let mut x169: u64 = 0;
    let mut x170: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x169, &mut x170, x157, 0x51868783bf2f966b);
    let mut x171: u64 = 0;
    let mut x172: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x171, &mut x172, x157, 0x7fcc0148f709a5d0);
    let mut x173: u64 = 0;
    let mut x174: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x173, &mut x174, x157, 0x3bb5c9b8899c47ae);
    let mut x175: u64 = 0;
    let mut x176: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x175, &mut x176, x157, 0xbb6fb71e91386409);
    let mut x177: u64 = 0;
    let mut x178: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x177, &mut x178, 0x0, x176, x173);
    let mut x179: u64 = 0;
    let mut x180: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x179, &mut x180, x178, x174, x171);
    let mut x181: u64 = 0;
    let mut x182: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x181, &mut x182, x180, x172, x169);
    let mut x183: u64 = 0;
    let mut x184: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x183, &mut x184, x182, x170, x167);
    let mut x185: u64 = 0;
    let mut x186: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x185, &mut x186, x184, x168, x165);
    let mut x187: u64 = 0;
    let mut x188: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x187, &mut x188, x186, x166, x163);
    let mut x189: u64 = 0;
    let mut x190: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x189, &mut x190, x188, x164, x161);
    let mut x191: u64 = 0;
    let mut x192: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x191, &mut x192, x190, x162, x159);
    let x193: u64 = ((x192 as u64) + x160);
    let mut x194: u64 = 0;
    let mut x195: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x194, &mut x195, 0x0, x137, x175);
    let mut x196: u64 = 0;
    let mut x197: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x196, &mut x197, x195, x139, x177);
    let mut x198: u64 = 0;
    let mut x199: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x198, &mut x199, x197, x141, x179);
    let mut x200: u64 = 0;
    let mut x201: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x200, &mut x201, x199, x143, x181);
    let mut x202: u64 = 0;
    let mut x203: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x202, &mut x203, x201, x145, x183);
    let mut x204: u64 = 0;
    let mut x205: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x204, &mut x205, x203, x147, x185);
    let mut x206: u64 = 0;
    let mut x207: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x206, &mut x207, x205, x149, x187);
    let mut x208: u64 = 0;
    let mut x209: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x208, &mut x209, x207, x151, x189);
    let mut x210: u64 = 0;
    let mut x211: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x210, &mut x211, x209, x153, x191);
    let mut x212: u64 = 0;
    let mut x213: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x212, &mut x213, x211, x155, x193);
    let x214: u64 = ((x213 as u64) + (x156 as u64));
    let mut x215: u64 = 0;
    let mut x216: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x215, &mut x216, x2, (*IndexConst(arg1).index(8)));
    let mut x217: u64 = 0;
    let mut x218: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x217, &mut x218, x2, (*IndexConst(arg1).index(7)));
    let mut x219: u64 = 0;
    let mut x220: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x219, &mut x220, x2, (*IndexConst(arg1).index(6)));
    let mut x221: u64 = 0;
    let mut x222: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x221, &mut x222, x2, (*IndexConst(arg1).index(5)));
    let mut x223: u64 = 0;
    let mut x224: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x223, &mut x224, x2, (*IndexConst(arg1).index(4)));
    let mut x225: u64 = 0;
    let mut x226: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x225, &mut x226, x2, (*IndexConst(arg1).index(3)));
    let mut x227: u64 = 0;
    let mut x228: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x227, &mut x228, x2, (*IndexConst(arg1).index(2)));
    let mut x229: u64 = 0;
    let mut x230: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x229, &mut x230, x2, (*IndexConst(arg1).index(1)));
    let mut x231: u64 = 0;
    let mut x232: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x231, &mut x232, x2, (*IndexConst(arg1).index(0)));
    let mut x233: u64 = 0;
    let mut x234: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x233, &mut x234, 0x0, x232, x229);
    let mut x235: u64 = 0;
    let mut x236: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x235, &mut x236, x234, x230, x227);
    let mut x237: u64 = 0;
    let mut x238: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x237, &mut x238, x236, x228, x225);
    let mut x239: u64 = 0;
    let mut x240: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x239, &mut x240, x238, x226, x223);
    let mut x241: u64 = 0;
    let mut x242: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x241, &mut x242, x240, x224, x221);
    let mut x243: u64 = 0;
    let mut x244: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x243, &mut x244, x242, x222, x219);
    let mut x245: u64 = 0;
    let mut x246: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x245, &mut x246, x244, x220, x217);
    let mut x247: u64 = 0;
    let mut x248: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x247, &mut x248, x246, x218, x215);
    let x249: u64 = ((x248 as u64) + x216);
    let mut x250: u64 = 0;
    let mut x251: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x250, &mut x251, 0x0, x196, x231);
    let mut x252: u64 = 0;
    let mut x253: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x252, &mut x253, x251, x198, x233);
    let mut x254: u64 = 0;
    let mut x255: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x254, &mut x255, x253, x200, x235);
    let mut x256: u64 = 0;
    let mut x257: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x256, &mut x257, x255, x202, x237);
    let mut x258: u64 = 0;
    let mut x259: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x258, &mut x259, x257, x204, x239);
    let mut x260: u64 = 0;
    let mut x261: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x260, &mut x261, x259, x206, x241);
    let mut x262: u64 = 0;
    let mut x263: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x262, &mut x263, x261, x208, x243);
    let mut x264: u64 = 0;
    let mut x265: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x264, &mut x265, x263, x210, x245);
    let mut x266: u64 = 0;
    let mut x267: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x266, &mut x267, x265, x212, x247);
    let mut x268: u64 = 0;
    let mut x269: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x268, &mut x269, x267, x214, x249);
    let mut x270: u64 = 0;
    let mut x271: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x270, &mut x271, x250, 0x1d2f5ccd79a995c7);
    let mut x272: u64 = 0;
    let mut x273: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x272, &mut x273, x270, 0x1ff);
    let mut x274: u64 = 0;
    let mut x275: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x274, &mut x275, x270, 0xffffffffffffffff);
    let mut x276: u64 = 0;
    let mut x277: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x276, &mut x277, x270, 0xffffffffffffffff);
    let mut x278: u64 = 0;
    let mut x279: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x278, &mut x279, x270, 0xffffffffffffffff);
    let mut x280: u64 = 0;
    let mut x281: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x280, &mut x281, x270, 0xfffffffffffffffa);
    let mut x282: u64 = 0;
    let mut x283: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x282, &mut x283, x270, 0x51868783bf2f966b);
    let mut x284: u64 = 0;
    let mut x285: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x284, &mut x285, x270, 0x7fcc0148f709a5d0);
    let mut x286: u64 = 0;
    let mut x287: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x286, &mut x287, x270, 0x3bb5c9b8899c47ae);
    let mut x288: u64 = 0;
    let mut x289: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x288, &mut x289, x270, 0xbb6fb71e91386409);
    let mut x290: u64 = 0;
    let mut x291: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x290, &mut x291, 0x0, x289, x286);
    let mut x292: u64 = 0;
    let mut x293: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x292, &mut x293, x291, x287, x284);
    let mut x294: u64 = 0;
    let mut x295: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x294, &mut x295, x293, x285, x282);
    let mut x296: u64 = 0;
    let mut x297: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x296, &mut x297, x295, x283, x280);
    let mut x298: u64 = 0;
    let mut x299: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x298, &mut x299, x297, x281, x278);
    let mut x300: u64 = 0;
    let mut x301: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x300, &mut x301, x299, x279, x276);
    let mut x302: u64 = 0;
    let mut x303: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x302, &mut x303, x301, x277, x274);
    let mut x304: u64 = 0;
    let mut x305: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x304, &mut x305, x303, x275, x272);
    let x306: u64 = ((x305 as u64) + x273);
    let mut x307: u64 = 0;
    let mut x308: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x307, &mut x308, 0x0, x250, x288);
    let mut x309: u64 = 0;
    let mut x310: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x309, &mut x310, x308, x252, x290);
    let mut x311: u64 = 0;
    let mut x312: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x311, &mut x312, x310, x254, x292);
    let mut x313: u64 = 0;
    let mut x314: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x313, &mut x314, x312, x256, x294);
    let mut x315: u64 = 0;
    let mut x316: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x315, &mut x316, x314, x258, x296);
    let mut x317: u64 = 0;
    let mut x318: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x317, &mut x318, x316, x260, x298);
    let mut x319: u64 = 0;
    let mut x320: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x319, &mut x320, x318, x262, x300);
    let mut x321: u64 = 0;
    let mut x322: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x321, &mut x322, x320, x264, x302);
    let mut x323: u64 = 0;
    let mut x324: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x323, &mut x324, x322, x266, x304);
    let mut x325: u64 = 0;
    let mut x326: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x325, &mut x326, x324, x268, x306);
    let x327: u64 = ((x326 as u64) + (x269 as u64));
    let mut x328: u64 = 0;
    let mut x329: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x328, &mut x329, x3, (*IndexConst(arg1).index(8)));
    let mut x330: u64 = 0;
    let mut x331: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x330, &mut x331, x3, (*IndexConst(arg1).index(7)));
    let mut x332: u64 = 0;
    let mut x333: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x332, &mut x333, x3, (*IndexConst(arg1).index(6)));
    let mut x334: u64 = 0;
    let mut x335: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x334, &mut x335, x3, (*IndexConst(arg1).index(5)));
    let mut x336: u64 = 0;
    let mut x337: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x336, &mut x337, x3, (*IndexConst(arg1).index(4)));
    let mut x338: u64 = 0;
    let mut x339: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x338, &mut x339, x3, (*IndexConst(arg1).index(3)));
    let mut x340: u64 = 0;
    let mut x341: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x340, &mut x341, x3, (*IndexConst(arg1).index(2)));
    let mut x342: u64 = 0;
    let mut x343: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x342, &mut x343, x3, (*IndexConst(arg1).index(1)));
    let mut x344: u64 = 0;
    let mut x345: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x344, &mut x345, x3, (*IndexConst(arg1).index(0)));
    let mut x346: u64 = 0;
    let mut x347: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x346, &mut x347, 0x0, x345, x342);
    let mut x348: u64 = 0;
    let mut x349: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x348, &mut x349, x347, x343, x340);
    let mut x350: u64 = 0;
    let mut x351: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x350, &mut x351, x349, x341, x338);
    let mut x352: u64 = 0;
    let mut x353: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x352, &mut x353, x351, x339, x336);
    let mut x354: u64 = 0;
    let mut x355: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x354, &mut x355, x353, x337, x334);
    let mut x356: u64 = 0;
    let mut x357: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x356, &mut x357, x355, x335, x332);
    let mut x358: u64 = 0;
    let mut x359: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x358, &mut x359, x357, x333, x330);
    let mut x360: u64 = 0;
    let mut x361: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x360, &mut x361, x359, x331, x328);
    let x362: u64 = ((x361 as u64) + x329);
    let mut x363: u64 = 0;
    let mut x364: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x363, &mut x364, 0x0, x309, x344);
    let mut x365: u64 = 0;
    let mut x366: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x365, &mut x366, x364, x311, x346);
    let mut x367: u64 = 0;
    let mut x368: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x367, &mut x368, x366, x313, x348);
    let mut x369: u64 = 0;
    let mut x370: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x369, &mut x370, x368, x315, x350);
    let mut x371: u64 = 0;
    let mut x372: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x371, &mut x372, x370, x317, x352);
    let mut x373: u64 = 0;
    let mut x374: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x373, &mut x374, x372, x319, x354);
    let mut x375: u64 = 0;
    let mut x376: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x375, &mut x376, x374, x321, x356);
    let mut x377: u64 = 0;
    let mut x378: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x377, &mut x378, x376, x323, x358);
    let mut x379: u64 = 0;
    let mut x380: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x379, &mut x380, x378, x325, x360);
    let mut x381: u64 = 0;
    let mut x382: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x381, &mut x382, x380, x327, x362);
    let mut x383: u64 = 0;
    let mut x384: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x383, &mut x384, x363, 0x1d2f5ccd79a995c7);
    let mut x385: u64 = 0;
    let mut x386: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x385, &mut x386, x383, 0x1ff);
    let mut x387: u64 = 0;
    let mut x388: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x387, &mut x388, x383, 0xffffffffffffffff);
    let mut x389: u64 = 0;
    let mut x390: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x389, &mut x390, x383, 0xffffffffffffffff);
    let mut x391: u64 = 0;
    let mut x392: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x391, &mut x392, x383, 0xffffffffffffffff);
    let mut x393: u64 = 0;
    let mut x394: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x393, &mut x394, x383, 0xfffffffffffffffa);
    let mut x395: u64 = 0;
    let mut x396: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x395, &mut x396, x383, 0x51868783bf2f966b);
    let mut x397: u64 = 0;
    let mut x398: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x397, &mut x398, x383, 0x7fcc0148f709a5d0);
    let mut x399: u64 = 0;
    let mut x400: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x399, &mut x400, x383, 0x3bb5c9b8899c47ae);
    let mut x401: u64 = 0;
    let mut x402: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x401, &mut x402, x383, 0xbb6fb71e91386409);
    let mut x403: u64 = 0;
    let mut x404: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x403, &mut x404, 0x0, x402, x399);
    let mut x405: u64 = 0;
    let mut x406: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x405, &mut x406, x404, x400, x397);
    let mut x407: u64 = 0;
    let mut x408: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x407, &mut x408, x406, x398, x395);
    let mut x409: u64 = 0;
    let mut x410: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x409, &mut x410, x408, x396, x393);
    let mut x411: u64 = 0;
    let mut x412: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x411, &mut x412, x410, x394, x391);
    let mut x413: u64 = 0;
    let mut x414: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x413, &mut x414, x412, x392, x389);
    let mut x415: u64 = 0;
    let mut x416: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x415, &mut x416, x414, x390, x387);
    let mut x417: u64 = 0;
    let mut x418: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x417, &mut x418, x416, x388, x385);
    let x419: u64 = ((x418 as u64) + x386);
    let mut x420: u64 = 0;
    let mut x421: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x420, &mut x421, 0x0, x363, x401);
    let mut x422: u64 = 0;
    let mut x423: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x422, &mut x423, x421, x365, x403);
    let mut x424: u64 = 0;
    let mut x425: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x424, &mut x425, x423, x367, x405);
    let mut x426: u64 = 0;
    let mut x427: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x426, &mut x427, x425, x369, x407);
    let mut x428: u64 = 0;
    let mut x429: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x428, &mut x429, x427, x371, x409);
    let mut x430: u64 = 0;
    let mut x431: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x430, &mut x431, x429, x373, x411);
    let mut x432: u64 = 0;
    let mut x433: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x432, &mut x433, x431, x375, x413);
    let mut x434: u64 = 0;
    let mut x435: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x434, &mut x435, x433, x377, x415);
    let mut x436: u64 = 0;
    let mut x437: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x436, &mut x437, x435, x379, x417);
    let mut x438: u64 = 0;
    let mut x439: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x438, &mut x439, x437, x381, x419);
    let x440: u64 = ((x439 as u64) + (x382 as u64));
    let mut x441: u64 = 0;
    let mut x442: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x441, &mut x442, x4, (*IndexConst(arg1).index(8)));
    let mut x443: u64 = 0;
    let mut x444: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x443, &mut x444, x4, (*IndexConst(arg1).index(7)));
    let mut x445: u64 = 0;
    let mut x446: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x445, &mut x446, x4, (*IndexConst(arg1).index(6)));
    let mut x447: u64 = 0;
    let mut x448: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x447, &mut x448, x4, (*IndexConst(arg1).index(5)));
    let mut x449: u64 = 0;
    let mut x450: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x449, &mut x450, x4, (*IndexConst(arg1).index(4)));
    let mut x451: u64 = 0;
    let mut x452: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x451, &mut x452, x4, (*IndexConst(arg1).index(3)));
    let mut x453: u64 = 0;
    let mut x454: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x453, &mut x454, x4, (*IndexConst(arg1).index(2)));
    let mut x455: u64 = 0;
    let mut x456: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x455, &mut x456, x4, (*IndexConst(arg1).index(1)));
    let mut x457: u64 = 0;
    let mut x458: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x457, &mut x458, x4, (*IndexConst(arg1).index(0)));
    let mut x459: u64 = 0;
    let mut x460: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x459, &mut x460, 0x0, x458, x455);
    let mut x461: u64 = 0;
    let mut x462: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x461, &mut x462, x460, x456, x453);
    let mut x463: u64 = 0;
    let mut x464: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x463, &mut x464, x462, x454, x451);
    let mut x465: u64 = 0;
    let mut x466: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x465, &mut x466, x464, x452, x449);
    let mut x467: u64 = 0;
    let mut x468: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x467, &mut x468, x466, x450, x447);
    let mut x469: u64 = 0;
    let mut x470: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x469, &mut x470, x468, x448, x445);
    let mut x471: u64 = 0;
    let mut x472: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x471, &mut x472, x470, x446, x443);
    let mut x473: u64 = 0;
    let mut x474: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x473, &mut x474, x472, x444, x441);
    let x475: u64 = ((x474 as u64) + x442);
    let mut x476: u64 = 0;
    let mut x477: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x476, &mut x477, 0x0, x422, x457);
    let mut x478: u64 = 0;
    let mut x479: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x478, &mut x479, x477, x424, x459);
    let mut x480: u64 = 0;
    let mut x481: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x480, &mut x481, x479, x426, x461);
    let mut x482: u64 = 0;
    let mut x483: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x482, &mut x483, x481, x428, x463);
    let mut x484: u64 = 0;
    let mut x485: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x484, &mut x485, x483, x430, x465);
    let mut x486: u64 = 0;
    let mut x487: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x486, &mut x487, x485, x432, x467);
    let mut x488: u64 = 0;
    let mut x489: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x488, &mut x489, x487, x434, x469);
    let mut x490: u64 = 0;
    let mut x491: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x490, &mut x491, x489, x436, x471);
    let mut x492: u64 = 0;
    let mut x493: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x492, &mut x493, x491, x438, x473);
    let mut x494: u64 = 0;
    let mut x495: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x494, &mut x495, x493, x440, x475);
    let mut x496: u64 = 0;
    let mut x497: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x496, &mut x497, x476, 0x1d2f5ccd79a995c7);
    let mut x498: u64 = 0;
    let mut x499: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x498, &mut x499, x496, 0x1ff);
    let mut x500: u64 = 0;
    let mut x501: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x500, &mut x501, x496, 0xffffffffffffffff);
    let mut x502: u64 = 0;
    let mut x503: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x502, &mut x503, x496, 0xffffffffffffffff);
    let mut x504: u64 = 0;
    let mut x505: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x504, &mut x505, x496, 0xffffffffffffffff);
    let mut x506: u64 = 0;
    let mut x507: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x506, &mut x507, x496, 0xfffffffffffffffa);
    let mut x508: u64 = 0;
    let mut x509: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x508, &mut x509, x496, 0x51868783bf2f966b);
    let mut x510: u64 = 0;
    let mut x511: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x510, &mut x511, x496, 0x7fcc0148f709a5d0);
    let mut x512: u64 = 0;
    let mut x513: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x512, &mut x513, x496, 0x3bb5c9b8899c47ae);
    let mut x514: u64 = 0;
    let mut x515: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x514, &mut x515, x496, 0xbb6fb71e91386409);
    let mut x516: u64 = 0;
    let mut x517: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x516, &mut x517, 0x0, x515, x512);
    let mut x518: u64 = 0;
    let mut x519: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x518, &mut x519, x517, x513, x510);
    let mut x520: u64 = 0;
    let mut x521: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x520, &mut x521, x519, x511, x508);
    let mut x522: u64 = 0;
    let mut x523: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x522, &mut x523, x521, x509, x506);
    let mut x524: u64 = 0;
    let mut x525: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x524, &mut x525, x523, x507, x504);
    let mut x526: u64 = 0;
    let mut x527: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x526, &mut x527, x525, x505, x502);
    let mut x528: u64 = 0;
    let mut x529: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x528, &mut x529, x527, x503, x500);
    let mut x530: u64 = 0;
    let mut x531: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x530, &mut x531, x529, x501, x498);
    let x532: u64 = ((x531 as u64) + x499);
    let mut x533: u64 = 0;
    let mut x534: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x533, &mut x534, 0x0, x476, x514);
    let mut x535: u64 = 0;
    let mut x536: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x535, &mut x536, x534, x478, x516);
    let mut x537: u64 = 0;
    let mut x538: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x537, &mut x538, x536, x480, x518);
    let mut x539: u64 = 0;
    let mut x540: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x539, &mut x540, x538, x482, x520);
    let mut x541: u64 = 0;
    let mut x542: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x541, &mut x542, x540, x484, x522);
    let mut x543: u64 = 0;
    let mut x544: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x543, &mut x544, x542, x486, x524);
    let mut x545: u64 = 0;
    let mut x546: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x545, &mut x546, x544, x488, x526);
    let mut x547: u64 = 0;
    let mut x548: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x547, &mut x548, x546, x490, x528);
    let mut x549: u64 = 0;
    let mut x550: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x549, &mut x550, x548, x492, x530);
    let mut x551: u64 = 0;
    let mut x552: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x551, &mut x552, x550, x494, x532);
    let x553: u64 = ((x552 as u64) + (x495 as u64));
    let mut x554: u64 = 0;
    let mut x555: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x554, &mut x555, x5, (*IndexConst(arg1).index(8)));
    let mut x556: u64 = 0;
    let mut x557: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x556, &mut x557, x5, (*IndexConst(arg1).index(7)));
    let mut x558: u64 = 0;
    let mut x559: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x558, &mut x559, x5, (*IndexConst(arg1).index(6)));
    let mut x560: u64 = 0;
    let mut x561: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x560, &mut x561, x5, (*IndexConst(arg1).index(5)));
    let mut x562: u64 = 0;
    let mut x563: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x562, &mut x563, x5, (*IndexConst(arg1).index(4)));
    let mut x564: u64 = 0;
    let mut x565: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x564, &mut x565, x5, (*IndexConst(arg1).index(3)));
    let mut x566: u64 = 0;
    let mut x567: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x566, &mut x567, x5, (*IndexConst(arg1).index(2)));
    let mut x568: u64 = 0;
    let mut x569: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x568, &mut x569, x5, (*IndexConst(arg1).index(1)));
    let mut x570: u64 = 0;
    let mut x571: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x570, &mut x571, x5, (*IndexConst(arg1).index(0)));
    let mut x572: u64 = 0;
    let mut x573: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x572, &mut x573, 0x0, x571, x568);
    let mut x574: u64 = 0;
    let mut x575: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x574, &mut x575, x573, x569, x566);
    let mut x576: u64 = 0;
    let mut x577: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x576, &mut x577, x575, x567, x564);
    let mut x578: u64 = 0;
    let mut x579: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x578, &mut x579, x577, x565, x562);
    let mut x580: u64 = 0;
    let mut x581: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x580, &mut x581, x579, x563, x560);
    let mut x582: u64 = 0;
    let mut x583: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x582, &mut x583, x581, x561, x558);
    let mut x584: u64 = 0;
    let mut x585: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x584, &mut x585, x583, x559, x556);
    let mut x586: u64 = 0;
    let mut x587: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x586, &mut x587, x585, x557, x554);
    let x588: u64 = ((x587 as u64) + x555);
    let mut x589: u64 = 0;
    let mut x590: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x589, &mut x590, 0x0, x535, x570);
    let mut x591: u64 = 0;
    let mut x592: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x591, &mut x592, x590, x537, x572);
    let mut x593: u64 = 0;
    let mut x594: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x593, &mut x594, x592, x539, x574);
    let mut x595: u64 = 0;
    let mut x596: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x595, &mut x596, x594, x541, x576);
    let mut x597: u64 = 0;
    let mut x598: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x597, &mut x598, x596, x543, x578);
    let mut x599: u64 = 0;
    let mut x600: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x599, &mut x600, x598, x545, x580);
    let mut x601: u64 = 0;
    let mut x602: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x601, &mut x602, x600, x547, x582);
    let mut x603: u64 = 0;
    let mut x604: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x603, &mut x604, x602, x549, x584);
    let mut x605: u64 = 0;
    let mut x606: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x605, &mut x606, x604, x551, x586);
    let mut x607: u64 = 0;
    let mut x608: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x607, &mut x608, x606, x553, x588);
    let mut x609: u64 = 0;
    let mut x610: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x609, &mut x610, x589, 0x1d2f5ccd79a995c7);
    let mut x611: u64 = 0;
    let mut x612: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x611, &mut x612, x609, 0x1ff);
    let mut x613: u64 = 0;
    let mut x614: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x613, &mut x614, x609, 0xffffffffffffffff);
    let mut x615: u64 = 0;
    let mut x616: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x615, &mut x616, x609, 0xffffffffffffffff);
    let mut x617: u64 = 0;
    let mut x618: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x617, &mut x618, x609, 0xffffffffffffffff);
    let mut x619: u64 = 0;
    let mut x620: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x619, &mut x620, x609, 0xfffffffffffffffa);
    let mut x621: u64 = 0;
    let mut x622: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x621, &mut x622, x609, 0x51868783bf2f966b);
    let mut x623: u64 = 0;
    let mut x624: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x623, &mut x624, x609, 0x7fcc0148f709a5d0);
    let mut x625: u64 = 0;
    let mut x626: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x625, &mut x626, x609, 0x3bb5c9b8899c47ae);
    let mut x627: u64 = 0;
    let mut x628: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x627, &mut x628, x609, 0xbb6fb71e91386409);
    let mut x629: u64 = 0;
    let mut x630: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x629, &mut x630, 0x0, x628, x625);
    let mut x631: u64 = 0;
    let mut x632: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x631, &mut x632, x630, x626, x623);
    let mut x633: u64 = 0;
    let mut x634: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x633, &mut x634, x632, x624, x621);
    let mut x635: u64 = 0;
    let mut x636: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x635, &mut x636, x634, x622, x619);
    let mut x637: u64 = 0;
    let mut x638: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x637, &mut x638, x636, x620, x617);
    let mut x639: u64 = 0;
    let mut x640: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x639, &mut x640, x638, x618, x615);
    let mut x641: u64 = 0;
    let mut x642: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x641, &mut x642, x640, x616, x613);
    let mut x643: u64 = 0;
    let mut x644: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x643, &mut x644, x642, x614, x611);
    let x645: u64 = ((x644 as u64) + x612);
    let mut x646: u64 = 0;
    let mut x647: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x646, &mut x647, 0x0, x589, x627);
    let mut x648: u64 = 0;
    let mut x649: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x648, &mut x649, x647, x591, x629);
    let mut x650: u64 = 0;
    let mut x651: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x650, &mut x651, x649, x593, x631);
    let mut x652: u64 = 0;
    let mut x653: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x652, &mut x653, x651, x595, x633);
    let mut x654: u64 = 0;
    let mut x655: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x654, &mut x655, x653, x597, x635);
    let mut x656: u64 = 0;
    let mut x657: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x656, &mut x657, x655, x599, x637);
    let mut x658: u64 = 0;
    let mut x659: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x658, &mut x659, x657, x601, x639);
    let mut x660: u64 = 0;
    let mut x661: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x660, &mut x661, x659, x603, x641);
    let mut x662: u64 = 0;
    let mut x663: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x662, &mut x663, x661, x605, x643);
    let mut x664: u64 = 0;
    let mut x665: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x664, &mut x665, x663, x607, x645);
    let x666: u64 = ((x665 as u64) + (x608 as u64));
    let mut x667: u64 = 0;
    let mut x668: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x667, &mut x668, x6, (*IndexConst(arg1).index(8)));
    let mut x669: u64 = 0;
    let mut x670: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x669, &mut x670, x6, (*IndexConst(arg1).index(7)));
    let mut x671: u64 = 0;
    let mut x672: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x671, &mut x672, x6, (*IndexConst(arg1).index(6)));
    let mut x673: u64 = 0;
    let mut x674: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x673, &mut x674, x6, (*IndexConst(arg1).index(5)));
    let mut x675: u64 = 0;
    let mut x676: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x675, &mut x676, x6, (*IndexConst(arg1).index(4)));
    let mut x677: u64 = 0;
    let mut x678: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x677, &mut x678, x6, (*IndexConst(arg1).index(3)));
    let mut x679: u64 = 0;
    let mut x680: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x679, &mut x680, x6, (*IndexConst(arg1).index(2)));
    let mut x681: u64 = 0;
    let mut x682: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x681, &mut x682, x6, (*IndexConst(arg1).index(1)));
    let mut x683: u64 = 0;
    let mut x684: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x683, &mut x684, x6, (*IndexConst(arg1).index(0)));
    let mut x685: u64 = 0;
    let mut x686: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x685, &mut x686, 0x0, x684, x681);
    let mut x687: u64 = 0;
    let mut x688: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x687, &mut x688, x686, x682, x679);
    let mut x689: u64 = 0;
    let mut x690: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x689, &mut x690, x688, x680, x677);
    let mut x691: u64 = 0;
    let mut x692: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x691, &mut x692, x690, x678, x675);
    let mut x693: u64 = 0;
    let mut x694: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x693, &mut x694, x692, x676, x673);
    let mut x695: u64 = 0;
    let mut x696: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x695, &mut x696, x694, x674, x671);
    let mut x697: u64 = 0;
    let mut x698: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x697, &mut x698, x696, x672, x669);
    let mut x699: u64 = 0;
    let mut x700: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x699, &mut x700, x698, x670, x667);
    let x701: u64 = ((x700 as u64) + x668);
    let mut x702: u64 = 0;
    let mut x703: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x702, &mut x703, 0x0, x648, x683);
    let mut x704: u64 = 0;
    let mut x705: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x704, &mut x705, x703, x650, x685);
    let mut x706: u64 = 0;
    let mut x707: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x706, &mut x707, x705, x652, x687);
    let mut x708: u64 = 0;
    let mut x709: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x708, &mut x709, x707, x654, x689);
    let mut x710: u64 = 0;
    let mut x711: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x710, &mut x711, x709, x656, x691);
    let mut x712: u64 = 0;
    let mut x713: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x712, &mut x713, x711, x658, x693);
    let mut x714: u64 = 0;
    let mut x715: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x714, &mut x715, x713, x660, x695);
    let mut x716: u64 = 0;
    let mut x717: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x716, &mut x717, x715, x662, x697);
    let mut x718: u64 = 0;
    let mut x719: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x718, &mut x719, x717, x664, x699);
    let mut x720: u64 = 0;
    let mut x721: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x720, &mut x721, x719, x666, x701);
    let mut x722: u64 = 0;
    let mut x723: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x722, &mut x723, x702, 0x1d2f5ccd79a995c7);
    let mut x724: u64 = 0;
    let mut x725: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x724, &mut x725, x722, 0x1ff);
    let mut x726: u64 = 0;
    let mut x727: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x726, &mut x727, x722, 0xffffffffffffffff);
    let mut x728: u64 = 0;
    let mut x729: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x728, &mut x729, x722, 0xffffffffffffffff);
    let mut x730: u64 = 0;
    let mut x731: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x730, &mut x731, x722, 0xffffffffffffffff);
    let mut x732: u64 = 0;
    let mut x733: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x732, &mut x733, x722, 0xfffffffffffffffa);
    let mut x734: u64 = 0;
    let mut x735: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x734, &mut x735, x722, 0x51868783bf2f966b);
    let mut x736: u64 = 0;
    let mut x737: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x736, &mut x737, x722, 0x7fcc0148f709a5d0);
    let mut x738: u64 = 0;
    let mut x739: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x738, &mut x739, x722, 0x3bb5c9b8899c47ae);
    let mut x740: u64 = 0;
    let mut x741: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x740, &mut x741, x722, 0xbb6fb71e91386409);
    let mut x742: u64 = 0;
    let mut x743: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x742, &mut x743, 0x0, x741, x738);
    let mut x744: u64 = 0;
    let mut x745: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x744, &mut x745, x743, x739, x736);
    let mut x746: u64 = 0;
    let mut x747: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x746, &mut x747, x745, x737, x734);
    let mut x748: u64 = 0;
    let mut x749: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x748, &mut x749, x747, x735, x732);
    let mut x750: u64 = 0;
    let mut x751: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x750, &mut x751, x749, x733, x730);
    let mut x752: u64 = 0;
    let mut x753: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x752, &mut x753, x751, x731, x728);
    let mut x754: u64 = 0;
    let mut x755: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x754, &mut x755, x753, x729, x726);
    let mut x756: u64 = 0;
    let mut x757: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x756, &mut x757, x755, x727, x724);
    let x758: u64 = ((x757 as u64) + x725);
    let mut x759: u64 = 0;
    let mut x760: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x759, &mut x760, 0x0, x702, x740);
    let mut x761: u64 = 0;
    let mut x762: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x761, &mut x762, x760, x704, x742);
    let mut x763: u64 = 0;
    let mut x764: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x763, &mut x764, x762, x706, x744);
    let mut x765: u64 = 0;
    let mut x766: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x765, &mut x766, x764, x708, x746);
    let mut x767: u64 = 0;
    let mut x768: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x767, &mut x768, x766, x710, x748);
    let mut x769: u64 = 0;
    let mut x770: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x769, &mut x770, x768, x712, x750);
    let mut x771: u64 = 0;
    let mut x772: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x771, &mut x772, x770, x714, x752);
    let mut x773: u64 = 0;
    let mut x774: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x773, &mut x774, x772, x716, x754);
    let mut x775: u64 = 0;
    let mut x776: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x775, &mut x776, x774, x718, x756);
    let mut x777: u64 = 0;
    let mut x778: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x777, &mut x778, x776, x720, x758);
    let x779: u64 = ((x778 as u64) + (x721 as u64));
    let mut x780: u64 = 0;
    let mut x781: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x780, &mut x781, x7, (*IndexConst(arg1).index(8)));
    let mut x782: u64 = 0;
    let mut x783: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x782, &mut x783, x7, (*IndexConst(arg1).index(7)));
    let mut x784: u64 = 0;
    let mut x785: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x784, &mut x785, x7, (*IndexConst(arg1).index(6)));
    let mut x786: u64 = 0;
    let mut x787: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x786, &mut x787, x7, (*IndexConst(arg1).index(5)));
    let mut x788: u64 = 0;
    let mut x789: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x788, &mut x789, x7, (*IndexConst(arg1).index(4)));
    let mut x790: u64 = 0;
    let mut x791: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x790, &mut x791, x7, (*IndexConst(arg1).index(3)));
    let mut x792: u64 = 0;
    let mut x793: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x792, &mut x793, x7, (*IndexConst(arg1).index(2)));
    let mut x794: u64 = 0;
    let mut x795: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x794, &mut x795, x7, (*IndexConst(arg1).index(1)));
    let mut x796: u64 = 0;
    let mut x797: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x796, &mut x797, x7, (*IndexConst(arg1).index(0)));
    let mut x798: u64 = 0;
    let mut x799: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x798, &mut x799, 0x0, x797, x794);
    let mut x800: u64 = 0;
    let mut x801: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x800, &mut x801, x799, x795, x792);
    let mut x802: u64 = 0;
    let mut x803: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x802, &mut x803, x801, x793, x790);
    let mut x804: u64 = 0;
    let mut x805: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x804, &mut x805, x803, x791, x788);
    let mut x806: u64 = 0;
    let mut x807: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x806, &mut x807, x805, x789, x786);
    let mut x808: u64 = 0;
    let mut x809: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x808, &mut x809, x807, x787, x784);
    let mut x810: u64 = 0;
    let mut x811: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x810, &mut x811, x809, x785, x782);
    let mut x812: u64 = 0;
    let mut x813: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x812, &mut x813, x811, x783, x780);
    let x814: u64 = ((x813 as u64) + x781);
    let mut x815: u64 = 0;
    let mut x816: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x815, &mut x816, 0x0, x761, x796);
    let mut x817: u64 = 0;
    let mut x818: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x817, &mut x818, x816, x763, x798);
    let mut x819: u64 = 0;
    let mut x820: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x819, &mut x820, x818, x765, x800);
    let mut x821: u64 = 0;
    let mut x822: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x821, &mut x822, x820, x767, x802);
    let mut x823: u64 = 0;
    let mut x824: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x823, &mut x824, x822, x769, x804);
    let mut x825: u64 = 0;
    let mut x826: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x825, &mut x826, x824, x771, x806);
    let mut x827: u64 = 0;
    let mut x828: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x827, &mut x828, x826, x773, x808);
    let mut x829: u64 = 0;
    let mut x830: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x829, &mut x830, x828, x775, x810);
    let mut x831: u64 = 0;
    let mut x832: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x831, &mut x832, x830, x777, x812);
    let mut x833: u64 = 0;
    let mut x834: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x833, &mut x834, x832, x779, x814);
    let mut x835: u64 = 0;
    let mut x836: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x835, &mut x836, x815, 0x1d2f5ccd79a995c7);
    let mut x837: u64 = 0;
    let mut x838: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x837, &mut x838, x835, 0x1ff);
    let mut x839: u64 = 0;
    let mut x840: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x839, &mut x840, x835, 0xffffffffffffffff);
    let mut x841: u64 = 0;
    let mut x842: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x841, &mut x842, x835, 0xffffffffffffffff);
    let mut x843: u64 = 0;
    let mut x844: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x843, &mut x844, x835, 0xffffffffffffffff);
    let mut x845: u64 = 0;
    let mut x846: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x845, &mut x846, x835, 0xfffffffffffffffa);
    let mut x847: u64 = 0;
    let mut x848: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x847, &mut x848, x835, 0x51868783bf2f966b);
    let mut x849: u64 = 0;
    let mut x850: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x849, &mut x850, x835, 0x7fcc0148f709a5d0);
    let mut x851: u64 = 0;
    let mut x852: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x851, &mut x852, x835, 0x3bb5c9b8899c47ae);
    let mut x853: u64 = 0;
    let mut x854: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x853, &mut x854, x835, 0xbb6fb71e91386409);
    let mut x855: u64 = 0;
    let mut x856: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x855, &mut x856, 0x0, x854, x851);
    let mut x857: u64 = 0;
    let mut x858: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x857, &mut x858, x856, x852, x849);
    let mut x859: u64 = 0;
    let mut x860: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x859, &mut x860, x858, x850, x847);
    let mut x861: u64 = 0;
    let mut x862: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x861, &mut x862, x860, x848, x845);
    let mut x863: u64 = 0;
    let mut x864: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x863, &mut x864, x862, x846, x843);
    let mut x865: u64 = 0;
    let mut x866: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x865, &mut x866, x864, x844, x841);
    let mut x867: u64 = 0;
    let mut x868: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x867, &mut x868, x866, x842, x839);
    let mut x869: u64 = 0;
    let mut x870: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x869, &mut x870, x868, x840, x837);
    let x871: u64 = ((x870 as u64) + x838);
    let mut x872: u64 = 0;
    let mut x873: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x872, &mut x873, 0x0, x815, x853);
    let mut x874: u64 = 0;
    let mut x875: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x874, &mut x875, x873, x817, x855);
    let mut x876: u64 = 0;
    let mut x877: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x876, &mut x877, x875, x819, x857);
    let mut x878: u64 = 0;
    let mut x879: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x878, &mut x879, x877, x821, x859);
    let mut x880: u64 = 0;
    let mut x881: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x880, &mut x881, x879, x823, x861);
    let mut x882: u64 = 0;
    let mut x883: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x882, &mut x883, x881, x825, x863);
    let mut x884: u64 = 0;
    let mut x885: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x884, &mut x885, x883, x827, x865);
    let mut x886: u64 = 0;
    let mut x887: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x886, &mut x887, x885, x829, x867);
    let mut x888: u64 = 0;
    let mut x889: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x888, &mut x889, x887, x831, x869);
    let mut x890: u64 = 0;
    let mut x891: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x890, &mut x891, x889, x833, x871);
    let x892: u64 = ((x891 as u64) + (x834 as u64));
    let mut x893: u64 = 0;
    let mut x894: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x893, &mut x894, x8, (*IndexConst(arg1).index(8)));
    let mut x895: u64 = 0;
    let mut x896: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x895, &mut x896, x8, (*IndexConst(arg1).index(7)));
    let mut x897: u64 = 0;
    let mut x898: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x897, &mut x898, x8, (*IndexConst(arg1).index(6)));
    let mut x899: u64 = 0;
    let mut x900: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x899, &mut x900, x8, (*IndexConst(arg1).index(5)));
    let mut x901: u64 = 0;
    let mut x902: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x901, &mut x902, x8, (*IndexConst(arg1).index(4)));
    let mut x903: u64 = 0;
    let mut x904: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x903, &mut x904, x8, (*IndexConst(arg1).index(3)));
    let mut x905: u64 = 0;
    let mut x906: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x905, &mut x906, x8, (*IndexConst(arg1).index(2)));
    let mut x907: u64 = 0;
    let mut x908: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x907, &mut x908, x8, (*IndexConst(arg1).index(1)));
    let mut x909: u64 = 0;
    let mut x910: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x909, &mut x910, x8, (*IndexConst(arg1).index(0)));
    let mut x911: u64 = 0;
    let mut x912: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x911, &mut x912, 0x0, x910, x907);
    let mut x913: u64 = 0;
    let mut x914: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x913, &mut x914, x912, x908, x905);
    let mut x915: u64 = 0;
    let mut x916: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x915, &mut x916, x914, x906, x903);
    let mut x917: u64 = 0;
    let mut x918: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x917, &mut x918, x916, x904, x901);
    let mut x919: u64 = 0;
    let mut x920: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x919, &mut x920, x918, x902, x899);
    let mut x921: u64 = 0;
    let mut x922: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x921, &mut x922, x920, x900, x897);
    let mut x923: u64 = 0;
    let mut x924: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x923, &mut x924, x922, x898, x895);
    let mut x925: u64 = 0;
    let mut x926: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x925, &mut x926, x924, x896, x893);
    let x927: u64 = ((x926 as u64) + x894);
    let mut x928: u64 = 0;
    let mut x929: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x928, &mut x929, 0x0, x874, x909);
    let mut x930: u64 = 0;
    let mut x931: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x930, &mut x931, x929, x876, x911);
    let mut x932: u64 = 0;
    let mut x933: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x932, &mut x933, x931, x878, x913);
    let mut x934: u64 = 0;
    let mut x935: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x934, &mut x935, x933, x880, x915);
    let mut x936: u64 = 0;
    let mut x937: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x936, &mut x937, x935, x882, x917);
    let mut x938: u64 = 0;
    let mut x939: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x938, &mut x939, x937, x884, x919);
    let mut x940: u64 = 0;
    let mut x941: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x940, &mut x941, x939, x886, x921);
    let mut x942: u64 = 0;
    let mut x943: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x942, &mut x943, x941, x888, x923);
    let mut x944: u64 = 0;
    let mut x945: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x944, &mut x945, x943, x890, x925);
    let mut x946: u64 = 0;
    let mut x947: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x946, &mut x947, x945, x892, x927);
    let mut x948: u64 = 0;
    let mut x949: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x948, &mut x949, x928, 0x1d2f5ccd79a995c7);
    let mut x950: u64 = 0;
    let mut x951: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x950, &mut x951, x948, 0x1ff);
    let mut x952: u64 = 0;
    let mut x953: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x952, &mut x953, x948, 0xffffffffffffffff);
    let mut x954: u64 = 0;
    let mut x955: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x954, &mut x955, x948, 0xffffffffffffffff);
    let mut x956: u64 = 0;
    let mut x957: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x956, &mut x957, x948, 0xffffffffffffffff);
    let mut x958: u64 = 0;
    let mut x959: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x958, &mut x959, x948, 0xfffffffffffffffa);
    let mut x960: u64 = 0;
    let mut x961: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x960, &mut x961, x948, 0x51868783bf2f966b);
    let mut x962: u64 = 0;
    let mut x963: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x962, &mut x963, x948, 0x7fcc0148f709a5d0);
    let mut x964: u64 = 0;
    let mut x965: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x964, &mut x965, x948, 0x3bb5c9b8899c47ae);
    let mut x966: u64 = 0;
    let mut x967: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x966, &mut x967, x948, 0xbb6fb71e91386409);
    let mut x968: u64 = 0;
    let mut x969: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x968, &mut x969, 0x0, x967, x964);
    let mut x970: u64 = 0;
    let mut x971: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x970, &mut x971, x969, x965, x962);
    let mut x972: u64 = 0;
    let mut x973: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x972, &mut x973, x971, x963, x960);
    let mut x974: u64 = 0;
    let mut x975: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x974, &mut x975, x973, x961, x958);
    let mut x976: u64 = 0;
    let mut x977: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x976, &mut x977, x975, x959, x956);
    let mut x978: u64 = 0;
    let mut x979: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x978, &mut x979, x977, x957, x954);
    let mut x980: u64 = 0;
    let mut x981: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x980, &mut x981, x979, x955, x952);
    let mut x982: u64 = 0;
    let mut x983: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x982, &mut x983, x981, x953, x950);
    let x984: u64 = ((x983 as u64) + x951);
    let mut x985: u64 = 0;
    let mut x986: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x985, &mut x986, 0x0, x928, x966);
    let mut x987: u64 = 0;
    let mut x988: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x987, &mut x988, x986, x930, x968);
    let mut x989: u64 = 0;
    let mut x990: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x989, &mut x990, x988, x932, x970);
    let mut x991: u64 = 0;
    let mut x992: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x991, &mut x992, x990, x934, x972);
    let mut x993: u64 = 0;
    let mut x994: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x993, &mut x994, x992, x936, x974);
    let mut x995: u64 = 0;
    let mut x996: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x995, &mut x996, x994, x938, x976);
    let mut x997: u64 = 0;
    let mut x998: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x997, &mut x998, x996, x940, x978);
    let mut x999: u64 = 0;
    let mut x1000: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x999, &mut x1000, x998, x942, x980);
    let mut x1001: u64 = 0;
    let mut x1002: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x1001, &mut x1002, x1000, x944, x982);
    let mut x1003: u64 = 0;
    let mut x1004: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x1003, &mut x1004, x1002, x946, x984);
    let x1005: u64 = ((x1004 as u64) + (x947 as u64));
    let mut x1006: u64 = 0;
    let mut x1007: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1006, &mut x1007, 0x0, x987, 0xbb6fb71e91386409);
    let mut x1008: u64 = 0;
    let mut x1009: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1008, &mut x1009, x1007, x989, 0x3bb5c9b8899c47ae);
    let mut x1010: u64 = 0;
    let mut x1011: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1010, &mut x1011, x1009, x991, 0x7fcc0148f709a5d0);
    let mut x1012: u64 = 0;
    let mut x1013: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1012, &mut x1013, x1011, x993, 0x51868783bf2f966b);
    let mut x1014: u64 = 0;
    let mut x1015: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1014, &mut x1015, x1013, x995, 0xfffffffffffffffa);
    let mut x1016: u64 = 0;
    let mut x1017: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1016, &mut x1017, x1015, x997, 0xffffffffffffffff);
    let mut x1018: u64 = 0;
    let mut x1019: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1018, &mut x1019, x1017, x999, 0xffffffffffffffff);
    let mut x1020: u64 = 0;
    let mut x1021: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1020, &mut x1021, x1019, x1001, 0xffffffffffffffff);
    let mut x1022: u64 = 0;
    let mut x1023: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1022, &mut x1023, x1021, x1003, 0x1ff);
    let mut x1024: u64 = 0;
    let mut x1025: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x1024, &mut x1025, x1023, x1005, (0x0 as u64));
    let mut x1026: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1026, x1025, x1006, x987);
    let mut x1027: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1027, x1025, x1008, x989);
    let mut x1028: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1028, x1025, x1010, x991);
    let mut x1029: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1029, x1025, x1012, x993);
    let mut x1030: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1030, x1025, x1014, x995);
    let mut x1031: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1031, x1025, x1016, x997);
    let mut x1032: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1032, x1025, x1018, x999);
    let mut x1033: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1033, x1025, x1020, x1001);
    let mut x1034: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x1034, x1025, x1022, x1003);
    *IndexConst(&mut out1).index_mut(0) = x1026;
    *IndexConst(&mut out1).index_mut(1) = x1027;
    *IndexConst(&mut out1).index_mut(2) = x1028;
    *IndexConst(&mut out1).index_mut(3) = x1029;
    *IndexConst(&mut out1).index_mut(4) = x1030;
    *IndexConst(&mut out1).index_mut(5) = x1031;
    *IndexConst(&mut out1).index_mut(6) = x1032;
    *IndexConst(&mut out1).index_mut(7) = x1033;
    *IndexConst(&mut out1).index_mut(8) = x1034;
}

/// The function fiat_p521_scalar_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_p521_scalar_add(
    mut out1: &mut fiat_p521_scalar_montgomery_domain_field_element,
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
    arg2: &fiat_p521_scalar_montgomery_domain_field_element,
) {
    let mut x1: u64 = 0;
    let mut x2: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x1,
        &mut x2,
        0x0,
        (*IndexConst(arg1).index(0)),
        (*IndexConst(arg2).index(0)),
    );
    let mut x3: u64 = 0;
    let mut x4: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x3,
        &mut x4,
        x2,
        (*IndexConst(arg1).index(1)),
        (*IndexConst(arg2).index(1)),
    );
    let mut x5: u64 = 0;
    let mut x6: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x5,
        &mut x6,
        x4,
        (*IndexConst(arg1).index(2)),
        (*IndexConst(arg2).index(2)),
    );
    let mut x7: u64 = 0;
    let mut x8: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x7,
        &mut x8,
        x6,
        (*IndexConst(arg1).index(3)),
        (*IndexConst(arg2).index(3)),
    );
    let mut x9: u64 = 0;
    let mut x10: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x9,
        &mut x10,
        x8,
        (*IndexConst(arg1).index(4)),
        (*IndexConst(arg2).index(4)),
    );
    let mut x11: u64 = 0;
    let mut x12: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x11,
        &mut x12,
        x10,
        (*IndexConst(arg1).index(5)),
        (*IndexConst(arg2).index(5)),
    );
    let mut x13: u64 = 0;
    let mut x14: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x13,
        &mut x14,
        x12,
        (*IndexConst(arg1).index(6)),
        (*IndexConst(arg2).index(6)),
    );
    let mut x15: u64 = 0;
    let mut x16: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x15,
        &mut x16,
        x14,
        (*IndexConst(arg1).index(7)),
        (*IndexConst(arg2).index(7)),
    );
    let mut x17: u64 = 0;
    let mut x18: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x17,
        &mut x18,
        x16,
        (*IndexConst(arg1).index(8)),
        (*IndexConst(arg2).index(8)),
    );
    let mut x19: u64 = 0;
    let mut x20: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x19, &mut x20, 0x0, x1, 0xbb6fb71e91386409);
    let mut x21: u64 = 0;
    let mut x22: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x21, &mut x22, x20, x3, 0x3bb5c9b8899c47ae);
    let mut x23: u64 = 0;
    let mut x24: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x23, &mut x24, x22, x5, 0x7fcc0148f709a5d0);
    let mut x25: u64 = 0;
    let mut x26: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x25, &mut x26, x24, x7, 0x51868783bf2f966b);
    let mut x27: u64 = 0;
    let mut x28: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x27, &mut x28, x26, x9, 0xfffffffffffffffa);
    let mut x29: u64 = 0;
    let mut x30: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x29, &mut x30, x28, x11, 0xffffffffffffffff);
    let mut x31: u64 = 0;
    let mut x32: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x31, &mut x32, x30, x13, 0xffffffffffffffff);
    let mut x33: u64 = 0;
    let mut x34: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x33, &mut x34, x32, x15, 0xffffffffffffffff);
    let mut x35: u64 = 0;
    let mut x36: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x35, &mut x36, x34, x17, 0x1ff);
    let mut x37: u64 = 0;
    let mut x38: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x37, &mut x38, x36, (x18 as u64), (0x0 as u64));
    let mut x39: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x39, x38, x19, x1);
    let mut x40: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x40, x38, x21, x3);
    let mut x41: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x41, x38, x23, x5);
    let mut x42: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x42, x38, x25, x7);
    let mut x43: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x43, x38, x27, x9);
    let mut x44: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x44, x38, x29, x11);
    let mut x45: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x45, x38, x31, x13);
    let mut x46: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x46, x38, x33, x15);
    let mut x47: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x47, x38, x35, x17);
    *IndexConst(&mut out1).index_mut(0) = x39;
    *IndexConst(&mut out1).index_mut(1) = x40;
    *IndexConst(&mut out1).index_mut(2) = x41;
    *IndexConst(&mut out1).index_mut(3) = x42;
    *IndexConst(&mut out1).index_mut(4) = x43;
    *IndexConst(&mut out1).index_mut(5) = x44;
    *IndexConst(&mut out1).index_mut(6) = x45;
    *IndexConst(&mut out1).index_mut(7) = x46;
    *IndexConst(&mut out1).index_mut(8) = x47;
}

/// The function fiat_p521_scalar_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_p521_scalar_sub(
    mut out1: &mut fiat_p521_scalar_montgomery_domain_field_element,
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
    arg2: &fiat_p521_scalar_montgomery_domain_field_element,
) {
    let mut x1: u64 = 0;
    let mut x2: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x1,
        &mut x2,
        0x0,
        (*IndexConst(arg1).index(0)),
        (*IndexConst(arg2).index(0)),
    );
    let mut x3: u64 = 0;
    let mut x4: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x3,
        &mut x4,
        x2,
        (*IndexConst(arg1).index(1)),
        (*IndexConst(arg2).index(1)),
    );
    let mut x5: u64 = 0;
    let mut x6: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x5,
        &mut x6,
        x4,
        (*IndexConst(arg1).index(2)),
        (*IndexConst(arg2).index(2)),
    );
    let mut x7: u64 = 0;
    let mut x8: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x7,
        &mut x8,
        x6,
        (*IndexConst(arg1).index(3)),
        (*IndexConst(arg2).index(3)),
    );
    let mut x9: u64 = 0;
    let mut x10: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x9,
        &mut x10,
        x8,
        (*IndexConst(arg1).index(4)),
        (*IndexConst(arg2).index(4)),
    );
    let mut x11: u64 = 0;
    let mut x12: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x11,
        &mut x12,
        x10,
        (*IndexConst(arg1).index(5)),
        (*IndexConst(arg2).index(5)),
    );
    let mut x13: u64 = 0;
    let mut x14: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x13,
        &mut x14,
        x12,
        (*IndexConst(arg1).index(6)),
        (*IndexConst(arg2).index(6)),
    );
    let mut x15: u64 = 0;
    let mut x16: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x15,
        &mut x16,
        x14,
        (*IndexConst(arg1).index(7)),
        (*IndexConst(arg2).index(7)),
    );
    let mut x17: u64 = 0;
    let mut x18: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x17,
        &mut x18,
        x16,
        (*IndexConst(arg1).index(8)),
        (*IndexConst(arg2).index(8)),
    );
    let mut x19: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x19, x18, (0x0 as u64), 0xffffffffffffffff);
    let mut x20: u64 = 0;
    let mut x21: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x20, &mut x21, 0x0, x1, (x19 & 0xbb6fb71e91386409));
    let mut x22: u64 = 0;
    let mut x23: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x22, &mut x23, x21, x3, (x19 & 0x3bb5c9b8899c47ae));
    let mut x24: u64 = 0;
    let mut x25: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x24, &mut x25, x23, x5, (x19 & 0x7fcc0148f709a5d0));
    let mut x26: u64 = 0;
    let mut x27: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x26, &mut x27, x25, x7, (x19 & 0x51868783bf2f966b));
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x28, &mut x29, x27, x9, (x19 & 0xfffffffffffffffa));
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x30, &mut x31, x29, x11, x19);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x32, &mut x33, x31, x13, x19);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x34, &mut x35, x33, x15, x19);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x36, &mut x37, x35, x17, (x19 & 0x1ff));
    *IndexConst(&mut out1).index_mut(0) = x20;
    *IndexConst(&mut out1).index_mut(1) = x22;
    *IndexConst(&mut out1).index_mut(2) = x24;
    *IndexConst(&mut out1).index_mut(3) = x26;
    *IndexConst(&mut out1).index_mut(4) = x28;
    *IndexConst(&mut out1).index_mut(5) = x30;
    *IndexConst(&mut out1).index_mut(6) = x32;
    *IndexConst(&mut out1).index_mut(7) = x34;
    *IndexConst(&mut out1).index_mut(8) = x36;
}

/// The function fiat_p521_scalar_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_p521_scalar_opp(
    mut out1: &mut fiat_p521_scalar_montgomery_domain_field_element,
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
) {
    let mut x1: u64 = 0;
    let mut x2: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x1,
        &mut x2,
        0x0,
        (0x0 as u64),
        (*IndexConst(arg1).index(0)),
    );
    let mut x3: u64 = 0;
    let mut x4: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x3,
        &mut x4,
        x2,
        (0x0 as u64),
        (*IndexConst(arg1).index(1)),
    );
    let mut x5: u64 = 0;
    let mut x6: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x5,
        &mut x6,
        x4,
        (0x0 as u64),
        (*IndexConst(arg1).index(2)),
    );
    let mut x7: u64 = 0;
    let mut x8: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x7,
        &mut x8,
        x6,
        (0x0 as u64),
        (*IndexConst(arg1).index(3)),
    );
    let mut x9: u64 = 0;
    let mut x10: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x9,
        &mut x10,
        x8,
        (0x0 as u64),
        (*IndexConst(arg1).index(4)),
    );
    let mut x11: u64 = 0;
    let mut x12: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x11,
        &mut x12,
        x10,
        (0x0 as u64),
        (*IndexConst(arg1).index(5)),
    );
    let mut x13: u64 = 0;
    let mut x14: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x13,
        &mut x14,
        x12,
        (0x0 as u64),
        (*IndexConst(arg1).index(6)),
    );
    let mut x15: u64 = 0;
    let mut x16: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x15,
        &mut x16,
        x14,
        (0x0 as u64),
        (*IndexConst(arg1).index(7)),
    );
    let mut x17: u64 = 0;
    let mut x18: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(
        &mut x17,
        &mut x18,
        x16,
        (0x0 as u64),
        (*IndexConst(arg1).index(8)),
    );
    let mut x19: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x19, x18, (0x0 as u64), 0xffffffffffffffff);
    let mut x20: u64 = 0;
    let mut x21: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x20, &mut x21, 0x0, x1, (x19 & 0xbb6fb71e91386409));
    let mut x22: u64 = 0;
    let mut x23: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x22, &mut x23, x21, x3, (x19 & 0x3bb5c9b8899c47ae));
    let mut x24: u64 = 0;
    let mut x25: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x24, &mut x25, x23, x5, (x19 & 0x7fcc0148f709a5d0));
    let mut x26: u64 = 0;
    let mut x27: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x26, &mut x27, x25, x7, (x19 & 0x51868783bf2f966b));
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x28, &mut x29, x27, x9, (x19 & 0xfffffffffffffffa));
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x30, &mut x31, x29, x11, x19);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x32, &mut x33, x31, x13, x19);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x34, &mut x35, x33, x15, x19);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x36, &mut x37, x35, x17, (x19 & 0x1ff));
    *IndexConst(&mut out1).index_mut(0) = x20;
    *IndexConst(&mut out1).index_mut(1) = x22;
    *IndexConst(&mut out1).index_mut(2) = x24;
    *IndexConst(&mut out1).index_mut(3) = x26;
    *IndexConst(&mut out1).index_mut(4) = x28;
    *IndexConst(&mut out1).index_mut(5) = x30;
    *IndexConst(&mut out1).index_mut(6) = x32;
    *IndexConst(&mut out1).index_mut(7) = x34;
    *IndexConst(&mut out1).index_mut(8) = x36;
}

/// The function fiat_p521_scalar_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^9) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_p521_scalar_from_montgomery(
    mut out1: &mut fiat_p521_scalar_non_montgomery_domain_field_element,
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
) {
    let x1: u64 = (*IndexConst(arg1).index(0));
    let mut x2: u64 = 0;
    let mut x3: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x2, &mut x3, x1, 0x1d2f5ccd79a995c7);
    let mut x4: u64 = 0;
    let mut x5: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x4, &mut x5, x2, 0x1ff);
    let mut x6: u64 = 0;
    let mut x7: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x6, &mut x7, x2, 0xffffffffffffffff);
    let mut x8: u64 = 0;
    let mut x9: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x8, &mut x9, x2, 0xffffffffffffffff);
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x10, &mut x11, x2, 0xffffffffffffffff);
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x12, &mut x13, x2, 0xfffffffffffffffa);
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x14, &mut x15, x2, 0x51868783bf2f966b);
    let mut x16: u64 = 0;
    let mut x17: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x16, &mut x17, x2, 0x7fcc0148f709a5d0);
    let mut x18: u64 = 0;
    let mut x19: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x18, &mut x19, x2, 0x3bb5c9b8899c47ae);
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x20, &mut x21, x2, 0xbb6fb71e91386409);
    let mut x22: u64 = 0;
    let mut x23: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x22, &mut x23, 0x0, x21, x18);
    let mut x24: u64 = 0;
    let mut x25: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x24, &mut x25, x23, x19, x16);
    let mut x26: u64 = 0;
    let mut x27: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x26, &mut x27, x25, x17, x14);
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x28, &mut x29, x27, x15, x12);
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x30, &mut x31, x29, x13, x10);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x32, &mut x33, x31, x11, x8);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x34, &mut x35, x33, x9, x6);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x36, &mut x37, x35, x7, x4);
    let mut x38: u64 = 0;
    let mut x39: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x38, &mut x39, 0x0, x1, x20);
    let mut x40: u64 = 0;
    let mut x41: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x40, &mut x41, x39, (0x0 as u64), x22);
    let mut x42: u64 = 0;
    let mut x43: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x42, &mut x43, x41, (0x0 as u64), x24);
    let mut x44: u64 = 0;
    let mut x45: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x44, &mut x45, x43, (0x0 as u64), x26);
    let mut x46: u64 = 0;
    let mut x47: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x46, &mut x47, x45, (0x0 as u64), x28);
    let mut x48: u64 = 0;
    let mut x49: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x48, &mut x49, x47, (0x0 as u64), x30);
    let mut x50: u64 = 0;
    let mut x51: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x50, &mut x51, x49, (0x0 as u64), x32);
    let mut x52: u64 = 0;
    let mut x53: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x52, &mut x53, x51, (0x0 as u64), x34);
    let mut x54: u64 = 0;
    let mut x55: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x54, &mut x55, x53, (0x0 as u64), x36);
    let mut x56: u64 = 0;
    let mut x57: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x56, &mut x57, 0x0, x40, (*IndexConst(arg1).index(1)));
    let mut x58: u64 = 0;
    let mut x59: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x58, &mut x59, x57, x42, (0x0 as u64));
    let mut x60: u64 = 0;
    let mut x61: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x60, &mut x61, x59, x44, (0x0 as u64));
    let mut x62: u64 = 0;
    let mut x63: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x62, &mut x63, x61, x46, (0x0 as u64));
    let mut x64: u64 = 0;
    let mut x65: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x64, &mut x65, x63, x48, (0x0 as u64));
    let mut x66: u64 = 0;
    let mut x67: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x66, &mut x67, x65, x50, (0x0 as u64));
    let mut x68: u64 = 0;
    let mut x69: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x68, &mut x69, x67, x52, (0x0 as u64));
    let mut x70: u64 = 0;
    let mut x71: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x70, &mut x71, x69, x54, (0x0 as u64));
    let mut x72: u64 = 0;
    let mut x73: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x72, &mut x73, x56, 0x1d2f5ccd79a995c7);
    let mut x74: u64 = 0;
    let mut x75: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x74, &mut x75, x72, 0x1ff);
    let mut x76: u64 = 0;
    let mut x77: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x76, &mut x77, x72, 0xffffffffffffffff);
    let mut x78: u64 = 0;
    let mut x79: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x78, &mut x79, x72, 0xffffffffffffffff);
    let mut x80: u64 = 0;
    let mut x81: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x80, &mut x81, x72, 0xffffffffffffffff);
    let mut x82: u64 = 0;
    let mut x83: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x82, &mut x83, x72, 0xfffffffffffffffa);
    let mut x84: u64 = 0;
    let mut x85: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x84, &mut x85, x72, 0x51868783bf2f966b);
    let mut x86: u64 = 0;
    let mut x87: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x86, &mut x87, x72, 0x7fcc0148f709a5d0);
    let mut x88: u64 = 0;
    let mut x89: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x88, &mut x89, x72, 0x3bb5c9b8899c47ae);
    let mut x90: u64 = 0;
    let mut x91: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x90, &mut x91, x72, 0xbb6fb71e91386409);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x92, &mut x93, 0x0, x91, x88);
    let mut x94: u64 = 0;
    let mut x95: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x94, &mut x95, x93, x89, x86);
    let mut x96: u64 = 0;
    let mut x97: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x87, x84);
    let mut x98: u64 = 0;
    let mut x99: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x85, x82);
    let mut x100: u64 = 0;
    let mut x101: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x83, x80);
    let mut x102: u64 = 0;
    let mut x103: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x102, &mut x103, x101, x81, x78);
    let mut x104: u64 = 0;
    let mut x105: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x104, &mut x105, x103, x79, x76);
    let mut x106: u64 = 0;
    let mut x107: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x106, &mut x107, x105, x77, x74);
    let mut x108: u64 = 0;
    let mut x109: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x108, &mut x109, 0x0, x56, x90);
    let mut x110: u64 = 0;
    let mut x111: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x110, &mut x111, x109, x58, x92);
    let mut x112: u64 = 0;
    let mut x113: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x112, &mut x113, x111, x60, x94);
    let mut x114: u64 = 0;
    let mut x115: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x114, &mut x115, x113, x62, x96);
    let mut x116: u64 = 0;
    let mut x117: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x116, &mut x117, x115, x64, x98);
    let mut x118: u64 = 0;
    let mut x119: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x118, &mut x119, x117, x66, x100);
    let mut x120: u64 = 0;
    let mut x121: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x120, &mut x121, x119, x68, x102);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x122, &mut x123, x121, x70, x104);
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x124,
        &mut x125,
        x123,
        ((x71 as u64) + ((x55 as u64) + ((x37 as u64) + x5))),
        x106,
    );
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x126,
        &mut x127,
        0x0,
        x110,
        (*IndexConst(arg1).index(2)),
    );
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x112, (0x0 as u64));
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x130, &mut x131, x129, x114, (0x0 as u64));
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x132, &mut x133, x131, x116, (0x0 as u64));
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x134, &mut x135, x133, x118, (0x0 as u64));
    let mut x136: u64 = 0;
    let mut x137: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x136, &mut x137, x135, x120, (0x0 as u64));
    let mut x138: u64 = 0;
    let mut x139: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x138, &mut x139, x137, x122, (0x0 as u64));
    let mut x140: u64 = 0;
    let mut x141: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x140, &mut x141, x139, x124, (0x0 as u64));
    let mut x142: u64 = 0;
    let mut x143: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x142, &mut x143, x126, 0x1d2f5ccd79a995c7);
    let mut x144: u64 = 0;
    let mut x145: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x144, &mut x145, x142, 0x1ff);
    let mut x146: u64 = 0;
    let mut x147: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x146, &mut x147, x142, 0xffffffffffffffff);
    let mut x148: u64 = 0;
    let mut x149: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x148, &mut x149, x142, 0xffffffffffffffff);
    let mut x150: u64 = 0;
    let mut x151: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x150, &mut x151, x142, 0xffffffffffffffff);
    let mut x152: u64 = 0;
    let mut x153: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x152, &mut x153, x142, 0xfffffffffffffffa);
    let mut x154: u64 = 0;
    let mut x155: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x154, &mut x155, x142, 0x51868783bf2f966b);
    let mut x156: u64 = 0;
    let mut x157: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x156, &mut x157, x142, 0x7fcc0148f709a5d0);
    let mut x158: u64 = 0;
    let mut x159: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x158, &mut x159, x142, 0x3bb5c9b8899c47ae);
    let mut x160: u64 = 0;
    let mut x161: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x160, &mut x161, x142, 0xbb6fb71e91386409);
    let mut x162: u64 = 0;
    let mut x163: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x162, &mut x163, 0x0, x161, x158);
    let mut x164: u64 = 0;
    let mut x165: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x164, &mut x165, x163, x159, x156);
    let mut x166: u64 = 0;
    let mut x167: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x166, &mut x167, x165, x157, x154);
    let mut x168: u64 = 0;
    let mut x169: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x168, &mut x169, x167, x155, x152);
    let mut x170: u64 = 0;
    let mut x171: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x170, &mut x171, x169, x153, x150);
    let mut x172: u64 = 0;
    let mut x173: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x172, &mut x173, x171, x151, x148);
    let mut x174: u64 = 0;
    let mut x175: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x174, &mut x175, x173, x149, x146);
    let mut x176: u64 = 0;
    let mut x177: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x176, &mut x177, x175, x147, x144);
    let mut x178: u64 = 0;
    let mut x179: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x178, &mut x179, 0x0, x126, x160);
    let mut x180: u64 = 0;
    let mut x181: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x180, &mut x181, x179, x128, x162);
    let mut x182: u64 = 0;
    let mut x183: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x182, &mut x183, x181, x130, x164);
    let mut x184: u64 = 0;
    let mut x185: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x184, &mut x185, x183, x132, x166);
    let mut x186: u64 = 0;
    let mut x187: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x186, &mut x187, x185, x134, x168);
    let mut x188: u64 = 0;
    let mut x189: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x188, &mut x189, x187, x136, x170);
    let mut x190: u64 = 0;
    let mut x191: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x190, &mut x191, x189, x138, x172);
    let mut x192: u64 = 0;
    let mut x193: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x192, &mut x193, x191, x140, x174);
    let mut x194: u64 = 0;
    let mut x195: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x194,
        &mut x195,
        x193,
        ((x141 as u64) + ((x125 as u64) + ((x107 as u64) + x75))),
        x176,
    );
    let mut x196: u64 = 0;
    let mut x197: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x196,
        &mut x197,
        0x0,
        x180,
        (*IndexConst(arg1).index(3)),
    );
    let mut x198: u64 = 0;
    let mut x199: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x198, &mut x199, x197, x182, (0x0 as u64));
    let mut x200: u64 = 0;
    let mut x201: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x200, &mut x201, x199, x184, (0x0 as u64));
    let mut x202: u64 = 0;
    let mut x203: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x202, &mut x203, x201, x186, (0x0 as u64));
    let mut x204: u64 = 0;
    let mut x205: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x204, &mut x205, x203, x188, (0x0 as u64));
    let mut x206: u64 = 0;
    let mut x207: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x206, &mut x207, x205, x190, (0x0 as u64));
    let mut x208: u64 = 0;
    let mut x209: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x208, &mut x209, x207, x192, (0x0 as u64));
    let mut x210: u64 = 0;
    let mut x211: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x210, &mut x211, x209, x194, (0x0 as u64));
    let mut x212: u64 = 0;
    let mut x213: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x212, &mut x213, x196, 0x1d2f5ccd79a995c7);
    let mut x214: u64 = 0;
    let mut x215: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x214, &mut x215, x212, 0x1ff);
    let mut x216: u64 = 0;
    let mut x217: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x216, &mut x217, x212, 0xffffffffffffffff);
    let mut x218: u64 = 0;
    let mut x219: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x218, &mut x219, x212, 0xffffffffffffffff);
    let mut x220: u64 = 0;
    let mut x221: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x220, &mut x221, x212, 0xffffffffffffffff);
    let mut x222: u64 = 0;
    let mut x223: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x222, &mut x223, x212, 0xfffffffffffffffa);
    let mut x224: u64 = 0;
    let mut x225: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x224, &mut x225, x212, 0x51868783bf2f966b);
    let mut x226: u64 = 0;
    let mut x227: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x226, &mut x227, x212, 0x7fcc0148f709a5d0);
    let mut x228: u64 = 0;
    let mut x229: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x228, &mut x229, x212, 0x3bb5c9b8899c47ae);
    let mut x230: u64 = 0;
    let mut x231: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x230, &mut x231, x212, 0xbb6fb71e91386409);
    let mut x232: u64 = 0;
    let mut x233: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x232, &mut x233, 0x0, x231, x228);
    let mut x234: u64 = 0;
    let mut x235: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x234, &mut x235, x233, x229, x226);
    let mut x236: u64 = 0;
    let mut x237: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x236, &mut x237, x235, x227, x224);
    let mut x238: u64 = 0;
    let mut x239: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x238, &mut x239, x237, x225, x222);
    let mut x240: u64 = 0;
    let mut x241: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x240, &mut x241, x239, x223, x220);
    let mut x242: u64 = 0;
    let mut x243: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x242, &mut x243, x241, x221, x218);
    let mut x244: u64 = 0;
    let mut x245: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x244, &mut x245, x243, x219, x216);
    let mut x246: u64 = 0;
    let mut x247: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x246, &mut x247, x245, x217, x214);
    let mut x248: u64 = 0;
    let mut x249: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x248, &mut x249, 0x0, x196, x230);
    let mut x250: u64 = 0;
    let mut x251: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x250, &mut x251, x249, x198, x232);
    let mut x252: u64 = 0;
    let mut x253: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x252, &mut x253, x251, x200, x234);
    let mut x254: u64 = 0;
    let mut x255: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x254, &mut x255, x253, x202, x236);
    let mut x256: u64 = 0;
    let mut x257: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x256, &mut x257, x255, x204, x238);
    let mut x258: u64 = 0;
    let mut x259: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x258, &mut x259, x257, x206, x240);
    let mut x260: u64 = 0;
    let mut x261: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x260, &mut x261, x259, x208, x242);
    let mut x262: u64 = 0;
    let mut x263: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x262, &mut x263, x261, x210, x244);
    let mut x264: u64 = 0;
    let mut x265: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x264,
        &mut x265,
        x263,
        ((x211 as u64) + ((x195 as u64) + ((x177 as u64) + x145))),
        x246,
    );
    let mut x266: u64 = 0;
    let mut x267: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x266,
        &mut x267,
        0x0,
        x250,
        (*IndexConst(arg1).index(4)),
    );
    let mut x268: u64 = 0;
    let mut x269: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x268, &mut x269, x267, x252, (0x0 as u64));
    let mut x270: u64 = 0;
    let mut x271: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x270, &mut x271, x269, x254, (0x0 as u64));
    let mut x272: u64 = 0;
    let mut x273: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x272, &mut x273, x271, x256, (0x0 as u64));
    let mut x274: u64 = 0;
    let mut x275: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x274, &mut x275, x273, x258, (0x0 as u64));
    let mut x276: u64 = 0;
    let mut x277: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x276, &mut x277, x275, x260, (0x0 as u64));
    let mut x278: u64 = 0;
    let mut x279: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x278, &mut x279, x277, x262, (0x0 as u64));
    let mut x280: u64 = 0;
    let mut x281: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x280, &mut x281, x279, x264, (0x0 as u64));
    let mut x282: u64 = 0;
    let mut x283: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x282, &mut x283, x266, 0x1d2f5ccd79a995c7);
    let mut x284: u64 = 0;
    let mut x285: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x284, &mut x285, x282, 0x1ff);
    let mut x286: u64 = 0;
    let mut x287: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x286, &mut x287, x282, 0xffffffffffffffff);
    let mut x288: u64 = 0;
    let mut x289: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x288, &mut x289, x282, 0xffffffffffffffff);
    let mut x290: u64 = 0;
    let mut x291: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x290, &mut x291, x282, 0xffffffffffffffff);
    let mut x292: u64 = 0;
    let mut x293: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x292, &mut x293, x282, 0xfffffffffffffffa);
    let mut x294: u64 = 0;
    let mut x295: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x294, &mut x295, x282, 0x51868783bf2f966b);
    let mut x296: u64 = 0;
    let mut x297: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x296, &mut x297, x282, 0x7fcc0148f709a5d0);
    let mut x298: u64 = 0;
    let mut x299: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x298, &mut x299, x282, 0x3bb5c9b8899c47ae);
    let mut x300: u64 = 0;
    let mut x301: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x300, &mut x301, x282, 0xbb6fb71e91386409);
    let mut x302: u64 = 0;
    let mut x303: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x302, &mut x303, 0x0, x301, x298);
    let mut x304: u64 = 0;
    let mut x305: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x304, &mut x305, x303, x299, x296);
    let mut x306: u64 = 0;
    let mut x307: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x306, &mut x307, x305, x297, x294);
    let mut x308: u64 = 0;
    let mut x309: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x308, &mut x309, x307, x295, x292);
    let mut x310: u64 = 0;
    let mut x311: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x310, &mut x311, x309, x293, x290);
    let mut x312: u64 = 0;
    let mut x313: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x312, &mut x313, x311, x291, x288);
    let mut x314: u64 = 0;
    let mut x315: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x314, &mut x315, x313, x289, x286);
    let mut x316: u64 = 0;
    let mut x317: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x316, &mut x317, x315, x287, x284);
    let mut x318: u64 = 0;
    let mut x319: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x318, &mut x319, 0x0, x266, x300);
    let mut x320: u64 = 0;
    let mut x321: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x320, &mut x321, x319, x268, x302);
    let mut x322: u64 = 0;
    let mut x323: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x322, &mut x323, x321, x270, x304);
    let mut x324: u64 = 0;
    let mut x325: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x324, &mut x325, x323, x272, x306);
    let mut x326: u64 = 0;
    let mut x327: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x326, &mut x327, x325, x274, x308);
    let mut x328: u64 = 0;
    let mut x329: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x328, &mut x329, x327, x276, x310);
    let mut x330: u64 = 0;
    let mut x331: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x330, &mut x331, x329, x278, x312);
    let mut x332: u64 = 0;
    let mut x333: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x332, &mut x333, x331, x280, x314);
    let mut x334: u64 = 0;
    let mut x335: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x334,
        &mut x335,
        x333,
        ((x281 as u64) + ((x265 as u64) + ((x247 as u64) + x215))),
        x316,
    );
    let mut x336: u64 = 0;
    let mut x337: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x336,
        &mut x337,
        0x0,
        x320,
        (*IndexConst(arg1).index(5)),
    );
    let mut x338: u64 = 0;
    let mut x339: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x338, &mut x339, x337, x322, (0x0 as u64));
    let mut x340: u64 = 0;
    let mut x341: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x340, &mut x341, x339, x324, (0x0 as u64));
    let mut x342: u64 = 0;
    let mut x343: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x342, &mut x343, x341, x326, (0x0 as u64));
    let mut x344: u64 = 0;
    let mut x345: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x344, &mut x345, x343, x328, (0x0 as u64));
    let mut x346: u64 = 0;
    let mut x347: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x346, &mut x347, x345, x330, (0x0 as u64));
    let mut x348: u64 = 0;
    let mut x349: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x348, &mut x349, x347, x332, (0x0 as u64));
    let mut x350: u64 = 0;
    let mut x351: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x350, &mut x351, x349, x334, (0x0 as u64));
    let mut x352: u64 = 0;
    let mut x353: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x352, &mut x353, x336, 0x1d2f5ccd79a995c7);
    let mut x354: u64 = 0;
    let mut x355: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x354, &mut x355, x352, 0x1ff);
    let mut x356: u64 = 0;
    let mut x357: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x356, &mut x357, x352, 0xffffffffffffffff);
    let mut x358: u64 = 0;
    let mut x359: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x358, &mut x359, x352, 0xffffffffffffffff);
    let mut x360: u64 = 0;
    let mut x361: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x360, &mut x361, x352, 0xffffffffffffffff);
    let mut x362: u64 = 0;
    let mut x363: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x362, &mut x363, x352, 0xfffffffffffffffa);
    let mut x364: u64 = 0;
    let mut x365: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x364, &mut x365, x352, 0x51868783bf2f966b);
    let mut x366: u64 = 0;
    let mut x367: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x366, &mut x367, x352, 0x7fcc0148f709a5d0);
    let mut x368: u64 = 0;
    let mut x369: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x368, &mut x369, x352, 0x3bb5c9b8899c47ae);
    let mut x370: u64 = 0;
    let mut x371: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x370, &mut x371, x352, 0xbb6fb71e91386409);
    let mut x372: u64 = 0;
    let mut x373: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x372, &mut x373, 0x0, x371, x368);
    let mut x374: u64 = 0;
    let mut x375: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x374, &mut x375, x373, x369, x366);
    let mut x376: u64 = 0;
    let mut x377: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x376, &mut x377, x375, x367, x364);
    let mut x378: u64 = 0;
    let mut x379: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x378, &mut x379, x377, x365, x362);
    let mut x380: u64 = 0;
    let mut x381: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x380, &mut x381, x379, x363, x360);
    let mut x382: u64 = 0;
    let mut x383: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x382, &mut x383, x381, x361, x358);
    let mut x384: u64 = 0;
    let mut x385: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x384, &mut x385, x383, x359, x356);
    let mut x386: u64 = 0;
    let mut x387: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x386, &mut x387, x385, x357, x354);
    let mut x388: u64 = 0;
    let mut x389: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x388, &mut x389, 0x0, x336, x370);
    let mut x390: u64 = 0;
    let mut x391: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x390, &mut x391, x389, x338, x372);
    let mut x392: u64 = 0;
    let mut x393: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x392, &mut x393, x391, x340, x374);
    let mut x394: u64 = 0;
    let mut x395: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x394, &mut x395, x393, x342, x376);
    let mut x396: u64 = 0;
    let mut x397: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x396, &mut x397, x395, x344, x378);
    let mut x398: u64 = 0;
    let mut x399: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x398, &mut x399, x397, x346, x380);
    let mut x400: u64 = 0;
    let mut x401: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x400, &mut x401, x399, x348, x382);
    let mut x402: u64 = 0;
    let mut x403: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x402, &mut x403, x401, x350, x384);
    let mut x404: u64 = 0;
    let mut x405: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x404,
        &mut x405,
        x403,
        ((x351 as u64) + ((x335 as u64) + ((x317 as u64) + x285))),
        x386,
    );
    let mut x406: u64 = 0;
    let mut x407: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x406,
        &mut x407,
        0x0,
        x390,
        (*IndexConst(arg1).index(6)),
    );
    let mut x408: u64 = 0;
    let mut x409: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x408, &mut x409, x407, x392, (0x0 as u64));
    let mut x410: u64 = 0;
    let mut x411: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x410, &mut x411, x409, x394, (0x0 as u64));
    let mut x412: u64 = 0;
    let mut x413: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x412, &mut x413, x411, x396, (0x0 as u64));
    let mut x414: u64 = 0;
    let mut x415: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x414, &mut x415, x413, x398, (0x0 as u64));
    let mut x416: u64 = 0;
    let mut x417: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x416, &mut x417, x415, x400, (0x0 as u64));
    let mut x418: u64 = 0;
    let mut x419: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x418, &mut x419, x417, x402, (0x0 as u64));
    let mut x420: u64 = 0;
    let mut x421: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x420, &mut x421, x419, x404, (0x0 as u64));
    let mut x422: u64 = 0;
    let mut x423: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x422, &mut x423, x406, 0x1d2f5ccd79a995c7);
    let mut x424: u64 = 0;
    let mut x425: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x424, &mut x425, x422, 0x1ff);
    let mut x426: u64 = 0;
    let mut x427: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x426, &mut x427, x422, 0xffffffffffffffff);
    let mut x428: u64 = 0;
    let mut x429: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x428, &mut x429, x422, 0xffffffffffffffff);
    let mut x430: u64 = 0;
    let mut x431: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x430, &mut x431, x422, 0xffffffffffffffff);
    let mut x432: u64 = 0;
    let mut x433: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x432, &mut x433, x422, 0xfffffffffffffffa);
    let mut x434: u64 = 0;
    let mut x435: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x434, &mut x435, x422, 0x51868783bf2f966b);
    let mut x436: u64 = 0;
    let mut x437: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x436, &mut x437, x422, 0x7fcc0148f709a5d0);
    let mut x438: u64 = 0;
    let mut x439: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x438, &mut x439, x422, 0x3bb5c9b8899c47ae);
    let mut x440: u64 = 0;
    let mut x441: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x440, &mut x441, x422, 0xbb6fb71e91386409);
    let mut x442: u64 = 0;
    let mut x443: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x442, &mut x443, 0x0, x441, x438);
    let mut x444: u64 = 0;
    let mut x445: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x444, &mut x445, x443, x439, x436);
    let mut x446: u64 = 0;
    let mut x447: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x446, &mut x447, x445, x437, x434);
    let mut x448: u64 = 0;
    let mut x449: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x448, &mut x449, x447, x435, x432);
    let mut x450: u64 = 0;
    let mut x451: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x450, &mut x451, x449, x433, x430);
    let mut x452: u64 = 0;
    let mut x453: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x452, &mut x453, x451, x431, x428);
    let mut x454: u64 = 0;
    let mut x455: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x454, &mut x455, x453, x429, x426);
    let mut x456: u64 = 0;
    let mut x457: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x456, &mut x457, x455, x427, x424);
    let mut x458: u64 = 0;
    let mut x459: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x458, &mut x459, 0x0, x406, x440);
    let mut x460: u64 = 0;
    let mut x461: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x460, &mut x461, x459, x408, x442);
    let mut x462: u64 = 0;
    let mut x463: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x462, &mut x463, x461, x410, x444);
    let mut x464: u64 = 0;
    let mut x465: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x464, &mut x465, x463, x412, x446);
    let mut x466: u64 = 0;
    let mut x467: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x466, &mut x467, x465, x414, x448);
    let mut x468: u64 = 0;
    let mut x469: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x468, &mut x469, x467, x416, x450);
    let mut x470: u64 = 0;
    let mut x471: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x470, &mut x471, x469, x418, x452);
    let mut x472: u64 = 0;
    let mut x473: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x472, &mut x473, x471, x420, x454);
    let mut x474: u64 = 0;
    let mut x475: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x474,
        &mut x475,
        x473,
        ((x421 as u64) + ((x405 as u64) + ((x387 as u64) + x355))),
        x456,
    );
    let mut x476: u64 = 0;
    let mut x477: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x476,
        &mut x477,
        0x0,
        x460,
        (*IndexConst(arg1).index(7)),
    );
    let mut x478: u64 = 0;
    let mut x479: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x478, &mut x479, x477, x462, (0x0 as u64));
    let mut x480: u64 = 0;
    let mut x481: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x480, &mut x481, x479, x464, (0x0 as u64));
    let mut x482: u64 = 0;
    let mut x483: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x482, &mut x483, x481, x466, (0x0 as u64));
    let mut x484: u64 = 0;
    let mut x485: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x484, &mut x485, x483, x468, (0x0 as u64));
    let mut x486: u64 = 0;
    let mut x487: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x486, &mut x487, x485, x470, (0x0 as u64));
    let mut x488: u64 = 0;
    let mut x489: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x488, &mut x489, x487, x472, (0x0 as u64));
    let mut x490: u64 = 0;
    let mut x491: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x490, &mut x491, x489, x474, (0x0 as u64));
    let mut x492: u64 = 0;
    let mut x493: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x492, &mut x493, x476, 0x1d2f5ccd79a995c7);
    let mut x494: u64 = 0;
    let mut x495: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x494, &mut x495, x492, 0x1ff);
    let mut x496: u64 = 0;
    let mut x497: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x496, &mut x497, x492, 0xffffffffffffffff);
    let mut x498: u64 = 0;
    let mut x499: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x498, &mut x499, x492, 0xffffffffffffffff);
    let mut x500: u64 = 0;
    let mut x501: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x500, &mut x501, x492, 0xffffffffffffffff);
    let mut x502: u64 = 0;
    let mut x503: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x502, &mut x503, x492, 0xfffffffffffffffa);
    let mut x504: u64 = 0;
    let mut x505: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x504, &mut x505, x492, 0x51868783bf2f966b);
    let mut x506: u64 = 0;
    let mut x507: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x506, &mut x507, x492, 0x7fcc0148f709a5d0);
    let mut x508: u64 = 0;
    let mut x509: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x508, &mut x509, x492, 0x3bb5c9b8899c47ae);
    let mut x510: u64 = 0;
    let mut x511: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x510, &mut x511, x492, 0xbb6fb71e91386409);
    let mut x512: u64 = 0;
    let mut x513: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x512, &mut x513, 0x0, x511, x508);
    let mut x514: u64 = 0;
    let mut x515: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x514, &mut x515, x513, x509, x506);
    let mut x516: u64 = 0;
    let mut x517: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x516, &mut x517, x515, x507, x504);
    let mut x518: u64 = 0;
    let mut x519: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x518, &mut x519, x517, x505, x502);
    let mut x520: u64 = 0;
    let mut x521: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x520, &mut x521, x519, x503, x500);
    let mut x522: u64 = 0;
    let mut x523: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x522, &mut x523, x521, x501, x498);
    let mut x524: u64 = 0;
    let mut x525: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x524, &mut x525, x523, x499, x496);
    let mut x526: u64 = 0;
    let mut x527: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x526, &mut x527, x525, x497, x494);
    let mut x528: u64 = 0;
    let mut x529: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x528, &mut x529, 0x0, x476, x510);
    let mut x530: u64 = 0;
    let mut x531: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x530, &mut x531, x529, x478, x512);
    let mut x532: u64 = 0;
    let mut x533: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x532, &mut x533, x531, x480, x514);
    let mut x534: u64 = 0;
    let mut x535: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x534, &mut x535, x533, x482, x516);
    let mut x536: u64 = 0;
    let mut x537: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x536, &mut x537, x535, x484, x518);
    let mut x538: u64 = 0;
    let mut x539: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x538, &mut x539, x537, x486, x520);
    let mut x540: u64 = 0;
    let mut x541: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x540, &mut x541, x539, x488, x522);
    let mut x542: u64 = 0;
    let mut x543: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x542, &mut x543, x541, x490, x524);
    let mut x544: u64 = 0;
    let mut x545: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x544,
        &mut x545,
        x543,
        ((x491 as u64) + ((x475 as u64) + ((x457 as u64) + x425))),
        x526,
    );
    let mut x546: u64 = 0;
    let mut x547: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x546,
        &mut x547,
        0x0,
        x530,
        (*IndexConst(arg1).index(8)),
    );
    let mut x548: u64 = 0;
    let mut x549: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x548, &mut x549, x547, x532, (0x0 as u64));
    let mut x550: u64 = 0;
    let mut x551: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x550, &mut x551, x549, x534, (0x0 as u64));
    let mut x552: u64 = 0;
    let mut x553: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x552, &mut x553, x551, x536, (0x0 as u64));
    let mut x554: u64 = 0;
    let mut x555: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x554, &mut x555, x553, x538, (0x0 as u64));
    let mut x556: u64 = 0;
    let mut x557: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x556, &mut x557, x555, x540, (0x0 as u64));
    let mut x558: u64 = 0;
    let mut x559: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x558, &mut x559, x557, x542, (0x0 as u64));
    let mut x560: u64 = 0;
    let mut x561: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x560, &mut x561, x559, x544, (0x0 as u64));
    let mut x562: u64 = 0;
    let mut x563: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x562, &mut x563, x546, 0x1d2f5ccd79a995c7);
    let mut x564: u64 = 0;
    let mut x565: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x564, &mut x565, x562, 0x1ff);
    let mut x566: u64 = 0;
    let mut x567: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x566, &mut x567, x562, 0xffffffffffffffff);
    let mut x568: u64 = 0;
    let mut x569: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x568, &mut x569, x562, 0xffffffffffffffff);
    let mut x570: u64 = 0;
    let mut x571: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x570, &mut x571, x562, 0xffffffffffffffff);
    let mut x572: u64 = 0;
    let mut x573: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x572, &mut x573, x562, 0xfffffffffffffffa);
    let mut x574: u64 = 0;
    let mut x575: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x574, &mut x575, x562, 0x51868783bf2f966b);
    let mut x576: u64 = 0;
    let mut x577: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x576, &mut x577, x562, 0x7fcc0148f709a5d0);
    let mut x578: u64 = 0;
    let mut x579: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x578, &mut x579, x562, 0x3bb5c9b8899c47ae);
    let mut x580: u64 = 0;
    let mut x581: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x580, &mut x581, x562, 0xbb6fb71e91386409);
    let mut x582: u64 = 0;
    let mut x583: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x582, &mut x583, 0x0, x581, x578);
    let mut x584: u64 = 0;
    let mut x585: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x584, &mut x585, x583, x579, x576);
    let mut x586: u64 = 0;
    let mut x587: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x586, &mut x587, x585, x577, x574);
    let mut x588: u64 = 0;
    let mut x589: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x588, &mut x589, x587, x575, x572);
    let mut x590: u64 = 0;
    let mut x591: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x590, &mut x591, x589, x573, x570);
    let mut x592: u64 = 0;
    let mut x593: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x592, &mut x593, x591, x571, x568);
    let mut x594: u64 = 0;
    let mut x595: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x594, &mut x595, x593, x569, x566);
    let mut x596: u64 = 0;
    let mut x597: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x596, &mut x597, x595, x567, x564);
    let mut x598: u64 = 0;
    let mut x599: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x598, &mut x599, 0x0, x546, x580);
    let mut x600: u64 = 0;
    let mut x601: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x600, &mut x601, x599, x548, x582);
    let mut x602: u64 = 0;
    let mut x603: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x602, &mut x603, x601, x550, x584);
    let mut x604: u64 = 0;
    let mut x605: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x604, &mut x605, x603, x552, x586);
    let mut x606: u64 = 0;
    let mut x607: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x606, &mut x607, x605, x554, x588);
    let mut x608: u64 = 0;
    let mut x609: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x608, &mut x609, x607, x556, x590);
    let mut x610: u64 = 0;
    let mut x611: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x610, &mut x611, x609, x558, x592);
    let mut x612: u64 = 0;
    let mut x613: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x612, &mut x613, x611, x560, x594);
    let mut x614: u64 = 0;
    let mut x615: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x614,
        &mut x615,
        x613,
        ((x561 as u64) + ((x545 as u64) + ((x527 as u64) + x495))),
        x596,
    );
    let x616: u64 = ((x615 as u64) + ((x597 as u64) + x565));
    let mut x617: u64 = 0;
    let mut x618: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x617, &mut x618, 0x0, x600, 0xbb6fb71e91386409);
    let mut x619: u64 = 0;
    let mut x620: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x619, &mut x620, x618, x602, 0x3bb5c9b8899c47ae);
    let mut x621: u64 = 0;
    let mut x622: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x621, &mut x622, x620, x604, 0x7fcc0148f709a5d0);
    let mut x623: u64 = 0;
    let mut x624: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x623, &mut x624, x622, x606, 0x51868783bf2f966b);
    let mut x625: u64 = 0;
    let mut x626: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x625, &mut x626, x624, x608, 0xfffffffffffffffa);
    let mut x627: u64 = 0;
    let mut x628: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x627, &mut x628, x626, x610, 0xffffffffffffffff);
    let mut x629: u64 = 0;
    let mut x630: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x629, &mut x630, x628, x612, 0xffffffffffffffff);
    let mut x631: u64 = 0;
    let mut x632: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x631, &mut x632, x630, x614, 0xffffffffffffffff);
    let mut x633: u64 = 0;
    let mut x634: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x633, &mut x634, x632, x616, 0x1ff);
    let mut x635: u64 = 0;
    let mut x636: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x635, &mut x636, x634, (0x0 as u64), (0x0 as u64));
    let mut x637: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x637, x636, x617, x600);
    let mut x638: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x638, x636, x619, x602);
    let mut x639: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x639, x636, x621, x604);
    let mut x640: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x640, x636, x623, x606);
    let mut x641: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x641, x636, x625, x608);
    let mut x642: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x642, x636, x627, x610);
    let mut x643: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x643, x636, x629, x612);
    let mut x644: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x644, x636, x631, x614);
    let mut x645: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x645, x636, x633, x616);
    *IndexConst(&mut out1).index_mut(0) = x637;
    *IndexConst(&mut out1).index_mut(1) = x638;
    *IndexConst(&mut out1).index_mut(2) = x639;
    *IndexConst(&mut out1).index_mut(3) = x640;
    *IndexConst(&mut out1).index_mut(4) = x641;
    *IndexConst(&mut out1).index_mut(5) = x642;
    *IndexConst(&mut out1).index_mut(6) = x643;
    *IndexConst(&mut out1).index_mut(7) = x644;
    *IndexConst(&mut out1).index_mut(8) = x645;
}

/// The function fiat_p521_scalar_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_p521_scalar_to_montgomery(
    mut out1: &mut fiat_p521_scalar_montgomery_domain_field_element,
    arg1: &fiat_p521_scalar_non_montgomery_domain_field_element,
) {
    let x1: u64 = (*IndexConst(arg1).index(1));
    let x2: u64 = (*IndexConst(arg1).index(2));
    let x3: u64 = (*IndexConst(arg1).index(3));
    let x4: u64 = (*IndexConst(arg1).index(4));
    let x5: u64 = (*IndexConst(arg1).index(5));
    let x6: u64 = (*IndexConst(arg1).index(6));
    let x7: u64 = (*IndexConst(arg1).index(7));
    let x8: u64 = (*IndexConst(arg1).index(8));
    let x9: u64 = (*IndexConst(arg1).index(0));
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x10, &mut x11, x9, 0x3d);
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x12, &mut x13, x9, 0x2d8e03d1492d0d45);
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x14, &mut x15, x9, 0x5bcc6d61a8e567bc);
    let mut x16: u64 = 0;
    let mut x17: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x16, &mut x17, x9, 0xcff3d142b7756e3e);
    let mut x18: u64 = 0;
    let mut x19: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x18, &mut x19, x9, 0xdd6e23d82e49c7db);
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x20, &mut x21, x9, 0xd3721ef557f75e06);
    let mut x22: u64 = 0;
    let mut x23: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x22, &mut x23, x9, 0x12a78d38794573ff);
    let mut x24: u64 = 0;
    let mut x25: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x24, &mut x25, x9, 0xf707badce5547ea3);
    let mut x26: u64 = 0;
    let mut x27: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x26, &mut x27, x9, 0x137cd04dcf15dd04);
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x28, &mut x29, 0x0, x27, x24);
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x30, &mut x31, x29, x25, x22);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x32, &mut x33, x31, x23, x20);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x34, &mut x35, x33, x21, x18);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x36, &mut x37, x35, x19, x16);
    let mut x38: u64 = 0;
    let mut x39: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x38, &mut x39, x37, x17, x14);
    let mut x40: u64 = 0;
    let mut x41: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x40, &mut x41, x39, x15, x12);
    let mut x42: u64 = 0;
    let mut x43: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x42, &mut x43, x41, x13, x10);
    let mut x44: u64 = 0;
    let mut x45: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x44, &mut x45, x26, 0x1d2f5ccd79a995c7);
    let mut x46: u64 = 0;
    let mut x47: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x46, &mut x47, x44, 0x1ff);
    let mut x48: u64 = 0;
    let mut x49: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x48, &mut x49, x44, 0xffffffffffffffff);
    let mut x50: u64 = 0;
    let mut x51: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x50, &mut x51, x44, 0xffffffffffffffff);
    let mut x52: u64 = 0;
    let mut x53: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x52, &mut x53, x44, 0xffffffffffffffff);
    let mut x54: u64 = 0;
    let mut x55: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x54, &mut x55, x44, 0xfffffffffffffffa);
    let mut x56: u64 = 0;
    let mut x57: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x56, &mut x57, x44, 0x51868783bf2f966b);
    let mut x58: u64 = 0;
    let mut x59: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x58, &mut x59, x44, 0x7fcc0148f709a5d0);
    let mut x60: u64 = 0;
    let mut x61: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x60, &mut x61, x44, 0x3bb5c9b8899c47ae);
    let mut x62: u64 = 0;
    let mut x63: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x62, &mut x63, x44, 0xbb6fb71e91386409);
    let mut x64: u64 = 0;
    let mut x65: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x64, &mut x65, 0x0, x63, x60);
    let mut x66: u64 = 0;
    let mut x67: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x66, &mut x67, x65, x61, x58);
    let mut x68: u64 = 0;
    let mut x69: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x68, &mut x69, x67, x59, x56);
    let mut x70: u64 = 0;
    let mut x71: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x70, &mut x71, x69, x57, x54);
    let mut x72: u64 = 0;
    let mut x73: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x72, &mut x73, x71, x55, x52);
    let mut x74: u64 = 0;
    let mut x75: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x74, &mut x75, x73, x53, x50);
    let mut x76: u64 = 0;
    let mut x77: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x76, &mut x77, x75, x51, x48);
    let mut x78: u64 = 0;
    let mut x79: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x78, &mut x79, x77, x49, x46);
    let mut x80: u64 = 0;
    let mut x81: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x80, &mut x81, 0x0, x26, x62);
    let mut x82: u64 = 0;
    let mut x83: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x82, &mut x83, x81, x28, x64);
    let mut x84: u64 = 0;
    let mut x85: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x84, &mut x85, x83, x30, x66);
    let mut x86: u64 = 0;
    let mut x87: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x86, &mut x87, x85, x32, x68);
    let mut x88: u64 = 0;
    let mut x89: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x88, &mut x89, x87, x34, x70);
    let mut x90: u64 = 0;
    let mut x91: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x90, &mut x91, x89, x36, x72);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x92, &mut x93, x91, x38, x74);
    let mut x94: u64 = 0;
    let mut x95: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x94, &mut x95, x93, x40, x76);
    let mut x96: u64 = 0;
    let mut x97: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x42, x78);
    let mut x98: u64 = 0;
    let mut x99: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x98, &mut x99, x1, 0x3d);
    let mut x100: u64 = 0;
    let mut x101: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x100, &mut x101, x1, 0x2d8e03d1492d0d45);
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x102, &mut x103, x1, 0x5bcc6d61a8e567bc);
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x104, &mut x105, x1, 0xcff3d142b7756e3e);
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x106, &mut x107, x1, 0xdd6e23d82e49c7db);
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x108, &mut x109, x1, 0xd3721ef557f75e06);
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x110, &mut x111, x1, 0x12a78d38794573ff);
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x112, &mut x113, x1, 0xf707badce5547ea3);
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x114, &mut x115, x1, 0x137cd04dcf15dd04);
    let mut x116: u64 = 0;
    let mut x117: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x116, &mut x117, 0x0, x115, x112);
    let mut x118: u64 = 0;
    let mut x119: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x118, &mut x119, x117, x113, x110);
    let mut x120: u64 = 0;
    let mut x121: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x120, &mut x121, x119, x111, x108);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x122, &mut x123, x121, x109, x106);
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x124, &mut x125, x123, x107, x104);
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x126, &mut x127, x125, x105, x102);
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x103, x100);
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x130, &mut x131, x129, x101, x98);
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x132, &mut x133, 0x0, x82, x114);
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x134, &mut x135, x133, x84, x116);
    let mut x136: u64 = 0;
    let mut x137: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x136, &mut x137, x135, x86, x118);
    let mut x138: u64 = 0;
    let mut x139: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x138, &mut x139, x137, x88, x120);
    let mut x140: u64 = 0;
    let mut x141: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x140, &mut x141, x139, x90, x122);
    let mut x142: u64 = 0;
    let mut x143: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x142, &mut x143, x141, x92, x124);
    let mut x144: u64 = 0;
    let mut x145: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x144, &mut x145, x143, x94, x126);
    let mut x146: u64 = 0;
    let mut x147: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x146, &mut x147, x145, x96, x128);
    let mut x148: u64 = 0;
    let mut x149: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x148,
        &mut x149,
        x147,
        (((x97 as u64) + ((x43 as u64) + x11)) + ((x79 as u64) + x47)),
        x130,
    );
    let mut x150: u64 = 0;
    let mut x151: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x150, &mut x151, x132, 0x1d2f5ccd79a995c7);
    let mut x152: u64 = 0;
    let mut x153: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x152, &mut x153, x150, 0x1ff);
    let mut x154: u64 = 0;
    let mut x155: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x154, &mut x155, x150, 0xffffffffffffffff);
    let mut x156: u64 = 0;
    let mut x157: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x156, &mut x157, x150, 0xffffffffffffffff);
    let mut x158: u64 = 0;
    let mut x159: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x158, &mut x159, x150, 0xffffffffffffffff);
    let mut x160: u64 = 0;
    let mut x161: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x160, &mut x161, x150, 0xfffffffffffffffa);
    let mut x162: u64 = 0;
    let mut x163: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x162, &mut x163, x150, 0x51868783bf2f966b);
    let mut x164: u64 = 0;
    let mut x165: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x164, &mut x165, x150, 0x7fcc0148f709a5d0);
    let mut x166: u64 = 0;
    let mut x167: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x166, &mut x167, x150, 0x3bb5c9b8899c47ae);
    let mut x168: u64 = 0;
    let mut x169: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x168, &mut x169, x150, 0xbb6fb71e91386409);
    let mut x170: u64 = 0;
    let mut x171: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x170, &mut x171, 0x0, x169, x166);
    let mut x172: u64 = 0;
    let mut x173: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x172, &mut x173, x171, x167, x164);
    let mut x174: u64 = 0;
    let mut x175: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x174, &mut x175, x173, x165, x162);
    let mut x176: u64 = 0;
    let mut x177: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x176, &mut x177, x175, x163, x160);
    let mut x178: u64 = 0;
    let mut x179: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x178, &mut x179, x177, x161, x158);
    let mut x180: u64 = 0;
    let mut x181: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x180, &mut x181, x179, x159, x156);
    let mut x182: u64 = 0;
    let mut x183: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x182, &mut x183, x181, x157, x154);
    let mut x184: u64 = 0;
    let mut x185: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x184, &mut x185, x183, x155, x152);
    let mut x186: u64 = 0;
    let mut x187: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x186, &mut x187, 0x0, x132, x168);
    let mut x188: u64 = 0;
    let mut x189: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x188, &mut x189, x187, x134, x170);
    let mut x190: u64 = 0;
    let mut x191: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x190, &mut x191, x189, x136, x172);
    let mut x192: u64 = 0;
    let mut x193: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x192, &mut x193, x191, x138, x174);
    let mut x194: u64 = 0;
    let mut x195: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x194, &mut x195, x193, x140, x176);
    let mut x196: u64 = 0;
    let mut x197: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x196, &mut x197, x195, x142, x178);
    let mut x198: u64 = 0;
    let mut x199: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x198, &mut x199, x197, x144, x180);
    let mut x200: u64 = 0;
    let mut x201: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x200, &mut x201, x199, x146, x182);
    let mut x202: u64 = 0;
    let mut x203: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x202, &mut x203, x201, x148, x184);
    let mut x204: u64 = 0;
    let mut x205: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x204, &mut x205, x2, 0x3d);
    let mut x206: u64 = 0;
    let mut x207: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x206, &mut x207, x2, 0x2d8e03d1492d0d45);
    let mut x208: u64 = 0;
    let mut x209: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x208, &mut x209, x2, 0x5bcc6d61a8e567bc);
    let mut x210: u64 = 0;
    let mut x211: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x210, &mut x211, x2, 0xcff3d142b7756e3e);
    let mut x212: u64 = 0;
    let mut x213: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x212, &mut x213, x2, 0xdd6e23d82e49c7db);
    let mut x214: u64 = 0;
    let mut x215: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x214, &mut x215, x2, 0xd3721ef557f75e06);
    let mut x216: u64 = 0;
    let mut x217: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x216, &mut x217, x2, 0x12a78d38794573ff);
    let mut x218: u64 = 0;
    let mut x219: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x218, &mut x219, x2, 0xf707badce5547ea3);
    let mut x220: u64 = 0;
    let mut x221: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x220, &mut x221, x2, 0x137cd04dcf15dd04);
    let mut x222: u64 = 0;
    let mut x223: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x222, &mut x223, 0x0, x221, x218);
    let mut x224: u64 = 0;
    let mut x225: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x224, &mut x225, x223, x219, x216);
    let mut x226: u64 = 0;
    let mut x227: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x226, &mut x227, x225, x217, x214);
    let mut x228: u64 = 0;
    let mut x229: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x228, &mut x229, x227, x215, x212);
    let mut x230: u64 = 0;
    let mut x231: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x230, &mut x231, x229, x213, x210);
    let mut x232: u64 = 0;
    let mut x233: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x232, &mut x233, x231, x211, x208);
    let mut x234: u64 = 0;
    let mut x235: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x234, &mut x235, x233, x209, x206);
    let mut x236: u64 = 0;
    let mut x237: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x236, &mut x237, x235, x207, x204);
    let mut x238: u64 = 0;
    let mut x239: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x238, &mut x239, 0x0, x188, x220);
    let mut x240: u64 = 0;
    let mut x241: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x240, &mut x241, x239, x190, x222);
    let mut x242: u64 = 0;
    let mut x243: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x242, &mut x243, x241, x192, x224);
    let mut x244: u64 = 0;
    let mut x245: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x244, &mut x245, x243, x194, x226);
    let mut x246: u64 = 0;
    let mut x247: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x246, &mut x247, x245, x196, x228);
    let mut x248: u64 = 0;
    let mut x249: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x248, &mut x249, x247, x198, x230);
    let mut x250: u64 = 0;
    let mut x251: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x250, &mut x251, x249, x200, x232);
    let mut x252: u64 = 0;
    let mut x253: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x252, &mut x253, x251, x202, x234);
    let mut x254: u64 = 0;
    let mut x255: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x254,
        &mut x255,
        x253,
        (((x203 as u64) + ((x149 as u64) + ((x131 as u64) + x99))) + ((x185 as u64) + x153)),
        x236,
    );
    let mut x256: u64 = 0;
    let mut x257: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x256, &mut x257, x238, 0x1d2f5ccd79a995c7);
    let mut x258: u64 = 0;
    let mut x259: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x258, &mut x259, x256, 0x1ff);
    let mut x260: u64 = 0;
    let mut x261: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x260, &mut x261, x256, 0xffffffffffffffff);
    let mut x262: u64 = 0;
    let mut x263: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x262, &mut x263, x256, 0xffffffffffffffff);
    let mut x264: u64 = 0;
    let mut x265: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x264, &mut x265, x256, 0xffffffffffffffff);
    let mut x266: u64 = 0;
    let mut x267: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x266, &mut x267, x256, 0xfffffffffffffffa);
    let mut x268: u64 = 0;
    let mut x269: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x268, &mut x269, x256, 0x51868783bf2f966b);
    let mut x270: u64 = 0;
    let mut x271: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x270, &mut x271, x256, 0x7fcc0148f709a5d0);
    let mut x272: u64 = 0;
    let mut x273: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x272, &mut x273, x256, 0x3bb5c9b8899c47ae);
    let mut x274: u64 = 0;
    let mut x275: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x274, &mut x275, x256, 0xbb6fb71e91386409);
    let mut x276: u64 = 0;
    let mut x277: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x276, &mut x277, 0x0, x275, x272);
    let mut x278: u64 = 0;
    let mut x279: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x278, &mut x279, x277, x273, x270);
    let mut x280: u64 = 0;
    let mut x281: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x280, &mut x281, x279, x271, x268);
    let mut x282: u64 = 0;
    let mut x283: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x282, &mut x283, x281, x269, x266);
    let mut x284: u64 = 0;
    let mut x285: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x284, &mut x285, x283, x267, x264);
    let mut x286: u64 = 0;
    let mut x287: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x286, &mut x287, x285, x265, x262);
    let mut x288: u64 = 0;
    let mut x289: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x288, &mut x289, x287, x263, x260);
    let mut x290: u64 = 0;
    let mut x291: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x290, &mut x291, x289, x261, x258);
    let mut x292: u64 = 0;
    let mut x293: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x292, &mut x293, 0x0, x238, x274);
    let mut x294: u64 = 0;
    let mut x295: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x294, &mut x295, x293, x240, x276);
    let mut x296: u64 = 0;
    let mut x297: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x296, &mut x297, x295, x242, x278);
    let mut x298: u64 = 0;
    let mut x299: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x298, &mut x299, x297, x244, x280);
    let mut x300: u64 = 0;
    let mut x301: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x300, &mut x301, x299, x246, x282);
    let mut x302: u64 = 0;
    let mut x303: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x302, &mut x303, x301, x248, x284);
    let mut x304: u64 = 0;
    let mut x305: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x304, &mut x305, x303, x250, x286);
    let mut x306: u64 = 0;
    let mut x307: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x306, &mut x307, x305, x252, x288);
    let mut x308: u64 = 0;
    let mut x309: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x308, &mut x309, x307, x254, x290);
    let mut x310: u64 = 0;
    let mut x311: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x310, &mut x311, x3, 0x3d);
    let mut x312: u64 = 0;
    let mut x313: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x312, &mut x313, x3, 0x2d8e03d1492d0d45);
    let mut x314: u64 = 0;
    let mut x315: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x314, &mut x315, x3, 0x5bcc6d61a8e567bc);
    let mut x316: u64 = 0;
    let mut x317: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x316, &mut x317, x3, 0xcff3d142b7756e3e);
    let mut x318: u64 = 0;
    let mut x319: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x318, &mut x319, x3, 0xdd6e23d82e49c7db);
    let mut x320: u64 = 0;
    let mut x321: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x320, &mut x321, x3, 0xd3721ef557f75e06);
    let mut x322: u64 = 0;
    let mut x323: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x322, &mut x323, x3, 0x12a78d38794573ff);
    let mut x324: u64 = 0;
    let mut x325: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x324, &mut x325, x3, 0xf707badce5547ea3);
    let mut x326: u64 = 0;
    let mut x327: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x326, &mut x327, x3, 0x137cd04dcf15dd04);
    let mut x328: u64 = 0;
    let mut x329: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x328, &mut x329, 0x0, x327, x324);
    let mut x330: u64 = 0;
    let mut x331: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x330, &mut x331, x329, x325, x322);
    let mut x332: u64 = 0;
    let mut x333: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x332, &mut x333, x331, x323, x320);
    let mut x334: u64 = 0;
    let mut x335: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x334, &mut x335, x333, x321, x318);
    let mut x336: u64 = 0;
    let mut x337: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x336, &mut x337, x335, x319, x316);
    let mut x338: u64 = 0;
    let mut x339: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x338, &mut x339, x337, x317, x314);
    let mut x340: u64 = 0;
    let mut x341: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x340, &mut x341, x339, x315, x312);
    let mut x342: u64 = 0;
    let mut x343: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x342, &mut x343, x341, x313, x310);
    let mut x344: u64 = 0;
    let mut x345: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x344, &mut x345, 0x0, x294, x326);
    let mut x346: u64 = 0;
    let mut x347: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x346, &mut x347, x345, x296, x328);
    let mut x348: u64 = 0;
    let mut x349: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x348, &mut x349, x347, x298, x330);
    let mut x350: u64 = 0;
    let mut x351: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x350, &mut x351, x349, x300, x332);
    let mut x352: u64 = 0;
    let mut x353: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x352, &mut x353, x351, x302, x334);
    let mut x354: u64 = 0;
    let mut x355: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x354, &mut x355, x353, x304, x336);
    let mut x356: u64 = 0;
    let mut x357: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x356, &mut x357, x355, x306, x338);
    let mut x358: u64 = 0;
    let mut x359: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x358, &mut x359, x357, x308, x340);
    let mut x360: u64 = 0;
    let mut x361: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x360,
        &mut x361,
        x359,
        (((x309 as u64) + ((x255 as u64) + ((x237 as u64) + x205))) + ((x291 as u64) + x259)),
        x342,
    );
    let mut x362: u64 = 0;
    let mut x363: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x362, &mut x363, x344, 0x1d2f5ccd79a995c7);
    let mut x364: u64 = 0;
    let mut x365: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x364, &mut x365, x362, 0x1ff);
    let mut x366: u64 = 0;
    let mut x367: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x366, &mut x367, x362, 0xffffffffffffffff);
    let mut x368: u64 = 0;
    let mut x369: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x368, &mut x369, x362, 0xffffffffffffffff);
    let mut x370: u64 = 0;
    let mut x371: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x370, &mut x371, x362, 0xffffffffffffffff);
    let mut x372: u64 = 0;
    let mut x373: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x372, &mut x373, x362, 0xfffffffffffffffa);
    let mut x374: u64 = 0;
    let mut x375: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x374, &mut x375, x362, 0x51868783bf2f966b);
    let mut x376: u64 = 0;
    let mut x377: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x376, &mut x377, x362, 0x7fcc0148f709a5d0);
    let mut x378: u64 = 0;
    let mut x379: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x378, &mut x379, x362, 0x3bb5c9b8899c47ae);
    let mut x380: u64 = 0;
    let mut x381: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x380, &mut x381, x362, 0xbb6fb71e91386409);
    let mut x382: u64 = 0;
    let mut x383: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x382, &mut x383, 0x0, x381, x378);
    let mut x384: u64 = 0;
    let mut x385: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x384, &mut x385, x383, x379, x376);
    let mut x386: u64 = 0;
    let mut x387: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x386, &mut x387, x385, x377, x374);
    let mut x388: u64 = 0;
    let mut x389: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x388, &mut x389, x387, x375, x372);
    let mut x390: u64 = 0;
    let mut x391: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x390, &mut x391, x389, x373, x370);
    let mut x392: u64 = 0;
    let mut x393: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x392, &mut x393, x391, x371, x368);
    let mut x394: u64 = 0;
    let mut x395: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x394, &mut x395, x393, x369, x366);
    let mut x396: u64 = 0;
    let mut x397: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x396, &mut x397, x395, x367, x364);
    let mut x398: u64 = 0;
    let mut x399: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x398, &mut x399, 0x0, x344, x380);
    let mut x400: u64 = 0;
    let mut x401: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x400, &mut x401, x399, x346, x382);
    let mut x402: u64 = 0;
    let mut x403: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x402, &mut x403, x401, x348, x384);
    let mut x404: u64 = 0;
    let mut x405: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x404, &mut x405, x403, x350, x386);
    let mut x406: u64 = 0;
    let mut x407: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x406, &mut x407, x405, x352, x388);
    let mut x408: u64 = 0;
    let mut x409: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x408, &mut x409, x407, x354, x390);
    let mut x410: u64 = 0;
    let mut x411: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x410, &mut x411, x409, x356, x392);
    let mut x412: u64 = 0;
    let mut x413: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x412, &mut x413, x411, x358, x394);
    let mut x414: u64 = 0;
    let mut x415: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x414, &mut x415, x413, x360, x396);
    let mut x416: u64 = 0;
    let mut x417: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x416, &mut x417, x4, 0x3d);
    let mut x418: u64 = 0;
    let mut x419: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x418, &mut x419, x4, 0x2d8e03d1492d0d45);
    let mut x420: u64 = 0;
    let mut x421: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x420, &mut x421, x4, 0x5bcc6d61a8e567bc);
    let mut x422: u64 = 0;
    let mut x423: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x422, &mut x423, x4, 0xcff3d142b7756e3e);
    let mut x424: u64 = 0;
    let mut x425: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x424, &mut x425, x4, 0xdd6e23d82e49c7db);
    let mut x426: u64 = 0;
    let mut x427: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x426, &mut x427, x4, 0xd3721ef557f75e06);
    let mut x428: u64 = 0;
    let mut x429: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x428, &mut x429, x4, 0x12a78d38794573ff);
    let mut x430: u64 = 0;
    let mut x431: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x430, &mut x431, x4, 0xf707badce5547ea3);
    let mut x432: u64 = 0;
    let mut x433: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x432, &mut x433, x4, 0x137cd04dcf15dd04);
    let mut x434: u64 = 0;
    let mut x435: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x434, &mut x435, 0x0, x433, x430);
    let mut x436: u64 = 0;
    let mut x437: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x436, &mut x437, x435, x431, x428);
    let mut x438: u64 = 0;
    let mut x439: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x438, &mut x439, x437, x429, x426);
    let mut x440: u64 = 0;
    let mut x441: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x440, &mut x441, x439, x427, x424);
    let mut x442: u64 = 0;
    let mut x443: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x442, &mut x443, x441, x425, x422);
    let mut x444: u64 = 0;
    let mut x445: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x444, &mut x445, x443, x423, x420);
    let mut x446: u64 = 0;
    let mut x447: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x446, &mut x447, x445, x421, x418);
    let mut x448: u64 = 0;
    let mut x449: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x448, &mut x449, x447, x419, x416);
    let mut x450: u64 = 0;
    let mut x451: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x450, &mut x451, 0x0, x400, x432);
    let mut x452: u64 = 0;
    let mut x453: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x452, &mut x453, x451, x402, x434);
    let mut x454: u64 = 0;
    let mut x455: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x454, &mut x455, x453, x404, x436);
    let mut x456: u64 = 0;
    let mut x457: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x456, &mut x457, x455, x406, x438);
    let mut x458: u64 = 0;
    let mut x459: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x458, &mut x459, x457, x408, x440);
    let mut x460: u64 = 0;
    let mut x461: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x460, &mut x461, x459, x410, x442);
    let mut x462: u64 = 0;
    let mut x463: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x462, &mut x463, x461, x412, x444);
    let mut x464: u64 = 0;
    let mut x465: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x464, &mut x465, x463, x414, x446);
    let mut x466: u64 = 0;
    let mut x467: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x466,
        &mut x467,
        x465,
        (((x415 as u64) + ((x361 as u64) + ((x343 as u64) + x311))) + ((x397 as u64) + x365)),
        x448,
    );
    let mut x468: u64 = 0;
    let mut x469: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x468, &mut x469, x450, 0x1d2f5ccd79a995c7);
    let mut x470: u64 = 0;
    let mut x471: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x470, &mut x471, x468, 0x1ff);
    let mut x472: u64 = 0;
    let mut x473: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x472, &mut x473, x468, 0xffffffffffffffff);
    let mut x474: u64 = 0;
    let mut x475: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x474, &mut x475, x468, 0xffffffffffffffff);
    let mut x476: u64 = 0;
    let mut x477: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x476, &mut x477, x468, 0xffffffffffffffff);
    let mut x478: u64 = 0;
    let mut x479: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x478, &mut x479, x468, 0xfffffffffffffffa);
    let mut x480: u64 = 0;
    let mut x481: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x480, &mut x481, x468, 0x51868783bf2f966b);
    let mut x482: u64 = 0;
    let mut x483: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x482, &mut x483, x468, 0x7fcc0148f709a5d0);
    let mut x484: u64 = 0;
    let mut x485: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x484, &mut x485, x468, 0x3bb5c9b8899c47ae);
    let mut x486: u64 = 0;
    let mut x487: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x486, &mut x487, x468, 0xbb6fb71e91386409);
    let mut x488: u64 = 0;
    let mut x489: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x488, &mut x489, 0x0, x487, x484);
    let mut x490: u64 = 0;
    let mut x491: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x490, &mut x491, x489, x485, x482);
    let mut x492: u64 = 0;
    let mut x493: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x492, &mut x493, x491, x483, x480);
    let mut x494: u64 = 0;
    let mut x495: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x494, &mut x495, x493, x481, x478);
    let mut x496: u64 = 0;
    let mut x497: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x496, &mut x497, x495, x479, x476);
    let mut x498: u64 = 0;
    let mut x499: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x498, &mut x499, x497, x477, x474);
    let mut x500: u64 = 0;
    let mut x501: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x500, &mut x501, x499, x475, x472);
    let mut x502: u64 = 0;
    let mut x503: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x502, &mut x503, x501, x473, x470);
    let mut x504: u64 = 0;
    let mut x505: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x504, &mut x505, 0x0, x450, x486);
    let mut x506: u64 = 0;
    let mut x507: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x506, &mut x507, x505, x452, x488);
    let mut x508: u64 = 0;
    let mut x509: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x508, &mut x509, x507, x454, x490);
    let mut x510: u64 = 0;
    let mut x511: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x510, &mut x511, x509, x456, x492);
    let mut x512: u64 = 0;
    let mut x513: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x512, &mut x513, x511, x458, x494);
    let mut x514: u64 = 0;
    let mut x515: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x514, &mut x515, x513, x460, x496);
    let mut x516: u64 = 0;
    let mut x517: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x516, &mut x517, x515, x462, x498);
    let mut x518: u64 = 0;
    let mut x519: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x518, &mut x519, x517, x464, x500);
    let mut x520: u64 = 0;
    let mut x521: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x520, &mut x521, x519, x466, x502);
    let mut x522: u64 = 0;
    let mut x523: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x522, &mut x523, x5, 0x3d);
    let mut x524: u64 = 0;
    let mut x525: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x524, &mut x525, x5, 0x2d8e03d1492d0d45);
    let mut x526: u64 = 0;
    let mut x527: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x526, &mut x527, x5, 0x5bcc6d61a8e567bc);
    let mut x528: u64 = 0;
    let mut x529: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x528, &mut x529, x5, 0xcff3d142b7756e3e);
    let mut x530: u64 = 0;
    let mut x531: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x530, &mut x531, x5, 0xdd6e23d82e49c7db);
    let mut x532: u64 = 0;
    let mut x533: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x532, &mut x533, x5, 0xd3721ef557f75e06);
    let mut x534: u64 = 0;
    let mut x535: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x534, &mut x535, x5, 0x12a78d38794573ff);
    let mut x536: u64 = 0;
    let mut x537: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x536, &mut x537, x5, 0xf707badce5547ea3);
    let mut x538: u64 = 0;
    let mut x539: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x538, &mut x539, x5, 0x137cd04dcf15dd04);
    let mut x540: u64 = 0;
    let mut x541: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x540, &mut x541, 0x0, x539, x536);
    let mut x542: u64 = 0;
    let mut x543: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x542, &mut x543, x541, x537, x534);
    let mut x544: u64 = 0;
    let mut x545: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x544, &mut x545, x543, x535, x532);
    let mut x546: u64 = 0;
    let mut x547: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x546, &mut x547, x545, x533, x530);
    let mut x548: u64 = 0;
    let mut x549: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x548, &mut x549, x547, x531, x528);
    let mut x550: u64 = 0;
    let mut x551: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x550, &mut x551, x549, x529, x526);
    let mut x552: u64 = 0;
    let mut x553: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x552, &mut x553, x551, x527, x524);
    let mut x554: u64 = 0;
    let mut x555: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x554, &mut x555, x553, x525, x522);
    let mut x556: u64 = 0;
    let mut x557: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x556, &mut x557, 0x0, x506, x538);
    let mut x558: u64 = 0;
    let mut x559: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x558, &mut x559, x557, x508, x540);
    let mut x560: u64 = 0;
    let mut x561: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x560, &mut x561, x559, x510, x542);
    let mut x562: u64 = 0;
    let mut x563: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x562, &mut x563, x561, x512, x544);
    let mut x564: u64 = 0;
    let mut x565: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x564, &mut x565, x563, x514, x546);
    let mut x566: u64 = 0;
    let mut x567: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x566, &mut x567, x565, x516, x548);
    let mut x568: u64 = 0;
    let mut x569: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x568, &mut x569, x567, x518, x550);
    let mut x570: u64 = 0;
    let mut x571: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x570, &mut x571, x569, x520, x552);
    let mut x572: u64 = 0;
    let mut x573: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x572,
        &mut x573,
        x571,
        (((x521 as u64) + ((x467 as u64) + ((x449 as u64) + x417))) + ((x503 as u64) + x471)),
        x554,
    );
    let mut x574: u64 = 0;
    let mut x575: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x574, &mut x575, x556, 0x1d2f5ccd79a995c7);
    let mut x576: u64 = 0;
    let mut x577: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x576, &mut x577, x574, 0x1ff);
    let mut x578: u64 = 0;
    let mut x579: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x578, &mut x579, x574, 0xffffffffffffffff);
    let mut x580: u64 = 0;
    let mut x581: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x580, &mut x581, x574, 0xffffffffffffffff);
    let mut x582: u64 = 0;
    let mut x583: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x582, &mut x583, x574, 0xffffffffffffffff);
    let mut x584: u64 = 0;
    let mut x585: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x584, &mut x585, x574, 0xfffffffffffffffa);
    let mut x586: u64 = 0;
    let mut x587: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x586, &mut x587, x574, 0x51868783bf2f966b);
    let mut x588: u64 = 0;
    let mut x589: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x588, &mut x589, x574, 0x7fcc0148f709a5d0);
    let mut x590: u64 = 0;
    let mut x591: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x590, &mut x591, x574, 0x3bb5c9b8899c47ae);
    let mut x592: u64 = 0;
    let mut x593: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x592, &mut x593, x574, 0xbb6fb71e91386409);
    let mut x594: u64 = 0;
    let mut x595: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x594, &mut x595, 0x0, x593, x590);
    let mut x596: u64 = 0;
    let mut x597: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x596, &mut x597, x595, x591, x588);
    let mut x598: u64 = 0;
    let mut x599: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x598, &mut x599, x597, x589, x586);
    let mut x600: u64 = 0;
    let mut x601: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x600, &mut x601, x599, x587, x584);
    let mut x602: u64 = 0;
    let mut x603: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x602, &mut x603, x601, x585, x582);
    let mut x604: u64 = 0;
    let mut x605: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x604, &mut x605, x603, x583, x580);
    let mut x606: u64 = 0;
    let mut x607: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x606, &mut x607, x605, x581, x578);
    let mut x608: u64 = 0;
    let mut x609: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x608, &mut x609, x607, x579, x576);
    let mut x610: u64 = 0;
    let mut x611: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x610, &mut x611, 0x0, x556, x592);
    let mut x612: u64 = 0;
    let mut x613: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x612, &mut x613, x611, x558, x594);
    let mut x614: u64 = 0;
    let mut x615: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x614, &mut x615, x613, x560, x596);
    let mut x616: u64 = 0;
    let mut x617: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x616, &mut x617, x615, x562, x598);
    let mut x618: u64 = 0;
    let mut x619: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x618, &mut x619, x617, x564, x600);
    let mut x620: u64 = 0;
    let mut x621: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x620, &mut x621, x619, x566, x602);
    let mut x622: u64 = 0;
    let mut x623: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x622, &mut x623, x621, x568, x604);
    let mut x624: u64 = 0;
    let mut x625: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x624, &mut x625, x623, x570, x606);
    let mut x626: u64 = 0;
    let mut x627: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x626, &mut x627, x625, x572, x608);
    let mut x628: u64 = 0;
    let mut x629: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x628, &mut x629, x6, 0x3d);
    let mut x630: u64 = 0;
    let mut x631: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x630, &mut x631, x6, 0x2d8e03d1492d0d45);
    let mut x632: u64 = 0;
    let mut x633: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x632, &mut x633, x6, 0x5bcc6d61a8e567bc);
    let mut x634: u64 = 0;
    let mut x635: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x634, &mut x635, x6, 0xcff3d142b7756e3e);
    let mut x636: u64 = 0;
    let mut x637: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x636, &mut x637, x6, 0xdd6e23d82e49c7db);
    let mut x638: u64 = 0;
    let mut x639: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x638, &mut x639, x6, 0xd3721ef557f75e06);
    let mut x640: u64 = 0;
    let mut x641: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x640, &mut x641, x6, 0x12a78d38794573ff);
    let mut x642: u64 = 0;
    let mut x643: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x642, &mut x643, x6, 0xf707badce5547ea3);
    let mut x644: u64 = 0;
    let mut x645: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x644, &mut x645, x6, 0x137cd04dcf15dd04);
    let mut x646: u64 = 0;
    let mut x647: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x646, &mut x647, 0x0, x645, x642);
    let mut x648: u64 = 0;
    let mut x649: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x648, &mut x649, x647, x643, x640);
    let mut x650: u64 = 0;
    let mut x651: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x650, &mut x651, x649, x641, x638);
    let mut x652: u64 = 0;
    let mut x653: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x652, &mut x653, x651, x639, x636);
    let mut x654: u64 = 0;
    let mut x655: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x654, &mut x655, x653, x637, x634);
    let mut x656: u64 = 0;
    let mut x657: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x656, &mut x657, x655, x635, x632);
    let mut x658: u64 = 0;
    let mut x659: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x658, &mut x659, x657, x633, x630);
    let mut x660: u64 = 0;
    let mut x661: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x660, &mut x661, x659, x631, x628);
    let mut x662: u64 = 0;
    let mut x663: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x662, &mut x663, 0x0, x612, x644);
    let mut x664: u64 = 0;
    let mut x665: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x664, &mut x665, x663, x614, x646);
    let mut x666: u64 = 0;
    let mut x667: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x666, &mut x667, x665, x616, x648);
    let mut x668: u64 = 0;
    let mut x669: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x668, &mut x669, x667, x618, x650);
    let mut x670: u64 = 0;
    let mut x671: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x670, &mut x671, x669, x620, x652);
    let mut x672: u64 = 0;
    let mut x673: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x672, &mut x673, x671, x622, x654);
    let mut x674: u64 = 0;
    let mut x675: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x674, &mut x675, x673, x624, x656);
    let mut x676: u64 = 0;
    let mut x677: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x676, &mut x677, x675, x626, x658);
    let mut x678: u64 = 0;
    let mut x679: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x678,
        &mut x679,
        x677,
        (((x627 as u64) + ((x573 as u64) + ((x555 as u64) + x523))) + ((x609 as u64) + x577)),
        x660,
    );
    let mut x680: u64 = 0;
    let mut x681: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x680, &mut x681, x662, 0x1d2f5ccd79a995c7);
    let mut x682: u64 = 0;
    let mut x683: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x682, &mut x683, x680, 0x1ff);
    let mut x684: u64 = 0;
    let mut x685: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x684, &mut x685, x680, 0xffffffffffffffff);
    let mut x686: u64 = 0;
    let mut x687: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x686, &mut x687, x680, 0xffffffffffffffff);
    let mut x688: u64 = 0;
    let mut x689: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x688, &mut x689, x680, 0xffffffffffffffff);
    let mut x690: u64 = 0;
    let mut x691: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x690, &mut x691, x680, 0xfffffffffffffffa);
    let mut x692: u64 = 0;
    let mut x693: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x692, &mut x693, x680, 0x51868783bf2f966b);
    let mut x694: u64 = 0;
    let mut x695: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x694, &mut x695, x680, 0x7fcc0148f709a5d0);
    let mut x696: u64 = 0;
    let mut x697: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x696, &mut x697, x680, 0x3bb5c9b8899c47ae);
    let mut x698: u64 = 0;
    let mut x699: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x698, &mut x699, x680, 0xbb6fb71e91386409);
    let mut x700: u64 = 0;
    let mut x701: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x700, &mut x701, 0x0, x699, x696);
    let mut x702: u64 = 0;
    let mut x703: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x702, &mut x703, x701, x697, x694);
    let mut x704: u64 = 0;
    let mut x705: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x704, &mut x705, x703, x695, x692);
    let mut x706: u64 = 0;
    let mut x707: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x706, &mut x707, x705, x693, x690);
    let mut x708: u64 = 0;
    let mut x709: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x708, &mut x709, x707, x691, x688);
    let mut x710: u64 = 0;
    let mut x711: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x710, &mut x711, x709, x689, x686);
    let mut x712: u64 = 0;
    let mut x713: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x712, &mut x713, x711, x687, x684);
    let mut x714: u64 = 0;
    let mut x715: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x714, &mut x715, x713, x685, x682);
    let mut x716: u64 = 0;
    let mut x717: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x716, &mut x717, 0x0, x662, x698);
    let mut x718: u64 = 0;
    let mut x719: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x718, &mut x719, x717, x664, x700);
    let mut x720: u64 = 0;
    let mut x721: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x720, &mut x721, x719, x666, x702);
    let mut x722: u64 = 0;
    let mut x723: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x722, &mut x723, x721, x668, x704);
    let mut x724: u64 = 0;
    let mut x725: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x724, &mut x725, x723, x670, x706);
    let mut x726: u64 = 0;
    let mut x727: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x726, &mut x727, x725, x672, x708);
    let mut x728: u64 = 0;
    let mut x729: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x728, &mut x729, x727, x674, x710);
    let mut x730: u64 = 0;
    let mut x731: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x730, &mut x731, x729, x676, x712);
    let mut x732: u64 = 0;
    let mut x733: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x732, &mut x733, x731, x678, x714);
    let mut x734: u64 = 0;
    let mut x735: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x734, &mut x735, x7, 0x3d);
    let mut x736: u64 = 0;
    let mut x737: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x736, &mut x737, x7, 0x2d8e03d1492d0d45);
    let mut x738: u64 = 0;
    let mut x739: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x738, &mut x739, x7, 0x5bcc6d61a8e567bc);
    let mut x740: u64 = 0;
    let mut x741: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x740, &mut x741, x7, 0xcff3d142b7756e3e);
    let mut x742: u64 = 0;
    let mut x743: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x742, &mut x743, x7, 0xdd6e23d82e49c7db);
    let mut x744: u64 = 0;
    let mut x745: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x744, &mut x745, x7, 0xd3721ef557f75e06);
    let mut x746: u64 = 0;
    let mut x747: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x746, &mut x747, x7, 0x12a78d38794573ff);
    let mut x748: u64 = 0;
    let mut x749: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x748, &mut x749, x7, 0xf707badce5547ea3);
    let mut x750: u64 = 0;
    let mut x751: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x750, &mut x751, x7, 0x137cd04dcf15dd04);
    let mut x752: u64 = 0;
    let mut x753: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x752, &mut x753, 0x0, x751, x748);
    let mut x754: u64 = 0;
    let mut x755: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x754, &mut x755, x753, x749, x746);
    let mut x756: u64 = 0;
    let mut x757: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x756, &mut x757, x755, x747, x744);
    let mut x758: u64 = 0;
    let mut x759: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x758, &mut x759, x757, x745, x742);
    let mut x760: u64 = 0;
    let mut x761: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x760, &mut x761, x759, x743, x740);
    let mut x762: u64 = 0;
    let mut x763: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x762, &mut x763, x761, x741, x738);
    let mut x764: u64 = 0;
    let mut x765: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x764, &mut x765, x763, x739, x736);
    let mut x766: u64 = 0;
    let mut x767: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x766, &mut x767, x765, x737, x734);
    let mut x768: u64 = 0;
    let mut x769: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x768, &mut x769, 0x0, x718, x750);
    let mut x770: u64 = 0;
    let mut x771: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x770, &mut x771, x769, x720, x752);
    let mut x772: u64 = 0;
    let mut x773: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x772, &mut x773, x771, x722, x754);
    let mut x774: u64 = 0;
    let mut x775: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x774, &mut x775, x773, x724, x756);
    let mut x776: u64 = 0;
    let mut x777: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x776, &mut x777, x775, x726, x758);
    let mut x778: u64 = 0;
    let mut x779: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x778, &mut x779, x777, x728, x760);
    let mut x780: u64 = 0;
    let mut x781: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x780, &mut x781, x779, x730, x762);
    let mut x782: u64 = 0;
    let mut x783: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x782, &mut x783, x781, x732, x764);
    let mut x784: u64 = 0;
    let mut x785: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x784,
        &mut x785,
        x783,
        (((x733 as u64) + ((x679 as u64) + ((x661 as u64) + x629))) + ((x715 as u64) + x683)),
        x766,
    );
    let mut x786: u64 = 0;
    let mut x787: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x786, &mut x787, x768, 0x1d2f5ccd79a995c7);
    let mut x788: u64 = 0;
    let mut x789: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x788, &mut x789, x786, 0x1ff);
    let mut x790: u64 = 0;
    let mut x791: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x790, &mut x791, x786, 0xffffffffffffffff);
    let mut x792: u64 = 0;
    let mut x793: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x792, &mut x793, x786, 0xffffffffffffffff);
    let mut x794: u64 = 0;
    let mut x795: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x794, &mut x795, x786, 0xffffffffffffffff);
    let mut x796: u64 = 0;
    let mut x797: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x796, &mut x797, x786, 0xfffffffffffffffa);
    let mut x798: u64 = 0;
    let mut x799: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x798, &mut x799, x786, 0x51868783bf2f966b);
    let mut x800: u64 = 0;
    let mut x801: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x800, &mut x801, x786, 0x7fcc0148f709a5d0);
    let mut x802: u64 = 0;
    let mut x803: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x802, &mut x803, x786, 0x3bb5c9b8899c47ae);
    let mut x804: u64 = 0;
    let mut x805: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x804, &mut x805, x786, 0xbb6fb71e91386409);
    let mut x806: u64 = 0;
    let mut x807: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x806, &mut x807, 0x0, x805, x802);
    let mut x808: u64 = 0;
    let mut x809: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x808, &mut x809, x807, x803, x800);
    let mut x810: u64 = 0;
    let mut x811: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x810, &mut x811, x809, x801, x798);
    let mut x812: u64 = 0;
    let mut x813: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x812, &mut x813, x811, x799, x796);
    let mut x814: u64 = 0;
    let mut x815: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x814, &mut x815, x813, x797, x794);
    let mut x816: u64 = 0;
    let mut x817: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x816, &mut x817, x815, x795, x792);
    let mut x818: u64 = 0;
    let mut x819: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x818, &mut x819, x817, x793, x790);
    let mut x820: u64 = 0;
    let mut x821: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x820, &mut x821, x819, x791, x788);
    let mut x822: u64 = 0;
    let mut x823: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x822, &mut x823, 0x0, x768, x804);
    let mut x824: u64 = 0;
    let mut x825: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x824, &mut x825, x823, x770, x806);
    let mut x826: u64 = 0;
    let mut x827: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x826, &mut x827, x825, x772, x808);
    let mut x828: u64 = 0;
    let mut x829: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x828, &mut x829, x827, x774, x810);
    let mut x830: u64 = 0;
    let mut x831: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x830, &mut x831, x829, x776, x812);
    let mut x832: u64 = 0;
    let mut x833: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x832, &mut x833, x831, x778, x814);
    let mut x834: u64 = 0;
    let mut x835: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x834, &mut x835, x833, x780, x816);
    let mut x836: u64 = 0;
    let mut x837: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x836, &mut x837, x835, x782, x818);
    let mut x838: u64 = 0;
    let mut x839: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x838, &mut x839, x837, x784, x820);
    let mut x840: u64 = 0;
    let mut x841: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x840, &mut x841, x8, 0x3d);
    let mut x842: u64 = 0;
    let mut x843: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x842, &mut x843, x8, 0x2d8e03d1492d0d45);
    let mut x844: u64 = 0;
    let mut x845: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x844, &mut x845, x8, 0x5bcc6d61a8e567bc);
    let mut x846: u64 = 0;
    let mut x847: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x846, &mut x847, x8, 0xcff3d142b7756e3e);
    let mut x848: u64 = 0;
    let mut x849: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x848, &mut x849, x8, 0xdd6e23d82e49c7db);
    let mut x850: u64 = 0;
    let mut x851: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x850, &mut x851, x8, 0xd3721ef557f75e06);
    let mut x852: u64 = 0;
    let mut x853: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x852, &mut x853, x8, 0x12a78d38794573ff);
    let mut x854: u64 = 0;
    let mut x855: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x854, &mut x855, x8, 0xf707badce5547ea3);
    let mut x856: u64 = 0;
    let mut x857: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x856, &mut x857, x8, 0x137cd04dcf15dd04);
    let mut x858: u64 = 0;
    let mut x859: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x858, &mut x859, 0x0, x857, x854);
    let mut x860: u64 = 0;
    let mut x861: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x860, &mut x861, x859, x855, x852);
    let mut x862: u64 = 0;
    let mut x863: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x862, &mut x863, x861, x853, x850);
    let mut x864: u64 = 0;
    let mut x865: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x864, &mut x865, x863, x851, x848);
    let mut x866: u64 = 0;
    let mut x867: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x866, &mut x867, x865, x849, x846);
    let mut x868: u64 = 0;
    let mut x869: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x868, &mut x869, x867, x847, x844);
    let mut x870: u64 = 0;
    let mut x871: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x870, &mut x871, x869, x845, x842);
    let mut x872: u64 = 0;
    let mut x873: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x872, &mut x873, x871, x843, x840);
    let mut x874: u64 = 0;
    let mut x875: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x874, &mut x875, 0x0, x824, x856);
    let mut x876: u64 = 0;
    let mut x877: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x876, &mut x877, x875, x826, x858);
    let mut x878: u64 = 0;
    let mut x879: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x878, &mut x879, x877, x828, x860);
    let mut x880: u64 = 0;
    let mut x881: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x880, &mut x881, x879, x830, x862);
    let mut x882: u64 = 0;
    let mut x883: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x882, &mut x883, x881, x832, x864);
    let mut x884: u64 = 0;
    let mut x885: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x884, &mut x885, x883, x834, x866);
    let mut x886: u64 = 0;
    let mut x887: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x886, &mut x887, x885, x836, x868);
    let mut x888: u64 = 0;
    let mut x889: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x888, &mut x889, x887, x838, x870);
    let mut x890: u64 = 0;
    let mut x891: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x890,
        &mut x891,
        x889,
        (((x839 as u64) + ((x785 as u64) + ((x767 as u64) + x735))) + ((x821 as u64) + x789)),
        x872,
    );
    let mut x892: u64 = 0;
    let mut x893: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x892, &mut x893, x874, 0x1d2f5ccd79a995c7);
    let mut x894: u64 = 0;
    let mut x895: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x894, &mut x895, x892, 0x1ff);
    let mut x896: u64 = 0;
    let mut x897: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x896, &mut x897, x892, 0xffffffffffffffff);
    let mut x898: u64 = 0;
    let mut x899: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x898, &mut x899, x892, 0xffffffffffffffff);
    let mut x900: u64 = 0;
    let mut x901: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x900, &mut x901, x892, 0xffffffffffffffff);
    let mut x902: u64 = 0;
    let mut x903: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x902, &mut x903, x892, 0xfffffffffffffffa);
    let mut x904: u64 = 0;
    let mut x905: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x904, &mut x905, x892, 0x51868783bf2f966b);
    let mut x906: u64 = 0;
    let mut x907: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x906, &mut x907, x892, 0x7fcc0148f709a5d0);
    let mut x908: u64 = 0;
    let mut x909: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x908, &mut x909, x892, 0x3bb5c9b8899c47ae);
    let mut x910: u64 = 0;
    let mut x911: u64 = 0;
    fiat_p521_scalar_mulx_u64(&mut x910, &mut x911, x892, 0xbb6fb71e91386409);
    let mut x912: u64 = 0;
    let mut x913: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x912, &mut x913, 0x0, x911, x908);
    let mut x914: u64 = 0;
    let mut x915: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x914, &mut x915, x913, x909, x906);
    let mut x916: u64 = 0;
    let mut x917: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x916, &mut x917, x915, x907, x904);
    let mut x918: u64 = 0;
    let mut x919: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x918, &mut x919, x917, x905, x902);
    let mut x920: u64 = 0;
    let mut x921: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x920, &mut x921, x919, x903, x900);
    let mut x922: u64 = 0;
    let mut x923: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x922, &mut x923, x921, x901, x898);
    let mut x924: u64 = 0;
    let mut x925: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x924, &mut x925, x923, x899, x896);
    let mut x926: u64 = 0;
    let mut x927: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x926, &mut x927, x925, x897, x894);
    let mut x928: u64 = 0;
    let mut x929: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x928, &mut x929, 0x0, x874, x910);
    let mut x930: u64 = 0;
    let mut x931: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x930, &mut x931, x929, x876, x912);
    let mut x932: u64 = 0;
    let mut x933: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x932, &mut x933, x931, x878, x914);
    let mut x934: u64 = 0;
    let mut x935: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x934, &mut x935, x933, x880, x916);
    let mut x936: u64 = 0;
    let mut x937: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x936, &mut x937, x935, x882, x918);
    let mut x938: u64 = 0;
    let mut x939: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x938, &mut x939, x937, x884, x920);
    let mut x940: u64 = 0;
    let mut x941: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x940, &mut x941, x939, x886, x922);
    let mut x942: u64 = 0;
    let mut x943: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x942, &mut x943, x941, x888, x924);
    let mut x944: u64 = 0;
    let mut x945: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x944, &mut x945, x943, x890, x926);
    let x946: u64 =
        (((x945 as u64) + ((x891 as u64) + ((x873 as u64) + x841))) + ((x927 as u64) + x895));
    let mut x947: u64 = 0;
    let mut x948: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x947, &mut x948, 0x0, x930, 0xbb6fb71e91386409);
    let mut x949: u64 = 0;
    let mut x950: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x949, &mut x950, x948, x932, 0x3bb5c9b8899c47ae);
    let mut x951: u64 = 0;
    let mut x952: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x951, &mut x952, x950, x934, 0x7fcc0148f709a5d0);
    let mut x953: u64 = 0;
    let mut x954: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x953, &mut x954, x952, x936, 0x51868783bf2f966b);
    let mut x955: u64 = 0;
    let mut x956: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x955, &mut x956, x954, x938, 0xfffffffffffffffa);
    let mut x957: u64 = 0;
    let mut x958: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x957, &mut x958, x956, x940, 0xffffffffffffffff);
    let mut x959: u64 = 0;
    let mut x960: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x959, &mut x960, x958, x942, 0xffffffffffffffff);
    let mut x961: u64 = 0;
    let mut x962: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x961, &mut x962, x960, x944, 0xffffffffffffffff);
    let mut x963: u64 = 0;
    let mut x964: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x963, &mut x964, x962, x946, 0x1ff);
    let mut x965: u64 = 0;
    let mut x966: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x965, &mut x966, x964, (0x0 as u64), (0x0 as u64));
    let mut x967: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x967, x966, x947, x930);
    let mut x968: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x968, x966, x949, x932);
    let mut x969: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x969, x966, x951, x934);
    let mut x970: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x970, x966, x953, x936);
    let mut x971: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x971, x966, x955, x938);
    let mut x972: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x972, x966, x957, x940);
    let mut x973: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x973, x966, x959, x942);
    let mut x974: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x974, x966, x961, x944);
    let mut x975: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x975, x966, x963, x946);
    *IndexConst(&mut out1).index_mut(0) = x967;
    *IndexConst(&mut out1).index_mut(1) = x968;
    *IndexConst(&mut out1).index_mut(2) = x969;
    *IndexConst(&mut out1).index_mut(3) = x970;
    *IndexConst(&mut out1).index_mut(4) = x971;
    *IndexConst(&mut out1).index_mut(5) = x972;
    *IndexConst(&mut out1).index_mut(6) = x973;
    *IndexConst(&mut out1).index_mut(7) = x974;
    *IndexConst(&mut out1).index_mut(8) = x975;
}

/// The function fiat_p521_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub const fn fiat_p521_scalar_nonzero(out1: &mut u64, arg1: &[u64; 9]) {
    let x1: u64 = ((*IndexConst(arg1).index(0))
        | ((*IndexConst(arg1).index(1))
            | ((*IndexConst(arg1).index(2))
                | ((*IndexConst(arg1).index(3))
                    | ((*IndexConst(arg1).index(4))
                        | ((*IndexConst(arg1).index(5))
                            | ((*IndexConst(arg1).index(6))
                                | ((*IndexConst(arg1).index(7))
                                    | (*IndexConst(arg1).index(8))))))))));
    *out1 = x1;
}

/// The function fiat_p521_scalar_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_p521_scalar_selectznz(
    mut out1: &mut [u64; 9],
    arg1: fiat_p521_scalar_u1,
    arg2: &[u64; 9],
    arg3: &[u64; 9],
) {
    let mut x1: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x1,
        arg1,
        (*IndexConst(arg2).index(0)),
        (*IndexConst(arg3).index(0)),
    );
    let mut x2: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x2,
        arg1,
        (*IndexConst(arg2).index(1)),
        (*IndexConst(arg3).index(1)),
    );
    let mut x3: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x3,
        arg1,
        (*IndexConst(arg2).index(2)),
        (*IndexConst(arg3).index(2)),
    );
    let mut x4: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x4,
        arg1,
        (*IndexConst(arg2).index(3)),
        (*IndexConst(arg3).index(3)),
    );
    let mut x5: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x5,
        arg1,
        (*IndexConst(arg2).index(4)),
        (*IndexConst(arg3).index(4)),
    );
    let mut x6: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x6,
        arg1,
        (*IndexConst(arg2).index(5)),
        (*IndexConst(arg3).index(5)),
    );
    let mut x7: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x7,
        arg1,
        (*IndexConst(arg2).index(6)),
        (*IndexConst(arg3).index(6)),
    );
    let mut x8: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x8,
        arg1,
        (*IndexConst(arg2).index(7)),
        (*IndexConst(arg3).index(7)),
    );
    let mut x9: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x9,
        arg1,
        (*IndexConst(arg2).index(8)),
        (*IndexConst(arg3).index(8)),
    );
    *IndexConst(&mut out1).index_mut(0) = x1;
    *IndexConst(&mut out1).index_mut(1) = x2;
    *IndexConst(&mut out1).index_mut(2) = x3;
    *IndexConst(&mut out1).index_mut(3) = x4;
    *IndexConst(&mut out1).index_mut(4) = x5;
    *IndexConst(&mut out1).index_mut(5) = x6;
    *IndexConst(&mut out1).index_mut(6) = x7;
    *IndexConst(&mut out1).index_mut(7) = x8;
    *IndexConst(&mut out1).index_mut(8) = x9;
}

/// The function fiat_p521_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..65]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0x1ff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
#[inline]
pub const fn fiat_p521_scalar_to_bytes(mut out1: &mut [u8; 66], arg1: &[u64; 9]) {
    let x1: u64 = (*IndexConst(arg1).index(8));
    let x2: u64 = (*IndexConst(arg1).index(7));
    let x3: u64 = (*IndexConst(arg1).index(6));
    let x4: u64 = (*IndexConst(arg1).index(5));
    let x5: u64 = (*IndexConst(arg1).index(4));
    let x6: u64 = (*IndexConst(arg1).index(3));
    let x7: u64 = (*IndexConst(arg1).index(2));
    let x8: u64 = (*IndexConst(arg1).index(1));
    let x9: u64 = (*IndexConst(arg1).index(0));
    let x10: u8 = ((x9 & (0xff as u64)) as u8);
    let x11: u64 = (x9 >> 8);
    let x12: u8 = ((x11 & (0xff as u64)) as u8);
    let x13: u64 = (x11 >> 8);
    let x14: u8 = ((x13 & (0xff as u64)) as u8);
    let x15: u64 = (x13 >> 8);
    let x16: u8 = ((x15 & (0xff as u64)) as u8);
    let x17: u64 = (x15 >> 8);
    let x18: u8 = ((x17 & (0xff as u64)) as u8);
    let x19: u64 = (x17 >> 8);
    let x20: u8 = ((x19 & (0xff as u64)) as u8);
    let x21: u64 = (x19 >> 8);
    let x22: u8 = ((x21 & (0xff as u64)) as u8);
    let x23: u8 = ((x21 >> 8) as u8);
    let x24: u8 = ((x8 & (0xff as u64)) as u8);
    let x25: u64 = (x8 >> 8);
    let x26: u8 = ((x25 & (0xff as u64)) as u8);
    let x27: u64 = (x25 >> 8);
    let x28: u8 = ((x27 & (0xff as u64)) as u8);
    let x29: u64 = (x27 >> 8);
    let x30: u8 = ((x29 & (0xff as u64)) as u8);
    let x31: u64 = (x29 >> 8);
    let x32: u8 = ((x31 & (0xff as u64)) as u8);
    let x33: u64 = (x31 >> 8);
    let x34: u8 = ((x33 & (0xff as u64)) as u8);
    let x35: u64 = (x33 >> 8);
    let x36: u8 = ((x35 & (0xff as u64)) as u8);
    let x37: u8 = ((x35 >> 8) as u8);
    let x38: u8 = ((x7 & (0xff as u64)) as u8);
    let x39: u64 = (x7 >> 8);
    let x40: u8 = ((x39 & (0xff as u64)) as u8);
    let x41: u64 = (x39 >> 8);
    let x42: u8 = ((x41 & (0xff as u64)) as u8);
    let x43: u64 = (x41 >> 8);
    let x44: u8 = ((x43 & (0xff as u64)) as u8);
    let x45: u64 = (x43 >> 8);
    let x46: u8 = ((x45 & (0xff as u64)) as u8);
    let x47: u64 = (x45 >> 8);
    let x48: u8 = ((x47 & (0xff as u64)) as u8);
    let x49: u64 = (x47 >> 8);
    let x50: u8 = ((x49 & (0xff as u64)) as u8);
    let x51: u8 = ((x49 >> 8) as u8);
    let x52: u8 = ((x6 & (0xff as u64)) as u8);
    let x53: u64 = (x6 >> 8);
    let x54: u8 = ((x53 & (0xff as u64)) as u8);
    let x55: u64 = (x53 >> 8);
    let x56: u8 = ((x55 & (0xff as u64)) as u8);
    let x57: u64 = (x55 >> 8);
    let x58: u8 = ((x57 & (0xff as u64)) as u8);
    let x59: u64 = (x57 >> 8);
    let x60: u8 = ((x59 & (0xff as u64)) as u8);
    let x61: u64 = (x59 >> 8);
    let x62: u8 = ((x61 & (0xff as u64)) as u8);
    let x63: u64 = (x61 >> 8);
    let x64: u8 = ((x63 & (0xff as u64)) as u8);
    let x65: u8 = ((x63 >> 8) as u8);
    let x66: u8 = ((x5 & (0xff as u64)) as u8);
    let x67: u64 = (x5 >> 8);
    let x68: u8 = ((x67 & (0xff as u64)) as u8);
    let x69: u64 = (x67 >> 8);
    let x70: u8 = ((x69 & (0xff as u64)) as u8);
    let x71: u64 = (x69 >> 8);
    let x72: u8 = ((x71 & (0xff as u64)) as u8);
    let x73: u64 = (x71 >> 8);
    let x74: u8 = ((x73 & (0xff as u64)) as u8);
    let x75: u64 = (x73 >> 8);
    let x76: u8 = ((x75 & (0xff as u64)) as u8);
    let x77: u64 = (x75 >> 8);
    let x78: u8 = ((x77 & (0xff as u64)) as u8);
    let x79: u8 = ((x77 >> 8) as u8);
    let x80: u8 = ((x4 & (0xff as u64)) as u8);
    let x81: u64 = (x4 >> 8);
    let x82: u8 = ((x81 & (0xff as u64)) as u8);
    let x83: u64 = (x81 >> 8);
    let x84: u8 = ((x83 & (0xff as u64)) as u8);
    let x85: u64 = (x83 >> 8);
    let x86: u8 = ((x85 & (0xff as u64)) as u8);
    let x87: u64 = (x85 >> 8);
    let x88: u8 = ((x87 & (0xff as u64)) as u8);
    let x89: u64 = (x87 >> 8);
    let x90: u8 = ((x89 & (0xff as u64)) as u8);
    let x91: u64 = (x89 >> 8);
    let x92: u8 = ((x91 & (0xff as u64)) as u8);
    let x93: u8 = ((x91 >> 8) as u8);
    let x94: u8 = ((x3 & (0xff as u64)) as u8);
    let x95: u64 = (x3 >> 8);
    let x96: u8 = ((x95 & (0xff as u64)) as u8);
    let x97: u64 = (x95 >> 8);
    let x98: u8 = ((x97 & (0xff as u64)) as u8);
    let x99: u64 = (x97 >> 8);
    let x100: u8 = ((x99 & (0xff as u64)) as u8);
    let x101: u64 = (x99 >> 8);
    let x102: u8 = ((x101 & (0xff as u64)) as u8);
    let x103: u64 = (x101 >> 8);
    let x104: u8 = ((x103 & (0xff as u64)) as u8);
    let x105: u64 = (x103 >> 8);
    let x106: u8 = ((x105 & (0xff as u64)) as u8);
    let x107: u8 = ((x105 >> 8) as u8);
    let x108: u8 = ((x2 & (0xff as u64)) as u8);
    let x109: u64 = (x2 >> 8);
    let x110: u8 = ((x109 & (0xff as u64)) as u8);
    let x111: u64 = (x109 >> 8);
    let x112: u8 = ((x111 & (0xff as u64)) as u8);
    let x113: u64 = (x111 >> 8);
    let x114: u8 = ((x113 & (0xff as u64)) as u8);
    let x115: u64 = (x113 >> 8);
    let x116: u8 = ((x115 & (0xff as u64)) as u8);
    let x117: u64 = (x115 >> 8);
    let x118: u8 = ((x117 & (0xff as u64)) as u8);
    let x119: u64 = (x117 >> 8);
    let x120: u8 = ((x119 & (0xff as u64)) as u8);
    let x121: u8 = ((x119 >> 8) as u8);
    let x122: u8 = ((x1 & (0xff as u64)) as u8);
    let x123: fiat_p521_scalar_u1 = ((x1 >> 8) as fiat_p521_scalar_u1);
    *IndexConst(&mut out1).index_mut(0) = x10;
    *IndexConst(&mut out1).index_mut(1) = x12;
    *IndexConst(&mut out1).index_mut(2) = x14;
    *IndexConst(&mut out1).index_mut(3) = x16;
    *IndexConst(&mut out1).index_mut(4) = x18;
    *IndexConst(&mut out1).index_mut(5) = x20;
    *IndexConst(&mut out1).index_mut(6) = x22;
    *IndexConst(&mut out1).index_mut(7) = x23;
    *IndexConst(&mut out1).index_mut(8) = x24;
    *IndexConst(&mut out1).index_mut(9) = x26;
    *IndexConst(&mut out1).index_mut(10) = x28;
    *IndexConst(&mut out1).index_mut(11) = x30;
    *IndexConst(&mut out1).index_mut(12) = x32;
    *IndexConst(&mut out1).index_mut(13) = x34;
    *IndexConst(&mut out1).index_mut(14) = x36;
    *IndexConst(&mut out1).index_mut(15) = x37;
    *IndexConst(&mut out1).index_mut(16) = x38;
    *IndexConst(&mut out1).index_mut(17) = x40;
    *IndexConst(&mut out1).index_mut(18) = x42;
    *IndexConst(&mut out1).index_mut(19) = x44;
    *IndexConst(&mut out1).index_mut(20) = x46;
    *IndexConst(&mut out1).index_mut(21) = x48;
    *IndexConst(&mut out1).index_mut(22) = x50;
    *IndexConst(&mut out1).index_mut(23) = x51;
    *IndexConst(&mut out1).index_mut(24) = x52;
    *IndexConst(&mut out1).index_mut(25) = x54;
    *IndexConst(&mut out1).index_mut(26) = x56;
    *IndexConst(&mut out1).index_mut(27) = x58;
    *IndexConst(&mut out1).index_mut(28) = x60;
    *IndexConst(&mut out1).index_mut(29) = x62;
    *IndexConst(&mut out1).index_mut(30) = x64;
    *IndexConst(&mut out1).index_mut(31) = x65;
    *IndexConst(&mut out1).index_mut(32) = x66;
    *IndexConst(&mut out1).index_mut(33) = x68;
    *IndexConst(&mut out1).index_mut(34) = x70;
    *IndexConst(&mut out1).index_mut(35) = x72;
    *IndexConst(&mut out1).index_mut(36) = x74;
    *IndexConst(&mut out1).index_mut(37) = x76;
    *IndexConst(&mut out1).index_mut(38) = x78;
    *IndexConst(&mut out1).index_mut(39) = x79;
    *IndexConst(&mut out1).index_mut(40) = x80;
    *IndexConst(&mut out1).index_mut(41) = x82;
    *IndexConst(&mut out1).index_mut(42) = x84;
    *IndexConst(&mut out1).index_mut(43) = x86;
    *IndexConst(&mut out1).index_mut(44) = x88;
    *IndexConst(&mut out1).index_mut(45) = x90;
    *IndexConst(&mut out1).index_mut(46) = x92;
    *IndexConst(&mut out1).index_mut(47) = x93;
    *IndexConst(&mut out1).index_mut(48) = x94;
    *IndexConst(&mut out1).index_mut(49) = x96;
    *IndexConst(&mut out1).index_mut(50) = x98;
    *IndexConst(&mut out1).index_mut(51) = x100;
    *IndexConst(&mut out1).index_mut(52) = x102;
    *IndexConst(&mut out1).index_mut(53) = x104;
    *IndexConst(&mut out1).index_mut(54) = x106;
    *IndexConst(&mut out1).index_mut(55) = x107;
    *IndexConst(&mut out1).index_mut(56) = x108;
    *IndexConst(&mut out1).index_mut(57) = x110;
    *IndexConst(&mut out1).index_mut(58) = x112;
    *IndexConst(&mut out1).index_mut(59) = x114;
    *IndexConst(&mut out1).index_mut(60) = x116;
    *IndexConst(&mut out1).index_mut(61) = x118;
    *IndexConst(&mut out1).index_mut(62) = x120;
    *IndexConst(&mut out1).index_mut(63) = x121;
    *IndexConst(&mut out1).index_mut(64) = x122;
    *IndexConst(&mut out1).index_mut(65) = (x123 as u8);
}

/// The function fiat_p521_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0x1ff]]
#[inline]
pub const fn fiat_p521_scalar_from_bytes(mut out1: &mut [u64; 9], arg1: &[u8; 66]) {
    let x1: u64 = ((((*IndexConst(arg1).index(65)) as fiat_p521_scalar_u1) as u64) << 8);
    let x2: u8 = (*IndexConst(arg1).index(64));
    let x3: u64 = (((*IndexConst(arg1).index(63)) as u64) << 56);
    let x4: u64 = (((*IndexConst(arg1).index(62)) as u64) << 48);
    let x5: u64 = (((*IndexConst(arg1).index(61)) as u64) << 40);
    let x6: u64 = (((*IndexConst(arg1).index(60)) as u64) << 32);
    let x7: u64 = (((*IndexConst(arg1).index(59)) as u64) << 24);
    let x8: u64 = (((*IndexConst(arg1).index(58)) as u64) << 16);
    let x9: u64 = (((*IndexConst(arg1).index(57)) as u64) << 8);
    let x10: u8 = (*IndexConst(arg1).index(56));
    let x11: u64 = (((*IndexConst(arg1).index(55)) as u64) << 56);
    let x12: u64 = (((*IndexConst(arg1).index(54)) as u64) << 48);
    let x13: u64 = (((*IndexConst(arg1).index(53)) as u64) << 40);
    let x14: u64 = (((*IndexConst(arg1).index(52)) as u64) << 32);
    let x15: u64 = (((*IndexConst(arg1).index(51)) as u64) << 24);
    let x16: u64 = (((*IndexConst(arg1).index(50)) as u64) << 16);
    let x17: u64 = (((*IndexConst(arg1).index(49)) as u64) << 8);
    let x18: u8 = (*IndexConst(arg1).index(48));
    let x19: u64 = (((*IndexConst(arg1).index(47)) as u64) << 56);
    let x20: u64 = (((*IndexConst(arg1).index(46)) as u64) << 48);
    let x21: u64 = (((*IndexConst(arg1).index(45)) as u64) << 40);
    let x22: u64 = (((*IndexConst(arg1).index(44)) as u64) << 32);
    let x23: u64 = (((*IndexConst(arg1).index(43)) as u64) << 24);
    let x24: u64 = (((*IndexConst(arg1).index(42)) as u64) << 16);
    let x25: u64 = (((*IndexConst(arg1).index(41)) as u64) << 8);
    let x26: u8 = (*IndexConst(arg1).index(40));
    let x27: u64 = (((*IndexConst(arg1).index(39)) as u64) << 56);
    let x28: u64 = (((*IndexConst(arg1).index(38)) as u64) << 48);
    let x29: u64 = (((*IndexConst(arg1).index(37)) as u64) << 40);
    let x30: u64 = (((*IndexConst(arg1).index(36)) as u64) << 32);
    let x31: u64 = (((*IndexConst(arg1).index(35)) as u64) << 24);
    let x32: u64 = (((*IndexConst(arg1).index(34)) as u64) << 16);
    let x33: u64 = (((*IndexConst(arg1).index(33)) as u64) << 8);
    let x34: u8 = (*IndexConst(arg1).index(32));
    let x35: u64 = (((*IndexConst(arg1).index(31)) as u64) << 56);
    let x36: u64 = (((*IndexConst(arg1).index(30)) as u64) << 48);
    let x37: u64 = (((*IndexConst(arg1).index(29)) as u64) << 40);
    let x38: u64 = (((*IndexConst(arg1).index(28)) as u64) << 32);
    let x39: u64 = (((*IndexConst(arg1).index(27)) as u64) << 24);
    let x40: u64 = (((*IndexConst(arg1).index(26)) as u64) << 16);
    let x41: u64 = (((*IndexConst(arg1).index(25)) as u64) << 8);
    let x42: u8 = (*IndexConst(arg1).index(24));
    let x43: u64 = (((*IndexConst(arg1).index(23)) as u64) << 56);
    let x44: u64 = (((*IndexConst(arg1).index(22)) as u64) << 48);
    let x45: u64 = (((*IndexConst(arg1).index(21)) as u64) << 40);
    let x46: u64 = (((*IndexConst(arg1).index(20)) as u64) << 32);
    let x47: u64 = (((*IndexConst(arg1).index(19)) as u64) << 24);
    let x48: u64 = (((*IndexConst(arg1).index(18)) as u64) << 16);
    let x49: u64 = (((*IndexConst(arg1).index(17)) as u64) << 8);
    let x50: u8 = (*IndexConst(arg1).index(16));
    let x51: u64 = (((*IndexConst(arg1).index(15)) as u64) << 56);
    let x52: u64 = (((*IndexConst(arg1).index(14)) as u64) << 48);
    let x53: u64 = (((*IndexConst(arg1).index(13)) as u64) << 40);
    let x54: u64 = (((*IndexConst(arg1).index(12)) as u64) << 32);
    let x55: u64 = (((*IndexConst(arg1).index(11)) as u64) << 24);
    let x56: u64 = (((*IndexConst(arg1).index(10)) as u64) << 16);
    let x57: u64 = (((*IndexConst(arg1).index(9)) as u64) << 8);
    let x58: u8 = (*IndexConst(arg1).index(8));
    let x59: u64 = (((*IndexConst(arg1).index(7)) as u64) << 56);
    let x60: u64 = (((*IndexConst(arg1).index(6)) as u64) << 48);
    let x61: u64 = (((*IndexConst(arg1).index(5)) as u64) << 40);
    let x62: u64 = (((*IndexConst(arg1).index(4)) as u64) << 32);
    let x63: u64 = (((*IndexConst(arg1).index(3)) as u64) << 24);
    let x64: u64 = (((*IndexConst(arg1).index(2)) as u64) << 16);
    let x65: u64 = (((*IndexConst(arg1).index(1)) as u64) << 8);
    let x66: u8 = (*IndexConst(arg1).index(0));
    let x67: u64 = (x65 + (x66 as u64));
    let x68: u64 = (x64 + x67);
    let x69: u64 = (x63 + x68);
    let x70: u64 = (x62 + x69);
    let x71: u64 = (x61 + x70);
    let x72: u64 = (x60 + x71);
    let x73: u64 = (x59 + x72);
    let x74: u64 = (x57 + (x58 as u64));
    let x75: u64 = (x56 + x74);
    let x76: u64 = (x55 + x75);
    let x77: u64 = (x54 + x76);
    let x78: u64 = (x53 + x77);
    let x79: u64 = (x52 + x78);
    let x80: u64 = (x51 + x79);
    let x81: u64 = (x49 + (x50 as u64));
    let x82: u64 = (x48 + x81);
    let x83: u64 = (x47 + x82);
    let x84: u64 = (x46 + x83);
    let x85: u64 = (x45 + x84);
    let x86: u64 = (x44 + x85);
    let x87: u64 = (x43 + x86);
    let x88: u64 = (x41 + (x42 as u64));
    let x89: u64 = (x40 + x88);
    let x90: u64 = (x39 + x89);
    let x91: u64 = (x38 + x90);
    let x92: u64 = (x37 + x91);
    let x93: u64 = (x36 + x92);
    let x94: u64 = (x35 + x93);
    let x95: u64 = (x33 + (x34 as u64));
    let x96: u64 = (x32 + x95);
    let x97: u64 = (x31 + x96);
    let x98: u64 = (x30 + x97);
    let x99: u64 = (x29 + x98);
    let x100: u64 = (x28 + x99);
    let x101: u64 = (x27 + x100);
    let x102: u64 = (x25 + (x26 as u64));
    let x103: u64 = (x24 + x102);
    let x104: u64 = (x23 + x103);
    let x105: u64 = (x22 + x104);
    let x106: u64 = (x21 + x105);
    let x107: u64 = (x20 + x106);
    let x108: u64 = (x19 + x107);
    let x109: u64 = (x17 + (x18 as u64));
    let x110: u64 = (x16 + x109);
    let x111: u64 = (x15 + x110);
    let x112: u64 = (x14 + x111);
    let x113: u64 = (x13 + x112);
    let x114: u64 = (x12 + x113);
    let x115: u64 = (x11 + x114);
    let x116: u64 = (x9 + (x10 as u64));
    let x117: u64 = (x8 + x116);
    let x118: u64 = (x7 + x117);
    let x119: u64 = (x6 + x118);
    let x120: u64 = (x5 + x119);
    let x121: u64 = (x4 + x120);
    let x122: u64 = (x3 + x121);
    let x123: u64 = (x1 + (x2 as u64));
    *IndexConst(&mut out1).index_mut(0) = x73;
    *IndexConst(&mut out1).index_mut(1) = x80;
    *IndexConst(&mut out1).index_mut(2) = x87;
    *IndexConst(&mut out1).index_mut(3) = x94;
    *IndexConst(&mut out1).index_mut(4) = x101;
    *IndexConst(&mut out1).index_mut(5) = x108;
    *IndexConst(&mut out1).index_mut(6) = x115;
    *IndexConst(&mut out1).index_mut(7) = x122;
    *IndexConst(&mut out1).index_mut(8) = x123;
}

/// The function fiat_p521_scalar_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_p521_scalar_set_one(
    mut out1: &mut fiat_p521_scalar_montgomery_domain_field_element,
) {
    *IndexConst(&mut out1).index_mut(0) = 0xfb80000000000000;
    *IndexConst(&mut out1).index_mut(1) = 0x28a2482470b763cd;
    *IndexConst(&mut out1).index_mut(2) = 0x17e2251b23bb31dc;
    *IndexConst(&mut out1).index_mut(3) = 0xca4019ff5b847b2d;
    *IndexConst(&mut out1).index_mut(4) = 0x2d73cbc3e206834;
    *IndexConst(&mut out1).index_mut(5) = (0x0 as u64);
    *IndexConst(&mut out1).index_mut(6) = (0x0 as u64);
    *IndexConst(&mut out1).index_mut(7) = (0x0 as u64);
    *IndexConst(&mut out1).index_mut(8) = (0x0 as u64);
}

/// The function fiat_p521_scalar_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_p521_scalar_msat(mut out1: &mut [u64; 10]) {
    *IndexConst(&mut out1).index_mut(0) = 0xbb6fb71e91386409;
    *IndexConst(&mut out1).index_mut(1) = 0x3bb5c9b8899c47ae;
    *IndexConst(&mut out1).index_mut(2) = 0x7fcc0148f709a5d0;
    *IndexConst(&mut out1).index_mut(3) = 0x51868783bf2f966b;
    *IndexConst(&mut out1).index_mut(4) = 0xfffffffffffffffa;
    *IndexConst(&mut out1).index_mut(5) = 0xffffffffffffffff;
    *IndexConst(&mut out1).index_mut(6) = 0xffffffffffffffff;
    *IndexConst(&mut out1).index_mut(7) = 0xffffffffffffffff;
    *IndexConst(&mut out1).index_mut(8) = 0x1ff;
    *IndexConst(&mut out1).index_mut(9) = (0x0 as u64);
}

/// The function fiat_p521_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_p521_scalar_divstep_precomp(mut out1: &mut [u64; 9]) {
    *IndexConst(&mut out1).index_mut(0) = 0x7b27a0cb33d1884b;
    *IndexConst(&mut out1).index_mut(1) = 0x9ef6cb011f2467d8;
    *IndexConst(&mut out1).index_mut(2) = 0x5fbc88e1d6e7fce;
    *IndexConst(&mut out1).index_mut(3) = 0xb08222d0fe97e1dc;
    *IndexConst(&mut out1).index_mut(4) = 0x1624870c44df3fce;
    *IndexConst(&mut out1).index_mut(5) = 0xb7f07b8eedbce602;
    *IndexConst(&mut out1).index_mut(6) = 0x62da93cf721f63bc;
    *IndexConst(&mut out1).index_mut(7) = 0xafd209c16c4f0d20;
    *IndexConst(&mut out1).index_mut(8) = 0x1c7;
}

/// The function fiat_p521_scalar_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub const fn fiat_p521_scalar_divstep(
    out1: &mut u64,
    mut out2: &mut [u64; 10],
    mut out3: &mut [u64; 10],
    mut out4: &mut [u64; 9],
    mut out5: &mut [u64; 9],
    arg1: u64,
    arg2: &[u64; 10],
    arg3: &[u64; 10],
    arg4: &[u64; 9],
    arg5: &[u64; 9],
) {
    let mut x1: u64 = 0;
    let mut x2: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u64));
    let x3: fiat_p521_scalar_u1 = (((x1 >> 63) as fiat_p521_scalar_u1)
        & (((*IndexConst(arg3).index(0)) & (0x1 as u64)) as fiat_p521_scalar_u1));
    let mut x4: u64 = 0;
    let mut x5: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u64));
    let mut x6: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x6, x3, arg1, x4);
    let mut x7: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x7,
        x3,
        (*IndexConst(arg2).index(0)),
        (*IndexConst(arg3).index(0)),
    );
    let mut x8: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x8,
        x3,
        (*IndexConst(arg2).index(1)),
        (*IndexConst(arg3).index(1)),
    );
    let mut x9: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x9,
        x3,
        (*IndexConst(arg2).index(2)),
        (*IndexConst(arg3).index(2)),
    );
    let mut x10: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x10,
        x3,
        (*IndexConst(arg2).index(3)),
        (*IndexConst(arg3).index(3)),
    );
    let mut x11: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x11,
        x3,
        (*IndexConst(arg2).index(4)),
        (*IndexConst(arg3).index(4)),
    );
    let mut x12: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x12,
        x3,
        (*IndexConst(arg2).index(5)),
        (*IndexConst(arg3).index(5)),
    );
    let mut x13: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x13,
        x3,
        (*IndexConst(arg2).index(6)),
        (*IndexConst(arg3).index(6)),
    );
    let mut x14: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x14,
        x3,
        (*IndexConst(arg2).index(7)),
        (*IndexConst(arg3).index(7)),
    );
    let mut x15: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x15,
        x3,
        (*IndexConst(arg2).index(8)),
        (*IndexConst(arg3).index(8)),
    );
    let mut x16: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x16,
        x3,
        (*IndexConst(arg2).index(9)),
        (*IndexConst(arg3).index(9)),
    );
    let mut x17: u64 = 0;
    let mut x18: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x17,
        &mut x18,
        0x0,
        (0x1 as u64),
        (!(*IndexConst(arg2).index(0))),
    );
    let mut x19: u64 = 0;
    let mut x20: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x19,
        &mut x20,
        x18,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(1))),
    );
    let mut x21: u64 = 0;
    let mut x22: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x21,
        &mut x22,
        x20,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(2))),
    );
    let mut x23: u64 = 0;
    let mut x24: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x23,
        &mut x24,
        x22,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(3))),
    );
    let mut x25: u64 = 0;
    let mut x26: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x25,
        &mut x26,
        x24,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(4))),
    );
    let mut x27: u64 = 0;
    let mut x28: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x27,
        &mut x28,
        x26,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(5))),
    );
    let mut x29: u64 = 0;
    let mut x30: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x29,
        &mut x30,
        x28,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(6))),
    );
    let mut x31: u64 = 0;
    let mut x32: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x31,
        &mut x32,
        x30,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(7))),
    );
    let mut x33: u64 = 0;
    let mut x34: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x33,
        &mut x34,
        x32,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(8))),
    );
    let mut x35: u64 = 0;
    let mut x36: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x35,
        &mut x36,
        x34,
        (0x0 as u64),
        (!(*IndexConst(arg2).index(9))),
    );
    let mut x37: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x37, x3, (*IndexConst(arg3).index(0)), x17);
    let mut x38: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x38, x3, (*IndexConst(arg3).index(1)), x19);
    let mut x39: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x39, x3, (*IndexConst(arg3).index(2)), x21);
    let mut x40: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x40, x3, (*IndexConst(arg3).index(3)), x23);
    let mut x41: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x41, x3, (*IndexConst(arg3).index(4)), x25);
    let mut x42: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x42, x3, (*IndexConst(arg3).index(5)), x27);
    let mut x43: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x43, x3, (*IndexConst(arg3).index(6)), x29);
    let mut x44: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x44, x3, (*IndexConst(arg3).index(7)), x31);
    let mut x45: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x45, x3, (*IndexConst(arg3).index(8)), x33);
    let mut x46: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x46, x3, (*IndexConst(arg3).index(9)), x35);
    let mut x47: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x47,
        x3,
        (*IndexConst(arg4).index(0)),
        (*IndexConst(arg5).index(0)),
    );
    let mut x48: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x48,
        x3,
        (*IndexConst(arg4).index(1)),
        (*IndexConst(arg5).index(1)),
    );
    let mut x49: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x49,
        x3,
        (*IndexConst(arg4).index(2)),
        (*IndexConst(arg5).index(2)),
    );
    let mut x50: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x50,
        x3,
        (*IndexConst(arg4).index(3)),
        (*IndexConst(arg5).index(3)),
    );
    let mut x51: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x51,
        x3,
        (*IndexConst(arg4).index(4)),
        (*IndexConst(arg5).index(4)),
    );
    let mut x52: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x52,
        x3,
        (*IndexConst(arg4).index(5)),
        (*IndexConst(arg5).index(5)),
    );
    let mut x53: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x53,
        x3,
        (*IndexConst(arg4).index(6)),
        (*IndexConst(arg5).index(6)),
    );
    let mut x54: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x54,
        x3,
        (*IndexConst(arg4).index(7)),
        (*IndexConst(arg5).index(7)),
    );
    let mut x55: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(
        &mut x55,
        x3,
        (*IndexConst(arg4).index(8)),
        (*IndexConst(arg5).index(8)),
    );
    let mut x56: u64 = 0;
    let mut x57: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x56, &mut x57, 0x0, x47, x47);
    let mut x58: u64 = 0;
    let mut x59: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x58, &mut x59, x57, x48, x48);
    let mut x60: u64 = 0;
    let mut x61: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x60, &mut x61, x59, x49, x49);
    let mut x62: u64 = 0;
    let mut x63: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x62, &mut x63, x61, x50, x50);
    let mut x64: u64 = 0;
    let mut x65: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x64, &mut x65, x63, x51, x51);
    let mut x66: u64 = 0;
    let mut x67: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x66, &mut x67, x65, x52, x52);
    let mut x68: u64 = 0;
    let mut x69: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x68, &mut x69, x67, x53, x53);
    let mut x70: u64 = 0;
    let mut x71: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x70, &mut x71, x69, x54, x54);
    let mut x72: u64 = 0;
    let mut x73: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x72, &mut x73, x71, x55, x55);
    let mut x74: u64 = 0;
    let mut x75: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x74, &mut x75, 0x0, x56, 0xbb6fb71e91386409);
    let mut x76: u64 = 0;
    let mut x77: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x76, &mut x77, x75, x58, 0x3bb5c9b8899c47ae);
    let mut x78: u64 = 0;
    let mut x79: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x78, &mut x79, x77, x60, 0x7fcc0148f709a5d0);
    let mut x80: u64 = 0;
    let mut x81: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x80, &mut x81, x79, x62, 0x51868783bf2f966b);
    let mut x82: u64 = 0;
    let mut x83: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x82, &mut x83, x81, x64, 0xfffffffffffffffa);
    let mut x84: u64 = 0;
    let mut x85: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x84, &mut x85, x83, x66, 0xffffffffffffffff);
    let mut x86: u64 = 0;
    let mut x87: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x86, &mut x87, x85, x68, 0xffffffffffffffff);
    let mut x88: u64 = 0;
    let mut x89: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x88, &mut x89, x87, x70, 0xffffffffffffffff);
    let mut x90: u64 = 0;
    let mut x91: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x90, &mut x91, x89, x72, 0x1ff);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x92, &mut x93, x91, (x73 as u64), (0x0 as u64));
    let x94: u64 = (*IndexConst(arg4).index(8));
    let x95: u64 = (*IndexConst(arg4).index(7));
    let x96: u64 = (*IndexConst(arg4).index(6));
    let x97: u64 = (*IndexConst(arg4).index(5));
    let x98: u64 = (*IndexConst(arg4).index(4));
    let x99: u64 = (*IndexConst(arg4).index(3));
    let x100: u64 = (*IndexConst(arg4).index(2));
    let x101: u64 = (*IndexConst(arg4).index(1));
    let x102: u64 = (*IndexConst(arg4).index(0));
    let mut x103: u64 = 0;
    let mut x104: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x103, &mut x104, 0x0, (0x0 as u64), x102);
    let mut x105: u64 = 0;
    let mut x106: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x105, &mut x106, x104, (0x0 as u64), x101);
    let mut x107: u64 = 0;
    let mut x108: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x107, &mut x108, x106, (0x0 as u64), x100);
    let mut x109: u64 = 0;
    let mut x110: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x109, &mut x110, x108, (0x0 as u64), x99);
    let mut x111: u64 = 0;
    let mut x112: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x111, &mut x112, x110, (0x0 as u64), x98);
    let mut x113: u64 = 0;
    let mut x114: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x113, &mut x114, x112, (0x0 as u64), x97);
    let mut x115: u64 = 0;
    let mut x116: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x115, &mut x116, x114, (0x0 as u64), x96);
    let mut x117: u64 = 0;
    let mut x118: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x117, &mut x118, x116, (0x0 as u64), x95);
    let mut x119: u64 = 0;
    let mut x120: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x119, &mut x120, x118, (0x0 as u64), x94);
    let mut x121: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x121, x120, (0x0 as u64), 0xffffffffffffffff);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x122, &mut x123, 0x0, x103, (x121 & 0xbb6fb71e91386409));
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x124,
        &mut x125,
        x123,
        x105,
        (x121 & 0x3bb5c9b8899c47ae),
    );
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x126,
        &mut x127,
        x125,
        x107,
        (x121 & 0x7fcc0148f709a5d0),
    );
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x128,
        &mut x129,
        x127,
        x109,
        (x121 & 0x51868783bf2f966b),
    );
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(
        &mut x130,
        &mut x131,
        x129,
        x111,
        (x121 & 0xfffffffffffffffa),
    );
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x132, &mut x133, x131, x113, x121);
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x134, &mut x135, x133, x115, x121);
    let mut x136: u64 = 0;
    let mut x137: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x136, &mut x137, x135, x117, x121);
    let mut x138: u64 = 0;
    let mut x139: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x138, &mut x139, x137, x119, (x121 & 0x1ff));
    let mut x140: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x140, x3, (*IndexConst(arg5).index(0)), x122);
    let mut x141: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x141, x3, (*IndexConst(arg5).index(1)), x124);
    let mut x142: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x142, x3, (*IndexConst(arg5).index(2)), x126);
    let mut x143: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x143, x3, (*IndexConst(arg5).index(3)), x128);
    let mut x144: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x144, x3, (*IndexConst(arg5).index(4)), x130);
    let mut x145: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x145, x3, (*IndexConst(arg5).index(5)), x132);
    let mut x146: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x146, x3, (*IndexConst(arg5).index(6)), x134);
    let mut x147: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x147, x3, (*IndexConst(arg5).index(7)), x136);
    let mut x148: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x148, x3, (*IndexConst(arg5).index(8)), x138);
    let x149: fiat_p521_scalar_u1 = ((x37 & (0x1 as u64)) as fiat_p521_scalar_u1);
    let mut x150: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x150, x149, (0x0 as u64), x7);
    let mut x151: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x151, x149, (0x0 as u64), x8);
    let mut x152: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x152, x149, (0x0 as u64), x9);
    let mut x153: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x153, x149, (0x0 as u64), x10);
    let mut x154: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x154, x149, (0x0 as u64), x11);
    let mut x155: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x155, x149, (0x0 as u64), x12);
    let mut x156: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x156, x149, (0x0 as u64), x13);
    let mut x157: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x157, x149, (0x0 as u64), x14);
    let mut x158: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x158, x149, (0x0 as u64), x15);
    let mut x159: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x159, x149, (0x0 as u64), x16);
    let mut x160: u64 = 0;
    let mut x161: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x160, &mut x161, 0x0, x37, x150);
    let mut x162: u64 = 0;
    let mut x163: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x162, &mut x163, x161, x38, x151);
    let mut x164: u64 = 0;
    let mut x165: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x164, &mut x165, x163, x39, x152);
    let mut x166: u64 = 0;
    let mut x167: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x166, &mut x167, x165, x40, x153);
    let mut x168: u64 = 0;
    let mut x169: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x168, &mut x169, x167, x41, x154);
    let mut x170: u64 = 0;
    let mut x171: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x170, &mut x171, x169, x42, x155);
    let mut x172: u64 = 0;
    let mut x173: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x172, &mut x173, x171, x43, x156);
    let mut x174: u64 = 0;
    let mut x175: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x174, &mut x175, x173, x44, x157);
    let mut x176: u64 = 0;
    let mut x177: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x176, &mut x177, x175, x45, x158);
    let mut x178: u64 = 0;
    let mut x179: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x178, &mut x179, x177, x46, x159);
    let mut x180: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x180, x149, (0x0 as u64), x47);
    let mut x181: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x181, x149, (0x0 as u64), x48);
    let mut x182: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x182, x149, (0x0 as u64), x49);
    let mut x183: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x183, x149, (0x0 as u64), x50);
    let mut x184: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x184, x149, (0x0 as u64), x51);
    let mut x185: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x185, x149, (0x0 as u64), x52);
    let mut x186: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x186, x149, (0x0 as u64), x53);
    let mut x187: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x187, x149, (0x0 as u64), x54);
    let mut x188: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x188, x149, (0x0 as u64), x55);
    let mut x189: u64 = 0;
    let mut x190: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x189, &mut x190, 0x0, x140, x180);
    let mut x191: u64 = 0;
    let mut x192: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x191, &mut x192, x190, x141, x181);
    let mut x193: u64 = 0;
    let mut x194: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x193, &mut x194, x192, x142, x182);
    let mut x195: u64 = 0;
    let mut x196: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x195, &mut x196, x194, x143, x183);
    let mut x197: u64 = 0;
    let mut x198: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x197, &mut x198, x196, x144, x184);
    let mut x199: u64 = 0;
    let mut x200: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x199, &mut x200, x198, x145, x185);
    let mut x201: u64 = 0;
    let mut x202: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x201, &mut x202, x200, x146, x186);
    let mut x203: u64 = 0;
    let mut x204: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x203, &mut x204, x202, x147, x187);
    let mut x205: u64 = 0;
    let mut x206: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x205, &mut x206, x204, x148, x188);
    let mut x207: u64 = 0;
    let mut x208: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x207, &mut x208, 0x0, x189, 0xbb6fb71e91386409);
    let mut x209: u64 = 0;
    let mut x210: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x209, &mut x210, x208, x191, 0x3bb5c9b8899c47ae);
    let mut x211: u64 = 0;
    let mut x212: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x211, &mut x212, x210, x193, 0x7fcc0148f709a5d0);
    let mut x213: u64 = 0;
    let mut x214: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x213, &mut x214, x212, x195, 0x51868783bf2f966b);
    let mut x215: u64 = 0;
    let mut x216: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x215, &mut x216, x214, x197, 0xfffffffffffffffa);
    let mut x217: u64 = 0;
    let mut x218: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x217, &mut x218, x216, x199, 0xffffffffffffffff);
    let mut x219: u64 = 0;
    let mut x220: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x219, &mut x220, x218, x201, 0xffffffffffffffff);
    let mut x221: u64 = 0;
    let mut x222: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x221, &mut x222, x220, x203, 0xffffffffffffffff);
    let mut x223: u64 = 0;
    let mut x224: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x223, &mut x224, x222, x205, 0x1ff);
    let mut x225: u64 = 0;
    let mut x226: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_subborrowx_u64(&mut x225, &mut x226, x224, (x206 as u64), (0x0 as u64));
    let mut x227: u64 = 0;
    let mut x228: fiat_p521_scalar_u1 = 0;
    fiat_p521_scalar_addcarryx_u64(&mut x227, &mut x228, 0x0, x6, (0x1 as u64));
    let x229: u64 = ((x160 >> 1) | ((x162 << 63) & 0xffffffffffffffff));
    let x230: u64 = ((x162 >> 1) | ((x164 << 63) & 0xffffffffffffffff));
    let x231: u64 = ((x164 >> 1) | ((x166 << 63) & 0xffffffffffffffff));
    let x232: u64 = ((x166 >> 1) | ((x168 << 63) & 0xffffffffffffffff));
    let x233: u64 = ((x168 >> 1) | ((x170 << 63) & 0xffffffffffffffff));
    let x234: u64 = ((x170 >> 1) | ((x172 << 63) & 0xffffffffffffffff));
    let x235: u64 = ((x172 >> 1) | ((x174 << 63) & 0xffffffffffffffff));
    let x236: u64 = ((x174 >> 1) | ((x176 << 63) & 0xffffffffffffffff));
    let x237: u64 = ((x176 >> 1) | ((x178 << 63) & 0xffffffffffffffff));
    let x238: u64 = ((x178 & 0x8000000000000000) | (x178 >> 1));
    let mut x239: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x239, x93, x74, x56);
    let mut x240: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x240, x93, x76, x58);
    let mut x241: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x241, x93, x78, x60);
    let mut x242: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x242, x93, x80, x62);
    let mut x243: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x243, x93, x82, x64);
    let mut x244: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x244, x93, x84, x66);
    let mut x245: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x245, x93, x86, x68);
    let mut x246: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x246, x93, x88, x70);
    let mut x247: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x247, x93, x90, x72);
    let mut x248: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x248, x226, x207, x189);
    let mut x249: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x249, x226, x209, x191);
    let mut x250: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x250, x226, x211, x193);
    let mut x251: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x251, x226, x213, x195);
    let mut x252: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x252, x226, x215, x197);
    let mut x253: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x253, x226, x217, x199);
    let mut x254: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x254, x226, x219, x201);
    let mut x255: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x255, x226, x221, x203);
    let mut x256: u64 = 0;
    fiat_p521_scalar_cmovznz_u64(&mut x256, x226, x223, x205);
    *out1 = x227;
    *IndexConst(&mut out2).index_mut(0) = x7;
    *IndexConst(&mut out2).index_mut(1) = x8;
    *IndexConst(&mut out2).index_mut(2) = x9;
    *IndexConst(&mut out2).index_mut(3) = x10;
    *IndexConst(&mut out2).index_mut(4) = x11;
    *IndexConst(&mut out2).index_mut(5) = x12;
    *IndexConst(&mut out2).index_mut(6) = x13;
    *IndexConst(&mut out2).index_mut(7) = x14;
    *IndexConst(&mut out2).index_mut(8) = x15;
    *IndexConst(&mut out2).index_mut(9) = x16;
    *IndexConst(&mut out3).index_mut(0) = x229;
    *IndexConst(&mut out3).index_mut(1) = x230;
    *IndexConst(&mut out3).index_mut(2) = x231;
    *IndexConst(&mut out3).index_mut(3) = x232;
    *IndexConst(&mut out3).index_mut(4) = x233;
    *IndexConst(&mut out3).index_mut(5) = x234;
    *IndexConst(&mut out3).index_mut(6) = x235;
    *IndexConst(&mut out3).index_mut(7) = x236;
    *IndexConst(&mut out3).index_mut(8) = x237;
    *IndexConst(&mut out3).index_mut(9) = x238;
    *IndexConst(&mut out4).index_mut(0) = x239;
    *IndexConst(&mut out4).index_mut(1) = x240;
    *IndexConst(&mut out4).index_mut(2) = x241;
    *IndexConst(&mut out4).index_mut(3) = x242;
    *IndexConst(&mut out4).index_mut(4) = x243;
    *IndexConst(&mut out4).index_mut(5) = x244;
    *IndexConst(&mut out4).index_mut(6) = x245;
    *IndexConst(&mut out4).index_mut(7) = x246;
    *IndexConst(&mut out4).index_mut(8) = x247;
    *IndexConst(&mut out5).index_mut(0) = x248;
    *IndexConst(&mut out5).index_mut(1) = x249;
    *IndexConst(&mut out5).index_mut(2) = x250;
    *IndexConst(&mut out5).index_mut(3) = x251;
    *IndexConst(&mut out5).index_mut(4) = x252;
    *IndexConst(&mut out5).index_mut(5) = x253;
    *IndexConst(&mut out5).index_mut(6) = x254;
    *IndexConst(&mut out5).index_mut(7) = x255;
    *IndexConst(&mut out5).index_mut(8) = x256;
}
