use openh264::Error;
use openh264::decoder::Decoder;

#[cfg(feature = "source")]
fn main() -> Result<(), Error> {
    let h264_packets = &include_bytes!("../tests/data/multi_512x512.h264")[..];
    let mut rgb = vec![0; 512 * 512 * 3];

    let mut decoder = Decoder::new()?;
    let image = decoder.decode(h264_packets)?.ok_or_else(|| Error::msg("Must have image"))?;

    image.write_rgb8(&mut rgb);

    Ok(())
}

#[cfg(not(feature = "source"))]
fn main() {}
