/* automatically generated by rust-bindgen 0.71.1 */

#[doc = "< rgb color formats"]
pub const videoFormatRGB: EVideoFormatType = 1;
pub const videoFormatRGBA: EVideoFormatType = 2;
pub const videoFormatRGB555: EVideoFormatType = 3;
pub const videoFormatRGB565: EVideoFormatType = 4;
pub const videoFormatBGR: EVideoFormatType = 5;
pub const videoFormatBGRA: EVideoFormatType = 6;
pub const videoFormatABGR: EVideoFormatType = 7;
pub const videoFormatARGB: EVideoFormatType = 8;
#[doc = "< yuv color formats"]
pub const videoFormatYUY2: EVideoFormatType = 20;
pub const videoFormatYVYU: EVideoFormatType = 21;
pub const videoFormatUYVY: EVideoFormatType = 22;
#[doc = "< the same as IYUV"]
pub const videoFormatI420: EVideoFormatType = 23;
pub const videoFormatYV12: EVideoFormatType = 24;
#[doc = "< only used in SVC decoder testbed"]
pub const videoFormatInternal: EVideoFormatType = 25;
#[doc = "< new format for output by DXVA decoding"]
pub const videoFormatNV12: EVideoFormatType = 26;
pub const videoFormatVFlip: EVideoFormatType = -2147483648;
#[doc = " @brief Enumerate the type of video format"]
pub type EVideoFormatType = ::std::os::raw::c_int;
#[doc = "< encoder not ready or parameters are invalidate"]
pub const videoFrameTypeInvalid: EVideoFrameType = 0;
#[doc = "< IDR frame in H.264"]
pub const videoFrameTypeIDR: EVideoFrameType = 1;
#[doc = "< I frame type"]
pub const videoFrameTypeI: EVideoFrameType = 2;
#[doc = "< P frame type"]
pub const videoFrameTypeP: EVideoFrameType = 3;
#[doc = "< skip the frame based encoder kernel"]
pub const videoFrameTypeSkip: EVideoFrameType = 4;
#[doc = "< a frame where I and P slices are mixing, not supported yet"]
pub const videoFrameTypeIPMixed: EVideoFrameType = 5;
#[doc = " @brief Enumerate  video frame type"]
pub type EVideoFrameType = ::std::os::raw::c_int;
#[doc = "< successful"]
pub const cmResultSuccess: CM_RETURN = 0;
#[doc = "< parameters are invalid"]
pub const cmInitParaError: CM_RETURN = 1;
pub const cmUnknownReason: CM_RETURN = 2;
#[doc = "< malloc a memory error"]
pub const cmMallocMemeError: CM_RETURN = 3;
#[doc = "< initial action is expected"]
pub const cmInitExpected: CM_RETURN = 4;
pub const cmUnsupportedData: CM_RETURN = 5;
#[doc = " @brief Enumerate  return type"]
pub type CM_RETURN = ::std::os::raw::c_int;
pub const NAL_UNKNOWN: ENalUnitType = 0;
pub const NAL_SLICE: ENalUnitType = 1;
pub const NAL_SLICE_DPA: ENalUnitType = 2;
pub const NAL_SLICE_DPB: ENalUnitType = 3;
pub const NAL_SLICE_DPC: ENalUnitType = 4;
#[doc = "< ref_idc != 0"]
pub const NAL_SLICE_IDR: ENalUnitType = 5;
#[doc = "< ref_idc == 0"]
pub const NAL_SEI: ENalUnitType = 6;
pub const NAL_SPS: ENalUnitType = 7;
pub const NAL_PPS: ENalUnitType = 8;
#[doc = " @brief Enumulate the nal unit type"]
pub type ENalUnitType = ::std::os::raw::c_int;
pub const NAL_PRIORITY_DISPOSABLE: ENalPriority = 0;
pub const NAL_PRIORITY_LOW: ENalPriority = 1;
pub const NAL_PRIORITY_HIGH: ENalPriority = 2;
pub const NAL_PRIORITY_HIGHEST: ENalPriority = 3;
#[doc = " @brief NRI: eNalRefIdc"]
pub type ENalPriority = ::std::os::raw::c_int;
pub const DEBLOCKING_IDC_0: _bindgen_ty_1 = 0;
pub const DEBLOCKING_IDC_1: _bindgen_ty_1 = 1;
pub const DEBLOCKING_IDC_2: _bindgen_ty_1 = 2;
#[doc = " @brief eDeblockingIdc"]
pub type _bindgen_ty_1 = ::std::os::raw::c_int;
pub type ERR_TOOL = ::std::os::raw::c_ushort;
#[doc = "< NONE Error Tools"]
pub const ET_NONE: _bindgen_ty_2 = 0;
#[doc = "< IP Scalable"]
pub const ET_IP_SCALE: _bindgen_ty_2 = 1;
#[doc = "< Flexible Macroblock Ordering"]
pub const ET_FMO: _bindgen_ty_2 = 2;
#[doc = "< Intra Refresh in predifined 2% MB"]
pub const ET_IR_R1: _bindgen_ty_2 = 4;
#[doc = "< Intra Refresh in predifined 5% MB"]
pub const ET_IR_R2: _bindgen_ty_2 = 8;
#[doc = "< Intra Refresh in predifined 10% MB"]
pub const ET_IR_R3: _bindgen_ty_2 = 16;
#[doc = "< Forward Error Correction in 50% redundency mode"]
pub const ET_FEC_HALF: _bindgen_ty_2 = 32;
#[doc = "< Forward Error Correction in 100% redundency mode"]
pub const ET_FEC_FULL: _bindgen_ty_2 = 64;
#[doc = "< Reference Frame Selection"]
pub const ET_RFS: _bindgen_ty_2 = 128;
#[doc = "@brief to do"]
pub type _bindgen_ty_2 = ::std::os::raw::c_int;
#[doc = " @brief Information of coded Slice(=NAL)(s)"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SliceInformation {
    #[doc = "< base buffer of coded slice(s)"]
    pub pBufferOfSlices: *mut ::std::os::raw::c_uchar,
    #[doc = "< number of coded slices"]
    pub iCodedSliceCount: ::std::os::raw::c_int,
    #[doc = "< array of slices length accordingly by number of slice"]
    pub pLengthOfSlices: *mut ::std::os::raw::c_uint,
    #[doc = "< FEC type[0, 50%FEC, 100%FEC]"]
    pub iFecType: ::std::os::raw::c_int,
    #[doc = "< index of slice in frame [FMO: 0,..,uiSliceCount-1; No FMO: 0]"]
    pub uiSliceIdx: ::std::os::raw::c_uchar,
    #[doc = "< count number of slice in frame [FMO: 2-8; No FMO: 1]"]
    pub uiSliceCount: ::std::os::raw::c_uchar,
    #[doc = "< index of frame[-1, .., idr_interval-1]"]
    pub iFrameIndex: ::std::os::raw::c_char,
    #[doc = "< NRI, priority level of slice(NAL)"]
    pub uiNalRefIdc: ::std::os::raw::c_uchar,
    #[doc = "< NAL type"]
    pub uiNalType: ::std::os::raw::c_uchar,
    #[doc = "< whether final NAL is involved in buffer of coded slices, flag used in Pause feature in T27"]
    pub uiContainingFinalNal: ::std::os::raw::c_uchar,
}
impl Default for SliceInformation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief Information of coded Slice(=NAL)(s)"]
pub type SliceInfo = SliceInformation;
#[doc = " @brief Information of coded Slice(=NAL)(s)"]
pub type PSliceInfo = *mut SliceInformation;
#[doc = " @brief thresholds of the initial, maximal and minimal rate"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SRateThresholds {
    #[doc = "< frame width"]
    pub iWidth: ::std::os::raw::c_int,
    #[doc = "< frame height"]
    pub iHeight: ::std::os::raw::c_int,
    #[doc = "< threshold of initial rate"]
    pub iThresholdOfInitRate: ::std::os::raw::c_int,
    #[doc = "< threshold of maximal rate"]
    pub iThresholdOfMaxRate: ::std::os::raw::c_int,
    #[doc = "< threshold of minimal rate"]
    pub iThresholdOfMinRate: ::std::os::raw::c_int,
    #[doc = "< min frame rate min"]
    pub iMinThresholdFrameRate: ::std::os::raw::c_int,
    #[doc = "< skip to frame rate min"]
    pub iSkipFrameRate: ::std::os::raw::c_int,
    #[doc = "< how many frames to skip"]
    pub iSkipFrameStep: ::std::os::raw::c_int,
}
#[doc = " @brief thresholds of the initial, maximal and minimal rate"]
pub type PRateThresholds = *mut SRateThresholds;
#[doc = " @brief  Structure for decoder memery"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagSysMemBuffer {
    #[doc = "< width of decoded pic for display"]
    pub iWidth: ::std::os::raw::c_int,
    #[doc = "< height of decoded pic for display"]
    pub iHeight: ::std::os::raw::c_int,
    #[doc = "< type is \"EVideoFormatType\""]
    pub iFormat: ::std::os::raw::c_int,
    #[doc = "< stride of 2 component"]
    pub iStride: [::std::os::raw::c_int; 2usize],
}
#[doc = " @brief  Structure for decoder memery"]
pub type SSysMEMBuffer = TagSysMemBuffer;
#[doc = " @brief  Buffer info"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TagBufferInfo {
    #[doc = "< 0: one frame data is not ready; 1: one frame data is ready"]
    pub iBufferStatus: ::std::os::raw::c_int,
    #[doc = "< input BS timestamp"]
    pub uiInBsTimeStamp: ::std::os::raw::c_ulonglong,
    #[doc = "< output YUV timestamp, when bufferstatus is 1"]
    pub uiOutYuvTimeStamp: ::std::os::raw::c_ulonglong,
    #[doc = "<  output buffer info"]
    pub UsrData: TagBufferInfo__bindgen_ty_1,
    pub pDst: [*mut ::std::os::raw::c_uchar; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TagBufferInfo__bindgen_ty_1 {
    #[doc = "<  memory info for one picture"]
    pub sSystemBuffer: SSysMEMBuffer,
}
impl Default for TagBufferInfo__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for TagBufferInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief  Buffer info"]
pub type SBufferInfo = TagBufferInfo;
#[doc = " @brief Struct of OpenH264 version\n/\n///\n/// E.g. SDK version is 1.2.0.0, major version number is 1, minor version number is 2, and revision number is 0."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _tagVersion {
    #[doc = "< The major version number"]
    pub uMajor: ::std::os::raw::c_uint,
    #[doc = "< The minor version number"]
    pub uMinor: ::std::os::raw::c_uint,
    #[doc = "< The revision number"]
    pub uRevision: ::std::os::raw::c_uint,
    #[doc = "< The reserved number, it should be 0."]
    pub uReserved: ::std::os::raw::c_uint,
}
#[doc = " @brief Struct of OpenH264 version\n/\n///\n/// E.g. SDK version is 1.2.0.0, major version number is 1, minor version number is 2, and revision number is 0."]
pub type OpenH264Version = _tagVersion;
#[doc = "< bit stream error-free"]
pub const dsErrorFree: DECODING_STATE = 0;
#[doc = "< need more throughput to generate a frame output,"]
pub const dsFramePending: DECODING_STATE = 1;
#[doc = "< layer lost at reference frame with temporal id 0"]
pub const dsRefLost: DECODING_STATE = 2;
#[doc = "< error bitstreams(maybe broken internal frame) the decoder cared"]
pub const dsBitstreamError: DECODING_STATE = 4;
#[doc = "< dependented layer is ever lost"]
pub const dsDepLayerLost: DECODING_STATE = 8;
#[doc = "< no parameter set NALs involved"]
pub const dsNoParamSets: DECODING_STATE = 16;
#[doc = "< current data error concealed specified"]
pub const dsDataErrorConcealed: DECODING_STATE = 32;
#[doc = "<ref picure list contains null ptrs within uiRefCount range"]
pub const dsRefListNullPtrs: DECODING_STATE = 64;
#[doc = "< invalid argument specified"]
pub const dsInvalidArgument: DECODING_STATE = 4096;
#[doc = "< initializing operation is expected"]
pub const dsInitialOptExpected: DECODING_STATE = 8192;
#[doc = "< out of memory due to new request"]
pub const dsOutOfMemory: DECODING_STATE = 16384;
#[doc = "< actual picture size exceeds size of dst pBuffer feed in decoder, so need expand its size"]
pub const dsDstBufNeedExpan: DECODING_STATE = 32768;
#[doc = " @brief Decoding status"]
pub type DECODING_STATE = ::std::os::raw::c_int;
pub const ENCODER_OPTION_DATAFORMAT: ENCODER_OPTION = 0;
#[doc = "< IDR period,0/-1 means no Intra period (only the first frame); lager than 0 means the desired IDR period, must be multiple of (2^temporal_layer)"]
pub const ENCODER_OPTION_IDR_INTERVAL: ENCODER_OPTION = 1;
#[doc = "< structure of Base Param"]
pub const ENCODER_OPTION_SVC_ENCODE_PARAM_BASE: ENCODER_OPTION = 2;
#[doc = "< structure of Extension Param"]
pub const ENCODER_OPTION_SVC_ENCODE_PARAM_EXT: ENCODER_OPTION = 3;
#[doc = "< maximal input frame rate, current supported range: MAX_FRAME_RATE = 30,MIN_FRAME_RATE = 1"]
pub const ENCODER_OPTION_FRAME_RATE: ENCODER_OPTION = 4;
pub const ENCODER_OPTION_BITRATE: ENCODER_OPTION = 5;
pub const ENCODER_OPTION_MAX_BITRATE: ENCODER_OPTION = 6;
pub const ENCODER_OPTION_INTER_SPATIAL_PRED: ENCODER_OPTION = 7;
pub const ENCODER_OPTION_RC_MODE: ENCODER_OPTION = 8;
pub const ENCODER_OPTION_RC_FRAME_SKIP: ENCODER_OPTION = 9;
#[doc = "< 0:disable padding;1:padding"]
pub const ENCODER_PADDING_PADDING: ENCODER_OPTION = 10;
#[doc = "< assgin the profile for each layer"]
pub const ENCODER_OPTION_PROFILE: ENCODER_OPTION = 11;
#[doc = "< assgin the level for each layer"]
pub const ENCODER_OPTION_LEVEL: ENCODER_OPTION = 12;
#[doc = "< the number of refererence frame"]
pub const ENCODER_OPTION_NUMBER_REF: ENCODER_OPTION = 13;
#[doc = "< the delivery info which is a feedback from app level"]
pub const ENCODER_OPTION_DELIVERY_STATUS: ENCODER_OPTION = 14;
pub const ENCODER_LTR_RECOVERY_REQUEST: ENCODER_OPTION = 15;
pub const ENCODER_LTR_MARKING_FEEDBACK: ENCODER_OPTION = 16;
pub const ENCODER_LTR_MARKING_PERIOD: ENCODER_OPTION = 17;
#[doc = "< 0:disable LTR;larger than 0 enable LTR; LTR number is fixed to be 2 in current encoder"]
pub const ENCODER_OPTION_LTR: ENCODER_OPTION = 18;
pub const ENCODER_OPTION_COMPLEXITY: ENCODER_OPTION = 19;
#[doc = "< enable SSEI: true--enable ssei; false--disable ssei"]
pub const ENCODER_OPTION_ENABLE_SSEI: ENCODER_OPTION = 20;
#[doc = "< enable prefix: true--enable prefix; false--disable prefix"]
pub const ENCODER_OPTION_ENABLE_PREFIX_NAL_ADDING: ENCODER_OPTION = 21;
#[doc = "< different stategy in adjust ID in SPS/PPS: 0- constant ID, 1-additional ID, 6-mapping and additional"]
pub const ENCODER_OPTION_SPS_PPS_ID_STRATEGY: ENCODER_OPTION = 22;
pub const ENCODER_OPTION_CURRENT_PATH: ENCODER_OPTION = 23;
#[doc = "< dump layer reconstruct frame to a specified file"]
pub const ENCODER_OPTION_DUMP_FILE: ENCODER_OPTION = 24;
#[doc = "< trace info based on the trace level"]
pub const ENCODER_OPTION_TRACE_LEVEL: ENCODER_OPTION = 25;
#[doc = "< a void (*)(void* context, int level, const char* message) function which receives log messages"]
pub const ENCODER_OPTION_TRACE_CALLBACK: ENCODER_OPTION = 26;
#[doc = "< context info of trace callback"]
pub const ENCODER_OPTION_TRACE_CALLBACK_CONTEXT: ENCODER_OPTION = 27;
#[doc = "< read only"]
pub const ENCODER_OPTION_GET_STATISTICS: ENCODER_OPTION = 28;
#[doc = "< log interval in millisecond"]
pub const ENCODER_OPTION_STATISTICS_LOG_INTERVAL: ENCODER_OPTION = 29;
#[doc = "< advanced algorithmetic settings"]
pub const ENCODER_OPTION_IS_LOSSLESS_LINK: ENCODER_OPTION = 30;
#[doc = "< bit vary percentage"]
pub const ENCODER_OPTION_BITS_VARY_PERCENTAGE: ENCODER_OPTION = 31;
#[doc = " @brief Option types introduced in SVC encoder application"]
pub type ENCODER_OPTION = ::std::os::raw::c_int;
#[doc = "< end of stream flag"]
pub const DECODER_OPTION_END_OF_STREAM: DECODER_OPTION = 1;
#[doc = "< feedback whether or not have VCL NAL in current AU for application layer"]
pub const DECODER_OPTION_VCL_NAL: DECODER_OPTION = 2;
#[doc = "< feedback temporal id for application layer"]
pub const DECODER_OPTION_TEMPORAL_ID: DECODER_OPTION = 3;
#[doc = "< feedback current decoded frame number"]
pub const DECODER_OPTION_FRAME_NUM: DECODER_OPTION = 4;
#[doc = "< feedback current frame belong to which IDR period"]
pub const DECODER_OPTION_IDR_PIC_ID: DECODER_OPTION = 5;
#[doc = "< feedback wether current frame mark a LTR"]
pub const DECODER_OPTION_LTR_MARKING_FLAG: DECODER_OPTION = 6;
#[doc = "< feedback frame num marked by current Frame"]
pub const DECODER_OPTION_LTR_MARKED_FRAME_NUM: DECODER_OPTION = 7;
#[doc = "< indicate decoder error concealment method"]
pub const DECODER_OPTION_ERROR_CON_IDC: DECODER_OPTION = 8;
pub const DECODER_OPTION_TRACE_LEVEL: DECODER_OPTION = 9;
#[doc = "< a void (*)(void* context, int level, const char* message) function which receives log messages"]
pub const DECODER_OPTION_TRACE_CALLBACK: DECODER_OPTION = 10;
#[doc = "< context info of trace callbac"]
pub const DECODER_OPTION_TRACE_CALLBACK_CONTEXT: DECODER_OPTION = 11;
#[doc = "< feedback decoder statistics"]
pub const DECODER_OPTION_GET_STATISTICS: DECODER_OPTION = 12;
#[doc = "< feedback decoder Sample Aspect Ratio info in Vui"]
pub const DECODER_OPTION_GET_SAR_INFO: DECODER_OPTION = 13;
#[doc = "< get current AU profile info, only is used in GetOption"]
pub const DECODER_OPTION_PROFILE: DECODER_OPTION = 14;
#[doc = "< get current AU level info,only is used in GetOption"]
pub const DECODER_OPTION_LEVEL: DECODER_OPTION = 15;
#[doc = "< set log output interval"]
pub const DECODER_OPTION_STATISTICS_LOG_INTERVAL: DECODER_OPTION = 16;
#[doc = "< feedback current frame is ref pic or not"]
pub const DECODER_OPTION_IS_REF_PIC: DECODER_OPTION = 17;
#[doc = "< number of frames remaining in decoder buffer when pictures are required to re-ordered into display-order."]
pub const DECODER_OPTION_NUM_OF_FRAMES_REMAINING_IN_BUFFER: DECODER_OPTION = 18;
#[doc = "< number of decoding threads. The maximum thread count is equal or less than lesser of (cpu core counts and 16)."]
pub const DECODER_OPTION_NUM_OF_THREADS: DECODER_OPTION = 19;
#[doc = " @brief Option types introduced in decoder application"]
pub type DECODER_OPTION = ::std::os::raw::c_int;
pub const ERROR_CON_DISABLE: ERROR_CON_IDC = 0;
pub const ERROR_CON_FRAME_COPY: ERROR_CON_IDC = 1;
pub const ERROR_CON_SLICE_COPY: ERROR_CON_IDC = 2;
pub const ERROR_CON_FRAME_COPY_CROSS_IDR: ERROR_CON_IDC = 3;
pub const ERROR_CON_SLICE_COPY_CROSS_IDR: ERROR_CON_IDC = 4;
pub const ERROR_CON_SLICE_COPY_CROSS_IDR_FREEZE_RES_CHANGE: ERROR_CON_IDC = 5;
pub const ERROR_CON_SLICE_MV_COPY_CROSS_IDR: ERROR_CON_IDC = 6;
pub const ERROR_CON_SLICE_MV_COPY_CROSS_IDR_FREEZE_RES_CHANGE: ERROR_CON_IDC = 7;
#[doc = " @brief Enumerate the type of error concealment methods"]
pub type ERROR_CON_IDC = ::std::os::raw::c_int;
pub const FEEDBACK_NON_VCL_NAL: FEEDBACK_VCL_NAL_IN_AU = 0;
pub const FEEDBACK_VCL_NAL: FEEDBACK_VCL_NAL_IN_AU = 1;
pub const FEEDBACK_UNKNOWN_NAL: FEEDBACK_VCL_NAL_IN_AU = 2;
#[doc = " @brief Feedback that whether or not have VCL NAL in current AU"]
pub type FEEDBACK_VCL_NAL_IN_AU = ::std::os::raw::c_int;
pub const NON_VIDEO_CODING_LAYER: LAYER_TYPE = 0;
pub const VIDEO_CODING_LAYER: LAYER_TYPE = 1;
#[doc = " @brief Type of layer being encoded"]
pub type LAYER_TYPE = ::std::os::raw::c_int;
pub const SPATIAL_LAYER_0: LAYER_NUM = 0;
pub const SPATIAL_LAYER_1: LAYER_NUM = 1;
pub const SPATIAL_LAYER_2: LAYER_NUM = 2;
pub const SPATIAL_LAYER_3: LAYER_NUM = 3;
pub const SPATIAL_LAYER_ALL: LAYER_NUM = 4;
#[doc = " @brief Spatial layer num"]
pub type LAYER_NUM = ::std::os::raw::c_int;
pub const VIDEO_BITSTREAM_AVC: VIDEO_BITSTREAM_TYPE = 0;
pub const VIDEO_BITSTREAM_SVC: VIDEO_BITSTREAM_TYPE = 1;
pub const VIDEO_BITSTREAM_DEFAULT: VIDEO_BITSTREAM_TYPE = 1;
#[doc = " @brief Enumerate the type of video bitstream which is provided to decoder"]
pub type VIDEO_BITSTREAM_TYPE = ::std::os::raw::c_int;
pub const NO_RECOVERY_REQUSET: KEY_FRAME_REQUEST_TYPE = 0;
pub const LTR_RECOVERY_REQUEST: KEY_FRAME_REQUEST_TYPE = 1;
pub const IDR_RECOVERY_REQUEST: KEY_FRAME_REQUEST_TYPE = 2;
pub const NO_LTR_MARKING_FEEDBACK: KEY_FRAME_REQUEST_TYPE = 3;
pub const LTR_MARKING_SUCCESS: KEY_FRAME_REQUEST_TYPE = 4;
pub const LTR_MARKING_FAILED: KEY_FRAME_REQUEST_TYPE = 5;
#[doc = " @brief Enumerate the type of key frame request"]
pub type KEY_FRAME_REQUEST_TYPE = ::std::os::raw::c_int;
#[doc = " @brief Structure for LTR recover request"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SLTRRecoverRequest {
    #[doc = "< IDR request or LTR recovery request"]
    pub uiFeedbackType: ::std::os::raw::c_uint,
    #[doc = "< distinguish request from different IDR"]
    pub uiIDRPicId: ::std::os::raw::c_uint,
    pub iLastCorrectFrameNum: ::std::os::raw::c_int,
    #[doc = "< specify current decoder frame_num."]
    pub iCurrentFrameNum: ::std::os::raw::c_int,
    pub iLayerId: ::std::os::raw::c_int,
}
#[doc = " @brief Structure for LTR marking feedback"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SLTRMarkingFeedback {
    #[doc = "< mark failed or successful"]
    pub uiFeedbackType: ::std::os::raw::c_uint,
    #[doc = "< distinguish request from different IDR"]
    pub uiIDRPicId: ::std::os::raw::c_uint,
    #[doc = "< specify current decoder frame_num"]
    pub iLTRFrameNum: ::std::os::raw::c_int,
    pub iLayerId: ::std::os::raw::c_int,
}
#[doc = " @brief Structure for LTR configuration"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SLTRConfig {
    #[doc = "< 1: on, 0: off"]
    pub bEnableLongTermReference: bool,
    #[doc = "< TODO: not supported to set it arbitrary yet"]
    pub iLTRRefNum: ::std::os::raw::c_int,
}
#[doc = "< quality mode"]
pub const RC_QUALITY_MODE: RC_MODES = 0;
#[doc = "< bitrate mode"]
pub const RC_BITRATE_MODE: RC_MODES = 1;
#[doc = "< no bitrate control,only using buffer status,adjust the video quality"]
pub const RC_BUFFERBASED_MODE: RC_MODES = 2;
pub const RC_TIMESTAMP_MODE: RC_MODES = 3;
#[doc = "< this is in-building RC MODE, WILL BE DELETED after algorithm tuning!"]
pub const RC_BITRATE_MODE_POST_SKIP: RC_MODES = 4;
#[doc = "< rate control off mode"]
pub const RC_OFF_MODE: RC_MODES = -1;
#[doc = " @brief Enumerate the type of rate control mode"]
pub type RC_MODES = ::std::os::raw::c_int;
pub const PRO_UNKNOWN: EProfileIdc = 0;
pub const PRO_BASELINE: EProfileIdc = 66;
pub const PRO_MAIN: EProfileIdc = 77;
pub const PRO_EXTENDED: EProfileIdc = 88;
pub const PRO_HIGH: EProfileIdc = 100;
pub const PRO_HIGH10: EProfileIdc = 110;
pub const PRO_HIGH422: EProfileIdc = 122;
pub const PRO_HIGH444: EProfileIdc = 144;
pub const PRO_CAVLC444: EProfileIdc = 244;
pub const PRO_SCALABLE_BASELINE: EProfileIdc = 83;
pub const PRO_SCALABLE_HIGH: EProfileIdc = 86;
#[doc = " @brief Enumerate the type of profile id"]
pub type EProfileIdc = ::std::os::raw::c_int;
pub const LEVEL_UNKNOWN: ELevelIdc = 0;
pub const LEVEL_1_0: ELevelIdc = 10;
pub const LEVEL_1_B: ELevelIdc = 9;
pub const LEVEL_1_1: ELevelIdc = 11;
pub const LEVEL_1_2: ELevelIdc = 12;
pub const LEVEL_1_3: ELevelIdc = 13;
pub const LEVEL_2_0: ELevelIdc = 20;
pub const LEVEL_2_1: ELevelIdc = 21;
pub const LEVEL_2_2: ELevelIdc = 22;
pub const LEVEL_3_0: ELevelIdc = 30;
pub const LEVEL_3_1: ELevelIdc = 31;
pub const LEVEL_3_2: ELevelIdc = 32;
pub const LEVEL_4_0: ELevelIdc = 40;
pub const LEVEL_4_1: ELevelIdc = 41;
pub const LEVEL_4_2: ELevelIdc = 42;
pub const LEVEL_5_0: ELevelIdc = 50;
pub const LEVEL_5_1: ELevelIdc = 51;
pub const LEVEL_5_2: ELevelIdc = 52;
#[doc = " @brief Enumerate the type of level id"]
pub type ELevelIdc = ::std::os::raw::c_int;
#[doc = "< quiet mode"]
pub const WELS_LOG_QUIET: _bindgen_ty_3 = 0;
#[doc = "< error log iLevel"]
pub const WELS_LOG_ERROR: _bindgen_ty_3 = 1;
#[doc = "< Warning log iLevel"]
pub const WELS_LOG_WARNING: _bindgen_ty_3 = 2;
#[doc = "< information log iLevel"]
pub const WELS_LOG_INFO: _bindgen_ty_3 = 4;
#[doc = "< debug log, critical algo log"]
pub const WELS_LOG_DEBUG: _bindgen_ty_3 = 8;
#[doc = "< per packet/frame log"]
pub const WELS_LOG_DETAIL: _bindgen_ty_3 = 16;
#[doc = "< resversed log iLevel"]
pub const WELS_LOG_RESV: _bindgen_ty_3 = 32;
pub const WELS_LOG_LEVEL_COUNT: _bindgen_ty_3 = 6;
#[doc = "< default log iLevel in Wels codec"]
pub const WELS_LOG_DEFAULT: _bindgen_ty_3 = 2;
#[doc = " @brief Enumerate the type of wels log"]
pub type _bindgen_ty_3 = ::std::os::raw::c_int;
#[doc = "< | SliceNum==1"]
pub const SM_SINGLE_SLICE: SliceModeEnum = 0;
#[doc = "< | according to SliceNum        | enabled dynamic slicing for multi-thread"]
pub const SM_FIXEDSLCNUM_SLICE: SliceModeEnum = 1;
#[doc = "< | according to SlicesAssign    | need input of MB numbers each slice. In addition, if other constraint in SSliceArgument is presented, need to follow the constraints. Typically if MB num and slice size are both constrained, re-encoding may be involved."]
pub const SM_RASTER_SLICE: SliceModeEnum = 2;
#[doc = "< | according to SliceSize       | slicing according to size, the slicing will be dynamic(have no idea about slice_nums until encoding current frame)"]
pub const SM_SIZELIMITED_SLICE: SliceModeEnum = 3;
pub const SM_RESERVED: SliceModeEnum = 4;
#[doc = " @brief Enumerate the type of slice mode"]
pub type SliceModeEnum = ::std::os::raw::c_int;
#[doc = " @brief Structure for slice argument"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SSliceArgument {
    #[doc = "< by default, uiSliceMode will be SM_SINGLE_SLICE"]
    pub uiSliceMode: SliceModeEnum,
    #[doc = "< only used when uiSliceMode=1, when uiSliceNum=0 means auto design it with cpu core number"]
    pub uiSliceNum: ::std::os::raw::c_uint,
    #[doc = "< only used when uiSliceMode=2; when =0 means setting one MB row a slice"]
    pub uiSliceMbNum: [::std::os::raw::c_uint; 35usize],
    #[doc = "< now only used when uiSliceMode=4"]
    pub uiSliceSizeConstraint: ::std::os::raw::c_uint,
}
impl Default for SSliceArgument {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const VF_COMPONENT: EVideoFormatSPS = 0;
pub const VF_PAL: EVideoFormatSPS = 1;
pub const VF_NTSC: EVideoFormatSPS = 2;
pub const VF_SECAM: EVideoFormatSPS = 3;
pub const VF_MAC: EVideoFormatSPS = 4;
pub const VF_UNDEF: EVideoFormatSPS = 5;
pub const VF_NUM_ENUM: EVideoFormatSPS = 6;
#[doc = " @brief Enumerate the type of video format"]
pub type EVideoFormatSPS = ::std::os::raw::c_int;
pub const CP_RESERVED0: EColorPrimaries = 0;
pub const CP_BT709: EColorPrimaries = 1;
pub const CP_UNDEF: EColorPrimaries = 2;
pub const CP_RESERVED3: EColorPrimaries = 3;
pub const CP_BT470M: EColorPrimaries = 4;
pub const CP_BT470BG: EColorPrimaries = 5;
pub const CP_SMPTE170M: EColorPrimaries = 6;
pub const CP_SMPTE240M: EColorPrimaries = 7;
pub const CP_FILM: EColorPrimaries = 8;
pub const CP_BT2020: EColorPrimaries = 9;
pub const CP_NUM_ENUM: EColorPrimaries = 10;
#[doc = " @brief Enumerate the type of color primaries"]
pub type EColorPrimaries = ::std::os::raw::c_int;
pub const TRC_RESERVED0: ETransferCharacteristics = 0;
pub const TRC_BT709: ETransferCharacteristics = 1;
pub const TRC_UNDEF: ETransferCharacteristics = 2;
pub const TRC_RESERVED3: ETransferCharacteristics = 3;
pub const TRC_BT470M: ETransferCharacteristics = 4;
pub const TRC_BT470BG: ETransferCharacteristics = 5;
pub const TRC_SMPTE170M: ETransferCharacteristics = 6;
pub const TRC_SMPTE240M: ETransferCharacteristics = 7;
pub const TRC_LINEAR: ETransferCharacteristics = 8;
pub const TRC_LOG100: ETransferCharacteristics = 9;
pub const TRC_LOG316: ETransferCharacteristics = 10;
pub const TRC_IEC61966_2_4: ETransferCharacteristics = 11;
pub const TRC_BT1361E: ETransferCharacteristics = 12;
pub const TRC_IEC61966_2_1: ETransferCharacteristics = 13;
pub const TRC_BT2020_10: ETransferCharacteristics = 14;
pub const TRC_BT2020_12: ETransferCharacteristics = 15;
pub const TRC_NUM_ENUM: ETransferCharacteristics = 16;
#[doc = " @brief Enumerate the type of transfer characteristics"]
pub type ETransferCharacteristics = ::std::os::raw::c_int;
pub const CM_GBR: EColorMatrix = 0;
pub const CM_BT709: EColorMatrix = 1;
pub const CM_UNDEF: EColorMatrix = 2;
pub const CM_RESERVED3: EColorMatrix = 3;
pub const CM_FCC: EColorMatrix = 4;
pub const CM_BT470BG: EColorMatrix = 5;
pub const CM_SMPTE170M: EColorMatrix = 6;
pub const CM_SMPTE240M: EColorMatrix = 7;
pub const CM_YCGCO: EColorMatrix = 8;
pub const CM_BT2020NC: EColorMatrix = 9;
pub const CM_BT2020C: EColorMatrix = 10;
pub const CM_NUM_ENUM: EColorMatrix = 11;
#[doc = " @brief Enumerate the type of color matrix"]
pub type EColorMatrix = ::std::os::raw::c_int;
pub const ASP_UNSPECIFIED: ESampleAspectRatio = 0;
pub const ASP_1x1: ESampleAspectRatio = 1;
pub const ASP_12x11: ESampleAspectRatio = 2;
pub const ASP_10x11: ESampleAspectRatio = 3;
pub const ASP_16x11: ESampleAspectRatio = 4;
pub const ASP_40x33: ESampleAspectRatio = 5;
pub const ASP_24x11: ESampleAspectRatio = 6;
pub const ASP_20x11: ESampleAspectRatio = 7;
pub const ASP_32x11: ESampleAspectRatio = 8;
pub const ASP_80x33: ESampleAspectRatio = 9;
pub const ASP_18x11: ESampleAspectRatio = 10;
pub const ASP_15x11: ESampleAspectRatio = 11;
pub const ASP_64x33: ESampleAspectRatio = 12;
pub const ASP_160x99: ESampleAspectRatio = 13;
pub const ASP_EXT_SAR: ESampleAspectRatio = 255;
#[doc = " @brief Enumerate the type of sample aspect ratio"]
pub type ESampleAspectRatio = ::std::os::raw::c_int;
#[doc = " @brief  Structure for spatial layer configuration"]
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct SSpatialLayerConfig {
    #[doc = "< width of picture in luminance samples of a layer"]
    pub iVideoWidth: ::std::os::raw::c_int,
    #[doc = "< height of picture in luminance samples of a layer"]
    pub iVideoHeight: ::std::os::raw::c_int,
    #[doc = "< frame rate specified for a layer"]
    pub fFrameRate: f32,
    #[doc = "< target bitrate for a spatial layer, in unit of bps"]
    pub iSpatialBitrate: ::std::os::raw::c_int,
    #[doc = "< maximum  bitrate for a spatial layer, in unit of bps"]
    pub iMaxSpatialBitrate: ::std::os::raw::c_int,
    #[doc = "< value of profile IDC (PRO_UNKNOWN for auto-detection)"]
    pub uiProfileIdc: EProfileIdc,
    #[doc = "< value of profile IDC (0 for auto-detection)"]
    pub uiLevelIdc: ELevelIdc,
    #[doc = "< value of level IDC (0 for auto-detection)"]
    pub iDLayerQp: ::std::os::raw::c_int,
    pub sSliceArgument: SSliceArgument,
    pub bVideoSignalTypePresent: bool,
    pub uiVideoFormat: ::std::os::raw::c_uchar,
    pub bFullRange: bool,
    pub bColorDescriptionPresent: bool,
    pub uiColorPrimaries: ::std::os::raw::c_uchar,
    pub uiTransferCharacteristics: ::std::os::raw::c_uchar,
    pub uiColorMatrix: ::std::os::raw::c_uchar,
    #[doc = "< aspect ratio present in VUI"]
    pub bAspectRatioPresent: bool,
    #[doc = "< aspect ratio idc"]
    pub eAspectRatio: ESampleAspectRatio,
    #[doc = "< use if aspect ratio idc == 255"]
    pub sAspectRatioExtWidth: ::std::os::raw::c_ushort,
    #[doc = "< use if aspect ratio idc == 255"]
    pub sAspectRatioExtHeight: ::std::os::raw::c_ushort,
}
impl Default for SSpatialLayerConfig {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "< camera video for real-time communication"]
pub const CAMERA_VIDEO_REAL_TIME: EUsageType = 0;
#[doc = "< screen content signal"]
pub const SCREEN_CONTENT_REAL_TIME: EUsageType = 1;
pub const CAMERA_VIDEO_NON_REAL_TIME: EUsageType = 2;
pub const SCREEN_CONTENT_NON_REAL_TIME: EUsageType = 3;
pub const INPUT_CONTENT_TYPE_ALL: EUsageType = 4;
#[doc = " @brief Encoder usage type"]
pub type EUsageType = ::std::os::raw::c_int;
#[doc = "< the lowest compleixty,the fastest speed,"]
pub const LOW_COMPLEXITY: ECOMPLEXITY_MODE = 0;
#[doc = "< medium complexity, medium speed,medium quality"]
pub const MEDIUM_COMPLEXITY: ECOMPLEXITY_MODE = 1;
#[doc = "< high complexity, lowest speed, high quality"]
pub const HIGH_COMPLEXITY: ECOMPLEXITY_MODE = 2;
#[doc = " @brief Enumulate the complexity mode"]
pub type ECOMPLEXITY_MODE = ::std::os::raw::c_int;
#[doc = "< constant id in SPS/PPS"]
pub const CONSTANT_ID: EParameterSetStrategy = 0;
#[doc = "< SPS/PPS id increases at each IDR"]
pub const INCREASING_ID: EParameterSetStrategy = 1;
#[doc = "< using SPS in the existing list if possible"]
pub const SPS_LISTING: EParameterSetStrategy = 2;
pub const SPS_LISTING_AND_PPS_INCREASING: EParameterSetStrategy = 3;
pub const SPS_PPS_LISTING: EParameterSetStrategy = 6;
#[doc = " @brief Enumulate for the stategy of SPS/PPS strategy"]
pub type EParameterSetStrategy = ::std::os::raw::c_int;
#[doc = " @brief SVC Encoding Parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct TagEncParamBase {
    #[doc = "< application type; please refer to the definition of EUsageType"]
    pub iUsageType: EUsageType,
    #[doc = "< width of picture in luminance samples (the maximum of all layers if multiple spatial layers presents)"]
    pub iPicWidth: ::std::os::raw::c_int,
    #[doc = "< height of picture in luminance samples((the maximum of all layers if multiple spatial layers presents)"]
    pub iPicHeight: ::std::os::raw::c_int,
    #[doc = "< target bitrate desired, in unit of bps"]
    pub iTargetBitrate: ::std::os::raw::c_int,
    #[doc = "< rate control mode"]
    pub iRCMode: RC_MODES,
    #[doc = "< maximal input frame rate"]
    pub fMaxFrameRate: f32,
}
impl Default for TagEncParamBase {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief SVC Encoding Parameters"]
pub type SEncParamBase = TagEncParamBase;
#[doc = " @brief SVC Encoding Parameters"]
pub type PEncParamBase = *mut TagEncParamBase;
#[doc = " @brief SVC Encoding Parameters extention"]
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct TagEncParamExt {
    #[doc = "< same as in TagEncParamBase"]
    pub iUsageType: EUsageType,
    #[doc = "< same as in TagEncParamBase"]
    pub iPicWidth: ::std::os::raw::c_int,
    #[doc = "< same as in TagEncParamBase"]
    pub iPicHeight: ::std::os::raw::c_int,
    #[doc = "< same as in TagEncParamBase"]
    pub iTargetBitrate: ::std::os::raw::c_int,
    #[doc = "< same as in TagEncParamBase"]
    pub iRCMode: RC_MODES,
    #[doc = "< same as in TagEncParamBase"]
    pub fMaxFrameRate: f32,
    #[doc = "< temporal layer number, max temporal layer = 4"]
    pub iTemporalLayerNum: ::std::os::raw::c_int,
    #[doc = "< spatial layer number,1<= iSpatialLayerNum <= MAX_SPATIAL_LAYER_NUM, MAX_SPATIAL_LAYER_NUM = 4"]
    pub iSpatialLayerNum: ::std::os::raw::c_int,
    pub sSpatialLayers: [SSpatialLayerConfig; 4usize],
    pub iComplexityMode: ECOMPLEXITY_MODE,
    #[doc = "< period of Intra frame"]
    pub uiIntraPeriod: ::std::os::raw::c_uint,
    #[doc = "< number of reference frame used"]
    pub iNumRefFrame: ::std::os::raw::c_int,
    #[doc = "< different stategy in adjust ID in SPS/PPS: 0- constant ID, 1-additional ID, 6-mapping and additional"]
    pub eSpsPpsIdStrategy: EParameterSetStrategy,
    #[doc = "< false:not use Prefix NAL; true: use Prefix NAL"]
    pub bPrefixNalAddingCtrl: bool,
    #[doc = "< false:not use SSEI; true: use SSEI -- TODO: planning to remove the interface of SSEI"]
    pub bEnableSSEI: bool,
    #[doc = "< (when encoding more than 1 spatial layer) false: use SVC syntax for higher layers; true: use Simulcast AVC"]
    pub bSimulcastAVC: bool,
    #[doc = "< 0:disable padding;1:padding"]
    pub iPaddingFlag: ::std::os::raw::c_int,
    #[doc = "< 0:CAVLC  1:CABAC."]
    pub iEntropyCodingModeFlag: ::std::os::raw::c_int,
    #[doc = "< False: don't skip frame even if VBV buffer overflow.True: allow skipping frames to keep the bitrate within limits"]
    pub bEnableFrameSkip: bool,
    #[doc = "< the maximum bitrate, in unit of bps, set it to UNSPECIFIED_BIT_RATE if not needed"]
    pub iMaxBitrate: ::std::os::raw::c_int,
    #[doc = "< the maximum QP encoder supports"]
    pub iMaxQp: ::std::os::raw::c_int,
    #[doc = "< the minmum QP encoder supports"]
    pub iMinQp: ::std::os::raw::c_int,
    #[doc = "< the maximum NAL size.  This value should be not 0 for dynamic slice mode"]
    pub uiMaxNalSize: ::std::os::raw::c_uint,
    #[doc = "< 1: on, 0: off"]
    pub bEnableLongTermReference: bool,
    #[doc = "< the number of LTR(long term reference),TODO: not supported to set it arbitrary yet"]
    pub iLTRRefNum: ::std::os::raw::c_int,
    #[doc = "< the LTR marked period that is used in feedback."]
    pub iLtrMarkPeriod: ::std::os::raw::c_uint,
    #[doc = "< 1 # 0: auto(dynamic imp. internal encoder); 1: multiple threads imp. disabled; lager than 1: count number of threads;"]
    pub iMultipleThreadIdc: ::std::os::raw::c_ushort,
    #[doc = "< only used when uiSliceMode=1 or 3, will change slicing of a picture during the run-time of multi-thread encoding, so the result of each run may be different"]
    pub bUseLoadBalancing: bool,
    #[doc = "< 0: on, 1: off, 2: on except for slice boundaries"]
    pub iLoopFilterDisableIdc: ::std::os::raw::c_int,
    #[doc = "< AlphaOffset: valid range [-6, 6], default 0"]
    pub iLoopFilterAlphaC0Offset: ::std::os::raw::c_int,
    #[doc = "< BetaOffset: valid range [-6, 6], default 0"]
    pub iLoopFilterBetaOffset: ::std::os::raw::c_int,
    #[doc = "< denoise control"]
    pub bEnableDenoise: bool,
    #[doc = "< background detection control //VAA_BACKGROUND_DETECTION //BGD cmd"]
    pub bEnableBackgroundDetection: bool,
    #[doc = "< adaptive quantization control"]
    pub bEnableAdaptiveQuant: bool,
    #[doc = "< enable frame cropping flag: TRUE always in application"]
    pub bEnableFrameCroppingFlag: bool,
    pub bEnableSceneChangeDetect: bool,
    #[doc = "< LTR advanced setting"]
    pub bIsLosslessLink: bool,
    #[doc = "< fix rate control overshooting"]
    pub bFixRCOverShoot: bool,
    #[doc = "< the target bits of IDR is (idr_bitrate_ratio/100) * average target bit per frame."]
    pub iIdrBitrateRatio: ::std::os::raw::c_int,
    #[doc = "< get Y PSNR stats for the whole video sequence"]
    pub bPsnrY: bool,
    #[doc = "< get U PSNR stats for the whole video sequence"]
    pub bPsnrU: bool,
    #[doc = "< get V PSNR stats for the whole video sequence"]
    pub bPsnrV: bool,
}
impl Default for TagEncParamExt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief SVC Encoding Parameters extention"]
pub type SEncParamExt = TagEncParamExt;
#[doc = " @brief Define a new struct to show the property of video bitstream."]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct SVideoProperty {
    #[doc = "< size of the struct"]
    pub size: ::std::os::raw::c_uint,
    #[doc = "< video stream type (AVC/SVC)"]
    pub eVideoBsType: VIDEO_BITSTREAM_TYPE,
}
impl Default for SVideoProperty {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief SVC Decoding Parameters, reserved here and potential applicable in the future"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagSVCDecodingParam {
    #[doc = "< file name of reconstructed frame used for PSNR calculation based debug"]
    pub pFileNameRestructed: *mut ::std::os::raw::c_char,
    #[doc = "< CPU load"]
    pub uiCpuLoad: ::std::os::raw::c_uint,
    #[doc = "< setting target dq layer id"]
    pub uiTargetDqLayer: ::std::os::raw::c_uchar,
    #[doc = "< whether active error concealment feature in decoder"]
    pub eEcActiveIdc: ERROR_CON_IDC,
    #[doc = "< decoder for parse only, no reconstruction. When it is true, SPS/PPS size should not exceed SPS_PPS_BS_SIZE (128). Otherwise, it will return error info"]
    pub bParseOnly: bool,
    #[doc = "< video stream property"]
    pub sVideoProperty: SVideoProperty,
}
impl Default for TagSVCDecodingParam {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief SVC Decoding Parameters, reserved here and potential applicable in the future"]
pub type SDecodingParam = TagSVCDecodingParam;
#[doc = " @brief SVC Decoding Parameters, reserved here and potential applicable in the future"]
pub type PDecodingParam = *mut TagSVCDecodingParam;
#[doc = " @brief Bitstream inforamtion of a layer being encoded"]
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct SLayerBSInfo {
    pub uiTemporalId: ::std::os::raw::c_uchar,
    pub uiSpatialId: ::std::os::raw::c_uchar,
    pub uiQualityId: ::std::os::raw::c_uchar,
    pub eFrameType: EVideoFrameType,
    pub uiLayerType: ::std::os::raw::c_uchar,
    #[doc = "< refer to D.2.11 Sub-sequence information SEI message semantics"]
    pub iSubSeqId: ::std::os::raw::c_int,
    #[doc = "< count number of NAL coded already"]
    pub iNalCount: ::std::os::raw::c_int,
    #[doc = "< length of NAL size in byte from 0 to iNalCount-1"]
    pub pNalLengthInByte: *mut ::std::os::raw::c_int,
    #[doc = "< buffer of bitstream contained"]
    pub pBsBuf: *mut ::std::os::raw::c_uchar,
    #[doc = "< PSNR values for Y/U/V"]
    pub rPsnr: [f32; 3usize],
}
impl Default for SLayerBSInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief Bitstream inforamtion of a layer being encoded"]
pub type PLayerBSInfo = *mut SLayerBSInfo;
#[doc = " @brief Frame bit stream info"]
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct SFrameBSInfo {
    pub iLayerNum: ::std::os::raw::c_int,
    pub sLayerInfo: [SLayerBSInfo; 128usize],
    pub eFrameType: EVideoFrameType,
    pub iFrameSizeInBytes: ::std::os::raw::c_int,
    pub uiTimeStamp: ::std::os::raw::c_longlong,
}
impl Default for SFrameBSInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief Frame bit stream info"]
pub type PFrameBSInfo = *mut SFrameBSInfo;
#[doc = "  @brief Structure for source picture"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct Source_Picture_s {
    #[doc = "< color space type"]
    pub iColorFormat: ::std::os::raw::c_int,
    #[doc = "< stride for each plane pData"]
    pub iStride: [::std::os::raw::c_int; 4usize],
    #[doc = "< plane pData"]
    pub pData: [*mut ::std::os::raw::c_uchar; 4usize],
    #[doc = "< luma picture width in x coordinate"]
    pub iPicWidth: ::std::os::raw::c_int,
    #[doc = "< luma picture height in y coordinate"]
    pub iPicHeight: ::std::os::raw::c_int,
    #[doc = "< timestamp of the source picture, unit: millisecond"]
    pub uiTimeStamp: ::std::os::raw::c_longlong,
    #[doc = "< get Y PSNR for this frame"]
    pub bPsnrY: bool,
    #[doc = "< get U PSNR for this frame"]
    pub bPsnrU: bool,
    #[doc = "< get V PSNR for this frame"]
    pub bPsnrV: bool,
}
impl Default for Source_Picture_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "  @brief Structure for source picture"]
pub type SSourcePicture = Source_Picture_s;
#[doc = " @brief Structure for bit rate info"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagBitrateInfo {
    pub iLayer: LAYER_NUM,
    #[doc = "< the maximum bitrate"]
    pub iBitrate: ::std::os::raw::c_int,
}
impl Default for TagBitrateInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief Structure for bit rate info"]
pub type SBitrateInfo = TagBitrateInfo;
#[doc = " @brief Structure for dump layer info"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagDumpLayer {
    pub iLayer: ::std::os::raw::c_int,
    pub pFileName: *mut ::std::os::raw::c_char,
}
impl Default for TagDumpLayer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief Structure for dump layer info"]
pub type SDumpLayer = TagDumpLayer;
#[doc = " @brief Structure for profile info in layer"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagProfileInfo {
    pub iLayer: ::std::os::raw::c_int,
    #[doc = "< the profile info"]
    pub uiProfileIdc: EProfileIdc,
}
impl Default for TagProfileInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief Structure for profile info in layer"]
pub type SProfileInfo = TagProfileInfo;
#[doc = " @brief  Structure for level info in layer"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagLevelInfo {
    pub iLayer: ::std::os::raw::c_int,
    #[doc = "< the level info"]
    pub uiLevelIdc: ELevelIdc,
}
impl Default for TagLevelInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief  Structure for level info in layer"]
pub type SLevelInfo = TagLevelInfo;
#[doc = " @brief Structure for dilivery status"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagDeliveryStatus {
    #[doc = "< 0: the previous frame isn't delivered,1: the previous frame is delivered"]
    pub bDeliveryFlag: bool,
    #[doc = "< the frame type that is dropped; reserved"]
    pub iDropFrameType: ::std::os::raw::c_int,
    #[doc = "< the frame size that is dropped; reserved"]
    pub iDropFrameSize: ::std::os::raw::c_int,
}
#[doc = " @brief Structure for dilivery status"]
pub type SDeliveryStatus = TagDeliveryStatus;
#[doc = " @brief The capability of decoder, for SDP negotiation"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagDecoderCapability {
    #[doc = "< profile_idc"]
    pub iProfileIdc: ::std::os::raw::c_int,
    #[doc = "< profile-iop"]
    pub iProfileIop: ::std::os::raw::c_int,
    #[doc = "< level_idc"]
    pub iLevelIdc: ::std::os::raw::c_int,
    #[doc = "< max-mbps"]
    pub iMaxMbps: ::std::os::raw::c_int,
    #[doc = "< max-fs"]
    pub iMaxFs: ::std::os::raw::c_int,
    #[doc = "< max-cpb"]
    pub iMaxCpb: ::std::os::raw::c_int,
    #[doc = "< max-dpb"]
    pub iMaxDpb: ::std::os::raw::c_int,
    #[doc = "< max-br"]
    pub iMaxBr: ::std::os::raw::c_int,
    #[doc = "< redundant-pic-cap"]
    pub bRedPicCap: bool,
}
#[doc = " @brief The capability of decoder, for SDP negotiation"]
pub type SDecoderCapability = TagDecoderCapability;
#[doc = " @brief Structure for parse only output"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagParserBsInfo {
    #[doc = "< total NAL number in current AU"]
    pub iNalNum: ::std::os::raw::c_int,
    #[doc = "< each nal length"]
    pub pNalLenInByte: *mut ::std::os::raw::c_int,
    #[doc = "< outputted dst buffer for parsed bitstream"]
    pub pDstBuff: *mut ::std::os::raw::c_uchar,
    #[doc = "< required SPS width info"]
    pub iSpsWidthInPixel: ::std::os::raw::c_int,
    #[doc = "< required SPS height info"]
    pub iSpsHeightInPixel: ::std::os::raw::c_int,
    #[doc = "< input BS timestamp"]
    pub uiInBsTimeStamp: ::std::os::raw::c_ulonglong,
    #[doc = "< output BS timestamp"]
    pub uiOutBsTimeStamp: ::std::os::raw::c_ulonglong,
}
impl Default for TagParserBsInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " @brief Structure for parse only output"]
pub type SParserBsInfo = TagParserBsInfo;
#[doc = " @brief Structure for parse only output"]
pub type PParserBsInfo = *mut TagParserBsInfo;
#[doc = " @brief Structure for encoder statistics"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct TagVideoEncoderStatistics {
    #[doc = "< the width of encoded frame"]
    pub uiWidth: ::std::os::raw::c_uint,
    #[doc = "< the height of encoded frame"]
    pub uiHeight: ::std::os::raw::c_uint,
    #[doc = "< average_Encoding_Time"]
    pub fAverageFrameSpeedInMs: f32,
    #[doc = "< the average frame rate in, calculate since encoding starts, supposed that the input timestamp is in unit of ms"]
    pub fAverageFrameRate: f32,
    #[doc = "< the frame rate in, in the last second, supposed that the input timestamp is in unit of ms (? useful for checking BR, but is it easy to calculate?"]
    pub fLatestFrameRate: f32,
    #[doc = "< sendrate in Bits per second, calculated within the set time-window"]
    pub uiBitRate: ::std::os::raw::c_uint,
    #[doc = "< the average QP of last encoded frame"]
    pub uiAverageFrameQP: ::std::os::raw::c_uint,
    #[doc = "< number of frames"]
    pub uiInputFrameCount: ::std::os::raw::c_uint,
    #[doc = "< number of frames"]
    pub uiSkippedFrameCount: ::std::os::raw::c_uint,
    #[doc = "< uiResolutionChangeTimes"]
    pub uiResolutionChangeTimes: ::std::os::raw::c_uint,
    #[doc = "< number of IDR requests"]
    pub uiIDRReqNum: ::std::os::raw::c_uint,
    #[doc = "< number of actual IDRs sent"]
    pub uiIDRSentNum: ::std::os::raw::c_uint,
    #[doc = "< number of LTR sent/marked"]
    pub uiLTRSentNum: ::std::os::raw::c_uint,
    #[doc = "< Timestamp of updating the statistics"]
    pub iStatisticsTs: ::std::os::raw::c_longlong,
    pub iTotalEncodedBytes: ::std::os::raw::c_ulong,
    pub iLastStatisticsBytes: ::std::os::raw::c_ulong,
    pub iLastStatisticsFrameCount: ::std::os::raw::c_ulong,
}
#[doc = " @brief Structure for encoder statistics"]
pub type SEncoderStatistics = TagVideoEncoderStatistics;
#[doc = " @brief  Structure for decoder statistics"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct TagVideoDecoderStatistics {
    #[doc = "< the width of encode/decode frame"]
    pub uiWidth: ::std::os::raw::c_uint,
    #[doc = "< the height of encode/decode frame"]
    pub uiHeight: ::std::os::raw::c_uint,
    #[doc = "< average_Decoding_Time"]
    pub fAverageFrameSpeedInMs: f32,
    #[doc = "< actual average_Decoding_Time, including freezing pictures"]
    pub fActualAverageFrameSpeedInMs: f32,
    #[doc = "< number of frames"]
    pub uiDecodedFrameCount: ::std::os::raw::c_uint,
    #[doc = "< uiResolutionChangeTimes"]
    pub uiResolutionChangeTimes: ::std::os::raw::c_uint,
    #[doc = "< number of correct IDR received"]
    pub uiIDRCorrectNum: ::std::os::raw::c_uint,
    #[doc = "< when EC is on, the average ratio of total EC areas, can be an indicator of reconstruction quality"]
    pub uiAvgEcRatio: ::std::os::raw::c_uint,
    #[doc = "< when EC is on, the rough average ratio of propogate EC areas, can be an indicator of reconstruction quality"]
    pub uiAvgEcPropRatio: ::std::os::raw::c_uint,
    #[doc = "< number of actual unintegrity IDR or not received but eced"]
    pub uiEcIDRNum: ::std::os::raw::c_uint,
    #[doc = "<"]
    pub uiEcFrameNum: ::std::os::raw::c_uint,
    #[doc = "< number of whole lost IDR"]
    pub uiIDRLostNum: ::std::os::raw::c_uint,
    #[doc = "< number of freezing IDR with error (partly received), under resolution change"]
    pub uiFreezingIDRNum: ::std::os::raw::c_uint,
    #[doc = "< number of freezing non-IDR with error"]
    pub uiFreezingNonIDRNum: ::std::os::raw::c_uint,
    #[doc = "< average luma QP. default: -1, no correct frame outputted"]
    pub iAvgLumaQp: ::std::os::raw::c_int,
    #[doc = "< number of Sps Invalid report"]
    pub iSpsReportErrorNum: ::std::os::raw::c_int,
    #[doc = "< number of SubSps Invalid report"]
    pub iSubSpsReportErrorNum: ::std::os::raw::c_int,
    #[doc = "< number of Pps Invalid report"]
    pub iPpsReportErrorNum: ::std::os::raw::c_int,
    #[doc = "< number of Sps NoExist Nal"]
    pub iSpsNoExistNalNum: ::std::os::raw::c_int,
    #[doc = "< number of SubSps NoExist Nal"]
    pub iSubSpsNoExistNalNum: ::std::os::raw::c_int,
    #[doc = "< number of Pps NoExist Nal"]
    pub iPpsNoExistNalNum: ::std::os::raw::c_int,
    #[doc = "< Profile idc in syntax"]
    pub uiProfile: ::std::os::raw::c_uint,
    #[doc = "< level idc according to Annex A-1"]
    pub uiLevel: ::std::os::raw::c_uint,
    #[doc = "< current active SPS id"]
    pub iCurrentActiveSpsId: ::std::os::raw::c_int,
    #[doc = "< current active PPS id"]
    pub iCurrentActivePpsId: ::std::os::raw::c_int,
    #[doc = "< frame interval of statistics log"]
    pub iStatisticsLogInterval: ::std::os::raw::c_uint,
}
#[doc = " @brief  Structure for decoder statistics"]
pub type SDecoderStatistics = TagVideoDecoderStatistics;
#[doc = " @brief Structure for sample aspect ratio (SAR) info in VUI"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct TagVuiSarInfo {
    #[doc = "< SAR width"]
    pub uiSarWidth: ::std::os::raw::c_uint,
    #[doc = "< SAR height"]
    pub uiSarHeight: ::std::os::raw::c_uint,
    #[doc = "< SAR overscan flag"]
    pub bOverscanAppropriateFlag: bool,
}
#[doc = " @brief Structure for sample aspect ratio (SAR) info in VUI"]
pub type SVuiSarInfo = TagVuiSarInfo;
#[doc = " @brief Structure for sample aspect ratio (SAR) info in VUI"]
pub type PVuiSarInfo = *mut TagVuiSarInfo;
pub type ISVCEncoder = *const ISVCEncoderVtbl;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ISVCEncoderVtbl {
    pub Initialize: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ISVCEncoder, pParam: *const SEncParamBase) -> ::std::os::raw::c_int,
    >,
    pub InitializeExt:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder, pParam: *const SEncParamExt) -> ::std::os::raw::c_int>,
    pub GetDefaultParams:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder, pParam: *mut SEncParamExt) -> ::std::os::raw::c_int>,
    pub Uninitialize: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder) -> ::std::os::raw::c_int>,
    pub EncodeFrame: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCEncoder,
            kpSrcPic: *const SSourcePicture,
            pBsInfo: *mut SFrameBSInfo,
        ) -> ::std::os::raw::c_int,
    >,
    pub EncodeParameterSets:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder, pBsInfo: *mut SFrameBSInfo) -> ::std::os::raw::c_int>,
    pub ForceIntraFrame: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCEncoder, bIDR: bool) -> ::std::os::raw::c_int>,
    pub SetOption: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCEncoder,
            eOptionId: ENCODER_OPTION,
            pOption: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub GetOption: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCEncoder,
            eOptionId: ENCODER_OPTION,
            pOption: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
}
pub type ISVCDecoder = *const ISVCDecoderVtbl;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct ISVCDecoderVtbl {
    pub Initialize: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ISVCDecoder, pParam: *const SDecodingParam) -> ::std::os::raw::c_long,
    >,
    pub Uninitialize: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ISVCDecoder) -> ::std::os::raw::c_long>,
    pub DecodeFrame: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            ppDst: *mut *mut ::std::os::raw::c_uchar,
            pStride: *mut ::std::os::raw::c_int,
            iWidth: *mut ::std::os::raw::c_int,
            iHeight: *mut ::std::os::raw::c_int,
        ) -> DECODING_STATE,
    >,
    pub DecodeFrameNoDelay: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            ppDst: *mut *mut ::std::os::raw::c_uchar,
            pDstInfo: *mut SBufferInfo,
        ) -> DECODING_STATE,
    >,
    pub DecodeFrame2: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            ppDst: *mut *mut ::std::os::raw::c_uchar,
            pDstInfo: *mut SBufferInfo,
        ) -> DECODING_STATE,
    >,
    pub FlushFrame: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            ppDst: *mut *mut ::std::os::raw::c_uchar,
            pDstInfo: *mut SBufferInfo,
        ) -> DECODING_STATE,
    >,
    pub DecodeParser: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            pDstInfo: *mut SParserBsInfo,
        ) -> DECODING_STATE,
    >,
    pub DecodeFrameEx: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            pSrc: *const ::std::os::raw::c_uchar,
            iSrcLen: ::std::os::raw::c_int,
            pDst: *mut ::std::os::raw::c_uchar,
            iDstStride: ::std::os::raw::c_int,
            iDstLen: *mut ::std::os::raw::c_int,
            iWidth: *mut ::std::os::raw::c_int,
            iHeight: *mut ::std::os::raw::c_int,
            iColorFormat: *mut ::std::os::raw::c_int,
        ) -> DECODING_STATE,
    >,
    pub SetOption: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            eOptionId: DECODER_OPTION,
            pOption: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_long,
    >,
    pub GetOption: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ISVCDecoder,
            eOptionId: DECODER_OPTION,
            pOption: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_long,
    >,
}
pub type WelsTraceCallback = ::std::option::Option<
    unsafe extern "C" fn(ctx: *mut ::std::os::raw::c_void, level: ::std::os::raw::c_int, string: *const ::std::os::raw::c_char),
>;
