use std::sync::LazyLock;

use ironrdp_core::{decode, encode_vec};

use super::*;
use crate::rdp::server_license::{
    BasicSecurityHeader, BasicSecurityHeaderFlags, LicensePdu, PreambleFlags, PreambleVersion,
    BASIC_SECURITY_HEADER_SIZE, PREAMBLE_SIZE,
};

const SERVER_UPGRADE_LICENSE_BUFFER: [u8; 2059] = [
    0x80, 0x00, // flags
    0x00, 0x00, // flagsHi
    0x03, 0x03, 0x07, 0x08, // preamble
    0x09, 0x00, // blob type
    0xef, 0x07, // blob len
    0xdb, 0xa3, 0x13, 0x30, 0x79, 0xa3, 0xcd, 0x9e, 0x48, 0xf4, 0x8f, 0x06, 0x37, 0x1b, 0x45, 0xdd, 0x60, 0xa9, 0x2e,
    0x29, 0x26, 0xbf, 0xc1, 0x96, 0x5e, 0x07, 0x93, 0x9d, 0xf2, 0x2d, 0x3e, 0xa3, 0x3a, 0xff, 0xd5, 0x6d, 0xf5, 0x85,
    0x30, 0x28, 0xe1, 0x46, 0xfd, 0x56, 0xd1, 0x20, 0x41, 0x33, 0x94, 0x88, 0x0c, 0x27, 0x23, 0xa0, 0x61, 0x38, 0x60,
    0xdb, 0x86, 0xd6, 0xce, 0x2c, 0xcd, 0x40, 0x39, 0x55, 0x23, 0x39, 0x12, 0xb9, 0xfd, 0xc2, 0x8d, 0x58, 0x0a, 0x37,
    0x33, 0x42, 0x5c, 0x61, 0xd7, 0xc8, 0xa0, 0x11, 0x66, 0xe2, 0x45, 0xba, 0x41, 0x39, 0xea, 0x85, 0x2a, 0x6e, 0x7a,
    0xb3, 0xe7, 0x27, 0x75, 0xfc, 0x4d, 0xc0, 0xfb, 0x0d, 0xe8, 0x67, 0x90, 0xb3, 0x3a, 0x40, 0xf0, 0x15, 0x8a, 0x15,
    0x8e, 0x2c, 0x99, 0x0f, 0x1c, 0xbd, 0xd2, 0x08, 0x66, 0x51, 0x9e, 0x6a, 0xe6, 0x2c, 0xf7, 0x1f, 0xd0, 0xc0, 0x8e,
    0x89, 0x76, 0x64, 0x18, 0x58, 0xa1, 0x94, 0xbd, 0xce, 0xb1, 0x2d, 0x96, 0xab, 0x53, 0xcf, 0xf8, 0xbf, 0xd0, 0xc9,
    0xc0, 0x2e, 0xe6, 0xa4, 0x0b, 0x50, 0x31, 0x4a, 0x4e, 0xd8, 0x47, 0x4b, 0xaf, 0xb8, 0x21, 0x78, 0xbf, 0x09, 0xac,
    0x7f, 0x2d, 0x2d, 0x88, 0xf6, 0xd8, 0xc7, 0x45, 0x33, 0x9f, 0xac, 0x69, 0xf5, 0x88, 0x9d, 0x5c, 0x6e, 0xc9, 0xd0,
    0xca, 0x8c, 0xbc, 0xa9, 0xd6, 0x07, 0x36, 0xed, 0x40, 0x95, 0x8a, 0xc1, 0x3f, 0x04, 0x41, 0xb3, 0xc9, 0xb3, 0x18,
    0x9d, 0x33, 0x1b, 0x04, 0x55, 0xcd, 0x41, 0xdf, 0x19, 0xe1, 0xcd, 0xa0, 0xa4, 0x35, 0x6e, 0xb7, 0x0a, 0xf3, 0xec,
    0x48, 0x10, 0x4f, 0x28, 0xc6, 0x35, 0xf3, 0x9b, 0xa2, 0xd5, 0xf7, 0x58, 0x03, 0x4d, 0x9a, 0x16, 0x34, 0xfb, 0x96,
    0x0c, 0xd5, 0x3a, 0xae, 0x52, 0x1b, 0x2f, 0x1f, 0x1f, 0x31, 0xb2, 0xd9, 0x14, 0x3b, 0x73, 0x0f, 0xe3, 0x04, 0xe0,
    0xa5, 0x52, 0x89, 0x68, 0xba, 0x0f, 0x99, 0x9d, 0x24, 0xa6, 0xf3, 0xe8, 0x9f, 0xcc, 0xd2, 0x44, 0x9f, 0x08, 0x8b,
    0x0a, 0x24, 0x89, 0xf7, 0xc9, 0x07, 0x0d, 0x25, 0x07, 0xed, 0x3e, 0x75, 0x21, 0x19, 0x65, 0xdc, 0x98, 0x41, 0x9d,
    0x05, 0x12, 0x18, 0x88, 0x86, 0x16, 0x43, 0x49, 0x29, 0xf2, 0xe8, 0x26, 0x16, 0x1e, 0xce, 0xcd, 0x32, 0xe7, 0x36,
    0x74, 0x51, 0x27, 0xfd, 0xa2, 0xa9, 0x62, 0x57, 0x60, 0x28, 0xe4, 0x64, 0x02, 0x06, 0x6b, 0xff, 0x01, 0xab, 0xc5,
    0x1c, 0x25, 0x98, 0x07, 0xe1, 0x40, 0xad, 0x19, 0xb7, 0x68, 0x66, 0x12, 0x4e, 0x80, 0xbc, 0x83, 0xd2, 0xde, 0xcb,
    0x7e, 0xc2, 0x32, 0xc7, 0xb8, 0x4d, 0xd6, 0x7d, 0xdd, 0x63, 0xa9, 0x95, 0x45, 0xc1, 0x90, 0xc7, 0x99, 0x3c, 0x0a,
    0x24, 0x62, 0xfc, 0x24, 0x15, 0xdb, 0xd3, 0xd2, 0x9b, 0x5d, 0x78, 0x04, 0x78, 0xd5, 0x40, 0x1d, 0xe3, 0x4e, 0xe8,
    0x30, 0x9f, 0x56, 0x91, 0x71, 0x00, 0x86, 0x2c, 0x6a, 0xb2, 0x78, 0xec, 0x70, 0xd9, 0x71, 0xe6, 0xaa, 0xb1, 0xad,
    0x18, 0xf9, 0xa6, 0x84, 0xb7, 0x4b, 0x5f, 0x32, 0xb8, 0xe3, 0xc7, 0x84, 0xef, 0x37, 0xfe, 0xae, 0x99, 0xb5, 0xf2,
    0x34, 0x84, 0x82, 0x4a, 0xb3, 0xd0, 0x7c, 0x5e, 0x25, 0x71, 0x89, 0x8b, 0x7d, 0x6f, 0x5f, 0x96, 0x7a, 0x1d, 0x84,
    0x96, 0x56, 0x34, 0x30, 0xce, 0x09, 0xd5, 0x00, 0xa8, 0xac, 0x15, 0x72, 0x21, 0xc4, 0x71, 0x57, 0xe5, 0x2a, 0x3d,
    0xdf, 0x82, 0xb8, 0xb8, 0x63, 0xdc, 0x3f, 0x2e, 0x99, 0x6c, 0xc3, 0xe3, 0xfd, 0x92, 0xe0, 0x26, 0xe1, 0x27, 0xb8,
    0x04, 0x71, 0xb0, 0xa8, 0xd1, 0xdf, 0x7e, 0x24, 0x23, 0xb9, 0x82, 0x01, 0x77, 0xdc, 0x8f, 0x77, 0x54, 0xe6, 0x93,
    0xc8, 0x6c, 0x66, 0x87, 0xb7, 0xaa, 0x9d, 0x66, 0xd4, 0xc6, 0x2f, 0x5e, 0x9e, 0xe1, 0xcf, 0xdb, 0xb2, 0x74, 0x0e,
    0xea, 0xa5, 0xe0, 0xf7, 0x00, 0xf1, 0x76, 0xf7, 0x45, 0x2c, 0xf8, 0xa9, 0x3b, 0xd9, 0x81, 0x59, 0x52, 0x0f, 0xfe,
    0xd9, 0x28, 0x02, 0x59, 0x82, 0x39, 0x51, 0x6e, 0xb9, 0xac, 0xf9, 0x6a, 0x48, 0x73, 0x6f, 0x2c, 0x4d, 0x7b, 0xc0,
    0xbf, 0xbe, 0x69, 0xae, 0x0e, 0xdc, 0x8b, 0xe6, 0xd8, 0x9f, 0x66, 0x30, 0x1e, 0x45, 0x1d, 0x85, 0x23, 0xeb, 0xa8,
    0x02, 0xb5, 0xba, 0xc2, 0xfd, 0xa1, 0xff, 0xc5, 0x55, 0x2b, 0xa0, 0xf7, 0x5b, 0x24, 0xee, 0x81, 0xd8, 0xe1, 0xb8,
    0x02, 0x06, 0x85, 0x6e, 0x41, 0x5a, 0xb8, 0x07, 0xff, 0x65, 0xdb, 0xb4, 0x59, 0x89, 0x71, 0x95, 0xd5, 0x0c, 0x2a,
    0x67, 0x4d, 0x57, 0xfd, 0x4a, 0xe8, 0x07, 0x02, 0x42, 0x20, 0xd9, 0xf1, 0xc6, 0xd5, 0x4c, 0x53, 0xb0, 0x32, 0x68,
    0xc0, 0xdc, 0xd7, 0x5d, 0x8f, 0xec, 0x24, 0x29, 0x00, 0x4f, 0x46, 0x8d, 0xd2, 0x99, 0xb2, 0xf4, 0x06, 0x99, 0x9a,
    0xa6, 0x31, 0xf1, 0x49, 0x16, 0xfe, 0x94, 0xbb, 0x8e, 0x15, 0x55, 0x06, 0x93, 0x16, 0xa3, 0x2d, 0x10, 0xb7, 0xb1,
    0xcf, 0x61, 0x78, 0xaf, 0x93, 0x66, 0x5a, 0x75, 0x5e, 0x97, 0xc0, 0x97, 0x4c, 0xba, 0xa9, 0x50, 0xac, 0x1b, 0xd6,
    0x92, 0x2a, 0xac, 0x0a, 0x21, 0x12, 0x9e, 0x4a, 0xf0, 0x40, 0x39, 0x4b, 0xe5, 0x78, 0x88, 0x86, 0x17, 0xb9, 0xeb,
    0xa0, 0x33, 0x8a, 0x9a, 0xfc, 0x7c, 0x91, 0x16, 0xd7, 0x52, 0xec, 0x05, 0x7e, 0x4e, 0x90, 0x78, 0x5e, 0x45, 0x4a,
    0xdd, 0xf6, 0xf4, 0x2e, 0x68, 0xf7, 0x8e, 0xfc, 0x60, 0x95, 0xaa, 0x6a, 0x07, 0x9c, 0xea, 0xce, 0xc1, 0xd9, 0x55,
    0x3a, 0x78, 0x54, 0x9a, 0x2a, 0x5f, 0x47, 0x87, 0x18, 0x4a, 0x8c, 0x6c, 0x34, 0xf5, 0xb8, 0xe2, 0x84, 0x36, 0xef,
    0x0d, 0x2e, 0x9d, 0x42, 0xd9, 0xff, 0x56, 0xe2, 0x87, 0x0b, 0x2f, 0x4d, 0x0e, 0xc0, 0x60, 0x35, 0x06, 0x9f, 0x61,
    0x9e, 0x4e, 0x7b, 0x49, 0x41, 0xb4, 0xfa, 0x04, 0x10, 0xbd, 0xf6, 0xad, 0x02, 0xd9, 0x7c, 0xba, 0x06, 0x68, 0xbb,
    0xa7, 0xa6, 0x8a, 0xab, 0xab, 0xb1, 0x2d, 0x69, 0x2a, 0xf1, 0xc6, 0x7b, 0x1b, 0x71, 0xb9, 0xd0, 0x91, 0x82, 0x6f,
    0xa8, 0x3c, 0xe1, 0xa3, 0x23, 0x3d, 0x4e, 0x48, 0x74, 0xe5, 0xc9, 0xc5, 0x95, 0x31, 0xad, 0xe7, 0xa9, 0xdb, 0x35,
    0xcd, 0x02, 0x08, 0x2c, 0x29, 0x5f, 0xf9, 0x17, 0x86, 0x69, 0x8f, 0x13, 0xd1, 0xca, 0x83, 0xfc, 0xac, 0x55, 0xcf,
    0x5a, 0xe6, 0x45, 0xaf, 0xe5, 0xbb, 0xe7, 0xb5, 0x53, 0x4e, 0xf0, 0x63, 0xfc, 0x9a, 0x49, 0xf6, 0x45, 0x93, 0xc6,
    0xbf, 0xd5, 0xb3, 0x25, 0xe2, 0x93, 0xb0, 0xa6, 0xa7, 0x14, 0x80, 0x6d, 0xb2, 0x03, 0x15, 0x6a, 0xad, 0xe8, 0x25,
    0xf1, 0x80, 0xd4, 0xba, 0x9a, 0x88, 0xbc, 0x56, 0x14, 0x7a, 0x4d, 0xad, 0xc3, 0x24, 0x3f, 0x4d, 0x35, 0x8b, 0xf6,
    0x59, 0x5b, 0xfd, 0xc9, 0x32, 0x1d, 0xf5, 0xa5, 0x53, 0xb5, 0xfb, 0xba, 0x83, 0x29, 0x0b, 0x9c, 0x62, 0x9b, 0x56,
    0x4b, 0x44, 0xbc, 0xcc, 0x19, 0x59, 0x7c, 0x0b, 0x74, 0xd9, 0x04, 0x28, 0xb3, 0x67, 0xab, 0x82, 0x36, 0x39, 0x55,
    0x5f, 0x7c, 0xed, 0x84, 0xc1, 0x16, 0xd3, 0x9e, 0x9c, 0x90, 0x9d, 0x55, 0xbc, 0x3e, 0xb9, 0x63, 0x12, 0xf2, 0x26,
    0x6d, 0xd7, 0xcc, 0x4f, 0x01, 0xa2, 0x0b, 0xd9, 0x66, 0x60, 0xad, 0xed, 0x2e, 0xbd, 0xbe, 0x28, 0x5f, 0x4a, 0x33,
    0xc8, 0xe8, 0xd4, 0xa6, 0x23, 0x8a, 0xfd, 0x66, 0xf5, 0x28, 0x90, 0x81, 0x27, 0xa9, 0x44, 0x93, 0x68, 0x57, 0x44,
    0x5e, 0xba, 0x90, 0x12, 0x03, 0x15, 0x2f, 0x69, 0x80, 0x55, 0xe8, 0x32, 0x63, 0x88, 0x30, 0x85, 0x50, 0x9b, 0xb6,
    0xbc, 0xbb, 0xc6, 0xfe, 0xa2, 0xe7, 0x32, 0x9d, 0x3d, 0x7d, 0xe2, 0x31, 0x93, 0xa6, 0x4e, 0xa0, 0xdc, 0x11, 0x44,
    0xd2, 0x93, 0x32, 0x94, 0x1e, 0xc6, 0x4c, 0x28, 0xde, 0xa2, 0xa6, 0x0d, 0x14, 0x02, 0x74, 0x8a, 0x84, 0x2a, 0x03,
    0x67, 0x35, 0x1d, 0x66, 0x3e, 0xe9, 0x68, 0x4a, 0xb2, 0x92, 0x1a, 0x69, 0x48, 0xbd, 0x23, 0xfd, 0x70, 0x5a, 0xfd,
    0xfe, 0x74, 0x39, 0xc5, 0xfa, 0x11, 0xac, 0x04, 0xc9, 0x94, 0xfc, 0x12, 0x2e, 0x06, 0x04, 0x61, 0x8e, 0x32, 0xf4,
    0xf8, 0x3b, 0xd1, 0xd8, 0x09, 0xb3, 0xe4, 0xac, 0x0f, 0x3e, 0x92, 0xf7, 0x75, 0x0b, 0x32, 0x9b, 0xd4, 0x8a, 0x13,
    0x99, 0x6a, 0x26, 0x77, 0x9f, 0x34, 0x08, 0xa8, 0xeb, 0xb3, 0x3e, 0x2a, 0x5b, 0x4a, 0x44, 0xf9, 0x21, 0x89, 0x2a,
    0x09, 0x9c, 0xc7, 0x0d, 0x2a, 0xd8, 0xd6, 0x27, 0x30, 0x25, 0x39, 0x84, 0x14, 0x11, 0x47, 0xff, 0x60, 0xe4, 0x7c,
    0xc3, 0x41, 0xfd, 0xd5, 0x34, 0xdd, 0xb1, 0x1c, 0xf2, 0xeb, 0xb1, 0x67, 0x04, 0xfa, 0xfd, 0x65, 0x5b, 0x20, 0x6e,
    0x28, 0x75, 0xa9, 0x74, 0x8e, 0xc4, 0x2f, 0xf7, 0xb2, 0xf5, 0x9f, 0x13, 0x44, 0xff, 0xb0, 0xf0, 0x68, 0xb0, 0x69,
    0x15, 0xa6, 0x16, 0xa8, 0xac, 0xc3, 0x06, 0x14, 0x8e, 0x51, 0x99, 0xa9, 0x4c, 0x19, 0xd1, 0x25, 0x34, 0xb5, 0x79,
    0xc2, 0xa7, 0xbf, 0xd8, 0x3d, 0x2d, 0x4c, 0x33, 0xac, 0x1b, 0x6c, 0xaf, 0x10, 0x42, 0x41, 0x14, 0x02, 0xe6, 0x87,
    0x2b, 0xe9, 0xec, 0xc6, 0xb1, 0xeb, 0x97, 0xd4, 0x35, 0x49, 0x97, 0xfc, 0xe2, 0x73, 0xf9, 0x98, 0x46, 0x7c, 0xf6,
    0x17, 0x2d, 0xb5, 0x43, 0x07, 0x8b, 0x19, 0x95, 0x9b, 0x65, 0xd3, 0x05, 0x7e, 0xb0, 0x68, 0x0d, 0x6e, 0x4b, 0x60,
    0xad, 0x5c, 0x47, 0x6e, 0x37, 0xfd, 0x3f, 0x60, 0x43, 0xda, 0xb2, 0x34, 0x00, 0xd6, 0x9c, 0x6d, 0x46, 0x7f, 0x41,
    0xe2, 0xc1, 0x1a, 0xd0, 0x53, 0x72, 0x81, 0x0b, 0x3f, 0x77, 0xe1, 0xbc, 0xcc, 0x09, 0x0f, 0xa1, 0x1d, 0x73, 0x8c,
    0xac, 0xa4, 0x48, 0x90, 0x80, 0xa8, 0x50, 0x63, 0x6a, 0xb7, 0x76, 0x91, 0x91, 0x2f, 0x1a, 0x5e, 0x83, 0x80, 0xe6,
    0xae, 0x66, 0x77, 0x44, 0xe0, 0x0f, 0x14, 0x70, 0xc9, 0xd3, 0x91, 0xe8, 0xd2, 0xc4, 0x89, 0xa8, 0x45, 0xc0, 0x3d,
    0xbd, 0x09, 0x58, 0xe0, 0xcd, 0xe6, 0x5c, 0x9e, 0x02, 0x94, 0xd2, 0xbe, 0xdf, 0x94, 0x35, 0xf7, 0x67, 0x96, 0x75,
    0x88, 0x08, 0x59, 0xd9, 0x19, 0x21, 0xda, 0xd0, 0xa2, 0x74, 0x2d, 0x22, 0x87, 0x37, 0x27, 0x6e, 0x58, 0xdc, 0x8e,
    0x9f, 0x50, 0xd5, 0x62, 0xf3, 0x4a, 0xa4, 0xb2, 0xfb, 0xf9, 0x3e, 0xd5, 0xda, 0x57, 0x56, 0x5c, 0xcb, 0x0e, 0xd1,
    0x62, 0x4f, 0xea, 0x42, 0x4a, 0x62, 0xb2, 0x4e, 0x1c, 0xd1, 0xcc, 0x24, 0x1b, 0xdc, 0xac, 0xd4, 0xb0, 0x2f, 0x5d,
    0x62, 0x87, 0x56, 0x3d, 0xe4, 0x03, 0xae, 0x4a, 0x7e, 0x7d, 0x05, 0xfe, 0x85, 0x33, 0xda, 0x5f, 0x36, 0xcb, 0x56,
    0xa1, 0x14, 0x80, 0x63, 0x26, 0x75, 0x3a, 0xc2, 0x1f, 0x9c, 0xdd, 0x8a, 0xd6, 0xf8, 0xa9, 0x1a, 0xf6, 0xc2, 0x57,
    0xe0, 0x7b, 0x80, 0x55, 0xd5, 0x12, 0xf1, 0xb4, 0xe7, 0x1d, 0x95, 0x68, 0x02, 0xf1, 0x19, 0xff, 0x74, 0x72, 0x32,
    0xdb, 0x6c, 0xc9, 0xa0, 0x2d, 0x69, 0xfc, 0xc0, 0xe8, 0x27, 0x11, 0xb8, 0xe0, 0xf5, 0x83, 0x60, 0x3f, 0xb4, 0x94,
    0xe5, 0x9d, 0xb8, 0xfd, 0xc5, 0x9e, 0x50, 0x76, 0x92, 0xc7, 0x33, 0x6b, 0xe0, 0x7e, 0x9b, 0x2c, 0x3b, 0x27, 0xd8,
    0xa6, 0xda, 0xb3, 0xa1, 0x45, 0xef, 0x3b, 0x3d, 0x76, 0x1d, 0x5a, 0x43, 0xa4, 0xe1, 0x82, 0x5f, 0x7d, 0x0b, 0x10,
    0x28, 0x1c, 0xb9, 0x8f, 0x2b, 0xcd, 0xf9, 0xc5, 0x93, 0xe3, 0x65, 0xa5, 0x5b, 0x50, 0xa9, 0x07, 0x16, 0xb3, 0x45,
    0x4a, 0x69, 0xfc, 0x58, 0x12, 0x7b, 0x58, 0x34, 0x9f, 0x6f, 0x5e, 0x7a, 0xc2, 0x9f, 0x7b, 0xcf, 0x62, 0x62, 0x6c,
    0x1e, 0x7d, 0xd9, 0x72, 0xca, 0x98, 0x1e, 0xd4, 0xe5, 0xc7, 0x98, 0x27, 0xe3, 0x9f, 0xc5, 0x3c, 0x90, 0x9e, 0x26,
    0xed, 0x7e, 0x38, 0x2b, 0xcf, 0xc4, 0x99, 0xf5, 0xb4, 0x78, 0x48, 0x7c, 0x08, 0x99, 0xbc, 0x80, 0x47, 0xb1, 0xc5,
    0x58, 0x60, 0x17, 0x84, 0x11, 0xf8, 0x70, 0xa1, 0x26, 0x95, 0x94, 0x77, 0xf4, 0x8d, 0x1d, 0x47, 0x96, 0xdf, 0x95,
    0x1d, 0x97, 0x37, 0x5a, 0x12, 0xfb, 0x3f, 0xcd, 0xa0, 0xfb, 0xac, 0x61, 0x62, 0x1f, 0xee, 0xdc, 0x6d, 0x2c, 0x45,
    0x5f, 0xc0, 0x80, 0x7d, 0x99, 0x62, 0x38, 0xf7, 0x6d, 0x88, 0xd5, 0xe2, 0x24, 0x9d, 0xed, 0xa7, 0xd5, 0xe7, 0x1c,
    0x8a, 0x75, 0x9b, 0x67, 0x0c, 0x64, 0xfe, 0xe7, 0xe2, 0xe9, 0xa0, 0x94, 0x60, 0x26, 0x46, 0xd8, 0xc9, 0x59, 0x43,
    0x17, 0x85, 0x07, 0x32, 0x8b, 0x0c, 0x5a, 0x1e, 0x35, 0x48, 0x46, 0xe5, 0x44, 0x5b, 0xc7, 0x07, 0xcd, 0x30, 0x97,
    0x80, 0xfa, 0xf9, 0xeb, 0x0d, 0xaf, 0xaf, 0x3e, 0xbe, 0x27, 0x43, 0x8e, 0x4a, 0xf2, 0x60, 0xeb, 0x2b, 0x4d, 0x11,
    0x9a, 0xe1, 0xd7, 0x59, 0x78, 0x29, 0x26, 0x3e, 0x9b, 0xda, 0x61, 0x15, 0xab, 0xe8, 0x6f, 0x81, 0x73, 0xac, 0x9f,
    0x43, 0xc6, 0xb1, 0x81, 0x73, 0x36, 0x4a, 0x1e, 0x57, 0x2b, 0xd9, 0x7a, 0x06, 0x4f, 0xb6, 0x37, 0x11, 0xe6, 0xc6,
    0x90, 0x41, 0xa4, 0xa6, 0xb7, 0x3a, 0x7e, 0xc9, 0xce, 0x50, 0x2f, 0x8c, 0x07, 0xdb, 0x9a, 0x19, 0x38, 0x51, 0x35,
    0x50, 0xf3, 0x09, 0x33, 0x20, 0x62, 0x36, 0xa8, 0x6c, 0x8e, 0xf2, 0x56, 0x8c, 0x82, 0xd3, 0xfa, 0x16, 0xb5, 0x3d,
    0x74, 0x28, 0xdc, 0x2a, 0xe5, 0xae, 0xab, 0x77, 0xe5, 0x22, 0x3d, 0x69, 0x92, 0xb8, 0x56, 0xc5, 0x06, 0x6b, 0x8b,
    0xda, 0x46, 0x18, 0xaf, 0x93, 0xa2, 0x0c, 0xb5, 0xd3, 0xd6, 0x94, 0x4a, 0x29, 0xfd, 0x4b, 0x48, 0x48, 0xa1, 0x73,
    0xbc, 0xde, 0xcb, 0x3a, 0x35, 0x27, 0xd5, 0x40, 0x3a, 0x1d, 0x5b, 0xe3, 0x62, 0xa5, 0x22, 0xa2, 0x7b, 0xb5, 0x6a,
    0xf0, 0x5e, 0x0a, 0x96, 0x5c, 0xe8, 0x3b, 0x41, 0x58, 0xa1, 0xd5, 0x11, 0x2c, 0x36, 0x9e, 0xe5, 0x2b, 0xc9, 0xfb,
    0x1b, 0x37, 0xd0, 0x8e, 0xcf, 0xc2, 0x01, 0x6f, 0xb6, 0x21, 0x96, 0x9c, 0x14, 0x2f, 0x76, 0x19, 0xb0, 0x6a, 0x9d,
    0xef, 0x69, 0xfd, 0xd0, 0x03, 0xd9, 0xeb, 0xb7, 0x86, 0x76, 0x20, 0xd3, 0x20, 0x6a, 0xd8, 0xcb, 0xc8, 0x9e, 0xb7,
    0x82, 0x28, 0xb2, 0x25, 0xa7, 0xa2, 0x6b, 0xfd, 0x60, 0xb0, 0x11, 0x09, 0x53, 0x5f, 0x79, 0x6b, 0x72, 0xd7, 0x1b,
    0x21, 0x73, 0xf7, 0x21, 0xd5, 0x5c, 0xc4, 0xe5, 0x52, 0x82, 0x73, 0x1f, 0x9c, 0x95, 0xe1, 0x21, 0xbf, 0x12, 0x67,
    0xc9, 0x41, 0xe5, 0x64, 0xc4, 0xd4, 0xf9, 0xa2, 0x9b, 0x29, 0xdf, 0xe5, 0xa4, 0xf3, 0xb4, 0x69, 0x6d, 0x2c, 0xb0,
    0x42, 0xe3, 0xe6, 0x25, 0xa7, 0x8f, 0xf5, 0x12, 0x99, 0x8c, 0xbf, 0xbb, 0xd8, 0xa8, 0x23, 0xdb, 0x8e, 0xec, 0x37,
    0xb0, 0x8e, 0x4f, 0xed, 0x67, 0xaa, 0x3e, 0xf6, 0x24, 0x56, 0x96, 0xe3, 0xd4, 0xbc, 0x25, 0x0b,
    0x56, // encrypted new license info
    0xed, 0xe8, 0xbf, 0xd6, 0x13, 0xa0, 0xf5, 0x80, 0x4a, 0xe5, 0xff, 0x85, 0x16, 0xfa, 0xcb, 0x1f, // mac data
];

const MAC_DATA: [u8; 16] = [
    0xed, 0xe8, 0xbf, 0xd6, 0x13, 0xa0, 0xf5, 0x80, 0x4a, 0xe5, 0xff, 0x85, 0x16, 0xfa, 0xcb, 0x1f,
];

const NEW_LICENSE_INFORMATION_BUFFER: [u8; 2031] = [
    0x00, 0x00, 0x06, 0x00, // version
    0x0e, 0x00, 0x00, 0x00, // scope length
    0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x6f, 0x66, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x00, // scope
    0x2c, 0x00, 0x00, 0x00, // company name length 26
    0x4d, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x6f, 0x00, 0x66, 0x00, 0x74, 0x00, 0x20,
    0x00, 0x43, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x70, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00,
    0x6f, 0x00, 0x6e, 0x00, 0x00, 0x00, // company name 44
    0x08, 0x00, 0x00, 0x00, // product id length
    0x41, 0x00, 0x30, 0x00, 0x32, 0x00, 0x00, 0x00, // product id
    0x99, 0x07, 0x00, 0x00, // license info length
    0x30, 0x82, 0x07, 0x95, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x07, 0x02, 0xa0, 0x82, 0x07, 0x86,
    0x30, 0x82, 0x07, 0x82, 0x02, 0x01, 0x01, 0x31, 0x00, 0x30, 0x0b, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
    0x01, 0x07, 0x01, 0xa0, 0x82, 0x07, 0x6a, 0x30, 0x82, 0x02, 0xf1, 0x30, 0x82, 0x01, 0xdd, 0xa0, 0x03, 0x02, 0x01,
    0x02, 0x02, 0x08, 0x01, 0x9e, 0x27, 0x4d, 0x68, 0xac, 0xed, 0x20, 0x30, 0x09, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02,
    0x1d, 0x05, 0x00, 0x30, 0x32, 0x31, 0x30, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x03, 0x1e, 0x0c, 0x00, 0x52, 0x00,
    0x4f, 0x00, 0x44, 0x00, 0x45, 0x00, 0x4e, 0x00, 0x54, 0x30, 0x19, 0x06, 0x03, 0x55, 0x04, 0x07, 0x1e, 0x12, 0x00,
    0x57, 0x00, 0x4f, 0x00, 0x52, 0x00, 0x4b, 0x00, 0x47, 0x00, 0x52, 0x00, 0x4f, 0x00, 0x55, 0x00, 0x50, 0x30, 0x1e,
    0x17, 0x0d, 0x37, 0x30, 0x30, 0x35, 0x33, 0x30, 0x31, 0x30, 0x33, 0x36, 0x31, 0x38, 0x5a, 0x17, 0x0d, 0x34, 0x39,
    0x30, 0x35, 0x33, 0x30, 0x31, 0x30, 0x33, 0x36, 0x31, 0x38, 0x5a, 0x30, 0x32, 0x31, 0x30, 0x30, 0x13, 0x06, 0x03,
    0x55, 0x04, 0x03, 0x1e, 0x0c, 0x00, 0x52, 0x00, 0x4f, 0x00, 0x44, 0x00, 0x45, 0x00, 0x4e, 0x00, 0x54, 0x30, 0x19,
    0x06, 0x03, 0x55, 0x04, 0x07, 0x1e, 0x12, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52, 0x00, 0x4b, 0x00, 0x47, 0x00, 0x52,
    0x00, 0x4f, 0x00, 0x55, 0x00, 0x50, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7,
    0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01,
    0x00, 0x88, 0xad, 0x7c, 0x8f, 0x8b, 0x82, 0x76, 0x5a, 0xbd, 0x8f, 0x6f, 0x62, 0x18, 0xe1, 0xd9, 0xaa, 0x41, 0xfd,
    0xed, 0x68, 0x01, 0xc6, 0x34, 0x35, 0xb0, 0x29, 0x04, 0xca, 0x4a, 0x4a, 0x1c, 0x7e, 0x80, 0x14, 0xf7, 0x8e, 0x77,
    0xb8, 0x25, 0xff, 0x16, 0x47, 0x6f, 0xbd, 0xe2, 0x34, 0x3d, 0x2e, 0x02, 0xb9, 0x53, 0xe4, 0x33, 0x75, 0xad, 0x73,
    0x28, 0x80, 0xa0, 0x4d, 0xfc, 0x6c, 0xc0, 0x22, 0x53, 0x1b, 0x2c, 0xf8, 0xf5, 0x01, 0x60, 0x19, 0x7e, 0x79, 0x19,
    0x39, 0x8d, 0xb5, 0xce, 0x39, 0x58, 0xdd, 0x55, 0x24, 0x3b, 0x55, 0x7b, 0x43, 0xc1, 0x7f, 0x14, 0x2f, 0xb0, 0x64,
    0x3a, 0x54, 0x95, 0x2b, 0x88, 0x49, 0x0c, 0x61, 0x2d, 0xac, 0xf8, 0x45, 0xf5, 0xda, 0x88, 0x18, 0x5f, 0xae, 0x42,
    0xf8, 0x75, 0xc7, 0x26, 0x6d, 0xb5, 0xbb, 0x39, 0x6f, 0xcc, 0x55, 0x1b, 0x32, 0x11, 0x38, 0x8d, 0xe4, 0xe9, 0x44,
    0x84, 0x11, 0x36, 0xa2, 0x61, 0x76, 0xaa, 0x4c, 0xb4, 0xe3, 0x55, 0x0f, 0xe4, 0x77, 0x8e, 0xde, 0xe3, 0xa9, 0xea,
    0xb7, 0x41, 0x94, 0x00, 0x58, 0xaa, 0xc9, 0x34, 0xa2, 0x98, 0xc6, 0x01, 0x1a, 0x76, 0x14, 0x01, 0xa8, 0xdc, 0x30,
    0x7c, 0x77, 0x5a, 0x20, 0x71, 0x5a, 0xa2, 0x3f, 0xaf, 0x13, 0x7e, 0xe8, 0xfd, 0x84, 0xa2, 0x5b, 0xcf, 0x25, 0xe9,
    0xc7, 0x8f, 0xa8, 0xf2, 0x8b, 0x84, 0xc7, 0x04, 0x5e, 0x53, 0x73, 0x4e, 0x0e, 0x89, 0xa3, 0x3c, 0xe7, 0x68, 0x5c,
    0x24, 0xb7, 0x80, 0x53, 0x3c, 0x54, 0xc8, 0xc1, 0x53, 0xaa, 0x71, 0x71, 0x3d, 0x36, 0x15, 0xd6, 0x6a, 0x9d, 0x7d,
    0xde, 0xae, 0xf9, 0xe6, 0xaf, 0x57, 0xae, 0xb9, 0x01, 0x96, 0x5d, 0xe0, 0x4d, 0xcd, 0xed, 0xc8, 0xd7, 0xf3, 0x01,
    0x03, 0x38, 0x10, 0xbe, 0x7c, 0x42, 0x67, 0x01, 0xa7, 0x23, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x13, 0x30, 0x11,
    0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x04, 0x08, 0x30, 0x06, 0x01, 0x01, 0xff, 0x02, 0x01, 0x00, 0x30, 0x09,
    0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1d, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x70, 0xdb, 0x21, 0x2b, 0x84,
    0x9a, 0x7a, 0xc3, 0xb1, 0x68, 0xfa, 0xc0, 0x00, 0x8b, 0x71, 0xab, 0x43, 0x9f, 0xb6, 0x7b, 0xb7, 0x1f, 0x20, 0x83,
    0xac, 0x0a, 0xb5, 0x0e, 0xad, 0xb6, 0x36, 0xef, 0x65, 0x17, 0x99, 0x86, 0x8a, 0x3d, 0xba, 0x0c, 0x53, 0x2e, 0xa3,
    0x75, 0xa0, 0xf3, 0x11, 0x3d, 0xe7, 0x65, 0x4b, 0xae, 0x3c, 0x42, 0x70, 0x11, 0xdc, 0xca, 0x83, 0xc0, 0xbe, 0x3e,
    0x97, 0x71, 0x84, 0x69, 0xd6, 0xa8, 0x27, 0x33, 0x9b, 0x3e, 0x17, 0x3c, 0xa0, 0x4c, 0x64, 0xca, 0x20, 0x37, 0xa4,
    0x11, 0xa9, 0x28, 0x8f, 0xb7, 0x18, 0x96, 0x69, 0x15, 0x0d, 0x74, 0x04, 0x75, 0x2a, 0x00, 0xc7, 0xa6, 0x6a, 0xbe,
    0xac, 0xb3, 0xf2, 0xfb, 0x06, 0x1b, 0x6c, 0x11, 0xbd, 0x96, 0xe2, 0x34, 0x74, 0x5d, 0xf5, 0x98, 0x8f, 0x3a, 0x8d,
    0x69, 0x08, 0x6f, 0x53, 0x12, 0x4e, 0x39, 0x80, 0x90, 0xce, 0x8b, 0x5e, 0x88, 0x23, 0x2d, 0xfd, 0x55, 0xfd, 0x58,
    0x3d, 0x39, 0x27, 0xb3, 0x7c, 0x57, 0xfe, 0x3b, 0xab, 0x62, 0x26, 0x60, 0xe2, 0xd0, 0xc8, 0xf4, 0x02, 0x23, 0x16,
    0xc3, 0x52, 0x5d, 0x9f, 0x05, 0x49, 0xa2, 0x71, 0x2d, 0x6d, 0x5b, 0x90, 0xdd, 0xbf, 0xe5, 0xa9, 0x2e, 0xf1, 0x85,
    0x8a, 0x8a, 0xb8, 0xa9, 0x6b, 0x13, 0xcc, 0x8d, 0x4c, 0x22, 0x41, 0xad, 0x32, 0x1e, 0x3b, 0x4b, 0x89, 0x37, 0x66,
    0xdf, 0x1e, 0xa5, 0x4a, 0x03, 0x52, 0x1c, 0xd9, 0x19, 0x79, 0x22, 0xd4, 0xa7, 0x3b, 0x47, 0x93, 0xa9, 0x0c, 0x03,
    0x6a, 0xd8, 0x5f, 0xfc, 0xc0, 0x75, 0x33, 0xe5, 0x26, 0xda, 0xf7, 0x4a, 0x77, 0xd8, 0xf1, 0x30, 0x80, 0x39, 0x38,
    0x1e, 0x86, 0x1d, 0x97, 0x00, 0x9c, 0x0e, 0xba, 0x00, 0x54, 0x8a, 0xc0, 0x12, 0x32, 0x6f, 0x3d, 0xc4, 0x15, 0xf9,
    0x50, 0xf8, 0xce, 0x95, 0x30, 0x82, 0x04, 0x71, 0x30, 0x82, 0x03, 0x5d, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x05,
    0x03, 0x00, 0x00, 0x00, 0x0f, 0x30, 0x09, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1d, 0x05, 0x00, 0x30, 0x32, 0x31,
    0x30, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x03, 0x1e, 0x0c, 0x00, 0x52, 0x00, 0x4f, 0x00, 0x44, 0x00, 0x45, 0x00,
    0x4e, 0x00, 0x54, 0x30, 0x19, 0x06, 0x03, 0x55, 0x04, 0x07, 0x1e, 0x12, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52, 0x00,
    0x4b, 0x00, 0x47, 0x00, 0x52, 0x00, 0x4f, 0x00, 0x55, 0x00, 0x50, 0x30, 0x1e, 0x17, 0x0d, 0x30, 0x37, 0x30, 0x36,
    0x32, 0x30, 0x31, 0x34, 0x35, 0x31, 0x33, 0x35, 0x5a, 0x17, 0x0d, 0x30, 0x37, 0x30, 0x39, 0x31, 0x38, 0x31, 0x34,
    0x35, 0x31, 0x33, 0x35, 0x5a, 0x30, 0x7f, 0x31, 0x7d, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x03, 0x1e, 0x0c, 0x00,
    0x52, 0x00, 0x4f, 0x00, 0x44, 0x00, 0x45, 0x00, 0x4e, 0x00, 0x54, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x07, 0x1e,
    0x1a, 0x00, 0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x73, 0x00, 0x74, 0x00, 0x72,
    0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x05, 0x1e, 0x3c, 0x00, 0x31,
    0x00, 0x42, 0x00, 0x63, 0x00, 0x4b, 0x00, 0x65, 0x00, 0x64, 0x00, 0x79, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x72, 0x00,
    0x4f, 0x00, 0x34, 0x00, 0x2f, 0x00, 0x4d, 0x00, 0x43, 0x00, 0x44, 0x00, 0x4c, 0x00, 0x49, 0x00, 0x31, 0x00, 0x41,
    0x00, 0x48, 0x00, 0x5a, 0x00, 0x63, 0x00, 0x50, 0x00, 0x69, 0x00, 0x61, 0x00, 0x73, 0x00, 0x3d, 0x00, 0x0d, 0x00,
    0x0a, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05,
    0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0x88, 0xad, 0x7c, 0x8f,
    0x8b, 0x82, 0x76, 0x5a, 0xbd, 0x8f, 0x6f, 0x62, 0x18, 0xe1, 0xd9, 0xaa, 0x41, 0xfd, 0xed, 0x68, 0x01, 0xc6, 0x34,
    0x35, 0xb0, 0x29, 0x04, 0xca, 0x4a, 0x4a, 0x1c, 0x7e, 0x80, 0x14, 0xf7, 0x8e, 0x77, 0xb8, 0x25, 0xff, 0x16, 0x47,
    0x6f, 0xbd, 0xe2, 0x34, 0x3d, 0x2e, 0x02, 0xb9, 0x53, 0xe4, 0x33, 0x75, 0xad, 0x73, 0x28, 0x80, 0xa0, 0x4d, 0xfc,
    0x6c, 0xc0, 0x22, 0x53, 0x1b, 0x2c, 0xf8, 0xf5, 0x01, 0x60, 0x19, 0x7e, 0x79, 0x19, 0x39, 0x8d, 0xb5, 0xce, 0x39,
    0x58, 0xdd, 0x55, 0x24, 0x3b, 0x55, 0x7b, 0x43, 0xc1, 0x7f, 0x14, 0x2f, 0xb0, 0x64, 0x3a, 0x54, 0x95, 0x2b, 0x88,
    0x49, 0x0c, 0x61, 0x2d, 0xac, 0xf8, 0x45, 0xf5, 0xda, 0x88, 0x18, 0x5f, 0xae, 0x42, 0xf8, 0x75, 0xc7, 0x26, 0x6d,
    0xb5, 0xbb, 0x39, 0x6f, 0xcc, 0x55, 0x1b, 0x32, 0x11, 0x38, 0x8d, 0xe4, 0xe9, 0x44, 0x84, 0x11, 0x36, 0xa2, 0x61,
    0x76, 0xaa, 0x4c, 0xb4, 0xe3, 0x55, 0x0f, 0xe4, 0x77, 0x8e, 0xde, 0xe3, 0xa9, 0xea, 0xb7, 0x41, 0x94, 0x00, 0x58,
    0xaa, 0xc9, 0x34, 0xa2, 0x98, 0xc6, 0x01, 0x1a, 0x76, 0x14, 0x01, 0xa8, 0xdc, 0x30, 0x7c, 0x77, 0x5a, 0x20, 0x71,
    0x5a, 0xa2, 0x3f, 0xaf, 0x13, 0x7e, 0xe8, 0xfd, 0x84, 0xa2, 0x5b, 0xcf, 0x25, 0xe9, 0xc7, 0x8f, 0xa8, 0xf2, 0x8b,
    0x84, 0xc7, 0x04, 0x5e, 0x53, 0x73, 0x4e, 0x0e, 0x89, 0xa3, 0x3c, 0xe7, 0x68, 0x5c, 0x24, 0xb7, 0x80, 0x53, 0x3c,
    0x54, 0xc8, 0xc1, 0x53, 0xaa, 0x71, 0x71, 0x3d, 0x36, 0x15, 0xd6, 0x6a, 0x9d, 0x7d, 0xde, 0xae, 0xf9, 0xe6, 0xaf,
    0x57, 0xae, 0xb9, 0x01, 0x96, 0x5d, 0xe0, 0x4d, 0xcd, 0xed, 0xc8, 0xd7, 0xf3, 0x01, 0x03, 0x38, 0x10, 0xbe, 0x7c,
    0x42, 0x67, 0x01, 0xa7, 0x23, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x82, 0x01, 0x47, 0x30, 0x82, 0x01, 0x43, 0x30,
    0x14, 0x06, 0x09, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x12, 0x04, 0x01, 0x01, 0xff, 0x04, 0x04, 0x01, 0x00,
    0x05, 0x00, 0x30, 0x3c, 0x06, 0x09, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x12, 0x02, 0x01, 0x01, 0xff, 0x04,
    0x2c, 0x4d, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x6f, 0x00, 0x66, 0x00, 0x74, 0x00,
    0x20, 0x00, 0x43, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x70, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69,
    0x00, 0x6f, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x30, 0x56, 0x06, 0x09, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x12,
    0x05, 0x01, 0x01, 0xff, 0x04, 0x46, 0x00, 0x30, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x1c, 0x00, 0x08, 0x00, 0x24, 0x00, 0x16, 0x00, 0x3a, 0x00, 0x01, 0x00, 0x41, 0x00, 0x30, 0x00,
    0x32, 0x00, 0x00, 0x00, 0x41, 0x00, 0x30, 0x00, 0x32, 0x00, 0x2d, 0x00, 0x36, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x30,
    0x00, 0x2d, 0x00, 0x53, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x80, 0x64, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x30, 0x6e, 0x06, 0x09, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x12, 0x06, 0x01, 0x01, 0xff, 0x04, 0x5e, 0x00,
    0x30, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x3e, 0x00, 0x52, 0x00, 0x4f, 0x00, 0x44, 0x00, 0x45, 0x00, 0x4e, 0x00,
    0x54, 0x00, 0x00, 0x00, 0x37, 0x00, 0x38, 0x00, 0x34, 0x00, 0x34, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x30, 0x00, 0x30,
    0x00, 0x36, 0x00, 0x2d, 0x00, 0x35, 0x00, 0x38, 0x00, 0x36, 0x00, 0x37, 0x00, 0x30, 0x00, 0x34, 0x00, 0x35, 0x00,
    0x2d, 0x00, 0x37, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x37, 0x00, 0x00, 0x00, 0x57, 0x00, 0x4f, 0x00, 0x52,
    0x00, 0x4b, 0x00, 0x47, 0x00, 0x52, 0x00, 0x4f, 0x00, 0x55, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x25,
    0x06, 0x03, 0x55, 0x1d, 0x23, 0x01, 0x01, 0xff, 0x04, 0x1b, 0x30, 0x19, 0xa1, 0x10, 0xa4, 0x0e, 0x52, 0x00, 0x4f,
    0x00, 0x44, 0x00, 0x45, 0x00, 0x4e, 0x00, 0x54, 0x00, 0x00, 0x00, 0x82, 0x05, 0x03, 0x00, 0x00, 0x00, 0x0f, 0x30,
    0x09, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1d, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x13, 0x1b, 0xdc, 0x89,
    0xd2, 0xfc, 0x54, 0x0c, 0xee, 0x82, 0x45, 0x68, 0x6a, 0x72, 0xc3, 0x3e, 0x17, 0x73, 0x96, 0x53, 0x44, 0x39, 0x50,
    0x0e, 0x0b, 0x9f, 0x95, 0xd6, 0x2c, 0x6b, 0x53, 0x14, 0x9c, 0xe5, 0x55, 0xed, 0x65, 0xdf, 0x2a, 0xeb, 0x5c, 0x64,
    0x85, 0x70, 0x1f, 0xbc, 0x96, 0xcf, 0xa3, 0x76, 0xb1, 0x72, 0x3b, 0xe1, 0xf6, 0xad, 0xad, 0xad, 0x2a, 0x14, 0xaf,
    0xba, 0xd0, 0xd6, 0xd5, 0x6d, 0x55, 0xec, 0x1e, 0xc3, 0x4b, 0xba, 0x06, 0x9c, 0x59, 0x78, 0x93, 0x64, 0x87, 0x4b,
    0x03, 0xf9, 0xee, 0x4c, 0xdd, 0x36, 0x5b, 0xbd, 0xd4, 0xe5, 0x4c, 0x4e, 0xda, 0x7b, 0xc1, 0xae, 0x23, 0x28, 0x9e,
    0x77, 0x6f, 0x0f, 0xe6, 0x94, 0xfe, 0x05, 0x22, 0x00, 0xab, 0x63, 0x5b, 0xe1, 0x82, 0x45, 0xa6, 0xec, 0x1f, 0x6f,
    0x2c, 0x7b, 0x56, 0xde, 0x78, 0x25, 0x7d, 0x10, 0x60, 0x0e, 0x53, 0x42, 0x4b, 0x6c, 0x7a, 0x6b, 0x5d, 0xc9, 0xd5,
    0xa6, 0xae, 0xc8, 0xc8, 0x52, 0x29, 0xd6, 0x42, 0x56, 0x02, 0xec, 0xf9, 0x23, 0xa8, 0x8c, 0x8d, 0x89, 0xc9, 0x7c,
    0x84, 0x07, 0xfc, 0x33, 0xe1, 0x1e, 0xea, 0xe2, 0x8f, 0x2b, 0xbe, 0x8f, 0xa9, 0xd3, 0xd1, 0xe1, 0x5e, 0x0b, 0xdc,
    0xb6, 0x43, 0x6e, 0x33, 0x0a, 0xf4, 0x2e, 0x9d, 0x0c, 0xc9, 0x58, 0x54, 0x34, 0xaa, 0xe1, 0xd2, 0xa2, 0xe4, 0x90,
    0x02, 0x23, 0x26, 0xa0, 0x92, 0x26, 0x26, 0x0a, 0x83, 0xb4, 0x4d, 0xd9, 0x4b, 0xef, 0xeb, 0x9d, 0xa9, 0x24, 0x3f,
    0x92, 0x8b, 0xdb, 0x04, 0x7b, 0x9d, 0x64, 0x91, 0xa4, 0x4b, 0xd2, 0x6e, 0x51, 0x05, 0x08, 0xc9, 0x91, 0xaf, 0x31,
    0x26, 0x55, 0x21, 0xb1, 0xea, 0xce, 0xa3, 0xa4, 0x0d, 0x5e, 0x4c, 0x46, 0xdb, 0x16, 0x2d, 0x98, 0xdc, 0x60, 0x19,
    0xb8, 0x1b, 0xb9, 0xcd, 0xfb, 0x31, 0x00, // license info
];

static NEW_LICENSE_INFORMATION: LazyLock<LicenseInformation> = LazyLock::new(|| LicenseInformation {
    version: 0x0006_0000,
    scope: "microsoft.com".to_owned(),
    company_name: "Microsoft Corporation".to_owned(),
    product_id: "A02".to_owned(),
    license_info: Vec::from(&NEW_LICENSE_INFORMATION_BUFFER[NEW_LICENSE_INFORMATION_BUFFER.len() - 0x0799..]),
});
static SERVER_UPGRADE_LICENSE: LazyLock<LicensePdu> = LazyLock::new(|| {
    ServerUpgradeLicense {
        license_header: LicenseHeader {
            security_header: BasicSecurityHeader {
                flags: BasicSecurityHeaderFlags::LICENSE_PKT,
            },
            preamble_message_type: PreambleType::NewLicense,
            preamble_flags: PreambleFlags::empty(),
            preamble_version: PreambleVersion::V3,
            preamble_message_size: u16::try_from(SERVER_UPGRADE_LICENSE_BUFFER.len() - BASIC_SECURITY_HEADER_SIZE)
                .expect("buffer size is too large"),
        },
        encrypted_license_info: Vec::from(
            &SERVER_UPGRADE_LICENSE_BUFFER[12..SERVER_UPGRADE_LICENSE_BUFFER.len() - MAC_SIZE],
        ),
        mac_data: Vec::from(MAC_DATA.as_ref()),
    }
    .into()
});

#[test]
fn from_buffer_correctly_parses_new_license_information() {
    assert_eq!(
        *NEW_LICENSE_INFORMATION,
        decode(NEW_LICENSE_INFORMATION_BUFFER.as_ref()).unwrap()
    );
}

#[test]
fn to_buffer_correctly_serializes_new_license_information() {
    let serialized_new_license_info = encode_vec(&*NEW_LICENSE_INFORMATION).unwrap();

    assert_eq!(
        NEW_LICENSE_INFORMATION_BUFFER.as_ref(),
        serialized_new_license_info.as_slice()
    );
}

#[test]
fn buffer_length_is_correct_for_new_license_information() {
    assert_eq!(NEW_LICENSE_INFORMATION_BUFFER.len(), NEW_LICENSE_INFORMATION.size());
}

#[test]
fn from_buffer_correctly_parses_server_upgrade_license() {
    assert_eq!(
        *SERVER_UPGRADE_LICENSE,
        decode(SERVER_UPGRADE_LICENSE_BUFFER.as_ref()).unwrap()
    );
}

#[test]
fn to_buffer_correctly_serializes_server_upgrade_license() {
    let serialized_upgrade_license = encode_vec(&*SERVER_UPGRADE_LICENSE).unwrap();

    assert_eq!(
        SERVER_UPGRADE_LICENSE_BUFFER.as_ref(),
        serialized_upgrade_license.as_slice()
    );
}

#[test]
fn buffer_length_is_correct_for_server_upgrade_license() {
    assert_eq!(SERVER_UPGRADE_LICENSE_BUFFER.len(), SERVER_UPGRADE_LICENSE.size());
}

#[test]
fn upgrade_license_verifies_correctly() {
    let encrypted_license_info = vec![
        0xa5, 0x62, 0xcc, 0xe8, 0x5f, 0x22, 0x79, 0x2b, 0xf3, 0xe7, 0x3c, 0x3, 0xde, 0xfe, 0x54, 0x8c, 0xe1, 0xa4,
        0xc2, 0x61, 0x81, 0x8b, 0x48, 0x38, 0x7d, 0x6, 0x4, 0x28, 0xbe, 0x53, 0xc5, 0x30, 0x38, 0x3b, 0x1e, 0xed, 0x48,
        0xc6, 0x2c, 0x88, 0x4, 0xbb, 0x58, 0xd7, 0x10, 0xa8, 0x8e, 0xff, 0x89, 0x4a, 0xc0, 0x3a, 0x6, 0x82, 0xc4, 0xfe,
        0x73, 0x2f, 0x39, 0xe7, 0xb7, 0xba, 0xb7, 0xa8, 0xfb, 0xb6, 0x68, 0x8, 0x90, 0xc6, 0x2d, 0x99, 0xbb, 0x85,
        0x17, 0x48, 0xcd, 0x2d, 0xe1, 0xf7, 0x80, 0x26, 0x78, 0x6d, 0xce, 0x62, 0xed, 0x2, 0x7c, 0x8f, 0x35, 0xde,
        0x1c, 0xb6, 0xa, 0x95, 0xab, 0x38, 0xd9, 0x51, 0x8c, 0x49, 0x35, 0xce, 0xa6, 0xd4, 0x1e, 0x3a, 0xe7, 0xd9,
        0x7e, 0xd4, 0x2a, 0xf9, 0xfa, 0xb2, 0x8, 0xd2, 0xdf, 0xa9, 0x51, 0x2d, 0x6e, 0x8c, 0x99, 0xd2, 0xb6, 0x7c,
        0x30, 0xac, 0xa, 0x8, 0x2f, 0x29, 0xaa, 0x15, 0xfe, 0x8e, 0x3f, 0x99, 0xd, 0x9a, 0xfb, 0x74, 0x68, 0xa9, 0x72,
        0x1, 0xd, 0x5, 0x59, 0x60, 0x8, 0xc3, 0x5b, 0x72, 0xe3, 0x47, 0x71, 0xbe, 0xa7, 0xa4, 0x79, 0x89, 0xde, 0xe2,
        0xd7, 0x5f, 0x97, 0x8e, 0x18, 0x2a, 0xd0, 0x92, 0x30, 0x51, 0xfa, 0xa7, 0xa9, 0x62, 0x7a, 0x32, 0x8e, 0xf,
        0xc5, 0x98, 0xd8, 0x24, 0x39, 0x5a, 0xca, 0xcf, 0x1d, 0x52, 0x62, 0x16, 0x5b, 0xfe, 0x45, 0xfc, 0x56, 0xf0,
        0x20, 0xb1, 0xb4, 0x16, 0x19, 0x1e, 0x19, 0xba, 0x5b, 0xe, 0x73, 0x78, 0xd1, 0x5, 0xe5, 0xa7, 0xbc, 0x6, 0xca,
        0x3b, 0x3b, 0x16, 0x48, 0xa4, 0x52, 0x58, 0x20, 0x8, 0x91, 0x31, 0x17, 0x68, 0xd1, 0x2a, 0x88, 0x5b, 0xd2,
        0xc1, 0xd3, 0xd0, 0x88, 0xc5, 0x2c, 0xfa, 0xdc, 0x39, 0xf7, 0xeb, 0x72, 0x6d, 0x6b, 0x77, 0xd7, 0x57, 0x6f,
        0x62, 0x40, 0x12, 0xc0, 0xff, 0xb2, 0xaa, 0xbf, 0x35, 0x11, 0x30, 0xc7, 0xf4, 0x78, 0xf8, 0x70, 0x40, 0xf0,
        0xb6, 0x20, 0xab, 0xb, 0x94, 0x52, 0xd5, 0x53, 0x74, 0x3b, 0x4b, 0xfb, 0x53, 0x83, 0xf1, 0x7f, 0x46, 0xef,
        0x37, 0xe0, 0x44, 0xba, 0xc, 0x5a, 0x65, 0x7d, 0x37, 0x1f, 0x66, 0xe, 0x6f, 0x75, 0x1a, 0x2d, 0xe9, 0xd6, 0x3f,
        0x5, 0x74, 0xa9, 0x7, 0x5, 0xc4, 0x4f, 0x6a, 0x8d, 0x5a, 0xad, 0x95, 0xf5, 0xf2, 0x2a, 0xd9, 0x32, 0x4c, 0x4d,
        0x44, 0x6a, 0xb4, 0x1e, 0xb7, 0x29, 0x2, 0xf4, 0x2f, 0x23, 0x52, 0x8a, 0xe6, 0xb0, 0x94, 0x29, 0x7c, 0xf8,
        0x9e, 0x99, 0xbe, 0x63, 0x32, 0xa9, 0x2c, 0xdf, 0xb7, 0x64, 0xe5, 0xc5, 0xa7, 0x24, 0x75, 0xb1, 0x43, 0x6f,
        0x7, 0xf3, 0x7e, 0x15, 0x9a, 0x8f, 0x5e, 0xc0, 0x15, 0x8f, 0xcc, 0xfa, 0x3c, 0x9e, 0x66, 0xa, 0x84, 0xe4, 0x70,
        0xb2, 0x20, 0x89, 0x4e, 0x1e, 0x29, 0xbf, 0x74, 0x7f, 0xd1, 0x48, 0x64, 0x1d, 0xec, 0x3, 0xe9, 0x85, 0x76,
        0xab, 0xcf, 0x93, 0xfa, 0x6f, 0x4a, 0xf5, 0xa4, 0xc5, 0xf5, 0xc3, 0x6f, 0xd5, 0xae, 0x58, 0xa9, 0x94, 0x77,
        0x64, 0x75, 0x45, 0x12, 0x7d, 0x7a, 0x6d, 0x83, 0x2b, 0x23, 0xf9, 0x3e, 0x5e, 0x49, 0x57, 0xbe, 0x4f, 0x64,
        0x59, 0xcc, 0xae, 0x8f, 0xea, 0x7b, 0xa6, 0xe3, 0x6b, 0x8e, 0xab, 0xa, 0xdf, 0x59, 0x8b, 0x5, 0x9b, 0x93, 0x32,
        0xe8, 0x2e, 0x6b, 0xcc, 0xcb, 0x2e, 0xb8, 0x26, 0x26, 0x1b, 0x42, 0x8c, 0xf3, 0xe2, 0xaf, 0xf9, 0xb3, 0xfe,
        0x49, 0xf6, 0x8b, 0x9b, 0xea, 0x64, 0xc2, 0x85, 0xca, 0x59, 0x5a, 0xfe, 0xe5, 0xc5, 0xd4, 0x7a, 0x0, 0x87,
        0x4a, 0xb5, 0xe8, 0xb4, 0xbb, 0x6a, 0x84, 0x87, 0x7e, 0x82, 0x44, 0x13, 0xcf, 0xf, 0xeb, 0xff, 0xd7, 0xf0,
        0xab, 0x56, 0x79, 0xa1, 0x33, 0xe, 0xf0, 0xa, 0x4b, 0x1, 0x81, 0x8c, 0xfe, 0x76, 0xb2, 0xd1, 0x57, 0x3d, 0x26,
        0x94, 0x36, 0x19, 0x74, 0x48, 0x48, 0xcd, 0xc3, 0xfc, 0xc0, 0xe5, 0xb6, 0x2b, 0xef, 0xb2, 0x6a, 0x44, 0x64,
        0x54, 0x42, 0x6e, 0x10, 0xf0, 0xfe, 0x6, 0xbe, 0x1, 0x73, 0xde, 0x16, 0x2e, 0x4b, 0xa9, 0x5b, 0xe0, 0xa9, 0x1a,
        0xda, 0xb9, 0xb3, 0x7e, 0xaf, 0x63, 0x1, 0x6, 0x9a, 0x8, 0xce, 0x7e, 0x3a, 0x3f, 0x33, 0xb9, 0x41, 0x38, 0xaf,
        0x43, 0xa, 0x79, 0xe3, 0xf, 0x7c, 0x9a, 0x6c, 0xbd, 0x2c, 0xc3, 0xa2, 0xba, 0x50, 0x98, 0xaa, 0x77, 0xc4, 0x2,
        0x97, 0xc7, 0x60, 0xc4, 0x4d, 0x14, 0xf9, 0xa0, 0xe0, 0x96, 0xa6, 0x27, 0x83, 0xbd, 0x96, 0x1b, 0xf6, 0xcf,
        0x9f, 0xba, 0xe8, 0xac, 0x38, 0x4d, 0xf9, 0xe0, 0x49, 0x75, 0xd1, 0xf8, 0x5a, 0xff, 0x43, 0x87, 0x5, 0x45,
        0x18, 0x90, 0x8f, 0x53, 0xf8, 0x8e, 0xf7, 0x3b, 0x2b, 0xfe, 0x2f, 0xcf, 0x5d, 0x73, 0x59, 0xd8, 0x8f, 0xc7,
        0x3a, 0x4f, 0xa7, 0x78, 0xfa, 0xc4, 0x68, 0xd, 0x95, 0xc7, 0x82, 0x6b, 0xa2, 0xb7, 0x1f, 0xdc, 0xb8, 0xc9,
        0x5d, 0x83, 0x27, 0x24, 0x84, 0x2f, 0xf4, 0x5f, 0xb, 0xa7, 0x3d, 0x0, 0x35, 0xbb, 0x5c, 0xbb, 0xbf, 0x5e, 0x7c,
        0xb4, 0xf4, 0x43, 0x13, 0x2b, 0x17, 0x6e, 0xef, 0xbf, 0x19, 0x57, 0xa4, 0x29, 0xbc, 0xdf, 0xd9, 0x89, 0x7b,
        0x2d, 0x54, 0x46, 0xd6, 0x44, 0x90, 0x37, 0xea, 0xeb, 0x74, 0xb6, 0x9f, 0xe5, 0x4e, 0x57, 0x63, 0x43, 0xe5,
        0xd7, 0xf, 0x72, 0x65, 0x8c, 0x91, 0xe, 0xd4, 0xdd, 0x67, 0xce, 0x6a, 0xb5, 0xe2, 0x60, 0x38, 0x5a, 0xe8, 0x3b,
        0x55, 0xd3, 0x9a, 0x12, 0xdb, 0x57, 0x3, 0xb3, 0x64, 0xd9, 0x96, 0x9b, 0x7, 0xfd, 0x25, 0x41, 0x8c, 0xbc, 0x20,
        0x91, 0x11, 0x1, 0x5f, 0xfe, 0x44, 0x1e, 0x68, 0xc, 0x40, 0xa4, 0xc3, 0xc2, 0xb7, 0x4d, 0x5c, 0xa1, 0x36, 0x6e,
        0x52, 0xda, 0xed, 0x71, 0xc5, 0xce, 0x27, 0x1e, 0xdc, 0xfd, 0xb8, 0xda, 0x70, 0xba, 0x7a, 0x33, 0x66, 0x91,
        0x62, 0x46, 0xd1, 0xae, 0x12, 0xc8, 0x90, 0xe4, 0xb4, 0x21, 0x2f, 0xa5, 0xb8, 0x6, 0x71, 0x26, 0x49, 0x37,
        0xe5, 0xc7, 0xd6, 0xa1, 0x4f, 0xb0, 0xe9, 0xdb, 0xce, 0xee, 0x6e, 0xc1, 0xb, 0x11, 0x5f, 0x6f, 0x72, 0x23,
        0xb5, 0xb6, 0x81, 0x4d, 0x7f, 0xe3, 0xe5, 0x41, 0xf4, 0x29, 0x55, 0x89, 0xfd, 0x62, 0x5d, 0x11, 0xaa, 0xd,
        0x94, 0x58, 0xe0, 0x9f, 0xd9, 0xb7, 0xc7, 0x47, 0x4e, 0x70, 0xe6, 0x84, 0xb1, 0x5d, 0x3a, 0xd1, 0xed, 0x5,
        0x61, 0x79, 0xe2, 0xe7, 0x5, 0x53, 0x94, 0xe2, 0x44, 0x49, 0xc, 0xc4, 0x36, 0x85, 0x22, 0xb9, 0x7b, 0xa5, 0xb,
        0x59, 0xeb, 0xb8, 0x5d, 0x38, 0x4d, 0x6d, 0xe, 0x6b, 0x8a, 0x5f, 0x9f, 0x3b, 0x93, 0x5f, 0x26, 0xc3, 0x33,
        0x17, 0x21, 0x15, 0x3c, 0x92, 0xf3, 0x53, 0x48, 0x1c, 0x2c, 0x46, 0x48, 0xee, 0x9e, 0xf1, 0x9d, 0x12, 0x0,
        0xd2, 0x7c, 0x7b, 0xd1, 0xd5, 0x7c, 0xdc, 0x63, 0x2e, 0x22, 0x1e, 0x16, 0x8a, 0x31, 0x3, 0xee, 0x24, 0x11,
        0x53, 0x15, 0xef, 0x15, 0xf1, 0xcd, 0xc, 0x33, 0x51, 0x20, 0xab, 0xab, 0xa3, 0x6d, 0xdb, 0x89, 0x12, 0xfe,
        0xeb, 0x59, 0x75, 0x84, 0x28, 0xf9, 0x62, 0x86, 0xfb, 0xd9, 0xca, 0xc6, 0x28, 0x88, 0x1b, 0x41, 0xfe, 0xf5,
        0xe4, 0x6c, 0x15, 0x1a, 0xa1, 0xe1, 0xe3, 0x9, 0xb0, 0x71, 0x16, 0xc2, 0xee, 0xb4, 0x54, 0x48, 0x9d, 0x37,
        0xa1, 0x33, 0x86, 0xdd, 0x3f, 0x6e, 0x9b, 0x3f, 0x99, 0xce, 0x11, 0x5c, 0xea, 0xc9, 0xec, 0xaa, 0x17, 0xd6,
        0x4d, 0x5c, 0x77, 0x99, 0x5, 0x23, 0xd4, 0x1d, 0xa1, 0xc1, 0x8c, 0xec, 0x64, 0x90, 0xd5, 0xb3, 0xb8, 0x73,
        0x88, 0x0, 0xe6, 0x41, 0x88, 0x2b, 0x77, 0x9, 0x3, 0xa0, 0xe4, 0xa4, 0x93, 0xe7, 0xbe, 0xd7, 0xe9, 0x6c, 0x0,
        0x15, 0xa6, 0xde, 0x38, 0xda, 0x2b, 0x6d, 0xfb, 0xde, 0x0, 0x96, 0x75, 0x8e, 0x8c, 0xef, 0x94, 0xc4, 0x64,
        0xcd, 0xfc, 0xb7, 0xf8, 0x6, 0x5c, 0xcc, 0x41, 0xf6, 0xce, 0x2c, 0xf3, 0xba, 0x44, 0x9e, 0x9f, 0xa8, 0xe6,
        0xb3, 0x5a, 0xdb, 0x38, 0x5e, 0x53, 0x45, 0x4, 0xb2, 0x3e, 0xe7, 0xea, 0xc5, 0x1b, 0x40, 0xaf, 0xd0, 0xb7,
        0xd3, 0x6c, 0x9e, 0x30, 0xa1, 0x72, 0xc, 0xde, 0x66, 0x3b, 0x9c, 0x75, 0xb7, 0x67, 0x48, 0x17, 0x8c, 0x97,
        0xbc, 0xd2, 0x9, 0xc6, 0x94, 0xc9, 0x3f, 0xbf, 0xd6, 0x1d, 0x5f, 0x63, 0x18, 0xf1, 0x95, 0x6c, 0x49, 0x37,
        0x85, 0xb0, 0x3f, 0xa4, 0x7a, 0x36, 0xa8, 0xeb, 0xe1, 0xce, 0x88, 0xcc, 0x37, 0x45, 0xa9, 0xda, 0x91, 0x96,
        0xfa, 0xc4, 0xda, 0x2e, 0xcc, 0x49, 0xe1, 0x98, 0xf1, 0x93, 0x28, 0x37, 0xa0, 0xf4, 0x5f, 0xda, 0x50, 0xfc,
        0x63, 0xef, 0x74, 0x29, 0xc0, 0x31, 0xfb, 0x6a, 0x9a, 0x19, 0x4f, 0x44, 0x54, 0xcf, 0x8c, 0x77, 0xda, 0xf3,
        0xaa, 0xe7, 0x1f, 0x5, 0xa1, 0x11, 0xf1, 0x1b, 0xa6, 0x77, 0xbb, 0xc6, 0xa8, 0x59, 0x2c, 0x9d, 0xea, 0x98,
        0x1a, 0x7c, 0x65, 0x79, 0x88, 0xdb, 0x30, 0xa2, 0xe8, 0xa, 0xe1, 0x21, 0x82, 0x2f, 0x68, 0xb0, 0xe4, 0xce,
        0xe7, 0x46, 0x82, 0x8d, 0xb5, 0xea, 0xad, 0x26, 0xb6, 0xf4, 0xd6, 0xdd, 0x6b, 0xd3, 0x30, 0x84, 0x2e, 0xd8,
        0x72, 0x1, 0xec, 0x68, 0x49, 0x4f, 0xa2, 0x3f, 0xe1, 0xee, 0x38, 0x59, 0x69, 0x2f, 0xb, 0x92, 0x14, 0xb9, 0xc5,
        0x3b, 0xae, 0x0, 0xf5, 0x23, 0xd5, 0x3c, 0x1b, 0x9f, 0xef, 0xe1, 0x4c, 0x40, 0xfd, 0x8, 0xba, 0x81, 0xbc, 0x3c,
        0x6d, 0x59, 0x92, 0x4a, 0x5c, 0xa8, 0xc5, 0xfd, 0x7b, 0x71, 0xa5, 0x13, 0xfb, 0xdd, 0x15, 0x99, 0x21, 0x42,
        0x54, 0x66, 0x78, 0xc5, 0x75, 0xac, 0xfb, 0xca, 0x71, 0x91, 0xae, 0x63, 0xf1, 0x67, 0x29, 0xc, 0x4b, 0xaf,
        0x78, 0xad, 0xd9, 0xc1, 0x9, 0xa7, 0x28, 0x14, 0x78, 0x50, 0xe3, 0x45, 0xfa, 0xb7, 0x41, 0x9f, 0x96, 0xd4,
        0x51, 0x56, 0xf7, 0xee, 0xdf, 0xf8, 0xa5, 0x36, 0x85, 0xa0, 0x72, 0xc9, 0x64, 0xb0, 0x23, 0x1d, 0xd6, 0x62,
        0x7, 0xf3, 0xf1, 0xfb, 0x41, 0x17, 0x32, 0xef, 0x56, 0x6d, 0x83, 0xc4, 0x1f, 0x70, 0x8b, 0x73, 0x33, 0x62,
        0xba, 0x47, 0x1, 0x24, 0x89, 0xed, 0xc, 0xc0, 0x18, 0x9, 0x40, 0x93, 0xda, 0x5e, 0x39, 0x2f, 0xd4, 0x3f, 0x9d,
        0xb3, 0xa4, 0xd, 0xd1, 0x3b, 0xc4, 0xf4, 0xf7, 0x23, 0xa5, 0xb, 0x9a, 0x93, 0xae, 0xc9, 0x3, 0xf, 0x9b, 0xbb,
        0xb0, 0xc2, 0xb0, 0x41, 0x6e, 0xaf, 0xf2, 0xb9, 0xad, 0x9a, 0x71, 0xc1, 0x87, 0xf0, 0x0, 0x53, 0xac, 0xad,
        0x24, 0x4c, 0x6f, 0x14, 0xd2, 0xd1, 0x85, 0x56, 0xb2, 0x7c, 0xf9, 0xa2, 0x92, 0x81, 0x43, 0x8e, 0xc8, 0xa4,
        0x58, 0x79, 0x4a, 0xde, 0x8f, 0xac, 0xa1, 0xcb, 0xf2, 0x9c, 0x38, 0x9c, 0xd6, 0xb2, 0x1a, 0xfa, 0x1c, 0xb5,
        0x19, 0xe2, 0x13, 0x36, 0x41, 0x9e, 0xc3, 0x73, 0xe9, 0x20, 0xf, 0xe3, 0xfd, 0xc, 0xa2, 0xd1, 0x77, 0xf8, 0xae,
        0xb6, 0x11, 0xd1, 0x55, 0x5b, 0xae, 0xd9, 0xb5, 0x2a, 0xd3, 0x96, 0x86, 0x77, 0xf7, 0xe2, 0x2, 0xa6, 0xc2,
        0x10, 0x37, 0x2f, 0x10, 0xff, 0xee, 0xc9, 0x29, 0xd1, 0xf4, 0x89, 0x4b, 0x89, 0x0, 0xee, 0xb5, 0x9f, 0xd1,
        0xad, 0x7b, 0x92, 0x17, 0x87, 0x85, 0x21, 0x59, 0xc7, 0xc3, 0xbf, 0x86, 0xf6, 0xff, 0xd8, 0x8a, 0x47, 0xb9,
        0x61, 0xa1, 0x52, 0xed, 0xf, 0x34, 0x17, 0xe2, 0xcb, 0x92, 0x0, 0x16, 0x2a, 0x1f, 0x4a, 0x60, 0x54, 0xd7, 0x1d,
        0x7a, 0x97, 0x4c, 0x91, 0x41, 0x8f, 0x80, 0x68, 0xbd, 0xa5, 0x57, 0x26, 0xe4, 0xf7, 0x8a, 0xe0, 0x57, 0x76,
        0x58, 0xe, 0x14, 0xfc, 0xab, 0xae, 0x60, 0xa8, 0xb2, 0x62, 0xd0, 0x9, 0x4b, 0xbc, 0x8, 0x20, 0x1f, 0x58, 0x9,
        0x52, 0x8, 0xd4, 0xf5, 0xdb, 0x87, 0x1e, 0x1c, 0xaf, 0x47, 0xe, 0x8b, 0x19, 0x3f, 0xf3, 0x7, 0x38, 0x5a, 0x5c,
        0x29, 0x66, 0x54, 0x77, 0x22, 0x4f, 0xb6, 0x5d, 0xc6, 0xc9, 0x35, 0x44, 0xe9, 0xeb, 0x33, 0x8a, 0x12, 0x77,
        0xc2, 0x1e, 0x83, 0xca, 0xfa, 0x1a, 0x2f, 0xef, 0x13, 0x6f, 0x70, 0xa6, 0x1f, 0x2e, 0x61, 0x83, 0xf4, 0x10,
        0xb8, 0x1, 0xa4, 0xb7, 0x9, 0xaa, 0x32, 0x36, 0x77, 0x39, 0x62, 0xfa, 0x7b, 0x19, 0x6b, 0x97, 0xe0, 0xd2, 0x1,
        0xfd, 0x33, 0x60, 0x8, 0xe0, 0x4, 0xdf, 0xa7, 0x86, 0xd1, 0x8d, 0xc4, 0xf6, 0x9c, 0xed, 0x77, 0x68, 0x9d, 0xee,
        0xd0, 0x67, 0xc7, 0xce, 0xd7, 0xf2, 0x2b, 0x2f, 0xe2, 0x82, 0x80, 0x89, 0x4b, 0x4c, 0x35, 0xd8, 0xf3, 0xca,
        0x8a, 0xd5, 0x37, 0xe, 0xf4, 0xac, 0x2f, 0xd7, 0xc2, 0x34, 0x39, 0x81, 0xce, 0x95, 0x65, 0x11, 0x2, 0xfa, 0xa0,
        0x20, 0x96, 0xd2, 0x7b, 0x42, 0x6b, 0xc8, 0x91, 0x9d, 0xe8, 0xc7, 0x62, 0xc7, 0x32, 0x6b, 0x66, 0x59, 0xe1,
        0xca, 0xf7, 0x42, 0x4a, 0x6c, 0xca, 0x72, 0xe, 0x82, 0x3, 0x93, 0xd6, 0xdf, 0xa5, 0xd3, 0xf6, 0xa6, 0x62, 0xec,
        0x85, 0x12, 0x7a, 0xde, 0x1, 0xd5, 0x13, 0x47, 0x23, 0x3e, 0xda, 0xcb, 0x3, 0x72, 0xde, 0x5e, 0x70, 0x10, 0x52,
        0x7e, 0x62, 0x84, 0x1e, 0x66, 0x37, 0x3a, 0x48, 0x5d, 0x96, 0x2b, 0x8f, 0x1, 0x16, 0xb, 0x0, 0xff, 0x1d, 0xf7,
        0xe8, 0xa2, 0xc7, 0xa1, 0xc9, 0x39, 0x8b, 0x75, 0x59, 0x8d, 0x33, 0x5e, 0x54, 0xae, 0xa8, 0x2b, 0x63, 0x89,
        0x5e, 0x7a, 0x3e, 0x35, 0x5c, 0x39, 0x9c, 0xfc, 0xa8, 0x1b, 0x33, 0x4b, 0xfe, 0xf3, 0xa7, 0x2, 0xe5, 0xc3,
        0x6b, 0x17, 0xc1, 0xb5, 0xdb, 0x26, 0x51, 0xff, 0x58, 0x4a, 0x3, 0x52, 0x1e, 0xde, 0x8, 0x96, 0x3a, 0x7d, 0x14,
        0x63, 0x80, 0xca, 0x5, 0x7f, 0x24, 0x73, 0x65, 0xb7, 0x70, 0x5a, 0x4f, 0xea, 0x6f, 0x8d, 0xa6, 0xf0, 0x6f,
        0x60, 0xdb, 0x34, 0x77, 0xef, 0xa0, 0x21, 0x17, 0xa2, 0x95, 0x4a, 0x73, 0xad, 0x68, 0xc1, 0xf3, 0xad, 0x67,
        0x68, 0x30, 0xa0, 0xda, 0x98, 0xfb, 0x15, 0xd7, 0x28, 0x9b, 0xb3, 0xf0, 0x34, 0x92, 0xb5, 0x3, 0x12, 0x0, 0xcb,
        0x54, 0x98, 0xf2, 0x75, 0x1d, 0x7a, 0x38, 0x5d, 0x3, 0xb1, 0xa9, 0x70, 0xc7, 0x5a, 0x1d, 0x25, 0x73, 0xfc,
        0xfb, 0x13, 0x6d, 0x5b, 0xe9, 0xb4, 0x5, 0xd2, 0xd, 0x1a, 0xd2, 0x38, 0x1c, 0x75, 0x19, 0xa, 0x9b, 0x16, 0x9,
        0xfb, 0x1a, 0xb2, 0xe2, 0xe, 0x85, 0x6e, 0x32, 0x9, 0x1b, 0xb5, 0xc3, 0x3b, 0x78, 0x41, 0xf0, 0x92, 0xeb, 0xcd,
        0x9, 0xde, 0x61, 0x30, 0x1f, 0xe2, 0x24, 0x80, 0x50, 0xa5, 0xe, 0x9, 0x18, 0xe, 0xe5, 0x70, 0x1f, 0xde, 0x6c,
        0x51, 0x3e, 0xdd, 0x9e, 0xad, 0xc5, 0x79, 0xd3, 0x2e, 0x9, 0x7, 0xa7, 0x52, 0xb7, 0x2c, 0x7f, 0xdb, 0x66, 0xf8,
        0xa2, 0xea, 0x47, 0xfe, 0xe2, 0x75, 0x77, 0xb3, 0xa9, 0x69, 0x98, 0xa3, 0x1a, 0xd9, 0xec, 0x5e, 0xf6, 0x2b,
        0x58, 0x8c, 0xd0, 0x58, 0x3f, 0x74, 0x7e, 0x6f, 0xe2, 0xe3, 0x6f, 0xa8, 0xc8, 0x1a, 0xf7, 0x7f, 0xbb, 0x7,
        0xca, 0x3, 0xfa, 0xab, 0xd8, 0x28, 0x15, 0x90, 0x89, 0x89, 0xf, 0xc4, 0xe2, 0xf8, 0xa6, 0xb7, 0x92, 0x59, 0x24,
        0x53, 0x15, 0x25, 0xd5, 0xf2, 0xb, 0xc2, 0xf0, 0x81, 0x16, 0x39, 0xcb, 0x7b, 0xae, 0x1e, 0xc1, 0x5d, 0x16,
        0xb8, 0x6d, 0x30, 0xdc, 0xf0, 0x17, 0x99, 0x8d, 0xd0, 0xab, 0x2a, 0xc8, 0x24, 0x3a, 0xd7, 0xe4, 0x16, 0x50,
        0xb7, 0x36, 0x6, 0x99, 0x90, 0x91, 0x84, 0xad, 0xf1, 0xb, 0xc2, 0xec, 0x15, 0x3a, 0x6e, 0xe8, 0x6, 0x5e, 0xcf,
        0x1a, 0x82, 0x15, 0xd8, 0x83, 0x60, 0x4c, 0xe8, 0x2d, 0x68, 0x7b, 0x6, 0x87, 0xd0, 0xe2, 0xec, 0x1f, 0x56,
        0xb1, 0xc7, 0xa8, 0xad, 0x7e, 0xf2, 0x25, 0x59, 0xbb, 0x2c, 0xc0, 0x2e, 0x56, 0x68, 0x2c, 0xa0, 0xd8, 0x27,
        0xd5, 0x9d, 0xb1, 0x9c, 0x3, 0xa3, 0xa7, 0xb8, 0xde, 0x5d, 0x62, 0xe, 0x8b, 0xb6, 0x7a, 0xf2, 0x8, 0x8, 0x51,
        0xe8, 0xe3, 0xa4, 0x13, 0x20, 0xcf, 0xa7, 0xbf, 0x3c, 0x62, 0xbc, 0xad, 0x16, 0xba, 0x84, 0xb8, 0xab, 0xac,
        0x15, 0x8e, 0x29, 0x33, 0x12, 0xd0, 0x83, 0x21, 0x5f, 0x87, 0x5a, 0x2f, 0x74, 0xd4, 0x91, 0xf8, 0x3f, 0x6d,
        0xa9, 0xa5, 0x62, 0xaa, 0x47, 0x62, 0x58, 0xf1, 0x16, 0x36, 0x81, 0x38, 0xc2, 0x21, 0xba, 0x23, 0x1, 0x27,
        0x1f, 0xad, 0x7f, 0x4a, 0x3e, 0xca, 0x9d, 0x9e, 0x4e, 0xea, 0xeb, 0xa4, 0xd7, 0xd, 0xf3, 0xa0, 0x12, 0x64,
        0xdc, 0xf4, 0x4e, 0xa7, 0x45, 0x55, 0x97, 0xef, 0x75, 0x78, 0x91, 0x6e, 0x66, 0x72, 0xe4, 0x84, 0xe5, 0xc4,
        0x72, 0xc4, 0xc0, 0x3, 0x83, 0xd4, 0x31, 0xc4, 0x49, 0x43, 0xe1, 0x79, 0x7a, 0x70, 0xe2, 0x40, 0xa1, 0x51,
        0x56, 0xae, 0x11, 0xfb, 0x7b, 0x89, 0x8a, 0xdd, 0x55, 0xa4, 0x18, 0xb6, 0xee, 0x6, 0xd7, 0x8a, 0xc1, 0x89,
        0xbf, 0x2d, 0xd7, 0xbf, 0x18, 0x14, 0xb0, 0xec, 0xed, 0xe1, 0x20, 0x18, 0xb6, 0x21, 0x6b, 0x3c, 0xe0, 0x9f,
        0x92, 0xed, 0xb4, 0x40, 0xd9, 0x77, 0x32, 0x50, 0x85, 0x25, 0x39, 0x2c, 0x37, 0x31, 0x4c, 0x9e, 0xbf, 0xe4,
        0xfc, 0x47, 0xe7, 0xc4, 0xaf, 0x4d, 0x7e, 0x9d, 0x80, 0x34, 0x60, 0xc5, 0xca, 0x74, 0xef, 0x38, 0x4, 0x71,
        0xf3, 0x1b, 0x99, 0x3f, 0xb5, 0xa8, 0x10, 0xf, 0xef, 0x84, 0x1, 0xe1, 0x9, 0x46, 0xe7, 0xe2, 0x56, 0x19, 0x7d,
        0x6a, 0x9f, 0x21, 0x7a, 0xd1, 0x82, 0x59, 0x7c, 0x9a, 0x13, 0xe2, 0x7f, 0x1e, 0x71, 0xcb, 0xf5, 0xf6, 0x47,
        0x8, 0x30, 0xa3, 0x3e, 0x1f, 0x2e, 0x26, 0x80, 0xe6, 0x1a, 0x62, 0x24, 0x1f, 0x18, 0x11, 0xf, 0xcf, 0xa7, 0x76,
        0x57, 0x3f, 0x7, 0xba, 0xbc, 0x26, 0xdc, 0x49, 0x38, 0x53, 0x71, 0xdc, 0x5b, 0xc3, 0x9f, 0x17, 0x44, 0xe9,
        0x58, 0xde, 0x97, 0xbf, 0x5a, 0xf, 0x69, 0x57, 0xb7, 0x3b, 0xda, 0x9c, 0x6c, 0x3a, 0x9c, 0x47, 0x2d, 0xd9,
        0xc3, 0x3a, 0xbf, 0x4c, 0x10, 0x75, 0x33, 0x3b, 0x83, 0x28, 0x70, 0xc7, 0xd7, 0x6e, 0x2f, 0xeb, 0xd3, 0xe5,
        0x39, 0x20, 0x8f, 0x6f, 0x9f, 0xad, 0x19, 0xe3, 0x3f, 0x40, 0xb0, 0x14, 0xef, 0x9c, 0xfd, 0x91, 0xf3, 0xf7,
        0x7f, 0x94, 0x47, 0xbb, 0x22, 0xc7, 0x68, 0xc9, 0xf1, 0x4b, 0x4b, 0x46, 0x2c, 0xa2, 0x6f, 0xd3, 0xc0, 0x48,
        0xef, 0xde, 0xde, 0xc4, 0x55, 0x8f, 0xfd, 0xff, 0x12, 0xd0, 0x38, 0xc0, 0x4, 0xe9, 0x1b, 0x73, 0x5, 0xe0, 0x10,
        0x53, 0xd7, 0x4b, 0x84, 0x80, 0xab, 0xea, 0xf5, 0xd9, 0xb4, 0x6f, 0xbf, 0xea, 0x25, 0x90, 0xcf, 0x4f, 0x15,
        0xc4, 0xd3, 0xa3, 0x83, 0x59, 0xf, 0x38, 0x66, 0xfa, 0xb8, 0xec, 0xde, 0xdc, 0x31, 0x47, 0xbf, 0x8b, 0xfe,
        0x27, 0x28, 0x70, 0x79, 0xf6, 0x44, 0x7f, 0xcb, 0xf7, 0xab, 0x55, 0x56, 0x9b, 0xd4, 0x9a, 0xbf, 0xa3, 0xa9,
        0xbd, 0xc2, 0xb8, 0x1c, 0x85, 0x3c, 0x13, 0x5e, 0xd7, 0x97, 0xec, 0xf9, 0x94, 0x5f, 0xf8, 0xa0, 0xb9, 0x4d,
        0x2, 0x8e, 0x9f, 0x64, 0xbe, 0x69, 0xb0, 0x94, 0x92, 0xbd, 0xd8, 0xfa, 0xc9, 0x7, 0x29, 0x7a, 0x0, 0x2f, 0xe8,
        0x9f, 0x33, 0xb4, 0xcb, 0x3f, 0xd7, 0x6c, 0x65, 0xf8, 0x15, 0xa7, 0xa7, 0x5, 0x4a, 0xb7, 0x6c, 0x28, 0x5c,
        0xf3, 0x3, 0xb1, 0x80, 0x93, 0x86, 0xf9, 0xdf, 0x4b, 0x56, 0x96, 0x36, 0xfd, 0x36, 0xc9, 0xe4, 0xa2, 0x24,
        0x34, 0x40, 0x54, 0x35, 0xbe, 0x26, 0x94, 0xd0, 0xd4, 0xd4, 0x55, 0xb4, 0x47, 0xf8, 0xe4, 0x7c, 0xe5, 0x37,
        0xdf, 0x11, 0xba, 0xea, 0xd, 0x92, 0xed, 0x92, 0x93, 0x7c, 0xa0, 0xad, 0x89, 0xd4, 0x82, 0xc5, 0x74, 0xfc,
        0x56, 0x69, 0x24, 0xf8, 0xe6, 0xfa, 0xc2, 0xd9, 0x7, 0x47, 0xb8, 0x4e, 0x9e, 0x23, 0x13, 0x16, 0xe0, 0xa1,
        0xcd, 0x2f, 0x69, 0x62, 0x4c, 0xc0, 0x72, 0x22, 0x86, 0x2f, 0x3a, 0x1c, 0xb4, 0x73, 0x56, 0x88, 0xe6, 0x82,
        0xfd, 0x2f, 0x2f, 0xc0, 0x30, 0x7f, 0x72, 0x23, 0xa7, 0x94, 0xc2, 0x6e, 0xf4, 0x2, 0xf6, 0xa3, 0xe0, 0x5d, 0xc,
        0x4c, 0xf7, 0x4e, 0x60, 0x12, 0x2, 0xca, 0x40, 0xc7, 0x1a, 0x4e, 0x3c, 0x7c, 0xce, 0xd8, 0x1b, 0xba, 0x5, 0x89,
        0xf, 0xec, 0xfe, 0x4, 0x96, 0xd, 0x99, 0x2b, 0xb6, 0xbd, 0x6e, 0xa5, 0x6d, 0x28, 0xd4, 0xc0, 0x19, 0xe3, 0x91,
        0x49, 0xe1, 0xa7, 0x84, 0xc8, 0xe7, 0x77, 0x56, 0x57, 0x94, 0xa2, 0x2e, 0x49, 0xf7, 0x8b, 0x1c, 0x8f, 0x85,
        0x75, 0x8f, 0x69, 0x97, 0x6b, 0xc2, 0x4d, 0xd9, 0x88, 0x23, 0xdc, 0x50, 0xb3, 0xa, 0xbb, 0x19, 0xbc, 0xe0,
        0x21, 0x76, 0xde, 0xe9, 0x46, 0x5d, 0x32, 0x6b, 0x8d, 0x4b, 0x99, 0xd4, 0x85, 0xc, 0x77, 0x29, 0x1f, 0x6b,
        0x8f, 0xf2, 0x2, 0x89, 0xef, 0x63, 0xab, 0xc, 0xe1, 0xd6, 0x72, 0xe3, 0xdf, 0x88, 0xd0, 0x2c, 0xdf, 0xae, 0xd6,
        0xf9, 0x29, 0x7, 0x94, 0x93, 0x10, 0x66, 0x57, 0x78, 0x6b, 0x8e, 0x84, 0x11, 0x6d, 0x2b, 0xe5, 0x8a, 0xa5,
        0x65, 0x98, 0xfc, 0x92, 0x47, 0x1d, 0xfd, 0x4b, 0x41, 0xdc, 0x87, 0x42, 0xf8, 0xbc, 0x9e, 0xc1, 0xfa, 0x91,
        0x81, 0x11, 0xcc, 0x92, 0x2f, 0xdb, 0xd8, 0xf8, 0x2e, 0x56, 0x6f, 0xbe, 0xf8, 0x6c, 0xf8, 0x5f, 0x2d, 0x61,
        0xb4, 0x4c, 0x7c, 0x6c, 0x11, 0x46, 0x4a, 0x63, 0x51, 0x55, 0x5a, 0xf5, 0xfa, 0x26, 0xc7, 0x45, 0x3, 0x64,
        0x84, 0xcb, 0x69, 0x36, 0x9b, 0x5, 0x1f, 0x1c, 0x10, 0x68, 0xbc, 0x12, 0x70, 0xde, 0x83, 0xdf, 0x94, 0x9b,
        0x94, 0x6f, 0xae, 0xdb, 0xe8, 0xef, 0xd7, 0x6c, 0x23, 0xd0, 0x6f, 0x8c, 0xc5, 0x6b, 0x37, 0xad, 0x72, 0x16,
        0x69, 0x77, 0x95, 0xb4, 0x6d, 0x6e, 0x1, 0x9f, 0xf0, 0xbd, 0xd5, 0x1f, 0x5b, 0x7a, 0xc5, 0xe3, 0x2d, 0xf7,
        0x3e, 0xd1, 0xce, 0xbe, 0x89, 0x34, 0xfa, 0x3d, 0x93, 0x6c, 0x90, 0x53, 0x3d, 0xfd, 0x7, 0xc4, 0xb3, 0xb, 0x9a,
        0x22, 0xba, 0xaa, 0x50, 0x20, 0xaa, 0x4f, 0x72, 0xb6, 0xf9, 0xed, 0xc0, 0x89, 0xef, 0xab, 0x66, 0x5a, 0x47,
        0x3, 0x6f, 0xc7, 0xb4, 0x10, 0x0, 0x89, 0x7, 0x4f, 0xa, 0xbe, 0x64, 0xfb, 0x5b, 0x33, 0x28, 0xbe, 0x5a, 0xe6,
        0x9c, 0x1b, 0x94, 0x5f, 0x1, 0x88, 0x6, 0xbc, 0xbf, 0x81, 0x98, 0x97, 0x54, 0xe7, 0x52, 0xa0, 0xa, 0x37, 0xf,
        0xf0, 0x3f, 0xba, 0x7, 0xc1, 0xbc, 0xbe, 0x36, 0x31, 0x94, 0x5d, 0x7a, 0x8c, 0x2d, 0xbe, 0xc, 0x2c, 0xb2, 0x71,
        0xa2, 0x73, 0xb4, 0xfc, 0xd2, 0xc4, 0x24, 0x5, 0x64, 0xd1, 0x15, 0xf6, 0x61, 0x7c, 0x60, 0x90, 0x49, 0x8c,
        0x69, 0x68, 0xa3, 0x73, 0xf9, 0x1, 0x7, 0xfa, 0x4f, 0x2a, 0xd0, 0x52, 0x84, 0x7c, 0x5c, 0x47, 0x78, 0x3c, 0xac,
        0xc4, 0x5c, 0x18, 0x32, 0x6c, 0x5e, 0xbb, 0xdb, 0xbd, 0x3c, 0x84, 0xc9, 0x9f, 0x65, 0xab, 0x3f, 0xa, 0x53,
        0x2c, 0xa1, 0x50, 0x4a, 0x45, 0x62, 0x46, 0xaa, 0xb4, 0xe8, 0x49, 0x11, 0x33, 0xa1, 0x32, 0x30, 0x2d, 0xf0,
        0xb2, 0x2f, 0x60, 0x68, 0x4a, 0x3b, 0x27, 0xd3, 0xb, 0xfa, 0x53, 0xc8, 0xdb, 0x99, 0xea, 0x8c, 0x67, 0x57,
        0x25, 0x26, 0xe, 0xc5, 0x98, 0xd0, 0xaf, 0xff, 0xac, 0x83, 0x85, 0x8f, 0x21, 0x4b, 0x91, 0xdd, 0x79, 0x40,
        0x9e, 0x36, 0x1f, 0x28, 0x62, 0xc9, 0xd3, 0x32, 0xe8, 0xc0, 0x62, 0x1b, 0x5b, 0xd5, 0x16, 0xf9, 0x2f, 0xa5,
        0x46, 0x73, 0xb3, 0x0, 0xc9, 0xbf, 0x3c, 0x31, 0x60, 0x3a, 0xbf, 0xc3, 0xdd, 0xc9, 0xb0, 0x8b, 0x7c, 0x2, 0x39,
        0x88, 0x37, 0x15, 0xfb, 0x81, 0x59, 0x80, 0xb2, 0xd9, 0x62, 0xf, 0xac, 0x85, 0x82, 0x8a, 0x49, 0x4, 0xea, 0x4a,
        0x1d, 0xb2, 0x29, 0x81, 0xba, 0xd7, 0xe4, 0x1a, 0x7f, 0x5d, 0x95, 0xf8, 0xcc, 0x70, 0x33, 0x79, 0x91, 0x85,
        0xf0, 0xc, 0xbb, 0x62, 0x3a, 0xcb, 0x1a, 0x6, 0x59, 0x88, 0x73, 0xb7, 0x54, 0xf6, 0x2a, 0xdb, 0xb4, 0xd3, 0x6a,
        0xe2, 0x72, 0x33, 0xf5, 0x55, 0xa9, 0x9c, 0xb8, 0xb6, 0xf2, 0x69, 0x65, 0xde, 0xc5, 0xf9, 0x9a, 0x25, 0xe6,
        0x9b, 0x38, 0x74, 0xe0, 0x17, 0x47, 0x96, 0x84, 0xce, 0x6c, 0x35, 0xb7, 0xfd, 0x90, 0x8e, 0xaf, 0x48, 0x41,
        0x17, 0xd8, 0xd8, 0xe0, 0x45, 0x1, 0x1b, 0xea, 0x75, 0x5b, 0x4, 0xfb, 0xf2, 0x8d, 0x47, 0xfd, 0x4f, 0xf1, 0xd0,
        0xd1, 0x33, 0xab, 0xce, 0x57, 0xd1, 0x3f, 0xde, 0xc, 0xf1, 0xbe, 0x2b, 0x81, 0xe2, 0x45, 0x4a, 0x2f, 0x25,
        0x16, 0xf7, 0x9f, 0x8, 0x98, 0x7f, 0x4a, 0x31, 0xd7, 0x66, 0xf9, 0xa0, 0x5c, 0x4e, 0xee, 0x4f, 0x3f, 0xbc,
        0x4a, 0x4a, 0xcd, 0x2c, 0x28, 0x25, 0xbc, 0xe1, 0x47, 0x8d, 0xd2, 0x92, 0x5, 0xa, 0x67, 0xb2, 0x49, 0x4f, 0x47,
        0xe8, 0xe5, 0x63, 0x92, 0xe0, 0xd2, 0x35, 0xed, 0xd9, 0xb6, 0x7b, 0x37, 0x7f, 0x20, 0xc4, 0xe4, 0xc4, 0x20,
        0xbb, 0xd, 0x88, 0x29, 0xbe, 0x68, 0x87, 0xf, 0xfe, 0xb, 0xff, 0x2, 0x6b, 0xca, 0x47, 0x40, 0x80, 0x15, 0xc7,
        0xcc, 0x7f, 0x31, 0x20, 0x62, 0x59, 0x51, 0xe5, 0x35, 0x57, 0x27, 0x6b, 0x34, 0x3e, 0x1c, 0xa1, 0x32, 0x3b,
        0x8b, 0xeb, 0x6a, 0xa6, 0x4a, 0xe8, 0x7d, 0xaa, 0x98, 0x4c, 0x6e, 0x97, 0x1c, 0x5b, 0x15, 0xef, 0x57, 0xd7,
        0x4f, 0x8a, 0x5f, 0xde, 0x49, 0xc, 0x80, 0xa5, 0xcb, 0x19, 0x85, 0xe5, 0xbe, 0x16, 0x32, 0x6b, 0xd1, 0xf2,
        0xe0, 0xff, 0x58, 0x31, 0xe5, 0x55, 0x72, 0xbf, 0xa5, 0x2e, 0x7f, 0x9, 0x2c, 0x77, 0xc4, 0xec, 0x75, 0xcd,
        0x11, 0x31, 0x78, 0x39, 0xed, 0x79, 0x7d, 0x3, 0x70, 0xac, 0xa3, 0x2a, 0x8f, 0xe7, 0x7b, 0x2, 0xa0, 0x1b, 0x1c,
        0xf9, 0x36, 0x36, 0x91, 0x31, 0x71, 0x80, 0x3a, 0x2e, 0x6d, 0x2d, 0x73, 0xf1, 0x8c, 0xfe, 0x6, 0x2c, 0x1c,
        0x69, 0x8f, 0xae, 0x46, 0x5a, 0xdc, 0xfa, 0x3b, 0x3d, 0x2a, 0x50, 0xd1, 0x3f, 0xd0, 0xa5, 0xfb, 0x21, 0xfe,
        0xc8, 0x60, 0x6f, 0x71, 0xb8, 0xa9, 0xbf, 0xe5, 0x35, 0x80, 0x3b, 0xde, 0xb4, 0xdf, 0xca, 0xa0, 0x1e, 0xbc,
        0x9b, 0xcb, 0xc2, 0x9e, 0x83, 0x44, 0xf9, 0x9f, 0x92, 0x57, 0x22, 0x2f, 0x19, 0xa3, 0x73, 0x85, 0x62, 0x86,
        0x2d, 0xce, 0xf6, 0x3d, 0xb3, 0x8e, 0xeb, 0xaa, 0x9e, 0xe6, 0x1f, 0xf5, 0x51, 0x3e, 0xf3, 0xb8, 0xd9, 0x44,
        0x55, 0x1e, 0xbe, 0x89, 0x2f, 0x6a, 0xb5, 0xfb, 0x83, 0xc7, 0x55, 0x5c, 0xaa, 0xa0, 0x1c, 0x15, 0x3e, 0xd4,
        0x2e, 0x2e, 0x36, 0x69, 0x2f, 0x8e, 0xcb, 0xc7, 0xea, 0x3d, 0x79, 0x2e, 0xf0, 0x2e, 0xa6, 0xd8, 0x39, 0x3b,
        0xa4, 0x99, 0xae, 0xc, 0x8f, 0x3e, 0x77, 0x2a, 0xf3, 0x93, 0x8d, 0xdc, 0x79, 0xbe, 0x79, 0x1c, 0xe6, 0xf9,
        0xc4, 0x78, 0x38, 0xce, 0x93, 0x96, 0xf7, 0x3a, 0xa5, 0x54, 0x70, 0xe6, 0x6f, 0x8a, 0x61, 0x3e, 0xdf, 0xd9,
        0x72, 0x2f, 0x2e, 0x3d, 0xeb, 0xb6, 0x29, 0xc6, 0x87, 0xb2, 0xf9, 0x72, 0x2, 0x56, 0x67, 0x74, 0xec, 0xe7,
        0xa2, 0xd2, 0xc2, 0x9f, 0xa, 0x9e, 0x22, 0xd2, 0xf5, 0xf7, 0x74, 0x24, 0x4f, 0xfc, 0x8f, 0xdf, 0xab, 0xe0,
        0x34, 0x80, 0xa0, 0x82, 0xab, 0x44, 0x19, 0x28, 0x75, 0x74, 0xe5, 0x1b, 0x75, 0xff, 0xfc, 0x94, 0x4d, 0x80,
        0xea, 0x94, 0x85, 0xd6, 0xf5, 0x8b, 0x39, 0x51, 0x7c, 0x12, 0x3f, 0x6a, 0xf0, 0xa1, 0xed, 0xfd, 0x52, 0x2d,
        0x90, 0xa8, 0x4b, 0x2b, 0xe1, 0x3b, 0x37, 0xc4, 0xe8, 0x98, 0xfb, 0x1c, 0x5f, 0xdc, 0x5d, 0x2f, 0xde, 0xae,
        0xd0, 0xa, 0x5c, 0x3a, 0x1f, 0xce, 0x37, 0x7f, 0x9d, 0x84, 0xb9, 0xc7, 0xe2, 0xfc, 0xf7, 0x73, 0xee, 0x79,
        0xbf, 0x6a, 0x62, 0x6a, 0x8c, 0x0, 0x54, 0x3e, 0xca, 0x66, 0x7e, 0xf0, 0xf9, 0x5c, 0xd3, 0xc9, 0xd, 0xd8, 0x85,
        0x3e, 0xa7, 0x19, 0x91, 0xf5, 0x90, 0x51, 0xbb, 0xfb, 0x63, 0xec, 0x25, 0x12, 0x14, 0x3, 0xce, 0xde, 0x7, 0xf7,
        0x59, 0x8f, 0x73, 0xb4, 0xe2, 0xf1, 0x32, 0x35, 0x21, 0x2f, 0x0, 0x61, 0x69, 0x5e, 0x2f, 0x12, 0x4f, 0x85,
        0xbc, 0xb3, 0x14, 0x85, 0x1f, 0x54, 0x6d, 0xa7, 0xfe, 0x47, 0xe8, 0xc4, 0xb2, 0x3f, 0xf4, 0x15, 0xf8, 0xc6,
        0xdd, 0x24, 0x14, 0x81, 0xa8, 0xe, 0xb1, 0x9b, 0x59, 0x60, 0x86, 0x64, 0x92, 0xc2, 0x5c, 0xc2, 0x2d, 0x92,
        0xcc, 0x9e, 0xbb, 0xa8, 0xed, 0xe5, 0x2b, 0xd1, 0x40, 0xdf, 0xdd, 0x57, 0x8d, 0x96, 0x3, 0x34, 0x6e, 0xbf,
        0xaf, 0xfd, 0x0, 0xfd, 0x4f, 0x0, 0x4, 0x35, 0xb8, 0x2b, 0x3b, 0xec, 0x33, 0x48, 0x94, 0xd0, 0x3c, 0x16, 0x98,
        0x9, 0xd1, 0xbc, 0x0, 0x36, 0xb3, 0x9d, 0x60, 0x7f, 0xab, 0x29, 0xe4, 0xca, 0xc0, 0x30, 0xd7, 0x45, 0x7d, 0xd7,
        0xb7, 0xf2, 0xc5, 0x6e, 0x7c, 0x9a, 0x5d, 0xe8, 0xfc, 0x2c, 0x27, 0x7b, 0xdb, 0x30, 0xb9, 0xc3, 0x51, 0x6c,
        0xc7, 0x35, 0x0, 0xeb, 0x8c, 0x27, 0xf9, 0x70, 0xe4, 0x54, 0xee, 0xb0, 0xe6, 0xbe, 0xb8, 0x94, 0x14, 0x6f,
        0xf5, 0xa6, 0x28, 0xa2, 0xc3, 0x7e, 0x3c, 0x93, 0x5a, 0xdd, 0x79, 0x44, 0x7f, 0x9c, 0xf8, 0xde, 0x6c, 0xfa,
        0xda, 0xa9, 0xe5, 0x42, 0x99, 0x4e, 0x60, 0x21, 0x9e, 0x12, 0x4a, 0x94, 0xb5, 0x9b, 0xa6, 0x0, 0x57, 0x23,
        0x7b, 0xcf, 0x38, 0xe8, 0xe3, 0xcb, 0x1d, 0xf8, 0x13, 0x9f, 0x2f, 0x35, 0x91, 0xb4, 0xd8, 0xac, 0xe8, 0xe7,
        0xb2, 0x87, 0x3f, 0xac, 0xd, 0xcc, 0x6f, 0xbd, 0xfb, 0x5f, 0xd6, 0x68, 0x37, 0x61, 0xe8, 0x71, 0xbe, 0xc6,
        0xc0, 0xae, 0x52, 0xf5, 0x1d, 0xc1, 0x1, 0xc8, 0xfa, 0x89, 0xf, 0x3b, 0x90, 0x57, 0xa5, 0x99, 0xec, 0xa, 0xb8,
        0xab, 0x6d, 0x12, 0x9a, 0x8b, 0xe8, 0xcc, 0xe0, 0x30, 0x9f, 0x42, 0x35, 0x7, 0xa0, 0x4a, 0x71, 0xab, 0x6d,
        0x82, 0x98, 0x9b, 0x7f, 0xb3, 0xc7, 0x6b, 0x25, 0x6f, 0xe5, 0x86, 0xa8, 0xdb, 0xb2, 0x7f, 0x37, 0xb1, 0xd3,
        0x46, 0xe9, 0xe6, 0x92, 0xbe, 0x69, 0x90, 0xbf, 0xc5, 0xf0, 0xb4, 0xe1, 0x22, 0xe4, 0xc5, 0x7d, 0x1a, 0x28,
        0x50, 0x5b, 0x36, 0x3d, 0x86, 0x80, 0x92, 0x22, 0xed, 0xc6, 0x5d, 0x2a, 0x3f, 0xad, 0x75, 0xb1, 0x3a, 0x5e,
        0xae, 0xed, 0x4f, 0xa5, 0xaa, 0x48, 0x85, 0x5f, 0xb8, 0x21, 0xa, 0x55, 0x5d, 0x2f, 0x2c, 0x17, 0xf7, 0xac,
        0x38, 0xa3, 0x95, 0x62, 0x86, 0xc2, 0xa3, 0x6a, 0x44, 0xdc, 0xb3, 0x43, 0x44, 0xc3, 0x3b, 0xc8, 0xc2, 0x5d,
        0xe8, 0x12, 0x35, 0xae, 0xfd, 0x26, 0x75, 0x87, 0x6, 0x7, 0xe0, 0x81, 0xe7, 0x4b, 0x2f, 0x54, 0xd6, 0x4a, 0x1c,
        0xb9, 0x2f, 0xfb, 0xad, 0x6d, 0x32, 0x94, 0x68, 0x65, 0x6, 0xa9, 0x9f, 0xf4, 0xe9, 0x8e, 0xaf, 0x6, 0xb0, 0x41,
        0x11, 0xbb, 0x98, 0xec, 0x76, 0x40, 0x7a, 0xd, 0xa7, 0x7, 0x77, 0x1b, 0xa0, 0x7, 0x8b, 0x84, 0x9e, 0xeb, 0xda,
        0x80, 0xcf, 0xc, 0x48, 0xa9, 0x7f, 0x27, 0xcd, 0xa5, 0x1a, 0x92, 0xfc, 0xde, 0x99, 0xe2, 0x97, 0x83, 0x80,
        0x65, 0xbf, 0xb1, 0xba, 0xed, 0xdb, 0x3a, 0xe0, 0xee, 0xc2, 0x2, 0x8, 0x21, 0x60, 0xfe, 0x91, 0x7a, 0xcd, 0x92,
        0xd3, 0x12, 0x13, 0x19, 0x82, 0x90, 0xd2, 0xb4, 0x9a, 0xd7, 0x32, 0xd0, 0xf2, 0x85, 0x99, 0xa4, 0x0, 0xcb,
        0x4f, 0x8a, 0xf8, 0x86, 0x50, 0x11, 0x23, 0x53, 0xe9, 0x6a, 0xe, 0x2a, 0x19, 0x7c, 0xe8, 0x80, 0x17, 0x9e,
        0xc9, 0xf4, 0x19, 0x28, 0xb6, 0x32, 0x24, 0x61, 0xac, 0xe5, 0xaa, 0x11, 0x53, 0x1b, 0x34, 0x1f, 0x24, 0x85,
        0x14, 0x86, 0xb1, 0x9e, 0x2e, 0x4d, 0x82, 0x12, 0x69, 0x6a, 0xbb, 0xb3, 0x8f, 0xf3, 0xc2, 0x40, 0x7c, 0xbd,
        0xad, 0x31, 0xdd, 0x6, 0xf5, 0x16, 0x3c, 0xb, 0x43, 0x31, 0x1, 0x39, 0xfd, 0xa, 0xfe, 0x5d, 0x5d, 0x59, 0x1a,
        0xf1, 0x3a, 0xc5, 0xc5, 0xeb, 0x30, 0x57, 0xa4, 0xdc, 0xf4, 0xfa, 0xa3, 0xf, 0x71, 0xb6, 0x52, 0xb8, 0x73, 0x5,
        0x8a, 0xcf, 0xdb, 0x9b, 0xdb, 0x65, 0xdb, 0x64, 0xbd, 0x27, 0x45, 0xde, 0xe6, 0x50, 0x0, 0xa, 0x1e, 0x4d, 0xce,
        0x98, 0xe0, 0x2e, 0x2e, 0xe0, 0xd9, 0x44, 0xbf, 0x86, 0x60, 0xb1, 0x33, 0xb3, 0x33, 0xaa, 0x8e, 0x5, 0x96,
        0x10, 0xca, 0x4b, 0x2c, 0x56, 0xdf, 0x42, 0x59, 0xdc, 0x93, 0xc1, 0x79, 0xed, 0x0, 0x54, 0x44, 0x40, 0xf7,
        0x86, 0xaa, 0x8e, 0xbb, 0x5c, 0x1a, 0x6, 0x28, 0xea, 0x11, 0xab, 0xba, 0x6a, 0x36, 0x1c, 0x30, 0x6c, 0x66,
        0x11, 0xce, 0xf4, 0xd, 0xab, 0xed, 0xa0, 0x50, 0xeb, 0x13, 0xe1, 0x22, 0x1a, 0x75, 0x68, 0x29, 0x62, 0x10,
        0xae, 0x68, 0x80, 0xf6, 0xa7, 0xd4, 0x9d, 0xcd, 0x2c, 0x22, 0x6c, 0xab, 0x44, 0x4d, 0x53, 0xad, 0x1c, 0x2,
        0x5d, 0x3, 0xbb, 0x9b, 0x41, 0x97, 0x43, 0x46, 0x24, 0x34, 0xdf, 0x7a, 0xaf, 0x27, 0xbd, 0xac, 0x4f, 0x31,
        0xed, 0xeb, 0x6d, 0x9f, 0x46, 0x2d, 0x78, 0xc7, 0xad, 0x60, 0xea, 0x21, 0x52, 0x1f, 0x66, 0x4, 0xd4, 0xe2, 0x0,
        0x3, 0xda, 0xee, 0x4a, 0xa, 0xc7, 0x5b, 0x70, 0x12, 0x9f, 0xb7, 0xa2, 0x6a, 0x7d, 0xca, 0x28, 0x3a, 0xc6, 0x5e,
        0x57, 0x2, 0xb1, 0x88, 0x29, 0x72, 0xa4, 0x82, 0x9a, 0x59, 0xb6, 0xc0, 0x63, 0xbb, 0x88, 0xc5, 0x15, 0x3f,
        0x33, 0xf5, 0x24, 0x54, 0xbc, 0x16, 0x7c, 0xc6, 0xda, 0xd8, 0xfa, 0xb9, 0xe5, 0xca, 0x1e, 0x49, 0xdc, 0x2a,
        0x25, 0x42, 0xe, 0x58, 0xa1, 0x60, 0x1, 0x91, 0x1d, 0x8a, 0xaf, 0x91, 0x60, 0x9, 0x17, 0xed, 0xc8, 0x28, 0xcf,
        0x88, 0xb0, 0xb0, 0x40, 0xca, 0x6d, 0xe1, 0x9, 0xe, 0x19, 0x4a, 0xc2, 0x48, 0xba, 0x5a, 0x22, 0xfe, 0x4b, 0xe2,
        0x38, 0xe6, 0xe0, 0x44, 0x33, 0x8b, 0xcd, 0xc, 0x25, 0x2b, 0x89, 0x68, 0x64, 0x61, 0x55, 0x3a, 0x55, 0xb2,
        0x7c, 0xbc, 0xe6, 0x93, 0x62, 0x5c, 0xc1, 0x76, 0x1c, 0x5c, 0x1e, 0x59, 0x3f, 0xcb, 0x39, 0x53, 0x19, 0xf3,
        0x7e, 0xaf, 0xc3, 0xab, 0x74, 0x78, 0x73, 0x73, 0x4d, 0x2f, 0xe6, 0x9f, 0x3c, 0xb1, 0xc8, 0x77, 0xbe, 0x16,
        0xd2, 0xe5, 0x8, 0xe1, 0x71, 0xce, 0xb4, 0x2, 0xd7, 0x69, 0x1, 0x3e, 0x49, 0x31, 0x27, 0x5, 0xad, 0x92, 0xdf,
        0x10, 0x90, 0xc5, 0x54, 0x76, 0xc4, 0x4f, 0x8f, 0x14, 0x8d, 0xff, 0x88, 0xd0, 0x50, 0x20, 0x8d, 0x70, 0x8a,
        0xcb, 0x43, 0xab, 0x31, 0x30, 0xec, 0x7b, 0x93, 0x71, 0xfc, 0xc3, 0x68, 0x4a, 0x72, 0x3e, 0xe7, 0x84, 0xce,
        0x91, 0x68, 0xf, 0xfa, 0xb9, 0xce, 0x4f, 0x7a, 0xde, 0x18, 0x12, 0x90, 0xf5, 0xf2, 0xce, 0xc5, 0xc5, 0xd6,
        0x64, 0x5b, 0xa1, 0x66, 0xe0, 0x3a, 0xff, 0xd, 0x49, 0xb1, 0x5d, 0x2c, 0x6e, 0x3e, 0x5b, 0x86, 0x2e, 0xd7,
        0xae, 0xd5, 0xc1, 0xcc, 0xc7, 0x3b, 0x44, 0x1f, 0x72, 0x67, 0x84, 0x6, 0xbb, 0x5c, 0x13, 0xff, 0x20, 0xd8,
        0x21, 0x22, 0xd6, 0x9c, 0x2b, 0xa6, 0x47, 0x85, 0xbd, 0xcf, 0xc6, 0xc3, 0x4d, 0x5d, 0xee, 0x7d, 0x63, 0x4f,
        0xe4, 0xab, 0x37, 0xfc, 0x95, 0x84, 0xbd, 0xc8, 0x14, 0x24, 0x30, 0x43, 0x29, 0xc6, 0x8d, 0xd5, 0xa7, 0x84,
        0xf6, 0x4a, 0x74, 0x54, 0x7e, 0x4b, 0x4d, 0xba, 0xbc, 0x2c, 0xa8, 0xe0, 0x3b, 0xbd, 0xd4, 0x8d, 0x32, 0xf8,
        0x92, 0x91, 0x3f, 0x42, 0xdb, 0xbe, 0xac, 0x66, 0x8d, 0x78, 0x3f, 0xca, 0xe9, 0x45, 0x78, 0xd7, 0x2f, 0xec,
        0xfa, 0xb6, 0x7c, 0x92, 0xed, 0xb, 0xff, 0xa0, 0xb7, 0xd4, 0xfb, 0xe8, 0x6e, 0x63, 0x52, 0x54, 0xa9, 0x64,
        0x8e, 0x61, 0xd6, 0x1a, 0x7f, 0x97, 0x53, 0x41, 0xb2, 0xa0, 0xf2, 0x4c, 0xff, 0x54, 0xd7, 0x9c, 0x90, 0xcf,
        0x3, 0xa3, 0xc6, 0x59, 0xb2, 0xb2, 0xe0, 0xb2, 0xe2, 0xd6, 0x54, 0xd8, 0xad, 0x71, 0xf4, 0xae, 0xc7, 0x7a,
        0xfd, 0x30, 0xb0, 0x6c, 0xa2, 0x4b, 0xc4, 0x2e, 0x59, 0xab, 0xcd, 0xb4, 0xf4, 0xe7, 0xde, 0xad, 0x14, 0x1b,
        0x64, 0x42, 0x4b, 0x5d, 0xf3, 0xba, 0xf3, 0x7a, 0xb9, 0xb7, 0xd1, 0xcb, 0x42, 0xec, 0x23, 0x8a, 0xbb, 0x44,
        0x79, 0x58, 0x9e, 0x79, 0x38, 0x20, 0x8, 0x0, 0x8e, 0xa7, 0xbf, 0xbd, 0x75, 0x69, 0xd5, 0x4a, 0x83, 0x62, 0x70,
        0x9b, 0xb3, 0xf2, 0x28, 0xdb, 0xf, 0x8d, 0xad, 0xf3, 0xb9, 0xa9, 0x2d, 0x16, 0x42, 0x1b, 0x55, 0x1b, 0x66,
        0xfa, 0x14, 0xa8, 0x29, 0x49, 0x23, 0xb2, 0xfd, 0x68, 0x9, 0x69, 0x7d, 0x74, 0xc6, 0x4f, 0xc8, 0x29, 0xc5,
        0x8a, 0x9a, 0xde, 0x7, 0xd3, 0x78, 0xf4, 0xe6, 0x5b, 0x8e, 0x34, 0xc4, 0xf, 0x9, 0x0, 0x68, 0xce, 0x2d, 0x81,
        0x27, 0x24, 0x2f, 0xcd, 0x70, 0x5c, 0x86, 0x9c, 0x2d, 0x10, 0xee, 0xd4, 0x9a, 0x1a, 0xdf, 0x2c, 0xc8, 0x65,
        0x8a, 0xd4, 0xd7, 0x6d, 0x10, 0x16, 0x9f, 0xeb, 0xc7, 0x64, 0x61, 0xb4, 0xbd, 0x51, 0x7b, 0x88, 0xc5, 0x50,
        0x95, 0xc7, 0xa4, 0x7e, 0xa9, 0x74, 0x44, 0x9e, 0xd5, 0x56, 0x95, 0x4, 0xd8, 0xb0, 0xb2, 0x5c, 0x4f, 0x5, 0x82,
        0x2b, 0xfc, 0x1e, 0x53, 0x9d, 0xe2, 0x10, 0xaa, 0x32, 0x51, 0x91, 0x1d, 0xeb, 0x47, 0x4, 0x6, 0x70, 0xd6, 0x61,
        0xb6, 0xc8, 0xe3, 0xd, 0x52, 0x84, 0xdb, 0x9c, 0x55, 0x6f, 0x46, 0x6c, 0x50, 0xb6, 0x62, 0x42, 0x31, 0xfa,
        0x63, 0x9d, 0x97, 0xa7, 0x9c, 0x31, 0xb1, 0x43, 0x54, 0x4f, 0x5f, 0x7e, 0x6a, 0x34, 0x91, 0x38, 0x68, 0x9b,
        0x6b, 0x5e, 0xc1, 0x48, 0x5, 0x9d, 0x1b, 0x7e, 0x95, 0x63, 0x64, 0x9f, 0x3c, 0x4c, 0x71, 0x5c, 0x9b, 0x87,
        0xce, 0x31, 0x5c, 0xc7, 0xa7, 0x24, 0x16, 0xdb, 0x83, 0xdb, 0x54, 0xea, 0x6a, 0xb8, 0xe, 0xd6, 0xba, 0x10,
        0xeb, 0xe3, 0x7c, 0xa0, 0xcc, 0x91, 0xe8, 0x6, 0x69, 0x66, 0x60, 0xef, 0x55, 0x4a, 0x3e, 0xf9, 0xe6, 0xb4,
        0x5b, 0x48, 0xb6, 0xf4, 0xeb, 0x8, 0xe6, 0xc3, 0xb5, 0x22, 0xf8, 0x18, 0x1b, 0xc0, 0xb6, 0xdb, 0x87, 0x8b,
        0x13, 0x3c, 0x21,
    ];

    let mac_data = vec![
        0xe8, 0x38, 0x46, 0xb7, 0xa8, 0xf9, 0x5c, 0x66, 0xe3, 0x8e, 0x10, 0x8f, 0xb6, 0x4, 0x80, 0xc7,
    ];

    let upgrade_license = ServerUpgradeLicense {
        license_header: LicenseHeader {
            security_header: BasicSecurityHeader {
                flags: BasicSecurityHeaderFlags::LICENSE_PKT,
            },
            preamble_message_type: PreambleType::NewLicense,
            preamble_flags: PreambleFlags::empty(),
            preamble_version: PreambleVersion::V3,
            preamble_message_size: u16::try_from(
                PREAMBLE_SIZE + BLOB_LENGTH_SIZE + BLOB_TYPE_SIZE + encrypted_license_info.len() + MAC_SIZE,
            )
            .expect("can't panic"),
        },
        encrypted_license_info,
        mac_data,
    };

    let encryption_info = LicenseEncryptionData {
        premaster_secret: Vec::new(), // this field is not involved in this unit test
        mac_salt_key: vec![
            0xd5, 0x2c, 0x7c, 0xd2, 0x71, 0x15, 0x2c, 0x41, 0xbb, 0xd8, 0x36, 0xdb, 0x19, 0x3e, 0xc0, 0xf3,
        ],
        license_key: vec![
            0x88, 0x7d, 0x33, 0xa6, 0x13, 0xd, 0x76, 0xbf, 0x76, 0x2a, 0xf, 0x57, 0x71, 0x1d, 0x40, 0xa3,
        ],
    };

    upgrade_license.verify_server_license(&encryption_info).unwrap();
}
