#![cfg_attr(feature = "no-std", no_std)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(dead_code)]
#[cfg(feature = "no-std")]
extern crate alloc;
#[cfg(feature = "no-std")]
extern crate no_std_compat as std;
pub use self::cudaDataType_t as cudaDataType;
pub use self::libraryPropertyType_t as libraryPropertyType;
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type FILE = _IO_FILE;
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type _IO_lock_t = ::core::ffi::c_void;
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type __off64_t = ::core::ffi::c_long;
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type __off_t = ::core::ffi::c_long;
pub type bsric02Info_t = *mut bsric02Info;
pub type bsrilu02Info_t = *mut bsrilu02Info;
pub type bsrsm2Info_t = *mut bsrsm2Info;
pub type bsrsv2Info_t = *mut bsrsv2Info;
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
pub type csrgemm2Info_t = *mut csrgemm2Info;
pub type csric02Info_t = *mut csric02Info;
pub type csrilu02Info_t = *mut csrilu02Info;
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
pub type csrsm2Info_t = *mut csrsm2Info;
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
pub type csrsv2Info_t = *mut csrsv2Info;
pub type csru2csrInfo_t = *mut csru2csrInfo;
pub type cuComplex = cuFloatComplex;
pub type cuDoubleComplex = double2;
pub type cuFloatComplex = float2;
pub type cudaStream_t = *mut CUstream_st;
pub type cusparseColorInfo_t = *mut cusparseColorInfo;
#[cfg(any(
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type cusparseConstDnMatDescr_t = *const cusparseDnMatDescr;
#[cfg(any(
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type cusparseConstDnVecDescr_t = *const cusparseDnVecDescr;
#[cfg(any(
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type cusparseConstSpMatDescr_t = *const cusparseSpMatDescr;
#[cfg(any(
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type cusparseConstSpVecDescr_t = *const cusparseSpVecDescr;
pub type cusparseDnMatDescr_t = *mut cusparseDnMatDescr;
pub type cusparseDnVecDescr_t = *mut cusparseDnVecDescr;
pub type cusparseHandle_t = *mut cusparseContext;
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type cusparseLoggerCallback_t = ::core::option::Option<
    unsafe extern "C" fn(
        logLevel: ::core::ffi::c_int,
        functionName: *const ::core::ffi::c_char,
        message: *const ::core::ffi::c_char,
    ),
>;
pub type cusparseMatDescr_t = *mut cusparseMatDescr;
pub type cusparseSpGEMMDescr_t = *mut cusparseSpGEMMDescr;
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
pub type cusparseSpMMOpPlan_t = *mut cusparseSpMMOpPlan;
pub type cusparseSpMatDescr_t = *mut cusparseSpMatDescr;
pub type cusparseSpSMDescr_t = *mut cusparseSpSMDescr;
pub type cusparseSpSVDescr_t = *mut cusparseSpSVDescr;
pub type cusparseSpVecDescr_t = *mut cusparseSpVecDescr;
pub type pruneInfo_t = *mut pruneInfo;
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudaDataType_t {
    CUDA_R_16F = 2,
    CUDA_C_16F = 6,
    CUDA_R_16BF = 14,
    CUDA_C_16BF = 15,
    CUDA_R_32F = 0,
    CUDA_C_32F = 4,
    CUDA_R_64F = 1,
    CUDA_C_64F = 5,
    CUDA_R_4I = 16,
    CUDA_C_4I = 17,
    CUDA_R_4U = 18,
    CUDA_C_4U = 19,
    CUDA_R_8I = 3,
    CUDA_C_8I = 7,
    CUDA_R_8U = 8,
    CUDA_C_8U = 9,
    CUDA_R_16I = 20,
    CUDA_C_16I = 21,
    CUDA_R_16U = 22,
    CUDA_C_16U = 23,
    CUDA_R_32I = 10,
    CUDA_C_32I = 11,
    CUDA_R_32U = 12,
    CUDA_C_32U = 13,
    CUDA_R_64I = 24,
    CUDA_C_64I = 25,
    CUDA_R_64U = 26,
    CUDA_C_64U = 27,
}
#[cfg(any(
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudaDataType_t {
    CUDA_R_16F = 2,
    CUDA_C_16F = 6,
    CUDA_R_16BF = 14,
    CUDA_C_16BF = 15,
    CUDA_R_32F = 0,
    CUDA_C_32F = 4,
    CUDA_R_64F = 1,
    CUDA_C_64F = 5,
    CUDA_R_4I = 16,
    CUDA_C_4I = 17,
    CUDA_R_4U = 18,
    CUDA_C_4U = 19,
    CUDA_R_8I = 3,
    CUDA_C_8I = 7,
    CUDA_R_8U = 8,
    CUDA_C_8U = 9,
    CUDA_R_16I = 20,
    CUDA_C_16I = 21,
    CUDA_R_16U = 22,
    CUDA_C_16U = 23,
    CUDA_R_32I = 10,
    CUDA_C_32I = 11,
    CUDA_R_32U = 12,
    CUDA_C_32U = 13,
    CUDA_R_64I = 24,
    CUDA_C_64I = 25,
    CUDA_R_64U = 26,
    CUDA_C_64U = 27,
    CUDA_R_8F_E4M3 = 28,
    CUDA_R_8F_E5M2 = 29,
}
#[cfg(any(feature = "cuda-12080", feature = "cuda-12090"))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudaDataType_t {
    CUDA_R_16F = 2,
    CUDA_C_16F = 6,
    CUDA_R_16BF = 14,
    CUDA_C_16BF = 15,
    CUDA_R_32F = 0,
    CUDA_C_32F = 4,
    CUDA_R_64F = 1,
    CUDA_C_64F = 5,
    CUDA_R_4I = 16,
    CUDA_C_4I = 17,
    CUDA_R_4U = 18,
    CUDA_C_4U = 19,
    CUDA_R_8I = 3,
    CUDA_C_8I = 7,
    CUDA_R_8U = 8,
    CUDA_C_8U = 9,
    CUDA_R_16I = 20,
    CUDA_C_16I = 21,
    CUDA_R_16U = 22,
    CUDA_C_16U = 23,
    CUDA_R_32I = 10,
    CUDA_C_32I = 11,
    CUDA_R_32U = 12,
    CUDA_C_32U = 13,
    CUDA_R_64I = 24,
    CUDA_C_64I = 25,
    CUDA_R_64U = 26,
    CUDA_C_64U = 27,
    CUDA_R_8F_E4M3 = 28,
    CUDA_R_8F_E5M2 = 29,
    CUDA_R_8F_UE8M0 = 30,
    CUDA_R_6F_E2M3 = 31,
    CUDA_R_6F_E3M2 = 32,
    CUDA_R_4F_E2M1 = 33,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseAction_t {
    CUSPARSE_ACTION_SYMBOLIC = 0,
    CUSPARSE_ACTION_NUMERIC = 1,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseAlgMode_t {
    CUSPARSE_ALG_MERGE_PATH = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseColorAlg_t {
    CUSPARSE_COLOR_ALG0 = 0,
    CUSPARSE_COLOR_ALG1 = 1,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseCsr2CscAlg_t {
    CUSPARSE_CSR2CSC_ALG1 = 1,
    CUSPARSE_CSR2CSC_ALG2 = 2,
}
#[cfg(any(
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseCsr2CscAlg_t {
    CUSPARSE_CSR2CSC_ALG_DEFAULT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseDenseToSparseAlg_t {
    CUSPARSE_DENSETOSPARSE_ALG_DEFAULT = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseDiagType_t {
    CUSPARSE_DIAG_TYPE_NON_UNIT = 0,
    CUSPARSE_DIAG_TYPE_UNIT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseDirection_t {
    CUSPARSE_DIRECTION_ROW = 0,
    CUSPARSE_DIRECTION_COLUMN = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseFillMode_t {
    CUSPARSE_FILL_MODE_LOWER = 0,
    CUSPARSE_FILL_MODE_UPPER = 1,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseFormat_t {
    CUSPARSE_FORMAT_CSR = 1,
    CUSPARSE_FORMAT_CSC = 2,
    CUSPARSE_FORMAT_COO = 3,
    CUSPARSE_FORMAT_COO_AOS = 4,
    CUSPARSE_FORMAT_BLOCKED_ELL = 5,
}
#[cfg(any(feature = "cuda-12000"))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseFormat_t {
    CUSPARSE_FORMAT_CSR = 1,
    CUSPARSE_FORMAT_CSC = 2,
    CUSPARSE_FORMAT_COO = 3,
    CUSPARSE_FORMAT_BLOCKED_ELL = 5,
}
#[cfg(any(
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseFormat_t {
    CUSPARSE_FORMAT_CSR = 1,
    CUSPARSE_FORMAT_CSC = 2,
    CUSPARSE_FORMAT_COO = 3,
    CUSPARSE_FORMAT_BLOCKED_ELL = 5,
    CUSPARSE_FORMAT_BSR = 6,
    CUSPARSE_FORMAT_SLICED_ELLPACK = 7,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseIndexBase_t {
    CUSPARSE_INDEX_BASE_ZERO = 0,
    CUSPARSE_INDEX_BASE_ONE = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseIndexType_t {
    CUSPARSE_INDEX_16U = 1,
    CUSPARSE_INDEX_32I = 2,
    CUSPARSE_INDEX_64I = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseMatrixType_t {
    CUSPARSE_MATRIX_TYPE_GENERAL = 0,
    CUSPARSE_MATRIX_TYPE_SYMMETRIC = 1,
    CUSPARSE_MATRIX_TYPE_HERMITIAN = 2,
    CUSPARSE_MATRIX_TYPE_TRIANGULAR = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseOperation_t {
    CUSPARSE_OPERATION_NON_TRANSPOSE = 0,
    CUSPARSE_OPERATION_TRANSPOSE = 1,
    CUSPARSE_OPERATION_CONJUGATE_TRANSPOSE = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseOrder_t {
    CUSPARSE_ORDER_COL = 1,
    CUSPARSE_ORDER_ROW = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparsePointerMode_t {
    CUSPARSE_POINTER_MODE_HOST = 0,
    CUSPARSE_POINTER_MODE_DEVICE = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSDDMMAlg_t {
    CUSPARSE_SDDMM_ALG_DEFAULT = 0,
}
#[cfg(any(feature = "cuda-11040"))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSideMode_t {
    CUSPARSE_SIDE_LEFT = 0,
    CUSPARSE_SIDE_RIGHT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSolvePolicy_t {
    CUSPARSE_SOLVE_POLICY_NO_LEVEL = 0,
    CUSPARSE_SOLVE_POLICY_USE_LEVEL = 1,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpGEMMAlg_t {
    CUSPARSE_SPGEMM_DEFAULT = 0,
    CUSPARSE_SPGEMM_CSR_ALG_DETERMINITIC = 1,
    CUSPARSE_SPGEMM_CSR_ALG_NONDETERMINITIC = 2,
}
#[cfg(any(
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpGEMMAlg_t {
    CUSPARSE_SPGEMM_DEFAULT = 0,
    CUSPARSE_SPGEMM_CSR_ALG_DETERMINITIC = 1,
    CUSPARSE_SPGEMM_CSR_ALG_NONDETERMINITIC = 2,
    CUSPARSE_SPGEMM_ALG1 = 3,
    CUSPARSE_SPGEMM_ALG2 = 4,
    CUSPARSE_SPGEMM_ALG3 = 5,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpMMAlg_t {
    CUSPARSE_MM_ALG_DEFAULT = 0,
    CUSPARSE_COOMM_ALG1 = 1,
    CUSPARSE_COOMM_ALG2 = 2,
    CUSPARSE_COOMM_ALG3 = 3,
    CUSPARSE_CSRMM_ALG1 = 4,
    CUSPARSE_SPMM_COO_ALG4 = 5,
    CUSPARSE_SPMM_CSR_ALG2 = 6,
    CUSPARSE_SPMM_CSR_ALG3 = 12,
    CUSPARSE_SPMM_BLOCKED_ELL_ALG1 = 13,
}
#[cfg(any(
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpMMAlg_t {
    CUSPARSE_SPMM_ALG_DEFAULT = 0,
    CUSPARSE_SPMM_COO_ALG1 = 1,
    CUSPARSE_SPMM_COO_ALG2 = 2,
    CUSPARSE_SPMM_COO_ALG3 = 3,
    CUSPARSE_SPMM_COO_ALG4 = 5,
    CUSPARSE_SPMM_CSR_ALG1 = 4,
    CUSPARSE_SPMM_CSR_ALG2 = 6,
    CUSPARSE_SPMM_CSR_ALG3 = 12,
    CUSPARSE_SPMM_BLOCKED_ELL_ALG1 = 13,
}
#[cfg(any(
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpMMAlg_t {
    CUSPARSE_SPMM_ALG_DEFAULT = 0,
    CUSPARSE_SPMM_COO_ALG1 = 1,
    CUSPARSE_SPMM_COO_ALG2 = 2,
    CUSPARSE_SPMM_COO_ALG3 = 3,
    CUSPARSE_SPMM_COO_ALG4 = 5,
    CUSPARSE_SPMM_CSR_ALG1 = 4,
    CUSPARSE_SPMM_CSR_ALG2 = 6,
    CUSPARSE_SPMM_CSR_ALG3 = 12,
    CUSPARSE_SPMM_BLOCKED_ELL_ALG1 = 13,
    CUSPARSE_SPMM_BSR_ALG1 = 14,
}
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpMMOpAlg_t {
    CUSPARSE_SPMM_OP_ALG_DEFAULT = 0,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpMVAlg_t {
    CUSPARSE_MV_ALG_DEFAULT = 0,
    CUSPARSE_COOMV_ALG = 1,
    CUSPARSE_CSRMV_ALG1 = 2,
    CUSPARSE_CSRMV_ALG2 = 3,
    CUSPARSE_SPMV_COO_ALG2 = 4,
}
#[cfg(any(feature = "cuda-12000"))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpMVAlg_t {
    CUSPARSE_SPMV_ALG_DEFAULT = 0,
    CUSPARSE_SPMV_CSR_ALG1 = 2,
    CUSPARSE_SPMV_CSR_ALG2 = 3,
    CUSPARSE_SPMV_COO_ALG1 = 1,
    CUSPARSE_SPMV_COO_ALG2 = 4,
}
#[cfg(any(
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpMVAlg_t {
    CUSPARSE_SPMV_ALG_DEFAULT = 0,
    CUSPARSE_SPMV_CSR_ALG1 = 2,
    CUSPARSE_SPMV_CSR_ALG2 = 3,
    CUSPARSE_SPMV_COO_ALG1 = 1,
    CUSPARSE_SPMV_COO_ALG2 = 4,
    CUSPARSE_SPMV_SELL_ALG1 = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpMatAttribute_t {
    CUSPARSE_SPMAT_FILL_MODE = 0,
    CUSPARSE_SPMAT_DIAG_TYPE = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpSMAlg_t {
    CUSPARSE_SPSM_ALG_DEFAULT = 0,
}
#[cfg(any(
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpSMUpdate_t {
    CUSPARSE_SPSM_UPDATE_GENERAL = 0,
    CUSPARSE_SPSM_UPDATE_DIAGONAL = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpSVAlg_t {
    CUSPARSE_SPSV_ALG_DEFAULT = 0,
}
#[cfg(any(
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSpSVUpdate_t {
    CUSPARSE_SPSV_UPDATE_GENERAL = 0,
    CUSPARSE_SPSV_UPDATE_DIAGONAL = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseSparseToDenseAlg_t {
    CUSPARSE_SPARSETODENSE_ALG_DEFAULT = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cusparseStatus_t {
    CUSPARSE_STATUS_SUCCESS = 0,
    CUSPARSE_STATUS_NOT_INITIALIZED = 1,
    CUSPARSE_STATUS_ALLOC_FAILED = 2,
    CUSPARSE_STATUS_INVALID_VALUE = 3,
    CUSPARSE_STATUS_ARCH_MISMATCH = 4,
    CUSPARSE_STATUS_MAPPING_ERROR = 5,
    CUSPARSE_STATUS_EXECUTION_FAILED = 6,
    CUSPARSE_STATUS_INTERNAL_ERROR = 7,
    CUSPARSE_STATUS_MATRIX_TYPE_NOT_SUPPORTED = 8,
    CUSPARSE_STATUS_ZERO_PIVOT = 9,
    CUSPARSE_STATUS_NOT_SUPPORTED = 10,
    CUSPARSE_STATUS_INSUFFICIENT_RESOURCES = 11,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum libraryPropertyType_t {
    MAJOR_VERSION = 0,
    MINOR_VERSION = 1,
    PATCH_LEVEL = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUstream_st {
    _unused: [u8; 0],
}
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _IO_FILE {
    pub _flags: ::core::ffi::c_int,
    pub _IO_read_ptr: *mut ::core::ffi::c_char,
    pub _IO_read_end: *mut ::core::ffi::c_char,
    pub _IO_read_base: *mut ::core::ffi::c_char,
    pub _IO_write_base: *mut ::core::ffi::c_char,
    pub _IO_write_ptr: *mut ::core::ffi::c_char,
    pub _IO_write_end: *mut ::core::ffi::c_char,
    pub _IO_buf_base: *mut ::core::ffi::c_char,
    pub _IO_buf_end: *mut ::core::ffi::c_char,
    pub _IO_save_base: *mut ::core::ffi::c_char,
    pub _IO_backup_base: *mut ::core::ffi::c_char,
    pub _IO_save_end: *mut ::core::ffi::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::core::ffi::c_int,
    pub _flags2: ::core::ffi::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::core::ffi::c_ushort,
    pub _vtable_offset: ::core::ffi::c_schar,
    pub _shortbuf: [::core::ffi::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::core::ffi::c_void,
    pub __pad5: usize,
    pub _mode: ::core::ffi::c_int,
    pub _unused2: [::core::ffi::c_char; 20usize],
}
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bsric02Info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bsrilu02Info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bsrsm2Info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bsrsv2Info {
    _unused: [u8; 0],
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct csrgemm2Info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct csric02Info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct csrilu02Info {
    _unused: [u8; 0],
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct csrsm2Info {
    _unused: [u8; 0],
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct csrsv2Info {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct csru2csrInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseColorInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseContext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseDnMatDescr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseDnVecDescr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseMatDescr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseSpGEMMDescr {
    _unused: [u8; 0],
}
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseSpMMOpPlan {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseSpMatDescr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseSpSMDescr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseSpSVDescr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseSpVecDescr {
    _unused: [u8; 0],
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct double2 {
    pub x: f64,
    pub y: f64,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct float2 {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pruneInfo {
    _unused: [u8; 0],
}
#[cfg(any(feature = "cuda-12080", feature = "cuda-12090"))]
impl cudaDataType_t {
    pub const CUDA_R_8F_UE4M3: cudaDataType_t = cudaDataType_t::CUDA_R_8F_E4M3;
}
#[cfg(any(
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
impl cusparseCsr2CscAlg_t {
    pub const CUSPARSE_CSR2CSC_ALG1: cusparseCsr2CscAlg_t =
        cusparseCsr2CscAlg_t::CUSPARSE_CSR2CSC_ALG_DEFAULT;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMMAlg_t {
    pub const CUSPARSE_SPMM_ALG_DEFAULT: cusparseSpMMAlg_t =
        cusparseSpMMAlg_t::CUSPARSE_MM_ALG_DEFAULT;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMMAlg_t {
    pub const CUSPARSE_SPMM_COO_ALG1: cusparseSpMMAlg_t = cusparseSpMMAlg_t::CUSPARSE_COOMM_ALG1;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMMAlg_t {
    pub const CUSPARSE_SPMM_COO_ALG2: cusparseSpMMAlg_t = cusparseSpMMAlg_t::CUSPARSE_COOMM_ALG2;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMMAlg_t {
    pub const CUSPARSE_SPMM_COO_ALG3: cusparseSpMMAlg_t = cusparseSpMMAlg_t::CUSPARSE_COOMM_ALG3;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMMAlg_t {
    pub const CUSPARSE_SPMM_CSR_ALG1: cusparseSpMMAlg_t = cusparseSpMMAlg_t::CUSPARSE_CSRMM_ALG1;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMVAlg_t {
    pub const CUSPARSE_SPMV_ALG_DEFAULT: cusparseSpMVAlg_t =
        cusparseSpMVAlg_t::CUSPARSE_MV_ALG_DEFAULT;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMVAlg_t {
    pub const CUSPARSE_SPMV_COO_ALG1: cusparseSpMVAlg_t = cusparseSpMVAlg_t::CUSPARSE_COOMV_ALG;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMVAlg_t {
    pub const CUSPARSE_SPMV_CSR_ALG1: cusparseSpMVAlg_t = cusparseSpMVAlg_t::CUSPARSE_CSRMV_ALG1;
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080"
))]
impl cusparseSpMVAlg_t {
    pub const CUSPARSE_SPMV_CSR_ALG2: cusparseSpMVAlg_t = cusparseSpMVAlg_t::CUSPARSE_CSRMV_ALG2;
}
#[cfg(any(
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080",
    feature = "cuda-12090"
))]
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[cfg(not(feature = "dynamic-loading"))]
extern "C" {
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseAxpby(
        handle: cusparseHandle_t,
        alpha: *const ::core::ffi::c_void,
        vecX: cusparseSpVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseAxpby(
        handle: cusparseHandle_t,
        alpha: *const ::core::ffi::c_void,
        vecX: cusparseConstSpVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t;
    pub fn cusparseBlockedEllGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        ellBlockSize: *mut i64,
        ellCols: *mut i64,
        ellColInd: *mut *mut ::core::ffi::c_void,
        ellValue: *mut *mut ::core::ffi::c_void,
        ellIdxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(feature = "cuda-12010"))]
    pub fn cusparseBsrSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
        offsetsBatchStride: i64,
        columnsValuesBatchStride: i64,
        ValuesBatchStride: i64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseBsrSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
        offsetsBatchStride: i64,
        columnsBatchStride: i64,
        ValuesBatchStride: i64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCaxpyi(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        xVal: *const cuComplex,
        xInd: *const ::core::ffi::c_int,
        y: *mut cuComplex,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsric02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsric02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pInputBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsric02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrilu02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrilu02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrilu02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut cuComplex,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrmm(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const cuComplex,
        beta: *const cuComplex,
        y: *mut cuComplex,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrsm2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrsm2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrsm2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        X: *mut cuComplex,
        ldx: ::core::ffi::c_int,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrsv2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrsv2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *mut cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrsv2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        f: *const cuComplex,
        x: *mut cuComplex,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCbsrxmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        sizeOfMask: ::core::ffi::c_int,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedMaskPtrA: *const ::core::ffi::c_int,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedEndPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const cuComplex,
        beta: *const cuComplex,
        y: *mut cuComplex,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsc2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscSortedValA: *const cuComplex,
        cscSortedRowIndA: *const ::core::ffi::c_int,
        cscSortedColPtrA: *const ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsr2bsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsr2csr_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedColIndA: *const ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValC: *mut cuComplex,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        tol: cuComplex,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsr2csru(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut cuComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsr2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsrcolor(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        fractionToColor: *const f32,
        ncolors: *mut ::core::ffi::c_int,
        coloring: *mut ::core::ffi::c_int,
        reordering: *mut ::core::ffi::c_int,
        info: cusparseColorInfo_t,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsrgeam2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsrgeam2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const cuComplex,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrgemm2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedValD: *const cuComplex,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuComplex,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrgemm2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsric02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsric02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsric02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsrilu02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsrilu02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsrilu02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut cuComplex,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrsm2_analysis(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrsm2_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrsm2_solve(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrsv2_analysis(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrsv2_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCcsrsv2_solve(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        f: *const cuComplex,
        x: *mut cuComplex,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsru2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut cuComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCcsru2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *mut cuComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCdense2csc(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        nnzPerCol: *const ::core::ffi::c_int,
        cscSortedValA: *mut cuComplex,
        cscSortedRowIndA: *mut ::core::ffi::c_int,
        cscSortedColPtrA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCdense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *mut ::core::ffi::c_int,
        csrSortedColIndA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCgebsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCgebsr2gebsc(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        bscVal: *mut cuComplex,
        bscRowInd: *mut ::core::ffi::c_int,
        bscColPtr: *mut ::core::ffi::c_int,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCgebsr2gebsc_bufferSize(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCgebsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCgebsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCgemmi(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        cscValB: *const cuComplex,
        cscColPtrB: *const ::core::ffi::c_int,
        cscRowIndB: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCgemvi(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        xVal: *const cuComplex,
        xInd: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCgemvi_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        pBufferSize: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCgpsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *mut cuComplex,
        dl: *mut cuComplex,
        d: *mut cuComplex,
        du: *mut cuComplex,
        dw: *mut cuComplex,
        x: *mut cuComplex,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCgpsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *const cuComplex,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        dw: *const cuComplex,
        x: *const cuComplex,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCgthr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *const cuComplex,
        xVal: *mut cuComplex,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCgthrz(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *mut cuComplex,
        xVal: *mut cuComplex,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseCgtsv2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCgtsv2StridedBatch(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        x: *mut cuComplex,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCgtsv2StridedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        x: *const cuComplex,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseCgtsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseCgtsv2_nopivot(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCgtsv2_nopivot_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseCgtsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *mut cuComplex,
        d: *mut cuComplex,
        du: *mut cuComplex,
        x: *mut cuComplex,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCgtsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        x: *const cuComplex,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseCnnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        nnzPerRowCol: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCnnz_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        descr: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzPerRow: *mut ::core::ffi::c_int,
        nnzC: *mut ::core::ffi::c_int,
        tol: cuComplex,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstBlockedEllGet(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        ellBlockSize: *mut i64,
        ellCols: *mut i64,
        ellColInd: *mut *const ::core::ffi::c_void,
        ellValue: *mut *const ::core::ffi::c_void,
        ellIdxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstCooGet(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cooRowInd: *mut *const ::core::ffi::c_void,
        cooColInd: *mut *const ::core::ffi::c_void,
        cooValues: *mut *const ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstCscGet(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cscColOffsets: *mut *const ::core::ffi::c_void,
        cscRowInd: *mut *const ::core::ffi::c_void,
        cscValues: *mut *const ::core::ffi::c_void,
        cscColOffsetsType: *mut cusparseIndexType_t,
        cscRowIndType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstCsrGet(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        csrRowOffsets: *mut *const ::core::ffi::c_void,
        csrColInd: *mut *const ::core::ffi::c_void,
        csrValues: *mut *const ::core::ffi::c_void,
        csrRowOffsetsType: *mut cusparseIndexType_t,
        csrColIndType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstDnMatGet(
        dnMatDescr: cusparseConstDnMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        ld: *mut i64,
        values: *mut *const ::core::ffi::c_void,
        type_: *mut cudaDataType,
        order: *mut cusparseOrder_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstDnMatGetValues(
        dnMatDescr: cusparseConstDnMatDescr_t,
        values: *mut *const ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstDnVecGet(
        dnVecDescr: cusparseConstDnVecDescr_t,
        size: *mut i64,
        values: *mut *const ::core::ffi::c_void,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstDnVecGetValues(
        dnVecDescr: cusparseConstDnVecDescr_t,
        values: *mut *const ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstSpMatGetValues(
        spMatDescr: cusparseConstSpMatDescr_t,
        values: *mut *const ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstSpVecGet(
        spVecDescr: cusparseConstSpVecDescr_t,
        size: *mut i64,
        nnz: *mut i64,
        indices: *mut *const ::core::ffi::c_void,
        values: *mut *const ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseConstSpVecGetValues(
        spVecDescr: cusparseConstSpVecDescr_t,
        values: *mut *const ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseConstrainedGeMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseConstrainedGeMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCooAoSGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cooInd: *mut *mut ::core::ffi::c_void,
        cooValues: *mut *mut ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCooGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cooRowInd: *mut *mut ::core::ffi::c_void,
        cooColInd: *mut *mut ::core::ffi::c_void,
        cooValues: *mut *mut ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCooSetPointers(
        spMatDescr: cusparseSpMatDescr_t,
        cooRows: *mut ::core::ffi::c_void,
        cooColumns: *mut ::core::ffi::c_void,
        cooValues: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCooSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
        batchStride: i64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCopyMatDescr(
        dest: cusparseMatDescr_t,
        src: cusparseMatDescr_t,
    ) -> cusparseStatus_t;
    pub fn cusparseCreate(handle: *mut cusparseHandle_t) -> cusparseStatus_t;
    pub fn cusparseCreateBlockedEll(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        ellBlockSize: i64,
        ellCols: i64,
        ellColInd: *mut ::core::ffi::c_void,
        ellValue: *mut ::core::ffi::c_void,
        ellIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(feature = "cuda-12010"))]
    pub fn cusparseCreateBsr(
        spMatDescr: *mut cusparseSpMatDescr_t,
        brows: i64,
        bcols: i64,
        bnnz: i64,
        rowBlockDim: i64,
        colBlockDim: i64,
        bsrRowOffsets: *mut ::core::ffi::c_void,
        bsrColInd: *mut ::core::ffi::c_void,
        bsrValues: *mut ::core::ffi::c_void,
        bsrRowOffsetsType: cusparseIndexType_t,
        bsrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateBsr(
        spMatDescr: *mut cusparseSpMatDescr_t,
        brows: i64,
        bcols: i64,
        bnnz: i64,
        rowBlockSize: i64,
        colBlockSize: i64,
        bsrRowOffsets: *mut ::core::ffi::c_void,
        bsrColInd: *mut ::core::ffi::c_void,
        bsrValues: *mut ::core::ffi::c_void,
        bsrRowOffsetsType: cusparseIndexType_t,
        bsrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t;
    pub fn cusparseCreateBsric02Info(info: *mut bsric02Info_t) -> cusparseStatus_t;
    pub fn cusparseCreateBsrilu02Info(info: *mut bsrilu02Info_t) -> cusparseStatus_t;
    pub fn cusparseCreateBsrsm2Info(info: *mut bsrsm2Info_t) -> cusparseStatus_t;
    pub fn cusparseCreateBsrsv2Info(info: *mut bsrsv2Info_t) -> cusparseStatus_t;
    pub fn cusparseCreateColorInfo(info: *mut cusparseColorInfo_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstBlockedEll(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        ellBlockSize: i64,
        ellCols: i64,
        ellColInd: *const ::core::ffi::c_void,
        ellValue: *const ::core::ffi::c_void,
        ellIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstBsr(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        brows: i64,
        bcols: i64,
        bnnz: i64,
        rowBlockDim: i64,
        colBlockDim: i64,
        bsrRowOffsets: *const ::core::ffi::c_void,
        bsrColInd: *const ::core::ffi::c_void,
        bsrValues: *const ::core::ffi::c_void,
        bsrRowOffsetsType: cusparseIndexType_t,
        bsrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstCoo(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cooRowInd: *const ::core::ffi::c_void,
        cooColInd: *const ::core::ffi::c_void,
        cooValues: *const ::core::ffi::c_void,
        cooIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstCsc(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cscColOffsets: *const ::core::ffi::c_void,
        cscRowInd: *const ::core::ffi::c_void,
        cscValues: *const ::core::ffi::c_void,
        cscColOffsetsType: cusparseIndexType_t,
        cscRowIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstCsr(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        csrRowOffsets: *const ::core::ffi::c_void,
        csrColInd: *const ::core::ffi::c_void,
        csrValues: *const ::core::ffi::c_void,
        csrRowOffsetsType: cusparseIndexType_t,
        csrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstDnMat(
        dnMatDescr: *mut cusparseConstDnMatDescr_t,
        rows: i64,
        cols: i64,
        ld: i64,
        values: *const ::core::ffi::c_void,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstDnVec(
        dnVecDescr: *mut cusparseConstDnVecDescr_t,
        size: i64,
        values: *const ::core::ffi::c_void,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstSlicedEll(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        sellValuesSize: i64,
        sliceSize: i64,
        sellSliceOffsets: *const ::core::ffi::c_void,
        sellColInd: *const ::core::ffi::c_void,
        sellValues: *const ::core::ffi::c_void,
        sellSliceOffsetsType: cusparseIndexType_t,
        sellColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateConstSpVec(
        spVecDescr: *mut cusparseConstSpVecDescr_t,
        size: i64,
        nnz: i64,
        indices: *const ::core::ffi::c_void,
        values: *const ::core::ffi::c_void,
        idxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCreateCoo(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cooRowInd: *mut ::core::ffi::c_void,
        cooColInd: *mut ::core::ffi::c_void,
        cooValues: *mut ::core::ffi::c_void,
        cooIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCreateCooAoS(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cooInd: *mut ::core::ffi::c_void,
        cooValues: *mut ::core::ffi::c_void,
        cooIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCreateCsc(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cscColOffsets: *mut ::core::ffi::c_void,
        cscRowInd: *mut ::core::ffi::c_void,
        cscValues: *mut ::core::ffi::c_void,
        cscColOffsetsType: cusparseIndexType_t,
        cscRowIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCreateCsr(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        csrRowOffsets: *mut ::core::ffi::c_void,
        csrColInd: *mut ::core::ffi::c_void,
        csrValues: *mut ::core::ffi::c_void,
        csrRowOffsetsType: cusparseIndexType_t,
        csrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCreateCsrgemm2Info(info: *mut csrgemm2Info_t) -> cusparseStatus_t;
    pub fn cusparseCreateCsric02Info(info: *mut csric02Info_t) -> cusparseStatus_t;
    pub fn cusparseCreateCsrilu02Info(info: *mut csrilu02Info_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCreateCsrsm2Info(info: *mut csrsm2Info_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCreateCsrsv2Info(info: *mut csrsv2Info_t) -> cusparseStatus_t;
    pub fn cusparseCreateCsru2csrInfo(info: *mut csru2csrInfo_t) -> cusparseStatus_t;
    pub fn cusparseCreateDnMat(
        dnMatDescr: *mut cusparseDnMatDescr_t,
        rows: i64,
        cols: i64,
        ld: i64,
        values: *mut ::core::ffi::c_void,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t;
    pub fn cusparseCreateDnVec(
        dnVecDescr: *mut cusparseDnVecDescr_t,
        size: i64,
        values: *mut ::core::ffi::c_void,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCreateIdentityPermutation(
        handle: cusparseHandle_t,
        n: ::core::ffi::c_int,
        p: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseCreateMatDescr(descrA: *mut cusparseMatDescr_t) -> cusparseStatus_t;
    pub fn cusparseCreatePruneInfo(info: *mut pruneInfo_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCreateSlicedEll(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        sellValuesSize: i64,
        sliceSize: i64,
        sellSliceOffsets: *mut ::core::ffi::c_void,
        sellColInd: *mut ::core::ffi::c_void,
        sellValues: *mut ::core::ffi::c_void,
        sellSliceOffsetsType: cusparseIndexType_t,
        sellColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCreateSpVec(
        spVecDescr: *mut cusparseSpVecDescr_t,
        size: i64,
        nnz: i64,
        indices: *mut ::core::ffi::c_void,
        values: *mut ::core::ffi::c_void,
        idxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseCscGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cscColOffsets: *mut *mut ::core::ffi::c_void,
        cscRowInd: *mut *mut ::core::ffi::c_void,
        cscValues: *mut *mut ::core::ffi::c_void,
        cscColOffsetsType: *mut cusparseIndexType_t,
        cscRowIndType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCscSetPointers(
        spMatDescr: cusparseSpMatDescr_t,
        cscColOffsets: *mut ::core::ffi::c_void,
        cscRowInd: *mut ::core::ffi::c_void,
        cscValues: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCsctr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *const cuComplex,
        xInd: *const ::core::ffi::c_int,
        y: *mut cuComplex,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseCsr2cscEx2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *const ::core::ffi::c_void,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *const ::core::ffi::c_int,
        cscVal: *mut ::core::ffi::c_void,
        cscColPtr: *mut ::core::ffi::c_int,
        cscRowInd: *mut ::core::ffi::c_int,
        valType: cudaDataType,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        alg: cusparseCsr2CscAlg_t,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCsr2cscEx2_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *const ::core::ffi::c_void,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *const ::core::ffi::c_int,
        cscVal: *mut ::core::ffi::c_void,
        cscColPtr: *mut ::core::ffi::c_int,
        cscRowInd: *mut ::core::ffi::c_int,
        valType: cudaDataType,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        alg: cusparseCsr2CscAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseCsrGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        csrRowOffsets: *mut *mut ::core::ffi::c_void,
        csrColInd: *mut *mut ::core::ffi::c_void,
        csrValues: *mut *mut ::core::ffi::c_void,
        csrRowOffsetsType: *mut cusparseIndexType_t,
        csrColIndType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseCsrSetPointers(
        spMatDescr: cusparseSpMatDescr_t,
        csrRowOffsets: *mut ::core::ffi::c_void,
        csrColInd: *mut ::core::ffi::c_void,
        csrValues: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseCsrSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
        offsetsBatchStride: i64,
        columnsValuesBatchStride: i64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCsrmvEx(
        handle: cusparseHandle_t,
        alg: cusparseAlgMode_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphatype: cudaDataType,
        descrA: cusparseMatDescr_t,
        csrValA: *const ::core::ffi::c_void,
        csrValAtype: cudaDataType,
        csrRowPtrA: *const ::core::ffi::c_int,
        csrColIndA: *const ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xtype: cudaDataType,
        beta: *const ::core::ffi::c_void,
        betatype: cudaDataType,
        y: *mut ::core::ffi::c_void,
        ytype: cudaDataType,
        executiontype: cudaDataType,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseCsrmvEx_bufferSize(
        handle: cusparseHandle_t,
        alg: cusparseAlgMode_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphatype: cudaDataType,
        descrA: cusparseMatDescr_t,
        csrValA: *const ::core::ffi::c_void,
        csrValAtype: cudaDataType,
        csrRowPtrA: *const ::core::ffi::c_int,
        csrColIndA: *const ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xtype: cudaDataType,
        beta: *const ::core::ffi::c_void,
        betatype: cudaDataType,
        y: *mut ::core::ffi::c_void,
        ytype: cudaDataType,
        executiontype: cudaDataType,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDaxpyi(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        xVal: *const f64,
        xInd: *const ::core::ffi::c_int,
        y: *mut f64,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsric02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsric02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pInputBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsric02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrilu02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrilu02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrilu02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut f64,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrmm(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const f64,
        beta: *const f64,
        y: *mut f64,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrsm2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrsm2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrsm2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        X: *mut f64,
        ldx: ::core::ffi::c_int,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrsv2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrsv2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *mut f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrsv2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        f: *const f64,
        x: *mut f64,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDbsrxmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        sizeOfMask: ::core::ffi::c_int,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedMaskPtrA: *const ::core::ffi::c_int,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedEndPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const f64,
        beta: *const f64,
        y: *mut f64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsc2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscSortedValA: *const f64,
        cscSortedRowIndA: *const ::core::ffi::c_int,
        cscSortedColPtrA: *const ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsr2bsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f64,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsr2csr_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedColIndA: *const ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValC: *mut f64,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        tol: f64,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsr2csru(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut f64,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsr2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f64,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsrcolor(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        fractionToColor: *const f64,
        ncolors: *mut ::core::ffi::c_int,
        coloring: *mut ::core::ffi::c_int,
        reordering: *mut ::core::ffi::c_int,
        info: cusparseColorInfo_t,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsrgeam2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const f64,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f64,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsrgeam2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const f64,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f64,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrgemm2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f64,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const f64,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedValD: *const f64,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrgemm2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const f64,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsric02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsric02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsric02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsrilu02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsrilu02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsrilu02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut f64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrsm2_analysis(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrsm2_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrsm2_solve(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrsv2_analysis(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrsv2_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDcsrsv2_solve(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        f: *const f64,
        x: *mut f64,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsru2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut f64,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDcsru2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *mut f64,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDdense2csc(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f64,
        lda: ::core::ffi::c_int,
        nnzPerCol: *const ::core::ffi::c_int,
        cscSortedValA: *mut f64,
        cscSortedRowIndA: *mut ::core::ffi::c_int,
        cscSortedColPtrA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDdense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f64,
        lda: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *mut ::core::ffi::c_int,
        csrSortedColIndA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(feature = "cuda-11040"))]
    pub fn cusparseDenseToSparse_analysis(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDenseToSparse_analysis(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseDenseToSparse_analysis(
        handle: cusparseHandle_t,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDenseToSparse_bufferSize(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseDenseToSparse_bufferSize(
        handle: cusparseHandle_t,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(feature = "cuda-11040"))]
    pub fn cusparseDenseToSparse_convert(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDenseToSparse_convert(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseDenseToSparse_convert(
        handle: cusparseHandle_t,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDestroy(handle: cusparseHandle_t) -> cusparseStatus_t;
    pub fn cusparseDestroyBsric02Info(info: bsric02Info_t) -> cusparseStatus_t;
    pub fn cusparseDestroyBsrilu02Info(info: bsrilu02Info_t) -> cusparseStatus_t;
    pub fn cusparseDestroyBsrsm2Info(info: bsrsm2Info_t) -> cusparseStatus_t;
    pub fn cusparseDestroyBsrsv2Info(info: bsrsv2Info_t) -> cusparseStatus_t;
    pub fn cusparseDestroyColorInfo(info: cusparseColorInfo_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDestroyCsrgemm2Info(info: csrgemm2Info_t) -> cusparseStatus_t;
    pub fn cusparseDestroyCsric02Info(info: csric02Info_t) -> cusparseStatus_t;
    pub fn cusparseDestroyCsrilu02Info(info: csrilu02Info_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDestroyCsrsm2Info(info: csrsm2Info_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDestroyCsrsv2Info(info: csrsv2Info_t) -> cusparseStatus_t;
    pub fn cusparseDestroyCsru2csrInfo(info: csru2csrInfo_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDestroyDnMat(dnMatDescr: cusparseDnMatDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseDestroyDnMat(dnMatDescr: cusparseConstDnMatDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDestroyDnVec(dnVecDescr: cusparseDnVecDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseDestroyDnVec(dnVecDescr: cusparseConstDnVecDescr_t) -> cusparseStatus_t;
    pub fn cusparseDestroyMatDescr(descrA: cusparseMatDescr_t) -> cusparseStatus_t;
    pub fn cusparseDestroyPruneInfo(info: pruneInfo_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDestroySpMat(spMatDescr: cusparseSpMatDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseDestroySpMat(spMatDescr: cusparseConstSpMatDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDestroySpVec(spVecDescr: cusparseSpVecDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseDestroySpVec(spVecDescr: cusparseConstSpVecDescr_t) -> cusparseStatus_t;
    pub fn cusparseDgebsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDgebsr2gebsc(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        bscVal: *mut f64,
        bscRowInd: *mut ::core::ffi::c_int,
        bscColPtr: *mut ::core::ffi::c_int,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDgebsr2gebsc_bufferSize(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDgebsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f64,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDgebsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDgemmi(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        cscValB: *const f64,
        cscColPtrB: *const ::core::ffi::c_int,
        cscRowIndB: *const ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDgemvi(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        xVal: *const f64,
        xInd: *const ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDgemvi_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        pBufferSize: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDgpsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *mut f64,
        dl: *mut f64,
        d: *mut f64,
        du: *mut f64,
        dw: *mut f64,
        x: *mut f64,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDgpsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *const f64,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        dw: *const f64,
        x: *const f64,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDgthr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *const f64,
        xVal: *mut f64,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDgthrz(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *mut f64,
        xVal: *mut f64,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseDgtsv2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDgtsv2StridedBatch(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        x: *mut f64,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDgtsv2StridedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        x: *const f64,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseDgtsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseDgtsv2_nopivot(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDgtsv2_nopivot_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseDgtsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *mut f64,
        d: *mut f64,
        du: *mut f64,
        x: *mut f64,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDgtsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        x: *const f64,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseDnMatGet(
        dnMatDescr: cusparseDnMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        ld: *mut i64,
        values: *mut *mut ::core::ffi::c_void,
        type_: *mut cudaDataType,
        order: *mut cusparseOrder_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDnMatGetStridedBatch(
        dnMatDescr: cusparseDnMatDescr_t,
        batchCount: *mut ::core::ffi::c_int,
        batchStride: *mut i64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseDnMatGetStridedBatch(
        dnMatDescr: cusparseConstDnMatDescr_t,
        batchCount: *mut ::core::ffi::c_int,
        batchStride: *mut i64,
    ) -> cusparseStatus_t;
    pub fn cusparseDnMatGetValues(
        dnMatDescr: cusparseDnMatDescr_t,
        values: *mut *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDnMatSetStridedBatch(
        dnMatDescr: cusparseDnMatDescr_t,
        batchCount: ::core::ffi::c_int,
        batchStride: i64,
    ) -> cusparseStatus_t;
    pub fn cusparseDnMatSetValues(
        dnMatDescr: cusparseDnMatDescr_t,
        values: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDnVecGet(
        dnVecDescr: cusparseDnVecDescr_t,
        size: *mut i64,
        values: *mut *mut ::core::ffi::c_void,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    pub fn cusparseDnVecGetValues(
        dnVecDescr: cusparseDnVecDescr_t,
        values: *mut *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDnVecSetValues(
        dnVecDescr: cusparseDnVecDescr_t,
        values: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDnnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f64,
        lda: ::core::ffi::c_int,
        nnzPerRowCol: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseDnnz_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        descr: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzPerRow: *mut ::core::ffi::c_int,
        nnzC: *mut ::core::ffi::c_int,
        tol: f64,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneCsr2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneCsr2csrByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneCsr2csrByPercentage_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        info: pruneInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneCsr2csrNnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneCsr2csrNnzByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneCsr2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneDense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneDense2csrByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneDense2csrByPercentage_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        info: pruneInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneDense2csrNnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneDense2csrNnzByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseDpruneDense2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDroti(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *mut f64,
        xInd: *const ::core::ffi::c_int,
        y: *mut f64,
        c: *const f64,
        s: *const f64,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseDsctr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *const f64,
        xInd: *const ::core::ffi::c_int,
        y: *mut f64,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseGather(
        handle: cusparseHandle_t,
        vecY: cusparseDnVecDescr_t,
        vecX: cusparseSpVecDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseGather(
        handle: cusparseHandle_t,
        vecY: cusparseConstDnVecDescr_t,
        vecX: cusparseSpVecDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000"
    ))]
    pub fn cusparseGetColorAlgs(
        info: cusparseColorInfo_t,
        alg: *mut cusparseColorAlg_t,
    ) -> cusparseStatus_t;
    pub fn cusparseGetErrorName(status: cusparseStatus_t) -> *const ::core::ffi::c_char;
    pub fn cusparseGetErrorString(status: cusparseStatus_t) -> *const ::core::ffi::c_char;
    pub fn cusparseGetMatDiagType(descrA: cusparseMatDescr_t) -> cusparseDiagType_t;
    pub fn cusparseGetMatFillMode(descrA: cusparseMatDescr_t) -> cusparseFillMode_t;
    pub fn cusparseGetMatIndexBase(descrA: cusparseMatDescr_t) -> cusparseIndexBase_t;
    pub fn cusparseGetMatType(descrA: cusparseMatDescr_t) -> cusparseMatrixType_t;
    pub fn cusparseGetPointerMode(
        handle: cusparseHandle_t,
        mode: *mut cusparsePointerMode_t,
    ) -> cusparseStatus_t;
    pub fn cusparseGetProperty(
        type_: libraryPropertyType,
        value: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseGetStream(
        handle: cusparseHandle_t,
        streamId: *mut cudaStream_t,
    ) -> cusparseStatus_t;
    pub fn cusparseGetVersion(
        handle: cusparseHandle_t,
        version: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseLoggerForceDisable() -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseLoggerOpenFile(logFile: *const ::core::ffi::c_char) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseLoggerSetCallback(callback: cusparseLoggerCallback_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseLoggerSetFile(file: *mut FILE) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseLoggerSetLevel(level: ::core::ffi::c_int) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseLoggerSetMask(mask: ::core::ffi::c_int) -> cusparseStatus_t;
    pub fn cusparseRot(
        handle: cusparseHandle_t,
        c_coeff: *const ::core::ffi::c_void,
        s_coeff: *const ::core::ffi::c_void,
        vecX: cusparseSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSDDMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSDDMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSDDMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSDDMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSDDMM_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSDDMM_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSaxpyi(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        xVal: *const f32,
        xInd: *const ::core::ffi::c_int,
        y: *mut f32,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsric02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsric02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pInputBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsric02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrilu02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrilu02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrilu02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut f32,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrmm(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const f32,
        beta: *const f32,
        y: *mut f32,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrsm2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrsm2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrsm2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        X: *mut f32,
        ldx: ::core::ffi::c_int,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrsv2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrsv2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *mut f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrsv2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        f: *const f32,
        x: *mut f32,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSbsrxmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        sizeOfMask: ::core::ffi::c_int,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedMaskPtrA: *const ::core::ffi::c_int,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedEndPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const f32,
        beta: *const f32,
        y: *mut f32,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScatter(
        handle: cusparseHandle_t,
        vecX: cusparseSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseScatter(
        handle: cusparseHandle_t,
        vecX: cusparseConstSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsc2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscSortedValA: *const f32,
        cscSortedRowIndA: *const ::core::ffi::c_int,
        cscSortedColPtrA: *const ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseScsr2bsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f32,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseScsr2csr_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedColIndA: *const ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValC: *mut f32,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        tol: f32,
    ) -> cusparseStatus_t;
    pub fn cusparseScsr2csru(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut f32,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsr2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseScsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f32,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseScsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseScsrcolor(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        fractionToColor: *const f32,
        ncolors: *mut ::core::ffi::c_int,
        coloring: *mut ::core::ffi::c_int,
        reordering: *mut ::core::ffi::c_int,
        info: cusparseColorInfo_t,
    ) -> cusparseStatus_t;
    pub fn cusparseScsrgeam2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const f32,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f32,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseScsrgeam2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const f32,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f32,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrgemm2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f32,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const f32,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedValD: *const f32,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrgemm2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const f32,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseScsric02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseScsric02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseScsric02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseScsrilu02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseScsrilu02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseScsrilu02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseScsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut f32,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrsm2_analysis(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrsm2_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrsm2_solve(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrsv2_analysis(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrsv2_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseScsrsv2_solve(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        f: *const f32,
        x: *mut f32,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseScsru2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut f32,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseScsru2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *mut f32,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSdense2csc(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f32,
        lda: ::core::ffi::c_int,
        nnzPerCol: *const ::core::ffi::c_int,
        cscSortedValA: *mut f32,
        cscSortedRowIndA: *mut ::core::ffi::c_int,
        cscSortedColPtrA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSdense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f32,
        lda: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *mut ::core::ffi::c_int,
        csrSortedColIndA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000"
    ))]
    pub fn cusparseSetColorAlgs(
        info: cusparseColorInfo_t,
        alg: cusparseColorAlg_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSetMatDiagType(
        descrA: cusparseMatDescr_t,
        diagType: cusparseDiagType_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSetMatFillMode(
        descrA: cusparseMatDescr_t,
        fillMode: cusparseFillMode_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSetMatIndexBase(
        descrA: cusparseMatDescr_t,
        base: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSetMatType(
        descrA: cusparseMatDescr_t,
        type_: cusparseMatrixType_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSetPointerMode(
        handle: cusparseHandle_t,
        mode: cusparsePointerMode_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSetStream(handle: cusparseHandle_t, streamId: cudaStream_t) -> cusparseStatus_t;
    pub fn cusparseSgebsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSgebsr2gebsc(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        bscVal: *mut f32,
        bscRowInd: *mut ::core::ffi::c_int,
        bscColPtr: *mut ::core::ffi::c_int,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSgebsr2gebsc_bufferSize(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSgebsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f32,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSgebsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSgemmi(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        cscValB: *const f32,
        cscColPtrB: *const ::core::ffi::c_int,
        cscRowIndB: *const ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSgemvi(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        xVal: *const f32,
        xInd: *const ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSgemvi_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        pBufferSize: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSgpsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *mut f32,
        dl: *mut f32,
        d: *mut f32,
        du: *mut f32,
        dw: *mut f32,
        x: *mut f32,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSgpsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *const f32,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        dw: *const f32,
        x: *const f32,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSgthr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *const f32,
        xVal: *mut f32,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSgthrz(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *mut f32,
        xVal: *mut f32,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSgtsv2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSgtsv2StridedBatch(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        x: *mut f32,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSgtsv2StridedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        x: *const f32,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSgtsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSgtsv2_nopivot(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSgtsv2_nopivot_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSgtsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *mut f32,
        d: *mut f32,
        du: *mut f32,
        x: *mut f32,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSgtsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        x: *const f32,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSnnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f32,
        lda: ::core::ffi::c_int,
        nnzPerRowCol: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSnnz_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        descr: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzPerRow: *mut ::core::ffi::c_int,
        nnzC: *mut ::core::ffi::c_int,
        tol: f32,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpGEMM_compute(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize2: *mut usize,
        externalBuffer2: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMM_compute(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize2: *mut usize,
        externalBuffer2: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpGEMM_copy(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMM_copy(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSpGEMM_createDescr(descr: *mut cusparseSpGEMMDescr_t) -> cusparseStatus_t;
    pub fn cusparseSpGEMM_destroyDescr(descr: cusparseSpGEMMDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMM_estimateMemory(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        chunk_fraction: f32,
        bufferSize3: *mut usize,
        externalBuffer3: *mut ::core::ffi::c_void,
        bufferSize2: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMM_getNumProducts(
        spgemmDescr: cusparseSpGEMMDescr_t,
        num_prods: *mut i64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpGEMM_workEstimation(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize1: *mut usize,
        externalBuffer1: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMM_workEstimation(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize1: *mut usize,
        externalBuffer1: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpGEMMreuse_compute(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMMreuse_compute(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpGEMMreuse_copy(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize5: *mut usize,
        externalBuffer5: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMMreuse_copy(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize5: *mut usize,
        externalBuffer5: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpGEMMreuse_nnz(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize2: *mut usize,
        externalBuffer2: *mut ::core::ffi::c_void,
        bufferSize3: *mut usize,
        externalBuffer3: *mut ::core::ffi::c_void,
        bufferSize4: *mut usize,
        externalBuffer4: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMMreuse_nnz(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize2: *mut usize,
        externalBuffer2: *mut ::core::ffi::c_void,
        bufferSize3: *mut usize,
        externalBuffer3: *mut ::core::ffi::c_void,
        bufferSize4: *mut usize,
        externalBuffer4: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpGEMMreuse_workEstimation(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize1: *mut usize,
        externalBuffer1: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpGEMMreuse_workEstimation(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize1: *mut usize,
        externalBuffer1: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMMOp(
        plan: cusparseSpMMOpPlan_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMMOp_createPlan(
        handle: cusparseHandle_t,
        plan: *mut cusparseSpMMOpPlan_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMOpAlg_t,
        addOperationNvvmBuffer: *const ::core::ffi::c_void,
        addOperationBufferSize: usize,
        mulOperationNvvmBuffer: *const ::core::ffi::c_void,
        mulOperationBufferSize: usize,
        epilogueNvvmBuffer: *const ::core::ffi::c_void,
        epilogueBufferSize: usize,
        SpMMWorkspaceSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMMOp_createPlan(
        handle: cusparseHandle_t,
        plan: *mut cusparseSpMMOpPlan_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMOpAlg_t,
        addOperationNvvmBuffer: *const ::core::ffi::c_void,
        addOperationBufferSize: usize,
        mulOperationNvvmBuffer: *const ::core::ffi::c_void,
        mulOperationBufferSize: usize,
        epilogueNvvmBuffer: *const ::core::ffi::c_void,
        epilogueBufferSize: usize,
        SpMMWorkspaceSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMMOp_destroyPlan(plan: cusparseSpMMOpPlan_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMM_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMM_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMV(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMV(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMV_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMV_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMV_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMatGetAttribute(
        spMatDescr: cusparseSpMatDescr_t,
        attribute: cusparseSpMatAttribute_t,
        data: *mut ::core::ffi::c_void,
        dataSize: usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMatGetAttribute(
        spMatDescr: cusparseConstSpMatDescr_t,
        attribute: cusparseSpMatAttribute_t,
        data: *mut ::core::ffi::c_void,
        dataSize: usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMatGetFormat(
        spMatDescr: cusparseSpMatDescr_t,
        format: *mut cusparseFormat_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMatGetFormat(
        spMatDescr: cusparseConstSpMatDescr_t,
        format: *mut cusparseFormat_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMatGetIndexBase(
        spMatDescr: cusparseSpMatDescr_t,
        idxBase: *mut cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMatGetIndexBase(
        spMatDescr: cusparseConstSpMatDescr_t,
        idxBase: *mut cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMatGetSize(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMatGetSize(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMatGetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpMatGetStridedBatch(
        spMatDescr: cusparseConstSpMatDescr_t,
        batchCount: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSpMatGetValues(
        spMatDescr: cusparseSpMatDescr_t,
        values: *mut *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpMatSetAttribute(
        spMatDescr: cusparseSpMatDescr_t,
        attribute: cusparseSpMatAttribute_t,
        data: *mut ::core::ffi::c_void,
        dataSize: usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpMatSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseSpMatSetValues(
        spMatDescr: cusparseSpMatDescr_t,
        values: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpSM_analysis(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpSM_analysis(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpSM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpSM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSpSM_createDescr(descr: *mut cusparseSpSMDescr_t) -> cusparseStatus_t;
    pub fn cusparseSpSM_destroyDescr(descr: cusparseSpSMDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpSM_solve(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpSM_solve(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpSM_updateMatrix(
        handle: cusparseHandle_t,
        spsmDescr: cusparseSpSMDescr_t,
        newValues: *mut ::core::ffi::c_void,
        updatePart: cusparseSpSMUpdate_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpSV_analysis(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpSV_analysis(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpSV_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpSV_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSpSV_createDescr(descr: *mut cusparseSpSVDescr_t) -> cusparseStatus_t;
    pub fn cusparseSpSV_destroyDescr(descr: cusparseSpSVDescr_t) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpSV_solve(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpSV_solve(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpSV_updateMatrix(
        handle: cusparseHandle_t,
        spsvDescr: cusparseSpSVDescr_t,
        newValues: *mut ::core::ffi::c_void,
        updatePart: cusparseSpSVUpdate_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpVV(
        handle: cusparseHandle_t,
        opX: cusparseOperation_t,
        vecX: cusparseSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        result: *mut ::core::ffi::c_void,
        computeType: cudaDataType,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpVV(
        handle: cusparseHandle_t,
        opX: cusparseOperation_t,
        vecX: cusparseConstSpVecDescr_t,
        vecY: cusparseConstDnVecDescr_t,
        result: *mut ::core::ffi::c_void,
        computeType: cudaDataType,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpVV_bufferSize(
        handle: cusparseHandle_t,
        opX: cusparseOperation_t,
        vecX: cusparseSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        result: *const ::core::ffi::c_void,
        computeType: cudaDataType,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpVV_bufferSize(
        handle: cusparseHandle_t,
        opX: cusparseOperation_t,
        vecX: cusparseConstSpVecDescr_t,
        vecY: cusparseConstDnVecDescr_t,
        result: *const ::core::ffi::c_void,
        computeType: cudaDataType,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSpVecGet(
        spVecDescr: cusparseSpVecDescr_t,
        size: *mut i64,
        nnz: *mut i64,
        indices: *mut *mut ::core::ffi::c_void,
        values: *mut *mut ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSpVecGetIndexBase(
        spVecDescr: cusparseSpVecDescr_t,
        idxBase: *mut cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSpVecGetIndexBase(
        spVecDescr: cusparseConstSpVecDescr_t,
        idxBase: *mut cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseSpVecGetValues(
        spVecDescr: cusparseSpVecDescr_t,
        values: *mut *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpVecSetValues(
        spVecDescr: cusparseSpVecDescr_t,
        values: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(feature = "cuda-11040"))]
    pub fn cusparseSparseToDense(
        handle: cusparseHandle_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSparseToDense(
        handle: cusparseHandle_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSparseToDense(
        handle: cusparseHandle_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSparseToDense_bufferSize(
        handle: cusparseHandle_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cusparseSparseToDense_bufferSize(
        handle: cusparseHandle_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneCsr2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneCsr2csrByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneCsr2csrByPercentage_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        info: pruneInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneCsr2csrNnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneCsr2csrNnzByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneCsr2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneDense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneDense2csrByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneDense2csrByPercentage_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        info: pruneInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneDense2csrNnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneDense2csrNnzByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseSpruneDense2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSroti(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *mut f32,
        xInd: *const ::core::ffi::c_int,
        y: *mut f32,
        c: *const f32,
        s: *const f32,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseSsctr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *const f32,
        xInd: *const ::core::ffi::c_int,
        y: *mut f32,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseXbsric02_zeroPivot(
        handle: cusparseHandle_t,
        info: bsric02Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseXbsrilu02_zeroPivot(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseXbsrsm2_zeroPivot(
        handle: cusparseHandle_t,
        info: bsrsm2Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseXbsrsv2_zeroPivot(
        handle: cusparseHandle_t,
        info: bsrsv2Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseXcoo2csr(
        handle: cusparseHandle_t,
        cooRowInd: *const ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        csrSortedRowPtr: *mut ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseXcoosortByColumn(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        cooRowsA: *mut ::core::ffi::c_int,
        cooColsA: *mut ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseXcoosortByRow(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        cooRowsA: *mut ::core::ffi::c_int,
        cooColsA: *mut ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseXcoosort_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        cooRowsA: *const ::core::ffi::c_int,
        cooColsA: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseXcscsort(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscColPtrA: *const ::core::ffi::c_int,
        cscRowIndA: *mut ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseXcscsort_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        cscColPtrA: *const ::core::ffi::c_int,
        cscRowIndA: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseXcsr2bsrNnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseXcsr2coo(
        handle: cusparseHandle_t,
        csrSortedRowPtr: *const ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        cooRowInd: *mut ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseXcsr2gebsrNnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseXcsrgeam2Nnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        workspace: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseXcsrgemm2Nnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseXcsric02_zeroPivot(
        handle: cusparseHandle_t,
        info: csric02Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseXcsrilu02_zeroPivot(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseXcsrsm2_zeroPivot(
        handle: cusparseHandle_t,
        info: csrsm2Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseXcsrsort(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrRowPtrA: *const ::core::ffi::c_int,
        csrColIndA: *mut ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseXcsrsort_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrRowPtrA: *const ::core::ffi::c_int,
        csrColIndA: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseXcsrsv2_zeroPivot(
        handle: cusparseHandle_t,
        info: csrsv2Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseXgebsr2gebsrNnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZaxpyi(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        xVal: *const cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsric02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsric02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pInputBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsric02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrilu02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrilu02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrilu02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut cuDoubleComplex,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrmm(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrsm2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrsm2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrsm2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        X: *mut cuDoubleComplex,
        ldx: ::core::ffi::c_int,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrsv2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrsv2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *mut cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrsv2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        f: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZbsrxmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        sizeOfMask: ::core::ffi::c_int,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedMaskPtrA: *const ::core::ffi::c_int,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedEndPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsc2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscSortedValA: *const cuDoubleComplex,
        cscSortedRowIndA: *const ::core::ffi::c_int,
        cscSortedColPtrA: *const ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsr2bsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuDoubleComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsr2csr_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedColIndA: *const ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        tol: cuDoubleComplex,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsr2csru(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut cuDoubleComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsr2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuDoubleComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsrcolor(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        fractionToColor: *const f64,
        ncolors: *mut ::core::ffi::c_int,
        coloring: *mut ::core::ffi::c_int,
        reordering: *mut ::core::ffi::c_int,
        info: cusparseColorInfo_t,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsrgeam2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuDoubleComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsrgeam2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuDoubleComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const cuDoubleComplex,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrgemm2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuDoubleComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedValD: *const cuDoubleComplex,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrgemm2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsric02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsric02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsric02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsrilu02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsrilu02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsrilu02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut cuDoubleComplex,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrsm2_analysis(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrsm2_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrsm2_solve(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrsv2_analysis(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrsv2_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZcsrsv2_solve(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        f: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsru2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut cuDoubleComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZcsru2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *mut cuDoubleComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZdense2csc(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        nnzPerCol: *const ::core::ffi::c_int,
        cscSortedValA: *mut cuDoubleComplex,
        cscSortedRowIndA: *mut ::core::ffi::c_int,
        cscSortedColPtrA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZdense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *mut ::core::ffi::c_int,
        csrSortedColIndA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZgebsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZgebsr2gebsc(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        bscVal: *mut cuDoubleComplex,
        bscRowInd: *mut ::core::ffi::c_int,
        bscColPtr: *mut ::core::ffi::c_int,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZgebsr2gebsc_bufferSize(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZgebsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuDoubleComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZgebsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZgemmi(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        cscValB: *const cuDoubleComplex,
        cscColPtrB: *const ::core::ffi::c_int,
        cscRowIndB: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZgemvi(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        xVal: *const cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZgemvi_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        pBufferSize: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZgpsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *mut cuDoubleComplex,
        dl: *mut cuDoubleComplex,
        d: *mut cuDoubleComplex,
        du: *mut cuDoubleComplex,
        dw: *mut cuDoubleComplex,
        x: *mut cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZgpsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *const cuDoubleComplex,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        dw: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZgthr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        xVal: *mut cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZgthrz(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        xVal: *mut cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
    pub fn cusparseZgtsv2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZgtsv2StridedBatch(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZgtsv2StridedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseZgtsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseZgtsv2_nopivot(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZgtsv2_nopivot_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseZgtsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *mut cuDoubleComplex,
        d: *mut cuDoubleComplex,
        du: *mut cuDoubleComplex,
        x: *mut cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t;
    pub fn cusparseZgtsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t;
    pub fn cusparseZnnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        nnzPerRowCol: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t;
    pub fn cusparseZnnz_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        descr: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzPerRow: *mut ::core::ffi::c_int,
        nnzC: *mut ::core::ffi::c_int,
        tol: cuDoubleComplex,
    ) -> cusparseStatus_t;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub fn cusparseZsctr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *const cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t;
}
#[cfg(feature = "dynamic-loading")]
mod loaded {
    use super::*;
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseAxpby(
        handle: cusparseHandle_t,
        alpha: *const ::core::ffi::c_void,
        vecX: cusparseSpVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseAxpby)(handle, alpha, vecX, beta, vecY)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseAxpby(
        handle: cusparseHandle_t,
        alpha: *const ::core::ffi::c_void,
        vecX: cusparseConstSpVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseAxpby)(handle, alpha, vecX, beta, vecY)
    }
    pub unsafe fn cusparseBlockedEllGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        ellBlockSize: *mut i64,
        ellCols: *mut i64,
        ellColInd: *mut *mut ::core::ffi::c_void,
        ellValue: *mut *mut ::core::ffi::c_void,
        ellIdxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseBlockedEllGet)(
            spMatDescr,
            rows,
            cols,
            ellBlockSize,
            ellCols,
            ellColInd,
            ellValue,
            ellIdxType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(feature = "cuda-12010"))]
    pub unsafe fn cusparseBsrSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
        offsetsBatchStride: i64,
        columnsValuesBatchStride: i64,
        ValuesBatchStride: i64,
    ) -> cusparseStatus_t {
        (culib().cusparseBsrSetStridedBatch)(
            spMatDescr,
            batchCount,
            offsetsBatchStride,
            columnsValuesBatchStride,
            ValuesBatchStride,
        )
    }
    #[cfg(any(
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseBsrSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
        offsetsBatchStride: i64,
        columnsBatchStride: i64,
        ValuesBatchStride: i64,
    ) -> cusparseStatus_t {
        (culib().cusparseBsrSetStridedBatch)(
            spMatDescr,
            batchCount,
            offsetsBatchStride,
            columnsBatchStride,
            ValuesBatchStride,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCaxpyi(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        xVal: *const cuComplex,
        xInd: *const ::core::ffi::c_int,
        y: *mut cuComplex,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCaxpyi)(handle, nnz, alpha, xVal, xInd, y, idxBase)
    }
    pub unsafe fn cusparseCbsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsr2csr)(
            handle,
            dirA,
            mb,
            nb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
        )
    }
    pub unsafe fn cusparseCbsric02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsric02)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCbsric02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pInputBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsric02_analysis)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pInputBuffer,
        )
    }
    pub unsafe fn cusparseCbsric02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsric02_bufferSize)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCbsrilu02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrilu02)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCbsrilu02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrilu02_analysis)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCbsrilu02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrilu02_bufferSize)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCbsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut cuComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrilu02_numericBoost)(handle, info, enable_boost, tol, boost_val)
    }
    pub unsafe fn cusparseCbsrmm(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrmm)(
            handle,
            dirA,
            transA,
            transB,
            mb,
            n,
            kb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockSize,
            B,
            ldb,
            beta,
            C,
            ldc,
        )
    }
    pub unsafe fn cusparseCbsrmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const cuComplex,
        beta: *const cuComplex,
        y: *mut cuComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrmv)(
            handle,
            dirA,
            transA,
            mb,
            nb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            x,
            beta,
            y,
        )
    }
    pub unsafe fn cusparseCbsrsm2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrsm2_analysis)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCbsrsm2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrsm2_bufferSize)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCbsrsm2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        X: *mut cuComplex,
        ldx: ::core::ffi::c_int,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrsm2_solve)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            alpha,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            B,
            ldb,
            X,
            ldx,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCbsrsv2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrsv2_analysis)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCbsrsv2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *mut cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrsv2_bufferSize)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCbsrsv2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        f: *const cuComplex,
        x: *mut cuComplex,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrsv2_solve)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            f,
            x,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCbsrxmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        sizeOfMask: ::core::ffi::c_int,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedMaskPtrA: *const ::core::ffi::c_int,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedEndPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const cuComplex,
        beta: *const cuComplex,
        y: *mut cuComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseCbsrxmv)(
            handle,
            dirA,
            transA,
            sizeOfMask,
            mb,
            nb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedMaskPtrA,
            bsrSortedRowPtrA,
            bsrSortedEndPtrA,
            bsrSortedColIndA,
            blockDim,
            x,
            beta,
            y,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsc2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscSortedValA: *const cuComplex,
        cscSortedRowIndA: *const ::core::ffi::c_int,
        cscSortedColPtrA: *const ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsc2dense)(
            handle,
            m,
            n,
            descrA,
            cscSortedValA,
            cscSortedRowIndA,
            cscSortedColPtrA,
            A,
            lda,
        )
    }
    pub unsafe fn cusparseCcsr2bsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsr2bsr)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            blockDim,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
        )
    }
    pub unsafe fn cusparseCcsr2csr_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedColIndA: *const ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValC: *mut cuComplex,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        tol: cuComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsr2csr_compress)(
            handle,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedColIndA,
            csrSortedRowPtrA,
            nnzA,
            nnzPerRow,
            csrSortedValC,
            csrSortedColIndC,
            csrSortedRowPtrC,
            tol,
        )
    }
    pub unsafe fn cusparseCcsr2csru(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut cuComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsr2csru)(
            handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsr2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsr2dense)(
            handle,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            A,
            lda,
        )
    }
    pub unsafe fn cusparseCcsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsr2gebsr)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
            rowBlockDim,
            colBlockDim,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCcsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsr2gebsr_bufferSize)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            rowBlockDim,
            colBlockDim,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCcsrcolor(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        fractionToColor: *const f32,
        ncolors: *mut ::core::ffi::c_int,
        coloring: *mut ::core::ffi::c_int,
        reordering: *mut ::core::ffi::c_int,
        info: cusparseColorInfo_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrcolor)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            fractionToColor,
            ncolors,
            coloring,
            reordering,
            info,
        )
    }
    pub unsafe fn cusparseCcsrgeam2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrgeam2)(
            handle,
            m,
            n,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            beta,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCcsrgeam2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const cuComplex,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrgeam2_bufferSizeExt)(
            handle,
            m,
            n,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            beta,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrgemm2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedValD: *const cuComplex,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuComplex,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrgemm2)(
            handle,
            m,
            n,
            k,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            beta,
            descrD,
            nnzD,
            csrSortedValD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrgemm2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrgemm2_bufferSizeExt)(
            handle,
            m,
            n,
            k,
            alpha,
            descrA,
            nnzA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            beta,
            descrD,
            nnzD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCcsric02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsric02)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA_valM,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCcsric02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsric02_analysis)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCcsric02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsric02_bufferSize)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCcsrilu02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrilu02)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA_valM,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCcsrilu02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrilu02_analysis)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCcsrilu02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrilu02_bufferSize)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCcsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut cuComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrilu02_numericBoost)(handle, info, enable_boost, tol, boost_val)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrsm2_analysis(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrsm2_analysis)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrsm2_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrsm2_bufferSizeExt)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrsm2_solve(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrsm2_solve)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrsv2_analysis(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrsv2_analysis)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrsv2_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrsv2_bufferSize)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrsv2_bufferSizeExt)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCcsrsv2_solve(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        f: *const cuComplex,
        x: *mut cuComplex,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsrsv2_solve)(
            handle,
            transA,
            m,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            f,
            x,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCcsru2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut cuComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsru2csr)(
            handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer,
        )
    }
    pub unsafe fn cusparseCcsru2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *mut cuComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCcsru2csr_bufferSizeExt)(
            handle,
            m,
            n,
            nnz,
            csrVal,
            csrRowPtr,
            csrColInd,
            info,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCdense2csc(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        nnzPerCol: *const ::core::ffi::c_int,
        cscSortedValA: *mut cuComplex,
        cscSortedRowIndA: *mut ::core::ffi::c_int,
        cscSortedColPtrA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCdense2csc)(
            handle,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerCol,
            cscSortedValA,
            cscSortedRowIndA,
            cscSortedColPtrA,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCdense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValA: *mut cuComplex,
        csrSortedRowPtrA: *mut ::core::ffi::c_int,
        csrSortedColIndA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCdense2csr)(
            handle,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerRow,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
        )
    }
    pub unsafe fn cusparseCgebsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCgebsr2csr)(
            handle,
            dirA,
            mb,
            nb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDim,
            colBlockDim,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
        )
    }
    pub unsafe fn cusparseCgebsr2gebsc(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        bscVal: *mut cuComplex,
        bscRowInd: *mut ::core::ffi::c_int,
        bscColPtr: *mut ::core::ffi::c_int,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCgebsr2gebsc)(
            handle,
            mb,
            nb,
            nnzb,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            rowBlockDim,
            colBlockDim,
            bscVal,
            bscRowInd,
            bscColPtr,
            copyValues,
            idxBase,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCgebsr2gebsc_bufferSize(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const cuComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCgebsr2gebsc_bufferSize)(
            handle,
            mb,
            nb,
            nnzb,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            rowBlockDim,
            colBlockDim,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCgebsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCgebsr2gebsr)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
            rowBlockDimC,
            colBlockDimC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCgebsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCgebsr2gebsr_bufferSize)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            rowBlockDimC,
            colBlockDimC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCgemmi(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        cscValB: *const cuComplex,
        cscColPtrB: *const ::core::ffi::c_int,
        cscRowIndB: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCgemmi)(
            handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc,
        )
    }
    pub unsafe fn cusparseCgemvi(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        xVal: *const cuComplex,
        xInd: *const ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCgemvi)(
            handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer,
        )
    }
    pub unsafe fn cusparseCgemvi_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        pBufferSize: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCgemvi_bufferSize)(handle, transA, m, n, nnz, pBufferSize)
    }
    pub unsafe fn cusparseCgpsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *mut cuComplex,
        dl: *mut cuComplex,
        d: *mut cuComplex,
        du: *mut cuComplex,
        dw: *mut cuComplex,
        x: *mut cuComplex,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCgpsvInterleavedBatch)(
            handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBuffer,
        )
    }
    pub unsafe fn cusparseCgpsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *const cuComplex,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        dw: *const cuComplex,
        x: *const cuComplex,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCgpsvInterleavedBatch_bufferSizeExt)(
            handle,
            algo,
            m,
            ds,
            dl,
            d,
            du,
            dw,
            x,
            batchCount,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCgthr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *const cuComplex,
        xVal: *mut cuComplex,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCgthr)(handle, nnz, y, xVal, xInd, idxBase)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCgthrz(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *mut cuComplex,
        xVal: *mut cuComplex,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCgthrz)(handle, nnz, y, xVal, xInd, idxBase)
    }
    pub unsafe fn cusparseCgtsv2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCgtsv2)(handle, m, n, dl, d, du, B, ldb, pBuffer)
    }
    pub unsafe fn cusparseCgtsv2StridedBatch(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        x: *mut cuComplex,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCgtsv2StridedBatch)(
            handle,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            batchStride,
            pBuffer,
        )
    }
    pub unsafe fn cusparseCgtsv2StridedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        x: *const cuComplex,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCgtsv2StridedBatch_bufferSizeExt)(
            handle,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            batchStride,
            bufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCgtsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCgtsv2_bufferSizeExt)(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes)
    }
    pub unsafe fn cusparseCgtsv2_nopivot(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCgtsv2_nopivot)(handle, m, n, dl, d, du, B, ldb, pBuffer)
    }
    pub unsafe fn cusparseCgtsv2_nopivot_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCgtsv2_nopivot_bufferSizeExt)(
            handle,
            m,
            n,
            dl,
            d,
            du,
            B,
            ldb,
            bufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCgtsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *mut cuComplex,
        d: *mut cuComplex,
        du: *mut cuComplex,
        x: *mut cuComplex,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCgtsvInterleavedBatch)(handle, algo, m, dl, d, du, x, batchCount, pBuffer)
    }
    pub unsafe fn cusparseCgtsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *const cuComplex,
        d: *const cuComplex,
        du: *const cuComplex,
        x: *const cuComplex,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCgtsvInterleavedBatch_bufferSizeExt)(
            handle,
            algo,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseCnnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        nnzPerRowCol: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCnnz)(
            handle,
            dirA,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerRowCol,
            nnzTotalDevHostPtr,
        )
    }
    pub unsafe fn cusparseCnnz_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        descr: cusparseMatDescr_t,
        csrSortedValA: *const cuComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzPerRow: *mut ::core::ffi::c_int,
        nnzC: *mut ::core::ffi::c_int,
        tol: cuComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseCnnz_compress)(
            handle,
            m,
            descr,
            csrSortedValA,
            csrSortedRowPtrA,
            nnzPerRow,
            nnzC,
            tol,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstBlockedEllGet(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        ellBlockSize: *mut i64,
        ellCols: *mut i64,
        ellColInd: *mut *const ::core::ffi::c_void,
        ellValue: *mut *const ::core::ffi::c_void,
        ellIdxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseConstBlockedEllGet)(
            spMatDescr,
            rows,
            cols,
            ellBlockSize,
            ellCols,
            ellColInd,
            ellValue,
            ellIdxType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstCooGet(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cooRowInd: *mut *const ::core::ffi::c_void,
        cooColInd: *mut *const ::core::ffi::c_void,
        cooValues: *mut *const ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseConstCooGet)(
            spMatDescr, rows, cols, nnz, cooRowInd, cooColInd, cooValues, idxType, idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstCscGet(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cscColOffsets: *mut *const ::core::ffi::c_void,
        cscRowInd: *mut *const ::core::ffi::c_void,
        cscValues: *mut *const ::core::ffi::c_void,
        cscColOffsetsType: *mut cusparseIndexType_t,
        cscRowIndType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseConstCscGet)(
            spMatDescr,
            rows,
            cols,
            nnz,
            cscColOffsets,
            cscRowInd,
            cscValues,
            cscColOffsetsType,
            cscRowIndType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstCsrGet(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        csrRowOffsets: *mut *const ::core::ffi::c_void,
        csrColInd: *mut *const ::core::ffi::c_void,
        csrValues: *mut *const ::core::ffi::c_void,
        csrRowOffsetsType: *mut cusparseIndexType_t,
        csrColIndType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseConstCsrGet)(
            spMatDescr,
            rows,
            cols,
            nnz,
            csrRowOffsets,
            csrColInd,
            csrValues,
            csrRowOffsetsType,
            csrColIndType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstDnMatGet(
        dnMatDescr: cusparseConstDnMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        ld: *mut i64,
        values: *mut *const ::core::ffi::c_void,
        type_: *mut cudaDataType,
        order: *mut cusparseOrder_t,
    ) -> cusparseStatus_t {
        (culib().cusparseConstDnMatGet)(dnMatDescr, rows, cols, ld, values, type_, order)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstDnMatGetValues(
        dnMatDescr: cusparseConstDnMatDescr_t,
        values: *mut *const ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseConstDnMatGetValues)(dnMatDescr, values)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstDnVecGet(
        dnVecDescr: cusparseConstDnVecDescr_t,
        size: *mut i64,
        values: *mut *const ::core::ffi::c_void,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseConstDnVecGet)(dnVecDescr, size, values, valueType)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstDnVecGetValues(
        dnVecDescr: cusparseConstDnVecDescr_t,
        values: *mut *const ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseConstDnVecGetValues)(dnVecDescr, values)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstSpMatGetValues(
        spMatDescr: cusparseConstSpMatDescr_t,
        values: *mut *const ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseConstSpMatGetValues)(spMatDescr, values)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstSpVecGet(
        spVecDescr: cusparseConstSpVecDescr_t,
        size: *mut i64,
        nnz: *mut i64,
        indices: *mut *const ::core::ffi::c_void,
        values: *mut *const ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseConstSpVecGet)(
            spVecDescr, size, nnz, indices, values, idxType, idxBase, valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseConstSpVecGetValues(
        spVecDescr: cusparseConstSpVecDescr_t,
        values: *mut *const ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseConstSpVecGetValues)(spVecDescr, values)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseConstrainedGeMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseConstrainedGeMM)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseConstrainedGeMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseConstrainedGeMM_bufferSize)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCooAoSGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cooInd: *mut *mut ::core::ffi::c_void,
        cooValues: *mut *mut ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCooAoSGet)(
            spMatDescr, rows, cols, nnz, cooInd, cooValues, idxType, idxBase, valueType,
        )
    }
    pub unsafe fn cusparseCooGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cooRowInd: *mut *mut ::core::ffi::c_void,
        cooColInd: *mut *mut ::core::ffi::c_void,
        cooValues: *mut *mut ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCooGet)(
            spMatDescr, rows, cols, nnz, cooRowInd, cooColInd, cooValues, idxType, idxBase,
            valueType,
        )
    }
    pub unsafe fn cusparseCooSetPointers(
        spMatDescr: cusparseSpMatDescr_t,
        cooRows: *mut ::core::ffi::c_void,
        cooColumns: *mut ::core::ffi::c_void,
        cooValues: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCooSetPointers)(spMatDescr, cooRows, cooColumns, cooValues)
    }
    pub unsafe fn cusparseCooSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
        batchStride: i64,
    ) -> cusparseStatus_t {
        (culib().cusparseCooSetStridedBatch)(spMatDescr, batchCount, batchStride)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCopyMatDescr(
        dest: cusparseMatDescr_t,
        src: cusparseMatDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCopyMatDescr)(dest, src)
    }
    pub unsafe fn cusparseCreate(handle: *mut cusparseHandle_t) -> cusparseStatus_t {
        (culib().cusparseCreate)(handle)
    }
    pub unsafe fn cusparseCreateBlockedEll(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        ellBlockSize: i64,
        ellCols: i64,
        ellColInd: *mut ::core::ffi::c_void,
        ellValue: *mut ::core::ffi::c_void,
        ellIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateBlockedEll)(
            spMatDescr,
            rows,
            cols,
            ellBlockSize,
            ellCols,
            ellColInd,
            ellValue,
            ellIdxType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(feature = "cuda-12010"))]
    pub unsafe fn cusparseCreateBsr(
        spMatDescr: *mut cusparseSpMatDescr_t,
        brows: i64,
        bcols: i64,
        bnnz: i64,
        rowBlockDim: i64,
        colBlockDim: i64,
        bsrRowOffsets: *mut ::core::ffi::c_void,
        bsrColInd: *mut ::core::ffi::c_void,
        bsrValues: *mut ::core::ffi::c_void,
        bsrRowOffsetsType: cusparseIndexType_t,
        bsrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateBsr)(
            spMatDescr,
            brows,
            bcols,
            bnnz,
            rowBlockDim,
            colBlockDim,
            bsrRowOffsets,
            bsrColInd,
            bsrValues,
            bsrRowOffsetsType,
            bsrColIndType,
            idxBase,
            valueType,
            order,
        )
    }
    #[cfg(any(
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateBsr(
        spMatDescr: *mut cusparseSpMatDescr_t,
        brows: i64,
        bcols: i64,
        bnnz: i64,
        rowBlockSize: i64,
        colBlockSize: i64,
        bsrRowOffsets: *mut ::core::ffi::c_void,
        bsrColInd: *mut ::core::ffi::c_void,
        bsrValues: *mut ::core::ffi::c_void,
        bsrRowOffsetsType: cusparseIndexType_t,
        bsrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateBsr)(
            spMatDescr,
            brows,
            bcols,
            bnnz,
            rowBlockSize,
            colBlockSize,
            bsrRowOffsets,
            bsrColInd,
            bsrValues,
            bsrRowOffsetsType,
            bsrColIndType,
            idxBase,
            valueType,
            order,
        )
    }
    pub unsafe fn cusparseCreateBsric02Info(info: *mut bsric02Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateBsric02Info)(info)
    }
    pub unsafe fn cusparseCreateBsrilu02Info(info: *mut bsrilu02Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateBsrilu02Info)(info)
    }
    pub unsafe fn cusparseCreateBsrsm2Info(info: *mut bsrsm2Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateBsrsm2Info)(info)
    }
    pub unsafe fn cusparseCreateBsrsv2Info(info: *mut bsrsv2Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateBsrsv2Info)(info)
    }
    pub unsafe fn cusparseCreateColorInfo(info: *mut cusparseColorInfo_t) -> cusparseStatus_t {
        (culib().cusparseCreateColorInfo)(info)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstBlockedEll(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        ellBlockSize: i64,
        ellCols: i64,
        ellColInd: *const ::core::ffi::c_void,
        ellValue: *const ::core::ffi::c_void,
        ellIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstBlockedEll)(
            spMatDescr,
            rows,
            cols,
            ellBlockSize,
            ellCols,
            ellColInd,
            ellValue,
            ellIdxType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstBsr(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        brows: i64,
        bcols: i64,
        bnnz: i64,
        rowBlockDim: i64,
        colBlockDim: i64,
        bsrRowOffsets: *const ::core::ffi::c_void,
        bsrColInd: *const ::core::ffi::c_void,
        bsrValues: *const ::core::ffi::c_void,
        bsrRowOffsetsType: cusparseIndexType_t,
        bsrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstBsr)(
            spMatDescr,
            brows,
            bcols,
            bnnz,
            rowBlockDim,
            colBlockDim,
            bsrRowOffsets,
            bsrColInd,
            bsrValues,
            bsrRowOffsetsType,
            bsrColIndType,
            idxBase,
            valueType,
            order,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstCoo(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cooRowInd: *const ::core::ffi::c_void,
        cooColInd: *const ::core::ffi::c_void,
        cooValues: *const ::core::ffi::c_void,
        cooIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstCoo)(
            spMatDescr, rows, cols, nnz, cooRowInd, cooColInd, cooValues, cooIdxType, idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstCsc(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cscColOffsets: *const ::core::ffi::c_void,
        cscRowInd: *const ::core::ffi::c_void,
        cscValues: *const ::core::ffi::c_void,
        cscColOffsetsType: cusparseIndexType_t,
        cscRowIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstCsc)(
            spMatDescr,
            rows,
            cols,
            nnz,
            cscColOffsets,
            cscRowInd,
            cscValues,
            cscColOffsetsType,
            cscRowIndType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstCsr(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        csrRowOffsets: *const ::core::ffi::c_void,
        csrColInd: *const ::core::ffi::c_void,
        csrValues: *const ::core::ffi::c_void,
        csrRowOffsetsType: cusparseIndexType_t,
        csrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstCsr)(
            spMatDescr,
            rows,
            cols,
            nnz,
            csrRowOffsets,
            csrColInd,
            csrValues,
            csrRowOffsetsType,
            csrColIndType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstDnMat(
        dnMatDescr: *mut cusparseConstDnMatDescr_t,
        rows: i64,
        cols: i64,
        ld: i64,
        values: *const ::core::ffi::c_void,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstDnMat)(dnMatDescr, rows, cols, ld, values, valueType, order)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstDnVec(
        dnVecDescr: *mut cusparseConstDnVecDescr_t,
        size: i64,
        values: *const ::core::ffi::c_void,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstDnVec)(dnVecDescr, size, values, valueType)
    }
    #[cfg(any(
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstSlicedEll(
        spMatDescr: *mut cusparseConstSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        sellValuesSize: i64,
        sliceSize: i64,
        sellSliceOffsets: *const ::core::ffi::c_void,
        sellColInd: *const ::core::ffi::c_void,
        sellValues: *const ::core::ffi::c_void,
        sellSliceOffsetsType: cusparseIndexType_t,
        sellColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstSlicedEll)(
            spMatDescr,
            rows,
            cols,
            nnz,
            sellValuesSize,
            sliceSize,
            sellSliceOffsets,
            sellColInd,
            sellValues,
            sellSliceOffsetsType,
            sellColIndType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateConstSpVec(
        spVecDescr: *mut cusparseConstSpVecDescr_t,
        size: i64,
        nnz: i64,
        indices: *const ::core::ffi::c_void,
        values: *const ::core::ffi::c_void,
        idxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateConstSpVec)(
            spVecDescr, size, nnz, indices, values, idxType, idxBase, valueType,
        )
    }
    pub unsafe fn cusparseCreateCoo(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cooRowInd: *mut ::core::ffi::c_void,
        cooColInd: *mut ::core::ffi::c_void,
        cooValues: *mut ::core::ffi::c_void,
        cooIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateCoo)(
            spMatDescr, rows, cols, nnz, cooRowInd, cooColInd, cooValues, cooIdxType, idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCreateCooAoS(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cooInd: *mut ::core::ffi::c_void,
        cooValues: *mut ::core::ffi::c_void,
        cooIdxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateCooAoS)(
            spMatDescr, rows, cols, nnz, cooInd, cooValues, cooIdxType, idxBase, valueType,
        )
    }
    pub unsafe fn cusparseCreateCsc(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        cscColOffsets: *mut ::core::ffi::c_void,
        cscRowInd: *mut ::core::ffi::c_void,
        cscValues: *mut ::core::ffi::c_void,
        cscColOffsetsType: cusparseIndexType_t,
        cscRowIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateCsc)(
            spMatDescr,
            rows,
            cols,
            nnz,
            cscColOffsets,
            cscRowInd,
            cscValues,
            cscColOffsetsType,
            cscRowIndType,
            idxBase,
            valueType,
        )
    }
    pub unsafe fn cusparseCreateCsr(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        csrRowOffsets: *mut ::core::ffi::c_void,
        csrColInd: *mut ::core::ffi::c_void,
        csrValues: *mut ::core::ffi::c_void,
        csrRowOffsetsType: cusparseIndexType_t,
        csrColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateCsr)(
            spMatDescr,
            rows,
            cols,
            nnz,
            csrRowOffsets,
            csrColInd,
            csrValues,
            csrRowOffsetsType,
            csrColIndType,
            idxBase,
            valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCreateCsrgemm2Info(info: *mut csrgemm2Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateCsrgemm2Info)(info)
    }
    pub unsafe fn cusparseCreateCsric02Info(info: *mut csric02Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateCsric02Info)(info)
    }
    pub unsafe fn cusparseCreateCsrilu02Info(info: *mut csrilu02Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateCsrilu02Info)(info)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCreateCsrsm2Info(info: *mut csrsm2Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateCsrsm2Info)(info)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCreateCsrsv2Info(info: *mut csrsv2Info_t) -> cusparseStatus_t {
        (culib().cusparseCreateCsrsv2Info)(info)
    }
    pub unsafe fn cusparseCreateCsru2csrInfo(info: *mut csru2csrInfo_t) -> cusparseStatus_t {
        (culib().cusparseCreateCsru2csrInfo)(info)
    }
    pub unsafe fn cusparseCreateDnMat(
        dnMatDescr: *mut cusparseDnMatDescr_t,
        rows: i64,
        cols: i64,
        ld: i64,
        values: *mut ::core::ffi::c_void,
        valueType: cudaDataType,
        order: cusparseOrder_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateDnMat)(dnMatDescr, rows, cols, ld, values, valueType, order)
    }
    pub unsafe fn cusparseCreateDnVec(
        dnVecDescr: *mut cusparseDnVecDescr_t,
        size: i64,
        values: *mut ::core::ffi::c_void,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateDnVec)(dnVecDescr, size, values, valueType)
    }
    pub unsafe fn cusparseCreateIdentityPermutation(
        handle: cusparseHandle_t,
        n: ::core::ffi::c_int,
        p: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateIdentityPermutation)(handle, n, p)
    }
    pub unsafe fn cusparseCreateMatDescr(descrA: *mut cusparseMatDescr_t) -> cusparseStatus_t {
        (culib().cusparseCreateMatDescr)(descrA)
    }
    pub unsafe fn cusparseCreatePruneInfo(info: *mut pruneInfo_t) -> cusparseStatus_t {
        (culib().cusparseCreatePruneInfo)(info)
    }
    #[cfg(any(
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCreateSlicedEll(
        spMatDescr: *mut cusparseSpMatDescr_t,
        rows: i64,
        cols: i64,
        nnz: i64,
        sellValuesSize: i64,
        sliceSize: i64,
        sellSliceOffsets: *mut ::core::ffi::c_void,
        sellColInd: *mut ::core::ffi::c_void,
        sellValues: *mut ::core::ffi::c_void,
        sellSliceOffsetsType: cusparseIndexType_t,
        sellColIndType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateSlicedEll)(
            spMatDescr,
            rows,
            cols,
            nnz,
            sellValuesSize,
            sliceSize,
            sellSliceOffsets,
            sellColInd,
            sellValues,
            sellSliceOffsetsType,
            sellColIndType,
            idxBase,
            valueType,
        )
    }
    pub unsafe fn cusparseCreateSpVec(
        spVecDescr: *mut cusparseSpVecDescr_t,
        size: i64,
        nnz: i64,
        indices: *mut ::core::ffi::c_void,
        values: *mut ::core::ffi::c_void,
        idxType: cusparseIndexType_t,
        idxBase: cusparseIndexBase_t,
        valueType: cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCreateSpVec)(
            spVecDescr, size, nnz, indices, values, idxType, idxBase, valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseCscGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        cscColOffsets: *mut *mut ::core::ffi::c_void,
        cscRowInd: *mut *mut ::core::ffi::c_void,
        cscValues: *mut *mut ::core::ffi::c_void,
        cscColOffsetsType: *mut cusparseIndexType_t,
        cscRowIndType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCscGet)(
            spMatDescr,
            rows,
            cols,
            nnz,
            cscColOffsets,
            cscRowInd,
            cscValues,
            cscColOffsetsType,
            cscRowIndType,
            idxBase,
            valueType,
        )
    }
    pub unsafe fn cusparseCscSetPointers(
        spMatDescr: cusparseSpMatDescr_t,
        cscColOffsets: *mut ::core::ffi::c_void,
        cscRowInd: *mut ::core::ffi::c_void,
        cscValues: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCscSetPointers)(spMatDescr, cscColOffsets, cscRowInd, cscValues)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCsctr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *const cuComplex,
        xInd: *const ::core::ffi::c_int,
        y: *mut cuComplex,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseCsctr)(handle, nnz, xVal, xInd, y, idxBase)
    }
    pub unsafe fn cusparseCsr2cscEx2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *const ::core::ffi::c_void,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *const ::core::ffi::c_int,
        cscVal: *mut ::core::ffi::c_void,
        cscColPtr: *mut ::core::ffi::c_int,
        cscRowInd: *mut ::core::ffi::c_int,
        valType: cudaDataType,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        alg: cusparseCsr2CscAlg_t,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCsr2cscEx2)(
            handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, cscVal, cscColPtr, cscRowInd, valType,
            copyValues, idxBase, alg, buffer,
        )
    }
    pub unsafe fn cusparseCsr2cscEx2_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *const ::core::ffi::c_void,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *const ::core::ffi::c_int,
        cscVal: *mut ::core::ffi::c_void,
        cscColPtr: *mut ::core::ffi::c_int,
        cscRowInd: *mut ::core::ffi::c_int,
        valType: cudaDataType,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        alg: cusparseCsr2CscAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCsr2cscEx2_bufferSize)(
            handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, cscVal, cscColPtr, cscRowInd, valType,
            copyValues, idxBase, alg, bufferSize,
        )
    }
    pub unsafe fn cusparseCsrGet(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
        csrRowOffsets: *mut *mut ::core::ffi::c_void,
        csrColInd: *mut *mut ::core::ffi::c_void,
        csrValues: *mut *mut ::core::ffi::c_void,
        csrRowOffsetsType: *mut cusparseIndexType_t,
        csrColIndType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseCsrGet)(
            spMatDescr,
            rows,
            cols,
            nnz,
            csrRowOffsets,
            csrColInd,
            csrValues,
            csrRowOffsetsType,
            csrColIndType,
            idxBase,
            valueType,
        )
    }
    pub unsafe fn cusparseCsrSetPointers(
        spMatDescr: cusparseSpMatDescr_t,
        csrRowOffsets: *mut ::core::ffi::c_void,
        csrColInd: *mut ::core::ffi::c_void,
        csrValues: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCsrSetPointers)(spMatDescr, csrRowOffsets, csrColInd, csrValues)
    }
    pub unsafe fn cusparseCsrSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
        offsetsBatchStride: i64,
        columnsValuesBatchStride: i64,
    ) -> cusparseStatus_t {
        (culib().cusparseCsrSetStridedBatch)(
            spMatDescr,
            batchCount,
            offsetsBatchStride,
            columnsValuesBatchStride,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCsrmvEx(
        handle: cusparseHandle_t,
        alg: cusparseAlgMode_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphatype: cudaDataType,
        descrA: cusparseMatDescr_t,
        csrValA: *const ::core::ffi::c_void,
        csrValAtype: cudaDataType,
        csrRowPtrA: *const ::core::ffi::c_int,
        csrColIndA: *const ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xtype: cudaDataType,
        beta: *const ::core::ffi::c_void,
        betatype: cudaDataType,
        y: *mut ::core::ffi::c_void,
        ytype: cudaDataType,
        executiontype: cudaDataType,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseCsrmvEx)(
            handle,
            alg,
            transA,
            m,
            n,
            nnz,
            alpha,
            alphatype,
            descrA,
            csrValA,
            csrValAtype,
            csrRowPtrA,
            csrColIndA,
            x,
            xtype,
            beta,
            betatype,
            y,
            ytype,
            executiontype,
            buffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseCsrmvEx_bufferSize(
        handle: cusparseHandle_t,
        alg: cusparseAlgMode_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphatype: cudaDataType,
        descrA: cusparseMatDescr_t,
        csrValA: *const ::core::ffi::c_void,
        csrValAtype: cudaDataType,
        csrRowPtrA: *const ::core::ffi::c_int,
        csrColIndA: *const ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xtype: cudaDataType,
        beta: *const ::core::ffi::c_void,
        betatype: cudaDataType,
        y: *mut ::core::ffi::c_void,
        ytype: cudaDataType,
        executiontype: cudaDataType,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseCsrmvEx_bufferSize)(
            handle,
            alg,
            transA,
            m,
            n,
            nnz,
            alpha,
            alphatype,
            descrA,
            csrValA,
            csrValAtype,
            csrRowPtrA,
            csrColIndA,
            x,
            xtype,
            beta,
            betatype,
            y,
            ytype,
            executiontype,
            bufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDaxpyi(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        xVal: *const f64,
        xInd: *const ::core::ffi::c_int,
        y: *mut f64,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseDaxpyi)(handle, nnz, alpha, xVal, xInd, y, idxBase)
    }
    pub unsafe fn cusparseDbsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsr2csr)(
            handle,
            dirA,
            mb,
            nb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
        )
    }
    pub unsafe fn cusparseDbsric02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsric02)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDbsric02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pInputBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsric02_analysis)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pInputBuffer,
        )
    }
    pub unsafe fn cusparseDbsric02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsric02_bufferSize)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDbsrilu02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrilu02)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDbsrilu02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrilu02_analysis)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDbsrilu02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrilu02_bufferSize)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDbsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut f64,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrilu02_numericBoost)(handle, info, enable_boost, tol, boost_val)
    }
    pub unsafe fn cusparseDbsrmm(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrmm)(
            handle,
            dirA,
            transA,
            transB,
            mb,
            n,
            kb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockSize,
            B,
            ldb,
            beta,
            C,
            ldc,
        )
    }
    pub unsafe fn cusparseDbsrmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const f64,
        beta: *const f64,
        y: *mut f64,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrmv)(
            handle,
            dirA,
            transA,
            mb,
            nb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            x,
            beta,
            y,
        )
    }
    pub unsafe fn cusparseDbsrsm2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrsm2_analysis)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDbsrsm2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrsm2_bufferSize)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDbsrsm2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        X: *mut f64,
        ldx: ::core::ffi::c_int,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrsm2_solve)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            alpha,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            B,
            ldb,
            X,
            ldx,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDbsrsv2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrsv2_analysis)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDbsrsv2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *mut f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrsv2_bufferSize)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDbsrsv2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        f: *const f64,
        x: *mut f64,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrsv2_solve)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            f,
            x,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDbsrxmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        sizeOfMask: ::core::ffi::c_int,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedMaskPtrA: *const ::core::ffi::c_int,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedEndPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const f64,
        beta: *const f64,
        y: *mut f64,
    ) -> cusparseStatus_t {
        (culib().cusparseDbsrxmv)(
            handle,
            dirA,
            transA,
            sizeOfMask,
            mb,
            nb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedMaskPtrA,
            bsrSortedRowPtrA,
            bsrSortedEndPtrA,
            bsrSortedColIndA,
            blockDim,
            x,
            beta,
            y,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsc2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscSortedValA: *const f64,
        cscSortedRowIndA: *const ::core::ffi::c_int,
        cscSortedColPtrA: *const ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsc2dense)(
            handle,
            m,
            n,
            descrA,
            cscSortedValA,
            cscSortedRowIndA,
            cscSortedColPtrA,
            A,
            lda,
        )
    }
    pub unsafe fn cusparseDcsr2bsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f64,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsr2bsr)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            blockDim,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
        )
    }
    pub unsafe fn cusparseDcsr2csr_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedColIndA: *const ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValC: *mut f64,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        tol: f64,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsr2csr_compress)(
            handle,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedColIndA,
            csrSortedRowPtrA,
            nnzA,
            nnzPerRow,
            csrSortedValC,
            csrSortedColIndC,
            csrSortedRowPtrC,
            tol,
        )
    }
    pub unsafe fn cusparseDcsr2csru(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut f64,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsr2csru)(
            handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsr2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsr2dense)(
            handle,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            A,
            lda,
        )
    }
    pub unsafe fn cusparseDcsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f64,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsr2gebsr)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
            rowBlockDim,
            colBlockDim,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDcsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsr2gebsr_bufferSize)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            rowBlockDim,
            colBlockDim,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDcsrcolor(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        fractionToColor: *const f64,
        ncolors: *mut ::core::ffi::c_int,
        coloring: *mut ::core::ffi::c_int,
        reordering: *mut ::core::ffi::c_int,
        info: cusparseColorInfo_t,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrcolor)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            fractionToColor,
            ncolors,
            coloring,
            reordering,
            info,
        )
    }
    pub unsafe fn cusparseDcsrgeam2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const f64,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f64,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrgeam2)(
            handle,
            m,
            n,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            beta,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDcsrgeam2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const f64,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f64,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrgeam2_bufferSizeExt)(
            handle,
            m,
            n,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            beta,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrgemm2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f64,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const f64,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedValD: *const f64,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrgemm2)(
            handle,
            m,
            n,
            k,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            beta,
            descrD,
            nnzD,
            csrSortedValD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrgemm2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const f64,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrgemm2_bufferSizeExt)(
            handle,
            m,
            n,
            k,
            alpha,
            descrA,
            nnzA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            beta,
            descrD,
            nnzD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDcsric02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsric02)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA_valM,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDcsric02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsric02_analysis)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDcsric02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsric02_bufferSize)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDcsrilu02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrilu02)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA_valM,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDcsrilu02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrilu02_analysis)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDcsrilu02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrilu02_bufferSize)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDcsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut f64,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrilu02_numericBoost)(handle, info, enable_boost, tol, boost_val)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrsm2_analysis(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrsm2_analysis)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrsm2_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrsm2_bufferSizeExt)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrsm2_solve(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrsm2_solve)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrsv2_analysis(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrsv2_analysis)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrsv2_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrsv2_bufferSize)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrsv2_bufferSizeExt)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDcsrsv2_solve(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        f: *const f64,
        x: *mut f64,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsrsv2_solve)(
            handle,
            transA,
            m,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            f,
            x,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDcsru2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut f64,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsru2csr)(
            handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer,
        )
    }
    pub unsafe fn cusparseDcsru2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *mut f64,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDcsru2csr_bufferSizeExt)(
            handle,
            m,
            n,
            nnz,
            csrVal,
            csrRowPtr,
            csrColInd,
            info,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDdense2csc(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f64,
        lda: ::core::ffi::c_int,
        nnzPerCol: *const ::core::ffi::c_int,
        cscSortedValA: *mut f64,
        cscSortedRowIndA: *mut ::core::ffi::c_int,
        cscSortedColPtrA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDdense2csc)(
            handle,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerCol,
            cscSortedValA,
            cscSortedRowIndA,
            cscSortedColPtrA,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDdense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f64,
        lda: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValA: *mut f64,
        csrSortedRowPtrA: *mut ::core::ffi::c_int,
        csrSortedColIndA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDdense2csr)(
            handle,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerRow,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
        )
    }
    #[cfg(any(feature = "cuda-11040"))]
    pub unsafe fn cusparseDenseToSparse_analysis(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDenseToSparse_analysis)(handle, matA, matB, alg, buffer)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDenseToSparse_analysis(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDenseToSparse_analysis)(handle, matA, matB, alg, externalBuffer)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseDenseToSparse_analysis(
        handle: cusparseHandle_t,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDenseToSparse_analysis)(handle, matA, matB, alg, externalBuffer)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDenseToSparse_bufferSize(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDenseToSparse_bufferSize)(handle, matA, matB, alg, bufferSize)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseDenseToSparse_bufferSize(
        handle: cusparseHandle_t,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDenseToSparse_bufferSize)(handle, matA, matB, alg, bufferSize)
    }
    #[cfg(any(feature = "cuda-11040"))]
    pub unsafe fn cusparseDenseToSparse_convert(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDenseToSparse_convert)(handle, matA, matB, alg, buffer)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDenseToSparse_convert(
        handle: cusparseHandle_t,
        matA: cusparseDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDenseToSparse_convert)(handle, matA, matB, alg, externalBuffer)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseDenseToSparse_convert(
        handle: cusparseHandle_t,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseSpMatDescr_t,
        alg: cusparseDenseToSparseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDenseToSparse_convert)(handle, matA, matB, alg, externalBuffer)
    }
    pub unsafe fn cusparseDestroy(handle: cusparseHandle_t) -> cusparseStatus_t {
        (culib().cusparseDestroy)(handle)
    }
    pub unsafe fn cusparseDestroyBsric02Info(info: bsric02Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyBsric02Info)(info)
    }
    pub unsafe fn cusparseDestroyBsrilu02Info(info: bsrilu02Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyBsrilu02Info)(info)
    }
    pub unsafe fn cusparseDestroyBsrsm2Info(info: bsrsm2Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyBsrsm2Info)(info)
    }
    pub unsafe fn cusparseDestroyBsrsv2Info(info: bsrsv2Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyBsrsv2Info)(info)
    }
    pub unsafe fn cusparseDestroyColorInfo(info: cusparseColorInfo_t) -> cusparseStatus_t {
        (culib().cusparseDestroyColorInfo)(info)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDestroyCsrgemm2Info(info: csrgemm2Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyCsrgemm2Info)(info)
    }
    pub unsafe fn cusparseDestroyCsric02Info(info: csric02Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyCsric02Info)(info)
    }
    pub unsafe fn cusparseDestroyCsrilu02Info(info: csrilu02Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyCsrilu02Info)(info)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDestroyCsrsm2Info(info: csrsm2Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyCsrsm2Info)(info)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDestroyCsrsv2Info(info: csrsv2Info_t) -> cusparseStatus_t {
        (culib().cusparseDestroyCsrsv2Info)(info)
    }
    pub unsafe fn cusparseDestroyCsru2csrInfo(info: csru2csrInfo_t) -> cusparseStatus_t {
        (culib().cusparseDestroyCsru2csrInfo)(info)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDestroyDnMat(dnMatDescr: cusparseDnMatDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroyDnMat)(dnMatDescr)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseDestroyDnMat(dnMatDescr: cusparseConstDnMatDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroyDnMat)(dnMatDescr)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDestroyDnVec(dnVecDescr: cusparseDnVecDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroyDnVec)(dnVecDescr)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseDestroyDnVec(dnVecDescr: cusparseConstDnVecDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroyDnVec)(dnVecDescr)
    }
    pub unsafe fn cusparseDestroyMatDescr(descrA: cusparseMatDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroyMatDescr)(descrA)
    }
    pub unsafe fn cusparseDestroyPruneInfo(info: pruneInfo_t) -> cusparseStatus_t {
        (culib().cusparseDestroyPruneInfo)(info)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDestroySpMat(spMatDescr: cusparseSpMatDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroySpMat)(spMatDescr)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseDestroySpMat(spMatDescr: cusparseConstSpMatDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroySpMat)(spMatDescr)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDestroySpVec(spVecDescr: cusparseSpVecDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroySpVec)(spVecDescr)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseDestroySpVec(spVecDescr: cusparseConstSpVecDescr_t) -> cusparseStatus_t {
        (culib().cusparseDestroySpVec)(spVecDescr)
    }
    pub unsafe fn cusparseDgebsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDgebsr2csr)(
            handle,
            dirA,
            mb,
            nb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDim,
            colBlockDim,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
        )
    }
    pub unsafe fn cusparseDgebsr2gebsc(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        bscVal: *mut f64,
        bscRowInd: *mut ::core::ffi::c_int,
        bscColPtr: *mut ::core::ffi::c_int,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDgebsr2gebsc)(
            handle,
            mb,
            nb,
            nnzb,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            rowBlockDim,
            colBlockDim,
            bscVal,
            bscRowInd,
            bscColPtr,
            copyValues,
            idxBase,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDgebsr2gebsc_bufferSize(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const f64,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDgebsr2gebsc_bufferSize)(
            handle,
            mb,
            nb,
            nnzb,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            rowBlockDim,
            colBlockDim,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDgebsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f64,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDgebsr2gebsr)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
            rowBlockDimC,
            colBlockDimC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDgebsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f64,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDgebsr2gebsr_bufferSize)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            rowBlockDimC,
            colBlockDimC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDgemmi(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        cscValB: *const f64,
        cscColPtrB: *const ::core::ffi::c_int,
        cscRowIndB: *const ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDgemmi)(
            handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc,
        )
    }
    pub unsafe fn cusparseDgemvi(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        xVal: *const f64,
        xInd: *const ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDgemvi)(
            handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer,
        )
    }
    pub unsafe fn cusparseDgemvi_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        pBufferSize: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDgemvi_bufferSize)(handle, transA, m, n, nnz, pBufferSize)
    }
    pub unsafe fn cusparseDgpsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *mut f64,
        dl: *mut f64,
        d: *mut f64,
        du: *mut f64,
        dw: *mut f64,
        x: *mut f64,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDgpsvInterleavedBatch)(
            handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBuffer,
        )
    }
    pub unsafe fn cusparseDgpsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *const f64,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        dw: *const f64,
        x: *const f64,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDgpsvInterleavedBatch_bufferSizeExt)(
            handle,
            algo,
            m,
            ds,
            dl,
            d,
            du,
            dw,
            x,
            batchCount,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDgthr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *const f64,
        xVal: *mut f64,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseDgthr)(handle, nnz, y, xVal, xInd, idxBase)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDgthrz(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *mut f64,
        xVal: *mut f64,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseDgthrz)(handle, nnz, y, xVal, xInd, idxBase)
    }
    pub unsafe fn cusparseDgtsv2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDgtsv2)(handle, m, n, dl, d, du, B, ldb, pBuffer)
    }
    pub unsafe fn cusparseDgtsv2StridedBatch(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        x: *mut f64,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDgtsv2StridedBatch)(
            handle,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            batchStride,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDgtsv2StridedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        x: *const f64,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDgtsv2StridedBatch_bufferSizeExt)(
            handle,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            batchStride,
            bufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDgtsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDgtsv2_bufferSizeExt)(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes)
    }
    pub unsafe fn cusparseDgtsv2_nopivot(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDgtsv2_nopivot)(handle, m, n, dl, d, du, B, ldb, pBuffer)
    }
    pub unsafe fn cusparseDgtsv2_nopivot_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDgtsv2_nopivot_bufferSizeExt)(
            handle,
            m,
            n,
            dl,
            d,
            du,
            B,
            ldb,
            bufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDgtsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *mut f64,
        d: *mut f64,
        du: *mut f64,
        x: *mut f64,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDgtsvInterleavedBatch)(handle, algo, m, dl, d, du, x, batchCount, pBuffer)
    }
    pub unsafe fn cusparseDgtsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *const f64,
        d: *const f64,
        du: *const f64,
        x: *const f64,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDgtsvInterleavedBatch_bufferSizeExt)(
            handle,
            algo,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDnMatGet(
        dnMatDescr: cusparseDnMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        ld: *mut i64,
        values: *mut *mut ::core::ffi::c_void,
        type_: *mut cudaDataType,
        order: *mut cusparseOrder_t,
    ) -> cusparseStatus_t {
        (culib().cusparseDnMatGet)(dnMatDescr, rows, cols, ld, values, type_, order)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDnMatGetStridedBatch(
        dnMatDescr: cusparseDnMatDescr_t,
        batchCount: *mut ::core::ffi::c_int,
        batchStride: *mut i64,
    ) -> cusparseStatus_t {
        (culib().cusparseDnMatGetStridedBatch)(dnMatDescr, batchCount, batchStride)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseDnMatGetStridedBatch(
        dnMatDescr: cusparseConstDnMatDescr_t,
        batchCount: *mut ::core::ffi::c_int,
        batchStride: *mut i64,
    ) -> cusparseStatus_t {
        (culib().cusparseDnMatGetStridedBatch)(dnMatDescr, batchCount, batchStride)
    }
    pub unsafe fn cusparseDnMatGetValues(
        dnMatDescr: cusparseDnMatDescr_t,
        values: *mut *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDnMatGetValues)(dnMatDescr, values)
    }
    pub unsafe fn cusparseDnMatSetStridedBatch(
        dnMatDescr: cusparseDnMatDescr_t,
        batchCount: ::core::ffi::c_int,
        batchStride: i64,
    ) -> cusparseStatus_t {
        (culib().cusparseDnMatSetStridedBatch)(dnMatDescr, batchCount, batchStride)
    }
    pub unsafe fn cusparseDnMatSetValues(
        dnMatDescr: cusparseDnMatDescr_t,
        values: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDnMatSetValues)(dnMatDescr, values)
    }
    pub unsafe fn cusparseDnVecGet(
        dnVecDescr: cusparseDnVecDescr_t,
        size: *mut i64,
        values: *mut *mut ::core::ffi::c_void,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseDnVecGet)(dnVecDescr, size, values, valueType)
    }
    pub unsafe fn cusparseDnVecGetValues(
        dnVecDescr: cusparseDnVecDescr_t,
        values: *mut *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDnVecGetValues)(dnVecDescr, values)
    }
    pub unsafe fn cusparseDnVecSetValues(
        dnVecDescr: cusparseDnVecDescr_t,
        values: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDnVecSetValues)(dnVecDescr, values)
    }
    pub unsafe fn cusparseDnnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f64,
        lda: ::core::ffi::c_int,
        nnzPerRowCol: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseDnnz)(
            handle,
            dirA,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerRowCol,
            nnzTotalDevHostPtr,
        )
    }
    pub unsafe fn cusparseDnnz_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        descr: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzPerRow: *mut ::core::ffi::c_int,
        nnzC: *mut ::core::ffi::c_int,
        tol: f64,
    ) -> cusparseStatus_t {
        (culib().cusparseDnnz_compress)(
            handle,
            m,
            descr,
            csrSortedValA,
            csrSortedRowPtrA,
            nnzPerRow,
            nnzC,
            tol,
        )
    }
    pub unsafe fn cusparseDpruneCsr2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneCsr2csr)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            threshold,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDpruneCsr2csrByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneCsr2csrByPercentage)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            percentage,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDpruneCsr2csrByPercentage_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        info: pruneInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneCsr2csrByPercentage_bufferSizeExt)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            percentage,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDpruneCsr2csrNnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneCsr2csrNnz)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            threshold,
            descrC,
            csrSortedRowPtrC,
            nnzTotalDevHostPtr,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDpruneCsr2csrNnzByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneCsr2csrNnzByPercentage)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            percentage,
            descrC,
            csrSortedRowPtrC,
            nnzTotalDevHostPtr,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDpruneCsr2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f64,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneCsr2csr_bufferSizeExt)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            threshold,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDpruneDense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneDense2csr)(
            handle,
            m,
            n,
            A,
            lda,
            threshold,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDpruneDense2csrByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneDense2csrByPercentage)(
            handle,
            m,
            n,
            A,
            lda,
            percentage,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDpruneDense2csrByPercentage_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        info: pruneInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneDense2csrByPercentage_bufferSizeExt)(
            handle,
            m,
            n,
            A,
            lda,
            percentage,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseDpruneDense2csrNnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneDense2csrNnz)(
            handle,
            m,
            n,
            A,
            lda,
            threshold,
            descrC,
            csrSortedRowPtrC,
            nnzTotalDevHostPtr,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDpruneDense2csrNnzByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneDense2csrNnzByPercentage)(
            handle,
            m,
            n,
            A,
            lda,
            percentage,
            descrC,
            csrRowPtrC,
            nnzTotalDevHostPtr,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseDpruneDense2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        threshold: *const f64,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f64,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseDpruneDense2csr_bufferSizeExt)(
            handle,
            m,
            n,
            A,
            lda,
            threshold,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDroti(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *mut f64,
        xInd: *const ::core::ffi::c_int,
        y: *mut f64,
        c: *const f64,
        s: *const f64,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseDroti)(handle, nnz, xVal, xInd, y, c, s, idxBase)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseDsctr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *const f64,
        xInd: *const ::core::ffi::c_int,
        y: *mut f64,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseDsctr)(handle, nnz, xVal, xInd, y, idxBase)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseGather(
        handle: cusparseHandle_t,
        vecY: cusparseDnVecDescr_t,
        vecX: cusparseSpVecDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseGather)(handle, vecY, vecX)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseGather(
        handle: cusparseHandle_t,
        vecY: cusparseConstDnVecDescr_t,
        vecX: cusparseSpVecDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseGather)(handle, vecY, vecX)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000"
    ))]
    pub unsafe fn cusparseGetColorAlgs(
        info: cusparseColorInfo_t,
        alg: *mut cusparseColorAlg_t,
    ) -> cusparseStatus_t {
        (culib().cusparseGetColorAlgs)(info, alg)
    }
    pub unsafe fn cusparseGetErrorName(status: cusparseStatus_t) -> *const ::core::ffi::c_char {
        (culib().cusparseGetErrorName)(status)
    }
    pub unsafe fn cusparseGetErrorString(status: cusparseStatus_t) -> *const ::core::ffi::c_char {
        (culib().cusparseGetErrorString)(status)
    }
    pub unsafe fn cusparseGetMatDiagType(descrA: cusparseMatDescr_t) -> cusparseDiagType_t {
        (culib().cusparseGetMatDiagType)(descrA)
    }
    pub unsafe fn cusparseGetMatFillMode(descrA: cusparseMatDescr_t) -> cusparseFillMode_t {
        (culib().cusparseGetMatFillMode)(descrA)
    }
    pub unsafe fn cusparseGetMatIndexBase(descrA: cusparseMatDescr_t) -> cusparseIndexBase_t {
        (culib().cusparseGetMatIndexBase)(descrA)
    }
    pub unsafe fn cusparseGetMatType(descrA: cusparseMatDescr_t) -> cusparseMatrixType_t {
        (culib().cusparseGetMatType)(descrA)
    }
    pub unsafe fn cusparseGetPointerMode(
        handle: cusparseHandle_t,
        mode: *mut cusparsePointerMode_t,
    ) -> cusparseStatus_t {
        (culib().cusparseGetPointerMode)(handle, mode)
    }
    pub unsafe fn cusparseGetProperty(
        type_: libraryPropertyType,
        value: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseGetProperty)(type_, value)
    }
    pub unsafe fn cusparseGetStream(
        handle: cusparseHandle_t,
        streamId: *mut cudaStream_t,
    ) -> cusparseStatus_t {
        (culib().cusparseGetStream)(handle, streamId)
    }
    pub unsafe fn cusparseGetVersion(
        handle: cusparseHandle_t,
        version: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseGetVersion)(handle, version)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseLoggerForceDisable() -> cusparseStatus_t {
        (culib().cusparseLoggerForceDisable)()
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseLoggerOpenFile(logFile: *const ::core::ffi::c_char) -> cusparseStatus_t {
        (culib().cusparseLoggerOpenFile)(logFile)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseLoggerSetCallback(
        callback: cusparseLoggerCallback_t,
    ) -> cusparseStatus_t {
        (culib().cusparseLoggerSetCallback)(callback)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseLoggerSetFile(file: *mut FILE) -> cusparseStatus_t {
        (culib().cusparseLoggerSetFile)(file)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseLoggerSetLevel(level: ::core::ffi::c_int) -> cusparseStatus_t {
        (culib().cusparseLoggerSetLevel)(level)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseLoggerSetMask(mask: ::core::ffi::c_int) -> cusparseStatus_t {
        (culib().cusparseLoggerSetMask)(mask)
    }
    pub unsafe fn cusparseRot(
        handle: cusparseHandle_t,
        c_coeff: *const ::core::ffi::c_void,
        s_coeff: *const ::core::ffi::c_void,
        vecX: cusparseSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseRot)(handle, c_coeff, s_coeff, vecX, vecY)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSDDMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSDDMM)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSDDMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSDDMM)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSDDMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSDDMM_bufferSize)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSDDMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSDDMM_bufferSize)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSDDMM_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseDnMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSDDMM_preprocess)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSDDMM_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstDnMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSDDMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSDDMM_preprocess)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSaxpyi(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        xVal: *const f32,
        xInd: *const ::core::ffi::c_int,
        y: *mut f32,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSaxpyi)(handle, nnz, alpha, xVal, xInd, y, idxBase)
    }
    pub unsafe fn cusparseSbsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsr2csr)(
            handle,
            dirA,
            mb,
            nb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
        )
    }
    pub unsafe fn cusparseSbsric02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsric02)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSbsric02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pInputBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsric02_analysis)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pInputBuffer,
        )
    }
    pub unsafe fn cusparseSbsric02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsric02_bufferSize)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSbsrilu02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrilu02)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSbsrilu02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrilu02_analysis)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSbsrilu02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrilu02_bufferSize)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSbsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut f32,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrilu02_numericBoost)(handle, info, enable_boost, tol, boost_val)
    }
    pub unsafe fn cusparseSbsrmm(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrmm)(
            handle,
            dirA,
            transA,
            transB,
            mb,
            n,
            kb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockSize,
            B,
            ldb,
            beta,
            C,
            ldc,
        )
    }
    pub unsafe fn cusparseSbsrmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const f32,
        beta: *const f32,
        y: *mut f32,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrmv)(
            handle,
            dirA,
            transA,
            mb,
            nb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            x,
            beta,
            y,
        )
    }
    pub unsafe fn cusparseSbsrsm2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrsm2_analysis)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSbsrsm2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrsm2_bufferSize)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSbsrsm2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        X: *mut f32,
        ldx: ::core::ffi::c_int,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrsm2_solve)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            alpha,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            B,
            ldb,
            X,
            ldx,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSbsrsv2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrsv2_analysis)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSbsrsv2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *mut f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrsv2_bufferSize)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSbsrsv2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        f: *const f32,
        x: *mut f32,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrsv2_solve)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            f,
            x,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSbsrxmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        sizeOfMask: ::core::ffi::c_int,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedMaskPtrA: *const ::core::ffi::c_int,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedEndPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const f32,
        beta: *const f32,
        y: *mut f32,
    ) -> cusparseStatus_t {
        (culib().cusparseSbsrxmv)(
            handle,
            dirA,
            transA,
            sizeOfMask,
            mb,
            nb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedMaskPtrA,
            bsrSortedRowPtrA,
            bsrSortedEndPtrA,
            bsrSortedColIndA,
            blockDim,
            x,
            beta,
            y,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScatter(
        handle: cusparseHandle_t,
        vecX: cusparseSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseScatter)(handle, vecX, vecY)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseScatter(
        handle: cusparseHandle_t,
        vecX: cusparseConstSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseScatter)(handle, vecX, vecY)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsc2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscSortedValA: *const f32,
        cscSortedRowIndA: *const ::core::ffi::c_int,
        cscSortedColPtrA: *const ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseScsc2dense)(
            handle,
            m,
            n,
            descrA,
            cscSortedValA,
            cscSortedRowIndA,
            cscSortedColPtrA,
            A,
            lda,
        )
    }
    pub unsafe fn cusparseScsr2bsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f32,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseScsr2bsr)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            blockDim,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
        )
    }
    pub unsafe fn cusparseScsr2csr_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedColIndA: *const ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValC: *mut f32,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        tol: f32,
    ) -> cusparseStatus_t {
        (culib().cusparseScsr2csr_compress)(
            handle,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedColIndA,
            csrSortedRowPtrA,
            nnzA,
            nnzPerRow,
            csrSortedValC,
            csrSortedColIndC,
            csrSortedRowPtrC,
            tol,
        )
    }
    pub unsafe fn cusparseScsr2csru(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut f32,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsr2csru)(
            handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsr2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseScsr2dense)(
            handle,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            A,
            lda,
        )
    }
    pub unsafe fn cusparseScsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f32,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsr2gebsr)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
            rowBlockDim,
            colBlockDim,
            pBuffer,
        )
    }
    pub unsafe fn cusparseScsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseScsr2gebsr_bufferSize)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            rowBlockDim,
            colBlockDim,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseScsrcolor(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        fractionToColor: *const f32,
        ncolors: *mut ::core::ffi::c_int,
        coloring: *mut ::core::ffi::c_int,
        reordering: *mut ::core::ffi::c_int,
        info: cusparseColorInfo_t,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrcolor)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            fractionToColor,
            ncolors,
            coloring,
            reordering,
            info,
        )
    }
    pub unsafe fn cusparseScsrgeam2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const f32,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f32,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrgeam2)(
            handle,
            m,
            n,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            beta,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseScsrgeam2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const f32,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f32,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrgeam2_bufferSizeExt)(
            handle,
            m,
            n,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            beta,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrgemm2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const f32,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const f32,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedValD: *const f32,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrgemm2)(
            handle,
            m,
            n,
            k,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            beta,
            descrD,
            nnzD,
            csrSortedValD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrgemm2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const f32,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrgemm2_bufferSizeExt)(
            handle,
            m,
            n,
            k,
            alpha,
            descrA,
            nnzA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            beta,
            descrD,
            nnzD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseScsric02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsric02)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA_valM,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseScsric02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsric02_analysis)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseScsric02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseScsric02_bufferSize)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseScsrilu02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrilu02)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA_valM,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseScsrilu02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrilu02_analysis)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseScsrilu02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrilu02_bufferSize)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseScsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut f32,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrilu02_numericBoost)(handle, info, enable_boost, tol, boost_val)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrsm2_analysis(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrsm2_analysis)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrsm2_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrsm2_bufferSizeExt)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrsm2_solve(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrsm2_solve)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrsv2_analysis(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrsv2_analysis)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrsv2_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrsv2_bufferSize)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrsv2_bufferSizeExt)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseScsrsv2_solve(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        f: *const f32,
        x: *mut f32,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsrsv2_solve)(
            handle,
            transA,
            m,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            f,
            x,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseScsru2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut f32,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseScsru2csr)(
            handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer,
        )
    }
    pub unsafe fn cusparseScsru2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *mut f32,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseScsru2csr_bufferSizeExt)(
            handle,
            m,
            n,
            nnz,
            csrVal,
            csrRowPtr,
            csrColInd,
            info,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSdense2csc(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f32,
        lda: ::core::ffi::c_int,
        nnzPerCol: *const ::core::ffi::c_int,
        cscSortedValA: *mut f32,
        cscSortedRowIndA: *mut ::core::ffi::c_int,
        cscSortedColPtrA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSdense2csc)(
            handle,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerCol,
            cscSortedValA,
            cscSortedRowIndA,
            cscSortedColPtrA,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSdense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f32,
        lda: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValA: *mut f32,
        csrSortedRowPtrA: *mut ::core::ffi::c_int,
        csrSortedColIndA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSdense2csr)(
            handle,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerRow,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000"
    ))]
    pub unsafe fn cusparseSetColorAlgs(
        info: cusparseColorInfo_t,
        alg: cusparseColorAlg_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSetColorAlgs)(info, alg)
    }
    pub unsafe fn cusparseSetMatDiagType(
        descrA: cusparseMatDescr_t,
        diagType: cusparseDiagType_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSetMatDiagType)(descrA, diagType)
    }
    pub unsafe fn cusparseSetMatFillMode(
        descrA: cusparseMatDescr_t,
        fillMode: cusparseFillMode_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSetMatFillMode)(descrA, fillMode)
    }
    pub unsafe fn cusparseSetMatIndexBase(
        descrA: cusparseMatDescr_t,
        base: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSetMatIndexBase)(descrA, base)
    }
    pub unsafe fn cusparseSetMatType(
        descrA: cusparseMatDescr_t,
        type_: cusparseMatrixType_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSetMatType)(descrA, type_)
    }
    pub unsafe fn cusparseSetPointerMode(
        handle: cusparseHandle_t,
        mode: cusparsePointerMode_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSetPointerMode)(handle, mode)
    }
    pub unsafe fn cusparseSetStream(
        handle: cusparseHandle_t,
        streamId: cudaStream_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSetStream)(handle, streamId)
    }
    pub unsafe fn cusparseSgebsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSgebsr2csr)(
            handle,
            dirA,
            mb,
            nb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDim,
            colBlockDim,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
        )
    }
    pub unsafe fn cusparseSgebsr2gebsc(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        bscVal: *mut f32,
        bscRowInd: *mut ::core::ffi::c_int,
        bscColPtr: *mut ::core::ffi::c_int,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSgebsr2gebsc)(
            handle,
            mb,
            nb,
            nnzb,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            rowBlockDim,
            colBlockDim,
            bscVal,
            bscRowInd,
            bscColPtr,
            copyValues,
            idxBase,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSgebsr2gebsc_bufferSize(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const f32,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSgebsr2gebsc_bufferSize)(
            handle,
            mb,
            nb,
            nnzb,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            rowBlockDim,
            colBlockDim,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSgebsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut f32,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSgebsr2gebsr)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
            rowBlockDimC,
            colBlockDimC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSgebsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const f32,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSgebsr2gebsr_bufferSize)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            rowBlockDimC,
            colBlockDimC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSgemmi(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        cscValB: *const f32,
        cscColPtrB: *const ::core::ffi::c_int,
        cscRowIndB: *const ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSgemmi)(
            handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc,
        )
    }
    pub unsafe fn cusparseSgemvi(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        xVal: *const f32,
        xInd: *const ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSgemvi)(
            handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer,
        )
    }
    pub unsafe fn cusparseSgemvi_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        pBufferSize: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSgemvi_bufferSize)(handle, transA, m, n, nnz, pBufferSize)
    }
    pub unsafe fn cusparseSgpsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *mut f32,
        dl: *mut f32,
        d: *mut f32,
        du: *mut f32,
        dw: *mut f32,
        x: *mut f32,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSgpsvInterleavedBatch)(
            handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBuffer,
        )
    }
    pub unsafe fn cusparseSgpsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *const f32,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        dw: *const f32,
        x: *const f32,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSgpsvInterleavedBatch_bufferSizeExt)(
            handle,
            algo,
            m,
            ds,
            dl,
            d,
            du,
            dw,
            x,
            batchCount,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSgthr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *const f32,
        xVal: *mut f32,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSgthr)(handle, nnz, y, xVal, xInd, idxBase)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSgthrz(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *mut f32,
        xVal: *mut f32,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSgthrz)(handle, nnz, y, xVal, xInd, idxBase)
    }
    pub unsafe fn cusparseSgtsv2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSgtsv2)(handle, m, n, dl, d, du, B, ldb, pBuffer)
    }
    pub unsafe fn cusparseSgtsv2StridedBatch(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        x: *mut f32,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSgtsv2StridedBatch)(
            handle,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            batchStride,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSgtsv2StridedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        x: *const f32,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSgtsv2StridedBatch_bufferSizeExt)(
            handle,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            batchStride,
            bufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSgtsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSgtsv2_bufferSizeExt)(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes)
    }
    pub unsafe fn cusparseSgtsv2_nopivot(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSgtsv2_nopivot)(handle, m, n, dl, d, du, B, ldb, pBuffer)
    }
    pub unsafe fn cusparseSgtsv2_nopivot_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSgtsv2_nopivot_bufferSizeExt)(
            handle,
            m,
            n,
            dl,
            d,
            du,
            B,
            ldb,
            bufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSgtsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *mut f32,
        d: *mut f32,
        du: *mut f32,
        x: *mut f32,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSgtsvInterleavedBatch)(handle, algo, m, dl, d, du, x, batchCount, pBuffer)
    }
    pub unsafe fn cusparseSgtsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *const f32,
        d: *const f32,
        du: *const f32,
        x: *const f32,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSgtsvInterleavedBatch_bufferSizeExt)(
            handle,
            algo,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSnnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const f32,
        lda: ::core::ffi::c_int,
        nnzPerRowCol: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSnnz)(
            handle,
            dirA,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerRowCol,
            nnzTotalDevHostPtr,
        )
    }
    pub unsafe fn cusparseSnnz_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        descr: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzPerRow: *mut ::core::ffi::c_int,
        nnzC: *mut ::core::ffi::c_int,
        tol: f32,
    ) -> cusparseStatus_t {
        (culib().cusparseSnnz_compress)(
            handle,
            m,
            descr,
            csrSortedValA,
            csrSortedRowPtrA,
            nnzPerRow,
            nnzC,
            tol,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpGEMM_compute(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize2: *mut usize,
        externalBuffer2: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_compute)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
            bufferSize2,
            externalBuffer2,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMM_compute(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize2: *mut usize,
        externalBuffer2: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_compute)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
            bufferSize2,
            externalBuffer2,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpGEMM_copy(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_copy)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMM_copy(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_copy)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
        )
    }
    pub unsafe fn cusparseSpGEMM_createDescr(
        descr: *mut cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_createDescr)(descr)
    }
    pub unsafe fn cusparseSpGEMM_destroyDescr(descr: cusparseSpGEMMDescr_t) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_destroyDescr)(descr)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMM_estimateMemory(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        chunk_fraction: f32,
        bufferSize3: *mut usize,
        externalBuffer3: *mut ::core::ffi::c_void,
        bufferSize2: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_estimateMemory)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
            chunk_fraction,
            bufferSize3,
            externalBuffer3,
            bufferSize2,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMM_getNumProducts(
        spgemmDescr: cusparseSpGEMMDescr_t,
        num_prods: *mut i64,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_getNumProducts)(spgemmDescr, num_prods)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpGEMM_workEstimation(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize1: *mut usize,
        externalBuffer1: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_workEstimation)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
            bufferSize1,
            externalBuffer1,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMM_workEstimation(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize1: *mut usize,
        externalBuffer1: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMM_workEstimation)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
            bufferSize1,
            externalBuffer1,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpGEMMreuse_compute(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMMreuse_compute)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMMreuse_compute(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseSpMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMMreuse_compute)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            spgemmDescr,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpGEMMreuse_copy(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize5: *mut usize,
        externalBuffer5: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMMreuse_copy)(
            handle,
            opA,
            opB,
            matA,
            matB,
            matC,
            alg,
            spgemmDescr,
            bufferSize5,
            externalBuffer5,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMMreuse_copy(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize5: *mut usize,
        externalBuffer5: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMMreuse_copy)(
            handle,
            opA,
            opB,
            matA,
            matB,
            matC,
            alg,
            spgemmDescr,
            bufferSize5,
            externalBuffer5,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpGEMMreuse_nnz(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize2: *mut usize,
        externalBuffer2: *mut ::core::ffi::c_void,
        bufferSize3: *mut usize,
        externalBuffer3: *mut ::core::ffi::c_void,
        bufferSize4: *mut usize,
        externalBuffer4: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMMreuse_nnz)(
            handle,
            opA,
            opB,
            matA,
            matB,
            matC,
            alg,
            spgemmDescr,
            bufferSize2,
            externalBuffer2,
            bufferSize3,
            externalBuffer3,
            bufferSize4,
            externalBuffer4,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMMreuse_nnz(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize2: *mut usize,
        externalBuffer2: *mut ::core::ffi::c_void,
        bufferSize3: *mut usize,
        externalBuffer3: *mut ::core::ffi::c_void,
        bufferSize4: *mut usize,
        externalBuffer4: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMMreuse_nnz)(
            handle,
            opA,
            opB,
            matA,
            matB,
            matC,
            alg,
            spgemmDescr,
            bufferSize2,
            externalBuffer2,
            bufferSize3,
            externalBuffer3,
            bufferSize4,
            externalBuffer4,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpGEMMreuse_workEstimation(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize1: *mut usize,
        externalBuffer1: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMMreuse_workEstimation)(
            handle,
            opA,
            opB,
            matA,
            matB,
            matC,
            alg,
            spgemmDescr,
            bufferSize1,
            externalBuffer1,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpGEMMreuse_workEstimation(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstSpMatDescr_t,
        matC: cusparseSpMatDescr_t,
        alg: cusparseSpGEMMAlg_t,
        spgemmDescr: cusparseSpGEMMDescr_t,
        bufferSize1: *mut usize,
        externalBuffer1: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpGEMMreuse_workEstimation)(
            handle,
            opA,
            opB,
            matA,
            matB,
            matC,
            alg,
            spgemmDescr,
            bufferSize1,
            externalBuffer1,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMM)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMM(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMM)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMMOp(
        plan: cusparseSpMMOpPlan_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMMOp)(plan, externalBuffer)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMMOp_createPlan(
        handle: cusparseHandle_t,
        plan: *mut cusparseSpMMOpPlan_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMOpAlg_t,
        addOperationNvvmBuffer: *const ::core::ffi::c_void,
        addOperationBufferSize: usize,
        mulOperationNvvmBuffer: *const ::core::ffi::c_void,
        mulOperationBufferSize: usize,
        epilogueNvvmBuffer: *const ::core::ffi::c_void,
        epilogueBufferSize: usize,
        SpMMWorkspaceSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMMOp_createPlan)(
            handle,
            plan,
            opA,
            opB,
            matA,
            matB,
            matC,
            computeType,
            alg,
            addOperationNvvmBuffer,
            addOperationBufferSize,
            mulOperationNvvmBuffer,
            mulOperationBufferSize,
            epilogueNvvmBuffer,
            epilogueBufferSize,
            SpMMWorkspaceSize,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMMOp_createPlan(
        handle: cusparseHandle_t,
        plan: *mut cusparseSpMMOpPlan_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMOpAlg_t,
        addOperationNvvmBuffer: *const ::core::ffi::c_void,
        addOperationBufferSize: usize,
        mulOperationNvvmBuffer: *const ::core::ffi::c_void,
        mulOperationBufferSize: usize,
        epilogueNvvmBuffer: *const ::core::ffi::c_void,
        epilogueBufferSize: usize,
        SpMMWorkspaceSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMMOp_createPlan)(
            handle,
            plan,
            opA,
            opB,
            matA,
            matB,
            matC,
            computeType,
            alg,
            addOperationNvvmBuffer,
            addOperationBufferSize,
            mulOperationNvvmBuffer,
            mulOperationBufferSize,
            epilogueNvvmBuffer,
            epilogueBufferSize,
            SpMMWorkspaceSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMMOp_destroyPlan(plan: cusparseSpMMOpPlan_t) -> cusparseStatus_t {
        (culib().cusparseSpMMOp_destroyPlan)(plan)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMM_bufferSize)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMM_bufferSize)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMM_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMM_preprocess)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMM_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        beta: *const ::core::ffi::c_void,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMMAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMM_preprocess)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            beta,
            matC,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMV(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMV)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            beta,
            vecY,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMV(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMV)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            beta,
            vecY,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMV_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMV_bufferSize)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            beta,
            vecY,
            computeType,
            alg,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMV_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMV_bufferSize)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            beta,
            vecY,
            computeType,
            alg,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMV_preprocess(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        beta: *const ::core::ffi::c_void,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpMVAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMV_preprocess)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            beta,
            vecY,
            computeType,
            alg,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMatGetAttribute(
        spMatDescr: cusparseSpMatDescr_t,
        attribute: cusparseSpMatAttribute_t,
        data: *mut ::core::ffi::c_void,
        dataSize: usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetAttribute)(spMatDescr, attribute, data, dataSize)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMatGetAttribute(
        spMatDescr: cusparseConstSpMatDescr_t,
        attribute: cusparseSpMatAttribute_t,
        data: *mut ::core::ffi::c_void,
        dataSize: usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetAttribute)(spMatDescr, attribute, data, dataSize)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMatGetFormat(
        spMatDescr: cusparseSpMatDescr_t,
        format: *mut cusparseFormat_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetFormat)(spMatDescr, format)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMatGetFormat(
        spMatDescr: cusparseConstSpMatDescr_t,
        format: *mut cusparseFormat_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetFormat)(spMatDescr, format)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMatGetIndexBase(
        spMatDescr: cusparseSpMatDescr_t,
        idxBase: *mut cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetIndexBase)(spMatDescr, idxBase)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMatGetIndexBase(
        spMatDescr: cusparseConstSpMatDescr_t,
        idxBase: *mut cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetIndexBase)(spMatDescr, idxBase)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMatGetSize(
        spMatDescr: cusparseSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetSize)(spMatDescr, rows, cols, nnz)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMatGetSize(
        spMatDescr: cusparseConstSpMatDescr_t,
        rows: *mut i64,
        cols: *mut i64,
        nnz: *mut i64,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetSize)(spMatDescr, rows, cols, nnz)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMatGetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetStridedBatch)(spMatDescr, batchCount)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpMatGetStridedBatch(
        spMatDescr: cusparseConstSpMatDescr_t,
        batchCount: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetStridedBatch)(spMatDescr, batchCount)
    }
    pub unsafe fn cusparseSpMatGetValues(
        spMatDescr: cusparseSpMatDescr_t,
        values: *mut *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatGetValues)(spMatDescr, values)
    }
    pub unsafe fn cusparseSpMatSetAttribute(
        spMatDescr: cusparseSpMatDescr_t,
        attribute: cusparseSpMatAttribute_t,
        data: *mut ::core::ffi::c_void,
        dataSize: usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatSetAttribute)(spMatDescr, attribute, data, dataSize)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpMatSetStridedBatch(
        spMatDescr: cusparseSpMatDescr_t,
        batchCount: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatSetStridedBatch)(spMatDescr, batchCount)
    }
    pub unsafe fn cusparseSpMatSetValues(
        spMatDescr: cusparseSpMatDescr_t,
        values: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpMatSetValues)(spMatDescr, values)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpSM_analysis(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSM_analysis)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            matC,
            computeType,
            alg,
            spsmDescr,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpSM_analysis(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSM_analysis)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            matC,
            computeType,
            alg,
            spsmDescr,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpSM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSM_bufferSize)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            matC,
            computeType,
            alg,
            spsmDescr,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpSM_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSM_bufferSize)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            matC,
            computeType,
            alg,
            spsmDescr,
            bufferSize,
        )
    }
    pub unsafe fn cusparseSpSM_createDescr(descr: *mut cusparseSpSMDescr_t) -> cusparseStatus_t {
        (culib().cusparseSpSM_createDescr)(descr)
    }
    pub unsafe fn cusparseSpSM_destroyDescr(descr: cusparseSpSMDescr_t) -> cusparseStatus_t {
        (culib().cusparseSpSM_destroyDescr)(descr)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpSM_solve(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSM_solve)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            matC,
            computeType,
            alg,
            spsmDescr,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpSM_solve(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        opB: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseConstDnMatDescr_t,
        matC: cusparseDnMatDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSMAlg_t,
        spsmDescr: cusparseSpSMDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSM_solve)(
            handle,
            opA,
            opB,
            alpha,
            matA,
            matB,
            matC,
            computeType,
            alg,
            spsmDescr,
        )
    }
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpSM_updateMatrix(
        handle: cusparseHandle_t,
        spsmDescr: cusparseSpSMDescr_t,
        newValues: *mut ::core::ffi::c_void,
        updatePart: cusparseSpSMUpdate_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSM_updateMatrix)(handle, spsmDescr, newValues, updatePart)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpSV_analysis(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSV_analysis)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            vecY,
            computeType,
            alg,
            spsvDescr,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpSV_analysis(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSV_analysis)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            vecY,
            computeType,
            alg,
            spsvDescr,
            externalBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpSV_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSV_bufferSize)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            vecY,
            computeType,
            alg,
            spsvDescr,
            bufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpSV_bufferSize(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSV_bufferSize)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            vecY,
            computeType,
            alg,
            spsvDescr,
            bufferSize,
        )
    }
    pub unsafe fn cusparseSpSV_createDescr(descr: *mut cusparseSpSVDescr_t) -> cusparseStatus_t {
        (culib().cusparseSpSV_createDescr)(descr)
    }
    pub unsafe fn cusparseSpSV_destroyDescr(descr: cusparseSpSVDescr_t) -> cusparseStatus_t {
        (culib().cusparseSpSV_destroyDescr)(descr)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpSV_solve(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseSpMatDescr_t,
        vecX: cusparseDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSV_solve)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            vecY,
            computeType,
            alg,
            spsvDescr,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpSV_solve(
        handle: cusparseHandle_t,
        opA: cusparseOperation_t,
        alpha: *const ::core::ffi::c_void,
        matA: cusparseConstSpMatDescr_t,
        vecX: cusparseConstDnVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        computeType: cudaDataType,
        alg: cusparseSpSVAlg_t,
        spsvDescr: cusparseSpSVDescr_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSV_solve)(
            handle,
            opA,
            alpha,
            matA,
            vecX,
            vecY,
            computeType,
            alg,
            spsvDescr,
        )
    }
    #[cfg(any(
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpSV_updateMatrix(
        handle: cusparseHandle_t,
        spsvDescr: cusparseSpSVDescr_t,
        newValues: *mut ::core::ffi::c_void,
        updatePart: cusparseSpSVUpdate_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpSV_updateMatrix)(handle, spsvDescr, newValues, updatePart)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpVV(
        handle: cusparseHandle_t,
        opX: cusparseOperation_t,
        vecX: cusparseSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        result: *mut ::core::ffi::c_void,
        computeType: cudaDataType,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVV)(handle, opX, vecX, vecY, result, computeType, externalBuffer)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpVV(
        handle: cusparseHandle_t,
        opX: cusparseOperation_t,
        vecX: cusparseConstSpVecDescr_t,
        vecY: cusparseConstDnVecDescr_t,
        result: *mut ::core::ffi::c_void,
        computeType: cudaDataType,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVV)(handle, opX, vecX, vecY, result, computeType, externalBuffer)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpVV_bufferSize(
        handle: cusparseHandle_t,
        opX: cusparseOperation_t,
        vecX: cusparseSpVecDescr_t,
        vecY: cusparseDnVecDescr_t,
        result: *const ::core::ffi::c_void,
        computeType: cudaDataType,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVV_bufferSize)(handle, opX, vecX, vecY, result, computeType, bufferSize)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpVV_bufferSize(
        handle: cusparseHandle_t,
        opX: cusparseOperation_t,
        vecX: cusparseConstSpVecDescr_t,
        vecY: cusparseConstDnVecDescr_t,
        result: *const ::core::ffi::c_void,
        computeType: cudaDataType,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVV_bufferSize)(handle, opX, vecX, vecY, result, computeType, bufferSize)
    }
    pub unsafe fn cusparseSpVecGet(
        spVecDescr: cusparseSpVecDescr_t,
        size: *mut i64,
        nnz: *mut i64,
        indices: *mut *mut ::core::ffi::c_void,
        values: *mut *mut ::core::ffi::c_void,
        idxType: *mut cusparseIndexType_t,
        idxBase: *mut cusparseIndexBase_t,
        valueType: *mut cudaDataType,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVecGet)(
            spVecDescr, size, nnz, indices, values, idxType, idxBase, valueType,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSpVecGetIndexBase(
        spVecDescr: cusparseSpVecDescr_t,
        idxBase: *mut cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVecGetIndexBase)(spVecDescr, idxBase)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSpVecGetIndexBase(
        spVecDescr: cusparseConstSpVecDescr_t,
        idxBase: *mut cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVecGetIndexBase)(spVecDescr, idxBase)
    }
    pub unsafe fn cusparseSpVecGetValues(
        spVecDescr: cusparseSpVecDescr_t,
        values: *mut *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVecGetValues)(spVecDescr, values)
    }
    pub unsafe fn cusparseSpVecSetValues(
        spVecDescr: cusparseSpVecDescr_t,
        values: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpVecSetValues)(spVecDescr, values)
    }
    #[cfg(any(feature = "cuda-11040"))]
    pub unsafe fn cusparseSparseToDense(
        handle: cusparseHandle_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        buffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSparseToDense)(handle, matA, matB, alg, buffer)
    }
    #[cfg(any(
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSparseToDense(
        handle: cusparseHandle_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSparseToDense)(handle, matA, matB, alg, externalBuffer)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSparseToDense(
        handle: cusparseHandle_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        externalBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSparseToDense)(handle, matA, matB, alg, externalBuffer)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSparseToDense_bufferSize(
        handle: cusparseHandle_t,
        matA: cusparseSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSparseToDense_bufferSize)(handle, matA, matB, alg, bufferSize)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cusparseSparseToDense_bufferSize(
        handle: cusparseHandle_t,
        matA: cusparseConstSpMatDescr_t,
        matB: cusparseDnMatDescr_t,
        alg: cusparseSparseToDenseAlg_t,
        bufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSparseToDense_bufferSize)(handle, matA, matB, alg, bufferSize)
    }
    pub unsafe fn cusparseSpruneCsr2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneCsr2csr)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            threshold,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSpruneCsr2csrByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneCsr2csrByPercentage)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            percentage,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSpruneCsr2csrByPercentage_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        info: pruneInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneCsr2csrByPercentage_bufferSizeExt)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            percentage,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSpruneCsr2csrNnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneCsr2csrNnz)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            threshold,
            descrC,
            csrSortedRowPtrC,
            nnzTotalDevHostPtr,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSpruneCsr2csrNnzByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneCsr2csrNnzByPercentage)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            percentage,
            descrC,
            csrSortedRowPtrC,
            nnzTotalDevHostPtr,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSpruneCsr2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const f32,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneCsr2csr_bufferSizeExt)(
            handle,
            m,
            n,
            nnzA,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            threshold,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSpruneDense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneDense2csr)(
            handle,
            m,
            n,
            A,
            lda,
            threshold,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSpruneDense2csrByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneDense2csrByPercentage)(
            handle,
            m,
            n,
            A,
            lda,
            percentage,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSpruneDense2csrByPercentage_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        info: pruneInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneDense2csrByPercentage_bufferSizeExt)(
            handle,
            m,
            n,
            A,
            lda,
            percentage,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseSpruneDense2csrNnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneDense2csrNnz)(
            handle,
            m,
            n,
            A,
            lda,
            threshold,
            descrC,
            csrRowPtrC,
            nnzTotalDevHostPtr,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSpruneDense2csrNnzByPercentage(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        percentage: f32,
        descrC: cusparseMatDescr_t,
        csrRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: pruneInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneDense2csrNnzByPercentage)(
            handle,
            m,
            n,
            A,
            lda,
            percentage,
            descrC,
            csrRowPtrC,
            nnzTotalDevHostPtr,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseSpruneDense2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        threshold: *const f32,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const f32,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseSpruneDense2csr_bufferSizeExt)(
            handle,
            m,
            n,
            A,
            lda,
            threshold,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSroti(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *mut f32,
        xInd: *const ::core::ffi::c_int,
        y: *mut f32,
        c: *const f32,
        s: *const f32,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSroti)(handle, nnz, xVal, xInd, y, c, s, idxBase)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseSsctr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *const f32,
        xInd: *const ::core::ffi::c_int,
        y: *mut f32,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseSsctr)(handle, nnz, xVal, xInd, y, idxBase)
    }
    pub unsafe fn cusparseXbsric02_zeroPivot(
        handle: cusparseHandle_t,
        info: bsric02Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXbsric02_zeroPivot)(handle, info, position)
    }
    pub unsafe fn cusparseXbsrilu02_zeroPivot(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXbsrilu02_zeroPivot)(handle, info, position)
    }
    pub unsafe fn cusparseXbsrsm2_zeroPivot(
        handle: cusparseHandle_t,
        info: bsrsm2Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXbsrsm2_zeroPivot)(handle, info, position)
    }
    pub unsafe fn cusparseXbsrsv2_zeroPivot(
        handle: cusparseHandle_t,
        info: bsrsv2Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXbsrsv2_zeroPivot)(handle, info, position)
    }
    pub unsafe fn cusparseXcoo2csr(
        handle: cusparseHandle_t,
        cooRowInd: *const ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        csrSortedRowPtr: *mut ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseXcoo2csr)(handle, cooRowInd, nnz, m, csrSortedRowPtr, idxBase)
    }
    pub unsafe fn cusparseXcoosortByColumn(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        cooRowsA: *mut ::core::ffi::c_int,
        cooColsA: *mut ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseXcoosortByColumn)(handle, m, n, nnz, cooRowsA, cooColsA, P, pBuffer)
    }
    pub unsafe fn cusparseXcoosortByRow(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        cooRowsA: *mut ::core::ffi::c_int,
        cooColsA: *mut ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseXcoosortByRow)(handle, m, n, nnz, cooRowsA, cooColsA, P, pBuffer)
    }
    pub unsafe fn cusparseXcoosort_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        cooRowsA: *const ::core::ffi::c_int,
        cooColsA: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseXcoosort_bufferSizeExt)(
            handle,
            m,
            n,
            nnz,
            cooRowsA,
            cooColsA,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseXcscsort(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscColPtrA: *const ::core::ffi::c_int,
        cscRowIndA: *mut ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseXcscsort)(
            handle, m, n, nnz, descrA, cscColPtrA, cscRowIndA, P, pBuffer,
        )
    }
    pub unsafe fn cusparseXcscsort_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        cscColPtrA: *const ::core::ffi::c_int,
        cscRowIndA: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseXcscsort_bufferSizeExt)(
            handle,
            m,
            n,
            nnz,
            cscColPtrA,
            cscRowIndA,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseXcsr2bsrNnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsr2bsrNnz)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            blockDim,
            descrC,
            bsrSortedRowPtrC,
            nnzTotalDevHostPtr,
        )
    }
    pub unsafe fn cusparseXcsr2coo(
        handle: cusparseHandle_t,
        csrSortedRowPtr: *const ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        cooRowInd: *mut ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsr2coo)(handle, csrSortedRowPtr, nnz, m, cooRowInd, idxBase)
    }
    pub unsafe fn cusparseXcsr2gebsrNnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsr2gebsrNnz)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrC,
            bsrSortedRowPtrC,
            rowBlockDim,
            colBlockDim,
            nnzTotalDevHostPtr,
            pBuffer,
        )
    }
    pub unsafe fn cusparseXcsrgeam2Nnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        workspace: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsrgeam2Nnz)(
            handle,
            m,
            n,
            descrA,
            nnzA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedRowPtrC,
            nnzTotalDevHostPtr,
            workspace,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseXcsrgemm2Nnz(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsrgemm2Nnz)(
            handle,
            m,
            n,
            k,
            descrA,
            nnzA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrD,
            nnzD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            descrC,
            csrSortedRowPtrC,
            nnzTotalDevHostPtr,
            info,
            pBuffer,
        )
    }
    pub unsafe fn cusparseXcsric02_zeroPivot(
        handle: cusparseHandle_t,
        info: csric02Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsric02_zeroPivot)(handle, info, position)
    }
    pub unsafe fn cusparseXcsrilu02_zeroPivot(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsrilu02_zeroPivot)(handle, info, position)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseXcsrsm2_zeroPivot(
        handle: cusparseHandle_t,
        info: csrsm2Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsrsm2_zeroPivot)(handle, info, position)
    }
    pub unsafe fn cusparseXcsrsort(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrRowPtrA: *const ::core::ffi::c_int,
        csrColIndA: *mut ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsrsort)(
            handle, m, n, nnz, descrA, csrRowPtrA, csrColIndA, P, pBuffer,
        )
    }
    pub unsafe fn cusparseXcsrsort_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrRowPtrA: *const ::core::ffi::c_int,
        csrColIndA: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsrsort_bufferSizeExt)(
            handle,
            m,
            n,
            nnz,
            csrRowPtrA,
            csrColIndA,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseXcsrsv2_zeroPivot(
        handle: cusparseHandle_t,
        info: csrsv2Info_t,
        position: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseXcsrsv2_zeroPivot)(handle, info, position)
    }
    pub unsafe fn cusparseXgebsr2gebsrNnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseXgebsr2gebsrNnz)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            descrC,
            bsrSortedRowPtrC,
            rowBlockDimC,
            colBlockDimC,
            nnzTotalDevHostPtr,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZaxpyi(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        xVal: *const cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseZaxpyi)(handle, nnz, alpha, xVal, xInd, y, idxBase)
    }
    pub unsafe fn cusparseZbsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsr2csr)(
            handle,
            dirA,
            mb,
            nb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
        )
    }
    pub unsafe fn cusparseZbsric02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsric02)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZbsric02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        policy: cusparseSolvePolicy_t,
        pInputBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsric02_analysis)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pInputBuffer,
        )
    }
    pub unsafe fn cusparseZbsric02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsric02_bufferSize)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZbsrilu02(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrilu02)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZbsrilu02_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrilu02_analysis)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZbsrilu02_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrilu02_bufferSize)(
            handle,
            dirA,
            mb,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZbsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: bsrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut cuDoubleComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrilu02_numericBoost)(handle, info, enable_boost, tol, boost_val)
    }
    pub unsafe fn cusparseZbsrmm(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrmm)(
            handle,
            dirA,
            transA,
            transB,
            mb,
            n,
            kb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockSize,
            B,
            ldb,
            beta,
            C,
            ldc,
        )
    }
    pub unsafe fn cusparseZbsrmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrmv)(
            handle,
            dirA,
            transA,
            mb,
            nb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            x,
            beta,
            y,
        )
    }
    pub unsafe fn cusparseZbsrsm2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrsm2_analysis)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZbsrsm2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *mut cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrsm2_bufferSize)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZbsrsm2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        transXY: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        blockSize: ::core::ffi::c_int,
        info: bsrsm2Info_t,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        X: *mut cuDoubleComplex,
        ldx: ::core::ffi::c_int,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrsm2_solve)(
            handle,
            dirA,
            transA,
            transXY,
            mb,
            n,
            nnzb,
            alpha,
            descrA,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            blockSize,
            info,
            B,
            ldb,
            X,
            ldx,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZbsrsv2_analysis(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrsv2_analysis)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZbsrsv2_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *mut cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrsv2_bufferSize)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZbsrsv2_solve(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        mb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        info: bsrsv2Info_t,
        f: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrsv2_solve)(
            handle,
            dirA,
            transA,
            mb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            blockDim,
            info,
            f,
            x,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZbsrxmv(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        transA: cusparseOperation_t,
        sizeOfMask: ::core::ffi::c_int,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedMaskPtrA: *const ::core::ffi::c_int,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedEndPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseZbsrxmv)(
            handle,
            dirA,
            transA,
            sizeOfMask,
            mb,
            nb,
            nnzb,
            alpha,
            descrA,
            bsrSortedValA,
            bsrSortedMaskPtrA,
            bsrSortedRowPtrA,
            bsrSortedEndPtrA,
            bsrSortedColIndA,
            blockDim,
            x,
            beta,
            y,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsc2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        cscSortedValA: *const cuDoubleComplex,
        cscSortedRowIndA: *const ::core::ffi::c_int,
        cscSortedColPtrA: *const ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsc2dense)(
            handle,
            m,
            n,
            descrA,
            cscSortedValA,
            cscSortedRowIndA,
            cscSortedColPtrA,
            A,
            lda,
        )
    }
    pub unsafe fn cusparseZcsr2bsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        blockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuDoubleComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsr2bsr)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            blockDim,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
        )
    }
    pub unsafe fn cusparseZcsr2csr_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedColIndA: *const ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzA: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        tol: cuDoubleComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsr2csr_compress)(
            handle,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedColIndA,
            csrSortedRowPtrA,
            nnzA,
            nnzPerRow,
            csrSortedValC,
            csrSortedColIndC,
            csrSortedRowPtrC,
            tol,
        )
    }
    pub unsafe fn cusparseZcsr2csru(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut cuDoubleComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsr2csru)(
            handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsr2dense(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsr2dense)(
            handle,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            A,
            lda,
        )
    }
    pub unsafe fn cusparseZcsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuDoubleComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsr2gebsr)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
            rowBlockDim,
            colBlockDim,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZcsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsr2gebsr_bufferSize)(
            handle,
            dirA,
            m,
            n,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            rowBlockDim,
            colBlockDim,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZcsrcolor(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        fractionToColor: *const f64,
        ncolors: *mut ::core::ffi::c_int,
        coloring: *mut ::core::ffi::c_int,
        reordering: *mut ::core::ffi::c_int,
        info: cusparseColorInfo_t,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrcolor)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            fractionToColor,
            ncolors,
            coloring,
            reordering,
            info,
        )
    }
    pub unsafe fn cusparseZcsrgeam2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuDoubleComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrgeam2)(
            handle,
            m,
            n,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            beta,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZcsrgeam2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuDoubleComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *const cuDoubleComplex,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *const ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrgeam2_bufferSizeExt)(
            handle,
            m,
            n,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            beta,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrgemm2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedValB: *const cuDoubleComplex,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedValD: *const cuDoubleComplex,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedRowPtrC: *const ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrgemm2)(
            handle,
            m,
            n,
            k,
            alpha,
            descrA,
            nnzA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedValB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            beta,
            descrD,
            nnzD,
            csrSortedValD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
            info,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrgemm2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        nnzA: ::core::ffi::c_int,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        descrB: cusparseMatDescr_t,
        nnzB: ::core::ffi::c_int,
        csrSortedRowPtrB: *const ::core::ffi::c_int,
        csrSortedColIndB: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        descrD: cusparseMatDescr_t,
        nnzD: ::core::ffi::c_int,
        csrSortedRowPtrD: *const ::core::ffi::c_int,
        csrSortedColIndD: *const ::core::ffi::c_int,
        info: csrgemm2Info_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrgemm2_bufferSizeExt)(
            handle,
            m,
            n,
            k,
            alpha,
            descrA,
            nnzA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            descrB,
            nnzB,
            csrSortedRowPtrB,
            csrSortedColIndB,
            beta,
            descrD,
            nnzD,
            csrSortedRowPtrD,
            csrSortedColIndD,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZcsric02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsric02)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA_valM,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZcsric02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsric02_analysis)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZcsric02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csric02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsric02_bufferSize)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZcsrilu02(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA_valM: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrilu02)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA_valM,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZcsrilu02_analysis(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrilu02_analysis)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZcsrilu02_bufferSize(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrilu02Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrilu02_bufferSize)(
            handle,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZcsrilu02_numericBoost(
        handle: cusparseHandle_t,
        info: csrilu02Info_t,
        enable_boost: ::core::ffi::c_int,
        tol: *mut f64,
        boost_val: *mut cuDoubleComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrilu02_numericBoost)(handle, info, enable_boost, tol, boost_val)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrsm2_analysis(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrsm2_analysis)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrsm2_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrsm2_bufferSizeExt)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrsm2_solve(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        transA: cusparseOperation_t,
        transB: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: csrsm2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrsm2_solve)(
            handle,
            algo,
            transA,
            transB,
            m,
            nrhs,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            B,
            ldb,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrsv2_analysis(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrsv2_analysis)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            policy,
            pBuffer,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrsv2_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrsv2_bufferSize)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        pBufferSize: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrsv2_bufferSizeExt)(
            handle,
            transA,
            m,
            nnz,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            pBufferSize,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZcsrsv2_solve(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        descrA: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        csrSortedColIndA: *const ::core::ffi::c_int,
        info: csrsv2Info_t,
        f: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        policy: cusparseSolvePolicy_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsrsv2_solve)(
            handle,
            transA,
            m,
            nnz,
            alpha,
            descrA,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
            info,
            f,
            x,
            policy,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZcsru2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        csrVal: *mut cuDoubleComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsru2csr)(
            handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer,
        )
    }
    pub unsafe fn cusparseZcsru2csr_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        csrVal: *mut cuDoubleComplex,
        csrRowPtr: *const ::core::ffi::c_int,
        csrColInd: *mut ::core::ffi::c_int,
        info: csru2csrInfo_t,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZcsru2csr_bufferSizeExt)(
            handle,
            m,
            n,
            nnz,
            csrVal,
            csrRowPtr,
            csrColInd,
            info,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZdense2csc(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        nnzPerCol: *const ::core::ffi::c_int,
        cscSortedValA: *mut cuDoubleComplex,
        cscSortedRowIndA: *mut ::core::ffi::c_int,
        cscSortedColPtrA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZdense2csc)(
            handle,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerCol,
            cscSortedValA,
            cscSortedRowIndA,
            cscSortedColPtrA,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZdense2csr(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        nnzPerRow: *const ::core::ffi::c_int,
        csrSortedValA: *mut cuDoubleComplex,
        csrSortedRowPtrA: *mut ::core::ffi::c_int,
        csrSortedColIndA: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZdense2csr)(
            handle,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerRow,
            csrSortedValA,
            csrSortedRowPtrA,
            csrSortedColIndA,
        )
    }
    pub unsafe fn cusparseZgebsr2csr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        csrSortedValC: *mut cuDoubleComplex,
        csrSortedRowPtrC: *mut ::core::ffi::c_int,
        csrSortedColIndC: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZgebsr2csr)(
            handle,
            dirA,
            mb,
            nb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDim,
            colBlockDim,
            descrC,
            csrSortedValC,
            csrSortedRowPtrC,
            csrSortedColIndC,
        )
    }
    pub unsafe fn cusparseZgebsr2gebsc(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        bscVal: *mut cuDoubleComplex,
        bscRowInd: *mut ::core::ffi::c_int,
        bscColPtr: *mut ::core::ffi::c_int,
        copyValues: cusparseAction_t,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZgebsr2gebsc)(
            handle,
            mb,
            nb,
            nnzb,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            rowBlockDim,
            colBlockDim,
            bscVal,
            bscRowInd,
            bscColPtr,
            copyValues,
            idxBase,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZgebsr2gebsc_bufferSize(
        handle: cusparseHandle_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        bsrSortedVal: *const cuDoubleComplex,
        bsrSortedRowPtr: *const ::core::ffi::c_int,
        bsrSortedColInd: *const ::core::ffi::c_int,
        rowBlockDim: ::core::ffi::c_int,
        colBlockDim: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZgebsr2gebsc_bufferSize)(
            handle,
            mb,
            nb,
            nnzb,
            bsrSortedVal,
            bsrSortedRowPtr,
            bsrSortedColInd,
            rowBlockDim,
            colBlockDim,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZgebsr2gebsr(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        descrC: cusparseMatDescr_t,
        bsrSortedValC: *mut cuDoubleComplex,
        bsrSortedRowPtrC: *mut ::core::ffi::c_int,
        bsrSortedColIndC: *mut ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZgebsr2gebsr)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            descrC,
            bsrSortedValC,
            bsrSortedRowPtrC,
            bsrSortedColIndC,
            rowBlockDimC,
            colBlockDimC,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZgebsr2gebsr_bufferSize(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        mb: ::core::ffi::c_int,
        nb: ::core::ffi::c_int,
        nnzb: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        bsrSortedValA: *const cuDoubleComplex,
        bsrSortedRowPtrA: *const ::core::ffi::c_int,
        bsrSortedColIndA: *const ::core::ffi::c_int,
        rowBlockDimA: ::core::ffi::c_int,
        colBlockDimA: ::core::ffi::c_int,
        rowBlockDimC: ::core::ffi::c_int,
        colBlockDimC: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZgebsr2gebsr_bufferSize)(
            handle,
            dirA,
            mb,
            nb,
            nnzb,
            descrA,
            bsrSortedValA,
            bsrSortedRowPtrA,
            bsrSortedColIndA,
            rowBlockDimA,
            colBlockDimA,
            rowBlockDimC,
            colBlockDimC,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZgemmi(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        cscValB: *const cuDoubleComplex,
        cscColPtrB: *const ::core::ffi::c_int,
        cscRowIndB: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZgemmi)(
            handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc,
        )
    }
    pub unsafe fn cusparseZgemvi(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        xVal: *const cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        idxBase: cusparseIndexBase_t,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZgemvi)(
            handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer,
        )
    }
    pub unsafe fn cusparseZgemvi_bufferSize(
        handle: cusparseHandle_t,
        transA: cusparseOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nnz: ::core::ffi::c_int,
        pBufferSize: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZgemvi_bufferSize)(handle, transA, m, n, nnz, pBufferSize)
    }
    pub unsafe fn cusparseZgpsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *mut cuDoubleComplex,
        dl: *mut cuDoubleComplex,
        d: *mut cuDoubleComplex,
        du: *mut cuDoubleComplex,
        dw: *mut cuDoubleComplex,
        x: *mut cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZgpsvInterleavedBatch)(
            handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBuffer,
        )
    }
    pub unsafe fn cusparseZgpsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        ds: *const cuDoubleComplex,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        dw: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZgpsvInterleavedBatch_bufferSizeExt)(
            handle,
            algo,
            m,
            ds,
            dl,
            d,
            du,
            dw,
            x,
            batchCount,
            pBufferSizeInBytes,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZgthr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        xVal: *mut cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseZgthr)(handle, nnz, y, xVal, xInd, idxBase)
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZgthrz(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        xVal: *mut cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseZgthrz)(handle, nnz, y, xVal, xInd, idxBase)
    }
    pub unsafe fn cusparseZgtsv2(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZgtsv2)(handle, m, n, dl, d, du, B, ldb, pBuffer)
    }
    pub unsafe fn cusparseZgtsv2StridedBatch(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZgtsv2StridedBatch)(
            handle,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            batchStride,
            pBuffer,
        )
    }
    pub unsafe fn cusparseZgtsv2StridedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        batchStride: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZgtsv2StridedBatch_bufferSizeExt)(
            handle,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            batchStride,
            bufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZgtsv2_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZgtsv2_bufferSizeExt)(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes)
    }
    pub unsafe fn cusparseZgtsv2_nopivot(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZgtsv2_nopivot)(handle, m, n, dl, d, du, B, ldb, pBuffer)
    }
    pub unsafe fn cusparseZgtsv2_nopivot_bufferSizeExt(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        bufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZgtsv2_nopivot_bufferSizeExt)(
            handle,
            m,
            n,
            dl,
            d,
            du,
            B,
            ldb,
            bufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZgtsvInterleavedBatch(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *mut cuDoubleComplex,
        d: *mut cuDoubleComplex,
        du: *mut cuDoubleComplex,
        x: *mut cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        pBuffer: *mut ::core::ffi::c_void,
    ) -> cusparseStatus_t {
        (culib().cusparseZgtsvInterleavedBatch)(handle, algo, m, dl, d, du, x, batchCount, pBuffer)
    }
    pub unsafe fn cusparseZgtsvInterleavedBatch_bufferSizeExt(
        handle: cusparseHandle_t,
        algo: ::core::ffi::c_int,
        m: ::core::ffi::c_int,
        dl: *const cuDoubleComplex,
        d: *const cuDoubleComplex,
        du: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        batchCount: ::core::ffi::c_int,
        pBufferSizeInBytes: *mut usize,
    ) -> cusparseStatus_t {
        (culib().cusparseZgtsvInterleavedBatch_bufferSizeExt)(
            handle,
            algo,
            m,
            dl,
            d,
            du,
            x,
            batchCount,
            pBufferSizeInBytes,
        )
    }
    pub unsafe fn cusparseZnnz(
        handle: cusparseHandle_t,
        dirA: cusparseDirection_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        descrA: cusparseMatDescr_t,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        nnzPerRowCol: *mut ::core::ffi::c_int,
        nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
    ) -> cusparseStatus_t {
        (culib().cusparseZnnz)(
            handle,
            dirA,
            m,
            n,
            descrA,
            A,
            lda,
            nnzPerRowCol,
            nnzTotalDevHostPtr,
        )
    }
    pub unsafe fn cusparseZnnz_compress(
        handle: cusparseHandle_t,
        m: ::core::ffi::c_int,
        descr: cusparseMatDescr_t,
        csrSortedValA: *const cuDoubleComplex,
        csrSortedRowPtrA: *const ::core::ffi::c_int,
        nnzPerRow: *mut ::core::ffi::c_int,
        nnzC: *mut ::core::ffi::c_int,
        tol: cuDoubleComplex,
    ) -> cusparseStatus_t {
        (culib().cusparseZnnz_compress)(
            handle,
            m,
            descr,
            csrSortedValA,
            csrSortedRowPtrA,
            nnzPerRow,
            nnzC,
            tol,
        )
    }
    #[cfg(any(
        feature = "cuda-11040",
        feature = "cuda-11050",
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080"
    ))]
    pub unsafe fn cusparseZsctr(
        handle: cusparseHandle_t,
        nnz: ::core::ffi::c_int,
        xVal: *const cuDoubleComplex,
        xInd: *const ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        idxBase: cusparseIndexBase_t,
    ) -> cusparseStatus_t {
        (culib().cusparseZsctr)(handle, nnz, xVal, xInd, y, idxBase)
    }
    pub struct Lib {
        __library: ::libloading::Library,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseAxpby: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            alpha: *const ::core::ffi::c_void,
            vecX: cusparseSpVecDescr_t,
            beta: *const ::core::ffi::c_void,
            vecY: cusparseDnVecDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseAxpby: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            alpha: *const ::core::ffi::c_void,
            vecX: cusparseConstSpVecDescr_t,
            beta: *const ::core::ffi::c_void,
            vecY: cusparseDnVecDescr_t,
        ) -> cusparseStatus_t,
        pub cusparseBlockedEllGet: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            ellBlockSize: *mut i64,
            ellCols: *mut i64,
            ellColInd: *mut *mut ::core::ffi::c_void,
            ellValue: *mut *mut ::core::ffi::c_void,
            ellIdxType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(feature = "cuda-12010"))]
        pub cusparseBsrSetStridedBatch: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            batchCount: ::core::ffi::c_int,
            offsetsBatchStride: i64,
            columnsValuesBatchStride: i64,
            ValuesBatchStride: i64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseBsrSetStridedBatch: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            batchCount: ::core::ffi::c_int,
            offsetsBatchStride: i64,
            columnsBatchStride: i64,
            ValuesBatchStride: i64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCaxpyi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            alpha: *const cuComplex,
            xVal: *const cuComplex,
            xInd: *const ::core::ffi::c_int,
            y: *mut cuComplex,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseCbsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut cuComplex,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCbsric02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCbsric02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            policy: cusparseSolvePolicy_t,
            pInputBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCbsric02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCbsrilu02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCbsrilu02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCbsrilu02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCbsrilu02_numericBoost: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: bsrilu02Info_t,
            enable_boost: ::core::ffi::c_int,
            tol: *mut f64,
            boost_val: *mut cuComplex,
        ) -> cusparseStatus_t,
        pub cusparseCbsrmm: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCbsrmv: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            x: *const cuComplex,
            beta: *const cuComplex,
            y: *mut cuComplex,
        ) -> cusparseStatus_t,
        pub cusparseCbsrsm2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCbsrsm2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCbsrsm2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            X: *mut cuComplex,
            ldx: ::core::ffi::c_int,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCbsrsv2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCbsrsv2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *mut cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCbsrsv2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            f: *const cuComplex,
            x: *mut cuComplex,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCbsrxmv: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            sizeOfMask: ::core::ffi::c_int,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedMaskPtrA: *const ::core::ffi::c_int,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedEndPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            x: *const cuComplex,
            beta: *const cuComplex,
            y: *mut cuComplex,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsc2dense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            cscSortedValA: *const cuComplex,
            cscSortedRowIndA: *const ::core::ffi::c_int,
            cscSortedColPtrA: *const ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCcsr2bsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut cuComplex,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCcsr2csr_compress: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedColIndA: *const ::core::ffi::c_int,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            nnzPerRow: *const ::core::ffi::c_int,
            csrSortedValC: *mut cuComplex,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            tol: cuComplex,
        ) -> cusparseStatus_t,
        pub cusparseCcsr2csru: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrVal: *mut cuComplex,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsr2dense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCcsr2gebsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut cuComplex,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCcsr2gebsr_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCcsrcolor: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            fractionToColor: *const f32,
            ncolors: *mut ::core::ffi::c_int,
            coloring: *mut ::core::ffi::c_int,
            reordering: *mut ::core::ffi::c_int,
            info: cusparseColorInfo_t,
        ) -> cusparseStatus_t,
        pub cusparseCcsrgeam2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            beta: *const cuComplex,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const cuComplex,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut cuComplex,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCcsrgeam2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            beta: *const cuComplex,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const cuComplex,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *const cuComplex,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrgemm2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const cuComplex,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            beta: *const cuComplex,
            descrD: cusparseMatDescr_t,
            nnzD: ::core::ffi::c_int,
            csrSortedValD: *const cuComplex,
            csrSortedRowPtrD: *const ::core::ffi::c_int,
            csrSortedColIndD: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut cuComplex,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            info: csrgemm2Info_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrgemm2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            beta: *const cuComplex,
            descrD: cusparseMatDescr_t,
            nnzD: ::core::ffi::c_int,
            csrSortedRowPtrD: *const ::core::ffi::c_int,
            csrSortedColIndD: *const ::core::ffi::c_int,
            info: csrgemm2Info_t,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseCcsric02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA_valM: *mut cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCcsric02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCcsric02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCcsrilu02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA_valM: *mut cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCcsrilu02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCcsrilu02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCcsrilu02_numericBoost: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: csrilu02Info_t,
            enable_boost: ::core::ffi::c_int,
            tol: *mut f64,
            boost_val: *mut cuComplex,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrsm2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrsm2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrsm2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *mut cuComplex,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrsv2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrsv2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrsv2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            pBufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCcsrsv2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const cuComplex,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            f: *const cuComplex,
            x: *mut cuComplex,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCcsru2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrVal: *mut cuComplex,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCcsru2csr_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            csrVal: *mut cuComplex,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCdense2csc: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            nnzPerCol: *const ::core::ffi::c_int,
            cscSortedValA: *mut cuComplex,
            cscSortedRowIndA: *mut ::core::ffi::c_int,
            cscSortedColPtrA: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCdense2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            nnzPerRow: *const ::core::ffi::c_int,
            csrSortedValA: *mut cuComplex,
            csrSortedRowPtrA: *mut ::core::ffi::c_int,
            csrSortedColIndA: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCgebsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut cuComplex,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCgebsr2gebsc: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            bsrSortedVal: *const cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            bscVal: *mut cuComplex,
            bscRowInd: *mut ::core::ffi::c_int,
            bscColPtr: *mut ::core::ffi::c_int,
            copyValues: cusparseAction_t,
            idxBase: cusparseIndexBase_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCgebsr2gebsc_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            bsrSortedVal: *const cuComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCgebsr2gebsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDimA: ::core::ffi::c_int,
            colBlockDimA: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut cuComplex,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
            rowBlockDimC: ::core::ffi::c_int,
            colBlockDimC: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCgebsr2gebsr_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDimA: ::core::ffi::c_int,
            colBlockDimA: ::core::ffi::c_int,
            rowBlockDimC: ::core::ffi::c_int,
            colBlockDimC: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCgemmi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            cscValB: *const cuComplex,
            cscColPtrB: *const ::core::ffi::c_int,
            cscRowIndB: *const ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCgemvi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            xVal: *const cuComplex,
            xInd: *const ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            idxBase: cusparseIndexBase_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCgemvi_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            pBufferSize: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCgpsvInterleavedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            ds: *mut cuComplex,
            dl: *mut cuComplex,
            d: *mut cuComplex,
            du: *mut cuComplex,
            dw: *mut cuComplex,
            x: *mut cuComplex,
            batchCount: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCgpsvInterleavedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            ds: *const cuComplex,
            dl: *const cuComplex,
            d: *const cuComplex,
            du: *const cuComplex,
            dw: *const cuComplex,
            x: *const cuComplex,
            batchCount: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCgthr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            y: *const cuComplex,
            xVal: *mut cuComplex,
            xInd: *const ::core::ffi::c_int,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCgthrz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            y: *mut cuComplex,
            xVal: *mut cuComplex,
            xInd: *const ::core::ffi::c_int,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseCgtsv2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const cuComplex,
            d: *const cuComplex,
            du: *const cuComplex,
            B: *mut cuComplex,
            ldb: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCgtsv2StridedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            dl: *const cuComplex,
            d: *const cuComplex,
            du: *const cuComplex,
            x: *mut cuComplex,
            batchCount: ::core::ffi::c_int,
            batchStride: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCgtsv2StridedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            dl: *const cuComplex,
            d: *const cuComplex,
            du: *const cuComplex,
            x: *const cuComplex,
            batchCount: ::core::ffi::c_int,
            batchStride: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        pub cusparseCgtsv2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const cuComplex,
            d: *const cuComplex,
            du: *const cuComplex,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseCgtsv2_nopivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const cuComplex,
            d: *const cuComplex,
            du: *const cuComplex,
            B: *mut cuComplex,
            ldb: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCgtsv2_nopivot_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const cuComplex,
            d: *const cuComplex,
            du: *const cuComplex,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseCgtsvInterleavedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            dl: *mut cuComplex,
            d: *mut cuComplex,
            du: *mut cuComplex,
            x: *mut cuComplex,
            batchCount: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCgtsvInterleavedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            dl: *const cuComplex,
            d: *const cuComplex,
            du: *const cuComplex,
            x: *const cuComplex,
            batchCount: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        pub cusparseCnnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            nnzPerRowCol: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCnnz_compress: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            descr: cusparseMatDescr_t,
            csrSortedValA: *const cuComplex,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            nnzPerRow: *mut ::core::ffi::c_int,
            nnzC: *mut ::core::ffi::c_int,
            tol: cuComplex,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstBlockedEllGet: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            ellBlockSize: *mut i64,
            ellCols: *mut i64,
            ellColInd: *mut *const ::core::ffi::c_void,
            ellValue: *mut *const ::core::ffi::c_void,
            ellIdxType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstCooGet: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
            cooRowInd: *mut *const ::core::ffi::c_void,
            cooColInd: *mut *const ::core::ffi::c_void,
            cooValues: *mut *const ::core::ffi::c_void,
            idxType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstCscGet: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
            cscColOffsets: *mut *const ::core::ffi::c_void,
            cscRowInd: *mut *const ::core::ffi::c_void,
            cscValues: *mut *const ::core::ffi::c_void,
            cscColOffsetsType: *mut cusparseIndexType_t,
            cscRowIndType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstCsrGet: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
            csrRowOffsets: *mut *const ::core::ffi::c_void,
            csrColInd: *mut *const ::core::ffi::c_void,
            csrValues: *mut *const ::core::ffi::c_void,
            csrRowOffsetsType: *mut cusparseIndexType_t,
            csrColIndType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstDnMatGet: unsafe extern "C" fn(
            dnMatDescr: cusparseConstDnMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            ld: *mut i64,
            values: *mut *const ::core::ffi::c_void,
            type_: *mut cudaDataType,
            order: *mut cusparseOrder_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstDnMatGetValues: unsafe extern "C" fn(
            dnMatDescr: cusparseConstDnMatDescr_t,
            values: *mut *const ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstDnVecGet: unsafe extern "C" fn(
            dnVecDescr: cusparseConstDnVecDescr_t,
            size: *mut i64,
            values: *mut *const ::core::ffi::c_void,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstDnVecGetValues: unsafe extern "C" fn(
            dnVecDescr: cusparseConstDnVecDescr_t,
            values: *mut *const ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstSpMatGetValues: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            values: *mut *const ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstSpVecGet: unsafe extern "C" fn(
            spVecDescr: cusparseConstSpVecDescr_t,
            size: *mut i64,
            nnz: *mut i64,
            indices: *mut *const ::core::ffi::c_void,
            values: *mut *const ::core::ffi::c_void,
            idxType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseConstSpVecGetValues: unsafe extern "C" fn(
            spVecDescr: cusparseConstSpVecDescr_t,
            values: *mut *const ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseConstrainedGeMM: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseDnMatDescr_t,
            matB: cusparseDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseConstrainedGeMM_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseDnMatDescr_t,
            matB: cusparseDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCooAoSGet: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
            cooInd: *mut *mut ::core::ffi::c_void,
            cooValues: *mut *mut ::core::ffi::c_void,
            idxType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCooGet: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
            cooRowInd: *mut *mut ::core::ffi::c_void,
            cooColInd: *mut *mut ::core::ffi::c_void,
            cooValues: *mut *mut ::core::ffi::c_void,
            idxType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCooSetPointers: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            cooRows: *mut ::core::ffi::c_void,
            cooColumns: *mut ::core::ffi::c_void,
            cooValues: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCooSetStridedBatch: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            batchCount: ::core::ffi::c_int,
            batchStride: i64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCopyMatDescr: unsafe extern "C" fn(
            dest: cusparseMatDescr_t,
            src: cusparseMatDescr_t,
        ) -> cusparseStatus_t,
        pub cusparseCreate: unsafe extern "C" fn(handle: *mut cusparseHandle_t) -> cusparseStatus_t,
        pub cusparseCreateBlockedEll: unsafe extern "C" fn(
            spMatDescr: *mut cusparseSpMatDescr_t,
            rows: i64,
            cols: i64,
            ellBlockSize: i64,
            ellCols: i64,
            ellColInd: *mut ::core::ffi::c_void,
            ellValue: *mut ::core::ffi::c_void,
            ellIdxType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(feature = "cuda-12010"))]
        pub cusparseCreateBsr: unsafe extern "C" fn(
            spMatDescr: *mut cusparseSpMatDescr_t,
            brows: i64,
            bcols: i64,
            bnnz: i64,
            rowBlockDim: i64,
            colBlockDim: i64,
            bsrRowOffsets: *mut ::core::ffi::c_void,
            bsrColInd: *mut ::core::ffi::c_void,
            bsrValues: *mut ::core::ffi::c_void,
            bsrRowOffsetsType: cusparseIndexType_t,
            bsrColIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
            order: cusparseOrder_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateBsr: unsafe extern "C" fn(
            spMatDescr: *mut cusparseSpMatDescr_t,
            brows: i64,
            bcols: i64,
            bnnz: i64,
            rowBlockSize: i64,
            colBlockSize: i64,
            bsrRowOffsets: *mut ::core::ffi::c_void,
            bsrColInd: *mut ::core::ffi::c_void,
            bsrValues: *mut ::core::ffi::c_void,
            bsrRowOffsetsType: cusparseIndexType_t,
            bsrColIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
            order: cusparseOrder_t,
        ) -> cusparseStatus_t,
        pub cusparseCreateBsric02Info:
            unsafe extern "C" fn(info: *mut bsric02Info_t) -> cusparseStatus_t,
        pub cusparseCreateBsrilu02Info:
            unsafe extern "C" fn(info: *mut bsrilu02Info_t) -> cusparseStatus_t,
        pub cusparseCreateBsrsm2Info:
            unsafe extern "C" fn(info: *mut bsrsm2Info_t) -> cusparseStatus_t,
        pub cusparseCreateBsrsv2Info:
            unsafe extern "C" fn(info: *mut bsrsv2Info_t) -> cusparseStatus_t,
        pub cusparseCreateColorInfo:
            unsafe extern "C" fn(info: *mut cusparseColorInfo_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstBlockedEll: unsafe extern "C" fn(
            spMatDescr: *mut cusparseConstSpMatDescr_t,
            rows: i64,
            cols: i64,
            ellBlockSize: i64,
            ellCols: i64,
            ellColInd: *const ::core::ffi::c_void,
            ellValue: *const ::core::ffi::c_void,
            ellIdxType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstBsr: unsafe extern "C" fn(
            spMatDescr: *mut cusparseConstSpMatDescr_t,
            brows: i64,
            bcols: i64,
            bnnz: i64,
            rowBlockDim: i64,
            colBlockDim: i64,
            bsrRowOffsets: *const ::core::ffi::c_void,
            bsrColInd: *const ::core::ffi::c_void,
            bsrValues: *const ::core::ffi::c_void,
            bsrRowOffsetsType: cusparseIndexType_t,
            bsrColIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
            order: cusparseOrder_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstCoo: unsafe extern "C" fn(
            spMatDescr: *mut cusparseConstSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            cooRowInd: *const ::core::ffi::c_void,
            cooColInd: *const ::core::ffi::c_void,
            cooValues: *const ::core::ffi::c_void,
            cooIdxType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstCsc: unsafe extern "C" fn(
            spMatDescr: *mut cusparseConstSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            cscColOffsets: *const ::core::ffi::c_void,
            cscRowInd: *const ::core::ffi::c_void,
            cscValues: *const ::core::ffi::c_void,
            cscColOffsetsType: cusparseIndexType_t,
            cscRowIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstCsr: unsafe extern "C" fn(
            spMatDescr: *mut cusparseConstSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            csrRowOffsets: *const ::core::ffi::c_void,
            csrColInd: *const ::core::ffi::c_void,
            csrValues: *const ::core::ffi::c_void,
            csrRowOffsetsType: cusparseIndexType_t,
            csrColIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstDnMat: unsafe extern "C" fn(
            dnMatDescr: *mut cusparseConstDnMatDescr_t,
            rows: i64,
            cols: i64,
            ld: i64,
            values: *const ::core::ffi::c_void,
            valueType: cudaDataType,
            order: cusparseOrder_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstDnVec: unsafe extern "C" fn(
            dnVecDescr: *mut cusparseConstDnVecDescr_t,
            size: i64,
            values: *const ::core::ffi::c_void,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstSlicedEll: unsafe extern "C" fn(
            spMatDescr: *mut cusparseConstSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            sellValuesSize: i64,
            sliceSize: i64,
            sellSliceOffsets: *const ::core::ffi::c_void,
            sellColInd: *const ::core::ffi::c_void,
            sellValues: *const ::core::ffi::c_void,
            sellSliceOffsetsType: cusparseIndexType_t,
            sellColIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateConstSpVec: unsafe extern "C" fn(
            spVecDescr: *mut cusparseConstSpVecDescr_t,
            size: i64,
            nnz: i64,
            indices: *const ::core::ffi::c_void,
            values: *const ::core::ffi::c_void,
            idxType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCreateCoo: unsafe extern "C" fn(
            spMatDescr: *mut cusparseSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            cooRowInd: *mut ::core::ffi::c_void,
            cooColInd: *mut ::core::ffi::c_void,
            cooValues: *mut ::core::ffi::c_void,
            cooIdxType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCreateCooAoS: unsafe extern "C" fn(
            spMatDescr: *mut cusparseSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            cooInd: *mut ::core::ffi::c_void,
            cooValues: *mut ::core::ffi::c_void,
            cooIdxType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCreateCsc: unsafe extern "C" fn(
            spMatDescr: *mut cusparseSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            cscColOffsets: *mut ::core::ffi::c_void,
            cscRowInd: *mut ::core::ffi::c_void,
            cscValues: *mut ::core::ffi::c_void,
            cscColOffsetsType: cusparseIndexType_t,
            cscRowIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCreateCsr: unsafe extern "C" fn(
            spMatDescr: *mut cusparseSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            csrRowOffsets: *mut ::core::ffi::c_void,
            csrColInd: *mut ::core::ffi::c_void,
            csrValues: *mut ::core::ffi::c_void,
            csrRowOffsetsType: cusparseIndexType_t,
            csrColIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCreateCsrgemm2Info:
            unsafe extern "C" fn(info: *mut csrgemm2Info_t) -> cusparseStatus_t,
        pub cusparseCreateCsric02Info:
            unsafe extern "C" fn(info: *mut csric02Info_t) -> cusparseStatus_t,
        pub cusparseCreateCsrilu02Info:
            unsafe extern "C" fn(info: *mut csrilu02Info_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCreateCsrsm2Info:
            unsafe extern "C" fn(info: *mut csrsm2Info_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCreateCsrsv2Info:
            unsafe extern "C" fn(info: *mut csrsv2Info_t) -> cusparseStatus_t,
        pub cusparseCreateCsru2csrInfo:
            unsafe extern "C" fn(info: *mut csru2csrInfo_t) -> cusparseStatus_t,
        pub cusparseCreateDnMat: unsafe extern "C" fn(
            dnMatDescr: *mut cusparseDnMatDescr_t,
            rows: i64,
            cols: i64,
            ld: i64,
            values: *mut ::core::ffi::c_void,
            valueType: cudaDataType,
            order: cusparseOrder_t,
        ) -> cusparseStatus_t,
        pub cusparseCreateDnVec: unsafe extern "C" fn(
            dnVecDescr: *mut cusparseDnVecDescr_t,
            size: i64,
            values: *mut ::core::ffi::c_void,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCreateIdentityPermutation: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            n: ::core::ffi::c_int,
            p: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseCreateMatDescr:
            unsafe extern "C" fn(descrA: *mut cusparseMatDescr_t) -> cusparseStatus_t,
        pub cusparseCreatePruneInfo:
            unsafe extern "C" fn(info: *mut pruneInfo_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCreateSlicedEll: unsafe extern "C" fn(
            spMatDescr: *mut cusparseSpMatDescr_t,
            rows: i64,
            cols: i64,
            nnz: i64,
            sellValuesSize: i64,
            sliceSize: i64,
            sellSliceOffsets: *mut ::core::ffi::c_void,
            sellColInd: *mut ::core::ffi::c_void,
            sellValues: *mut ::core::ffi::c_void,
            sellSliceOffsetsType: cusparseIndexType_t,
            sellColIndType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCreateSpVec: unsafe extern "C" fn(
            spVecDescr: *mut cusparseSpVecDescr_t,
            size: i64,
            nnz: i64,
            indices: *mut ::core::ffi::c_void,
            values: *mut ::core::ffi::c_void,
            idxType: cusparseIndexType_t,
            idxBase: cusparseIndexBase_t,
            valueType: cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseCscGet: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
            cscColOffsets: *mut *mut ::core::ffi::c_void,
            cscRowInd: *mut *mut ::core::ffi::c_void,
            cscValues: *mut *mut ::core::ffi::c_void,
            cscColOffsetsType: *mut cusparseIndexType_t,
            cscRowIndType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCscSetPointers: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            cscColOffsets: *mut ::core::ffi::c_void,
            cscRowInd: *mut ::core::ffi::c_void,
            cscValues: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCsctr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            xVal: *const cuComplex,
            xInd: *const ::core::ffi::c_int,
            y: *mut cuComplex,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseCsr2cscEx2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            csrVal: *const ::core::ffi::c_void,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *const ::core::ffi::c_int,
            cscVal: *mut ::core::ffi::c_void,
            cscColPtr: *mut ::core::ffi::c_int,
            cscRowInd: *mut ::core::ffi::c_int,
            valType: cudaDataType,
            copyValues: cusparseAction_t,
            idxBase: cusparseIndexBase_t,
            alg: cusparseCsr2CscAlg_t,
            buffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCsr2cscEx2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            csrVal: *const ::core::ffi::c_void,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *const ::core::ffi::c_int,
            cscVal: *mut ::core::ffi::c_void,
            cscColPtr: *mut ::core::ffi::c_int,
            cscRowInd: *mut ::core::ffi::c_int,
            valType: cudaDataType,
            copyValues: cusparseAction_t,
            idxBase: cusparseIndexBase_t,
            alg: cusparseCsr2CscAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseCsrGet: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
            csrRowOffsets: *mut *mut ::core::ffi::c_void,
            csrColInd: *mut *mut ::core::ffi::c_void,
            csrValues: *mut *mut ::core::ffi::c_void,
            csrRowOffsetsType: *mut cusparseIndexType_t,
            csrColIndType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseCsrSetPointers: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            csrRowOffsets: *mut ::core::ffi::c_void,
            csrColInd: *mut ::core::ffi::c_void,
            csrValues: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseCsrSetStridedBatch: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            batchCount: ::core::ffi::c_int,
            offsetsBatchStride: i64,
            columnsValuesBatchStride: i64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCsrmvEx: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            alg: cusparseAlgMode_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            alphatype: cudaDataType,
            descrA: cusparseMatDescr_t,
            csrValA: *const ::core::ffi::c_void,
            csrValAtype: cudaDataType,
            csrRowPtrA: *const ::core::ffi::c_int,
            csrColIndA: *const ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xtype: cudaDataType,
            beta: *const ::core::ffi::c_void,
            betatype: cudaDataType,
            y: *mut ::core::ffi::c_void,
            ytype: cudaDataType,
            executiontype: cudaDataType,
            buffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseCsrmvEx_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            alg: cusparseAlgMode_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            alphatype: cudaDataType,
            descrA: cusparseMatDescr_t,
            csrValA: *const ::core::ffi::c_void,
            csrValAtype: cudaDataType,
            csrRowPtrA: *const ::core::ffi::c_int,
            csrColIndA: *const ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xtype: cudaDataType,
            beta: *const ::core::ffi::c_void,
            betatype: cudaDataType,
            y: *mut ::core::ffi::c_void,
            ytype: cudaDataType,
            executiontype: cudaDataType,
            bufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDaxpyi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            alpha: *const f64,
            xVal: *const f64,
            xInd: *const ::core::ffi::c_int,
            y: *mut f64,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseDbsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f64,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDbsric02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDbsric02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            policy: cusparseSolvePolicy_t,
            pInputBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDbsric02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDbsrilu02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDbsrilu02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDbsrilu02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDbsrilu02_numericBoost: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: bsrilu02Info_t,
            enable_boost: ::core::ffi::c_int,
            tol: *mut f64,
            boost_val: *mut f64,
        ) -> cusparseStatus_t,
        pub cusparseDbsrmm: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDbsrmv: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            x: *const f64,
            beta: *const f64,
            y: *mut f64,
        ) -> cusparseStatus_t,
        pub cusparseDbsrsm2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDbsrsm2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDbsrsm2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            X: *mut f64,
            ldx: ::core::ffi::c_int,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDbsrsv2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDbsrsv2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *mut f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDbsrsv2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            f: *const f64,
            x: *mut f64,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDbsrxmv: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            sizeOfMask: ::core::ffi::c_int,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedMaskPtrA: *const ::core::ffi::c_int,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedEndPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            x: *const f64,
            beta: *const f64,
            y: *mut f64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsc2dense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            cscSortedValA: *const f64,
            cscSortedRowIndA: *const ::core::ffi::c_int,
            cscSortedColPtrA: *const ::core::ffi::c_int,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDcsr2bsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut f64,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDcsr2csr_compress: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedColIndA: *const ::core::ffi::c_int,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            nnzPerRow: *const ::core::ffi::c_int,
            csrSortedValC: *mut f64,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            tol: f64,
        ) -> cusparseStatus_t,
        pub cusparseDcsr2csru: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrVal: *mut f64,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsr2dense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDcsr2gebsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut f64,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDcsr2gebsr_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDcsrcolor: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            fractionToColor: *const f64,
            ncolors: *mut ::core::ffi::c_int,
            coloring: *mut ::core::ffi::c_int,
            reordering: *mut ::core::ffi::c_int,
            info: cusparseColorInfo_t,
        ) -> cusparseStatus_t,
        pub cusparseDcsrgeam2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            beta: *const f64,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const f64,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f64,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDcsrgeam2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            beta: *const f64,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const f64,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *const f64,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrgemm2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const f64,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            beta: *const f64,
            descrD: cusparseMatDescr_t,
            nnzD: ::core::ffi::c_int,
            csrSortedValD: *const f64,
            csrSortedRowPtrD: *const ::core::ffi::c_int,
            csrSortedColIndD: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f64,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            info: csrgemm2Info_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrgemm2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            beta: *const f64,
            descrD: cusparseMatDescr_t,
            nnzD: ::core::ffi::c_int,
            csrSortedRowPtrD: *const ::core::ffi::c_int,
            csrSortedColIndD: *const ::core::ffi::c_int,
            info: csrgemm2Info_t,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseDcsric02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA_valM: *mut f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDcsric02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDcsric02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDcsrilu02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA_valM: *mut f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDcsrilu02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDcsrilu02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDcsrilu02_numericBoost: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: csrilu02Info_t,
            enable_boost: ::core::ffi::c_int,
            tol: *mut f64,
            boost_val: *mut f64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrsm2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrsm2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrsm2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *mut f64,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrsv2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrsv2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrsv2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            pBufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDcsrsv2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f64,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            f: *const f64,
            x: *mut f64,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDcsru2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrVal: *mut f64,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDcsru2csr_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            csrVal: *mut f64,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDdense2csc: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const f64,
            lda: ::core::ffi::c_int,
            nnzPerCol: *const ::core::ffi::c_int,
            cscSortedValA: *mut f64,
            cscSortedRowIndA: *mut ::core::ffi::c_int,
            cscSortedColPtrA: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDdense2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const f64,
            lda: ::core::ffi::c_int,
            nnzPerRow: *const ::core::ffi::c_int,
            csrSortedValA: *mut f64,
            csrSortedRowPtrA: *mut ::core::ffi::c_int,
            csrSortedColIndA: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(feature = "cuda-11040"))]
        pub cusparseDenseToSparse_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseDnMatDescr_t,
            matB: cusparseSpMatDescr_t,
            alg: cusparseDenseToSparseAlg_t,
            buffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDenseToSparse_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseDnMatDescr_t,
            matB: cusparseSpMatDescr_t,
            alg: cusparseDenseToSparseAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseDenseToSparse_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseConstDnMatDescr_t,
            matB: cusparseSpMatDescr_t,
            alg: cusparseDenseToSparseAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDenseToSparse_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseDnMatDescr_t,
            matB: cusparseSpMatDescr_t,
            alg: cusparseDenseToSparseAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseDenseToSparse_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseConstDnMatDescr_t,
            matB: cusparseSpMatDescr_t,
            alg: cusparseDenseToSparseAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(feature = "cuda-11040"))]
        pub cusparseDenseToSparse_convert: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseDnMatDescr_t,
            matB: cusparseSpMatDescr_t,
            alg: cusparseDenseToSparseAlg_t,
            buffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDenseToSparse_convert: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseDnMatDescr_t,
            matB: cusparseSpMatDescr_t,
            alg: cusparseDenseToSparseAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseDenseToSparse_convert: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseConstDnMatDescr_t,
            matB: cusparseSpMatDescr_t,
            alg: cusparseDenseToSparseAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDestroy: unsafe extern "C" fn(handle: cusparseHandle_t) -> cusparseStatus_t,
        pub cusparseDestroyBsric02Info:
            unsafe extern "C" fn(info: bsric02Info_t) -> cusparseStatus_t,
        pub cusparseDestroyBsrilu02Info:
            unsafe extern "C" fn(info: bsrilu02Info_t) -> cusparseStatus_t,
        pub cusparseDestroyBsrsm2Info: unsafe extern "C" fn(info: bsrsm2Info_t) -> cusparseStatus_t,
        pub cusparseDestroyBsrsv2Info: unsafe extern "C" fn(info: bsrsv2Info_t) -> cusparseStatus_t,
        pub cusparseDestroyColorInfo:
            unsafe extern "C" fn(info: cusparseColorInfo_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDestroyCsrgemm2Info:
            unsafe extern "C" fn(info: csrgemm2Info_t) -> cusparseStatus_t,
        pub cusparseDestroyCsric02Info:
            unsafe extern "C" fn(info: csric02Info_t) -> cusparseStatus_t,
        pub cusparseDestroyCsrilu02Info:
            unsafe extern "C" fn(info: csrilu02Info_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDestroyCsrsm2Info: unsafe extern "C" fn(info: csrsm2Info_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDestroyCsrsv2Info: unsafe extern "C" fn(info: csrsv2Info_t) -> cusparseStatus_t,
        pub cusparseDestroyCsru2csrInfo:
            unsafe extern "C" fn(info: csru2csrInfo_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDestroyDnMat:
            unsafe extern "C" fn(dnMatDescr: cusparseDnMatDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseDestroyDnMat:
            unsafe extern "C" fn(dnMatDescr: cusparseConstDnMatDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDestroyDnVec:
            unsafe extern "C" fn(dnVecDescr: cusparseDnVecDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseDestroyDnVec:
            unsafe extern "C" fn(dnVecDescr: cusparseConstDnVecDescr_t) -> cusparseStatus_t,
        pub cusparseDestroyMatDescr:
            unsafe extern "C" fn(descrA: cusparseMatDescr_t) -> cusparseStatus_t,
        pub cusparseDestroyPruneInfo: unsafe extern "C" fn(info: pruneInfo_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDestroySpMat:
            unsafe extern "C" fn(spMatDescr: cusparseSpMatDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseDestroySpMat:
            unsafe extern "C" fn(spMatDescr: cusparseConstSpMatDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDestroySpVec:
            unsafe extern "C" fn(spVecDescr: cusparseSpVecDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseDestroySpVec:
            unsafe extern "C" fn(spVecDescr: cusparseConstSpVecDescr_t) -> cusparseStatus_t,
        pub cusparseDgebsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f64,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDgebsr2gebsc: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            bsrSortedVal: *const f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            bscVal: *mut f64,
            bscRowInd: *mut ::core::ffi::c_int,
            bscColPtr: *mut ::core::ffi::c_int,
            copyValues: cusparseAction_t,
            idxBase: cusparseIndexBase_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDgebsr2gebsc_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            bsrSortedVal: *const f64,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDgebsr2gebsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDimA: ::core::ffi::c_int,
            colBlockDimA: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut f64,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
            rowBlockDimC: ::core::ffi::c_int,
            colBlockDimC: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDgebsr2gebsr_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f64,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDimA: ::core::ffi::c_int,
            colBlockDimA: ::core::ffi::c_int,
            rowBlockDimC: ::core::ffi::c_int,
            colBlockDimC: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDgemmi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            cscValB: *const f64,
            cscColPtrB: *const ::core::ffi::c_int,
            cscRowIndB: *const ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDgemvi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            xVal: *const f64,
            xInd: *const ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            idxBase: cusparseIndexBase_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDgemvi_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            pBufferSize: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDgpsvInterleavedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            ds: *mut f64,
            dl: *mut f64,
            d: *mut f64,
            du: *mut f64,
            dw: *mut f64,
            x: *mut f64,
            batchCount: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDgpsvInterleavedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            ds: *const f64,
            dl: *const f64,
            d: *const f64,
            du: *const f64,
            dw: *const f64,
            x: *const f64,
            batchCount: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDgthr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            y: *const f64,
            xVal: *mut f64,
            xInd: *const ::core::ffi::c_int,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDgthrz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            y: *mut f64,
            xVal: *mut f64,
            xInd: *const ::core::ffi::c_int,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseDgtsv2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const f64,
            d: *const f64,
            du: *const f64,
            B: *mut f64,
            ldb: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDgtsv2StridedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            dl: *const f64,
            d: *const f64,
            du: *const f64,
            x: *mut f64,
            batchCount: ::core::ffi::c_int,
            batchStride: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDgtsv2StridedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            dl: *const f64,
            d: *const f64,
            du: *const f64,
            x: *const f64,
            batchCount: ::core::ffi::c_int,
            batchStride: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        pub cusparseDgtsv2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const f64,
            d: *const f64,
            du: *const f64,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseDgtsv2_nopivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const f64,
            d: *const f64,
            du: *const f64,
            B: *mut f64,
            ldb: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDgtsv2_nopivot_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const f64,
            d: *const f64,
            du: *const f64,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseDgtsvInterleavedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            dl: *mut f64,
            d: *mut f64,
            du: *mut f64,
            x: *mut f64,
            batchCount: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDgtsvInterleavedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            dl: *const f64,
            d: *const f64,
            du: *const f64,
            x: *const f64,
            batchCount: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        pub cusparseDnMatGet: unsafe extern "C" fn(
            dnMatDescr: cusparseDnMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            ld: *mut i64,
            values: *mut *mut ::core::ffi::c_void,
            type_: *mut cudaDataType,
            order: *mut cusparseOrder_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDnMatGetStridedBatch: unsafe extern "C" fn(
            dnMatDescr: cusparseDnMatDescr_t,
            batchCount: *mut ::core::ffi::c_int,
            batchStride: *mut i64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseDnMatGetStridedBatch: unsafe extern "C" fn(
            dnMatDescr: cusparseConstDnMatDescr_t,
            batchCount: *mut ::core::ffi::c_int,
            batchStride: *mut i64,
        ) -> cusparseStatus_t,
        pub cusparseDnMatGetValues: unsafe extern "C" fn(
            dnMatDescr: cusparseDnMatDescr_t,
            values: *mut *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDnMatSetStridedBatch: unsafe extern "C" fn(
            dnMatDescr: cusparseDnMatDescr_t,
            batchCount: ::core::ffi::c_int,
            batchStride: i64,
        ) -> cusparseStatus_t,
        pub cusparseDnMatSetValues: unsafe extern "C" fn(
            dnMatDescr: cusparseDnMatDescr_t,
            values: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDnVecGet: unsafe extern "C" fn(
            dnVecDescr: cusparseDnVecDescr_t,
            size: *mut i64,
            values: *mut *mut ::core::ffi::c_void,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        pub cusparseDnVecGetValues: unsafe extern "C" fn(
            dnVecDescr: cusparseDnVecDescr_t,
            values: *mut *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDnVecSetValues: unsafe extern "C" fn(
            dnVecDescr: cusparseDnVecDescr_t,
            values: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDnnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const f64,
            lda: ::core::ffi::c_int,
            nnzPerRowCol: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseDnnz_compress: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            descr: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            nnzPerRow: *mut ::core::ffi::c_int,
            nnzC: *mut ::core::ffi::c_int,
            tol: f64,
        ) -> cusparseStatus_t,
        pub cusparseDpruneCsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            threshold: *const f64,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f64,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDpruneCsr2csrByPercentage: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            percentage: f32,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f64,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            info: pruneInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDpruneCsr2csrByPercentage_bufferSizeExt:
            unsafe extern "C" fn(
                handle: cusparseHandle_t,
                m: ::core::ffi::c_int,
                n: ::core::ffi::c_int,
                nnzA: ::core::ffi::c_int,
                descrA: cusparseMatDescr_t,
                csrSortedValA: *const f64,
                csrSortedRowPtrA: *const ::core::ffi::c_int,
                csrSortedColIndA: *const ::core::ffi::c_int,
                percentage: f32,
                descrC: cusparseMatDescr_t,
                csrSortedValC: *const f64,
                csrSortedRowPtrC: *const ::core::ffi::c_int,
                csrSortedColIndC: *const ::core::ffi::c_int,
                info: pruneInfo_t,
                pBufferSizeInBytes: *mut usize,
            ) -> cusparseStatus_t,
        pub cusparseDpruneCsr2csrNnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            threshold: *const f64,
            descrC: cusparseMatDescr_t,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDpruneCsr2csrNnzByPercentage: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            percentage: f32,
            descrC: cusparseMatDescr_t,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            info: pruneInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDpruneCsr2csr_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f64,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            threshold: *const f64,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *const f64,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseDpruneDense2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            threshold: *const f64,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f64,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDpruneDense2csrByPercentage: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            percentage: f32,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f64,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            info: pruneInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDpruneDense2csrByPercentage_bufferSizeExt:
            unsafe extern "C" fn(
                handle: cusparseHandle_t,
                m: ::core::ffi::c_int,
                n: ::core::ffi::c_int,
                A: *const f64,
                lda: ::core::ffi::c_int,
                percentage: f32,
                descrC: cusparseMatDescr_t,
                csrSortedValC: *const f64,
                csrSortedRowPtrC: *const ::core::ffi::c_int,
                csrSortedColIndC: *const ::core::ffi::c_int,
                info: pruneInfo_t,
                pBufferSizeInBytes: *mut usize,
            ) -> cusparseStatus_t,
        pub cusparseDpruneDense2csrNnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            threshold: *const f64,
            descrC: cusparseMatDescr_t,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseDpruneDense2csrNnzByPercentage: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            percentage: f32,
            descrC: cusparseMatDescr_t,
            csrRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            info: pruneInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        )
            -> cusparseStatus_t,
        pub cusparseDpruneDense2csr_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            threshold: *const f64,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *const f64,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDroti: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            xVal: *mut f64,
            xInd: *const ::core::ffi::c_int,
            y: *mut f64,
            c: *const f64,
            s: *const f64,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseDsctr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            xVal: *const f64,
            xInd: *const ::core::ffi::c_int,
            y: *mut f64,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseGather: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            vecY: cusparseDnVecDescr_t,
            vecX: cusparseSpVecDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseGather: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            vecY: cusparseConstDnVecDescr_t,
            vecX: cusparseSpVecDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000"
        ))]
        pub cusparseGetColorAlgs: unsafe extern "C" fn(
            info: cusparseColorInfo_t,
            alg: *mut cusparseColorAlg_t,
        ) -> cusparseStatus_t,
        pub cusparseGetErrorName:
            unsafe extern "C" fn(status: cusparseStatus_t) -> *const ::core::ffi::c_char,
        pub cusparseGetErrorString:
            unsafe extern "C" fn(status: cusparseStatus_t) -> *const ::core::ffi::c_char,
        pub cusparseGetMatDiagType:
            unsafe extern "C" fn(descrA: cusparseMatDescr_t) -> cusparseDiagType_t,
        pub cusparseGetMatFillMode:
            unsafe extern "C" fn(descrA: cusparseMatDescr_t) -> cusparseFillMode_t,
        pub cusparseGetMatIndexBase:
            unsafe extern "C" fn(descrA: cusparseMatDescr_t) -> cusparseIndexBase_t,
        pub cusparseGetMatType:
            unsafe extern "C" fn(descrA: cusparseMatDescr_t) -> cusparseMatrixType_t,
        pub cusparseGetPointerMode: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            mode: *mut cusparsePointerMode_t,
        ) -> cusparseStatus_t,
        pub cusparseGetProperty: unsafe extern "C" fn(
            type_: libraryPropertyType,
            value: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseGetStream: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            streamId: *mut cudaStream_t,
        ) -> cusparseStatus_t,
        pub cusparseGetVersion: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            version: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseLoggerForceDisable: unsafe extern "C" fn() -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseLoggerOpenFile:
            unsafe extern "C" fn(logFile: *const ::core::ffi::c_char) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseLoggerSetCallback:
            unsafe extern "C" fn(callback: cusparseLoggerCallback_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseLoggerSetFile: unsafe extern "C" fn(file: *mut FILE) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseLoggerSetLevel:
            unsafe extern "C" fn(level: ::core::ffi::c_int) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseLoggerSetMask:
            unsafe extern "C" fn(mask: ::core::ffi::c_int) -> cusparseStatus_t,
        pub cusparseRot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            c_coeff: *const ::core::ffi::c_void,
            s_coeff: *const ::core::ffi::c_void,
            vecX: cusparseSpVecDescr_t,
            vecY: cusparseDnVecDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSDDMM: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseDnMatDescr_t,
            matB: cusparseDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSDDMMAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSDDMM: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstDnMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSDDMMAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSDDMM_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseDnMatDescr_t,
            matB: cusparseDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSDDMMAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSDDMM_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstDnMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSDDMMAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSDDMM_preprocess: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseDnMatDescr_t,
            matB: cusparseDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSDDMMAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSDDMM_preprocess: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstDnMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSDDMMAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSaxpyi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            alpha: *const f32,
            xVal: *const f32,
            xInd: *const ::core::ffi::c_int,
            y: *mut f32,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseSbsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f32,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSbsric02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSbsric02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            policy: cusparseSolvePolicy_t,
            pInputBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSbsric02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSbsrilu02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSbsrilu02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSbsrilu02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSbsrilu02_numericBoost: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: bsrilu02Info_t,
            enable_boost: ::core::ffi::c_int,
            tol: *mut f64,
            boost_val: *mut f32,
        ) -> cusparseStatus_t,
        pub cusparseSbsrmm: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSbsrmv: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            x: *const f32,
            beta: *const f32,
            y: *mut f32,
        ) -> cusparseStatus_t,
        pub cusparseSbsrsm2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSbsrsm2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSbsrsm2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            X: *mut f32,
            ldx: ::core::ffi::c_int,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSbsrsv2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSbsrsv2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *mut f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSbsrsv2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            f: *const f32,
            x: *mut f32,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSbsrxmv: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            sizeOfMask: ::core::ffi::c_int,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedMaskPtrA: *const ::core::ffi::c_int,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedEndPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            x: *const f32,
            beta: *const f32,
            y: *mut f32,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScatter: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            vecX: cusparseSpVecDescr_t,
            vecY: cusparseDnVecDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseScatter: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            vecX: cusparseConstSpVecDescr_t,
            vecY: cusparseDnVecDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsc2dense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            cscSortedValA: *const f32,
            cscSortedRowIndA: *const ::core::ffi::c_int,
            cscSortedColPtrA: *const ::core::ffi::c_int,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseScsr2bsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut f32,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseScsr2csr_compress: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedColIndA: *const ::core::ffi::c_int,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            nnzPerRow: *const ::core::ffi::c_int,
            csrSortedValC: *mut f32,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            tol: f32,
        ) -> cusparseStatus_t,
        pub cusparseScsr2csru: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrVal: *mut f32,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsr2dense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseScsr2gebsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut f32,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseScsr2gebsr_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseScsrcolor: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            fractionToColor: *const f32,
            ncolors: *mut ::core::ffi::c_int,
            coloring: *mut ::core::ffi::c_int,
            reordering: *mut ::core::ffi::c_int,
            info: cusparseColorInfo_t,
        ) -> cusparseStatus_t,
        pub cusparseScsrgeam2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            beta: *const f32,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const f32,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f32,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseScsrgeam2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            beta: *const f32,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const f32,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *const f32,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrgemm2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedValB: *const f32,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            beta: *const f32,
            descrD: cusparseMatDescr_t,
            nnzD: ::core::ffi::c_int,
            csrSortedValD: *const f32,
            csrSortedRowPtrD: *const ::core::ffi::c_int,
            csrSortedColIndD: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f32,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            info: csrgemm2Info_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrgemm2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            beta: *const f32,
            descrD: cusparseMatDescr_t,
            nnzD: ::core::ffi::c_int,
            csrSortedRowPtrD: *const ::core::ffi::c_int,
            csrSortedColIndD: *const ::core::ffi::c_int,
            info: csrgemm2Info_t,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseScsric02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA_valM: *mut f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseScsric02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseScsric02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csric02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseScsrilu02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA_valM: *mut f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseScsrilu02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseScsrilu02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrilu02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseScsrilu02_numericBoost: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: csrilu02Info_t,
            enable_boost: ::core::ffi::c_int,
            tol: *mut f64,
            boost_val: *mut f32,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrsm2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrsm2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrsm2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            B: *mut f32,
            ldb: ::core::ffi::c_int,
            info: csrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrsv2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrsv2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrsv2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *mut f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            pBufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseScsrsv2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f32,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            info: csrsv2Info_t,
            f: *const f32,
            x: *mut f32,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseScsru2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrVal: *mut f32,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseScsru2csr_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            csrVal: *mut f32,
            csrRowPtr: *const ::core::ffi::c_int,
            csrColInd: *mut ::core::ffi::c_int,
            info: csru2csrInfo_t,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSdense2csc: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const f32,
            lda: ::core::ffi::c_int,
            nnzPerCol: *const ::core::ffi::c_int,
            cscSortedValA: *mut f32,
            cscSortedRowIndA: *mut ::core::ffi::c_int,
            cscSortedColPtrA: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSdense2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const f32,
            lda: ::core::ffi::c_int,
            nnzPerRow: *const ::core::ffi::c_int,
            csrSortedValA: *mut f32,
            csrSortedRowPtrA: *mut ::core::ffi::c_int,
            csrSortedColIndA: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000"
        ))]
        pub cusparseSetColorAlgs: unsafe extern "C" fn(
            info: cusparseColorInfo_t,
            alg: cusparseColorAlg_t,
        ) -> cusparseStatus_t,
        pub cusparseSetMatDiagType: unsafe extern "C" fn(
            descrA: cusparseMatDescr_t,
            diagType: cusparseDiagType_t,
        ) -> cusparseStatus_t,
        pub cusparseSetMatFillMode: unsafe extern "C" fn(
            descrA: cusparseMatDescr_t,
            fillMode: cusparseFillMode_t,
        ) -> cusparseStatus_t,
        pub cusparseSetMatIndexBase: unsafe extern "C" fn(
            descrA: cusparseMatDescr_t,
            base: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseSetMatType: unsafe extern "C" fn(
            descrA: cusparseMatDescr_t,
            type_: cusparseMatrixType_t,
        ) -> cusparseStatus_t,
        pub cusparseSetPointerMode: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            mode: cusparsePointerMode_t,
        ) -> cusparseStatus_t,
        pub cusparseSetStream: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            streamId: cudaStream_t,
        ) -> cusparseStatus_t,
        pub cusparseSgebsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f32,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSgebsr2gebsc: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            bsrSortedVal: *const f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            bscVal: *mut f32,
            bscRowInd: *mut ::core::ffi::c_int,
            bscColPtr: *mut ::core::ffi::c_int,
            copyValues: cusparseAction_t,
            idxBase: cusparseIndexBase_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSgebsr2gebsc_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            bsrSortedVal: *const f32,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSgebsr2gebsr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDimA: ::core::ffi::c_int,
            colBlockDimA: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedValC: *mut f32,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            bsrSortedColIndC: *mut ::core::ffi::c_int,
            rowBlockDimC: ::core::ffi::c_int,
            colBlockDimC: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSgebsr2gebsr_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const f32,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDimA: ::core::ffi::c_int,
            colBlockDimA: ::core::ffi::c_int,
            rowBlockDimC: ::core::ffi::c_int,
            colBlockDimC: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSgemmi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            cscValB: *const f32,
            cscColPtrB: *const ::core::ffi::c_int,
            cscRowIndB: *const ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSgemvi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            xVal: *const f32,
            xInd: *const ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            idxBase: cusparseIndexBase_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSgemvi_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            transA: cusparseOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            pBufferSize: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSgpsvInterleavedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            ds: *mut f32,
            dl: *mut f32,
            d: *mut f32,
            du: *mut f32,
            dw: *mut f32,
            x: *mut f32,
            batchCount: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSgpsvInterleavedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            ds: *const f32,
            dl: *const f32,
            d: *const f32,
            du: *const f32,
            dw: *const f32,
            x: *const f32,
            batchCount: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSgthr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            y: *const f32,
            xVal: *mut f32,
            xInd: *const ::core::ffi::c_int,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSgthrz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            y: *mut f32,
            xVal: *mut f32,
            xInd: *const ::core::ffi::c_int,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseSgtsv2: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const f32,
            d: *const f32,
            du: *const f32,
            B: *mut f32,
            ldb: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSgtsv2StridedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            dl: *const f32,
            d: *const f32,
            du: *const f32,
            x: *mut f32,
            batchCount: ::core::ffi::c_int,
            batchStride: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSgtsv2StridedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            dl: *const f32,
            d: *const f32,
            du: *const f32,
            x: *const f32,
            batchCount: ::core::ffi::c_int,
            batchStride: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        pub cusparseSgtsv2_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const f32,
            d: *const f32,
            du: *const f32,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseSgtsv2_nopivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const f32,
            d: *const f32,
            du: *const f32,
            B: *mut f32,
            ldb: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSgtsv2_nopivot_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            dl: *const f32,
            d: *const f32,
            du: *const f32,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            bufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseSgtsvInterleavedBatch: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            dl: *mut f32,
            d: *mut f32,
            du: *mut f32,
            x: *mut f32,
            batchCount: ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSgtsvInterleavedBatch_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            algo: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            dl: *const f32,
            d: *const f32,
            du: *const f32,
            x: *const f32,
            batchCount: ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        pub cusparseSnnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            A: *const f32,
            lda: ::core::ffi::c_int,
            nnzPerRowCol: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSnnz_compress: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            descr: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            nnzPerRow: *mut ::core::ffi::c_int,
            nnzC: *mut ::core::ffi::c_int,
            tol: f32,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpGEMM_compute: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize2: *mut usize,
            externalBuffer2: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMM_compute: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize2: *mut usize,
            externalBuffer2: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpGEMM_copy: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMM_copy: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
        ) -> cusparseStatus_t,
        pub cusparseSpGEMM_createDescr:
            unsafe extern "C" fn(descr: *mut cusparseSpGEMMDescr_t) -> cusparseStatus_t,
        pub cusparseSpGEMM_destroyDescr:
            unsafe extern "C" fn(descr: cusparseSpGEMMDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMM_estimateMemory: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            chunk_fraction: f32,
            bufferSize3: *mut usize,
            externalBuffer3: *mut ::core::ffi::c_void,
            bufferSize2: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMM_getNumProducts: unsafe extern "C" fn(
            spgemmDescr: cusparseSpGEMMDescr_t,
            num_prods: *mut i64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpGEMM_workEstimation: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize1: *mut usize,
            externalBuffer1: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMM_workEstimation: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize1: *mut usize,
            externalBuffer1: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpGEMMreuse_compute: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMMreuse_compute: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstSpMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseSpMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpGEMMreuse_copy: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            matA: cusparseSpMatDescr_t,
            matB: cusparseSpMatDescr_t,
            matC: cusparseSpMatDescr_t,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize5: *mut usize,
            externalBuffer5: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMMreuse_copy: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstSpMatDescr_t,
            matC: cusparseSpMatDescr_t,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize5: *mut usize,
            externalBuffer5: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpGEMMreuse_nnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            matA: cusparseSpMatDescr_t,
            matB: cusparseSpMatDescr_t,
            matC: cusparseSpMatDescr_t,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize2: *mut usize,
            externalBuffer2: *mut ::core::ffi::c_void,
            bufferSize3: *mut usize,
            externalBuffer3: *mut ::core::ffi::c_void,
            bufferSize4: *mut usize,
            externalBuffer4: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMMreuse_nnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstSpMatDescr_t,
            matC: cusparseSpMatDescr_t,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize2: *mut usize,
            externalBuffer2: *mut ::core::ffi::c_void,
            bufferSize3: *mut usize,
            externalBuffer3: *mut ::core::ffi::c_void,
            bufferSize4: *mut usize,
            externalBuffer4: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpGEMMreuse_workEstimation: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            matA: cusparseSpMatDescr_t,
            matB: cusparseSpMatDescr_t,
            matC: cusparseSpMatDescr_t,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize1: *mut usize,
            externalBuffer1: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpGEMMreuse_workEstimation: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstSpMatDescr_t,
            matC: cusparseSpMatDescr_t,
            alg: cusparseSpGEMMAlg_t,
            spgemmDescr: cusparseSpGEMMDescr_t,
            bufferSize1: *mut usize,
            externalBuffer1: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMM: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMMAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMM: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMMAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMMOp: unsafe extern "C" fn(
            plan: cusparseSpMMOpPlan_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMMOp_createPlan: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            plan: *mut cusparseSpMMOpPlan_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMMOpAlg_t,
            addOperationNvvmBuffer: *const ::core::ffi::c_void,
            addOperationBufferSize: usize,
            mulOperationNvvmBuffer: *const ::core::ffi::c_void,
            mulOperationBufferSize: usize,
            epilogueNvvmBuffer: *const ::core::ffi::c_void,
            epilogueBufferSize: usize,
            SpMMWorkspaceSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMMOp_createPlan: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            plan: *mut cusparseSpMMOpPlan_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMMOpAlg_t,
            addOperationNvvmBuffer: *const ::core::ffi::c_void,
            addOperationBufferSize: usize,
            mulOperationNvvmBuffer: *const ::core::ffi::c_void,
            mulOperationBufferSize: usize,
            epilogueNvvmBuffer: *const ::core::ffi::c_void,
            epilogueBufferSize: usize,
            SpMMWorkspaceSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMMOp_destroyPlan:
            unsafe extern "C" fn(plan: cusparseSpMMOpPlan_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMM_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMMAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMM_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMMAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMM_preprocess: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMMAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMM_preprocess: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            beta: *const ::core::ffi::c_void,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMMAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMV: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            vecX: cusparseDnVecDescr_t,
            beta: *const ::core::ffi::c_void,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMVAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMV: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            vecX: cusparseConstDnVecDescr_t,
            beta: *const ::core::ffi::c_void,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMVAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMV_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            vecX: cusparseDnVecDescr_t,
            beta: *const ::core::ffi::c_void,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMVAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMV_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            vecX: cusparseConstDnVecDescr_t,
            beta: *const ::core::ffi::c_void,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMVAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMV_preprocess: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            vecX: cusparseConstDnVecDescr_t,
            beta: *const ::core::ffi::c_void,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpMVAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMatGetAttribute: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            attribute: cusparseSpMatAttribute_t,
            data: *mut ::core::ffi::c_void,
            dataSize: usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMatGetAttribute: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            attribute: cusparseSpMatAttribute_t,
            data: *mut ::core::ffi::c_void,
            dataSize: usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMatGetFormat: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            format: *mut cusparseFormat_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMatGetFormat: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            format: *mut cusparseFormat_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMatGetIndexBase: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            idxBase: *mut cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMatGetIndexBase: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            idxBase: *mut cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMatGetSize: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMatGetSize: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            rows: *mut i64,
            cols: *mut i64,
            nnz: *mut i64,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMatGetStridedBatch: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            batchCount: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpMatGetStridedBatch: unsafe extern "C" fn(
            spMatDescr: cusparseConstSpMatDescr_t,
            batchCount: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSpMatGetValues: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            values: *mut *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpMatSetAttribute: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            attribute: cusparseSpMatAttribute_t,
            data: *mut ::core::ffi::c_void,
            dataSize: usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpMatSetStridedBatch: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            batchCount: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseSpMatSetValues: unsafe extern "C" fn(
            spMatDescr: cusparseSpMatDescr_t,
            values: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpSM_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSMAlg_t,
            spsmDescr: cusparseSpSMDescr_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpSM_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSMAlg_t,
            spsmDescr: cusparseSpSMDescr_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpSM_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSMAlg_t,
            spsmDescr: cusparseSpSMDescr_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpSM_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSMAlg_t,
            spsmDescr: cusparseSpSMDescr_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseSpSM_createDescr:
            unsafe extern "C" fn(descr: *mut cusparseSpSMDescr_t) -> cusparseStatus_t,
        pub cusparseSpSM_destroyDescr:
            unsafe extern "C" fn(descr: cusparseSpSMDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpSM_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSMAlg_t,
            spsmDescr: cusparseSpSMDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpSM_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            opB: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseConstDnMatDescr_t,
            matC: cusparseDnMatDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSMAlg_t,
            spsmDescr: cusparseSpSMDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpSM_updateMatrix: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            spsmDescr: cusparseSpSMDescr_t,
            newValues: *mut ::core::ffi::c_void,
            updatePart: cusparseSpSMUpdate_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpSV_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            vecX: cusparseDnVecDescr_t,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSVAlg_t,
            spsvDescr: cusparseSpSVDescr_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpSV_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            vecX: cusparseConstDnVecDescr_t,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSVAlg_t,
            spsvDescr: cusparseSpSVDescr_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpSV_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            vecX: cusparseDnVecDescr_t,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSVAlg_t,
            spsvDescr: cusparseSpSVDescr_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpSV_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            vecX: cusparseConstDnVecDescr_t,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSVAlg_t,
            spsvDescr: cusparseSpSVDescr_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseSpSV_createDescr:
            unsafe extern "C" fn(descr: *mut cusparseSpSVDescr_t) -> cusparseStatus_t,
        pub cusparseSpSV_destroyDescr:
            unsafe extern "C" fn(descr: cusparseSpSVDescr_t) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpSV_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseSpMatDescr_t,
            vecX: cusparseDnVecDescr_t,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSVAlg_t,
            spsvDescr: cusparseSpSVDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpSV_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opA: cusparseOperation_t,
            alpha: *const ::core::ffi::c_void,
            matA: cusparseConstSpMatDescr_t,
            vecX: cusparseConstDnVecDescr_t,
            vecY: cusparseDnVecDescr_t,
            computeType: cudaDataType,
            alg: cusparseSpSVAlg_t,
            spsvDescr: cusparseSpSVDescr_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpSV_updateMatrix: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            spsvDescr: cusparseSpSVDescr_t,
            newValues: *mut ::core::ffi::c_void,
            updatePart: cusparseSpSVUpdate_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpVV: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opX: cusparseOperation_t,
            vecX: cusparseSpVecDescr_t,
            vecY: cusparseDnVecDescr_t,
            result: *mut ::core::ffi::c_void,
            computeType: cudaDataType,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpVV: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opX: cusparseOperation_t,
            vecX: cusparseConstSpVecDescr_t,
            vecY: cusparseConstDnVecDescr_t,
            result: *mut ::core::ffi::c_void,
            computeType: cudaDataType,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpVV_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opX: cusparseOperation_t,
            vecX: cusparseSpVecDescr_t,
            vecY: cusparseDnVecDescr_t,
            result: *const ::core::ffi::c_void,
            computeType: cudaDataType,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpVV_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            opX: cusparseOperation_t,
            vecX: cusparseConstSpVecDescr_t,
            vecY: cusparseConstDnVecDescr_t,
            result: *const ::core::ffi::c_void,
            computeType: cudaDataType,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseSpVecGet: unsafe extern "C" fn(
            spVecDescr: cusparseSpVecDescr_t,
            size: *mut i64,
            nnz: *mut i64,
            indices: *mut *mut ::core::ffi::c_void,
            values: *mut *mut ::core::ffi::c_void,
            idxType: *mut cusparseIndexType_t,
            idxBase: *mut cusparseIndexBase_t,
            valueType: *mut cudaDataType,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSpVecGetIndexBase: unsafe extern "C" fn(
            spVecDescr: cusparseSpVecDescr_t,
            idxBase: *mut cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSpVecGetIndexBase: unsafe extern "C" fn(
            spVecDescr: cusparseConstSpVecDescr_t,
            idxBase: *mut cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseSpVecGetValues: unsafe extern "C" fn(
            spVecDescr: cusparseSpVecDescr_t,
            values: *mut *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpVecSetValues: unsafe extern "C" fn(
            spVecDescr: cusparseSpVecDescr_t,
            values: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(feature = "cuda-11040"))]
        pub cusparseSparseToDense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            alg: cusparseSparseToDenseAlg_t,
            buffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSparseToDense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            alg: cusparseSparseToDenseAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSparseToDense: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            alg: cusparseSparseToDenseAlg_t,
            externalBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSparseToDense_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            alg: cusparseSparseToDenseAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cusparseSparseToDense_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            matA: cusparseConstSpMatDescr_t,
            matB: cusparseDnMatDescr_t,
            alg: cusparseSparseToDenseAlg_t,
            bufferSize: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseSpruneCsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            threshold: *const f32,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f32,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpruneCsr2csrByPercentage: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            percentage: f32,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f32,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            info: pruneInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpruneCsr2csrByPercentage_bufferSizeExt:
            unsafe extern "C" fn(
                handle: cusparseHandle_t,
                m: ::core::ffi::c_int,
                n: ::core::ffi::c_int,
                nnzA: ::core::ffi::c_int,
                descrA: cusparseMatDescr_t,
                csrSortedValA: *const f32,
                csrSortedRowPtrA: *const ::core::ffi::c_int,
                csrSortedColIndA: *const ::core::ffi::c_int,
                percentage: f32,
                descrC: cusparseMatDescr_t,
                csrSortedValC: *const f32,
                csrSortedRowPtrC: *const ::core::ffi::c_int,
                csrSortedColIndC: *const ::core::ffi::c_int,
                info: pruneInfo_t,
                pBufferSizeInBytes: *mut usize,
            ) -> cusparseStatus_t,
        pub cusparseSpruneCsr2csrNnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            threshold: *const f32,
            descrC: cusparseMatDescr_t,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpruneCsr2csrNnzByPercentage: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            percentage: f32,
            descrC: cusparseMatDescr_t,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            info: pruneInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpruneCsr2csr_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzA: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedValA: *const f32,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            threshold: *const f32,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *const f32,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseSpruneDense2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            threshold: *const f32,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f32,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpruneDense2csrByPercentage: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            percentage: f32,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut f32,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
            info: pruneInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpruneDense2csrByPercentage_bufferSizeExt:
            unsafe extern "C" fn(
                handle: cusparseHandle_t,
                m: ::core::ffi::c_int,
                n: ::core::ffi::c_int,
                A: *const f32,
                lda: ::core::ffi::c_int,
                percentage: f32,
                descrC: cusparseMatDescr_t,
                csrSortedValC: *const f32,
                csrSortedRowPtrC: *const ::core::ffi::c_int,
                csrSortedColIndC: *const ::core::ffi::c_int,
                info: pruneInfo_t,
                pBufferSizeInBytes: *mut usize,
            ) -> cusparseStatus_t,
        pub cusparseSpruneDense2csrNnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            threshold: *const f32,
            descrC: cusparseMatDescr_t,
            csrRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseSpruneDense2csrNnzByPercentage: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            percentage: f32,
            descrC: cusparseMatDescr_t,
            csrRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            info: pruneInfo_t,
            pBuffer: *mut ::core::ffi::c_void,
        )
            -> cusparseStatus_t,
        pub cusparseSpruneDense2csr_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            threshold: *const f32,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *const f32,
            csrSortedRowPtrC: *const ::core::ffi::c_int,
            csrSortedColIndC: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        )
            -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSroti: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            xVal: *mut f32,
            xInd: *const ::core::ffi::c_int,
            y: *mut f32,
            c: *const f32,
            s: *const f32,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseSsctr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            xVal: *const f32,
            xInd: *const ::core::ffi::c_int,
            y: *mut f32,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseXbsric02_zeroPivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: bsric02Info_t,
            position: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseXbsrilu02_zeroPivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: bsrilu02Info_t,
            position: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseXbsrsm2_zeroPivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: bsrsm2Info_t,
            position: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseXbsrsv2_zeroPivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: bsrsv2Info_t,
            position: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseXcoo2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            cooRowInd: *const ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            csrSortedRowPtr: *mut ::core::ffi::c_int,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseXcoosortByColumn: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            cooRowsA: *mut ::core::ffi::c_int,
            cooColsA: *mut ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseXcoosortByRow: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            cooRowsA: *mut ::core::ffi::c_int,
            cooColsA: *mut ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseXcoosort_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            cooRowsA: *const ::core::ffi::c_int,
            cooColsA: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseXcscsort: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            cscColPtrA: *const ::core::ffi::c_int,
            cscRowIndA: *mut ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseXcscsort_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            cscColPtrA: *const ::core::ffi::c_int,
            cscRowIndA: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        pub cusparseXcsr2bsrNnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseXcsr2coo: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            csrSortedRowPtr: *const ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            m: ::core::ffi::c_int,
            cooRowInd: *mut ::core::ffi::c_int,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseXcsr2gebsrNnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            rowBlockDim: ::core::ffi::c_int,
            colBlockDim: ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseXcsrgeam2Nnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            workspace: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseXcsrgemm2Nnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            nnzA: ::core::ffi::c_int,
            csrSortedRowPtrA: *const ::core::ffi::c_int,
            csrSortedColIndA: *const ::core::ffi::c_int,
            descrB: cusparseMatDescr_t,
            nnzB: ::core::ffi::c_int,
            csrSortedRowPtrB: *const ::core::ffi::c_int,
            csrSortedColIndB: *const ::core::ffi::c_int,
            descrD: cusparseMatDescr_t,
            nnzD: ::core::ffi::c_int,
            csrSortedRowPtrD: *const ::core::ffi::c_int,
            csrSortedColIndD: *const ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            info: csrgemm2Info_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseXcsric02_zeroPivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: csric02Info_t,
            position: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseXcsrilu02_zeroPivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: csrilu02Info_t,
            position: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseXcsrsm2_zeroPivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: csrsm2Info_t,
            position: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseXcsrsort: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            csrRowPtrA: *const ::core::ffi::c_int,
            csrColIndA: *mut ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseXcsrsort_bufferSizeExt: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnz: ::core::ffi::c_int,
            csrRowPtrA: *const ::core::ffi::c_int,
            csrColIndA: *const ::core::ffi::c_int,
            pBufferSizeInBytes: *mut usize,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseXcsrsv2_zeroPivot: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: csrsv2Info_t,
            position: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseXgebsr2gebsrNnz: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            rowBlockDimA: ::core::ffi::c_int,
            colBlockDimA: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            bsrSortedRowPtrC: *mut ::core::ffi::c_int,
            rowBlockDimC: ::core::ffi::c_int,
            colBlockDimC: ::core::ffi::c_int,
            nnzTotalDevHostPtr: *mut ::core::ffi::c_int,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        #[cfg(any(
            feature = "cuda-11040",
            feature = "cuda-11050",
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080"
        ))]
        pub cusparseZaxpyi: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            nnz: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            xVal: *const cuDoubleComplex,
            xInd: *const ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            idxBase: cusparseIndexBase_t,
        ) -> cusparseStatus_t,
        pub cusparseZbsr2csr: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuDoubleComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            descrC: cusparseMatDescr_t,
            csrSortedValC: *mut cuDoubleComplex,
            csrSortedRowPtrC: *mut ::core::ffi::c_int,
            csrSortedColIndC: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseZbsric02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseZbsric02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            policy: cusparseSolvePolicy_t,
            pInputBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseZbsric02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsric02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseZbsrilu02: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseZbsrilu02_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseZbsrilu02_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrilu02Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseZbsrilu02_numericBoost: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            info: bsrilu02Info_t,
            enable_boost: ::core::ffi::c_int,
            tol: *mut f64,
            boost_val: *mut cuDoubleComplex,
        ) -> cusparseStatus_t,
        pub cusparseZbsrmm: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transB: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuDoubleComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseZbsrmv: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuDoubleComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
        ) -> cusparseStatus_t,
        pub cusparseZbsrsm2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseZbsrsm2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *mut cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseZbsrsm2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            transXY: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedVal: *const cuDoubleComplex,
            bsrSortedRowPtr: *const ::core::ffi::c_int,
            bsrSortedColInd: *const ::core::ffi::c_int,
            blockSize: ::core::ffi::c_int,
            info: bsrsm2Info_t,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            X: *mut cuDoubleComplex,
            ldx: ::core::ffi::c_int,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseZbsrsv2_analysis: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuDoubleComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseZbsrsv2_bufferSize: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *mut cuDoubleComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            pBufferSizeInBytes: *mut ::core::ffi::c_int,
        ) -> cusparseStatus_t,
        pub cusparseZbsrsv2_solve: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            mb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            descrA: cusparseMatDescr_t,
            bsrSortedValA: *const cuDoubleComplex,
            bsrSortedRowPtrA: *const ::core::ffi::c_int,
            bsrSortedColIndA: *const ::core::ffi::c_int,
            blockDim: ::core::ffi::c_int,
            info: bsrsv2Info_t,
            f: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            policy: cusparseSolvePolicy_t,
            pBuffer: *mut ::core::ffi::c_void,
        ) -> cusparseStatus_t,
        pub cusparseZbsrxmv: unsafe extern "C" fn(
            handle: cusparseHandle_t,
            dirA: cusparseDirection_t,
            transA: cusparseOperation_t,
            sizeOfMask: ::core::ffi::c_int,
            mb: ::core::ffi::c_int,
            nb: ::core::ffi::c_int,
            nnzb: ::core::ffi::c_int,
            alpha: *cons