#![cfg_attr(feature = "no-std", no_std)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(dead_code)]
#[cfg(feature = "no-std")]
extern crate alloc;
#[cfg(feature = "no-std")]
extern crate no_std_compat as std;
pub use self::libraryPropertyType_t as libraryPropertyType;
pub type cudaGraph_t = *mut CUgraph_st;
pub type cudaStream_t = *mut CUstream_st;
pub type cudnnActivationDescriptor_t = *mut cudnnActivationStruct;
pub type cudnnAttnDescriptor_t = *mut cudnnAttnStruct;
pub type cudnnBackendDescriptor_t = *mut ::core::ffi::c_void;
pub type cudnnCTCLossDescriptor_t = *mut cudnnCTCLossStruct;
pub type cudnnCallback_t = ::core::option::Option<
    unsafe extern "C" fn(
        sev: cudnnSeverity_t,
        udata: *mut ::core::ffi::c_void,
        dbg: *const cudnnDebug_t,
        msg: *const ::core::ffi::c_char,
    ),
>;
pub type cudnnConvolutionBwdDataAlgoPerf_t = cudnnConvolutionBwdDataAlgoPerfStruct;
pub type cudnnConvolutionBwdFilterAlgoPerf_t = cudnnConvolutionBwdFilterAlgoPerfStruct;
pub type cudnnConvolutionDescriptor_t = *mut cudnnConvolutionStruct;
pub type cudnnConvolutionFwdAlgoPerf_t = cudnnConvolutionFwdAlgoPerfStruct;
pub type cudnnDebug_t = cudnnDebugStruct;
pub type cudnnDropoutDescriptor_t = *mut cudnnDropoutStruct;
pub type cudnnFilterDescriptor_t = *mut cudnnFilterStruct;
pub type cudnnFraction_t = cudnnFractionStruct;
pub type cudnnFusedOpsConstParamPack_t = *mut cudnnFusedOpsConstParamStruct;
pub type cudnnFusedOpsPlan_t = *mut cudnnFusedOpsPlanStruct;
pub type cudnnFusedOpsVariantParamPack_t = *mut cudnnFusedOpsVariantParamStruct;
pub type cudnnHandle_t = *mut cudnnContext;
pub type cudnnLRNDescriptor_t = *mut cudnnLRNStruct;
pub type cudnnOpTensorDescriptor_t = *mut cudnnOpTensorStruct;
pub type cudnnPoolingDescriptor_t = *mut cudnnPoolingStruct;
pub type cudnnRNNDataDescriptor_t = *mut cudnnRNNDataStruct;
pub type cudnnRNNDescriptor_t = *mut cudnnRNNStruct;
pub type cudnnReduceTensorDescriptor_t = *mut cudnnReduceTensorStruct;
pub type cudnnSeqDataDescriptor_t = *mut cudnnSeqDataStruct;
pub type cudnnSpatialTransformerDescriptor_t = *mut cudnnSpatialTransformerStruct;
pub type cudnnTensorDescriptor_t = *mut cudnnTensorStruct;
pub type cudnnTensorTransformDescriptor_t = *mut cudnnTensorTransformStruct;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnActivationMode_t {
    CUDNN_ACTIVATION_SIGMOID = 0,
    CUDNN_ACTIVATION_RELU = 1,
    CUDNN_ACTIVATION_TANH = 2,
    CUDNN_ACTIVATION_CLIPPED_RELU = 3,
    CUDNN_ACTIVATION_ELU = 4,
    CUDNN_ACTIVATION_IDENTITY = 5,
    CUDNN_ACTIVATION_SWISH = 6,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendAttributeName_t {
    CUDNN_ATTR_POINTWISE_MODE = 0,
    CUDNN_ATTR_POINTWISE_MATH_PREC = 1,
    CUDNN_ATTR_POINTWISE_NAN_PROPAGATION = 2,
    CUDNN_ATTR_POINTWISE_RELU_LOWER_CLIP = 3,
    CUDNN_ATTR_POINTWISE_RELU_UPPER_CLIP = 4,
    CUDNN_ATTR_POINTWISE_RELU_LOWER_CLIP_SLOPE = 5,
    CUDNN_ATTR_POINTWISE_ELU_ALPHA = 6,
    CUDNN_ATTR_POINTWISE_SOFTPLUS_BETA = 7,
    CUDNN_ATTR_POINTWISE_SWISH_BETA = 8,
    CUDNN_ATTR_POINTWISE_AXIS = 9,
    CUDNN_ATTR_CONVOLUTION_COMP_TYPE = 100,
    CUDNN_ATTR_CONVOLUTION_CONV_MODE = 101,
    CUDNN_ATTR_CONVOLUTION_DILATIONS = 102,
    CUDNN_ATTR_CONVOLUTION_FILTER_STRIDES = 103,
    CUDNN_ATTR_CONVOLUTION_POST_PADDINGS = 104,
    CUDNN_ATTR_CONVOLUTION_PRE_PADDINGS = 105,
    CUDNN_ATTR_CONVOLUTION_SPATIAL_DIMS = 106,
    CUDNN_ATTR_ENGINEHEUR_MODE = 200,
    CUDNN_ATTR_ENGINEHEUR_OPERATION_GRAPH = 201,
    CUDNN_ATTR_ENGINEHEUR_RESULTS = 202,
    CUDNN_ATTR_ENGINEHEUR_SM_COUNT_TARGET = 203,
    CUDNN_ATTR_ENGINEHEUR_DEVICEPROP = 204,
    CUDNN_ATTR_ENGINECFG_ENGINE = 300,
    CUDNN_ATTR_ENGINECFG_INTERMEDIATE_INFO = 301,
    CUDNN_ATTR_ENGINECFG_KNOB_CHOICES = 302,
    CUDNN_ATTR_ENGINECFG_WORKSPACE_SIZE = 303,
    CUDNN_ATTR_ENGINECFG_SHARED_MEMORY_USED = 304,
    CUDNN_ATTR_EXECUTION_PLAN_HANDLE = 400,
    CUDNN_ATTR_EXECUTION_PLAN_ENGINE_CONFIG = 401,
    CUDNN_ATTR_EXECUTION_PLAN_WORKSPACE_SIZE = 402,
    CUDNN_ATTR_EXECUTION_PLAN_COMPUTED_INTERMEDIATE_UIDS = 403,
    CUDNN_ATTR_EXECUTION_PLAN_RUN_ONLY_INTERMEDIATE_UIDS = 404,
    CUDNN_ATTR_EXECUTION_PLAN_JSON_REPRESENTATION = 405,
    CUDNN_ATTR_EXECUTION_PLAN_KERNEL_CACHE = 406,
    CUDNN_ATTR_EXECUTION_PLAN_DEVICEPROP = 407,
    CUDNN_ATTR_INTERMEDIATE_INFO_UNIQUE_ID = 500,
    CUDNN_ATTR_INTERMEDIATE_INFO_SIZE = 501,
    CUDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_DATA_UIDS = 502,
    CUDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_ATTRIBUTES = 503,
    CUDNN_ATTR_KNOB_CHOICE_KNOB_TYPE = 600,
    CUDNN_ATTR_KNOB_CHOICE_KNOB_VALUE = 601,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_ALPHA = 700,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_BETA = 701,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_CONV_DESC = 702,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_W = 703,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_X = 704,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_Y = 705,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_ALPHA = 706,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_BETA = 707,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_CONV_DESC = 708,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_W = 709,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_DX = 710,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_DY = 711,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_ALPHA = 712,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_BETA = 713,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_CONV_DESC = 714,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_DW = 715,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_X = 716,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_DY = 717,
    CUDNN_ATTR_OPERATION_POINTWISE_PW_DESCRIPTOR = 750,
    CUDNN_ATTR_OPERATION_POINTWISE_XDESC = 751,
    CUDNN_ATTR_OPERATION_POINTWISE_BDESC = 752,
    CUDNN_ATTR_OPERATION_POINTWISE_YDESC = 753,
    CUDNN_ATTR_OPERATION_POINTWISE_ALPHA1 = 754,
    CUDNN_ATTR_OPERATION_POINTWISE_ALPHA2 = 755,
    CUDNN_ATTR_OPERATION_POINTWISE_DXDESC = 756,
    CUDNN_ATTR_OPERATION_POINTWISE_DYDESC = 757,
    CUDNN_ATTR_OPERATION_POINTWISE_TDESC = 758,
    CUDNN_ATTR_OPERATION_GENSTATS_MODE = 770,
    CUDNN_ATTR_OPERATION_GENSTATS_MATH_PREC = 771,
    CUDNN_ATTR_OPERATION_GENSTATS_XDESC = 772,
    CUDNN_ATTR_OPERATION_GENSTATS_SUMDESC = 773,
    CUDNN_ATTR_OPERATION_GENSTATS_SQSUMDESC = 774,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_STATS_MODE = 780,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_MATH_PREC = 781,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_Y_SUM_DESC = 782,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_Y_SQ_SUM_DESC = 783,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SCALE_DESC = 784,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_BIAS_DESC = 785,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_PREV_RUNNING_MEAN_DESC = 786,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_PREV_RUNNING_VAR_DESC = 787,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_UPDATED_RUNNING_MEAN_DESC = 788,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_UPDATED_RUNNING_VAR_DESC = 789,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SAVED_MEAN_DESC = 790,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SAVED_INV_STD_DESC = 791,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EQ_SCALE_DESC = 792,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EQ_BIAS_DESC = 793,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_ACCUM_COUNT_DESC = 794,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EPSILON_DESC = 795,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EXP_AVERATE_FACTOR_DESC = 796,
    CUDNN_ATTR_OPERATIONGRAPH_HANDLE = 800,
    CUDNN_ATTR_OPERATIONGRAPH_OPS = 801,
    CUDNN_ATTR_OPERATIONGRAPH_ENGINE_GLOBAL_COUNT = 802,
    CUDNN_ATTR_OPERATIONGRAPH_IS_DYNAMIC_SHAPE_ENABLED = 803,
    CUDNN_ATTR_OPERATIONGRAPH_IS_SAME_TOPOLOGY = 804,
    CUDNN_ATTR_TENSOR_BYTE_ALIGNMENT = 900,
    CUDNN_ATTR_TENSOR_DATA_TYPE = 901,
    CUDNN_ATTR_TENSOR_DIMENSIONS = 902,
    CUDNN_ATTR_TENSOR_STRIDES = 903,
    CUDNN_ATTR_TENSOR_VECTOR_COUNT = 904,
    CUDNN_ATTR_TENSOR_VECTORIZED_DIMENSION = 905,
    CUDNN_ATTR_TENSOR_UNIQUE_ID = 906,
    CUDNN_ATTR_TENSOR_IS_VIRTUAL = 907,
    CUDNN_ATTR_TENSOR_IS_BY_VALUE = 908,
    CUDNN_ATTR_TENSOR_REORDERING_MODE = 909,
    CUDNN_ATTR_TENSOR_RAGGED_OFFSET_DESC = 913,
    CUDNN_ATTR_VARIANT_PACK_UNIQUE_IDS = 1000,
    CUDNN_ATTR_VARIANT_PACK_DATA_POINTERS = 1001,
    CUDNN_ATTR_VARIANT_PACK_INTERMEDIATES = 1002,
    CUDNN_ATTR_VARIANT_PACK_WORKSPACE = 1003,
    CUDNN_ATTR_LAYOUT_INFO_TENSOR_UID = 1100,
    CUDNN_ATTR_LAYOUT_INFO_TYPES = 1101,
    CUDNN_ATTR_KNOB_INFO_TYPE = 1200,
    CUDNN_ATTR_KNOB_INFO_MAXIMUM_VALUE = 1201,
    CUDNN_ATTR_KNOB_INFO_MINIMUM_VALUE = 1202,
    CUDNN_ATTR_KNOB_INFO_STRIDE = 1203,
    CUDNN_ATTR_ENGINE_OPERATION_GRAPH = 1300,
    CUDNN_ATTR_ENGINE_GLOBAL_INDEX = 1301,
    CUDNN_ATTR_ENGINE_KNOB_INFO = 1302,
    CUDNN_ATTR_ENGINE_NUMERICAL_NOTE = 1303,
    CUDNN_ATTR_ENGINE_LAYOUT_INFO = 1304,
    CUDNN_ATTR_ENGINE_BEHAVIOR_NOTE = 1305,
    CUDNN_ATTR_ENGINE_SM_COUNT_TARGET = 1306,
    CUDNN_ATTR_ENGINE_DEVICEPROP = 1307,
    CUDNN_ATTR_MATMUL_COMP_TYPE = 1500,
    CUDNN_ATTR_MATMUL_PADDING_VALUE = 1503,
    CUDNN_ATTR_OPERATION_MATMUL_ADESC = 1520,
    CUDNN_ATTR_OPERATION_MATMUL_BDESC = 1521,
    CUDNN_ATTR_OPERATION_MATMUL_CDESC = 1522,
    CUDNN_ATTR_OPERATION_MATMUL_DESC = 1523,
    CUDNN_ATTR_OPERATION_MATMUL_IRREGULARLY_STRIDED_BATCH_COUNT = 1524,
    CUDNN_ATTR_OPERATION_MATMUL_GEMM_M_OVERRIDE_DESC = 1525,
    CUDNN_ATTR_OPERATION_MATMUL_GEMM_N_OVERRIDE_DESC = 1526,
    CUDNN_ATTR_OPERATION_MATMUL_GEMM_K_OVERRIDE_DESC = 1527,
    CUDNN_ATTR_REDUCTION_OPERATOR = 1600,
    CUDNN_ATTR_REDUCTION_COMP_TYPE = 1601,
    CUDNN_ATTR_OPERATION_REDUCTION_XDESC = 1610,
    CUDNN_ATTR_OPERATION_REDUCTION_YDESC = 1611,
    CUDNN_ATTR_OPERATION_REDUCTION_DESC = 1612,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_MATH_PREC = 1620,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_MEAN_DESC = 1621,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_INVSTD_DESC = 1622,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_BN_SCALE_DESC = 1623,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_X_DESC = 1624,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DY_DESC = 1625,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DBN_SCALE_DESC = 1626,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DBN_BIAS_DESC = 1627,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_DY_SCALE_DESC = 1628,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_X_SCALE_DESC = 1629,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_BIAS = 1630,
    CUDNN_ATTR_RESAMPLE_MODE = 1700,
    CUDNN_ATTR_RESAMPLE_COMP_TYPE = 1701,
    CUDNN_ATTR_RESAMPLE_SPATIAL_DIMS = 1702,
    CUDNN_ATTR_RESAMPLE_POST_PADDINGS = 1703,
    CUDNN_ATTR_RESAMPLE_PRE_PADDINGS = 1704,
    CUDNN_ATTR_RESAMPLE_STRIDES = 1705,
    CUDNN_ATTR_RESAMPLE_WINDOW_DIMS = 1706,
    CUDNN_ATTR_RESAMPLE_NAN_PROPAGATION = 1707,
    CUDNN_ATTR_RESAMPLE_PADDING_MODE = 1708,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_XDESC = 1710,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_YDESC = 1711,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_IDXDESC = 1712,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_ALPHA = 1713,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_BETA = 1714,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_DESC = 1716,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DXDESC = 1720,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DYDESC = 1721,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_IDXDESC = 1722,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_ALPHA = 1723,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_BETA = 1724,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DESC = 1725,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_XDESC = 1726,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_YDESC = 1727,
    CUDNN_ATTR_OPERATION_CONCAT_AXIS = 1800,
    CUDNN_ATTR_OPERATION_CONCAT_INPUT_DESCS = 1801,
    CUDNN_ATTR_OPERATION_CONCAT_INPLACE_INDEX = 1802,
    CUDNN_ATTR_OPERATION_CONCAT_OUTPUT_DESC = 1803,
    CUDNN_ATTR_OPERATION_SIGNAL_MODE = 1900,
    CUDNN_ATTR_OPERATION_SIGNAL_FLAGDESC = 1901,
    CUDNN_ATTR_OPERATION_SIGNAL_VALUE = 1902,
    CUDNN_ATTR_OPERATION_SIGNAL_XDESC = 1903,
    CUDNN_ATTR_OPERATION_SIGNAL_YDESC = 1904,
    CUDNN_ATTR_OPERATION_PAGED_CACHE_LOAD_CONTAINER_DESC = 1950,
    CUDNN_ATTR_OPERATION_PAGED_CACHE_LOAD_YDESC = 1951,
    CUDNN_ATTR_OPERATION_PAGED_CACHE_LOAD_SEQUENCE_DESC = 1952,
    CUDNN_ATTR_OPERATION_PAGED_CACHE_LOAD_PAGE_TABLE_DESC = 1953,
    CUDNN_ATTR_OPERATION_NORM_FWD_MODE = 2000,
    CUDNN_ATTR_OPERATION_NORM_FWD_PHASE = 2001,
    CUDNN_ATTR_OPERATION_NORM_FWD_XDESC = 2002,
    CUDNN_ATTR_OPERATION_NORM_FWD_MEAN_DESC = 2003,
    CUDNN_ATTR_OPERATION_NORM_FWD_INV_VARIANCE_DESC = 2004,
    CUDNN_ATTR_OPERATION_NORM_FWD_SCALE_DESC = 2005,
    CUDNN_ATTR_OPERATION_NORM_FWD_BIAS_DESC = 2006,
    CUDNN_ATTR_OPERATION_NORM_FWD_EPSILON_DESC = 2007,
    CUDNN_ATTR_OPERATION_NORM_FWD_EXP_AVG_FACTOR_DESC = 2008,
    CUDNN_ATTR_OPERATION_NORM_FWD_INPUT_RUNNING_MEAN_DESC = 2009,
    CUDNN_ATTR_OPERATION_NORM_FWD_INPUT_RUNNING_VAR_DESC = 2010,
    CUDNN_ATTR_OPERATION_NORM_FWD_OUTPUT_RUNNING_MEAN_DESC = 2011,
    CUDNN_ATTR_OPERATION_NORM_FWD_OUTPUT_RUNNING_VAR_DESC = 2012,
    CUDNN_ATTR_OPERATION_NORM_FWD_YDESC = 2013,
    CUDNN_ATTR_OPERATION_NORM_FWD_PEER_STAT_DESCS = 2014,
    CUDNN_ATTR_OPERATION_NORM_BWD_MODE = 2100,
    CUDNN_ATTR_OPERATION_NORM_BWD_XDESC = 2101,
    CUDNN_ATTR_OPERATION_NORM_BWD_MEAN_DESC = 2102,
    CUDNN_ATTR_OPERATION_NORM_BWD_INV_VARIANCE_DESC = 2103,
    CUDNN_ATTR_OPERATION_NORM_BWD_DYDESC = 2104,
    CUDNN_ATTR_OPERATION_NORM_BWD_SCALE_DESC = 2105,
    CUDNN_ATTR_OPERATION_NORM_BWD_EPSILON_DESC = 2106,
    CUDNN_ATTR_OPERATION_NORM_BWD_DSCALE_DESC = 2107,
    CUDNN_ATTR_OPERATION_NORM_BWD_DBIAS_DESC = 2108,
    CUDNN_ATTR_OPERATION_NORM_BWD_DXDESC = 2109,
    CUDNN_ATTR_OPERATION_NORM_BWD_PEER_STAT_DESCS = 2110,
    CUDNN_ATTR_OPERATION_RESHAPE_XDESC = 2200,
    CUDNN_ATTR_OPERATION_RESHAPE_YDESC = 2201,
    CUDNN_ATTR_RNG_DISTRIBUTION = 2300,
    CUDNN_ATTR_RNG_NORMAL_DIST_MEAN = 2301,
    CUDNN_ATTR_RNG_NORMAL_DIST_STANDARD_DEVIATION = 2302,
    CUDNN_ATTR_RNG_UNIFORM_DIST_MAXIMUM = 2303,
    CUDNN_ATTR_RNG_UNIFORM_DIST_MINIMUM = 2304,
    CUDNN_ATTR_RNG_BERNOULLI_DIST_PROBABILITY = 2305,
    CUDNN_ATTR_OPERATION_RNG_YDESC = 2310,
    CUDNN_ATTR_OPERATION_RNG_SEED = 2311,
    CUDNN_ATTR_OPERATION_RNG_DESC = 2312,
    CUDNN_ATTR_OPERATION_RNG_OFFSET_DESC = 2313,
    CUDNN_ATTR_KERNEL_CACHE_OPERATION_GRAPH = 2400,
    CUDNN_ATTR_KERNEL_CACHE_IS_ENGINECFG_KERNEL_CACHED = 2401,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_XDESC = 2500,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_YDESC = 2501,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_SCALE_DESC = 2502,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_MATH_PREC = 2503,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_QUANTIZE_BLOCK_SIZE = 2504,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_XDESC = 2600,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_SCALE_DESC = 2601,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_YDESC = 2602,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_MATH_PREC = 2603,
    CUDNN_ATTR_OPERATION_BLOCK_SCALE_DEQUANTIZE_BLOCK_SIZE = 2604,
    CUDNN_ATTR_DEVICEPROP_DEVICE_ID = 2700,
    CUDNN_ATTR_DEVICEPROP_HANDLE = 2701,
    CUDNN_ATTR_DEVICEPROP_JSON_REPRESENTATION = 2702,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendAttributeType_t {
    CUDNN_TYPE_HANDLE = 0,
    CUDNN_TYPE_DATA_TYPE = 1,
    CUDNN_TYPE_BOOLEAN = 2,
    CUDNN_TYPE_INT64 = 3,
    CUDNN_TYPE_FLOAT = 4,
    CUDNN_TYPE_DOUBLE = 5,
    CUDNN_TYPE_VOID_PTR = 6,
    CUDNN_TYPE_CONVOLUTION_MODE = 7,
    CUDNN_TYPE_HEUR_MODE = 8,
    CUDNN_TYPE_KNOB_TYPE = 9,
    CUDNN_TYPE_NAN_PROPOGATION = 10,
    CUDNN_TYPE_NUMERICAL_NOTE = 11,
    CUDNN_TYPE_LAYOUT_TYPE = 12,
    CUDNN_TYPE_ATTRIB_NAME = 13,
    CUDNN_TYPE_POINTWISE_MODE = 14,
    CUDNN_TYPE_BACKEND_DESCRIPTOR = 15,
    CUDNN_TYPE_GENSTATS_MODE = 16,
    CUDNN_TYPE_BN_FINALIZE_STATS_MODE = 17,
    CUDNN_TYPE_REDUCTION_OPERATOR_TYPE = 18,
    CUDNN_TYPE_BEHAVIOR_NOTE = 19,
    CUDNN_TYPE_TENSOR_REORDERING_MODE = 20,
    CUDNN_TYPE_RESAMPLE_MODE = 21,
    CUDNN_TYPE_PADDING_MODE = 22,
    CUDNN_TYPE_INT32 = 23,
    CUDNN_TYPE_CHAR = 24,
    CUDNN_TYPE_SIGNAL_MODE = 25,
    CUDNN_TYPE_FRACTION = 26,
    CUDNN_TYPE_NORM_MODE = 27,
    CUDNN_TYPE_NORM_FWD_PHASE = 28,
    CUDNN_TYPE_RNG_DISTRIBUTION = 29,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendBehaviorNote_t {
    CUDNN_BEHAVIOR_NOTE_RUNTIME_COMPILATION = 0,
    CUDNN_BEHAVIOR_NOTE_REQUIRES_FILTER_INT8x32_REORDER = 1,
    CUDNN_BEHAVIOR_NOTE_REQUIRES_BIAS_INT8x32_REORDER = 2,
    CUDNN_BEHAVIOR_NOTE_SUPPORTS_CUDA_GRAPH_NATIVE_API = 3,
    CUDNN_BEHAVIOR_NOTE_TYPE_COUNT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendDescriptorType_t {
    CUDNN_BACKEND_POINTWISE_DESCRIPTOR = 0,
    CUDNN_BACKEND_CONVOLUTION_DESCRIPTOR = 1,
    CUDNN_BACKEND_ENGINE_DESCRIPTOR = 2,
    CUDNN_BACKEND_ENGINECFG_DESCRIPTOR = 3,
    CUDNN_BACKEND_ENGINEHEUR_DESCRIPTOR = 4,
    CUDNN_BACKEND_EXECUTION_PLAN_DESCRIPTOR = 5,
    CUDNN_BACKEND_INTERMEDIATE_INFO_DESCRIPTOR = 6,
    CUDNN_BACKEND_KNOB_CHOICE_DESCRIPTOR = 7,
    CUDNN_BACKEND_KNOB_INFO_DESCRIPTOR = 8,
    CUDNN_BACKEND_LAYOUT_INFO_DESCRIPTOR = 9,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_FORWARD_DESCRIPTOR = 10,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_BACKWARD_FILTER_DESCRIPTOR = 11,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_BACKWARD_DATA_DESCRIPTOR = 12,
    CUDNN_BACKEND_OPERATION_POINTWISE_DESCRIPTOR = 13,
    CUDNN_BACKEND_OPERATION_GEN_STATS_DESCRIPTOR = 14,
    CUDNN_BACKEND_OPERATIONGRAPH_DESCRIPTOR = 15,
    CUDNN_BACKEND_VARIANT_PACK_DESCRIPTOR = 16,
    CUDNN_BACKEND_TENSOR_DESCRIPTOR = 17,
    CUDNN_BACKEND_MATMUL_DESCRIPTOR = 18,
    CUDNN_BACKEND_OPERATION_MATMUL_DESCRIPTOR = 19,
    CUDNN_BACKEND_OPERATION_BN_FINALIZE_STATISTICS_DESCRIPTOR = 20,
    CUDNN_BACKEND_REDUCTION_DESCRIPTOR = 21,
    CUDNN_BACKEND_OPERATION_REDUCTION_DESCRIPTOR = 22,
    CUDNN_BACKEND_OPERATION_BN_BWD_WEIGHTS_DESCRIPTOR = 23,
    CUDNN_BACKEND_RESAMPLE_DESCRIPTOR = 24,
    CUDNN_BACKEND_OPERATION_RESAMPLE_FWD_DESCRIPTOR = 25,
    CUDNN_BACKEND_OPERATION_RESAMPLE_BWD_DESCRIPTOR = 26,
    CUDNN_BACKEND_OPERATION_CONCAT_DESCRIPTOR = 27,
    CUDNN_BACKEND_OPERATION_SIGNAL_DESCRIPTOR = 28,
    CUDNN_BACKEND_OPERATION_NORM_FORWARD_DESCRIPTOR = 29,
    CUDNN_BACKEND_OPERATION_NORM_BACKWARD_DESCRIPTOR = 30,
    CUDNN_BACKEND_OPERATION_RESHAPE_DESCRIPTOR = 31,
    CUDNN_BACKEND_RNG_DESCRIPTOR = 32,
    CUDNN_BACKEND_OPERATION_RNG_DESCRIPTOR = 33,
    CUDNN_BACKEND_KERNEL_CACHE_DESCRIPTOR = 34,
    CUDNN_BACKEND_OPERATION_PAGED_CACHE_LOAD_DESCRIPTOR = 35,
    CUDNN_BACKEND_OPERATION_BLOCK_SCALE_QUANTIZE_DESCRIPTOR = 36,
    CUDNN_BACKEND_OPERATION_BLOCK_SCALE_DEQUANTIZE_DESCRIPTOR = 37,
    CUDNN_BACKEND_DEVICEPROP_DESCRIPTOR = 38,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendHeurMode_t {
    CUDNN_HEUR_MODE_INSTANT = 0,
    CUDNN_HEUR_MODE_B = 1,
    CUDNN_HEUR_MODE_FALLBACK = 2,
    CUDNN_HEUR_MODE_A = 3,
    CUDNN_HEUR_MODES_COUNT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendKnobType_t {
    CUDNN_KNOB_TYPE_SPLIT_K = 0,
    CUDNN_KNOB_TYPE_SWIZZLE = 1,
    CUDNN_KNOB_TYPE_TILE_SIZE = 2,
    CUDNN_KNOB_TYPE_USE_TEX = 3,
    CUDNN_KNOB_TYPE_EDGE = 4,
    CUDNN_KNOB_TYPE_KBLOCK = 5,
    CUDNN_KNOB_TYPE_LDGA = 6,
    CUDNN_KNOB_TYPE_LDGB = 7,
    CUDNN_KNOB_TYPE_CHUNK_K = 8,
    CUDNN_KNOB_TYPE_SPLIT_H = 9,
    CUDNN_KNOB_TYPE_WINO_TILE = 10,
    CUDNN_KNOB_TYPE_MULTIPLY = 11,
    CUDNN_KNOB_TYPE_SPLIT_K_BUF = 12,
    CUDNN_KNOB_TYPE_TILEK = 13,
    CUDNN_KNOB_TYPE_STAGES = 14,
    CUDNN_KNOB_TYPE_REDUCTION_MODE = 15,
    CUDNN_KNOB_TYPE_CTA_SPLIT_K_MODE = 16,
    CUDNN_KNOB_TYPE_SPLIT_K_SLC = 17,
    CUDNN_KNOB_TYPE_IDX_MODE = 18,
    CUDNN_KNOB_TYPE_SLICED = 19,
    CUDNN_KNOB_TYPE_SPLIT_RS = 20,
    CUDNN_KNOB_TYPE_SINGLEBUFFER = 21,
    CUDNN_KNOB_TYPE_LDGC = 22,
    CUDNN_KNOB_TYPE_SPECFILT = 23,
    CUDNN_KNOB_TYPE_KERNEL_CFG = 24,
    CUDNN_KNOB_TYPE_WORKSPACE = 25,
    CUDNN_KNOB_TYPE_TILE_CGA = 26,
    CUDNN_KNOB_TYPE_TILE_CGA_M = 27,
    CUDNN_KNOB_TYPE_TILE_CGA_N = 28,
    CUDNN_KNOB_TYPE_BLOCK_SIZE = 29,
    CUDNN_KNOB_TYPE_OCCUPANCY = 30,
    CUDNN_KNOB_TYPE_ARRAY_SIZE_PER_THREAD = 31,
    CUDNN_KNOB_TYPE_NUM_C_PER_BLOCK = 32,
    CUDNN_KNOB_TYPE_SPLIT_COLS = 33,
    CUDNN_KNOB_TYPE_TILE_ROWS = 34,
    CUDNN_KNOB_TYPE_TILE_COLS = 35,
    CUDNN_KNOB_TYPE_LOAD_SIZE = 36,
    CUDNN_KNOB_TYPE_CTA_COUNT = 37,
    CUDNN_KNOB_TYPE_STREAM_K = 38,
    CUDNN_KNOB_TYPE_SPLIT_P_SLC = 39,
    CUDNN_KNOB_TYPE_TILE_M = 40,
    CUDNN_KNOB_TYPE_TILE_N = 41,
    CUDNN_KNOB_TYPE_WARP_SPEC_CFG = 42,
    CUDNN_KNOB_TYPE_COUNTS = 43,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendLayoutType_t {
    CUDNN_LAYOUT_TYPE_PREFERRED_NCHW = 0,
    CUDNN_LAYOUT_TYPE_PREFERRED_NHWC = 1,
    CUDNN_LAYOUT_TYPE_PREFERRED_PAD4CK = 2,
    CUDNN_LAYOUT_TYPE_PREFERRED_PAD8CK = 3,
    CUDNN_LAYOUT_TYPE_COUNT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendNormFwdPhase_t {
    CUDNN_NORM_FWD_INFERENCE = 0,
    CUDNN_NORM_FWD_TRAINING = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendNormMode_t {
    CUDNN_LAYER_NORM = 0,
    CUDNN_INSTANCE_NORM = 1,
    CUDNN_BATCH_NORM = 2,
    CUDNN_GROUP_NORM = 3,
    CUDNN_RMS_NORM = 4,
    CUDNN_ADA_LAYER_NORM = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendNumericalNote_t {
    CUDNN_NUMERICAL_NOTE_TENSOR_CORE = 0,
    CUDNN_NUMERICAL_NOTE_DOWN_CONVERT_INPUTS = 1,
    CUDNN_NUMERICAL_NOTE_REDUCED_PRECISION_REDUCTION = 2,
    CUDNN_NUMERICAL_NOTE_FFT = 3,
    CUDNN_NUMERICAL_NOTE_NONDETERMINISTIC = 4,
    CUDNN_NUMERICAL_NOTE_WINOGRAD = 5,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_4x4 = 6,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_6x6 = 7,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_13x13 = 8,
    CUDNN_NUMERICAL_NOTE_STRICT_NAN_PROP = 9,
    CUDNN_NUMERICAL_NOTE_TYPE_COUNT = 10,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendTensorReordering_t {
    CUDNN_TENSOR_REORDERING_NONE = 0,
    CUDNN_TENSOR_REORDERING_INT8x32 = 1,
    CUDNN_TENSOR_REORDERING_F16x16 = 2,
    CUDNN_TENSOR_REORDERING_F8_128x4 = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBatchNormMode_t {
    CUDNN_BATCHNORM_PER_ACTIVATION = 0,
    CUDNN_BATCHNORM_SPATIAL = 1,
    CUDNN_BATCHNORM_SPATIAL_PERSISTENT = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBatchNormOps_t {
    CUDNN_BATCHNORM_OPS_BN = 0,
    CUDNN_BATCHNORM_OPS_BN_ACTIVATION = 1,
    CUDNN_BATCHNORM_OPS_BN_ADD_ACTIVATION = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBnFinalizeStatsMode_t {
    CUDNN_BN_FINALIZE_STATISTICS_TRAINING = 0,
    CUDNN_BN_FINALIZE_STATISTICS_INFERENCE = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnCTCGradMode_t {
    CUDNN_CTC_ZERO_OOB_GRADIENTS = 0,
    CUDNN_CTC_SKIP_OOB_GRADIENTS = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnCTCLossAlgo_t {
    CUDNN_CTC_LOSS_ALGO_DETERMINISTIC = 0,
    CUDNN_CTC_LOSS_ALGO_NON_DETERMINISTIC = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnConvolutionBwdDataAlgo_t {
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_0 = 0,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_1 = 1,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT = 2,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT_TILING = 3,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD = 4,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_COUNT = 6,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnConvolutionBwdFilterAlgo_t {
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_0 = 0,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_1 = 1,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT = 2,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_3 = 3,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD = 4,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT_TILING = 6,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_COUNT = 7,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnConvolutionFwdAlgo_t {
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_GEMM = 0,
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_PRECOMP_GEMM = 1,
    CUDNN_CONVOLUTION_FWD_ALGO_GEMM = 2,
    CUDNN_CONVOLUTION_FWD_ALGO_DIRECT = 3,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT = 4,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT_TILING = 5,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD = 6,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD_NONFUSED = 7,
    CUDNN_CONVOLUTION_FWD_ALGO_COUNT = 8,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnConvolutionMode_t {
    CUDNN_CONVOLUTION = 0,
    CUDNN_CROSS_CORRELATION = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnDataType_t {
    CUDNN_DATA_FLOAT = 0,
    CUDNN_DATA_DOUBLE = 1,
    CUDNN_DATA_HALF = 2,
    CUDNN_DATA_INT8 = 3,
    CUDNN_DATA_INT32 = 4,
    CUDNN_DATA_INT8x4 = 5,
    CUDNN_DATA_UINT8 = 6,
    CUDNN_DATA_UINT8x4 = 7,
    CUDNN_DATA_INT8x32 = 8,
    CUDNN_DATA_BFLOAT16 = 9,
    CUDNN_DATA_INT64 = 10,
    CUDNN_DATA_BOOLEAN = 11,
    CUDNN_DATA_FP8_E4M3 = 12,
    CUDNN_DATA_FP8_E5M2 = 13,
    CUDNN_DATA_FAST_FLOAT_FOR_FP8 = 14,
    CUDNN_DATA_FP8_E8M0 = 15,
    CUDNN_DATA_FP4_E2M1 = 16,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnDeterminism_t {
    CUDNN_NON_DETERMINISTIC = 0,
    CUDNN_DETERMINISTIC = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnDirectionMode_t {
    CUDNN_UNIDIRECTIONAL = 0,
    CUDNN_BIDIRECTIONAL = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnDivNormMode_t {
    CUDNN_DIVNORM_PRECOMPUTED_MEANS = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnErrQueryMode_t {
    CUDNN_ERRQUERY_RAWCODE = 0,
    CUDNN_ERRQUERY_NONBLOCKING = 1,
    CUDNN_ERRQUERY_BLOCKING = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFoldingDirection_t {
    CUDNN_TRANSFORM_FOLD = 0,
    CUDNN_TRANSFORM_UNFOLD = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnForwardMode_t {
    CUDNN_FWD_MODE_INFERENCE = 0,
    CUDNN_FWD_MODE_TRAINING = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFusedOpsConstParamLabel_t {
    CUDNN_PARAM_XDESC = 0,
    CUDNN_PARAM_XDATA_PLACEHOLDER = 1,
    CUDNN_PARAM_BN_MODE = 2,
    CUDNN_PARAM_BN_EQSCALEBIAS_DESC = 3,
    CUDNN_PARAM_BN_EQSCALE_PLACEHOLDER = 4,
    CUDNN_PARAM_BN_EQBIAS_PLACEHOLDER = 5,
    CUDNN_PARAM_ACTIVATION_DESC = 6,
    CUDNN_PARAM_CONV_DESC = 7,
    CUDNN_PARAM_WDESC = 8,
    CUDNN_PARAM_WDATA_PLACEHOLDER = 9,
    CUDNN_PARAM_DWDESC = 10,
    CUDNN_PARAM_DWDATA_PLACEHOLDER = 11,
    CUDNN_PARAM_YDESC = 12,
    CUDNN_PARAM_YDATA_PLACEHOLDER = 13,
    CUDNN_PARAM_DYDESC = 14,
    CUDNN_PARAM_DYDATA_PLACEHOLDER = 15,
    CUDNN_PARAM_YSTATS_DESC = 16,
    CUDNN_PARAM_YSUM_PLACEHOLDER = 17,
    CUDNN_PARAM_YSQSUM_PLACEHOLDER = 18,
    CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC = 19,
    CUDNN_PARAM_BN_SCALE_PLACEHOLDER = 20,
    CUDNN_PARAM_BN_BIAS_PLACEHOLDER = 21,
    CUDNN_PARAM_BN_SAVED_MEAN_PLACEHOLDER = 22,
    CUDNN_PARAM_BN_SAVED_INVSTD_PLACEHOLDER = 23,
    CUDNN_PARAM_BN_RUNNING_MEAN_PLACEHOLDER = 24,
    CUDNN_PARAM_BN_RUNNING_VAR_PLACEHOLDER = 25,
    CUDNN_PARAM_ZDESC = 26,
    CUDNN_PARAM_ZDATA_PLACEHOLDER = 27,
    CUDNN_PARAM_BN_Z_EQSCALEBIAS_DESC = 28,
    CUDNN_PARAM_BN_Z_EQSCALE_PLACEHOLDER = 29,
    CUDNN_PARAM_BN_Z_EQBIAS_PLACEHOLDER = 30,
    CUDNN_PARAM_ACTIVATION_BITMASK_DESC = 31,
    CUDNN_PARAM_ACTIVATION_BITMASK_PLACEHOLDER = 32,
    CUDNN_PARAM_DXDESC = 33,
    CUDNN_PARAM_DXDATA_PLACEHOLDER = 34,
    CUDNN_PARAM_DZDESC = 35,
    CUDNN_PARAM_DZDATA_PLACEHOLDER = 36,
    CUDNN_PARAM_BN_DSCALE_PLACEHOLDER = 37,
    CUDNN_PARAM_BN_DBIAS_PLACEHOLDER = 38,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFusedOpsPointerPlaceHolder_t {
    CUDNN_PTR_NULL = 0,
    CUDNN_PTR_ELEM_ALIGNED = 1,
    CUDNN_PTR_16B_ALIGNED = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFusedOpsVariantParamLabel_t {
    CUDNN_PTR_XDATA = 0,
    CUDNN_PTR_BN_EQSCALE = 1,
    CUDNN_PTR_BN_EQBIAS = 2,
    CUDNN_PTR_WDATA = 3,
    CUDNN_PTR_DWDATA = 4,
    CUDNN_PTR_YDATA = 5,
    CUDNN_PTR_DYDATA = 6,
    CUDNN_PTR_YSUM = 7,
    CUDNN_PTR_YSQSUM = 8,
    CUDNN_PTR_WORKSPACE = 9,
    CUDNN_PTR_BN_SCALE = 10,
    CUDNN_PTR_BN_BIAS = 11,
    CUDNN_PTR_BN_SAVED_MEAN = 12,
    CUDNN_PTR_BN_SAVED_INVSTD = 13,
    CUDNN_PTR_BN_RUNNING_MEAN = 14,
    CUDNN_PTR_BN_RUNNING_VAR = 15,
    CUDNN_PTR_ZDATA = 16,
    CUDNN_PTR_BN_Z_EQSCALE = 17,
    CUDNN_PTR_BN_Z_EQBIAS = 18,
    CUDNN_PTR_ACTIVATION_BITMASK = 19,
    CUDNN_PTR_DXDATA = 20,
    CUDNN_PTR_DZDATA = 21,
    CUDNN_PTR_BN_DSCALE = 22,
    CUDNN_PTR_BN_DBIAS = 23,
    CUDNN_SCALAR_SIZE_T_WORKSPACE_SIZE_IN_BYTES = 100,
    CUDNN_SCALAR_INT64_T_BN_ACCUMULATION_COUNT = 101,
    CUDNN_SCALAR_DOUBLE_BN_EXP_AVG_FACTOR = 102,
    CUDNN_SCALAR_DOUBLE_BN_EPSILON = 103,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFusedOps_t {
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_CONV_BNSTATS = 0,
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_WGRAD = 1,
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_TRAINING = 2,
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_INFERENCE = 3,
    CUDNN_FUSED_CONV_SCALE_BIAS_ADD_ACTIVATION = 4,
    CUDNN_FUSED_SCALE_BIAS_ADD_ACTIVATION_GEN_BITMASK = 5,
    CUDNN_FUSED_DACTIVATION_FORK_DBATCHNORM = 6,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnGenStatsMode_t {
    CUDNN_GENSTATS_SUM_SQSUM = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnIndicesType_t {
    CUDNN_32BIT_INDICES = 0,
    CUDNN_64BIT_INDICES = 1,
    CUDNN_16BIT_INDICES = 2,
    CUDNN_8BIT_INDICES = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnLRNMode_t {
    CUDNN_LRN_CROSS_CHANNEL_DIM1 = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnLossNormalizationMode_t {
    CUDNN_LOSS_NORMALIZATION_NONE = 0,
    CUDNN_LOSS_NORMALIZATION_SOFTMAX = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnMathType_t {
    CUDNN_DEFAULT_MATH = 0,
    CUDNN_TENSOR_OP_MATH = 1,
    CUDNN_TENSOR_OP_MATH_ALLOW_CONVERSION = 2,
    CUDNN_FMA_MATH = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnMultiHeadAttnWeightKind_t {
    CUDNN_MH_ATTN_Q_WEIGHTS = 0,
    CUDNN_MH_ATTN_K_WEIGHTS = 1,
    CUDNN_MH_ATTN_V_WEIGHTS = 2,
    CUDNN_MH_ATTN_O_WEIGHTS = 3,
    CUDNN_MH_ATTN_Q_BIASES = 4,
    CUDNN_MH_ATTN_K_BIASES = 5,
    CUDNN_MH_ATTN_V_BIASES = 6,
    CUDNN_MH_ATTN_O_BIASES = 7,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnNanPropagation_t {
    CUDNN_NOT_PROPAGATE_NAN = 0,
    CUDNN_PROPAGATE_NAN = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnNormAlgo_t {
    CUDNN_NORM_ALGO_STANDARD = 0,
    CUDNN_NORM_ALGO_PERSIST = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnNormMode_t {
    CUDNN_NORM_PER_ACTIVATION = 0,
    CUDNN_NORM_PER_CHANNEL = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnNormOps_t {
    CUDNN_NORM_OPS_NORM = 0,
    CUDNN_NORM_OPS_NORM_ACTIVATION = 1,
    CUDNN_NORM_OPS_NORM_ADD_ACTIVATION = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnOpTensorOp_t {
    CUDNN_OP_TENSOR_ADD = 0,
    CUDNN_OP_TENSOR_MUL = 1,
    CUDNN_OP_TENSOR_MIN = 2,
    CUDNN_OP_TENSOR_MAX = 3,
    CUDNN_OP_TENSOR_SQRT = 4,
    CUDNN_OP_TENSOR_NOT = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnPaddingMode_t {
    CUDNN_ZERO_PAD = 0,
    CUDNN_NEG_INF_PAD = 1,
    CUDNN_EDGE_VAL_PAD = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnPointwiseMode_t {
    CUDNN_POINTWISE_ADD = 0,
    CUDNN_POINTWISE_ADD_SQUARE = 5,
    CUDNN_POINTWISE_DIV = 6,
    CUDNN_POINTWISE_MAX = 3,
    CUDNN_POINTWISE_MIN = 2,
    CUDNN_POINTWISE_MOD = 7,
    CUDNN_POINTWISE_MUL = 1,
    CUDNN_POINTWISE_POW = 8,
    CUDNN_POINTWISE_SUB = 9,
    CUDNN_POINTWISE_ABS = 10,
    CUDNN_POINTWISE_CEIL = 11,
    CUDNN_POINTWISE_COS = 12,
    CUDNN_POINTWISE_EXP = 13,
    CUDNN_POINTWISE_FLOOR = 14,
    CUDNN_POINTWISE_LOG = 15,
    CUDNN_POINTWISE_NEG = 16,
    CUDNN_POINTWISE_RSQRT = 17,
    CUDNN_POINTWISE_SIN = 18,
    CUDNN_POINTWISE_SQRT = 4,
    CUDNN_POINTWISE_TAN = 19,
    CUDNN_POINTWISE_ERF = 20,
    CUDNN_POINTWISE_IDENTITY = 21,
    CUDNN_POINTWISE_RECIPROCAL = 22,
    CUDNN_POINTWISE_ATAN2 = 23,
    CUDNN_POINTWISE_RELU_FWD = 100,
    CUDNN_POINTWISE_TANH_FWD = 101,
    CUDNN_POINTWISE_SIGMOID_FWD = 102,
    CUDNN_POINTWISE_ELU_FWD = 103,
    CUDNN_POINTWISE_GELU_FWD = 104,
    CUDNN_POINTWISE_SOFTPLUS_FWD = 105,
    CUDNN_POINTWISE_SWISH_FWD = 106,
    CUDNN_POINTWISE_GELU_APPROX_TANH_FWD = 107,
    CUDNN_POINTWISE_RELU_BWD = 200,
    CUDNN_POINTWISE_TANH_BWD = 201,
    CUDNN_POINTWISE_SIGMOID_BWD = 202,
    CUDNN_POINTWISE_ELU_BWD = 203,
    CUDNN_POINTWISE_GELU_BWD = 204,
    CUDNN_POINTWISE_SOFTPLUS_BWD = 205,
    CUDNN_POINTWISE_SWISH_BWD = 206,
    CUDNN_POINTWISE_GELU_APPROX_TANH_BWD = 207,
    CUDNN_POINTWISE_CMP_EQ = 300,
    CUDNN_POINTWISE_CMP_NEQ = 301,
    CUDNN_POINTWISE_CMP_GT = 302,
    CUDNN_POINTWISE_CMP_GE = 303,
    CUDNN_POINTWISE_CMP_LT = 304,
    CUDNN_POINTWISE_CMP_LE = 305,
    CUDNN_POINTWISE_LOGICAL_AND = 400,
    CUDNN_POINTWISE_LOGICAL_OR = 401,
    CUDNN_POINTWISE_LOGICAL_NOT = 402,
    CUDNN_POINTWISE_GEN_INDEX = 501,
    CUDNN_POINTWISE_BINARY_SELECT = 601,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnPoolingMode_t {
    CUDNN_POOLING_MAX = 0,
    CUDNN_POOLING_AVERAGE_COUNT_INCLUDE_PADDING = 1,
    CUDNN_POOLING_AVERAGE_COUNT_EXCLUDE_PADDING = 2,
    CUDNN_POOLING_MAX_DETERMINISTIC = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNAlgo_t {
    CUDNN_RNN_ALGO_STANDARD = 0,
    CUDNN_RNN_ALGO_PERSIST_STATIC = 1,
    CUDNN_RNN_ALGO_PERSIST_DYNAMIC = 2,
    CUDNN_RNN_ALGO_PERSIST_STATIC_SMALL_H = 3,
    CUDNN_RNN_ALGO_COUNT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNBiasMode_t {
    CUDNN_RNN_NO_BIAS = 0,
    CUDNN_RNN_SINGLE_INP_BIAS = 1,
    CUDNN_RNN_DOUBLE_BIAS = 2,
    CUDNN_RNN_SINGLE_REC_BIAS = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNClipMode_t {
    CUDNN_RNN_CLIP_NONE = 0,
    CUDNN_RNN_CLIP_MINMAX = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNDataLayout_t {
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_UNPACKED = 0,
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_PACKED = 1,
    CUDNN_RNN_DATA_LAYOUT_BATCH_MAJOR_UNPACKED = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNInputMode_t {
    CUDNN_LINEAR_INPUT = 0,
    CUDNN_SKIP_INPUT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNMode_t {
    CUDNN_RNN_RELU = 0,
    CUDNN_RNN_TANH = 1,
    CUDNN_LSTM = 2,
    CUDNN_GRU = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnReduceTensorIndices_t {
    CUDNN_REDUCE_TENSOR_NO_INDICES = 0,
    CUDNN_REDUCE_TENSOR_FLATTENED_INDICES = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnReduceTensorOp_t {
    CUDNN_REDUCE_TENSOR_ADD = 0,
    CUDNN_REDUCE_TENSOR_MUL = 1,
    CUDNN_REDUCE_TENSOR_MIN = 2,
    CUDNN_REDUCE_TENSOR_MAX = 3,
    CUDNN_REDUCE_TENSOR_AMAX = 4,
    CUDNN_REDUCE_TENSOR_AVG = 5,
    CUDNN_REDUCE_TENSOR_NORM1 = 6,
    CUDNN_REDUCE_TENSOR_NORM2 = 7,
    CUDNN_REDUCE_TENSOR_MUL_NO_ZEROS = 8,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnReorderType_t {
    CUDNN_DEFAULT_REORDER = 0,
    CUDNN_NO_REORDER = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnResampleMode_t {
    CUDNN_RESAMPLE_NEAREST = 0,
    CUDNN_RESAMPLE_BILINEAR = 1,
    CUDNN_RESAMPLE_AVGPOOL = 2,
    CUDNN_RESAMPLE_AVGPOOL_EXCLUDE_PADDING = 4,
    CUDNN_RESAMPLE_MAXPOOL = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRngDistribution_t {
    CUDNN_RNG_DISTRIBUTION_BERNOULLI = 0,
    CUDNN_RNG_DISTRIBUTION_UNIFORM = 1,
    CUDNN_RNG_DISTRIBUTION_NORMAL = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSamplerType_t {
    CUDNN_SAMPLER_BILINEAR = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSeqDataAxis_t {
    CUDNN_SEQDATA_TIME_DIM = 0,
    CUDNN_SEQDATA_BATCH_DIM = 1,
    CUDNN_SEQDATA_BEAM_DIM = 2,
    CUDNN_SEQDATA_VECT_DIM = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSeverity_t {
    CUDNN_SEV_FATAL = 0,
    CUDNN_SEV_ERROR = 1,
    CUDNN_SEV_WARNING = 2,
    CUDNN_SEV_INFO = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSignalMode_t {
    CUDNN_SIGNAL_SET = 0,
    CUDNN_SIGNAL_WAIT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSoftmaxAlgorithm_t {
    CUDNN_SOFTMAX_FAST = 0,
    CUDNN_SOFTMAX_ACCURATE = 1,
    CUDNN_SOFTMAX_LOG = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSoftmaxMode_t {
    CUDNN_SOFTMAX_MODE_INSTANCE = 0,
    CUDNN_SOFTMAX_MODE_CHANNEL = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnStatus_t {
    CUDNN_STATUS_SUCCESS = 0,
    CUDNN_STATUS_NOT_INITIALIZED = 1001,
    CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH = 1002,
    CUDNN_STATUS_SERIALIZATION_VERSION_MISMATCH = 1003,
    CUDNN_STATUS_DEPRECATED = 1004,
    CUDNN_STATUS_LICENSE_ERROR = 1005,
    CUDNN_STATUS_RUNTIME_IN_PROGRESS = 1006,
    CUDNN_STATUS_RUNTIME_FP_OVERFLOW = 1007,
    CUDNN_STATUS_SUBLIBRARY_LOADING_FAILED = 1008,
    CUDNN_STATUS_BAD_PARAM = 2000,
    CUDNN_STATUS_BAD_PARAM_NULL_POINTER = 2002,
    CUDNN_STATUS_BAD_PARAM_MISALIGNED_POINTER = 2003,
    CUDNN_STATUS_BAD_PARAM_NOT_FINALIZED = 2004,
    CUDNN_STATUS_BAD_PARAM_OUT_OF_BOUND = 2005,
    CUDNN_STATUS_BAD_PARAM_SIZE_INSUFFICIENT = 2006,
    CUDNN_STATUS_BAD_PARAM_STREAM_MISMATCH = 2007,
    CUDNN_STATUS_BAD_PARAM_SHAPE_MISMATCH = 2008,
    CUDNN_STATUS_BAD_PARAM_DUPLICATED_ENTRIES = 2009,
    CUDNN_STATUS_BAD_PARAM_ATTRIBUTE_TYPE = 2010,
    CUDNN_STATUS_BAD_PARAM_CUDA_GRAPH_MISMATCH = 2011,
    CUDNN_STATUS_BAD_PARAM_DESCRIPTOR_TYPE = 2012,
    CUDNN_STATUS_NOT_SUPPORTED = 3000,
    CUDNN_STATUS_NOT_SUPPORTED_GRAPH_PATTERN = 3001,
    CUDNN_STATUS_NOT_SUPPORTED_SHAPE = 3002,
    CUDNN_STATUS_NOT_SUPPORTED_DATA_TYPE = 3003,
    CUDNN_STATUS_NOT_SUPPORTED_LAYOUT = 3004,
    CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDA_DRIVER = 3005,
    CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDART = 3006,
    CUDNN_STATUS_NOT_SUPPORTED_ARCH_MISMATCH = 3007,
    CUDNN_STATUS_NOT_SUPPORTED_RUNTIME_PREREQUISITE_MISSING = 3008,
    CUDNN_STATUS_NOT_SUPPORTED_SUBLIBRARY_UNAVAILABLE = 3009,
    CUDNN_STATUS_NOT_SUPPORTED_SHARED_MEMORY_INSUFFICIENT = 3010,
    CUDNN_STATUS_NOT_SUPPORTED_PADDING = 3011,
    CUDNN_STATUS_NOT_SUPPORTED_BAD_LAUNCH_PARAM = 3012,
    CUDNN_STATUS_NOT_SUPPORTED_CUDA_GRAPH_NATIVE_API = 3013,
    CUDNN_STATUS_INTERNAL_ERROR = 4000,
    CUDNN_STATUS_INTERNAL_ERROR_COMPILATION_FAILED = 4001,
    CUDNN_STATUS_INTERNAL_ERROR_UNEXPECTED_VALUE = 4002,
    CUDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED = 4003,
    CUDNN_STATUS_INTERNAL_ERROR_DEVICE_ALLOCATION_FAILED = 4004,
    CUDNN_STATUS_INTERNAL_ERROR_BAD_LAUNCH_PARAM = 4005,
    CUDNN_STATUS_INTERNAL_ERROR_TEXTURE_CREATION_FAILED = 4006,
    CUDNN_STATUS_EXECUTION_FAILED = 5000,
    CUDNN_STATUS_EXECUTION_FAILED_CUDA_DRIVER = 5001,
    CUDNN_STATUS_EXECUTION_FAILED_CUBLAS = 5002,
    CUDNN_STATUS_EXECUTION_FAILED_CUDART = 5003,
    CUDNN_STATUS_EXECUTION_FAILED_CURAND = 5004,
    CUDNN_STATUS_INVALID_VALUE = 2001,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnTensorFormat_t {
    CUDNN_TENSOR_NCHW = 0,
    CUDNN_TENSOR_NHWC = 1,
    CUDNN_TENSOR_NCHW_VECT_C = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnWgradMode_t {
    CUDNN_WGRAD_MODE_ADD = 0,
    CUDNN_WGRAD_MODE_SET = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum libraryPropertyType_t {
    MAJOR_VERSION = 0,
    MINOR_VERSION = 1,
    PATCH_LEVEL = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUgraph_st {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUstream_st {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnActivationStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnAttnStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnCTCLossStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnContext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct cudnnConvolutionBwdDataAlgoPerfStruct {
    pub algo: cudnnConvolutionBwdDataAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::core::ffi::c_int; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct cudnnConvolutionBwdFilterAlgoPerfStruct {
    pub algo: cudnnConvolutionBwdFilterAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::core::ffi::c_int; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct cudnnConvolutionFwdAlgoPerfStruct {
    pub algo: cudnnConvolutionFwdAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::core::ffi::c_int; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnConvolutionStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct cudnnDebugStruct {
    pub cudnn_version: ::core::ffi::c_uint,
    pub cudnnStatus: cudnnStatus_t,
    pub time_sec: ::core::ffi::c_uint,
    pub time_usec: ::core::ffi::c_uint,
    pub time_delta: ::core::ffi::c_uint,
    pub handle: cudnnHandle_t,
    pub stream: cudaStream_t,
    pub pid: ::core::ffi::c_ulonglong,
    pub tid: ::core::ffi::c_ulonglong,
    pub cudaDeviceId: ::core::ffi::c_int,
    pub reserved: [::core::ffi::c_int; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnDropoutStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFilterStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct cudnnFractionStruct {
    pub numerator: i64,
    pub denominator: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsConstParamStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsPlanStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsVariantParamStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnLRNStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnOpTensorStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnPoolingStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRNNDataStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRNNStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnReduceTensorStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRuntimeTag_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnSeqDataStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnSpatialTransformerStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnTensorStruct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnTensorTransformStruct {
    _unused: [u8; 0],
}
impl cudnnResampleMode_t {
    pub const CUDNN_RESAMPLE_AVGPOOL_INCLUDE_PADDING: cudnnResampleMode_t =
        cudnnResampleMode_t::CUDNN_RESAMPLE_AVGPOOL;
}
impl cudnnStatus_t {
    pub const CUDNN_STATUS_ALLOC_FAILED: cudnnStatus_t =
        cudnnStatus_t::CUDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED;
}
impl cudnnStatus_t {
    pub const CUDNN_STATUS_ARCH_MISMATCH: cudnnStatus_t =
        cudnnStatus_t::CUDNN_STATUS_NOT_SUPPORTED_ARCH_MISMATCH;
}
impl cudnnStatus_t {
    pub const CUDNN_STATUS_MAPPING_ERROR: cudnnStatus_t =
        cudnnStatus_t::CUDNN_STATUS_INTERNAL_ERROR_TEXTURE_CREATION_FAILED;
}
impl cudnnStatus_t {
    pub const CUDNN_STATUS_RUNTIME_PREREQUISITE_MISSING: cudnnStatus_t =
        cudnnStatus_t::CUDNN_STATUS_NOT_SUPPORTED_RUNTIME_PREREQUISITE_MISSING;
}
impl cudnnStatus_t {
    pub const CUDNN_STATUS_VERSION_MISMATCH: cudnnStatus_t =
        cudnnStatus_t::CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH;
}
impl Default for cudnnConvolutionBwdDataAlgoPerfStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for cudnnConvolutionBwdFilterAlgoPerfStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for cudnnConvolutionFwdAlgoPerfStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for cudnnDebugStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[cfg(not(feature = "dynamic-loading"))]
extern "C" {
    pub fn cudnnActivationBackward(
        handle: cudnnHandle_t,
        activationDesc: cudnnActivationDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnActivationForward(
        handle: cudnnHandle_t,
        activationDesc: cudnnActivationDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnAddTensor(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnAdvVersionCheck() -> cudnnStatus_t;
    pub fn cudnnBackendCreateDescriptor(
        descriptorType: cudnnBackendDescriptorType_t,
        descriptor: *mut cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnBackendDestroyDescriptor(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnBackendExecute(
        handle: cudnnHandle_t,
        executionPlan: cudnnBackendDescriptor_t,
        variantPack: cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnBackendFinalize(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnBackendGetAttribute(
        descriptor: cudnnBackendDescriptor_t,
        attributeName: cudnnBackendAttributeName_t,
        attributeType: cudnnBackendAttributeType_t,
        requestedElementCount: i64,
        elementCount: *mut i64,
        arrayOfElements: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnBackendInitialize(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnBackendPopulateCudaGraph(
        handle: cudnnHandle_t,
        executionPlan: cudnnBackendDescriptor_t,
        variantPack: cudnnBackendDescriptor_t,
        graph: cudaGraph_t,
    ) -> cudnnStatus_t;
    pub fn cudnnBackendSetAttribute(
        descriptor: cudnnBackendDescriptor_t,
        attributeName: cudnnBackendAttributeName_t,
        attributeType: cudnnBackendAttributeType_t,
        elementCount: i64,
        arrayOfElements: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnBackendUpdateCudaGraph(
        handle: cudnnHandle_t,
        executionPlan: cudnnBackendDescriptor_t,
        variantPack: cudnnBackendDescriptor_t,
        graph: cudaGraph_t,
    ) -> cudnnStatus_t;
    pub fn cudnnBatchNormalizationBackward(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        dBnScaleResult: *mut ::core::ffi::c_void,
        dBnBiasResult: *mut ::core::ffi::c_void,
        epsilon: f64,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnBatchNormalizationBackwardEx(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dyData: *const ::core::ffi::c_void,
        dzDesc: cudnnTensorDescriptor_t,
        dzData: *mut ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dxData: *mut ::core::ffi::c_void,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        bnScaleData: *const ::core::ffi::c_void,
        bnBiasData: *const ::core::ffi::c_void,
        dBnScaleData: *mut ::core::ffi::c_void,
        dBnBiasData: *mut ::core::ffi::c_void,
        epsilon: f64,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
    pub fn cudnnBatchNormalizationForwardInference(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        estimatedMean: *const ::core::ffi::c_void,
        estimatedVariance: *const ::core::ffi::c_void,
        epsilon: f64,
    ) -> cudnnStatus_t;
    pub fn cudnnBatchNormalizationForwardTraining(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnBatchNormalizationForwardTrainingEx(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        zData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
    pub fn cudnnBuildRNNDynamic(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        miniBatch: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnCTCLoss(
        handle: cudnnHandle_t,
        probsDesc: cudnnTensorDescriptor_t,
        probs: *const ::core::ffi::c_void,
        hostLabels: *const ::core::ffi::c_int,
        hostLabelLengths: *const ::core::ffi::c_int,
        hostInputLengths: *const ::core::ffi::c_int,
        costs: *mut ::core::ffi::c_void,
        gradientsDesc: cudnnTensorDescriptor_t,
        gradients: *mut ::core::ffi::c_void,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
    pub fn cudnnCTCLoss_v8(
        handle: cudnnHandle_t,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        probsDesc: cudnnTensorDescriptor_t,
        probs: *const ::core::ffi::c_void,
        labels: *const ::core::ffi::c_int,
        labelLengths: *const ::core::ffi::c_int,
        inputLengths: *const ::core::ffi::c_int,
        costs: *mut ::core::ffi::c_void,
        gradientsDesc: cudnnTensorDescriptor_t,
        gradients: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workspace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnCnnVersionCheck() -> cudnnStatus_t;
    pub fn cudnnConvolutionBackwardBias(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dbDesc: cudnnTensorDescriptor_t,
        db: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnConvolutionBackwardData(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionBwdDataAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnConvolutionBackwardFilter(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionBwdFilterAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnConvolutionBiasActivationForward(
        handle: cudnnHandle_t,
        alpha1: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        alpha2: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        z: *const ::core::ffi::c_void,
        biasDesc: cudnnTensorDescriptor_t,
        bias: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnConvolutionForward(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnCreate(handle: *mut cudnnHandle_t) -> cudnnStatus_t;
    pub fn cudnnCreateActivationDescriptor(
        activationDesc: *mut cudnnActivationDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateAttnDescriptor(attnDesc: *mut cudnnAttnDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnCreateCTCLossDescriptor(
        ctcLossDesc: *mut cudnnCTCLossDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateConvolutionDescriptor(
        convDesc: *mut cudnnConvolutionDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateDropoutDescriptor(
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateFilterDescriptor(filterDesc: *mut cudnnFilterDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnCreateFusedOpsConstParamPack(
        constPack: *mut cudnnFusedOpsConstParamPack_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateFusedOpsPlan(
        plan: *mut cudnnFusedOpsPlan_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateFusedOpsVariantParamPack(
        varPack: *mut cudnnFusedOpsVariantParamPack_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateLRNDescriptor(normDesc: *mut cudnnLRNDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnCreateOpTensorDescriptor(
        opTensorDesc: *mut cudnnOpTensorDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreatePoolingDescriptor(
        poolingDesc: *mut cudnnPoolingDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateRNNDataDescriptor(
        rnnDataDesc: *mut cudnnRNNDataDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateRNNDescriptor(rnnDesc: *mut cudnnRNNDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnCreateReduceTensorDescriptor(
        reduceTensorDesc: *mut cudnnReduceTensorDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateSeqDataDescriptor(
        seqDataDesc: *mut cudnnSeqDataDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateSpatialTransformerDescriptor(
        stDesc: *mut cudnnSpatialTransformerDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnCreateTensorDescriptor(tensorDesc: *mut cudnnTensorDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnCreateTensorTransformDescriptor(
        transformDesc: *mut cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDeriveBNTensorDescriptor(
        derivedBnDesc: cudnnTensorDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        mode: cudnnBatchNormMode_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDeriveNormTensorDescriptor(
        derivedNormScaleBiasDesc: cudnnTensorDescriptor_t,
        derivedNormMeanVarDesc: cudnnTensorDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        mode: cudnnNormMode_t,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnDestroy(handle: cudnnHandle_t) -> cudnnStatus_t;
    pub fn cudnnDestroyActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDestroyAttnDescriptor(attnDesc: cudnnAttnDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyCTCLossDescriptor(ctcLossDesc: cudnnCTCLossDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyConvolutionDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDestroyDropoutDescriptor(dropoutDesc: cudnnDropoutDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyFilterDescriptor(filterDesc: cudnnFilterDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyFusedOpsConstParamPack(
        constPack: cudnnFusedOpsConstParamPack_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDestroyFusedOpsPlan(plan: cudnnFusedOpsPlan_t) -> cudnnStatus_t;
    pub fn cudnnDestroyFusedOpsVariantParamPack(
        varPack: cudnnFusedOpsVariantParamPack_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDestroyLRNDescriptor(lrnDesc: cudnnLRNDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyOpTensorDescriptor(opTensorDesc: cudnnOpTensorDescriptor_t)
        -> cudnnStatus_t;
    pub fn cudnnDestroyPoolingDescriptor(poolingDesc: cudnnPoolingDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyRNNDataDescriptor(rnnDataDesc: cudnnRNNDataDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyRNNDescriptor(rnnDesc: cudnnRNNDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDestroySeqDataDescriptor(seqDataDesc: cudnnSeqDataDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroySpatialTransformerDescriptor(
        stDesc: cudnnSpatialTransformerDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDestroyTensorDescriptor(tensorDesc: cudnnTensorDescriptor_t) -> cudnnStatus_t;
    pub fn cudnnDestroyTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnDivisiveNormalizationBackward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        mode: cudnnDivNormMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        means: *const ::core::ffi::c_void,
        dy: *const ::core::ffi::c_void,
        temp: *mut ::core::ffi::c_void,
        temp2: *mut ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dXdMeansDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dMeans: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnDivisiveNormalizationForward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        mode: cudnnDivNormMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        means: *const ::core::ffi::c_void,
        temp: *mut ::core::ffi::c_void,
        temp2: *mut ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnDropoutBackward(
        handle: cudnnHandle_t,
        dropoutDesc: cudnnDropoutDescriptor_t,
        dydesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dxdesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
    pub fn cudnnDropoutForward(
        handle: cudnnHandle_t,
        dropoutDesc: cudnnDropoutDescriptor_t,
        xdesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        ydesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
    pub fn cudnnDropoutGetReserveSpaceSize(
        xdesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnDropoutGetStatesSize(
        handle: cudnnHandle_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnFindConvolutionBackwardDataAlgorithm(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
    ) -> cudnnStatus_t;
    pub fn cudnnFindConvolutionBackwardDataAlgorithmEx(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
    pub fn cudnnFindConvolutionBackwardFilterAlgorithm(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dwDesc: cudnnFilterDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
    ) -> cudnnStatus_t;
    pub fn cudnnFindConvolutionBackwardFilterAlgorithmEx(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
    pub fn cudnnFindConvolutionForwardAlgorithm(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
    ) -> cudnnStatus_t;
    pub fn cudnnFindConvolutionForwardAlgorithmEx(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
    pub fn cudnnFusedOpsExecute(
        handle: cudnnHandle_t,
        plan: cudnnFusedOpsPlan_t,
        varPack: cudnnFusedOpsVariantParamPack_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
        mode: *mut cudnnActivationMode_t,
        reluNanOpt: *mut cudnnNanPropagation_t,
        coef: *mut f64,
    ) -> cudnnStatus_t;
    pub fn cudnnGetActivationDescriptorSwishBeta(
        activationDesc: cudnnActivationDescriptor_t,
        swish_beta: *mut f64,
    ) -> cudnnStatus_t;
    pub fn cudnnGetAttnDescriptor(
        attnDesc: cudnnAttnDescriptor_t,
        attnMode: *mut ::core::ffi::c_uint,
        nHeads: *mut ::core::ffi::c_int,
        smScaler: *mut f64,
        dataType: *mut cudnnDataType_t,
        computePrec: *mut cudnnDataType_t,
        mathType: *mut cudnnMathType_t,
        attnDropoutDesc: *mut cudnnDropoutDescriptor_t,
        postDropoutDesc: *mut cudnnDropoutDescriptor_t,
        qSize: *mut ::core::ffi::c_int,
        kSize: *mut ::core::ffi::c_int,
        vSize: *mut ::core::ffi::c_int,
        qProjSize: *mut ::core::ffi::c_int,
        kProjSize: *mut ::core::ffi::c_int,
        vProjSize: *mut ::core::ffi::c_int,
        oProjSize: *mut ::core::ffi::c_int,
        qoMaxSeqLength: *mut ::core::ffi::c_int,
        kvMaxSeqLength: *mut ::core::ffi::c_int,
        maxBatchSize: *mut ::core::ffi::c_int,
        maxBeamSize: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetBatchNormalizationBackwardExWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        xDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        dzDesc: cudnnTensorDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        xDesc: cudnnTensorDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetBatchNormalizationTrainingExReserveSpaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        activationDesc: cudnnActivationDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetCTCLossDescriptorEx(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        gradMode: *mut cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetCTCLossDescriptor_v8(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        gradMode: *mut cudnnNanPropagation_t,
        maxLabelLength: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetCTCLossDescriptor_v9(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        ctcGradMode: *mut cudnnCTCGradMode_t,
        maxLabelLength: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetCTCLossWorkspaceSize(
        handle: cudnnHandle_t,
        probsDesc: cudnnTensorDescriptor_t,
        gradientsDesc: cudnnTensorDescriptor_t,
        labels: *const ::core::ffi::c_int,
        labelLengths: *const ::core::ffi::c_int,
        inputLengths: *const ::core::ffi::c_int,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetCTCLossWorkspaceSize_v8(
        handle: cudnnHandle_t,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        probsDesc: cudnnTensorDescriptor_t,
        gradientsDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetCallback(
        mask: *mut ::core::ffi::c_uint,
        udata: *mut *mut ::core::ffi::c_void,
        fptr: *mut cudnnCallback_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolution2dDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        pad_h: *mut ::core::ffi::c_int,
        pad_w: *mut ::core::ffi::c_int,
        u: *mut ::core::ffi::c_int,
        v: *mut ::core::ffi::c_int,
        dilation_h: *mut ::core::ffi::c_int,
        dilation_w: *mut ::core::ffi::c_int,
        mode: *mut cudnnConvolutionMode_t,
        computeType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolution2dForwardOutputDim(
        convDesc: cudnnConvolutionDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        n: *mut ::core::ffi::c_int,
        c: *mut ::core::ffi::c_int,
        h: *mut ::core::ffi::c_int,
        w: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionBackwardDataAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionBackwardDataAlgorithm_v7(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionBackwardDataWorkspaceSize(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        algo: cudnnConvolutionBwdDataAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionBackwardFilterAlgorithm_v7(
        handle: cudnnHandle_t,
        srcDesc: cudnnTensorDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnFilterDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionBackwardFilterWorkspaceSize(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnFilterDescriptor_t,
        algo: cudnnConvolutionBwdFilterAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionForwardAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionForwardAlgorithm_v7(
        handle: cudnnHandle_t,
        srcDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        destDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionForwardWorkspaceSize(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionGroupCount(
        convDesc: cudnnConvolutionDescriptor_t,
        groupCount: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionMathType(
        convDesc: cudnnConvolutionDescriptor_t,
        mathType: *mut cudnnMathType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionNdDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        arrayLengthRequested: ::core::ffi::c_int,
        arrayLength: *mut ::core::ffi::c_int,
        padA: *mut ::core::ffi::c_int,
        strideA: *mut ::core::ffi::c_int,
        dilationA: *mut ::core::ffi::c_int,
        mode: *mut cudnnConvolutionMode_t,
        computeType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionNdForwardOutputDim(
        convDesc: cudnnConvolutionDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        nbDims: ::core::ffi::c_int,
        tensorOuputDimA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetConvolutionReorderType(
        convDesc: cudnnConvolutionDescriptor_t,
        reorderType: *mut cudnnReorderType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetCudartVersion() -> usize;
    pub fn cudnnGetDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: *mut f32,
        states: *mut *mut ::core::ffi::c_void,
        seed: *mut ::core::ffi::c_ulonglong,
    ) -> cudnnStatus_t;
    pub fn cudnnGetErrorString(status: cudnnStatus_t) -> *const ::core::ffi::c_char;
    pub fn cudnnGetFilter4dDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: *mut cudnnDataType_t,
        format: *mut cudnnTensorFormat_t,
        k: *mut ::core::ffi::c_int,
        c: *mut ::core::ffi::c_int,
        h: *mut ::core::ffi::c_int,
        w: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetFilterNdDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        nbDimsRequested: ::core::ffi::c_int,
        dataType: *mut cudnnDataType_t,
        format: *mut cudnnTensorFormat_t,
        nbDims: *mut ::core::ffi::c_int,
        filterDimA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetFilterSizeInBytes(
        filterDesc: cudnnFilterDescriptor_t,
        size: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetFoldedConvBackwardDataDescriptors(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnTensorDescriptor_t,
        transformFormat: cudnnTensorFormat_t,
        foldedFilterDesc: cudnnFilterDescriptor_t,
        paddedDiffDesc: cudnnTensorDescriptor_t,
        foldedConvDesc: cudnnConvolutionDescriptor_t,
        foldedGradDesc: cudnnTensorDescriptor_t,
        filterFoldTransDesc: cudnnTensorTransformDescriptor_t,
        diffPadTransDesc: cudnnTensorTransformDescriptor_t,
        gradFoldTransDesc: cudnnTensorTransformDescriptor_t,
        gradUnfoldTransDesc: cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetFusedOpsConstParamPackAttribute(
        constPack: cudnnFusedOpsConstParamPack_t,
        paramLabel: cudnnFusedOpsConstParamLabel_t,
        param: *mut ::core::ffi::c_void,
        isNULL: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetFusedOpsVariantParamPackAttribute(
        varPack: cudnnFusedOpsVariantParamPack_t,
        paramLabel: cudnnFusedOpsVariantParamLabel_t,
        ptr: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnGetLRNDescriptor(
        normDesc: cudnnLRNDescriptor_t,
        lrnN: *mut ::core::ffi::c_uint,
        lrnAlpha: *mut f64,
        lrnBeta: *mut f64,
        lrnK: *mut f64,
    ) -> cudnnStatus_t;
    pub fn cudnnGetLastErrorString(message: *mut ::core::ffi::c_char, max_size: usize);
    pub fn cudnnGetMaxDeviceVersion() -> usize;
    pub fn cudnnGetMultiHeadAttnBuffers(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        weightSizeInBytes: *mut usize,
        workSpaceSizeInBytes: *mut usize,
        reserveSpaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetMultiHeadAttnWeights(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        wKind: cudnnMultiHeadAttnWeightKind_t,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        wDesc: cudnnTensorDescriptor_t,
        wAddr: *mut *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnGetNormalizationBackwardWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        xDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        dzDesc: cudnnTensorDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dNormScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetNormalizationForwardTrainingWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        xDesc: cudnnTensorDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetNormalizationTrainingReserveSpaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        activationDesc: cudnnActivationDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
        opTensorOp: *mut cudnnOpTensorOp_t,
        opTensorCompType: *mut cudnnDataType_t,
        opTensorNanOpt: *mut cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetPooling2dDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: *mut cudnnPoolingMode_t,
        maxpoolingNanOpt: *mut cudnnNanPropagation_t,
        windowHeight: *mut ::core::ffi::c_int,
        windowWidth: *mut ::core::ffi::c_int,
        verticalPadding: *mut ::core::ffi::c_int,
        horizontalPadding: *mut ::core::ffi::c_int,
        verticalStride: *mut ::core::ffi::c_int,
        horizontalStride: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetPooling2dForwardOutputDim(
        poolingDesc: cudnnPoolingDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        n: *mut ::core::ffi::c_int,
        c: *mut ::core::ffi::c_int,
        h: *mut ::core::ffi::c_int,
        w: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetPoolingNdDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        nbDimsRequested: ::core::ffi::c_int,
        mode: *mut cudnnPoolingMode_t,
        maxpoolingNanOpt: *mut cudnnNanPropagation_t,
        nbDims: *mut ::core::ffi::c_int,
        windowDimA: *mut ::core::ffi::c_int,
        paddingA: *mut ::core::ffi::c_int,
        strideA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetPoolingNdForwardOutputDim(
        poolingDesc: cudnnPoolingDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        nbDims: ::core::ffi::c_int,
        outputTensorDimA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetProperty(
        type_: libraryPropertyType,
        value: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
        dataType: *mut cudnnDataType_t,
        layout: *mut cudnnRNNDataLayout_t,
        maxSeqLength: *mut ::core::ffi::c_int,
        batchSize: *mut ::core::ffi::c_int,
        vectorSize: *mut ::core::ffi::c_int,
        arrayLengthRequested: ::core::ffi::c_int,
        seqLengthArray: *mut ::core::ffi::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnGetRNNDescriptor_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        algo: *mut cudnnRNNAlgo_t,
        cellMode: *mut cudnnRNNMode_t,
        biasMode: *mut cudnnRNNBiasMode_t,
        dirMode: *mut cudnnDirectionMode_t,
        inputMode: *mut cudnnRNNInputMode_t,
        dataType: *mut cudnnDataType_t,
        mathPrec: *mut cudnnDataType_t,
        mathType: *mut cudnnMathType_t,
        inputSize: *mut i32,
        hiddenSize: *mut i32,
        projSize: *mut i32,
        numLayers: *mut i32,
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
        auxFlags: *mut u32,
    ) -> cudnnStatus_t;
    pub fn cudnnGetRNNTempSpaceSizes(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        fwdMode: cudnnForwardMode_t,
        xDesc: cudnnRNNDataDescriptor_t,
        workSpaceSize: *mut usize,
        reserveSpaceSize: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetRNNWeightParams(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        pseudoLayer: i32,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        linLayerID: i32,
        mDesc: cudnnTensorDescriptor_t,
        mAddr: *mut *mut ::core::ffi::c_void,
        bDesc: cudnnTensorDescriptor_t,
        bAddr: *mut *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnGetRNNWeightSpaceSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        weightSpaceSize: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        reduceTensorOp: *mut cudnnReduceTensorOp_t,
        reduceTensorCompType: *mut cudnnDataType_t,
        reduceTensorNanOpt: *mut cudnnNanPropagation_t,
        reduceTensorIndices: *mut cudnnReduceTensorIndices_t,
        reduceTensorIndicesType: *mut cudnnIndicesType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetReductionIndicesSize(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        aDesc: cudnnTensorDescriptor_t,
        cDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetReductionWorkspaceSize(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        aDesc: cudnnTensorDescriptor_t,
        cDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetSeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
        dataType: *mut cudnnDataType_t,
        nbDims: *mut ::core::ffi::c_int,
        nbDimsRequested: ::core::ffi::c_int,
        dimA: *mut ::core::ffi::c_int,
        axes: *mut cudnnSeqDataAxis_t,
        seqLengthArraySize: *mut usize,
        seqLengthSizeRequested: usize,
        seqLengthArray: *mut ::core::ffi::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnGetStream(handle: cudnnHandle_t, streamId: *mut cudaStream_t) -> cudnnStatus_t;
    pub fn cudnnGetTensor4dDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: *mut cudnnDataType_t,
        n: *mut ::core::ffi::c_int,
        c: *mut ::core::ffi::c_int,
        h: *mut ::core::ffi::c_int,
        w: *mut ::core::ffi::c_int,
        nStride: *mut ::core::ffi::c_int,
        cStride: *mut ::core::ffi::c_int,
        hStride: *mut ::core::ffi::c_int,
        wStride: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetTensorNdDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        nbDimsRequested: ::core::ffi::c_int,
        dataType: *mut cudnnDataType_t,
        nbDims: *mut ::core::ffi::c_int,
        dimA: *mut ::core::ffi::c_int,
        strideA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnGetTensorSizeInBytes(
        tensorDesc: cudnnTensorDescriptor_t,
        size: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnGetTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
        nbDimsRequested: u32,
        destFormat: *mut cudnnTensorFormat_t,
        padBeforeA: *mut i32,
        padAfterA: *mut i32,
        foldA: *mut u32,
        direction: *mut cudnnFoldingDirection_t,
    ) -> cudnnStatus_t;
    pub fn cudnnGetVersion() -> usize;
    pub fn cudnnGraphVersionCheck() -> cudnnStatus_t;
    pub fn cudnnIm2Col(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        colBuffer: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnInitTransformDest(
        transformDesc: cudnnTensorTransformDescriptor_t,
        srcDesc: cudnnTensorDescriptor_t,
        destDesc: cudnnTensorDescriptor_t,
        destSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnLRNCrossChannelBackward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        lrnMode: cudnnLRNMode_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnLRNCrossChannelForward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        lrnMode: cudnnLRNMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnMakeFusedOpsPlan(
        handle: cudnnHandle_t,
        plan: cudnnFusedOpsPlan_t,
        constPack: cudnnFusedOpsConstParamPack_t,
        workspaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
    pub fn cudnnMultiHeadAttnBackwardData(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        loWinIdx: *const ::core::ffi::c_int,
        hiWinIdx: *const ::core::ffi::c_int,
        devSeqLengthsDQDO: *const ::core::ffi::c_int,
        devSeqLengthsDKDV: *const ::core::ffi::c_int,
        doDesc: cudnnSeqDataDescriptor_t,
        dout: *const ::core::ffi::c_void,
        dqDesc: cudnnSeqDataDescriptor_t,
        dqueries: *mut ::core::ffi::c_void,
        queries: *const ::core::ffi::c_void,
        dkDesc: cudnnSeqDataDescriptor_t,
        dkeys: *mut ::core::ffi::c_void,
        keys: *const ::core::ffi::c_void,
        dvDesc: cudnnSeqDataDescriptor_t,
        dvalues: *mut ::core::ffi::c_void,
        values: *const ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnMultiHeadAttnBackwardWeights(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        addGrad: cudnnWgradMode_t,
        qDesc: cudnnSeqDataDescriptor_t,
        queries: *const ::core::ffi::c_void,
        kDesc: cudnnSeqDataDescriptor_t,
        keys: *const ::core::ffi::c_void,
        vDesc: cudnnSeqDataDescriptor_t,
        values: *const ::core::ffi::c_void,
        doDesc: cudnnSeqDataDescriptor_t,
        dout: *const ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        dweights: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnMultiHeadAttnForward(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        currIdx: ::core::ffi::c_int,
        loWinIdx: *const ::core::ffi::c_int,
        hiWinIdx: *const ::core::ffi::c_int,
        devSeqLengthsQO: *const ::core::ffi::c_int,
        devSeqLengthsKV: *const ::core::ffi::c_int,
        qDesc: cudnnSeqDataDescriptor_t,
        queries: *const ::core::ffi::c_void,
        residuals: *const ::core::ffi::c_void,
        kDesc: cudnnSeqDataDescriptor_t,
        keys: *const ::core::ffi::c_void,
        vDesc: cudnnSeqDataDescriptor_t,
        values: *const ::core::ffi::c_void,
        oDesc: cudnnSeqDataDescriptor_t,
        out: *mut ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnNormalizationBackward(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dyData: *const ::core::ffi::c_void,
        dzDesc: cudnnTensorDescriptor_t,
        dzData: *mut ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dxData: *mut ::core::ffi::c_void,
        dNormScaleBiasDesc: cudnnTensorDescriptor_t,
        normScaleData: *const ::core::ffi::c_void,
        normBiasData: *const ::core::ffi::c_void,
        dNormScaleData: *mut ::core::ffi::c_void,
        dNormBiasData: *mut ::core::ffi::c_void,
        epsilon: f64,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnNormalizationForwardInference(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        normScale: *const ::core::ffi::c_void,
        normBias: *const ::core::ffi::c_void,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        estimatedMean: *const ::core::ffi::c_void,
        estimatedVariance: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        z: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        epsilon: f64,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnNormalizationForwardTraining(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        normScale: *const ::core::ffi::c_void,
        normBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        zData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *mut ::core::ffi::c_void,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnOpTensor(
        handle: cudnnHandle_t,
        opTensorDesc: cudnnOpTensorDescriptor_t,
        alpha1: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        alpha2: *const ::core::ffi::c_void,
        bDesc: cudnnTensorDescriptor_t,
        B: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnOpsVersionCheck() -> cudnnStatus_t;
    pub fn cudnnPoolingBackward(
        handle: cudnnHandle_t,
        poolingDesc: cudnnPoolingDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnPoolingForward(
        handle: cudnnHandle_t,
        poolingDesc: cudnnPoolingDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnQueryRuntimeError(
        handle: cudnnHandle_t,
        rstatus: *mut cudnnStatus_t,
        mode: cudnnErrQueryMode_t,
        tag: *mut cudnnRuntimeTag_t,
    ) -> cudnnStatus_t;
    pub fn cudnnRNNBackwardData_v8(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        devSeqLengths: *const i32,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::core::ffi::c_void,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnRNNDataDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        dhy: *const ::core::ffi::c_void,
        dhx: *mut ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        dcy: *const ::core::ffi::c_void,
        dcx: *mut ::core::ffi::c_void,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnRNNBackwardWeights_v8(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        addGrad: cudnnWgradMode_t,
        devSeqLengths: *const i32,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::core::ffi::c_void,
        weightSpaceSize: usize,
        dweightSpace: *mut ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnRNNForward(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        fwdMode: cudnnForwardMode_t,
        devSeqLengths: *const i32,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        hy: *mut ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        cy: *mut ::core::ffi::c_void,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnRNNGetClip_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: *mut cudnnRNNClipMode_t,
        clipNanOpt: *mut cudnnNanPropagation_t,
        lclip: *mut f64,
        rclip: *mut f64,
    ) -> cudnnStatus_t;
    pub fn cudnnRNNGetClip_v9(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: *mut cudnnRNNClipMode_t,
        lclip: *mut f64,
        rclip: *mut f64,
    ) -> cudnnStatus_t;
    pub fn cudnnRNNSetClip_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: cudnnRNNClipMode_t,
        clipNanOpt: cudnnNanPropagation_t,
        lclip: f64,
        rclip: f64,
    ) -> cudnnStatus_t;
    pub fn cudnnRNNSetClip_v9(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: cudnnRNNClipMode_t,
        lclip: f64,
        rclip: f64,
    ) -> cudnnStatus_t;
    pub fn cudnnReduceTensor(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        indices: *mut ::core::ffi::c_void,
        indicesSizeInBytes: usize,
        workspace: *mut ::core::ffi::c_void,
        workspaceSizeInBytes: usize,
        alpha: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnReorderFilterAndBias(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        reorderType: cudnnReorderType_t,
        filterData: *const ::core::ffi::c_void,
        reorderedFilterData: *mut ::core::ffi::c_void,
        reorderBias: ::core::ffi::c_int,
        biasData: *const ::core::ffi::c_void,
        reorderedBiasData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnRestoreDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: f32,
        states: *mut ::core::ffi::c_void,
        stateSizeInBytes: usize,
        seed: ::core::ffi::c_ulonglong,
    ) -> cudnnStatus_t;
    pub fn cudnnScaleTensor(
        handle: cudnnHandle_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        alpha: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSetActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
        mode: cudnnActivationMode_t,
        reluNanOpt: cudnnNanPropagation_t,
        coef: f64,
    ) -> cudnnStatus_t;
    pub fn cudnnSetActivationDescriptorSwishBeta(
        activationDesc: cudnnActivationDescriptor_t,
        swish_beta: f64,
    ) -> cudnnStatus_t;
    pub fn cudnnSetAttnDescriptor(
        attnDesc: cudnnAttnDescriptor_t,
        attnMode: ::core::ffi::c_uint,
        nHeads: ::core::ffi::c_int,
        smScaler: f64,
        dataType: cudnnDataType_t,
        computePrec: cudnnDataType_t,
        mathType: cudnnMathType_t,
        attnDropoutDesc: cudnnDropoutDescriptor_t,
        postDropoutDesc: cudnnDropoutDescriptor_t,
        qSize: ::core::ffi::c_int,
        kSize: ::core::ffi::c_int,
        vSize: ::core::ffi::c_int,
        qProjSize: ::core::ffi::c_int,
        kProjSize: ::core::ffi::c_int,
        vProjSize: ::core::ffi::c_int,
        oProjSize: ::core::ffi::c_int,
        qoMaxSeqLength: ::core::ffi::c_int,
        kvMaxSeqLength: ::core::ffi::c_int,
        maxBatchSize: ::core::ffi::c_int,
        maxBeamSize: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetCTCLossDescriptorEx(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        gradMode: cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetCTCLossDescriptor_v8(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        gradMode: cudnnNanPropagation_t,
        maxLabelLength: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetCTCLossDescriptor_v9(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        ctcGradMode: cudnnCTCGradMode_t,
        maxLabelLength: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetCallback(
        mask: ::core::ffi::c_uint,
        udata: *mut ::core::ffi::c_void,
        fptr: cudnnCallback_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetConvolution2dDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        pad_h: ::core::ffi::c_int,
        pad_w: ::core::ffi::c_int,
        u: ::core::ffi::c_int,
        v: ::core::ffi::c_int,
        dilation_h: ::core::ffi::c_int,
        dilation_w: ::core::ffi::c_int,
        mode: cudnnConvolutionMode_t,
        computeType: cudnnDataType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetConvolutionGroupCount(
        convDesc: cudnnConvolutionDescriptor_t,
        groupCount: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetConvolutionMathType(
        convDesc: cudnnConvolutionDescriptor_t,
        mathType: cudnnMathType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetConvolutionNdDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        arrayLength: ::core::ffi::c_int,
        padA: *const ::core::ffi::c_int,
        filterStrideA: *const ::core::ffi::c_int,
        dilationA: *const ::core::ffi::c_int,
        mode: cudnnConvolutionMode_t,
        computeType: cudnnDataType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetConvolutionReorderType(
        convDesc: cudnnConvolutionDescriptor_t,
        reorderType: cudnnReorderType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: f32,
        states: *mut ::core::ffi::c_void,
        stateSizeInBytes: usize,
        seed: ::core::ffi::c_ulonglong,
    ) -> cudnnStatus_t;
    pub fn cudnnSetFilter4dDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: cudnnDataType_t,
        format: cudnnTensorFormat_t,
        k: ::core::ffi::c_int,
        c: ::core::ffi::c_int,
        h: ::core::ffi::c_int,
        w: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetFilterNdDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: cudnnDataType_t,
        format: cudnnTensorFormat_t,
        nbDims: ::core::ffi::c_int,
        filterDimA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetFusedOpsConstParamPackAttribute(
        constPack: cudnnFusedOpsConstParamPack_t,
        paramLabel: cudnnFusedOpsConstParamLabel_t,
        param: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSetFusedOpsVariantParamPackAttribute(
        varPack: cudnnFusedOpsVariantParamPack_t,
        paramLabel: cudnnFusedOpsVariantParamLabel_t,
        ptr: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSetLRNDescriptor(
        normDesc: cudnnLRNDescriptor_t,
        lrnN: ::core::ffi::c_uint,
        lrnAlpha: f64,
        lrnBeta: f64,
        lrnK: f64,
    ) -> cudnnStatus_t;
    pub fn cudnnSetOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
        opTensorOp: cudnnOpTensorOp_t,
        opTensorCompType: cudnnDataType_t,
        opTensorNanOpt: cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetPooling2dDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: cudnnPoolingMode_t,
        maxpoolingNanOpt: cudnnNanPropagation_t,
        windowHeight: ::core::ffi::c_int,
        windowWidth: ::core::ffi::c_int,
        verticalPadding: ::core::ffi::c_int,
        horizontalPadding: ::core::ffi::c_int,
        verticalStride: ::core::ffi::c_int,
        horizontalStride: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetPoolingNdDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: cudnnPoolingMode_t,
        maxpoolingNanOpt: cudnnNanPropagation_t,
        nbDims: ::core::ffi::c_int,
        windowDimA: *const ::core::ffi::c_int,
        paddingA: *const ::core::ffi::c_int,
        strideA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
        dataType: cudnnDataType_t,
        layout: cudnnRNNDataLayout_t,
        maxSeqLength: ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
        vectorSize: ::core::ffi::c_int,
        seqLengthArray: *const ::core::ffi::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSetRNNDescriptor_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        algo: cudnnRNNAlgo_t,
        cellMode: cudnnRNNMode_t,
        biasMode: cudnnRNNBiasMode_t,
        dirMode: cudnnDirectionMode_t,
        inputMode: cudnnRNNInputMode_t,
        dataType: cudnnDataType_t,
        mathPrec: cudnnDataType_t,
        mathType: cudnnMathType_t,
        inputSize: i32,
        hiddenSize: i32,
        projSize: i32,
        numLayers: i32,
        dropoutDesc: cudnnDropoutDescriptor_t,
        auxFlags: u32,
    ) -> cudnnStatus_t;
    pub fn cudnnSetReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        reduceTensorOp: cudnnReduceTensorOp_t,
        reduceTensorCompType: cudnnDataType_t,
        reduceTensorNanOpt: cudnnNanPropagation_t,
        reduceTensorIndices: cudnnReduceTensorIndices_t,
        reduceTensorIndicesType: cudnnIndicesType_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSetSeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
        dataType: cudnnDataType_t,
        nbDims: ::core::ffi::c_int,
        dimA: *const ::core::ffi::c_int,
        axes: *const cudnnSeqDataAxis_t,
        seqLengthArraySize: usize,
        seqLengthArray: *const ::core::ffi::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSetSpatialTransformerNdDescriptor(
        stDesc: cudnnSpatialTransformerDescriptor_t,
        samplerType: cudnnSamplerType_t,
        dataType: cudnnDataType_t,
        nbDims: ::core::ffi::c_int,
        dimA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetStream(handle: cudnnHandle_t, streamId: cudaStream_t) -> cudnnStatus_t;
    pub fn cudnnSetTensor(
        handle: cudnnHandle_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        valuePtr: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSetTensor4dDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        format: cudnnTensorFormat_t,
        dataType: cudnnDataType_t,
        n: ::core::ffi::c_int,
        c: ::core::ffi::c_int,
        h: ::core::ffi::c_int,
        w: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetTensor4dDescriptorEx(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: cudnnDataType_t,
        n: ::core::ffi::c_int,
        c: ::core::ffi::c_int,
        h: ::core::ffi::c_int,
        w: ::core::ffi::c_int,
        nStride: ::core::ffi::c_int,
        cStride: ::core::ffi::c_int,
        hStride: ::core::ffi::c_int,
        wStride: ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetTensorNdDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: cudnnDataType_t,
        nbDims: ::core::ffi::c_int,
        dimA: *const ::core::ffi::c_int,
        strideA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetTensorNdDescriptorEx(
        tensorDesc: cudnnTensorDescriptor_t,
        format: cudnnTensorFormat_t,
        dataType: cudnnDataType_t,
        nbDims: ::core::ffi::c_int,
        dimA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t;
    pub fn cudnnSetTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
        nbDims: u32,
        destFormat: cudnnTensorFormat_t,
        padBeforeA: *const i32,
        padAfterA: *const i32,
        foldA: *const u32,
        direction: cudnnFoldingDirection_t,
    ) -> cudnnStatus_t;
    pub fn cudnnSoftmaxBackward(
        handle: cudnnHandle_t,
        algo: cudnnSoftmaxAlgorithm_t,
        mode: cudnnSoftmaxMode_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSoftmaxForward(
        handle: cudnnHandle_t,
        algo: cudnnSoftmaxAlgorithm_t,
        mode: cudnnSoftmaxMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSpatialTfGridGeneratorBackward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        dgrid: *const ::core::ffi::c_void,
        dtheta: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSpatialTfGridGeneratorForward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        theta: *const ::core::ffi::c_void,
        grid: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSpatialTfSamplerBackward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        alphaDgrid: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        grid: *const ::core::ffi::c_void,
        betaDgrid: *const ::core::ffi::c_void,
        dgrid: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnSpatialTfSamplerForward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        grid: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnTransformFilter(
        handle: cudnnHandle_t,
        transDesc: cudnnTensorTransformDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        srcDesc: cudnnFilterDescriptor_t,
        srcData: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        destDesc: cudnnFilterDescriptor_t,
        destData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnTransformTensor(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
    pub fn cudnnTransformTensorEx(
        handle: cudnnHandle_t,
        transDesc: cudnnTensorTransformDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        srcDesc: cudnnTensorDescriptor_t,
        srcData: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        destDesc: cudnnTensorDescriptor_t,
        destData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[cfg(feature = "dynamic-loading")]
mod loaded {
    use super::*;
    pub unsafe fn cudnnActivationBackward(
        handle: cudnnHandle_t,
        activationDesc: cudnnActivationDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnActivationBackward)(
            handle,
            activationDesc,
            alpha,
            yDesc,
            y,
            dyDesc,
            dy,
            xDesc,
            x,
            beta,
            dxDesc,
            dx,
        )
    }
    pub unsafe fn cudnnActivationForward(
        handle: cudnnHandle_t,
        activationDesc: cudnnActivationDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnActivationForward)(handle, activationDesc, alpha, xDesc, x, beta, yDesc, y)
    }
    pub unsafe fn cudnnAddTensor(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnAddTensor)(handle, alpha, aDesc, A, beta, cDesc, C)
    }
    pub unsafe fn cudnnAdvVersionCheck() -> cudnnStatus_t {
        (culib().cudnnAdvVersionCheck)()
    }
    pub unsafe fn cudnnBackendCreateDescriptor(
        descriptorType: cudnnBackendDescriptorType_t,
        descriptor: *mut cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnBackendCreateDescriptor)(descriptorType, descriptor)
    }
    pub unsafe fn cudnnBackendDestroyDescriptor(
        descriptor: cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnBackendDestroyDescriptor)(descriptor)
    }
    pub unsafe fn cudnnBackendExecute(
        handle: cudnnHandle_t,
        executionPlan: cudnnBackendDescriptor_t,
        variantPack: cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnBackendExecute)(handle, executionPlan, variantPack)
    }
    pub unsafe fn cudnnBackendFinalize(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t {
        (culib().cudnnBackendFinalize)(descriptor)
    }
    pub unsafe fn cudnnBackendGetAttribute(
        descriptor: cudnnBackendDescriptor_t,
        attributeName: cudnnBackendAttributeName_t,
        attributeType: cudnnBackendAttributeType_t,
        requestedElementCount: i64,
        elementCount: *mut i64,
        arrayOfElements: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnBackendGetAttribute)(
            descriptor,
            attributeName,
            attributeType,
            requestedElementCount,
            elementCount,
            arrayOfElements,
        )
    }
    pub unsafe fn cudnnBackendInitialize(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t {
        (culib().cudnnBackendInitialize)(descriptor)
    }
    pub unsafe fn cudnnBackendPopulateCudaGraph(
        handle: cudnnHandle_t,
        executionPlan: cudnnBackendDescriptor_t,
        variantPack: cudnnBackendDescriptor_t,
        graph: cudaGraph_t,
    ) -> cudnnStatus_t {
        (culib().cudnnBackendPopulateCudaGraph)(handle, executionPlan, variantPack, graph)
    }
    pub unsafe fn cudnnBackendSetAttribute(
        descriptor: cudnnBackendDescriptor_t,
        attributeName: cudnnBackendAttributeName_t,
        attributeType: cudnnBackendAttributeType_t,
        elementCount: i64,
        arrayOfElements: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnBackendSetAttribute)(
            descriptor,
            attributeName,
            attributeType,
            elementCount,
            arrayOfElements,
        )
    }
    pub unsafe fn cudnnBackendUpdateCudaGraph(
        handle: cudnnHandle_t,
        executionPlan: cudnnBackendDescriptor_t,
        variantPack: cudnnBackendDescriptor_t,
        graph: cudaGraph_t,
    ) -> cudnnStatus_t {
        (culib().cudnnBackendUpdateCudaGraph)(handle, executionPlan, variantPack, graph)
    }
    pub unsafe fn cudnnBatchNormalizationBackward(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        dBnScaleResult: *mut ::core::ffi::c_void,
        dBnBiasResult: *mut ::core::ffi::c_void,
        epsilon: f64,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnBatchNormalizationBackward)(
            handle,
            mode,
            alphaDataDiff,
            betaDataDiff,
            alphaParamDiff,
            betaParamDiff,
            xDesc,
            x,
            dyDesc,
            dy,
            dxDesc,
            dx,
            dBnScaleBiasDesc,
            bnScale,
            dBnScaleResult,
            dBnBiasResult,
            epsilon,
            savedMean,
            savedInvVariance,
        )
    }
    pub unsafe fn cudnnBatchNormalizationBackwardEx(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dyData: *const ::core::ffi::c_void,
        dzDesc: cudnnTensorDescriptor_t,
        dzData: *mut ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dxData: *mut ::core::ffi::c_void,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        bnScaleData: *const ::core::ffi::c_void,
        bnBiasData: *const ::core::ffi::c_void,
        dBnScaleData: *mut ::core::ffi::c_void,
        dBnBiasData: *mut ::core::ffi::c_void,
        epsilon: f64,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t {
        (culib().cudnnBatchNormalizationBackwardEx)(
            handle,
            mode,
            bnOps,
            alphaDataDiff,
            betaDataDiff,
            alphaParamDiff,
            betaParamDiff,
            xDesc,
            xData,
            yDesc,
            yData,
            dyDesc,
            dyData,
            dzDesc,
            dzData,
            dxDesc,
            dxData,
            dBnScaleBiasDesc,
            bnScaleData,
            bnBiasData,
            dBnScaleData,
            dBnBiasData,
            epsilon,
            savedMean,
            savedInvVariance,
            activationDesc,
            workSpace,
            workSpaceSizeInBytes,
            reserveSpace,
            reserveSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnBatchNormalizationForwardInference(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        estimatedMean: *const ::core::ffi::c_void,
        estimatedVariance: *const ::core::ffi::c_void,
        epsilon: f64,
    ) -> cudnnStatus_t {
        (culib().cudnnBatchNormalizationForwardInference)(
            handle,
            mode,
            alpha,
            beta,
            xDesc,
            x,
            yDesc,
            y,
            bnScaleBiasMeanVarDesc,
            bnScale,
            bnBias,
            estimatedMean,
            estimatedVariance,
            epsilon,
        )
    }
    pub unsafe fn cudnnBatchNormalizationForwardTraining(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnBatchNormalizationForwardTraining)(
            handle,
            mode,
            alpha,
            beta,
            xDesc,
            x,
            yDesc,
            y,
            bnScaleBiasMeanVarDesc,
            bnScale,
            bnBias,
            exponentialAverageFactor,
            resultRunningMean,
            resultRunningVariance,
            epsilon,
            resultSaveMean,
            resultSaveInvVariance,
        )
    }
    pub unsafe fn cudnnBatchNormalizationForwardTrainingEx(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        zData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t {
        (culib().cudnnBatchNormalizationForwardTrainingEx)(
            handle,
            mode,
            bnOps,
            alpha,
            beta,
            xDesc,
            xData,
            zDesc,
            zData,
            yDesc,
            yData,
            bnScaleBiasMeanVarDesc,
            bnScale,
            bnBias,
            exponentialAverageFactor,
            resultRunningMean,
            resultRunningVariance,
            epsilon,
            resultSaveMean,
            resultSaveInvVariance,
            activationDesc,
            workspace,
            workSpaceSizeInBytes,
            reserveSpace,
            reserveSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnBuildRNNDynamic(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        miniBatch: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnBuildRNNDynamic)(handle, rnnDesc, miniBatch)
    }
    pub unsafe fn cudnnCTCLoss(
        handle: cudnnHandle_t,
        probsDesc: cudnnTensorDescriptor_t,
        probs: *const ::core::ffi::c_void,
        hostLabels: *const ::core::ffi::c_int,
        hostLabelLengths: *const ::core::ffi::c_int,
        hostInputLengths: *const ::core::ffi::c_int,
        costs: *mut ::core::ffi::c_void,
        gradientsDesc: cudnnTensorDescriptor_t,
        gradients: *mut ::core::ffi::c_void,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t {
        (culib().cudnnCTCLoss)(
            handle,
            probsDesc,
            probs,
            hostLabels,
            hostLabelLengths,
            hostInputLengths,
            costs,
            gradientsDesc,
            gradients,
            algo,
            ctcLossDesc,
            workspace,
            workSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnCTCLoss_v8(
        handle: cudnnHandle_t,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        probsDesc: cudnnTensorDescriptor_t,
        probs: *const ::core::ffi::c_void,
        labels: *const ::core::ffi::c_int,
        labelLengths: *const ::core::ffi::c_int,
        inputLengths: *const ::core::ffi::c_int,
        costs: *mut ::core::ffi::c_void,
        gradientsDesc: cudnnTensorDescriptor_t,
        gradients: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workspace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnCTCLoss_v8)(
            handle,
            algo,
            ctcLossDesc,
            probsDesc,
            probs,
            labels,
            labelLengths,
            inputLengths,
            costs,
            gradientsDesc,
            gradients,
            workSpaceSizeInBytes,
            workspace,
        )
    }
    pub unsafe fn cudnnCnnVersionCheck() -> cudnnStatus_t {
        (culib().cudnnCnnVersionCheck)()
    }
    pub unsafe fn cudnnConvolutionBackwardBias(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dbDesc: cudnnTensorDescriptor_t,
        db: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnConvolutionBackwardBias)(handle, alpha, dyDesc, dy, beta, dbDesc, db)
    }
    pub unsafe fn cudnnConvolutionBackwardData(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionBwdDataAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnConvolutionBackwardData)(
            handle,
            alpha,
            wDesc,
            w,
            dyDesc,
            dy,
            convDesc,
            algo,
            workSpace,
            workSpaceSizeInBytes,
            beta,
            dxDesc,
            dx,
        )
    }
    pub unsafe fn cudnnConvolutionBackwardFilter(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionBwdFilterAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnConvolutionBackwardFilter)(
            handle,
            alpha,
            xDesc,
            x,
            dyDesc,
            dy,
            convDesc,
            algo,
            workSpace,
            workSpaceSizeInBytes,
            beta,
            dwDesc,
            dw,
        )
    }
    pub unsafe fn cudnnConvolutionBiasActivationForward(
        handle: cudnnHandle_t,
        alpha1: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        alpha2: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        z: *const ::core::ffi::c_void,
        biasDesc: cudnnTensorDescriptor_t,
        bias: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnConvolutionBiasActivationForward)(
            handle,
            alpha1,
            xDesc,
            x,
            wDesc,
            w,
            convDesc,
            algo,
            workSpace,
            workSpaceSizeInBytes,
            alpha2,
            zDesc,
            z,
            biasDesc,
            bias,
            activationDesc,
            yDesc,
            y,
        )
    }
    pub unsafe fn cudnnConvolutionForward(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnConvolutionForward)(
            handle,
            alpha,
            xDesc,
            x,
            wDesc,
            w,
            convDesc,
            algo,
            workSpace,
            workSpaceSizeInBytes,
            beta,
            yDesc,
            y,
        )
    }
    pub unsafe fn cudnnCreate(handle: *mut cudnnHandle_t) -> cudnnStatus_t {
        (culib().cudnnCreate)(handle)
    }
    pub unsafe fn cudnnCreateActivationDescriptor(
        activationDesc: *mut cudnnActivationDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateActivationDescriptor)(activationDesc)
    }
    pub unsafe fn cudnnCreateAttnDescriptor(attnDesc: *mut cudnnAttnDescriptor_t) -> cudnnStatus_t {
        (culib().cudnnCreateAttnDescriptor)(attnDesc)
    }
    pub unsafe fn cudnnCreateCTCLossDescriptor(
        ctcLossDesc: *mut cudnnCTCLossDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateCTCLossDescriptor)(ctcLossDesc)
    }
    pub unsafe fn cudnnCreateConvolutionDescriptor(
        convDesc: *mut cudnnConvolutionDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateConvolutionDescriptor)(convDesc)
    }
    pub unsafe fn cudnnCreateDropoutDescriptor(
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateDropoutDescriptor)(dropoutDesc)
    }
    pub unsafe fn cudnnCreateFilterDescriptor(
        filterDesc: *mut cudnnFilterDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateFilterDescriptor)(filterDesc)
    }
    pub unsafe fn cudnnCreateFusedOpsConstParamPack(
        constPack: *mut cudnnFusedOpsConstParamPack_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateFusedOpsConstParamPack)(constPack, ops)
    }
    pub unsafe fn cudnnCreateFusedOpsPlan(
        plan: *mut cudnnFusedOpsPlan_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateFusedOpsPlan)(plan, ops)
    }
    pub unsafe fn cudnnCreateFusedOpsVariantParamPack(
        varPack: *mut cudnnFusedOpsVariantParamPack_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateFusedOpsVariantParamPack)(varPack, ops)
    }
    pub unsafe fn cudnnCreateLRNDescriptor(normDesc: *mut cudnnLRNDescriptor_t) -> cudnnStatus_t {
        (culib().cudnnCreateLRNDescriptor)(normDesc)
    }
    pub unsafe fn cudnnCreateOpTensorDescriptor(
        opTensorDesc: *mut cudnnOpTensorDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateOpTensorDescriptor)(opTensorDesc)
    }
    pub unsafe fn cudnnCreatePoolingDescriptor(
        poolingDesc: *mut cudnnPoolingDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreatePoolingDescriptor)(poolingDesc)
    }
    pub unsafe fn cudnnCreateRNNDataDescriptor(
        rnnDataDesc: *mut cudnnRNNDataDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateRNNDataDescriptor)(rnnDataDesc)
    }
    pub unsafe fn cudnnCreateRNNDescriptor(rnnDesc: *mut cudnnRNNDescriptor_t) -> cudnnStatus_t {
        (culib().cudnnCreateRNNDescriptor)(rnnDesc)
    }
    pub unsafe fn cudnnCreateReduceTensorDescriptor(
        reduceTensorDesc: *mut cudnnReduceTensorDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateReduceTensorDescriptor)(reduceTensorDesc)
    }
    pub unsafe fn cudnnCreateSeqDataDescriptor(
        seqDataDesc: *mut cudnnSeqDataDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateSeqDataDescriptor)(seqDataDesc)
    }
    pub unsafe fn cudnnCreateSpatialTransformerDescriptor(
        stDesc: *mut cudnnSpatialTransformerDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateSpatialTransformerDescriptor)(stDesc)
    }
    pub unsafe fn cudnnCreateTensorDescriptor(
        tensorDesc: *mut cudnnTensorDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateTensorDescriptor)(tensorDesc)
    }
    pub unsafe fn cudnnCreateTensorTransformDescriptor(
        transformDesc: *mut cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnCreateTensorTransformDescriptor)(transformDesc)
    }
    pub unsafe fn cudnnDeriveBNTensorDescriptor(
        derivedBnDesc: cudnnTensorDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        mode: cudnnBatchNormMode_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDeriveBNTensorDescriptor)(derivedBnDesc, xDesc, mode)
    }
    pub unsafe fn cudnnDeriveNormTensorDescriptor(
        derivedNormScaleBiasDesc: cudnnTensorDescriptor_t,
        derivedNormMeanVarDesc: cudnnTensorDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        mode: cudnnNormMode_t,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnDeriveNormTensorDescriptor)(
            derivedNormScaleBiasDesc,
            derivedNormMeanVarDesc,
            xDesc,
            mode,
            groupCnt,
        )
    }
    pub unsafe fn cudnnDestroy(handle: cudnnHandle_t) -> cudnnStatus_t {
        (culib().cudnnDestroy)(handle)
    }
    pub unsafe fn cudnnDestroyActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyActivationDescriptor)(activationDesc)
    }
    pub unsafe fn cudnnDestroyAttnDescriptor(attnDesc: cudnnAttnDescriptor_t) -> cudnnStatus_t {
        (culib().cudnnDestroyAttnDescriptor)(attnDesc)
    }
    pub unsafe fn cudnnDestroyCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyCTCLossDescriptor)(ctcLossDesc)
    }
    pub unsafe fn cudnnDestroyConvolutionDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyConvolutionDescriptor)(convDesc)
    }
    pub unsafe fn cudnnDestroyDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyDropoutDescriptor)(dropoutDesc)
    }
    pub unsafe fn cudnnDestroyFilterDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyFilterDescriptor)(filterDesc)
    }
    pub unsafe fn cudnnDestroyFusedOpsConstParamPack(
        constPack: cudnnFusedOpsConstParamPack_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyFusedOpsConstParamPack)(constPack)
    }
    pub unsafe fn cudnnDestroyFusedOpsPlan(plan: cudnnFusedOpsPlan_t) -> cudnnStatus_t {
        (culib().cudnnDestroyFusedOpsPlan)(plan)
    }
    pub unsafe fn cudnnDestroyFusedOpsVariantParamPack(
        varPack: cudnnFusedOpsVariantParamPack_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyFusedOpsVariantParamPack)(varPack)
    }
    pub unsafe fn cudnnDestroyLRNDescriptor(lrnDesc: cudnnLRNDescriptor_t) -> cudnnStatus_t {
        (culib().cudnnDestroyLRNDescriptor)(lrnDesc)
    }
    pub unsafe fn cudnnDestroyOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyOpTensorDescriptor)(opTensorDesc)
    }
    pub unsafe fn cudnnDestroyPoolingDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyPoolingDescriptor)(poolingDesc)
    }
    pub unsafe fn cudnnDestroyRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyRNNDataDescriptor)(rnnDataDesc)
    }
    pub unsafe fn cudnnDestroyRNNDescriptor(rnnDesc: cudnnRNNDescriptor_t) -> cudnnStatus_t {
        (culib().cudnnDestroyRNNDescriptor)(rnnDesc)
    }
    pub unsafe fn cudnnDestroyReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyReduceTensorDescriptor)(reduceTensorDesc)
    }
    pub unsafe fn cudnnDestroySeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroySeqDataDescriptor)(seqDataDesc)
    }
    pub unsafe fn cudnnDestroySpatialTransformerDescriptor(
        stDesc: cudnnSpatialTransformerDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroySpatialTransformerDescriptor)(stDesc)
    }
    pub unsafe fn cudnnDestroyTensorDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyTensorDescriptor)(tensorDesc)
    }
    pub unsafe fn cudnnDestroyTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnDestroyTensorTransformDescriptor)(transformDesc)
    }
    pub unsafe fn cudnnDivisiveNormalizationBackward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        mode: cudnnDivNormMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        means: *const ::core::ffi::c_void,
        dy: *const ::core::ffi::c_void,
        temp: *mut ::core::ffi::c_void,
        temp2: *mut ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dXdMeansDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dMeans: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnDivisiveNormalizationBackward)(
            handle,
            normDesc,
            mode,
            alpha,
            xDesc,
            x,
            means,
            dy,
            temp,
            temp2,
            beta,
            dXdMeansDesc,
            dx,
            dMeans,
        )
    }
    pub unsafe fn cudnnDivisiveNormalizationForward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        mode: cudnnDivNormMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        means: *const ::core::ffi::c_void,
        temp: *mut ::core::ffi::c_void,
        temp2: *mut ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnDivisiveNormalizationForward)(
            handle, normDesc, mode, alpha, xDesc, x, means, temp, temp2, beta, yDesc, y,
        )
    }
    pub unsafe fn cudnnDropoutBackward(
        handle: cudnnHandle_t,
        dropoutDesc: cudnnDropoutDescriptor_t,
        dydesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dxdesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t {
        (culib().cudnnDropoutBackward)(
            handle,
            dropoutDesc,
            dydesc,
            dy,
            dxdesc,
            dx,
            reserveSpace,
            reserveSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnDropoutForward(
        handle: cudnnHandle_t,
        dropoutDesc: cudnnDropoutDescriptor_t,
        xdesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        ydesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t {
        (culib().cudnnDropoutForward)(
            handle,
            dropoutDesc,
            xdesc,
            x,
            ydesc,
            y,
            reserveSpace,
            reserveSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnDropoutGetReserveSpaceSize(
        xdesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnDropoutGetReserveSpaceSize)(xdesc, sizeInBytes)
    }
    pub unsafe fn cudnnDropoutGetStatesSize(
        handle: cudnnHandle_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnDropoutGetStatesSize)(handle, sizeInBytes)
    }
    pub unsafe fn cudnnFindConvolutionBackwardDataAlgorithm(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
    ) -> cudnnStatus_t {
        (culib().cudnnFindConvolutionBackwardDataAlgorithm)(
            handle,
            wDesc,
            dyDesc,
            convDesc,
            dxDesc,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
        )
    }
    pub unsafe fn cudnnFindConvolutionBackwardDataAlgorithmEx(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t {
        (culib().cudnnFindConvolutionBackwardDataAlgorithmEx)(
            handle,
            wDesc,
            w,
            dyDesc,
            dy,
            convDesc,
            dxDesc,
            dx,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
            workSpace,
            workSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnFindConvolutionBackwardFilterAlgorithm(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dwDesc: cudnnFilterDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
    ) -> cudnnStatus_t {
        (culib().cudnnFindConvolutionBackwardFilterAlgorithm)(
            handle,
            xDesc,
            dyDesc,
            convDesc,
            dwDesc,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
        )
    }
    pub unsafe fn cudnnFindConvolutionBackwardFilterAlgorithmEx(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t {
        (culib().cudnnFindConvolutionBackwardFilterAlgorithmEx)(
            handle,
            xDesc,
            x,
            dyDesc,
            y,
            convDesc,
            dwDesc,
            dw,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
            workSpace,
            workSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnFindConvolutionForwardAlgorithm(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
    ) -> cudnnStatus_t {
        (culib().cudnnFindConvolutionForwardAlgorithm)(
            handle,
            xDesc,
            wDesc,
            convDesc,
            yDesc,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
        )
    }
    pub unsafe fn cudnnFindConvolutionForwardAlgorithmEx(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t {
        (culib().cudnnFindConvolutionForwardAlgorithmEx)(
            handle,
            xDesc,
            x,
            wDesc,
            w,
            convDesc,
            yDesc,
            y,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
            workSpace,
            workSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnFusedOpsExecute(
        handle: cudnnHandle_t,
        plan: cudnnFusedOpsPlan_t,
        varPack: cudnnFusedOpsVariantParamPack_t,
    ) -> cudnnStatus_t {
        (culib().cudnnFusedOpsExecute)(handle, plan, varPack)
    }
    pub unsafe fn cudnnGetActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
        mode: *mut cudnnActivationMode_t,
        reluNanOpt: *mut cudnnNanPropagation_t,
        coef: *mut f64,
    ) -> cudnnStatus_t {
        (culib().cudnnGetActivationDescriptor)(activationDesc, mode, reluNanOpt, coef)
    }
    pub unsafe fn cudnnGetActivationDescriptorSwishBeta(
        activationDesc: cudnnActivationDescriptor_t,
        swish_beta: *mut f64,
    ) -> cudnnStatus_t {
        (culib().cudnnGetActivationDescriptorSwishBeta)(activationDesc, swish_beta)
    }
    pub unsafe fn cudnnGetAttnDescriptor(
        attnDesc: cudnnAttnDescriptor_t,
        attnMode: *mut ::core::ffi::c_uint,
        nHeads: *mut ::core::ffi::c_int,
        smScaler: *mut f64,
        dataType: *mut cudnnDataType_t,
        computePrec: *mut cudnnDataType_t,
        mathType: *mut cudnnMathType_t,
        attnDropoutDesc: *mut cudnnDropoutDescriptor_t,
        postDropoutDesc: *mut cudnnDropoutDescriptor_t,
        qSize: *mut ::core::ffi::c_int,
        kSize: *mut ::core::ffi::c_int,
        vSize: *mut ::core::ffi::c_int,
        qProjSize: *mut ::core::ffi::c_int,
        kProjSize: *mut ::core::ffi::c_int,
        vProjSize: *mut ::core::ffi::c_int,
        oProjSize: *mut ::core::ffi::c_int,
        qoMaxSeqLength: *mut ::core::ffi::c_int,
        kvMaxSeqLength: *mut ::core::ffi::c_int,
        maxBatchSize: *mut ::core::ffi::c_int,
        maxBeamSize: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetAttnDescriptor)(
            attnDesc,
            attnMode,
            nHeads,
            smScaler,
            dataType,
            computePrec,
            mathType,
            attnDropoutDesc,
            postDropoutDesc,
            qSize,
            kSize,
            vSize,
            qProjSize,
            kProjSize,
            vProjSize,
            oProjSize,
            qoMaxSeqLength,
            kvMaxSeqLength,
            maxBatchSize,
            maxBeamSize,
        )
    }
    pub unsafe fn cudnnGetBatchNormalizationBackwardExWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        xDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        dzDesc: cudnnTensorDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetBatchNormalizationBackwardExWorkspaceSize)(
            handle,
            mode,
            bnOps,
            xDesc,
            yDesc,
            dyDesc,
            dzDesc,
            dxDesc,
            dBnScaleBiasDesc,
            activationDesc,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        xDesc: cudnnTensorDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize)(
            handle,
            mode,
            bnOps,
            xDesc,
            zDesc,
            yDesc,
            bnScaleBiasMeanVarDesc,
            activationDesc,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetBatchNormalizationTrainingExReserveSpaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        activationDesc: cudnnActivationDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetBatchNormalizationTrainingExReserveSpaceSize)(
            handle,
            mode,
            bnOps,
            activationDesc,
            xDesc,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetCTCLossDescriptor)(ctcLossDesc, compType)
    }
    pub unsafe fn cudnnGetCTCLossDescriptorEx(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        gradMode: *mut cudnnNanPropagation_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetCTCLossDescriptorEx)(ctcLossDesc, compType, normMode, gradMode)
    }
    pub unsafe fn cudnnGetCTCLossDescriptor_v8(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        gradMode: *mut cudnnNanPropagation_t,
        maxLabelLength: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetCTCLossDescriptor_v8)(
            ctcLossDesc,
            compType,
            normMode,
            gradMode,
            maxLabelLength,
        )
    }
    pub unsafe fn cudnnGetCTCLossDescriptor_v9(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        ctcGradMode: *mut cudnnCTCGradMode_t,
        maxLabelLength: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetCTCLossDescriptor_v9)(
            ctcLossDesc,
            compType,
            normMode,
            ctcGradMode,
            maxLabelLength,
        )
    }
    pub unsafe fn cudnnGetCTCLossWorkspaceSize(
        handle: cudnnHandle_t,
        probsDesc: cudnnTensorDescriptor_t,
        gradientsDesc: cudnnTensorDescriptor_t,
        labels: *const ::core::ffi::c_int,
        labelLengths: *const ::core::ffi::c_int,
        inputLengths: *const ::core::ffi::c_int,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetCTCLossWorkspaceSize)(
            handle,
            probsDesc,
            gradientsDesc,
            labels,
            labelLengths,
            inputLengths,
            algo,
            ctcLossDesc,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetCTCLossWorkspaceSize_v8(
        handle: cudnnHandle_t,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        probsDesc: cudnnTensorDescriptor_t,
        gradientsDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetCTCLossWorkspaceSize_v8)(
            handle,
            algo,
            ctcLossDesc,
            probsDesc,
            gradientsDesc,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetCallback(
        mask: *mut ::core::ffi::c_uint,
        udata: *mut *mut ::core::ffi::c_void,
        fptr: *mut cudnnCallback_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetCallback)(mask, udata, fptr)
    }
    pub unsafe fn cudnnGetConvolution2dDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        pad_h: *mut ::core::ffi::c_int,
        pad_w: *mut ::core::ffi::c_int,
        u: *mut ::core::ffi::c_int,
        v: *mut ::core::ffi::c_int,
        dilation_h: *mut ::core::ffi::c_int,
        dilation_w: *mut ::core::ffi::c_int,
        mode: *mut cudnnConvolutionMode_t,
        computeType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolution2dDescriptor)(
            convDesc,
            pad_h,
            pad_w,
            u,
            v,
            dilation_h,
            dilation_w,
            mode,
            computeType,
        )
    }
    pub unsafe fn cudnnGetConvolution2dForwardOutputDim(
        convDesc: cudnnConvolutionDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        n: *mut ::core::ffi::c_int,
        c: *mut ::core::ffi::c_int,
        h: *mut ::core::ffi::c_int,
        w: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolution2dForwardOutputDim)(
            convDesc,
            inputTensorDesc,
            filterDesc,
            n,
            c,
            h,
            w,
        )
    }
    pub unsafe fn cudnnGetConvolutionBackwardDataAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionBackwardDataAlgorithmMaxCount)(handle, count)
    }
    pub unsafe fn cudnnGetConvolutionBackwardDataAlgorithm_v7(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionBackwardDataAlgorithm_v7)(
            handle,
            filterDesc,
            diffDesc,
            convDesc,
            gradDesc,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
        )
    }
    pub unsafe fn cudnnGetConvolutionBackwardDataWorkspaceSize(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        algo: cudnnConvolutionBwdDataAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionBackwardDataWorkspaceSize)(
            handle,
            wDesc,
            dyDesc,
            convDesc,
            dxDesc,
            algo,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionBackwardFilterAlgorithmMaxCount)(handle, count)
    }
    pub unsafe fn cudnnGetConvolutionBackwardFilterAlgorithm_v7(
        handle: cudnnHandle_t,
        srcDesc: cudnnTensorDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnFilterDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionBackwardFilterAlgorithm_v7)(
            handle,
            srcDesc,
            diffDesc,
            convDesc,
            gradDesc,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
        )
    }
    pub unsafe fn cudnnGetConvolutionBackwardFilterWorkspaceSize(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnFilterDescriptor_t,
        algo: cudnnConvolutionBwdFilterAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionBackwardFilterWorkspaceSize)(
            handle,
            xDesc,
            dyDesc,
            convDesc,
            gradDesc,
            algo,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetConvolutionForwardAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionForwardAlgorithmMaxCount)(handle, count)
    }
    pub unsafe fn cudnnGetConvolutionForwardAlgorithm_v7(
        handle: cudnnHandle_t,
        srcDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        destDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::core::ffi::c_int,
        returnedAlgoCount: *mut ::core::ffi::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionForwardAlgorithm_v7)(
            handle,
            srcDesc,
            filterDesc,
            convDesc,
            destDesc,
            requestedAlgoCount,
            returnedAlgoCount,
            perfResults,
        )
    }
    pub unsafe fn cudnnGetConvolutionForwardWorkspaceSize(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionForwardWorkspaceSize)(
            handle,
            xDesc,
            wDesc,
            convDesc,
            yDesc,
            algo,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetConvolutionGroupCount(
        convDesc: cudnnConvolutionDescriptor_t,
        groupCount: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionGroupCount)(convDesc, groupCount)
    }
    pub unsafe fn cudnnGetConvolutionMathType(
        convDesc: cudnnConvolutionDescriptor_t,
        mathType: *mut cudnnMathType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionMathType)(convDesc, mathType)
    }
    pub unsafe fn cudnnGetConvolutionNdDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        arrayLengthRequested: ::core::ffi::c_int,
        arrayLength: *mut ::core::ffi::c_int,
        padA: *mut ::core::ffi::c_int,
        strideA: *mut ::core::ffi::c_int,
        dilationA: *mut ::core::ffi::c_int,
        mode: *mut cudnnConvolutionMode_t,
        computeType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionNdDescriptor)(
            convDesc,
            arrayLengthRequested,
            arrayLength,
            padA,
            strideA,
            dilationA,
            mode,
            computeType,
        )
    }
    pub unsafe fn cudnnGetConvolutionNdForwardOutputDim(
        convDesc: cudnnConvolutionDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        nbDims: ::core::ffi::c_int,
        tensorOuputDimA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionNdForwardOutputDim)(
            convDesc,
            inputTensorDesc,
            filterDesc,
            nbDims,
            tensorOuputDimA,
        )
    }
    pub unsafe fn cudnnGetConvolutionReorderType(
        convDesc: cudnnConvolutionDescriptor_t,
        reorderType: *mut cudnnReorderType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetConvolutionReorderType)(convDesc, reorderType)
    }
    pub unsafe fn cudnnGetCudartVersion() -> usize {
        (culib().cudnnGetCudartVersion)()
    }
    pub unsafe fn cudnnGetDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: *mut f32,
        states: *mut *mut ::core::ffi::c_void,
        seed: *mut ::core::ffi::c_ulonglong,
    ) -> cudnnStatus_t {
        (culib().cudnnGetDropoutDescriptor)(dropoutDesc, handle, dropout, states, seed)
    }
    pub unsafe fn cudnnGetErrorString(status: cudnnStatus_t) -> *const ::core::ffi::c_char {
        (culib().cudnnGetErrorString)(status)
    }
    pub unsafe fn cudnnGetFilter4dDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: *mut cudnnDataType_t,
        format: *mut cudnnTensorFormat_t,
        k: *mut ::core::ffi::c_int,
        c: *mut ::core::ffi::c_int,
        h: *mut ::core::ffi::c_int,
        w: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetFilter4dDescriptor)(filterDesc, dataType, format, k, c, h, w)
    }
    pub unsafe fn cudnnGetFilterNdDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        nbDimsRequested: ::core::ffi::c_int,
        dataType: *mut cudnnDataType_t,
        format: *mut cudnnTensorFormat_t,
        nbDims: *mut ::core::ffi::c_int,
        filterDimA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetFilterNdDescriptor)(
            filterDesc,
            nbDimsRequested,
            dataType,
            format,
            nbDims,
            filterDimA,
        )
    }
    pub unsafe fn cudnnGetFilterSizeInBytes(
        filterDesc: cudnnFilterDescriptor_t,
        size: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetFilterSizeInBytes)(filterDesc, size)
    }
    pub unsafe fn cudnnGetFoldedConvBackwardDataDescriptors(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnTensorDescriptor_t,
        transformFormat: cudnnTensorFormat_t,
        foldedFilterDesc: cudnnFilterDescriptor_t,
        paddedDiffDesc: cudnnTensorDescriptor_t,
        foldedConvDesc: cudnnConvolutionDescriptor_t,
        foldedGradDesc: cudnnTensorDescriptor_t,
        filterFoldTransDesc: cudnnTensorTransformDescriptor_t,
        diffPadTransDesc: cudnnTensorTransformDescriptor_t,
        gradFoldTransDesc: cudnnTensorTransformDescriptor_t,
        gradUnfoldTransDesc: cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetFoldedConvBackwardDataDescriptors)(
            handle,
            filterDesc,
            diffDesc,
            convDesc,
            gradDesc,
            transformFormat,
            foldedFilterDesc,
            paddedDiffDesc,
            foldedConvDesc,
            foldedGradDesc,
            filterFoldTransDesc,
            diffPadTransDesc,
            gradFoldTransDesc,
            gradUnfoldTransDesc,
        )
    }
    pub unsafe fn cudnnGetFusedOpsConstParamPackAttribute(
        constPack: cudnnFusedOpsConstParamPack_t,
        paramLabel: cudnnFusedOpsConstParamLabel_t,
        param: *mut ::core::ffi::c_void,
        isNULL: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetFusedOpsConstParamPackAttribute)(constPack, paramLabel, param, isNULL)
    }
    pub unsafe fn cudnnGetFusedOpsVariantParamPackAttribute(
        varPack: cudnnFusedOpsVariantParamPack_t,
        paramLabel: cudnnFusedOpsVariantParamLabel_t,
        ptr: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnGetFusedOpsVariantParamPackAttribute)(varPack, paramLabel, ptr)
    }
    pub unsafe fn cudnnGetLRNDescriptor(
        normDesc: cudnnLRNDescriptor_t,
        lrnN: *mut ::core::ffi::c_uint,
        lrnAlpha: *mut f64,
        lrnBeta: *mut f64,
        lrnK: *mut f64,
    ) -> cudnnStatus_t {
        (culib().cudnnGetLRNDescriptor)(normDesc, lrnN, lrnAlpha, lrnBeta, lrnK)
    }
    pub unsafe fn cudnnGetLastErrorString(message: *mut ::core::ffi::c_char, max_size: usize) {
        (culib().cudnnGetLastErrorString)(message, max_size)
    }
    pub unsafe fn cudnnGetMaxDeviceVersion() -> usize {
        (culib().cudnnGetMaxDeviceVersion)()
    }
    pub unsafe fn cudnnGetMultiHeadAttnBuffers(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        weightSizeInBytes: *mut usize,
        workSpaceSizeInBytes: *mut usize,
        reserveSpaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetMultiHeadAttnBuffers)(
            handle,
            attnDesc,
            weightSizeInBytes,
            workSpaceSizeInBytes,
            reserveSpaceSizeInBytes,
        )
    }
    pub unsafe fn cudnnGetMultiHeadAttnWeights(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        wKind: cudnnMultiHeadAttnWeightKind_t,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        wDesc: cudnnTensorDescriptor_t,
        wAddr: *mut *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnGetMultiHeadAttnWeights)(
            handle,
            attnDesc,
            wKind,
            weightSizeInBytes,
            weights,
            wDesc,
            wAddr,
        )
    }
    pub unsafe fn cudnnGetNormalizationBackwardWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        xDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        dzDesc: cudnnTensorDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dNormScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetNormalizationBackwardWorkspaceSize)(
            handle,
            mode,
            normOps,
            algo,
            xDesc,
            yDesc,
            dyDesc,
            dzDesc,
            dxDesc,
            dNormScaleBiasDesc,
            activationDesc,
            normMeanVarDesc,
            sizeInBytes,
            groupCnt,
        )
    }
    pub unsafe fn cudnnGetNormalizationForwardTrainingWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        xDesc: cudnnTensorDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetNormalizationForwardTrainingWorkspaceSize)(
            handle,
            mode,
            normOps,
            algo,
            xDesc,
            zDesc,
            yDesc,
            normScaleBiasDesc,
            activationDesc,
            normMeanVarDesc,
            sizeInBytes,
            groupCnt,
        )
    }
    pub unsafe fn cudnnGetNormalizationTrainingReserveSpaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        activationDesc: cudnnActivationDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetNormalizationTrainingReserveSpaceSize)(
            handle,
            mode,
            normOps,
            algo,
            activationDesc,
            xDesc,
            sizeInBytes,
            groupCnt,
        )
    }
    pub unsafe fn cudnnGetOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
        opTensorOp: *mut cudnnOpTensorOp_t,
        opTensorCompType: *mut cudnnDataType_t,
        opTensorNanOpt: *mut cudnnNanPropagation_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetOpTensorDescriptor)(
            opTensorDesc,
            opTensorOp,
            opTensorCompType,
            opTensorNanOpt,
        )
    }
    pub unsafe fn cudnnGetPooling2dDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: *mut cudnnPoolingMode_t,
        maxpoolingNanOpt: *mut cudnnNanPropagation_t,
        windowHeight: *mut ::core::ffi::c_int,
        windowWidth: *mut ::core::ffi::c_int,
        verticalPadding: *mut ::core::ffi::c_int,
        horizontalPadding: *mut ::core::ffi::c_int,
        verticalStride: *mut ::core::ffi::c_int,
        horizontalStride: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetPooling2dDescriptor)(
            poolingDesc,
            mode,
            maxpoolingNanOpt,
            windowHeight,
            windowWidth,
            verticalPadding,
            horizontalPadding,
            verticalStride,
            horizontalStride,
        )
    }
    pub unsafe fn cudnnGetPooling2dForwardOutputDim(
        poolingDesc: cudnnPoolingDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        n: *mut ::core::ffi::c_int,
        c: *mut ::core::ffi::c_int,
        h: *mut ::core::ffi::c_int,
        w: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetPooling2dForwardOutputDim)(poolingDesc, inputTensorDesc, n, c, h, w)
    }
    pub unsafe fn cudnnGetPoolingNdDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        nbDimsRequested: ::core::ffi::c_int,
        mode: *mut cudnnPoolingMode_t,
        maxpoolingNanOpt: *mut cudnnNanPropagation_t,
        nbDims: *mut ::core::ffi::c_int,
        windowDimA: *mut ::core::ffi::c_int,
        paddingA: *mut ::core::ffi::c_int,
        strideA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetPoolingNdDescriptor)(
            poolingDesc,
            nbDimsRequested,
            mode,
            maxpoolingNanOpt,
            nbDims,
            windowDimA,
            paddingA,
            strideA,
        )
    }
    pub unsafe fn cudnnGetPoolingNdForwardOutputDim(
        poolingDesc: cudnnPoolingDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        nbDims: ::core::ffi::c_int,
        outputTensorDimA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetPoolingNdForwardOutputDim)(
            poolingDesc,
            inputTensorDesc,
            nbDims,
            outputTensorDimA,
        )
    }
    pub unsafe fn cudnnGetProperty(
        type_: libraryPropertyType,
        value: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetProperty)(type_, value)
    }
    pub unsafe fn cudnnGetRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
        dataType: *mut cudnnDataType_t,
        layout: *mut cudnnRNNDataLayout_t,
        maxSeqLength: *mut ::core::ffi::c_int,
        batchSize: *mut ::core::ffi::c_int,
        vectorSize: *mut ::core::ffi::c_int,
        arrayLengthRequested: ::core::ffi::c_int,
        seqLengthArray: *mut ::core::ffi::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnGetRNNDataDescriptor)(
            rnnDataDesc,
            dataType,
            layout,
            maxSeqLength,
            batchSize,
            vectorSize,
            arrayLengthRequested,
            seqLengthArray,
            paddingFill,
        )
    }
    pub unsafe fn cudnnGetRNNDescriptor_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        algo: *mut cudnnRNNAlgo_t,
        cellMode: *mut cudnnRNNMode_t,
        biasMode: *mut cudnnRNNBiasMode_t,
        dirMode: *mut cudnnDirectionMode_t,
        inputMode: *mut cudnnRNNInputMode_t,
        dataType: *mut cudnnDataType_t,
        mathPrec: *mut cudnnDataType_t,
        mathType: *mut cudnnMathType_t,
        inputSize: *mut i32,
        hiddenSize: *mut i32,
        projSize: *mut i32,
        numLayers: *mut i32,
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
        auxFlags: *mut u32,
    ) -> cudnnStatus_t {
        (culib().cudnnGetRNNDescriptor_v8)(
            rnnDesc,
            algo,
            cellMode,
            biasMode,
            dirMode,
            inputMode,
            dataType,
            mathPrec,
            mathType,
            inputSize,
            hiddenSize,
            projSize,
            numLayers,
            dropoutDesc,
            auxFlags,
        )
    }
    pub unsafe fn cudnnGetRNNTempSpaceSizes(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        fwdMode: cudnnForwardMode_t,
        xDesc: cudnnRNNDataDescriptor_t,
        workSpaceSize: *mut usize,
        reserveSpaceSize: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetRNNTempSpaceSizes)(
            handle,
            rnnDesc,
            fwdMode,
            xDesc,
            workSpaceSize,
            reserveSpaceSize,
        )
    }
    pub unsafe fn cudnnGetRNNWeightParams(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        pseudoLayer: i32,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        linLayerID: i32,
        mDesc: cudnnTensorDescriptor_t,
        mAddr: *mut *mut ::core::ffi::c_void,
        bDesc: cudnnTensorDescriptor_t,
        bAddr: *mut *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnGetRNNWeightParams)(
            handle,
            rnnDesc,
            pseudoLayer,
            weightSpaceSize,
            weightSpace,
            linLayerID,
            mDesc,
            mAddr,
            bDesc,
            bAddr,
        )
    }
    pub unsafe fn cudnnGetRNNWeightSpaceSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        weightSpaceSize: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetRNNWeightSpaceSize)(handle, rnnDesc, weightSpaceSize)
    }
    pub unsafe fn cudnnGetReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        reduceTensorOp: *mut cudnnReduceTensorOp_t,
        reduceTensorCompType: *mut cudnnDataType_t,
        reduceTensorNanOpt: *mut cudnnNanPropagation_t,
        reduceTensorIndices: *mut cudnnReduceTensorIndices_t,
        reduceTensorIndicesType: *mut cudnnIndicesType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetReduceTensorDescriptor)(
            reduceTensorDesc,
            reduceTensorOp,
            reduceTensorCompType,
            reduceTensorNanOpt,
            reduceTensorIndices,
            reduceTensorIndicesType,
        )
    }
    pub unsafe fn cudnnGetReductionIndicesSize(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        aDesc: cudnnTensorDescriptor_t,
        cDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetReductionIndicesSize)(handle, reduceTensorDesc, aDesc, cDesc, sizeInBytes)
    }
    pub unsafe fn cudnnGetReductionWorkspaceSize(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        aDesc: cudnnTensorDescriptor_t,
        cDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetReductionWorkspaceSize)(
            handle,
            reduceTensorDesc,
            aDesc,
            cDesc,
            sizeInBytes,
        )
    }
    pub unsafe fn cudnnGetSeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
        dataType: *mut cudnnDataType_t,
        nbDims: *mut ::core::ffi::c_int,
        nbDimsRequested: ::core::ffi::c_int,
        dimA: *mut ::core::ffi::c_int,
        axes: *mut cudnnSeqDataAxis_t,
        seqLengthArraySize: *mut usize,
        seqLengthSizeRequested: usize,
        seqLengthArray: *mut ::core::ffi::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnGetSeqDataDescriptor)(
            seqDataDesc,
            dataType,
            nbDims,
            nbDimsRequested,
            dimA,
            axes,
            seqLengthArraySize,
            seqLengthSizeRequested,
            seqLengthArray,
            paddingFill,
        )
    }
    pub unsafe fn cudnnGetStream(
        handle: cudnnHandle_t,
        streamId: *mut cudaStream_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetStream)(handle, streamId)
    }
    pub unsafe fn cudnnGetTensor4dDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: *mut cudnnDataType_t,
        n: *mut ::core::ffi::c_int,
        c: *mut ::core::ffi::c_int,
        h: *mut ::core::ffi::c_int,
        w: *mut ::core::ffi::c_int,
        nStride: *mut ::core::ffi::c_int,
        cStride: *mut ::core::ffi::c_int,
        hStride: *mut ::core::ffi::c_int,
        wStride: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetTensor4dDescriptor)(
            tensorDesc, dataType, n, c, h, w, nStride, cStride, hStride, wStride,
        )
    }
    pub unsafe fn cudnnGetTensorNdDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        nbDimsRequested: ::core::ffi::c_int,
        dataType: *mut cudnnDataType_t,
        nbDims: *mut ::core::ffi::c_int,
        dimA: *mut ::core::ffi::c_int,
        strideA: *mut ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnGetTensorNdDescriptor)(
            tensorDesc,
            nbDimsRequested,
            dataType,
            nbDims,
            dimA,
            strideA,
        )
    }
    pub unsafe fn cudnnGetTensorSizeInBytes(
        tensorDesc: cudnnTensorDescriptor_t,
        size: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnGetTensorSizeInBytes)(tensorDesc, size)
    }
    pub unsafe fn cudnnGetTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
        nbDimsRequested: u32,
        destFormat: *mut cudnnTensorFormat_t,
        padBeforeA: *mut i32,
        padAfterA: *mut i32,
        foldA: *mut u32,
        direction: *mut cudnnFoldingDirection_t,
    ) -> cudnnStatus_t {
        (culib().cudnnGetTensorTransformDescriptor)(
            transformDesc,
            nbDimsRequested,
            destFormat,
            padBeforeA,
            padAfterA,
            foldA,
            direction,
        )
    }
    pub unsafe fn cudnnGetVersion() -> usize {
        (culib().cudnnGetVersion)()
    }
    pub unsafe fn cudnnGraphVersionCheck() -> cudnnStatus_t {
        (culib().cudnnGraphVersionCheck)()
    }
    pub unsafe fn cudnnIm2Col(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        colBuffer: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnIm2Col)(handle, xDesc, x, wDesc, convDesc, colBuffer)
    }
    pub unsafe fn cudnnInitTransformDest(
        transformDesc: cudnnTensorTransformDescriptor_t,
        srcDesc: cudnnTensorDescriptor_t,
        destDesc: cudnnTensorDescriptor_t,
        destSizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnInitTransformDest)(transformDesc, srcDesc, destDesc, destSizeInBytes)
    }
    pub unsafe fn cudnnLRNCrossChannelBackward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        lrnMode: cudnnLRNMode_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnLRNCrossChannelBackward)(
            handle, normDesc, lrnMode, alpha, yDesc, y, dyDesc, dy, xDesc, x, beta, dxDesc, dx,
        )
    }
    pub unsafe fn cudnnLRNCrossChannelForward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        lrnMode: cudnnLRNMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnLRNCrossChannelForward)(
            handle, normDesc, lrnMode, alpha, xDesc, x, beta, yDesc, y,
        )
    }
    pub unsafe fn cudnnMakeFusedOpsPlan(
        handle: cudnnHandle_t,
        plan: cudnnFusedOpsPlan_t,
        constPack: cudnnFusedOpsConstParamPack_t,
        workspaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t {
        (culib().cudnnMakeFusedOpsPlan)(handle, plan, constPack, workspaceSizeInBytes)
    }
    pub unsafe fn cudnnMultiHeadAttnBackwardData(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        loWinIdx: *const ::core::ffi::c_int,
        hiWinIdx: *const ::core::ffi::c_int,
        devSeqLengthsDQDO: *const ::core::ffi::c_int,
        devSeqLengthsDKDV: *const ::core::ffi::c_int,
        doDesc: cudnnSeqDataDescriptor_t,
        dout: *const ::core::ffi::c_void,
        dqDesc: cudnnSeqDataDescriptor_t,
        dqueries: *mut ::core::ffi::c_void,
        queries: *const ::core::ffi::c_void,
        dkDesc: cudnnSeqDataDescriptor_t,
        dkeys: *mut ::core::ffi::c_void,
        keys: *const ::core::ffi::c_void,
        dvDesc: cudnnSeqDataDescriptor_t,
        dvalues: *mut ::core::ffi::c_void,
        values: *const ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnMultiHeadAttnBackwardData)(
            handle,
            attnDesc,
            loWinIdx,
            hiWinIdx,
            devSeqLengthsDQDO,
            devSeqLengthsDKDV,
            doDesc,
            dout,
            dqDesc,
            dqueries,
            queries,
            dkDesc,
            dkeys,
            keys,
            dvDesc,
            dvalues,
            values,
            weightSizeInBytes,
            weights,
            workSpaceSizeInBytes,
            workSpace,
            reserveSpaceSizeInBytes,
            reserveSpace,
        )
    }
    pub unsafe fn cudnnMultiHeadAttnBackwardWeights(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        addGrad: cudnnWgradMode_t,
        qDesc: cudnnSeqDataDescriptor_t,
        queries: *const ::core::ffi::c_void,
        kDesc: cudnnSeqDataDescriptor_t,
        keys: *const ::core::ffi::c_void,
        vDesc: cudnnSeqDataDescriptor_t,
        values: *const ::core::ffi::c_void,
        doDesc: cudnnSeqDataDescriptor_t,
        dout: *const ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        dweights: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnMultiHeadAttnBackwardWeights)(
            handle,
            attnDesc,
            addGrad,
            qDesc,
            queries,
            kDesc,
            keys,
            vDesc,
            values,
            doDesc,
            dout,
            weightSizeInBytes,
            weights,
            dweights,
            workSpaceSizeInBytes,
            workSpace,
            reserveSpaceSizeInBytes,
            reserveSpace,
        )
    }
    pub unsafe fn cudnnMultiHeadAttnForward(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        currIdx: ::core::ffi::c_int,
        loWinIdx: *const ::core::ffi::c_int,
        hiWinIdx: *const ::core::ffi::c_int,
        devSeqLengthsQO: *const ::core::ffi::c_int,
        devSeqLengthsKV: *const ::core::ffi::c_int,
        qDesc: cudnnSeqDataDescriptor_t,
        queries: *const ::core::ffi::c_void,
        residuals: *const ::core::ffi::c_void,
        kDesc: cudnnSeqDataDescriptor_t,
        keys: *const ::core::ffi::c_void,
        vDesc: cudnnSeqDataDescriptor_t,
        values: *const ::core::ffi::c_void,
        oDesc: cudnnSeqDataDescriptor_t,
        out: *mut ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnMultiHeadAttnForward)(
            handle,
            attnDesc,
            currIdx,
            loWinIdx,
            hiWinIdx,
            devSeqLengthsQO,
            devSeqLengthsKV,
            qDesc,
            queries,
            residuals,
            kDesc,
            keys,
            vDesc,
            values,
            oDesc,
            out,
            weightSizeInBytes,
            weights,
            workSpaceSizeInBytes,
            workSpace,
            reserveSpaceSizeInBytes,
            reserveSpace,
        )
    }
    pub unsafe fn cudnnNormalizationBackward(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dyData: *const ::core::ffi::c_void,
        dzDesc: cudnnTensorDescriptor_t,
        dzData: *mut ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dxData: *mut ::core::ffi::c_void,
        dNormScaleBiasDesc: cudnnTensorDescriptor_t,
        normScaleData: *const ::core::ffi::c_void,
        normBiasData: *const ::core::ffi::c_void,
        dNormScaleData: *mut ::core::ffi::c_void,
        dNormBiasData: *mut ::core::ffi::c_void,
        epsilon: f64,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnNormalizationBackward)(
            handle,
            mode,
            normOps,
            algo,
            alphaDataDiff,
            betaDataDiff,
            alphaParamDiff,
            betaParamDiff,
            xDesc,
            xData,
            yDesc,
            yData,
            dyDesc,
            dyData,
            dzDesc,
            dzData,
            dxDesc,
            dxData,
            dNormScaleBiasDesc,
            normScaleData,
            normBiasData,
            dNormScaleData,
            dNormBiasData,
            epsilon,
            normMeanVarDesc,
            savedMean,
            savedInvVariance,
            activationDesc,
            workSpace,
            workSpaceSizeInBytes,
            reserveSpace,
            reserveSpaceSizeInBytes,
            groupCnt,
        )
    }
    pub unsafe fn cudnnNormalizationForwardInference(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        normScale: *const ::core::ffi::c_void,
        normBias: *const ::core::ffi::c_void,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        estimatedMean: *const ::core::ffi::c_void,
        estimatedVariance: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        z: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        epsilon: f64,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnNormalizationForwardInference)(
            handle,
            mode,
            normOps,
            algo,
            alpha,
            beta,
            xDesc,
            x,
            normScaleBiasDesc,
            normScale,
            normBias,
            normMeanVarDesc,
            estimatedMean,
            estimatedVariance,
            zDesc,
            z,
            activationDesc,
            yDesc,
            y,
            epsilon,
            groupCnt,
        )
    }
    pub unsafe fn cudnnNormalizationForwardTraining(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        normScale: *const ::core::ffi::c_void,
        normBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        zData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *mut ::core::ffi::c_void,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        groupCnt: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnNormalizationForwardTraining)(
            handle,
            mode,
            normOps,
            algo,
            alpha,
            beta,
            xDesc,
            xData,
            normScaleBiasDesc,
            normScale,
            normBias,
            exponentialAverageFactor,
            normMeanVarDesc,
            resultRunningMean,
            resultRunningVariance,
            epsilon,
            resultSaveMean,
            resultSaveInvVariance,
            activationDesc,
            zDesc,
            zData,
            yDesc,
            yData,
            workspace,
            workSpaceSizeInBytes,
            reserveSpace,
            reserveSpaceSizeInBytes,
            groupCnt,
        )
    }
    pub unsafe fn cudnnOpTensor(
        handle: cudnnHandle_t,
        opTensorDesc: cudnnOpTensorDescriptor_t,
        alpha1: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        alpha2: *const ::core::ffi::c_void,
        bDesc: cudnnTensorDescriptor_t,
        B: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnOpTensor)(
            handle,
            opTensorDesc,
            alpha1,
            aDesc,
            A,
            alpha2,
            bDesc,
            B,
            beta,
            cDesc,
            C,
        )
    }
    pub unsafe fn cudnnOpsVersionCheck() -> cudnnStatus_t {
        (culib().cudnnOpsVersionCheck)()
    }
    pub unsafe fn cudnnPoolingBackward(
        handle: cudnnHandle_t,
        poolingDesc: cudnnPoolingDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnPoolingBackward)(
            handle,
            poolingDesc,
            alpha,
            yDesc,
            y,
            dyDesc,
            dy,
            xDesc,
            x,
            beta,
            dxDesc,
            dx,
        )
    }
    pub unsafe fn cudnnPoolingForward(
        handle: cudnnHandle_t,
        poolingDesc: cudnnPoolingDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnPoolingForward)(handle, poolingDesc, alpha, xDesc, x, beta, yDesc, y)
    }
    pub unsafe fn cudnnQueryRuntimeError(
        handle: cudnnHandle_t,
        rstatus: *mut cudnnStatus_t,
        mode: cudnnErrQueryMode_t,
        tag: *mut cudnnRuntimeTag_t,
    ) -> cudnnStatus_t {
        (culib().cudnnQueryRuntimeError)(handle, rstatus, mode, tag)
    }
    pub unsafe fn cudnnRNNBackwardData_v8(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        devSeqLengths: *const i32,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::core::ffi::c_void,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnRNNDataDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        dhy: *const ::core::ffi::c_void,
        dhx: *mut ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        dcy: *const ::core::ffi::c_void,
        dcx: *mut ::core::ffi::c_void,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnRNNBackwardData_v8)(
            handle,
            rnnDesc,
            devSeqLengths,
            yDesc,
            y,
            dy,
            xDesc,
            dx,
            hDesc,
            hx,
            dhy,
            dhx,
            cDesc,
            cx,
            dcy,
            dcx,
            weightSpaceSize,
            weightSpace,
            workSpaceSize,
            workSpace,
            reserveSpaceSize,
            reserveSpace,
        )
    }
    pub unsafe fn cudnnRNNBackwardWeights_v8(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        addGrad: cudnnWgradMode_t,
        devSeqLengths: *const i32,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::core::ffi::c_void,
        weightSpaceSize: usize,
        dweightSpace: *mut ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnRNNBackwardWeights_v8)(
            handle,
            rnnDesc,
            addGrad,
            devSeqLengths,
            xDesc,
            x,
            hDesc,
            hx,
            yDesc,
            y,
            weightSpaceSize,
            dweightSpace,
            workSpaceSize,
            workSpace,
            reserveSpaceSize,
            reserveSpace,
        )
    }
    pub unsafe fn cudnnRNNForward(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        fwdMode: cudnnForwardMode_t,
        devSeqLengths: *const i32,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        hy: *mut ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        cy: *mut ::core::ffi::c_void,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnRNNForward)(
            handle,
            rnnDesc,
            fwdMode,
            devSeqLengths,
            xDesc,
            x,
            yDesc,
            y,
            hDesc,
            hx,
            hy,
            cDesc,
            cx,
            cy,
            weightSpaceSize,
            weightSpace,
            workSpaceSize,
            workSpace,
            reserveSpaceSize,
            reserveSpace,
        )
    }
    pub unsafe fn cudnnRNNGetClip_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: *mut cudnnRNNClipMode_t,
        clipNanOpt: *mut cudnnNanPropagation_t,
        lclip: *mut f64,
        rclip: *mut f64,
    ) -> cudnnStatus_t {
        (culib().cudnnRNNGetClip_v8)(rnnDesc, clipMode, clipNanOpt, lclip, rclip)
    }
    pub unsafe fn cudnnRNNGetClip_v9(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: *mut cudnnRNNClipMode_t,
        lclip: *mut f64,
        rclip: *mut f64,
    ) -> cudnnStatus_t {
        (culib().cudnnRNNGetClip_v9)(rnnDesc, clipMode, lclip, rclip)
    }
    pub unsafe fn cudnnRNNSetClip_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: cudnnRNNClipMode_t,
        clipNanOpt: cudnnNanPropagation_t,
        lclip: f64,
        rclip: f64,
    ) -> cudnnStatus_t {
        (culib().cudnnRNNSetClip_v8)(rnnDesc, clipMode, clipNanOpt, lclip, rclip)
    }
    pub unsafe fn cudnnRNNSetClip_v9(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: cudnnRNNClipMode_t,
        lclip: f64,
        rclip: f64,
    ) -> cudnnStatus_t {
        (culib().cudnnRNNSetClip_v9)(rnnDesc, clipMode, lclip, rclip)
    }
    pub unsafe fn cudnnReduceTensor(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        indices: *mut ::core::ffi::c_void,
        indicesSizeInBytes: usize,
        workspace: *mut ::core::ffi::c_void,
        workspaceSizeInBytes: usize,
        alpha: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnReduceTensor)(
            handle,
            reduceTensorDesc,
            indices,
            indicesSizeInBytes,
            workspace,
            workspaceSizeInBytes,
            alpha,
            aDesc,
            A,
            beta,
            cDesc,
            C,
        )
    }
    pub unsafe fn cudnnReorderFilterAndBias(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        reorderType: cudnnReorderType_t,
        filterData: *const ::core::ffi::c_void,
        reorderedFilterData: *mut ::core::ffi::c_void,
        reorderBias: ::core::ffi::c_int,
        biasData: *const ::core::ffi::c_void,
        reorderedBiasData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnReorderFilterAndBias)(
            handle,
            filterDesc,
            reorderType,
            filterData,
            reorderedFilterData,
            reorderBias,
            biasData,
            reorderedBiasData,
        )
    }
    pub unsafe fn cudnnRestoreDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: f32,
        states: *mut ::core::ffi::c_void,
        stateSizeInBytes: usize,
        seed: ::core::ffi::c_ulonglong,
    ) -> cudnnStatus_t {
        (culib().cudnnRestoreDropoutDescriptor)(
            dropoutDesc,
            handle,
            dropout,
            states,
            stateSizeInBytes,
            seed,
        )
    }
    pub unsafe fn cudnnScaleTensor(
        handle: cudnnHandle_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        alpha: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnScaleTensor)(handle, yDesc, y, alpha)
    }
    pub unsafe fn cudnnSetActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
        mode: cudnnActivationMode_t,
        reluNanOpt: cudnnNanPropagation_t,
        coef: f64,
    ) -> cudnnStatus_t {
        (culib().cudnnSetActivationDescriptor)(activationDesc, mode, reluNanOpt, coef)
    }
    pub unsafe fn cudnnSetActivationDescriptorSwishBeta(
        activationDesc: cudnnActivationDescriptor_t,
        swish_beta: f64,
    ) -> cudnnStatus_t {
        (culib().cudnnSetActivationDescriptorSwishBeta)(activationDesc, swish_beta)
    }
    pub unsafe fn cudnnSetAttnDescriptor(
        attnDesc: cudnnAttnDescriptor_t,
        attnMode: ::core::ffi::c_uint,
        nHeads: ::core::ffi::c_int,
        smScaler: f64,
        dataType: cudnnDataType_t,
        computePrec: cudnnDataType_t,
        mathType: cudnnMathType_t,
        attnDropoutDesc: cudnnDropoutDescriptor_t,
        postDropoutDesc: cudnnDropoutDescriptor_t,
        qSize: ::core::ffi::c_int,
        kSize: ::core::ffi::c_int,
        vSize: ::core::ffi::c_int,
        qProjSize: ::core::ffi::c_int,
        kProjSize: ::core::ffi::c_int,
        vProjSize: ::core::ffi::c_int,
        oProjSize: ::core::ffi::c_int,
        qoMaxSeqLength: ::core::ffi::c_int,
        kvMaxSeqLength: ::core::ffi::c_int,
        maxBatchSize: ::core::ffi::c_int,
        maxBeamSize: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetAttnDescriptor)(
            attnDesc,
            attnMode,
            nHeads,
            smScaler,
            dataType,
            computePrec,
            mathType,
            attnDropoutDesc,
            postDropoutDesc,
            qSize,
            kSize,
            vSize,
            qProjSize,
            kProjSize,
            vProjSize,
            oProjSize,
            qoMaxSeqLength,
            kvMaxSeqLength,
            maxBatchSize,
            maxBeamSize,
        )
    }
    pub unsafe fn cudnnSetCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetCTCLossDescriptor)(ctcLossDesc, compType)
    }
    pub unsafe fn cudnnSetCTCLossDescriptorEx(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        gradMode: cudnnNanPropagation_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetCTCLossDescriptorEx)(ctcLossDesc, compType, normMode, gradMode)
    }
    pub unsafe fn cudnnSetCTCLossDescriptor_v8(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        gradMode: cudnnNanPropagation_t,
        maxLabelLength: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetCTCLossDescriptor_v8)(
            ctcLossDesc,
            compType,
            normMode,
            gradMode,
            maxLabelLength,
        )
    }
    pub unsafe fn cudnnSetCTCLossDescriptor_v9(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        ctcGradMode: cudnnCTCGradMode_t,
        maxLabelLength: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetCTCLossDescriptor_v9)(
            ctcLossDesc,
            compType,
            normMode,
            ctcGradMode,
            maxLabelLength,
        )
    }
    pub unsafe fn cudnnSetCallback(
        mask: ::core::ffi::c_uint,
        udata: *mut ::core::ffi::c_void,
        fptr: cudnnCallback_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetCallback)(mask, udata, fptr)
    }
    pub unsafe fn cudnnSetConvolution2dDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        pad_h: ::core::ffi::c_int,
        pad_w: ::core::ffi::c_int,
        u: ::core::ffi::c_int,
        v: ::core::ffi::c_int,
        dilation_h: ::core::ffi::c_int,
        dilation_w: ::core::ffi::c_int,
        mode: cudnnConvolutionMode_t,
        computeType: cudnnDataType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetConvolution2dDescriptor)(
            convDesc,
            pad_h,
            pad_w,
            u,
            v,
            dilation_h,
            dilation_w,
            mode,
            computeType,
        )
    }
    pub unsafe fn cudnnSetConvolutionGroupCount(
        convDesc: cudnnConvolutionDescriptor_t,
        groupCount: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetConvolutionGroupCount)(convDesc, groupCount)
    }
    pub unsafe fn cudnnSetConvolutionMathType(
        convDesc: cudnnConvolutionDescriptor_t,
        mathType: cudnnMathType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetConvolutionMathType)(convDesc, mathType)
    }
    pub unsafe fn cudnnSetConvolutionNdDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        arrayLength: ::core::ffi::c_int,
        padA: *const ::core::ffi::c_int,
        filterStrideA: *const ::core::ffi::c_int,
        dilationA: *const ::core::ffi::c_int,
        mode: cudnnConvolutionMode_t,
        computeType: cudnnDataType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetConvolutionNdDescriptor)(
            convDesc,
            arrayLength,
            padA,
            filterStrideA,
            dilationA,
            mode,
            computeType,
        )
    }
    pub unsafe fn cudnnSetConvolutionReorderType(
        convDesc: cudnnConvolutionDescriptor_t,
        reorderType: cudnnReorderType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetConvolutionReorderType)(convDesc, reorderType)
    }
    pub unsafe fn cudnnSetDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: f32,
        states: *mut ::core::ffi::c_void,
        stateSizeInBytes: usize,
        seed: ::core::ffi::c_ulonglong,
    ) -> cudnnStatus_t {
        (culib().cudnnSetDropoutDescriptor)(
            dropoutDesc,
            handle,
            dropout,
            states,
            stateSizeInBytes,
            seed,
        )
    }
    pub unsafe fn cudnnSetFilter4dDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: cudnnDataType_t,
        format: cudnnTensorFormat_t,
        k: ::core::ffi::c_int,
        c: ::core::ffi::c_int,
        h: ::core::ffi::c_int,
        w: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetFilter4dDescriptor)(filterDesc, dataType, format, k, c, h, w)
    }
    pub unsafe fn cudnnSetFilterNdDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: cudnnDataType_t,
        format: cudnnTensorFormat_t,
        nbDims: ::core::ffi::c_int,
        filterDimA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetFilterNdDescriptor)(filterDesc, dataType, format, nbDims, filterDimA)
    }
    pub unsafe fn cudnnSetFusedOpsConstParamPackAttribute(
        constPack: cudnnFusedOpsConstParamPack_t,
        paramLabel: cudnnFusedOpsConstParamLabel_t,
        param: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSetFusedOpsConstParamPackAttribute)(constPack, paramLabel, param)
    }
    pub unsafe fn cudnnSetFusedOpsVariantParamPackAttribute(
        varPack: cudnnFusedOpsVariantParamPack_t,
        paramLabel: cudnnFusedOpsVariantParamLabel_t,
        ptr: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSetFusedOpsVariantParamPackAttribute)(varPack, paramLabel, ptr)
    }
    pub unsafe fn cudnnSetLRNDescriptor(
        normDesc: cudnnLRNDescriptor_t,
        lrnN: ::core::ffi::c_uint,
        lrnAlpha: f64,
        lrnBeta: f64,
        lrnK: f64,
    ) -> cudnnStatus_t {
        (culib().cudnnSetLRNDescriptor)(normDesc, lrnN, lrnAlpha, lrnBeta, lrnK)
    }
    pub unsafe fn cudnnSetOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
        opTensorOp: cudnnOpTensorOp_t,
        opTensorCompType: cudnnDataType_t,
        opTensorNanOpt: cudnnNanPropagation_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetOpTensorDescriptor)(
            opTensorDesc,
            opTensorOp,
            opTensorCompType,
            opTensorNanOpt,
        )
    }
    pub unsafe fn cudnnSetPooling2dDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: cudnnPoolingMode_t,
        maxpoolingNanOpt: cudnnNanPropagation_t,
        windowHeight: ::core::ffi::c_int,
        windowWidth: ::core::ffi::c_int,
        verticalPadding: ::core::ffi::c_int,
        horizontalPadding: ::core::ffi::c_int,
        verticalStride: ::core::ffi::c_int,
        horizontalStride: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetPooling2dDescriptor)(
            poolingDesc,
            mode,
            maxpoolingNanOpt,
            windowHeight,
            windowWidth,
            verticalPadding,
            horizontalPadding,
            verticalStride,
            horizontalStride,
        )
    }
    pub unsafe fn cudnnSetPoolingNdDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: cudnnPoolingMode_t,
        maxpoolingNanOpt: cudnnNanPropagation_t,
        nbDims: ::core::ffi::c_int,
        windowDimA: *const ::core::ffi::c_int,
        paddingA: *const ::core::ffi::c_int,
        strideA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetPoolingNdDescriptor)(
            poolingDesc,
            mode,
            maxpoolingNanOpt,
            nbDims,
            windowDimA,
            paddingA,
            strideA,
        )
    }
    pub unsafe fn cudnnSetRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
        dataType: cudnnDataType_t,
        layout: cudnnRNNDataLayout_t,
        maxSeqLength: ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
        vectorSize: ::core::ffi::c_int,
        seqLengthArray: *const ::core::ffi::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSetRNNDataDescriptor)(
            rnnDataDesc,
            dataType,
            layout,
            maxSeqLength,
            batchSize,
            vectorSize,
            seqLengthArray,
            paddingFill,
        )
    }
    pub unsafe fn cudnnSetRNNDescriptor_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        algo: cudnnRNNAlgo_t,
        cellMode: cudnnRNNMode_t,
        biasMode: cudnnRNNBiasMode_t,
        dirMode: cudnnDirectionMode_t,
        inputMode: cudnnRNNInputMode_t,
        dataType: cudnnDataType_t,
        mathPrec: cudnnDataType_t,
        mathType: cudnnMathType_t,
        inputSize: i32,
        hiddenSize: i32,
        projSize: i32,
        numLayers: i32,
        dropoutDesc: cudnnDropoutDescriptor_t,
        auxFlags: u32,
    ) -> cudnnStatus_t {
        (culib().cudnnSetRNNDescriptor_v8)(
            rnnDesc,
            algo,
            cellMode,
            biasMode,
            dirMode,
            inputMode,
            dataType,
            mathPrec,
            mathType,
            inputSize,
            hiddenSize,
            projSize,
            numLayers,
            dropoutDesc,
            auxFlags,
        )
    }
    pub unsafe fn cudnnSetReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        reduceTensorOp: cudnnReduceTensorOp_t,
        reduceTensorCompType: cudnnDataType_t,
        reduceTensorNanOpt: cudnnNanPropagation_t,
        reduceTensorIndices: cudnnReduceTensorIndices_t,
        reduceTensorIndicesType: cudnnIndicesType_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetReduceTensorDescriptor)(
            reduceTensorDesc,
            reduceTensorOp,
            reduceTensorCompType,
            reduceTensorNanOpt,
            reduceTensorIndices,
            reduceTensorIndicesType,
        )
    }
    pub unsafe fn cudnnSetSeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
        dataType: cudnnDataType_t,
        nbDims: ::core::ffi::c_int,
        dimA: *const ::core::ffi::c_int,
        axes: *const cudnnSeqDataAxis_t,
        seqLengthArraySize: usize,
        seqLengthArray: *const ::core::ffi::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSetSeqDataDescriptor)(
            seqDataDesc,
            dataType,
            nbDims,
            dimA,
            axes,
            seqLengthArraySize,
            seqLengthArray,
            paddingFill,
        )
    }
    pub unsafe fn cudnnSetSpatialTransformerNdDescriptor(
        stDesc: cudnnSpatialTransformerDescriptor_t,
        samplerType: cudnnSamplerType_t,
        dataType: cudnnDataType_t,
        nbDims: ::core::ffi::c_int,
        dimA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetSpatialTransformerNdDescriptor)(
            stDesc,
            samplerType,
            dataType,
            nbDims,
            dimA,
        )
    }
    pub unsafe fn cudnnSetStream(handle: cudnnHandle_t, streamId: cudaStream_t) -> cudnnStatus_t {
        (culib().cudnnSetStream)(handle, streamId)
    }
    pub unsafe fn cudnnSetTensor(
        handle: cudnnHandle_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        valuePtr: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSetTensor)(handle, yDesc, y, valuePtr)
    }
    pub unsafe fn cudnnSetTensor4dDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        format: cudnnTensorFormat_t,
        dataType: cudnnDataType_t,
        n: ::core::ffi::c_int,
        c: ::core::ffi::c_int,
        h: ::core::ffi::c_int,
        w: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetTensor4dDescriptor)(tensorDesc, format, dataType, n, c, h, w)
    }
    pub unsafe fn cudnnSetTensor4dDescriptorEx(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: cudnnDataType_t,
        n: ::core::ffi::c_int,
        c: ::core::ffi::c_int,
        h: ::core::ffi::c_int,
        w: ::core::ffi::c_int,
        nStride: ::core::ffi::c_int,
        cStride: ::core::ffi::c_int,
        hStride: ::core::ffi::c_int,
        wStride: ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetTensor4dDescriptorEx)(
            tensorDesc, dataType, n, c, h, w, nStride, cStride, hStride, wStride,
        )
    }
    pub unsafe fn cudnnSetTensorNdDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: cudnnDataType_t,
        nbDims: ::core::ffi::c_int,
        dimA: *const ::core::ffi::c_int,
        strideA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetTensorNdDescriptor)(tensorDesc, dataType, nbDims, dimA, strideA)
    }
    pub unsafe fn cudnnSetTensorNdDescriptorEx(
        tensorDesc: cudnnTensorDescriptor_t,
        format: cudnnTensorFormat_t,
        dataType: cudnnDataType_t,
        nbDims: ::core::ffi::c_int,
        dimA: *const ::core::ffi::c_int,
    ) -> cudnnStatus_t {
        (culib().cudnnSetTensorNdDescriptorEx)(tensorDesc, format, dataType, nbDims, dimA)
    }
    pub unsafe fn cudnnSetTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
        nbDims: u32,
        destFormat: cudnnTensorFormat_t,
        padBeforeA: *const i32,
        padAfterA: *const i32,
        foldA: *const u32,
        direction: cudnnFoldingDirection_t,
    ) -> cudnnStatus_t {
        (culib().cudnnSetTensorTransformDescriptor)(
            transformDesc,
            nbDims,
            destFormat,
            padBeforeA,
            padAfterA,
            foldA,
            direction,
        )
    }
    pub unsafe fn cudnnSoftmaxBackward(
        handle: cudnnHandle_t,
        algo: cudnnSoftmaxAlgorithm_t,
        mode: cudnnSoftmaxMode_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSoftmaxBackward)(
            handle, algo, mode, alpha, yDesc, y, dyDesc, dy, beta, dxDesc, dx,
        )
    }
    pub unsafe fn cudnnSoftmaxForward(
        handle: cudnnHandle_t,
        algo: cudnnSoftmaxAlgorithm_t,
        mode: cudnnSoftmaxMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSoftmaxForward)(handle, algo, mode, alpha, xDesc, x, beta, yDesc, y)
    }
    pub unsafe fn cudnnSpatialTfGridGeneratorBackward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        dgrid: *const ::core::ffi::c_void,
        dtheta: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSpatialTfGridGeneratorBackward)(handle, stDesc, dgrid, dtheta)
    }
    pub unsafe fn cudnnSpatialTfGridGeneratorForward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        theta: *const ::core::ffi::c_void,
        grid: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSpatialTfGridGeneratorForward)(handle, stDesc, theta, grid)
    }
    pub unsafe fn cudnnSpatialTfSamplerBackward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        alphaDgrid: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        grid: *const ::core::ffi::c_void,
        betaDgrid: *const ::core::ffi::c_void,
        dgrid: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSpatialTfSamplerBackward)(
            handle, stDesc, alpha, xDesc, x, beta, dxDesc, dx, alphaDgrid, dyDesc, dy, grid,
            betaDgrid, dgrid,
        )
    }
    pub unsafe fn cudnnSpatialTfSamplerForward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        grid: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnSpatialTfSamplerForward)(
            handle, stDesc, alpha, xDesc, x, grid, beta, yDesc, y,
        )
    }
    pub unsafe fn cudnnTransformFilter(
        handle: cudnnHandle_t,
        transDesc: cudnnTensorTransformDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        srcDesc: cudnnFilterDescriptor_t,
        srcData: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        destDesc: cudnnFilterDescriptor_t,
        destData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnTransformFilter)(
            handle, transDesc, alpha, srcDesc, srcData, beta, destDesc, destData,
        )
    }
    pub unsafe fn cudnnTransformTensor(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnTransformTensor)(handle, alpha, xDesc, x, beta, yDesc, y)
    }
    pub unsafe fn cudnnTransformTensorEx(
        handle: cudnnHandle_t,
        transDesc: cudnnTensorTransformDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        srcDesc: cudnnTensorDescriptor_t,
        srcData: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        destDesc: cudnnTensorDescriptor_t,
        destData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t {
        (culib().cudnnTransformTensorEx)(
            handle, transDesc, alpha, srcDesc, srcData, beta, destDesc, destData,
        )
    }
    pub struct Lib {
        __library: ::libloading::Library,
        pub cudnnActivationBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            activationDesc: cudnnActivationDescriptor_t,
            alpha: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnActivationForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            activationDesc: cudnnActivationDescriptor_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnAddTensor: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            alpha: *const ::core::ffi::c_void,
            aDesc: cudnnTensorDescriptor_t,
            A: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            cDesc: cudnnTensorDescriptor_t,
            C: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnAdvVersionCheck: unsafe extern "C" fn() -> cudnnStatus_t,
        pub cudnnBackendCreateDescriptor: unsafe extern "C" fn(
            descriptorType: cudnnBackendDescriptorType_t,
            descriptor: *mut cudnnBackendDescriptor_t,
        ) -> cudnnStatus_t,
        pub cudnnBackendDestroyDescriptor:
            unsafe extern "C" fn(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t,
        pub cudnnBackendExecute: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            executionPlan: cudnnBackendDescriptor_t,
            variantPack: cudnnBackendDescriptor_t,
        ) -> cudnnStatus_t,
        pub cudnnBackendFinalize:
            unsafe extern "C" fn(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t,
        pub cudnnBackendGetAttribute: unsafe extern "C" fn(
            descriptor: cudnnBackendDescriptor_t,
            attributeName: cudnnBackendAttributeName_t,
            attributeType: cudnnBackendAttributeType_t,
            requestedElementCount: i64,
            elementCount: *mut i64,
            arrayOfElements: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnBackendInitialize:
            unsafe extern "C" fn(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t,
        pub cudnnBackendPopulateCudaGraph: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            executionPlan: cudnnBackendDescriptor_t,
            variantPack: cudnnBackendDescriptor_t,
            graph: cudaGraph_t,
        ) -> cudnnStatus_t,
        pub cudnnBackendSetAttribute: unsafe extern "C" fn(
            descriptor: cudnnBackendDescriptor_t,
            attributeName: cudnnBackendAttributeName_t,
            attributeType: cudnnBackendAttributeType_t,
            elementCount: i64,
            arrayOfElements: *const ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnBackendUpdateCudaGraph: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            executionPlan: cudnnBackendDescriptor_t,
            variantPack: cudnnBackendDescriptor_t,
            graph: cudaGraph_t,
        ) -> cudnnStatus_t,
        pub cudnnBatchNormalizationBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnBatchNormMode_t,
            alphaDataDiff: *const ::core::ffi::c_void,
            betaDataDiff: *const ::core::ffi::c_void,
            alphaParamDiff: *const ::core::ffi::c_void,
            betaParamDiff: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
            dBnScaleBiasDesc: cudnnTensorDescriptor_t,
            bnScale: *const ::core::ffi::c_void,
            dBnScaleResult: *mut ::core::ffi::c_void,
            dBnBiasResult: *mut ::core::ffi::c_void,
            epsilon: f64,
            savedMean: *const ::core::ffi::c_void,
            savedInvVariance: *const ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnBatchNormalizationBackwardEx: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnBatchNormMode_t,
            bnOps: cudnnBatchNormOps_t,
            alphaDataDiff: *const ::core::ffi::c_void,
            betaDataDiff: *const ::core::ffi::c_void,
            alphaParamDiff: *const ::core::ffi::c_void,
            betaParamDiff: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            xData: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            yData: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dyData: *const ::core::ffi::c_void,
            dzDesc: cudnnTensorDescriptor_t,
            dzData: *mut ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dxData: *mut ::core::ffi::c_void,
            dBnScaleBiasDesc: cudnnTensorDescriptor_t,
            bnScaleData: *const ::core::ffi::c_void,
            bnBiasData: *const ::core::ffi::c_void,
            dBnScaleData: *mut ::core::ffi::c_void,
            dBnBiasData: *mut ::core::ffi::c_void,
            epsilon: f64,
            savedMean: *const ::core::ffi::c_void,
            savedInvVariance: *const ::core::ffi::c_void,
            activationDesc: cudnnActivationDescriptor_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            reserveSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
        ) -> cudnnStatus_t,
        pub cudnnBatchNormalizationForwardInference: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnBatchNormMode_t,
            alpha: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
            bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
            bnScale: *const ::core::ffi::c_void,
            bnBias: *const ::core::ffi::c_void,
            estimatedMean: *const ::core::ffi::c_void,
            estimatedVariance: *const ::core::ffi::c_void,
            epsilon: f64,
        ) -> cudnnStatus_t,
        pub cudnnBatchNormalizationForwardTraining: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnBatchNormMode_t,
            alpha: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
            bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
            bnScale: *const ::core::ffi::c_void,
            bnBias: *const ::core::ffi::c_void,
            exponentialAverageFactor: f64,
            resultRunningMean: *mut ::core::ffi::c_void,
            resultRunningVariance: *mut ::core::ffi::c_void,
            epsilon: f64,
            resultSaveMean: *mut ::core::ffi::c_void,
            resultSaveInvVariance: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnBatchNormalizationForwardTrainingEx: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnBatchNormMode_t,
            bnOps: cudnnBatchNormOps_t,
            alpha: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            xData: *const ::core::ffi::c_void,
            zDesc: cudnnTensorDescriptor_t,
            zData: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            yData: *mut ::core::ffi::c_void,
            bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
            bnScale: *const ::core::ffi::c_void,
            bnBias: *const ::core::ffi::c_void,
            exponentialAverageFactor: f64,
            resultRunningMean: *mut ::core::ffi::c_void,
            resultRunningVariance: *mut ::core::ffi::c_void,
            epsilon: f64,
            resultSaveMean: *mut ::core::ffi::c_void,
            resultSaveInvVariance: *mut ::core::ffi::c_void,
            activationDesc: cudnnActivationDescriptor_t,
            workspace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            reserveSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
        )
            -> cudnnStatus_t,
        pub cudnnBuildRNNDynamic: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            rnnDesc: cudnnRNNDescriptor_t,
            miniBatch: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnCTCLoss: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            probsDesc: cudnnTensorDescriptor_t,
            probs: *const ::core::ffi::c_void,
            hostLabels: *const ::core::ffi::c_int,
            hostLabelLengths: *const ::core::ffi::c_int,
            hostInputLengths: *const ::core::ffi::c_int,
            costs: *mut ::core::ffi::c_void,
            gradientsDesc: cudnnTensorDescriptor_t,
            gradients: *mut ::core::ffi::c_void,
            algo: cudnnCTCLossAlgo_t,
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            workspace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
        ) -> cudnnStatus_t,
        pub cudnnCTCLoss_v8: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            algo: cudnnCTCLossAlgo_t,
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            probsDesc: cudnnTensorDescriptor_t,
            probs: *const ::core::ffi::c_void,
            labels: *const ::core::ffi::c_int,
            labelLengths: *const ::core::ffi::c_int,
            inputLengths: *const ::core::ffi::c_int,
            costs: *mut ::core::ffi::c_void,
            gradientsDesc: cudnnTensorDescriptor_t,
            gradients: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            workspace: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnCnnVersionCheck: unsafe extern "C" fn() -> cudnnStatus_t,
        pub cudnnConvolutionBackwardBias: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            alpha: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            dbDesc: cudnnTensorDescriptor_t,
            db: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnConvolutionBackwardData: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            alpha: *const ::core::ffi::c_void,
            wDesc: cudnnFilterDescriptor_t,
            w: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            convDesc: cudnnConvolutionDescriptor_t,
            algo: cudnnConvolutionBwdDataAlgo_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            beta: *const ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnConvolutionBackwardFilter: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            convDesc: cudnnConvolutionDescriptor_t,
            algo: cudnnConvolutionBwdFilterAlgo_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            beta: *const ::core::ffi::c_void,
            dwDesc: cudnnFilterDescriptor_t,
            dw: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnConvolutionBiasActivationForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            alpha1: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            wDesc: cudnnFilterDescriptor_t,
            w: *const ::core::ffi::c_void,
            convDesc: cudnnConvolutionDescriptor_t,
            algo: cudnnConvolutionFwdAlgo_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            alpha2: *const ::core::ffi::c_void,
            zDesc: cudnnTensorDescriptor_t,
            z: *const ::core::ffi::c_void,
            biasDesc: cudnnTensorDescriptor_t,
            bias: *const ::core::ffi::c_void,
            activationDesc: cudnnActivationDescriptor_t,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnConvolutionForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            wDesc: cudnnFilterDescriptor_t,
            w: *const ::core::ffi::c_void,
            convDesc: cudnnConvolutionDescriptor_t,
            algo: cudnnConvolutionFwdAlgo_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            beta: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnCreate: unsafe extern "C" fn(handle: *mut cudnnHandle_t) -> cudnnStatus_t,
        pub cudnnCreateActivationDescriptor:
            unsafe extern "C" fn(activationDesc: *mut cudnnActivationDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateAttnDescriptor:
            unsafe extern "C" fn(attnDesc: *mut cudnnAttnDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateCTCLossDescriptor:
            unsafe extern "C" fn(ctcLossDesc: *mut cudnnCTCLossDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateConvolutionDescriptor:
            unsafe extern "C" fn(convDesc: *mut cudnnConvolutionDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateDropoutDescriptor:
            unsafe extern "C" fn(dropoutDesc: *mut cudnnDropoutDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateFilterDescriptor:
            unsafe extern "C" fn(filterDesc: *mut cudnnFilterDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateFusedOpsConstParamPack: unsafe extern "C" fn(
            constPack: *mut cudnnFusedOpsConstParamPack_t,
            ops: cudnnFusedOps_t,
        ) -> cudnnStatus_t,
        pub cudnnCreateFusedOpsPlan: unsafe extern "C" fn(
            plan: *mut cudnnFusedOpsPlan_t,
            ops: cudnnFusedOps_t,
        ) -> cudnnStatus_t,
        pub cudnnCreateFusedOpsVariantParamPack: unsafe extern "C" fn(
            varPack: *mut cudnnFusedOpsVariantParamPack_t,
            ops: cudnnFusedOps_t,
        ) -> cudnnStatus_t,
        pub cudnnCreateLRNDescriptor:
            unsafe extern "C" fn(normDesc: *mut cudnnLRNDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateOpTensorDescriptor:
            unsafe extern "C" fn(opTensorDesc: *mut cudnnOpTensorDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreatePoolingDescriptor:
            unsafe extern "C" fn(poolingDesc: *mut cudnnPoolingDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateRNNDataDescriptor:
            unsafe extern "C" fn(rnnDataDesc: *mut cudnnRNNDataDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateRNNDescriptor:
            unsafe extern "C" fn(rnnDesc: *mut cudnnRNNDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateReduceTensorDescriptor: unsafe extern "C" fn(
            reduceTensorDesc: *mut cudnnReduceTensorDescriptor_t,
        ) -> cudnnStatus_t,
        pub cudnnCreateSeqDataDescriptor:
            unsafe extern "C" fn(seqDataDesc: *mut cudnnSeqDataDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateSpatialTransformerDescriptor:
            unsafe extern "C" fn(stDesc: *mut cudnnSpatialTransformerDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateTensorDescriptor:
            unsafe extern "C" fn(tensorDesc: *mut cudnnTensorDescriptor_t) -> cudnnStatus_t,
        pub cudnnCreateTensorTransformDescriptor: unsafe extern "C" fn(
            transformDesc: *mut cudnnTensorTransformDescriptor_t,
        ) -> cudnnStatus_t,
        pub cudnnDeriveBNTensorDescriptor: unsafe extern "C" fn(
            derivedBnDesc: cudnnTensorDescriptor_t,
            xDesc: cudnnTensorDescriptor_t,
            mode: cudnnBatchNormMode_t,
        ) -> cudnnStatus_t,
        pub cudnnDeriveNormTensorDescriptor: unsafe extern "C" fn(
            derivedNormScaleBiasDesc: cudnnTensorDescriptor_t,
            derivedNormMeanVarDesc: cudnnTensorDescriptor_t,
            xDesc: cudnnTensorDescriptor_t,
            mode: cudnnNormMode_t,
            groupCnt: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnDestroy: unsafe extern "C" fn(handle: cudnnHandle_t) -> cudnnStatus_t,
        pub cudnnDestroyActivationDescriptor:
            unsafe extern "C" fn(activationDesc: cudnnActivationDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyAttnDescriptor:
            unsafe extern "C" fn(attnDesc: cudnnAttnDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyCTCLossDescriptor:
            unsafe extern "C" fn(ctcLossDesc: cudnnCTCLossDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyConvolutionDescriptor:
            unsafe extern "C" fn(convDesc: cudnnConvolutionDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyDropoutDescriptor:
            unsafe extern "C" fn(dropoutDesc: cudnnDropoutDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyFilterDescriptor:
            unsafe extern "C" fn(filterDesc: cudnnFilterDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyFusedOpsConstParamPack:
            unsafe extern "C" fn(constPack: cudnnFusedOpsConstParamPack_t) -> cudnnStatus_t,
        pub cudnnDestroyFusedOpsPlan:
            unsafe extern "C" fn(plan: cudnnFusedOpsPlan_t) -> cudnnStatus_t,
        pub cudnnDestroyFusedOpsVariantParamPack:
            unsafe extern "C" fn(varPack: cudnnFusedOpsVariantParamPack_t) -> cudnnStatus_t,
        pub cudnnDestroyLRNDescriptor:
            unsafe extern "C" fn(lrnDesc: cudnnLRNDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyOpTensorDescriptor:
            unsafe extern "C" fn(opTensorDesc: cudnnOpTensorDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyPoolingDescriptor:
            unsafe extern "C" fn(poolingDesc: cudnnPoolingDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyRNNDataDescriptor:
            unsafe extern "C" fn(rnnDataDesc: cudnnRNNDataDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyRNNDescriptor:
            unsafe extern "C" fn(rnnDesc: cudnnRNNDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyReduceTensorDescriptor:
            unsafe extern "C" fn(reduceTensorDesc: cudnnReduceTensorDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroySeqDataDescriptor:
            unsafe extern "C" fn(seqDataDesc: cudnnSeqDataDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroySpatialTransformerDescriptor:
            unsafe extern "C" fn(stDesc: cudnnSpatialTransformerDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyTensorDescriptor:
            unsafe extern "C" fn(tensorDesc: cudnnTensorDescriptor_t) -> cudnnStatus_t,
        pub cudnnDestroyTensorTransformDescriptor:
            unsafe extern "C" fn(transformDesc: cudnnTensorTransformDescriptor_t) -> cudnnStatus_t,
        pub cudnnDivisiveNormalizationBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            normDesc: cudnnLRNDescriptor_t,
            mode: cudnnDivNormMode_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            means: *const ::core::ffi::c_void,
            dy: *const ::core::ffi::c_void,
            temp: *mut ::core::ffi::c_void,
            temp2: *mut ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            dXdMeansDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
            dMeans: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnDivisiveNormalizationForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            normDesc: cudnnLRNDescriptor_t,
            mode: cudnnDivNormMode_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            means: *const ::core::ffi::c_void,
            temp: *mut ::core::ffi::c_void,
            temp2: *mut ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnDropoutBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            dropoutDesc: cudnnDropoutDescriptor_t,
            dydesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            dxdesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
            reserveSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
        ) -> cudnnStatus_t,
        pub cudnnDropoutForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            dropoutDesc: cudnnDropoutDescriptor_t,
            xdesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            ydesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
            reserveSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
        ) -> cudnnStatus_t,
        pub cudnnDropoutGetReserveSpaceSize: unsafe extern "C" fn(
            xdesc: cudnnTensorDescriptor_t,
            sizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnDropoutGetStatesSize:
            unsafe extern "C" fn(handle: cudnnHandle_t, sizeInBytes: *mut usize) -> cudnnStatus_t,
        pub cudnnFindConvolutionBackwardDataAlgorithm: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            wDesc: cudnnFilterDescriptor_t,
            dyDesc: cudnnTensorDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            dxDesc: cudnnTensorDescriptor_t,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
        )
            -> cudnnStatus_t,
        pub cudnnFindConvolutionBackwardDataAlgorithmEx: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            wDesc: cudnnFilterDescriptor_t,
            w: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            convDesc: cudnnConvolutionDescriptor_t,
            dxDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
        )
            -> cudnnStatus_t,
        pub cudnnFindConvolutionBackwardFilterAlgorithm: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            xDesc: cudnnTensorDescriptor_t,
            dyDesc: cudnnTensorDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            dwDesc: cudnnFilterDescriptor_t,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
        )
            -> cudnnStatus_t,
        pub cudnnFindConvolutionBackwardFilterAlgorithmEx: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            y: *const ::core::ffi::c_void,
            convDesc: cudnnConvolutionDescriptor_t,
            dwDesc: cudnnFilterDescriptor_t,
            dw: *mut ::core::ffi::c_void,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
        )
            -> cudnnStatus_t,
        pub cudnnFindConvolutionForwardAlgorithm: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            xDesc: cudnnTensorDescriptor_t,
            wDesc: cudnnFilterDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            yDesc: cudnnTensorDescriptor_t,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
        ) -> cudnnStatus_t,
        pub cudnnFindConvolutionForwardAlgorithmEx: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            wDesc: cudnnFilterDescriptor_t,
            w: *const ::core::ffi::c_void,
            convDesc: cudnnConvolutionDescriptor_t,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
        ) -> cudnnStatus_t,
        pub cudnnFusedOpsExecute: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            plan: cudnnFusedOpsPlan_t,
            varPack: cudnnFusedOpsVariantParamPack_t,
        ) -> cudnnStatus_t,
        pub cudnnGetActivationDescriptor: unsafe extern "C" fn(
            activationDesc: cudnnActivationDescriptor_t,
            mode: *mut cudnnActivationMode_t,
            reluNanOpt: *mut cudnnNanPropagation_t,
            coef: *mut f64,
        ) -> cudnnStatus_t,
        pub cudnnGetActivationDescriptorSwishBeta: unsafe extern "C" fn(
            activationDesc: cudnnActivationDescriptor_t,
            swish_beta: *mut f64,
        ) -> cudnnStatus_t,
        pub cudnnGetAttnDescriptor: unsafe extern "C" fn(
            attnDesc: cudnnAttnDescriptor_t,
            attnMode: *mut ::core::ffi::c_uint,
            nHeads: *mut ::core::ffi::c_int,
            smScaler: *mut f64,
            dataType: *mut cudnnDataType_t,
            computePrec: *mut cudnnDataType_t,
            mathType: *mut cudnnMathType_t,
            attnDropoutDesc: *mut cudnnDropoutDescriptor_t,
            postDropoutDesc: *mut cudnnDropoutDescriptor_t,
            qSize: *mut ::core::ffi::c_int,
            kSize: *mut ::core::ffi::c_int,
            vSize: *mut ::core::ffi::c_int,
            qProjSize: *mut ::core::ffi::c_int,
            kProjSize: *mut ::core::ffi::c_int,
            vProjSize: *mut ::core::ffi::c_int,
            oProjSize: *mut ::core::ffi::c_int,
            qoMaxSeqLength: *mut ::core::ffi::c_int,
            kvMaxSeqLength: *mut ::core::ffi::c_int,
            maxBatchSize: *mut ::core::ffi::c_int,
            maxBeamSize: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetBatchNormalizationBackwardExWorkspaceSize:
            unsafe extern "C" fn(
                handle: cudnnHandle_t,
                mode: cudnnBatchNormMode_t,
                bnOps: cudnnBatchNormOps_t,
                xDesc: cudnnTensorDescriptor_t,
                yDesc: cudnnTensorDescriptor_t,
                dyDesc: cudnnTensorDescriptor_t,
                dzDesc: cudnnTensorDescriptor_t,
                dxDesc: cudnnTensorDescriptor_t,
                dBnScaleBiasDesc: cudnnTensorDescriptor_t,
                activationDesc: cudnnActivationDescriptor_t,
                sizeInBytes: *mut usize,
            ) -> cudnnStatus_t,
        pub cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize:
            unsafe extern "C" fn(
                handle: cudnnHandle_t,
                mode: cudnnBatchNormMode_t,
                bnOps: cudnnBatchNormOps_t,
                xDesc: cudnnTensorDescriptor_t,
                zDesc: cudnnTensorDescriptor_t,
                yDesc: cudnnTensorDescriptor_t,
                bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
                activationDesc: cudnnActivationDescriptor_t,
                sizeInBytes: *mut usize,
            ) -> cudnnStatus_t,
        pub cudnnGetBatchNormalizationTrainingExReserveSpaceSize:
            unsafe extern "C" fn(
                handle: cudnnHandle_t,
                mode: cudnnBatchNormMode_t,
                bnOps: cudnnBatchNormOps_t,
                activationDesc: cudnnActivationDescriptor_t,
                xDesc: cudnnTensorDescriptor_t,
                sizeInBytes: *mut usize,
            ) -> cudnnStatus_t,
        pub cudnnGetCTCLossDescriptor: unsafe extern "C" fn(
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            compType: *mut cudnnDataType_t,
        ) -> cudnnStatus_t,
        pub cudnnGetCTCLossDescriptorEx: unsafe extern "C" fn(
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            compType: *mut cudnnDataType_t,
            normMode: *mut cudnnLossNormalizationMode_t,
            gradMode: *mut cudnnNanPropagation_t,
        ) -> cudnnStatus_t,
        pub cudnnGetCTCLossDescriptor_v8: unsafe extern "C" fn(
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            compType: *mut cudnnDataType_t,
            normMode: *mut cudnnLossNormalizationMode_t,
            gradMode: *mut cudnnNanPropagation_t,
            maxLabelLength: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetCTCLossDescriptor_v9: unsafe extern "C" fn(
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            compType: *mut cudnnDataType_t,
            normMode: *mut cudnnLossNormalizationMode_t,
            ctcGradMode: *mut cudnnCTCGradMode_t,
            maxLabelLength: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetCTCLossWorkspaceSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            probsDesc: cudnnTensorDescriptor_t,
            gradientsDesc: cudnnTensorDescriptor_t,
            labels: *const ::core::ffi::c_int,
            labelLengths: *const ::core::ffi::c_int,
            inputLengths: *const ::core::ffi::c_int,
            algo: cudnnCTCLossAlgo_t,
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            sizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetCTCLossWorkspaceSize_v8: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            algo: cudnnCTCLossAlgo_t,
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            probsDesc: cudnnTensorDescriptor_t,
            gradientsDesc: cudnnTensorDescriptor_t,
            sizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetCallback: unsafe extern "C" fn(
            mask: *mut ::core::ffi::c_uint,
            udata: *mut *mut ::core::ffi::c_void,
            fptr: *mut cudnnCallback_t,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolution2dDescriptor: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            pad_h: *mut ::core::ffi::c_int,
            pad_w: *mut ::core::ffi::c_int,
            u: *mut ::core::ffi::c_int,
            v: *mut ::core::ffi::c_int,
            dilation_h: *mut ::core::ffi::c_int,
            dilation_w: *mut ::core::ffi::c_int,
            mode: *mut cudnnConvolutionMode_t,
            computeType: *mut cudnnDataType_t,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolution2dForwardOutputDim: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            inputTensorDesc: cudnnTensorDescriptor_t,
            filterDesc: cudnnFilterDescriptor_t,
            n: *mut ::core::ffi::c_int,
            c: *mut ::core::ffi::c_int,
            h: *mut ::core::ffi::c_int,
            w: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolutionBackwardDataAlgorithmMaxCount: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            count: *mut ::core::ffi::c_int,
        )
            -> cudnnStatus_t,
        pub cudnnGetConvolutionBackwardDataAlgorithm_v7: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            filterDesc: cudnnFilterDescriptor_t,
            diffDesc: cudnnTensorDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            gradDesc: cudnnTensorDescriptor_t,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
        )
            -> cudnnStatus_t,
        pub cudnnGetConvolutionBackwardDataWorkspaceSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            wDesc: cudnnFilterDescriptor_t,
            dyDesc: cudnnTensorDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            dxDesc: cudnnTensorDescriptor_t,
            algo: cudnnConvolutionBwdDataAlgo_t,
            sizeInBytes: *mut usize,
        )
            -> cudnnStatus_t,
        pub cudnnGetConvolutionBackwardFilterAlgorithmMaxCount:
            unsafe extern "C" fn(
                handle: cudnnHandle_t,
                count: *mut ::core::ffi::c_int,
            ) -> cudnnStatus_t,
        pub cudnnGetConvolutionBackwardFilterAlgorithm_v7: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            srcDesc: cudnnTensorDescriptor_t,
            diffDesc: cudnnTensorDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            gradDesc: cudnnFilterDescriptor_t,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
        )
            -> cudnnStatus_t,
        pub cudnnGetConvolutionBackwardFilterWorkspaceSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            xDesc: cudnnTensorDescriptor_t,
            dyDesc: cudnnTensorDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            gradDesc: cudnnFilterDescriptor_t,
            algo: cudnnConvolutionBwdFilterAlgo_t,
            sizeInBytes: *mut usize,
        )
            -> cudnnStatus_t,
        pub cudnnGetConvolutionForwardAlgorithmMaxCount: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            count: *mut ::core::ffi::c_int,
        )
            -> cudnnStatus_t,
        pub cudnnGetConvolutionForwardAlgorithm_v7: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            srcDesc: cudnnTensorDescriptor_t,
            filterDesc: cudnnFilterDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            destDesc: cudnnTensorDescriptor_t,
            requestedAlgoCount: ::core::ffi::c_int,
            returnedAlgoCount: *mut ::core::ffi::c_int,
            perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolutionForwardWorkspaceSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            xDesc: cudnnTensorDescriptor_t,
            wDesc: cudnnFilterDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            yDesc: cudnnTensorDescriptor_t,
            algo: cudnnConvolutionFwdAlgo_t,
            sizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolutionGroupCount: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            groupCount: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolutionMathType: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            mathType: *mut cudnnMathType_t,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolutionNdDescriptor: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            arrayLengthRequested: ::core::ffi::c_int,
            arrayLength: *mut ::core::ffi::c_int,
            padA: *mut ::core::ffi::c_int,
            strideA: *mut ::core::ffi::c_int,
            dilationA: *mut ::core::ffi::c_int,
            mode: *mut cudnnConvolutionMode_t,
            computeType: *mut cudnnDataType_t,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolutionNdForwardOutputDim: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            inputTensorDesc: cudnnTensorDescriptor_t,
            filterDesc: cudnnFilterDescriptor_t,
            nbDims: ::core::ffi::c_int,
            tensorOuputDimA: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetConvolutionReorderType: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            reorderType: *mut cudnnReorderType_t,
        ) -> cudnnStatus_t,
        pub cudnnGetCudartVersion: unsafe extern "C" fn() -> usize,
        pub cudnnGetDropoutDescriptor: unsafe extern "C" fn(
            dropoutDesc: cudnnDropoutDescriptor_t,
            handle: cudnnHandle_t,
            dropout: *mut f32,
            states: *mut *mut ::core::ffi::c_void,
            seed: *mut ::core::ffi::c_ulonglong,
        ) -> cudnnStatus_t,
        pub cudnnGetErrorString:
            unsafe extern "C" fn(status: cudnnStatus_t) -> *const ::core::ffi::c_char,
        pub cudnnGetFilter4dDescriptor: unsafe extern "C" fn(
            filterDesc: cudnnFilterDescriptor_t,
            dataType: *mut cudnnDataType_t,
            format: *mut cudnnTensorFormat_t,
            k: *mut ::core::ffi::c_int,
            c: *mut ::core::ffi::c_int,
            h: *mut ::core::ffi::c_int,
            w: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetFilterNdDescriptor: unsafe extern "C" fn(
            filterDesc: cudnnFilterDescriptor_t,
            nbDimsRequested: ::core::ffi::c_int,
            dataType: *mut cudnnDataType_t,
            format: *mut cudnnTensorFormat_t,
            nbDims: *mut ::core::ffi::c_int,
            filterDimA: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetFilterSizeInBytes: unsafe extern "C" fn(
            filterDesc: cudnnFilterDescriptor_t,
            size: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetFoldedConvBackwardDataDescriptors: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            filterDesc: cudnnFilterDescriptor_t,
            diffDesc: cudnnTensorDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            gradDesc: cudnnTensorDescriptor_t,
            transformFormat: cudnnTensorFormat_t,
            foldedFilterDesc: cudnnFilterDescriptor_t,
            paddedDiffDesc: cudnnTensorDescriptor_t,
            foldedConvDesc: cudnnConvolutionDescriptor_t,
            foldedGradDesc: cudnnTensorDescriptor_t,
            filterFoldTransDesc: cudnnTensorTransformDescriptor_t,
            diffPadTransDesc: cudnnTensorTransformDescriptor_t,
            gradFoldTransDesc: cudnnTensorTransformDescriptor_t,
            gradUnfoldTransDesc: cudnnTensorTransformDescriptor_t,
        )
            -> cudnnStatus_t,
        pub cudnnGetFusedOpsConstParamPackAttribute: unsafe extern "C" fn(
            constPack: cudnnFusedOpsConstParamPack_t,
            paramLabel: cudnnFusedOpsConstParamLabel_t,
            param: *mut ::core::ffi::c_void,
            isNULL: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetFusedOpsVariantParamPackAttribute: unsafe extern "C" fn(
            varPack: cudnnFusedOpsVariantParamPack_t,
            paramLabel: cudnnFusedOpsVariantParamLabel_t,
            ptr: *mut ::core::ffi::c_void,
        )
            -> cudnnStatus_t,
        pub cudnnGetLRNDescriptor: unsafe extern "C" fn(
            normDesc: cudnnLRNDescriptor_t,
            lrnN: *mut ::core::ffi::c_uint,
            lrnAlpha: *mut f64,
            lrnBeta: *mut f64,
            lrnK: *mut f64,
        ) -> cudnnStatus_t,
        pub cudnnGetLastErrorString:
            unsafe extern "C" fn(message: *mut ::core::ffi::c_char, max_size: usize),
        pub cudnnGetMaxDeviceVersion: unsafe extern "C" fn() -> usize,
        pub cudnnGetMultiHeadAttnBuffers: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            attnDesc: cudnnAttnDescriptor_t,
            weightSizeInBytes: *mut usize,
            workSpaceSizeInBytes: *mut usize,
            reserveSpaceSizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetMultiHeadAttnWeights: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            attnDesc: cudnnAttnDescriptor_t,
            wKind: cudnnMultiHeadAttnWeightKind_t,
            weightSizeInBytes: usize,
            weights: *const ::core::ffi::c_void,
            wDesc: cudnnTensorDescriptor_t,
            wAddr: *mut *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnGetNormalizationBackwardWorkspaceSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnNormMode_t,
            normOps: cudnnNormOps_t,
            algo: cudnnNormAlgo_t,
            xDesc: cudnnTensorDescriptor_t,
            yDesc: cudnnTensorDescriptor_t,
            dyDesc: cudnnTensorDescriptor_t,
            dzDesc: cudnnTensorDescriptor_t,
            dxDesc: cudnnTensorDescriptor_t,
            dNormScaleBiasDesc: cudnnTensorDescriptor_t,
            activationDesc: cudnnActivationDescriptor_t,
            normMeanVarDesc: cudnnTensorDescriptor_t,
            sizeInBytes: *mut usize,
            groupCnt: ::core::ffi::c_int,
        )
            -> cudnnStatus_t,
        pub cudnnGetNormalizationForwardTrainingWorkspaceSize:
            unsafe extern "C" fn(
                handle: cudnnHandle_t,
                mode: cudnnNormMode_t,
                normOps: cudnnNormOps_t,
                algo: cudnnNormAlgo_t,
                xDesc: cudnnTensorDescriptor_t,
                zDesc: cudnnTensorDescriptor_t,
                yDesc: cudnnTensorDescriptor_t,
                normScaleBiasDesc: cudnnTensorDescriptor_t,
                activationDesc: cudnnActivationDescriptor_t,
                normMeanVarDesc: cudnnTensorDescriptor_t,
                sizeInBytes: *mut usize,
                groupCnt: ::core::ffi::c_int,
            ) -> cudnnStatus_t,
        pub cudnnGetNormalizationTrainingReserveSpaceSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnNormMode_t,
            normOps: cudnnNormOps_t,
            algo: cudnnNormAlgo_t,
            activationDesc: cudnnActivationDescriptor_t,
            xDesc: cudnnTensorDescriptor_t,
            sizeInBytes: *mut usize,
            groupCnt: ::core::ffi::c_int,
        )
            -> cudnnStatus_t,
        pub cudnnGetOpTensorDescriptor: unsafe extern "C" fn(
            opTensorDesc: cudnnOpTensorDescriptor_t,
            opTensorOp: *mut cudnnOpTensorOp_t,
            opTensorCompType: *mut cudnnDataType_t,
            opTensorNanOpt: *mut cudnnNanPropagation_t,
        ) -> cudnnStatus_t,
        pub cudnnGetPooling2dDescriptor: unsafe extern "C" fn(
            poolingDesc: cudnnPoolingDescriptor_t,
            mode: *mut cudnnPoolingMode_t,
            maxpoolingNanOpt: *mut cudnnNanPropagation_t,
            windowHeight: *mut ::core::ffi::c_int,
            windowWidth: *mut ::core::ffi::c_int,
            verticalPadding: *mut ::core::ffi::c_int,
            horizontalPadding: *mut ::core::ffi::c_int,
            verticalStride: *mut ::core::ffi::c_int,
            horizontalStride: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetPooling2dForwardOutputDim: unsafe extern "C" fn(
            poolingDesc: cudnnPoolingDescriptor_t,
            inputTensorDesc: cudnnTensorDescriptor_t,
            n: *mut ::core::ffi::c_int,
            c: *mut ::core::ffi::c_int,
            h: *mut ::core::ffi::c_int,
            w: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetPoolingNdDescriptor: unsafe extern "C" fn(
            poolingDesc: cudnnPoolingDescriptor_t,
            nbDimsRequested: ::core::ffi::c_int,
            mode: *mut cudnnPoolingMode_t,
            maxpoolingNanOpt: *mut cudnnNanPropagation_t,
            nbDims: *mut ::core::ffi::c_int,
            windowDimA: *mut ::core::ffi::c_int,
            paddingA: *mut ::core::ffi::c_int,
            strideA: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetPoolingNdForwardOutputDim: unsafe extern "C" fn(
            poolingDesc: cudnnPoolingDescriptor_t,
            inputTensorDesc: cudnnTensorDescriptor_t,
            nbDims: ::core::ffi::c_int,
            outputTensorDimA: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetProperty: unsafe extern "C" fn(
            type_: libraryPropertyType,
            value: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetRNNDataDescriptor: unsafe extern "C" fn(
            rnnDataDesc: cudnnRNNDataDescriptor_t,
            dataType: *mut cudnnDataType_t,
            layout: *mut cudnnRNNDataLayout_t,
            maxSeqLength: *mut ::core::ffi::c_int,
            batchSize: *mut ::core::ffi::c_int,
            vectorSize: *mut ::core::ffi::c_int,
            arrayLengthRequested: ::core::ffi::c_int,
            seqLengthArray: *mut ::core::ffi::c_int,
            paddingFill: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnGetRNNDescriptor_v8: unsafe extern "C" fn(
            rnnDesc: cudnnRNNDescriptor_t,
            algo: *mut cudnnRNNAlgo_t,
            cellMode: *mut cudnnRNNMode_t,
            biasMode: *mut cudnnRNNBiasMode_t,
            dirMode: *mut cudnnDirectionMode_t,
            inputMode: *mut cudnnRNNInputMode_t,
            dataType: *mut cudnnDataType_t,
            mathPrec: *mut cudnnDataType_t,
            mathType: *mut cudnnMathType_t,
            inputSize: *mut i32,
            hiddenSize: *mut i32,
            projSize: *mut i32,
            numLayers: *mut i32,
            dropoutDesc: *mut cudnnDropoutDescriptor_t,
            auxFlags: *mut u32,
        ) -> cudnnStatus_t,
        pub cudnnGetRNNTempSpaceSizes: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            rnnDesc: cudnnRNNDescriptor_t,
            fwdMode: cudnnForwardMode_t,
            xDesc: cudnnRNNDataDescriptor_t,
            workSpaceSize: *mut usize,
            reserveSpaceSize: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetRNNWeightParams: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            rnnDesc: cudnnRNNDescriptor_t,
            pseudoLayer: i32,
            weightSpaceSize: usize,
            weightSpace: *const ::core::ffi::c_void,
            linLayerID: i32,
            mDesc: cudnnTensorDescriptor_t,
            mAddr: *mut *mut ::core::ffi::c_void,
            bDesc: cudnnTensorDescriptor_t,
            bAddr: *mut *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnGetRNNWeightSpaceSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            rnnDesc: cudnnRNNDescriptor_t,
            weightSpaceSize: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetReduceTensorDescriptor: unsafe extern "C" fn(
            reduceTensorDesc: cudnnReduceTensorDescriptor_t,
            reduceTensorOp: *mut cudnnReduceTensorOp_t,
            reduceTensorCompType: *mut cudnnDataType_t,
            reduceTensorNanOpt: *mut cudnnNanPropagation_t,
            reduceTensorIndices: *mut cudnnReduceTensorIndices_t,
            reduceTensorIndicesType: *mut cudnnIndicesType_t,
        ) -> cudnnStatus_t,
        pub cudnnGetReductionIndicesSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            reduceTensorDesc: cudnnReduceTensorDescriptor_t,
            aDesc: cudnnTensorDescriptor_t,
            cDesc: cudnnTensorDescriptor_t,
            sizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetReductionWorkspaceSize: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            reduceTensorDesc: cudnnReduceTensorDescriptor_t,
            aDesc: cudnnTensorDescriptor_t,
            cDesc: cudnnTensorDescriptor_t,
            sizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetSeqDataDescriptor: unsafe extern "C" fn(
            seqDataDesc: cudnnSeqDataDescriptor_t,
            dataType: *mut cudnnDataType_t,
            nbDims: *mut ::core::ffi::c_int,
            nbDimsRequested: ::core::ffi::c_int,
            dimA: *mut ::core::ffi::c_int,
            axes: *mut cudnnSeqDataAxis_t,
            seqLengthArraySize: *mut usize,
            seqLengthSizeRequested: usize,
            seqLengthArray: *mut ::core::ffi::c_int,
            paddingFill: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnGetStream: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            streamId: *mut cudaStream_t,
        ) -> cudnnStatus_t,
        pub cudnnGetTensor4dDescriptor: unsafe extern "C" fn(
            tensorDesc: cudnnTensorDescriptor_t,
            dataType: *mut cudnnDataType_t,
            n: *mut ::core::ffi::c_int,
            c: *mut ::core::ffi::c_int,
            h: *mut ::core::ffi::c_int,
            w: *mut ::core::ffi::c_int,
            nStride: *mut ::core::ffi::c_int,
            cStride: *mut ::core::ffi::c_int,
            hStride: *mut ::core::ffi::c_int,
            wStride: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetTensorNdDescriptor: unsafe extern "C" fn(
            tensorDesc: cudnnTensorDescriptor_t,
            nbDimsRequested: ::core::ffi::c_int,
            dataType: *mut cudnnDataType_t,
            nbDims: *mut ::core::ffi::c_int,
            dimA: *mut ::core::ffi::c_int,
            strideA: *mut ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnGetTensorSizeInBytes: unsafe extern "C" fn(
            tensorDesc: cudnnTensorDescriptor_t,
            size: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnGetTensorTransformDescriptor: unsafe extern "C" fn(
            transformDesc: cudnnTensorTransformDescriptor_t,
            nbDimsRequested: u32,
            destFormat: *mut cudnnTensorFormat_t,
            padBeforeA: *mut i32,
            padAfterA: *mut i32,
            foldA: *mut u32,
            direction: *mut cudnnFoldingDirection_t,
        ) -> cudnnStatus_t,
        pub cudnnGetVersion: unsafe extern "C" fn() -> usize,
        pub cudnnGraphVersionCheck: unsafe extern "C" fn() -> cudnnStatus_t,
        pub cudnnIm2Col: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            wDesc: cudnnFilterDescriptor_t,
            convDesc: cudnnConvolutionDescriptor_t,
            colBuffer: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnInitTransformDest: unsafe extern "C" fn(
            transformDesc: cudnnTensorTransformDescriptor_t,
            srcDesc: cudnnTensorDescriptor_t,
            destDesc: cudnnTensorDescriptor_t,
            destSizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnLRNCrossChannelBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            normDesc: cudnnLRNDescriptor_t,
            lrnMode: cudnnLRNMode_t,
            alpha: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnLRNCrossChannelForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            normDesc: cudnnLRNDescriptor_t,
            lrnMode: cudnnLRNMode_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnMakeFusedOpsPlan: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            plan: cudnnFusedOpsPlan_t,
            constPack: cudnnFusedOpsConstParamPack_t,
            workspaceSizeInBytes: *mut usize,
        ) -> cudnnStatus_t,
        pub cudnnMultiHeadAttnBackwardData: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            attnDesc: cudnnAttnDescriptor_t,
            loWinIdx: *const ::core::ffi::c_int,
            hiWinIdx: *const ::core::ffi::c_int,
            devSeqLengthsDQDO: *const ::core::ffi::c_int,
            devSeqLengthsDKDV: *const ::core::ffi::c_int,
            doDesc: cudnnSeqDataDescriptor_t,
            dout: *const ::core::ffi::c_void,
            dqDesc: cudnnSeqDataDescriptor_t,
            dqueries: *mut ::core::ffi::c_void,
            queries: *const ::core::ffi::c_void,
            dkDesc: cudnnSeqDataDescriptor_t,
            dkeys: *mut ::core::ffi::c_void,
            keys: *const ::core::ffi::c_void,
            dvDesc: cudnnSeqDataDescriptor_t,
            dvalues: *mut ::core::ffi::c_void,
            values: *const ::core::ffi::c_void,
            weightSizeInBytes: usize,
            weights: *const ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            workSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
            reserveSpace: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnMultiHeadAttnBackwardWeights: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            attnDesc: cudnnAttnDescriptor_t,
            addGrad: cudnnWgradMode_t,
            qDesc: cudnnSeqDataDescriptor_t,
            queries: *const ::core::ffi::c_void,
            kDesc: cudnnSeqDataDescriptor_t,
            keys: *const ::core::ffi::c_void,
            vDesc: cudnnSeqDataDescriptor_t,
            values: *const ::core::ffi::c_void,
            doDesc: cudnnSeqDataDescriptor_t,
            dout: *const ::core::ffi::c_void,
            weightSizeInBytes: usize,
            weights: *const ::core::ffi::c_void,
            dweights: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            workSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
            reserveSpace: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnMultiHeadAttnForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            attnDesc: cudnnAttnDescriptor_t,
            currIdx: ::core::ffi::c_int,
            loWinIdx: *const ::core::ffi::c_int,
            hiWinIdx: *const ::core::ffi::c_int,
            devSeqLengthsQO: *const ::core::ffi::c_int,
            devSeqLengthsKV: *const ::core::ffi::c_int,
            qDesc: cudnnSeqDataDescriptor_t,
            queries: *const ::core::ffi::c_void,
            residuals: *const ::core::ffi::c_void,
            kDesc: cudnnSeqDataDescriptor_t,
            keys: *const ::core::ffi::c_void,
            vDesc: cudnnSeqDataDescriptor_t,
            values: *const ::core::ffi::c_void,
            oDesc: cudnnSeqDataDescriptor_t,
            out: *mut ::core::ffi::c_void,
            weightSizeInBytes: usize,
            weights: *const ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            workSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
            reserveSpace: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnNormalizationBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnNormMode_t,
            normOps: cudnnNormOps_t,
            algo: cudnnNormAlgo_t,
            alphaDataDiff: *const ::core::ffi::c_void,
            betaDataDiff: *const ::core::ffi::c_void,
            alphaParamDiff: *const ::core::ffi::c_void,
            betaParamDiff: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            xData: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            yData: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dyData: *const ::core::ffi::c_void,
            dzDesc: cudnnTensorDescriptor_t,
            dzData: *mut ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dxData: *mut ::core::ffi::c_void,
            dNormScaleBiasDesc: cudnnTensorDescriptor_t,
            normScaleData: *const ::core::ffi::c_void,
            normBiasData: *const ::core::ffi::c_void,
            dNormScaleData: *mut ::core::ffi::c_void,
            dNormBiasData: *mut ::core::ffi::c_void,
            epsilon: f64,
            normMeanVarDesc: cudnnTensorDescriptor_t,
            savedMean: *const ::core::ffi::c_void,
            savedInvVariance: *const ::core::ffi::c_void,
            activationDesc: cudnnActivationDescriptor_t,
            workSpace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            reserveSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
            groupCnt: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnNormalizationForwardInference: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnNormMode_t,
            normOps: cudnnNormOps_t,
            algo: cudnnNormAlgo_t,
            alpha: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            normScaleBiasDesc: cudnnTensorDescriptor_t,
            normScale: *const ::core::ffi::c_void,
            normBias: *const ::core::ffi::c_void,
            normMeanVarDesc: cudnnTensorDescriptor_t,
            estimatedMean: *const ::core::ffi::c_void,
            estimatedVariance: *const ::core::ffi::c_void,
            zDesc: cudnnTensorDescriptor_t,
            z: *const ::core::ffi::c_void,
            activationDesc: cudnnActivationDescriptor_t,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
            epsilon: f64,
            groupCnt: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnNormalizationForwardTraining: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            mode: cudnnNormMode_t,
            normOps: cudnnNormOps_t,
            algo: cudnnNormAlgo_t,
            alpha: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            xData: *const ::core::ffi::c_void,
            normScaleBiasDesc: cudnnTensorDescriptor_t,
            normScale: *const ::core::ffi::c_void,
            normBias: *const ::core::ffi::c_void,
            exponentialAverageFactor: f64,
            normMeanVarDesc: cudnnTensorDescriptor_t,
            resultRunningMean: *mut ::core::ffi::c_void,
            resultRunningVariance: *mut ::core::ffi::c_void,
            epsilon: f64,
            resultSaveMean: *mut ::core::ffi::c_void,
            resultSaveInvVariance: *mut ::core::ffi::c_void,
            activationDesc: cudnnActivationDescriptor_t,
            zDesc: cudnnTensorDescriptor_t,
            zData: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            yData: *mut ::core::ffi::c_void,
            workspace: *mut ::core::ffi::c_void,
            workSpaceSizeInBytes: usize,
            reserveSpace: *mut ::core::ffi::c_void,
            reserveSpaceSizeInBytes: usize,
            groupCnt: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnOpTensor: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            opTensorDesc: cudnnOpTensorDescriptor_t,
            alpha1: *const ::core::ffi::c_void,
            aDesc: cudnnTensorDescriptor_t,
            A: *const ::core::ffi::c_void,
            alpha2: *const ::core::ffi::c_void,
            bDesc: cudnnTensorDescriptor_t,
            B: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            cDesc: cudnnTensorDescriptor_t,
            C: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnOpsVersionCheck: unsafe extern "C" fn() -> cudnnStatus_t,
        pub cudnnPoolingBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            poolingDesc: cudnnPoolingDescriptor_t,
            alpha: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnPoolingForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            poolingDesc: cudnnPoolingDescriptor_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnQueryRuntimeError: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            rstatus: *mut cudnnStatus_t,
            mode: cudnnErrQueryMode_t,
            tag: *mut cudnnRuntimeTag_t,
        ) -> cudnnStatus_t,
        pub cudnnRNNBackwardData_v8: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            rnnDesc: cudnnRNNDescriptor_t,
            devSeqLengths: *const i32,
            yDesc: cudnnRNNDataDescriptor_t,
            y: *const ::core::ffi::c_void,
            dy: *const ::core::ffi::c_void,
            xDesc: cudnnRNNDataDescriptor_t,
            dx: *mut ::core::ffi::c_void,
            hDesc: cudnnTensorDescriptor_t,
            hx: *const ::core::ffi::c_void,
            dhy: *const ::core::ffi::c_void,
            dhx: *mut ::core::ffi::c_void,
            cDesc: cudnnTensorDescriptor_t,
            cx: *const ::core::ffi::c_void,
            dcy: *const ::core::ffi::c_void,
            dcx: *mut ::core::ffi::c_void,
            weightSpaceSize: usize,
            weightSpace: *const ::core::ffi::c_void,
            workSpaceSize: usize,
            workSpace: *mut ::core::ffi::c_void,
            reserveSpaceSize: usize,
            reserveSpace: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnRNNBackwardWeights_v8: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            rnnDesc: cudnnRNNDescriptor_t,
            addGrad: cudnnWgradMode_t,
            devSeqLengths: *const i32,
            xDesc: cudnnRNNDataDescriptor_t,
            x: *const ::core::ffi::c_void,
            hDesc: cudnnTensorDescriptor_t,
            hx: *const ::core::ffi::c_void,
            yDesc: cudnnRNNDataDescriptor_t,
            y: *const ::core::ffi::c_void,
            weightSpaceSize: usize,
            dweightSpace: *mut ::core::ffi::c_void,
            workSpaceSize: usize,
            workSpace: *mut ::core::ffi::c_void,
            reserveSpaceSize: usize,
            reserveSpace: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnRNNForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            rnnDesc: cudnnRNNDescriptor_t,
            fwdMode: cudnnForwardMode_t,
            devSeqLengths: *const i32,
            xDesc: cudnnRNNDataDescriptor_t,
            x: *const ::core::ffi::c_void,
            yDesc: cudnnRNNDataDescriptor_t,
            y: *mut ::core::ffi::c_void,
            hDesc: cudnnTensorDescriptor_t,
            hx: *const ::core::ffi::c_void,
            hy: *mut ::core::ffi::c_void,
            cDesc: cudnnTensorDescriptor_t,
            cx: *const ::core::ffi::c_void,
            cy: *mut ::core::ffi::c_void,
            weightSpaceSize: usize,
            weightSpace: *const ::core::ffi::c_void,
            workSpaceSize: usize,
            workSpace: *mut ::core::ffi::c_void,
            reserveSpaceSize: usize,
            reserveSpace: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnRNNGetClip_v8: unsafe extern "C" fn(
            rnnDesc: cudnnRNNDescriptor_t,
            clipMode: *mut cudnnRNNClipMode_t,
            clipNanOpt: *mut cudnnNanPropagation_t,
            lclip: *mut f64,
            rclip: *mut f64,
        ) -> cudnnStatus_t,
        pub cudnnRNNGetClip_v9: unsafe extern "C" fn(
            rnnDesc: cudnnRNNDescriptor_t,
            clipMode: *mut cudnnRNNClipMode_t,
            lclip: *mut f64,
            rclip: *mut f64,
        ) -> cudnnStatus_t,
        pub cudnnRNNSetClip_v8: unsafe extern "C" fn(
            rnnDesc: cudnnRNNDescriptor_t,
            clipMode: cudnnRNNClipMode_t,
            clipNanOpt: cudnnNanPropagation_t,
            lclip: f64,
            rclip: f64,
        ) -> cudnnStatus_t,
        pub cudnnRNNSetClip_v9: unsafe extern "C" fn(
            rnnDesc: cudnnRNNDescriptor_t,
            clipMode: cudnnRNNClipMode_t,
            lclip: f64,
            rclip: f64,
        ) -> cudnnStatus_t,
        pub cudnnReduceTensor: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            reduceTensorDesc: cudnnReduceTensorDescriptor_t,
            indices: *mut ::core::ffi::c_void,
            indicesSizeInBytes: usize,
            workspace: *mut ::core::ffi::c_void,
            workspaceSizeInBytes: usize,
            alpha: *const ::core::ffi::c_void,
            aDesc: cudnnTensorDescriptor_t,
            A: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            cDesc: cudnnTensorDescriptor_t,
            C: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnReorderFilterAndBias: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            filterDesc: cudnnFilterDescriptor_t,
            reorderType: cudnnReorderType_t,
            filterData: *const ::core::ffi::c_void,
            reorderedFilterData: *mut ::core::ffi::c_void,
            reorderBias: ::core::ffi::c_int,
            biasData: *const ::core::ffi::c_void,
            reorderedBiasData: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnRestoreDropoutDescriptor: unsafe extern "C" fn(
            dropoutDesc: cudnnDropoutDescriptor_t,
            handle: cudnnHandle_t,
            dropout: f32,
            states: *mut ::core::ffi::c_void,
            stateSizeInBytes: usize,
            seed: ::core::ffi::c_ulonglong,
        ) -> cudnnStatus_t,
        pub cudnnScaleTensor: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
            alpha: *const ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSetActivationDescriptor: unsafe extern "C" fn(
            activationDesc: cudnnActivationDescriptor_t,
            mode: cudnnActivationMode_t,
            reluNanOpt: cudnnNanPropagation_t,
            coef: f64,
        ) -> cudnnStatus_t,
        pub cudnnSetActivationDescriptorSwishBeta: unsafe extern "C" fn(
            activationDesc: cudnnActivationDescriptor_t,
            swish_beta: f64,
        ) -> cudnnStatus_t,
        pub cudnnSetAttnDescriptor: unsafe extern "C" fn(
            attnDesc: cudnnAttnDescriptor_t,
            attnMode: ::core::ffi::c_uint,
            nHeads: ::core::ffi::c_int,
            smScaler: f64,
            dataType: cudnnDataType_t,
            computePrec: cudnnDataType_t,
            mathType: cudnnMathType_t,
            attnDropoutDesc: cudnnDropoutDescriptor_t,
            postDropoutDesc: cudnnDropoutDescriptor_t,
            qSize: ::core::ffi::c_int,
            kSize: ::core::ffi::c_int,
            vSize: ::core::ffi::c_int,
            qProjSize: ::core::ffi::c_int,
            kProjSize: ::core::ffi::c_int,
            vProjSize: ::core::ffi::c_int,
            oProjSize: ::core::ffi::c_int,
            qoMaxSeqLength: ::core::ffi::c_int,
            kvMaxSeqLength: ::core::ffi::c_int,
            maxBatchSize: ::core::ffi::c_int,
            maxBeamSize: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetCTCLossDescriptor: unsafe extern "C" fn(
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            compType: cudnnDataType_t,
        ) -> cudnnStatus_t,
        pub cudnnSetCTCLossDescriptorEx: unsafe extern "C" fn(
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            compType: cudnnDataType_t,
            normMode: cudnnLossNormalizationMode_t,
            gradMode: cudnnNanPropagation_t,
        ) -> cudnnStatus_t,
        pub cudnnSetCTCLossDescriptor_v8: unsafe extern "C" fn(
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            compType: cudnnDataType_t,
            normMode: cudnnLossNormalizationMode_t,
            gradMode: cudnnNanPropagation_t,
            maxLabelLength: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetCTCLossDescriptor_v9: unsafe extern "C" fn(
            ctcLossDesc: cudnnCTCLossDescriptor_t,
            compType: cudnnDataType_t,
            normMode: cudnnLossNormalizationMode_t,
            ctcGradMode: cudnnCTCGradMode_t,
            maxLabelLength: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetCallback: unsafe extern "C" fn(
            mask: ::core::ffi::c_uint,
            udata: *mut ::core::ffi::c_void,
            fptr: cudnnCallback_t,
        ) -> cudnnStatus_t,
        pub cudnnSetConvolution2dDescriptor: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            pad_h: ::core::ffi::c_int,
            pad_w: ::core::ffi::c_int,
            u: ::core::ffi::c_int,
            v: ::core::ffi::c_int,
            dilation_h: ::core::ffi::c_int,
            dilation_w: ::core::ffi::c_int,
            mode: cudnnConvolutionMode_t,
            computeType: cudnnDataType_t,
        ) -> cudnnStatus_t,
        pub cudnnSetConvolutionGroupCount: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            groupCount: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetConvolutionMathType: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            mathType: cudnnMathType_t,
        ) -> cudnnStatus_t,
        pub cudnnSetConvolutionNdDescriptor: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            arrayLength: ::core::ffi::c_int,
            padA: *const ::core::ffi::c_int,
            filterStrideA: *const ::core::ffi::c_int,
            dilationA: *const ::core::ffi::c_int,
            mode: cudnnConvolutionMode_t,
            computeType: cudnnDataType_t,
        ) -> cudnnStatus_t,
        pub cudnnSetConvolutionReorderType: unsafe extern "C" fn(
            convDesc: cudnnConvolutionDescriptor_t,
            reorderType: cudnnReorderType_t,
        ) -> cudnnStatus_t,
        pub cudnnSetDropoutDescriptor: unsafe extern "C" fn(
            dropoutDesc: cudnnDropoutDescriptor_t,
            handle: cudnnHandle_t,
            dropout: f32,
            states: *mut ::core::ffi::c_void,
            stateSizeInBytes: usize,
            seed: ::core::ffi::c_ulonglong,
        ) -> cudnnStatus_t,
        pub cudnnSetFilter4dDescriptor: unsafe extern "C" fn(
            filterDesc: cudnnFilterDescriptor_t,
            dataType: cudnnDataType_t,
            format: cudnnTensorFormat_t,
            k: ::core::ffi::c_int,
            c: ::core::ffi::c_int,
            h: ::core::ffi::c_int,
            w: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetFilterNdDescriptor: unsafe extern "C" fn(
            filterDesc: cudnnFilterDescriptor_t,
            dataType: cudnnDataType_t,
            format: cudnnTensorFormat_t,
            nbDims: ::core::ffi::c_int,
            filterDimA: *const ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetFusedOpsConstParamPackAttribute: unsafe extern "C" fn(
            constPack: cudnnFusedOpsConstParamPack_t,
            paramLabel: cudnnFusedOpsConstParamLabel_t,
            param: *const ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSetFusedOpsVariantParamPackAttribute: unsafe extern "C" fn(
            varPack: cudnnFusedOpsVariantParamPack_t,
            paramLabel: cudnnFusedOpsVariantParamLabel_t,
            ptr: *mut ::core::ffi::c_void,
        )
            -> cudnnStatus_t,
        pub cudnnSetLRNDescriptor: unsafe extern "C" fn(
            normDesc: cudnnLRNDescriptor_t,
            lrnN: ::core::ffi::c_uint,
            lrnAlpha: f64,
            lrnBeta: f64,
            lrnK: f64,
        ) -> cudnnStatus_t,
        pub cudnnSetOpTensorDescriptor: unsafe extern "C" fn(
            opTensorDesc: cudnnOpTensorDescriptor_t,
            opTensorOp: cudnnOpTensorOp_t,
            opTensorCompType: cudnnDataType_t,
            opTensorNanOpt: cudnnNanPropagation_t,
        ) -> cudnnStatus_t,
        pub cudnnSetPooling2dDescriptor: unsafe extern "C" fn(
            poolingDesc: cudnnPoolingDescriptor_t,
            mode: cudnnPoolingMode_t,
            maxpoolingNanOpt: cudnnNanPropagation_t,
            windowHeight: ::core::ffi::c_int,
            windowWidth: ::core::ffi::c_int,
            verticalPadding: ::core::ffi::c_int,
            horizontalPadding: ::core::ffi::c_int,
            verticalStride: ::core::ffi::c_int,
            horizontalStride: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetPoolingNdDescriptor: unsafe extern "C" fn(
            poolingDesc: cudnnPoolingDescriptor_t,
            mode: cudnnPoolingMode_t,
            maxpoolingNanOpt: cudnnNanPropagation_t,
            nbDims: ::core::ffi::c_int,
            windowDimA: *const ::core::ffi::c_int,
            paddingA: *const ::core::ffi::c_int,
            strideA: *const ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetRNNDataDescriptor: unsafe extern "C" fn(
            rnnDataDesc: cudnnRNNDataDescriptor_t,
            dataType: cudnnDataType_t,
            layout: cudnnRNNDataLayout_t,
            maxSeqLength: ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
            vectorSize: ::core::ffi::c_int,
            seqLengthArray: *const ::core::ffi::c_int,
            paddingFill: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSetRNNDescriptor_v8: unsafe extern "C" fn(
            rnnDesc: cudnnRNNDescriptor_t,
            algo: cudnnRNNAlgo_t,
            cellMode: cudnnRNNMode_t,
            biasMode: cudnnRNNBiasMode_t,
            dirMode: cudnnDirectionMode_t,
            inputMode: cudnnRNNInputMode_t,
            dataType: cudnnDataType_t,
            mathPrec: cudnnDataType_t,
            mathType: cudnnMathType_t,
            inputSize: i32,
            hiddenSize: i32,
            projSize: i32,
            numLayers: i32,
            dropoutDesc: cudnnDropoutDescriptor_t,
            auxFlags: u32,
        ) -> cudnnStatus_t,
        pub cudnnSetReduceTensorDescriptor: unsafe extern "C" fn(
            reduceTensorDesc: cudnnReduceTensorDescriptor_t,
            reduceTensorOp: cudnnReduceTensorOp_t,
            reduceTensorCompType: cudnnDataType_t,
            reduceTensorNanOpt: cudnnNanPropagation_t,
            reduceTensorIndices: cudnnReduceTensorIndices_t,
            reduceTensorIndicesType: cudnnIndicesType_t,
        ) -> cudnnStatus_t,
        pub cudnnSetSeqDataDescriptor: unsafe extern "C" fn(
            seqDataDesc: cudnnSeqDataDescriptor_t,
            dataType: cudnnDataType_t,
            nbDims: ::core::ffi::c_int,
            dimA: *const ::core::ffi::c_int,
            axes: *const cudnnSeqDataAxis_t,
            seqLengthArraySize: usize,
            seqLengthArray: *const ::core::ffi::c_int,
            paddingFill: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSetSpatialTransformerNdDescriptor: unsafe extern "C" fn(
            stDesc: cudnnSpatialTransformerDescriptor_t,
            samplerType: cudnnSamplerType_t,
            dataType: cudnnDataType_t,
            nbDims: ::core::ffi::c_int,
            dimA: *const ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetStream:
            unsafe extern "C" fn(handle: cudnnHandle_t, streamId: cudaStream_t) -> cudnnStatus_t,
        pub cudnnSetTensor: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
            valuePtr: *const ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSetTensor4dDescriptor: unsafe extern "C" fn(
            tensorDesc: cudnnTensorDescriptor_t,
            format: cudnnTensorFormat_t,
            dataType: cudnnDataType_t,
            n: ::core::ffi::c_int,
            c: ::core::ffi::c_int,
            h: ::core::ffi::c_int,
            w: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetTensor4dDescriptorEx: unsafe extern "C" fn(
            tensorDesc: cudnnTensorDescriptor_t,
            dataType: cudnnDataType_t,
            n: ::core::ffi::c_int,
            c: ::core::ffi::c_int,
            h: ::core::ffi::c_int,
            w: ::core::ffi::c_int,
            nStride: ::core::ffi::c_int,
            cStride: ::core::ffi::c_int,
            hStride: ::core::ffi::c_int,
            wStride: ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetTensorNdDescriptor: unsafe extern "C" fn(
            tensorDesc: cudnnTensorDescriptor_t,
            dataType: cudnnDataType_t,
            nbDims: ::core::ffi::c_int,
            dimA: *const ::core::ffi::c_int,
            strideA: *const ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetTensorNdDescriptorEx: unsafe extern "C" fn(
            tensorDesc: cudnnTensorDescriptor_t,
            format: cudnnTensorFormat_t,
            dataType: cudnnDataType_t,
            nbDims: ::core::ffi::c_int,
            dimA: *const ::core::ffi::c_int,
        ) -> cudnnStatus_t,
        pub cudnnSetTensorTransformDescriptor: unsafe extern "C" fn(
            transformDesc: cudnnTensorTransformDescriptor_t,
            nbDims: u32,
            destFormat: cudnnTensorFormat_t,
            padBeforeA: *const i32,
            padAfterA: *const i32,
            foldA: *const u32,
            direction: cudnnFoldingDirection_t,
        ) -> cudnnStatus_t,
        pub cudnnSoftmaxBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            algo: cudnnSoftmaxAlgorithm_t,
            mode: cudnnSoftmaxMode_t,
            alpha: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSoftmaxForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            algo: cudnnSoftmaxAlgorithm_t,
            mode: cudnnSoftmaxMode_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSpatialTfGridGeneratorBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            stDesc: cudnnSpatialTransformerDescriptor_t,
            dgrid: *const ::core::ffi::c_void,
            dtheta: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSpatialTfGridGeneratorForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            stDesc: cudnnSpatialTransformerDescriptor_t,
            theta: *const ::core::ffi::c_void,
            grid: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSpatialTfSamplerBackward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            stDesc: cudnnSpatialTransformerDescriptor_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            dxDesc: cudnnTensorDescriptor_t,
            dx: *mut ::core::ffi::c_void,
            alphaDgrid: *const ::core::ffi::c_void,
            dyDesc: cudnnTensorDescriptor_t,
            dy: *const ::core::ffi::c_void,
            grid: *const ::core::ffi::c_void,
            betaDgrid: *const ::core::ffi::c_void,
            dgrid: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnSpatialTfSamplerForward: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            stDesc: cudnnSpatialTransformerDescriptor_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            grid: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnTransformFilter: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            transDesc: cudnnTensorTransformDescriptor_t,
            alpha: *const ::core::ffi::c_void,
            srcDesc: cudnnFilterDescriptor_t,
            srcData: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            destDesc: cudnnFilterDescriptor_t,
            destData: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnTransformTensor: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            alpha: *const ::core::ffi::c_void,
            xDesc: cudnnTensorDescriptor_t,
            x: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            yDesc: cudnnTensorDescriptor_t,
            y: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
        pub cudnnTransformTensorEx: unsafe extern "C" fn(
            handle: cudnnHandle_t,
            transDesc: cudnnTensorTransformDescriptor_t,
            alpha: *const ::core::ffi::c_void,
            srcDesc: cudnnTensorDescriptor_t,
            srcData: *const ::core::ffi::c_void,
            beta: *const ::core::ffi::c_void,
            destDesc: cudnnTensorDescriptor_t,
            destData: *mut ::core::ffi::c_void,
        ) -> cudnnStatus_t,
    }
    impl Lib {
        pub unsafe fn new<P>(path: P) -> Result<Self, ::libloading::Error>
        where
            P: AsRef<::std::ffi::OsStr>,
        {
            let library = ::libloading::Library::new(path)?;
            Self::from_library(library)
        }
        pub unsafe fn from_library<L>(library: L) -> Result<Self, ::libloading::Error>
        where
            L: Into<::libloading::Library>,
        {
            let __library = library.into();
            let cudnnActivationBackward = __library
                .get(b"cudnnActivationBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnActivationForward = __library
                .get(b"cudnnActivationForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnAddTensor = __library
                .get(b"cudnnAddTensor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnAdvVersionCheck = __library
                .get(b"cudnnAdvVersionCheck\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendCreateDescriptor = __library
                .get(b"cudnnBackendCreateDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendDestroyDescriptor = __library
                .get(b"cudnnBackendDestroyDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendExecute = __library
                .get(b"cudnnBackendExecute\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendFinalize = __library
                .get(b"cudnnBackendFinalize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendGetAttribute = __library
                .get(b"cudnnBackendGetAttribute\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendInitialize = __library
                .get(b"cudnnBackendInitialize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendPopulateCudaGraph = __library
                .get(b"cudnnBackendPopulateCudaGraph\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendSetAttribute = __library
                .get(b"cudnnBackendSetAttribute\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBackendUpdateCudaGraph = __library
                .get(b"cudnnBackendUpdateCudaGraph\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBatchNormalizationBackward = __library
                .get(b"cudnnBatchNormalizationBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBatchNormalizationBackwardEx = __library
                .get(b"cudnnBatchNormalizationBackwardEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBatchNormalizationForwardInference = __library
                .get(b"cudnnBatchNormalizationForwardInference\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBatchNormalizationForwardTraining = __library
                .get(b"cudnnBatchNormalizationForwardTraining\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBatchNormalizationForwardTrainingEx = __library
                .get(b"cudnnBatchNormalizationForwardTrainingEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnBuildRNNDynamic = __library
                .get(b"cudnnBuildRNNDynamic\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCTCLoss = __library
                .get(b"cudnnCTCLoss\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCTCLoss_v8 = __library
                .get(b"cudnnCTCLoss_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCnnVersionCheck = __library
                .get(b"cudnnCnnVersionCheck\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnConvolutionBackwardBias = __library
                .get(b"cudnnConvolutionBackwardBias\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnConvolutionBackwardData = __library
                .get(b"cudnnConvolutionBackwardData\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnConvolutionBackwardFilter = __library
                .get(b"cudnnConvolutionBackwardFilter\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnConvolutionBiasActivationForward = __library
                .get(b"cudnnConvolutionBiasActivationForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnConvolutionForward = __library
                .get(b"cudnnConvolutionForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreate = __library
                .get(b"cudnnCreate\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateActivationDescriptor = __library
                .get(b"cudnnCreateActivationDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateAttnDescriptor = __library
                .get(b"cudnnCreateAttnDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateCTCLossDescriptor = __library
                .get(b"cudnnCreateCTCLossDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateConvolutionDescriptor = __library
                .get(b"cudnnCreateConvolutionDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateDropoutDescriptor = __library
                .get(b"cudnnCreateDropoutDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateFilterDescriptor = __library
                .get(b"cudnnCreateFilterDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateFusedOpsConstParamPack = __library
                .get(b"cudnnCreateFusedOpsConstParamPack\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateFusedOpsPlan = __library
                .get(b"cudnnCreateFusedOpsPlan\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateFusedOpsVariantParamPack = __library
                .get(b"cudnnCreateFusedOpsVariantParamPack\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateLRNDescriptor = __library
                .get(b"cudnnCreateLRNDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateOpTensorDescriptor = __library
                .get(b"cudnnCreateOpTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreatePoolingDescriptor = __library
                .get(b"cudnnCreatePoolingDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateRNNDataDescriptor = __library
                .get(b"cudnnCreateRNNDataDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateRNNDescriptor = __library
                .get(b"cudnnCreateRNNDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateReduceTensorDescriptor = __library
                .get(b"cudnnCreateReduceTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateSeqDataDescriptor = __library
                .get(b"cudnnCreateSeqDataDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateSpatialTransformerDescriptor = __library
                .get(b"cudnnCreateSpatialTransformerDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateTensorDescriptor = __library
                .get(b"cudnnCreateTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnCreateTensorTransformDescriptor = __library
                .get(b"cudnnCreateTensorTransformDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDeriveBNTensorDescriptor = __library
                .get(b"cudnnDeriveBNTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDeriveNormTensorDescriptor = __library
                .get(b"cudnnDeriveNormTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroy = __library
                .get(b"cudnnDestroy\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyActivationDescriptor = __library
                .get(b"cudnnDestroyActivationDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyAttnDescriptor = __library
                .get(b"cudnnDestroyAttnDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyCTCLossDescriptor = __library
                .get(b"cudnnDestroyCTCLossDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyConvolutionDescriptor = __library
                .get(b"cudnnDestroyConvolutionDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyDropoutDescriptor = __library
                .get(b"cudnnDestroyDropoutDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyFilterDescriptor = __library
                .get(b"cudnnDestroyFilterDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyFusedOpsConstParamPack = __library
                .get(b"cudnnDestroyFusedOpsConstParamPack\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyFusedOpsPlan = __library
                .get(b"cudnnDestroyFusedOpsPlan\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyFusedOpsVariantParamPack = __library
                .get(b"cudnnDestroyFusedOpsVariantParamPack\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyLRNDescriptor = __library
                .get(b"cudnnDestroyLRNDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyOpTensorDescriptor = __library
                .get(b"cudnnDestroyOpTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyPoolingDescriptor = __library
                .get(b"cudnnDestroyPoolingDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyRNNDataDescriptor = __library
                .get(b"cudnnDestroyRNNDataDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyRNNDescriptor = __library
                .get(b"cudnnDestroyRNNDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyReduceTensorDescriptor = __library
                .get(b"cudnnDestroyReduceTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroySeqDataDescriptor = __library
                .get(b"cudnnDestroySeqDataDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroySpatialTransformerDescriptor = __library
                .get(b"cudnnDestroySpatialTransformerDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyTensorDescriptor = __library
                .get(b"cudnnDestroyTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDestroyTensorTransformDescriptor = __library
                .get(b"cudnnDestroyTensorTransformDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDivisiveNormalizationBackward = __library
                .get(b"cudnnDivisiveNormalizationBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDivisiveNormalizationForward = __library
                .get(b"cudnnDivisiveNormalizationForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDropoutBackward = __library
                .get(b"cudnnDropoutBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDropoutForward = __library
                .get(b"cudnnDropoutForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDropoutGetReserveSpaceSize = __library
                .get(b"cudnnDropoutGetReserveSpaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnDropoutGetStatesSize = __library
                .get(b"cudnnDropoutGetStatesSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnFindConvolutionBackwardDataAlgorithm = __library
                .get(b"cudnnFindConvolutionBackwardDataAlgorithm\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnFindConvolutionBackwardDataAlgorithmEx = __library
                .get(b"cudnnFindConvolutionBackwardDataAlgorithmEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnFindConvolutionBackwardFilterAlgorithm = __library
                .get(b"cudnnFindConvolutionBackwardFilterAlgorithm\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnFindConvolutionBackwardFilterAlgorithmEx = __library
                .get(b"cudnnFindConvolutionBackwardFilterAlgorithmEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnFindConvolutionForwardAlgorithm = __library
                .get(b"cudnnFindConvolutionForwardAlgorithm\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnFindConvolutionForwardAlgorithmEx = __library
                .get(b"cudnnFindConvolutionForwardAlgorithmEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnFusedOpsExecute = __library
                .get(b"cudnnFusedOpsExecute\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetActivationDescriptor = __library
                .get(b"cudnnGetActivationDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetActivationDescriptorSwishBeta = __library
                .get(b"cudnnGetActivationDescriptorSwishBeta\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetAttnDescriptor = __library
                .get(b"cudnnGetAttnDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetBatchNormalizationBackwardExWorkspaceSize = __library
                .get(b"cudnnGetBatchNormalizationBackwardExWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize = __library
                .get(b"cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetBatchNormalizationTrainingExReserveSpaceSize = __library
                .get(b"cudnnGetBatchNormalizationTrainingExReserveSpaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetCTCLossDescriptor = __library
                .get(b"cudnnGetCTCLossDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetCTCLossDescriptorEx = __library
                .get(b"cudnnGetCTCLossDescriptorEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetCTCLossDescriptor_v8 = __library
                .get(b"cudnnGetCTCLossDescriptor_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetCTCLossDescriptor_v9 = __library
                .get(b"cudnnGetCTCLossDescriptor_v9\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetCTCLossWorkspaceSize = __library
                .get(b"cudnnGetCTCLossWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetCTCLossWorkspaceSize_v8 = __library
                .get(b"cudnnGetCTCLossWorkspaceSize_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetCallback = __library
                .get(b"cudnnGetCallback\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolution2dDescriptor = __library
                .get(b"cudnnGetConvolution2dDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolution2dForwardOutputDim = __library
                .get(b"cudnnGetConvolution2dForwardOutputDim\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionBackwardDataAlgorithmMaxCount = __library
                .get(b"cudnnGetConvolutionBackwardDataAlgorithmMaxCount\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionBackwardDataAlgorithm_v7 = __library
                .get(b"cudnnGetConvolutionBackwardDataAlgorithm_v7\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionBackwardDataWorkspaceSize = __library
                .get(b"cudnnGetConvolutionBackwardDataWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionBackwardFilterAlgorithmMaxCount = __library
                .get(b"cudnnGetConvolutionBackwardFilterAlgorithmMaxCount\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionBackwardFilterAlgorithm_v7 = __library
                .get(b"cudnnGetConvolutionBackwardFilterAlgorithm_v7\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionBackwardFilterWorkspaceSize = __library
                .get(b"cudnnGetConvolutionBackwardFilterWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionForwardAlgorithmMaxCount = __library
                .get(b"cudnnGetConvolutionForwardAlgorithmMaxCount\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionForwardAlgorithm_v7 = __library
                .get(b"cudnnGetConvolutionForwardAlgorithm_v7\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionForwardWorkspaceSize = __library
                .get(b"cudnnGetConvolutionForwardWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionGroupCount = __library
                .get(b"cudnnGetConvolutionGroupCount\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionMathType = __library
                .get(b"cudnnGetConvolutionMathType\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionNdDescriptor = __library
                .get(b"cudnnGetConvolutionNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionNdForwardOutputDim = __library
                .get(b"cudnnGetConvolutionNdForwardOutputDim\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetConvolutionReorderType = __library
                .get(b"cudnnGetConvolutionReorderType\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetCudartVersion = __library
                .get(b"cudnnGetCudartVersion\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetDropoutDescriptor = __library
                .get(b"cudnnGetDropoutDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetErrorString = __library
                .get(b"cudnnGetErrorString\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetFilter4dDescriptor = __library
                .get(b"cudnnGetFilter4dDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetFilterNdDescriptor = __library
                .get(b"cudnnGetFilterNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetFilterSizeInBytes = __library
                .get(b"cudnnGetFilterSizeInBytes\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetFoldedConvBackwardDataDescriptors = __library
                .get(b"cudnnGetFoldedConvBackwardDataDescriptors\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetFusedOpsConstParamPackAttribute = __library
                .get(b"cudnnGetFusedOpsConstParamPackAttribute\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetFusedOpsVariantParamPackAttribute = __library
                .get(b"cudnnGetFusedOpsVariantParamPackAttribute\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetLRNDescriptor = __library
                .get(b"cudnnGetLRNDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetLastErrorString = __library
                .get(b"cudnnGetLastErrorString\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetMaxDeviceVersion = __library
                .get(b"cudnnGetMaxDeviceVersion\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetMultiHeadAttnBuffers = __library
                .get(b"cudnnGetMultiHeadAttnBuffers\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetMultiHeadAttnWeights = __library
                .get(b"cudnnGetMultiHeadAttnWeights\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetNormalizationBackwardWorkspaceSize = __library
                .get(b"cudnnGetNormalizationBackwardWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetNormalizationForwardTrainingWorkspaceSize = __library
                .get(b"cudnnGetNormalizationForwardTrainingWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetNormalizationTrainingReserveSpaceSize = __library
                .get(b"cudnnGetNormalizationTrainingReserveSpaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetOpTensorDescriptor = __library
                .get(b"cudnnGetOpTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetPooling2dDescriptor = __library
                .get(b"cudnnGetPooling2dDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetPooling2dForwardOutputDim = __library
                .get(b"cudnnGetPooling2dForwardOutputDim\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetPoolingNdDescriptor = __library
                .get(b"cudnnGetPoolingNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetPoolingNdForwardOutputDim = __library
                .get(b"cudnnGetPoolingNdForwardOutputDim\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetProperty = __library
                .get(b"cudnnGetProperty\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetRNNDataDescriptor = __library
                .get(b"cudnnGetRNNDataDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetRNNDescriptor_v8 = __library
                .get(b"cudnnGetRNNDescriptor_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetRNNTempSpaceSizes = __library
                .get(b"cudnnGetRNNTempSpaceSizes\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetRNNWeightParams = __library
                .get(b"cudnnGetRNNWeightParams\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetRNNWeightSpaceSize = __library
                .get(b"cudnnGetRNNWeightSpaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetReduceTensorDescriptor = __library
                .get(b"cudnnGetReduceTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetReductionIndicesSize = __library
                .get(b"cudnnGetReductionIndicesSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetReductionWorkspaceSize = __library
                .get(b"cudnnGetReductionWorkspaceSize\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetSeqDataDescriptor = __library
                .get(b"cudnnGetSeqDataDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetStream = __library
                .get(b"cudnnGetStream\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetTensor4dDescriptor = __library
                .get(b"cudnnGetTensor4dDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetTensorNdDescriptor = __library
                .get(b"cudnnGetTensorNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetTensorSizeInBytes = __library
                .get(b"cudnnGetTensorSizeInBytes\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetTensorTransformDescriptor = __library
                .get(b"cudnnGetTensorTransformDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGetVersion = __library
                .get(b"cudnnGetVersion\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnGraphVersionCheck = __library
                .get(b"cudnnGraphVersionCheck\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnIm2Col = __library
                .get(b"cudnnIm2Col\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnInitTransformDest = __library
                .get(b"cudnnInitTransformDest\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnLRNCrossChannelBackward = __library
                .get(b"cudnnLRNCrossChannelBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnLRNCrossChannelForward = __library
                .get(b"cudnnLRNCrossChannelForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnMakeFusedOpsPlan = __library
                .get(b"cudnnMakeFusedOpsPlan\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnMultiHeadAttnBackwardData = __library
                .get(b"cudnnMultiHeadAttnBackwardData\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnMultiHeadAttnBackwardWeights = __library
                .get(b"cudnnMultiHeadAttnBackwardWeights\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnMultiHeadAttnForward = __library
                .get(b"cudnnMultiHeadAttnForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnNormalizationBackward = __library
                .get(b"cudnnNormalizationBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnNormalizationForwardInference = __library
                .get(b"cudnnNormalizationForwardInference\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnNormalizationForwardTraining = __library
                .get(b"cudnnNormalizationForwardTraining\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnOpTensor = __library
                .get(b"cudnnOpTensor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnOpsVersionCheck = __library
                .get(b"cudnnOpsVersionCheck\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnPoolingBackward = __library
                .get(b"cudnnPoolingBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnPoolingForward = __library
                .get(b"cudnnPoolingForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnQueryRuntimeError = __library
                .get(b"cudnnQueryRuntimeError\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnRNNBackwardData_v8 = __library
                .get(b"cudnnRNNBackwardData_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnRNNBackwardWeights_v8 = __library
                .get(b"cudnnRNNBackwardWeights_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnRNNForward = __library
                .get(b"cudnnRNNForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnRNNGetClip_v8 = __library
                .get(b"cudnnRNNGetClip_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnRNNGetClip_v9 = __library
                .get(b"cudnnRNNGetClip_v9\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnRNNSetClip_v8 = __library
                .get(b"cudnnRNNSetClip_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnRNNSetClip_v9 = __library
                .get(b"cudnnRNNSetClip_v9\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnReduceTensor = __library
                .get(b"cudnnReduceTensor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnReorderFilterAndBias = __library
                .get(b"cudnnReorderFilterAndBias\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnRestoreDropoutDescriptor = __library
                .get(b"cudnnRestoreDropoutDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnScaleTensor = __library
                .get(b"cudnnScaleTensor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetActivationDescriptor = __library
                .get(b"cudnnSetActivationDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetActivationDescriptorSwishBeta = __library
                .get(b"cudnnSetActivationDescriptorSwishBeta\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetAttnDescriptor = __library
                .get(b"cudnnSetAttnDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetCTCLossDescriptor = __library
                .get(b"cudnnSetCTCLossDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetCTCLossDescriptorEx = __library
                .get(b"cudnnSetCTCLossDescriptorEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetCTCLossDescriptor_v8 = __library
                .get(b"cudnnSetCTCLossDescriptor_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetCTCLossDescriptor_v9 = __library
                .get(b"cudnnSetCTCLossDescriptor_v9\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetCallback = __library
                .get(b"cudnnSetCallback\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetConvolution2dDescriptor = __library
                .get(b"cudnnSetConvolution2dDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetConvolutionGroupCount = __library
                .get(b"cudnnSetConvolutionGroupCount\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetConvolutionMathType = __library
                .get(b"cudnnSetConvolutionMathType\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetConvolutionNdDescriptor = __library
                .get(b"cudnnSetConvolutionNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetConvolutionReorderType = __library
                .get(b"cudnnSetConvolutionReorderType\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetDropoutDescriptor = __library
                .get(b"cudnnSetDropoutDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetFilter4dDescriptor = __library
                .get(b"cudnnSetFilter4dDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetFilterNdDescriptor = __library
                .get(b"cudnnSetFilterNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetFusedOpsConstParamPackAttribute = __library
                .get(b"cudnnSetFusedOpsConstParamPackAttribute\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetFusedOpsVariantParamPackAttribute = __library
                .get(b"cudnnSetFusedOpsVariantParamPackAttribute\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetLRNDescriptor = __library
                .get(b"cudnnSetLRNDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetOpTensorDescriptor = __library
                .get(b"cudnnSetOpTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetPooling2dDescriptor = __library
                .get(b"cudnnSetPooling2dDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetPoolingNdDescriptor = __library
                .get(b"cudnnSetPoolingNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetRNNDataDescriptor = __library
                .get(b"cudnnSetRNNDataDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetRNNDescriptor_v8 = __library
                .get(b"cudnnSetRNNDescriptor_v8\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetReduceTensorDescriptor = __library
                .get(b"cudnnSetReduceTensorDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetSeqDataDescriptor = __library
                .get(b"cudnnSetSeqDataDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetSpatialTransformerNdDescriptor = __library
                .get(b"cudnnSetSpatialTransformerNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetStream = __library
                .get(b"cudnnSetStream\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetTensor = __library
                .get(b"cudnnSetTensor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetTensor4dDescriptor = __library
                .get(b"cudnnSetTensor4dDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetTensor4dDescriptorEx = __library
                .get(b"cudnnSetTensor4dDescriptorEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetTensorNdDescriptor = __library
                .get(b"cudnnSetTensorNdDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetTensorNdDescriptorEx = __library
                .get(b"cudnnSetTensorNdDescriptorEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSetTensorTransformDescriptor = __library
                .get(b"cudnnSetTensorTransformDescriptor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSoftmaxBackward = __library
                .get(b"cudnnSoftmaxBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSoftmaxForward = __library
                .get(b"cudnnSoftmaxForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSpatialTfGridGeneratorBackward = __library
                .get(b"cudnnSpatialTfGridGeneratorBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSpatialTfGridGeneratorForward = __library
                .get(b"cudnnSpatialTfGridGeneratorForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSpatialTfSamplerBackward = __library
                .get(b"cudnnSpatialTfSamplerBackward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnSpatialTfSamplerForward = __library
                .get(b"cudnnSpatialTfSamplerForward\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnTransformFilter = __library
                .get(b"cudnnTransformFilter\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnTransformTensor = __library
                .get(b"cudnnTransformTensor\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cudnnTransformTensorEx = __library
                .get(b"cudnnTransformTensorEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            Ok(Self {
                __library,
                cudnnActivationBackward,
                cudnnActivationForward,
                cudnnAddTensor,
                cudnnAdvVersionCheck,
                cudnnBackendCreateDescriptor,
                cudnnBackendDestroyDescriptor,
                cudnnBackendExecute,
                cudnnBackendFinalize,
                cudnnBackendGetAttribute,
                cudnnBackendInitialize,
                cudnnBackendPopulateCudaGraph,
                cudnnBackendSetAttribute,
                cudnnBackendUpdateCudaGraph,
                cudnnBatchNormalizationBackward,
                cudnnBatchNormalizationBackwardEx,
                cudnnBatchNormalizationForwardInference,
                cudnnBatchNormalizationForwardTraining,
                cudnnBatchNormalizationForwardTrainingEx,
                cudnnBuildRNNDynamic,
                cudnnCTCLoss,
                cudnnCTCLoss_v8,
                cudnnCnnVersionCheck,
                cudnnConvolutionBackwardBias,
                cudnnConvolutionBackwardData,
                cudnnConvolutionBackwardFilter,
                cudnnConvolutionBiasActivationForward,
                cudnnConvolutionForward,
                cudnnCreate,
                cudnnCreateActivationDescriptor,
                cudnnCreateAttnDescriptor,
                cudnnCreateCTCLossDescriptor,
                cudnnCreateConvolutionDescriptor,
                cudnnCreateDropoutDescriptor,
                cudnnCreateFilterDescriptor,
                cudnnCreateFusedOpsConstParamPack,
                cudnnCreateFusedOpsPlan,
                cudnnCreateFusedOpsVariantParamPack,
                cudnnCreateLRNDescriptor,
                cudnnCreateOpTensorDescriptor,
                cudnnCreatePoolingDescriptor,
                cudnnCreateRNNDataDescriptor,
                cudnnCreateRNNDescriptor,
                cudnnCreateReduceTensorDescriptor,
                cudnnCreateSeqDataDescriptor,
                cudnnCreateSpatialTransformerDescriptor,
                cudnnCreateTensorDescriptor,
                cudnnCreateTensorTransformDescriptor,
                cudnnDeriveBNTensorDescriptor,
                cudnnDeriveNormTensorDescriptor,
                cudnnDestroy,
                cudnnDestroyActivationDescriptor,
                cudnnDestroyAttnDescriptor,
                cudnnDestroyCTCLossDescriptor,
                cudnnDestroyConvolutionDescriptor,
                cudnnDestroyDropoutDescriptor,
                cudnnDestroyFilterDescriptor,
                cudnnDestroyFusedOpsConstParamPack,
                cudnnDestroyFusedOpsPlan,
                cudnnDestroyFusedOpsVariantParamPack,
                cudnnDestroyLRNDescriptor,
                cudnnDestroyOpTensorDescriptor,
                cudnnDestroyPoolingDescriptor,
                cudnnDestroyRNNDataDescriptor,
                cudnnDestroyRNNDescriptor,
                cudnnDestroyReduceTensorDescriptor,
                cudnnDestroySeqDataDescriptor,
                cudnnDestroySpatialTransformerDescriptor,
                cudnnDestroyTensorDescriptor,
                cudnnDestroyTensorTransformDescriptor,
                cudnnDivisiveNormalizationBackward,
                cudnnDivisiveNormalizationForward,
                cudnnDropoutBackward,
                cudnnDropoutForward,
                cudnnDropoutGetReserveSpaceSize,
                cudnnDropoutGetStatesSize,
                cudnnFindConvolutionBackwardDataAlgorithm,
                cudnnFindConvolutionBackwardDataAlgorithmEx,
                cudnnFindConvolutionBackwardFilterAlgorithm,
                cudnnFindConvolutionBackwardFilterAlgorithmEx,
                cudnnFindConvolutionForwardAlgorithm,
                cudnnFindConvolutionForwardAlgorithmEx,
                cudnnFusedOpsExecute,
                cudnnGetActivationDescriptor,
                cudnnGetActivationDescriptorSwishBeta,
                cudnnGetAttnDescriptor,
                cudnnGetBatchNormalizationBackwardExWorkspaceSize,
                cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize,
                cudnnGetBatchNormalizationTrainingExReserveSpaceSize,
                cudnnGetCTCLossDescriptor,
                cudnnGetCTCLossDescriptorEx,
                cudnnGetCTCLossDescriptor_v8,
                cudnnGetCTCLossDescriptor_v9,
                cudnnGetCTCLossWorkspaceSize,
                cudnnGetCTCLossWorkspaceSize_v8,
                cudnnGetCallback,
                cudnnGetConvolution2dDescriptor,
                cudnnGetConvolution2dForwardOutputDim,
                cudnnGetConvolutionBackwardDataAlgorithmMaxCount,
                cudnnGetConvolutionBackwardDataAlgorithm_v7,
                cudnnGetConvolutionBackwardDataWorkspaceSize,
                cudnnGetConvolutionBackwardFilterAlgorithmMaxCount,
                cudnnGetConvolutionBackwardFilterAlgorithm_v7,
                cudnnGetConvolutionBackwardFilterWorkspaceSize,
                cudnnGetConvolutionForwardAlgorithmMaxCount,
                cudnnGetConvolutionForwardAlgorithm_v7,
                cudnnGetConvolutionForwardWorkspaceSize,
                cudnnGetConvolutionGroupCount,
                cudnnGetConvolutionMathType,
                cudnnGetConvolutionNdDescriptor,
                cudnnGetConvolutionNdForwardOutputDim,
                cudnnGetConvolutionReorderType,
                cudnnGetCudartVersion,
                cudnnGetDropoutDescriptor,
                cudnnGetErrorString,
                cudnnGetFilter4dDescriptor,
                cudnnGetFilterNdDescriptor,
                cudnnGetFilterSizeInBytes,
                cudnnGetFoldedConvBackwardDataDescriptors,
                cudnnGetFusedOpsConstParamPackAttribute,
                cudnnGetFusedOpsVariantParamPackAttribute,
                cudnnGetLRNDescriptor,
                cudnnGetLastErrorString,
                cudnnGetMaxDeviceVersion,
                cudnnGetMultiHeadAttnBuffers,
                cudnnGetMultiHeadAttnWeights,
                cudnnGetNormalizationBackwardWorkspaceSize,
                cudnnGetNormalizationForwardTrainingWorkspaceSize,
                cudnnGetNormalizationTrainingReserveSpaceSize,
                cudnnGetOpTensorDescriptor,
                cudnnGetPooling2dDescriptor,
                cudnnGetPooling2dForwardOutputDim,
                cudnnGetPoolingNdDescriptor,
                cudnnGetPoolingNdForwardOutputDim,
                cudnnGetProperty,
                cudnnGetRNNDataDescriptor,
                cudnnGetRNNDescriptor_v8,
                cudnnGetRNNTempSpaceSizes,
                cudnnGetRNNWeightParams,
                cudnnGetRNNWeightSpaceSize,
                cudnnGetReduceTensorDescriptor,
                cudnnGetReductionIndicesSize,
                cudnnGetReductionWorkspaceSize,
                cudnnGetSeqDataDescriptor,
                cudnnGetStream,
                cudnnGetTensor4dDescriptor,
                cudnnGetTensorNdDescriptor,
                cudnnGetTensorSizeInBytes,
                cudnnGetTensorTransformDescriptor,
                cudnnGetVersion,
                cudnnGraphVersionCheck,
                cudnnIm2Col,
                cudnnInitTransformDest,
                cudnnLRNCrossChannelBackward,
                cudnnLRNCrossChannelForward,
                cudnnMakeFusedOpsPlan,
                cudnnMultiHeadAttnBackwardData,
                cudnnMultiHeadAttnBackwardWeights,
                cudnnMultiHeadAttnForward,
                cudnnNormalizationBackward,
                cudnnNormalizationForwardInference,
                cudnnNormalizationForwardTraining,
                cudnnOpTensor,
                cudnnOpsVersionCheck,
                cudnnPoolingBackward,
                cudnnPoolingForward,
                cudnnQueryRuntimeError,
                cudnnRNNBackwardData_v8,
                cudnnRNNBackwardWeights_v8,
                cudnnRNNForward,
                cudnnRNNGetClip_v8,
                cudnnRNNGetClip_v9,
                cudnnRNNSetClip_v8,
                cudnnRNNSetClip_v9,
                cudnnReduceTensor,
                cudnnReorderFilterAndBias,
                cudnnRestoreDropoutDescriptor,
                cudnnScaleTensor,
                cudnnSetActivationDescriptor,
                cudnnSetActivationDescriptorSwishBeta,
                cudnnSetAttnDescriptor,
                cudnnSetCTCLossDescriptor,
                cudnnSetCTCLossDescriptorEx,
                cudnnSetCTCLossDescriptor_v8,
                cudnnSetCTCLossDescriptor_v9,
                cudnnSetCallback,
                cudnnSetConvolution2dDescriptor,
                cudnnSetConvolutionGroupCount,
                cudnnSetConvolutionMathType,
                cudnnSetConvolutionNdDescriptor,
                cudnnSetConvolutionReorderType,
                cudnnSetDropoutDescriptor,
                cudnnSetFilter4dDescriptor,
                cudnnSetFilterNdDescriptor,
                cudnnSetFusedOpsConstParamPackAttribute,
                cudnnSetFusedOpsVariantParamPackAttribute,
                cudnnSetLRNDescriptor,
                cudnnSetOpTensorDescriptor,
                cudnnSetPooling2dDescriptor,
                cudnnSetPoolingNdDescriptor,
                cudnnSetRNNDataDescriptor,
                cudnnSetRNNDescriptor_v8,
                cudnnSetReduceTensorDescriptor,
                cudnnSetSeqDataDescriptor,
                cudnnSetSpatialTransformerNdDescriptor,
                cudnnSetStream,
                cudnnSetTensor,
                cudnnSetTensor4dDescriptor,
                cudnnSetTensor4dDescriptorEx,
                cudnnSetTensorNdDescriptor,
                cudnnSetTensorNdDescriptorEx,
                cudnnSetTensorTransformDescriptor,
                cudnnSoftmaxBackward,
                cudnnSoftmaxForward,
                cudnnSpatialTfGridGeneratorBackward,
                cudnnSpatialTfGridGeneratorForward,
                cudnnSpatialTfSamplerBackward,
                cudnnSpatialTfSamplerForward,
                cudnnTransformFilter,
                cudnnTransformTensor,
                cudnnTransformTensorEx,
            })
        }
    }
    pub unsafe fn culib() -> &'static Lib {
        static LIB: std::sync::OnceLock<Lib> = std::sync::OnceLock::new();
        LIB.get_or_init(|| {
            let lib_names = std::vec!["cudnn"];
            let choices: std::vec::Vec<_> = lib_names
                .iter()
                .map(|l| crate::get_lib_name_candidates(l))
                .flatten()
                .collect();
            for choice in choices.iter() {
                if let Ok(lib) = Lib::new(choice) {
                    return lib;
                }
            }
            crate::panic_no_lib_found(lib_names[0], &choices);
        })
    }
}
#[cfg(feature = "dynamic-loading")]
pub use loaded::*;
