#![cfg_attr(feature = "no-std", no_std)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(dead_code)]
#[cfg(feature = "no-std")]
extern crate alloc;
#[cfg(feature = "no-std")]
extern crate no_std_compat as std;
pub use self::cudaDataType as cublasDataType_t;
pub use self::cudaDataType_t as cudaDataType;
pub use self::libraryPropertyType_t as libraryPropertyType;
pub type cuComplex = cuFloatComplex;
pub type cuDoubleComplex = double2;
pub type cuFloatComplex = float2;
pub type cublasHandle_t = *mut cublasContext;
pub type cublasLogCallback =
    ::core::option::Option<unsafe extern "C" fn(msg: *const ::core::ffi::c_char)>;
pub type cudaStream_t = *mut CUstream_st;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasAtomicsMode_t {
    CUBLAS_ATOMICS_NOT_ALLOWED = 0,
    CUBLAS_ATOMICS_ALLOWED = 1,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasComputeType_t {
    CUBLAS_COMPUTE_16F = 64,
    CUBLAS_COMPUTE_16F_PEDANTIC = 65,
    CUBLAS_COMPUTE_32F = 68,
    CUBLAS_COMPUTE_32F_PEDANTIC = 69,
    CUBLAS_COMPUTE_32F_FAST_16F = 74,
    CUBLAS_COMPUTE_32F_FAST_16BF = 75,
    CUBLAS_COMPUTE_32F_FAST_TF32 = 77,
    CUBLAS_COMPUTE_64F = 70,
    CUBLAS_COMPUTE_64F_PEDANTIC = 71,
    CUBLAS_COMPUTE_32I = 72,
    CUBLAS_COMPUTE_32I_PEDANTIC = 73,
}
#[cfg(any(feature = "cuda-12090"))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasComputeType_t {
    CUBLAS_COMPUTE_16F = 64,
    CUBLAS_COMPUTE_16F_PEDANTIC = 65,
    CUBLAS_COMPUTE_32F = 68,
    CUBLAS_COMPUTE_32F_PEDANTIC = 69,
    CUBLAS_COMPUTE_32F_FAST_16F = 74,
    CUBLAS_COMPUTE_32F_FAST_16BF = 75,
    CUBLAS_COMPUTE_32F_FAST_TF32 = 77,
    CUBLAS_COMPUTE_32F_EMULATED_16BFX9 = 78,
    CUBLAS_COMPUTE_64F = 70,
    CUBLAS_COMPUTE_64F_PEDANTIC = 71,
    CUBLAS_COMPUTE_32I = 72,
    CUBLAS_COMPUTE_32I_PEDANTIC = 73,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasDiagType_t {
    CUBLAS_DIAG_NON_UNIT = 0,
    CUBLAS_DIAG_UNIT = 1,
}
#[cfg(any(feature = "cuda-12090"))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasEmulationStrategy_t {
    CUBLAS_EMULATION_STRATEGY_DEFAULT = 0,
    CUBLAS_EMULATION_STRATEGY_PERFORMANT = 1,
    CUBLAS_EMULATION_STRATEGY_EAGER = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasFillMode_t {
    CUBLAS_FILL_MODE_LOWER = 0,
    CUBLAS_FILL_MODE_UPPER = 1,
    CUBLAS_FILL_MODE_FULL = 2,
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasGemmAlgo_t {
    CUBLAS_GEMM_DFALT = -1,
    CUBLAS_GEMM_ALGO0 = 0,
    CUBLAS_GEMM_ALGO1 = 1,
    CUBLAS_GEMM_ALGO2 = 2,
    CUBLAS_GEMM_ALGO3 = 3,
    CUBLAS_GEMM_ALGO4 = 4,
    CUBLAS_GEMM_ALGO5 = 5,
    CUBLAS_GEMM_ALGO6 = 6,
    CUBLAS_GEMM_ALGO7 = 7,
    CUBLAS_GEMM_ALGO8 = 8,
    CUBLAS_GEMM_ALGO9 = 9,
    CUBLAS_GEMM_ALGO10 = 10,
    CUBLAS_GEMM_ALGO11 = 11,
    CUBLAS_GEMM_ALGO12 = 12,
    CUBLAS_GEMM_ALGO13 = 13,
    CUBLAS_GEMM_ALGO14 = 14,
    CUBLAS_GEMM_ALGO15 = 15,
    CUBLAS_GEMM_ALGO16 = 16,
    CUBLAS_GEMM_ALGO17 = 17,
    CUBLAS_GEMM_ALGO18 = 18,
    CUBLAS_GEMM_ALGO19 = 19,
    CUBLAS_GEMM_ALGO20 = 20,
    CUBLAS_GEMM_ALGO21 = 21,
    CUBLAS_GEMM_ALGO22 = 22,
    CUBLAS_GEMM_ALGO23 = 23,
    CUBLAS_GEMM_DEFAULT_TENSOR_OP = 99,
    CUBLAS_GEMM_ALGO0_TENSOR_OP = 100,
    CUBLAS_GEMM_ALGO1_TENSOR_OP = 101,
    CUBLAS_GEMM_ALGO2_TENSOR_OP = 102,
    CUBLAS_GEMM_ALGO3_TENSOR_OP = 103,
    CUBLAS_GEMM_ALGO4_TENSOR_OP = 104,
    CUBLAS_GEMM_ALGO5_TENSOR_OP = 105,
    CUBLAS_GEMM_ALGO6_TENSOR_OP = 106,
    CUBLAS_GEMM_ALGO7_TENSOR_OP = 107,
    CUBLAS_GEMM_ALGO8_TENSOR_OP = 108,
    CUBLAS_GEMM_ALGO9_TENSOR_OP = 109,
    CUBLAS_GEMM_ALGO10_TENSOR_OP = 110,
    CUBLAS_GEMM_ALGO11_TENSOR_OP = 111,
    CUBLAS_GEMM_ALGO12_TENSOR_OP = 112,
    CUBLAS_GEMM_ALGO13_TENSOR_OP = 113,
    CUBLAS_GEMM_ALGO14_TENSOR_OP = 114,
    CUBLAS_GEMM_ALGO15_TENSOR_OP = 115,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070",
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060",
    feature = "cuda-12080"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasMath_t {
    CUBLAS_DEFAULT_MATH = 0,
    CUBLAS_TENSOR_OP_MATH = 1,
    CUBLAS_PEDANTIC_MATH = 2,
    CUBLAS_TF32_TENSOR_OP_MATH = 3,
    CUBLAS_MATH_DISALLOW_REDUCED_PRECISION_REDUCTION = 16,
}
#[cfg(any(feature = "cuda-12090"))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasMath_t {
    CUBLAS_DEFAULT_MATH = 0,
    CUBLAS_TENSOR_OP_MATH = 1,
    CUBLAS_PEDANTIC_MATH = 2,
    CUBLAS_TF32_TENSOR_OP_MATH = 3,
    CUBLAS_FP32_EMULATED_BF16X9_MATH = 4,
    CUBLAS_MATH_DISALLOW_REDUCED_PRECISION_REDUCTION = 16,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasOperation_t {
    CUBLAS_OP_N = 0,
    CUBLAS_OP_T = 1,
    CUBLAS_OP_C = 2,
    CUBLAS_OP_CONJG = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasPointerMode_t {
    CUBLAS_POINTER_MODE_HOST = 0,
    CUBLAS_POINTER_MODE_DEVICE = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasSideMode_t {
    CUBLAS_SIDE_LEFT = 0,
    CUBLAS_SIDE_RIGHT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cublasStatus_t {
    CUBLAS_STATUS_SUCCESS = 0,
    CUBLAS_STATUS_NOT_INITIALIZED = 1,
    CUBLAS_STATUS_ALLOC_FAILED = 3,
    CUBLAS_STATUS_INVALID_VALUE = 7,
    CUBLAS_STATUS_ARCH_MISMATCH = 8,
    CUBLAS_STATUS_MAPPING_ERROR = 11,
    CUBLAS_STATUS_EXECUTION_FAILED = 13,
    CUBLAS_STATUS_INTERNAL_ERROR = 14,
    CUBLAS_STATUS_NOT_SUPPORTED = 15,
    CUBLAS_STATUS_LICENSE_ERROR = 16,
}
#[cfg(any(
    feature = "cuda-11040",
    feature = "cuda-11050",
    feature = "cuda-11060",
    feature = "cuda-11070"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudaDataType_t {
    CUDA_R_16F = 2,
    CUDA_C_16F = 6,
    CUDA_R_16BF = 14,
    CUDA_C_16BF = 15,
    CUDA_R_32F = 0,
    CUDA_C_32F = 4,
    CUDA_R_64F = 1,
    CUDA_C_64F = 5,
    CUDA_R_4I = 16,
    CUDA_C_4I = 17,
    CUDA_R_4U = 18,
    CUDA_C_4U = 19,
    CUDA_R_8I = 3,
    CUDA_C_8I = 7,
    CUDA_R_8U = 8,
    CUDA_C_8U = 9,
    CUDA_R_16I = 20,
    CUDA_C_16I = 21,
    CUDA_R_16U = 22,
    CUDA_C_16U = 23,
    CUDA_R_32I = 10,
    CUDA_C_32I = 11,
    CUDA_R_32U = 12,
    CUDA_C_32U = 13,
    CUDA_R_64I = 24,
    CUDA_C_64I = 25,
    CUDA_R_64U = 26,
    CUDA_C_64U = 27,
}
#[cfg(any(
    feature = "cuda-11080",
    feature = "cuda-12000",
    feature = "cuda-12010",
    feature = "cuda-12020",
    feature = "cuda-12030",
    feature = "cuda-12040",
    feature = "cuda-12050",
    feature = "cuda-12060"
))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudaDataType_t {
    CUDA_R_16F = 2,
    CUDA_C_16F = 6,
    CUDA_R_16BF = 14,
    CUDA_C_16BF = 15,
    CUDA_R_32F = 0,
    CUDA_C_32F = 4,
    CUDA_R_64F = 1,
    CUDA_C_64F = 5,
    CUDA_R_4I = 16,
    CUDA_C_4I = 17,
    CUDA_R_4U = 18,
    CUDA_C_4U = 19,
    CUDA_R_8I = 3,
    CUDA_C_8I = 7,
    CUDA_R_8U = 8,
    CUDA_C_8U = 9,
    CUDA_R_16I = 20,
    CUDA_C_16I = 21,
    CUDA_R_16U = 22,
    CUDA_C_16U = 23,
    CUDA_R_32I = 10,
    CUDA_C_32I = 11,
    CUDA_R_32U = 12,
    CUDA_C_32U = 13,
    CUDA_R_64I = 24,
    CUDA_C_64I = 25,
    CUDA_R_64U = 26,
    CUDA_C_64U = 27,
    CUDA_R_8F_E4M3 = 28,
    CUDA_R_8F_E5M2 = 29,
}
#[cfg(any(feature = "cuda-12080", feature = "cuda-12090"))]
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudaDataType_t {
    CUDA_R_16F = 2,
    CUDA_C_16F = 6,
    CUDA_R_16BF = 14,
    CUDA_C_16BF = 15,
    CUDA_R_32F = 0,
    CUDA_C_32F = 4,
    CUDA_R_64F = 1,
    CUDA_C_64F = 5,
    CUDA_R_4I = 16,
    CUDA_C_4I = 17,
    CUDA_R_4U = 18,
    CUDA_C_4U = 19,
    CUDA_R_8I = 3,
    CUDA_C_8I = 7,
    CUDA_R_8U = 8,
    CUDA_C_8U = 9,
    CUDA_R_16I = 20,
    CUDA_C_16I = 21,
    CUDA_R_16U = 22,
    CUDA_C_16U = 23,
    CUDA_R_32I = 10,
    CUDA_C_32I = 11,
    CUDA_R_32U = 12,
    CUDA_C_32U = 13,
    CUDA_R_64I = 24,
    CUDA_C_64I = 25,
    CUDA_R_64U = 26,
    CUDA_C_64U = 27,
    CUDA_R_8F_E4M3 = 28,
    CUDA_R_8F_E5M2 = 29,
    CUDA_R_8F_UE8M0 = 30,
    CUDA_R_6F_E2M3 = 31,
    CUDA_R_6F_E3M2 = 32,
    CUDA_R_4F_E2M1 = 33,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum libraryPropertyType_t {
    MAJOR_VERSION = 0,
    MINOR_VERSION = 1,
    PATCH_LEVEL = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUstream_st {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cublasContext {
    _unused: [u8; 0],
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct double2 {
    pub x: f64,
    pub y: f64,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone, PartialOrd, PartialEq)]
pub struct float2 {
    pub x: f32,
    pub y: f32,
}
impl cublasGemmAlgo_t {
    pub const CUBLAS_GEMM_DEFAULT: cublasGemmAlgo_t = cublasGemmAlgo_t::CUBLAS_GEMM_DFALT;
}
impl cublasGemmAlgo_t {
    pub const CUBLAS_GEMM_DFALT_TENSOR_OP: cublasGemmAlgo_t =
        cublasGemmAlgo_t::CUBLAS_GEMM_DEFAULT_TENSOR_OP;
}
impl cublasOperation_t {
    pub const CUBLAS_OP_HERMITAN: cublasOperation_t = cublasOperation_t::CUBLAS_OP_C;
}
#[cfg(any(feature = "cuda-12080", feature = "cuda-12090"))]
impl cudaDataType_t {
    pub const CUDA_R_8F_UE4M3: cudaDataType_t = cudaDataType_t::CUDA_R_8F_E4M3;
}
#[cfg(not(feature = "dynamic-loading"))]
extern "C" {
    pub fn cublasAsumEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasAsumEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasAxpyEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasAxpyEx_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasCaxpy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCaxpy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasCcopy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCcopy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasCdgmm(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCdgmm_64(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCdotc_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCdotc_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        result: *mut cuComplex,
    ) -> cublasStatus_t;
    pub fn cublasCdotu_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCdotu_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        result: *mut cuComplex,
    ) -> cublasStatus_t;
    pub fn cublasCgbmv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgbmv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgeam(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgeam_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        beta: *const cuComplex,
        B: *const cuComplex,
        ldb: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgelsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasCgemm3m(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasCgemm3mBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemm3mBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        Barray: *const *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgemm3mEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemm3mEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgemm3mStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemm3mStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemm3m_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgemmBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemmBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        Barray: *const *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgemmEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemmEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgemmStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemmStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgemm_v2(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemm_v2_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemvBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        xarray: *const *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        yarray: *const *mut cuComplex,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemvBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        xarray: *const *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        yarray: *const *mut cuComplex,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemvStridedBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemvStridedBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const cuComplex,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgemv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgemv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgeqrfBatched(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut cuComplex,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasCgerc_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgerc_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgeru_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCgeru_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasCgetrfBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasCgetriBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasCgetrsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut cuComplex,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasChbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasChbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasChemm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasChemm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasChemv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasChemv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasCher2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCher2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasCher2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCher2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCher_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCher_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const cuComplex,
        incx: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasCherk3mEx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCherk3mEx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCherkEx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCherkEx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCherk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCherk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const cuComplex,
        lda: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCherkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCherkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasChpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        AP: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasChpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        AP: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasChpr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasChpr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        AP: *mut cuComplex,
    ) -> cublasStatus_t;
    pub fn cublasChpr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasChpr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const cuComplex,
        incx: i64,
        AP: *mut cuComplex,
    ) -> cublasStatus_t;
    pub fn cublasCmatinvBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut cuComplex,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasCopyEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCopyEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasCreate_v2(handle: *mut cublasHandle_t) -> cublasStatus_t;
    pub fn cublasCrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const cuComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
        c: *const f32,
        s: *const cuComplex,
    ) -> cublasStatus_t;
    pub fn cublasCrotg_v2(
        handle: cublasHandle_t,
        a: *mut cuComplex,
        b: *mut cuComplex,
        c: *mut f32,
        s: *mut cuComplex,
    ) -> cublasStatus_t;
    pub fn cublasCscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t;
    pub fn cublasCsscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasCswap_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCswap_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsymm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsymm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsymv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsymv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsyr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsyr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsyr2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsyr2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsyr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsyr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsyrk3mEx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsyrk3mEx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsyrkEx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsyrkEx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsyrk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsyrk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCsyrkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCsyrkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtbsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtbsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtpsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtpsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtpttr(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasCtrmm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtrmm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtrmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtrmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtrsmBatched(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const *mut cuComplex,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtrsmBatched_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const *const cuComplex,
        lda: i64,
        B: *const *mut cuComplex,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtrsm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtrsm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *mut cuComplex,
        ldb: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtrsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasCtrsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasCtrttp(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t;
    pub fn cublasDasum_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDasum_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDaxpy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDaxpy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasDcopy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDcopy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasDdgmm(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDdgmm_64(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasDdot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDdot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        result: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDestroy_v2(handle: cublasHandle_t) -> cublasStatus_t;
    pub fn cublasDgbmv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgbmv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasDgeam(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgeam_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        beta: *const f64,
        B: *const f64,
        ldb: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasDgelsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut f64,
        lda: ::core::ffi::c_int,
        Carray: *const *mut f64,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasDgemmBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        Barray: *const *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        Carray: *const *mut f64,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemmBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: i64,
        Barray: *const *const f64,
        ldb: i64,
        beta: *const f64,
        Carray: *const *mut f64,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemmGroupedBatched(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const ::core::ffi::c_int,
        n_array: *const ::core::ffi::c_int,
        k_array: *const ::core::ffi::c_int,
        alpha_array: *const f64,
        Aarray: *const *const f64,
        lda_array: *const ::core::ffi::c_int,
        Barray: *const *const f64,
        ldb_array: *const ::core::ffi::c_int,
        beta_array: *const f64,
        Carray: *const *mut f64,
        ldc_array: *const ::core::ffi::c_int,
        group_count: ::core::ffi::c_int,
        group_size: *const ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemmGroupedBatched_64(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const i64,
        n_array: *const i64,
        k_array: *const i64,
        alpha_array: *const f64,
        Aarray: *const *const f64,
        lda_array: *const i64,
        Barray: *const *const f64,
        ldb_array: *const i64,
        beta_array: *const f64,
        Carray: *const *mut f64,
        ldc_array: *const i64,
        group_count: i64,
        group_size: *const i64,
    ) -> cublasStatus_t;
    pub fn cublasDgemmStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemmStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const f64,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasDgemm_v2(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemm_v2_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemvBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        xarray: *const *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        yarray: *const *mut f64,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemvBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: i64,
        xarray: *const *const f64,
        incx: i64,
        beta: *const f64,
        yarray: *const *mut f64,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemvStridedBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const f64,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemvStridedBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const f64,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasDgemv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDgemv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasDgeqrfBatched(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut f64,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut f64,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasDger_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDger_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasDgetrfBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut f64,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasDgetriBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut f64,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasDgetrsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut f64,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasDmatinvBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut f64,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasDnrm2_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDnrm2_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDotEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDotEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasDotcEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDotcEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasDrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t;
    pub fn cublasDrotg_v2(
        handle: cublasHandle_t,
        a: *mut f64,
        b: *mut f64,
        c: *mut f64,
        s: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDrotm_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        param: *const f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDrotm_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
        param: *const f64,
    ) -> cublasStatus_t;
    pub fn cublasDrotmg_v2(
        handle: cublasHandle_t,
        d1: *mut f64,
        d2: *mut f64,
        x1: *mut f64,
        y1: *const f64,
        param: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDsbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDsbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasDscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasDspmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        AP: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDspmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        AP: *const f64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasDspr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDspr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        AP: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDspr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDspr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        AP: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDswap_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDswap_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasDsymm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDsymm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasDsymv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDsymv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasDsyr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDsyr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasDsyr2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDsyr2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasDsyr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDsyr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasDsyrk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDsyrk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasDsyrkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDsyrkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtbsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtbsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtpsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtpsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtpttr(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasDtrmm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtrmm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtrmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtrmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtrsmBatched(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        B: *const *mut f64,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtrsmBatched_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const *const f64,
        lda: i64,
        B: *const *mut f64,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtrsm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtrsm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *mut f64,
        ldb: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtrsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDtrsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasDtrttp(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDzasum_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDzasum_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasDznrm2_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasDznrm2_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t;
    pub fn cublasGemmBatchedEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGemmBatchedEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        batchCount: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t;
    pub fn cublasGemmEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGemmEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGemmGroupedBatchedEx(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const ::core::ffi::c_int,
        n_array: *const ::core::ffi::c_int,
        k_array: *const ::core::ffi::c_int,
        alpha_array: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType_t,
        lda_array: *const ::core::ffi::c_int,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType_t,
        ldb_array: *const ::core::ffi::c_int,
        beta_array: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType_t,
        ldc_array: *const ::core::ffi::c_int,
        group_count: ::core::ffi::c_int,
        group_size: *const ::core::ffi::c_int,
        computeType: cublasComputeType_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGemmGroupedBatchedEx_64(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const i64,
        n_array: *const i64,
        k_array: *const i64,
        alpha_array: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType_t,
        lda_array: *const i64,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType_t,
        ldb_array: *const i64,
        beta_array: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType_t,
        ldc_array: *const i64,
        group_count: i64,
        group_size: *const i64,
        computeType: cublasComputeType_t,
    ) -> cublasStatus_t;
    pub fn cublasGemmStridedBatchedEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGemmStridedBatchedEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t;
    pub fn cublasGetAtomicsMode(
        handle: cublasHandle_t,
        mode: *mut cublasAtomicsMode_t,
    ) -> cublasStatus_t;
    pub fn cublasGetCudartVersion() -> usize;
    #[cfg(any(feature = "cuda-12090"))]
    pub fn cublasGetEmulationStrategy(
        handle: cublasHandle_t,
        emulationStrategy: *mut cublasEmulationStrategy_t,
    ) -> cublasStatus_t;
    pub fn cublasGetLoggerCallback(userCallback: *mut cublasLogCallback) -> cublasStatus_t;
    pub fn cublasGetMathMode(handle: cublasHandle_t, mode: *mut cublasMath_t) -> cublasStatus_t;
    pub fn cublasGetMatrix(
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasGetMatrixAsync(
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGetMatrixAsync_64(
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGetMatrix_64(
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
    ) -> cublasStatus_t;
    pub fn cublasGetPointerMode_v2(
        handle: cublasHandle_t,
        mode: *mut cublasPointerMode_t,
    ) -> cublasStatus_t;
    pub fn cublasGetProperty(
        type_: libraryPropertyType,
        value: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasGetSmCountTarget(
        handle: cublasHandle_t,
        smCountTarget: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasGetStatusName(status: cublasStatus_t) -> *const ::core::ffi::c_char;
    pub fn cublasGetStatusString(status: cublasStatus_t) -> *const ::core::ffi::c_char;
    pub fn cublasGetStream_v2(
        handle: cublasHandle_t,
        streamId: *mut cudaStream_t,
    ) -> cublasStatus_t;
    pub fn cublasGetVector(
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasGetVectorAsync(
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        devicePtr: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        hostPtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGetVectorAsync_64(
        n: i64,
        elemSize: i64,
        devicePtr: *const ::core::ffi::c_void,
        incx: i64,
        hostPtr: *mut ::core::ffi::c_void,
        incy: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasGetVector_64(
        n: i64,
        elemSize: i64,
        x: *const ::core::ffi::c_void,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasGetVersion_v2(
        handle: cublasHandle_t,
        version: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasIamaxEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIamaxEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIaminEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIaminEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIcamax_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIcamax_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIcamin_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIcamin_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIdamax_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIdamax_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIdamin_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIdamin_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIsamax_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIsamax_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIsamin_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIsamin_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIzamax_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIzamax_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasIzamin_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasIzamin_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t;
    pub fn cublasLoggerConfigure(
        logIsOn: ::core::ffi::c_int,
        logToStdOut: ::core::ffi::c_int,
        logToStdErr: ::core::ffi::c_int,
        logFileName: *const ::core::ffi::c_char,
    ) -> cublasStatus_t;
    pub fn cublasNrm2Ex(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasNrm2Ex_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasRotEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        c: *const ::core::ffi::c_void,
        s: *const ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasRotEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        c: *const ::core::ffi::c_void,
        s: *const ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasRotgEx(
        handle: cublasHandle_t,
        a: *mut ::core::ffi::c_void,
        b: *mut ::core::ffi::c_void,
        abType: cudaDataType,
        c: *mut ::core::ffi::c_void,
        s: *mut ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasRotmEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        param: *const ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasRotmEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        param: *const ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasRotmgEx(
        handle: cublasHandle_t,
        d1: *mut ::core::ffi::c_void,
        d1Type: cudaDataType,
        d2: *mut ::core::ffi::c_void,
        d2Type: cudaDataType,
        x1: *mut ::core::ffi::c_void,
        x1Type: cudaDataType,
        y1: *const ::core::ffi::c_void,
        y1Type: cudaDataType,
        param: *mut ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasSasum_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSasum_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasSaxpy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSaxpy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasScalEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        executionType: cudaDataType,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasScalEx_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        executionType: cudaDataType,
    ) -> cublasStatus_t;
    pub fn cublasScasum_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasScasum_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasScnrm2_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasScnrm2_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasScopy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasScopy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasSdgmm(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSdgmm_64(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasSdot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSdot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        result: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasSetAtomicsMode(
        handle: cublasHandle_t,
        mode: cublasAtomicsMode_t,
    ) -> cublasStatus_t;
    #[cfg(any(feature = "cuda-12090"))]
    pub fn cublasSetEmulationStrategy(
        handle: cublasHandle_t,
        emulationStrategy: cublasEmulationStrategy_t,
    ) -> cublasStatus_t;
    pub fn cublasSetLoggerCallback(userCallback: cublasLogCallback) -> cublasStatus_t;
    pub fn cublasSetMathMode(handle: cublasHandle_t, mode: cublasMath_t) -> cublasStatus_t;
    pub fn cublasSetMatrix(
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSetMatrixAsync(
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSetMatrixAsync_64(
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSetMatrix_64(
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
    ) -> cublasStatus_t;
    pub fn cublasSetPointerMode_v2(
        handle: cublasHandle_t,
        mode: cublasPointerMode_t,
    ) -> cublasStatus_t;
    pub fn cublasSetSmCountTarget(
        handle: cublasHandle_t,
        smCountTarget: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSetStream_v2(handle: cublasHandle_t, streamId: cudaStream_t) -> cublasStatus_t;
    pub fn cublasSetVector(
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        devicePtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSetVectorAsync(
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        hostPtr: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        devicePtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSetVectorAsync_64(
        n: i64,
        elemSize: i64,
        hostPtr: *const ::core::ffi::c_void,
        incx: i64,
        devicePtr: *mut ::core::ffi::c_void,
        incy: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSetVector_64(
        n: i64,
        elemSize: i64,
        x: *const ::core::ffi::c_void,
        incx: i64,
        devicePtr: *mut ::core::ffi::c_void,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasSetWorkspace_v2(
        handle: cublasHandle_t,
        workspace: *mut ::core::ffi::c_void,
        workspaceSizeInBytes: usize,
    ) -> cublasStatus_t;
    pub fn cublasSgbmv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgbmv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasSgeam(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgeam_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        beta: *const f32,
        B: *const f32,
        ldb: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasSgelsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut f32,
        lda: ::core::ffi::c_int,
        Carray: *const *mut f32,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSgemmBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        Barray: *const *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        Carray: *const *mut f32,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemmBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: i64,
        Barray: *const *const f32,
        ldb: i64,
        beta: *const f32,
        Carray: *const *mut f32,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasSgemmEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemmEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemmGroupedBatched(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const ::core::ffi::c_int,
        n_array: *const ::core::ffi::c_int,
        k_array: *const ::core::ffi::c_int,
        alpha_array: *const f32,
        Aarray: *const *const f32,
        lda_array: *const ::core::ffi::c_int,
        Barray: *const *const f32,
        ldb_array: *const ::core::ffi::c_int,
        beta_array: *const f32,
        Carray: *const *mut f32,
        ldc_array: *const ::core::ffi::c_int,
        group_count: ::core::ffi::c_int,
        group_size: *const ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemmGroupedBatched_64(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const i64,
        n_array: *const i64,
        k_array: *const i64,
        alpha_array: *const f32,
        Aarray: *const *const f32,
        lda_array: *const i64,
        Barray: *const *const f32,
        ldb_array: *const i64,
        beta_array: *const f32,
        Carray: *const *mut f32,
        ldc_array: *const i64,
        group_count: i64,
        group_size: *const i64,
    ) -> cublasStatus_t;
    pub fn cublasSgemmStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemmStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const f32,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasSgemm_v2(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemm_v2_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemvBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        xarray: *const *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        yarray: *const *mut f32,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemvBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: i64,
        xarray: *const *const f32,
        incx: i64,
        beta: *const f32,
        yarray: *const *mut f32,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemvStridedBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const f32,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemvStridedBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const f32,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasSgemv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSgemv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasSgeqrfBatched(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut f32,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut f32,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSger_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSger_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasSgetrfBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut f32,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSgetriBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut f32,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSgetrsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut f32,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSmatinvBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut f32,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasSnrm2_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSnrm2_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasSrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t;
    pub fn cublasSrotg_v2(
        handle: cublasHandle_t,
        a: *mut f32,
        b: *mut f32,
        c: *mut f32,
        s: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasSrotm_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        param: *const f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSrotm_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
        param: *const f32,
    ) -> cublasStatus_t;
    pub fn cublasSrotmg_v2(
        handle: cublasHandle_t,
        d1: *mut f32,
        d2: *mut f32,
        x1: *mut f32,
        y1: *const f32,
        param: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasSsbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSsbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasSscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasSspmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        AP: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSspmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        AP: *const f32,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasSspr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSspr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        AP: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasSspr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSspr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        AP: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasSswap_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSswap_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasSsymm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSsymm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasSsymv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSsymv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasSsyr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSsyr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasSsyr2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSsyr2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasSsyr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSsyr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasSsyrk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSsyrk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasSsyrkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSsyrkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasStbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasStbsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStbsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasStpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasStpsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStpsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasStpttr(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasStrmm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStrmm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasStrmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStrmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasStrsmBatched(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        B: *const *mut f32,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStrsmBatched_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const *const f32,
        lda: i64,
        B: *const *mut f32,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasStrsm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStrsm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *mut f32,
        ldb: i64,
    ) -> cublasStatus_t;
    pub fn cublasStrsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasStrsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasStrttp(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t;
    pub fn cublasSwapEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasSwapEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasUint8gemmBias(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        transc: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const ::core::ffi::c_uchar,
        A_bias: ::core::ffi::c_int,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_uchar,
        B_bias: ::core::ffi::c_int,
        ldb: ::core::ffi::c_int,
        C: *mut ::core::ffi::c_uchar,
        C_bias: ::core::ffi::c_int,
        ldc: ::core::ffi::c_int,
        C_mult: ::core::ffi::c_int,
        C_shift: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasXerbla(srName: *const ::core::ffi::c_char, info: ::core::ffi::c_int);
    pub fn cublasZaxpy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZaxpy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZcopy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZcopy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZdgmm(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZdgmm_64(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZdotc_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZdotc_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    pub fn cublasZdotu_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZdotu_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    pub fn cublasZdrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZdrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t;
    pub fn cublasZdscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZdscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgbmv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgbmv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgeam(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgeam_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgelsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Carray: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasZgemm3m(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemm3m_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgemmBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        Carray: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemmBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: i64,
        Barray: *const *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        Carray: *const *mut cuDoubleComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgemmStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemmStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuDoubleComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgemm_v2(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemm_v2_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemvBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        xarray: *const *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        yarray: *const *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemvBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: i64,
        xarray: *const *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        yarray: *const *mut cuDoubleComplex,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemvStridedBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemvStridedBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const cuDoubleComplex,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgemv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgemv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgeqrfBatched(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut cuDoubleComplex,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasZgerc_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgerc_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgeru_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZgeru_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasZgetrfBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasZgetriBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasZgetrsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasZhbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZhbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZhemm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZhemm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZhemv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZhemv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZher2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZher2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasZher2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZher2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZher_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZher_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasZherk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZherk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZherkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZherkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZhpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        AP: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZhpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        AP: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZhpr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZhpr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    pub fn cublasZhpr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZhpr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: i64,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    pub fn cublasZmatinvBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut cuDoubleComplex,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasZrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const cuDoubleComplex,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
        c: *const f64,
        s: *const cuDoubleComplex,
    ) -> cublasStatus_t;
    pub fn cublasZrotg_v2(
        handle: cublasHandle_t,
        a: *mut cuDoubleComplex,
        b: *mut cuDoubleComplex,
        c: *mut f64,
        s: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
    pub fn cublasZscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasZswap_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZswap_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZsymm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZsymm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZsymv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZsymv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t;
    pub fn cublasZsyr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZsyr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasZsyr2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZsyr2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZsyr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZsyr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t;
    pub fn cublasZsyrk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZsyrk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZsyrkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZsyrkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtbsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtbsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtpsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtpsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtpttr(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    pub fn cublasZtrmm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtrmm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtrmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtrmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtrsmBatched(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtrsmBatched_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const *const cuDoubleComplex,
        lda: i64,
        B: *const *mut cuDoubleComplex,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtrsm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtrsm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *mut cuDoubleComplex,
        ldb: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtrsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t;
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub fn cublasZtrsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t;
    pub fn cublasZtrttp(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t;
}
#[cfg(feature = "dynamic-loading")]
mod loaded {
    use super::*;
    pub unsafe fn cublasAsumEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasAsumEx)(handle, n, x, xType, incx, result, resultType, executiontype)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasAsumEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasAsumEx_64)(handle, n, x, xType, incx, result, resultType, executiontype)
    }
    pub unsafe fn cublasAxpyEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasAxpyEx)(
            handle,
            n,
            alpha,
            alphaType,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            executiontype,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasAxpyEx_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasAxpyEx_64)(
            handle,
            n,
            alpha,
            alphaType,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            executiontype,
        )
    }
    pub unsafe fn cublasCaxpy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCaxpy_v2)(handle, n, alpha, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCaxpy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasCaxpy_v2_64)(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasCcopy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCcopy_v2)(handle, n, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCcopy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasCcopy_v2_64)(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasCdgmm(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCdgmm)(handle, mode, m, n, A, lda, x, incx, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCdgmm_64(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCdgmm_64)(handle, mode, m, n, A, lda, x, incx, C, ldc)
    }
    pub unsafe fn cublasCdotc_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasCdotc_v2)(handle, n, x, incx, y, incy, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCdotc_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        result: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasCdotc_v2_64)(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasCdotu_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasCdotu_v2)(handle, n, x, incx, y, incy, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCdotu_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        result: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasCdotu_v2_64)(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasCgbmv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgbmv_v2)(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgbmv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgbmv_v2_64)(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasCgeam(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgeam)(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgeam_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        beta: *const cuComplex,
        B: *const cuComplex,
        ldb: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgeam_64)(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasCgelsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgelsBatched)(
            handle,
            trans,
            m,
            n,
            nrhs,
            Aarray,
            lda,
            Carray,
            ldc,
            info,
            devInfoArray,
            batchSize,
        )
    }
    pub unsafe fn cublasCgemm3m(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemm3m)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCgemm3mBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemm3mBatched)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemm3mBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        Barray: *const *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemm3mBatched_64)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemm3mEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemm3mEx)(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemm3mEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemm3mEx_64)(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    pub unsafe fn cublasCgemm3mStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemm3mStridedBatched)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemm3mStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemm3mStridedBatched_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemm3m_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemm3m_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCgemmBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemmBatched)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemmBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        Barray: *const *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        Carray: *const *mut cuComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemmBatched_64)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemmEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemmEx)(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemmEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemmEx_64)(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    pub unsafe fn cublasCgemmStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemmStridedBatched)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemmStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemmStridedBatched_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasCgemm_v2(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemm_v2)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemm_v2_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemm_v2_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemvBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        xarray: *const *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        yarray: *const *mut cuComplex,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemvBatched)(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemvBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        Aarray: *const *const cuComplex,
        lda: i64,
        xarray: *const *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        yarray: *const *mut cuComplex,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemvBatched_64)(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemvStridedBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemvStridedBatched)(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemvStridedBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const cuComplex,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemvStridedBatched_64)(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasCgemv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgemv_v2)(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgemv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgemv_v2_64)(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasCgeqrfBatched(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut cuComplex,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgeqrfBatched)(handle, m, n, Aarray, lda, TauArray, info, batchSize)
    }
    pub unsafe fn cublasCgerc_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgerc_v2)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgerc_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgerc_v2_64)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasCgeru_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgeru_v2)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCgeru_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasCgeru_v2_64)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasCgetrfBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut cuComplex,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgetrfBatched)(handle, n, A, lda, P, info, batchSize)
    }
    pub unsafe fn cublasCgetriBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut cuComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgetriBatched)(handle, n, A, lda, P, C, ldc, info, batchSize)
    }
    pub unsafe fn cublasCgetrsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut cuComplex,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCgetrsBatched)(
            handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize,
        )
    }
    pub unsafe fn cublasChbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasChbmv_v2)(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasChbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasChbmv_v2_64)(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasChemm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasChemm_v2)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasChemm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasChemm_v2_64)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasChemv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasChemv_v2)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasChemv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasChemv_v2_64)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasCher2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCher2_v2)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCher2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasCher2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasCher2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCher2k_v2)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCher2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCher2k_v2_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCher_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCher_v2)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCher_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const cuComplex,
        incx: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasCher_v2_64)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    pub unsafe fn cublasCherk3mEx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCherk3mEx)(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCherk3mEx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCherk3mEx_64)(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCherkEx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCherkEx)(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCherkEx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCherkEx_64)(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCherk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCherk_v2)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCherk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const cuComplex,
        lda: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCherk_v2_64)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    pub unsafe fn cublasCherkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCherkx)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCherkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const f32,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCherkx_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasChpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        AP: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasChpmv_v2)(handle, uplo, n, alpha, AP, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasChpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        AP: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasChpmv_v2_64)(handle, uplo, n, alpha, AP, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasChpr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasChpr2_v2)(handle, uplo, n, alpha, x, incx, y, incy, AP)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasChpr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasChpr2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, AP)
    }
    pub unsafe fn cublasChpr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasChpr_v2)(handle, uplo, n, alpha, x, incx, AP)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasChpr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const cuComplex,
        incx: i64,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasChpr_v2_64)(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasCmatinvBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut cuComplex,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCmatinvBatched)(handle, n, A, lda, Ainv, lda_inv, info, batchSize)
    }
    pub unsafe fn cublasCopyEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCopyEx)(handle, n, x, xType, incx, y, yType, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCopyEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasCopyEx_64)(handle, n, x, xType, incx, y, yType, incy)
    }
    pub unsafe fn cublasCreate_v2(handle: *mut cublasHandle_t) -> cublasStatus_t {
        (culib().cublasCreate_v2)(handle)
    }
    pub unsafe fn cublasCrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasCrot_v2)(handle, n, x, incx, y, incy, c, s)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
        c: *const f32,
        s: *const cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasCrot_v2_64)(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasCrotg_v2(
        handle: cublasHandle_t,
        a: *mut cuComplex,
        b: *mut cuComplex,
        c: *mut f32,
        s: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasCrotg_v2)(handle, a, b, c, s)
    }
    pub unsafe fn cublasCscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCscal_v2)(handle, n, alpha, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasCscal_v2_64)(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasCsrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t {
        (culib().cublasCsrot_v2)(handle, n, x, incx, y, incy, c, s)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t {
        (culib().cublasCsrot_v2_64)(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasCsscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsscal_v2)(handle, n, alpha, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsscal_v2_64)(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasCswap_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCswap_v2)(handle, n, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCswap_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuComplex,
        incx: i64,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasCswap_v2_64)(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasCsymm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsymm_v2)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsymm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsymm_v2_64)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsymv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsymv_v2)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsymv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        x: *const cuComplex,
        incx: i64,
        beta: *const cuComplex,
        y: *mut cuComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsymv_v2_64)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasCsyr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        y: *const cuComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsyr2_v2)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsyr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        y: *const cuComplex,
        incy: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsyr2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasCsyr2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsyr2k_v2)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsyr2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsyr2k_v2_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCsyr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsyr_v2)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsyr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuComplex,
        x: *const cuComplex,
        incx: i64,
        A: *mut cuComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsyr_v2_64)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    pub unsafe fn cublasCsyrk3mEx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsyrk3mEx)(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsyrk3mEx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsyrk3mEx_64)(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCsyrkEx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsyrkEx)(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsyrkEx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        beta: *const cuComplex,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsyrkEx_64)(
            handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc,
        )
    }
    pub unsafe fn cublasCsyrk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsyrk_v2)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsyrk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsyrk_v2_64)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    pub unsafe fn cublasCsyrkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCsyrkx)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCsyrkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        beta: *const cuComplex,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCsyrkx_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasCtbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtbmv_v2)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtbmv_v2_64)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    pub unsafe fn cublasCtbsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtbsv_v2)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtbsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtbsv_v2_64)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    pub unsafe fn cublasCtpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtpmv_v2)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtpmv_v2_64)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    pub unsafe fn cublasCtpsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtpsv_v2)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtpsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuComplex,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtpsv_v2_64)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    pub unsafe fn cublasCtpttr(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const cuComplex,
        A: *mut cuComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtpttr)(handle, uplo, n, AP, A, lda)
    }
    pub unsafe fn cublasCtrmm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const cuComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtrmm_v2)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtrmm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *const cuComplex,
        ldb: i64,
        C: *mut cuComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtrmm_v2_64)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasCtrmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtrmv_v2)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtrmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtrmv_v2_64)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    pub unsafe fn cublasCtrsmBatched(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *const *mut cuComplex,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtrsmBatched)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtrsmBatched_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const *const cuComplex,
        lda: i64,
        B: *const *mut cuComplex,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtrsmBatched_64)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasCtrsm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        B: *mut cuComplex,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtrsm_v2)(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtrsm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuComplex,
        A: *const cuComplex,
        lda: i64,
        B: *mut cuComplex,
        ldb: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtrsm_v2_64)(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb)
    }
    pub unsafe fn cublasCtrsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasCtrsv_v2)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasCtrsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuComplex,
        lda: i64,
        x: *mut cuComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasCtrsv_v2_64)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    pub unsafe fn cublasCtrttp(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const cuComplex,
        lda: ::core::ffi::c_int,
        AP: *mut cuComplex,
    ) -> cublasStatus_t {
        (culib().cublasCtrttp)(handle, uplo, n, A, lda, AP)
    }
    pub unsafe fn cublasDasum_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDasum_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDasum_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDasum_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDaxpy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDaxpy_v2)(handle, n, alpha, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDaxpy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasDaxpy_v2_64)(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasDcopy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDcopy_v2)(handle, n, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDcopy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasDcopy_v2_64)(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasDdgmm(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDdgmm)(handle, mode, m, n, A, lda, x, incx, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDdgmm_64(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasDdgmm_64)(handle, mode, m, n, A, lda, x, incx, C, ldc)
    }
    pub unsafe fn cublasDdot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDdot_v2)(handle, n, x, incx, y, incy, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDdot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDdot_v2_64)(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasDestroy_v2(handle: cublasHandle_t) -> cublasStatus_t {
        (culib().cublasDestroy_v2)(handle)
    }
    pub unsafe fn cublasDgbmv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgbmv_v2)(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgbmv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasDgbmv_v2_64)(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasDgeam(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgeam)(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgeam_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        beta: *const f64,
        B: *const f64,
        ldb: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasDgeam_64)(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasDgelsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut f64,
        lda: ::core::ffi::c_int,
        Carray: *const *mut f64,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgelsBatched)(
            handle,
            trans,
            m,
            n,
            nrhs,
            Aarray,
            lda,
            Carray,
            ldc,
            info,
            devInfoArray,
            batchSize,
        )
    }
    pub unsafe fn cublasDgemmBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        Barray: *const *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        Carray: *const *mut f64,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgemmBatched)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemmBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: i64,
        Barray: *const *const f64,
        ldb: i64,
        beta: *const f64,
        Carray: *const *mut f64,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasDgemmBatched_64)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemmGroupedBatched(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const ::core::ffi::c_int,
        n_array: *const ::core::ffi::c_int,
        k_array: *const ::core::ffi::c_int,
        alpha_array: *const f64,
        Aarray: *const *const f64,
        lda_array: *const ::core::ffi::c_int,
        Barray: *const *const f64,
        ldb_array: *const ::core::ffi::c_int,
        beta_array: *const f64,
        Carray: *const *mut f64,
        ldc_array: *const ::core::ffi::c_int,
        group_count: ::core::ffi::c_int,
        group_size: *const ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgemmGroupedBatched)(
            handle,
            transa_array,
            transb_array,
            m_array,
            n_array,
            k_array,
            alpha_array,
            Aarray,
            lda_array,
            Barray,
            ldb_array,
            beta_array,
            Carray,
            ldc_array,
            group_count,
            group_size,
        )
    }
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemmGroupedBatched_64(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const i64,
        n_array: *const i64,
        k_array: *const i64,
        alpha_array: *const f64,
        Aarray: *const *const f64,
        lda_array: *const i64,
        Barray: *const *const f64,
        ldb_array: *const i64,
        beta_array: *const f64,
        Carray: *const *mut f64,
        ldc_array: *const i64,
        group_count: i64,
        group_size: *const i64,
    ) -> cublasStatus_t {
        (culib().cublasDgemmGroupedBatched_64)(
            handle,
            transa_array,
            transb_array,
            m_array,
            n_array,
            k_array,
            alpha_array,
            Aarray,
            lda_array,
            Barray,
            ldb_array,
            beta_array,
            Carray,
            ldc_array,
            group_count,
            group_size,
        )
    }
    pub unsafe fn cublasDgemmStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgemmStridedBatched)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemmStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const f64,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasDgemmStridedBatched_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasDgemm_v2(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgemm_v2)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemm_v2_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasDgemm_v2_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemvBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        xarray: *const *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        yarray: *const *mut f64,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgemvBatched)(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemvBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        Aarray: *const *const f64,
        lda: i64,
        xarray: *const *const f64,
        incx: i64,
        beta: *const f64,
        yarray: *const *mut f64,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasDgemvBatched_64)(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemvStridedBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const f64,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgemvStridedBatched)(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemvStridedBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const f64,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasDgemvStridedBatched_64)(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasDgemv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgemv_v2)(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDgemv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasDgemv_v2_64)(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasDgeqrfBatched(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut f64,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut f64,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgeqrfBatched)(handle, m, n, Aarray, lda, TauArray, info, batchSize)
    }
    pub unsafe fn cublasDger_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDger_v2)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDger_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasDger_v2_64)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasDgetrfBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut f64,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgetrfBatched)(handle, n, A, lda, P, info, batchSize)
    }
    pub unsafe fn cublasDgetriBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut f64,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgetriBatched)(handle, n, A, lda, P, C, ldc, info, batchSize)
    }
    pub unsafe fn cublasDgetrsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const f64,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut f64,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDgetrsBatched)(
            handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize,
        )
    }
    pub unsafe fn cublasDmatinvBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut f64,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDmatinvBatched)(handle, n, A, lda, Ainv, lda_inv, info, batchSize)
    }
    pub unsafe fn cublasDnrm2_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDnrm2_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDnrm2_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDnrm2_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDotEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasDotEx)(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            result,
            resultType,
            executionType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDotEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasDotEx_64)(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            result,
            resultType,
            executionType,
        )
    }
    pub unsafe fn cublasDotcEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasDotcEx)(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            result,
            resultType,
            executionType,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDotcEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *const ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasDotcEx_64)(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            result,
            resultType,
            executionType,
        )
    }
    pub unsafe fn cublasDrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t {
        (culib().cublasDrot_v2)(handle, n, x, incx, y, incy, c, s)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t {
        (culib().cublasDrot_v2_64)(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasDrotg_v2(
        handle: cublasHandle_t,
        a: *mut f64,
        b: *mut f64,
        c: *mut f64,
        s: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDrotg_v2)(handle, a, b, c, s)
    }
    pub unsafe fn cublasDrotm_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
        param: *const f64,
    ) -> cublasStatus_t {
        (culib().cublasDrotm_v2)(handle, n, x, incx, y, incy, param)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDrotm_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
        param: *const f64,
    ) -> cublasStatus_t {
        (culib().cublasDrotm_v2_64)(handle, n, x, incx, y, incy, param)
    }
    pub unsafe fn cublasDrotmg_v2(
        handle: cublasHandle_t,
        d1: *mut f64,
        d2: *mut f64,
        x1: *mut f64,
        y1: *const f64,
        param: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDrotmg_v2)(handle, d1, d2, x1, y1, param)
    }
    pub unsafe fn cublasDsbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDsbmv_v2)(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDsbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasDsbmv_v2_64)(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasDscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDscal_v2)(handle, n, alpha, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasDscal_v2_64)(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasDspmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        AP: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDspmv_v2)(handle, uplo, n, alpha, AP, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDspmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        AP: *const f64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasDspmv_v2_64)(handle, uplo, n, alpha, AP, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasDspr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDspr2_v2)(handle, uplo, n, alpha, x, incx, y, incy, AP)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDspr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDspr2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, AP)
    }
    pub unsafe fn cublasDspr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDspr_v2)(handle, uplo, n, alpha, x, incx, AP)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDspr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDspr_v2_64)(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasDswap_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDswap_v2)(handle, n, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDswap_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f64,
        incx: i64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasDswap_v2_64)(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasDsymm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDsymm_v2)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDsymm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasDsymm_v2_64)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsymv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        beta: *const f64,
        y: *mut f64,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDsymv_v2)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDsymv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        x: *const f64,
        incx: i64,
        beta: *const f64,
        y: *mut f64,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasDsymv_v2_64)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasDsyr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        y: *const f64,
        incy: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDsyr2_v2)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDsyr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        y: *const f64,
        incy: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasDsyr2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasDsyr2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDsyr2k_v2)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDsyr2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasDsyr2k_v2_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDsyr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: ::core::ffi::c_int,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDsyr_v2)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDsyr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const f64,
        incx: i64,
        A: *mut f64,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasDsyr_v2_64)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    pub unsafe fn cublasDsyrk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDsyrk_v2)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDsyrk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasDsyrk_v2_64)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    pub unsafe fn cublasDsyrkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDsyrkx)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDsyrkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        beta: *const f64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasDsyrkx_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasDtbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtbmv_v2)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtbmv_v2_64)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    pub unsafe fn cublasDtbsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtbsv_v2)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtbsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtbsv_v2_64)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    pub unsafe fn cublasDtpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtpmv_v2)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtpmv_v2_64)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    pub unsafe fn cublasDtpsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtpsv_v2)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtpsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtpsv_v2_64)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    pub unsafe fn cublasDtpttr(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const f64,
        A: *mut f64,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtpttr)(handle, uplo, n, AP, A, lda)
    }
    pub unsafe fn cublasDtrmm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *const f64,
        ldb: ::core::ffi::c_int,
        C: *mut f64,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtrmm_v2)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtrmm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *const f64,
        ldb: i64,
        C: *mut f64,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtrmm_v2_64)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasDtrmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtrmv_v2)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtrmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtrmv_v2_64)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    pub unsafe fn cublasDtrsmBatched(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const *const f64,
        lda: ::core::ffi::c_int,
        B: *const *mut f64,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtrsmBatched)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtrsmBatched_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const *const f64,
        lda: i64,
        B: *const *mut f64,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtrsmBatched_64)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasDtrsm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const f64,
        lda: ::core::ffi::c_int,
        B: *mut f64,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtrsm_v2)(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtrsm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f64,
        A: *const f64,
        lda: i64,
        B: *mut f64,
        ldb: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtrsm_v2_64)(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb)
    }
    pub unsafe fn cublasDtrsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        x: *mut f64,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasDtrsv_v2)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDtrsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f64,
        lda: i64,
        x: *mut f64,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasDtrsv_v2_64)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    pub unsafe fn cublasDtrttp(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const f64,
        lda: ::core::ffi::c_int,
        AP: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDtrttp)(handle, uplo, n, A, lda, AP)
    }
    pub unsafe fn cublasDzasum_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDzasum_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDzasum_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDzasum_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasDznrm2_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDznrm2_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasDznrm2_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut f64,
    ) -> cublasStatus_t {
        (culib().cublasDznrm2_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasGemmBatchedEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (culib().cublasGemmBatchedEx)(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            Aarray,
            Atype,
            lda,
            Barray,
            Btype,
            ldb,
            beta,
            Carray,
            Ctype,
            ldc,
            batchCount,
            computeType,
            algo,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGemmBatchedEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        batchCount: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (culib().cublasGemmBatchedEx_64)(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            Aarray,
            Atype,
            lda,
            Barray,
            Btype,
            ldb,
            beta,
            Carray,
            Ctype,
            ldc,
            batchCount,
            computeType,
            algo,
        )
    }
    pub unsafe fn cublasGemmEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (culib().cublasGemmEx)(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            A,
            Atype,
            lda,
            B,
            Btype,
            ldb,
            beta,
            C,
            Ctype,
            ldc,
            computeType,
            algo,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGemmEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (culib().cublasGemmEx_64)(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            A,
            Atype,
            lda,
            B,
            Btype,
            ldb,
            beta,
            C,
            Ctype,
            ldc,
            computeType,
            algo,
        )
    }
    #[cfg(any(
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGemmGroupedBatchedEx(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const ::core::ffi::c_int,
        n_array: *const ::core::ffi::c_int,
        k_array: *const ::core::ffi::c_int,
        alpha_array: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType_t,
        lda_array: *const ::core::ffi::c_int,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType_t,
        ldb_array: *const ::core::ffi::c_int,
        beta_array: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType_t,
        ldc_array: *const ::core::ffi::c_int,
        group_count: ::core::ffi::c_int,
        group_size: *const ::core::ffi::c_int,
        computeType: cublasComputeType_t,
    ) -> cublasStatus_t {
        (culib().cublasGemmGroupedBatchedEx)(
            handle,
            transa_array,
            transb_array,
            m_array,
            n_array,
            k_array,
            alpha_array,
            Aarray,
            Atype,
            lda_array,
            Barray,
            Btype,
            ldb_array,
            beta_array,
            Carray,
            Ctype,
            ldc_array,
            group_count,
            group_size,
            computeType,
        )
    }
    #[cfg(any(
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGemmGroupedBatchedEx_64(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const i64,
        n_array: *const i64,
        k_array: *const i64,
        alpha_array: *const ::core::ffi::c_void,
        Aarray: *const *const ::core::ffi::c_void,
        Atype: cudaDataType_t,
        lda_array: *const i64,
        Barray: *const *const ::core::ffi::c_void,
        Btype: cudaDataType_t,
        ldb_array: *const i64,
        beta_array: *const ::core::ffi::c_void,
        Carray: *const *mut ::core::ffi::c_void,
        Ctype: cudaDataType_t,
        ldc_array: *const i64,
        group_count: i64,
        group_size: *const i64,
        computeType: cublasComputeType_t,
    ) -> cublasStatus_t {
        (culib().cublasGemmGroupedBatchedEx_64)(
            handle,
            transa_array,
            transb_array,
            m_array,
            n_array,
            k_array,
            alpha_array,
            Aarray,
            Atype,
            lda_array,
            Barray,
            Btype,
            ldb_array,
            beta_array,
            Carray,
            Ctype,
            ldc_array,
            group_count,
            group_size,
            computeType,
        )
    }
    pub unsafe fn cublasGemmStridedBatchedEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (culib().cublasGemmStridedBatchedEx)(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            A,
            Atype,
            lda,
            strideA,
            B,
            Btype,
            ldb,
            strideB,
            beta,
            C,
            Ctype,
            ldc,
            strideC,
            batchCount,
            computeType,
            algo,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGemmStridedBatchedEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const ::core::ffi::c_void,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const ::core::ffi::c_void,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
        computeType: cublasComputeType_t,
        algo: cublasGemmAlgo_t,
    ) -> cublasStatus_t {
        (culib().cublasGemmStridedBatchedEx_64)(
            handle,
            transa,
            transb,
            m,
            n,
            k,
            alpha,
            A,
            Atype,
            lda,
            strideA,
            B,
            Btype,
            ldb,
            strideB,
            beta,
            C,
            Ctype,
            ldc,
            strideC,
            batchCount,
            computeType,
            algo,
        )
    }
    pub unsafe fn cublasGetAtomicsMode(
        handle: cublasHandle_t,
        mode: *mut cublasAtomicsMode_t,
    ) -> cublasStatus_t {
        (culib().cublasGetAtomicsMode)(handle, mode)
    }
    pub unsafe fn cublasGetCudartVersion() -> usize {
        (culib().cublasGetCudartVersion)()
    }
    #[cfg(any(feature = "cuda-12090"))]
    pub unsafe fn cublasGetEmulationStrategy(
        handle: cublasHandle_t,
        emulationStrategy: *mut cublasEmulationStrategy_t,
    ) -> cublasStatus_t {
        (culib().cublasGetEmulationStrategy)(handle, emulationStrategy)
    }
    pub unsafe fn cublasGetLoggerCallback(userCallback: *mut cublasLogCallback) -> cublasStatus_t {
        (culib().cublasGetLoggerCallback)(userCallback)
    }
    pub unsafe fn cublasGetMathMode(
        handle: cublasHandle_t,
        mode: *mut cublasMath_t,
    ) -> cublasStatus_t {
        (culib().cublasGetMathMode)(handle, mode)
    }
    pub unsafe fn cublasGetMatrix(
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasGetMatrix)(rows, cols, elemSize, A, lda, B, ldb)
    }
    pub unsafe fn cublasGetMatrixAsync(
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasGetMatrixAsync)(rows, cols, elemSize, A, lda, B, ldb, stream)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGetMatrixAsync_64(
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasGetMatrixAsync_64)(rows, cols, elemSize, A, lda, B, ldb, stream)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGetMatrix_64(
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
    ) -> cublasStatus_t {
        (culib().cublasGetMatrix_64)(rows, cols, elemSize, A, lda, B, ldb)
    }
    pub unsafe fn cublasGetPointerMode_v2(
        handle: cublasHandle_t,
        mode: *mut cublasPointerMode_t,
    ) -> cublasStatus_t {
        (culib().cublasGetPointerMode_v2)(handle, mode)
    }
    pub unsafe fn cublasGetProperty(
        type_: libraryPropertyType,
        value: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasGetProperty)(type_, value)
    }
    pub unsafe fn cublasGetSmCountTarget(
        handle: cublasHandle_t,
        smCountTarget: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasGetSmCountTarget)(handle, smCountTarget)
    }
    pub unsafe fn cublasGetStatusName(status: cublasStatus_t) -> *const ::core::ffi::c_char {
        (culib().cublasGetStatusName)(status)
    }
    pub unsafe fn cublasGetStatusString(status: cublasStatus_t) -> *const ::core::ffi::c_char {
        (culib().cublasGetStatusString)(status)
    }
    pub unsafe fn cublasGetStream_v2(
        handle: cublasHandle_t,
        streamId: *mut cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasGetStream_v2)(handle, streamId)
    }
    pub unsafe fn cublasGetVector(
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasGetVector)(n, elemSize, x, incx, y, incy)
    }
    pub unsafe fn cublasGetVectorAsync(
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        devicePtr: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        hostPtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasGetVectorAsync)(n, elemSize, devicePtr, incx, hostPtr, incy, stream)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGetVectorAsync_64(
        n: i64,
        elemSize: i64,
        devicePtr: *const ::core::ffi::c_void,
        incx: i64,
        hostPtr: *mut ::core::ffi::c_void,
        incy: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasGetVectorAsync_64)(n, elemSize, devicePtr, incx, hostPtr, incy, stream)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasGetVector_64(
        n: i64,
        elemSize: i64,
        x: *const ::core::ffi::c_void,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasGetVector_64)(n, elemSize, x, incx, y, incy)
    }
    pub unsafe fn cublasGetVersion_v2(
        handle: cublasHandle_t,
        version: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasGetVersion_v2)(handle, version)
    }
    pub unsafe fn cublasIamaxEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIamaxEx)(handle, n, x, xType, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIamaxEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIamaxEx_64)(handle, n, x, xType, incx, result)
    }
    pub unsafe fn cublasIaminEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIaminEx)(handle, n, x, xType, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIaminEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIaminEx_64)(handle, n, x, xType, incx, result)
    }
    pub unsafe fn cublasIcamax_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIcamax_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIcamax_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIcamax_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIcamin_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIcamin_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIcamin_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIcamin_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIdamax_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIdamax_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIdamax_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIdamax_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIdamin_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f64,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIdamin_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIdamin_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f64,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIdamin_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIsamax_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIsamax_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIsamax_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIsamax_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIsamin_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIsamin_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIsamin_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIsamin_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIzamax_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIzamax_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIzamax_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIzamax_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasIzamin_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasIzamin_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasIzamin_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        result: *mut i64,
    ) -> cublasStatus_t {
        (culib().cublasIzamin_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasLoggerConfigure(
        logIsOn: ::core::ffi::c_int,
        logToStdOut: ::core::ffi::c_int,
        logToStdErr: ::core::ffi::c_int,
        logFileName: *const ::core::ffi::c_char,
    ) -> cublasStatus_t {
        (culib().cublasLoggerConfigure)(logIsOn, logToStdOut, logToStdErr, logFileName)
    }
    pub unsafe fn cublasNrm2Ex(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasNrm2Ex)(handle, n, x, xType, incx, result, resultType, executionType)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasNrm2Ex_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        result: *mut ::core::ffi::c_void,
        resultType: cudaDataType,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasNrm2Ex_64)(handle, n, x, xType, incx, result, resultType, executionType)
    }
    pub unsafe fn cublasRotEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        c: *const ::core::ffi::c_void,
        s: *const ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasRotEx)(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            c,
            s,
            csType,
            executiontype,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasRotEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        c: *const ::core::ffi::c_void,
        s: *const ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasRotEx_64)(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            c,
            s,
            csType,
            executiontype,
        )
    }
    pub unsafe fn cublasRotgEx(
        handle: cublasHandle_t,
        a: *mut ::core::ffi::c_void,
        b: *mut ::core::ffi::c_void,
        abType: cudaDataType,
        c: *mut ::core::ffi::c_void,
        s: *mut ::core::ffi::c_void,
        csType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasRotgEx)(handle, a, b, abType, c, s, csType, executiontype)
    }
    pub unsafe fn cublasRotmEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
        param: *const ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasRotmEx)(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            param,
            paramType,
            executiontype,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasRotmEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
        param: *const ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasRotmEx_64)(
            handle,
            n,
            x,
            xType,
            incx,
            y,
            yType,
            incy,
            param,
            paramType,
            executiontype,
        )
    }
    pub unsafe fn cublasRotmgEx(
        handle: cublasHandle_t,
        d1: *mut ::core::ffi::c_void,
        d1Type: cudaDataType,
        d2: *mut ::core::ffi::c_void,
        d2Type: cudaDataType,
        x1: *mut ::core::ffi::c_void,
        x1Type: cudaDataType,
        y1: *const ::core::ffi::c_void,
        y1Type: cudaDataType,
        param: *mut ::core::ffi::c_void,
        paramType: cudaDataType,
        executiontype: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasRotmgEx)(
            handle,
            d1,
            d1Type,
            d2,
            d2Type,
            x1,
            x1Type,
            y1,
            y1Type,
            param,
            paramType,
            executiontype,
        )
    }
    pub unsafe fn cublasSasum_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSasum_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSasum_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSasum_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasSaxpy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSaxpy_v2)(handle, n, alpha, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSaxpy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSaxpy_v2_64)(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasScalEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasScalEx)(handle, n, alpha, alphaType, x, xType, incx, executionType)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasScalEx_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const ::core::ffi::c_void,
        alphaType: cudaDataType,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        executionType: cudaDataType,
    ) -> cublasStatus_t {
        (culib().cublasScalEx_64)(handle, n, alpha, alphaType, x, xType, incx, executionType)
    }
    pub unsafe fn cublasScasum_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasScasum_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasScasum_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasScasum_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasScnrm2_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuComplex,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasScnrm2_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasScnrm2_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuComplex,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasScnrm2_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasScopy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasScopy_v2)(handle, n, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasScopy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasScopy_v2_64)(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasSdgmm(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSdgmm)(handle, mode, m, n, A, lda, x, incx, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSdgmm_64(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasSdgmm_64)(handle, mode, m, n, A, lda, x, incx, C, ldc)
    }
    pub unsafe fn cublasSdot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSdot_v2)(handle, n, x, incx, y, incy, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSdot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSdot_v2_64)(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasSetAtomicsMode(
        handle: cublasHandle_t,
        mode: cublasAtomicsMode_t,
    ) -> cublasStatus_t {
        (culib().cublasSetAtomicsMode)(handle, mode)
    }
    #[cfg(any(feature = "cuda-12090"))]
    pub unsafe fn cublasSetEmulationStrategy(
        handle: cublasHandle_t,
        emulationStrategy: cublasEmulationStrategy_t,
    ) -> cublasStatus_t {
        (culib().cublasSetEmulationStrategy)(handle, emulationStrategy)
    }
    pub unsafe fn cublasSetLoggerCallback(userCallback: cublasLogCallback) -> cublasStatus_t {
        (culib().cublasSetLoggerCallback)(userCallback)
    }
    pub unsafe fn cublasSetMathMode(handle: cublasHandle_t, mode: cublasMath_t) -> cublasStatus_t {
        (culib().cublasSetMathMode)(handle, mode)
    }
    pub unsafe fn cublasSetMatrix(
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSetMatrix)(rows, cols, elemSize, A, lda, B, ldb)
    }
    pub unsafe fn cublasSetMatrixAsync(
        rows: ::core::ffi::c_int,
        cols: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        A: *const ::core::ffi::c_void,
        lda: ::core::ffi::c_int,
        B: *mut ::core::ffi::c_void,
        ldb: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasSetMatrixAsync)(rows, cols, elemSize, A, lda, B, ldb, stream)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSetMatrixAsync_64(
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasSetMatrixAsync_64)(rows, cols, elemSize, A, lda, B, ldb, stream)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSetMatrix_64(
        rows: i64,
        cols: i64,
        elemSize: i64,
        A: *const ::core::ffi::c_void,
        lda: i64,
        B: *mut ::core::ffi::c_void,
        ldb: i64,
    ) -> cublasStatus_t {
        (culib().cublasSetMatrix_64)(rows, cols, elemSize, A, lda, B, ldb)
    }
    pub unsafe fn cublasSetPointerMode_v2(
        handle: cublasHandle_t,
        mode: cublasPointerMode_t,
    ) -> cublasStatus_t {
        (culib().cublasSetPointerMode_v2)(handle, mode)
    }
    pub unsafe fn cublasSetSmCountTarget(
        handle: cublasHandle_t,
        smCountTarget: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSetSmCountTarget)(handle, smCountTarget)
    }
    pub unsafe fn cublasSetStream_v2(
        handle: cublasHandle_t,
        streamId: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasSetStream_v2)(handle, streamId)
    }
    pub unsafe fn cublasSetVector(
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        x: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        devicePtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSetVector)(n, elemSize, x, incx, devicePtr, incy)
    }
    pub unsafe fn cublasSetVectorAsync(
        n: ::core::ffi::c_int,
        elemSize: ::core::ffi::c_int,
        hostPtr: *const ::core::ffi::c_void,
        incx: ::core::ffi::c_int,
        devicePtr: *mut ::core::ffi::c_void,
        incy: ::core::ffi::c_int,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasSetVectorAsync)(n, elemSize, hostPtr, incx, devicePtr, incy, stream)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSetVectorAsync_64(
        n: i64,
        elemSize: i64,
        hostPtr: *const ::core::ffi::c_void,
        incx: i64,
        devicePtr: *mut ::core::ffi::c_void,
        incy: i64,
        stream: cudaStream_t,
    ) -> cublasStatus_t {
        (culib().cublasSetVectorAsync_64)(n, elemSize, hostPtr, incx, devicePtr, incy, stream)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSetVector_64(
        n: i64,
        elemSize: i64,
        x: *const ::core::ffi::c_void,
        incx: i64,
        devicePtr: *mut ::core::ffi::c_void,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSetVector_64)(n, elemSize, x, incx, devicePtr, incy)
    }
    pub unsafe fn cublasSetWorkspace_v2(
        handle: cublasHandle_t,
        workspace: *mut ::core::ffi::c_void,
        workspaceSizeInBytes: usize,
    ) -> cublasStatus_t {
        (culib().cublasSetWorkspace_v2)(handle, workspace, workspaceSizeInBytes)
    }
    pub unsafe fn cublasSgbmv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgbmv_v2)(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgbmv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgbmv_v2_64)(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasSgeam(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgeam)(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgeam_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        beta: *const f32,
        B: *const f32,
        ldb: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgeam_64)(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasSgelsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut f32,
        lda: ::core::ffi::c_int,
        Carray: *const *mut f32,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgelsBatched)(
            handle,
            trans,
            m,
            n,
            nrhs,
            Aarray,
            lda,
            Carray,
            ldc,
            info,
            devInfoArray,
            batchSize,
        )
    }
    pub unsafe fn cublasSgemmBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        Barray: *const *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        Carray: *const *mut f32,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgemmBatched)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemmBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: i64,
        Barray: *const *const f32,
        ldb: i64,
        beta: *const f32,
        Carray: *const *mut f32,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgemmBatched_64)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasSgemmEx(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgemmEx)(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemmEx_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const ::core::ffi::c_void,
        Atype: cudaDataType,
        lda: i64,
        B: *const ::core::ffi::c_void,
        Btype: cudaDataType,
        ldb: i64,
        beta: *const f32,
        C: *mut ::core::ffi::c_void,
        Ctype: cudaDataType,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgemmEx_64)(
            handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype,
            ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemmGroupedBatched(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const ::core::ffi::c_int,
        n_array: *const ::core::ffi::c_int,
        k_array: *const ::core::ffi::c_int,
        alpha_array: *const f32,
        Aarray: *const *const f32,
        lda_array: *const ::core::ffi::c_int,
        Barray: *const *const f32,
        ldb_array: *const ::core::ffi::c_int,
        beta_array: *const f32,
        Carray: *const *mut f32,
        ldc_array: *const ::core::ffi::c_int,
        group_count: ::core::ffi::c_int,
        group_size: *const ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgemmGroupedBatched)(
            handle,
            transa_array,
            transb_array,
            m_array,
            n_array,
            k_array,
            alpha_array,
            Aarray,
            lda_array,
            Barray,
            ldb_array,
            beta_array,
            Carray,
            ldc_array,
            group_count,
            group_size,
        )
    }
    #[cfg(any(
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemmGroupedBatched_64(
        handle: cublasHandle_t,
        transa_array: *const cublasOperation_t,
        transb_array: *const cublasOperation_t,
        m_array: *const i64,
        n_array: *const i64,
        k_array: *const i64,
        alpha_array: *const f32,
        Aarray: *const *const f32,
        lda_array: *const i64,
        Barray: *const *const f32,
        ldb_array: *const i64,
        beta_array: *const f32,
        Carray: *const *mut f32,
        ldc_array: *const i64,
        group_count: i64,
        group_size: *const i64,
    ) -> cublasStatus_t {
        (culib().cublasSgemmGroupedBatched_64)(
            handle,
            transa_array,
            transb_array,
            m_array,
            n_array,
            k_array,
            alpha_array,
            Aarray,
            lda_array,
            Barray,
            ldb_array,
            beta_array,
            Carray,
            ldc_array,
            group_count,
            group_size,
        )
    }
    pub unsafe fn cublasSgemmStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgemmStridedBatched)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemmStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const f32,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgemmStridedBatched_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasSgemm_v2(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgemm_v2)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemm_v2_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgemm_v2_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemvBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        xarray: *const *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        yarray: *const *mut f32,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgemvBatched)(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemvBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        Aarray: *const *const f32,
        lda: i64,
        xarray: *const *const f32,
        incx: i64,
        beta: *const f32,
        yarray: *const *mut f32,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgemvBatched_64)(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemvStridedBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const f32,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgemvStridedBatched)(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemvStridedBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const f32,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgemvStridedBatched_64)(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasSgemv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgemv_v2)(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSgemv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSgemv_v2_64)(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasSgeqrfBatched(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut f32,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut f32,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgeqrfBatched)(handle, m, n, Aarray, lda, TauArray, info, batchSize)
    }
    pub unsafe fn cublasSger_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSger_v2)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSger_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasSger_v2_64)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasSgetrfBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut f32,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgetrfBatched)(handle, n, A, lda, P, info, batchSize)
    }
    pub unsafe fn cublasSgetriBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut f32,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgetriBatched)(handle, n, A, lda, P, C, ldc, info, batchSize)
    }
    pub unsafe fn cublasSgetrsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const f32,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut f32,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSgetrsBatched)(
            handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize,
        )
    }
    pub unsafe fn cublasSmatinvBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut f32,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSmatinvBatched)(handle, n, A, lda, Ainv, lda_inv, info, batchSize)
    }
    pub unsafe fn cublasSnrm2_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSnrm2_v2)(handle, n, x, incx, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSnrm2_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const f32,
        incx: i64,
        result: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSnrm2_v2_64)(handle, n, x, incx, result)
    }
    pub unsafe fn cublasSrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t {
        (culib().cublasSrot_v2)(handle, n, x, incx, y, incy, c, s)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
        c: *const f32,
        s: *const f32,
    ) -> cublasStatus_t {
        (culib().cublasSrot_v2_64)(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasSrotg_v2(
        handle: cublasHandle_t,
        a: *mut f32,
        b: *mut f32,
        c: *mut f32,
        s: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSrotg_v2)(handle, a, b, c, s)
    }
    pub unsafe fn cublasSrotm_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
        param: *const f32,
    ) -> cublasStatus_t {
        (culib().cublasSrotm_v2)(handle, n, x, incx, y, incy, param)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSrotm_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
        param: *const f32,
    ) -> cublasStatus_t {
        (culib().cublasSrotm_v2_64)(handle, n, x, incx, y, incy, param)
    }
    pub unsafe fn cublasSrotmg_v2(
        handle: cublasHandle_t,
        d1: *mut f32,
        d2: *mut f32,
        x1: *mut f32,
        y1: *const f32,
        param: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSrotmg_v2)(handle, d1, d2, x1, y1, param)
    }
    pub unsafe fn cublasSsbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSsbmv_v2)(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSsbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSsbmv_v2_64)(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasSscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSscal_v2)(handle, n, alpha, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasSscal_v2_64)(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasSspmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        AP: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSspmv_v2)(handle, uplo, n, alpha, AP, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSspmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        AP: *const f32,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSspmv_v2_64)(handle, uplo, n, alpha, AP, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasSspr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSspr2_v2)(handle, uplo, n, alpha, x, incx, y, incy, AP)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSspr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSspr2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, AP)
    }
    pub unsafe fn cublasSspr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSspr_v2)(handle, uplo, n, alpha, x, incx, AP)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSspr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasSspr_v2_64)(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasSswap_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSswap_v2)(handle, n, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSswap_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut f32,
        incx: i64,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSswap_v2_64)(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasSsymm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSsymm_v2)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSsymm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasSsymm_v2_64)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSsymv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *const f32,
        incx: ::core::ffi::c_int,
        beta: *const f32,
        y: *mut f32,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSsymv_v2)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSsymv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        x: *const f32,
        incx: i64,
        beta: *const f32,
        y: *mut f32,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSsymv_v2_64)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasSsyr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        y: *const f32,
        incy: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSsyr2_v2)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSsyr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        y: *const f32,
        incy: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasSsyr2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasSsyr2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSsyr2k_v2)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSsyr2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasSsyr2k_v2_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasSsyr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        x: *const f32,
        incx: ::core::ffi::c_int,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSsyr_v2)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSsyr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f32,
        x: *const f32,
        incx: i64,
        A: *mut f32,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasSsyr_v2_64)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    pub unsafe fn cublasSsyrk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSsyrk_v2)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSsyrk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasSsyrk_v2_64)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    pub unsafe fn cublasSsyrkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        beta: *const f32,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSsyrkx)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSsyrkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        beta: *const f32,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasSsyrkx_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasStbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStbmv_v2)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasStbmv_v2_64)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    pub unsafe fn cublasStbsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStbsv_v2)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStbsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasStbsv_v2_64)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    pub unsafe fn cublasStpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStpmv_v2)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasStpmv_v2_64)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    pub unsafe fn cublasStpsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStpsv_v2)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStpsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const f32,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasStpsv_v2_64)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    pub unsafe fn cublasStpttr(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const f32,
        A: *mut f32,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStpttr)(handle, uplo, n, AP, A, lda)
    }
    pub unsafe fn cublasStrmm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *const f32,
        ldb: ::core::ffi::c_int,
        C: *mut f32,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStrmm_v2)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStrmm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *const f32,
        ldb: i64,
        C: *mut f32,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasStrmm_v2_64)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasStrmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStrmv_v2)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStrmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasStrmv_v2_64)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    pub unsafe fn cublasStrsmBatched(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const *const f32,
        lda: ::core::ffi::c_int,
        B: *const *mut f32,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStrsmBatched)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStrsmBatched_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const *const f32,
        lda: i64,
        B: *const *mut f32,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasStrsmBatched_64)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasStrsm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const f32,
        A: *const f32,
        lda: ::core::ffi::c_int,
        B: *mut f32,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStrsm_v2)(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStrsm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const f32,
        A: *const f32,
        lda: i64,
        B: *mut f32,
        ldb: i64,
    ) -> cublasStatus_t {
        (culib().cublasStrsm_v2_64)(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb)
    }
    pub unsafe fn cublasStrsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        x: *mut f32,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasStrsv_v2)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasStrsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const f32,
        lda: i64,
        x: *mut f32,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasStrsv_v2_64)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    pub unsafe fn cublasStrttp(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const f32,
        lda: ::core::ffi::c_int,
        AP: *mut f32,
    ) -> cublasStatus_t {
        (culib().cublasStrttp)(handle, uplo, n, A, lda, AP)
    }
    pub unsafe fn cublasSwapEx(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: ::core::ffi::c_int,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasSwapEx)(handle, n, x, xType, incx, y, yType, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasSwapEx_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut ::core::ffi::c_void,
        xType: cudaDataType,
        incx: i64,
        y: *mut ::core::ffi::c_void,
        yType: cudaDataType,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasSwapEx_64)(handle, n, x, xType, incx, y, yType, incy)
    }
    pub unsafe fn cublasUint8gemmBias(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        transc: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const ::core::ffi::c_uchar,
        A_bias: ::core::ffi::c_int,
        lda: ::core::ffi::c_int,
        B: *const ::core::ffi::c_uchar,
        B_bias: ::core::ffi::c_int,
        ldb: ::core::ffi::c_int,
        C: *mut ::core::ffi::c_uchar,
        C_bias: ::core::ffi::c_int,
        ldc: ::core::ffi::c_int,
        C_mult: ::core::ffi::c_int,
        C_shift: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasUint8gemmBias)(
            handle, transa, transb, transc, m, n, k, A, A_bias, lda, B, B_bias, ldb, C, C_bias,
            ldc, C_mult, C_shift,
        )
    }
    pub unsafe fn cublasXerbla(srName: *const ::core::ffi::c_char, info: ::core::ffi::c_int) {
        (culib().cublasXerbla)(srName, info)
    }
    pub unsafe fn cublasZaxpy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZaxpy_v2)(handle, n, alpha, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZaxpy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZaxpy_v2_64)(handle, n, alpha, x, incx, y, incy)
    }
    pub unsafe fn cublasZcopy_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZcopy_v2)(handle, n, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZcopy_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZcopy_v2_64)(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasZdgmm(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZdgmm)(handle, mode, m, n, A, lda, x, incx, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZdgmm_64(
        handle: cublasHandle_t,
        mode: cublasSideMode_t,
        m: i64,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZdgmm_64)(handle, mode, m, n, A, lda, x, incx, C, ldc)
    }
    pub unsafe fn cublasZdotc_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZdotc_v2)(handle, n, x, incx, y, incy, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZdotc_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZdotc_v2_64)(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasZdotu_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZdotu_v2)(handle, n, x, incx, y, incy, result)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZdotu_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        result: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZdotu_v2_64)(handle, n, x, incx, y, incy, result)
    }
    pub unsafe fn cublasZdrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t {
        (culib().cublasZdrot_v2)(handle, n, x, incx, y, incy, c, s)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZdrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
        c: *const f64,
        s: *const f64,
    ) -> cublasStatus_t {
        (culib().cublasZdrot_v2_64)(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasZdscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZdscal_v2)(handle, n, alpha, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZdscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const f64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasZdscal_v2_64)(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasZgbmv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        kl: ::core::ffi::c_int,
        ku: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgbmv_v2)(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgbmv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        kl: i64,
        ku: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgbmv_v2_64)(
            handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy,
        )
    }
    pub unsafe fn cublasZgeam(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgeam)(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgeam_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const cuDoubleComplex,
        B: *const cuDoubleComplex,
        ldb: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgeam_64)(
            handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasZgelsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Carray: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        devInfoArray: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgelsBatched)(
            handle,
            trans,
            m,
            n,
            nrhs,
            Aarray,
            lda,
            Carray,
            ldc,
            info,
            devInfoArray,
            batchSize,
        )
    }
    pub unsafe fn cublasZgemm3m(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgemm3m)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemm3m_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgemm3m_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZgemmBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Barray: *const *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        Carray: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgemmBatched)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemmBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: i64,
        Barray: *const *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        Carray: *const *mut cuDoubleComplex,
        ldc: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgemmBatched_64)(
            handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc,
            batchCount,
        )
    }
    pub unsafe fn cublasZgemmStridedBatched(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        strideC: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgemmStridedBatched)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemmStridedBatched_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        B: *const cuDoubleComplex,
        ldb: i64,
        strideB: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
        strideC: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgemmStridedBatched_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc,
            strideC, batchCount,
        )
    }
    pub unsafe fn cublasZgemm_v2(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgemm_v2)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemm_v2_64(
        handle: cublasHandle_t,
        transa: cublasOperation_t,
        transb: cublasOperation_t,
        m: i64,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgemm_v2_64)(
            handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemvBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        xarray: *const *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        yarray: *const *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgemvBatched)(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemvBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        Aarray: *const *const cuDoubleComplex,
        lda: i64,
        xarray: *const *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        yarray: *const *mut cuDoubleComplex,
        incy: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgemvBatched_64)(
            handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-11060",
        feature = "cuda-11070",
        feature = "cuda-11080",
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemvStridedBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        strideA: ::core::ffi::c_longlong,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        stridey: ::core::ffi::c_longlong,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgemvStridedBatched)(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemvStridedBatched_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        strideA: ::core::ffi::c_longlong,
        x: *const cuDoubleComplex,
        incx: i64,
        stridex: ::core::ffi::c_longlong,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
        stridey: ::core::ffi::c_longlong,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgemvStridedBatched_64)(
            handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey,
            batchCount,
        )
    }
    pub unsafe fn cublasZgemv_v2(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgemv_v2)(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgemv_v2_64(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgemv_v2_64)(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasZgeqrfBatched(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        Aarray: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        TauArray: *const *mut cuDoubleComplex,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgeqrfBatched)(handle, m, n, Aarray, lda, TauArray, info, batchSize)
    }
    pub unsafe fn cublasZgerc_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgerc_v2)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgerc_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgerc_v2_64)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasZgeru_v2(
        handle: cublasHandle_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgeru_v2)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZgeru_v2_64(
        handle: cublasHandle_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasZgeru_v2_64)(handle, m, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasZgetrfBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
        P: *mut ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgetrfBatched)(handle, n, A, lda, P, info, batchSize)
    }
    pub unsafe fn cublasZgetriBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        P: *const ::core::ffi::c_int,
        C: *const *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgetriBatched)(handle, n, A, lda, P, C, ldc, info, batchSize)
    }
    pub unsafe fn cublasZgetrsBatched(
        handle: cublasHandle_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        nrhs: ::core::ffi::c_int,
        Aarray: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        devIpiv: *const ::core::ffi::c_int,
        Barray: *const *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZgetrsBatched)(
            handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize,
        )
    }
    pub unsafe fn cublasZhbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZhbmv_v2)(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZhbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZhbmv_v2_64)(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasZhemm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZhemm_v2)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZhemm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZhemm_v2_64)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZhemv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZhemv_v2)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZhemv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZhemv_v2_64)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasZher2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZher2_v2)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZher2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasZher2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasZher2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZher2k_v2)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZher2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZher2k_v2_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZher_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZher_v2)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZher_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasZher_v2_64)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    pub unsafe fn cublasZherk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const f64,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZherk_v2)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZherk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const f64,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZherk_v2_64)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    pub unsafe fn cublasZherkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZherkx)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZherkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const f64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZherkx_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZhpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        AP: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZhpmv_v2)(handle, uplo, n, alpha, AP, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZhpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        AP: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZhpmv_v2_64)(handle, uplo, n, alpha, AP, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasZhpr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZhpr2_v2)(handle, uplo, n, alpha, x, incx, y, incy, AP)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZhpr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZhpr2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, AP)
    }
    pub unsafe fn cublasZhpr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZhpr_v2)(handle, uplo, n, alpha, x, incx, AP)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZhpr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const f64,
        x: *const cuDoubleComplex,
        incx: i64,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZhpr_v2_64)(handle, uplo, n, alpha, x, incx, AP)
    }
    pub unsafe fn cublasZmatinvBatched(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        Ainv: *const *mut cuDoubleComplex,
        lda_inv: ::core::ffi::c_int,
        info: *mut ::core::ffi::c_int,
        batchSize: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZmatinvBatched)(handle, n, A, lda, Ainv, lda_inv, info, batchSize)
    }
    pub unsafe fn cublasZrot_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
        c: *const f64,
        s: *const cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZrot_v2)(handle, n, x, incx, y, incy, c, s)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZrot_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
        c: *const f64,
        s: *const cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZrot_v2_64)(handle, n, x, incx, y, incy, c, s)
    }
    pub unsafe fn cublasZrotg_v2(
        handle: cublasHandle_t,
        a: *mut cuDoubleComplex,
        b: *mut cuDoubleComplex,
        c: *mut f64,
        s: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZrotg_v2)(handle, a, b, c, s)
    }
    pub unsafe fn cublasZscal_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZscal_v2)(handle, n, alpha, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZscal_v2_64(
        handle: cublasHandle_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasZscal_v2_64)(handle, n, alpha, x, incx)
    }
    pub unsafe fn cublasZswap_v2(
        handle: cublasHandle_t,
        n: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZswap_v2)(handle, n, x, incx, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZswap_v2_64(
        handle: cublasHandle_t,
        n: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZswap_v2_64)(handle, n, x, incx, y, incy)
    }
    pub unsafe fn cublasZsymm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZsymm_v2)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZsymm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZsymm_v2_64)(
            handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsymv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZsymv_v2)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZsymv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *const cuDoubleComplex,
        incx: i64,
        beta: *const cuDoubleComplex,
        y: *mut cuDoubleComplex,
        incy: i64,
    ) -> cublasStatus_t {
        (culib().cublasZsymv_v2_64)(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy)
    }
    pub unsafe fn cublasZsyr2_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        y: *const cuDoubleComplex,
        incy: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZsyr2_v2)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZsyr2_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        y: *const cuDoubleComplex,
        incy: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasZsyr2_v2_64)(handle, uplo, n, alpha, x, incx, y, incy, A, lda)
    }
    pub unsafe fn cublasZsyr2k_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZsyr2k_v2)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZsyr2k_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZsyr2k_v2_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZsyr_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: ::core::ffi::c_int,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZsyr_v2)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZsyr_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: i64,
        alpha: *const cuDoubleComplex,
        x: *const cuDoubleComplex,
        incx: i64,
        A: *mut cuDoubleComplex,
        lda: i64,
    ) -> cublasStatus_t {
        (culib().cublasZsyr_v2_64)(handle, uplo, n, alpha, x, incx, A, lda)
    }
    pub unsafe fn cublasZsyrk_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZsyrk_v2)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZsyrk_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZsyrk_v2_64)(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc)
    }
    pub unsafe fn cublasZsyrkx(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZsyrkx)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZsyrkx_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        n: i64,
        k: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        beta: *const cuDoubleComplex,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZsyrkx_64)(
            handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc,
        )
    }
    pub unsafe fn cublasZtbmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtbmv_v2)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtbmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtbmv_v2_64)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    pub unsafe fn cublasZtbsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        k: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtbsv_v2)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtbsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        k: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtbsv_v2_64)(handle, uplo, trans, diag, n, k, A, lda, x, incx)
    }
    pub unsafe fn cublasZtpmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtpmv_v2)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtpmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtpmv_v2_64)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    pub unsafe fn cublasZtpsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtpsv_v2)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtpsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        AP: *const cuDoubleComplex,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtpsv_v2_64)(handle, uplo, trans, diag, n, AP, x, incx)
    }
    pub unsafe fn cublasZtpttr(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        AP: *const cuDoubleComplex,
        A: *mut cuDoubleComplex,
        lda: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtpttr)(handle, uplo, n, AP, A, lda)
    }
    pub unsafe fn cublasZtrmm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        C: *mut cuDoubleComplex,
        ldc: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtrmm_v2)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtrmm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *const cuDoubleComplex,
        ldb: i64,
        C: *mut cuDoubleComplex,
        ldc: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtrmm_v2_64)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc,
        )
    }
    pub unsafe fn cublasZtrmv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtrmv_v2)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtrmv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtrmv_v2_64)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    pub unsafe fn cublasZtrsmBatched(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *const *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
        batchCount: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtrsmBatched)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtrsmBatched_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const *const cuDoubleComplex,
        lda: i64,
        B: *const *mut cuDoubleComplex,
        ldb: i64,
        batchCount: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtrsmBatched_64)(
            handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount,
        )
    }
    pub unsafe fn cublasZtrsm_v2(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: ::core::ffi::c_int,
        n: ::core::ffi::c_int,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        B: *mut cuDoubleComplex,
        ldb: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtrsm_v2)(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtrsm_v2_64(
        handle: cublasHandle_t,
        side: cublasSideMode_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        m: i64,
        n: i64,
        alpha: *const cuDoubleComplex,
        A: *const cuDoubleComplex,
        lda: i64,
        B: *mut cuDoubleComplex,
        ldb: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtrsm_v2_64)(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb)
    }
    pub unsafe fn cublasZtrsv_v2(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        x: *mut cuDoubleComplex,
        incx: ::core::ffi::c_int,
    ) -> cublasStatus_t {
        (culib().cublasZtrsv_v2)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    #[cfg(any(
        feature = "cuda-12000",
        feature = "cuda-12010",
        feature = "cuda-12020",
        feature = "cuda-12030",
        feature = "cuda-12040",
        feature = "cuda-12050",
        feature = "cuda-12060",
        feature = "cuda-12080",
        feature = "cuda-12090"
    ))]
    pub unsafe fn cublasZtrsv_v2_64(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        trans: cublasOperation_t,
        diag: cublasDiagType_t,
        n: i64,
        A: *const cuDoubleComplex,
        lda: i64,
        x: *mut cuDoubleComplex,
        incx: i64,
    ) -> cublasStatus_t {
        (culib().cublasZtrsv_v2_64)(handle, uplo, trans, diag, n, A, lda, x, incx)
    }
    pub unsafe fn cublasZtrttp(
        handle: cublasHandle_t,
        uplo: cublasFillMode_t,
        n: ::core::ffi::c_int,
        A: *const cuDoubleComplex,
        lda: ::core::ffi::c_int,
        AP: *mut cuDoubleComplex,
    ) -> cublasStatus_t {
        (culib().cublasZtrttp)(handle, uplo, n, A, lda, AP)
    }
    pub struct Lib {
        __library: ::libloading::Library,
        pub cublasAsumEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasAsumEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasAxpyEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            alphaType: cudaDataType,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasAxpyEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const ::core::ffi::c_void,
            alphaType: cudaDataType,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasCaxpy_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCaxpy_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasCcopy_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCcopy_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasCdgmm: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCdgmm_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: i64,
            n: i64,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCdotc_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            result: *mut cuComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCdotc_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            result: *mut cuComplex,
        ) -> cublasStatus_t,
        pub cublasCdotu_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            result: *mut cuComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCdotu_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            result: *mut cuComplex,
        ) -> cublasStatus_t,
        pub cublasCgbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kl: ::core::ffi::c_int,
            ku: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            kl: i64,
            ku: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasCgeam: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            beta: *const cuComplex,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgeam_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            beta: *const cuComplex,
            B: *const cuComplex,
            ldb: i64,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCgelsBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *mut cuComplex,
            lda: ::core::ffi::c_int,
            Carray: *const *mut cuComplex,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            devInfoArray: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasCgemm3m: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasCgemm3mBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            Barray: *const *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            Carray: *const *mut cuComplex,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemm3mBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: i64,
            Barray: *const *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            Carray: *const *mut cuComplex,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasCgemm3mEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemm3mEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCgemm3mStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemm3mStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const cuComplex,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemm3m_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCgemmBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            Barray: *const *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            Carray: *const *mut cuComplex,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemmBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: i64,
            Barray: *const *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            Carray: *const *mut cuComplex,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasCgemmEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemmEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCgemmStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemmStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const cuComplex,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasCgemm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemvBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            xarray: *const *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            yarray: *const *mut cuComplex,
            incy: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemvBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            Aarray: *const *const cuComplex,
            lda: i64,
            xarray: *const *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            yarray: *const *mut cuComplex,
            incy: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemvStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            stridex: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
            stridey: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemvStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            x: *const cuComplex,
            incx: i64,
            stridex: ::core::ffi::c_longlong,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
            stridey: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasCgemv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgemv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasCgeqrfBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            Aarray: *const *mut cuComplex,
            lda: ::core::ffi::c_int,
            TauArray: *const *mut cuComplex,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasCgerc_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgerc_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasCgeru_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCgeru_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasCgetrfBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *mut cuComplex,
            lda: ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasCgetriBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            P: *const ::core::ffi::c_int,
            C: *const *mut cuComplex,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasCgetrsBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            devIpiv: *const ::core::ffi::c_int,
            Barray: *const *mut cuComplex,
            ldb: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasChbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasChbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasChemm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasChemm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasChemv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasChemv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasCher2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCher2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasCher2k_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCher2k_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCher_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCher_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const cuComplex,
            incx: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasCherk3mEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCherk3mEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCherkEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCherkEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCherk_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCherk_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const cuComplex,
            lda: i64,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCherkx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCherkx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const f32,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasChpmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            AP: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasChpmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            AP: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasChpr2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasChpr2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        pub cublasChpr_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasChpr_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const cuComplex,
            incx: i64,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        pub cublasCmatinvBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            Ainv: *const *mut cuComplex,
            lda_inv: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasCopyEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCopyEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasCreate_v2: unsafe extern "C" fn(handle: *mut cublasHandle_t) -> cublasStatus_t,
        pub cublasCrot_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
            c: *const f32,
            s: *const cuComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCrot_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
            c: *const f32,
            s: *const cuComplex,
        ) -> cublasStatus_t,
        pub cublasCrotg_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut cuComplex,
            b: *mut cuComplex,
            c: *mut f32,
            s: *mut cuComplex,
        ) -> cublasStatus_t,
        pub cublasCscal_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCscal_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const cuComplex,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasCsrot_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
            c: *const f32,
            s: *const f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsrot_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
            c: *const f32,
            s: *const f32,
        ) -> cublasStatus_t,
        pub cublasCsscal_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsscal_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f32,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasCswap_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCswap_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuComplex,
            incx: i64,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasCsymm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsymm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCsymv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsymv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            x: *const cuComplex,
            incx: i64,
            beta: *const cuComplex,
            y: *mut cuComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasCsyr2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            y: *const cuComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsyr2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            y: *const cuComplex,
            incy: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasCsyr2k_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsyr2k_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCsyr_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsyr_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuComplex,
            x: *const cuComplex,
            incx: i64,
            A: *mut cuComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasCsyrk3mEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsyrk3mEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCsyrkEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsyrkEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            beta: *const cuComplex,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCsyrk_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsyrk_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCsyrkx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCsyrkx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            beta: *const cuComplex,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCtbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const cuComplex,
            lda: i64,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasCtbsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtbsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const cuComplex,
            lda: i64,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasCtpmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const cuComplex,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtpmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const cuComplex,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasCtpsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const cuComplex,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtpsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const cuComplex,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasCtpttr: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            AP: *const cuComplex,
            A: *mut cuComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasCtrmm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const cuComplex,
            ldb: ::core::ffi::c_int,
            C: *mut cuComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtrmm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *const cuComplex,
            ldb: i64,
            C: *mut cuComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasCtrmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtrmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const cuComplex,
            lda: i64,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasCtrsmBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *const *mut cuComplex,
            ldb: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtrsmBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const *const cuComplex,
            lda: i64,
            B: *const *mut cuComplex,
            ldb: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasCtrsm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            B: *mut cuComplex,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtrsm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuComplex,
            A: *const cuComplex,
            lda: i64,
            B: *mut cuComplex,
            ldb: i64,
        ) -> cublasStatus_t,
        pub cublasCtrsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasCtrsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const cuComplex,
            lda: i64,
            x: *mut cuComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasCtrttp: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            A: *const cuComplex,
            lda: ::core::ffi::c_int,
            AP: *mut cuComplex,
        ) -> cublasStatus_t,
        pub cublasDasum_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDasum_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDaxpy_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDaxpy_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasDcopy_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDcopy_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasDdgmm: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDdgmm_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: i64,
            n: i64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasDdot_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *const f64,
            incy: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDdot_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            y: *const f64,
            incy: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDestroy_v2: unsafe extern "C" fn(handle: cublasHandle_t) -> cublasStatus_t,
        pub cublasDgbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kl: ::core::ffi::c_int,
            ku: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            kl: i64,
            ku: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasDgeam: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            beta: *const f64,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgeam_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            beta: *const f64,
            B: *const f64,
            ldb: i64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasDgelsBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *mut f64,
            lda: ::core::ffi::c_int,
            Carray: *const *mut f64,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            devInfoArray: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasDgemmBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            Aarray: *const *const f64,
            lda: ::core::ffi::c_int,
            Barray: *const *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            Carray: *const *mut f64,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemmBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f64,
            Aarray: *const *const f64,
            lda: i64,
            Barray: *const *const f64,
            ldb: i64,
            beta: *const f64,
            Carray: *const *mut f64,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemmGroupedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa_array: *const cublasOperation_t,
            transb_array: *const cublasOperation_t,
            m_array: *const ::core::ffi::c_int,
            n_array: *const ::core::ffi::c_int,
            k_array: *const ::core::ffi::c_int,
            alpha_array: *const f64,
            Aarray: *const *const f64,
            lda_array: *const ::core::ffi::c_int,
            Barray: *const *const f64,
            ldb_array: *const ::core::ffi::c_int,
            beta_array: *const f64,
            Carray: *const *mut f64,
            ldc_array: *const ::core::ffi::c_int,
            group_count: ::core::ffi::c_int,
            group_size: *const ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemmGroupedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa_array: *const cublasOperation_t,
            transb_array: *const cublasOperation_t,
            m_array: *const i64,
            n_array: *const i64,
            k_array: *const i64,
            alpha_array: *const f64,
            Aarray: *const *const f64,
            lda_array: *const i64,
            Barray: *const *const f64,
            ldb_array: *const i64,
            beta_array: *const f64,
            Carray: *const *mut f64,
            ldc_array: *const i64,
            group_count: i64,
            group_size: *const i64,
        ) -> cublasStatus_t,
        pub cublasDgemmStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemmStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const f64,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasDgemm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemvBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            Aarray: *const *const f64,
            lda: ::core::ffi::c_int,
            xarray: *const *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            yarray: *const *mut f64,
            incy: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemvBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            Aarray: *const *const f64,
            lda: i64,
            xarray: *const *const f64,
            incx: i64,
            beta: *const f64,
            yarray: *const *mut f64,
            incy: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemvStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            x: *const f64,
            incx: ::core::ffi::c_int,
            stridex: ::core::ffi::c_longlong,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
            stridey: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemvStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            x: *const f64,
            incx: i64,
            stridex: ::core::ffi::c_longlong,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
            stridey: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasDgemv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDgemv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasDgeqrfBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            Aarray: *const *mut f64,
            lda: ::core::ffi::c_int,
            TauArray: *const *mut f64,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasDger_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *const f64,
            incy: ::core::ffi::c_int,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDger_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            y: *const f64,
            incy: i64,
            A: *mut f64,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasDgetrfBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *mut f64,
            lda: ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasDgetriBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const f64,
            lda: ::core::ffi::c_int,
            P: *const ::core::ffi::c_int,
            C: *const *mut f64,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasDgetrsBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *const f64,
            lda: ::core::ffi::c_int,
            devIpiv: *const ::core::ffi::c_int,
            Barray: *const *mut f64,
            ldb: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasDmatinvBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const f64,
            lda: ::core::ffi::c_int,
            Ainv: *const *mut f64,
            lda_inv: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasDnrm2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDnrm2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDotEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *const ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDotEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *const ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasDotcEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *const ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDotcEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *const ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasDrot_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
            c: *const f64,
            s: *const f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDrot_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
            c: *const f64,
            s: *const f64,
        ) -> cublasStatus_t,
        pub cublasDrotg_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut f64,
            b: *mut f64,
            c: *mut f64,
            s: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDrotm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
            param: *const f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDrotm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
            param: *const f64,
        ) -> cublasStatus_t,
        pub cublasDrotmg_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            d1: *mut f64,
            d2: *mut f64,
            x1: *mut f64,
            y1: *const f64,
            param: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDsbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDsbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasDscal_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDscal_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasDspmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            AP: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDspmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            AP: *const f64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasDspr2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *const f64,
            incy: ::core::ffi::c_int,
            AP: *mut f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDspr2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            y: *const f64,
            incy: i64,
            AP: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDspr_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            AP: *mut f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDspr_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            AP: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDswap_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDswap_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f64,
            incx: i64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasDsymm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDsymm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasDsymv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            beta: *const f64,
            y: *mut f64,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDsymv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            x: *const f64,
            incx: i64,
            beta: *const f64,
            y: *mut f64,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasDsyr2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            y: *const f64,
            incy: ::core::ffi::c_int,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDsyr2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            y: *const f64,
            incy: i64,
            A: *mut f64,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasDsyr2k_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDsyr2k_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasDsyr_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const f64,
            incx: ::core::ffi::c_int,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDsyr_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const f64,
            incx: i64,
            A: *mut f64,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasDsyrk_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDsyrk_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasDsyrkx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDsyrkx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            beta: *const f64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasDtbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const f64,
            lda: i64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasDtbsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtbsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const f64,
            lda: i64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasDtpmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const f64,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtpmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const f64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasDtpsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const f64,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtpsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const f64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasDtpttr: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            AP: *const f64,
            A: *mut f64,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasDtrmm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *const f64,
            ldb: ::core::ffi::c_int,
            C: *mut f64,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtrmm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *const f64,
            ldb: i64,
            C: *mut f64,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasDtrmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtrmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const f64,
            lda: i64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasDtrsmBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const *const f64,
            lda: ::core::ffi::c_int,
            B: *const *mut f64,
            ldb: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtrsmBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const *const f64,
            lda: i64,
            B: *const *mut f64,
            ldb: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasDtrsm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const f64,
            lda: ::core::ffi::c_int,
            B: *mut f64,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtrsm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f64,
            A: *const f64,
            lda: i64,
            B: *mut f64,
            ldb: i64,
        ) -> cublasStatus_t,
        pub cublasDtrsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            x: *mut f64,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDtrsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const f64,
            lda: i64,
            x: *mut f64,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasDtrttp: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            A: *const f64,
            lda: ::core::ffi::c_int,
            AP: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDzasum_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDzasum_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        pub cublasDznrm2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            result: *mut f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasDznrm2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            result: *mut f64,
        ) -> cublasStatus_t,
        pub cublasGemmBatchedEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            Aarray: *const *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            Barray: *const *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const ::core::ffi::c_void,
            Carray: *const *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGemmBatchedEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const ::core::ffi::c_void,
            Aarray: *const *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            Barray: *const *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const ::core::ffi::c_void,
            Carray: *const *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
            batchCount: i64,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        pub cublasGemmEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const ::core::ffi::c_void,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGemmEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const ::core::ffi::c_void,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const ::core::ffi::c_void,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGemmGroupedBatchedEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa_array: *const cublasOperation_t,
            transb_array: *const cublasOperation_t,
            m_array: *const ::core::ffi::c_int,
            n_array: *const ::core::ffi::c_int,
            k_array: *const ::core::ffi::c_int,
            alpha_array: *const ::core::ffi::c_void,
            Aarray: *const *const ::core::ffi::c_void,
            Atype: cudaDataType_t,
            lda_array: *const ::core::ffi::c_int,
            Barray: *const *const ::core::ffi::c_void,
            Btype: cudaDataType_t,
            ldb_array: *const ::core::ffi::c_int,
            beta_array: *const ::core::ffi::c_void,
            Carray: *const *mut ::core::ffi::c_void,
            Ctype: cudaDataType_t,
            ldc_array: *const ::core::ffi::c_int,
            group_count: ::core::ffi::c_int,
            group_size: *const ::core::ffi::c_int,
            computeType: cublasComputeType_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGemmGroupedBatchedEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa_array: *const cublasOperation_t,
            transb_array: *const cublasOperation_t,
            m_array: *const i64,
            n_array: *const i64,
            k_array: *const i64,
            alpha_array: *const ::core::ffi::c_void,
            Aarray: *const *const ::core::ffi::c_void,
            Atype: cudaDataType_t,
            lda_array: *const i64,
            Barray: *const *const ::core::ffi::c_void,
            Btype: cudaDataType_t,
            ldb_array: *const i64,
            beta_array: *const ::core::ffi::c_void,
            Carray: *const *mut ::core::ffi::c_void,
            Ctype: cudaDataType_t,
            ldc_array: *const i64,
            group_count: i64,
            group_size: *const i64,
            computeType: cublasComputeType_t,
        ) -> cublasStatus_t,
        pub cublasGemmStridedBatchedEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const ::core::ffi::c_void,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGemmStridedBatchedEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const ::core::ffi::c_void,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const ::core::ffi::c_void,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
            computeType: cublasComputeType_t,
            algo: cublasGemmAlgo_t,
        ) -> cublasStatus_t,
        pub cublasGetAtomicsMode: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: *mut cublasAtomicsMode_t,
        ) -> cublasStatus_t,
        pub cublasGetCudartVersion: unsafe extern "C" fn() -> usize,
        #[cfg(any(feature = "cuda-12090"))]
        pub cublasGetEmulationStrategy: unsafe extern "C" fn(
            handle: cublasHandle_t,
            emulationStrategy: *mut cublasEmulationStrategy_t,
        ) -> cublasStatus_t,
        pub cublasGetLoggerCallback:
            unsafe extern "C" fn(userCallback: *mut cublasLogCallback) -> cublasStatus_t,
        pub cublasGetMathMode:
            unsafe extern "C" fn(handle: cublasHandle_t, mode: *mut cublasMath_t) -> cublasStatus_t,
        pub cublasGetMatrix: unsafe extern "C" fn(
            rows: ::core::ffi::c_int,
            cols: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            A: *const ::core::ffi::c_void,
            lda: ::core::ffi::c_int,
            B: *mut ::core::ffi::c_void,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasGetMatrixAsync: unsafe extern "C" fn(
            rows: ::core::ffi::c_int,
            cols: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            A: *const ::core::ffi::c_void,
            lda: ::core::ffi::c_int,
            B: *mut ::core::ffi::c_void,
            ldb: ::core::ffi::c_int,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGetMatrixAsync_64: unsafe extern "C" fn(
            rows: i64,
            cols: i64,
            elemSize: i64,
            A: *const ::core::ffi::c_void,
            lda: i64,
            B: *mut ::core::ffi::c_void,
            ldb: i64,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGetMatrix_64: unsafe extern "C" fn(
            rows: i64,
            cols: i64,
            elemSize: i64,
            A: *const ::core::ffi::c_void,
            lda: i64,
            B: *mut ::core::ffi::c_void,
            ldb: i64,
        ) -> cublasStatus_t,
        pub cublasGetPointerMode_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: *mut cublasPointerMode_t,
        ) -> cublasStatus_t,
        pub cublasGetProperty: unsafe extern "C" fn(
            type_: libraryPropertyType,
            value: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasGetSmCountTarget: unsafe extern "C" fn(
            handle: cublasHandle_t,
            smCountTarget: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasGetStatusName:
            unsafe extern "C" fn(status: cublasStatus_t) -> *const ::core::ffi::c_char,
        pub cublasGetStatusString:
            unsafe extern "C" fn(status: cublasStatus_t) -> *const ::core::ffi::c_char,
        pub cublasGetStream_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            streamId: *mut cudaStream_t,
        ) -> cublasStatus_t,
        pub cublasGetVector: unsafe extern "C" fn(
            n: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasGetVectorAsync: unsafe extern "C" fn(
            n: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            devicePtr: *const ::core::ffi::c_void,
            incx: ::core::ffi::c_int,
            hostPtr: *mut ::core::ffi::c_void,
            incy: ::core::ffi::c_int,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGetVectorAsync_64: unsafe extern "C" fn(
            n: i64,
            elemSize: i64,
            devicePtr: *const ::core::ffi::c_void,
            incx: i64,
            hostPtr: *mut ::core::ffi::c_void,
            incy: i64,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasGetVector_64: unsafe extern "C" fn(
            n: i64,
            elemSize: i64,
            x: *const ::core::ffi::c_void,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasGetVersion_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            version: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasIamaxEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIamaxEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIaminEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIaminEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIcamax_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIcamax_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIcamin_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIcamin_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIdamax_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIdamax_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIdamin_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f64,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIdamin_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f64,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIsamax_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIsamax_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIsamin_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIsamin_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIzamax_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIzamax_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasIzamin_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasIzamin_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            result: *mut i64,
        ) -> cublasStatus_t,
        pub cublasLoggerConfigure: unsafe extern "C" fn(
            logIsOn: ::core::ffi::c_int,
            logToStdOut: ::core::ffi::c_int,
            logToStdErr: ::core::ffi::c_int,
            logFileName: *const ::core::ffi::c_char,
        ) -> cublasStatus_t,
        pub cublasNrm2Ex: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasNrm2Ex_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            result: *mut ::core::ffi::c_void,
            resultType: cudaDataType,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasRotEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            c: *const ::core::ffi::c_void,
            s: *const ::core::ffi::c_void,
            csType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasRotEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            c: *const ::core::ffi::c_void,
            s: *const ::core::ffi::c_void,
            csType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasRotgEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut ::core::ffi::c_void,
            b: *mut ::core::ffi::c_void,
            abType: cudaDataType,
            c: *mut ::core::ffi::c_void,
            s: *mut ::core::ffi::c_void,
            csType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasRotmEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
            param: *const ::core::ffi::c_void,
            paramType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasRotmEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
            param: *const ::core::ffi::c_void,
            paramType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasRotmgEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            d1: *mut ::core::ffi::c_void,
            d1Type: cudaDataType,
            d2: *mut ::core::ffi::c_void,
            d2Type: cudaDataType,
            x1: *mut ::core::ffi::c_void,
            x1Type: cudaDataType,
            y1: *const ::core::ffi::c_void,
            y1Type: cudaDataType,
            param: *mut ::core::ffi::c_void,
            paramType: cudaDataType,
            executiontype: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasSasum_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSasum_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        pub cublasSaxpy_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSaxpy_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasScalEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const ::core::ffi::c_void,
            alphaType: cudaDataType,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasScalEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const ::core::ffi::c_void,
            alphaType: cudaDataType,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            executionType: cudaDataType,
        ) -> cublasStatus_t,
        pub cublasScasum_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasScasum_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        pub cublasScnrm2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuComplex,
            incx: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasScnrm2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuComplex,
            incx: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        pub cublasScopy_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasScopy_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasSdgmm: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSdgmm_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: i64,
            n: i64,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasSdot_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *const f32,
            incy: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSdot_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            y: *const f32,
            incy: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        pub cublasSetAtomicsMode: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasAtomicsMode_t,
        ) -> cublasStatus_t,
        #[cfg(any(feature = "cuda-12090"))]
        pub cublasSetEmulationStrategy: unsafe extern "C" fn(
            handle: cublasHandle_t,
            emulationStrategy: cublasEmulationStrategy_t,
        ) -> cublasStatus_t,
        pub cublasSetLoggerCallback:
            unsafe extern "C" fn(userCallback: cublasLogCallback) -> cublasStatus_t,
        pub cublasSetMathMode:
            unsafe extern "C" fn(handle: cublasHandle_t, mode: cublasMath_t) -> cublasStatus_t,
        pub cublasSetMatrix: unsafe extern "C" fn(
            rows: ::core::ffi::c_int,
            cols: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            A: *const ::core::ffi::c_void,
            lda: ::core::ffi::c_int,
            B: *mut ::core::ffi::c_void,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSetMatrixAsync: unsafe extern "C" fn(
            rows: ::core::ffi::c_int,
            cols: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            A: *const ::core::ffi::c_void,
            lda: ::core::ffi::c_int,
            B: *mut ::core::ffi::c_void,
            ldb: ::core::ffi::c_int,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSetMatrixAsync_64: unsafe extern "C" fn(
            rows: i64,
            cols: i64,
            elemSize: i64,
            A: *const ::core::ffi::c_void,
            lda: i64,
            B: *mut ::core::ffi::c_void,
            ldb: i64,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSetMatrix_64: unsafe extern "C" fn(
            rows: i64,
            cols: i64,
            elemSize: i64,
            A: *const ::core::ffi::c_void,
            lda: i64,
            B: *mut ::core::ffi::c_void,
            ldb: i64,
        ) -> cublasStatus_t,
        pub cublasSetPointerMode_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasPointerMode_t,
        ) -> cublasStatus_t,
        pub cublasSetSmCountTarget: unsafe extern "C" fn(
            handle: cublasHandle_t,
            smCountTarget: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSetStream_v2:
            unsafe extern "C" fn(handle: cublasHandle_t, streamId: cudaStream_t) -> cublasStatus_t,
        pub cublasSetVector: unsafe extern "C" fn(
            n: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            x: *const ::core::ffi::c_void,
            incx: ::core::ffi::c_int,
            devicePtr: *mut ::core::ffi::c_void,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSetVectorAsync: unsafe extern "C" fn(
            n: ::core::ffi::c_int,
            elemSize: ::core::ffi::c_int,
            hostPtr: *const ::core::ffi::c_void,
            incx: ::core::ffi::c_int,
            devicePtr: *mut ::core::ffi::c_void,
            incy: ::core::ffi::c_int,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSetVectorAsync_64: unsafe extern "C" fn(
            n: i64,
            elemSize: i64,
            hostPtr: *const ::core::ffi::c_void,
            incx: i64,
            devicePtr: *mut ::core::ffi::c_void,
            incy: i64,
            stream: cudaStream_t,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSetVector_64: unsafe extern "C" fn(
            n: i64,
            elemSize: i64,
            x: *const ::core::ffi::c_void,
            incx: i64,
            devicePtr: *mut ::core::ffi::c_void,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasSetWorkspace_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            workspace: *mut ::core::ffi::c_void,
            workspaceSizeInBytes: usize,
        ) -> cublasStatus_t,
        pub cublasSgbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kl: ::core::ffi::c_int,
            ku: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            kl: i64,
            ku: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasSgeam: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgeam_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            beta: *const f32,
            B: *const f32,
            ldb: i64,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasSgelsBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *mut f32,
            lda: ::core::ffi::c_int,
            Carray: *const *mut f32,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            devInfoArray: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSgemmBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            Aarray: *const *const f32,
            lda: ::core::ffi::c_int,
            Barray: *const *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            Carray: *const *mut f32,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemmBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f32,
            Aarray: *const *const f32,
            lda: i64,
            Barray: *const *const f32,
            ldb: i64,
            beta: *const f32,
            Carray: *const *mut f32,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasSgemmEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemmEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const ::core::ffi::c_void,
            Atype: cudaDataType,
            lda: i64,
            B: *const ::core::ffi::c_void,
            Btype: cudaDataType,
            ldb: i64,
            beta: *const f32,
            C: *mut ::core::ffi::c_void,
            Ctype: cudaDataType,
            ldc: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemmGroupedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa_array: *const cublasOperation_t,
            transb_array: *const cublasOperation_t,
            m_array: *const ::core::ffi::c_int,
            n_array: *const ::core::ffi::c_int,
            k_array: *const ::core::ffi::c_int,
            alpha_array: *const f32,
            Aarray: *const *const f32,
            lda_array: *const ::core::ffi::c_int,
            Barray: *const *const f32,
            ldb_array: *const ::core::ffi::c_int,
            beta_array: *const f32,
            Carray: *const *mut f32,
            ldc_array: *const ::core::ffi::c_int,
            group_count: ::core::ffi::c_int,
            group_size: *const ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemmGroupedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa_array: *const cublasOperation_t,
            transb_array: *const cublasOperation_t,
            m_array: *const i64,
            n_array: *const i64,
            k_array: *const i64,
            alpha_array: *const f32,
            Aarray: *const *const f32,
            lda_array: *const i64,
            Barray: *const *const f32,
            ldb_array: *const i64,
            beta_array: *const f32,
            Carray: *const *mut f32,
            ldc_array: *const i64,
            group_count: i64,
            group_size: *const i64,
        ) -> cublasStatus_t,
        pub cublasSgemmStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemmStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const f32,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasSgemm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemvBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            Aarray: *const *const f32,
            lda: ::core::ffi::c_int,
            xarray: *const *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            yarray: *const *mut f32,
            incy: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemvBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            Aarray: *const *const f32,
            lda: i64,
            xarray: *const *const f32,
            incx: i64,
            beta: *const f32,
            yarray: *const *mut f32,
            incy: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemvStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            x: *const f32,
            incx: ::core::ffi::c_int,
            stridex: ::core::ffi::c_longlong,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
            stridey: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemvStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            x: *const f32,
            incx: i64,
            stridex: ::core::ffi::c_longlong,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
            stridey: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasSgemv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSgemv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasSgeqrfBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            Aarray: *const *mut f32,
            lda: ::core::ffi::c_int,
            TauArray: *const *mut f32,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSger_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *const f32,
            incy: ::core::ffi::c_int,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSger_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            y: *const f32,
            incy: i64,
            A: *mut f32,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasSgetrfBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *mut f32,
            lda: ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSgetriBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const f32,
            lda: ::core::ffi::c_int,
            P: *const ::core::ffi::c_int,
            C: *const *mut f32,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSgetrsBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *const f32,
            lda: ::core::ffi::c_int,
            devIpiv: *const ::core::ffi::c_int,
            Barray: *const *mut f32,
            ldb: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSmatinvBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const f32,
            lda: ::core::ffi::c_int,
            Ainv: *const *mut f32,
            lda_inv: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasSnrm2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            result: *mut f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSnrm2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const f32,
            incx: i64,
            result: *mut f32,
        ) -> cublasStatus_t,
        pub cublasSrot_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
            c: *const f32,
            s: *const f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSrot_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
            c: *const f32,
            s: *const f32,
        ) -> cublasStatus_t,
        pub cublasSrotg_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut f32,
            b: *mut f32,
            c: *mut f32,
            s: *mut f32,
        ) -> cublasStatus_t,
        pub cublasSrotm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
            param: *const f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSrotm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
            param: *const f32,
        ) -> cublasStatus_t,
        pub cublasSrotmg_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            d1: *mut f32,
            d2: *mut f32,
            x1: *mut f32,
            y1: *const f32,
            param: *mut f32,
        ) -> cublasStatus_t,
        pub cublasSsbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSsbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasSscal_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSscal_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f32,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasSspmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            AP: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSspmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            AP: *const f32,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasSspr2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *const f32,
            incy: ::core::ffi::c_int,
            AP: *mut f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSspr2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            y: *const f32,
            incy: i64,
            AP: *mut f32,
        ) -> cublasStatus_t,
        pub cublasSspr_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            AP: *mut f32,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSspr_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            AP: *mut f32,
        ) -> cublasStatus_t,
        pub cublasSswap_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSswap_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut f32,
            incx: i64,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasSsymm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSsymm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasSsymv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *const f32,
            incx: ::core::ffi::c_int,
            beta: *const f32,
            y: *mut f32,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSsymv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            x: *const f32,
            incx: i64,
            beta: *const f32,
            y: *mut f32,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasSsyr2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            y: *const f32,
            incy: ::core::ffi::c_int,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSsyr2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            y: *const f32,
            incy: i64,
            A: *mut f32,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasSsyr2k_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSsyr2k_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasSsyr_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            x: *const f32,
            incx: ::core::ffi::c_int,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSsyr_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f32,
            x: *const f32,
            incx: i64,
            A: *mut f32,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasSsyrk_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSsyrk_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasSsyrkx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            beta: *const f32,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSsyrkx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            beta: *const f32,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasStbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const f32,
            lda: i64,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasStbsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStbsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const f32,
            lda: i64,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasStpmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const f32,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStpmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const f32,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasStpsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const f32,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStpsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const f32,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasStpttr: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            AP: *const f32,
            A: *mut f32,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasStrmm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *const f32,
            ldb: ::core::ffi::c_int,
            C: *mut f32,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStrmm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *const f32,
            ldb: i64,
            C: *mut f32,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasStrmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStrmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const f32,
            lda: i64,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasStrsmBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const *const f32,
            lda: ::core::ffi::c_int,
            B: *const *mut f32,
            ldb: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStrsmBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const *const f32,
            lda: i64,
            B: *const *mut f32,
            ldb: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasStrsm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const f32,
            A: *const f32,
            lda: ::core::ffi::c_int,
            B: *mut f32,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStrsm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const f32,
            A: *const f32,
            lda: i64,
            B: *mut f32,
            ldb: i64,
        ) -> cublasStatus_t,
        pub cublasStrsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            x: *mut f32,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasStrsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const f32,
            lda: i64,
            x: *mut f32,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasStrttp: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            A: *const f32,
            lda: ::core::ffi::c_int,
            AP: *mut f32,
        ) -> cublasStatus_t,
        pub cublasSwapEx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: ::core::ffi::c_int,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasSwapEx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut ::core::ffi::c_void,
            xType: cudaDataType,
            incx: i64,
            y: *mut ::core::ffi::c_void,
            yType: cudaDataType,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasUint8gemmBias: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            transc: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const ::core::ffi::c_uchar,
            A_bias: ::core::ffi::c_int,
            lda: ::core::ffi::c_int,
            B: *const ::core::ffi::c_uchar,
            B_bias: ::core::ffi::c_int,
            ldb: ::core::ffi::c_int,
            C: *mut ::core::ffi::c_uchar,
            C_bias: ::core::ffi::c_int,
            ldc: ::core::ffi::c_int,
            C_mult: ::core::ffi::c_int,
            C_shift: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasXerbla:
            unsafe extern "C" fn(srName: *const ::core::ffi::c_char, info: ::core::ffi::c_int),
        pub cublasZaxpy_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZaxpy_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZcopy_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZcopy_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZdgmm: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZdgmm_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            mode: cublasSideMode_t,
            m: i64,
            n: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZdotc_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            result: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZdotc_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            result: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        pub cublasZdotu_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            result: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZdotu_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            result: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        pub cublasZdrot_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
            c: *const f64,
            s: *const f64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZdrot_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
            c: *const f64,
            s: *const f64,
        ) -> cublasStatus_t,
        pub cublasZdscal_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZdscal_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const f64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasZgbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            kl: ::core::ffi::c_int,
            ku: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            kl: i64,
            ku: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZgeam: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgeam_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            beta: *const cuDoubleComplex,
            B: *const cuDoubleComplex,
            ldb: i64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZgelsBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
            Carray: *const *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            devInfoArray: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasZgemm3m: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemm3m_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZgemmBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            Aarray: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            Barray: *const *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            Carray: *const *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemmBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            Aarray: *const *const cuDoubleComplex,
            lda: i64,
            Barray: *const *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            Carray: *const *mut cuDoubleComplex,
            ldc: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasZgemmStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
            strideC: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemmStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            B: *const cuDoubleComplex,
            ldb: i64,
            strideB: ::core::ffi::c_longlong,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
            strideC: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasZgemm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            transa: cublasOperation_t,
            transb: cublasOperation_t,
            m: i64,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemvBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            Aarray: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            xarray: *const *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            yarray: *const *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemvBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            Aarray: *const *const cuDoubleComplex,
            lda: i64,
            xarray: *const *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            yarray: *const *mut cuDoubleComplex,
            incy: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-11060",
            feature = "cuda-11070",
            feature = "cuda-11080",
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemvStridedBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            strideA: ::core::ffi::c_longlong,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            stridex: ::core::ffi::c_longlong,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
            stridey: ::core::ffi::c_longlong,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemvStridedBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            strideA: ::core::ffi::c_longlong,
            x: *const cuDoubleComplex,
            incx: i64,
            stridex: ::core::ffi::c_longlong,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
            stridey: ::core::ffi::c_longlong,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasZgemv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgemv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZgeqrfBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            Aarray: *const *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
            TauArray: *const *mut cuDoubleComplex,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasZgerc_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgerc_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasZgeru_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZgeru_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasZgetrfBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
            P: *mut ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasZgetriBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            P: *const ::core::ffi::c_int,
            C: *const *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasZgetrsBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            nrhs: ::core::ffi::c_int,
            Aarray: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            devIpiv: *const ::core::ffi::c_int,
            Barray: *const *mut cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasZhbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZhbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZhemm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZhemm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZhemv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZhemv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZher2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZher2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasZher2k_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZher2k_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZher_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZher_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const cuDoubleComplex,
            incx: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasZherk_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const f64,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZherk_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const f64,
            A: *const cuDoubleComplex,
            lda: i64,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZherkx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZherkx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const f64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZhpmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            AP: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZhpmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            AP: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZhpr2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZhpr2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        pub cublasZhpr_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const f64,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZhpr_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const f64,
            x: *const cuDoubleComplex,
            incx: i64,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        pub cublasZmatinvBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            A: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            Ainv: *const *mut cuDoubleComplex,
            lda_inv: ::core::ffi::c_int,
            info: *mut ::core::ffi::c_int,
            batchSize: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasZrot_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
            c: *const f64,
            s: *const cuDoubleComplex,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZrot_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
            c: *const f64,
            s: *const cuDoubleComplex,
        ) -> cublasStatus_t,
        pub cublasZrotg_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            a: *mut cuDoubleComplex,
            b: *mut cuDoubleComplex,
            c: *mut f64,
            s: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
        pub cublasZscal_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZscal_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasZswap_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZswap_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            n: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZsymm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZsymm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZsymv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZsymv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *const cuDoubleComplex,
            incx: i64,
            beta: *const cuDoubleComplex,
            y: *mut cuDoubleComplex,
            incy: i64,
        ) -> cublasStatus_t,
        pub cublasZsyr2_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            y: *const cuDoubleComplex,
            incy: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZsyr2_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            y: *const cuDoubleComplex,
            incy: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasZsyr2k_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZsyr2k_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZsyr_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: ::core::ffi::c_int,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZsyr_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: i64,
            alpha: *const cuDoubleComplex,
            x: *const cuDoubleComplex,
            incx: i64,
            A: *mut cuDoubleComplex,
            lda: i64,
        ) -> cublasStatus_t,
        pub cublasZsyrk_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZsyrk_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZsyrkx: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZsyrkx_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            n: i64,
            k: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            beta: *const cuDoubleComplex,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZtbmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtbmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasZtbsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            k: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtbsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            k: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasZtpmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtpmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasZtpsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            AP: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtpsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            AP: *const cuDoubleComplex,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasZtpttr: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            AP: *const cuDoubleComplex,
            A: *mut cuDoubleComplex,
            lda: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        pub cublasZtrmm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            C: *mut cuDoubleComplex,
            ldc: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtrmm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *const cuDoubleComplex,
            ldb: i64,
            C: *mut cuDoubleComplex,
            ldc: i64,
        ) -> cublasStatus_t,
        pub cublasZtrmv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtrmv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasZtrsmBatched: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *const *mut cuDoubleComplex,
            ldb: ::core::ffi::c_int,
            batchCount: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtrsmBatched_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const *const cuDoubleComplex,
            lda: i64,
            B: *const *mut cuDoubleComplex,
            ldb: i64,
            batchCount: i64,
        ) -> cublasStatus_t,
        pub cublasZtrsm_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: ::core::ffi::c_int,
            n: ::core::ffi::c_int,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            B: *mut cuDoubleComplex,
            ldb: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtrsm_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            side: cublasSideMode_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            m: i64,
            n: i64,
            alpha: *const cuDoubleComplex,
            A: *const cuDoubleComplex,
            lda: i64,
            B: *mut cuDoubleComplex,
            ldb: i64,
        ) -> cublasStatus_t,
        pub cublasZtrsv_v2: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            x: *mut cuDoubleComplex,
            incx: ::core::ffi::c_int,
        ) -> cublasStatus_t,
        #[cfg(any(
            feature = "cuda-12000",
            feature = "cuda-12010",
            feature = "cuda-12020",
            feature = "cuda-12030",
            feature = "cuda-12040",
            feature = "cuda-12050",
            feature = "cuda-12060",
            feature = "cuda-12080",
            feature = "cuda-12090"
        ))]
        pub cublasZtrsv_v2_64: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            trans: cublasOperation_t,
            diag: cublasDiagType_t,
            n: i64,
            A: *const cuDoubleComplex,
            lda: i64,
            x: *mut cuDoubleComplex,
            incx: i64,
        ) -> cublasStatus_t,
        pub cublasZtrttp: unsafe extern "C" fn(
            handle: cublasHandle_t,
            uplo: cublasFillMode_t,
            n: ::core::ffi::c_int,
            A: *const cuDoubleComplex,
            lda: ::core::ffi::c_int,
            AP: *mut cuDoubleComplex,
        ) -> cublasStatus_t,
    }
    impl Lib {
        pub unsafe fn new<P>(path: P) -> Result<Self, ::libloading::Error>
        where
            P: AsRef<::std::ffi::OsStr>,
        {
            let library = ::libloading::Library::new(path)?;
            Self::from_library(library)
        }
        pub unsafe fn from_library<L>(library: L) -> Result<Self, ::libloading::Error>
        where
            L: Into<::libloading::Library>,
        {
            let __library = library.into();
            let cublasAsumEx = __library
                .get(b"cublasAsumEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasAsumEx_64 = __library
                .get(b"cublasAsumEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasAxpyEx = __library
                .get(b"cublasAxpyEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasAxpyEx_64 = __library
                .get(b"cublasAxpyEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCaxpy_v2 = __library
                .get(b"cublasCaxpy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCaxpy_v2_64 = __library
                .get(b"cublasCaxpy_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCcopy_v2 = __library
                .get(b"cublasCcopy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCcopy_v2_64 = __library
                .get(b"cublasCcopy_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCdgmm = __library
                .get(b"cublasCdgmm\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCdgmm_64 = __library
                .get(b"cublasCdgmm_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCdotc_v2 = __library
                .get(b"cublasCdotc_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCdotc_v2_64 = __library
                .get(b"cublasCdotc_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCdotu_v2 = __library
                .get(b"cublasCdotu_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCdotu_v2_64 = __library
                .get(b"cublasCdotu_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgbmv_v2 = __library
                .get(b"cublasCgbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgbmv_v2_64 = __library
                .get(b"cublasCgbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgeam = __library
                .get(b"cublasCgeam\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgeam_64 = __library
                .get(b"cublasCgeam_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgelsBatched = __library
                .get(b"cublasCgelsBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemm3m = __library
                .get(b"cublasCgemm3m\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemm3mBatched = __library
                .get(b"cublasCgemm3mBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemm3mBatched_64 = __library
                .get(b"cublasCgemm3mBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemm3mEx = __library
                .get(b"cublasCgemm3mEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemm3mEx_64 = __library
                .get(b"cublasCgemm3mEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemm3mStridedBatched = __library
                .get(b"cublasCgemm3mStridedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemm3mStridedBatched_64 = __library
                .get(b"cublasCgemm3mStridedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemm3m_64 = __library
                .get(b"cublasCgemm3m_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemmBatched = __library
                .get(b"cublasCgemmBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemmBatched_64 = __library
                .get(b"cublasCgemmBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemmEx = __library
                .get(b"cublasCgemmEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemmEx_64 = __library
                .get(b"cublasCgemmEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemmStridedBatched = __library
                .get(b"cublasCgemmStridedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemmStridedBatched_64 = __library
                .get(b"cublasCgemmStridedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemm_v2 = __library
                .get(b"cublasCgemm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemm_v2_64 = __library
                .get(b"cublasCgemm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-11060",
                feature = "cuda-11070",
                feature = "cuda-11080",
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemvBatched = __library
                .get(b"cublasCgemvBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemvBatched_64 = __library
                .get(b"cublasCgemvBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-11060",
                feature = "cuda-11070",
                feature = "cuda-11080",
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemvStridedBatched = __library
                .get(b"cublasCgemvStridedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemvStridedBatched_64 = __library
                .get(b"cublasCgemvStridedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgemv_v2 = __library
                .get(b"cublasCgemv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgemv_v2_64 = __library
                .get(b"cublasCgemv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgeqrfBatched = __library
                .get(b"cublasCgeqrfBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgerc_v2 = __library
                .get(b"cublasCgerc_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgerc_v2_64 = __library
                .get(b"cublasCgerc_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgeru_v2 = __library
                .get(b"cublasCgeru_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCgeru_v2_64 = __library
                .get(b"cublasCgeru_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgetrfBatched = __library
                .get(b"cublasCgetrfBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgetriBatched = __library
                .get(b"cublasCgetriBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCgetrsBatched = __library
                .get(b"cublasCgetrsBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasChbmv_v2 = __library
                .get(b"cublasChbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasChbmv_v2_64 = __library
                .get(b"cublasChbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasChemm_v2 = __library
                .get(b"cublasChemm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasChemm_v2_64 = __library
                .get(b"cublasChemm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasChemv_v2 = __library
                .get(b"cublasChemv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasChemv_v2_64 = __library
                .get(b"cublasChemv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCher2_v2 = __library
                .get(b"cublasCher2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCher2_v2_64 = __library
                .get(b"cublasCher2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCher2k_v2 = __library
                .get(b"cublasCher2k_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCher2k_v2_64 = __library
                .get(b"cublasCher2k_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCher_v2 = __library
                .get(b"cublasCher_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCher_v2_64 = __library
                .get(b"cublasCher_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCherk3mEx = __library
                .get(b"cublasCherk3mEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCherk3mEx_64 = __library
                .get(b"cublasCherk3mEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCherkEx = __library
                .get(b"cublasCherkEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCherkEx_64 = __library
                .get(b"cublasCherkEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCherk_v2 = __library
                .get(b"cublasCherk_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCherk_v2_64 = __library
                .get(b"cublasCherk_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCherkx = __library
                .get(b"cublasCherkx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCherkx_64 = __library
                .get(b"cublasCherkx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasChpmv_v2 = __library
                .get(b"cublasChpmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasChpmv_v2_64 = __library
                .get(b"cublasChpmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasChpr2_v2 = __library
                .get(b"cublasChpr2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasChpr2_v2_64 = __library
                .get(b"cublasChpr2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasChpr_v2 = __library
                .get(b"cublasChpr_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasChpr_v2_64 = __library
                .get(b"cublasChpr_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCmatinvBatched = __library
                .get(b"cublasCmatinvBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCopyEx = __library
                .get(b"cublasCopyEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCopyEx_64 = __library
                .get(b"cublasCopyEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCreate_v2 = __library
                .get(b"cublasCreate_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCrot_v2 = __library
                .get(b"cublasCrot_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCrot_v2_64 = __library
                .get(b"cublasCrot_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCrotg_v2 = __library
                .get(b"cublasCrotg_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCscal_v2 = __library
                .get(b"cublasCscal_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCscal_v2_64 = __library
                .get(b"cublasCscal_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsrot_v2 = __library
                .get(b"cublasCsrot_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsrot_v2_64 = __library
                .get(b"cublasCsrot_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsscal_v2 = __library
                .get(b"cublasCsscal_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsscal_v2_64 = __library
                .get(b"cublasCsscal_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCswap_v2 = __library
                .get(b"cublasCswap_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCswap_v2_64 = __library
                .get(b"cublasCswap_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsymm_v2 = __library
                .get(b"cublasCsymm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsymm_v2_64 = __library
                .get(b"cublasCsymm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsymv_v2 = __library
                .get(b"cublasCsymv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsymv_v2_64 = __library
                .get(b"cublasCsymv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsyr2_v2 = __library
                .get(b"cublasCsyr2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsyr2_v2_64 = __library
                .get(b"cublasCsyr2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsyr2k_v2 = __library
                .get(b"cublasCsyr2k_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsyr2k_v2_64 = __library
                .get(b"cublasCsyr2k_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsyr_v2 = __library
                .get(b"cublasCsyr_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsyr_v2_64 = __library
                .get(b"cublasCsyr_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsyrk3mEx = __library
                .get(b"cublasCsyrk3mEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsyrk3mEx_64 = __library
                .get(b"cublasCsyrk3mEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsyrkEx = __library
                .get(b"cublasCsyrkEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsyrkEx_64 = __library
                .get(b"cublasCsyrkEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsyrk_v2 = __library
                .get(b"cublasCsyrk_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsyrk_v2_64 = __library
                .get(b"cublasCsyrk_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCsyrkx = __library
                .get(b"cublasCsyrkx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCsyrkx_64 = __library
                .get(b"cublasCsyrkx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtbmv_v2 = __library
                .get(b"cublasCtbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtbmv_v2_64 = __library
                .get(b"cublasCtbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtbsv_v2 = __library
                .get(b"cublasCtbsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtbsv_v2_64 = __library
                .get(b"cublasCtbsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtpmv_v2 = __library
                .get(b"cublasCtpmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtpmv_v2_64 = __library
                .get(b"cublasCtpmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtpsv_v2 = __library
                .get(b"cublasCtpsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtpsv_v2_64 = __library
                .get(b"cublasCtpsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtpttr = __library
                .get(b"cublasCtpttr\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtrmm_v2 = __library
                .get(b"cublasCtrmm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtrmm_v2_64 = __library
                .get(b"cublasCtrmm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtrmv_v2 = __library
                .get(b"cublasCtrmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtrmv_v2_64 = __library
                .get(b"cublasCtrmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtrsmBatched = __library
                .get(b"cublasCtrsmBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtrsmBatched_64 = __library
                .get(b"cublasCtrsmBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtrsm_v2 = __library
                .get(b"cublasCtrsm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtrsm_v2_64 = __library
                .get(b"cublasCtrsm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtrsv_v2 = __library
                .get(b"cublasCtrsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasCtrsv_v2_64 = __library
                .get(b"cublasCtrsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasCtrttp = __library
                .get(b"cublasCtrttp\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDasum_v2 = __library
                .get(b"cublasDasum_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDasum_v2_64 = __library
                .get(b"cublasDasum_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDaxpy_v2 = __library
                .get(b"cublasDaxpy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDaxpy_v2_64 = __library
                .get(b"cublasDaxpy_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDcopy_v2 = __library
                .get(b"cublasDcopy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDcopy_v2_64 = __library
                .get(b"cublasDcopy_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDdgmm = __library
                .get(b"cublasDdgmm\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDdgmm_64 = __library
                .get(b"cublasDdgmm_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDdot_v2 = __library
                .get(b"cublasDdot_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDdot_v2_64 = __library
                .get(b"cublasDdot_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDestroy_v2 = __library
                .get(b"cublasDestroy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgbmv_v2 = __library
                .get(b"cublasDgbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgbmv_v2_64 = __library
                .get(b"cublasDgbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgeam = __library
                .get(b"cublasDgeam\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgeam_64 = __library
                .get(b"cublasDgeam_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgelsBatched = __library
                .get(b"cublasDgelsBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgemmBatched = __library
                .get(b"cublasDgemmBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemmBatched_64 = __library
                .get(b"cublasDgemmBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemmGroupedBatched = __library
                .get(b"cublasDgemmGroupedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemmGroupedBatched_64 = __library
                .get(b"cublasDgemmGroupedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgemmStridedBatched = __library
                .get(b"cublasDgemmStridedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemmStridedBatched_64 = __library
                .get(b"cublasDgemmStridedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgemm_v2 = __library
                .get(b"cublasDgemm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemm_v2_64 = __library
                .get(b"cublasDgemm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-11060",
                feature = "cuda-11070",
                feature = "cuda-11080",
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemvBatched = __library
                .get(b"cublasDgemvBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemvBatched_64 = __library
                .get(b"cublasDgemvBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-11060",
                feature = "cuda-11070",
                feature = "cuda-11080",
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemvStridedBatched = __library
                .get(b"cublasDgemvStridedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemvStridedBatched_64 = __library
                .get(b"cublasDgemvStridedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgemv_v2 = __library
                .get(b"cublasDgemv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDgemv_v2_64 = __library
                .get(b"cublasDgemv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgeqrfBatched = __library
                .get(b"cublasDgeqrfBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDger_v2 = __library
                .get(b"cublasDger_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDger_v2_64 = __library
                .get(b"cublasDger_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgetrfBatched = __library
                .get(b"cublasDgetrfBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgetriBatched = __library
                .get(b"cublasDgetriBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDgetrsBatched = __library
                .get(b"cublasDgetrsBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDmatinvBatched = __library
                .get(b"cublasDmatinvBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDnrm2_v2 = __library
                .get(b"cublasDnrm2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDnrm2_v2_64 = __library
                .get(b"cublasDnrm2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDotEx = __library
                .get(b"cublasDotEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDotEx_64 = __library
                .get(b"cublasDotEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDotcEx = __library
                .get(b"cublasDotcEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDotcEx_64 = __library
                .get(b"cublasDotcEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDrot_v2 = __library
                .get(b"cublasDrot_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDrot_v2_64 = __library
                .get(b"cublasDrot_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDrotg_v2 = __library
                .get(b"cublasDrotg_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDrotm_v2 = __library
                .get(b"cublasDrotm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDrotm_v2_64 = __library
                .get(b"cublasDrotm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDrotmg_v2 = __library
                .get(b"cublasDrotmg_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDsbmv_v2 = __library
                .get(b"cublasDsbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDsbmv_v2_64 = __library
                .get(b"cublasDsbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDscal_v2 = __library
                .get(b"cublasDscal_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDscal_v2_64 = __library
                .get(b"cublasDscal_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDspmv_v2 = __library
                .get(b"cublasDspmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDspmv_v2_64 = __library
                .get(b"cublasDspmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDspr2_v2 = __library
                .get(b"cublasDspr2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDspr2_v2_64 = __library
                .get(b"cublasDspr2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDspr_v2 = __library
                .get(b"cublasDspr_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDspr_v2_64 = __library
                .get(b"cublasDspr_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDswap_v2 = __library
                .get(b"cublasDswap_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDswap_v2_64 = __library
                .get(b"cublasDswap_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDsymm_v2 = __library
                .get(b"cublasDsymm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDsymm_v2_64 = __library
                .get(b"cublasDsymm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDsymv_v2 = __library
                .get(b"cublasDsymv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDsymv_v2_64 = __library
                .get(b"cublasDsymv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDsyr2_v2 = __library
                .get(b"cublasDsyr2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDsyr2_v2_64 = __library
                .get(b"cublasDsyr2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDsyr2k_v2 = __library
                .get(b"cublasDsyr2k_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDsyr2k_v2_64 = __library
                .get(b"cublasDsyr2k_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDsyr_v2 = __library
                .get(b"cublasDsyr_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDsyr_v2_64 = __library
                .get(b"cublasDsyr_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDsyrk_v2 = __library
                .get(b"cublasDsyrk_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDsyrk_v2_64 = __library
                .get(b"cublasDsyrk_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDsyrkx = __library
                .get(b"cublasDsyrkx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDsyrkx_64 = __library
                .get(b"cublasDsyrkx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtbmv_v2 = __library
                .get(b"cublasDtbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtbmv_v2_64 = __library
                .get(b"cublasDtbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtbsv_v2 = __library
                .get(b"cublasDtbsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtbsv_v2_64 = __library
                .get(b"cublasDtbsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtpmv_v2 = __library
                .get(b"cublasDtpmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtpmv_v2_64 = __library
                .get(b"cublasDtpmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtpsv_v2 = __library
                .get(b"cublasDtpsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtpsv_v2_64 = __library
                .get(b"cublasDtpsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtpttr = __library
                .get(b"cublasDtpttr\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtrmm_v2 = __library
                .get(b"cublasDtrmm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtrmm_v2_64 = __library
                .get(b"cublasDtrmm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtrmv_v2 = __library
                .get(b"cublasDtrmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtrmv_v2_64 = __library
                .get(b"cublasDtrmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtrsmBatched = __library
                .get(b"cublasDtrsmBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtrsmBatched_64 = __library
                .get(b"cublasDtrsmBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtrsm_v2 = __library
                .get(b"cublasDtrsm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtrsm_v2_64 = __library
                .get(b"cublasDtrsm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtrsv_v2 = __library
                .get(b"cublasDtrsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDtrsv_v2_64 = __library
                .get(b"cublasDtrsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDtrttp = __library
                .get(b"cublasDtrttp\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDzasum_v2 = __library
                .get(b"cublasDzasum_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDzasum_v2_64 = __library
                .get(b"cublasDzasum_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasDznrm2_v2 = __library
                .get(b"cublasDznrm2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasDznrm2_v2_64 = __library
                .get(b"cublasDznrm2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGemmBatchedEx = __library
                .get(b"cublasGemmBatchedEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGemmBatchedEx_64 = __library
                .get(b"cublasGemmBatchedEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGemmEx = __library
                .get(b"cublasGemmEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGemmEx_64 = __library
                .get(b"cublasGemmEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGemmGroupedBatchedEx = __library
                .get(b"cublasGemmGroupedBatchedEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGemmGroupedBatchedEx_64 = __library
                .get(b"cublasGemmGroupedBatchedEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGemmStridedBatchedEx = __library
                .get(b"cublasGemmStridedBatchedEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGemmStridedBatchedEx_64 = __library
                .get(b"cublasGemmStridedBatchedEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetAtomicsMode = __library
                .get(b"cublasGetAtomicsMode\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetCudartVersion = __library
                .get(b"cublasGetCudartVersion\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(feature = "cuda-12090"))]
            let cublasGetEmulationStrategy = __library
                .get(b"cublasGetEmulationStrategy\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetLoggerCallback = __library
                .get(b"cublasGetLoggerCallback\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetMathMode = __library
                .get(b"cublasGetMathMode\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetMatrix = __library
                .get(b"cublasGetMatrix\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetMatrixAsync = __library
                .get(b"cublasGetMatrixAsync\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGetMatrixAsync_64 = __library
                .get(b"cublasGetMatrixAsync_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGetMatrix_64 = __library
                .get(b"cublasGetMatrix_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetPointerMode_v2 = __library
                .get(b"cublasGetPointerMode_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetProperty = __library
                .get(b"cublasGetProperty\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetSmCountTarget = __library
                .get(b"cublasGetSmCountTarget\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetStatusName = __library
                .get(b"cublasGetStatusName\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetStatusString = __library
                .get(b"cublasGetStatusString\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetStream_v2 = __library
                .get(b"cublasGetStream_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetVector = __library
                .get(b"cublasGetVector\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetVectorAsync = __library
                .get(b"cublasGetVectorAsync\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGetVectorAsync_64 = __library
                .get(b"cublasGetVectorAsync_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasGetVector_64 = __library
                .get(b"cublasGetVector_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasGetVersion_v2 = __library
                .get(b"cublasGetVersion_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIamaxEx = __library
                .get(b"cublasIamaxEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIamaxEx_64 = __library
                .get(b"cublasIamaxEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIaminEx = __library
                .get(b"cublasIaminEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIaminEx_64 = __library
                .get(b"cublasIaminEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIcamax_v2 = __library
                .get(b"cublasIcamax_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIcamax_v2_64 = __library
                .get(b"cublasIcamax_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIcamin_v2 = __library
                .get(b"cublasIcamin_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIcamin_v2_64 = __library
                .get(b"cublasIcamin_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIdamax_v2 = __library
                .get(b"cublasIdamax_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIdamax_v2_64 = __library
                .get(b"cublasIdamax_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIdamin_v2 = __library
                .get(b"cublasIdamin_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIdamin_v2_64 = __library
                .get(b"cublasIdamin_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIsamax_v2 = __library
                .get(b"cublasIsamax_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIsamax_v2_64 = __library
                .get(b"cublasIsamax_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIsamin_v2 = __library
                .get(b"cublasIsamin_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIsamin_v2_64 = __library
                .get(b"cublasIsamin_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIzamax_v2 = __library
                .get(b"cublasIzamax_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIzamax_v2_64 = __library
                .get(b"cublasIzamax_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasIzamin_v2 = __library
                .get(b"cublasIzamin_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasIzamin_v2_64 = __library
                .get(b"cublasIzamin_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasLoggerConfigure = __library
                .get(b"cublasLoggerConfigure\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasNrm2Ex = __library
                .get(b"cublasNrm2Ex\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasNrm2Ex_64 = __library
                .get(b"cublasNrm2Ex_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasRotEx = __library
                .get(b"cublasRotEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasRotEx_64 = __library
                .get(b"cublasRotEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasRotgEx = __library
                .get(b"cublasRotgEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasRotmEx = __library
                .get(b"cublasRotmEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasRotmEx_64 = __library
                .get(b"cublasRotmEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasRotmgEx = __library
                .get(b"cublasRotmgEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSasum_v2 = __library
                .get(b"cublasSasum_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSasum_v2_64 = __library
                .get(b"cublasSasum_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSaxpy_v2 = __library
                .get(b"cublasSaxpy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSaxpy_v2_64 = __library
                .get(b"cublasSaxpy_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasScalEx = __library
                .get(b"cublasScalEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasScalEx_64 = __library
                .get(b"cublasScalEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasScasum_v2 = __library
                .get(b"cublasScasum_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasScasum_v2_64 = __library
                .get(b"cublasScasum_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasScnrm2_v2 = __library
                .get(b"cublasScnrm2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasScnrm2_v2_64 = __library
                .get(b"cublasScnrm2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasScopy_v2 = __library
                .get(b"cublasScopy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasScopy_v2_64 = __library
                .get(b"cublasScopy_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSdgmm = __library
                .get(b"cublasSdgmm\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSdgmm_64 = __library
                .get(b"cublasSdgmm_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSdot_v2 = __library
                .get(b"cublasSdot_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSdot_v2_64 = __library
                .get(b"cublasSdot_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetAtomicsMode = __library
                .get(b"cublasSetAtomicsMode\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(feature = "cuda-12090"))]
            let cublasSetEmulationStrategy = __library
                .get(b"cublasSetEmulationStrategy\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetLoggerCallback = __library
                .get(b"cublasSetLoggerCallback\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetMathMode = __library
                .get(b"cublasSetMathMode\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetMatrix = __library
                .get(b"cublasSetMatrix\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetMatrixAsync = __library
                .get(b"cublasSetMatrixAsync\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSetMatrixAsync_64 = __library
                .get(b"cublasSetMatrixAsync_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSetMatrix_64 = __library
                .get(b"cublasSetMatrix_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetPointerMode_v2 = __library
                .get(b"cublasSetPointerMode_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetSmCountTarget = __library
                .get(b"cublasSetSmCountTarget\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetStream_v2 = __library
                .get(b"cublasSetStream_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetVector = __library
                .get(b"cublasSetVector\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetVectorAsync = __library
                .get(b"cublasSetVectorAsync\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSetVectorAsync_64 = __library
                .get(b"cublasSetVectorAsync_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSetVector_64 = __library
                .get(b"cublasSetVector_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSetWorkspace_v2 = __library
                .get(b"cublasSetWorkspace_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgbmv_v2 = __library
                .get(b"cublasSgbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgbmv_v2_64 = __library
                .get(b"cublasSgbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgeam = __library
                .get(b"cublasSgeam\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgeam_64 = __library
                .get(b"cublasSgeam_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgelsBatched = __library
                .get(b"cublasSgelsBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgemmBatched = __library
                .get(b"cublasSgemmBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemmBatched_64 = __library
                .get(b"cublasSgemmBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgemmEx = __library
                .get(b"cublasSgemmEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemmEx_64 = __library
                .get(b"cublasSgemmEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemmGroupedBatched = __library
                .get(b"cublasSgemmGroupedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemmGroupedBatched_64 = __library
                .get(b"cublasSgemmGroupedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgemmStridedBatched = __library
                .get(b"cublasSgemmStridedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemmStridedBatched_64 = __library
                .get(b"cublasSgemmStridedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgemm_v2 = __library
                .get(b"cublasSgemm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemm_v2_64 = __library
                .get(b"cublasSgemm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-11060",
                feature = "cuda-11070",
                feature = "cuda-11080",
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemvBatched = __library
                .get(b"cublasSgemvBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemvBatched_64 = __library
                .get(b"cublasSgemvBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-11060",
                feature = "cuda-11070",
                feature = "cuda-11080",
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemvStridedBatched = __library
                .get(b"cublasSgemvStridedBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemvStridedBatched_64 = __library
                .get(b"cublasSgemvStridedBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgemv_v2 = __library
                .get(b"cublasSgemv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSgemv_v2_64 = __library
                .get(b"cublasSgemv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgeqrfBatched = __library
                .get(b"cublasSgeqrfBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSger_v2 = __library
                .get(b"cublasSger_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSger_v2_64 = __library
                .get(b"cublasSger_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgetrfBatched = __library
                .get(b"cublasSgetrfBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgetriBatched = __library
                .get(b"cublasSgetriBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSgetrsBatched = __library
                .get(b"cublasSgetrsBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSmatinvBatched = __library
                .get(b"cublasSmatinvBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSnrm2_v2 = __library
                .get(b"cublasSnrm2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSnrm2_v2_64 = __library
                .get(b"cublasSnrm2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSrot_v2 = __library
                .get(b"cublasSrot_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSrot_v2_64 = __library
                .get(b"cublasSrot_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSrotg_v2 = __library
                .get(b"cublasSrotg_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSrotm_v2 = __library
                .get(b"cublasSrotm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSrotm_v2_64 = __library
                .get(b"cublasSrotm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSrotmg_v2 = __library
                .get(b"cublasSrotmg_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSsbmv_v2 = __library
                .get(b"cublasSsbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSsbmv_v2_64 = __library
                .get(b"cublasSsbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSscal_v2 = __library
                .get(b"cublasSscal_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSscal_v2_64 = __library
                .get(b"cublasSscal_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSspmv_v2 = __library
                .get(b"cublasSspmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSspmv_v2_64 = __library
                .get(b"cublasSspmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSspr2_v2 = __library
                .get(b"cublasSspr2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSspr2_v2_64 = __library
                .get(b"cublasSspr2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSspr_v2 = __library
                .get(b"cublasSspr_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSspr_v2_64 = __library
                .get(b"cublasSspr_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSswap_v2 = __library
                .get(b"cublasSswap_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSswap_v2_64 = __library
                .get(b"cublasSswap_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSsymm_v2 = __library
                .get(b"cublasSsymm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSsymm_v2_64 = __library
                .get(b"cublasSsymm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSsymv_v2 = __library
                .get(b"cublasSsymv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSsymv_v2_64 = __library
                .get(b"cublasSsymv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSsyr2_v2 = __library
                .get(b"cublasSsyr2_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSsyr2_v2_64 = __library
                .get(b"cublasSsyr2_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSsyr2k_v2 = __library
                .get(b"cublasSsyr2k_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSsyr2k_v2_64 = __library
                .get(b"cublasSsyr2k_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSsyr_v2 = __library
                .get(b"cublasSsyr_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSsyr_v2_64 = __library
                .get(b"cublasSsyr_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSsyrk_v2 = __library
                .get(b"cublasSsyrk_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSsyrk_v2_64 = __library
                .get(b"cublasSsyrk_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSsyrkx = __library
                .get(b"cublasSsyrkx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSsyrkx_64 = __library
                .get(b"cublasSsyrkx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStbmv_v2 = __library
                .get(b"cublasStbmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStbmv_v2_64 = __library
                .get(b"cublasStbmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStbsv_v2 = __library
                .get(b"cublasStbsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStbsv_v2_64 = __library
                .get(b"cublasStbsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStpmv_v2 = __library
                .get(b"cublasStpmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStpmv_v2_64 = __library
                .get(b"cublasStpmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStpsv_v2 = __library
                .get(b"cublasStpsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStpsv_v2_64 = __library
                .get(b"cublasStpsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStpttr = __library
                .get(b"cublasStpttr\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStrmm_v2 = __library
                .get(b"cublasStrmm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStrmm_v2_64 = __library
                .get(b"cublasStrmm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStrmv_v2 = __library
                .get(b"cublasStrmv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStrmv_v2_64 = __library
                .get(b"cublasStrmv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStrsmBatched = __library
                .get(b"cublasStrsmBatched\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStrsmBatched_64 = __library
                .get(b"cublasStrsmBatched_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStrsm_v2 = __library
                .get(b"cublasStrsm_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStrsm_v2_64 = __library
                .get(b"cublasStrsm_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStrsv_v2 = __library
                .get(b"cublasStrsv_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasStrsv_v2_64 = __library
                .get(b"cublasStrsv_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasStrttp = __library
                .get(b"cublasStrttp\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasSwapEx = __library
                .get(b"cublasSwapEx\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasSwapEx_64 = __library
                .get(b"cublasSwapEx_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasUint8gemmBias = __library
                .get(b"cublasUint8gemmBias\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasXerbla = __library
                .get(b"cublasXerbla\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasZaxpy_v2 = __library
                .get(b"cublasZaxpy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasZaxpy_v2_64 = __library
                .get(b"cublasZaxpy_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasZcopy_v2 = __library
                .get(b"cublasZcopy_v2\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasZcopy_v2_64 = __library
                .get(b"cublasZcopy_v2_64\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            let cublasZdgmm = __library
                .get(b"cublasZdgmm\0")
                .map(|sym| *sym)
                .expect("Expected symbol in library");
            #[cfg(any(
                feature = "cuda-12000",
                feature = "cuda-12010",
                feature = "cuda-12020",
                feature = "cuda-12030",
                feature = "cuda-12040",
                feature = "cuda-12050",
                feature = "cuda-12060",
                feature = "cuda-12080",
                feature = "cuda-12090"
            ))]
            let cublasZdgmm_64 = __library
                .get(b"cublasZdgmm_64\0")
                .map(|sym| *sym)
                .expect("Expect