#!/usr/bin/env python3
# vim: set fileencoding=utf8
#
#   wicd package access helper
#
#   Copyright (C) 2021 Andreas Messer
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License Version 2 as
#   published by the Free Software Foundation.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
from importlib import metadata
import pkgutil
import importlib.resources
import os.path


def get_dist():
    try:
        return metadata.distribution("wicd")
    except metadata.PackageNotFoundError:
        raise ValueError(u'Unable to retrieve current distribution')

    raise ValueError(u'Unable to retrieve current distribution')


def get_version():
    return get_dist().version


def read_resource_file(module, path):
    return pkgutil.get_data(module, path)
