# Installation

This chapter provides a guide on how to install WendzelNNTPd 2.x.

## Linux/*nix/BSD from source

To install WendzelNNTPd from source you can either [download the provided
archive file of a stable version (e.g., *v-2.x.y.tar.gz*)](https://sourceforge.net/projects/wendzelnntpd/files/) and extract it[^1] or you can [clone the current WendzelNNTPd development repository](https://github.com/cdpxe/WendzelNNTPd).
Afterwards, run `./configure`. Please note that configure indicates missing
libraries and packages that you may first need to install using the
package system of your operating system.
```console
# 1. Unpack the content of the tarball (or: use git clone).
$ tar -xzf v2.2.0.tar.gz

# 2. Switch into the unpacked directory (the name of the
#    directory could be different on your system, e.g.,
#    cdpxe-WendzelNNTPd-17d557d.
$ cd wendzelnntpd

# 3. Run the configure script:
$ ./configure
...
```

**Please Note:** *If you wish to compile WITHOUT MySQL or WITHOUT SQLite
support*, then run `./configure --disable-mysql` or `./configure --disable-sqlite`,
respectively.

**Please Note:** *For FreeBSD/OpenBSD/NetBSD/\*BSD: There is no MySQL
support; you need to use SQLite (i.e., run
`./configure --disable-mysql`). Run `configure` as well as `make` in the
`bash` shell (under some BSDs you first need to install `bash`).*

**Please Note:** *If you wish to compile WITHOUT TLS support*, then run
`./configure --disable-tls`.

After `configure` has finished, run `make`:
```console
$ make
...
```

##### Installing WendzelNNTPd

To install WendzelNNTPd on your system, you need superuser access. Run
`make install` to install it to the default location */usr/local/\**.
```console
$ sudo make install
```

**Please Note (Upgrades):** Run `sudo make upgrade` instead of `sudo make install`
for an upgrade. Please cf. Section [Upgrading](upgrade.md#upgrading).

**Please Note (MySQL):** *If you plan to run MySQL*, then no database
was set up during `make install`. Please refer to
Section [Basic Configuration](configuration.md#basic-configuration) to learn how to generate
the MySQL database.

##### Generating SSL certificates

TLS is enabled by default in *wendzelnntpd.conf* as long as WendzelNNTPd has
not been compiled without TLS support. `make install` generates a self-signed
certificate for usage on localhost so that TLS can be used out-of-the-box.

If you want to generate an SSL certificate, which is signed by Let's Encrypt,
or a new self-signed certificate, you can use the helper script `create_certificate`:
```console
$ sudo create_certificate \
    --environment letsencrypt \
    --email <YOUR-EMAIL> \
    --domain <YOUR-DOMAIN>
```
For the parameter `--environment`, "*local*" is also a valid value. In
that case, the certificate is generated only for usage on localhost and
is self-signed. The location of the generated certificates can be adjusted
with the parameter `--targetdir`. You also need to adjust the paths in
*wendzelnntpd.conf* if you use a non-default location
(check Section [Encrypted connections over TLS](configuration.md#encrypted-connections-over-tls)).

### Automatic startup

There is an init script and a systemd service unit in the directory scripts/startup for automatic
startup of `wendzelnntpd`. More information can be found in
[Automating Start, Stop, and Restart](running.md#automating-start-stop-and-restart)

## Docker image for Linux

WendzelNNTPd is available as a [Docker image on Docker Hub](https://hub.docker.com/r/cdpxe/wendzelnntpd).

##### Run WendzelNNTPd in a Docker container

```console
$ docker run --name wendzelnntpd -d -p 119:119 -p 563:563 cdpxe/wendzelnntpd
```

##### Specify volumes for the database and configuration files

```console
$ docker run --name my-wendzelnntpd -d -p 119:119 -p 563:563 \
    -v wendzelnntpd_config:/usr/local/etc/wendzelnntpd \
    -v wendzelnntpd_data:/var/spool/news/wendzelnntpd \
    cdpxe/wendzelnntpd
```

##### Administration with wendzelnntpadm

```console
$ docker run --rm -v wendzelnntpd_config:/usr/local/etc/wendzelnntpd \
    -v wendzelnntpd_data:/var/spool/news/wendzelnntpd \
     cdpxe/wendzelnntpd wendzelnntpadm
```
Find further information regarding the administration of WendzelNNTPd in [Running](running.md#administration-tool-wendzelnntpadm).

##### Create new certificates

```console
$ docker run --rm -v wendzelnntpd_config:/usr/local/etc/wendzelnntpd \
    cdpxe/wendzelnntpd create_certificate
```
Finy further information in [Generating SSL certificates](#generating-ssl-certificates).

##### Get the configuration file

Copy the default configuration file from the image to the host:
```console
$ docker run --rm --entrypoint=cat cdpxe/wendzelnntpd \
    /usr/local/etc/wendzelnntpd/wendzelnntpd.conf \
    > /home/youruser/wendzelnntpd.conf
```

Or copy the current configuration file from your container:
```console
$ docker cp my-wendzelnntpd:/usr/local/etc/wendzelnntpd/wendzelnntpd.conf \
    /home/youruser/wendzelnntpd.conf 
```

##### Edit the configuration file

Find further information regarding the configuration of WendzelNNTPd in [Configuration](configuration.md#basic-configuration).

##### Provide the configuration file to the container

Copy the configuration file back to the container:
```console
$ docker cp /home/youruser/wendzelnntpd.conf \
    my-wendzelnntpd:/usr/local/etc/wendzelnntpd/wendzelnntpd.conf
```

Or bind mount the configuration file (the file needs to be owned by root in this case):
```console
$ sudo chown 0:0 /home/youruser/wendzelnntpd.conf
$ docker run --name wendzelnntpd -d -p 119:119 -p 563:563 \
    -v wendzelnntpd_config:/usr/local/etc/wendzelnntpd \
    -v wendzelnntpd_data:/var/spool/news/wendzelnntpd \
    -v /home/youruser/wendzelnntpd.conf:\
/usr/local/etc/wendzelnntpd/wendzelnntpd.conf:ro \
     -d cdpxe/wendzelnntpd
```

Or build a new image with your configuration file:
```dockerfile
FROM cdpxe/wendzelnntpd
COPY wendzelnntpd.conf /usr/local/etc/wendzelnntpd/wendzelnntpd.conf
```

##### Create the Docker image from source

You can also build the Docker image from source instead of using the pre-built image from Docker Hub.
Therefore, you need to get the source code of WendzelNNTPd like explained in [Linux/*nix/BSD from source](#linuxnixbsd-from-source).
After that you can build the image with `make`:
```console
$ make docker-build
```

## Unofficial Note: Mac OS X

A user reported WendzelNNTPd-2.0.0 is installable under Mac OS X 10.5.8.
The only necessary change was to add the flag `-arch x86_64` to
compile the code on a 64 bit system. However, I never tried to compile
WendzelNNTPd on a Mac.

## Windows

Not supported.

[^1]: On some \*nix-like operating systems you need to first run
    `gzip -d wendzelnntpd-VERSION.tgz` and then 
    `tar -xf wendzelnntpd-VERSION.tar` instead of letting `tar` do the whole
    job as in the listing.
