# Development

For development purposes you can start WendzelNNTPd on your host system.
If you are using an unsupported operating system or just not run
WenzdelNNTPd on your host system, you can use the provided Dockerfiles
to run WendzelNNTPd in a Docker container.

### Initial setup

When you are on a UNIX-based system (like macOS) you can use the
provided make commands:
```console
$ make docker-dev-build
$ make docker-dev-run
```

To stop the Docker container, you can use the following command:
```console
$ make docker-dev-stop
```

If you are not on a UNIX-based system (like Windows) use the following
native docker commands:
```console
$ docker build -f ./docker/Dockerfile -t wendzelnntpd-dev:latest .
$ docker run --name wendzelnntpd-dev --rm -it \
    -p 118:118 -p 119:119 -p 563:563 -p 564:564 \
    -v ${PWD}:/wendzelnntpd \
    -v wendzelnntpd_data:/var/spool/news/wendzelnntpd \
    wendzelnntpd-dev:latest
```

To stop the Docker container you can use the following command:
```console
$ docker stop wendzelnntpd-dev
```

### Test new code

The container is built without code included. The code is automatically
mounted as volume into the container. After each change of source code,
the application is compiled again.

### Edit configure or Makefile

This project uses `autoconf` to generate the *configure* script from
*configure.ac*. The files *configure*, *aclocal.m4*, *config.guess*,
*config.sub* and *install-sh* are autogenerated. Do not edit them
directly, but regenerate them with `autoreconf -fi` after editing
*configure.ac* or a macro in the *m4* directory.

The *Makefile* is generated by the *configure* script from the
*Makefile.in*.
