/*
 * ViSP, open source Visual Servoing Platform software.
 * Copyright (C) 2005 - 2025 by Inria. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file LICENSE.txt at the root directory of this source
 * distribution for additional information about the GNU GPL.
 *
 * For using ViSP with software that can not be combined with the GNU
 * GPL, please contact Inria about acquiring a ViSP Professional
 * Edition License.
 *
 * See https://visp.inria.fr for more information.
 *
 * This software was developed at:
 * Inria Rennes - Bretagne Atlantique
 * Campus Universitaire de Beaulieu
 * 35042 Rennes Cedex
 * France
 *
 * If you have questions regarding the use of this file, please contact
 * Inria at visp@inria.fr
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Description:
 * Colormap class to recolor an image with different grayscale values into
 * some corresponding color values, for better visualization for example.
 */

#include <visp3/core/vpColormap.h>

namespace
{
unsigned char m_autumnSrgbBytes[256][3] = {
    {255, 0, 0},   {255, 1, 0},   {255, 2, 0},   {255, 3, 0},   {255, 4, 0},   {255, 5, 0},   {255, 6, 0},
    {255, 7, 0},   {255, 8, 0},   {255, 9, 0},   {255, 10, 0},  {255, 11, 0},  {255, 12, 0},  {255, 13, 0},
    {255, 14, 0},  {255, 15, 0},  {255, 16, 0},  {255, 17, 0},  {255, 18, 0},  {255, 19, 0},  {255, 20, 0},
    {255, 21, 0},  {255, 22, 0},  {255, 23, 0},  {255, 24, 0},  {255, 25, 0},  {255, 26, 0},  {255, 27, 0},
    {255, 28, 0},  {255, 29, 0},  {255, 30, 0},  {255, 31, 0},  {255, 32, 0},  {255, 32, 0},  {255, 34, 0},
    {255, 35, 0},  {255, 36, 0},  {255, 36, 0},  {255, 38, 0},  {255, 39, 0},  {255, 40, 0},  {255, 40, 0},
    {255, 42, 0},  {255, 43, 0},  {255, 44, 0},  {255, 44, 0},  {255, 46, 0},  {255, 47, 0},  {255, 48, 0},
    {255, 48, 0},  {255, 50, 0},  {255, 51, 0},  {255, 52, 0},  {255, 52, 0},  {255, 54, 0},  {255, 55, 0},
    {255, 56, 0},  {255, 56, 0},  {255, 58, 0},  {255, 59, 0},  {255, 60, 0},  {255, 60, 0},  {255, 62, 0},
    {255, 63, 0},  {255, 64, 0},  {255, 65, 0},  {255, 65, 0},  {255, 67, 0},  {255, 68, 0},  {255, 69, 0},
    {255, 70, 0},  {255, 71, 0},  {255, 72, 0},  {255, 73, 0},  {255, 73, 0},  {255, 75, 0},  {255, 76, 0},
    {255, 77, 0},  {255, 78, 0},  {255, 79, 0},  {255, 80, 0},  {255, 81, 0},  {255, 81, 0},  {255, 83, 0},
    {255, 84, 0},  {255, 85, 0},  {255, 86, 0},  {255, 87, 0},  {255, 88, 0},  {255, 89, 0},  {255, 89, 0},
    {255, 91, 0},  {255, 92, 0},  {255, 93, 0},  {255, 94, 0},  {255, 95, 0},  {255, 96, 0},  {255, 97, 0},
    {255, 97, 0},  {255, 99, 0},  {255, 100, 0}, {255, 101, 0}, {255, 102, 0}, {255, 103, 0}, {255, 104, 0},
    {255, 105, 0}, {255, 105, 0}, {255, 107, 0}, {255, 108, 0}, {255, 109, 0}, {255, 110, 0}, {255, 111, 0},
    {255, 112, 0}, {255, 113, 0}, {255, 113, 0}, {255, 115, 0}, {255, 116, 0}, {255, 117, 0}, {255, 118, 0},
    {255, 119, 0}, {255, 120, 0}, {255, 121, 0}, {255, 121, 0}, {255, 123, 0}, {255, 124, 0}, {255, 125, 0},
    {255, 126, 0}, {255, 127, 0}, {255, 128, 0}, {255, 129, 0}, {255, 130, 0}, {255, 131, 0}, {255, 131, 0},
    {255, 133, 0}, {255, 134, 0}, {255, 135, 0}, {255, 136, 0}, {255, 137, 0}, {255, 138, 0}, {255, 139, 0},
    {255, 140, 0}, {255, 141, 0}, {255, 142, 0}, {255, 143, 0}, {255, 144, 0}, {255, 145, 0}, {255, 146, 0},
    {255, 147, 0}, {255, 147, 0}, {255, 149, 0}, {255, 150, 0}, {255, 151, 0}, {255, 152, 0}, {255, 153, 0},
    {255, 154, 0}, {255, 155, 0}, {255, 156, 0}, {255, 157, 0}, {255, 158, 0}, {255, 159, 0}, {255, 160, 0},
    {255, 161, 0}, {255, 162, 0}, {255, 163, 0}, {255, 163, 0}, {255, 165, 0}, {255, 166, 0}, {255, 167, 0},
    {255, 168, 0}, {255, 169, 0}, {255, 170, 0}, {255, 171, 0}, {255, 172, 0}, {255, 173, 0}, {255, 174, 0},
    {255, 175, 0}, {255, 176, 0}, {255, 177, 0}, {255, 178, 0}, {255, 179, 0}, {255, 179, 0}, {255, 181, 0},
    {255, 182, 0}, {255, 183, 0}, {255, 184, 0}, {255, 185, 0}, {255, 186, 0}, {255, 187, 0}, {255, 188, 0},
    {255, 189, 0}, {255, 190, 0}, {255, 191, 0}, {255, 192, 0}, {255, 193, 0}, {255, 194, 0}, {255, 195, 0},
    {255, 195, 0}, {255, 197, 0}, {255, 198, 0}, {255, 199, 0}, {255, 200, 0}, {255, 201, 0}, {255, 202, 0},
    {255, 203, 0}, {255, 204, 0}, {255, 205, 0}, {255, 206, 0}, {255, 207, 0}, {255, 208, 0}, {255, 209, 0},
    {255, 210, 0}, {255, 211, 0}, {255, 211, 0}, {255, 213, 0}, {255, 214, 0}, {255, 215, 0}, {255, 216, 0},
    {255, 217, 0}, {255, 218, 0}, {255, 219, 0}, {255, 220, 0}, {255, 221, 0}, {255, 222, 0}, {255, 223, 0},
    {255, 224, 0}, {255, 225, 0}, {255, 226, 0}, {255, 227, 0}, {255, 227, 0}, {255, 229, 0}, {255, 230, 0},
    {255, 231, 0}, {255, 232, 0}, {255, 233, 0}, {255, 234, 0}, {255, 235, 0}, {255, 236, 0}, {255, 237, 0},
    {255, 238, 0}, {255, 239, 0}, {255, 240, 0}, {255, 241, 0}, {255, 242, 0}, {255, 243, 0}, {255, 243, 0},
    {255, 245, 0}, {255, 246, 0}, {255, 247, 0}, {255, 248, 0}, {255, 249, 0}, {255, 250, 0}, {255, 251, 0},
    {255, 252, 0}, {255, 253, 0}, {255, 254, 0}, {255, 255, 0}
};

unsigned char m_cividisSrgbBytes[256][3] = {
        {0, 34, 77},     {0, 35, 79},     {0, 35, 80},     {0, 36, 82},     {0, 37, 84},     {0, 38, 85},
        {0, 38, 87},     {0, 39, 89},     {0, 40, 91},     {0, 40, 92},     {0, 41, 94},     {0, 42, 96},
        {0, 42, 98},     {0, 43, 100},    {0, 44, 102},    {0, 44, 103},    {0, 45, 105},    {0, 46, 107},
        {0, 47, 109},    {0, 47, 111},    {0, 48, 112},    {0, 48, 112},    {0, 49, 112},    {0, 49, 112},
        {4, 50, 112},    {8, 51, 112},    {11, 51, 112},   {14, 52, 112},   {17, 53, 111},   {20, 54, 111},
        {22, 54, 111},   {24, 55, 111},   {26, 56, 111},   {28, 56, 110},   {29, 57, 110},   {31, 58, 110},
        {33, 59, 110},   {34, 59, 110},   {36, 60, 110},   {37, 61, 109},   {39, 61, 109},   {40, 62, 109},
        {42, 63, 109},   {43, 63, 109},   {44, 64, 109},   {46, 65, 108},   {47, 66, 108},   {48, 66, 108},
        {49, 67, 108},   {50, 68, 108},   {52, 68, 108},   {53, 69, 108},   {54, 70, 108},   {55, 70, 108},
        {56, 71, 108},   {57, 72, 108},   {58, 72, 107},   {59, 73, 107},   {61, 74, 107},   {62, 75, 107},
        {63, 75, 107},   {64, 76, 107},   {65, 77, 107},   {66, 77, 107},   {67, 78, 107},   {68, 79, 107},
        {69, 79, 107},   {70, 80, 107},   {71, 81, 107},   {72, 81, 107},   {73, 82, 107},   {74, 83, 107},
        {75, 84, 108},   {76, 84, 108},   {77, 85, 108},   {78, 86, 108},   {78, 86, 108},   {79, 87, 108},
        {80, 88, 108},   {81, 88, 108},   {82, 89, 108},   {83, 90, 108},   {84, 90, 108},   {85, 91, 109},
        {86, 92, 109},   {87, 93, 109},   {88, 93, 109},   {89, 94, 109},   {89, 95, 109},   {90, 95, 109},
        {91, 96, 110},   {92, 97, 110},   {93, 97, 110},   {94, 98, 110},   {95, 99, 110},   {96, 100, 110},
        {97, 100, 111},  {97, 101, 111},  {98, 102, 111},  {99, 102, 111},  {100, 103, 111}, {101, 104, 112},
        {102, 105, 112}, {103, 105, 112}, {104, 106, 112}, {104, 107, 113}, {105, 107, 113}, {106, 108, 113},
        {107, 109, 113}, {108, 109, 114}, {109, 110, 114}, {110, 111, 114}, {110, 112, 115}, {111, 112, 115},
        {112, 113, 115}, {113, 114, 115}, {114, 115, 116}, {115, 115, 116}, {116, 116, 117}, {116, 117, 117},
        {117, 117, 117}, {118, 118, 118}, {119, 119, 118}, {120, 120, 118}, {121, 120, 119}, {121, 121, 119},
        {122, 122, 119}, {123, 123, 119}, {124, 123, 120}, {125, 124, 120}, {126, 125, 120}, {127, 125, 120},
        {128, 126, 120}, {129, 127, 120}, {130, 128, 120}, {131, 128, 120}, {132, 129, 120}, {133, 130, 120},
        {133, 131, 120}, {134, 131, 120}, {135, 132, 120}, {136, 133, 120}, {137, 134, 120}, {138, 134, 120},
        {139, 135, 120}, {140, 136, 120}, {141, 137, 120}, {142, 137, 120}, {143, 138, 119}, {144, 139, 119},
        {145, 140, 119}, {146, 140, 119}, {147, 141, 119}, {148, 142, 119}, {149, 143, 119}, {150, 143, 119},
        {151, 144, 118}, {152, 145, 118}, {153, 146, 118}, {154, 147, 118}, {155, 147, 118}, {156, 148, 118},
        {157, 149, 117}, {158, 150, 117}, {159, 150, 117}, {160, 151, 117}, {161, 152, 116}, {162, 153, 116},
        {163, 154, 116}, {164, 154, 116}, {165, 155, 115}, {166, 156, 115}, {167, 157, 115}, {168, 158, 115},
        {169, 158, 114}, {170, 159, 114}, {171, 160, 114}, {172, 161, 113}, {173, 162, 113}, {174, 162, 113},
        {175, 163, 112}, {176, 164, 112}, {177, 165, 112}, {178, 166, 111}, {179, 166, 111}, {180, 167, 111},
        {181, 168, 110}, {182, 169, 110}, {183, 170, 109}, {184, 171, 109}, {185, 171, 109}, {186, 172, 108},
        {187, 173, 108}, {188, 174, 107}, {189, 175, 107}, {190, 176, 106}, {191, 176, 106}, {193, 177, 105},
        {194, 178, 105}, {195, 179, 104}, {196, 180, 104}, {197, 181, 103}, {198, 181, 103}, {199, 182, 102},
        {200, 183, 101}, {201, 184, 101}, {202, 185, 100}, {203, 186, 100}, {204, 187, 99},  {205, 188, 98},
        {206, 188, 98},  {207, 189, 97},  {208, 190, 96},  {210, 191, 96},  {211, 192, 95},  {212, 193, 94},
        {213, 194, 94},  {214, 195, 93},  {215, 195, 92},  {216, 196, 91},  {217, 197, 90},  {218, 198, 90},
        {219, 199, 89},  {220, 200, 88},  {222, 201, 87},  {223, 202, 86},  {224, 203, 85},  {225, 204, 84},
        {226, 204, 83},  {227, 205, 82},  {228, 206, 81},  {229, 207, 80},  {230, 208, 79},  {232, 209, 78},
        {233, 210, 77},  {234, 211, 76},  {235, 212, 75},  {236, 213, 74},  {237, 214, 72},  {238, 215, 71},
        {239, 216, 70},  {241, 217, 68},  {242, 218, 67},  {243, 218, 66},  {244, 219, 64},  {245, 220, 63},
        {246, 221, 61},  {248, 222, 59},  {249, 223, 58},  {250, 224, 56},  {251, 225, 54},  {253, 226, 52},
        {253, 227, 51},  {253, 229, 52},  {253, 230, 54},  {253, 231, 55}
};

unsigned char m_coolSrgbBytes[256][3] = {
    {0, 255, 255},   {1, 254, 255},   {2, 253, 255},   {3, 252, 255},   {4, 251, 255},   {5, 250, 255},
    {6, 249, 255},   {7, 248, 255},   {8, 247, 255},   {9, 246, 255},   {10, 245, 255},  {11, 244, 255},
    {12, 243, 255},  {13, 242, 255},  {14, 241, 255},  {15, 240, 255},  {16, 239, 255},  {17, 238, 255},
    {18, 237, 255},  {19, 236, 255},  {20, 235, 255},  {21, 234, 255},  {22, 233, 255},  {23, 232, 255},
    {24, 231, 255},  {25, 230, 255},  {26, 229, 255},  {27, 228, 255},  {28, 227, 255},  {29, 226, 255},
    {30, 225, 255},  {31, 224, 255},  {32, 223, 255},  {32, 222, 255},  {34, 221, 255},  {35, 220, 255},
    {36, 219, 255},  {36, 218, 255},  {38, 217, 255},  {39, 216, 255},  {40, 215, 255},  {40, 214, 255},
    {42, 213, 255},  {43, 211, 255},  {44, 211, 255},  {44, 210, 255},  {46, 209, 255},  {47, 208, 255},
    {48, 207, 255},  {48, 206, 255},  {50, 205, 255},  {51, 204, 255},  {52, 203, 255},  {52, 202, 255},
    {54, 201, 255},  {55, 200, 255},  {56, 199, 255},  {56, 198, 255},  {58, 197, 255},  {59, 195, 255},
    {60, 195, 255},  {60, 194, 255},  {62, 193, 255},  {63, 192, 255},  {64, 191, 255},  {65, 190, 255},
    {65, 189, 255},  {67, 188, 255},  {68, 187, 255},  {69, 186, 255},  {70, 185, 255},  {71, 184, 255},
    {72, 183, 255},  {73, 182, 255},  {73, 181, 255},  {75, 179, 255},  {76, 179, 255},  {77, 178, 255},
    {78, 177, 255},  {79, 176, 255},  {80, 175, 255},  {81, 174, 255},  {81, 173, 255},  {83, 172, 255},
    {84, 171, 255},  {85, 170, 255},  {86, 169, 255},  {87, 168, 255},  {88, 167, 255},  {89, 166, 255},
    {89, 165, 255},  {91, 163, 255},  {92, 163, 255},  {93, 162, 255},  {94, 161, 255},  {95, 160, 255},
    {96, 159, 255},  {97, 158, 255},  {97, 157, 255},  {99, 156, 255},  {100, 155, 255}, {101, 154, 255},
    {102, 153, 255}, {103, 152, 255}, {104, 151, 255}, {105, 150, 255}, {105, 149, 255}, {107, 147, 255},
    {108, 147, 255}, {109, 146, 255}, {110, 145, 255}, {111, 144, 255}, {112, 143, 255}, {113, 142, 255},
    {113, 141, 255}, {115, 140, 255}, {116, 139, 255}, {117, 138, 255}, {118, 137, 255}, {119, 136, 255},
    {120, 135, 255}, {121, 134, 255}, {121, 133, 255}, {123, 131, 255}, {124, 131, 255}, {125, 130, 255},
    {126, 129, 255}, {127, 128, 255}, {128, 127, 255}, {129, 126, 255}, {130, 125, 255}, {131, 124, 255},
    {131, 123, 255}, {133, 121, 255}, {134, 121, 255}, {135, 120, 255}, {136, 119, 255}, {137, 118, 255},
    {138, 117, 255}, {139, 116, 255}, {140, 114, 255}, {141, 113, 255}, {142, 113, 255}, {143, 112, 255},
    {144, 111, 255}, {145, 110, 255}, {146, 109, 255}, {147, 108, 255}, {147, 107, 255}, {149, 105, 255},
    {150, 105, 255}, {151, 104, 255}, {152, 103, 255}, {153, 102, 255}, {154, 101, 255}, {155, 100, 255},
    {156, 98, 255},  {157, 97, 255},  {158, 97, 255},  {159, 96, 255},  {160, 95, 255},  {161, 94, 255},
    {162, 93, 255},  {163, 92, 255},  {163, 91, 255},  {165, 89, 255},  {166, 89, 255},  {167, 88, 255},
    {168, 87, 255},  {169, 86, 255},  {170, 85, 255},  {171, 84, 255},  {172, 82, 255},  {173, 81, 255},
    {174, 81, 255},  {175, 80, 255},  {176, 79, 255},  {177, 78, 255},  {178, 77, 255},  {179, 76, 255},
    {179, 75, 255},  {181, 73, 255},  {182, 73, 255},  {183, 72, 255},  {184, 71, 255},  {185, 70, 255},
    {186, 69, 255},  {187, 68, 255},  {188, 66, 255},  {189, 65, 255},  {190, 65, 255},  {191, 64, 255},
    {192, 63, 255},  {193, 62, 255},  {194, 61, 255},  {195, 60, 255},  {195, 59, 255},  {197, 57, 255},
    {198, 56, 255},  {199, 56, 255},  {200, 55, 255},  {201, 54, 255},  {202, 53, 255},  {203, 52, 255},
    {204, 50, 255},  {205, 49, 255},  {206, 48, 255},  {207, 48, 255},  {208, 47, 255},  {209, 46, 255},
    {210, 45, 255},  {211, 44, 255},  {211, 43, 255},  {213, 41, 255},  {214, 40, 255},  {215, 40, 255},
    {216, 39, 255},  {217, 38, 255},  {218, 37, 255},  {219, 36, 255},  {220, 34, 255},  {221, 33, 255},
    {222, 32, 255},  {223, 32, 255},  {224, 31, 255},  {225, 30, 255},  {226, 29, 255},  {227, 28, 255},
    {227, 27, 255},  {229, 25, 255},  {230, 24, 255},  {231, 24, 255},  {232, 23, 255},  {233, 22, 255},
    {234, 21, 255},  {235, 20, 255},  {236, 18, 255},  {237, 17, 255},  {238, 16, 255},  {239, 16, 255},
    {240, 15, 255},  {241, 14, 255},  {242, 13, 255},  {243, 12, 255},  {243, 11, 255},  {245, 9, 255},
    {246, 8, 255},   {247, 8, 255},   {248, 7, 255},   {249, 6, 255},   {250, 5, 255},   {251, 4, 255},
    {252, 2, 255},   {253, 1, 255},   {254, 0, 255},   {255, 0, 255}
};

unsigned char m_gistEarthSrgbBytes[256][3] = {
    {0, 0, 0},       {0, 0, 43},      {1, 0, 56},      {1, 0, 67},      {2, 0, 78},      {3, 0, 88},
    {3, 0, 99},      {4, 0, 110},     {5, 2, 115},     {5, 4, 116},     {6, 6, 116},     {7, 9, 116},
    {7, 11, 116},    {8, 13, 116},    {9, 16, 117},    {9, 18, 117},    {10, 20, 117},   {11, 22, 117},
    {11, 25, 117},   {12, 27, 117},   {13, 29, 118},   {13, 32, 118},   {14, 34, 118},   {15, 36, 118},
    {15, 39, 118},   {16, 41, 119},   {17, 43, 119},   {17, 45, 119},   {18, 48, 119},   {19, 50, 119},
    {19, 52, 119},   {20, 54, 120},   {21, 56, 120},   {21, 58, 120},   {22, 60, 120},   {23, 62, 120},
    {23, 64, 121},   {24, 66, 121},   {25, 69, 121},   {25, 71, 121},   {26, 73, 121},   {27, 75, 121},
    {27, 77, 122},   {28, 79, 122},   {29, 81, 122},   {29, 83, 122},   {30, 84, 122},   {31, 86, 123},
    {31, 88, 123},   {32, 90, 123},   {33, 92, 123},   {33, 94, 123},   {34, 96, 123},   {35, 97, 124},
    {35, 99, 124},   {36, 101, 124},  {37, 102, 124},  {37, 104, 124},  {38, 105, 125},  {39, 107, 125},
    {39, 109, 125},  {40, 110, 125},  {41, 112, 125},  {41, 113, 125},  {42, 115, 126},  {43, 116, 126},
    {43, 118, 126},  {44, 120, 126},  {45, 121, 126},  {45, 123, 127},  {46, 124, 127},  {47, 126, 127},
    {47, 127, 127},  {48, 128, 126},  {48, 129, 125},  {49, 129, 123},  {49, 130, 122},  {50, 130, 121},
    {50, 131, 120},  {51, 132, 119},  {51, 132, 117},  {52, 133, 116},  {52, 133, 115},  {53, 134, 114},
    {53, 134, 112},  {54, 135, 111},  {54, 136, 110},  {55, 136, 109},  {55, 137, 108},  {56, 137, 106},
    {56, 138, 105},  {56, 138, 104},  {57, 139, 103},  {57, 140, 101},  {58, 140, 100},  {58, 141, 99},
    {59, 141, 98},   {59, 142, 97},   {60, 142, 95},   {60, 143, 94},   {61, 144, 93},   {61, 144, 92},
    {62, 145, 90},   {62, 145, 89},   {63, 146, 88},   {63, 147, 87},   {64, 147, 85},   {64, 148, 84},
    {64, 148, 83},   {65, 149, 82},   {65, 149, 81},   {66, 150, 79},   {66, 151, 78},   {67, 151, 77},
    {67, 152, 76},   {68, 152, 74},   {68, 153, 73},   {69, 153, 72},   {71, 154, 71},   {73, 155, 70},
    {75, 155, 70},   {78, 156, 71},   {80, 156, 71},   {82, 157, 72},   {84, 157, 72},   {87, 158, 73},
    {89, 159, 74},   {91, 159, 74},   {93, 160, 75},   {95, 160, 75},   {98, 161, 76},   {100, 161, 77},
    {102, 162, 77},  {104, 163, 78},  {107, 163, 78},  {109, 163, 79},  {111, 164, 79},  {113, 164, 80},
    {115, 165, 81},  {118, 165, 81},  {120, 166, 82},  {121, 166, 82},  {123, 167, 82},  {125, 167, 82},
    {126, 167, 83},  {128, 168, 83},  {130, 168, 83},  {131, 169, 84},  {133, 169, 84},  {135, 170, 84},
    {136, 170, 85},  {138, 171, 85},  {140, 171, 85},  {141, 171, 86},  {143, 172, 86},  {145, 172, 86},
    {146, 173, 87},  {148, 173, 87},  {150, 174, 87},  {151, 174, 88},  {153, 174, 88},  {154, 175, 88},
    {156, 175, 88},  {158, 176, 89},  {159, 176, 89},  {161, 177, 89},  {163, 177, 90},  {164, 178, 90},
    {166, 178, 90},  {168, 178, 91},  {169, 179, 91},  {171, 179, 91},  {173, 180, 92},  {174, 180, 92},
    {176, 181, 92},  {178, 181, 93},  {179, 181, 93},  {181, 182, 93},  {182, 182, 94},  {183, 181, 94},
    {183, 181, 94},  {184, 180, 95},  {184, 179, 95},  {185, 178, 95},  {185, 177, 95},  {185, 176, 96},
    {186, 175, 96},  {186, 175, 96},  {187, 174, 97},  {187, 173, 97},  {188, 172, 97},  {188, 171, 98},
    {188, 170, 98},  {189, 169, 98},  {189, 169, 99},  {190, 168, 99},  {190, 167, 99},  {190, 166, 100},
    {191, 165, 100}, {191, 164, 100}, {192, 163, 101}, {192, 163, 103}, {193, 163, 105}, {194, 163, 108},
    {195, 164, 110}, {197, 164, 113}, {198, 165, 115}, {199, 166, 118}, {200, 166, 120}, {201, 167, 123},
    {202, 168, 125}, {203, 169, 127}, {204, 170, 130}, {206, 171, 132}, {207, 172, 135}, {208, 173, 137},
    {209, 173, 140}, {210, 174, 142}, {211, 175, 145}, {212, 176, 147}, {213, 177, 150}, {214, 178, 152},
    {216, 179, 154}, {217, 181, 157}, {218, 182, 159}, {219, 183, 162}, {220, 185, 164}, {221, 186, 167},
    {222, 188, 169}, {223, 189, 172}, {225, 191, 175}, {226, 193, 178}, {227, 195, 181}, {228, 197, 184},
    {229, 199, 187}, {230, 201, 190}, {231, 203, 193}, {232, 205, 196}, {233, 207, 199}, {235, 209, 202},
    {236, 211, 205}, {237, 213, 208}, {238, 215, 211}, {239, 217, 214}, {240, 220, 217}, {241, 222, 220},
    {242, 224, 223}, {244, 227, 226}, {245, 230, 229}, {246, 233, 232}, {247, 236, 235}, {248, 239, 238},
    {249, 242, 241}, {250, 245, 244}, {251, 248, 247}, {253, 250, 250}
};

unsigned char m_gnuplotSrgbBytes[256][3] = {
    {0, 0, 0},      {15, 0, 6},     {22, 0, 12},    {27, 0, 18},    {31, 0, 25},    {35, 0, 31},    {39, 0, 37},
    {42, 0, 43},    {45, 0, 49},    {47, 0, 56},    {50, 0, 62},    {52, 0, 68},    {55, 0, 74},    {57, 0, 80},
    {59, 0, 86},    {61, 0, 92},    {63, 0, 97},    {65, 0, 103},   {67, 0, 109},   {69, 0, 115},   {71, 0, 120},
    {73, 0, 126},   {74, 0, 131},   {76, 0, 136},   {78, 0, 142},   {79, 0, 147},   {81, 0, 152},   {82, 0, 157},
    {84, 0, 162},   {85, 0, 167},   {87, 0, 171},   {88, 0, 176},   {90, 0, 180},   {91, 0, 185},   {93, 0, 189},
    {94, 0, 193},   {95, 0, 197},   {97, 0, 201},   {98, 0, 205},   {99, 0, 209},   {100, 0, 212},  {102, 1, 215},
    {103, 1, 219},  {104, 1, 222},  {105, 1, 225},  {107, 1, 228},  {108, 1, 230},  {109, 1, 233},  {110, 1, 236},
    {111, 1, 238},  {112, 1, 240},  {114, 2, 242},  {115, 2, 244},  {116, 2, 246},  {117, 2, 247},  {118, 2, 249},
    {119, 2, 250},  {120, 2, 251},  {121, 3, 252},  {122, 3, 253},  {123, 3, 253},  {124, 3, 254},  {125, 3, 254},
    {126, 3, 254},  {127, 4, 254},  {128, 4, 254},  {129, 4, 254},  {130, 4, 254},  {131, 4, 253},  {132, 5, 252},
    {133, 5, 251},  {134, 5, 250},  {135, 5, 249},  {136, 5, 248},  {137, 6, 246},  {138, 6, 245},  {139, 6, 243},
    {140, 7, 241},  {141, 7, 239},  {141, 7, 237},  {142, 7, 234},  {143, 8, 232},  {144, 8, 229},  {145, 8, 226},
    {146, 9, 223},  {147, 9, 220},  {148, 9, 217},  {148, 10, 214}, {149, 10, 210}, {150, 10, 207}, {151, 11, 203},
    {152, 11, 199}, {153, 11, 195}, {153, 12, 191}, {154, 12, 187}, {155, 13, 183}, {156, 13, 178}, {157, 14, 174},
    {158, 14, 169}, {158, 14, 164}, {159, 15, 159}, {160, 15, 154}, {161, 16, 149}, {162, 16, 144}, {162, 17, 139},
    {163, 17, 134}, {164, 18, 128}, {165, 18, 123}, {165, 19, 117}, {166, 19, 112}, {167, 20, 106}, {168, 21, 100},
    {168, 21, 95},  {169, 22, 89},  {170, 22, 83},  {171, 23, 77},  {171, 24, 71},  {172, 24, 65},  {173, 25, 59},
    {174, 25, 53},  {174, 26, 46},  {175, 27, 40},  {176, 27, 34},  {177, 28, 28},  {177, 29, 21},  {178, 30, 15},
    {179, 30, 9},   {179, 31, 3},   {180, 32, 0},   {181, 33, 0},   {182, 33, 0},   {182, 34, 0},   {183, 35, 0},
    {184, 36, 0},   {184, 37, 0},   {185, 37, 0},   {186, 38, 0},   {186, 39, 0},   {187, 40, 0},   {188, 41, 0},
    {188, 42, 0},   {189, 43, 0},   {190, 44, 0},   {190, 44, 0},   {191, 45, 0},   {192, 46, 0},   {192, 47, 0},
    {193, 48, 0},   {194, 49, 0},   {194, 50, 0},   {195, 51, 0},   {196, 52, 0},   {196, 54, 0},   {197, 55, 0},
    {198, 56, 0},   {198, 57, 0},   {199, 58, 0},   {200, 59, 0},   {200, 60, 0},   {201, 61, 0},   {201, 62, 0},
    {202, 64, 0},   {203, 65, 0},   {203, 66, 0},   {204, 67, 0},   {205, 69, 0},   {205, 70, 0},   {206, 71, 0},
    {206, 72, 0},   {207, 74, 0},   {208, 75, 0},   {208, 76, 0},   {209, 78, 0},   {210, 79, 0},   {210, 81, 0},
    {211, 82, 0},   {211, 83, 0},   {212, 85, 0},   {213, 86, 0},   {213, 88, 0},   {214, 89, 0},   {214, 91, 0},
    {215, 92, 0},   {216, 94, 0},   {216, 95, 0},   {217, 97, 0},   {217, 98, 0},   {218, 100, 0},  {218, 102, 0},
    {219, 103, 0},  {220, 105, 0},  {220, 107, 0},  {221, 108, 0},  {221, 110, 0},  {222, 112, 0},  {222, 114, 0},
    {223, 115, 0},  {224, 117, 0},  {224, 119, 0},  {225, 121, 0},  {225, 123, 0},  {226, 124, 0},  {226, 126, 0},
    {227, 128, 0},  {228, 130, 0},  {228, 132, 0},  {229, 134, 0},  {229, 136, 0},  {230, 138, 0},  {230, 140, 0},
    {231, 142, 0},  {231, 144, 0},  {232, 146, 0},  {233, 148, 0},  {233, 150, 0},  {234, 152, 0},  {234, 154, 0},
    {235, 157, 0},  {235, 159, 0},  {236, 161, 0},  {236, 163, 0},  {237, 165, 0},  {237, 168, 0},  {238, 170, 0},
    {238, 172, 0},  {239, 175, 0},  {240, 177, 0},  {240, 179, 0},  {241, 182, 0},  {241, 184, 0},  {242, 187, 0},
    {242, 189, 0},  {243, 192, 0},  {243, 194, 0},  {244, 197, 0},  {244, 199, 0},  {245, 202, 0},  {245, 204, 0},
    {246, 207, 0},  {246, 209, 0},  {247, 212, 0},  {247, 215, 0},  {248, 217, 0},  {248, 220, 0},  {249, 223, 0},
    {249, 226, 0},  {250, 228, 0},  {250, 231, 0},  {251, 234, 0},  {251, 237, 0},  {252, 240, 0},  {252, 243, 0},
    {253, 246, 0},  {253, 249, 0},  {254, 252, 0},  {255, 255, 0}
};

unsigned char m_gnuplot2SrgbBytes[256][3] = {
    {0, 0, 0},       {0, 0, 4},       {0, 0, 8},       {0, 0, 12},      {0, 0, 16},      {0, 0, 20},
    {0, 0, 24},      {0, 0, 28},      {0, 0, 32},      {0, 0, 36},      {0, 0, 40},      {0, 0, 44},
    {0, 0, 48},      {0, 0, 52},      {0, 0, 56},      {0, 0, 60},      {0, 0, 64},      {0, 0, 68},
    {0, 0, 72},      {0, 0, 76},      {0, 0, 80},      {0, 0, 84},      {0, 0, 88},      {0, 0, 92},
    {0, 0, 96},      {0, 0, 100},     {0, 0, 104},     {0, 0, 108},     {0, 0, 112},     {0, 0, 116},
    {0, 0, 120},     {0, 0, 124},     {0, 0, 128},     {0, 0, 131},     {0, 0, 136},     {0, 0, 140},
    {0, 0, 144},     {0, 0, 147},     {0, 0, 152},     {0, 0, 156},     {0, 0, 160},     {0, 0, 163},
    {0, 0, 168},     {0, 0, 172},     {0, 0, 176},     {0, 0, 179},     {0, 0, 184},     {0, 0, 188},
    {0, 0, 192},     {0, 0, 195},     {0, 0, 200},     {0, 0, 204},     {0, 0, 208},     {0, 0, 211},
    {0, 0, 216},     {0, 0, 220},     {0, 0, 224},     {0, 0, 227},     {0, 0, 232},     {0, 0, 236},
    {0, 0, 240},     {0, 0, 243},     {0, 0, 248},     {0, 0, 252},     {0, 0, 255},     {3, 0, 255},
    {7, 0, 255},     {10, 0, 255},    {13, 0, 255},    {16, 0, 255},    {19, 0, 255},    {22, 0, 255},
    {25, 0, 255},    {28, 0, 255},    {32, 0, 255},    {35, 0, 255},    {38, 0, 255},    {41, 0, 255},
    {44, 0, 255},    {47, 0, 255},    {50, 0, 255},    {53, 0, 255},    {57, 0, 255},    {60, 0, 255},
    {63, 0, 255},    {66, 0, 255},    {69, 0, 255},    {72, 0, 255},    {75, 0, 255},    {78, 0, 255},
    {82, 0, 255},    {85, 0, 255},    {88, 0, 255},    {91, 0, 255},    {94, 0, 255},    {97, 0, 255},
    {100, 0, 255},   {103, 0, 255},   {107, 0, 255},   {110, 0, 255},   {113, 0, 255},   {116, 0, 255},
    {119, 0, 255},   {122, 0, 255},   {125, 0, 255},   {128, 0, 255},   {132, 0, 255},   {135, 0, 255},
    {138, 1, 253},   {141, 3, 251},   {144, 5, 249},   {147, 7, 247},   {150, 9, 245},   {153, 11, 243},
    {157, 13, 241},  {160, 15, 239},  {163, 17, 237},  {166, 19, 235},  {169, 21, 233},  {172, 23, 231},
    {175, 25, 229},  {178, 27, 227},  {182, 29, 225},  {185, 31, 223},  {188, 33, 221},  {191, 35, 219},
    {194, 37, 217},  {197, 39, 215},  {200, 41, 213},  {203, 43, 211},  {207, 45, 209},  {210, 47, 207},
    {213, 49, 205},  {216, 51, 203},  {219, 53, 201},  {222, 55, 199},  {225, 57, 197},  {228, 59, 195},
    {232, 61, 193},  {235, 63, 191},  {238, 65, 189},  {241, 67, 187},  {244, 69, 185},  {247, 71, 183},
    {250, 73, 181},  {253, 75, 179},  {255, 77, 177},  {255, 79, 175},  {255, 81, 173},  {255, 83, 171},
    {255, 85, 169},  {255, 87, 167},  {255, 89, 165},  {255, 91, 163},  {255, 93, 161},  {255, 95, 159},
    {255, 97, 157},  {255, 99, 155},  {255, 101, 153}, {255, 103, 151}, {255, 105, 149}, {255, 107, 147},
    {255, 109, 145}, {255, 111, 143}, {255, 113, 141}, {255, 115, 139}, {255, 117, 137}, {255, 119, 135},
    {255, 121, 133}, {255, 123, 131}, {255, 125, 129}, {255, 127, 127}, {255, 129, 125}, {255, 131, 123},
    {255, 133, 121}, {255, 135, 119}, {255, 137, 117}, {255, 139, 115}, {255, 141, 113}, {255, 143, 111},
    {255, 145, 109}, {255, 147, 107}, {255, 149, 105}, {255, 151, 103}, {255, 153, 101}, {255, 155, 99},
    {255, 157, 97},  {255, 159, 95},  {255, 161, 93},  {255, 163, 91},  {255, 165, 89},  {255, 167, 87},
    {255, 169, 85},  {255, 171, 83},  {255, 173, 81},  {255, 175, 79},  {255, 177, 77},  {255, 179, 75},
    {255, 181, 73},  {255, 183, 71},  {255, 185, 69},  {255, 187, 67},  {255, 189, 65},  {255, 191, 63},
    {255, 193, 61},  {255, 195, 59},  {255, 197, 57},  {255, 199, 55},  {255, 201, 53},  {255, 203, 51},
    {255, 205, 49},  {255, 207, 47},  {255, 209, 45},  {255, 211, 43},  {255, 213, 41},  {255, 215, 39},
    {255, 217, 37},  {255, 219, 35},  {255, 221, 33},  {255, 223, 31},  {255, 225, 29},  {255, 227, 27},
    {255, 229, 25},  {255, 231, 23},  {255, 233, 21},  {255, 235, 19},  {255, 237, 17},  {255, 239, 15},
    {255, 241, 13},  {255, 243, 11},  {255, 245, 9},   {255, 247, 7},   {255, 249, 5},   {255, 251, 3},
    {255, 253, 1},   {255, 255, 4},   {255, 255, 17},  {255, 255, 29},  {255, 255, 42},  {255, 255, 54},
    {255, 255, 67},  {255, 255, 79},  {255, 255, 92},  {255, 255, 104}, {255, 255, 117}, {255, 255, 130},
    {255, 255, 142}, {255, 255, 154}, {255, 255, 167}, {255, 255, 179}, {255, 255, 192}, {255, 255, 204},
    {255, 255, 217}, {255, 255, 230}, {255, 255, 242}, {255, 255, 255}
};

unsigned char m_hotSrgbBytes[256][3] = {
    {10, 0, 0},      {13, 0, 0},      {15, 0, 0},      {18, 0, 0},      {21, 0, 0},      {23, 0, 0},
    {26, 0, 0},      {28, 0, 0},      {31, 0, 0},      {34, 0, 0},      {36, 0, 0},      {39, 0, 0},
    {42, 0, 0},      {44, 0, 0},      {47, 0, 0},      {49, 0, 0},      {52, 0, 0},      {55, 0, 0},
    {57, 0, 0},      {60, 0, 0},      {63, 0, 0},      {65, 0, 0},      {68, 0, 0},      {70, 0, 0},
    {73, 0, 0},      {76, 0, 0},      {78, 0, 0},      {81, 0, 0},      {84, 0, 0},      {86, 0, 0},
    {89, 0, 0},      {91, 0, 0},      {94, 0, 0},      {97, 0, 0},      {99, 0, 0},      {102, 0, 0},
    {105, 0, 0},     {107, 0, 0},     {110, 0, 0},     {112, 0, 0},     {115, 0, 0},     {118, 0, 0},
    {120, 0, 0},     {123, 0, 0},     {126, 0, 0},     {128, 0, 0},     {131, 0, 0},     {133, 0, 0},
    {136, 0, 0},     {139, 0, 0},     {141, 0, 0},     {144, 0, 0},     {147, 0, 0},     {149, 0, 0},
    {152, 0, 0},     {154, 0, 0},     {157, 0, 0},     {160, 0, 0},     {162, 0, 0},     {165, 0, 0},
    {168, 0, 0},     {170, 0, 0},     {173, 0, 0},     {175, 0, 0},     {178, 0, 0},     {181, 0, 0},
    {183, 0, 0},     {186, 0, 0},     {189, 0, 0},     {191, 0, 0},     {194, 0, 0},     {196, 0, 0},
    {199, 0, 0},     {202, 0, 0},     {204, 0, 0},     {207, 0, 0},     {210, 0, 0},     {212, 0, 0},
    {215, 0, 0},     {217, 0, 0},     {220, 0, 0},     {223, 0, 0},     {225, 0, 0},     {228, 0, 0},
    {231, 0, 0},     {233, 0, 0},     {236, 0, 0},     {238, 0, 0},     {241, 0, 0},     {244, 0, 0},
    {246, 0, 0},     {249, 0, 0},     {252, 0, 0},     {254, 0, 0},     {255, 2, 0},     {255, 5, 0},
    {255, 7, 0},     {255, 10, 0},    {255, 12, 0},    {255, 15, 0},    {255, 18, 0},    {255, 20, 0},
    {255, 23, 0},    {255, 26, 0},    {255, 28, 0},    {255, 31, 0},    {255, 33, 0},    {255, 36, 0},
    {255, 39, 0},    {255, 41, 0},    {255, 44, 0},    {255, 47, 0},    {255, 49, 0},    {255, 52, 0},
    {255, 54, 0},    {255, 57, 0},    {255, 60, 0},    {255, 62, 0},    {255, 65, 0},    {255, 68, 0},
    {255, 70, 0},    {255, 73, 0},    {255, 75, 0},    {255, 78, 0},    {255, 81, 0},    {255, 83, 0},
    {255, 86, 0},    {255, 89, 0},    {255, 91, 0},    {255, 94, 0},    {255, 96, 0},    {255, 99, 0},
    {255, 102, 0},   {255, 104, 0},   {255, 107, 0},   {255, 110, 0},   {255, 112, 0},   {255, 115, 0},
    {255, 117, 0},   {255, 120, 0},   {255, 123, 0},   {255, 125, 0},   {255, 128, 0},   {255, 131, 0},
    {255, 133, 0},   {255, 136, 0},   {255, 138, 0},   {255, 141, 0},   {255, 144, 0},   {255, 146, 0},
    {255, 149, 0},   {255, 151, 0},   {255, 154, 0},   {255, 157, 0},   {255, 159, 0},   {255, 162, 0},
    {255, 165, 0},   {255, 167, 0},   {255, 170, 0},   {255, 172, 0},   {255, 175, 0},   {255, 178, 0},
    {255, 180, 0},   {255, 183, 0},   {255, 186, 0},   {255, 188, 0},   {255, 191, 0},   {255, 193, 0},
    {255, 196, 0},   {255, 199, 0},   {255, 201, 0},   {255, 204, 0},   {255, 207, 0},   {255, 209, 0},
    {255, 212, 0},   {255, 214, 0},   {255, 217, 0},   {255, 220, 0},   {255, 222, 0},   {255, 225, 0},
    {255, 228, 0},   {255, 230, 0},   {255, 233, 0},   {255, 235, 0},   {255, 238, 0},   {255, 241, 0},
    {255, 243, 0},   {255, 246, 0},   {255, 249, 0},   {255, 251, 0},   {255, 254, 0},   {255, 255, 2},
    {255, 255, 6},   {255, 255, 10},  {255, 255, 14},  {255, 255, 18},  {255, 255, 22},  {255, 255, 26},
    {255, 255, 30},  {255, 255, 34},  {255, 255, 38},  {255, 255, 42},  {255, 255, 46},  {255, 255, 50},
    {255, 255, 54},  {255, 255, 58},  {255, 255, 62},  {255, 255, 65},  {255, 255, 69},  {255, 255, 73},
    {255, 255, 77},  {255, 255, 81},  {255, 255, 85},  {255, 255, 89},  {255, 255, 93},  {255, 255, 97},
    {255, 255, 101}, {255, 255, 105}, {255, 255, 109}, {255, 255, 113}, {255, 255, 117}, {255, 255, 121},
    {255, 255, 125}, {255, 255, 128}, {255, 255, 132}, {255, 255, 136}, {255, 255, 140}, {255, 255, 144},
    {255, 255, 148}, {255, 255, 152}, {255, 255, 156}, {255, 255, 160}, {255, 255, 164}, {255, 255, 168},
    {255, 255, 172}, {255, 255, 176}, {255, 255, 180}, {255, 255, 184}, {255, 255, 188}, {255, 255, 191},
    {255, 255, 195}, {255, 255, 199}, {255, 255, 203}, {255, 255, 207}, {255, 255, 211}, {255, 255, 215},
    {255, 255, 219}, {255, 255, 223}, {255, 255, 227}, {255, 255, 231}, {255, 255, 235}, {255, 255, 239},
    {255, 255, 243}, {255, 255, 247}, {255, 255, 251}, {255, 255, 255}
};

unsigned char m_hsvSrgbBytes[256][3] = {
    {255, 0, 0},   {255, 5, 0},   {255, 11, 0},  {255, 17, 0},  {255, 23, 0},  {255, 29, 0},  {255, 35, 0},
    {255, 41, 0},  {255, 47, 0},  {255, 53, 0},  {255, 59, 0},  {255, 64, 0},  {255, 70, 0},  {255, 76, 0},
    {255, 82, 0},  {255, 88, 0},  {255, 94, 0},  {255, 100, 0}, {255, 106, 0}, {255, 112, 0}, {255, 118, 0},
    {255, 124, 0}, {255, 129, 0}, {255, 135, 0}, {255, 141, 0}, {255, 147, 0}, {255, 153, 0}, {255, 159, 0},
    {255, 165, 0}, {255, 171, 0}, {255, 177, 0}, {255, 183, 0}, {255, 189, 0}, {255, 194, 0}, {255, 200, 0},
    {255, 206, 0}, {255, 212, 0}, {255, 218, 0}, {255, 224, 0}, {255, 230, 0}, {255, 236, 0}, {253, 241, 0},
    {251, 245, 0}, {250, 249, 0}, {248, 252, 0}, {244, 255, 0}, {238, 255, 0}, {232, 255, 0}, {226, 255, 0},
    {220, 255, 0}, {214, 255, 0}, {208, 255, 0}, {202, 255, 0}, {196, 255, 0}, {191, 255, 0}, {185, 255, 0},
    {179, 255, 0}, {173, 255, 0}, {167, 255, 0}, {161, 255, 0}, {155, 255, 0}, {149, 255, 0}, {143, 255, 0},
    {137, 255, 0}, {131, 255, 0}, {126, 255, 0}, {120, 255, 0}, {114, 255, 0}, {108, 255, 0}, {102, 255, 0},
    {96, 255, 0},  {90, 255, 0},  {84, 255, 0},  {78, 255, 0},  {72, 255, 0},  {67, 255, 0},  {61, 255, 0},
    {55, 255, 0},  {49, 255, 0},  {43, 255, 0},  {37, 255, 0},  {31, 255, 0},  {25, 255, 0},  {19, 255, 0},
    {13, 255, 0},  {7, 255, 0},   {5, 255, 3},   {4, 255, 7},   {2, 255, 11},  {0, 255, 15},  {0, 255, 21},
    {0, 255, 27},  {0, 255, 33},  {0, 255, 39},  {0, 255, 45},  {0, 255, 51},  {0, 255, 57},  {0, 255, 62},
    {0, 255, 68},  {0, 255, 74},  {0, 255, 80},  {0, 255, 86},  {0, 255, 92},  {0, 255, 98},  {0, 255, 104},
    {0, 255, 110}, {0, 255, 116}, {0, 255, 121}, {0, 255, 127}, {0, 255, 133}, {0, 255, 139}, {0, 255, 145},
    {0, 255, 151}, {0, 255, 157}, {0, 255, 163}, {0, 255, 169}, {0, 255, 175}, {0, 255, 181}, {0, 255, 186},
    {0, 255, 192}, {0, 255, 198}, {0, 255, 204}, {0, 255, 210}, {0, 255, 216}, {0, 255, 222}, {0, 255, 228},
    {0, 255, 234}, {0, 255, 240}, {0, 255, 245}, {0, 255, 251}, {0, 252, 255}, {0, 246, 255}, {0, 240, 255},
    {0, 234, 255}, {0, 228, 255}, {0, 222, 255}, {0, 216, 255}, {0, 210, 255}, {0, 204, 255}, {0, 199, 255},
    {0, 193, 255}, {0, 187, 255}, {0, 181, 255}, {0, 175, 255}, {0, 169, 255}, {0, 163, 255}, {0, 157, 255},
    {0, 151, 255}, {0, 145, 255}, {0, 139, 255}, {0, 134, 255}, {0, 128, 255}, {0, 122, 255}, {0, 116, 255},
    {0, 110, 255}, {0, 104, 255}, {0, 98, 255},  {0, 92, 255},  {0, 86, 255},  {0, 80, 255},  {0, 75, 255},
    {0, 69, 255},  {0, 63, 255},  {0, 57, 255},  {0, 51, 255},  {0, 45, 255},  {0, 39, 255},  {0, 33, 255},
    {0, 27, 255},  {0, 21, 255},  {0, 15, 255},  {1, 12, 255},  {3, 8, 255},   {5, 4, 255},   {7, 0, 255},
    {13, 0, 255},  {19, 0, 255},  {25, 0, 255},  {31, 0, 255},  {37, 0, 255},  {43, 0, 255},  {49, 0, 255},
    {54, 0, 255},  {60, 0, 255},  {66, 0, 255},  {72, 0, 255},  {78, 0, 255},  {84, 0, 255},  {90, 0, 255},
    {96, 0, 255},  {102, 0, 255}, {108, 0, 255}, {113, 0, 255}, {119, 0, 255}, {125, 0, 255}, {131, 0, 255},
    {137, 0, 255}, {143, 0, 255}, {149, 0, 255}, {155, 0, 255}, {161, 0, 255}, {167, 0, 255}, {173, 0, 255},
    {178, 0, 255}, {184, 0, 255}, {190, 0, 255}, {196, 0, 255}, {202, 0, 255}, {208, 0, 255}, {214, 0, 255},
    {220, 0, 255}, {226, 0, 255}, {232, 0, 255}, {238, 0, 255}, {243, 0, 255}, {247, 0, 253}, {249, 0, 249},
    {251, 0, 245}, {253, 0, 241}, {255, 0, 236}, {255, 0, 230}, {255, 0, 224}, {255, 0, 218}, {255, 0, 212},
    {255, 0, 207}, {255, 0, 201}, {255, 0, 195}, {255, 0, 189}, {255, 0, 183}, {255, 0, 177}, {255, 0, 171},
    {255, 0, 165}, {255, 0, 159}, {255, 0, 153}, {255, 0, 147}, {255, 0, 142}, {255, 0, 136}, {255, 0, 130},
    {255, 0, 124}, {255, 0, 118}, {255, 0, 112}, {255, 0, 106}, {255, 0, 100}, {255, 0, 94},  {255, 0, 88},
    {255, 0, 82},  {255, 0, 77},  {255, 0, 71},  {255, 0, 65},  {255, 0, 59},  {255, 0, 53},  {255, 0, 47},
    {255, 0, 41},  {255, 0, 35},  {255, 0, 29},  {255, 0, 23}
};

unsigned char m_infernoSrgbBytes[256][3] = {
    {0, 0, 3},       {0, 0, 4},       {0, 0, 6},       {1, 0, 7},       {1, 1, 9},       {1, 1, 11},
    {2, 1, 14},      {2, 2, 16},      {3, 2, 18},      {4, 3, 20},      {4, 3, 22},      {5, 4, 24},
    {6, 4, 27},      {7, 5, 29},      {8, 6, 31},      {9, 6, 33},      {10, 7, 35},     {11, 7, 38},
    {13, 8, 40},     {14, 8, 42},     {15, 9, 45},     {16, 9, 47},     {18, 10, 50},    {19, 10, 52},
    {20, 11, 54},    {22, 11, 57},    {23, 11, 59},    {25, 11, 62},    {26, 11, 64},    {28, 12, 67},
    {29, 12, 69},    {31, 12, 71},    {32, 12, 74},    {34, 11, 76},    {36, 11, 78},    {38, 11, 80},
    {39, 11, 82},    {41, 11, 84},    {43, 10, 86},    {45, 10, 88},    {46, 10, 90},    {48, 10, 92},
    {50, 9, 93},     {52, 9, 95},     {53, 9, 96},     {55, 9, 97},     {57, 9, 98},     {59, 9, 100},
    {60, 9, 101},    {62, 9, 102},    {64, 9, 102},    {65, 9, 103},    {67, 10, 104},   {69, 10, 105},
    {70, 10, 105},   {72, 11, 106},   {74, 11, 106},   {75, 12, 107},   {77, 12, 107},   {79, 13, 108},
    {80, 13, 108},   {82, 14, 108},   {83, 14, 109},   {85, 15, 109},   {87, 15, 109},   {88, 16, 109},
    {90, 17, 109},   {91, 17, 110},   {93, 18, 110},   {95, 18, 110},   {96, 19, 110},   {98, 20, 110},
    {99, 20, 110},   {101, 21, 110},  {102, 21, 110},  {104, 22, 110},  {106, 23, 110},  {107, 23, 110},
    {109, 24, 110},  {110, 24, 110},  {112, 25, 110},  {114, 25, 109},  {115, 26, 109},  {117, 27, 109},
    {118, 27, 109},  {120, 28, 109},  {122, 28, 109},  {123, 29, 108},  {125, 29, 108},  {126, 30, 108},
    {128, 31, 107},  {129, 31, 107},  {131, 32, 107},  {133, 32, 106},  {134, 33, 106},  {136, 33, 106},
    {137, 34, 105},  {139, 34, 105},  {141, 35, 105},  {142, 36, 104},  {144, 36, 104},  {145, 37, 103},
    {147, 37, 103},  {149, 38, 102},  {150, 38, 102},  {152, 39, 101},  {153, 40, 100},  {155, 40, 100},
    {156, 41, 99},   {158, 41, 99},   {160, 42, 98},   {161, 43, 97},   {163, 43, 97},   {164, 44, 96},
    {166, 44, 95},   {167, 45, 95},   {169, 46, 94},   {171, 46, 93},   {172, 47, 92},   {174, 48, 91},
    {175, 49, 91},   {177, 49, 90},   {178, 50, 89},   {180, 51, 88},   {181, 51, 87},   {183, 52, 86},
    {184, 53, 86},   {186, 54, 85},   {187, 55, 84},   {189, 55, 83},   {190, 56, 82},   {191, 57, 81},
    {193, 58, 80},   {194, 59, 79},   {196, 60, 78},   {197, 61, 77},   {199, 62, 76},   {200, 62, 75},
    {201, 63, 74},   {203, 64, 73},   {204, 65, 72},   {205, 66, 71},   {207, 68, 70},   {208, 69, 68},
    {209, 70, 67},   {210, 71, 66},   {212, 72, 65},   {213, 73, 64},   {214, 74, 63},   {215, 75, 62},
    {217, 77, 61},   {218, 78, 59},   {219, 79, 58},   {220, 80, 57},   {221, 82, 56},   {222, 83, 55},
    {223, 84, 54},   {224, 86, 52},   {226, 87, 51},   {227, 88, 50},   {228, 90, 49},   {229, 91, 48},
    {230, 92, 46},   {230, 94, 45},   {231, 95, 44},   {232, 97, 43},   {233, 98, 42},   {234, 100, 40},
    {235, 101, 39},  {236, 103, 38},  {237, 104, 37},  {237, 106, 35},  {238, 108, 34},  {239, 109, 33},
    {240, 111, 31},  {240, 112, 30},  {241, 114, 29},  {242, 116, 28},  {242, 117, 26},  {243, 119, 25},
    {243, 121, 24},  {244, 122, 22},  {245, 124, 21},  {245, 126, 20},  {246, 128, 18},  {246, 129, 17},
    {247, 131, 16},  {247, 133, 14},  {248, 135, 13},  {248, 136, 12},  {248, 138, 11},  {249, 140, 9},
    {249, 142, 8},   {249, 144, 8},   {250, 145, 7},   {250, 147, 6},   {250, 149, 6},   {250, 151, 6},
    {251, 153, 6},   {251, 155, 6},   {251, 157, 6},   {251, 158, 7},   {251, 160, 7},   {251, 162, 8},
    {251, 164, 10},  {251, 166, 11},  {251, 168, 13},  {251, 170, 14},  {251, 172, 16},  {251, 174, 18},
    {251, 176, 20},  {251, 177, 22},  {251, 179, 24},  {251, 181, 26},  {251, 183, 28},  {251, 185, 30},
    {250, 187, 33},  {250, 189, 35},  {250, 191, 37},  {250, 193, 40},  {249, 195, 42},  {249, 197, 44},
    {249, 199, 47},  {248, 201, 49},  {248, 203, 52},  {248, 205, 55},  {247, 207, 58},  {247, 209, 60},
    {246, 211, 63},  {246, 213, 66},  {245, 215, 69},  {245, 217, 72},  {244, 219, 75},  {244, 220, 79},
    {243, 222, 82},  {243, 224, 86},  {243, 226, 89},  {242, 228, 93},  {242, 230, 96},  {241, 232, 100},
    {241, 233, 104}, {241, 235, 108}, {241, 237, 112}, {241, 238, 116}, {241, 240, 121}, {241, 242, 125},
    {242, 243, 129}, {242, 244, 133}, {243, 246, 137}, {244, 247, 141}, {245, 248, 145}, {246, 250, 149},
    {247, 251, 153}, {249, 252, 157}, {250, 253, 160}, {252, 254, 164}
};

unsigned char m_jetSrgbBytes[256][3] = {
    {0, 0, 127},     {0, 0, 131},     {0, 0, 135},     {0, 0, 139},     {0, 0, 143},     {0, 0, 147},
    {0, 0, 151},     {0, 0, 155},     {0, 0, 159},     {0, 0, 163},     {0, 0, 167},     {0, 0, 171},
    {0, 0, 175},     {0, 0, 179},     {0, 0, 183},     {0, 0, 187},     {0, 0, 191},     {0, 0, 195},
    {0, 0, 199},     {0, 0, 203},     {0, 0, 207},     {0, 0, 211},     {0, 0, 215},     {0, 0, 219},
    {0, 0, 223},     {0, 0, 227},     {0, 0, 231},     {0, 0, 235},     {0, 0, 239},     {0, 0, 243},
    {0, 0, 247},     {0, 0, 251},     {0, 0, 255},     {0, 4, 255},     {0, 8, 255},     {0, 12, 255},
    {0, 16, 255},    {0, 20, 255},    {0, 24, 255},    {0, 28, 255},    {0, 32, 255},    {0, 36, 255},
    {0, 40, 255},    {0, 44, 255},    {0, 48, 255},    {0, 52, 255},    {0, 56, 255},    {0, 60, 255},
    {0, 64, 255},    {0, 68, 255},    {0, 72, 255},    {0, 76, 255},    {0, 80, 255},    {0, 84, 255},
    {0, 88, 255},    {0, 92, 255},    {0, 96, 255},    {0, 100, 255},   {0, 104, 255},   {0, 108, 255},
    {0, 112, 255},   {0, 116, 255},   {0, 120, 255},   {0, 124, 255},   {0, 128, 255},   {0, 132, 255},
    {0, 136, 255},   {0, 140, 255},   {0, 144, 255},   {0, 148, 255},   {0, 152, 255},   {0, 156, 255},
    {0, 160, 255},   {0, 164, 255},   {0, 168, 255},   {0, 172, 255},   {0, 176, 255},   {0, 180, 255},
    {0, 184, 255},   {0, 188, 255},   {0, 192, 255},   {0, 196, 255},   {0, 200, 255},   {0, 204, 255},
    {0, 208, 255},   {0, 212, 255},   {0, 216, 255},   {0, 220, 255},   {0, 224, 255},   {0, 228, 255},
    {0, 232, 255},   {0, 236, 255},   {0, 240, 255},   {0, 244, 255},   {0, 248, 255},   {0, 252, 255},
    {1, 255, 253},   {5, 255, 249},   {9, 255, 245},   {13, 255, 241},  {17, 255, 237},  {21, 255, 233},
    {25, 255, 229},  {29, 255, 225},  {33, 255, 221},  {37, 255, 217},  {41, 255, 213},  {45, 255, 209},
    {49, 255, 205},  {53, 255, 201},  {57, 255, 197},  {61, 255, 193},  {65, 255, 189},  {69, 255, 185},
    {73, 255, 181},  {77, 255, 177},  {81, 255, 173},  {85, 255, 169},  {89, 255, 165},  {93, 255, 161},
    {97, 255, 157},  {101, 255, 153}, {105, 255, 149}, {109, 255, 145}, {113, 255, 141}, {117, 255, 137},
    {121, 255, 133}, {125, 255, 129}, {129, 255, 125}, {133, 255, 121}, {137, 255, 117}, {141, 255, 113},
    {145, 255, 109}, {149, 255, 105}, {153, 255, 101}, {157, 255, 97},  {161, 255, 93},  {165, 255, 89},
    {169, 255, 85},  {173, 255, 81},  {177, 255, 77},  {181, 255, 73},  {185, 255, 69},  {189, 255, 65},
    {193, 255, 61},  {197, 255, 57},  {201, 255, 53},  {205, 255, 49},  {209, 255, 45},  {213, 255, 41},
    {217, 255, 37},  {221, 255, 33},  {225, 255, 29},  {229, 255, 25},  {233, 255, 21},  {237, 255, 17},
    {241, 255, 13},  {245, 255, 9},   {249, 255, 5},   {253, 255, 1},   {255, 252, 0},   {255, 248, 0},
    {255, 244, 0},   {255, 240, 0},   {255, 236, 0},   {255, 232, 0},   {255, 228, 0},   {255, 224, 0},
    {255, 220, 0},   {255, 216, 0},   {255, 212, 0},   {255, 208, 0},   {255, 204, 0},   {255, 200, 0},
    {255, 196, 0},   {255, 192, 0},   {255, 188, 0},   {255, 184, 0},   {255, 180, 0},   {255, 176, 0},
    {255, 172, 0},   {255, 168, 0},   {255, 164, 0},   {255, 160, 0},   {255, 156, 0},   {255, 152, 0},
    {255, 148, 0},   {255, 144, 0},   {255, 140, 0},   {255, 136, 0},   {255, 132, 0},   {255, 128, 0},
    {255, 124, 0},   {255, 120, 0},   {255, 116, 0},   {255, 112, 0},   {255, 108, 0},   {255, 104, 0},
    {255, 100, 0},   {255, 96, 0},    {255, 92, 0},    {255, 88, 0},    {255, 84, 0},    {255, 80, 0},
    {255, 76, 0},    {255, 72, 0},    {255, 68, 0},    {255, 64, 0},    {255, 60, 0},    {255, 56, 0},
    {255, 52, 0},    {255, 48, 0},    {255, 44, 0},    {255, 40, 0},    {255, 36, 0},    {255, 32, 0},
    {255, 28, 0},    {255, 24, 0},    {255, 20, 0},    {255, 16, 0},    {255, 12, 0},    {255, 8, 0},
    {255, 4, 0},     {255, 0, 0},     {251, 0, 0},     {247, 0, 0},     {243, 0, 0},     {239, 0, 0},
    {235, 0, 0},     {231, 0, 0},     {227, 0, 0},     {223, 0, 0},     {219, 0, 0},     {215, 0, 0},
    {211, 0, 0},     {207, 0, 0},     {203, 0, 0},     {199, 0, 0},     {195, 0, 0},     {191, 0, 0},
    {187, 0, 0},     {183, 0, 0},     {179, 0, 0},     {175, 0, 0},     {171, 0, 0},     {167, 0, 0},
    {163, 0, 0},     {159, 0, 0},     {155, 0, 0},     {151, 0, 0},     {147, 0, 0},     {143, 0, 0},
    {139, 0, 0},     {135, 0, 0},     {131, 0, 0},     {127, 0, 0}
};

unsigned char m_magmaSrgbBytes[256][3] = {
    {0, 0, 3},       {0, 0, 4},       {0, 0, 6},       {1, 0, 7},       {1, 1, 9},       {1, 1, 11},
    {2, 2, 13},      {2, 2, 15},      {3, 3, 17},      {4, 3, 19},      {4, 4, 21},      {5, 4, 23},
    {6, 5, 25},      {7, 5, 27},      {8, 6, 29},      {9, 7, 31},      {10, 7, 34},     {11, 8, 36},
    {12, 9, 38},     {13, 10, 40},    {14, 10, 42},    {15, 11, 44},    {16, 12, 47},    {17, 12, 49},
    {18, 13, 51},    {20, 13, 53},    {21, 14, 56},    {22, 14, 58},    {23, 15, 60},    {24, 15, 63},
    {26, 16, 65},    {27, 16, 68},    {28, 16, 70},    {30, 16, 73},    {31, 17, 75},    {32, 17, 77},
    {34, 17, 80},    {35, 17, 82},    {37, 17, 85},    {38, 17, 87},    {40, 17, 89},    {42, 17, 92},
    {43, 17, 94},    {45, 16, 96},    {47, 16, 98},    {48, 16, 101},   {50, 16, 103},   {52, 16, 104},
    {53, 15, 106},   {55, 15, 108},   {57, 15, 110},   {59, 15, 111},   {60, 15, 113},   {62, 15, 114},
    {64, 15, 115},   {66, 15, 116},   {67, 15, 117},   {69, 15, 118},   {71, 15, 119},   {72, 16, 120},
    {74, 16, 121},   {75, 16, 121},   {77, 17, 122},   {79, 17, 123},   {80, 18, 123},   {82, 18, 124},
    {83, 19, 124},   {85, 19, 125},   {87, 20, 125},   {88, 21, 126},   {90, 21, 126},   {91, 22, 126},
    {93, 23, 126},   {94, 23, 127},   {96, 24, 127},   {97, 24, 127},   {99, 25, 127},   {101, 26, 128},
    {102, 26, 128},  {104, 27, 128},  {105, 28, 128},  {107, 28, 128},  {108, 29, 128},  {110, 30, 129},
    {111, 30, 129},  {113, 31, 129},  {115, 31, 129},  {116, 32, 129},  {118, 33, 129},  {119, 33, 129},
    {121, 34, 129},  {122, 34, 129},  {124, 35, 129},  {126, 36, 129},  {127, 36, 129},  {129, 37, 129},
    {130, 37, 129},  {132, 38, 129},  {133, 38, 129},  {135, 39, 129},  {137, 40, 129},  {138, 40, 129},
    {140, 41, 128},  {141, 41, 128},  {143, 42, 128},  {145, 42, 128},  {146, 43, 128},  {148, 43, 128},
    {149, 44, 128},  {151, 44, 127},  {153, 45, 127},  {154, 45, 127},  {156, 46, 127},  {158, 46, 126},
    {159, 47, 126},  {161, 47, 126},  {163, 48, 126},  {164, 48, 125},  {166, 49, 125},  {167, 49, 125},
    {169, 50, 124},  {171, 51, 124},  {172, 51, 123},  {174, 52, 123},  {176, 52, 123},  {177, 53, 122},
    {179, 53, 122},  {181, 54, 121},  {182, 54, 121},  {184, 55, 120},  {185, 55, 120},  {187, 56, 119},
    {189, 57, 119},  {190, 57, 118},  {192, 58, 117},  {194, 58, 117},  {195, 59, 116},  {197, 60, 116},
    {198, 60, 115},  {200, 61, 114},  {202, 62, 114},  {203, 62, 113},  {205, 63, 112},  {206, 64, 112},
    {208, 65, 111},  {209, 66, 110},  {211, 66, 109},  {212, 67, 109},  {214, 68, 108},  {215, 69, 107},
    {217, 70, 106},  {218, 71, 105},  {220, 72, 105},  {221, 73, 104},  {222, 74, 103},  {224, 75, 102},
    {225, 76, 102},  {226, 77, 101},  {228, 78, 100},  {229, 80, 99},   {230, 81, 98},   {231, 82, 98},
    {232, 84, 97},   {234, 85, 96},   {235, 86, 96},   {236, 88, 95},   {237, 89, 95},   {238, 91, 94},
    {238, 93, 93},   {239, 94, 93},   {240, 96, 93},   {241, 97, 92},   {242, 99, 92},   {243, 101, 92},
    {243, 103, 91},  {244, 104, 91},  {245, 106, 91},  {245, 108, 91},  {246, 110, 91},  {246, 112, 91},
    {247, 113, 91},  {247, 115, 92},  {248, 117, 92},  {248, 119, 92},  {249, 121, 92},  {249, 123, 93},
    {249, 125, 93},  {250, 127, 94},  {250, 128, 94},  {250, 130, 95},  {251, 132, 96},  {251, 134, 96},
    {251, 136, 97},  {251, 138, 98},  {252, 140, 99},  {252, 142, 99},  {252, 144, 100}, {252, 146, 101},
    {252, 147, 102}, {253, 149, 103}, {253, 151, 104}, {253, 153, 105}, {253, 155, 106}, {253, 157, 107},
    {253, 159, 108}, {253, 161, 110}, {253, 162, 111}, {253, 164, 112}, {254, 166, 113}, {254, 168, 115},
    {254, 170, 116}, {254, 172, 117}, {254, 174, 118}, {254, 175, 120}, {254, 177, 121}, {254, 179, 123},
    {254, 181, 124}, {254, 183, 125}, {254, 185, 127}, {254, 187, 128}, {254, 188, 130}, {254, 190, 131},
    {254, 192, 133}, {254, 194, 134}, {254, 196, 136}, {254, 198, 137}, {254, 199, 139}, {254, 201, 141},
    {254, 203, 142}, {253, 205, 144}, {253, 207, 146}, {253, 209, 147}, {253, 210, 149}, {253, 212, 151},
    {253, 214, 152}, {253, 216, 154}, {253, 218, 156}, {253, 220, 157}, {253, 221, 159}, {253, 223, 161},
    {253, 225, 163}, {252, 227, 165}, {252, 229, 166}, {252, 230, 168}, {252, 232, 170}, {252, 234, 172},
    {252, 236, 174}, {252, 238, 176}, {252, 240, 177}, {252, 241, 179}, {252, 243, 181}, {252, 245, 183},
    {251, 247, 185}, {251, 249, 187}, {251, 250, 189}, {251, 252, 191}
};

unsigned char m_oceanSrgbBytes[256][3] = {
    {0, 127, 0},     {0, 126, 1},     {0, 124, 2},     {0, 123, 3},     {0, 121, 4},     {0, 120, 5},
    {0, 118, 6},     {0, 117, 7},     {0, 115, 8},     {0, 114, 9},     {0, 112, 10},    {0, 111, 11},
    {0, 109, 12},    {0, 108, 13},    {0, 106, 14},    {0, 105, 15},    {0, 103, 16},    {0, 102, 17},
    {0, 100, 18},    {0, 99, 19},     {0, 97, 20},     {0, 96, 21},     {0, 94, 22},     {0, 93, 23},
    {0, 91, 24},     {0, 89, 25},     {0, 88, 26},     {0, 87, 27},     {0, 85, 28},     {0, 84, 29},
    {0, 82, 30},     {0, 81, 31},     {0, 79, 32},     {0, 78, 32},     {0, 76, 34},     {0, 74, 35},
    {0, 73, 36},     {0, 72, 36},     {0, 70, 38},     {0, 69, 39},     {0, 67, 40},     {0, 66, 40},
    {0, 64, 42},     {0, 63, 43},     {0, 61, 44},     {0, 60, 44},     {0, 58, 46},     {0, 56, 47},
    {0, 55, 48},     {0, 54, 48},     {0, 52, 50},     {0, 50, 51},     {0, 49, 52},     {0, 48, 52},
    {0, 46, 54},     {0, 44, 55},     {0, 43, 56},     {0, 42, 56},     {0, 40, 58},     {0, 39, 59},
    {0, 37, 60},     {0, 36, 60},     {0, 34, 62},     {0, 32, 63},     {0, 31, 64},     {0, 30, 65},
    {0, 28, 65},     {0, 26, 67},     {0, 25, 68},     {0, 24, 69},     {0, 22, 70},     {0, 20, 71},
    {0, 19, 72},     {0, 18, 73},     {0, 16, 73},     {0, 15, 75},     {0, 13, 76},     {0, 12, 77},
    {0, 10, 78},     {0, 8, 79},      {0, 7, 80},      {0, 6, 81},      {0, 4, 81},      {0, 2, 83},
    {0, 1, 84},      {0, 0, 85},      {0, 1, 86},      {0, 2, 87},      {0, 4, 88},      {0, 5, 89},
    {0, 7, 89},      {0, 8, 91},      {0, 10, 92},     {0, 11, 93},     {0, 13, 94},     {0, 15, 95},
    {0, 16, 96},     {0, 17, 97},     {0, 19, 97},     {0, 21, 99},     {0, 22, 100},    {0, 24, 101},
    {0, 25, 102},    {0, 27, 103},    {0, 28, 104},    {0, 30, 105},    {0, 31, 105},    {0, 32, 107},
    {0, 34, 108},    {0, 35, 109},    {0, 37, 110},    {0, 39, 111},    {0, 40, 112},    {0, 41, 113},
    {0, 43, 113},    {0, 45, 115},    {0, 46, 116},    {0, 48, 117},    {0, 49, 118},    {0, 50, 119},
    {0, 52, 120},    {0, 53, 121},    {0, 55, 121},    {0, 56, 123},    {0, 58, 124},    {0, 59, 125},
    {0, 61, 126},    {0, 63, 127},    {0, 64, 128},    {0, 65, 129},    {0, 67, 130},    {0, 68, 131},
    {0, 70, 131},    {0, 72, 133},    {0, 73, 134},    {0, 75, 135},    {0, 76, 136},    {0, 78, 137},
    {0, 79, 138},    {0, 81, 139},    {0, 82, 140},    {0, 84, 141},    {0, 85, 142},    {0, 87, 143},
    {0, 88, 144},    {0, 89, 145},    {0, 91, 146},    {0, 92, 147},    {0, 94, 147},    {0, 96, 149},
    {0, 97, 150},    {0, 98, 151},    {0, 100, 152},   {0, 101, 153},   {0, 103, 154},   {0, 104, 155},
    {0, 106, 156},   {0, 108, 157},   {0, 109, 158},   {0, 111, 159},   {0, 112, 160},   {0, 113, 161},
    {0, 115, 162},   {0, 116, 163},   {0, 118, 163},   {0, 120, 165},   {0, 121, 166},   {0, 123, 167},
    {0, 124, 168},   {0, 126, 169},   {0, 127, 170},   {2, 129, 171},   {5, 130, 172},   {8, 131, 173},
    {11, 133, 174},  {14, 134, 175},  {17, 136, 176},  {20, 137, 177},  {23, 139, 178},  {26, 140, 179},
    {29, 142, 179},  {32, 144, 181},  {35, 145, 182},  {38, 147, 183},  {41, 148, 184},  {44, 149, 185},
    {47, 151, 186},  {50, 152, 187},  {54, 154, 188},  {57, 156, 189},  {60, 157, 190},  {63, 159, 191},
    {65, 160, 192},  {68, 162, 193},  {71, 163, 194},  {74, 164, 195},  {77, 166, 195},  {81, 168, 197},
    {84, 169, 198},  {87, 171, 199},  {90, 172, 200},  {93, 174, 201},  {96, 175, 202},  {98, 177, 203},
    {102, 178, 204}, {105, 180, 205}, {108, 181, 206}, {111, 183, 207}, {114, 184, 208}, {117, 186, 209},
    {120, 187, 210}, {123, 189, 211}, {126, 190, 211}, {129, 192, 213}, {131, 193, 214}, {134, 195, 215},
    {137, 196, 216}, {140, 197, 217}, {143, 199, 218}, {146, 200, 219}, {150, 202, 220}, {153, 204, 221},
    {156, 205, 222}, {159, 207, 223}, {162, 208, 224}, {164, 210, 225}, {167, 211, 226}, {170, 212, 227},
    {173, 214, 227}, {177, 216, 229}, {180, 217, 230}, {183, 219, 231}, {186, 220, 232}, {189, 222, 233},
    {192, 223, 234}, {195, 225, 235}, {197, 226, 236}, {200, 227, 237}, {203, 229, 238}, {206, 230, 239},
    {209, 232, 240}, {212, 233, 241}, {215, 235, 242}, {218, 236, 243}, {221, 238, 243}, {225, 240, 245},
    {227, 241, 246}, {230, 243, 247}, {233, 244, 248}, {236, 245, 249}, {239, 247, 250}, {242, 248, 251},
    {246, 250, 252}, {249, 252, 253}, {252, 253, 254}, {255, 255, 255}
};

unsigned char m_plasmaSrgbBytes[256][3] = {
    {12, 7, 134},   {16, 7, 135},   {19, 6, 137},   {21, 6, 138},   {24, 6, 139},   {27, 6, 140},   {29, 6, 141},
    {31, 5, 142},   {33, 5, 143},   {35, 5, 144},   {37, 5, 145},   {39, 5, 146},   {41, 5, 147},   {43, 5, 148},
    {45, 4, 148},   {47, 4, 149},   {49, 4, 150},   {51, 4, 151},   {52, 4, 152},   {54, 4, 152},   {56, 4, 153},
    {58, 4, 154},   {59, 3, 154},   {61, 3, 155},   {63, 3, 156},   {64, 3, 156},   {66, 3, 157},   {68, 3, 158},
    {69, 3, 158},   {71, 2, 159},   {73, 2, 159},   {74, 2, 160},   {76, 2, 161},   {78, 2, 161},   {79, 2, 162},
    {81, 1, 162},   {82, 1, 163},   {84, 1, 163},   {86, 1, 163},   {87, 1, 164},   {89, 1, 164},   {90, 0, 165},
    {92, 0, 165},   {94, 0, 165},   {95, 0, 166},   {97, 0, 166},   {98, 0, 166},   {100, 0, 167},  {101, 0, 167},
    {103, 0, 167},  {104, 0, 167},  {106, 0, 167},  {108, 0, 168},  {109, 0, 168},  {111, 0, 168},  {112, 0, 168},
    {114, 0, 168},  {115, 0, 168},  {117, 0, 168},  {118, 1, 168},  {120, 1, 168},  {121, 1, 168},  {123, 2, 168},
    {124, 2, 167},  {126, 3, 167},  {127, 3, 167},  {129, 4, 167},  {130, 4, 167},  {132, 5, 166},  {133, 6, 166},
    {134, 7, 166},  {136, 7, 165},  {137, 8, 165},  {139, 9, 164},  {140, 10, 164}, {142, 12, 164}, {143, 13, 163},
    {144, 14, 163}, {146, 15, 162}, {147, 16, 161}, {149, 17, 161}, {150, 18, 160}, {151, 19, 160}, {153, 20, 159},
    {154, 21, 158}, {155, 23, 158}, {157, 24, 157}, {158, 25, 156}, {159, 26, 155}, {160, 27, 155}, {162, 28, 154},
    {163, 29, 153}, {164, 30, 152}, {165, 31, 151}, {167, 33, 151}, {168, 34, 150}, {169, 35, 149}, {170, 36, 148},
    {172, 37, 147}, {173, 38, 146}, {174, 39, 145}, {175, 40, 144}, {176, 42, 143}, {177, 43, 143}, {178, 44, 142},
    {180, 45, 141}, {181, 46, 140}, {182, 47, 139}, {183, 48, 138}, {184, 50, 137}, {185, 51, 136}, {186, 52, 135},
    {187, 53, 134}, {188, 54, 133}, {189, 55, 132}, {190, 56, 131}, {191, 57, 130}, {192, 59, 129}, {193, 60, 128},
    {194, 61, 128}, {195, 62, 127}, {196, 63, 126}, {197, 64, 125}, {198, 65, 124}, {199, 66, 123}, {200, 68, 122},
    {201, 69, 121}, {202, 70, 120}, {203, 71, 119}, {204, 72, 118}, {205, 73, 117}, {206, 74, 117}, {207, 75, 116},
    {208, 77, 115}, {209, 78, 114}, {209, 79, 113}, {210, 80, 112}, {211, 81, 111}, {212, 82, 110}, {213, 83, 109},
    {214, 85, 109}, {215, 86, 108}, {215, 87, 107}, {216, 88, 106}, {217, 89, 105}, {218, 90, 104}, {219, 91, 103},
    {220, 93, 102}, {220, 94, 102}, {221, 95, 101}, {222, 96, 100}, {223, 97, 99},  {223, 98, 98},  {224, 100, 97},
    {225, 101, 96}, {226, 102, 96}, {227, 103, 95}, {227, 104, 94}, {228, 106, 93}, {229, 107, 92}, {229, 108, 91},
    {230, 109, 90}, {231, 110, 90}, {232, 112, 89}, {232, 113, 88}, {233, 114, 87}, {234, 115, 86}, {234, 116, 85},
    {235, 118, 84}, {236, 119, 84}, {236, 120, 83}, {237, 121, 82}, {237, 123, 81}, {238, 124, 80}, {239, 125, 79},
    {239, 126, 78}, {240, 128, 77}, {240, 129, 77}, {241, 130, 76}, {242, 132, 75}, {242, 133, 74}, {243, 134, 73},
    {243, 135, 72}, {244, 137, 71}, {244, 138, 71}, {245, 139, 70}, {245, 141, 69}, {246, 142, 68}, {246, 143, 67},
    {246, 145, 66}, {247, 146, 65}, {247, 147, 65}, {248, 149, 64}, {248, 150, 63}, {248, 152, 62}, {249, 153, 61},
    {249, 154, 60}, {250, 156, 59}, {250, 157, 58}, {250, 159, 58}, {250, 160, 57}, {251, 162, 56}, {251, 163, 55},
    {251, 164, 54}, {252, 166, 53}, {252, 167, 53}, {252, 169, 52}, {252, 170, 51}, {252, 172, 50}, {252, 173, 49},
    {253, 175, 49}, {253, 176, 48}, {253, 178, 47}, {253, 179, 46}, {253, 181, 45}, {253, 182, 45}, {253, 184, 44},
    {253, 185, 43}, {253, 187, 43}, {253, 188, 42}, {253, 190, 41}, {253, 192, 41}, {253, 193, 40}, {253, 195, 40},
    {253, 196, 39}, {253, 198, 38}, {252, 199, 38}, {252, 201, 38}, {252, 203, 37}, {252, 204, 37}, {252, 206, 37},
    {251, 208, 36}, {251, 209, 36}, {251, 211, 36}, {250, 213, 36}, {250, 214, 36}, {250, 216, 36}, {249, 217, 36},
    {249, 219, 36}, {248, 221, 36}, {248, 223, 36}, {247, 224, 36}, {247, 226, 37}, {246, 228, 37}, {246, 229, 37},
    {245, 231, 38}, {245, 233, 38}, {244, 234, 38}, {243, 236, 38}, {243, 238, 38}, {242, 240, 38}, {242, 241, 38},
    {241, 243, 38}, {240, 245, 37}, {240, 246, 35}, {239, 248, 33}
};

unsigned char m_rainbowSrgbBytes[256][3] = {
    {127, 0, 255},   {125, 3, 254},   {123, 6, 254},   {121, 9, 254},   {119, 12, 254},  {117, 15, 254},
    {115, 18, 254},  {113, 21, 254},  {111, 25, 254},  {109, 28, 254},  {107, 31, 254},  {105, 34, 254},
    {103, 37, 254},  {101, 40, 254},  {99, 43, 254},   {97, 46, 253},   {95, 49, 253},   {93, 53, 253},
    {91, 56, 253},   {89, 59, 253},   {87, 62, 253},   {85, 65, 252},   {83, 68, 252},   {81, 71, 252},
    {79, 74, 252},   {77, 77, 251},   {75, 80, 251},   {73, 83, 251},   {71, 86, 251},   {69, 89, 250},
    {67, 92, 250},   {65, 95, 250},   {63, 97, 250},   {61, 100, 249},  {59, 103, 249},  {57, 106, 249},
    {55, 109, 248},  {53, 112, 248},  {51, 115, 248},  {49, 117, 247},  {47, 120, 247},  {45, 123, 246},
    {43, 126, 246},  {41, 128, 246},  {39, 131, 245},  {37, 134, 245},  {35, 136, 244},  {33, 139, 244},
    {31, 142, 243},  {29, 144, 243},  {27, 147, 243},  {25, 149, 242},  {23, 152, 242},  {21, 154, 241},
    {19, 157, 241},  {17, 159, 240},  {15, 162, 239},  {13, 164, 239},  {11, 167, 238},  {9, 169, 238},
    {7, 171, 237},   {5, 174, 237},   {3, 176, 236},   {1, 178, 236},   {0, 180, 235},   {2, 183, 234},
    {4, 185, 234},   {6, 187, 233},   {8, 189, 232},   {10, 191, 232},  {12, 193, 231},  {14, 195, 230},
    {16, 197, 230},  {18, 199, 229},  {20, 201, 228},  {22, 203, 228},  {24, 205, 227},  {26, 207, 226},
    {28, 209, 226},  {30, 210, 225},  {32, 212, 224},  {34, 214, 223},  {36, 215, 223},  {38, 217, 222},
    {40, 219, 221},  {42, 220, 220},  {44, 222, 220},  {46, 223, 219},  {48, 225, 218},  {50, 226, 217},
    {52, 228, 216},  {54, 229, 215},  {56, 230, 215},  {58, 232, 214},  {60, 233, 213},  {62, 234, 212},
    {64, 236, 211},  {66, 237, 210},  {68, 238, 209},  {70, 239, 209},  {72, 240, 208},  {74, 241, 207},
    {76, 242, 206},  {78, 243, 205},  {80, 244, 204},  {82, 245, 203},  {84, 246, 202},  {86, 246, 201},
    {88, 247, 200},  {90, 248, 199},  {92, 249, 198},  {94, 249, 197},  {96, 250, 196},  {98, 250, 195},
    {100, 251, 194}, {102, 251, 193}, {104, 252, 192}, {106, 252, 191}, {108, 253, 190}, {110, 253, 189},
    {112, 253, 188}, {114, 254, 187}, {116, 254, 186}, {118, 254, 185}, {120, 254, 184}, {122, 254, 183},
    {124, 254, 181}, {126, 254, 180}, {128, 254, 179}, {130, 254, 178}, {132, 254, 177}, {134, 254, 176},
    {136, 254, 175}, {138, 254, 174}, {140, 254, 172}, {142, 253, 171}, {144, 253, 170}, {146, 253, 169},
    {148, 252, 168}, {150, 252, 167}, {152, 251, 165}, {154, 251, 164}, {156, 250, 163}, {158, 250, 162},
    {160, 249, 161}, {162, 249, 159}, {164, 248, 158}, {166, 247, 157}, {168, 246, 156}, {170, 246, 154},
    {172, 245, 153}, {174, 244, 152}, {176, 243, 151}, {178, 242, 149}, {180, 241, 148}, {182, 240, 147},
    {184, 239, 146}, {186, 238, 144}, {188, 237, 143}, {190, 236, 142}, {192, 234, 140}, {194, 233, 139},
    {196, 232, 138}, {198, 230, 136}, {200, 229, 135}, {202, 228, 134}, {204, 226, 132}, {206, 225, 131},
    {208, 223, 130}, {210, 222, 128}, {212, 220, 127}, {214, 219, 126}, {216, 217, 124}, {218, 215, 123},
    {220, 214, 122}, {222, 212, 120}, {224, 210, 119}, {226, 209, 117}, {228, 207, 116}, {230, 205, 115},
    {232, 203, 113}, {234, 201, 112}, {236, 199, 110}, {238, 197, 109}, {240, 195, 108}, {242, 193, 106},
    {244, 191, 105}, {246, 189, 103}, {248, 187, 102}, {250, 185, 100}, {252, 183, 99},  {254, 180, 97},
    {255, 178, 96},  {255, 176, 95},  {255, 174, 93},  {255, 171, 92},  {255, 169, 90},  {255, 167, 89},
    {255, 164, 87},  {255, 162, 86},  {255, 159, 84},  {255, 157, 83},  {255, 154, 81},  {255, 152, 80},
    {255, 149, 78},  {255, 147, 77},  {255, 144, 75},  {255, 142, 74},  {255, 139, 72},  {255, 136, 71},
    {255, 134, 69},  {255, 131, 68},  {255, 128, 66},  {255, 126, 65},  {255, 123, 63},  {255, 120, 62},
    {255, 117, 60},  {255, 115, 59},  {255, 112, 57},  {255, 109, 56},  {255, 106, 54},  {255, 103, 53},
    {255, 100, 51},  {255, 97, 49},   {255, 95, 48},   {255, 92, 46},   {255, 89, 45},   {255, 86, 43},
    {255, 83, 42},   {255, 80, 40},   {255, 77, 39},   {255, 74, 37},   {255, 71, 36},   {255, 68, 34},
    {255, 65, 32},   {255, 62, 31},   {255, 59, 29},   {255, 56, 28},   {255, 53, 26},   {255, 49, 25},
    {255, 46, 23},   {255, 43, 21},   {255, 40, 20},   {255, 37, 18},   {255, 34, 17},   {255, 31, 15},
    {255, 28, 14},   {255, 25, 12},   {255, 21, 10},   {255, 18, 9},    {255, 15, 7},    {255, 12, 6},
    {255, 9, 4},     {255, 6, 3},     {255, 3, 1},     {255, 0, 0}
};

unsigned char m_springSrgbBytes[256][3] = {
    {255, 0, 255},   {255, 1, 254},   {255, 2, 253},   {255, 3, 252},   {255, 4, 251},   {255, 5, 250},
    {255, 6, 249},   {255, 7, 248},   {255, 8, 247},   {255, 9, 246},   {255, 10, 245},  {255, 11, 244},
    {255, 12, 243},  {255, 13, 242},  {255, 14, 241},  {255, 15, 240},  {255, 16, 239},  {255, 17, 238},
    {255, 18, 237},  {255, 19, 236},  {255, 20, 235},  {255, 21, 234},  {255, 22, 233},  {255, 23, 232},
    {255, 24, 231},  {255, 25, 230},  {255, 26, 229},  {255, 27, 228},  {255, 28, 227},  {255, 29, 226},
    {255, 30, 225},  {255, 31, 224},  {255, 32, 223},  {255, 32, 222},  {255, 34, 221},  {255, 35, 220},
    {255, 36, 219},  {255, 36, 218},  {255, 38, 217},  {255, 39, 216},  {255, 40, 215},  {255, 40, 214},
    {255, 42, 213},  {255, 43, 211},  {255, 44, 211},  {255, 44, 210},  {255, 46, 209},  {255, 47, 208},
    {255, 48, 207},  {255, 48, 206},  {255, 50, 205},  {255, 51, 204},  {255, 52, 203},  {255, 52, 202},
    {255, 54, 201},  {255, 55, 200},  {255, 56, 199},  {255, 56, 198},  {255, 58, 197},  {255, 59, 195},
    {255, 60, 195},  {255, 60, 194},  {255, 62, 193},  {255, 63, 192},  {255, 64, 191},  {255, 65, 190},
    {255, 65, 189},  {255, 67, 188},  {255, 68, 187},  {255, 69, 186},  {255, 70, 185},  {255, 71, 184},
    {255, 72, 183},  {255, 73, 182},  {255, 73, 181},  {255, 75, 179},  {255, 76, 179},  {255, 77, 178},
    {255, 78, 177},  {255, 79, 176},  {255, 80, 175},  {255, 81, 174},  {255, 81, 173},  {255, 83, 172},
    {255, 84, 171},  {255, 85, 170},  {255, 86, 169},  {255, 87, 168},  {255, 88, 167},  {255, 89, 166},
    {255, 89, 165},  {255, 91, 163},  {255, 92, 163},  {255, 93, 162},  {255, 94, 161},  {255, 95, 160},
    {255, 96, 159},  {255, 97, 158},  {255, 97, 157},  {255, 99, 156},  {255, 100, 155}, {255, 101, 154},
    {255, 102, 153}, {255, 103, 152}, {255, 104, 151}, {255, 105, 150}, {255, 105, 149}, {255, 107, 147},
    {255, 108, 147}, {255, 109, 146}, {255, 110, 145}, {255, 111, 144}, {255, 112, 143}, {255, 113, 142},
    {255, 113, 141}, {255, 115, 140}, {255, 116, 139}, {255, 117, 138}, {255, 118, 137}, {255, 119, 136},
    {255, 120, 135}, {255, 121, 134}, {255, 121, 133}, {255, 123, 131}, {255, 124, 131}, {255, 125, 130},
    {255, 126, 129}, {255, 127, 128}, {255, 128, 127}, {255, 129, 126}, {255, 130, 125}, {255, 131, 124},
    {255, 131, 123}, {255, 133, 121}, {255, 134, 121}, {255, 135, 120}, {255, 136, 119}, {255, 137, 118},
    {255, 138, 117}, {255, 139, 116}, {255, 140, 114}, {255, 141, 113}, {255, 142, 113}, {255, 143, 112},
    {255, 144, 111}, {255, 145, 110}, {255, 146, 109}, {255, 147, 108}, {255, 147, 107}, {255, 149, 105},
    {255, 150, 105}, {255, 151, 104}, {255, 152, 103}, {255, 153, 102}, {255, 154, 101}, {255, 155, 100},
    {255, 156, 98},  {255, 157, 97},  {255, 158, 97},  {255, 159, 96},  {255, 160, 95},  {255, 161, 94},
    {255, 162, 93},  {255, 163, 92},  {255, 163, 91},  {255, 165, 89},  {255, 166, 89},  {255, 167, 88},
    {255, 168, 87},  {255, 169, 86},  {255, 170, 85},  {255, 171, 84},  {255, 172, 82},  {255, 173, 81},
    {255, 174, 81},  {255, 175, 80},  {255, 176, 79},  {255, 177, 78},  {255, 178, 77},  {255, 179, 76},
    {255, 179, 75},  {255, 181, 73},  {255, 182, 73},  {255, 183, 72},  {255, 184, 71},  {255, 185, 70},
    {255, 186, 69},  {255, 187, 68},  {255, 188, 66},  {255, 189, 65},  {255, 190, 65},  {255, 191, 64},
    {255, 192, 63},  {255, 193, 62},  {255, 194, 61},  {255, 195, 60},  {255, 195, 59},  {255, 197, 57},
    {255, 198, 56},  {255, 199, 56},  {255, 200, 55},  {255, 201, 54},  {255, 202, 53},  {255, 203, 52},
    {255, 204, 50},  {255, 205, 49},  {255, 206, 48},  {255, 207, 48},  {255, 208, 47},  {255, 209, 46},
    {255, 210, 45},  {255, 211, 44},  {255, 211, 43},  {255, 213, 41},  {255, 214, 40},  {255, 215, 40},
    {255, 216, 39},  {255, 217, 38},  {255, 218, 37},  {255, 219, 36},  {255, 220, 34},  {255, 221, 33},
    {255, 222, 32},  {255, 223, 32},  {255, 224, 31},  {255, 225, 30},  {255, 226, 29},  {255, 227, 28},
    {255, 227, 27},  {255, 229, 25},  {255, 230, 24},  {255, 231, 24},  {255, 232, 23},  {255, 233, 22},
    {255, 234, 21},  {255, 235, 20},  {255, 236, 18},  {255, 237, 17},  {255, 238, 16},  {255, 239, 16},
    {255, 240, 15},  {255, 241, 14},  {255, 242, 13},  {255, 243, 12},  {255, 243, 11},  {255, 245, 9},
    {255, 246, 8},   {255, 247, 8},   {255, 248, 7},   {255, 249, 6},   {255, 250, 5},   {255, 251, 4},
    {255, 252, 2},   {255, 253, 1},   {255, 254, 0},   {255, 255, 0}
};

unsigned char m_summerSrgbBytes[256][3] = {
    {0, 127, 102},   {1, 128, 102},   {2, 128, 102},   {3, 129, 102},   {4, 129, 102},   {5, 130, 102},
    {6, 130, 102},   {7, 131, 102},   {8, 131, 102},   {9, 132, 102},   {10, 132, 102},  {11, 133, 102},
    {12, 133, 102},  {13, 134, 102},  {14, 134, 102},  {15, 135, 102},  {16, 135, 102},  {17, 136, 102},
    {18, 136, 102},  {19, 137, 102},  {20, 137, 102},  {21, 138, 102},  {22, 138, 102},  {23, 139, 102},
    {24, 139, 102},  {25, 140, 102},  {26, 140, 102},  {27, 141, 102},  {28, 141, 102},  {29, 142, 102},
    {30, 142, 102},  {31, 143, 102},  {32, 143, 102},  {32, 144, 102},  {34, 144, 102},  {35, 145, 102},
    {36, 145, 102},  {36, 146, 102},  {38, 146, 102},  {39, 147, 102},  {40, 147, 102},  {40, 147, 102},
    {42, 148, 102},  {43, 149, 102},  {44, 149, 102},  {44, 150, 102},  {46, 150, 102},  {47, 151, 102},
    {48, 151, 102},  {48, 152, 102},  {50, 152, 102},  {51, 153, 102},  {52, 153, 102},  {52, 154, 102},
    {54, 154, 102},  {55, 155, 102},  {56, 155, 102},  {56, 156, 102},  {58, 156, 102},  {59, 157, 102},
    {60, 157, 102},  {60, 158, 102},  {62, 158, 102},  {63, 159, 102},  {64, 159, 102},  {65, 160, 102},
    {65, 160, 102},  {67, 161, 102},  {68, 161, 102},  {69, 162, 102},  {70, 162, 102},  {71, 163, 102},
    {72, 163, 102},  {73, 163, 102},  {73, 164, 102},  {75, 165, 102},  {76, 165, 102},  {77, 166, 102},
    {78, 166, 102},  {79, 167, 102},  {80, 167, 102},  {81, 168, 102},  {81, 168, 102},  {83, 169, 102},
    {84, 169, 102},  {85, 170, 102},  {86, 170, 102},  {87, 171, 102},  {88, 171, 102},  {89, 172, 102},
    {89, 172, 102},  {91, 173, 102},  {92, 173, 102},  {93, 174, 102},  {94, 174, 102},  {95, 175, 102},
    {96, 175, 102},  {97, 176, 102},  {97, 176, 102},  {99, 177, 102},  {100, 177, 102}, {101, 178, 102},
    {102, 178, 102}, {103, 179, 102}, {104, 179, 102}, {105, 179, 102}, {105, 180, 102}, {107, 181, 102},
    {108, 181, 102}, {109, 182, 102}, {110, 182, 102}, {111, 183, 102}, {112, 183, 102}, {113, 184, 102},
    {113, 184, 102}, {115, 185, 102}, {116, 185, 102}, {117, 186, 102}, {118, 186, 102}, {119, 187, 102},
    {120, 187, 102}, {121, 188, 102}, {121, 188, 102}, {123, 189, 102}, {124, 189, 102}, {125, 190, 102},
    {126, 190, 102}, {127, 191, 102}, {128, 191, 102}, {129, 192, 102}, {130, 192, 102}, {131, 193, 102},
    {131, 193, 102}, {133, 194, 102}, {134, 194, 102}, {135, 195, 102}, {136, 195, 102}, {137, 195, 102},
    {138, 196, 102}, {139, 196, 102}, {140, 197, 102}, {141, 198, 102}, {142, 198, 102}, {143, 199, 102},
    {144, 199, 102}, {145, 200, 102}, {146, 200, 102}, {147, 201, 102}, {147, 201, 102}, {149, 202, 102},
    {150, 202, 102}, {151, 203, 102}, {152, 203, 102}, {153, 204, 102}, {154, 204, 102}, {155, 205, 102},
    {156, 205, 102}, {157, 206, 102}, {158, 206, 102}, {159, 207, 102}, {160, 207, 102}, {161, 208, 102},
    {162, 208, 102}, {163, 209, 102}, {163, 209, 102}, {165, 210, 102}, {166, 210, 102}, {167, 211, 102},
    {168, 211, 102}, {169, 211, 102}, {170, 212, 102}, {171, 212, 102}, {172, 213, 102}, {173, 214, 102},
    {174, 214, 102}, {175, 215, 102}, {176, 215, 102}, {177, 216, 102}, {178, 216, 102}, {179, 217, 102},
    {179, 217, 102}, {181, 218, 102}, {182, 218, 102}, {183, 219, 102}, {184, 219, 102}, {185, 220, 102},
    {186, 220, 102}, {187, 221, 102}, {188, 221, 102}, {189, 222, 102}, {190, 222, 102}, {191, 223, 102},
    {192, 223, 102}, {193, 224, 102}, {194, 224, 102}, {195, 225, 102}, {195, 225, 102}, {197, 226, 102},
    {198, 226, 102}, {199, 227, 102}, {200, 227, 102}, {201, 227, 102}, {202, 228, 102}, {203, 228, 102},
    {204, 229, 102}, {205, 230, 102}, {206, 230, 102}, {207, 231, 102}, {208, 231, 102}, {209, 232, 102},
    {210, 232, 102}, {211, 233, 102}, {211, 233, 102}, {213, 234, 102}, {214, 234, 102}, {215, 235, 102},
    {216, 235, 102}, {217, 236, 102}, {218, 236, 102}, {219, 237, 102}, {220, 237, 102}, {221, 238, 102},
    {222, 238, 102}, {223, 239, 102}, {224, 239, 102}, {225, 240, 102}, {226, 240, 102}, {227, 241, 102},
    {227, 241, 102}, {229, 242, 102}, {230, 242, 102}, {231, 243, 102}, {232, 243, 102}, {233, 243, 102},
    {234, 244, 102}, {235, 244, 102}, {236, 245, 102}, {237, 246, 102}, {238, 246, 102}, {239, 247, 102},
    {240, 247, 102}, {241, 248, 102}, {242, 248, 102}, {243, 249, 102}, {243, 249, 102}, {245, 250, 102},
    {246, 250, 102}, {247, 251, 102}, {248, 251, 102}, {249, 252, 102}, {250, 252, 102}, {251, 253, 102},
    {252, 253, 102}, {253, 254, 102}, {254, 254, 102}, {255, 255, 102}
};

unsigned char m_terrainSrgbBytes[256][3] = {
    {51, 51, 153},   {49, 53, 155},   {48, 56, 158},   {47, 59, 161},   {45, 61, 163},   {44, 64, 166},
    {43, 67, 169},   {41, 69, 171},   {40, 72, 174},   {39, 75, 177},   {37, 77, 179},   {36, 80, 182},
    {35, 83, 185},   {33, 85, 187},   {32, 88, 190},   {31, 91, 193},   {29, 93, 195},   {28, 96, 198},
    {27, 98, 201},   {25, 101, 203},  {24, 104, 206},  {23, 107, 209},  {21, 109, 211},  {20, 112, 214},
    {19, 115, 217},  {17, 117, 219},  {16, 120, 222},  {14, 123, 225},  {13, 125, 227},  {12, 128, 230},
    {11, 131, 233},  {9, 133, 235},   {8, 136, 238},   {7, 138, 241},   {5, 141, 243},   {4, 144, 246},
    {3, 147, 249},   {1, 149, 251},   {0, 152, 254},   {0, 154, 250},   {0, 156, 244},   {0, 158, 238},
    {0, 160, 232},   {0, 162, 226},   {0, 164, 220},   {0, 166, 214},   {0, 168, 208},   {0, 170, 202},
    {0, 172, 196},   {0, 174, 190},   {0, 176, 184},   {0, 178, 178},   {0, 180, 172},   {0, 182, 166},
    {0, 184, 160},   {0, 186, 154},   {0, 188, 148},   {0, 190, 142},   {0, 192, 136},   {0, 194, 130},
    {0, 196, 124},   {0, 198, 118},   {0, 200, 112},   {0, 202, 106},   {1, 204, 102},   {5, 205, 103},
    {8, 205, 103},   {13, 206, 104},  {17, 207, 105},  {21, 208, 106},  {25, 209, 107},  {29, 209, 107},
    {33, 210, 108},  {37, 211, 109},  {40, 212, 110},  {45, 213, 111},  {49, 213, 111},  {53, 214, 112},
    {57, 215, 113},  {61, 216, 114},  {65, 217, 115},  {69, 217, 115},  {72, 218, 116},  {77, 219, 117},
    {81, 220, 118},  {85, 221, 119},  {89, 221, 119},  {93, 222, 120},  {97, 223, 121},  {101, 224, 122},
    {104, 225, 122}, {109, 225, 123}, {113, 226, 124}, {117, 227, 125}, {121, 228, 126}, {125, 229, 127},
    {129, 229, 127}, {133, 230, 128}, {136, 231, 129}, {141, 232, 130}, {145, 233, 131}, {149, 233, 131},
    {153, 234, 132}, {157, 235, 133}, {161, 236, 134}, {165, 237, 135}, {168, 237, 135}, {173, 238, 136},
    {177, 239, 137}, {181, 240, 138}, {185, 241, 139}, {189, 241, 139}, {193, 242, 140}, {197, 243, 141},
    {200, 244, 142}, {205, 245, 143}, {209, 245, 143}, {213, 246, 144}, {217, 247, 145}, {221, 248, 146},
    {225, 249, 147}, {229, 249, 147}, {232, 250, 148}, {237, 251, 149}, {241, 252, 150}, {245, 253, 151},
    {249, 253, 151}, {253, 254, 152}, {254, 253, 152}, {252, 251, 151}, {250, 248, 150}, {248, 246, 149},
    {246, 243, 148}, {244, 240, 147}, {242, 238, 145}, {240, 235, 144}, {238, 233, 143}, {236, 230, 142},
    {234, 228, 141}, {232, 225, 140}, {230, 223, 139}, {228, 220, 138}, {226, 217, 137}, {224, 215, 136},
    {222, 212, 135}, {220, 210, 134}, {218, 207, 133}, {216, 205, 131}, {214, 202, 130}, {211, 199, 129},
    {210, 197, 128}, {208, 194, 127}, {206, 192, 126}, {204, 189, 125}, {202, 187, 124}, {200, 184, 123},
    {198, 182, 122}, {195, 179, 121}, {194, 176, 120}, {192, 174, 118}, {190, 171, 117}, {188, 169, 116},
    {186, 166, 115}, {184, 164, 114}, {182, 161, 113}, {179, 159, 112}, {178, 156, 111}, {176, 153, 110},
    {174, 151, 109}, {172, 148, 108}, {170, 146, 107}, {168, 143, 106}, {166, 141, 104}, {163, 138, 103},
    {162, 135, 102}, {160, 133, 101}, {158, 130, 100}, {156, 128, 99},  {154, 125, 98},  {152, 123, 97},
    {150, 120, 96},  {147, 118, 95},  {146, 115, 94},  {144, 112, 93},  {142, 110, 91},  {140, 107, 90},
    {138, 105, 89},  {136, 102, 88},  {134, 100, 87},  {131, 97, 86},   {130, 95, 85},   {128, 92, 84},
    {129, 93, 86},   {131, 96, 88},   {133, 98, 91},   {135, 101, 94},  {136, 103, 96},  {139, 106, 99},
    {141, 109, 102}, {143, 111, 104}, {145, 114, 107}, {147, 116, 110}, {149, 119, 112}, {151, 121, 115},
    {153, 124, 118}, {155, 127, 121}, {157, 129, 123}, {159, 132, 126}, {161, 134, 129}, {163, 137, 131},
    {165, 139, 134}, {167, 142, 137}, {168, 144, 139}, {171, 147, 142}, {173, 150, 145}, {175, 152, 147},
    {177, 155, 150}, {179, 157, 153}, {181, 160, 155}, {183, 162, 158}, {185, 165, 161}, {187, 167, 163},
    {189, 170, 166}, {191, 173, 169}, {193, 175, 171}, {195, 178, 174}, {196, 180, 177}, {199, 183, 179},
    {200, 185, 182}, {203, 188, 185}, {205, 191, 187}, {207, 193, 190}, {209, 196, 193}, {211, 198, 196},
    {212, 201, 198}, {215, 203, 201}, {217, 206, 204}, {219, 208, 206}, {221, 211, 209}, {223, 214, 212},
    {225, 216, 214}, {227, 219, 217}, {228, 221, 220}, {231, 224, 222}, {232, 226, 225}, {235, 229, 228},
    {237, 231, 230}, {239, 234, 233}, {241, 237, 236}, {243, 239, 238}, {244, 242, 241}, {247, 244, 244},
    {249, 247, 246}, {251, 249, 249}, {253, 252, 252}, {255, 255, 255}
};

unsigned char m_turboSrgbBytes[256][3] = {
    {48, 18, 59},   {50, 21, 67},   {51, 24, 74},   {52, 27, 81},   {53, 30, 88},   {54, 33, 95},    {55, 36, 102},
    {56, 39, 109},  {57, 42, 115},  {58, 45, 121},  {59, 47, 128},  {60, 50, 134},  {61, 53, 139},   {62, 56, 145},
    {63, 59, 151},  {63, 62, 156},  {64, 64, 162},  {65, 67, 167},  {65, 70, 172},  {66, 73, 177},   {66, 75, 181},
    {67, 78, 186},  {68, 81, 191},  {68, 84, 195},  {68, 86, 199},  {69, 89, 203},  {69, 92, 207},   {69, 94, 211},
    {70, 97, 214},  {70, 100, 218}, {70, 102, 221}, {70, 105, 224}, {70, 107, 227}, {71, 110, 230},  {71, 113, 233},
    {71, 115, 235}, {71, 118, 238}, {71, 120, 240}, {71, 123, 242}, {70, 125, 244}, {70, 128, 246},  {70, 130, 248},
    {70, 133, 250}, {70, 135, 251}, {69, 138, 252}, {69, 140, 253}, {68, 143, 254}, {67, 145, 254},  {66, 148, 255},
    {65, 150, 255}, {64, 153, 255}, {62, 155, 254}, {61, 158, 254}, {59, 160, 253}, {58, 163, 252},  {56, 165, 251},
    {55, 168, 250}, {53, 171, 248}, {51, 173, 247}, {49, 175, 245}, {47, 178, 244}, {46, 180, 242},  {44, 183, 240},
    {42, 185, 238}, {40, 188, 235}, {39, 190, 233}, {37, 192, 231}, {35, 195, 228}, {34, 197, 226},  {32, 199, 223},
    {31, 201, 221}, {30, 203, 218}, {28, 205, 216}, {27, 208, 213}, {26, 210, 210}, {26, 212, 208},  {25, 213, 205},
    {24, 215, 202}, {24, 217, 200}, {24, 219, 197}, {24, 221, 194}, {24, 222, 192}, {24, 224, 189},  {25, 226, 187},
    {25, 227, 185}, {26, 228, 182}, {28, 230, 180}, {29, 231, 178}, {31, 233, 175}, {32, 234, 172},  {34, 235, 170},
    {37, 236, 167}, {39, 238, 164}, {42, 239, 161}, {44, 240, 158}, {47, 241, 155}, {50, 242, 152},  {53, 243, 148},
    {56, 244, 145}, {60, 245, 142}, {63, 246, 138}, {67, 247, 135}, {70, 248, 132}, {74, 248, 128},  {78, 249, 125},
    {82, 250, 122}, {85, 250, 118}, {89, 251, 115}, {93, 252, 111}, {97, 252, 108}, {101, 253, 105}, {105, 253, 102},
    {109, 254, 98}, {113, 254, 95}, {117, 254, 92}, {121, 254, 89}, {125, 255, 86}, {128, 255, 83},  {132, 255, 81},
    {136, 255, 78}, {139, 255, 75}, {143, 255, 73}, {146, 255, 71}, {150, 254, 68}, {153, 254, 66},  {156, 254, 64},
    {159, 253, 63}, {161, 253, 61}, {164, 252, 60}, {167, 252, 58}, {169, 251, 57}, {172, 251, 56},  {175, 250, 55},
    {177, 249, 54}, {180, 248, 54}, {183, 247, 53}, {185, 246, 53}, {188, 245, 52}, {190, 244, 52},  {193, 243, 52},
    {195, 241, 52}, {198, 240, 52}, {200, 239, 52}, {203, 237, 52}, {205, 236, 52}, {208, 234, 52},  {210, 233, 53},
    {212, 231, 53}, {215, 229, 53}, {217, 228, 54}, {219, 226, 54}, {221, 224, 55}, {223, 223, 55},  {225, 221, 55},
    {227, 219, 56}, {229, 217, 56}, {231, 215, 57}, {233, 213, 57}, {235, 211, 57}, {236, 209, 58},  {238, 207, 58},
    {239, 205, 58}, {241, 203, 58}, {242, 201, 58}, {244, 199, 58}, {245, 197, 58}, {246, 195, 58},  {247, 193, 58},
    {248, 190, 57}, {249, 188, 57}, {250, 186, 57}, {251, 184, 56}, {251, 182, 55}, {252, 179, 54},  {252, 177, 54},
    {253, 174, 53}, {253, 172, 52}, {254, 169, 51}, {254, 167, 50}, {254, 164, 49}, {254, 161, 48},  {254, 158, 47},
    {254, 155, 45}, {254, 153, 44}, {254, 150, 43}, {254, 147, 42}, {254, 144, 41}, {253, 141, 39},  {253, 138, 38},
    {252, 135, 37}, {252, 132, 35}, {251, 129, 34}, {251, 126, 33}, {250, 123, 31}, {249, 120, 30},  {249, 117, 29},
    {248, 114, 28}, {247, 111, 26}, {246, 108, 25}, {245, 105, 24}, {244, 102, 23}, {243, 99, 21},   {242, 96, 20},
    {241, 93, 19},  {240, 91, 18},  {239, 88, 17},  {237, 85, 16},  {236, 83, 15},  {235, 80, 14},   {234, 78, 13},
    {232, 75, 12},  {231, 73, 12},  {229, 71, 11},  {228, 69, 10},  {226, 67, 10},  {225, 65, 9},    {223, 63, 8},
    {221, 61, 8},   {220, 59, 7},   {218, 57, 7},   {216, 55, 6},   {214, 53, 6},   {212, 51, 5},    {210, 49, 5},
    {208, 47, 5},   {206, 45, 4},   {204, 43, 4},   {202, 42, 4},   {200, 40, 3},   {197, 38, 3},    {195, 37, 3},
    {193, 35, 2},   {190, 33, 2},   {188, 32, 2},   {185, 30, 2},   {183, 29, 2},   {180, 27, 1},    {178, 26, 1},
    {175, 24, 1},   {172, 23, 1},   {169, 22, 1},   {167, 20, 1},   {164, 19, 1},   {161, 18, 1},    {158, 16, 1},
    {155, 15, 1},   {152, 14, 1},   {149, 13, 1},   {146, 11, 1},   {142, 10, 1},   {139, 9, 2},     {136, 8, 2},
    {133, 7, 2},    {129, 6, 2},    {126, 5, 2},    {122, 4, 3}
};

unsigned char m_twilightSrgbBytes[256][3] = {
    {225, 216, 226}, {224, 217, 226}, {223, 217, 225}, {222, 217, 224}, {221, 217, 224}, {219, 216, 223},
    {217, 216, 222}, {216, 215, 221}, {214, 214, 220}, {212, 214, 219}, {210, 213, 218}, {207, 212, 217},
    {205, 210, 216}, {202, 209, 215}, {199, 208, 214}, {197, 207, 212}, {194, 205, 211}, {191, 204, 210},
    {188, 202, 209}, {185, 201, 208}, {182, 199, 207}, {179, 198, 206}, {176, 196, 205}, {173, 195, 204},
    {170, 193, 203}, {167, 192, 202}, {164, 190, 202}, {161, 188, 201}, {158, 187, 200}, {155, 185, 200},
    {152, 183, 199}, {150, 181, 198}, {147, 180, 198}, {146, 179, 198}, {142, 176, 197}, {139, 174, 197},
    {137, 172, 196}, {136, 171, 196}, {132, 169, 195}, {130, 167, 195}, {128, 165, 195}, {127, 164, 194},
    {124, 161, 194}, {122, 159, 194}, {120, 157, 193}, {119, 156, 193}, {116, 154, 193}, {115, 152, 192},
    {113, 150, 192}, {112, 149, 192}, {110, 146, 191}, {109, 144, 191}, {107, 142, 191}, {107, 141, 191},
    {105, 137, 190}, {104, 135, 190}, {103, 133, 189}, {102, 132, 189}, {101, 129, 189}, {100, 127, 188},
    {100, 125, 188}, {99, 124, 187},  {98, 120, 187},  {98, 118, 186},  {97, 116, 186},  {97, 114, 185},
    {97, 113, 185},  {96, 109, 184},  {96, 107, 183},  {95, 105, 182},  {95, 103, 182},  {95, 100, 181},
    {95, 98, 180},   {95, 96, 179},   {95, 94, 179},   {94, 91, 177},   {94, 89, 176},   {94, 86, 175},
    {94, 84, 174},   {94, 81, 173},   {94, 79, 172},   {94, 77, 170},   {94, 75, 170},   {93, 72, 167},
    {93, 69, 166},   {93, 67, 164},   {93, 64, 163},   {93, 62, 161},   {92, 60, 159},   {92, 57, 157},
    {92, 56, 156},   {91, 52, 153},   {91, 50, 151},   {90, 48, 149},   {90, 45, 146},   {89, 43, 144},
    {89, 41, 141},   {88, 39, 139},   {87, 37, 137},   {86, 34, 133},   {85, 33, 130},   {84, 31, 127},
    {83, 29, 124},   {82, 27, 120},   {80, 26, 117},   {79, 25, 114},   {78, 24, 112},   {76, 22, 107},
    {74, 21, 103},   {73, 21, 100},   {71, 20, 96},    {69, 19, 93},    {68, 18, 90},    {66, 18, 87},
    {65, 18, 85},    {62, 17, 81},    {61, 17, 78},    {59, 17, 75},    {58, 16, 72},    {56, 16, 70},
    {55, 16, 67},    {54, 16, 65},    {53, 16, 64},    {51, 17, 61},    {50, 17, 59},    {50, 17, 58},
    {48, 18, 56},    {47, 19, 55},    {47, 19, 54},    {49, 18, 54},    {50, 18, 55},    {51, 17, 55},
    {52, 17, 55},    {54, 17, 56},    {55, 17, 57},    {57, 17, 57},    {59, 17, 58},    {61, 17, 59},
    {63, 17, 60},    {65, 17, 61},    {67, 18, 62},    {69, 18, 63},    {71, 18, 64},    {74, 19, 65},
    {76, 19, 66},    {79, 20, 67},    {81, 20, 68},    {84, 21, 69},    {85, 21, 70},    {89, 22, 71},
    {92, 22, 72},    {94, 23, 73},    {97, 24, 74},    {99, 24, 75},    {102, 25, 76},   {105, 26, 76},
    {107, 26, 77},   {110, 27, 78},   {113, 28, 78},   {115, 29, 78},   {118, 30, 79},   {120, 31, 79},
    {123, 32, 79},   {125, 33, 80},   {127, 34, 80},   {130, 36, 80},   {132, 37, 80},   {135, 39, 80},
    {137, 40, 80},   {139, 42, 80},   {141, 44, 80},   {144, 45, 80},   {146, 47, 79},   {148, 49, 79},
    {150, 50, 79},   {152, 52, 79},   {154, 54, 79},   {155, 56, 79},   {157, 58, 79},   {159, 60, 79},
    {160, 61, 79},   {162, 64, 79},   {164, 66, 79},   {166, 68, 79},   {167, 70, 79},   {169, 73, 80},
    {170, 75, 80},   {172, 77, 80},   {173, 79, 80},   {175, 81, 81},   {176, 84, 81},   {178, 86, 82},
    {179, 88, 82},   {180, 90, 83},   {181, 93, 83},   {182, 95, 84},   {183, 96, 84},   {185, 100, 86},
    {186, 102, 87},  {187, 104, 87},  {188, 107, 89},  {189, 109, 90},  {190, 112, 91},  {191, 114, 92},
    {192, 116, 93},  {192, 119, 95},  {193, 121, 96},  {194, 124, 98},  {195, 126, 100}, {195, 129, 102},
    {196, 131, 104}, {197, 134, 106}, {197, 135, 107}, {198, 139, 110}, {199, 141, 112}, {199, 143, 114},
    {200, 146, 117}, {200, 148, 120}, {201, 151, 122}, {201, 153, 125}, {202, 156, 128}, {202, 158, 131},
    {203, 161, 133}, {204, 163, 137}, {204, 165, 140}, {205, 168, 143}, {205, 170, 146}, {206, 172, 149},
    {206, 174, 151}, {207, 177, 156}, {208, 179, 159}, {209, 182, 163}, {210, 184, 166}, {211, 186, 169},
    {211, 188, 173}, {212, 190, 176}, {213, 192, 180}, {214, 194, 183}, {215, 196, 187}, {216, 198, 190},
    {217, 200, 193}, {218, 202, 196}, {219, 204, 200}, {219, 206, 203}, {220, 206, 204}, {221, 209, 208},
    {222, 210, 211}, {222, 211, 213}, {223, 213, 215}, {223, 214, 217}, {224, 214, 219}, {224, 215, 221},
    {225, 216, 222}, {225, 216, 223}, {225, 216, 225}, {225, 216, 225}
};

unsigned char m_twilightShiftedSrgbBytes[256][3] = {
    {47, 19, 55},    {48, 18, 56},    {50, 17, 58},    {50, 17, 59},    {51, 17, 61},    {52, 16, 63},
    {54, 16, 65},    {55, 16, 67},    {56, 16, 70},    {58, 16, 72},    {59, 17, 75},    {61, 17, 78},
    {62, 17, 81},    {64, 17, 84},    {66, 18, 87},    {68, 18, 90},    {69, 19, 93},    {71, 20, 96},
    {73, 21, 100},   {74, 21, 103},   {76, 22, 107},   {77, 23, 110},   {79, 25, 114},   {80, 26, 117},
    {82, 27, 120},   {83, 29, 124},   {84, 31, 127},   {85, 33, 130},   {86, 34, 133},   {87, 36, 136},
    {88, 39, 139},   {89, 41, 141},   {89, 43, 144},   {90, 44, 145},   {90, 48, 149},   {91, 50, 151},
    {91, 52, 153},   {92, 53, 154},   {92, 57, 157},   {92, 60, 159},   {93, 62, 161},   {93, 63, 162},
    {93, 67, 164},   {93, 69, 166},   {93, 72, 167},   {93, 73, 168},   {94, 77, 170},   {94, 79, 172},
    {94, 81, 173},   {94, 83, 173},   {94, 86, 175},   {94, 89, 176},   {94, 91, 177},   {94, 92, 178},
    {95, 96, 179},   {95, 98, 180},   {95, 100, 181},  {95, 101, 181},  {95, 105, 182},  {96, 107, 183},
    {96, 109, 184},  {96, 110, 184},  {97, 114, 185},  {97, 116, 186},  {98, 118, 186},  {98, 120, 187},
    {99, 122, 187},  {100, 125, 188}, {100, 127, 188}, {101, 129, 189}, {102, 131, 189}, {103, 133, 189},
    {104, 135, 190}, {105, 137, 190}, {106, 138, 190}, {107, 142, 191}, {109, 144, 191}, {110, 146, 191},
    {111, 148, 192}, {113, 150, 192}, {115, 152, 192}, {116, 154, 193}, {117, 154, 193}, {120, 157, 193},
    {122, 159, 194}, {124, 161, 194}, {126, 163, 194}, {128, 165, 195}, {130, 167, 195}, {132, 169, 195},
    {133, 170, 196}, {137, 172, 196}, {139, 174, 197}, {142, 176, 197}, {144, 178, 197}, {147, 180, 198},
    {150, 181, 198}, {152, 183, 199}, {154, 184, 199}, {158, 187, 200}, {161, 188, 201}, {164, 190, 202},
    {167, 192, 202}, {170, 193, 203}, {173, 195, 204}, {176, 196, 205}, {177, 197, 205}, {182, 199, 207},
    {185, 201, 208}, {188, 202, 209}, {191, 204, 210}, {194, 205, 211}, {197, 207, 212}, {199, 208, 214},
    {201, 209, 214}, {205, 210, 216}, {207, 212, 217}, {210, 213, 218}, {212, 214, 219}, {214, 214, 220},
    {216, 215, 221}, {217, 216, 222}, {218, 216, 222}, {221, 217, 224}, {222, 217, 224}, {223, 217, 225},
    {224, 217, 226}, {225, 216, 226}, {225, 216, 225}, {225, 216, 223}, {225, 216, 222}, {224, 215, 221},
    {224, 215, 220}, {223, 214, 217}, {223, 213, 215}, {222, 211, 213}, {222, 210, 211}, {221, 209, 208},
    {220, 207, 205}, {219, 206, 203}, {219, 204, 200}, {218, 202, 196}, {217, 200, 193}, {216, 198, 190},
    {215, 196, 187}, {214, 194, 183}, {213, 192, 180}, {212, 190, 176}, {212, 189, 175}, {211, 186, 169},
    {210, 184, 166}, {209, 182, 163}, {208, 179, 159}, {207, 177, 156}, {207, 175, 153}, {206, 172, 149},
    {205, 170, 146}, {205, 168, 143}, {204, 165, 140}, {204, 163, 137}, {203, 161, 133}, {202, 158, 131},
    {202, 156, 128}, {201, 153, 125}, {201, 152, 123}, {200, 148, 120}, {200, 146, 117}, {199, 143, 114},
    {199, 141, 112}, {198, 139, 110}, {197, 136, 108}, {197, 134, 106}, {196, 131, 104}, {195, 129, 102},
    {195, 126, 100}, {194, 124, 98},  {193, 121, 96},  {192, 119, 95},  {192, 116, 93},  {191, 114, 92},
    {190, 113, 91},  {189, 109, 90},  {188, 107, 89},  {187, 104, 87},  {186, 102, 87},  {185, 100, 86},
    {184, 97, 85},   {182, 95, 84},   {181, 93, 83},   {180, 90, 83},   {179, 88, 82},   {178, 86, 82},
    {176, 84, 81},   {175, 81, 81},   {173, 79, 80},   {172, 77, 80},   {171, 76, 80},   {169, 73, 80},
    {167, 70, 79},   {166, 68, 79},   {164, 66, 79},   {162, 64, 79},   {161, 62, 79},   {159, 60, 79},
    {157, 58, 79},   {155, 56, 79},   {154, 54, 79},   {152, 52, 79},   {150, 50, 79},   {148, 49, 79},
    {146, 47, 79},   {144, 45, 80},   {143, 44, 80},   {139, 42, 80},   {137, 40, 80},   {135, 39, 80},
    {132, 37, 80},   {130, 36, 80},   {128, 35, 80},   {125, 33, 80},   {123, 32, 79},   {120, 31, 79},
    {118, 30, 79},   {115, 29, 78},   {113, 28, 78},   {110, 27, 78},   {107, 26, 77},   {105, 26, 76},
    {103, 25, 76},   {99, 24, 75},    {97, 24, 74},    {94, 23, 73},    {92, 22, 72},    {89, 22, 71},
    {86, 21, 70},    {84, 21, 69},    {81, 20, 68},    {79, 20, 67},    {76, 19, 66},    {74, 19, 65},
    {71, 18, 64},    {69, 18, 63},    {67, 18, 62},    {65, 17, 61},    {64, 17, 60},    {61, 17, 59},
    {59, 17, 58},    {57, 17, 57},    {55, 17, 57},    {54, 17, 56},    {53, 17, 56},    {51, 17, 55},
    {50, 18, 55},    {49, 18, 54},    {47, 19, 54},    {47, 20, 54}
};

unsigned char m_viridisSrgbBytes[256][3] = {
    {68, 1, 84},    {68, 2, 85},    {68, 3, 87},    {69, 5, 88},    {69, 6, 90},    {69, 8, 91},    {70, 9, 92},
    {70, 11, 94},   {70, 12, 95},   {70, 14, 97},   {71, 15, 98},   {71, 17, 99},   {71, 18, 101},  {71, 20, 102},
    {71, 21, 103},  {71, 22, 105},  {71, 24, 106},  {72, 25, 107},  {72, 26, 108},  {72, 28, 110},  {72, 29, 111},
    {72, 30, 112},  {72, 32, 113},  {72, 33, 114},  {72, 34, 115},  {72, 35, 116},  {71, 37, 117},  {71, 38, 118},
    {71, 39, 119},  {71, 40, 120},  {71, 42, 121},  {71, 43, 122},  {71, 44, 123},  {70, 45, 124},  {70, 47, 124},
    {70, 48, 125},  {70, 49, 126},  {69, 50, 127},  {69, 52, 127},  {69, 53, 128},  {69, 54, 129},  {68, 55, 129},
    {68, 57, 130},  {67, 58, 131},  {67, 59, 131},  {67, 60, 132},  {66, 61, 132},  {66, 62, 133},  {66, 64, 133},
    {65, 65, 134},  {65, 66, 134},  {64, 67, 135},  {64, 68, 135},  {63, 69, 135},  {63, 71, 136},  {62, 72, 136},
    {62, 73, 137},  {61, 74, 137},  {61, 75, 137},  {61, 76, 137},  {60, 77, 138},  {60, 78, 138},  {59, 80, 138},
    {59, 81, 138},  {58, 82, 139},  {58, 83, 139},  {57, 84, 139},  {57, 85, 139},  {56, 86, 139},  {56, 87, 140},
    {55, 88, 140},  {55, 89, 140},  {54, 90, 140},  {54, 91, 140},  {53, 92, 140},  {53, 93, 140},  {52, 94, 141},
    {52, 95, 141},  {51, 96, 141},  {51, 97, 141},  {50, 98, 141},  {50, 99, 141},  {49, 100, 141}, {49, 101, 141},
    {49, 102, 141}, {48, 103, 141}, {48, 104, 141}, {47, 105, 141}, {47, 106, 141}, {46, 107, 142}, {46, 108, 142},
    {46, 109, 142}, {45, 110, 142}, {45, 111, 142}, {44, 112, 142}, {44, 113, 142}, {44, 114, 142}, {43, 115, 142},
    {43, 116, 142}, {42, 117, 142}, {42, 118, 142}, {42, 119, 142}, {41, 120, 142}, {41, 121, 142}, {40, 122, 142},
    {40, 122, 142}, {40, 123, 142}, {39, 124, 142}, {39, 125, 142}, {39, 126, 142}, {38, 127, 142}, {38, 128, 142},
    {38, 129, 142}, {37, 130, 142}, {37, 131, 141}, {36, 132, 141}, {36, 133, 141}, {36, 134, 141}, {35, 135, 141},
    {35, 136, 141}, {35, 137, 141}, {34, 137, 141}, {34, 138, 141}, {34, 139, 141}, {33, 140, 141}, {33, 141, 140},
    {33, 142, 140}, {32, 143, 140}, {32, 144, 140}, {32, 145, 140}, {31, 146, 140}, {31, 147, 139}, {31, 148, 139},
    {31, 149, 139}, {31, 150, 139}, {30, 151, 138}, {30, 152, 138}, {30, 153, 138}, {30, 153, 138}, {30, 154, 137},
    {30, 155, 137}, {30, 156, 137}, {30, 157, 136}, {30, 158, 136}, {30, 159, 136}, {30, 160, 135}, {31, 161, 135},
    {31, 162, 134}, {31, 163, 134}, {32, 164, 133}, {32, 165, 133}, {33, 166, 133}, {33, 167, 132}, {34, 167, 132},
    {35, 168, 131}, {35, 169, 130}, {36, 170, 130}, {37, 171, 129}, {38, 172, 129}, {39, 173, 128}, {40, 174, 127},
    {41, 175, 127}, {42, 176, 126}, {43, 177, 125}, {44, 177, 125}, {46, 178, 124}, {47, 179, 123}, {48, 180, 122},
    {50, 181, 122}, {51, 182, 121}, {53, 183, 120}, {54, 184, 119}, {56, 185, 118}, {57, 185, 118}, {59, 186, 117},
    {61, 187, 116}, {62, 188, 115}, {64, 189, 114}, {66, 190, 113}, {68, 190, 112}, {69, 191, 111}, {71, 192, 110},
    {73, 193, 109}, {75, 194, 108}, {77, 194, 107}, {79, 195, 105}, {81, 196, 104}, {83, 197, 103}, {85, 198, 102},
    {87, 198, 101}, {89, 199, 100}, {91, 200, 98},  {94, 201, 97},  {96, 201, 96},  {98, 202, 95},  {100, 203, 93},
    {103, 204, 92}, {105, 204, 91}, {107, 205, 89}, {109, 206, 88}, {112, 206, 86}, {114, 207, 85}, {116, 208, 84},
    {119, 208, 82}, {121, 209, 81}, {124, 210, 79}, {126, 210, 78}, {129, 211, 76}, {131, 211, 75}, {134, 212, 73},
    {136, 213, 71}, {139, 213, 70}, {141, 214, 68}, {144, 214, 67}, {146, 215, 65}, {149, 215, 63}, {151, 216, 62},
    {154, 216, 60}, {157, 217, 58}, {159, 217, 56}, {162, 218, 55}, {165, 218, 53}, {167, 219, 51}, {170, 219, 50},
    {173, 220, 48}, {175, 220, 46}, {178, 221, 44}, {181, 221, 43}, {183, 221, 41}, {186, 222, 39}, {189, 222, 38},
    {191, 223, 36}, {194, 223, 34}, {197, 223, 33}, {199, 224, 31}, {202, 224, 30}, {205, 224, 29}, {207, 225, 28},
    {210, 225, 27}, {212, 225, 26}, {215, 226, 25}, {218, 226, 24}, {220, 226, 24}, {223, 227, 24}, {225, 227, 24},
    {228, 227, 24}, {231, 228, 25}, {233, 228, 25}, {236, 228, 26}, {238, 229, 27}, {241, 229, 28}, {243, 229, 30},
    {246, 230, 31}, {248, 230, 33}, {250, 230, 34}, {253, 231, 36}
};

unsigned char m_winterSrgbBytes[256][3] = {
    {0, 0, 255},   {0, 1, 254},   {0, 2, 254},   {0, 3, 253},   {0, 4, 253},   {0, 5, 252},   {0, 6, 252},
    {0, 7, 251},   {0, 8, 251},   {0, 9, 250},   {0, 10, 250},  {0, 11, 249},  {0, 12, 249},  {0, 13, 248},
    {0, 14, 248},  {0, 15, 247},  {0, 16, 247},  {0, 17, 246},  {0, 18, 246},  {0, 19, 245},  {0, 20, 245},
    {0, 21, 244},  {0, 22, 244},  {0, 23, 243},  {0, 24, 243},  {0, 25, 242},  {0, 26, 242},  {0, 27, 241},
    {0, 28, 241},  {0, 29, 240},  {0, 30, 240},  {0, 31, 239},  {0, 32, 239},  {0, 32, 238},  {0, 34, 238},
    {0, 35, 237},  {0, 36, 237},  {0, 36, 236},  {0, 38, 236},  {0, 39, 235},  {0, 40, 235},  {0, 40, 234},
    {0, 42, 234},  {0, 43, 233},  {0, 44, 233},  {0, 44, 232},  {0, 46, 232},  {0, 47, 231},  {0, 48, 231},
    {0, 48, 230},  {0, 50, 230},  {0, 51, 229},  {0, 52, 229},  {0, 52, 228},  {0, 54, 228},  {0, 55, 227},
    {0, 56, 227},  {0, 56, 226},  {0, 58, 226},  {0, 59, 225},  {0, 60, 225},  {0, 60, 224},  {0, 62, 224},
    {0, 63, 223},  {0, 64, 223},  {0, 65, 222},  {0, 65, 222},  {0, 67, 221},  {0, 68, 221},  {0, 69, 220},
    {0, 70, 220},  {0, 71, 219},  {0, 72, 219},  {0, 73, 218},  {0, 73, 218},  {0, 75, 217},  {0, 76, 217},
    {0, 77, 216},  {0, 78, 216},  {0, 79, 215},  {0, 80, 215},  {0, 81, 214},  {0, 81, 214},  {0, 83, 213},
    {0, 84, 213},  {0, 85, 212},  {0, 86, 211},  {0, 87, 211},  {0, 88, 211},  {0, 89, 210},  {0, 89, 210},
    {0, 91, 209},  {0, 92, 209},  {0, 93, 208},  {0, 94, 208},  {0, 95, 207},  {0, 96, 207},  {0, 97, 206},
    {0, 97, 206},  {0, 99, 205},  {0, 100, 205}, {0, 101, 204}, {0, 102, 204}, {0, 103, 203}, {0, 104, 203},
    {0, 105, 202}, {0, 105, 202}, {0, 107, 201}, {0, 108, 201}, {0, 109, 200}, {0, 110, 200}, {0, 111, 199},
    {0, 112, 199}, {0, 113, 198}, {0, 113, 198}, {0, 115, 197}, {0, 116, 197}, {0, 117, 196}, {0, 118, 195},
    {0, 119, 195}, {0, 120, 195}, {0, 121, 194}, {0, 121, 194}, {0, 123, 193}, {0, 124, 193}, {0, 125, 192},
    {0, 126, 192}, {0, 127, 191}, {0, 128, 191}, {0, 129, 190}, {0, 130, 190}, {0, 131, 189}, {0, 131, 189},
    {0, 133, 188}, {0, 134, 188}, {0, 135, 187}, {0, 136, 187}, {0, 137, 186}, {0, 138, 186}, {0, 139, 185},
    {0, 140, 185}, {0, 141, 184}, {0, 142, 184}, {0, 143, 183}, {0, 144, 183}, {0, 145, 182}, {0, 146, 182},
    {0, 147, 181}, {0, 147, 181}, {0, 149, 180}, {0, 150, 179}, {0, 151, 179}, {0, 152, 179}, {0, 153, 178},
    {0, 154, 178}, {0, 155, 177}, {0, 156, 177}, {0, 157, 176}, {0, 158, 176}, {0, 159, 175}, {0, 160, 175},
    {0, 161, 174}, {0, 162, 174}, {0, 163, 173}, {0, 163, 173}, {0, 165, 172}, {0, 166, 172}, {0, 167, 171},
    {0, 168, 171}, {0, 169, 170}, {0, 170, 170}, {0, 171, 169}, {0, 172, 169}, {0, 173, 168}, {0, 174, 168},
    {0, 175, 167}, {0, 176, 167}, {0, 177, 166}, {0, 178, 166}, {0, 179, 165}, {0, 179, 165}, {0, 181, 164},
    {0, 182, 163}, {0, 183, 163}, {0, 184, 163}, {0, 185, 162}, {0, 186, 162}, {0, 187, 161}, {0, 188, 161},
    {0, 189, 160}, {0, 190, 160}, {0, 191, 159}, {0, 192, 159}, {0, 193, 158}, {0, 194, 158}, {0, 195, 157},
    {0, 195, 157}, {0, 197, 156}, {0, 198, 156}, {0, 199, 155}, {0, 200, 155}, {0, 201, 154}, {0, 202, 154},
    {0, 203, 153}, {0, 204, 153}, {0, 205, 152}, {0, 206, 152}, {0, 207, 151}, {0, 208, 151}, {0, 209, 150},
    {0, 210, 150}, {0, 211, 149}, {0, 211, 149}, {0, 213, 148}, {0, 214, 147}, {0, 215, 147}, {0, 216, 147},
    {0, 217, 146}, {0, 218, 146}, {0, 219, 145}, {0, 220, 145}, {0, 221, 144}, {0, 222, 144}, {0, 223, 143},
    {0, 224, 143}, {0, 225, 142}, {0, 226, 142}, {0, 227, 141}, {0, 227, 141}, {0, 229, 140}, {0, 230, 140},
    {0, 231, 139}, {0, 232, 139}, {0, 233, 138}, {0, 234, 138}, {0, 235, 137}, {0, 236, 137}, {0, 237, 136},
    {0, 238, 136}, {0, 239, 135}, {0, 240, 135}, {0, 241, 134}, {0, 242, 134}, {0, 243, 133}, {0, 243, 133},
    {0, 245, 132}, {0, 246, 131}, {0, 247, 131}, {0, 248, 131}, {0, 249, 130}, {0, 250, 130}, {0, 251, 129},
    {0, 252, 129}, {0, 253, 128}, {0, 254, 128}, {0, 255, 127}
};
}

BEGIN_VISP_NAMESPACE
/*!
  Creates a colormap class to be able to recolor an image with different grayscale values
  into some corresponding color values, for better visualization for example.

  \note The different colormap types come from the
  <a href="https://matplotlib.org/stable/tutorials/colors/colormaps.html">Matplotlib library</a>.

  \param [in] colormapType : Colormap family.
*/
vpColormap::vpColormap(const vpColormapType &colormapType) : m_colormapType(colormapType)
{
  for (unsigned int i = 0; i < 256; i++) {
    for (unsigned int j = 0; j < 3; j++) {
      switch (m_colormapType) {
      case COLORMAP_AUTUMN:
        m_colormapSrgbBytes[i][j] = m_autumnSrgbBytes[i][j];
        break;
      case COLORMAP_CIVIDIS:
        m_colormapSrgbBytes[i][j] = m_cividisSrgbBytes[i][j];
        break;
      case COLORMAP_COOL:
        m_colormapSrgbBytes[i][j] = m_coolSrgbBytes[i][j];
        break;
      case COLORMAP_GIST_EARTH:
        m_colormapSrgbBytes[i][j] = m_gistEarthSrgbBytes[i][j];
        break;
      case COLORMAP_GNUPLOT:
        m_colormapSrgbBytes[i][j] = m_gnuplotSrgbBytes[i][j];
        break;
      case COLORMAP_GNUPLOT2:
        m_colormapSrgbBytes[i][j] = m_gnuplot2SrgbBytes[i][j];
        break;
      case COLORMAP_HOT:
        m_colormapSrgbBytes[i][j] = m_hotSrgbBytes[i][j];
        break;
      case COLORMAP_HSV:
        m_colormapSrgbBytes[i][j] = m_hsvSrgbBytes[i][j];
        break;
      case COLORMAP_INFERNO:
        m_colormapSrgbBytes[i][j] = m_infernoSrgbBytes[i][j];
        break;
      case COLORMAP_JET:
        m_colormapSrgbBytes[i][j] = m_jetSrgbBytes[i][j];
        break;
      case COLORMAP_MAGMA:
        m_colormapSrgbBytes[i][j] = m_magmaSrgbBytes[i][j];
        break;
      case COLORMAP_OCEAN:
        m_colormapSrgbBytes[i][j] = m_oceanSrgbBytes[i][j];
        break;
      case COLORMAP_PLASMA:
        m_colormapSrgbBytes[i][j] = m_plasmaSrgbBytes[i][j];
        break;
      case COLORMAP_RAINBOW:
        m_colormapSrgbBytes[i][j] = m_rainbowSrgbBytes[i][j];
        break;
      case COLORMAP_SPRING:
        m_colormapSrgbBytes[i][j] = m_springSrgbBytes[i][j];
        break;
      case COLORMAP_SUMMER:
        m_colormapSrgbBytes[i][j] = m_summerSrgbBytes[i][j];
        break;
      case COLORMAP_TERRAIN:
        m_colormapSrgbBytes[i][j] = m_terrainSrgbBytes[i][j];
        break;
      case COLORMAP_TURBO:
        m_colormapSrgbBytes[i][j] = m_turboSrgbBytes[i][j];
        break;
      case COLORMAP_TWILIGHT:
        m_colormapSrgbBytes[i][j] = m_twilightSrgbBytes[i][j];
        break;
      case COLORMAP_TWILIGHT_SHIFTED:
        m_colormapSrgbBytes[i][j] = m_twilightShiftedSrgbBytes[i][j];
        break;
      case COLORMAP_VIRIDIS:
        m_colormapSrgbBytes[i][j] = m_viridisSrgbBytes[i][j];
        break;
      case COLORMAP_WINTER:
        m_colormapSrgbBytes[i][j] = m_winterSrgbBytes[i][j];
        break;
      default: {
        throw(vpException(vpException::fatalError, "Unsupported colormap in vpColormap constructor"));
      }
      }
    }
  }
}

/*!
  Apply a colormap to a 8-bit grayscale image:
    - if normalize is set to true, the min, max values are first extracted from \p I
    - the different values are remapped into the [0 - 255] range,
    - the colormap is applied on these unsigned char values,
    - otherwise, the grayscale values are directly mapped using the colormap.

  \param[in] I : The 8-bit grayscale image on which the colormap will be apply.
  \param[out] Icolor : Colorized image.
  \param[in] normalize : If true, normalization into the [0 - 255] range is applied,
                         otherwise the grayscale values are directly mapped.
 */
void vpColormap::convert(const vpImage<unsigned char> &I, vpImage<vpRGBa> &Icolor, bool normalize)
{
  Icolor.resize(I.getHeight(), I.getWidth());
  if (normalize) {
    unsigned char minVal = 0, maxVal = 1;
    I.getMinMaxValue(minVal, maxVal);

    // convert to 256 grayscale values
    float a = 255.0f / (maxVal - minVal);
    float b = -255.0f * minVal / (maxVal - minVal);
    vpImage<unsigned char> Inorm(I.getHeight(), I.getWidth());
    for (unsigned int i = 0; i < I.getHeight(); i++) {
      for (unsigned int j = 0; j < I.getWidth(); j++) {
        Inorm[i][j] = static_cast<unsigned char>(a * I[i][j] + b);
      }
    }

    for (unsigned int i = 0; i < Icolor.getHeight(); i++) {
      for (unsigned int j = 0; j < Icolor.getWidth(); j++) {
        const unsigned char gray = Inorm[i][j];
        Icolor[i][j] = vpRGBa(m_colormapSrgbBytes[gray][0], m_colormapSrgbBytes[gray][1], m_colormapSrgbBytes[gray][2]);
      }
    }
  }
  else {
    for (unsigned int i = 0; i < Icolor.getHeight(); i++) {
      for (unsigned int j = 0; j < Icolor.getWidth(); j++) {
        const unsigned char gray = I[i][j];
        Icolor[i][j] = vpRGBa(m_colormapSrgbBytes[gray][0], m_colormapSrgbBytes[gray][1], m_colormapSrgbBytes[gray][2]);
      }
    }
  }
}

/*!
  Apply a colormap to a 8-bit RGB image:
    - the RGB values are first converted to grayscale values,
    - if normalize is set to true, the min, max values are then extracted from \p I
    - the different values are remapped into the [0 - 255] range,
    - the colormap is applied on these unsigned char values,
    - otherwise, the grayscale values are directly mapped using the colormap.

  \param[in] I : The 8-bit grayscale image on which the colormap will be apply.
  \param[out] Icolor : Colorized image.
  \param[in] normalize : If true, normalization into the [0 - 255] range is applied,
                         otherwise the grayscale values are directly mapped.
 */
void vpColormap::convert(const vpImage<vpRGBa> &I, vpImage<vpRGBa> &Icolor, bool normalize)
{
  vpImage<unsigned char> I_uchar(I.getHeight(), I.getWidth());
  for (unsigned int i = 0; i < I.getHeight(); i++) {
    for (unsigned int j = 0; j < I.getWidth(); j++) {
      I_uchar[i][j] = static_cast<unsigned char>(0.299f * I[i][j].R + 0.587f * I[i][j].G + 0.114f * I[i][j].B);
    }
  }
  convert(I_uchar, Icolor, normalize);
}

/*!
  Apply a colormap to a floating-point image:
    - the min, max values are first extracted from \p I
    - the different values are remapped into the [0 - 255] range,
    - the colormap is applied on these unsigned char values.

  \param[in] I : The float image on which the colormap will be apply.
  \param[out] Icolor : Colorized image.
 */
void vpColormap::convert(const vpImage<float> &I, vpImage<vpRGBa> &Icolor)
{
  float minVal = 0, maxVal = 1;
  I.getMinMaxValue(minVal, maxVal);

  // convert to 256 grayscale values
  float a = 255.0f / (maxVal - minVal);
  float b = -255 * minVal / (maxVal - minVal);
  vpImage<unsigned char> Inorm(I.getHeight(), I.getWidth());
  for (unsigned int i = 0; i < I.getHeight(); i++) {
    for (unsigned int j = 0; j < I.getWidth(); j++) {
      Inorm[i][j] = static_cast<unsigned char>(a * I[i][j] + b);
    }
  }

  Icolor.resize(I.getHeight(), I.getWidth());
  for (unsigned int i = 0; i < Icolor.getHeight(); i++) {
    for (unsigned int j = 0; j < Icolor.getWidth(); j++) {
      unsigned char gray = Inorm[i][j];
      Icolor[i][j] = vpRGBa(m_colormapSrgbBytes[gray][0], m_colormapSrgbBytes[gray][1], m_colormapSrgbBytes[gray][2]);
    }
  }
}

/*!
  Apply a colormap to a 3 channels floating-point image:
    - the RGB values are converted using the grayscale formula,
    - the min, max values are first extracted from \p I
    - the different values are remapped into the [0 - 255] range,
    - the colormap is applied on these unsigned char values.

  \param[in] I : The float image on which the colormap will be apply.
  \param[out] Icolor : Colorized image.
 */
void vpColormap::convert(const vpImage<vpRGBf> &I, vpImage<vpRGBa> &Icolor)
{
  vpImage<float> I_float(I.getHeight(), I.getWidth());
  for (unsigned int i = 0; i < I.getHeight(); i++) {
    for (unsigned int j = 0; j < I.getWidth(); j++) {
      I_float[i][j] = 0.299f * I[i][j].R + 0.587f * I[i][j].G + 0.114f * I[i][j].B;
    }
  }
  convert(I_float, Icolor);
}
END_VISP_NAMESPACE
