/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

/*
// https://github.com/opencv/opencv/blob/3e43d0cfca9753bcc4983f610b75d70c3f25f0cd/modules/objdetect/src/aruco/predefined_dictionaries.hpp
Copyright 2025 OpenCV

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <stdlib.h>
#include "tagAruco7x7_1000.h"

static uint64_t codedata[1000] = {
  0x0001baac5d5162e1UL,
  0x0001c8e27cd4152eUL,
  0x00013d145de29d73UL,
  0x00014b1b9832636fUL,
  0x00018dbfe4692816UL,
  0x0000b400b8763a44UL,
  0x0001a354fe10afbcUL,
  0x00007d2484df464bUL,
  0x0001100e227dcbbeUL,
  0x000173592cf9b4ebUL,
  0x0001e861290cc887UL,
  0x0000013a3c588d01UL,
  0x0000afa68d0c317fUL,
  0x0001395d039f0024UL,
  0x00017f88ffd665dcUL,
  0x0001989219ed0a4bUL,
  0x0001a7b216d788c6UL,
  0x00000744abb456fdUL,
  0x00004e75d9181f0cUL,
  0x000073ae5aca022eUL,
  0x000074b59b967411UL,
  0x00008edb92bcae44UL,
  0x000094c207d1df77UL,
  0x0000bbf812145973UL,
  0x0000ed6733178755UL,
  0x00012ae8d49b0c18UL,
  0x000130d13bc6d3e2UL,
  0x000146c8b01d76a0UL,
  0x000173f3dd0ca2d0UL,
  0x000195fc2a1b6ecfUL,
  0x0001a77e14cb72bdUL,
  0x0001e49a1d3e6c36UL,
  0x0001feeba1673de7UL,
  0x000072189774d725UL,
  0x0000c0b574f30a70UL,
  0x00001638d2c6ec7eUL,
  0x00001a702241e245UL,
  0x00002ced7821110bUL,
  0x000035638cb69586UL,
  0x000052d2122b1cf4UL,
  0x0000530664c7d8cdUL,
  0x00005fabab68ef0dUL,
  0x00006f07e4399ebfUL,
  0x00007bdf87ce9cd3UL,
  0x00008e879e03c863UL,
  0x0000926184ad1261UL,
  0x0000b89172408c9aUL,
  0x0000bdb1a7ba8950UL,
  0x0000dc92c446afacUL,
  0x0000e575f5c45142UL,
  0x0000f4227569f686UL,
  0x0000f719b98a0dffUL,
  0x00010b20ca063fd1UL,
  0x000119fedf8a4b5dUL,
  0x000159e5d9e33a82UL,
  0x0001618b15fa5bcaUL,
  0x000176528ade090dUL,
  0x000183ae07643eeaUL,
  0x00019b733a8ac43eUL,
  0x0001a2def9dac864UL,
  0x0001a341fb77e543UL,
  0x00009769855a64f3UL,
  0x0000a6d430cf9e5aUL,
  0x000000d74d071e12UL,
  0x00000e2698ea1c92UL,
  0x00001ad454fe60c2UL,
  0x00001e584e5883a2UL,
  0x00002f6af31ca996UL,
  0x00002ff21f7e8439UL,
  0x00003abdc2cb3b40UL,
  0x00003e30bb6851f4UL,
  0x0000491333fe0abdUL,
  0x00004cb4e43f2dd9UL,
  0x00005819ee313444UL,
  0x00005d735ed1f498UL,
  0x00005e6861cb491eUL,
  0x000062808165199eUL,
  0x000063a36f92dc56UL,
  0x00006f311107d5b2UL,
  0x00009825c82bcf5fUL,
  0x00009ed46f821545UL,
  0x00009ee6e0707b62UL,
  0x0000abb3f102b70fUL,
  0x0000acabb6d6234bUL,
  0x0000acc44244b621UL,
  0x0000bb595c979f01UL,
  0x0000c03b3a4f30a6UL,
  0x0000d707bf249d90UL,
  0x0000d8e80f380d9cUL,
  0x0000e1c85a8f5145UL,
  0x0000eab421d0bc95UL,
  0x0001037915eca406UL,
  0x000107dbcea66a9bUL,
  0x000125bdcfb834baUL,
  0x00012ec1cfb51a47UL,
  0x00012fcea5f3874eUL,
  0x000137c6941cdc3cUL,
  0x0001546468139fb3UL,
  0x0001600a6efa37b5UL,
  0x00017705fad153a0UL,
  0x0001792f1bed5911UL,
  0x000179cb6a559dddUL,
  0x0001818c8ee9465cUL,
  0x000181fc31058b20UL,
  0x0001a278f56857ebUL,
  0x0001a87a326f89d1UL,
  0x0001b1e02ea1af03UL,
  0x0001b6a04057502aUL,
  0x0001c6a09f8e8768UL,
  0x0001c702d4b44ee2UL,
  0x0001cbad09bc67d7UL,
  0x0001d2e7ac516c75UL,
  0x0001d47697394091UL,
  0x0001db38fd1684a7UL,
  0x0001eeb152326ca9UL,
  0x0001fe9e1f38b941UL,
  0x00002e6b0fc08d6bUL,
  0x0000473dd887da53UL,
  0x00014c2d9857d104UL,
  0x0001655c6131c281UL,
  0x0001d678b62086deUL,
  0x0000010eaa2ff201UL,
  0x00000223b834d62aUL,
  0x000003d8090b3b6fUL,
  0x000006e6c4c53585UL,
  0x0000090348ff8646UL,
  0x00000c900ad73c8cUL,
  0x000012d7ebef400fUL,
  0x000015e33f8c7dd3UL,
  0x000019e69b5caeeeUL,
  0x00001b5d6ba0bf36UL,
  0x00002bd39a72d985UL,
  0x00002fbbd4757d6eUL,
  0x000031e623b77b86UL,
  0x000039bc31396159UL,
  0x00003fd52211b15eUL,
  0x000044f5eab18094UL,
  0x000045b81d6631fcUL,
  0x00004f3672e1a8e7UL,
  0x00005609d6ac3fc9UL,
  0x00005671dfe24d83UL,
  0x000059da148c4672UL,
  0x00005c00a58c9b15UL,
  0x00006b891c048b5eUL,
  0x00007b345a23f775UL,
  0x00007d8ad037d48dUL,
  0x000082a3485c6ad8UL,
  0x000085730bcb4840UL,
  0x0000869ea75e091aUL,
  0x000088ddb39806fbUL,
  0x0000922749b60c71UL,
  0x0000947f5cc80edaUL,
  0x0000962f93fd327eUL,
  0x0000964b6a615eefUL,
  0x00009793e05c1457UL,
  0x0000990c1ca6372eUL,
  0x000099edd150b95dUL,
  0x00009b41fad86e19UL,
  0x0000a1b24e45d38dUL,
  0x0000a22d13a8df82UL,
  0x0000a2a9bb960b94UL,
  0x0000a381adfe0f2bUL,
  0x0000aa60557d0736UL,
  0x0000ae80fae18f7dUL,
  0x0000aff2a520d464UL,
  0x0000b310c3db99b3UL,
  0x0000b7f6c7321adeUL,
  0x0000bbed2c7f5846UL,
  0x0000bc9cd95bb47eUL,
  0x0000c272384667cbUL,
  0x0000c2ca57ddaa29UL,
  0x0000cc044cf03277UL,
  0x0000d343e8018123UL,
  0x0000d9e8bba0d56fUL,
  0x0000dae1645332efUL,
  0x0000e09b403007ffUL,
  0x0000e11aa9e44355UL,
  0x0000e4748fbbe7bfUL,
  0x0000e7eb34b163e1UL,
  0x0000e89312d97051UL,
  0x0000eaff26819232UL,
  0x0000f7770069952cUL,
  0x0000f937a862b456UL,
  0x0000fba397d36e3cUL,
  0x0000fc746c5ba003UL,
  0x0000fddaf6606addUL,
  0x00010594e6e0dbd6UL,
  0x000105d295abcdfbUL,
  0x00010d94ffdb4425UL,
  0x000117b074d39f2cUL,
  0x0001185a12535639UL,
  0x00011a17e4e416a4UL,
  0x00011ad2b6049f6bUL,
  0x00011c88cc0210dfUL,
  0x00011dc2733d68a8UL,
  0x000120e1160d7319UL,
  0x00012492770d2fdeUL,
  0x000128197f157da3UL,
  0x000129be30567ed4UL,
  0x00012be5fcaa8fe2UL,
  0x00012e9cc1088abcUL,
  0x00013491d322eb45UL,
  0x000135dcd51eb7e3UL,
  0x00013b48b0b809ecUL,
  0x00013c7792fbd0efUL,
  0x00013ff89382ffa8UL,
  0x00014815b4595bfcUL,
  0x00014a3ec4f19b4bUL,
  0x00014adf08c3a405UL,
  0x00014fc654578932UL,
  0x000151408fff7feeUL,
  0x000158bf3970a9a6UL,
  0x00015998d3461810UL,
  0x00015d3a0865a730UL,
  0x00015d55ee01ce6dUL,
  0x000165645c7d7d82UL,
  0x0001677b5212baf7UL,
  0x000167f6a702b183UL,
  0x00016ad226cce5bcUL,
  0x00016b23ae7d017aUL,
  0x00016b343814600aUL,
  0x000175f26b5cb424UL,
  0x0001761617c00c20UL,
  0x00017800e2e3f43aUL,
  0x0001799d4a324a72UL,
  0x0001816f2420c5caUL,
  0x000181b99dc07f77UL,
  0x000186745e491961UL,
  0x000188913838c310UL,
  0x00018f3e2a6e028bUL,
  0x000192f5da345a6cUL,
  0x00019787d9e89f4eUL,
  0x00019945ac64db3aUL,
  0x00019d86e2b20e2fUL,
  0x0001aa18af8aef4fUL,
  0x0001aa8683ccd246UL,
  0x0001ab98e4a87150UL,
  0x0001af3adda3c31aUL,
  0x0001b062d21025e7UL,
  0x0001b25a38ac6021UL,
  0x0001b478e5738d45UL,
  0x0001c5b6c92f9505UL,
  0x0001c7d442986b79UL,
  0x0001c98a510b67b5UL,
  0x0001cc59b608fd08UL,
  0x0001cd038e4fe4bfUL,
  0x0001cf2f10c0493cUL,
  0x0001d0b6d8c778f9UL,
  0x0001d372623fd2b5UL,
  0x0001da5ee84cbec2UL,
  0x0001e42bd1f24007UL,
  0x0001e960d6da49b6UL,
  0x0001ebfc5ae61fffUL,
  0x0001f685ccd7bf52UL,
  0x0001f8e4d526364dUL,
  0x0001223144a80d8bUL,
  0x0001952855a86238UL,
  0x00003e8173047726UL,
  0x000044f3247ae38dUL,
  0x00005ad37934e4b1UL,
  0x00008573acfc02ffUL,
  0x000092a79d74aa97UL,
  0x0000a334a0f85e74UL,
  0x0000a4953a84f84dUL,
  0x0000cecb43f913ceUL,
  0x0000e207420732e5UL,
  0x0001183b16a07520UL,
  0x00012d10cd08b906UL,
  0x0001414c8d22bed9UL,
  0x00017f21e1e59754UL,
  0x000186b090234371UL,
  0x0001b750280eb707UL,
  0x0001d9aac61ea97bUL,
  0x0001fb175cf306eaUL,
  0x000000ac594da237UL,
  0x000000f26e6d6660UL,
  0x000006d18e1b44daUL,
  0x000008c3535e257bUL,
  0x0000144cc1ecee9dUL,
  0x0000156628d60f5cUL,
  0x0000159d40180680UL,
  0x000015a9bce48e70UL,
  0x000017c86ff29e03UL,
  0x0000189b2e41db70UL,
  0x0000215a6543b427UL,
  0x0000225cb015be0dUL,
  0x000024b7b7c1e3f9UL,
  0x0000297364340a0cUL,
  0x00002babce410ed2UL,
  0x00002e4ae76f6482UL,
  0x00002f141c9efbdbUL,
  0x0000323d2953c5f5UL,
  0x00003335433f7e98UL,
  0x0000367e03546c97UL,
  0x0000393d4d8baea3UL,
  0x00003a9ca55437feUL,
  0x00003b2add785a49UL,
  0x00003e99b773a593UL,
  0x00003f3d69d612d8UL,
  0x000040c15067fe4eUL,
  0x0000419af6f7841aUL,
  0x000043030c8b156aUL,
  0x00004339eb1d8f12UL,
  0x000043ebbd444847UL,
  0x0000450fee72f6e2UL,
  0x0000460221787fbaUL,
  0x00004978ce2b01b9UL,
  0x00004c997ea441d9UL,
  0x00004d9a57914946UL,
  0x00005016b7b9f96fUL,
  0x000050d0fad434f7UL,
  0x000050ed161100e0UL,
  0x000053434e9c1af0UL,
  0x0000565118e8786aUL,
  0x0000568b9dbd8425UL,
  0x00005780d0034f9aUL,
  0x00005a0e6ad4b19bUL,
  0x00005a0fee8eac78UL,
  0x00005e52df70281eUL,
  0x00005fd730e1d782UL,
  0x0000607bec71adb0UL,
  0x0000615854226dc7UL,
  0x00006167db3c608dUL,
  0x000068663e10e2b1UL,
  0x0000693f14f896b4UL,
  0x00006aa4a73968abUL,
  0x00006dd66e3a3e06UL,
  0x00006edde6e8964dUL,
  0x00006eff7e348c8fUL,
  0x00007022c98094a5UL,
  0x00007035a1964eaeUL,
  0x0000707c7b002941UL,
  0x0000730dcdce5d04UL,
  0x00007360bd1bc49bUL,
  0x0000750a43d577ebUL,
  0x0000756d656416a3UL,
  0x000076eb8576ed5aUL,
  0x000078d8f5ff4c6fUL,
  0x00007992655b5298UL,
  0x00007a4c9f9a32e4UL,
  0x00007eb4fdecd801UL,
  0x0000813c723526ecUL,
  0x0000819a8148e853UL,
  0x000081a4c4f6515fUL,
  0x00008358ea29b48aUL,
  0x000084d91b3277ceUL,
  0x000088de79026a9bUL,
  0x00008974fc9b993fUL,
  0x00008abe53581403UL,
  0x00008be935601b92UL,
  0x00008d14c63d7860UL,
  0x00008d2606520436UL,
  0x00008da752a2ba98UL,
  0x000093f1b9a6cadbUL,
  0x000099bfef8c80c6UL,
  0x00009db0b841b180UL,
  0x00009f5bff74b1efUL,
  0x0000a233f236cd5dUL,
  0x0000a673ef172ee1UL,
  0x0000a8380409f4bbUL,
  0x0000aa634e0361aaUL,
  0x0000ac05d443ffb7UL,
  0x0000ac83e4c8642eUL,
  0x0000b06e7f0e961eUL,
  0x0000b0932b2bd903UL,
  0x0000b896202418ecUL,
  0x0000b9ab78f3729fUL,
  0x0000ba47726551b3UL,
  0x0000bc36d0982a1dUL,
  0x0000bd9a1379c3e0UL,
  0x0000bfd845f130f4UL,
  0x0000c0983dd1f205UL,
  0x0000c26eacaf246fUL,
  0x0000c2ecc7d38d17UL,
  0x0000c329dcf0ef8eUL,
  0x0000c36956abf77bUL,
  0x0000c711b4afe33cUL,
  0x0000c98708614b87UL,
  0x0000cd2afc6e1b85UL,
  0x0000d17c0743ac4aUL,
  0x0000d481e07367d5UL,
  0x0000d4cef4090d4fUL,
  0x0000d50f7bd94413UL,
  0x0000d67fe8a86684UL,
  0x0000da3911d90765UL,
  0x0000daf6698e8f2bUL,
  0x0000dbb184b19f76UL,
  0x0000dc5930d6b1d6UL,
  0x0000dc60ef495a48UL,
  0x0000dcbbf1cd6c95UL,
  0x0000dcbe2ff51ed6UL,
  0x0000dd13f130fa74UL,
  0x0000ddd4928b8c38UL,
  0x0000de554a47de91UL,
  0x0000e2b3b0f714adUL,
  0x0000e42252bf1b5bUL,
  0x0000e48a97713e4fUL,
  0x0000e4fffe5b0316UL,
  0x0000e562d70dcd3aUL,
  0x0000e7db22774a1eUL,
  0x0000e8599ebd422dUL,
  0x0000e8810aa61678UL,
  0x0000e91bb96cdc22UL,
  0x0000eb6b83a35c4aUL,
  0x0000ebbff084dcdeUL,
  0x0000ed9f18db1ff3UL,
  0x0000edd901169a42UL,
  0x0000ef4ce741b5d6UL,
  0x0000eff3621d5d01UL,
  0x0000f2204d11494fUL,
  0x0000f5f575f8ad3eUL,
  0x0000f91a8a20bbafUL,
  0x0000ff432c1c6fecUL,
  0x0000ff5dc9f76aefUL,
  0x0000ffbab0a62934UL,
  0x000100e9e7127dcdUL,
  0x0001016c442ad934UL,
  0x00010276f5d5665eUL,
  0x0001066278a37ac0UL,
  0x00010907c258571aUL,
  0x000109267c706bdfUL,
  0x000109519f074673UL,
  0x00010af0cbe9bc5eUL,
  0x00010b121a93aab0UL,
  0x00010ec3e817cf0cUL,
  0x000110d9a4ba1f46UL,
  0x000111bf4013eb18UL,
  0x00011249087d1795UL,
  0x000113d1d8dfa9c7UL,
  0x0001146da26de7c0UL,
  0x000114816f4c1aacUL,
  0x0001167c5b928899UL,
  0x000116faff1119a6UL,
  0x000118b28d89c514UL,
  0x0001194a7814f3e1UL,
  0x00011a446c413d0eUL,
  0x00011ce64bd458cbUL,
  0x000120c1039cbc4aUL,
  0x0001215ecf298868UL,
  0x0001222df55c3941UL,
  0x000124afa88f9958UL,
  0x000125873c50b70fUL,
  0x00012670868f3cb6UL,
  0x00012a124660b0d8UL,
  0x00012a30f0c583b3UL,
  0x00012bb51d6dc92cUL,
  0x00012c676bc00797UL,
  0x00012d1d54b13b5cUL,
  0x000130381af1fbe9UL,
  0x00013226682dd169UL,
  0x000133e6d1eb31f4UL,
  0x00013842a382c001UL,
  0x00013b898b4f72a8UL,
  0x000142622594af24UL,
  0x00014480d4827540UL,
  0x000144aa1029a1abUL,
  0x00014658bedd6d7bUL,
  0x00014739643f60deUL,
  0x0001484e7a1ae506UL,
  0x0001497bf0f57173UL,
  0x00014a33ebda2012UL,
  0x00014a97d71bfa11UL,
  0x00014b9ce693369dUL,
  0x00014d8d0cbc85a8UL,
  0x00014e2cea2cdd3eUL,
  0x000150f922a42cbbUL,
  0x0001513a4d104fbeUL,
  0x000151407f88092aUL,
  0x00015206bf5ff518UL,
  0x000152cbf28a616bUL,
  0x000153ace5784133UL,
  0x0001542d2f183007UL,
  0x00015530820977adUL,
  0x0001571bb66b79a7UL,
  0x0001588a28ee0164UL,
  0x0001597f2923514cUL,
  0x000159f145fd4bdcUL,
  0x00015a1cb3e24555UL,
  0x00015a232fff8d87UL,
  0x00015a81e38706f7UL,
  0x00015ceba2b34919UL,
  0x00015de8c25703c6UL,
  0x00015fb3eaa039e0UL,
  0x000160ee414c875cUL,
  0x000163c21097c6f5UL,
  0x00016e9b744227f0UL,
  0x00016f0c9a7a1e5dUL,
  0x000171945e572f4dUL,
  0x000173b27a2a699dUL,
  0x000173d8af6a2a74UL,
  0x00017434d3f2394aUL,
  0x000174f4c6988cc3UL,
  0x000178ca67c4f942UL,
  0x00017902e5232b40UL,
  0x00017aa284adaeceUL,
  0x00017bb1352f3e23UL,
  0x00017fc8dd65a389UL,
  0x0001804aa0076ef7UL,
  0x000180895d61d9e2UL,
  0x0001872d4aa51048UL,
  0x00018744f4a49125UL,
  0x00018afcbd4aa558UL,
  0x0001930cee11f35bUL,
  0x0001932023208779UL,
  0x0001968833d7fb8aUL,
  0x00019732a54d1bdcUL,
  0x000198cd27279f0dUL,
  0x00019ec8547e7b3cUL,
  0x00019f65c6b8a11eUL,
  0x0001a1cea2ea909eUL,
  0x0001a2e3f2509bc8UL,
  0x0001a8b1e7f34386UL,
  0x0001af3fbded65f6UL,
  0x0001b0543fbe1db5UL,
  0x0001b3ed63ded336UL,
  0x0001b4400360f32eUL,
  0x0001b598eae7d259UL,
  0x0001b7358938d3c3UL,
  0x0001b7cdb2a0a4f1UL,
  0x0001b8d6fd758057UL,
  0x0001b8e345457cbcUL,
  0x0001b93a50d2f823UL,
  0x0001ba46c082937fUL,
  0x0001bccc85c91ea7UL,
  0x0001bec7b91e10cdUL,
  0x0001c0c38ae688c7UL,
  0x0001c0fbfda1c628UL,
  0x0001c157488a8f94UL,
  0x0001cb9b5df8f539UL,
  0x0001ce7375f7924cUL,
  0x0001d225a8c812beUL,
  0x0001d566a28b5b22UL,
  0x0001d6c373d67855UL,
  0x0001d77024723c70UL,
  0x0001ddca9a2edfdaUL,
  0x0001df840de171ceUL,
  0x0001e011f0894e1fUL,
  0x0001e2dfbd65331aUL,
  0x0001e506be44485eUL,
  0x0001e61ec0df3011UL,
  0x0001e62b3306746cUL,
  0x0001e64c2b9eaafeUL,
  0x0001e7ab050dfa07UL,
  0x0001e8038412a206UL,
  0x0001eb2edd1fcf6dUL,
  0x0001eb32ee85b4f5UL,
  0x0001f47878ebc4f6UL,
  0x0001f4a5120f94cbUL,
  0x0001f658e2241885UL,
  0x0001f7afc7895470UL,
  0x0001f85f45fc117eUL,
  0x0001fa04883c4b35UL,
  0x0001fbab76f88442UL,
  0x0001fcdb6d6743bfUL,
  0x0000e389ca73b16cUL,
  0x00010779c2279ba0UL,
  0x00000141a5f8eaa0UL,
  0x000001a66ce69328UL,
  0x0000025f743345bdUL,
  0x000002880476ab82UL,
  0x0000046954521799UL,
  0x000005284c656b1aUL,
  0x00000683f29fb82dUL,
  0x0000079712197ce7UL,
  0x00000aed538e3ec6UL,
  0x00000b58717c4038UL,
  0x00000d0b97426b75UL,
  0x00000e4a140eb405UL,
  0x000010683666d8e4UL,
  0x000011cbcd37697cUL,
  0x00001353d5e3af4cUL,
  0x000014a0983c5b89UL,
  0x000016a5a9411b30UL,
  0x0000191c8dd2617fUL,
  0x00001976ecc55bf5UL,
  0x00001aaa74c04dd0UL,
  0x00001ab9bdc3312dUL,
  0x00001b4646fb1de3UL,
  0x00001bcda90e0991UL,
  0x00001bf9d9356206UL,
  0x00001c374ca9c9b8UL,
  0x00001d424b89e3fdUL,
  0x00001e71536cabdaUL,
  0x00001f1f7589e256UL,
  0x0000204cf84ba1a9UL,
  0x000023e9289d619dUL,
  0x000024ca3c861fafUL,
  0x000024d7f9f2154cUL,
  0x00002733d85eecabUL,
  0x0000283be2ea407bUL,
  0x00002999fa93e62eUL,
  0x00002c200def8b40UL,
  0x00002c41051935e7UL,
  0x00002c82dc5d30f8UL,
  0x00002cbe6871fc82UL,
  0x00002d28b12e3effUL,
  0x00002dd2c0cff80fUL,
  0x00002ece8c672e34UL,
  0x00002edd75725b25UL,
  0x00002eea94a853deUL,
  0x0000305e91e584cbUL,
  0x0000320ec11c2a02UL,
  0x0000329029cde8d6UL,
  0x000033bb1a59f03aUL,
  0x00003405de76a7a8UL,
  0x000034ef44c3ce4fUL,
  0x00003556a551ab2aUL,
  0x000035eee308674bUL,
  0x000035f149645b4bUL,
  0x000036675331e144UL,
  0x000037b07b9f430bUL,
  0x000037cfded71ec5UL,
  0x00003937108722ceUL,
  0x00003b205fb03882UL,
  0x00003b80b3b7eccaUL,
  0x00003b8327b93f68UL,
  0x00003d1b016a8b7eUL,
  0x000040e92f0be162UL,
  0x0000412f80b20a9bUL,
  0x000041387f78fcdfUL,
  0x000042157d1cb694UL,
  0x0000429daf786dd0UL,
  0x00004457ec472140UL,
  0x0000452e8949012dUL,
  0x0000457f3fe3f021UL,
  0x0000476a5dd8e9faUL,
  0x000047cfcc7c59b9UL,
  0x000049a2985232e5UL,
  0x000049dd82160f5dUL,
  0x00004a3308a5758eUL,
  0x00004bd8b4a4b3e8UL,
  0x00004c285ca34c22UL,
  0x00004ddb99715e9cUL,
  0x00004e05959576d3UL,
  0x00004e6237343acdUL,
  0x00004edbe71c6748UL,
  0x00004f4a3635c62fUL,
  0x00004fc1f32a0d16UL,
  0x00005125affd0088UL,
  0x0000517ef995811cUL,
  0x0000518d7c238716UL,
  0x0000565e765e10aeUL,
  0x00005764eb79fd71UL,
  0x00005a4f5b5bd20dUL,
  0x00005a91d2758861UL,
  0x00005c46bfc790faUL,
  0x00005ca108bae05bUL,
  0x00005d8f0b8cb8a5UL,
  0x00005f0239c22e72UL,
  0x00006003eb0cc27eUL,
  0x0000621d086dafe6UL,
  0x00006397b698c228UL,
  0x0000656f95e4bb1fUL,
  0x000065e8ae57af48UL,
  0x0000671af0494cc0UL,
  0x00006b42c8da2783UL,
  0x00006bfa53942e1bUL,
  0x00006ce505a0aeacUL,
  0x000070bd66b6697cUL,
  0x000072bf83d5e303UL,
  0x00007323450e3cffUL,
  0x000073338ccf7292UL,
  0x00007668ebb5ea90UL,
  0x00007982b2e4530bUL,
  0x000079e083cb370eUL,
  0x00007b45ae172594UL,
  0x00007b8d99fa80cfUL,
  0x00007cd165c99cf2UL,
  0x00007e5e5cd0fe3bUL,
  0x00007edbafe7ba8cUL,
  0x00007f437c2e124aUL,
  0x000080263b11172fUL,
  0x00008354cd72d5d2UL,
  0x000083f01d79e6cbUL,
  0x00008567548caca7UL,
  0x0000866158cb43a7UL,
  0x0000879e34293729UL,
  0x0000890fb1ddeb0fUL,
  0x00008a0ce3801852UL,
  0x00008a54f83e6565UL,
  0x00008c129b07f719UL,
  0x00008c6fcb5d3c31UL,
  0x00008c9ffd80ad14UL,
  0x000090cdc2c5fbfbUL,
  0x000092014fc2fdddUL,
  0x00009284d3572dacUL,
  0x000095b00381126cUL,
  0x00009616a294a9e9UL,
  0x00009be927eba620UL,
  0x00009cbd6d15484cUL,
  0x00009d50d81008f2UL,
  0x00009e0d663392d4UL,
  0x00009e49fd0626fcUL,
  0x00009fab72430027UL,
  0x00009fc67ccdb2e3UL,
  0x00009ffc4b422b31UL,
  0x0000a17b65d1cae9UL,
  0x0000a19bbd32e1c9UL,
  0x0000a4206e5985f2UL,
  0x0000a50f4ec978ceUL,
  0x0000a7ce19eba833UL,
  0x0000a7f538fabdc1UL,
  0x0000a91aefa615b2UL,
  0x0000ab4709d37c99UL,
  0x0000abc22f0d2521UL,
  0x0000abd5f54d4ea1UL,
  0x0000ada78f77fbf2UL,
  0x0000aef8013381cbUL,
  0x0000af830cabffafUL,
  0x0000b0541e7d6c23UL,
  0x0000b10cbf720fcaUL,
  0x0000b242e6f1a8dfUL,
  0x0000b29df18e7af0UL,
  0x0000b2c2809f72cbUL,
  0x0000b4befb1d72c4UL,
  0x0000b4f9331d2403UL,
  0x0000b544722b3d56UL,
  0x0000b653cde94976UL,
  0x0000b6c56c9a7a14UL,
  0x0000b79cfa3c585aUL,
  0x0000b9065b571aa1UL,
  0x0000b9faa0da4e12UL,
  0x0000bc79c4e33a13UL,
  0x0000bf8134a00605UL,
  0x0000c11cc2c611adUL,
  0x0000c160a47d69c5UL,
  0x0000c20289d906b0UL,
  0x0000c376760b8ec1UL,
  0x0000c530b1768109UL,
  0x0000c60c4967e549UL,
  0x0000c8abc45db31dUL,
  0x0000ca9887474ac4UL,
  0x0000cabf56e673a3UL,
  0x0000cbc318803c24UL,
  0x0000cbc6116e5ebeUL,
  0x0000ccf0db1554a9UL,
  0x0000cddcac6fa25aUL,
  0x0000ce96261ff48eUL,
  0x0000cecf2e48a986UL,
  0x0000d1b910eddeefUL,
  0x0000d29e33f0ca7aUL,
  0x0000d6e8342a3184UL,
  0x0000d6fc99149bb5UL,
  0x0000daa4bcd61719UL,
  0x0000db520d201328UL,
  0x0000dbe6c118c224UL,
  0x0000de6b56f31d14UL,
  0x0000df300cdf8590UL,
  0x0000e0049acdf393UL,
  0x0000e0220a337cfdUL,
  0x0000e054e6015535UL,
  0x0000e27c6c9fee32UL,
  0x0000e4ed9027f065UL,
  0x0000e6b663a39fc8UL,
  0x0000e6e9f7af88c5UL,
  0x0000e7f72bc21ca7UL,
  0x0000e8c1b6b09cd4UL,
  0x0000ebee44f9908dUL,
  0x0000eccce0be392bUL,
  0x0000f07ee0b55d52UL,
  0x0000f0ce19a417d6UL,
  0x0000f5c948a818a6UL,
  0x0000fa685187e0ddUL,
  0x0000fc0db272e91cUL,
  0x0000fd36274d01b7UL,
  0x0000fd66f9a6efdeUL,
  0x0000fda0d93abdabUL,
  0x0001003988e644d5UL,
  0x00010116cfd15dd9UL,
  0x00010123e8f8d195UL,
  0x00010180f04edab1UL,
  0x0001036eb170fee7UL,
  0x000103a7f3bf5febUL,
  0x000105f08e700922UL,
  0x000107cc36aa2b48UL,
  0x000109bd9c16a8f1UL,
  0x00010c0ae3f6da17UL,
  0x00010ccb34315755UL,
  0x00010cde7e2f58c7UL,
  0x00010e292fa86e34UL,
  0x00010e5d0949e2d1UL,
  0x00010f60bd9826aaUL,
  0x00011008cf854996UL,
  0x000111f56b66e071UL,
  0x000114dd38a98449UL,
  0x0001188fc5d992faUL,
  0x00011b285555b5daUL,
  0x00011dd783387b04UL,
  0x00011efc5d7b6d56UL,
  0x00011f8a925dfaddUL,
  0x000120c830f46f6eUL,
  0x000121038815ffdeUL,
  0x0001212a3941e24bUL,
  0x00012144ee169244UL,
  0x000121e16168140dUL,
  0x0001225ae259638fUL,
  0x00012579ba514415UL,
  0x000125a8a53964c0UL,
  0x0001269fe3de25c7UL,
  0x0001274baa39aabcUL,
  0x0001275b62e78c45UL,
  0x000127b87c0e5441UL,
  0x000128c54d7d04d9UL,
  0x00012a869cfa3127UL,
  0x00012a8e2f60953aUL,
  0x00012a93122867c3UL,
  0x00012cfe7507f472UL,
  0x00012d360d0e879eUL,
  0x00012d71de40f3e3UL,
  0x00012f5f9d1a2c9cUL,
  0x000131112d4e0047UL,
  0x0001320d27aabcccUL,
  0x000135f48df07e2dUL,
  0x000136dbb1339a5fUL,
  0x00013781ea663cfeUL,
  0x000138f5c553d840UL,
  0x00013a347112bac7UL,
  0x00013a98203646e7UL,
  0x00013b47e37209d6UL,
  0x00013b5ce06bdf4cUL,
  0x00014020ccdb2a68UL,
  0x000141ff724d9c33UL,
  0x000142f37ef7cbbeUL,
  0x000144ba64d8d01eUL,
  0x0001460dd8e8ad11UL,
  0x000146cd55cf1264UL,
  0x000147bb3fd11278UL,
  0x000149787377cf7dUL,
  0x000149a3ffc81681UL,
  0x00014aa9c853e733UL,
  0x00014abbf3281ebaUL,
  0x00014bd038668306UL,
  0x00014c268658898cUL,
  0x00014ca268c1630dUL,
  0x00014d9c4c72e81dUL,
  0x0001502da8bb79eaUL,
  0x000150efa1d6948fUL,
  0x0001515332410990UL,
  0x000151e995ae13adUL,
  0x000153d6aed93342UL,
  0x000154615a906e1eUL,
  0x000156dc972f443eUL,
  0x000156e710f5f969UL,
  0x0001589b3027d036UL,
  0x00015b4b9b3c2e93UL,
  0x00015bb7cb8d66c9UL,
  0x00015cc6f17c1783UL,
  0x00015cdeda4ae8a1UL,
  0x00015e6d4ec0b7fcUL,
  0x00015fc917b939ffUL,
  0x0001627626dfba6dUL,
  0x00016276bb8e5dc0UL,
  0x00016330b2c2d04fUL,
  0x0001635507508bcfUL,
  0x000163d54bbf97f6UL,
  0x000165860b93464fUL,
  0x000165e44cefb17bUL,
  0x000166061c4383d9UL,
  0x00016642de75c594UL,
  0x00016b8d86af375aUL,
  0x00016d2c59c62be6UL,
  0x00016ef488ddc7e7UL,
  0x00016f576aec2768UL,
  0x00016faa9ee9a257UL,
  0x0001706b63e20f2dUL,
  0x000171a466406218UL,
  0x000171c3587e5077UL,
  0x00017309d0141671UL,
  0x00017443ed058ed7UL,
  0x000174cbd474aa67UL,
  0x00017659593ae13fUL,
  0x0001770a2934394fUL,
  0x00017ba0b77683e0UL,
  0x00017bca595f3658UL,
  0x000180bc519635a7UL,
  0x0001812df2fa2577UL,
  0x00018269e59935b4UL,
  0x0001842493614ce8UL,
  0x000184c07ffef4ebUL,
  0x000184c0b5ff09a6UL,
  0x000185fa39c95f8aUL,
  0x0001868f398745ebUL,
  0x000187a983155df6UL,
  0x000189c1e1333026UL,
  0x00018a3c5aeef05dUL,
  0x00018ad69fd38bedUL,
  0x00018baed2d12190UL,
  0x00018bfca1e54043UL,
  0x00018c45f955e4a4UL,
  0x00018d09c57a8f92UL,
  0x00018dbb57835ed3UL,
  0x00018dcdd8c35b21UL,
  0x0001901a5ea91b8cUL,
  0x000192257be3b4e6UL,
  0x0001928d0286421aUL,
  0x000192d64a95bdb7UL,
  0x000193843809ed2dUL,
  0x000194cf62183ffcUL,
  0x00019599f40e1d3aUL,
  0x00019740ec2aeaeeUL,
  0x0001979630856e94UL,
  0x0001982408526941UL,
  0x0001993f53c28670UL,
  0x00019c40a73669daUL,
  0x00019c560d8b6c73UL,
  0x00019da81b73075dUL,
  0x00019f1a9fd87092UL,
  0x00019f8f25d4d9f3UL,
  0x0001a0dab97e878fUL,
  0x0001a1805ecc3d10UL,
  0x0001a1da23213795UL,
  0x0001a2fa06da6d21UL,
  0x0001a5dc56870031UL,
  0x0001a67f0e665ad0UL,
  0x0001a71a934696b3UL,
  0x0001a79d7043eae5UL,
  0x0001aa5994fcc6d3UL,
  0x0001acf8eeca0b68UL,
  0x0001ad48fa22413fUL,
  0x0001b0a0854fa7d5UL,
  0x0001b2a5397c7428UL,
  0x0001b32296a6731cUL,
  0x0001b33ef374c080UL,
  0x0001b347b8cfcdfaUL,
  0x0001b420de2fb131UL,
  0x0001b4e0fb7af89cUL,
  0x0001b5078c8c6181UL,
  0x0001b79aacb60495UL,
  0x0001b8add6b6d85aUL,
  0x0001b8f4fab2f126UL,
  0x0001bbc28f35c9a7UL,
  0x0001bbebab16e6c6UL,
  0x0001bc0c31c8a191UL,
  0x0001bd1d61bef9baUL,
  0x0001bdf60f68c267UL,
  0x0001bf1c8a8e99d4UL,
  0x0001bfa76af76988UL,
  0x0001c0b80204f3e0UL,
  0x0001c0d55fa86956UL,
  0x0001c2d6c5bc0901UL,
  0x0001c3e9db691351UL,
  0x0001c3ed1a4de68cUL,
  0x0001c6ebd4525e7eUL,
  0x0001c8b7f02325e2UL,
  0x0001c9dd66ea043cUL,
  0x0001cab59ef27e94UL,
  0x0001cae122cf1fc8UL,
  0x0001cb865167b043UL,
  0x0001cbc3d5516dc3UL,
  0x0001cbda6d741ac5UL,
  0x0001cd7ab740c203UL,
  0x0001ce8e1799c0fcUL,
  0x0001ceff8bd8d19dUL,
  0x0001cf2f6bbbf14fUL,
  0x0001d0f0d6b5e7edUL,
  0x0001d184098689a2UL,
  0x0001d1ff2758f6d1UL,
  0x0001d21a7a79a173UL,
  0x0001d5a0947d9292UL,
  0x0001d6db2efe904aUL,
  0x0001d851447599a7UL,
  0x0001d9ed8577b7b6UL,
  0x0001da43c0ae25b0UL,
  0x0001db443660e662UL,
  0x0001dc759ae0c9f0UL,
  0x0001dd36b43bee3bUL,
  0x0001ded4a9a53c09UL,
  0x0001e0207354a68bUL,
  0x0001e156d11091d5UL,
  0x0001e2592980a389UL,
  0x0001e4345190f2b2UL,
  0x0001e505a9b18b76UL,
  0x0001e517d2b6e5b7UL,
  0x0001e52ef625f748UL,
  0x0001e6826bf94069UL,
  0x0001ea42fdae999fUL,
  0x0001eab095553c48UL,
  0x0001ebba299e7859UL,
  0x0001ebe0988067b1UL,
  0x0001ebfbea6360b0UL,
  0x0001ec3f003b6674UL,
  0x0001f1cf5182e408UL,
  0x0001f1fa8becedf7UL,
  0x0001f24c4d28a244UL,
  0x0001f572b9d36c81UL,
  0x0001f6510b6a9f69UL,
  0x0001f70eb5819feaUL,
  0x0001f7acf3e9b128UL,
  0x0001f8676b18b1baUL,
  0x0001f8cd1f7ad3b1UL,
  0x0001fa525e29541aUL,
  0x0001fc690f1710f5UL,
  0x0001fcaf88f5c23bUL,
  0x0001fd1b07241c1aUL,
  0x0001fd77f2687c27UL,
  0x0001fe53933d77bfUL,
  0x0000bbb6b61e3b81UL,
  0x00010a95357e9afbUL,
  0x00018cb610bfbb6aUL,
  0x0001cf5833fd8395UL
};
apriltag_family_t *tagAruco7x7_1000_create()
{
  apriltag_family_t *tf = calloc(1, sizeof(apriltag_family_t));
  tf->name = strdup("tagAruco7x7_1000");
  tf->h = 14;
  tf->ncodes = 1000;
  tf->codes = codedata;
  tf->nbits = 49;
  tf->bit_x = calloc(49, sizeof(uint32_t));
  tf->bit_y = calloc(49, sizeof(uint32_t));

  tf->bit_x[0] = 1;
  tf->bit_y[0] = 1;
  tf->bit_x[1] = 2;
  tf->bit_y[1] = 1;
  tf->bit_x[2] = 3;
  tf->bit_y[2] = 1;
  tf->bit_x[3] = 4;
  tf->bit_y[3] = 1;
  tf->bit_x[4] = 5;
  tf->bit_y[4] = 1;
  tf->bit_x[5] = 6;
  tf->bit_y[5] = 1;
  tf->bit_x[6] = 2;
  tf->bit_y[6] = 2;
  tf->bit_x[7] = 3;
  tf->bit_y[7] = 2;
  tf->bit_x[8] = 4;
  tf->bit_y[8] = 2;
  tf->bit_x[9] = 5;
  tf->bit_y[9] = 2;
  tf->bit_x[10] = 3;
  tf->bit_y[10] = 3;
  tf->bit_x[11] = 4;
  tf->bit_y[11] = 3;

  tf->bit_x[12] = 7;
  tf->bit_y[12] = 1;
  tf->bit_x[13] = 7;
  tf->bit_y[13] = 2;
  tf->bit_x[14] = 7;
  tf->bit_y[14] = 3;
  tf->bit_x[15] = 7;
  tf->bit_y[15] = 4;
  tf->bit_x[16] = 7;
  tf->bit_y[16] = 5;
  tf->bit_x[17] = 7;
  tf->bit_y[17] = 6;
  tf->bit_x[18] = 6;
  tf->bit_y[18] = 2;
  tf->bit_x[19] = 6;
  tf->bit_y[19] = 3;
  tf->bit_x[20] = 6;
  tf->bit_y[20] = 4;
  tf->bit_x[21] = 6;
  tf->bit_y[21] = 5;
  tf->bit_x[22] = 5;
  tf->bit_y[22] = 3;
  tf->bit_x[23] = 5;
  tf->bit_y[23] = 4;

  tf->bit_x[24] = 7;
  tf->bit_y[24] = 7;
  tf->bit_x[25] = 6;
  tf->bit_y[25] = 7;
  tf->bit_x[26] = 5;
  tf->bit_y[26] = 7;
  tf->bit_x[27] = 4;
  tf->bit_y[27] = 7;
  tf->bit_x[28] = 3;
  tf->bit_y[28] = 7;
  tf->bit_x[29] = 2;
  tf->bit_y[29] = 7;
  tf->bit_x[30] = 6;
  tf->bit_y[30] = 6;
  tf->bit_x[31] = 5;
  tf->bit_y[31] = 6;
  tf->bit_x[32] = 4;
  tf->bit_y[32] = 6;
  tf->bit_x[33] = 3;
  tf->bit_y[33] = 6;
  tf->bit_x[34] = 5;
  tf->bit_y[34] = 5;
  tf->bit_x[35] = 4;
  tf->bit_y[35] = 5;

  tf->bit_x[36] = 1;
  tf->bit_y[36] = 7;
  tf->bit_x[37] = 1;
  tf->bit_y[37] = 6;
  tf->bit_x[38] = 1;
  tf->bit_y[38] = 5;
  tf->bit_x[39] = 1;
  tf->bit_y[39] = 4;
  tf->bit_x[40] = 1;
  tf->bit_y[40] = 3;
  tf->bit_x[41] = 1;
  tf->bit_y[41] = 2;
  tf->bit_x[42] = 2;
  tf->bit_y[42] = 6;
  tf->bit_x[43] = 2;
  tf->bit_y[43] = 5;
  tf->bit_x[44] = 2;
  tf->bit_y[44] = 4;
  tf->bit_x[45] = 2;
  tf->bit_y[45] = 3;
  tf->bit_x[46] = 3;
  tf->bit_y[46] = 5;
  tf->bit_x[47] = 3;
  tf->bit_y[47] = 4;

  tf->bit_x[48] = 4;
  tf->bit_y[48] = 4;
  tf->width_at_border = 9;
  tf->total_width = 11;
  tf->reversed_border = false;
  return tf;
}

void tagAruco7x7_1000_destroy(apriltag_family_t *tf)
{
  free(tf->bit_x);
  free(tf->bit_y);
  free(tf->name);
  free(tf);
}
