/* automatically generated by rust-bindgen 0.72.0 */

pub const CEF_API_VERSION_13300: i32 = 13300;
pub const CEF_API_VERSION_13301: i32 = 13301;
pub const CEF_API_VERSION_13302: i32 = 13302;
pub const CEF_API_VERSION_13303: i32 = 13303;
pub const CEF_API_VERSION_13304: i32 = 13304;
pub const CEF_API_VERSION_13400: i32 = 13400;
pub const CEF_API_VERSION_13401: i32 = 13401;
pub const CEF_API_VERSION_13500: i32 = 13500;
pub const CEF_API_VERSION_13600: i32 = 13600;
pub const CEF_API_VERSION_13601: i32 = 13601;
pub const CEF_API_VERSION_13700: i32 = 13700;
pub const CEF_API_VERSION_13800: i32 = 13800;
pub const CEF_API_VERSION_999998: i32 = 999998;
pub const CEF_API_VERSION_999999: i32 = 999999;
pub const CEF_API_VERSION_MIN: i32 = 13300;
pub const CEF_API_VERSION_LAST: i32 = 13800;
pub const CEF_API_VERSION_EXPERIMENTAL: i32 = 999999;
pub const CEF_API_VERSION_NEXT: i32 = 999998;
pub const CEF_API_VERSION: i32 = 999999;
unsafe extern "C" {
    #[doc = "\n Configures the CEF API version and returns API hashes for the libcef\n library. The returned string is owned by the library and should not be\n freed. The |version| parameter should be CEF_API_VERSION and any changes to\n this value will be ignored after the first call to this method. The |entry|\n parameter describes which hash value will be returned:\n\n 0 - CEF_API_HASH_PLATFORM\n 1 - CEF_API_HASH_UNIVERSAL (deprecated, same as CEF_API_HASH_PLATFORM)\n 2 - CEF_COMMIT_HASH (from cef_version.h)\n"]
    pub fn cef_api_hash(
        version: ::std::os::raw::c_int,
        entry: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = "\n Returns the CEF API version that was configured by the first call to\n cef_api_hash().\n"]
    pub fn cef_api_version() -> ::std::os::raw::c_int;
}
pub type wchar_t = ::std::os::raw::c_ushort;
pub type __time64_t = ::std::os::raw::c_longlong;
pub type time_t = __time64_t;
pub type char16_t = ::std::os::raw::c_ushort;
#[doc = "\n CEF string type definitions. Whomever allocates |str| is responsible for\n providing an appropriate |dtor| implementation that will free the string in\n the same memory space. When reusing an existing string structure make sure\n to call |dtor| for the old value before assigning new |str| and |dtor|\n values. Static strings will have a NULL |dtor| value. Using the below\n functions if you want this managed for you.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_string_wide_t {
    pub str_: *mut wchar_t,
    pub length: usize,
    pub dtor: ::std::option::Option<unsafe extern "C" fn(str_: *mut wchar_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_string_wide_t"][::std::mem::size_of::<_cef_string_wide_t>() - 24usize];
    ["Alignment of _cef_string_wide_t"][::std::mem::align_of::<_cef_string_wide_t>() - 8usize];
    ["Offset of field: _cef_string_wide_t::str_"]
        [::std::mem::offset_of!(_cef_string_wide_t, str_) - 0usize];
    ["Offset of field: _cef_string_wide_t::length"]
        [::std::mem::offset_of!(_cef_string_wide_t, length) - 8usize];
    ["Offset of field: _cef_string_wide_t::dtor"]
        [::std::mem::offset_of!(_cef_string_wide_t, dtor) - 16usize];
};
#[doc = "\n CEF string type definitions. Whomever allocates |str| is responsible for\n providing an appropriate |dtor| implementation that will free the string in\n the same memory space. When reusing an existing string structure make sure\n to call |dtor| for the old value before assigning new |str| and |dtor|\n values. Static strings will have a NULL |dtor| value. Using the below\n functions if you want this managed for you.\n"]
pub type cef_string_wide_t = _cef_string_wide_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_string_utf8_t {
    pub str_: *mut ::std::os::raw::c_char,
    pub length: usize,
    pub dtor: ::std::option::Option<unsafe extern "C" fn(str_: *mut ::std::os::raw::c_char)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_string_utf8_t"][::std::mem::size_of::<_cef_string_utf8_t>() - 24usize];
    ["Alignment of _cef_string_utf8_t"][::std::mem::align_of::<_cef_string_utf8_t>() - 8usize];
    ["Offset of field: _cef_string_utf8_t::str_"]
        [::std::mem::offset_of!(_cef_string_utf8_t, str_) - 0usize];
    ["Offset of field: _cef_string_utf8_t::length"]
        [::std::mem::offset_of!(_cef_string_utf8_t, length) - 8usize];
    ["Offset of field: _cef_string_utf8_t::dtor"]
        [::std::mem::offset_of!(_cef_string_utf8_t, dtor) - 16usize];
};
pub type cef_string_utf8_t = _cef_string_utf8_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_string_utf16_t {
    pub str_: *mut char16_t,
    pub length: usize,
    pub dtor: ::std::option::Option<unsafe extern "C" fn(str_: *mut char16_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_string_utf16_t"][::std::mem::size_of::<_cef_string_utf16_t>() - 24usize];
    ["Alignment of _cef_string_utf16_t"][::std::mem::align_of::<_cef_string_utf16_t>() - 8usize];
    ["Offset of field: _cef_string_utf16_t::str_"]
        [::std::mem::offset_of!(_cef_string_utf16_t, str_) - 0usize];
    ["Offset of field: _cef_string_utf16_t::length"]
        [::std::mem::offset_of!(_cef_string_utf16_t, length) - 8usize];
    ["Offset of field: _cef_string_utf16_t::dtor"]
        [::std::mem::offset_of!(_cef_string_utf16_t, dtor) - 16usize];
};
pub type cef_string_utf16_t = _cef_string_utf16_t;
unsafe extern "C" {
    #[doc = "\n These functions set string values. If |copy| is true (1) the value will be\n copied instead of referenced. It is up to the user to properly manage\n the lifespan of references.\n"]
    pub fn cef_string_wide_set(
        src: *const wchar_t,
        src_len: usize,
        output: *mut cef_string_wide_t,
        copy: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf8_set(
        src: *const ::std::os::raw::c_char,
        src_len: usize,
        output: *mut cef_string_utf8_t,
        copy: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf16_set(
        src: *const char16_t,
        src_len: usize,
        output: *mut cef_string_utf16_t,
        copy: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n These functions clear string values. The structure itself is not freed.\n"]
    pub fn cef_string_wide_clear(str_: *mut cef_string_wide_t);
}
unsafe extern "C" {
    pub fn cef_string_utf8_clear(str_: *mut cef_string_utf8_t);
}
unsafe extern "C" {
    pub fn cef_string_utf16_clear(str_: *mut cef_string_utf16_t);
}
unsafe extern "C" {
    #[doc = "\n These functions compare two string values with the same results as strcmp().\n"]
    pub fn cef_string_wide_cmp(
        str1: *const cef_string_wide_t,
        str2: *const cef_string_wide_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf8_cmp(
        str1: *const cef_string_utf8_t,
        str2: *const cef_string_utf8_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf16_cmp(
        str1: *const cef_string_utf16_t,
        str2: *const cef_string_utf16_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n These functions convert between UTF-8, -16, and -32 strings. They are\n potentially slow so unnecessary conversions should be avoided. The best\n possible result will always be written to |output| with the boolean return\n value indicating whether the conversion is 100% valid.\n"]
    pub fn cef_string_wide_to_utf8(
        src: *const wchar_t,
        src_len: usize,
        output: *mut cef_string_utf8_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf8_to_wide(
        src: *const ::std::os::raw::c_char,
        src_len: usize,
        output: *mut cef_string_wide_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_wide_to_utf16(
        src: *const wchar_t,
        src_len: usize,
        output: *mut cef_string_utf16_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf16_to_wide(
        src: *const char16_t,
        src_len: usize,
        output: *mut cef_string_wide_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf8_to_utf16(
        src: *const ::std::os::raw::c_char,
        src_len: usize,
        output: *mut cef_string_utf16_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf16_to_utf8(
        src: *const char16_t,
        src_len: usize,
        output: *mut cef_string_utf8_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n These functions convert an ASCII string, typically a hardcoded constant, to\n a Wide/UTF16 string. Use instead of the UTF8 conversion routines if you know\n the string is ASCII.\n"]
    pub fn cef_string_ascii_to_wide(
        src: *const ::std::os::raw::c_char,
        src_len: usize,
        output: *mut cef_string_wide_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_ascii_to_utf16(
        src: *const ::std::os::raw::c_char,
        src_len: usize,
        output: *mut cef_string_utf16_t,
    ) -> ::std::os::raw::c_int;
}
#[doc = "\n It is sometimes necessary for the system to allocate string structures with\n the expectation that the user will free them. The userfree types act as a\n hint that the user is responsible for freeing the structure.\n"]
pub type cef_string_userfree_wide_t = *mut cef_string_wide_t;
pub type cef_string_userfree_utf8_t = *mut cef_string_utf8_t;
pub type cef_string_userfree_utf16_t = *mut cef_string_utf16_t;
unsafe extern "C" {
    #[doc = "\n These functions allocate a new string structure. They must be freed by\n calling the associated free function.\n"]
    pub fn cef_string_userfree_wide_alloc() -> cef_string_userfree_wide_t;
}
unsafe extern "C" {
    pub fn cef_string_userfree_utf8_alloc() -> cef_string_userfree_utf8_t;
}
unsafe extern "C" {
    pub fn cef_string_userfree_utf16_alloc() -> cef_string_userfree_utf16_t;
}
unsafe extern "C" {
    #[doc = "\n These functions free the string structure allocated by the associated\n alloc function. Any string contents will first be cleared.\n"]
    pub fn cef_string_userfree_wide_free(str_: cef_string_userfree_wide_t);
}
unsafe extern "C" {
    pub fn cef_string_userfree_utf8_free(str_: cef_string_userfree_utf8_t);
}
unsafe extern "C" {
    pub fn cef_string_userfree_utf16_free(str_: cef_string_userfree_utf16_t);
}
unsafe extern "C" {
    #[doc = "\n These functions convert utf16 string case using the current ICU locale. This\n may change the length of the string in some cases.\n"]
    pub fn cef_string_utf16_to_lower(
        src: *const char16_t,
        src_len: usize,
        output: *mut cef_string_utf16_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_string_utf16_to_upper(
        src: *const char16_t,
        src_len: usize,
        output: *mut cef_string_utf16_t,
    ) -> ::std::os::raw::c_int;
}
pub type cef_char_t = char16_t;
pub type cef_string_userfree_t = cef_string_userfree_utf16_t;
pub type cef_string_t = cef_string_utf16_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_string_list_t {
    _unused: [u8; 0],
}
#[doc = "\n CEF string maps are a set of key/value string pairs.\n"]
pub type cef_string_list_t = *mut _cef_string_list_t;
unsafe extern "C" {
    #[doc = "\n Allocate a new string map.\n"]
    pub fn cef_string_list_alloc() -> cef_string_list_t;
}
unsafe extern "C" {
    #[doc = "\n Return the number of elements in the string list.\n"]
    pub fn cef_string_list_size(list: cef_string_list_t) -> usize;
}
unsafe extern "C" {
    #[doc = "\n Retrieve the value at the specified zero-based string list index. Returns\n true (1) if the value was successfully retrieved.\n"]
    pub fn cef_string_list_value(
        list: cef_string_list_t,
        index: usize,
        value: *mut cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Append a new value at the end of the string list.\n"]
    pub fn cef_string_list_append(list: cef_string_list_t, value: *const cef_string_t);
}
unsafe extern "C" {
    #[doc = "\n Clear the string list.\n"]
    pub fn cef_string_list_clear(list: cef_string_list_t);
}
unsafe extern "C" {
    #[doc = "\n Free the string list.\n"]
    pub fn cef_string_list_free(list: cef_string_list_t);
}
unsafe extern "C" {
    #[doc = "\n Creates a copy of an existing string list.\n"]
    pub fn cef_string_list_copy(list: cef_string_list_t) -> cef_string_list_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_string_map_t {
    _unused: [u8; 0],
}
#[doc = "\n CEF string maps are a set of key/value string pairs.\n"]
pub type cef_string_map_t = *mut _cef_string_map_t;
unsafe extern "C" {
    #[doc = "\n Allocate a new string map.\n"]
    pub fn cef_string_map_alloc() -> cef_string_map_t;
}
unsafe extern "C" {
    #[doc = "\n Return the number of elements in the string map.\n"]
    pub fn cef_string_map_size(map: cef_string_map_t) -> usize;
}
unsafe extern "C" {
    #[doc = "\n Return the value assigned to the specified key.\n"]
    pub fn cef_string_map_find(
        map: cef_string_map_t,
        key: *const cef_string_t,
        value: *mut cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Return the key at the specified zero-based string map index.\n"]
    pub fn cef_string_map_key(
        map: cef_string_map_t,
        index: usize,
        key: *mut cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Return the value at the specified zero-based string map index.\n"]
    pub fn cef_string_map_value(
        map: cef_string_map_t,
        index: usize,
        value: *mut cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Append a new key/value pair at the end of the string map. If the key exists,\n overwrite the existing value with a new value w/o changing the pair order.\n"]
    pub fn cef_string_map_append(
        map: cef_string_map_t,
        key: *const cef_string_t,
        value: *const cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Clear the string map.\n"]
    pub fn cef_string_map_clear(map: cef_string_map_t);
}
unsafe extern "C" {
    #[doc = "\n Free the string map.\n"]
    pub fn cef_string_map_free(map: cef_string_map_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_string_multimap_t {
    _unused: [u8; 0],
}
#[doc = "\n CEF string multimaps are a set of key/value string pairs.\n More than one value can be assigned to a single key.\n"]
pub type cef_string_multimap_t = *mut _cef_string_multimap_t;
unsafe extern "C" {
    #[doc = "\n Allocate a new string multimap.\n"]
    pub fn cef_string_multimap_alloc() -> cef_string_multimap_t;
}
unsafe extern "C" {
    #[doc = "\n Return the number of elements in the string multimap.\n"]
    pub fn cef_string_multimap_size(map: cef_string_multimap_t) -> usize;
}
unsafe extern "C" {
    #[doc = "\n Return the number of values with the specified key.\n"]
    pub fn cef_string_multimap_find_count(
        map: cef_string_multimap_t,
        key: *const cef_string_t,
    ) -> usize;
}
unsafe extern "C" {
    #[doc = "\n Return the value_index-th value with the specified key.\n"]
    pub fn cef_string_multimap_enumerate(
        map: cef_string_multimap_t,
        key: *const cef_string_t,
        value_index: usize,
        value: *mut cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Return the key at the specified zero-based string multimap index.\n"]
    pub fn cef_string_multimap_key(
        map: cef_string_multimap_t,
        index: usize,
        key: *mut cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Return the value at the specified zero-based string multimap index.\n"]
    pub fn cef_string_multimap_value(
        map: cef_string_multimap_t,
        index: usize,
        value: *mut cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Append a new key/value pair at the end of the string multimap.\n"]
    pub fn cef_string_multimap_append(
        map: cef_string_multimap_t,
        key: *const cef_string_t,
        value: *const cef_string_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Clear the string multimap.\n"]
    pub fn cef_string_multimap_clear(map: cef_string_multimap_t);
}
unsafe extern "C" {
    #[doc = "\n Free the string multimap.\n"]
    pub fn cef_string_multimap_free(map: cef_string_multimap_t);
}
#[doc = "\n Represents a wall clock time in UTC. Values are not guaranteed to be\n monotonically non-decreasing and are subject to large amounts of skew.\n Time is stored internally as microseconds since the Windows epoch (1601).\n\n This is equivalent of Chromium `base::Time` (see base/time/time.h).\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_basetime_t {
    pub val: i64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_basetime_t"][::std::mem::size_of::<_cef_basetime_t>() - 8usize];
    ["Alignment of _cef_basetime_t"][::std::mem::align_of::<_cef_basetime_t>() - 8usize];
    ["Offset of field: _cef_basetime_t::val"]
        [::std::mem::offset_of!(_cef_basetime_t, val) - 0usize];
};
#[doc = "\n Represents a wall clock time in UTC. Values are not guaranteed to be\n monotonically non-decreasing and are subject to large amounts of skew.\n Time is stored internally as microseconds since the Windows epoch (1601).\n\n This is equivalent of Chromium `base::Time` (see base/time/time.h).\n"]
pub type cef_basetime_t = _cef_basetime_t;
#[doc = "\n Time information. Values should always be in UTC.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_time_t {
    #[doc = "\n Four or five digit year \"2007\" (1601 to 30827 on Windows, 1970 to 2038 on\n 32-bit POSIX)\n"]
    pub year: ::std::os::raw::c_int,
    #[doc = "\n 1-based month (values 1 = January, etc.)\n"]
    pub month: ::std::os::raw::c_int,
    #[doc = "\n 0-based day of week (0 = Sunday, etc.)\n"]
    pub day_of_week: ::std::os::raw::c_int,
    #[doc = "\n 1-based day of month (1-31)\n"]
    pub day_of_month: ::std::os::raw::c_int,
    #[doc = "\n Hour within the current day (0-23)\n"]
    pub hour: ::std::os::raw::c_int,
    #[doc = "\n Minute within the current hour (0-59)\n"]
    pub minute: ::std::os::raw::c_int,
    #[doc = "\n Second within the current minute (0-59 plus leap seconds which may take\n it up to 60).\n"]
    pub second: ::std::os::raw::c_int,
    #[doc = "\n Milliseconds within the current second (0-999)\n"]
    pub millisecond: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_time_t"][::std::mem::size_of::<_cef_time_t>() - 32usize];
    ["Alignment of _cef_time_t"][::std::mem::align_of::<_cef_time_t>() - 4usize];
    ["Offset of field: _cef_time_t::year"][::std::mem::offset_of!(_cef_time_t, year) - 0usize];
    ["Offset of field: _cef_time_t::month"][::std::mem::offset_of!(_cef_time_t, month) - 4usize];
    ["Offset of field: _cef_time_t::day_of_week"]
        [::std::mem::offset_of!(_cef_time_t, day_of_week) - 8usize];
    ["Offset of field: _cef_time_t::day_of_month"]
        [::std::mem::offset_of!(_cef_time_t, day_of_month) - 12usize];
    ["Offset of field: _cef_time_t::hour"][::std::mem::offset_of!(_cef_time_t, hour) - 16usize];
    ["Offset of field: _cef_time_t::minute"][::std::mem::offset_of!(_cef_time_t, minute) - 20usize];
    ["Offset of field: _cef_time_t::second"][::std::mem::offset_of!(_cef_time_t, second) - 24usize];
    ["Offset of field: _cef_time_t::millisecond"]
        [::std::mem::offset_of!(_cef_time_t, millisecond) - 28usize];
};
#[doc = "\n Time information. Values should always be in UTC.\n"]
pub type cef_time_t = _cef_time_t;
unsafe extern "C" {
    #[doc = "\n Converts cef_time_t to/from time_t. Returns true (1) on success and false\n (0) on failure.\n"]
    pub fn cef_time_to_timet(
        cef_time: *const cef_time_t,
        time: *mut time_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_time_from_timet(time: time_t, cef_time: *mut cef_time_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Converts cef_time_t to/from a double which is the number of seconds since\n epoch (Jan 1, 1970). Webkit uses this format to represent time. A value of 0\n means \"not initialized\". Returns true (1) on success and false (0) on\n failure.\n"]
    pub fn cef_time_to_doublet(
        cef_time: *const cef_time_t,
        time: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn cef_time_from_doublet(time: f64, cef_time: *mut cef_time_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Retrieve the current system time. Returns true (1) on success and false (0)\n on failure.\n"]
    pub fn cef_time_now(cef_time: *mut cef_time_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Retrieve the current system time.\n"]
    pub fn cef_basetime_now() -> cef_basetime_t;
}
unsafe extern "C" {
    #[doc = "\n Retrieve the delta in milliseconds between two time values. Returns true (1)\n on success and false (0) on failure."]
    pub fn cef_time_delta(
        cef_time1: *const cef_time_t,
        cef_time2: *const cef_time_t,
        delta: *mut ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Converts cef_time_t to cef_basetime_t. Returns true (1) on success and\n false (0) on failure.\n"]
    pub fn cef_time_to_basetime(
        from: *const cef_time_t,
        to: *mut cef_basetime_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Converts cef_basetime_t to cef_time_t. Returns true (1) on success and\n false (0) on failure.\n"]
    pub fn cef_time_from_basetime(
        from: cef_basetime_t,
        to: *mut cef_time_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported content setting types. Some types are platform-specific or only\n supported with Chrome style. Should be kept in sync with Chromium's\n ContentSettingsType type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_content_setting_types_t {
    #[doc = " This setting governs whether cookies are enabled by the user in the\n provided context. However, it may be overridden by other settings. This\n enum should NOT be read directly to determine whether cookies are enabled;\n the client should instead rely on the CookieSettings API."]
    CEF_CONTENT_SETTING_TYPE_COOKIES = 0,
    #[doc = " This setting governs whether cookies are enabled by the user in the\n provided context. However, it may be overridden by other settings. This\n enum should NOT be read directly to determine whether cookies are enabled;\n the client should instead rely on the CookieSettings API."]
    CEF_CONTENT_SETTING_TYPE_IMAGES = 1,
    #[doc = " This setting governs whether cookies are enabled by the user in the\n provided context. However, it may be overridden by other settings. This\n enum should NOT be read directly to determine whether cookies are enabled;\n the client should instead rely on the CookieSettings API."]
    CEF_CONTENT_SETTING_TYPE_JAVASCRIPT = 2,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_POPUPS = 3,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_GEOLOCATION = 4,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_NOTIFICATIONS = 5,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_AUTO_SELECT_CERTIFICATE = 6,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_MIXEDSCRIPT = 7,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_MEDIASTREAM_MIC = 8,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_MEDIASTREAM_CAMERA = 9,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_PROTOCOL_HANDLERS = 10,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_DEPRECATED_PPAPI_BROKER = 11,
    #[doc = " This setting governs both popups and unwanted redirects like tab-unders\n and framebusting."]
    CEF_CONTENT_SETTING_TYPE_AUTOMATIC_DOWNLOADS = 12,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_MIDI_SYSEX = 13,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_SSL_CERT_DECISIONS = 14,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_PROTECTED_MEDIA_IDENTIFIER = 15,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_APP_BANNER = 16,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_SITE_ENGAGEMENT = 17,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_DURABLE_STORAGE = 18,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_USB_CHOOSER_DATA = 19,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_BLUETOOTH_GUARD = 20,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_BACKGROUND_SYNC = 21,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_AUTOPLAY = 22,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_IMPORTANT_SITE_INFO = 23,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_PERMISSION_AUTOBLOCKER_DATA = 24,
    #[doc = " Advanced device-specific functions on MIDI devices. MIDI-SysEx\n communications can be used for changing the MIDI device's persistent state\n such as firmware."]
    CEF_CONTENT_SETTING_TYPE_ADS = 25,
    #[doc = " Website setting which stores metadata for the subresource filter to aid in\n decisions for whether or not to show the UI."]
    CEF_CONTENT_SETTING_TYPE_ADS_DATA = 26,
    #[doc = " MIDI stands for Musical Instrument Digital Interface. It is a standard\n that allows electronic musical instruments, computers, and other devices\n to communicate with each other."]
    CEF_CONTENT_SETTING_TYPE_MIDI = 27,
    #[doc = " This content setting type is for caching password protection service's\n verdicts of each origin."]
    CEF_CONTENT_SETTING_TYPE_PASSWORD_PROTECTION = 28,
    #[doc = " Website setting which stores engagement data for media related to a\n specific origin."]
    CEF_CONTENT_SETTING_TYPE_MEDIA_ENGAGEMENT = 29,
    #[doc = " Content setting which stores whether or not the site can play audible\n sound. This will not block playback but instead the user will not hear it."]
    CEF_CONTENT_SETTING_TYPE_SOUND = 30,
    #[doc = " Website setting which stores the list of client hints that the origin\n requested the browser to remember. The browser is expected to send all\n client hints in the HTTP request headers for every resource requested\n from that origin."]
    CEF_CONTENT_SETTING_TYPE_CLIENT_HINTS = 31,
    #[doc = " Generic Sensor API covering ambient-light-sensor, accelerometer, gyroscope\n and magnetometer are all mapped to a single content_settings_type.\n Setting for the Generic Sensor API covering ambient-light-sensor,\n accelerometer, gyroscope and magnetometer. These are all mapped to a\n single ContentSettingsType."]
    CEF_CONTENT_SETTING_TYPE_SENSORS = 32,
    #[doc = " Content setting which stores whether or not the user has granted the site\n permission to respond to accessibility events, which can be used to\n provide a custom accessibility experience. Requires explicit user consent\n because some users may not want sites to know they're using assistive\n technology. Deprecated in M131."]
    CEF_CONTENT_SETTING_TYPE_DEPRECATED_ACCESSIBILITY_EVENTS = 33,
    #[doc = " Used to store whether to allow a website to install a payment handler."]
    CEF_CONTENT_SETTING_TYPE_PAYMENT_HANDLER = 34,
    #[doc = " Content setting which stores whether to allow sites to ask for permission\n to access USB devices. If this is allowed specific device permissions are\n stored under USB_CHOOSER_DATA."]
    CEF_CONTENT_SETTING_TYPE_USB_GUARD = 35,
    #[doc = " Nothing is stored in this setting at present. Please refer to\n BackgroundFetchPermissionContext for details on how this permission\n is ascertained."]
    CEF_CONTENT_SETTING_TYPE_BACKGROUND_FETCH = 36,
    #[doc = " Website setting which stores the amount of times the user has dismissed\n intent picker UI without explicitly choosing an option."]
    CEF_CONTENT_SETTING_TYPE_INTENT_PICKER_DISPLAY = 37,
    #[doc = " Used to store whether to allow a website to detect user active/idle state."]
    CEF_CONTENT_SETTING_TYPE_IDLE_DETECTION = 38,
    #[doc = " Content settings for access to serial ports. The \"guard\" content setting\n stores whether to allow sites to ask for permission to access a port. The\n permissions granted to access particular ports are stored in the \"chooser\n data\" website setting."]
    CEF_CONTENT_SETTING_TYPE_SERIAL_GUARD = 39,
    #[doc = " Content settings for access to serial ports. The \"guard\" content setting\n stores whether to allow sites to ask for permission to access a port. The\n permissions granted to access particular ports are stored in the \"chooser\n data\" website setting."]
    CEF_CONTENT_SETTING_TYPE_SERIAL_CHOOSER_DATA = 40,
    #[doc = " Nothing is stored in this setting at present. Please refer to\n PeriodicBackgroundSyncPermissionContext for details on how this permission\n is ascertained.\n This content setting is not registered because it does not require access\n to any existing providers."]
    CEF_CONTENT_SETTING_TYPE_PERIODIC_BACKGROUND_SYNC = 41,
    #[doc = " Content setting which stores whether to allow sites to ask for permission\n to do Bluetooth scanning."]
    CEF_CONTENT_SETTING_TYPE_BLUETOOTH_SCANNING = 42,
    #[doc = " Content settings for access to HID devices. The \"guard\" content setting\n stores whether to allow sites to ask for permission to access a device.\n The permissions granted to access particular devices are stored in the\n \"chooser data\" website setting."]
    CEF_CONTENT_SETTING_TYPE_HID_GUARD = 43,
    #[doc = " Content settings for access to HID devices. The \"guard\" content setting\n stores whether to allow sites to ask for permission to access a device.\n The permissions granted to access particular devices are stored in the\n \"chooser data\" website setting."]
    CEF_CONTENT_SETTING_TYPE_HID_CHOOSER_DATA = 44,
    #[doc = " Wake Lock API, which has two lock types: screen and system locks.\n Currently, screen locks do not need any additional permission, and system\n locks are always denied while the right UI is worked out."]
    CEF_CONTENT_SETTING_TYPE_WAKE_LOCK_SCREEN = 45,
    #[doc = " Wake Lock API, which has two lock types: screen and system locks.\n Currently, screen locks do not need any additional permission, and system\n locks are always denied while the right UI is worked out."]
    CEF_CONTENT_SETTING_TYPE_WAKE_LOCK_SYSTEM = 46,
    #[doc = " Legacy SameSite cookie behavior. This disables SameSite=Lax-by-default,\n SameSite=None requires Secure, and Schemeful Same-Site, forcing the\n legacy behavior wherein 1) cookies that don't specify SameSite are treated\n as SameSite=None, 2) SameSite=None cookies are not required to be Secure,\n and 3) schemeful same-site is not active.\n\n This will also be used to revert to legacy behavior when future changes\n in cookie handling are introduced."]
    CEF_CONTENT_SETTING_TYPE_LEGACY_COOKIE_ACCESS = 47,
    #[doc = " Content settings which stores whether to allow sites to ask for permission\n to save changes to an original file selected by the user through the\n File System Access API."]
    CEF_CONTENT_SETTING_TYPE_FILE_SYSTEM_WRITE_GUARD = 48,
    #[doc = " Used to store whether to allow a website to exchange data with NFC\n devices."]
    CEF_CONTENT_SETTING_TYPE_NFC = 49,
    #[doc = " Website setting to store permissions granted to access particular\n Bluetooth devices."]
    CEF_CONTENT_SETTING_TYPE_BLUETOOTH_CHOOSER_DATA = 50,
    #[doc = " Full access to the system clipboard (sanitized read without user gesture,\n and unsanitized read and write with user gesture)."]
    CEF_CONTENT_SETTING_TYPE_CLIPBOARD_READ_WRITE = 51,
    #[doc = " This is special-cased in the permissions layer to always allow, and as\n such doesn't have associated prefs data."]
    CEF_CONTENT_SETTING_TYPE_CLIPBOARD_SANITIZED_WRITE = 52,
    #[doc = " This content setting type is for caching safe browsing real time url\n check's verdicts of each origin."]
    CEF_CONTENT_SETTING_TYPE_SAFE_BROWSING_URL_CHECK_DATA = 53,
    #[doc = " Used to store whether a site is allowed to request AR or VR sessions with\n the WebXr Device API."]
    CEF_CONTENT_SETTING_TYPE_VR = 54,
    #[doc = " Used to store whether a site is allowed to request AR or VR sessions with\n the WebXr Device API."]
    CEF_CONTENT_SETTING_TYPE_AR = 55,
    #[doc = " Content setting which stores whether to allow site to open and read files\n and directories selected through the File System Access API."]
    CEF_CONTENT_SETTING_TYPE_FILE_SYSTEM_READ_GUARD = 56,
    #[doc = " Access to first party storage in a third-party context. Exceptions are\n scoped to the combination of requesting/top-level origin, and are managed\n through the Storage Access API. For the time being, this content setting\n exists in parallel to third-party cookie rules stored in COOKIES."]
    CEF_CONTENT_SETTING_TYPE_STORAGE_ACCESS = 57,
    #[doc = " Content setting which stores whether to allow a site to control camera\n movements. It does not give access to camera."]
    CEF_CONTENT_SETTING_TYPE_CAMERA_PAN_TILT_ZOOM = 58,
    #[doc = " Content setting for Screen Enumeration and Screen Detail functionality.\n Permits access to detailed multi-screen information, like size and\n position. Permits placing fullscreen and windowed content on specific\n screens. See also: https://w3c.github.io/window-placement"]
    CEF_CONTENT_SETTING_TYPE_WINDOW_MANAGEMENT = 59,
    CEF_CONTENT_SETTING_TYPE_INSECURE_PRIVATE_NETWORK_DEPRECATED = 60,
    #[doc = " Content setting which stores whether or not a site can access low-level\n locally installed font data using the Local Fonts Access API."]
    CEF_CONTENT_SETTING_TYPE_LOCAL_FONTS = 61,
    #[doc = " Stores per-origin state for permission auto-revocation (for all permission\n types)."]
    CEF_CONTENT_SETTING_TYPE_PERMISSION_AUTOREVOCATION_DATA = 62,
    #[doc = " Stores per-origin state of the most recently selected directory for the\n use by the File System Access API."]
    CEF_CONTENT_SETTING_TYPE_FILE_SYSTEM_LAST_PICKED_DIRECTORY = 63,
    #[doc = " Controls access to the getDisplayMedia API."]
    CEF_CONTENT_SETTING_TYPE_DISPLAY_CAPTURE = 64,
    #[doc = " Website setting to store permissions metadata granted to paths on the\n local file system via the File System Access API.\n |FILE_SYSTEM_WRITE_GUARD| is the corresponding \"guard\" setting. The stored\n data represents valid permission only if\n |FILE_SYSTEM_ACCESS_EXTENDED_PERMISSION| is enabled via user opt-in.\n Otherwise, they represent \"recently granted but revoked permission\", which\n are used to restore the permission."]
    CEF_CONTENT_SETTING_TYPE_FILE_SYSTEM_ACCESS_CHOOSER_DATA = 65,
    #[doc = " Stores a grant that allows a relying party to send a request for identity\n information to specified identity providers, potentially through any\n anti-tracking measures that would otherwise prevent it. This setting is\n associated with the relying party's origin."]
    CEF_CONTENT_SETTING_TYPE_FEDERATED_IDENTITY_SHARING = 66,
    #[doc = " Whether to use the v8 optimized JIT for running JavaScript on the page."]
    CEF_CONTENT_SETTING_TYPE_JAVASCRIPT_JIT = 67,
    #[doc = " Content setting which stores user decisions to allow loading a site over\n HTTP. Entries are added by hostname when a user bypasses the HTTPS-First\n Mode interstitial warning when a site does not support HTTPS. Allowed\n hosts are exact hostname matches -- subdomains of a host on the allowlist\n must be separately allowlisted."]
    CEF_CONTENT_SETTING_TYPE_HTTP_ALLOWED = 68,
    #[doc = " Stores metadata related to form fill, such as e.g. whether user data was\n autofilled on a specific website."]
    CEF_CONTENT_SETTING_TYPE_FORMFILL_METADATA = 69,
    #[doc = " Setting to indicate that there is an active federated sign-in session\n between a specified relying party and a specified identity provider for\n a specified account. When this is present it allows access to session\n management capabilities between the sites. This setting is associated\n with the relying party's origin."]
    CEF_CONTENT_SETTING_TYPE_DEPRECATED_FEDERATED_IDENTITY_ACTIVE_SESSION = 70,
    #[doc = " Setting to indicate whether Chrome should automatically apply darkening to\n web content."]
    CEF_CONTENT_SETTING_TYPE_AUTO_DARK_WEB_CONTENT = 71,
    #[doc = " Setting to indicate whether Chrome should request the desktop view of a\n site instead of the mobile one."]
    CEF_CONTENT_SETTING_TYPE_REQUEST_DESKTOP_SITE = 72,
    #[doc = " Setting to indicate whether browser should allow signing into a website\n via the browser FedCM API."]
    CEF_CONTENT_SETTING_TYPE_FEDERATED_IDENTITY_API = 73,
    #[doc = " Stores notification interactions per origin for the past 90 days.\n Interactions per origin are pre-aggregated over seven-day windows: A\n notification interaction or display is assigned to the last Monday\n midnight in local time."]
    CEF_CONTENT_SETTING_TYPE_NOTIFICATION_INTERACTIONS = 74,
    #[doc = " Website setting which stores the last reduced accept language negotiated\n for a given origin, to be used on future visits to the origin."]
    CEF_CONTENT_SETTING_TYPE_REDUCED_ACCEPT_LANGUAGE = 75,
    #[doc = " Website setting which is used for NotificationPermissionReviewService to\n store origin blocklist from review notification permissions feature."]
    CEF_CONTENT_SETTING_TYPE_NOTIFICATION_PERMISSION_REVIEW = 76,
    #[doc = " Website setting to store permissions granted to access particular devices\n in private network."]
    CEF_CONTENT_SETTING_TYPE_PRIVATE_NETWORK_GUARD = 77,
    #[doc = " Website setting to store permissions granted to access particular devices\n in private network."]
    CEF_CONTENT_SETTING_TYPE_PRIVATE_NETWORK_CHOOSER_DATA = 78,
    #[doc = " Website setting which stores whether the browser has observed the user\n signing into an identity-provider based on observing the IdP-SignIn-Status\n HTTP header."]
    CEF_CONTENT_SETTING_TYPE_FEDERATED_IDENTITY_IDENTITY_PROVIDER_SIGNIN_STATUS = 79,
    #[doc = " Website setting which is used for RevokedPermissionsService to\n store revoked permissions of unused sites from unused site permissions\n feature."]
    CEF_CONTENT_SETTING_TYPE_REVOKED_UNUSED_SITE_PERMISSIONS = 80,
    #[doc = " Similar to STORAGE_ACCESS, but applicable at the page-level rather than\n being specific to a frame."]
    CEF_CONTENT_SETTING_TYPE_TOP_LEVEL_STORAGE_ACCESS = 81,
    #[doc = " Setting to indicate whether user has opted in to allowing auto re-authn\n via the FedCM API."]
    CEF_CONTENT_SETTING_TYPE_FEDERATED_IDENTITY_AUTO_REAUTHN_PERMISSION = 82,
    #[doc = " Website setting which stores whether the user has explicitly registered\n a website as an identity-provider."]
    CEF_CONTENT_SETTING_TYPE_FEDERATED_IDENTITY_IDENTITY_PROVIDER_REGISTRATION = 83,
    #[doc = " Content setting which is used to indicate whether anti-abuse functionality\n should be enabled."]
    CEF_CONTENT_SETTING_TYPE_ANTI_ABUSE = 84,
    #[doc = " Content setting used to indicate whether third-party storage partitioning\n should be enabled."]
    CEF_CONTENT_SETTING_TYPE_THIRD_PARTY_STORAGE_PARTITIONING = 85,
    #[doc = " Used to indicate whether HTTPS-First Mode is enabled on the hostname."]
    CEF_CONTENT_SETTING_TYPE_HTTPS_ENFORCED = 86,
    #[doc = " Setting for enabling the `getAllScreensMedia` API. Spec link:\n https://github.com/screen-share/capture-all-screens"]
    CEF_CONTENT_SETTING_TYPE_ALL_SCREEN_CAPTURE = 87,
    #[doc = " Stores per origin metadata for cookie controls."]
    CEF_CONTENT_SETTING_TYPE_COOKIE_CONTROLS_METADATA = 88,
    #[doc = " Content Setting for temporary 3PC accesses granted by user behavior\n heuristics."]
    CEF_CONTENT_SETTING_TYPE_TPCD_HEURISTICS_GRANTS = 89,
    #[doc = " Content Setting for 3PC accesses granted by metadata delivered via the\n component updater service. This type will only be used when\n `net::features::kTpcdMetadataGrants` is enabled."]
    CEF_CONTENT_SETTING_TYPE_TPCD_METADATA_GRANTS = 90,
    #[doc = " Content Setting for 3PC accesses granted via 3PC deprecation trial."]
    CEF_CONTENT_SETTING_TYPE_TPCD_TRIAL = 91,
    #[doc = " Content Setting for 3PC accesses granted via top-level 3PC deprecation\n trial. Similar to TPCD_TRIAL, but applicable at the page-level for the\n lifetime of the page that served the token, rather than being specific to\n a requesting-origin/top-level-site combination and persistent."]
    CEF_CONTENT_SETTING_TYPE_TOP_LEVEL_TPCD_TRIAL = 92,
    CEF_CONTENT_SETTING_TYPE_TOP_LEVEL_TPCD_ORIGIN_TRIAL = 93,
    #[doc = " Content setting used to indicate whether entering picture-in-picture\n automatically should be enabled."]
    CEF_CONTENT_SETTING_TYPE_AUTO_PICTURE_IN_PICTURE = 94,
    #[doc = " Whether user has opted into keeping file/directory permissions persistent\n between visits for a given origin. When enabled, permission metadata\n stored under |FILE_SYSTEM_ACCESS_CHOOSER_DATA| can auto-grant incoming\n permission request."]
    CEF_CONTENT_SETTING_TYPE_FILE_SYSTEM_ACCESS_EXTENDED_PERMISSION = 95,
    #[doc = " Whether the FSA Persistent Permissions restore prompt is eligible to be\n shown to the user, for a given origin."]
    CEF_CONTENT_SETTING_TYPE_FILE_SYSTEM_ACCESS_RESTORE_PERMISSION = 96,
    #[doc = " Whether an application capturing another tab, may scroll and zoom\n the captured tab."]
    CEF_CONTENT_SETTING_TYPE_CAPTURED_SURFACE_CONTROL = 97,
    #[doc = " Content setting for access to smart card readers.\n The \"guard\" content setting stores whether to allow sites to access the\n Smart Card API."]
    CEF_CONTENT_SETTING_TYPE_SMART_CARD_GUARD = 98,
    #[doc = " Content setting for access to smart card readers.\n The \"guard\" content setting stores whether to allow sites to access the\n Smart Card API."]
    CEF_CONTENT_SETTING_TYPE_SMART_CARD_DATA = 99,
    #[doc = " Content settings for access to printers for the Web Printing API."]
    CEF_CONTENT_SETTING_TYPE_WEB_PRINTING = 100,
    #[doc = " Content setting used to indicate whether entering HTML Fullscreen\n automatically (i.e. without transient activation) should be enabled."]
    CEF_CONTENT_SETTING_TYPE_AUTOMATIC_FULLSCREEN = 101,
    #[doc = " Content settings used to indicate that a web app is allowed to prompt the\n user for the installation of sub apps."]
    CEF_CONTENT_SETTING_TYPE_SUB_APP_INSTALLATION_PROMPTS = 102,
    #[doc = " Whether an application can enumerate audio output device."]
    CEF_CONTENT_SETTING_TYPE_SPEAKER_SELECTION = 103,
    #[doc = " Content settings for access to the Direct Sockets API."]
    CEF_CONTENT_SETTING_TYPE_DIRECT_SOCKETS = 104,
    #[doc = " Keyboard Lock API allows a site to capture keyboard inputs that would\n otherwise be handled by the OS or the browser."]
    CEF_CONTENT_SETTING_TYPE_KEYBOARD_LOCK = 105,
    #[doc = " Pointer Lock API allows a site to hide the cursor and have exclusive\n access to mouse inputs."]
    CEF_CONTENT_SETTING_TYPE_POINTER_LOCK = 106,
    #[doc = " Website setting which is used for RevokedPermissionsService to store\n auto-revoked notification permissions from abusive sites."]
    CEF_CONTENT_SETTING_TYPE_REVOKED_ABUSIVE_NOTIFICATION_PERMISSIONS = 107,
    #[doc = " Content setting that controls tracking protection status per site.\n BLOCK: Protections enabled. This is the default state.\n ALLOW: Protections disabled."]
    CEF_CONTENT_SETTING_TYPE_TRACKING_PROTECTION = 108,
    #[doc = " With this permission, when the application calls `getDisplayMedia()`, a\n system audio track can be returned without showing the display media\n selection picker. The application can explicitly specify\n `systemAudio: 'exclude'` or `video: true` to still show the display media\n selection picker if needed. Please note that the setting only works for\n WebUI."]
    CEF_CONTENT_SETTING_TYPE_DISPLAY_MEDIA_SYSTEM_AUDIO = 109,
    #[doc = " Whether to use the higher-tier v8 optimizers for running JavaScript on the\n page."]
    CEF_CONTENT_SETTING_TYPE_JAVASCRIPT_OPTIMIZER = 110,
    #[doc = " Content Setting for the Storage Access Headers persistent origin trial\n that allows origins to opt into the storage access header behavior. Should\n be scoped to `REQUESTING_ORIGIN_AND_TOP_SCHEMEFUL_SITE_SCOPE` in order to\n correspond to the design of persistent origin trials. See also:\n https://github.com/cfredric/storage-access-headers\n ALLOW: storage access request headers will be attached to cross-site\n        requests, and url requests will look for response headers from\n        origins to retry a request or load with storage access.\n BLOCK (default): no effect."]
    CEF_CONTENT_SETTING_TYPE_STORAGE_ACCESS_HEADER_ORIGIN_TRIAL = 111,
    #[doc = " Whether or not sites can request Hand Tracking data within WebXR Sessions."]
    CEF_CONTENT_SETTING_TYPE_HAND_TRACKING = 112,
    #[doc = " Website setting to indicate whether user has opted in to allow web apps to\n install other web apps."]
    CEF_CONTENT_SETTING_TYPE_WEB_APP_INSTALLATION = 113,
    #[doc = " Content settings for private network access in the context of the\n Direct Sockets API."]
    CEF_CONTENT_SETTING_TYPE_DIRECT_SOCKETS_PRIVATE_NETWORK_ACCESS = 114,
    #[doc = " Content settings for legacy cookie scope.\n Checks whether cookies scope is handled according to origin-bound cookies\n or legacy behavior."]
    CEF_CONTENT_SETTING_TYPE_LEGACY_COOKIE_SCOPE = 115,
    #[doc = " Website setting to indicate whether the user has allowlisted suspicious\n notifications for the origin."]
    CEF_CONTENT_SETTING_TYPE_ARE_SUSPICIOUS_NOTIFICATIONS_ALLOWLISTED_BY_USER = 116,
    #[doc = " Content settings for access to the Controlled Frame API."]
    CEF_CONTENT_SETTING_TYPE_CONTROLLED_FRAME = 117,
    #[doc = " Website setting which is used for RevokedPermissionsService to\n store revoked notification permissions of disruptive sites."]
    CEF_CONTENT_SETTING_TYPE_REVOKED_DISRUPTIVE_NOTIFICATION_PERMISSIONS = 118,
    #[doc = " Content setting for whether the site is allowed to make local network\n requests."]
    CEF_CONTENT_SETTING_TYPE_LOCAL_NETWORK_ACCESS = 119,
    #[doc = " Stores information on-device language packs for which a site has\n installed using the Web Speech API."]
    CEF_CONTENT_SETTING_TYPE_ON_DEVICE_SPEECH_RECOGNITION_LANGUAGES_DOWNLOADED = 120,
    #[doc = " Stores which Translator API language packs the site has initialized."]
    CEF_CONTENT_SETTING_TYPE_INITIALIZED_TRANSLATIONS = 121,
    #[doc = " Stores a list of notification ids where content detection found the\n notification to be suspicious and a warning has already been shown for the\n site. Used for recovering notification contents from the database if the\n user decides they would like to see all of these notifications."]
    CEF_CONTENT_SETTING_TYPE_SUSPICIOUS_NOTIFICATION_IDS = 122,
    CEF_CONTENT_SETTING_TYPE_NUM_VALUES = 123,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported content setting values. Should be kept in sync with Chromium's\n ContentSetting type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_content_setting_values_t {
    CEF_CONTENT_SETTING_VALUE_DEFAULT = 0,
    CEF_CONTENT_SETTING_VALUE_ALLOW = 1,
    CEF_CONTENT_SETTING_VALUE_BLOCK = 2,
    CEF_CONTENT_SETTING_VALUE_ASK = 3,
    CEF_CONTENT_SETTING_VALUE_SESSION_ONLY = 4,
    CEF_CONTENT_SETTING_VALUE_DETECT_IMPORTANT_CONTENT = 5,
    CEF_CONTENT_SETTING_VALUE_NUM_VALUES = 6,
}
#[doc = "\n Structure representing a point.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_point_t {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_point_t"][::std::mem::size_of::<_cef_point_t>() - 8usize];
    ["Alignment of _cef_point_t"][::std::mem::align_of::<_cef_point_t>() - 4usize];
    ["Offset of field: _cef_point_t::x"][::std::mem::offset_of!(_cef_point_t, x) - 0usize];
    ["Offset of field: _cef_point_t::y"][::std::mem::offset_of!(_cef_point_t, y) - 4usize];
};
#[doc = "\n Structure representing a point.\n"]
pub type cef_point_t = _cef_point_t;
#[doc = "\n Structure representing a rectangle.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_rect_t {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_rect_t"][::std::mem::size_of::<_cef_rect_t>() - 16usize];
    ["Alignment of _cef_rect_t"][::std::mem::align_of::<_cef_rect_t>() - 4usize];
    ["Offset of field: _cef_rect_t::x"][::std::mem::offset_of!(_cef_rect_t, x) - 0usize];
    ["Offset of field: _cef_rect_t::y"][::std::mem::offset_of!(_cef_rect_t, y) - 4usize];
    ["Offset of field: _cef_rect_t::width"][::std::mem::offset_of!(_cef_rect_t, width) - 8usize];
    ["Offset of field: _cef_rect_t::height"][::std::mem::offset_of!(_cef_rect_t, height) - 12usize];
};
#[doc = "\n Structure representing a rectangle.\n"]
pub type cef_rect_t = _cef_rect_t;
#[doc = "\n Structure representing a size.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_size_t {
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_size_t"][::std::mem::size_of::<_cef_size_t>() - 8usize];
    ["Alignment of _cef_size_t"][::std::mem::align_of::<_cef_size_t>() - 4usize];
    ["Offset of field: _cef_size_t::width"][::std::mem::offset_of!(_cef_size_t, width) - 0usize];
    ["Offset of field: _cef_size_t::height"][::std::mem::offset_of!(_cef_size_t, height) - 4usize];
};
#[doc = "\n Structure representing a size.\n"]
pub type cef_size_t = _cef_size_t;
#[doc = "\n Structure representing insets.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_insets_t {
    pub top: ::std::os::raw::c_int,
    pub left: ::std::os::raw::c_int,
    pub bottom: ::std::os::raw::c_int,
    pub right: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_insets_t"][::std::mem::size_of::<_cef_insets_t>() - 16usize];
    ["Alignment of _cef_insets_t"][::std::mem::align_of::<_cef_insets_t>() - 4usize];
    ["Offset of field: _cef_insets_t::top"][::std::mem::offset_of!(_cef_insets_t, top) - 0usize];
    ["Offset of field: _cef_insets_t::left"][::std::mem::offset_of!(_cef_insets_t, left) - 4usize];
    ["Offset of field: _cef_insets_t::bottom"]
        [::std::mem::offset_of!(_cef_insets_t, bottom) - 8usize];
    ["Offset of field: _cef_insets_t::right"]
        [::std::mem::offset_of!(_cef_insets_t, right) - 12usize];
};
#[doc = "\n Structure representing insets.\n"]
pub type cef_insets_t = _cef_insets_t;
pub type DWORD = ::std::os::raw::c_ulong;
pub type UINT = ::std::os::raw::c_uint;
pub type UINT_PTR = ::std::os::raw::c_ulonglong;
pub type LONG_PTR = ::std::os::raw::c_longlong;
pub type LONG = ::std::os::raw::c_long;
pub type HANDLE = *mut ::std::os::raw::c_void;
pub type WPARAM = UINT_PTR;
pub type LPARAM = LONG_PTR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HINSTANCE__ {
    pub unused: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of HINSTANCE__"][::std::mem::size_of::<HINSTANCE__>() - 4usize];
    ["Alignment of HINSTANCE__"][::std::mem::align_of::<HINSTANCE__>() - 4usize];
    ["Offset of field: HINSTANCE__::unused"][::std::mem::offset_of!(HINSTANCE__, unused) - 0usize];
};
#[repr(transparent)]
#[derive(Debug, Copy, Clone)]
pub struct HINSTANCE(pub *mut HINSTANCE__);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HWND__ {
    pub unused: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of HWND__"][::std::mem::size_of::<HWND__>() - 4usize];
    ["Alignment of HWND__"][::std::mem::align_of::<HWND__>() - 4usize];
    ["Offset of field: HWND__::unused"][::std::mem::offset_of!(HWND__, unused) - 0usize];
};
#[repr(transparent)]
#[derive(Debug, Copy, Clone)]
pub struct HWND(pub *mut HWND__);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HICON__ {
    pub unused: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of HICON__"][::std::mem::size_of::<HICON__>() - 4usize];
    ["Alignment of HICON__"][::std::mem::align_of::<HICON__>() - 4usize];
    ["Offset of field: HICON__::unused"][::std::mem::offset_of!(HICON__, unused) - 0usize];
};
pub type HICON = *mut HICON__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HMENU__ {
    pub unused: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of HMENU__"][::std::mem::size_of::<HMENU__>() - 4usize];
    ["Alignment of HMENU__"][::std::mem::align_of::<HMENU__>() - 4usize];
    ["Offset of field: HMENU__::unused"][::std::mem::offset_of!(HMENU__, unused) - 0usize];
};
pub type HMENU = *mut HMENU__;
pub type HCURSOR = HICON;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagPOINT {
    pub x: LONG,
    pub y: LONG,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of tagPOINT"][::std::mem::size_of::<tagPOINT>() - 8usize];
    ["Alignment of tagPOINT"][::std::mem::align_of::<tagPOINT>() - 4usize];
    ["Offset of field: tagPOINT::x"][::std::mem::offset_of!(tagPOINT, x) - 0usize];
    ["Offset of field: tagPOINT::y"][::std::mem::offset_of!(tagPOINT, y) - 4usize];
};
pub type POINT = tagPOINT;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagMSG {
    pub hwnd: HWND,
    pub message: UINT,
    pub wParam: WPARAM,
    pub lParam: LPARAM,
    pub time: DWORD,
    pub pt: POINT,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of tagMSG"][::std::mem::size_of::<tagMSG>() - 48usize];
    ["Alignment of tagMSG"][::std::mem::align_of::<tagMSG>() - 8usize];
    ["Offset of field: tagMSG::hwnd"][::std::mem::offset_of!(tagMSG, hwnd) - 0usize];
    ["Offset of field: tagMSG::message"][::std::mem::offset_of!(tagMSG, message) - 8usize];
    ["Offset of field: tagMSG::wParam"][::std::mem::offset_of!(tagMSG, wParam) - 16usize];
    ["Offset of field: tagMSG::lParam"][::std::mem::offset_of!(tagMSG, lParam) - 24usize];
    ["Offset of field: tagMSG::time"][::std::mem::offset_of!(tagMSG, time) - 32usize];
    ["Offset of field: tagMSG::pt"][::std::mem::offset_of!(tagMSG, pt) - 36usize];
};
pub type MSG = tagMSG;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Describes how to interpret the components of a pixel.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_color_type_t {
    #[doc = "\n RGBA with 8 bits per pixel (32bits total).\n"]
    CEF_COLOR_TYPE_RGBA_8888 = 0,
    #[doc = "\n BGRA with 8 bits per pixel (32bits total).\n"]
    CEF_COLOR_TYPE_BGRA_8888 = 1,
    #[doc = "\n BGRA with 8 bits per pixel (32bits total).\n"]
    CEF_COLOR_TYPE_NUM_VALUES = 2,
}
#[doc = "\n Structure containing shared texture common metadata.\n For documentation on each field, please refer to\n src/media/base/video_frame_metadata.h for actual details.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_accelerated_paint_info_common_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Timestamp of the frame in microseconds since capture start.\n"]
    pub timestamp: u64,
    #[doc = "\n The full dimensions of the video frame.\n"]
    pub coded_size: cef_size_t,
    #[doc = "\n The visible area of the video frame.\n"]
    pub visible_rect: cef_rect_t,
    #[doc = "\n The region of the video frame that capturer would like to populate.\n"]
    pub content_rect: cef_rect_t,
    #[doc = "\n Full size of the source frame.\n"]
    pub source_size: cef_size_t,
    #[doc = "\n Updated area of frame, can be considered as the `dirty` area.\n"]
    pub capture_update_rect: cef_rect_t,
    #[doc = "\n May reflects where the frame's contents originate from if region\n capture is used internally.\n"]
    pub region_capture_rect: cef_rect_t,
    #[doc = "\n The increamental counter of the frame.\n"]
    pub capture_counter: u64,
    #[doc = "\n Optional flag of capture_update_rect\n"]
    pub has_capture_update_rect: u8,
    #[doc = "\n Optional flag of region_capture_rect\n"]
    pub has_region_capture_rect: u8,
    #[doc = "\n Optional flag of source_size\n"]
    pub has_source_size: u8,
    #[doc = "\n Optional flag of capture_counter\n"]
    pub has_capture_counter: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_accelerated_paint_info_common_t"]
        [::std::mem::size_of::<_cef_accelerated_paint_info_common_t>() - 112usize];
    ["Alignment of _cef_accelerated_paint_info_common_t"]
        [::std::mem::align_of::<_cef_accelerated_paint_info_common_t>() - 8usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::size"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_common_t, size) - 0usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::timestamp"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_common_t, timestamp) - 8usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::coded_size"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_common_t, coded_size) - 16usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::visible_rect"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_common_t, visible_rect) - 24usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::content_rect"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_common_t, content_rect) - 40usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::source_size"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_common_t, source_size) - 56usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::capture_update_rect"][::std::mem::offset_of!(
        _cef_accelerated_paint_info_common_t,
        capture_update_rect
    ) - 64usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::region_capture_rect"][::std::mem::offset_of!(
        _cef_accelerated_paint_info_common_t,
        region_capture_rect
    ) - 80usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::capture_counter"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_common_t, capture_counter) - 96usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::has_capture_update_rect"][::std::mem::offset_of!(
        _cef_accelerated_paint_info_common_t,
        has_capture_update_rect
    )
        - 104usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::has_region_capture_rect"][::std::mem::offset_of!(
        _cef_accelerated_paint_info_common_t,
        has_region_capture_rect
    )
        - 105usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::has_source_size"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_common_t, has_source_size) - 106usize];
    ["Offset of field: _cef_accelerated_paint_info_common_t::has_capture_counter"][::std::mem::offset_of!(
        _cef_accelerated_paint_info_common_t,
        has_capture_counter
    ) - 107usize];
};
#[doc = "\n Structure containing shared texture common metadata.\n For documentation on each field, please refer to\n src/media/base/video_frame_metadata.h for actual details.\n"]
pub type cef_accelerated_paint_info_common_t = _cef_accelerated_paint_info_common_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n CEF supports both a Chrome runtime style (based on the Chrome UI layer) and\n an Alloy runtime style (based on the Chromium content layer). Chrome style\n provides the full Chrome UI and browser functionality whereas Alloy style\n provides less default browser functionality but adds additional client\n callbacks and support for windowless (off-screen) rendering. The style type\n is individually configured for each window/browser at creation time and\n different styles can be mixed during runtime. For additional comparative\n details on runtime styles see\n https://bitbucket.org/chromiumembedded/cef/wiki/Architecture.md#markdown-header-cef3\n\n Windowless rendering will always use Alloy style. Windowed rendering with a\n default window or client-provided parent window can configure the style via\n CefWindowInfo.runtime_style. Windowed rendering with the Views framework can\n configure the style via CefWindowDelegate::GetWindowRuntimeStyle and\n CefBrowserViewDelegate::GetBrowserRuntimeStyle. Alloy style Windows with the\n Views framework can host only Alloy style BrowserViews but Chrome style\n Windows can host both style BrowserViews. Additionally, a Chrome style\n Window can host at most one Chrome style BrowserView but potentially\n multiple Alloy style BrowserViews. See CefWindowInfo.runtime_style\n documentation for any additional platform-specific limitations.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_runtime_style_t {
    #[doc = "\n Use the default style. See above documentation for exceptions.\n"]
    CEF_RUNTIME_STYLE_DEFAULT = 0,
    #[doc = "\n Use Chrome style.\n"]
    CEF_RUNTIME_STYLE_CHROME = 1,
    #[doc = "\n Use Alloy style.\n"]
    CEF_RUNTIME_STYLE_ALLOY = 2,
}
pub type cef_cursor_handle_t = HCURSOR;
pub type cef_event_handle_t = *mut MSG;
pub type cef_window_handle_t = HWND;
pub type cef_shared_texture_handle_t = HANDLE;
#[doc = "\n Structure representing CefExecuteProcess arguments.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_main_args_t {
    pub instance: HINSTANCE,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_main_args_t"][::std::mem::size_of::<_cef_main_args_t>() - 8usize];
    ["Alignment of _cef_main_args_t"][::std::mem::align_of::<_cef_main_args_t>() - 8usize];
    ["Offset of field: _cef_main_args_t::instance"]
        [::std::mem::offset_of!(_cef_main_args_t, instance) - 0usize];
};
#[doc = "\n Structure representing CefExecuteProcess arguments.\n"]
pub type cef_main_args_t = _cef_main_args_t;
#[doc = "\n Structure representing window information.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_window_info_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    pub ex_style: DWORD,
    pub window_name: cef_string_t,
    pub style: DWORD,
    pub bounds: cef_rect_t,
    pub parent_window: cef_window_handle_t,
    pub menu: HMENU,
    #[doc = "\n Set to true (1) to create the browser using windowless (off-screen)\n rendering. No window will be created for the browser and all rendering\n will occur via the CefRenderHandler interface. The |parent_window| value\n will be used to identify monitor info and to act as the parent window for\n dialogs, context menus, etc. If |parent_window| is not provided then the\n main screen monitor will be used and some functionality that requires a\n parent window may not function correctly. In order to create windowless\n browsers the CefSettings.windowless_rendering_enabled value must be set to\n true. Transparent painting is enabled by default but can be disabled by\n setting CefBrowserSettings.background_color to an opaque value.\n"]
    pub windowless_rendering_enabled: ::std::os::raw::c_int,
    #[doc = "\n Set to true (1) to enable shared textures for windowless rendering. Only\n valid if windowless_rendering_enabled above is also set to true. Currently\n only supported on Windows (D3D11).\n"]
    pub shared_texture_enabled: ::std::os::raw::c_int,
    #[doc = "\n Set to true (1) to enable the ability to issue BeginFrame requests from\n the client application by calling CefBrowserHost::SendExternalBeginFrame.\n"]
    pub external_begin_frame_enabled: ::std::os::raw::c_int,
    #[doc = "\n Handle for the new browser window. Only used with windowed rendering.\n"]
    pub window: cef_window_handle_t,
    #[doc = "\n Optionally change the runtime style. Alloy style will always be used if\n |windowless_rendering_enabled| is true. See cef_runtime_style_t\n documentation for details.\n"]
    pub runtime_style: cef_runtime_style_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_window_info_t"][::std::mem::size_of::<_cef_window_info_t>() - 112usize];
    ["Alignment of _cef_window_info_t"][::std::mem::align_of::<_cef_window_info_t>() - 8usize];
    ["Offset of field: _cef_window_info_t::size"]
        [::std::mem::offset_of!(_cef_window_info_t, size) - 0usize];
    ["Offset of field: _cef_window_info_t::ex_style"]
        [::std::mem::offset_of!(_cef_window_info_t, ex_style) - 8usize];
    ["Offset of field: _cef_window_info_t::window_name"]
        [::std::mem::offset_of!(_cef_window_info_t, window_name) - 16usize];
    ["Offset of field: _cef_window_info_t::style"]
        [::std::mem::offset_of!(_cef_window_info_t, style) - 40usize];
    ["Offset of field: _cef_window_info_t::bounds"]
        [::std::mem::offset_of!(_cef_window_info_t, bounds) - 44usize];
    ["Offset of field: _cef_window_info_t::parent_window"]
        [::std::mem::offset_of!(_cef_window_info_t, parent_window) - 64usize];
    ["Offset of field: _cef_window_info_t::menu"]
        [::std::mem::offset_of!(_cef_window_info_t, menu) - 72usize];
    ["Offset of field: _cef_window_info_t::windowless_rendering_enabled"]
        [::std::mem::offset_of!(_cef_window_info_t, windowless_rendering_enabled) - 80usize];
    ["Offset of field: _cef_window_info_t::shared_texture_enabled"]
        [::std::mem::offset_of!(_cef_window_info_t, shared_texture_enabled) - 84usize];
    ["Offset of field: _cef_window_info_t::external_begin_frame_enabled"]
        [::std::mem::offset_of!(_cef_window_info_t, external_begin_frame_enabled) - 88usize];
    ["Offset of field: _cef_window_info_t::window"]
        [::std::mem::offset_of!(_cef_window_info_t, window) - 96usize];
    ["Offset of field: _cef_window_info_t::runtime_style"]
        [::std::mem::offset_of!(_cef_window_info_t, runtime_style) - 104usize];
};
#[doc = "\n Structure representing window information.\n"]
pub type cef_window_info_t = _cef_window_info_t;
#[doc = "\n Structure containing shared texture information for the OnAcceleratedPaint\n callback. Resources will be released to the underlying pool for reuse when\n the callback returns from client code.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_accelerated_paint_info_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Handle for the shared texture. The shared texture is instantiated\n without a keyed mutex.\n"]
    pub shared_texture_handle: cef_shared_texture_handle_t,
    #[doc = "\n The pixel format of the texture.\n"]
    pub format: cef_color_type_t,
    #[doc = "\n The extra common info.\n"]
    pub extra: cef_accelerated_paint_info_common_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_accelerated_paint_info_t"]
        [::std::mem::size_of::<_cef_accelerated_paint_info_t>() - 136usize];
    ["Alignment of _cef_accelerated_paint_info_t"]
        [::std::mem::align_of::<_cef_accelerated_paint_info_t>() - 8usize];
    ["Offset of field: _cef_accelerated_paint_info_t::size"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_t, size) - 0usize];
    ["Offset of field: _cef_accelerated_paint_info_t::shared_texture_handle"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_t, shared_texture_handle) - 8usize];
    ["Offset of field: _cef_accelerated_paint_info_t::format"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_t, format) - 16usize];
    ["Offset of field: _cef_accelerated_paint_info_t::extra"]
        [::std::mem::offset_of!(_cef_accelerated_paint_info_t, extra) - 24usize];
};
#[doc = "\n Structure containing shared texture information for the OnAcceleratedPaint\n callback. Resources will be released to the underlying pool for reuse when\n the callback returns from client code.\n"]
pub type cef_accelerated_paint_info_t = _cef_accelerated_paint_info_t;
pub type cef_color_t = u32;
impl cef_log_severity_t {
    pub const LOGSEVERITY_DEBUG: cef_log_severity_t = cef_log_severity_t::LOGSEVERITY_VERBOSE;
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Log severity levels.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_log_severity_t {
    #[doc = "\n Default logging (currently INFO logging).\n"]
    LOGSEVERITY_DEFAULT = 0,
    #[doc = "\n Verbose logging.\n"]
    LOGSEVERITY_VERBOSE = 1,
    #[doc = "\n INFO logging.\n"]
    LOGSEVERITY_INFO = 2,
    #[doc = "\n WARNING logging.\n"]
    LOGSEVERITY_WARNING = 3,
    #[doc = "\n ERROR logging.\n"]
    LOGSEVERITY_ERROR = 4,
    #[doc = "\n FATAL logging.\n"]
    LOGSEVERITY_FATAL = 5,
    #[doc = "\n Disable logging to file for all messages, and to stderr for messages with\n severity less than FATAL.\n"]
    LOGSEVERITY_DISABLE = 99,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Log items prepended to each log line.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_log_items_t {
    #[doc = "\n Prepend the default list of items.\n"]
    LOG_ITEMS_DEFAULT = 0,
    #[doc = "\n Prepend no items.\n"]
    LOG_ITEMS_NONE = 1,
    #[doc = "\n Prepend the process ID.\n"]
    LOG_ITEMS_FLAG_PROCESS_ID = 2,
    #[doc = "\n Prepend the thread ID.\n"]
    LOG_ITEMS_FLAG_THREAD_ID = 4,
    #[doc = "\n Prepend the timestamp.\n"]
    LOG_ITEMS_FLAG_TIME_STAMP = 8,
    #[doc = "\n Prepend the tickcount.\n"]
    LOG_ITEMS_FLAG_TICK_COUNT = 16,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Represents the state of a setting.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_state_t {
    #[doc = "\n Use the default state for the setting.\n"]
    STATE_DEFAULT = 0,
    #[doc = "\n Enable or allow the setting.\n"]
    STATE_ENABLED = 1,
    #[doc = "\n Disable or disallow the setting.\n"]
    STATE_DISABLED = 2,
}
#[doc = "\n Initialization settings. Specify NULL or 0 to get the recommended default\n values. Many of these and other settings can also configured using command-\n line switches.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_settings_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Set to true (1) to disable the sandbox for sub-processes. See\n cef_sandbox_win.h for requirements to enable the sandbox on Windows. Also\n configurable using the \"no-sandbox\" command-line switch.\n"]
    pub no_sandbox: ::std::os::raw::c_int,
    #[doc = "\n The path to a separate executable that will be launched for sub-processes.\n If this value is empty on Windows or Linux then the main process\n executable will be used. If this value is empty on macOS then a helper\n executable must exist at \"Contents/Frameworks/<app>\n Helper.app/Contents/MacOS/<app> Helper\" in the top-level app bundle. See\n the comments on CefExecuteProcess() for details. If this value is\n non-empty then it must be an absolute path. Also configurable using the\n \"browser-subprocess-path\" command-line switch.\n"]
    pub browser_subprocess_path: cef_string_t,
    #[doc = "\n The path to the CEF framework directory on macOS. If this value is empty\n then the framework must exist at \"Contents/Frameworks/Chromium Embedded\n Framework.framework\" in the top-level app bundle. If this value is\n non-empty then it must be an absolute path. Also configurable using the\n \"framework-dir-path\" command-line switch.\n"]
    pub framework_dir_path: cef_string_t,
    #[doc = "\n The path to the main bundle on macOS. If this value is empty then it\n defaults to the top-level app bundle. If this value is non-empty then it\n must be an absolute path. Also configurable using the \"main-bundle-path\"\n command-line switch.\n"]
    pub main_bundle_path: cef_string_t,
    #[doc = "\n Set to true (1) to have the browser process message loop run in a separate\n thread. If false (0) then the CefDoMessageLoopWork() function must be\n called from your application message loop. This option is only supported\n on Windows and Linux.\n"]
    pub multi_threaded_message_loop: ::std::os::raw::c_int,
    #[doc = "\n Set to true (1) to control browser process main (UI) thread message pump\n scheduling via the CefBrowserProcessHandler::OnScheduleMessagePumpWork()\n callback. This option is recommended for use in combination with the\n CefDoMessageLoopWork() function in cases where the CEF message loop must\n be integrated into an existing application message loop (see additional\n comments and warnings on CefDoMessageLoopWork). Enabling this option is\n not recommended for most users; leave this option disabled and use either\n the CefRunMessageLoop() function or multi_threaded_message_loop if\n possible.\n"]
    pub external_message_pump: ::std::os::raw::c_int,
    #[doc = "\n Set to true (1) to enable windowless (off-screen) rendering support. Do\n not enable this value if the application does not use windowless rendering\n as it may reduce rendering performance on some systems.\n"]
    pub windowless_rendering_enabled: ::std::os::raw::c_int,
    #[doc = "\n Set to true (1) to disable configuration of browser process features using\n standard CEF and Chromium command-line arguments. Configuration can still\n be specified using CEF data structures or via the\n CefApp::OnBeforeCommandLineProcessing() method.\n"]
    pub command_line_args_disabled: ::std::os::raw::c_int,
    #[doc = "\n The directory where data for the global browser cache will be stored on\n disk. If this value is non-empty then it must be an absolute path that is\n either equal to or a child directory of CefSettings.root_cache_path. If\n this value is empty then browsers will be created in \"incognito mode\"\n where in-memory caches are used for storage and no profile-specific data\n is persisted to disk (installation-specific data will still be persisted\n in root_cache_path). HTML5 databases such as localStorage will only\n persist across sessions if a cache path is specified. Can be overridden\n for individual CefRequestContext instances via the\n CefRequestContextSettings.cache_path value. Any child directory value will\n be ignored and the \"default\" profile (also a child directory) will be used\n instead.\n"]
    pub cache_path: cef_string_t,
    #[doc = "\n The root directory for installation-specific data and the parent directory\n for profile-specific data. All CefSettings.cache_path and\n CefRequestContextSettings.cache_path values must have this parent\n directory in common. If this value is empty and CefSettings.cache_path is\n non-empty then it will default to the CefSettings.cache_path value. Any\n non-empty value must be an absolute path. If both values are empty then\n the default platform-specific directory will be used\n (\"~/.config/cef_user_data\" directory on Linux, \"~/Library/Application\n Support/CEF/User Data\" directory on MacOS, \"AppData\\Local\\CEF\\User Data\"\n directory under the user profile directory on Windows). Use of the default\n directory is not recommended in production applications (see below).\n\n Multiple application instances writing to the same root_cache_path\n directory could result in data corruption. A process singleton lock based\n on the root_cache_path value is therefore used to protect against this.\n This singleton behavior applies to all CEF-based applications using\n version 120 or newer. You should customize root_cache_path for your\n application and implement CefBrowserProcessHandler::\n OnAlreadyRunningAppRelaunch, which will then be called on any app relaunch\n with the same root_cache_path value.\n\n Failure to set the root_cache_path value correctly may result in startup\n crashes or other unexpected behaviors (for example, the sandbox blocking\n read/write access to certain files).\n"]
    pub root_cache_path: cef_string_t,
    #[doc = "\n To persist session cookies (cookies without an expiry date or validity\n interval) by default when using the global cookie manager set this value\n to true (1). Session cookies are generally intended to be transient and\n most Web browsers do not persist them. A |cache_path| value must also be\n specified to enable this feature. Also configurable using the\n \"persist-session-cookies\" command-line switch. Can be overridden for\n individual CefRequestContext instances via the\n CefRequestContextSettings.persist_session_cookies value.\n"]
    pub persist_session_cookies: ::std::os::raw::c_int,
    #[doc = "\n Value that will be returned as the User-Agent HTTP header. If empty the\n default User-Agent string will be used. Also configurable using the\n \"user-agent\" command-line switch.\n"]
    pub user_agent: cef_string_t,
    #[doc = "\n Value that will be inserted as the product portion of the default\n User-Agent string. If empty the Chromium product version will be used. If\n |userAgent| is specified this value will be ignored. Also configurable\n using the \"user-agent-product\" command-line switch.\n"]
    pub user_agent_product: cef_string_t,
    #[doc = "\n The locale string that will be passed to WebKit. If empty the default\n locale of \"en-US\" will be used. This value is ignored on Linux where\n locale is determined using environment variable parsing with the\n precedence order: LANGUAGE, LC_ALL, LC_MESSAGES and LANG. Also\n configurable using the \"lang\" command-line switch.\n"]
    pub locale: cef_string_t,
    #[doc = "\n The directory and file name to use for the debug log. If empty a default\n log file name and location will be used. On Windows and Linux a\n \"debug.log\" file will be written in the main executable directory. On\n MacOS a \"~/Library/Logs/[app name]_debug.log\" file will be written where\n [app name] is the name of the main app executable. Also configurable using\n the \"log-file\" command-line switch.\n"]
    pub log_file: cef_string_t,
    #[doc = "\n The log severity. Only messages of this severity level or higher will be\n logged. When set to DISABLE no messages will be written to the log file,\n but FATAL messages will still be output to stderr. Also configurable using\n the \"log-severity\" command-line switch with a value of \"verbose\", \"info\",\n \"warning\", \"error\", \"fatal\" or \"disable\".\n"]
    pub log_severity: cef_log_severity_t,
    #[doc = "\n The log items prepended to each log line. If not set the default log items\n will be used. Also configurable using the \"log-items\" command-line switch\n with a value of \"none\" for no log items, or a comma-delimited list of\n values \"pid\", \"tid\", \"timestamp\" or \"tickcount\" for custom log items.\n"]
    pub log_items: cef_log_items_t,
    #[doc = "\n Custom flags that will be used when initializing the V8 JavaScript engine.\n The consequences of using custom flags may not be well tested. Also\n configurable using the \"js-flags\" command-line switch.\n"]
    pub javascript_flags: cef_string_t,
    #[doc = "\n The fully qualified path for the resources directory. If this value is\n empty the *.pak files must be located in the module directory on\n Windows/Linux or the app bundle Resources directory on MacOS. If this\n value is non-empty then it must be an absolute path. Also configurable\n using the \"resources-dir-path\" command-line switch.\n"]
    pub resources_dir_path: cef_string_t,
    #[doc = "\n The fully qualified path for the locales directory. If this value is empty\n the locales directory must be located in the module directory. If this\n value is non-empty then it must be an absolute path. This value is ignored\n on MacOS where pack files are always loaded from the app bundle Resources\n directory. Also configurable using the \"locales-dir-path\" command-line\n switch.\n"]
    pub locales_dir_path: cef_string_t,
    #[doc = "\n Set to a value between 1024 and 65535 to enable remote debugging on the\n specified port. Also configurable using the \"remote-debugging-port\"\n command-line switch. Specifying 0 via the command-line switch will result\n in the selection of an ephemeral port and the port number will be printed\n as part of the WebSocket endpoint URL to stderr. If a cache directory path\n is provided the port will also be written to the\n <cache-dir>/DevToolsActivePort file. Remote debugging can be accessed by\n loading the chrome://inspect page in Google Chrome. Port numbers 9222 and\n 9229 are discoverable by default. Other port numbers may need to be\n configured via \"Discover network targets\" on the Devices tab.\n"]
    pub remote_debugging_port: ::std::os::raw::c_int,
    #[doc = "\n The number of stack trace frames to capture for uncaught exceptions.\n Specify a positive value to enable the\n CefRenderProcessHandler::OnUncaughtException() callback. Specify 0\n (default value) and OnUncaughtException() will not be called. Also\n configurable using the \"uncaught-exception-stack-size\" command-line\n switch.\n"]
    pub uncaught_exception_stack_size: ::std::os::raw::c_int,
    #[doc = "\n Background color used for the browser before a document is loaded and when\n no document color is specified. The alpha component must be either fully\n opaque (0xFF) or fully transparent (0x00). If the alpha component is fully\n opaque then the RGB components will be used as the background color. If\n the alpha component is fully transparent for a windowed browser then the\n default value of opaque white be used. If the alpha component is fully\n transparent for a windowless (off-screen) browser then transparent\n painting will be enabled.\n"]
    pub background_color: cef_color_t,
    #[doc = "\n Comma delimited ordered list of language codes without any whitespace that\n will be used in the \"Accept-Language\" HTTP request header and\n \"navigator.language\" JS attribute. Can be overridden for individual\n CefRequestContext instances via the\n CefRequestContextSettings.accept_language_list value.\n"]
    pub accept_language_list: cef_string_t,
    #[doc = "\n Comma delimited list of schemes supported by the associated\n CefCookieManager. If |cookieable_schemes_exclude_defaults| is false (0)\n the default schemes (\"http\", \"https\", \"ws\" and \"wss\") will also be\n supported. Not specifying a |cookieable_schemes_list| value and setting\n |cookieable_schemes_exclude_defaults| to true (1) will disable all loading\n and saving of cookies. These settings will only impact the global\n CefRequestContext. Individual CefRequestContext instances can be\n configured via the CefRequestContextSettings.cookieable_schemes_list and\n CefRequestContextSettings.cookieable_schemes_exclude_defaults values.\n"]
    pub cookieable_schemes_list: cef_string_t,
    pub cookieable_schemes_exclude_defaults: ::std::os::raw::c_int,
    #[doc = "\n Specify an ID to enable Chrome policy management via Platform and OS-user\n policies. On Windows, this is a registry key like\n \"SOFTWARE\\\\Policies\\\\Google\\\\Chrome\". On MacOS, this is a bundle ID like\n \"com.google.Chrome\". On Linux, this is an absolute directory path like\n \"/etc/opt/chrome/policies\". Only supported with Chrome style. See\n https://support.google.com/chrome/a/answer/9037717 for details.\n\n Chrome Browser Cloud Management integration, when enabled via the\n \"enable-chrome-browser-cloud-management\" command-line flag, will also use\n the specified ID. See https://support.google.com/chrome/a/answer/9116814\n for details.\n"]
    pub chrome_policy_id: cef_string_t,
    #[doc = "\n Specify an ID for an ICON resource that can be loaded from the main\n executable and used when creating default Chrome windows such as DevTools\n and Task Manager. If unspecified the default Chromium ICON (IDR_MAINFRAME\n [101]) will be loaded from libcef.dll. Only supported with Chrome style on\n Windows.\n"]
    pub chrome_app_icon_id: ::std::os::raw::c_int,
    #[doc = "\n Specify whether signal handlers must be disabled on POSIX systems.\n"]
    pub disable_signal_handlers: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_settings_t"][::std::mem::size_of::<_cef_settings_t>() - 440usize];
    ["Alignment of _cef_settings_t"][::std::mem::align_of::<_cef_settings_t>() - 8usize];
    ["Offset of field: _cef_settings_t::size"]
        [::std::mem::offset_of!(_cef_settings_t, size) - 0usize];
    ["Offset of field: _cef_settings_t::no_sandbox"]
        [::std::mem::offset_of!(_cef_settings_t, no_sandbox) - 8usize];
    ["Offset of field: _cef_settings_t::browser_subprocess_path"]
        [::std::mem::offset_of!(_cef_settings_t, browser_subprocess_path) - 16usize];
    ["Offset of field: _cef_settings_t::framework_dir_path"]
        [::std::mem::offset_of!(_cef_settings_t, framework_dir_path) - 40usize];
    ["Offset of field: _cef_settings_t::main_bundle_path"]
        [::std::mem::offset_of!(_cef_settings_t, main_bundle_path) - 64usize];
    ["Offset of field: _cef_settings_t::multi_threaded_message_loop"]
        [::std::mem::offset_of!(_cef_settings_t, multi_threaded_message_loop) - 88usize];
    ["Offset of field: _cef_settings_t::external_message_pump"]
        [::std::mem::offset_of!(_cef_settings_t, external_message_pump) - 92usize];
    ["Offset of field: _cef_settings_t::windowless_rendering_enabled"]
        [::std::mem::offset_of!(_cef_settings_t, windowless_rendering_enabled) - 96usize];
    ["Offset of field: _cef_settings_t::command_line_args_disabled"]
        [::std::mem::offset_of!(_cef_settings_t, command_line_args_disabled) - 100usize];
    ["Offset of field: _cef_settings_t::cache_path"]
        [::std::mem::offset_of!(_cef_settings_t, cache_path) - 104usize];
    ["Offset of field: _cef_settings_t::root_cache_path"]
        [::std::mem::offset_of!(_cef_settings_t, root_cache_path) - 128usize];
    ["Offset of field: _cef_settings_t::persist_session_cookies"]
        [::std::mem::offset_of!(_cef_settings_t, persist_session_cookies) - 152usize];
    ["Offset of field: _cef_settings_t::user_agent"]
        [::std::mem::offset_of!(_cef_settings_t, user_agent) - 160usize];
    ["Offset of field: _cef_settings_t::user_agent_product"]
        [::std::mem::offset_of!(_cef_settings_t, user_agent_product) - 184usize];
    ["Offset of field: _cef_settings_t::locale"]
        [::std::mem::offset_of!(_cef_settings_t, locale) - 208usize];
    ["Offset of field: _cef_settings_t::log_file"]
        [::std::mem::offset_of!(_cef_settings_t, log_file) - 232usize];
    ["Offset of field: _cef_settings_t::log_severity"]
        [::std::mem::offset_of!(_cef_settings_t, log_severity) - 256usize];
    ["Offset of field: _cef_settings_t::log_items"]
        [::std::mem::offset_of!(_cef_settings_t, log_items) - 260usize];
    ["Offset of field: _cef_settings_t::javascript_flags"]
        [::std::mem::offset_of!(_cef_settings_t, javascript_flags) - 264usize];
    ["Offset of field: _cef_settings_t::resources_dir_path"]
        [::std::mem::offset_of!(_cef_settings_t, resources_dir_path) - 288usize];
    ["Offset of field: _cef_settings_t::locales_dir_path"]
        [::std::mem::offset_of!(_cef_settings_t, locales_dir_path) - 312usize];
    ["Offset of field: _cef_settings_t::remote_debugging_port"]
        [::std::mem::offset_of!(_cef_settings_t, remote_debugging_port) - 336usize];
    ["Offset of field: _cef_settings_t::uncaught_exception_stack_size"]
        [::std::mem::offset_of!(_cef_settings_t, uncaught_exception_stack_size) - 340usize];
    ["Offset of field: _cef_settings_t::background_color"]
        [::std::mem::offset_of!(_cef_settings_t, background_color) - 344usize];
    ["Offset of field: _cef_settings_t::accept_language_list"]
        [::std::mem::offset_of!(_cef_settings_t, accept_language_list) - 352usize];
    ["Offset of field: _cef_settings_t::cookieable_schemes_list"]
        [::std::mem::offset_of!(_cef_settings_t, cookieable_schemes_list) - 376usize];
    ["Offset of field: _cef_settings_t::cookieable_schemes_exclude_defaults"]
        [::std::mem::offset_of!(_cef_settings_t, cookieable_schemes_exclude_defaults) - 400usize];
    ["Offset of field: _cef_settings_t::chrome_policy_id"]
        [::std::mem::offset_of!(_cef_settings_t, chrome_policy_id) - 408usize];
    ["Offset of field: _cef_settings_t::chrome_app_icon_id"]
        [::std::mem::offset_of!(_cef_settings_t, chrome_app_icon_id) - 432usize];
    ["Offset of field: _cef_settings_t::disable_signal_handlers"]
        [::std::mem::offset_of!(_cef_settings_t, disable_signal_handlers) - 436usize];
};
#[doc = "\n Initialization settings. Specify NULL or 0 to get the recommended default\n values. Many of these and other settings can also configured using command-\n line switches.\n"]
pub type cef_settings_t = _cef_settings_t;
#[doc = "\n Request context initialization settings. Specify NULL or 0 to get the\n recommended default values.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_request_context_settings_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n The directory where cache data for this request context will be stored on\n disk. If this value is non-empty then it must be an absolute path that is\n either equal to or a child directory of CefSettings.root_cache_path. If\n this value is empty then browsers will be created in \"incognito mode\"\n where in-memory caches are used for storage and no profile-specific data\n is persisted to disk (installation-specific data will still be persisted\n in root_cache_path). HTML5 databases such as localStorage will only\n persist across sessions if a cache path is specified. To share the global\n browser cache and related configuration set this value to match the\n CefSettings.cache_path value.\n"]
    pub cache_path: cef_string_t,
    #[doc = "\n To persist session cookies (cookies without an expiry date or validity\n interval) by default when using the global cookie manager set this value\n to true (1). Session cookies are generally intended to be transient and\n most Web browsers do not persist them. Can be set globally using the\n CefSettings.persist_session_cookies value. This value will be ignored if\n |cache_path| is empty or if it matches the CefSettings.cache_path value.\n"]
    pub persist_session_cookies: ::std::os::raw::c_int,
    #[doc = "\n Comma delimited ordered list of language codes without any whitespace that\n will be used in the \"Accept-Language\" HTTP request header and\n \"navigator.language\" JS attribute. Can be set globally using the\n CefSettings.accept_language_list value. If all values are empty then\n \"en-US,en\" will be used. This value will be ignored if |cache_path|\n matches the CefSettings.cache_path value.\n"]
    pub accept_language_list: cef_string_t,
    #[doc = "\n Comma delimited list of schemes supported by the associated\n CefCookieManager. If |cookieable_schemes_exclude_defaults| is false (0)\n the default schemes (\"http\", \"https\", \"ws\" and \"wss\") will also be\n supported. Not specifying a |cookieable_schemes_list| value and setting\n |cookieable_schemes_exclude_defaults| to true (1) will disable all loading\n and saving of cookies. These values will be ignored if |cache_path|\n matches the CefSettings.cache_path value.\n"]
    pub cookieable_schemes_list: cef_string_t,
    pub cookieable_schemes_exclude_defaults: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_request_context_settings_t"]
        [::std::mem::size_of::<_cef_request_context_settings_t>() - 96usize];
    ["Alignment of _cef_request_context_settings_t"]
        [::std::mem::align_of::<_cef_request_context_settings_t>() - 8usize];
    ["Offset of field: _cef_request_context_settings_t::size"]
        [::std::mem::offset_of!(_cef_request_context_settings_t, size) - 0usize];
    ["Offset of field: _cef_request_context_settings_t::cache_path"]
        [::std::mem::offset_of!(_cef_request_context_settings_t, cache_path) - 8usize];
    ["Offset of field: _cef_request_context_settings_t::persist_session_cookies"][::std::mem::offset_of!(
        _cef_request_context_settings_t,
        persist_session_cookies
    ) - 32usize];
    ["Offset of field: _cef_request_context_settings_t::accept_language_list"]
        [::std::mem::offset_of!(_cef_request_context_settings_t, accept_language_list) - 40usize];
    ["Offset of field: _cef_request_context_settings_t::cookieable_schemes_list"][::std::mem::offset_of!(
        _cef_request_context_settings_t,
        cookieable_schemes_list
    ) - 64usize];
    ["Offset of field: _cef_request_context_settings_t::cookieable_schemes_exclude_defaults"][::std::mem::offset_of!(
        _cef_request_context_settings_t,
        cookieable_schemes_exclude_defaults
    )
        - 88usize];
};
#[doc = "\n Request context initialization settings. Specify NULL or 0 to get the\n recommended default values.\n"]
pub type cef_request_context_settings_t = _cef_request_context_settings_t;
#[doc = "\n Browser initialization settings. Specify NULL or 0 to get the recommended\n default values. The consequences of using custom values may not be well\n tested. Many of these and other settings can also configured using command-\n line switches.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_browser_settings_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n The maximum rate in frames per second (fps) that CefRenderHandler::OnPaint\n will be called for a windowless browser. The actual fps may be lower if\n the browser cannot generate frames at the requested rate. The minimum\n value is 1 and the maximum value is 60 (default 30). This value can also\n be changed dynamically via CefBrowserHost::SetWindowlessFrameRate.\n"]
    pub windowless_frame_rate: ::std::os::raw::c_int,
    #[doc = "\n Font settings.\n"]
    pub standard_font_family: cef_string_t,
    pub fixed_font_family: cef_string_t,
    pub serif_font_family: cef_string_t,
    pub sans_serif_font_family: cef_string_t,
    pub cursive_font_family: cef_string_t,
    pub fantasy_font_family: cef_string_t,
    pub default_font_size: ::std::os::raw::c_int,
    pub default_fixed_font_size: ::std::os::raw::c_int,
    pub minimum_font_size: ::std::os::raw::c_int,
    pub minimum_logical_font_size: ::std::os::raw::c_int,
    #[doc = "\n Default encoding for Web content. If empty \"ISO-8859-1\" will be used. Also\n configurable using the \"default-encoding\" command-line switch.\n"]
    pub default_encoding: cef_string_t,
    #[doc = "\n Controls the loading of fonts from remote sources. Also configurable using\n the \"disable-remote-fonts\" command-line switch.\n"]
    pub remote_fonts: cef_state_t,
    #[doc = "\n Controls whether JavaScript can be executed. Also configurable using the\n \"disable-javascript\" command-line switch.\n"]
    pub javascript: cef_state_t,
    #[doc = "\n Controls whether JavaScript can be used to close windows that were not\n opened via JavaScript. JavaScript can still be used to close windows that\n were opened via JavaScript or that have no back/forward history. Also\n configurable using the \"disable-javascript-close-windows\" command-line\n switch.\n"]
    pub javascript_close_windows: cef_state_t,
    #[doc = "\n Controls whether JavaScript can access the clipboard. Also configurable\n using the \"disable-javascript-access-clipboard\" command-line switch.\n"]
    pub javascript_access_clipboard: cef_state_t,
    #[doc = "\n Controls whether DOM pasting is supported in the editor via\n execCommand(\"paste\"). The |javascript_access_clipboard| setting must also\n be enabled. Also configurable using the \"disable-javascript-dom-paste\"\n command-line switch.\n"]
    pub javascript_dom_paste: cef_state_t,
    #[doc = "\n Controls whether image URLs will be loaded from the network. A cached\n image will still be rendered if requested. Also configurable using the\n \"disable-image-loading\" command-line switch.\n"]
    pub image_loading: cef_state_t,
    #[doc = "\n Controls whether standalone images will be shrunk to fit the page. Also\n configurable using the \"image-shrink-standalone-to-fit\" command-line\n switch.\n"]
    pub image_shrink_standalone_to_fit: cef_state_t,
    #[doc = "\n Controls whether text areas can be resized. Also configurable using the\n \"disable-text-area-resize\" command-line switch.\n"]
    pub text_area_resize: cef_state_t,
    #[doc = "\n Controls whether the tab key can advance focus to links. Also configurable\n using the \"disable-tab-to-links\" command-line switch.\n"]
    pub tab_to_links: cef_state_t,
    #[doc = "\n Controls whether local storage can be used. Also configurable using the\n \"disable-local-storage\" command-line switch.\n"]
    pub local_storage: cef_state_t,
    pub databases_deprecated: cef_state_t,
    #[doc = "\n Controls whether WebGL can be used. Note that WebGL requires hardware\n support and may not work on all systems even when enabled. Also\n configurable using the \"disable-webgl\" command-line switch.\n"]
    pub webgl: cef_state_t,
    #[doc = "\n Background color used for the browser before a document is loaded and when\n no document color is specified. The alpha component must be either fully\n opaque (0xFF) or fully transparent (0x00). If the alpha component is fully\n opaque then the RGB components will be used as the background color. If\n the alpha component is fully transparent for a windowed browser then the\n CefSettings.background_color value will be used. If the alpha component is\n fully transparent for a windowless (off-screen) browser then transparent\n painting will be enabled.\n"]
    pub background_color: cef_color_t,
    #[doc = "\n Controls whether the Chrome status bubble will be used. Only supported\n with Chrome style. For details about the status bubble see\n https://www.chromium.org/user-experience/status-bubble/\n"]
    pub chrome_status_bubble: cef_state_t,
    #[doc = "\n Controls whether the Chrome zoom bubble will be shown when zooming. Only\n supported with Chrome style.\n"]
    pub chrome_zoom_bubble: cef_state_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_browser_settings_t"]
        [::std::mem::size_of::<_cef_browser_settings_t>() - 264usize];
    ["Alignment of _cef_browser_settings_t"]
        [::std::mem::align_of::<_cef_browser_settings_t>() - 8usize];
    ["Offset of field: _cef_browser_settings_t::size"]
        [::std::mem::offset_of!(_cef_browser_settings_t, size) - 0usize];
    ["Offset of field: _cef_browser_settings_t::windowless_frame_rate"]
        [::std::mem::offset_of!(_cef_browser_settings_t, windowless_frame_rate) - 8usize];
    ["Offset of field: _cef_browser_settings_t::standard_font_family"]
        [::std::mem::offset_of!(_cef_browser_settings_t, standard_font_family) - 16usize];
    ["Offset of field: _cef_browser_settings_t::fixed_font_family"]
        [::std::mem::offset_of!(_cef_browser_settings_t, fixed_font_family) - 40usize];
    ["Offset of field: _cef_browser_settings_t::serif_font_family"]
        [::std::mem::offset_of!(_cef_browser_settings_t, serif_font_family) - 64usize];
    ["Offset of field: _cef_browser_settings_t::sans_serif_font_family"]
        [::std::mem::offset_of!(_cef_browser_settings_t, sans_serif_font_family) - 88usize];
    ["Offset of field: _cef_browser_settings_t::cursive_font_family"]
        [::std::mem::offset_of!(_cef_browser_settings_t, cursive_font_family) - 112usize];
    ["Offset of field: _cef_browser_settings_t::fantasy_font_family"]
        [::std::mem::offset_of!(_cef_browser_settings_t, fantasy_font_family) - 136usize];
    ["Offset of field: _cef_browser_settings_t::default_font_size"]
        [::std::mem::offset_of!(_cef_browser_settings_t, default_font_size) - 160usize];
    ["Offset of field: _cef_browser_settings_t::default_fixed_font_size"]
        [::std::mem::offset_of!(_cef_browser_settings_t, default_fixed_font_size) - 164usize];
    ["Offset of field: _cef_browser_settings_t::minimum_font_size"]
        [::std::mem::offset_of!(_cef_browser_settings_t, minimum_font_size) - 168usize];
    ["Offset of field: _cef_browser_settings_t::minimum_logical_font_size"]
        [::std::mem::offset_of!(_cef_browser_settings_t, minimum_logical_font_size) - 172usize];
    ["Offset of field: _cef_browser_settings_t::default_encoding"]
        [::std::mem::offset_of!(_cef_browser_settings_t, default_encoding) - 176usize];
    ["Offset of field: _cef_browser_settings_t::remote_fonts"]
        [::std::mem::offset_of!(_cef_browser_settings_t, remote_fonts) - 200usize];
    ["Offset of field: _cef_browser_settings_t::javascript"]
        [::std::mem::offset_of!(_cef_browser_settings_t, javascript) - 204usize];
    ["Offset of field: _cef_browser_settings_t::javascript_close_windows"]
        [::std::mem::offset_of!(_cef_browser_settings_t, javascript_close_windows) - 208usize];
    ["Offset of field: _cef_browser_settings_t::javascript_access_clipboard"]
        [::std::mem::offset_of!(_cef_browser_settings_t, javascript_access_clipboard) - 212usize];
    ["Offset of field: _cef_browser_settings_t::javascript_dom_paste"]
        [::std::mem::offset_of!(_cef_browser_settings_t, javascript_dom_paste) - 216usize];
    ["Offset of field: _cef_browser_settings_t::image_loading"]
        [::std::mem::offset_of!(_cef_browser_settings_t, image_loading) - 220usize];
    ["Offset of field: _cef_browser_settings_t::image_shrink_standalone_to_fit"][::std::mem::offset_of!(
        _cef_browser_settings_t,
        image_shrink_standalone_to_fit
    ) - 224usize];
    ["Offset of field: _cef_browser_settings_t::text_area_resize"]
        [::std::mem::offset_of!(_cef_browser_settings_t, text_area_resize) - 228usize];
    ["Offset of field: _cef_browser_settings_t::tab_to_links"]
        [::std::mem::offset_of!(_cef_browser_settings_t, tab_to_links) - 232usize];
    ["Offset of field: _cef_browser_settings_t::local_storage"]
        [::std::mem::offset_of!(_cef_browser_settings_t, local_storage) - 236usize];
    ["Offset of field: _cef_browser_settings_t::databases_deprecated"]
        [::std::mem::offset_of!(_cef_browser_settings_t, databases_deprecated) - 240usize];
    ["Offset of field: _cef_browser_settings_t::webgl"]
        [::std::mem::offset_of!(_cef_browser_settings_t, webgl) - 244usize];
    ["Offset of field: _cef_browser_settings_t::background_color"]
        [::std::mem::offset_of!(_cef_browser_settings_t, background_color) - 248usize];
    ["Offset of field: _cef_browser_settings_t::chrome_status_bubble"]
        [::std::mem::offset_of!(_cef_browser_settings_t, chrome_status_bubble) - 252usize];
    ["Offset of field: _cef_browser_settings_t::chrome_zoom_bubble"]
        [::std::mem::offset_of!(_cef_browser_settings_t, chrome_zoom_bubble) - 256usize];
};
#[doc = "\n Browser initialization settings. Specify NULL or 0 to get the recommended\n default values. The consequences of using custom values may not be well\n tested. Many of these and other settings can also configured using command-\n line switches.\n"]
pub type cef_browser_settings_t = _cef_browser_settings_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Return value types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_return_value_t {
    #[doc = "\n Cancel immediately.\n"]
    RV_CANCEL = 0,
    #[doc = "\n Continue immediately.\n"]
    RV_CONTINUE = 1,
    #[doc = "\n Continue asynchronously (usually via a callback).\n"]
    RV_CONTINUE_ASYNC = 2,
}
#[doc = "\n URL component parts.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_urlparts_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n The complete URL specification.\n"]
    pub spec: cef_string_t,
    #[doc = "\n Scheme component not including the colon (e.g., \"http\").\n"]
    pub scheme: cef_string_t,
    #[doc = "\n User name component.\n"]
    pub username: cef_string_t,
    #[doc = "\n Password component.\n"]
    pub password: cef_string_t,
    #[doc = "\n Host component. This may be a hostname, an IPv4 address or an IPv6 literal\n surrounded by square brackets (e.g., \"[2001:db8::1]\").\n"]
    pub host: cef_string_t,
    #[doc = "\n Port number component.\n"]
    pub port: cef_string_t,
    #[doc = "\n Origin contains just the scheme, host, and port from a URL. Equivalent to\n clearing any username and password, replacing the path with a slash, and\n clearing everything after that. This value will be empty for non-standard\n URLs.\n"]
    pub origin: cef_string_t,
    #[doc = "\n Path component including the first slash following the host.\n"]
    pub path: cef_string_t,
    #[doc = "\n Query string component (i.e., everything following the '?').\n"]
    pub query: cef_string_t,
    #[doc = "\n Fragment (hash) identifier component (i.e., the string following the '#').\n"]
    pub fragment: cef_string_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_urlparts_t"][::std::mem::size_of::<_cef_urlparts_t>() - 248usize];
    ["Alignment of _cef_urlparts_t"][::std::mem::align_of::<_cef_urlparts_t>() - 8usize];
    ["Offset of field: _cef_urlparts_t::size"]
        [::std::mem::offset_of!(_cef_urlparts_t, size) - 0usize];
    ["Offset of field: _cef_urlparts_t::spec"]
        [::std::mem::offset_of!(_cef_urlparts_t, spec) - 8usize];
    ["Offset of field: _cef_urlparts_t::scheme"]
        [::std::mem::offset_of!(_cef_urlparts_t, scheme) - 32usize];
    ["Offset of field: _cef_urlparts_t::username"]
        [::std::mem::offset_of!(_cef_urlparts_t, username) - 56usize];
    ["Offset of field: _cef_urlparts_t::password"]
        [::std::mem::offset_of!(_cef_urlparts_t, password) - 80usize];
    ["Offset of field: _cef_urlparts_t::host"]
        [::std::mem::offset_of!(_cef_urlparts_t, host) - 104usize];
    ["Offset of field: _cef_urlparts_t::port"]
        [::std::mem::offset_of!(_cef_urlparts_t, port) - 128usize];
    ["Offset of field: _cef_urlparts_t::origin"]
        [::std::mem::offset_of!(_cef_urlparts_t, origin) - 152usize];
    ["Offset of field: _cef_urlparts_t::path"]
        [::std::mem::offset_of!(_cef_urlparts_t, path) - 176usize];
    ["Offset of field: _cef_urlparts_t::query"]
        [::std::mem::offset_of!(_cef_urlparts_t, query) - 200usize];
    ["Offset of field: _cef_urlparts_t::fragment"]
        [::std::mem::offset_of!(_cef_urlparts_t, fragment) - 224usize];
};
#[doc = "\n URL component parts.\n"]
pub type cef_urlparts_t = _cef_urlparts_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Cookie priority values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_cookie_priority_t {
    CEF_COOKIE_PRIORITY_LOW = -1,
    CEF_COOKIE_PRIORITY_MEDIUM = 0,
    CEF_COOKIE_PRIORITY_HIGH = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Cookie same site values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_cookie_same_site_t {
    CEF_COOKIE_SAME_SITE_UNSPECIFIED = 0,
    CEF_COOKIE_SAME_SITE_NO_RESTRICTION = 1,
    CEF_COOKIE_SAME_SITE_LAX_MODE = 2,
    CEF_COOKIE_SAME_SITE_STRICT_MODE = 3,
    CEF_COOKIE_SAME_SITE_NUM_VALUES = 4,
}
#[doc = "\n Cookie information.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_cookie_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n The cookie name.\n"]
    pub name: cef_string_t,
    #[doc = "\n The cookie value.\n"]
    pub value: cef_string_t,
    #[doc = "\n If |domain| is empty a host cookie will be created instead of a domain\n cookie. Domain cookies are stored with a leading \".\" and are visible to\n sub-domains whereas host cookies are not.\n"]
    pub domain: cef_string_t,
    #[doc = "\n If |path| is non-empty only URLs at or below the path will get the cookie\n value.\n"]
    pub path: cef_string_t,
    #[doc = "\n If |secure| is true the cookie will only be sent for HTTPS requests.\n"]
    pub secure: ::std::os::raw::c_int,
    #[doc = "\n If |httponly| is true the cookie will only be sent for HTTP requests.\n"]
    pub httponly: ::std::os::raw::c_int,
    #[doc = "\n The cookie creation date. This is automatically populated by the system on\n cookie creation.\n"]
    pub creation: cef_basetime_t,
    #[doc = "\n The cookie last access date. This is automatically populated by the system\n on access.\n"]
    pub last_access: cef_basetime_t,
    #[doc = "\n The cookie expiration date is only valid if |has_expires| is true.\n"]
    pub has_expires: ::std::os::raw::c_int,
    pub expires: cef_basetime_t,
    #[doc = "\n Same site.\n"]
    pub same_site: cef_cookie_same_site_t,
    #[doc = "\n Priority.\n"]
    pub priority: cef_cookie_priority_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_cookie_t"][::std::mem::size_of::<_cef_cookie_t>() - 152usize];
    ["Alignment of _cef_cookie_t"][::std::mem::align_of::<_cef_cookie_t>() - 8usize];
    ["Offset of field: _cef_cookie_t::size"][::std::mem::offset_of!(_cef_cookie_t, size) - 0usize];
    ["Offset of field: _cef_cookie_t::name"][::std::mem::offset_of!(_cef_cookie_t, name) - 8usize];
    ["Offset of field: _cef_cookie_t::value"]
        [::std::mem::offset_of!(_cef_cookie_t, value) - 32usize];
    ["Offset of field: _cef_cookie_t::domain"]
        [::std::mem::offset_of!(_cef_cookie_t, domain) - 56usize];
    ["Offset of field: _cef_cookie_t::path"][::std::mem::offset_of!(_cef_cookie_t, path) - 80usize];
    ["Offset of field: _cef_cookie_t::secure"]
        [::std::mem::offset_of!(_cef_cookie_t, secure) - 104usize];
    ["Offset of field: _cef_cookie_t::httponly"]
        [::std::mem::offset_of!(_cef_cookie_t, httponly) - 108usize];
    ["Offset of field: _cef_cookie_t::creation"]
        [::std::mem::offset_of!(_cef_cookie_t, creation) - 112usize];
    ["Offset of field: _cef_cookie_t::last_access"]
        [::std::mem::offset_of!(_cef_cookie_t, last_access) - 120usize];
    ["Offset of field: _cef_cookie_t::has_expires"]
        [::std::mem::offset_of!(_cef_cookie_t, has_expires) - 128usize];
    ["Offset of field: _cef_cookie_t::expires"]
        [::std::mem::offset_of!(_cef_cookie_t, expires) - 136usize];
    ["Offset of field: _cef_cookie_t::same_site"]
        [::std::mem::offset_of!(_cef_cookie_t, same_site) - 144usize];
    ["Offset of field: _cef_cookie_t::priority"]
        [::std::mem::offset_of!(_cef_cookie_t, priority) - 148usize];
};
#[doc = "\n Cookie information.\n"]
pub type cef_cookie_t = _cef_cookie_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Process termination status values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_termination_status_t {
    #[doc = "\n Non-zero exit status.\n"]
    TS_ABNORMAL_TERMINATION = 0,
    #[doc = "\n SIGKILL or task manager kill.\n"]
    TS_PROCESS_WAS_KILLED = 1,
    #[doc = "\n Segmentation fault.\n"]
    TS_PROCESS_CRASHED = 2,
    #[doc = "\n Out of memory. Some platforms may use TS_PROCESS_CRASHED instead.\n"]
    TS_PROCESS_OOM = 3,
    #[doc = "\n Child process never launched.\n"]
    TS_LAUNCH_FAILED = 4,
    #[doc = "\n On Windows, the OS terminated the process due to code integrity failure.\n"]
    TS_INTEGRITY_FAILURE = 5,
    #[doc = "\n On Windows, the OS terminated the process due to code integrity failure.\n"]
    TS_NUM_VALUES = 6,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Path key values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_path_key_t {
    #[doc = "\n Current directory.\n"]
    PK_DIR_CURRENT = 0,
    #[doc = "\n Directory containing PK_FILE_EXE.\n"]
    PK_DIR_EXE = 1,
    #[doc = "\n Directory containing PK_FILE_MODULE.\n"]
    PK_DIR_MODULE = 2,
    #[doc = "\n Temporary directory.\n"]
    PK_DIR_TEMP = 3,
    #[doc = "\n Path and filename of the current executable.\n"]
    PK_FILE_EXE = 4,
    #[doc = "\n Path and filename of the module containing the CEF code (usually the\n libcef module).\n"]
    PK_FILE_MODULE = 5,
    #[doc = "\n \"Local Settings\\Application Data\" directory under the user profile\n directory on Windows.\n"]
    PK_LOCAL_APP_DATA = 6,
    #[doc = "\n \"Application Data\" directory under the user profile directory on Windows\n and \"~/Library/Application Support\" directory on MacOS.\n"]
    PK_USER_DATA = 7,
    #[doc = "\n Directory containing application resources. Can be configured via\n CefSettings.resources_dir_path.\n"]
    PK_DIR_RESOURCES = 8,
    #[doc = "\n Directory containing application resources. Can be configured via\n CefSettings.resources_dir_path.\n"]
    PK_NUM_VALUES = 9,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Storage types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_storage_type_t {
    ST_LOCALSTORAGE = 0,
    ST_SESSIONSTORAGE = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported error code values. For the complete list of error values see\n \"include/base/internal/cef_net_error_list.h\".\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_errorcode_t {
    ERR_NONE = 0,
    ERR_IO_PENDING = -1,
    ERR_FAILED = -2,
    ERR_ABORTED = -3,
    ERR_INVALID_ARGUMENT = -4,
    ERR_INVALID_HANDLE = -5,
    ERR_FILE_NOT_FOUND = -6,
    ERR_TIMED_OUT = -7,
    ERR_FILE_TOO_BIG = -8,
    ERR_UNEXPECTED = -9,
    ERR_ACCESS_DENIED = -10,
    ERR_NOT_IMPLEMENTED = -11,
    ERR_INSUFFICIENT_RESOURCES = -12,
    ERR_OUT_OF_MEMORY = -13,
    ERR_UPLOAD_FILE_CHANGED = -14,
    ERR_SOCKET_NOT_CONNECTED = -15,
    ERR_FILE_EXISTS = -16,
    ERR_FILE_PATH_TOO_LONG = -17,
    ERR_FILE_NO_SPACE = -18,
    ERR_FILE_VIRUS_INFECTED = -19,
    ERR_BLOCKED_BY_CLIENT = -20,
    ERR_NETWORK_CHANGED = -21,
    ERR_BLOCKED_BY_ADMINISTRATOR = -22,
    ERR_SOCKET_IS_CONNECTED = -23,
    ERR_UPLOAD_STREAM_REWIND_NOT_SUPPORTED = -25,
    ERR_CONTEXT_SHUT_DOWN = -26,
    ERR_BLOCKED_BY_RESPONSE = -27,
    ERR_CLEARTEXT_NOT_PERMITTED = -29,
    ERR_BLOCKED_BY_CSP = -30,
    ERR_H2_OR_QUIC_REQUIRED = -31,
    ERR_BLOCKED_BY_ORB = -32,
    ERR_NETWORK_ACCESS_REVOKED = -33,
    ERR_BLOCKED_BY_FINGERPRINTING_PROTECTION = -34,
    ERR_CONNECTION_CLOSED = -100,
    ERR_CONNECTION_RESET = -101,
    ERR_CONNECTION_REFUSED = -102,
    ERR_CONNECTION_ABORTED = -103,
    ERR_CONNECTION_FAILED = -104,
    ERR_NAME_NOT_RESOLVED = -105,
    ERR_INTERNET_DISCONNECTED = -106,
    ERR_SSL_PROTOCOL_ERROR = -107,
    ERR_ADDRESS_INVALID = -108,
    ERR_ADDRESS_UNREACHABLE = -109,
    ERR_SSL_CLIENT_AUTH_CERT_NEEDED = -110,
    ERR_TUNNEL_CONNECTION_FAILED = -111,
    ERR_NO_SSL_VERSIONS_ENABLED = -112,
    ERR_SSL_VERSION_OR_CIPHER_MISMATCH = -113,
    ERR_SSL_RENEGOTIATION_REQUESTED = -114,
    ERR_PROXY_AUTH_UNSUPPORTED = -115,
    ERR_BAD_SSL_CLIENT_AUTH_CERT = -117,
    ERR_CONNECTION_TIMED_OUT = -118,
    ERR_HOST_RESOLVER_QUEUE_TOO_LARGE = -119,
    ERR_SOCKS_CONNECTION_FAILED = -120,
    ERR_SOCKS_CONNECTION_HOST_UNREACHABLE = -121,
    ERR_ALPN_NEGOTIATION_FAILED = -122,
    ERR_SSL_NO_RENEGOTIATION = -123,
    ERR_WINSOCK_UNEXPECTED_WRITTEN_BYTES = -124,
    ERR_SSL_DECOMPRESSION_FAILURE_ALERT = -125,
    ERR_SSL_BAD_RECORD_MAC_ALERT = -126,
    ERR_PROXY_AUTH_REQUESTED = -127,
    ERR_PROXY_CONNECTION_FAILED = -130,
    ERR_MANDATORY_PROXY_CONFIGURATION_FAILED = -131,
    ERR_PRECONNECT_MAX_SOCKET_LIMIT = -133,
    ERR_SSL_CLIENT_AUTH_PRIVATE_KEY_ACCESS_DENIED = -134,
    ERR_SSL_CLIENT_AUTH_CERT_NO_PRIVATE_KEY = -135,
    ERR_PROXY_CERTIFICATE_INVALID = -136,
    ERR_NAME_RESOLUTION_FAILED = -137,
    ERR_NETWORK_ACCESS_DENIED = -138,
    ERR_TEMPORARILY_THROTTLED = -139,
    ERR_HTTPS_PROXY_TUNNEL_RESPONSE_REDIRECT = -140,
    ERR_SSL_CLIENT_AUTH_SIGNATURE_FAILED = -141,
    ERR_MSG_TOO_BIG = -142,
    ERR_WS_PROTOCOL_ERROR = -145,
    ERR_ADDRESS_IN_USE = -147,
    ERR_SSL_HANDSHAKE_NOT_COMPLETED = -148,
    ERR_SSL_BAD_PEER_PUBLIC_KEY = -149,
    ERR_SSL_PINNED_KEY_NOT_IN_CERT_CHAIN = -150,
    ERR_CLIENT_AUTH_CERT_TYPE_UNSUPPORTED = -151,
    ERR_SSL_DECRYPT_ERROR_ALERT = -153,
    ERR_WS_THROTTLE_QUEUE_TOO_LARGE = -154,
    ERR_SSL_SERVER_CERT_CHANGED = -156,
    ERR_SSL_UNRECOGNIZED_NAME_ALERT = -159,
    ERR_SOCKET_SET_RECEIVE_BUFFER_SIZE_ERROR = -160,
    ERR_SOCKET_SET_SEND_BUFFER_SIZE_ERROR = -161,
    ERR_SOCKET_RECEIVE_BUFFER_SIZE_UNCHANGEABLE = -162,
    ERR_SOCKET_SEND_BUFFER_SIZE_UNCHANGEABLE = -163,
    ERR_SSL_CLIENT_AUTH_CERT_BAD_FORMAT = -164,
    ERR_ICANN_NAME_COLLISION = -166,
    ERR_SSL_SERVER_CERT_BAD_FORMAT = -167,
    ERR_CT_STH_PARSING_FAILED = -168,
    ERR_CT_STH_INCOMPLETE = -169,
    ERR_UNABLE_TO_REUSE_CONNECTION_FOR_PROXY_AUTH = -170,
    ERR_CT_CONSISTENCY_PROOF_PARSING_FAILED = -171,
    ERR_SSL_OBSOLETE_CIPHER = -172,
    ERR_WS_UPGRADE = -173,
    ERR_READ_IF_READY_NOT_IMPLEMENTED = -174,
    ERR_NO_BUFFER_SPACE = -176,
    ERR_SSL_CLIENT_AUTH_NO_COMMON_ALGORITHMS = -177,
    ERR_EARLY_DATA_REJECTED = -178,
    ERR_WRONG_VERSION_ON_EARLY_DATA = -179,
    ERR_TLS13_DOWNGRADE_DETECTED = -180,
    ERR_SSL_KEY_USAGE_INCOMPATIBLE = -181,
    ERR_INVALID_ECH_CONFIG_LIST = -182,
    ERR_ECH_NOT_NEGOTIATED = -183,
    ERR_ECH_FALLBACK_CERTIFICATE_INVALID = -184,
    ERR_CERT_COMMON_NAME_INVALID = -200,
    ERR_CERT_DATE_INVALID = -201,
    ERR_CERT_AUTHORITY_INVALID = -202,
    ERR_CERT_CONTAINS_ERRORS = -203,
    ERR_CERT_NO_REVOCATION_MECHANISM = -204,
    ERR_CERT_UNABLE_TO_CHECK_REVOCATION = -205,
    ERR_CERT_REVOKED = -206,
    ERR_CERT_INVALID = -207,
    ERR_CERT_WEAK_SIGNATURE_ALGORITHM = -208,
    ERR_CERT_NON_UNIQUE_NAME = -210,
    ERR_CERT_WEAK_KEY = -211,
    ERR_CERT_NAME_CONSTRAINT_VIOLATION = -212,
    ERR_CERT_VALIDITY_TOO_LONG = -213,
    ERR_CERTIFICATE_TRANSPARENCY_REQUIRED = -214,
    ERR_CERT_KNOWN_INTERCEPTION_BLOCKED = -217,
    ERR_CERT_SELF_SIGNED_LOCAL_NETWORK = -219,
    ERR_CERT_END = -220,
    ERR_INVALID_URL = -300,
    ERR_DISALLOWED_URL_SCHEME = -301,
    ERR_UNKNOWN_URL_SCHEME = -302,
    ERR_INVALID_REDIRECT = -303,
    ERR_TOO_MANY_REDIRECTS = -310,
    ERR_UNSAFE_REDIRECT = -311,
    ERR_UNSAFE_PORT = -312,
    ERR_INVALID_RESPONSE = -320,
    ERR_INVALID_CHUNKED_ENCODING = -321,
    ERR_METHOD_NOT_SUPPORTED = -322,
    ERR_UNEXPECTED_PROXY_AUTH = -323,
    ERR_EMPTY_RESPONSE = -324,
    ERR_RESPONSE_HEADERS_TOO_BIG = -325,
    ERR_PAC_SCRIPT_FAILED = -327,
    ERR_REQUEST_RANGE_NOT_SATISFIABLE = -328,
    ERR_MALFORMED_IDENTITY = -329,
    ERR_CONTENT_DECODING_FAILED = -330,
    ERR_NETWORK_IO_SUSPENDED = -331,
    ERR_SYN_REPLY_NOT_RECEIVED = -332,
    ERR_ENCODING_CONVERSION_FAILED = -333,
    ERR_UNRECOGNIZED_FTP_DIRECTORY_LISTING_FORMAT = -334,
    ERR_NO_SUPPORTED_PROXIES = -336,
    ERR_HTTP2_PROTOCOL_ERROR = -337,
    ERR_INVALID_AUTH_CREDENTIALS = -338,
    ERR_UNSUPPORTED_AUTH_SCHEME = -339,
    ERR_ENCODING_DETECTION_FAILED = -340,
    ERR_MISSING_AUTH_CREDENTIALS = -341,
    ERR_UNEXPECTED_SECURITY_LIBRARY_STATUS = -342,
    ERR_MISCONFIGURED_AUTH_ENVIRONMENT = -343,
    ERR_UNDOCUMENTED_SECURITY_LIBRARY_STATUS = -344,
    ERR_RESPONSE_BODY_TOO_BIG_TO_DRAIN = -345,
    ERR_RESPONSE_HEADERS_MULTIPLE_CONTENT_LENGTH = -346,
    ERR_INCOMPLETE_HTTP2_HEADERS = -347,
    ERR_PAC_NOT_IN_DHCP = -348,
    ERR_RESPONSE_HEADERS_MULTIPLE_CONTENT_DISPOSITION = -349,
    ERR_RESPONSE_HEADERS_MULTIPLE_LOCATION = -350,
    ERR_HTTP2_SERVER_REFUSED_STREAM = -351,
    ERR_HTTP2_PING_FAILED = -352,
    ERR_CONTENT_LENGTH_MISMATCH = -354,
    ERR_INCOMPLETE_CHUNKED_ENCODING = -355,
    ERR_QUIC_PROTOCOL_ERROR = -356,
    ERR_RESPONSE_HEADERS_TRUNCATED = -357,
    ERR_QUIC_HANDSHAKE_FAILED = -358,
    ERR_HTTP2_INADEQUATE_TRANSPORT_SECURITY = -360,
    ERR_HTTP2_FLOW_CONTROL_ERROR = -361,
    ERR_HTTP2_FRAME_SIZE_ERROR = -362,
    ERR_HTTP2_COMPRESSION_ERROR = -363,
    ERR_PROXY_AUTH_REQUESTED_WITH_NO_CONNECTION = -364,
    ERR_HTTP_1_1_REQUIRED = -365,
    ERR_PROXY_HTTP_1_1_REQUIRED = -366,
    ERR_PAC_SCRIPT_TERMINATED = -367,
    ERR_PROXY_REQUIRED = -368,
    ERR_INVALID_HTTP_RESPONSE = -370,
    ERR_CONTENT_DECODING_INIT_FAILED = -371,
    ERR_HTTP2_RST_STREAM_NO_ERROR_RECEIVED = -372,
    ERR_TOO_MANY_RETRIES = -375,
    ERR_HTTP2_STREAM_CLOSED = -376,
    ERR_HTTP_RESPONSE_CODE_FAILURE = -379,
    ERR_QUIC_CERT_ROOT_NOT_KNOWN = -380,
    ERR_QUIC_GOAWAY_REQUEST_CAN_BE_RETRIED = -381,
    ERR_TOO_MANY_ACCEPT_CH_RESTARTS = -382,
    ERR_INCONSISTENT_IP_ADDRESS_SPACE = -383,
    ERR_CACHED_IP_ADDRESS_SPACE_BLOCKED_BY_PRIVATE_NETWORK_ACCESS_POLICY = -384,
    ERR_BLOCKED_BY_PRIVATE_NETWORK_ACCESS_CHECKS = -385,
    ERR_ZSTD_WINDOW_SIZE_TOO_BIG = -386,
    ERR_DICTIONARY_LOAD_FAILED = -387,
    ERR_UNEXPECTED_CONTENT_DICTIONARY_HEADER = -388,
    ERR_CACHE_MISS = -400,
    ERR_CACHE_READ_FAILURE = -401,
    ERR_CACHE_WRITE_FAILURE = -402,
    ERR_CACHE_OPERATION_NOT_SUPPORTED = -403,
    ERR_CACHE_OPEN_FAILURE = -404,
    ERR_CACHE_CREATE_FAILURE = -405,
    ERR_CACHE_RACE = -406,
    ERR_CACHE_CHECKSUM_READ_FAILURE = -407,
    ERR_CACHE_CHECKSUM_MISMATCH = -408,
    ERR_CACHE_LOCK_TIMEOUT = -409,
    ERR_CACHE_AUTH_FAILURE_AFTER_READ = -410,
    ERR_CACHE_ENTRY_NOT_SUITABLE = -411,
    ERR_CACHE_DOOM_FAILURE = -412,
    ERR_CACHE_OPEN_OR_CREATE_FAILURE = -413,
    ERR_INSECURE_RESPONSE = -501,
    ERR_NO_PRIVATE_KEY_FOR_CERT = -502,
    ERR_ADD_USER_CERT_FAILED = -503,
    ERR_INVALID_SIGNED_EXCHANGE = -504,
    ERR_INVALID_WEB_BUNDLE = -505,
    ERR_TRUST_TOKEN_OPERATION_FAILED = -506,
    ERR_TRUST_TOKEN_OPERATION_SUCCESS_WITHOUT_SENDING_REQUEST = -507,
    ERR_PKCS12_IMPORT_BAD_PASSWORD = -701,
    ERR_PKCS12_IMPORT_FAILED = -702,
    ERR_IMPORT_CA_CERT_NOT_CA = -703,
    ERR_IMPORT_CERT_ALREADY_EXISTS = -704,
    ERR_IMPORT_CA_CERT_FAILED = -705,
    ERR_IMPORT_SERVER_CERT_FAILED = -706,
    ERR_PKCS12_IMPORT_INVALID_MAC = -707,
    ERR_PKCS12_IMPORT_INVALID_FILE = -708,
    ERR_PKCS12_IMPORT_UNSUPPORTED = -709,
    ERR_KEY_GENERATION_FAILED = -710,
    ERR_PRIVATE_KEY_EXPORT_FAILED = -712,
    ERR_SELF_SIGNED_CERT_GENERATION_FAILED = -713,
    ERR_CERT_DATABASE_CHANGED = -714,
    ERR_CERT_VERIFIER_CHANGED = -716,
    ERR_DNS_MALFORMED_RESPONSE = -800,
    ERR_DNS_SERVER_REQUIRES_TCP = -801,
    ERR_DNS_SERVER_FAILED = -802,
    ERR_DNS_TIMED_OUT = -803,
    ERR_DNS_CACHE_MISS = -804,
    ERR_DNS_SEARCH_EMPTY = -805,
    ERR_DNS_SORT_ERROR = -806,
    ERR_DNS_SECURE_RESOLVER_HOSTNAME_RESOLUTION_FAILED = -808,
    ERR_DNS_NAME_HTTPS_ONLY = -809,
    ERR_DNS_REQUEST_CANCELLED = -810,
    ERR_DNS_NO_MATCHING_SUPPORTED_ALPN = -811,
    ERR_DNS_SECURE_PROBE_RECORD_INVALID = -814,
    ERR_BLOB_INVALID_CONSTRUCTION_ARGUMENTS = -900,
    ERR_BLOB_OUT_OF_MEMORY = -901,
    ERR_BLOB_FILE_WRITE_FAILED = -902,
    ERR_BLOB_SOURCE_DIED_IN_TRANSIT = -903,
    ERR_BLOB_DEREFERENCED_WHILE_BUILDING = -904,
    ERR_BLOB_REFERENCED_BLOB_BROKEN = -905,
    ERR_BLOB_REFERENCED_FILE_UNAVAILABLE = -906,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported certificate status code values. See net\\cert\\cert_status_flags.h\n for more information. CERT_STATUS_NONE is new in CEF because we use an\n enum while cert_status_flags.h uses a typedef and static const variables.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_cert_status_t {
    CERT_STATUS_NONE = 0,
    CERT_STATUS_COMMON_NAME_INVALID = 1,
    CERT_STATUS_DATE_INVALID = 2,
    CERT_STATUS_AUTHORITY_INVALID = 4,
    CERT_STATUS_NO_REVOCATION_MECHANISM = 16,
    CERT_STATUS_UNABLE_TO_CHECK_REVOCATION = 32,
    CERT_STATUS_REVOKED = 64,
    CERT_STATUS_INVALID = 128,
    CERT_STATUS_WEAK_SIGNATURE_ALGORITHM = 256,
    CERT_STATUS_NON_UNIQUE_NAME = 1024,
    CERT_STATUS_WEAK_KEY = 2048,
    CERT_STATUS_PINNED_KEY_MISSING = 8192,
    CERT_STATUS_NAME_CONSTRAINT_VIOLATION = 16384,
    CERT_STATUS_VALIDITY_TOO_LONG = 32768,
    CERT_STATUS_IS_EV = 65536,
    CERT_STATUS_REV_CHECKING_ENABLED = 131072,
    CERT_STATUS_SHA1_SIGNATURE_PRESENT = 524288,
    CERT_STATUS_CT_COMPLIANCE_FAILED = 1048576,
}
impl cef_resultcode_t {
    pub const CEF_RESULT_CODE_SANDBOX_FATAL_INTEGRITY: cef_resultcode_t =
        cef_resultcode_t::CEF_RESULT_CODE_SANDBOX_FATAL_FIRST;
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Process result codes. This is not a comprehensive list, as result codes\n might also include platform-specific crash values (Posix signal or Windows\n hardware exception), or internal-only implementation values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_resultcode_t {
    CEF_RESULT_CODE_NORMAL_EXIT = 0,
    #[doc = " Process was killed by user or system."]
    CEF_RESULT_CODE_KILLED = 1,
    #[doc = " Process hung."]
    CEF_RESULT_CODE_HUNG = 2,
    #[doc = " A bad message caused the process termination."]
    CEF_RESULT_CODE_KILLED_BAD_MESSAGE = 3,
    #[doc = " The GPU process exited because initialization failed."]
    CEF_RESULT_CODE_GPU_DEAD_ON_ARRIVAL = 4,
    #[doc = " The GPU process exited because initialization failed."]
    CEF_RESULT_CODE_CHROME_FIRST = 5,
    #[doc = " The process is of an unknown type."]
    CEF_RESULT_CODE_BAD_PROCESS_TYPE = 6,
    #[doc = " A critical chrome file is missing."]
    CEF_RESULT_CODE_MISSING_DATA = 7,
    #[doc = " Command line parameter is not supported."]
    CEF_RESULT_CODE_UNSUPPORTED_PARAM = 13,
    #[doc = " The profile was in use on another host."]
    CEF_RESULT_CODE_PROFILE_IN_USE = 21,
    #[doc = " Failed to pack an extension via the command line."]
    CEF_RESULT_CODE_PACK_EXTENSION_ERROR = 22,
    #[doc = " The browser process exited early by passing the command line to another\n running browser."]
    CEF_RESULT_CODE_NORMAL_EXIT_PROCESS_NOTIFIED = 24,
    #[doc = " A browser process was sandboxed. This should never happen."]
    CEF_RESULT_CODE_INVALID_SANDBOX_STATE = 31,
    #[doc = " Cloud policy enrollment failed or was given up by user."]
    CEF_RESULT_CODE_CLOUD_POLICY_ENROLLMENT_FAILED = 32,
    #[doc = " The GPU process was terminated due to context lost."]
    CEF_RESULT_CODE_GPU_EXIT_ON_CONTEXT_LOST = 34,
    #[doc = " An early startup command was executed and the browser must exit."]
    CEF_RESULT_CODE_NORMAL_EXIT_PACK_EXTENSION_SUCCESS = 36,
    #[doc = " The browser process exited because system resources are exhausted. The\n system state can't be recovered and will be unstable."]
    CEF_RESULT_CODE_SYSTEM_RESOURCE_EXHAUSTED = 37,
    #[doc = " The browser process exited because it was re-launched without elevation."]
    CEF_RESULT_CODE_NORMAL_EXIT_AUTO_DE_ELEVATED = 38,
    CEF_RESULT_CODE_CHROME_LAST = 39,
    CEF_RESULT_CODE_SANDBOX_FATAL_FIRST = 7006,
    #[doc = " Windows sandbox could not lower the token."]
    CEF_RESULT_CODE_SANDBOX_FATAL_DROPTOKEN = 7007,
    #[doc = " Windows sandbox failed to flush registry handles."]
    CEF_RESULT_CODE_SANDBOX_FATAL_FLUSHANDLES = 7008,
    #[doc = " Windows sandbox failed to forbid HCKU caching."]
    CEF_RESULT_CODE_SANDBOX_FATAL_CACHEDISABLE = 7009,
    #[doc = " Windows sandbox failed to close pending handles."]
    CEF_RESULT_CODE_SANDBOX_FATAL_CLOSEHANDLES = 7010,
    #[doc = " Windows sandbox could not set the mitigation policy."]
    CEF_RESULT_CODE_SANDBOX_FATAL_MITIGATION = 7011,
    #[doc = " Windows sandbox exceeded the job memory limit."]
    CEF_RESULT_CODE_SANDBOX_FATAL_MEMORY_EXCEEDED = 7012,
    #[doc = " Windows sandbox failed to warmup."]
    CEF_RESULT_CODE_SANDBOX_FATAL_WARMUP = 7013,
    #[doc = " Windows sandbox failed to warmup."]
    CEF_RESULT_CODE_SANDBOX_FATAL_BROKER_SHUTDOWN_HUNG = 7014,
    #[doc = " Windows sandbox failed to warmup."]
    CEF_RESULT_CODE_SANDBOX_FATAL_LAST = 7015,
    #[doc = " Windows sandbox failed to warmup."]
    CEF_RESULT_CODE_NUM_VALUES = 7016,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n The manner in which a link click should be opened. These constants match\n their equivalents in Chromium's window_open_disposition.h and should not be\n renumbered.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_window_open_disposition_t {
    CEF_WOD_UNKNOWN = 0,
    #[doc = "\n Current tab. This is the default in most cases.\n"]
    CEF_WOD_CURRENT_TAB = 1,
    #[doc = "\n Indicates that only one tab with the url should exist in the same window.\n"]
    CEF_WOD_SINGLETON_TAB = 2,
    #[doc = "\n Shift key + Middle mouse button or meta/ctrl key while clicking.\n"]
    CEF_WOD_NEW_FOREGROUND_TAB = 3,
    #[doc = "\n Middle mouse button or meta/ctrl key while clicking.\n"]
    CEF_WOD_NEW_BACKGROUND_TAB = 4,
    #[doc = "\n New popup window.\n"]
    CEF_WOD_NEW_POPUP = 5,
    #[doc = "\n Shift key while clicking.\n"]
    CEF_WOD_NEW_WINDOW = 6,
    #[doc = "\n Alt key while clicking.\n"]
    CEF_WOD_SAVE_TO_DISK = 7,
    #[doc = "\n New off-the-record (incognito) window.\n"]
    CEF_WOD_OFF_THE_RECORD = 8,
    #[doc = "\n Special case error condition from the renderer.\n"]
    CEF_WOD_IGNORE_ACTION = 9,
    #[doc = "\n Activates an existing tab containing the url, rather than navigating.\n This is similar to SINGLETON_TAB, but searches across all windows from\n the current profile and anonymity (instead of just the current one);\n closes the current tab on switching if the current tab was the NTP with\n no session history; and behaves like CURRENT_TAB instead of\n NEW_FOREGROUND_TAB when no existing tab is found.\n"]
    CEF_WOD_SWITCH_TO_TAB = 10,
    #[doc = "\n Creates a new document picture-in-picture window showing a child WebView.\n"]
    CEF_WOD_NEW_PICTURE_IN_PICTURE = 11,
    #[doc = "\n Creates a new document picture-in-picture window showing a child WebView.\n"]
    CEF_WOD_NUM_VALUES = 12,
}
impl cef_drag_operations_mask_t {
    pub const DRAG_OPERATION_NONE: cef_drag_operations_mask_t = cef_drag_operations_mask_t(0);
    pub const DRAG_OPERATION_COPY: cef_drag_operations_mask_t = cef_drag_operations_mask_t(1);
    pub const DRAG_OPERATION_LINK: cef_drag_operations_mask_t = cef_drag_operations_mask_t(2);
    pub const DRAG_OPERATION_GENERIC: cef_drag_operations_mask_t = cef_drag_operations_mask_t(4);
    pub const DRAG_OPERATION_PRIVATE: cef_drag_operations_mask_t = cef_drag_operations_mask_t(8);
    pub const DRAG_OPERATION_MOVE: cef_drag_operations_mask_t = cef_drag_operations_mask_t(16);
    pub const DRAG_OPERATION_DELETE: cef_drag_operations_mask_t = cef_drag_operations_mask_t(32);
    pub const DRAG_OPERATION_EVERY: cef_drag_operations_mask_t = cef_drag_operations_mask_t(-1);
}
impl ::std::ops::BitOr<cef_drag_operations_mask_t> for cef_drag_operations_mask_t {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        cef_drag_operations_mask_t(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for cef_drag_operations_mask_t {
    #[inline]
    fn bitor_assign(&mut self, rhs: cef_drag_operations_mask_t) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<cef_drag_operations_mask_t> for cef_drag_operations_mask_t {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        cef_drag_operations_mask_t(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for cef_drag_operations_mask_t {
    #[inline]
    fn bitand_assign(&mut self, rhs: cef_drag_operations_mask_t) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[doc = "\n \"Verb\" of a drag-and-drop operation as negotiated between the source and\n destination. These constants match their equivalents in WebCore's\n DragActions.h and should not be renumbered.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct cef_drag_operations_mask_t(pub ::std::os::raw::c_int);
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Input mode of a virtual keyboard. These constants match their equivalents\n in Chromium's text_input_mode.h and should not be renumbered.\n See https://html.spec.whatwg.org/#input-modalities:-the-inputmode-attribute\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_text_input_mode_t {
    CEF_TEXT_INPUT_MODE_DEFAULT = 0,
    CEF_TEXT_INPUT_MODE_NONE = 1,
    CEF_TEXT_INPUT_MODE_TEXT = 2,
    CEF_TEXT_INPUT_MODE_TEL = 3,
    CEF_TEXT_INPUT_MODE_URL = 4,
    CEF_TEXT_INPUT_MODE_EMAIL = 5,
    CEF_TEXT_INPUT_MODE_NUMERIC = 6,
    CEF_TEXT_INPUT_MODE_DECIMAL = 7,
    CEF_TEXT_INPUT_MODE_SEARCH = 8,
    CEF_TEXT_INPUT_MODE_NUM_VALUES = 9,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n V8 property attribute values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_v8_propertyattribute_t {
    #[doc = "\n Writeable, Enumerable, Configurable\n"]
    V8_PROPERTY_ATTRIBUTE_NONE = 0,
    #[doc = "\n Not writeable\n"]
    V8_PROPERTY_ATTRIBUTE_READONLY = 1,
    #[doc = "\n Not enumerable\n"]
    V8_PROPERTY_ATTRIBUTE_DONTENUM = 2,
    #[doc = "\n Not configurable\n"]
    V8_PROPERTY_ATTRIBUTE_DONTDELETE = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Post data elements may represent either bytes or files.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_postdataelement_type_t {
    PDE_TYPE_EMPTY = 0,
    PDE_TYPE_BYTES = 1,
    PDE_TYPE_FILE = 2,
    PDE_TYPE_NUM_VALUES = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Resource type for a request. These constants match their equivalents in\n Chromium's ResourceType and should not be renumbered.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_resource_type_t {
    #[doc = "\n Top level page.\n"]
    RT_MAIN_FRAME = 0,
    #[doc = "\n Frame or iframe.\n"]
    RT_SUB_FRAME = 1,
    #[doc = "\n CSS stylesheet.\n"]
    RT_STYLESHEET = 2,
    #[doc = "\n External script.\n"]
    RT_SCRIPT = 3,
    #[doc = "\n Image (jpg/gif/png/etc).\n"]
    RT_IMAGE = 4,
    #[doc = "\n Font.\n"]
    RT_FONT_RESOURCE = 5,
    #[doc = "\n Some other subresource. This is the default type if the actual type is\n unknown.\n"]
    RT_SUB_RESOURCE = 6,
    #[doc = "\n Object (or embed) tag for a plugin, or a resource that a plugin requested.\n"]
    RT_OBJECT = 7,
    #[doc = "\n Media resource.\n"]
    RT_MEDIA = 8,
    #[doc = "\n Main resource of a dedicated worker.\n"]
    RT_WORKER = 9,
    #[doc = "\n Main resource of a shared worker.\n"]
    RT_SHARED_WORKER = 10,
    #[doc = "\n Explicitly requested prefetch.\n"]
    RT_PREFETCH = 11,
    #[doc = "\n Favicon.\n"]
    RT_FAVICON = 12,
    #[doc = "\n XMLHttpRequest.\n"]
    RT_XHR = 13,
    #[doc = "\n A request for a \"<ping>\".\n"]
    RT_PING = 14,
    #[doc = "\n Main resource of a service worker.\n"]
    RT_SERVICE_WORKER = 15,
    #[doc = "\n A report of Content Security Policy violations.\n"]
    RT_CSP_REPORT = 16,
    #[doc = "\n A resource that a plugin requested.\n"]
    RT_PLUGIN_RESOURCE = 17,
    #[doc = "\n A main-frame service worker navigation preload request.\n"]
    RT_NAVIGATION_PRELOAD_MAIN_FRAME = 19,
    #[doc = "\n A sub-frame service worker navigation preload request.\n"]
    RT_NAVIGATION_PRELOAD_SUB_FRAME = 20,
    #[doc = "\n A sub-frame service worker navigation preload request.\n"]
    RT_NUM_VALUES = 21,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Transition type for a request. Made up of one source value and 0 or more\n qualifiers.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_transition_type_t {
    #[doc = "\n Source is a link click or the JavaScript window.open function. This is\n also the default value for requests like sub-resource loads that are not\n navigations.\n"]
    TT_LINK = 0,
    #[doc = "\n Source is some other \"explicit\" navigation. This is the default value for\n navigations where the actual type is unknown. See also\n TT_DIRECT_LOAD_FLAG.\n"]
    TT_EXPLICIT = 1,
    #[doc = "\n User got to this page through a suggestion in the UI (for example, via the\n destinations page). Chrome style only.\n"]
    TT_AUTO_BOOKMARK = 2,
    #[doc = "\n Source is a subframe navigation. This is any content that is automatically\n loaded in a non-toplevel frame. For example, if a page consists of several\n frames containing ads, those ad URLs will have this transition type.\n The user may not even realize the content in these pages is a separate\n frame, so may not care about the URL.\n"]
    TT_AUTO_SUBFRAME = 3,
    #[doc = "\n Source is a subframe navigation explicitly requested by the user that will\n generate new navigation entries in the back/forward list. These are\n probably more important than frames that were automatically loaded in\n the background because the user probably cares about the fact that this\n link was loaded.\n"]
    TT_MANUAL_SUBFRAME = 4,
    #[doc = "\n User got to this page by typing in the URL bar and selecting an entry\n that did not look like a URL.  For example, a match might have the URL\n of a Google search result page, but appear like \"Search Google for ...\".\n These are not quite the same as EXPLICIT navigations because the user\n didn't type or see the destination URL. Chrome style only.\n See also TT_KEYWORD.\n"]
    TT_GENERATED = 5,
    #[doc = "\n This is a toplevel navigation. This is any content that is automatically\n loaded in a toplevel frame.  For example, opening a tab to show the ASH\n screen saver, opening the devtools window, opening the NTP after the safe\n browsing warning, opening web-based dialog boxes are examples of\n AUTO_TOPLEVEL navigations. Chrome style only.\n"]
    TT_AUTO_TOPLEVEL = 6,
    #[doc = "\n Source is a form submission by the user. NOTE: In some situations\n submitting a form does not result in this transition type. This can happen\n if the form uses a script to submit the contents.\n"]
    TT_FORM_SUBMIT = 7,
    #[doc = "\n Source is a \"reload\" of the page via the Reload function or by re-visiting\n the same URL. NOTE: This is distinct from the concept of whether a\n particular load uses \"reload semantics\" (i.e. bypasses cached data).\n"]
    TT_RELOAD = 8,
    #[doc = "\n The url was generated from a replaceable keyword other than the default\n search provider. If the user types a keyword (which also applies to\n tab-to-search) in the omnibox this qualifier is applied to the transition\n type of the generated url. TemplateURLModel then may generate an\n additional visit with a transition type of TT_KEYWORD_GENERATED against\n the url 'http://' + keyword. For example, if you do a tab-to-search\n against wikipedia the generated url has a transition qualifer of\n TT_KEYWORD, and TemplateURLModel generates a visit for 'wikipedia.org'\n with a transition type of TT_KEYWORD_GENERATED. Chrome style only.\n"]
    TT_KEYWORD = 9,
    #[doc = "\n Corresponds to a visit generated for a keyword. See description of\n TT_KEYWORD for more details. Chrome style only.\n"]
    TT_KEYWORD_GENERATED = 10,
    #[doc = "\n Corresponds to a visit generated for a keyword. See description of\n TT_KEYWORD for more details. Chrome style only.\n"]
    TT_NUM_VALUES = 11,
    #[doc = "\n General mask defining the bits used for the source values.\n"]
    TT_SOURCE_MASK = 255,
    #[doc = "\n Attempted to visit a URL but was blocked.\n"]
    TT_BLOCKED_FLAG = 8388608,
    #[doc = "\n Used the Forward or Back function to navigate among browsing history.\n Will be ORed to the transition type for the original load.\n"]
    TT_FORWARD_BACK_FLAG = 16777216,
    #[doc = "\n Loaded a URL directly via CreateBrowser, LoadURL or LoadRequest.\n"]
    TT_DIRECT_LOAD_FLAG = 33554432,
    #[doc = "\n User is navigating to the home page. Chrome style only.\n"]
    TT_HOME_PAGE_FLAG = 67108864,
    #[doc = "\n The transition originated from an external application; the exact\n definition of this is embedder dependent. Chrome style only.\n"]
    TT_FROM_API_FLAG = 134217728,
    #[doc = "\n The beginning of a navigation chain.\n"]
    TT_CHAIN_START_FLAG = 268435456,
    #[doc = "\n The last transition in a redirect chain.\n"]
    TT_CHAIN_END_FLAG = 536870912,
    #[doc = "\n Redirects caused by JavaScript or a meta refresh tag on the page.\n"]
    TT_CLIENT_REDIRECT_FLAG = 1073741824,
    #[doc = "\n Redirects sent from the server by HTTP headers.\n"]
    TT_SERVER_REDIRECT_FLAG = -2147483648,
    #[doc = "\n Used to test whether a transition involves a redirect.\n"]
    TT_IS_REDIRECT_MASK = -1073741824,
    #[doc = "\n General mask defining the bits used for the qualifiers.\n"]
    TT_QUALIFIER_MASK = -256,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Flags used to customize the behavior of CefURLRequest.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_urlrequest_flags_t {
    #[doc = "\n Default behavior.\n"]
    UR_FLAG_NONE = 0,
    #[doc = "\n If set the cache will be skipped when handling the request. Setting this\n value is equivalent to specifying the \"Cache-Control: no-cache\" request\n header. Setting this value in combination with UR_FLAG_ONLY_FROM_CACHE\n will cause the request to fail.\n"]
    UR_FLAG_SKIP_CACHE = 1,
    #[doc = "\n If set the request will fail if it cannot be served from the cache (or\n some equivalent local store). Setting this value is equivalent to\n specifying the \"Cache-Control: only-if-cached\" request header. Setting\n this value in combination with UR_FLAG_SKIP_CACHE or UR_FLAG_DISABLE_CACHE\n will cause the request to fail.\n"]
    UR_FLAG_ONLY_FROM_CACHE = 2,
    #[doc = "\n If set the cache will not be used at all. Setting this value is equivalent\n to specifying the \"Cache-Control: no-store\" request header. Setting this\n value in combination with UR_FLAG_ONLY_FROM_CACHE will cause the request\n to fail.\n"]
    UR_FLAG_DISABLE_CACHE = 4,
    #[doc = "\n If set user name, password, and cookies may be sent with the request, and\n cookies may be saved from the response.\n"]
    UR_FLAG_ALLOW_STORED_CREDENTIALS = 8,
    #[doc = "\n If set upload progress events will be generated when a request has a body.\n"]
    UR_FLAG_REPORT_UPLOAD_PROGRESS = 16,
    #[doc = "\n If set the CefURLRequestClient::OnDownloadData method will not be called.\n"]
    UR_FLAG_NO_DOWNLOAD_DATA = 32,
    #[doc = "\n If set 5XX redirect errors will be propagated to the observer instead of\n automatically re-tried. This currently only applies for requests\n originated in the browser process.\n"]
    UR_FLAG_NO_RETRY_ON_5XX = 64,
    #[doc = "\n If set 3XX responses will cause the fetch to halt immediately rather than\n continue through the redirect.\n"]
    UR_FLAG_STOP_ON_REDIRECT = 128,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Flags that represent CefURLRequest status.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_urlrequest_status_t {
    #[doc = "\n Unknown status.\n"]
    UR_UNKNOWN = 0,
    #[doc = "\n Request succeeded.\n"]
    UR_SUCCESS = 1,
    #[doc = "\n An IO request is pending, and the caller will be informed when it is\n completed.\n"]
    UR_IO_PENDING = 2,
    #[doc = "\n Request was canceled programatically.\n"]
    UR_CANCELED = 3,
    #[doc = "\n Request failed for some reason.\n"]
    UR_FAILED = 4,
    #[doc = "\n Request failed for some reason.\n"]
    UR_NUM_VALUES = 5,
}
#[doc = " Structure representing a draggable region.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_draggable_region_t {
    #[doc = "\n Bounds of the region.\n"]
    pub bounds: cef_rect_t,
    #[doc = "\n True (1) this this region is draggable and false (0) otherwise.\n"]
    pub draggable: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_draggable_region_t"][::std::mem::size_of::<_cef_draggable_region_t>() - 20usize];
    ["Alignment of _cef_draggable_region_t"]
        [::std::mem::align_of::<_cef_draggable_region_t>() - 4usize];
    ["Offset of field: _cef_draggable_region_t::bounds"]
        [::std::mem::offset_of!(_cef_draggable_region_t, bounds) - 0usize];
    ["Offset of field: _cef_draggable_region_t::draggable"]
        [::std::mem::offset_of!(_cef_draggable_region_t, draggable) - 16usize];
};
#[doc = " Structure representing a draggable region.\n"]
pub type cef_draggable_region_t = _cef_draggable_region_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Existing process IDs.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_process_id_t {
    #[doc = "\n Browser process.\n"]
    PID_BROWSER = 0,
    #[doc = "\n Renderer process.\n"]
    PID_RENDERER = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Existing thread IDs.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_thread_id_t {
    #[doc = "\n The main thread in the browser. This will be the same as the main\n application thread if CefInitialize() is called with a\n CefSettings.multi_threaded_message_loop value of false. Do not perform\n blocking tasks on this thread. All tasks posted after\n CefBrowserProcessHandler::OnContextInitialized() and before CefShutdown()\n are guaranteed to run. This thread will outlive all other CEF threads.\n"]
    TID_UI = 0,
    #[doc = "\n Used for blocking tasks like file system access where the user won't\n notice if the task takes an arbitrarily long time to complete. All tasks\n posted after CefBrowserProcessHandler::OnContextInitialized() and before\n CefShutdown() are guaranteed to run.\n"]
    TID_FILE_BACKGROUND = 1,
    #[doc = "\n Used for blocking tasks like file system access that affect UI or\n responsiveness of future user interactions. Do not use if an immediate\n response to a user interaction is expected. All tasks posted after\n CefBrowserProcessHandler::OnContextInitialized() and before CefShutdown()\n are guaranteed to run.\n Examples:\n - Updating the UI to reflect progress on a long task.\n - Loading data that might be shown in the UI after a future user\n   interaction.\n"]
    TID_FILE_USER_VISIBLE = 2,
    #[doc = "\n Used for blocking tasks like file system access that affect UI\n immediately after a user interaction. All tasks posted after\n CefBrowserProcessHandler::OnContextInitialized() and before CefShutdown()\n are guaranteed to run.\n Example: Generating data shown in the UI immediately after a click.\n"]
    TID_FILE_USER_BLOCKING = 3,
    #[doc = "\n Used to launch and terminate browser processes.\n"]
    TID_PROCESS_LAUNCHER = 4,
    #[doc = "\n Used to process IPC and network messages. Do not perform blocking tasks on\n this thread. All tasks posted after\n CefBrowserProcessHandler::OnContextInitialized() and before CefShutdown()\n are guaranteed to run.\n"]
    TID_IO = 5,
    #[doc = "\n The main thread in the renderer. Used for all WebKit and V8 interaction.\n Tasks may be posted to this thread after\n CefRenderProcessHandler::OnWebKitInitialized but are not guaranteed to\n run before sub-process termination (sub-processes may be killed at any\n time without warning).\n"]
    TID_RENDERER = 6,
    #[doc = "\n The main thread in the renderer. Used for all WebKit and V8 interaction.\n Tasks may be posted to this thread after\n CefRenderProcessHandler::OnWebKitInitialized but are not guaranteed to\n run before sub-process termination (sub-processes may be killed at any\n time without warning).\n"]
    TID_NUM_VALUES = 7,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Thread priority values listed in increasing order of importance.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_thread_priority_t {
    #[doc = "\n Suitable for threads that shouldn't disrupt high priority work.\n"]
    TP_BACKGROUND = 0,
    #[doc = "\n Default priority level.\n"]
    TP_NORMAL = 1,
    #[doc = "\n Suitable for threads which generate data for the display (at ~60Hz).\n"]
    TP_DISPLAY = 2,
    #[doc = "\n Suitable for low-latency, glitch-resistant audio.\n"]
    TP_REALTIME_AUDIO = 3,
    #[doc = "\n Suitable for low-latency, glitch-resistant audio.\n"]
    TP_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Message loop types. Indicates the set of asynchronous events that a message\n loop can process.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_message_loop_type_t {
    #[doc = "\n Supports tasks and timers.\n"]
    ML_TYPE_DEFAULT = 0,
    #[doc = "\n Supports tasks, timers and native UI events (e.g. Windows messages).\n"]
    ML_TYPE_UI = 1,
    #[doc = "\n Supports tasks, timers and asynchronous IO events.\n"]
    ML_TYPE_IO = 2,
    #[doc = "\n Supports tasks, timers and asynchronous IO events.\n"]
    ML_NUM_VALUES = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Windows COM initialization mode. Specifies how COM will be initialized for a\n new thread.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_com_init_mode_t {
    #[doc = "\n No COM initialization.\n"]
    COM_INIT_MODE_NONE = 0,
    #[doc = "\n Initialize COM using single-threaded apartments.\n"]
    COM_INIT_MODE_STA = 1,
    #[doc = "\n Initialize COM using multi-threaded apartments.\n"]
    COM_INIT_MODE_MTA = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported value types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_value_type_t {
    VTYPE_INVALID = 0,
    VTYPE_NULL = 1,
    VTYPE_BOOL = 2,
    VTYPE_INT = 3,
    VTYPE_DOUBLE = 4,
    VTYPE_STRING = 5,
    VTYPE_BINARY = 6,
    VTYPE_DICTIONARY = 7,
    VTYPE_LIST = 8,
    VTYPE_NUM_VALUES = 9,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported JavaScript dialog types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_jsdialog_type_t {
    JSDIALOGTYPE_ALERT = 0,
    JSDIALOGTYPE_CONFIRM = 1,
    JSDIALOGTYPE_PROMPT = 2,
    JSDIALOGTYPE_NUM_VALUES = 3,
}
#[doc = "\n Screen information used when window rendering is disabled. This structure is\n passed as a parameter to CefRenderHandler::GetScreenInfo and should be\n filled in by the client.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_screen_info_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Device scale factor. Specifies the ratio between physical and logical\n pixels.\n"]
    pub device_scale_factor: f32,
    #[doc = "\n The screen depth in bits per pixel.\n"]
    pub depth: ::std::os::raw::c_int,
    #[doc = "\n The bits per color component. This assumes that the colors are balanced\n equally.\n"]
    pub depth_per_component: ::std::os::raw::c_int,
    #[doc = "\n This can be true for black and white printers.\n"]
    pub is_monochrome: ::std::os::raw::c_int,
    #[doc = " The |rect| and |available_rect| properties are used to determine the\n available surface for rendering popup views.\n"]
    pub rect: cef_rect_t,
    #[doc = " The |rect| and |available_rect| properties are used to determine the\n available surface for rendering popup views.\n"]
    pub available_rect: cef_rect_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_screen_info_t"][::std::mem::size_of::<_cef_screen_info_t>() - 56usize];
    ["Alignment of _cef_screen_info_t"][::std::mem::align_of::<_cef_screen_info_t>() - 8usize];
    ["Offset of field: _cef_screen_info_t::size"]
        [::std::mem::offset_of!(_cef_screen_info_t, size) - 0usize];
    ["Offset of field: _cef_screen_info_t::device_scale_factor"]
        [::std::mem::offset_of!(_cef_screen_info_t, device_scale_factor) - 8usize];
    ["Offset of field: _cef_screen_info_t::depth"]
        [::std::mem::offset_of!(_cef_screen_info_t, depth) - 12usize];
    ["Offset of field: _cef_screen_info_t::depth_per_component"]
        [::std::mem::offset_of!(_cef_screen_info_t, depth_per_component) - 16usize];
    ["Offset of field: _cef_screen_info_t::is_monochrome"]
        [::std::mem::offset_of!(_cef_screen_info_t, is_monochrome) - 20usize];
    ["Offset of field: _cef_screen_info_t::rect"]
        [::std::mem::offset_of!(_cef_screen_info_t, rect) - 24usize];
    ["Offset of field: _cef_screen_info_t::available_rect"]
        [::std::mem::offset_of!(_cef_screen_info_t, available_rect) - 40usize];
};
#[doc = "\n Screen information used when window rendering is disabled. This structure is\n passed as a parameter to CefRenderHandler::GetScreenInfo and should be\n filled in by the client.\n"]
pub type cef_screen_info_t = _cef_screen_info_t;
#[doc = "\n Linux window properties, such as X11's WM_CLASS or Wayland's app_id.\n Those are passed to CefWindowDelegate, so the client can set them\n for the CefWindow's top-level. Thus, allowing window managers to correctly\n display the application's information (e.g., icons).\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_linux_window_properties_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Main window's Wayland's app_id\n"]
    pub wayland_app_id: cef_string_t,
    #[doc = "\n Main window's WM_CLASS_CLASS in X11\n"]
    pub wm_class_class: cef_string_t,
    #[doc = "\n Main window's WM_CLASS_NAME in X11\n"]
    pub wm_class_name: cef_string_t,
    #[doc = "\n Main window's WM_WINDOW_ROLE in X11\n"]
    pub wm_role_name: cef_string_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_linux_window_properties_t"]
        [::std::mem::size_of::<_cef_linux_window_properties_t>() - 104usize];
    ["Alignment of _cef_linux_window_properties_t"]
        [::std::mem::align_of::<_cef_linux_window_properties_t>() - 8usize];
    ["Offset of field: _cef_linux_window_properties_t::size"]
        [::std::mem::offset_of!(_cef_linux_window_properties_t, size) - 0usize];
    ["Offset of field: _cef_linux_window_properties_t::wayland_app_id"]
        [::std::mem::offset_of!(_cef_linux_window_properties_t, wayland_app_id) - 8usize];
    ["Offset of field: _cef_linux_window_properties_t::wm_class_class"]
        [::std::mem::offset_of!(_cef_linux_window_properties_t, wm_class_class) - 32usize];
    ["Offset of field: _cef_linux_window_properties_t::wm_class_name"]
        [::std::mem::offset_of!(_cef_linux_window_properties_t, wm_class_name) - 56usize];
    ["Offset of field: _cef_linux_window_properties_t::wm_role_name"]
        [::std::mem::offset_of!(_cef_linux_window_properties_t, wm_role_name) - 80usize];
};
#[doc = "\n Linux window properties, such as X11's WM_CLASS or Wayland's app_id.\n Those are passed to CefWindowDelegate, so the client can set them\n for the CefWindow's top-level. Thus, allowing window managers to correctly\n display the application's information (e.g., icons).\n"]
pub type cef_linux_window_properties_t = _cef_linux_window_properties_t;
impl cef_menu_id_t {
    pub const MENU_ID_SPELLCHECK_SUGGESTION_LAST: cef_menu_id_t =
        cef_menu_id_t::MENU_ID_SPELLCHECK_SUGGESTION_4;
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported menu IDs. Non-English translations can be provided for the\n IDS_MENU_* strings in CefResourceBundleHandler::GetLocalizedString().\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_menu_id_t {
    MENU_ID_BACK = 100,
    MENU_ID_FORWARD = 101,
    MENU_ID_RELOAD = 102,
    MENU_ID_RELOAD_NOCACHE = 103,
    MENU_ID_STOPLOAD = 104,
    MENU_ID_UNDO = 110,
    MENU_ID_REDO = 111,
    MENU_ID_CUT = 112,
    MENU_ID_COPY = 113,
    MENU_ID_PASTE = 114,
    MENU_ID_PASTE_MATCH_STYLE = 115,
    MENU_ID_DELETE = 116,
    MENU_ID_SELECT_ALL = 117,
    MENU_ID_FIND = 130,
    MENU_ID_PRINT = 131,
    MENU_ID_VIEW_SOURCE = 132,
    MENU_ID_SPELLCHECK_SUGGESTION_0 = 200,
    MENU_ID_SPELLCHECK_SUGGESTION_1 = 201,
    MENU_ID_SPELLCHECK_SUGGESTION_2 = 202,
    MENU_ID_SPELLCHECK_SUGGESTION_3 = 203,
    MENU_ID_SPELLCHECK_SUGGESTION_4 = 204,
    MENU_ID_NO_SPELLING_SUGGESTIONS = 205,
    MENU_ID_ADD_TO_DICTIONARY = 206,
    MENU_ID_CUSTOM_FIRST = 220,
    MENU_ID_CUSTOM_LAST = 250,
    MENU_ID_USER_FIRST = 26500,
    MENU_ID_USER_LAST = 28500,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Mouse button types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_mouse_button_type_t {
    MBT_LEFT = 0,
    MBT_MIDDLE = 1,
    MBT_RIGHT = 2,
}
#[doc = "\n Structure representing mouse event information.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_mouse_event_t {
    #[doc = "\n X coordinate relative to the left side of the view.\n"]
    pub x: ::std::os::raw::c_int,
    #[doc = "\n Y coordinate relative to the top side of the view.\n"]
    pub y: ::std::os::raw::c_int,
    #[doc = "\n Bit flags describing any pressed modifier keys. See\n cef_event_flags_t for values.\n"]
    pub modifiers: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_mouse_event_t"][::std::mem::size_of::<_cef_mouse_event_t>() - 12usize];
    ["Alignment of _cef_mouse_event_t"][::std::mem::align_of::<_cef_mouse_event_t>() - 4usize];
    ["Offset of field: _cef_mouse_event_t::x"]
        [::std::mem::offset_of!(_cef_mouse_event_t, x) - 0usize];
    ["Offset of field: _cef_mouse_event_t::y"]
        [::std::mem::offset_of!(_cef_mouse_event_t, y) - 4usize];
    ["Offset of field: _cef_mouse_event_t::modifiers"]
        [::std::mem::offset_of!(_cef_mouse_event_t, modifiers) - 8usize];
};
#[doc = "\n Structure representing mouse event information.\n"]
pub type cef_mouse_event_t = _cef_mouse_event_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Touch points states types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_touch_event_type_t {
    CEF_TET_RELEASED = 0,
    CEF_TET_PRESSED = 1,
    CEF_TET_MOVED = 2,
    CEF_TET_CANCELLED = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n The device type that caused the event.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_pointer_type_t {
    CEF_POINTER_TYPE_TOUCH = 0,
    CEF_POINTER_TYPE_MOUSE = 1,
    CEF_POINTER_TYPE_PEN = 2,
    CEF_POINTER_TYPE_ERASER = 3,
    CEF_POINTER_TYPE_UNKNOWN = 4,
}
#[doc = "\n Structure representing touch event information.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_touch_event_t {
    #[doc = "\n Id of a touch point. Must be unique per touch, can be any number except\n -1. Note that a maximum of 16 concurrent touches will be tracked; touches\n beyond that will be ignored.\n"]
    pub id: ::std::os::raw::c_int,
    #[doc = "\n X coordinate relative to the left side of the view.\n"]
    pub x: f32,
    #[doc = "\n Y coordinate relative to the top side of the view.\n"]
    pub y: f32,
    #[doc = "\n X radius in pixels. Set to 0 if not applicable.\n"]
    pub radius_x: f32,
    #[doc = "\n Y radius in pixels. Set to 0 if not applicable.\n"]
    pub radius_y: f32,
    #[doc = "\n Rotation angle in radians. Set to 0 if not applicable.\n"]
    pub rotation_angle: f32,
    #[doc = "\n The normalized pressure of the pointer input in the range of [0,1].\n Set to 0 if not applicable.\n"]
    pub pressure: f32,
    #[doc = "\n The state of the touch point. Touches begin with one CEF_TET_PRESSED event\n followed by zero or more CEF_TET_MOVED events and finally one\n CEF_TET_RELEASED or CEF_TET_CANCELLED event. Events not respecting this\n order will be ignored.\n"]
    pub type_: cef_touch_event_type_t,
    #[doc = "\n Bit flags describing any pressed modifier keys. See\n cef_event_flags_t for values.\n"]
    pub modifiers: u32,
    #[doc = "\n The device type that caused the event.\n"]
    pub pointer_type: cef_pointer_type_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_touch_event_t"][::std::mem::size_of::<_cef_touch_event_t>() - 40usize];
    ["Alignment of _cef_touch_event_t"][::std::mem::align_of::<_cef_touch_event_t>() - 4usize];
    ["Offset of field: _cef_touch_event_t::id"]
        [::std::mem::offset_of!(_cef_touch_event_t, id) - 0usize];
    ["Offset of field: _cef_touch_event_t::x"]
        [::std::mem::offset_of!(_cef_touch_event_t, x) - 4usize];
    ["Offset of field: _cef_touch_event_t::y"]
        [::std::mem::offset_of!(_cef_touch_event_t, y) - 8usize];
    ["Offset of field: _cef_touch_event_t::radius_x"]
        [::std::mem::offset_of!(_cef_touch_event_t, radius_x) - 12usize];
    ["Offset of field: _cef_touch_event_t::radius_y"]
        [::std::mem::offset_of!(_cef_touch_event_t, radius_y) - 16usize];
    ["Offset of field: _cef_touch_event_t::rotation_angle"]
        [::std::mem::offset_of!(_cef_touch_event_t, rotation_angle) - 20usize];
    ["Offset of field: _cef_touch_event_t::pressure"]
        [::std::mem::offset_of!(_cef_touch_event_t, pressure) - 24usize];
    ["Offset of field: _cef_touch_event_t::type_"]
        [::std::mem::offset_of!(_cef_touch_event_t, type_) - 28usize];
    ["Offset of field: _cef_touch_event_t::modifiers"]
        [::std::mem::offset_of!(_cef_touch_event_t, modifiers) - 32usize];
    ["Offset of field: _cef_touch_event_t::pointer_type"]
        [::std::mem::offset_of!(_cef_touch_event_t, pointer_type) - 36usize];
};
#[doc = "\n Structure representing touch event information.\n"]
pub type cef_touch_event_t = _cef_touch_event_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Paint element types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_paint_element_type_t {
    PET_VIEW = 0,
    PET_POPUP = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported event bit flags.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_event_flags_t {
    EVENTFLAG_NONE = 0,
    EVENTFLAG_CAPS_LOCK_ON = 1,
    EVENTFLAG_SHIFT_DOWN = 2,
    EVENTFLAG_CONTROL_DOWN = 4,
    EVENTFLAG_ALT_DOWN = 8,
    EVENTFLAG_LEFT_MOUSE_BUTTON = 16,
    EVENTFLAG_MIDDLE_MOUSE_BUTTON = 32,
    EVENTFLAG_RIGHT_MOUSE_BUTTON = 64,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_COMMAND_DOWN = 128,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_NUM_LOCK_ON = 256,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_IS_KEY_PAD = 512,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_IS_LEFT = 1024,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_IS_RIGHT = 2048,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_ALTGR_DOWN = 4096,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_IS_REPEAT = 8192,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_PRECISION_SCROLLING_DELTA = 16384,
    #[doc = " Mac OS-X command key."]
    EVENTFLAG_SCROLL_BY_PAGE = 32768,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported menu item types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_menu_item_type_t {
    MENUITEMTYPE_NONE = 0,
    MENUITEMTYPE_COMMAND = 1,
    MENUITEMTYPE_CHECK = 2,
    MENUITEMTYPE_RADIO = 3,
    MENUITEMTYPE_SEPARATOR = 4,
    MENUITEMTYPE_SUBMENU = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported context menu type flags.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_context_menu_type_flags_t {
    #[doc = "\n No node is selected.\n"]
    CM_TYPEFLAG_NONE = 0,
    #[doc = "\n The top page is selected.\n"]
    CM_TYPEFLAG_PAGE = 1,
    #[doc = "\n A subframe page is selected.\n"]
    CM_TYPEFLAG_FRAME = 2,
    #[doc = "\n A link is selected.\n"]
    CM_TYPEFLAG_LINK = 4,
    #[doc = "\n A media node is selected.\n"]
    CM_TYPEFLAG_MEDIA = 8,
    #[doc = "\n There is a textual or mixed selection that is selected.\n"]
    CM_TYPEFLAG_SELECTION = 16,
    #[doc = "\n An editable element is selected.\n"]
    CM_TYPEFLAG_EDITABLE = 32,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported context menu media types. These constants match their equivalents\n in Chromium's ContextMenuDataMediaType and should not be renumbered.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_context_menu_media_type_t {
    #[doc = "\n No special node is in context.\n"]
    CM_MEDIATYPE_NONE = 0,
    #[doc = "\n An image node is selected.\n"]
    CM_MEDIATYPE_IMAGE = 1,
    #[doc = "\n A video node is selected.\n"]
    CM_MEDIATYPE_VIDEO = 2,
    #[doc = "\n An audio node is selected.\n"]
    CM_MEDIATYPE_AUDIO = 3,
    #[doc = "\n An canvas node is selected.\n"]
    CM_MEDIATYPE_CANVAS = 4,
    #[doc = "\n A file node is selected.\n"]
    CM_MEDIATYPE_FILE = 5,
    #[doc = "\n A plugin node is selected.\n"]
    CM_MEDIATYPE_PLUGIN = 6,
    #[doc = "\n A plugin node is selected.\n"]
    CM_MEDIATYPE_NUM_VALUES = 7,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported context menu media state bit flags. These constants match their\n equivalents in Chromium's ContextMenuData::MediaFlags and should not be\n renumbered.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_context_menu_media_state_flags_t {
    CM_MEDIAFLAG_NONE = 0,
    CM_MEDIAFLAG_IN_ERROR = 1,
    CM_MEDIAFLAG_PAUSED = 2,
    CM_MEDIAFLAG_MUTED = 4,
    CM_MEDIAFLAG_LOOP = 8,
    CM_MEDIAFLAG_CAN_SAVE = 16,
    CM_MEDIAFLAG_HAS_AUDIO = 32,
    CM_MEDIAFLAG_CAN_TOGGLE_CONTROLS = 64,
    CM_MEDIAFLAG_CONTROLS = 128,
    CM_MEDIAFLAG_CAN_PRINT = 256,
    CM_MEDIAFLAG_CAN_ROTATE = 512,
    CM_MEDIAFLAG_CAN_PICTURE_IN_PICTURE = 1024,
    CM_MEDIAFLAG_PICTURE_IN_PICTURE = 2048,
    CM_MEDIAFLAG_CAN_LOOP = 4096,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported context menu edit state bit flags. These constants match their\n equivalents in Chromium's ContextMenuDataEditFlags and should not be\n renumbered.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_context_menu_edit_state_flags_t {
    CM_EDITFLAG_NONE = 0,
    CM_EDITFLAG_CAN_UNDO = 1,
    CM_EDITFLAG_CAN_REDO = 2,
    CM_EDITFLAG_CAN_CUT = 4,
    CM_EDITFLAG_CAN_COPY = 8,
    CM_EDITFLAG_CAN_PASTE = 16,
    CM_EDITFLAG_CAN_DELETE = 32,
    CM_EDITFLAG_CAN_SELECT_ALL = 64,
    CM_EDITFLAG_CAN_TRANSLATE = 128,
    CM_EDITFLAG_CAN_EDIT_RICHLY = 256,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported quick menu state bit flags.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_quick_menu_edit_state_flags_t {
    QM_EDITFLAG_NONE = 0,
    QM_EDITFLAG_CAN_ELLIPSIS = 1,
    QM_EDITFLAG_CAN_CUT = 2,
    QM_EDITFLAG_CAN_COPY = 4,
    QM_EDITFLAG_CAN_PASTE = 8,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Key event types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_key_event_type_t {
    #[doc = "\n Notification that a key transitioned from \"up\" to \"down\".\n"]
    KEYEVENT_RAWKEYDOWN = 0,
    #[doc = "\n Notification that a key was pressed. This does not necessarily correspond\n to a character depending on the key and language. Use KEYEVENT_CHAR for\n character input.\n"]
    KEYEVENT_KEYDOWN = 1,
    #[doc = "\n Notification that a key was released.\n"]
    KEYEVENT_KEYUP = 2,
    #[doc = "\n Notification that a character was typed. Use this for text input. Key\n down events may generate 0, 1, or more than one character event depending\n on the key, locale, and operating system.\n"]
    KEYEVENT_CHAR = 3,
}
#[doc = "\n Structure representing keyboard event information.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_key_event_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n The type of keyboard event.\n"]
    pub type_: cef_key_event_type_t,
    #[doc = "\n Bit flags describing any pressed modifier keys. See\n cef_event_flags_t for values.\n"]
    pub modifiers: u32,
    #[doc = "\n The Windows key code for the key event. This value is used by the DOM\n specification. Sometimes it comes directly from the event (i.e. on\n Windows) and sometimes it's determined using a mapping function. See\n WebCore/platform/chromium/KeyboardCodes.h for the list of values.\n"]
    pub windows_key_code: ::std::os::raw::c_int,
    #[doc = "\n The actual key code genenerated by the platform.\n"]
    pub native_key_code: ::std::os::raw::c_int,
    #[doc = "\n Indicates whether the event is considered a \"system key\" event (see\n http://msdn.microsoft.com/en-us/library/ms646286(VS.85).aspx for details).\n This value will always be false on non-Windows platforms.\n"]
    pub is_system_key: ::std::os::raw::c_int,
    #[doc = "\n The character generated by the keystroke.\n"]
    pub character: char16_t,
    #[doc = "\n Same as |character| but unmodified by any concurrently-held modifiers\n (except shift). This is useful for working out shortcut keys.\n"]
    pub unmodified_character: char16_t,
    #[doc = "\n True if the focus is currently on an editable field on the page. This is\n useful for determining if standard key events should be intercepted.\n"]
    pub focus_on_editable_field: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_key_event_t"][::std::mem::size_of::<_cef_key_event_t>() - 40usize];
    ["Alignment of _cef_key_event_t"][::std::mem::align_of::<_cef_key_event_t>() - 8usize];
    ["Offset of field: _cef_key_event_t::size"]
        [::std::mem::offset_of!(_cef_key_event_t, size) - 0usize];
    ["Offset of field: _cef_key_event_t::type_"]
        [::std::mem::offset_of!(_cef_key_event_t, type_) - 8usize];
    ["Offset of field: _cef_key_event_t::modifiers"]
        [::std::mem::offset_of!(_cef_key_event_t, modifiers) - 12usize];
    ["Offset of field: _cef_key_event_t::windows_key_code"]
        [::std::mem::offset_of!(_cef_key_event_t, windows_key_code) - 16usize];
    ["Offset of field: _cef_key_event_t::native_key_code"]
        [::std::mem::offset_of!(_cef_key_event_t, native_key_code) - 20usize];
    ["Offset of field: _cef_key_event_t::is_system_key"]
        [::std::mem::offset_of!(_cef_key_event_t, is_system_key) - 24usize];
    ["Offset of field: _cef_key_event_t::character"]
        [::std::mem::offset_of!(_cef_key_event_t, character) - 28usize];
    ["Offset of field: _cef_key_event_t::unmodified_character"]
        [::std::mem::offset_of!(_cef_key_event_t, unmodified_character) - 30usize];
    ["Offset of field: _cef_key_event_t::focus_on_editable_field"]
        [::std::mem::offset_of!(_cef_key_event_t, focus_on_editable_field) - 32usize];
};
#[doc = "\n Structure representing keyboard event information.\n"]
pub type cef_key_event_t = _cef_key_event_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Focus sources.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_focus_source_t {
    #[doc = "\n The source is explicit navigation via the API (LoadURL(), etc).\n"]
    FOCUS_SOURCE_NAVIGATION = 0,
    #[doc = "\n The source is a system-generated focus event.\n"]
    FOCUS_SOURCE_SYSTEM = 1,
    #[doc = "\n The source is a system-generated focus event.\n"]
    FOCUS_SOURCE_NUM_VALUES = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Navigation types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_navigation_type_t {
    NAVIGATION_LINK_CLICKED = 0,
    NAVIGATION_FORM_SUBMITTED = 1,
    NAVIGATION_BACK_FORWARD = 2,
    NAVIGATION_RELOAD = 3,
    NAVIGATION_FORM_RESUBMITTED = 4,
    NAVIGATION_OTHER = 5,
    NAVIGATION_NUM_VALUES = 6,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported XML encoding types. The parser supports ASCII, ISO-8859-1, and\n UTF16 (LE and BE) by default. All other types must be translated to UTF8\n before being passed to the parser. If a BOM is detected and the correct\n decoder is available then that decoder will be used automatically.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_xml_encoding_type_t {
    XML_ENCODING_NONE = 0,
    XML_ENCODING_UTF8 = 1,
    XML_ENCODING_UTF16LE = 2,
    XML_ENCODING_UTF16BE = 3,
    XML_ENCODING_ASCII = 4,
    XML_ENCODING_NUM_VALUES = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n XML node types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_xml_node_type_t {
    XML_NODE_UNSUPPORTED = 0,
    XML_NODE_PROCESSING_INSTRUCTION = 1,
    XML_NODE_DOCUMENT_TYPE = 2,
    XML_NODE_ELEMENT_START = 3,
    XML_NODE_ELEMENT_END = 4,
    XML_NODE_ATTRIBUTE = 5,
    XML_NODE_TEXT = 6,
    XML_NODE_CDATA = 7,
    XML_NODE_ENTITY_REFERENCE = 8,
    XML_NODE_WHITESPACE = 9,
    XML_NODE_COMMENT = 10,
    XML_NODE_NUM_VALUES = 11,
}
#[doc = "\n Popup window features.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_popup_features_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    pub x: ::std::os::raw::c_int,
    pub xSet: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub ySet: ::std::os::raw::c_int,
    pub width: ::std::os::raw::c_int,
    pub widthSet: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    pub heightSet: ::std::os::raw::c_int,
    #[doc = "\n True (1) if browser interface elements should be hidden.\n"]
    pub isPopup: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_popup_features_t"][::std::mem::size_of::<_cef_popup_features_t>() - 48usize];
    ["Alignment of _cef_popup_features_t"]
        [::std::mem::align_of::<_cef_popup_features_t>() - 8usize];
    ["Offset of field: _cef_popup_features_t::size"]
        [::std::mem::offset_of!(_cef_popup_features_t, size) - 0usize];
    ["Offset of field: _cef_popup_features_t::x"]
        [::std::mem::offset_of!(_cef_popup_features_t, x) - 8usize];
    ["Offset of field: _cef_popup_features_t::xSet"]
        [::std::mem::offset_of!(_cef_popup_features_t, xSet) - 12usize];
    ["Offset of field: _cef_popup_features_t::y"]
        [::std::mem::offset_of!(_cef_popup_features_t, y) - 16usize];
    ["Offset of field: _cef_popup_features_t::ySet"]
        [::std::mem::offset_of!(_cef_popup_features_t, ySet) - 20usize];
    ["Offset of field: _cef_popup_features_t::width"]
        [::std::mem::offset_of!(_cef_popup_features_t, width) - 24usize];
    ["Offset of field: _cef_popup_features_t::widthSet"]
        [::std::mem::offset_of!(_cef_popup_features_t, widthSet) - 28usize];
    ["Offset of field: _cef_popup_features_t::height"]
        [::std::mem::offset_of!(_cef_popup_features_t, height) - 32usize];
    ["Offset of field: _cef_popup_features_t::heightSet"]
        [::std::mem::offset_of!(_cef_popup_features_t, heightSet) - 36usize];
    ["Offset of field: _cef_popup_features_t::isPopup"]
        [::std::mem::offset_of!(_cef_popup_features_t, isPopup) - 40usize];
};
#[doc = "\n Popup window features.\n"]
pub type cef_popup_features_t = _cef_popup_features_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n DOM document types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_dom_document_type_t {
    DOM_DOCUMENT_TYPE_UNKNOWN = 0,
    DOM_DOCUMENT_TYPE_HTML = 1,
    DOM_DOCUMENT_TYPE_XHTML = 2,
    DOM_DOCUMENT_TYPE_PLUGIN = 3,
    DOM_DOCUMENT_TYPE_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n DOM event category flags.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_dom_event_category_t {
    DOM_EVENT_CATEGORY_UNKNOWN = 0,
    DOM_EVENT_CATEGORY_UI = 1,
    DOM_EVENT_CATEGORY_MOUSE = 2,
    DOM_EVENT_CATEGORY_MUTATION = 4,
    DOM_EVENT_CATEGORY_KEYBOARD = 8,
    DOM_EVENT_CATEGORY_TEXT = 16,
    DOM_EVENT_CATEGORY_COMPOSITION = 32,
    DOM_EVENT_CATEGORY_DRAG = 64,
    DOM_EVENT_CATEGORY_CLIPBOARD = 128,
    DOM_EVENT_CATEGORY_MESSAGE = 256,
    DOM_EVENT_CATEGORY_WHEEL = 512,
    DOM_EVENT_CATEGORY_BEFORE_TEXT_INSERTED = 1024,
    DOM_EVENT_CATEGORY_OVERFLOW = 2048,
    DOM_EVENT_CATEGORY_PAGE_TRANSITION = 4096,
    DOM_EVENT_CATEGORY_POPSTATE = 8192,
    DOM_EVENT_CATEGORY_PROGRESS = 16384,
    DOM_EVENT_CATEGORY_XMLHTTPREQUEST_PROGRESS = 32768,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n DOM event processing phases.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_dom_event_phase_t {
    DOM_EVENT_PHASE_UNKNOWN = 0,
    DOM_EVENT_PHASE_CAPTURING = 1,
    DOM_EVENT_PHASE_AT_TARGET = 2,
    DOM_EVENT_PHASE_BUBBLING = 3,
    DOM_EVENT_PHASE_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n DOM node types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_dom_node_type_t {
    DOM_NODE_TYPE_UNSUPPORTED = 0,
    DOM_NODE_TYPE_ELEMENT = 1,
    DOM_NODE_TYPE_ATTRIBUTE = 2,
    DOM_NODE_TYPE_TEXT = 3,
    DOM_NODE_TYPE_CDATA_SECTION = 4,
    DOM_NODE_TYPE_PROCESSING_INSTRUCTIONS = 5,
    DOM_NODE_TYPE_COMMENT = 6,
    DOM_NODE_TYPE_DOCUMENT = 7,
    DOM_NODE_TYPE_DOCUMENT_TYPE = 8,
    DOM_NODE_TYPE_DOCUMENT_FRAGMENT = 9,
    DOM_NODE_TYPE_NUM_VALUES = 10,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n DOM form control types. Should be kept in sync with Chromium's\n blink::mojom::FormControlType type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_dom_form_control_type_t {
    DOM_FORM_CONTROL_TYPE_UNSUPPORTED = 0,
    DOM_FORM_CONTROL_TYPE_BUTTON_BUTTON = 1,
    DOM_FORM_CONTROL_TYPE_BUTTON_SUBMIT = 2,
    DOM_FORM_CONTROL_TYPE_BUTTON_RESET = 3,
    DOM_FORM_CONTROL_TYPE_BUTTON_POPOVER = 4,
    DOM_FORM_CONTROL_TYPE_FIELDSET = 5,
    DOM_FORM_CONTROL_TYPE_INPUT_BUTTON = 6,
    DOM_FORM_CONTROL_TYPE_INPUT_CHECKBOX = 7,
    DOM_FORM_CONTROL_TYPE_INPUT_COLOR = 8,
    DOM_FORM_CONTROL_TYPE_INPUT_DATE = 9,
    DOM_FORM_CONTROL_TYPE_INPUT_DATETIME_LOCAL = 10,
    DOM_FORM_CONTROL_TYPE_INPUT_EMAIL = 11,
    DOM_FORM_CONTROL_TYPE_INPUT_FILE = 12,
    DOM_FORM_CONTROL_TYPE_INPUT_HIDDEN = 13,
    DOM_FORM_CONTROL_TYPE_INPUT_IMAGE = 14,
    DOM_FORM_CONTROL_TYPE_INPUT_MONTH = 15,
    DOM_FORM_CONTROL_TYPE_INPUT_NUMBER = 16,
    DOM_FORM_CONTROL_TYPE_INPUT_PASSWORD = 17,
    DOM_FORM_CONTROL_TYPE_INPUT_RADIO = 18,
    DOM_FORM_CONTROL_TYPE_INPUT_RANGE = 19,
    DOM_FORM_CONTROL_TYPE_INPUT_RESET = 20,
    DOM_FORM_CONTROL_TYPE_INPUT_SEARCH = 21,
    DOM_FORM_CONTROL_TYPE_INPUT_SUBMIT = 22,
    DOM_FORM_CONTROL_TYPE_INPUT_TELEPHONE = 23,
    DOM_FORM_CONTROL_TYPE_INPUT_TEXT = 24,
    DOM_FORM_CONTROL_TYPE_INPUT_TIME = 25,
    DOM_FORM_CONTROL_TYPE_INPUT_URL = 26,
    DOM_FORM_CONTROL_TYPE_INPUT_WEEK = 27,
    DOM_FORM_CONTROL_TYPE_OUTPUT = 28,
    DOM_FORM_CONTROL_TYPE_SELECT_ONE = 29,
    DOM_FORM_CONTROL_TYPE_SELECT_MULTIPLE = 30,
    DOM_FORM_CONTROL_TYPE_TEXT_AREA = 31,
    DOM_FORM_CONTROL_TYPE_NUM_VALUES = 32,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported file dialog modes.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_file_dialog_mode_t {
    #[doc = "\n Requires that the file exists before allowing the user to pick it.\n"]
    FILE_DIALOG_OPEN = 0,
    #[doc = "\n Like Open, but allows picking multiple files to open.\n"]
    FILE_DIALOG_OPEN_MULTIPLE = 1,
    #[doc = "\n Like Open, but selects a folder to open.\n"]
    FILE_DIALOG_OPEN_FOLDER = 2,
    #[doc = "\n Allows picking a nonexistent file, and prompts to overwrite if the file\n already exists.\n"]
    FILE_DIALOG_SAVE = 3,
    #[doc = "\n Allows picking a nonexistent file, and prompts to overwrite if the file\n already exists.\n"]
    FILE_DIALOG_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Print job color mode values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_color_model_t {
    COLOR_MODEL_UNKNOWN = 0,
    COLOR_MODEL_GRAY = 1,
    COLOR_MODEL_COLOR = 2,
    COLOR_MODEL_CMYK = 3,
    COLOR_MODEL_CMY = 4,
    COLOR_MODEL_KCMY = 5,
    COLOR_MODEL_CMY_K = 6,
    COLOR_MODEL_BLACK = 7,
    COLOR_MODEL_GRAYSCALE = 8,
    COLOR_MODEL_RGB = 9,
    COLOR_MODEL_RGB16 = 10,
    COLOR_MODEL_RGBA = 11,
    COLOR_MODEL_COLORMODE_COLOR = 12,
    COLOR_MODEL_COLORMODE_MONOCHROME = 13,
    COLOR_MODEL_HP_COLOR_COLOR = 14,
    COLOR_MODEL_HP_COLOR_BLACK = 15,
    COLOR_MODEL_PRINTOUTMODE_NORMAL = 16,
    COLOR_MODEL_PRINTOUTMODE_NORMAL_GRAY = 17,
    COLOR_MODEL_PROCESSCOLORMODEL_CMYK = 18,
    COLOR_MODEL_PROCESSCOLORMODEL_GREYSCALE = 19,
    COLOR_MODEL_PROCESSCOLORMODEL_RGB = 20,
    COLOR_MODEL_NUM_VALUES = 21,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Print job duplex mode values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_duplex_mode_t {
    DUPLEX_MODE_UNKNOWN = -1,
    DUPLEX_MODE_SIMPLEX = 0,
    DUPLEX_MODE_LONG_EDGE = 1,
    DUPLEX_MODE_SHORT_EDGE = 2,
    DUPLEX_MODE_NUM_VALUES = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Cursor type values.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_cursor_type_t {
    CT_POINTER = 0,
    CT_CROSS = 1,
    CT_HAND = 2,
    CT_IBEAM = 3,
    CT_WAIT = 4,
    CT_HELP = 5,
    CT_EASTRESIZE = 6,
    CT_NORTHRESIZE = 7,
    CT_NORTHEASTRESIZE = 8,
    CT_NORTHWESTRESIZE = 9,
    CT_SOUTHRESIZE = 10,
    CT_SOUTHEASTRESIZE = 11,
    CT_SOUTHWESTRESIZE = 12,
    CT_WESTRESIZE = 13,
    CT_NORTHSOUTHRESIZE = 14,
    CT_EASTWESTRESIZE = 15,
    CT_NORTHEASTSOUTHWESTRESIZE = 16,
    CT_NORTHWESTSOUTHEASTRESIZE = 17,
    CT_COLUMNRESIZE = 18,
    CT_ROWRESIZE = 19,
    CT_MIDDLEPANNING = 20,
    CT_EASTPANNING = 21,
    CT_NORTHPANNING = 22,
    CT_NORTHEASTPANNING = 23,
    CT_NORTHWESTPANNING = 24,
    CT_SOUTHPANNING = 25,
    CT_SOUTHEASTPANNING = 26,
    CT_SOUTHWESTPANNING = 27,
    CT_WESTPANNING = 28,
    CT_MOVE = 29,
    CT_VERTICALTEXT = 30,
    CT_CELL = 31,
    CT_CONTEXTMENU = 32,
    CT_ALIAS = 33,
    CT_PROGRESS = 34,
    CT_NODROP = 35,
    CT_COPY = 36,
    CT_NONE = 37,
    CT_NOTALLOWED = 38,
    CT_ZOOMIN = 39,
    CT_ZOOMOUT = 40,
    CT_GRAB = 41,
    CT_GRABBING = 42,
    CT_MIDDLE_PANNING_VERTICAL = 43,
    CT_MIDDLE_PANNING_HORIZONTAL = 44,
    CT_CUSTOM = 45,
    CT_DND_NONE = 46,
    CT_DND_MOVE = 47,
    CT_DND_COPY = 48,
    CT_DND_LINK = 49,
    CT_NUM_VALUES = 50,
}
#[doc = "\n Structure representing cursor information. |buffer| will be\n |size.width|*|size.height|*4 bytes in size and represents a BGRA image with\n an upper-left origin.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_cursor_info_t {
    pub hotspot: cef_point_t,
    pub image_scale_factor: f32,
    pub buffer: *mut ::std::os::raw::c_void,
    pub size: cef_size_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_cursor_info_t"][::std::mem::size_of::<_cef_cursor_info_t>() - 32usize];
    ["Alignment of _cef_cursor_info_t"][::std::mem::align_of::<_cef_cursor_info_t>() - 8usize];
    ["Offset of field: _cef_cursor_info_t::hotspot"]
        [::std::mem::offset_of!(_cef_cursor_info_t, hotspot) - 0usize];
    ["Offset of field: _cef_cursor_info_t::image_scale_factor"]
        [::std::mem::offset_of!(_cef_cursor_info_t, image_scale_factor) - 8usize];
    ["Offset of field: _cef_cursor_info_t::buffer"]
        [::std::mem::offset_of!(_cef_cursor_info_t, buffer) - 16usize];
    ["Offset of field: _cef_cursor_info_t::size"]
        [::std::mem::offset_of!(_cef_cursor_info_t, size) - 24usize];
};
#[doc = "\n Structure representing cursor information. |buffer| will be\n |size.width|*|size.height|*4 bytes in size and represents a BGRA image with\n an upper-left origin.\n"]
pub type cef_cursor_info_t = _cef_cursor_info_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n URI unescape rules passed to CefURIDecode().\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_uri_unescape_rule_t {
    #[doc = "\n Don't unescape anything at all.\n"]
    UU_NONE = 0,
    #[doc = "\n Don't unescape anything special, but all normal unescaping will happen.\n This is a placeholder and can't be combined with other flags (since it's\n just the absence of them). All other unescape rules imply \"normal\" in\n addition to their special meaning. Things like escaped letters, digits,\n and most symbols will get unescaped with this mode.\n"]
    UU_NORMAL = 1,
    #[doc = "\n Convert %20 to spaces. In some places where we're showing URLs, we may\n want this. In places where the URL may be copied and pasted out, then\n you wouldn't want this since it might not be interpreted in one piece\n by other applications.\n"]
    UU_SPACES = 2,
    #[doc = "\n Unescapes '/' and '\\\\'. If these characters were unescaped, the resulting\n URL won't be the same as the source one. Moreover, they are dangerous to\n unescape in strings that will be used as file paths or names. This value\n should only be used when slashes don't have special meaning, like data\n URLs.\n"]
    UU_PATH_SEPARATORS = 4,
    #[doc = "\n Unescapes various characters that will change the meaning of URLs,\n including '%', '+', '&', '#'. Does not unescape path separators.\n If these characters were unescaped, the resulting URL won't be the same\n as the source one. This flag is used when generating final output like\n filenames for URLs where we won't be interpreting as a URL and want to do\n as much unescaping as possible.\n"]
    UU_URL_SPECIAL_CHARS_EXCEPT_PATH_SEPARATORS = 8,
    #[doc = "\n URL queries use \"+\" for space. This flag controls that replacement.\n"]
    UU_REPLACE_PLUS_WITH_SPACE = 16,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Options that can be passed to CefParseJSON.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_json_parser_options_t {
    #[doc = "\n Parses the input strictly according to RFC 4627. See comments in\n Chromium's base/json/json_reader.h file for known limitations/\n deviations from the RFC.\n"]
    JSON_PARSER_RFC = 0,
    #[doc = "\n Allows commas to exist after the last element in structures.\n"]
    JSON_PARSER_ALLOW_TRAILING_COMMAS = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Options that can be passed to CefWriteJSON.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_json_writer_options_t {
    #[doc = "\n Default behavior.\n"]
    JSON_WRITER_DEFAULT = 0,
    #[doc = "\n This option instructs the writer that if a Binary value is encountered,\n the value (and key if within a dictionary) will be omitted from the\n output, and success will be returned. Otherwise, if a binary value is\n encountered, failure will be returned.\n"]
    JSON_WRITER_OMIT_BINARY_VALUES = 1,
    #[doc = "\n This option instructs the writer to write doubles that have no fractional\n part as a normal integer (i.e., without using exponential notation\n or appending a '.0') as long as the value is within the range of a\n 64-bit int.\n"]
    JSON_WRITER_OMIT_DOUBLE_TYPE_PRESERVATION = 2,
    #[doc = "\n Return a slightly nicer formatted json string (pads with whitespace to\n help with readability).\n"]
    JSON_WRITER_PRETTY_PRINT = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Margin type for PDF printing.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_pdf_print_margin_type_t {
    #[doc = "\n Default margins of 1cm (~0.4 inches).\n"]
    PDF_PRINT_MARGIN_DEFAULT = 0,
    #[doc = "\n No margins.\n"]
    PDF_PRINT_MARGIN_NONE = 1,
    #[doc = "\n Custom margins using the |margin_*| values from cef_pdf_print_settings_t.\n"]
    PDF_PRINT_MARGIN_CUSTOM = 2,
}
#[doc = "\n Structure representing PDF print settings. These values match the parameters\n supported by the DevTools Page.printToPDF function. See\n https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-printToPDF\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_pdf_print_settings_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Set to true (1) for landscape mode or false (0) for portrait mode.\n"]
    pub landscape: ::std::os::raw::c_int,
    #[doc = "\n Set to true (1) to print background graphics.\n"]
    pub print_background: ::std::os::raw::c_int,
    #[doc = "\n The percentage to scale the PDF by before printing (e.g. .5 is 50%).\n If this value is less than or equal to zero the default value of 1.0\n will be used.\n"]
    pub scale: f64,
    #[doc = "\n Output paper size in inches. If either of these values is less than or\n equal to zero then the default paper size (letter, 8.5 x 11 inches) will\n be used.\n"]
    pub paper_width: f64,
    pub paper_height: f64,
    #[doc = "\n Set to true (1) to prefer page size as defined by css. Defaults to false\n (0), in which case the content will be scaled to fit the paper size.\n"]
    pub prefer_css_page_size: ::std::os::raw::c_int,
    #[doc = "\n Margin type.\n"]
    pub margin_type: cef_pdf_print_margin_type_t,
    #[doc = "\n Margins in inches. Only used if |margin_type| is set to\n PDF_PRINT_MARGIN_CUSTOM.\n"]
    pub margin_top: f64,
    pub margin_right: f64,
    pub margin_bottom: f64,
    pub margin_left: f64,
    #[doc = "\n Paper ranges to print, one based, e.g., '1-5, 8, 11-13'. Pages are printed\n in the document order, not in the order specified, and no more than once.\n Defaults to empty string, which implies the entire document is printed.\n The page numbers are quietly capped to actual page count of the document,\n and ranges beyond the end of the document are ignored. If this results in\n no pages to print, an error is reported. It is an error to specify a range\n with start greater than end.\n"]
    pub page_ranges: cef_string_t,
    #[doc = "\n Set to true (1) to display the header and/or footer. Modify\n |header_template| and/or |footer_template| to customize the display.\n"]
    pub display_header_footer: ::std::os::raw::c_int,
    #[doc = "\n HTML template for the print header. Only displayed if\n |display_header_footer| is true (1). Should be valid HTML markup with\n the following classes used to inject printing values into them:\n\n - date: formatted print date\n - title: document title\n - url: document location\n - pageNumber: current page number\n - totalPages: total pages in the document\n\n For example, \"<span class=title></span>\" would generate a span containing\n the title.\n"]
    pub header_template: cef_string_t,
    #[doc = "\n HTML template for the print footer. Only displayed if\n |display_header_footer| is true (1). Uses the same format as\n |header_template|.\n"]
    pub footer_template: cef_string_t,
    #[doc = "\n Set to true (1) to generate tagged (accessible) PDF.\n"]
    pub generate_tagged_pdf: ::std::os::raw::c_int,
    #[doc = "\n Set to true (1) to generate a document outline.\n"]
    pub generate_document_outline: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_pdf_print_settings_t"]
        [::std::mem::size_of::<_cef_pdf_print_settings_t>() - 168usize];
    ["Alignment of _cef_pdf_print_settings_t"]
        [::std::mem::align_of::<_cef_pdf_print_settings_t>() - 8usize];
    ["Offset of field: _cef_pdf_print_settings_t::size"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, size) - 0usize];
    ["Offset of field: _cef_pdf_print_settings_t::landscape"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, landscape) - 8usize];
    ["Offset of field: _cef_pdf_print_settings_t::print_background"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, print_background) - 12usize];
    ["Offset of field: _cef_pdf_print_settings_t::scale"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, scale) - 16usize];
    ["Offset of field: _cef_pdf_print_settings_t::paper_width"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, paper_width) - 24usize];
    ["Offset of field: _cef_pdf_print_settings_t::paper_height"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, paper_height) - 32usize];
    ["Offset of field: _cef_pdf_print_settings_t::prefer_css_page_size"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, prefer_css_page_size) - 40usize];
    ["Offset of field: _cef_pdf_print_settings_t::margin_type"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, margin_type) - 44usize];
    ["Offset of field: _cef_pdf_print_settings_t::margin_top"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, margin_top) - 48usize];
    ["Offset of field: _cef_pdf_print_settings_t::margin_right"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, margin_right) - 56usize];
    ["Offset of field: _cef_pdf_print_settings_t::margin_bottom"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, margin_bottom) - 64usize];
    ["Offset of field: _cef_pdf_print_settings_t::margin_left"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, margin_left) - 72usize];
    ["Offset of field: _cef_pdf_print_settings_t::page_ranges"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, page_ranges) - 80usize];
    ["Offset of field: _cef_pdf_print_settings_t::display_header_footer"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, display_header_footer) - 104usize];
    ["Offset of field: _cef_pdf_print_settings_t::header_template"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, header_template) - 112usize];
    ["Offset of field: _cef_pdf_print_settings_t::footer_template"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, footer_template) - 136usize];
    ["Offset of field: _cef_pdf_print_settings_t::generate_tagged_pdf"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, generate_tagged_pdf) - 160usize];
    ["Offset of field: _cef_pdf_print_settings_t::generate_document_outline"]
        [::std::mem::offset_of!(_cef_pdf_print_settings_t, generate_document_outline) - 164usize];
};
#[doc = "\n Structure representing PDF print settings. These values match the parameters\n supported by the DevTools Page.printToPDF function. See\n https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-printToPDF\n"]
pub type cef_pdf_print_settings_t = _cef_pdf_print_settings_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported UI scale factors for the platform. SCALE_FACTOR_NONE is used for\n density independent resources such as string, html/js files or an image that\n can be used for any scale factors (such as wallpapers).\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_scale_factor_t {
    SCALE_FACTOR_NONE = 0,
    SCALE_FACTOR_100P = 1,
    SCALE_FACTOR_125P = 2,
    SCALE_FACTOR_133P = 3,
    SCALE_FACTOR_140P = 4,
    SCALE_FACTOR_150P = 5,
    SCALE_FACTOR_180P = 6,
    SCALE_FACTOR_200P = 7,
    SCALE_FACTOR_250P = 8,
    SCALE_FACTOR_300P = 9,
    SCALE_FACTOR_NUM_VALUES = 10,
}
impl cef_referrer_policy_t {
    pub const REFERRER_POLICY_DEFAULT: cef_referrer_policy_t =
        cef_referrer_policy_t::REFERRER_POLICY_CLEAR_REFERRER_ON_TRANSITION_FROM_SECURE_TO_INSECURE;
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Policy for how the Referrer HTTP header value will be sent during\n navigation. If the `--no-referrers` command-line flag is specified then the\n policy value will be ignored and the Referrer value will never be sent. Must\n be kept synchronized with net::URLRequest::ReferrerPolicy from Chromium.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_referrer_policy_t {
    #[doc = "\n Clear the referrer header if the header value is HTTPS but the request\n destination is HTTP. This is the default behavior.\n"]
    REFERRER_POLICY_CLEAR_REFERRER_ON_TRANSITION_FROM_SECURE_TO_INSECURE = 0,
    #[doc = "\n A slight variant on CLEAR_REFERRER_ON_TRANSITION_FROM_SECURE_TO_INSECURE:\n If the request destination is HTTP, an HTTPS referrer will be cleared. If\n the request's destination is cross-origin with the referrer (but does not\n downgrade), the referrer's granularity will be stripped down to an origin\n rather than a full URL. Same-origin requests will send the full referrer.\n"]
    REFERRER_POLICY_REDUCE_REFERRER_GRANULARITY_ON_TRANSITION_CROSS_ORIGIN = 1,
    #[doc = "\n Strip the referrer down to an origin when the origin of the referrer is\n different from the destination's origin.\n"]
    REFERRER_POLICY_ORIGIN_ONLY_ON_TRANSITION_CROSS_ORIGIN = 2,
    #[doc = "\n Never change the referrer.\n"]
    REFERRER_POLICY_NEVER_CLEAR_REFERRER = 3,
    #[doc = "\n Strip the referrer down to the origin regardless of the redirect location.\n"]
    REFERRER_POLICY_ORIGIN = 4,
    #[doc = "\n Clear the referrer when the request's referrer is cross-origin with the\n request's destination.\n"]
    REFERRER_POLICY_CLEAR_REFERRER_ON_TRANSITION_CROSS_ORIGIN = 5,
    #[doc = "\n Strip the referrer down to the origin, but clear it entirely if the\n referrer value is HTTPS and the destination is HTTP.\n"]
    REFERRER_POLICY_ORIGIN_CLEAR_ON_TRANSITION_FROM_SECURE_TO_INSECURE = 6,
    #[doc = "\n Always clear the referrer regardless of the request destination.\n"]
    REFERRER_POLICY_NO_REFERRER = 7,
    #[doc = " Always the last value in this enumeration."]
    REFERRER_POLICY_NUM_VALUES = 8,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Return values for CefResponseFilter::Filter().\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_response_filter_status_t {
    #[doc = "\n Some or all of the pre-filter data was read successfully but more data is\n needed in order to continue filtering (filtered output is pending).\n"]
    RESPONSE_FILTER_NEED_MORE_DATA = 0,
    #[doc = "\n Some or all of the pre-filter data was read successfully and all available\n filtered output has been written.\n"]
    RESPONSE_FILTER_DONE = 1,
    #[doc = "\n An error occurred during filtering.\n"]
    RESPONSE_FILTER_ERROR = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Describes how to interpret the alpha component of a pixel.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_alpha_type_t {
    #[doc = "\n No transparency. The alpha component is ignored.\n"]
    CEF_ALPHA_TYPE_OPAQUE = 0,
    #[doc = "\n Transparency with pre-multiplied alpha component.\n"]
    CEF_ALPHA_TYPE_PREMULTIPLIED = 1,
    #[doc = "\n Transparency with post-multiplied alpha component.\n"]
    CEF_ALPHA_TYPE_POSTMULTIPLIED = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Text style types. Should be kepy in sync with gfx::TextStyle.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_text_style_t {
    CEF_TEXT_STYLE_BOLD = 0,
    CEF_TEXT_STYLE_ITALIC = 1,
    CEF_TEXT_STYLE_STRIKE = 2,
    CEF_TEXT_STYLE_DIAGONAL_STRIKE = 3,
    CEF_TEXT_STYLE_UNDERLINE = 4,
    CEF_TEXT_STYLE_NUM_VALUES = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Specifies where along the axis the CefBoxLayout child views should be laid\n out. Should be kept in sync with Chromium's views::LayoutAlignment type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_axis_alignment_t {
    #[doc = " Child views will be left/top-aligned."]
    CEF_AXIS_ALIGNMENT_START = 0,
    #[doc = " Child views will be center-aligned."]
    CEF_AXIS_ALIGNMENT_CENTER = 1,
    #[doc = " Child views will be right/bottom-aligned."]
    CEF_AXIS_ALIGNMENT_END = 2,
    #[doc = " Child views will be stretched to fit."]
    CEF_AXIS_ALIGNMENT_STRETCH = 3,
    #[doc = " Child views will be stretched to fit."]
    CEF_AXIS_ALIGNMENT_NUM_VALUES = 4,
}
#[doc = "\n Settings used when initializing a CefBoxLayout.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_box_layout_settings_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n If true (1) the layout will be horizontal, otherwise the layout will be\n vertical.\n"]
    pub horizontal: ::std::os::raw::c_int,
    #[doc = "\n Adds additional horizontal space between the child view area and the host\n view border.\n"]
    pub inside_border_horizontal_spacing: ::std::os::raw::c_int,
    #[doc = "\n Adds additional vertical space between the child view area and the host\n view border.\n"]
    pub inside_border_vertical_spacing: ::std::os::raw::c_int,
    #[doc = "\n Adds additional space around the child view area.\n"]
    pub inside_border_insets: cef_insets_t,
    #[doc = "\n Adds additional space between child views.\n"]
    pub between_child_spacing: ::std::os::raw::c_int,
    #[doc = "\n Specifies where along the main axis the child views should be laid out.\n"]
    pub main_axis_alignment: cef_axis_alignment_t,
    #[doc = "\n Specifies where along the cross axis the child views should be laid out.\n"]
    pub cross_axis_alignment: cef_axis_alignment_t,
    #[doc = "\n Minimum cross axis size.\n"]
    pub minimum_cross_axis_size: ::std::os::raw::c_int,
    #[doc = "\n Default flex for views when none is specified via CefBoxLayout methods.\n Using the preferred size as the basis, free space along the main axis is\n distributed to views in the ratio of their flex weights. Similarly, if the\n views will overflow the parent, space is subtracted in these ratios. A\n flex of 0 means this view is not resized. Flex values must not be\n negative.\n"]
    pub default_flex: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_box_layout_settings_t"]
        [::std::mem::size_of::<_cef_box_layout_settings_t>() - 56usize];
    ["Alignment of _cef_box_layout_settings_t"]
        [::std::mem::align_of::<_cef_box_layout_settings_t>() - 8usize];
    ["Offset of field: _cef_box_layout_settings_t::size"]
        [::std::mem::offset_of!(_cef_box_layout_settings_t, size) - 0usize];
    ["Offset of field: _cef_box_layout_settings_t::horizontal"]
        [::std::mem::offset_of!(_cef_box_layout_settings_t, horizontal) - 8usize];
    ["Offset of field: _cef_box_layout_settings_t::inside_border_horizontal_spacing"][::std::mem::offset_of!(
        _cef_box_layout_settings_t,
        inside_border_horizontal_spacing
    ) - 12usize];
    ["Offset of field: _cef_box_layout_settings_t::inside_border_vertical_spacing"][::std::mem::offset_of!(
        _cef_box_layout_settings_t,
        inside_border_vertical_spacing
    ) - 16usize];
    ["Offset of field: _cef_box_layout_settings_t::inside_border_insets"]
        [::std::mem::offset_of!(_cef_box_layout_settings_t, inside_border_insets) - 20usize];
    ["Offset of field: _cef_box_layout_settings_t::between_child_spacing"]
        [::std::mem::offset_of!(_cef_box_layout_settings_t, between_child_spacing) - 36usize];
    ["Offset of field: _cef_box_layout_settings_t::main_axis_alignment"]
        [::std::mem::offset_of!(_cef_box_layout_settings_t, main_axis_alignment) - 40usize];
    ["Offset of field: _cef_box_layout_settings_t::cross_axis_alignment"]
        [::std::mem::offset_of!(_cef_box_layout_settings_t, cross_axis_alignment) - 44usize];
    ["Offset of field: _cef_box_layout_settings_t::minimum_cross_axis_size"]
        [::std::mem::offset_of!(_cef_box_layout_settings_t, minimum_cross_axis_size) - 48usize];
    ["Offset of field: _cef_box_layout_settings_t::default_flex"]
        [::std::mem::offset_of!(_cef_box_layout_settings_t, default_flex) - 52usize];
};
#[doc = "\n Settings used when initializing a CefBoxLayout.\n"]
pub type cef_box_layout_settings_t = _cef_box_layout_settings_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Specifies the button display state.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_button_state_t {
    CEF_BUTTON_STATE_NORMAL = 0,
    CEF_BUTTON_STATE_HOVERED = 1,
    CEF_BUTTON_STATE_PRESSED = 2,
    CEF_BUTTON_STATE_DISABLED = 3,
    CEF_BUTTON_STATE_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Specifies the horizontal text alignment mode.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_horizontal_alignment_t {
    #[doc = "\n Align the text's left edge with that of its display area.\n"]
    CEF_HORIZONTAL_ALIGNMENT_LEFT = 0,
    #[doc = "\n Align the text's center with that of its display area.\n"]
    CEF_HORIZONTAL_ALIGNMENT_CENTER = 1,
    #[doc = "\n Align the text's right edge with that of its display area.\n"]
    CEF_HORIZONTAL_ALIGNMENT_RIGHT = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Specifies how a menu will be anchored for non-RTL languages. The opposite\n position will be used for RTL languages.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_menu_anchor_position_t {
    CEF_MENU_ANCHOR_TOPLEFT = 0,
    CEF_MENU_ANCHOR_TOPRIGHT = 1,
    CEF_MENU_ANCHOR_BOTTOMCENTER = 2,
    CEF_MENU_ANCHOR_NUM_VALUES = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Supported color types for menu items.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_menu_color_type_t {
    CEF_MENU_COLOR_TEXT = 0,
    CEF_MENU_COLOR_TEXT_HOVERED = 1,
    CEF_MENU_COLOR_TEXT_ACCELERATOR = 2,
    CEF_MENU_COLOR_TEXT_ACCELERATOR_HOVERED = 3,
    CEF_MENU_COLOR_BACKGROUND = 4,
    CEF_MENU_COLOR_BACKGROUND_HOVERED = 5,
    CEF_MENU_COLOR_NUM_VALUES = 6,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Supported SSL version values. See net/ssl/ssl_connection_status_flags.h\n for more information."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_ssl_version_t {
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_UNKNOWN = 0,
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_SSL2 = 1,
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_SSL3 = 2,
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_TLS1 = 3,
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_TLS1_1 = 4,
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_TLS1_2 = 5,
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_TLS1_3 = 6,
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_QUIC = 7,
    #[doc = " Unknown SSL version."]
    SSL_CONNECTION_VERSION_NUM_VALUES = 8,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Supported SSL content status flags. See content/public/common/ssl_status.h\n for more information."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_ssl_content_status_t {
    SSL_CONTENT_NORMAL_CONTENT = 0,
    SSL_CONTENT_DISPLAYED_INSECURE_CONTENT = 1,
    SSL_CONTENT_RAN_INSECURE_CONTENT = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Configuration options for registering a custom scheme.\n These values are used when calling AddCustomScheme."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_scheme_options_t {
    CEF_SCHEME_OPTION_NONE = 0,
    #[doc = " For non-standard scheme URLs only the \"scheme:\" component is parsed and\n canonicalized. The remainder of the URL will be passed to the handler as-\n is. For example, \"scheme:///some%20text\" will remain the same.\n Non-standard scheme URLs cannot be used as a target for form submission.\n"]
    CEF_SCHEME_OPTION_STANDARD = 1,
    #[doc = "\n If CEF_SCHEME_OPTION_LOCAL is set the scheme will be treated with the same\n security rules as those applied to \"file\" URLs. Normal pages cannot link\n to or access local URLs. Also, by default, local URLs can only perform\n XMLHttpRequest calls to the same URL (origin + path) that originated the\n request. To allow XMLHttpRequest calls from a local URL to other URLs with\n the same origin set the CefSettings.file_access_from_file_urls_allowed\n value to true (1). To allow XMLHttpRequest calls from a local URL to all\n origins set the CefSettings.universal_access_from_file_urls_allowed value\n to true (1).\n"]
    CEF_SCHEME_OPTION_LOCAL = 2,
    #[doc = "\n If CEF_SCHEME_OPTION_DISPLAY_ISOLATED is set the scheme can only be\n displayed from other content hosted with the same scheme. For example,\n pages in other origins cannot create iframes or hyperlinks to URLs with\n the scheme. For schemes that must be accessible from other schemes don't\n set this, set CEF_SCHEME_OPTION_CORS_ENABLED, and use CORS\n \"Access-Control-Allow-Origin\" headers to further restrict access.\n"]
    CEF_SCHEME_OPTION_DISPLAY_ISOLATED = 4,
    #[doc = "\n If CEF_SCHEME_OPTION_SECURE is set the scheme will be treated with the\n same security rules as those applied to \"https\" URLs. For example, loading\n this scheme from other secure schemes will not trigger mixed content\n warnings.\n"]
    CEF_SCHEME_OPTION_SECURE = 8,
    #[doc = "\n If CEF_SCHEME_OPTION_CORS_ENABLED is set the scheme can be sent CORS\n requests. This value should be set in most cases where\n CEF_SCHEME_OPTION_STANDARD is set.\n"]
    CEF_SCHEME_OPTION_CORS_ENABLED = 16,
    #[doc = "\n If CEF_SCHEME_OPTION_CSP_BYPASSING is set the scheme can bypass Content-\n Security-Policy (CSP) checks. This value should not be set in most cases\n where CEF_SCHEME_OPTION_STANDARD is set.\n"]
    CEF_SCHEME_OPTION_CSP_BYPASSING = 32,
    #[doc = "\n If CEF_SCHEME_OPTION_FETCH_ENABLED is set the scheme can perform Fetch API\n requests.\n"]
    CEF_SCHEME_OPTION_FETCH_ENABLED = 64,
}
#[doc = "\n Structure representing a range.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_range_t {
    pub from: u32,
    pub to: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_range_t"][::std::mem::size_of::<_cef_range_t>() - 8usize];
    ["Alignment of _cef_range_t"][::std::mem::align_of::<_cef_range_t>() - 4usize];
    ["Offset of field: _cef_range_t::from"][::std::mem::offset_of!(_cef_range_t, from) - 0usize];
    ["Offset of field: _cef_range_t::to"][::std::mem::offset_of!(_cef_range_t, to) - 4usize];
};
#[doc = "\n Structure representing a range.\n"]
pub type cef_range_t = _cef_range_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Composition underline style.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_composition_underline_style_t {
    CEF_CUS_SOLID = 0,
    CEF_CUS_DOT = 1,
    CEF_CUS_DASH = 2,
    CEF_CUS_NONE = 3,
    CEF_CUS_NUM_VALUES = 4,
}
#[doc = "\n Structure representing IME composition underline information. This is a thin\n wrapper around Blink's WebCompositionUnderline class and should be kept in\n sync with that.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_composition_underline_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Underline character range.\n"]
    pub range: cef_range_t,
    #[doc = "\n Text color.\n"]
    pub color: cef_color_t,
    #[doc = "\n Background color.\n"]
    pub background_color: cef_color_t,
    #[doc = "\n Set to true (1) for thick underline.\n"]
    pub thick: ::std::os::raw::c_int,
    #[doc = "\n Style.\n"]
    pub style: cef_composition_underline_style_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_composition_underline_t"]
        [::std::mem::size_of::<_cef_composition_underline_t>() - 32usize];
    ["Alignment of _cef_composition_underline_t"]
        [::std::mem::align_of::<_cef_composition_underline_t>() - 8usize];
    ["Offset of field: _cef_composition_underline_t::size"]
        [::std::mem::offset_of!(_cef_composition_underline_t, size) - 0usize];
    ["Offset of field: _cef_composition_underline_t::range"]
        [::std::mem::offset_of!(_cef_composition_underline_t, range) - 8usize];
    ["Offset of field: _cef_composition_underline_t::color"]
        [::std::mem::offset_of!(_cef_composition_underline_t, color) - 16usize];
    ["Offset of field: _cef_composition_underline_t::background_color"]
        [::std::mem::offset_of!(_cef_composition_underline_t, background_color) - 20usize];
    ["Offset of field: _cef_composition_underline_t::thick"]
        [::std::mem::offset_of!(_cef_composition_underline_t, thick) - 24usize];
    ["Offset of field: _cef_composition_underline_t::style"]
        [::std::mem::offset_of!(_cef_composition_underline_t, style) - 28usize];
};
#[doc = "\n Structure representing IME composition underline information. This is a thin\n wrapper around Blink's WebCompositionUnderline class and should be kept in\n sync with that.\n"]
pub type cef_composition_underline_t = _cef_composition_underline_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Enumerates the various representations of the ordering of audio channels.\n Must be kept synchronized with media::ChannelLayout from Chromium.\n See media\\base\\channel_layout.h\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_channel_layout_t {
    CEF_CHANNEL_LAYOUT_NONE = 0,
    CEF_CHANNEL_LAYOUT_UNSUPPORTED = 1,
    #[doc = " Front C"]
    CEF_CHANNEL_LAYOUT_MONO = 2,
    #[doc = " Front L, Front R"]
    CEF_CHANNEL_LAYOUT_STEREO = 3,
    #[doc = " Front L, Front R, Back C"]
    CEF_CHANNEL_LAYOUT_2_1 = 4,
    #[doc = " Front L, Front R, Front C"]
    CEF_CHANNEL_LAYOUT_SURROUND = 5,
    #[doc = " Front L, Front R, Front C, Back C"]
    CEF_CHANNEL_LAYOUT_4_0 = 6,
    #[doc = " Front L, Front R, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_2_2 = 7,
    #[doc = " Front L, Front R, Back L, Back R"]
    CEF_CHANNEL_LAYOUT_QUAD = 8,
    #[doc = " Front L, Front R, Front C, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_5_0 = 9,
    #[doc = " Front L, Front R, Front C, LFE, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_5_1 = 10,
    #[doc = " Front L, Front R, Front C, Back L, Back R"]
    CEF_CHANNEL_LAYOUT_5_0_BACK = 11,
    #[doc = " Front L, Front R, Front C, LFE, Back L, Back R"]
    CEF_CHANNEL_LAYOUT_5_1_BACK = 12,
    #[doc = " Front L, Front R, Front C, Back L, Back R, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_7_0 = 13,
    #[doc = " Front L, Front R, Front C, LFE, Back L, Back R, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_7_1 = 14,
    #[doc = " Front L, Front R, Front C, LFE, Front LofC, Front RofC, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_7_1_WIDE = 15,
    #[doc = " Front L, Front R"]
    CEF_CHANNEL_LAYOUT_STEREO_DOWNMIX = 16,
    #[doc = " Front L, Front R, LFE"]
    CEF_CHANNEL_LAYOUT_2POINT1 = 17,
    #[doc = " Front L, Front R, Front C, LFE"]
    CEF_CHANNEL_LAYOUT_3_1 = 18,
    #[doc = " Front L, Front R, Front C, LFE, Back C"]
    CEF_CHANNEL_LAYOUT_4_1 = 19,
    #[doc = " Front L, Front R, Front C, Back C, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_6_0 = 20,
    #[doc = " Front L, Front R, Front LofC, Front RofC, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_6_0_FRONT = 21,
    #[doc = " Front L, Front R, Front C, Back L, Back R, Back C"]
    CEF_CHANNEL_LAYOUT_HEXAGONAL = 22,
    #[doc = " Front L, Front R, Front C, LFE, Back C, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_6_1 = 23,
    #[doc = " Front L, Front R, Front C, LFE, Back L, Back R, Back C"]
    CEF_CHANNEL_LAYOUT_6_1_BACK = 24,
    #[doc = " Front L, Front R, LFE, Front LofC, Front RofC, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_6_1_FRONT = 25,
    #[doc = " Front L, Front R, Front C, Front LofC, Front RofC, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_7_0_FRONT = 26,
    #[doc = " Front L, Front R, Front C, LFE, Back L, Back R, Front LofC, Front RofC"]
    CEF_CHANNEL_LAYOUT_7_1_WIDE_BACK = 27,
    #[doc = " Front L, Front R, Front C, Back L, Back R, Back C, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_OCTAGONAL = 28,
    #[doc = " Channels are not explicitly mapped to speakers."]
    CEF_CHANNEL_LAYOUT_DISCRETE = 29,
    #[doc = " Deprecated, but keeping the enum value for UMA consistency.\n Front L, Front R, Front C. Front C contains the keyboard mic audio. This\n layout is only intended for input for WebRTC. The Front C channel\n is stripped away in the WebRTC audio input pipeline and never seen outside\n of that."]
    CEF_CHANNEL_LAYOUT_STEREO_AND_KEYBOARD_MIC = 30,
    #[doc = " Front L, Front R, LFE, Side L, Side R"]
    CEF_CHANNEL_LAYOUT_4_1_QUAD_SIDE = 31,
    #[doc = " Actual channel layout is specified in the bitstream and the actual channel\n count is unknown at Chromium media pipeline level (useful for audio\n pass-through mode)."]
    CEF_CHANNEL_LAYOUT_BITSTREAM = 32,
    #[doc = " Front L, Front R, Front C, LFE, Side L, Side R,\n Front Height L, Front Height R, Rear Height L, Rear Height R\n Will be represented as six channels (5.1) due to eight channel limit\n kMaxConcurrentChannels"]
    CEF_CHANNEL_LAYOUT_5_1_4_DOWNMIX = 33,
    #[doc = " Front C, LFE"]
    CEF_CHANNEL_LAYOUT_1_1 = 34,
    #[doc = " Front L, Front R, LFE, Back C"]
    CEF_CHANNEL_LAYOUT_3_1_BACK = 35,
    #[doc = " Front L, Front R, LFE, Back C"]
    CEF_CHANNEL_NUM_VALUES = 36,
}
#[doc = "\n Structure representing the audio parameters for setting up the audio\n handler.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_audio_parameters_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Layout of the audio channels\n"]
    pub channel_layout: cef_channel_layout_t,
    #[doc = "\n Sample rate"]
    pub sample_rate: ::std::os::raw::c_int,
    #[doc = "\n Number of frames per buffer\n"]
    pub frames_per_buffer: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_audio_parameters_t"][::std::mem::size_of::<_cef_audio_parameters_t>() - 24usize];
    ["Alignment of _cef_audio_parameters_t"]
        [::std::mem::align_of::<_cef_audio_parameters_t>() - 8usize];
    ["Offset of field: _cef_audio_parameters_t::size"]
        [::std::mem::offset_of!(_cef_audio_parameters_t, size) - 0usize];
    ["Offset of field: _cef_audio_parameters_t::channel_layout"]
        [::std::mem::offset_of!(_cef_audio_parameters_t, channel_layout) - 8usize];
    ["Offset of field: _cef_audio_parameters_t::sample_rate"]
        [::std::mem::offset_of!(_cef_audio_parameters_t, sample_rate) - 12usize];
    ["Offset of field: _cef_audio_parameters_t::frames_per_buffer"]
        [::std::mem::offset_of!(_cef_audio_parameters_t, frames_per_buffer) - 16usize];
};
#[doc = "\n Structure representing the audio parameters for setting up the audio\n handler.\n"]
pub type cef_audio_parameters_t = _cef_audio_parameters_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Result codes for CefMediaRouter::CreateRoute. Should be kept in sync with\n Chromium's media_router::mojom::RouteRequestResultCode type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_media_route_create_result_t {
    CEF_MRCR_UNKNOWN_ERROR = 0,
    CEF_MRCR_OK = 1,
    CEF_MRCR_TIMED_OUT = 2,
    CEF_MRCR_ROUTE_NOT_FOUND = 3,
    CEF_MRCR_SINK_NOT_FOUND = 4,
    CEF_MRCR_INVALID_ORIGIN = 5,
    CEF_MRCR_OFF_THE_RECORD_MISMATCH_DEPRECATED = 6,
    CEF_MRCR_NO_SUPPORTED_PROVIDER = 7,
    CEF_MRCR_CANCELLED = 8,
    CEF_MRCR_ROUTE_ALREADY_EXISTS = 9,
    CEF_MRCR_DESKTOP_PICKER_FAILED = 10,
    CEF_MRCR_ROUTE_ALREADY_TERMINATED = 11,
    CEF_MRCR_REDUNDANT_REQUEST = 12,
    CEF_MRCR_USER_NOT_ALLOWED = 13,
    CEF_MRCR_NOTIFICATION_DISABLED = 14,
    CEF_MRCR_NUM_VALUES = 15,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Connection state for a MediaRoute object. Should be kept in sync with\n Chromium's blink::mojom::PresentationConnectionState type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_media_route_connection_state_t {
    CEF_MRCS_UNKNOWN = -1,
    CEF_MRCS_CONNECTING = 0,
    CEF_MRCS_CONNECTED = 1,
    CEF_MRCS_CLOSED = 2,
    CEF_MRCS_TERMINATED = 3,
    CEF_MRCS_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Icon types for a MediaSink object. Should be kept in sync with Chromium's\n media_router::SinkIconType type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_media_sink_icon_type_t {
    CEF_MSIT_CAST = 0,
    CEF_MSIT_CAST_AUDIO_GROUP = 1,
    CEF_MSIT_CAST_AUDIO = 2,
    CEF_MSIT_MEETING = 3,
    CEF_MSIT_HANGOUT = 4,
    CEF_MSIT_EDUCATION = 5,
    CEF_MSIT_WIRED_DISPLAY = 6,
    CEF_MSIT_GENERIC = 7,
    CEF_MSIT_NUM_VALUES = 8,
}
#[doc = "\n Device information for a MediaSink object.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_sink_device_info_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    pub ip_address: cef_string_t,
    pub port: ::std::os::raw::c_int,
    pub model_name: cef_string_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_sink_device_info_t"]
        [::std::mem::size_of::<_cef_media_sink_device_info_t>() - 64usize];
    ["Alignment of _cef_media_sink_device_info_t"]
        [::std::mem::align_of::<_cef_media_sink_device_info_t>() - 8usize];
    ["Offset of field: _cef_media_sink_device_info_t::size"]
        [::std::mem::offset_of!(_cef_media_sink_device_info_t, size) - 0usize];
    ["Offset of field: _cef_media_sink_device_info_t::ip_address"]
        [::std::mem::offset_of!(_cef_media_sink_device_info_t, ip_address) - 8usize];
    ["Offset of field: _cef_media_sink_device_info_t::port"]
        [::std::mem::offset_of!(_cef_media_sink_device_info_t, port) - 32usize];
    ["Offset of field: _cef_media_sink_device_info_t::model_name"]
        [::std::mem::offset_of!(_cef_media_sink_device_info_t, model_name) - 40usize];
};
#[doc = "\n Device information for a MediaSink object.\n"]
pub type cef_media_sink_device_info_t = _cef_media_sink_device_info_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Represents commands available to TextField. Should be kept in sync with\n Chromium's views::TextField::MenuCommands type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_text_field_commands_t {
    CEF_TFC_UNKNOWN = 0,
    CEF_TFC_CUT = 1,
    CEF_TFC_COPY = 2,
    CEF_TFC_PASTE = 3,
    CEF_TFC_SELECT_ALL = 4,
    CEF_TFC_SELECT_WORD = 5,
    CEF_TFC_UNDO = 6,
    CEF_TFC_DELETE = 7,
    CEF_TFC_NUM_VALUES = 8,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Chrome toolbar types.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_chrome_toolbar_type_t {
    CEF_CTT_UNKNOWN = 0,
    CEF_CTT_NONE = 1,
    CEF_CTT_NORMAL = 2,
    CEF_CTT_LOCATION = 3,
    CEF_CTT_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Chrome page action icon types. Should be kept in sync with Chromium's\n PageActionIconType type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_chrome_page_action_icon_type_t {
    CEF_CPAIT_BOOKMARK_STAR = 0,
    CEF_CPAIT_CLICK_TO_CALL = 1,
    CEF_CPAIT_COOKIE_CONTROLS = 2,
    CEF_CPAIT_FILE_SYSTEM_ACCESS = 3,
    CEF_CPAIT_FIND = 4,
    CEF_CPAIT_MEMORY_SAVER = 5,
    CEF_CPAIT_INTENT_PICKER = 6,
    CEF_CPAIT_LOCAL_CARD_MIGRATION = 7,
    CEF_CPAIT_MANAGE_PASSWORDS = 8,
    CEF_CPAIT_PAYMENTS_OFFER_NOTIFICATION = 9,
    CEF_CPAIT_PRICE_TRACKING = 10,
    CEF_CPAIT_PWA_INSTALL = 11,
    CEF_CPAIT_QR_CODE_GENERATOR_DEPRECATED = 12,
    CEF_CPAIT_READER_MODE_DEPRECATED = 13,
    CEF_CPAIT_SAVE_AUTOFILL_ADDRESS = 14,
    CEF_CPAIT_SAVE_CARD = 15,
    CEF_CPAIT_SEND_TAB_TO_SELF_DEPRECATED = 16,
    CEF_CPAIT_SHARING_HUB = 17,
    CEF_CPAIT_SIDE_SEARCH_DEPRECATED = 18,
    CEF_CPAIT_SMS_REMOTE_FETCHER = 19,
    CEF_CPAIT_TRANSLATE = 20,
    CEF_CPAIT_VIRTUAL_CARD_ENROLL = 21,
    CEF_CPAIT_VIRTUAL_CARD_INFORMATION = 22,
    CEF_CPAIT_ZOOM = 23,
    CEF_CPAIT_SAVE_IBAN = 24,
    CEF_CPAIT_MANDATORY_REAUTH = 25,
    CEF_CPAIT_PRICE_INSIGHTS = 26,
    CEF_CPAIT_READ_ANYTHING_DEPRECATED = 27,
    CEF_CPAIT_PRODUCT_SPECIFICATIONS = 28,
    CEF_CPAIT_LENS_OVERLAY = 29,
    CEF_CPAIT_DISCOUNTS = 30,
    CEF_CPAIT_OPTIMIZATION_GUIDE = 31,
    CEF_CPAIT_COLLABORATION_MESSAGING = 32,
    CEF_CPAIT_CHANGE_PASSWORD = 33,
    CEF_CPAIT_LENS_OVERLAY_HOMEWORK = 34,
    CEF_CPAIT_NUM_VALUES = 35,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Chrome toolbar button types. Should be kept in sync with CEF's internal\n ToolbarButtonType type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_chrome_toolbar_button_type_t {
    CEF_CTBT_CAST = 0,
    CEF_CTBT_DOWNLOAD_DEPRECATED = 1,
    CEF_CTBT_SEND_TAB_TO_SELF_DEPRECATED = 2,
    CEF_CTBT_SIDE_PANEL = 3,
    CEF_CTBT_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Docking modes supported by CefWindow::AddOverlay.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_docking_mode_t {
    CEF_DOCKING_MODE_TOP_LEFT = 0,
    CEF_DOCKING_MODE_TOP_RIGHT = 1,
    CEF_DOCKING_MODE_BOTTOM_LEFT = 2,
    CEF_DOCKING_MODE_BOTTOM_RIGHT = 3,
    CEF_DOCKING_MODE_CUSTOM = 4,
    CEF_DOCKING_MODE_NUM_VALUES = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Show states supported by CefWindowDelegate::GetInitialShowState.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_show_state_t {
    CEF_SHOW_STATE_NORMAL = 0,
    CEF_SHOW_STATE_MINIMIZED = 1,
    CEF_SHOW_STATE_MAXIMIZED = 2,
    CEF_SHOW_STATE_FULLSCREEN = 3,
    CEF_SHOW_STATE_HIDDEN = 4,
    CEF_SHOW_STATE_NUM_VALUES = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Values indicating what state of the touch handle is set.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_touch_handle_state_flags_t {
    CEF_THS_FLAG_NONE = 0,
    CEF_THS_FLAG_ENABLED = 1,
    CEF_THS_FLAG_ORIENTATION = 2,
    CEF_THS_FLAG_ORIGIN = 4,
    CEF_THS_FLAG_ALPHA = 8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_touch_handle_state_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = "\n Touch handle id. Increments for each new touch handle.\n"]
    pub touch_handle_id: ::std::os::raw::c_int,
    #[doc = "\n Combination of cef_touch_handle_state_flags_t values indicating what state\n is set.\n"]
    pub flags: u32,
    #[doc = "\n Enabled state. Only set if |flags| contains CEF_THS_FLAG_ENABLED.\n"]
    pub enabled: ::std::os::raw::c_int,
    #[doc = "\n Orientation state. Only set if |flags| contains CEF_THS_FLAG_ORIENTATION.\n"]
    pub orientation: cef_horizontal_alignment_t,
    pub mirror_vertical: ::std::os::raw::c_int,
    pub mirror_horizontal: ::std::os::raw::c_int,
    #[doc = "\n Origin state. Only set if |flags| contains CEF_THS_FLAG_ORIGIN.\n"]
    pub origin: cef_point_t,
    #[doc = "\n Alpha state. Only set if |flags| contains CEF_THS_FLAG_ALPHA.\n"]
    pub alpha: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_touch_handle_state_t"]
        [::std::mem::size_of::<_cef_touch_handle_state_t>() - 48usize];
    ["Alignment of _cef_touch_handle_state_t"]
        [::std::mem::align_of::<_cef_touch_handle_state_t>() - 8usize];
    ["Offset of field: _cef_touch_handle_state_t::size"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, size) - 0usize];
    ["Offset of field: _cef_touch_handle_state_t::touch_handle_id"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, touch_handle_id) - 8usize];
    ["Offset of field: _cef_touch_handle_state_t::flags"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, flags) - 12usize];
    ["Offset of field: _cef_touch_handle_state_t::enabled"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, enabled) - 16usize];
    ["Offset of field: _cef_touch_handle_state_t::orientation"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, orientation) - 20usize];
    ["Offset of field: _cef_touch_handle_state_t::mirror_vertical"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, mirror_vertical) - 24usize];
    ["Offset of field: _cef_touch_handle_state_t::mirror_horizontal"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, mirror_horizontal) - 28usize];
    ["Offset of field: _cef_touch_handle_state_t::origin"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, origin) - 32usize];
    ["Offset of field: _cef_touch_handle_state_t::alpha"]
        [::std::mem::offset_of!(_cef_touch_handle_state_t, alpha) - 40usize];
};
pub type cef_touch_handle_state_t = _cef_touch_handle_state_t;
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Media access permissions used by OnRequestMediaAccessPermission.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_media_access_permission_types_t {
    #[doc = "\n No permission.\n"]
    CEF_MEDIA_PERMISSION_NONE = 0,
    #[doc = "\n Device audio capture permission.\n"]
    CEF_MEDIA_PERMISSION_DEVICE_AUDIO_CAPTURE = 1,
    #[doc = "\n Device video capture permission.\n"]
    CEF_MEDIA_PERMISSION_DEVICE_VIDEO_CAPTURE = 2,
    #[doc = "\n Desktop audio capture permission.\n"]
    CEF_MEDIA_PERMISSION_DESKTOP_AUDIO_CAPTURE = 4,
    #[doc = "\n Desktop video capture permission.\n"]
    CEF_MEDIA_PERMISSION_DESKTOP_VIDEO_CAPTURE = 8,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Permission types used with OnShowPermissionPrompt. Some types are\n platform-specific or only supported with Chrome style. Should be kept\n in sync with Chromium's permissions::RequestType type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_permission_request_types_t {
    CEF_PERMISSION_TYPE_NONE = 0,
    CEF_PERMISSION_TYPE_AR_SESSION = 1,
    CEF_PERMISSION_TYPE_CAMERA_PAN_TILT_ZOOM = 2,
    CEF_PERMISSION_TYPE_CAMERA_STREAM = 4,
    CEF_PERMISSION_TYPE_CAPTURED_SURFACE_CONTROL = 8,
    CEF_PERMISSION_TYPE_CLIPBOARD = 16,
    CEF_PERMISSION_TYPE_TOP_LEVEL_STORAGE_ACCESS = 32,
    CEF_PERMISSION_TYPE_DISK_QUOTA = 64,
    CEF_PERMISSION_TYPE_LOCAL_FONTS = 128,
    CEF_PERMISSION_TYPE_GEOLOCATION = 256,
    CEF_PERMISSION_TYPE_HAND_TRACKING = 512,
    CEF_PERMISSION_TYPE_IDENTITY_PROVIDER = 1024,
    CEF_PERMISSION_TYPE_IDLE_DETECTION = 2048,
    CEF_PERMISSION_TYPE_MIC_STREAM = 4096,
    CEF_PERMISSION_TYPE_MIDI_SYSEX = 8192,
    CEF_PERMISSION_TYPE_MULTIPLE_DOWNLOADS = 16384,
    CEF_PERMISSION_TYPE_NOTIFICATIONS = 32768,
    CEF_PERMISSION_TYPE_KEYBOARD_LOCK = 65536,
    CEF_PERMISSION_TYPE_POINTER_LOCK = 131072,
    CEF_PERMISSION_TYPE_PROTECTED_MEDIA_IDENTIFIER = 262144,
    CEF_PERMISSION_TYPE_REGISTER_PROTOCOL_HANDLER = 524288,
    CEF_PERMISSION_TYPE_STORAGE_ACCESS = 1048576,
    CEF_PERMISSION_TYPE_VR_SESSION = 2097152,
    CEF_PERMISSION_TYPE_WEB_APP_INSTALLATION = 4194304,
    CEF_PERMISSION_TYPE_WINDOW_MANAGEMENT = 8388608,
    CEF_PERMISSION_TYPE_FILE_SYSTEM_ACCESS = 16777216,
    CEF_PERMISSION_TYPE_LOCAL_NETWORK_ACCESS = 33554432,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Permission request results.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_permission_request_result_t {
    #[doc = "\n Accept the permission request as an explicit user action.\n"]
    CEF_PERMISSION_RESULT_ACCEPT = 0,
    #[doc = "\n Deny the permission request as an explicit user action.\n"]
    CEF_PERMISSION_RESULT_DENY = 1,
    #[doc = "\n Dismiss the permission request as an explicit user action.\n"]
    CEF_PERMISSION_RESULT_DISMISS = 2,
    #[doc = "\n Ignore the permission request. If the prompt remains unhandled (e.g.\n OnShowPermissionPrompt returns false and there is no default permissions\n UI) then any related promises may remain unresolved.\n"]
    CEF_PERMISSION_RESULT_IGNORE = 3,
    #[doc = "\n Ignore the permission request. If the prompt remains unhandled (e.g.\n OnShowPermissionPrompt returns false and there is no default permissions\n UI) then any related promises may remain unresolved.\n"]
    CEF_PERMISSION_RESULT_NUM_VALUES = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Certificate types supported by CefTestServer::CreateAndStart. The matching\n certificate file must exist in the \"net/data/ssl/certificates\" directory.\n See CefSetDataDirectoryForTests() for related configuration.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_test_cert_type_t {
    #[doc = " Valid certificate using the IP (127.0.0.1). Loads the \"ok_cert.pem\" file."]
    CEF_TEST_CERT_OK_IP = 0,
    #[doc = " Valid certificate using the domain (\"localhost\"). Loads the\n \"localhost_cert.pem\" file."]
    CEF_TEST_CERT_OK_DOMAIN = 1,
    #[doc = " Expired certificate. Loads the \"expired_cert.pem\" file."]
    CEF_TEST_CERT_EXPIRED = 2,
    #[doc = " Expired certificate. Loads the \"expired_cert.pem\" file."]
    CEF_TEST_CERT_NUM_VALUES = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Preferences type passed to\n CefBrowserProcessHandler::OnRegisterCustomPreferences.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_preferences_type_t {
    #[doc = " Global preferences registered a single time at application startup."]
    CEF_PREFERENCES_TYPE_GLOBAL = 0,
    #[doc = " Request context preferences registered each time a new CefRequestContext\n is created."]
    CEF_PREFERENCES_TYPE_REQUEST_CONTEXT = 1,
    #[doc = " Request context preferences registered each time a new CefRequestContext\n is created."]
    CEF_PREFERENCES_TYPE_NUM_VALUES = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Download interrupt reasons. Should be kept in sync with\n Chromium's download::DownloadInterruptReason type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_download_interrupt_reason_t {
    CEF_DOWNLOAD_INTERRUPT_REASON_NONE = 0,
    #[doc = " Generic file operation failure."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_FAILED = 1,
    #[doc = " The file cannot be accessed due to security restrictions."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_ACCESS_DENIED = 2,
    #[doc = " There is not enough room on the drive."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_NO_SPACE = 3,
    #[doc = " The directory or file name is too long."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_NAME_TOO_LONG = 5,
    #[doc = " The file is too large for the file system to handle."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_TOO_LARGE = 6,
    #[doc = " The file contains a virus."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_VIRUS_INFECTED = 7,
    #[doc = " The file was in use. Too many files are opened at once. We have run out of\n memory."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_TRANSIENT_ERROR = 10,
    #[doc = " The file was blocked due to local policy."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_BLOCKED = 11,
    #[doc = " An attempt to check the safety of the download failed due to unexpected\n reasons. See http://crbug.com/153212."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_SECURITY_CHECK_FAILED = 12,
    #[doc = " An attempt was made to seek past the end of a file in opening\n a file (as part of resuming a previously interrupted download)."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_TOO_SHORT = 13,
    #[doc = " The partial file didn't match the expected hash."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_HASH_MISMATCH = 14,
    #[doc = " The source and the target of the download were the same."]
    CEF_DOWNLOAD_INTERRUPT_REASON_FILE_SAME_AS_SOURCE = 15,
    #[doc = " Generic network failure."]
    CEF_DOWNLOAD_INTERRUPT_REASON_NETWORK_FAILED = 20,
    #[doc = " The network operation timed out."]
    CEF_DOWNLOAD_INTERRUPT_REASON_NETWORK_TIMEOUT = 21,
    #[doc = " The network connection has been lost."]
    CEF_DOWNLOAD_INTERRUPT_REASON_NETWORK_DISCONNECTED = 22,
    #[doc = " The server has gone down."]
    CEF_DOWNLOAD_INTERRUPT_REASON_NETWORK_SERVER_DOWN = 23,
    #[doc = " The network request was invalid. This may be due to the original URL or a\n redirected URL:\n - Having an unsupported scheme.\n - Being an invalid URL.\n - Being disallowed by policy."]
    CEF_DOWNLOAD_INTERRUPT_REASON_NETWORK_INVALID_REQUEST = 24,
    #[doc = " The server indicates that the operation has failed (generic)."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_FAILED = 30,
    #[doc = " The server does not support range requests.\n Internal use only:  must restart from the beginning."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_NO_RANGE = 31,
    #[doc = " The server does not have the requested data."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_BAD_CONTENT = 33,
    #[doc = " Server didn't authorize access to resource."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_UNAUTHORIZED = 34,
    #[doc = " Server certificate problem."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_CERT_PROBLEM = 35,
    #[doc = " Server access forbidden."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_FORBIDDEN = 36,
    #[doc = " Unexpected server response. This might indicate that the responding server\n may not be the intended server."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_UNREACHABLE = 37,
    #[doc = " The server sent fewer bytes than the content-length header. It may\n indicate that the connection was closed prematurely, or the Content-Length\n header was invalid. The download is only interrupted if strong validators\n are present. Otherwise, it is treated as finished."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_CONTENT_LENGTH_MISMATCH = 38,
    #[doc = " An unexpected cross-origin redirect happened."]
    CEF_DOWNLOAD_INTERRUPT_REASON_SERVER_CROSS_ORIGIN_REDIRECT = 39,
    #[doc = " The user canceled the download."]
    CEF_DOWNLOAD_INTERRUPT_REASON_USER_CANCELED = 40,
    #[doc = " The user shut down the browser.\n Internal use only:  resume pending downloads if possible."]
    CEF_DOWNLOAD_INTERRUPT_REASON_USER_SHUTDOWN = 41,
    #[doc = " The browser crashed.\n Internal use only:  resume pending downloads if possible."]
    CEF_DOWNLOAD_INTERRUPT_REASON_CRASH = 50,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Specifies the gesture commands.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_gesture_command_t {
    CEF_GESTURE_COMMAND_BACK = 0,
    CEF_GESTURE_COMMAND_FORWARD = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Specifies the zoom commands supported by CefBrowserHost::Zoom.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_zoom_command_t {
    CEF_ZOOM_COMMAND_OUT = 0,
    CEF_ZOOM_COMMAND_RESET = 1,
    CEF_ZOOM_COMMAND_IN = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Specifies the color variants supported by\n CefRequestContext::SetChromeThemeColor.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_color_variant_t {
    CEF_COLOR_VARIANT_SYSTEM = 0,
    CEF_COLOR_VARIANT_LIGHT = 1,
    CEF_COLOR_VARIANT_DARK = 2,
    CEF_COLOR_VARIANT_TONAL_SPOT = 3,
    CEF_COLOR_VARIANT_NEUTRAL = 4,
    CEF_COLOR_VARIANT_VIBRANT = 5,
    CEF_COLOR_VARIANT_EXPRESSIVE = 6,
    CEF_COLOR_VARIANT_NUM_VALUES = 7,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "\n Specifies the task type variants supported by CefTaskManager.\n Should be kept in sync with Chromium's task_manager::Task::Type type.\n"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cef_task_type_t {
    CEF_TASK_TYPE_UNKNOWN = 0,
    #[doc = " The main browser process."]
    CEF_TASK_TYPE_BROWSER = 1,
    #[doc = " A graphics process."]
    CEF_TASK_TYPE_GPU = 2,
    #[doc = " A Linux zygote process."]
    CEF_TASK_TYPE_ZYGOTE = 3,
    #[doc = " A browser utility process."]
    CEF_TASK_TYPE_UTILITY = 4,
    #[doc = " A normal WebContents renderer process."]
    CEF_TASK_TYPE_RENDERER = 5,
    #[doc = " An extension or app process."]
    CEF_TASK_TYPE_EXTENSION = 6,
    #[doc = " A browser plugin guest process."]
    CEF_TASK_TYPE_GUEST = 7,
    #[doc = " A plugin process."]
    CEF_TASK_TYPE_PLUGIN = 8,
    #[doc = " A sandbox helper process"]
    CEF_TASK_TYPE_SANDBOX_HELPER = 9,
    #[doc = " A dedicated worker running on the renderer process."]
    CEF_TASK_TYPE_DEDICATED_WORKER = 10,
    #[doc = " A shared worker running on the renderer process."]
    CEF_TASK_TYPE_SHARED_WORKER = 11,
    #[doc = " A service worker running on the renderer process."]
    CEF_TASK_TYPE_SERVICE_WORKER = 12,
    #[doc = " A service worker running on the renderer process."]
    CEF_TASK_TYPE_NUM_VALUES = 13,
}
#[doc = "\n Structure representing task information provided by CefTaskManager.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_task_info_t {
    #[doc = "\n Size of this structure.\n"]
    pub size: usize,
    #[doc = " The task ID."]
    pub id: i64,
    #[doc = " The task type."]
    pub type_: cef_task_type_t,
    #[doc = " Set to true (1) if the task is killable."]
    pub is_killable: ::std::os::raw::c_int,
    #[doc = " The task title."]
    pub title: cef_string_t,
    #[doc = " The CPU usage of the process on which the task is running. The value is\n in the range zero to number_of_processors * 100%."]
    pub cpu_usage: f64,
    #[doc = " The number of processors available on the system."]
    pub number_of_processors: ::std::os::raw::c_int,
    #[doc = " The memory footprint of the task in bytes. A value of -1 means no valid\n value is currently available."]
    pub memory: i64,
    #[doc = " The GPU memory usage of the task in bytes. A value of -1 means no valid\n value is currently available."]
    pub gpu_memory: i64,
    #[doc = " Set to true (1) if this task process' GPU resource count is inflated\n because it is counting other processes' resources (e.g, the GPU process\n has this value set to true because it is the aggregate of all processes)."]
    pub is_gpu_memory_inflated: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_task_info_t"][::std::mem::size_of::<_cef_task_info_t>() - 88usize];
    ["Alignment of _cef_task_info_t"][::std::mem::align_of::<_cef_task_info_t>() - 8usize];
    ["Offset of field: _cef_task_info_t::size"]
        [::std::mem::offset_of!(_cef_task_info_t, size) - 0usize];
    ["Offset of field: _cef_task_info_t::id"]
        [::std::mem::offset_of!(_cef_task_info_t, id) - 8usize];
    ["Offset of field: _cef_task_info_t::type_"]
        [::std::mem::offset_of!(_cef_task_info_t, type_) - 16usize];
    ["Offset of field: _cef_task_info_t::is_killable"]
        [::std::mem::offset_of!(_cef_task_info_t, is_killable) - 20usize];
    ["Offset of field: _cef_task_info_t::title"]
        [::std::mem::offset_of!(_cef_task_info_t, title) - 24usize];
    ["Offset of field: _cef_task_info_t::cpu_usage"]
        [::std::mem::offset_of!(_cef_task_info_t, cpu_usage) - 48usize];
    ["Offset of field: _cef_task_info_t::number_of_processors"]
        [::std::mem::offset_of!(_cef_task_info_t, number_of_processors) - 56usize];
    ["Offset of field: _cef_task_info_t::memory"]
        [::std::mem::offset_of!(_cef_task_info_t, memory) - 64usize];
    ["Offset of field: _cef_task_info_t::gpu_memory"]
        [::std::mem::offset_of!(_cef_task_info_t, gpu_memory) - 72usize];
    ["Offset of field: _cef_task_info_t::is_gpu_memory_inflated"]
        [::std::mem::offset_of!(_cef_task_info_t, is_gpu_memory_inflated) - 80usize];
};
#[doc = "\n Structure representing task information provided by CefTaskManager.\n"]
pub type cef_task_info_t = _cef_task_info_t;
#[doc = "\n All ref-counted framework structures must include this structure first.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_base_ref_counted_t {
    #[doc = "\n Size of the data structure.\n"]
    pub size: usize,
    #[doc = "\n Called to increment the reference count for the object. Should be called\n for every new copy of a pointer to a given object.\n"]
    pub add_ref: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_base_ref_counted_t)>,
    #[doc = "\n Called to decrement the reference count for the object. If the reference\n count falls to 0 the object should self-delete. Returns true (1) if the\n resulting reference count is 0.\n"]
    pub release: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_base_ref_counted_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the current reference count is 1.\n"]
    pub has_one_ref: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_base_ref_counted_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the current reference count is at least 1.\n"]
    pub has_at_least_one_ref: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_base_ref_counted_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_base_ref_counted_t"][::std::mem::size_of::<_cef_base_ref_counted_t>() - 40usize];
    ["Alignment of _cef_base_ref_counted_t"]
        [::std::mem::align_of::<_cef_base_ref_counted_t>() - 8usize];
    ["Offset of field: _cef_base_ref_counted_t::size"]
        [::std::mem::offset_of!(_cef_base_ref_counted_t, size) - 0usize];
    ["Offset of field: _cef_base_ref_counted_t::add_ref"]
        [::std::mem::offset_of!(_cef_base_ref_counted_t, add_ref) - 8usize];
    ["Offset of field: _cef_base_ref_counted_t::release"]
        [::std::mem::offset_of!(_cef_base_ref_counted_t, release) - 16usize];
    ["Offset of field: _cef_base_ref_counted_t::has_one_ref"]
        [::std::mem::offset_of!(_cef_base_ref_counted_t, has_one_ref) - 24usize];
    ["Offset of field: _cef_base_ref_counted_t::has_at_least_one_ref"]
        [::std::mem::offset_of!(_cef_base_ref_counted_t, has_at_least_one_ref) - 32usize];
};
#[doc = "\n All ref-counted framework structures must include this structure first.\n"]
pub type cef_base_ref_counted_t = _cef_base_ref_counted_t;
#[doc = "\n All scoped framework structures must include this structure first.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_base_scoped_t {
    #[doc = "\n Size of the data structure.\n"]
    pub size: usize,
    #[doc = "\n Called to delete this object. May be NULL if the object is not owned.\n"]
    pub del: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_base_scoped_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_base_scoped_t"][::std::mem::size_of::<_cef_base_scoped_t>() - 16usize];
    ["Alignment of _cef_base_scoped_t"][::std::mem::align_of::<_cef_base_scoped_t>() - 8usize];
    ["Offset of field: _cef_base_scoped_t::size"]
        [::std::mem::offset_of!(_cef_base_scoped_t, size) - 0usize];
    ["Offset of field: _cef_base_scoped_t::del"]
        [::std::mem::offset_of!(_cef_base_scoped_t, del) - 8usize];
};
#[doc = "\n All scoped framework structures must include this structure first.\n"]
pub type cef_base_scoped_t = _cef_base_scoped_t;
#[doc = "\n Callback structure for cef_browser_host_t::AddDevToolsMessageObserver. The\n functions of this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_dev_tools_message_observer_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be called on receipt of a DevTools protocol message.\n |browser| is the originating browser instance. |message| is a UTF8-encoded\n JSON dictionary representing either a function result or an event.\n |message| is only valid for the scope of this callback and should be\n copied if necessary. Return true (1) if the message was handled or false\n (0) if the message should be further processed and passed to the\n OnDevToolsMethodResult or OnDevToolsEvent functions as appropriate.\n\n Method result dictionaries include an \"id\" (int) value that identifies the\n orginating function call sent from\n cef_browser_host_t::SendDevToolsMessage, and optionally either a \"result\"\n (dictionary) or \"error\" (dictionary) value. The \"error\" dictionary will\n contain \"code\" (int) and \"message\" (string) values. Event dictionaries\n include a \"function\" (string) value and optionally a \"params\" (dictionary)\n value. See the DevTools protocol documentation at\n https://chromedevtools.github.io/devtools-protocol/ for details of\n supported function calls and the expected \"result\" or \"params\" dictionary\n contents. JSON dictionaries can be parsed using the CefParseJSON function\n if desired, however be aware of performance considerations when parsing\n large messages (some of which may exceed 1MB in size).\n"]
    pub on_dev_tools_message: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dev_tools_message_observer_t,
            browser: *mut _cef_browser_t,
            message: *const ::std::os::raw::c_void,
            message_size: usize,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Method that will be called after attempted execution of a DevTools\n protocol function. |browser| is the originating browser instance.\n |message_id| is the \"id\" value that identifies the originating function\n call message. If the function succeeded |success| will be true (1) and\n |result| will be the UTF8-encoded JSON \"result\" dictionary value (which\n may be NULL). If the function failed |success| will be false (0) and\n |result| will be the UTF8-encoded JSON \"error\" dictionary value. |result|\n is only valid for the scope of this callback and should be copied if\n necessary. See the OnDevToolsMessage documentation for additional details\n on |result| contents.\n"]
    pub on_dev_tools_method_result: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dev_tools_message_observer_t,
            browser: *mut _cef_browser_t,
            message_id: ::std::os::raw::c_int,
            success: ::std::os::raw::c_int,
            result: *const ::std::os::raw::c_void,
            result_size: usize,
        ),
    >,
    #[doc = "\n Method that will be called on receipt of a DevTools protocol event.\n |browser| is the originating browser instance. |function| is the\n \"function\" value. |params| is the UTF8-encoded JSON \"params\" dictionary\n value (which may be NULL). |params| is only valid for the scope of this\n callback and should be copied if necessary. See the OnDevToolsMessage\n documentation for additional details on |params| contents.\n"]
    pub on_dev_tools_event: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dev_tools_message_observer_t,
            browser: *mut _cef_browser_t,
            method: *const cef_string_t,
            params: *const ::std::os::raw::c_void,
            params_size: usize,
        ),
    >,
    #[doc = "\n Method that will be called when the DevTools agent has attached. |browser|\n is the originating browser instance. This will generally occur in response\n to the first message sent while the agent is detached.\n"]
    pub on_dev_tools_agent_attached: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dev_tools_message_observer_t,
            browser: *mut _cef_browser_t,
        ),
    >,
    #[doc = "\n Method that will be called when the DevTools agent has detached. |browser|\n is the originating browser instance. Any function results that were\n pending before the agent became detached will not be delivered, and any\n active event subscriptions will be canceled.\n"]
    pub on_dev_tools_agent_detached: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dev_tools_message_observer_t,
            browser: *mut _cef_browser_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_dev_tools_message_observer_t"]
        [::std::mem::size_of::<_cef_dev_tools_message_observer_t>() - 80usize];
    ["Alignment of _cef_dev_tools_message_observer_t"]
        [::std::mem::align_of::<_cef_dev_tools_message_observer_t>() - 8usize];
    ["Offset of field: _cef_dev_tools_message_observer_t::base"]
        [::std::mem::offset_of!(_cef_dev_tools_message_observer_t, base) - 0usize];
    ["Offset of field: _cef_dev_tools_message_observer_t::on_dev_tools_message"]
        [::std::mem::offset_of!(_cef_dev_tools_message_observer_t, on_dev_tools_message) - 40usize];
    ["Offset of field: _cef_dev_tools_message_observer_t::on_dev_tools_method_result"][::std::mem::offset_of!(
        _cef_dev_tools_message_observer_t,
        on_dev_tools_method_result
    ) - 48usize];
    ["Offset of field: _cef_dev_tools_message_observer_t::on_dev_tools_event"]
        [::std::mem::offset_of!(_cef_dev_tools_message_observer_t, on_dev_tools_event) - 56usize];
    ["Offset of field: _cef_dev_tools_message_observer_t::on_dev_tools_agent_attached"][::std::mem::offset_of!(
        _cef_dev_tools_message_observer_t,
        on_dev_tools_agent_attached
    )
        - 64usize];
    ["Offset of field: _cef_dev_tools_message_observer_t::on_dev_tools_agent_detached"][::std::mem::offset_of!(
        _cef_dev_tools_message_observer_t,
        on_dev_tools_agent_detached
    )
        - 72usize];
};
#[doc = "\n Callback structure for cef_browser_host_t::AddDevToolsMessageObserver. The\n functions of this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_dev_tools_message_observer_t = _cef_dev_tools_message_observer_t;
#[doc = "\n Structure that wraps other data value types. Complex types (binary,\n dictionary and list) will be referenced but not owned by this object. Can be\n used on any process and thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_value_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if the underlying data is valid. This will always be true\n (1) for simple types. For complex types (binary, dictionary and list) the\n underlying data may become invalid if owned by another object (e.g. list\n or dictionary) and that other object is then modified or destroyed. This\n value object can be re-used by calling Set*() even if the underlying data\n is invalid.\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the underlying data is owned by another object.\n"]
    pub is_owned: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the underlying data is read-only. Some APIs may expose\n read-only objects.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object and |that| object have the same underlying\n data. If true (1) modifications to this object will also affect |that|\n object and vice-versa.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_value_t,
            that: *mut _cef_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object and |that| object have an equivalent\n underlying value but are not necessarily the same object.\n"]
    pub is_equal: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_value_t,
            that: *mut _cef_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns a copy of this object. The underlying data will also be copied.\n"]
    pub copy:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_value_t) -> *mut _cef_value_t>,
    #[doc = "\n Returns the underlying value type.\n"]
    pub get_type:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_value_t) -> cef_value_type_t>,
    #[doc = "\n Returns the underlying value as type bool.\n"]
    pub get_bool: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the underlying value as type int.\n"]
    pub get_int: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the underlying value as type double.\n"]
    pub get_double: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_value_t) -> f64>,
    #[doc = "\n Returns the underlying value as type string.\n"]
    pub get_string: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the underlying value as type binary. The returned reference may\n become invalid if the value is owned by another object or if ownership is\n transferred to another object in the future. To maintain a reference to\n the value after assigning ownership to a dictionary or list pass this\n object to the set_value() function instead of passing the returned\n reference to set_binary().\n"]
    pub get_binary: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns the underlying value as type dictionary. The returned reference\n may become invalid if the value is owned by another object or if ownership\n is transferred to another object in the future. To maintain a reference to\n the value after assigning ownership to a dictionary or list pass this\n object to the set_value() function instead of passing the returned\n reference to set_dictionary().\n"]
    pub get_dictionary: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> *mut _cef_dictionary_value_t,
    >,
    #[doc = "\n Returns the underlying value as type list. The returned reference may\n become invalid if the value is owned by another object or if ownership is\n transferred to another object in the future. To maintain a reference to\n the value after assigning ownership to a dictionary or list pass this\n object to the set_value() function instead of passing the returned\n reference to set_list().\n"]
    pub get_list: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> *mut _cef_list_value_t,
    >,
    #[doc = "\n Sets the underlying value as type null. Returns true (1) if the value was\n set successfully.\n"]
    pub set_null: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the underlying value as type bool. Returns true (1) if the value was\n set successfully.\n"]
    pub set_bool: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_value_t,
            value: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the underlying value as type int. Returns true (1) if the value was\n set successfully.\n"]
    pub set_int: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_value_t,
            value: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the underlying value as type double. Returns true (1) if the value\n was set successfully.\n"]
    pub set_double: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_value_t, value: f64) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the underlying value as type string. Returns true (1) if the value\n was set successfully.\n"]
    pub set_string: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_value_t,
            value: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the underlying value as type binary. Returns true (1) if the value\n was set successfully. This object keeps a reference to |value| and\n ownership of the underlying data remains unchanged.\n"]
    pub set_binary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_value_t,
            value: *mut _cef_binary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the underlying value as type dict. Returns true (1) if the value was\n set successfully. This object keeps a reference to |value| and ownership\n of the underlying data remains unchanged.\n"]
    pub set_dictionary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_value_t,
            value: *mut _cef_dictionary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the underlying value as type list. Returns true (1) if the value was\n set successfully. This object keeps a reference to |value| and ownership\n of the underlying data remains unchanged.\n"]
    pub set_list: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_value_t,
            value: *mut _cef_list_value_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_value_t"][::std::mem::size_of::<_cef_value_t>() - 216usize];
    ["Alignment of _cef_value_t"][::std::mem::align_of::<_cef_value_t>() - 8usize];
    ["Offset of field: _cef_value_t::base"][::std::mem::offset_of!(_cef_value_t, base) - 0usize];
    ["Offset of field: _cef_value_t::is_valid"]
        [::std::mem::offset_of!(_cef_value_t, is_valid) - 40usize];
    ["Offset of field: _cef_value_t::is_owned"]
        [::std::mem::offset_of!(_cef_value_t, is_owned) - 48usize];
    ["Offset of field: _cef_value_t::is_read_only"]
        [::std::mem::offset_of!(_cef_value_t, is_read_only) - 56usize];
    ["Offset of field: _cef_value_t::is_same"]
        [::std::mem::offset_of!(_cef_value_t, is_same) - 64usize];
    ["Offset of field: _cef_value_t::is_equal"]
        [::std::mem::offset_of!(_cef_value_t, is_equal) - 72usize];
    ["Offset of field: _cef_value_t::copy"][::std::mem::offset_of!(_cef_value_t, copy) - 80usize];
    ["Offset of field: _cef_value_t::get_type"]
        [::std::mem::offset_of!(_cef_value_t, get_type) - 88usize];
    ["Offset of field: _cef_value_t::get_bool"]
        [::std::mem::offset_of!(_cef_value_t, get_bool) - 96usize];
    ["Offset of field: _cef_value_t::get_int"]
        [::std::mem::offset_of!(_cef_value_t, get_int) - 104usize];
    ["Offset of field: _cef_value_t::get_double"]
        [::std::mem::offset_of!(_cef_value_t, get_double) - 112usize];
    ["Offset of field: _cef_value_t::get_string"]
        [::std::mem::offset_of!(_cef_value_t, get_string) - 120usize];
    ["Offset of field: _cef_value_t::get_binary"]
        [::std::mem::offset_of!(_cef_value_t, get_binary) - 128usize];
    ["Offset of field: _cef_value_t::get_dictionary"]
        [::std::mem::offset_of!(_cef_value_t, get_dictionary) - 136usize];
    ["Offset of field: _cef_value_t::get_list"]
        [::std::mem::offset_of!(_cef_value_t, get_list) - 144usize];
    ["Offset of field: _cef_value_t::set_null"]
        [::std::mem::offset_of!(_cef_value_t, set_null) - 152usize];
    ["Offset of field: _cef_value_t::set_bool"]
        [::std::mem::offset_of!(_cef_value_t, set_bool) - 160usize];
    ["Offset of field: _cef_value_t::set_int"]
        [::std::mem::offset_of!(_cef_value_t, set_int) - 168usize];
    ["Offset of field: _cef_value_t::set_double"]
        [::std::mem::offset_of!(_cef_value_t, set_double) - 176usize];
    ["Offset of field: _cef_value_t::set_string"]
        [::std::mem::offset_of!(_cef_value_t, set_string) - 184usize];
    ["Offset of field: _cef_value_t::set_binary"]
        [::std::mem::offset_of!(_cef_value_t, set_binary) - 192usize];
    ["Offset of field: _cef_value_t::set_dictionary"]
        [::std::mem::offset_of!(_cef_value_t, set_dictionary) - 200usize];
    ["Offset of field: _cef_value_t::set_list"]
        [::std::mem::offset_of!(_cef_value_t, set_list) - 208usize];
};
#[doc = "\n Structure that wraps other data value types. Complex types (binary,\n dictionary and list) will be referenced but not owned by this object. Can be\n used on any process and thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_value_t = _cef_value_t;
unsafe extern "C" {
    #[doc = "\n Creates a new object.\n"]
    pub fn cef_value_create() -> *mut cef_value_t;
}
#[doc = "\n Structure representing a binary value. Can be used on any process and\n thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_binary_value_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is valid. This object may become invalid\n if the underlying data is owned by another object (e.g. list or\n dictionary) and that other object is then modified or destroyed. Do not\n call any other functions if this function returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_binary_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object is currently owned by another object.\n"]
    pub is_owned: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_binary_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object and |that| object have the same underlying\n data.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_binary_value_t,
            that: *mut _cef_binary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object and |that| object have an equivalent\n underlying value but are not necessarily the same object.\n"]
    pub is_equal: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_binary_value_t,
            that: *mut _cef_binary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns a copy of this object. The data in this object will also be\n copied.\n"]
    pub copy: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_binary_value_t) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns a pointer to the beginning of the memory block. The returned\n pointer is valid as long as the cef_binary_value_t is alive.\n"]
    pub get_raw_data: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_binary_value_t) -> *const ::std::os::raw::c_void,
    >,
    #[doc = "\n Returns the data size.\n"]
    pub get_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_binary_value_t) -> usize>,
    #[doc = "\n Read up to |buffer_size| number of bytes into |buffer|. Reading begins at\n the specified byte |data_offset|. Returns the number of bytes read.\n"]
    pub get_data: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_binary_value_t,
            buffer: *mut ::std::os::raw::c_void,
            buffer_size: usize,
            data_offset: usize,
        ) -> usize,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_binary_value_t"][::std::mem::size_of::<_cef_binary_value_t>() - 104usize];
    ["Alignment of _cef_binary_value_t"][::std::mem::align_of::<_cef_binary_value_t>() - 8usize];
    ["Offset of field: _cef_binary_value_t::base"]
        [::std::mem::offset_of!(_cef_binary_value_t, base) - 0usize];
    ["Offset of field: _cef_binary_value_t::is_valid"]
        [::std::mem::offset_of!(_cef_binary_value_t, is_valid) - 40usize];
    ["Offset of field: _cef_binary_value_t::is_owned"]
        [::std::mem::offset_of!(_cef_binary_value_t, is_owned) - 48usize];
    ["Offset of field: _cef_binary_value_t::is_same"]
        [::std::mem::offset_of!(_cef_binary_value_t, is_same) - 56usize];
    ["Offset of field: _cef_binary_value_t::is_equal"]
        [::std::mem::offset_of!(_cef_binary_value_t, is_equal) - 64usize];
    ["Offset of field: _cef_binary_value_t::copy"]
        [::std::mem::offset_of!(_cef_binary_value_t, copy) - 72usize];
    ["Offset of field: _cef_binary_value_t::get_raw_data"]
        [::std::mem::offset_of!(_cef_binary_value_t, get_raw_data) - 80usize];
    ["Offset of field: _cef_binary_value_t::get_size"]
        [::std::mem::offset_of!(_cef_binary_value_t, get_size) - 88usize];
    ["Offset of field: _cef_binary_value_t::get_data"]
        [::std::mem::offset_of!(_cef_binary_value_t, get_data) - 96usize];
};
#[doc = "\n Structure representing a binary value. Can be used on any process and\n thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_binary_value_t = _cef_binary_value_t;
unsafe extern "C" {
    #[doc = "\n Creates a new object that is not owned by any other object. The specified\n |data| will be copied.\n"]
    pub fn cef_binary_value_create(
        data: *const ::std::os::raw::c_void,
        data_size: usize,
    ) -> *mut cef_binary_value_t;
}
#[doc = "\n Structure representing a dictionary value. Can be used on any process and\n thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_dictionary_value_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is valid. This object may become invalid\n if the underlying data is owned by another object (e.g. list or\n dictionary) and that other object is then modified or destroyed. Do not\n call any other functions if this function returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_dictionary_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object is currently owned by another object.\n"]
    pub is_owned: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_dictionary_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the values of this object are read-only. Some APIs may\n expose read-only objects.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_dictionary_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object and |that| object have the same underlying\n data. If true (1) modifications to this object will also affect |that|\n object and vice-versa.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            that: *mut _cef_dictionary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object and |that| object have an equivalent\n underlying value but are not necessarily the same object.\n"]
    pub is_equal: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            that: *mut _cef_dictionary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns a writable copy of this object. If |exclude_NULL_children| is true\n (1) any NULL dictionaries or lists will be excluded from the copy.\n"]
    pub copy: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            exclude_empty_children: ::std::os::raw::c_int,
        ) -> *mut _cef_dictionary_value_t,
    >,
    #[doc = "\n Returns the number of values.\n"]
    pub get_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_dictionary_value_t) -> usize>,
    #[doc = "\n Removes all values. Returns true (1) on success.\n"]
    pub clear: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_dictionary_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the current dictionary has a value for the given key.\n"]
    pub has_key: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Reads all keys for this dictionary into the specified vector.\n"]
    pub get_keys: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            keys: cef_string_list_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Removes the value at the specified key. Returns true (1) is the value was\n removed successfully.\n"]
    pub remove: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value type for the specified key.\n"]
    pub get_type: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> cef_value_type_t,
    >,
    #[doc = "\n Returns the value at the specified key. For simple types the returned\n value will copy existing data and modifications to the value will not\n modify this object. For complex types (binary, dictionary and list) the\n returned value will reference existing data and modifications to the value\n will modify this object.\n"]
    pub get_value: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> *mut _cef_value_t,
    >,
    #[doc = "\n Returns the value at the specified key as type bool.\n"]
    pub get_bool: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value at the specified key as type int.\n"]
    pub get_int: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value at the specified key as type double.\n"]
    pub get_double: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_dictionary_value_t, key: *const cef_string_t) -> f64,
    >,
    #[doc = "\n Returns the value at the specified key as type string.\n"]
    pub get_string: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the value at the specified key as type binary. The returned value\n will reference existing data.\n"]
    pub get_binary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns the value at the specified key as type dictionary. The returned\n value will reference existing data and modifications to the value will\n modify this object.\n"]
    pub get_dictionary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> *mut _cef_dictionary_value_t,
    >,
    #[doc = "\n Returns the value at the specified key as type list. The returned value\n will reference existing data and modifications to the value will modify\n this object.\n"]
    pub get_list: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> *mut _cef_list_value_t,
    >,
    #[doc = "\n Sets the value at the specified key. Returns true (1) if the value was set\n successfully. If |value| represents simple data then the underlying data\n will be copied and modifications to |value| will not modify this object.\n If |value| represents complex data (binary, dictionary or list) then the\n underlying data will be referenced and modifications to |value| will\n modify this object.\n"]
    pub set_value: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
            value: *mut _cef_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified key as type null. Returns true (1) if the\n value was set successfully.\n"]
    pub set_null: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified key as type bool. Returns true (1) if the\n value was set successfully.\n"]
    pub set_bool: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
            value: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified key as type int. Returns true (1) if the\n value was set successfully.\n"]
    pub set_int: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
            value: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified key as type double. Returns true (1) if\n the value was set successfully.\n"]
    pub set_double: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
            value: f64,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified key as type string. Returns true (1) if\n the value was set successfully.\n"]
    pub set_string: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
            value: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified key as type binary. Returns true (1) if\n the value was set successfully. If |value| is currently owned by another\n object then the value will be copied and the |value| reference will not\n change. Otherwise, ownership will be transferred to this object and the\n |value| reference will be invalidated.\n"]
    pub set_binary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
            value: *mut _cef_binary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified key as type dict. Returns true (1) if the\n value was set successfully. If |value| is currently owned by another\n object then the value will be copied and the |value| reference will not\n change. Otherwise, ownership will be transferred to this object and the\n |value| reference will be invalidated.\n"]
    pub set_dictionary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
            value: *mut _cef_dictionary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified key as type list. Returns true (1) if the\n value was set successfully. If |value| is currently owned by another\n object then the value will be copied and the |value| reference will not\n change. Otherwise, ownership will be transferred to this object and the\n |value| reference will be invalidated.\n"]
    pub set_list: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dictionary_value_t,
            key: *const cef_string_t,
            value: *mut _cef_list_value_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_dictionary_value_t"]
        [::std::mem::size_of::<_cef_dictionary_value_t>() - 272usize];
    ["Alignment of _cef_dictionary_value_t"]
        [::std::mem::align_of::<_cef_dictionary_value_t>() - 8usize];
    ["Offset of field: _cef_dictionary_value_t::base"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, base) - 0usize];
    ["Offset of field: _cef_dictionary_value_t::is_valid"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, is_valid) - 40usize];
    ["Offset of field: _cef_dictionary_value_t::is_owned"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, is_owned) - 48usize];
    ["Offset of field: _cef_dictionary_value_t::is_read_only"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, is_read_only) - 56usize];
    ["Offset of field: _cef_dictionary_value_t::is_same"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, is_same) - 64usize];
    ["Offset of field: _cef_dictionary_value_t::is_equal"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, is_equal) - 72usize];
    ["Offset of field: _cef_dictionary_value_t::copy"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, copy) - 80usize];
    ["Offset of field: _cef_dictionary_value_t::get_size"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_size) - 88usize];
    ["Offset of field: _cef_dictionary_value_t::clear"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, clear) - 96usize];
    ["Offset of field: _cef_dictionary_value_t::has_key"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, has_key) - 104usize];
    ["Offset of field: _cef_dictionary_value_t::get_keys"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_keys) - 112usize];
    ["Offset of field: _cef_dictionary_value_t::remove"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, remove) - 120usize];
    ["Offset of field: _cef_dictionary_value_t::get_type"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_type) - 128usize];
    ["Offset of field: _cef_dictionary_value_t::get_value"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_value) - 136usize];
    ["Offset of field: _cef_dictionary_value_t::get_bool"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_bool) - 144usize];
    ["Offset of field: _cef_dictionary_value_t::get_int"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_int) - 152usize];
    ["Offset of field: _cef_dictionary_value_t::get_double"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_double) - 160usize];
    ["Offset of field: _cef_dictionary_value_t::get_string"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_string) - 168usize];
    ["Offset of field: _cef_dictionary_value_t::get_binary"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_binary) - 176usize];
    ["Offset of field: _cef_dictionary_value_t::get_dictionary"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_dictionary) - 184usize];
    ["Offset of field: _cef_dictionary_value_t::get_list"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, get_list) - 192usize];
    ["Offset of field: _cef_dictionary_value_t::set_value"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_value) - 200usize];
    ["Offset of field: _cef_dictionary_value_t::set_null"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_null) - 208usize];
    ["Offset of field: _cef_dictionary_value_t::set_bool"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_bool) - 216usize];
    ["Offset of field: _cef_dictionary_value_t::set_int"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_int) - 224usize];
    ["Offset of field: _cef_dictionary_value_t::set_double"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_double) - 232usize];
    ["Offset of field: _cef_dictionary_value_t::set_string"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_string) - 240usize];
    ["Offset of field: _cef_dictionary_value_t::set_binary"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_binary) - 248usize];
    ["Offset of field: _cef_dictionary_value_t::set_dictionary"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_dictionary) - 256usize];
    ["Offset of field: _cef_dictionary_value_t::set_list"]
        [::std::mem::offset_of!(_cef_dictionary_value_t, set_list) - 264usize];
};
#[doc = "\n Structure representing a dictionary value. Can be used on any process and\n thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_dictionary_value_t = _cef_dictionary_value_t;
unsafe extern "C" {
    #[doc = "\n Creates a new object that is not owned by any other object.\n"]
    pub fn cef_dictionary_value_create() -> *mut cef_dictionary_value_t;
}
#[doc = "\n Structure representing a list value. Can be used on any process and thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_list_value_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is valid. This object may become invalid\n if the underlying data is owned by another object (e.g. list or\n dictionary) and that other object is then modified or destroyed. Do not\n call any other functions if this function returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object is currently owned by another object.\n"]
    pub is_owned: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the values of this object are read-only. Some APIs may\n expose read-only objects.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object and |that| object have the same underlying\n data. If true (1) modifications to this object will also affect |that|\n object and vice-versa.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            that: *mut _cef_list_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object and |that| object have an equivalent\n underlying value but are not necessarily the same object.\n"]
    pub is_equal: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            that: *mut _cef_list_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns a writable copy of this object.\n"]
    pub copy: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t) -> *mut _cef_list_value_t,
    >,
    #[doc = "\n Sets the number of values. If the number of values is expanded all new\n value slots will default to type null. Returns true (1) on success.\n"]
    pub set_size: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, size: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the number of values.\n"]
    pub get_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_list_value_t) -> usize>,
    #[doc = "\n Removes all values. Returns true (1) on success.\n"]
    pub clear: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Removes the value at the specified index.\n"]
    pub remove: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value type at the specified index.\n"]
    pub get_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> cef_value_type_t,
    >,
    #[doc = "\n Returns the value at the specified index. For simple types the returned\n value will copy existing data and modifications to the value will not\n modify this object. For complex types (binary, dictionary and list) the\n returned value will reference existing data and modifications to the value\n will modify this object.\n"]
    pub get_value: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> *mut _cef_value_t,
    >,
    #[doc = "\n Returns the value at the specified index as type bool.\n"]
    pub get_bool: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value at the specified index as type int.\n"]
    pub get_int: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value at the specified index as type double.\n"]
    pub get_double: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> f64,
    >,
    #[doc = "\n Returns the value at the specified index as type string.\n"]
    pub get_string: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the value at the specified index as type binary. The returned\n value will reference existing data.\n"]
    pub get_binary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
        ) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns the value at the specified index as type dictionary. The returned\n value will reference existing data and modifications to the value will\n modify this object.\n"]
    pub get_dictionary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
        ) -> *mut _cef_dictionary_value_t,
    >,
    #[doc = "\n Returns the value at the specified index as type list. The returned value\n will reference existing data and modifications to the value will modify\n this object.\n"]
    pub get_list: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> *mut _cef_list_value_t,
    >,
    #[doc = "\n Sets the value at the specified index. Returns true (1) if the value was\n set successfully. If |value| represents simple data then the underlying\n data will be copied and modifications to |value| will not modify this\n object. If |value| represents complex data (binary, dictionary or list)\n then the underlying data will be referenced and modifications to |value|\n will modify this object.\n"]
    pub set_value: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
            value: *mut _cef_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified index as type null. Returns true (1) if\n the value was set successfully.\n"]
    pub set_null: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_list_value_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified index as type bool. Returns true (1) if\n the value was set successfully.\n"]
    pub set_bool: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
            value: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified index as type int. Returns true (1) if the\n value was set successfully.\n"]
    pub set_int: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
            value: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified index as type double. Returns true (1) if\n the value was set successfully.\n"]
    pub set_double: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
            value: f64,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified index as type string. Returns true (1) if\n the value was set successfully.\n"]
    pub set_string: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
            value: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified index as type binary. Returns true (1) if\n the value was set successfully. If |value| is currently owned by another\n object then the value will be copied and the |value| reference will not\n change. Otherwise, ownership will be transferred to this object and the\n |value| reference will be invalidated.\n"]
    pub set_binary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
            value: *mut _cef_binary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified index as type dict. Returns true (1) if\n the value was set successfully. If |value| is currently owned by another\n object then the value will be copied and the |value| reference will not\n change. Otherwise, ownership will be transferred to this object and the\n |value| reference will be invalidated.\n"]
    pub set_dictionary: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
            value: *mut _cef_dictionary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the value at the specified index as type list. Returns true (1) if\n the value was set successfully. If |value| is currently owned by another\n object then the value will be copied and the |value| reference will not\n change. Otherwise, ownership will be transferred to this object and the\n |value| reference will be invalidated.\n"]
    pub set_list: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_list_value_t,
            index: usize,
            value: *mut _cef_list_value_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_list_value_t"][::std::mem::size_of::<_cef_list_value_t>() - 264usize];
    ["Alignment of _cef_list_value_t"][::std::mem::align_of::<_cef_list_value_t>() - 8usize];
    ["Offset of field: _cef_list_value_t::base"]
        [::std::mem::offset_of!(_cef_list_value_t, base) - 0usize];
    ["Offset of field: _cef_list_value_t::is_valid"]
        [::std::mem::offset_of!(_cef_list_value_t, is_valid) - 40usize];
    ["Offset of field: _cef_list_value_t::is_owned"]
        [::std::mem::offset_of!(_cef_list_value_t, is_owned) - 48usize];
    ["Offset of field: _cef_list_value_t::is_read_only"]
        [::std::mem::offset_of!(_cef_list_value_t, is_read_only) - 56usize];
    ["Offset of field: _cef_list_value_t::is_same"]
        [::std::mem::offset_of!(_cef_list_value_t, is_same) - 64usize];
    ["Offset of field: _cef_list_value_t::is_equal"]
        [::std::mem::offset_of!(_cef_list_value_t, is_equal) - 72usize];
    ["Offset of field: _cef_list_value_t::copy"]
        [::std::mem::offset_of!(_cef_list_value_t, copy) - 80usize];
    ["Offset of field: _cef_list_value_t::set_size"]
        [::std::mem::offset_of!(_cef_list_value_t, set_size) - 88usize];
    ["Offset of field: _cef_list_value_t::get_size"]
        [::std::mem::offset_of!(_cef_list_value_t, get_size) - 96usize];
    ["Offset of field: _cef_list_value_t::clear"]
        [::std::mem::offset_of!(_cef_list_value_t, clear) - 104usize];
    ["Offset of field: _cef_list_value_t::remove"]
        [::std::mem::offset_of!(_cef_list_value_t, remove) - 112usize];
    ["Offset of field: _cef_list_value_t::get_type"]
        [::std::mem::offset_of!(_cef_list_value_t, get_type) - 120usize];
    ["Offset of field: _cef_list_value_t::get_value"]
        [::std::mem::offset_of!(_cef_list_value_t, get_value) - 128usize];
    ["Offset of field: _cef_list_value_t::get_bool"]
        [::std::mem::offset_of!(_cef_list_value_t, get_bool) - 136usize];
    ["Offset of field: _cef_list_value_t::get_int"]
        [::std::mem::offset_of!(_cef_list_value_t, get_int) - 144usize];
    ["Offset of field: _cef_list_value_t::get_double"]
        [::std::mem::offset_of!(_cef_list_value_t, get_double) - 152usize];
    ["Offset of field: _cef_list_value_t::get_string"]
        [::std::mem::offset_of!(_cef_list_value_t, get_string) - 160usize];
    ["Offset of field: _cef_list_value_t::get_binary"]
        [::std::mem::offset_of!(_cef_list_value_t, get_binary) - 168usize];
    ["Offset of field: _cef_list_value_t::get_dictionary"]
        [::std::mem::offset_of!(_cef_list_value_t, get_dictionary) - 176usize];
    ["Offset of field: _cef_list_value_t::get_list"]
        [::std::mem::offset_of!(_cef_list_value_t, get_list) - 184usize];
    ["Offset of field: _cef_list_value_t::set_value"]
        [::std::mem::offset_of!(_cef_list_value_t, set_value) - 192usize];
    ["Offset of field: _cef_list_value_t::set_null"]
        [::std::mem::offset_of!(_cef_list_value_t, set_null) - 200usize];
    ["Offset of field: _cef_list_value_t::set_bool"]
        [::std::mem::offset_of!(_cef_list_value_t, set_bool) - 208usize];
    ["Offset of field: _cef_list_value_t::set_int"]
        [::std::mem::offset_of!(_cef_list_value_t, set_int) - 216usize];
    ["Offset of field: _cef_list_value_t::set_double"]
        [::std::mem::offset_of!(_cef_list_value_t, set_double) - 224usize];
    ["Offset of field: _cef_list_value_t::set_string"]
        [::std::mem::offset_of!(_cef_list_value_t, set_string) - 232usize];
    ["Offset of field: _cef_list_value_t::set_binary"]
        [::std::mem::offset_of!(_cef_list_value_t, set_binary) - 240usize];
    ["Offset of field: _cef_list_value_t::set_dictionary"]
        [::std::mem::offset_of!(_cef_list_value_t, set_dictionary) - 248usize];
    ["Offset of field: _cef_list_value_t::set_list"]
        [::std::mem::offset_of!(_cef_list_value_t, set_list) - 256usize];
};
#[doc = "\n Structure representing a list value. Can be used on any process and thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_list_value_t = _cef_list_value_t;
unsafe extern "C" {
    #[doc = "\n Creates a new object that is not owned by any other object.\n"]
    pub fn cef_list_value_create() -> *mut cef_list_value_t;
}
#[doc = "\n Container for a single image represented at different scale factors. All\n image representations should be the same size in density independent pixel\n (DIP) units. For example, if the image at scale factor 1.0 is 100x100 pixels\n then the image at scale factor 2.0 should be 200x200 pixels -- both images\n will display with a DIP size of 100x100 units. The functions of this\n structure can be called on any browser process thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_image_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this Image is NULL.\n"]
    pub is_empty: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_image_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this Image and |that| Image share the same underlying\n storage. Will also return true (1) if both images are NULL.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_image_t,
            that: *mut _cef_image_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add a bitmap image representation for |scale_factor|. Only 32-bit\n RGBA/BGRA formats are supported. |pixel_width| and |pixel_height| are the\n bitmap representation size in pixel coordinates. |pixel_data| is the array\n of pixel data and should be |pixel_width| x |pixel_height| x 4 bytes in\n size. |color_type| and |alpha_type| values specify the pixel format.\n"]
    pub add_bitmap: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_image_t,
            scale_factor: f32,
            pixel_width: ::std::os::raw::c_int,
            pixel_height: ::std::os::raw::c_int,
            color_type: cef_color_type_t,
            alpha_type: cef_alpha_type_t,
            pixel_data: *const ::std::os::raw::c_void,
            pixel_data_size: usize,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add a PNG image representation for |scale_factor|. |png_data| is the image\n data of size |png_data_size|. Any alpha transparency in the PNG data will\n be maintained.\n"]
    pub add_png: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_image_t,
            scale_factor: f32,
            png_data: *const ::std::os::raw::c_void,
            png_data_size: usize,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Create a JPEG image representation for |scale_factor|. |jpeg_data| is the\n image data of size |jpeg_data_size|. The JPEG format does not support\n transparency so the alpha byte will be set to 0xFF for all pixels.\n"]
    pub add_jpeg: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_image_t,
            scale_factor: f32,
            jpeg_data: *const ::std::os::raw::c_void,
            jpeg_data_size: usize,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the image width in density independent pixel (DIP) units.\n"]
    pub get_width: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_image_t) -> usize>,
    #[doc = "\n Returns the image height in density independent pixel (DIP) units.\n"]
    pub get_height: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_image_t) -> usize>,
    #[doc = "\n Returns true (1) if this image contains a representation for\n |scale_factor|.\n"]
    pub has_representation: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_image_t, scale_factor: f32) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Removes the representation for |scale_factor|. Returns true (1) on\n success.\n"]
    pub remove_representation: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_image_t, scale_factor: f32) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns information for the representation that most closely matches\n |scale_factor|. |actual_scale_factor| is the actual scale factor for the\n representation. |pixel_width| and |pixel_height| are the representation\n size in pixel coordinates. Returns true (1) on success.\n"]
    pub get_representation_info: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_image_t,
            scale_factor: f32,
            actual_scale_factor: *mut f32,
            pixel_width: *mut ::std::os::raw::c_int,
            pixel_height: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the bitmap representation that most closely matches\n |scale_factor|. Only 32-bit RGBA/BGRA formats are supported. |color_type|\n and |alpha_type| values specify the desired output pixel format.\n |pixel_width| and |pixel_height| are the output representation size in\n pixel coordinates. Returns a cef_binary_value_t containing the pixel data\n on success or NULL on failure.\n"]
    pub get_as_bitmap: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_image_t,
            scale_factor: f32,
            color_type: cef_color_type_t,
            alpha_type: cef_alpha_type_t,
            pixel_width: *mut ::std::os::raw::c_int,
            pixel_height: *mut ::std::os::raw::c_int,
        ) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns the PNG representation that most closely matches |scale_factor|.\n If |with_transparency| is true (1) any alpha transparency in the image\n will be represented in the resulting PNG data. |pixel_width| and\n |pixel_height| are the output representation size in pixel coordinates.\n Returns a cef_binary_value_t containing the PNG image data on success or\n NULL on failure.\n"]
    pub get_as_png: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_image_t,
            scale_factor: f32,
            with_transparency: ::std::os::raw::c_int,
            pixel_width: *mut ::std::os::raw::c_int,
            pixel_height: *mut ::std::os::raw::c_int,
        ) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns the JPEG representation that most closely matches |scale_factor|.\n |quality| determines the compression level with 0 == lowest and 100 ==\n highest. The JPEG format does not support alpha transparency and the alpha\n channel, if any, will be discarded. |pixel_width| and |pixel_height| are\n the output representation size in pixel coordinates. Returns a\n cef_binary_value_t containing the JPEG image data on success or NULL on\n failure.\n"]
    pub get_as_jpeg: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_image_t,
            scale_factor: f32,
            quality: ::std::os::raw::c_int,
            pixel_width: *mut ::std::os::raw::c_int,
            pixel_height: *mut ::std::os::raw::c_int,
        ) -> *mut _cef_binary_value_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_image_t"][::std::mem::size_of::<_cef_image_t>() - 144usize];
    ["Alignment of _cef_image_t"][::std::mem::align_of::<_cef_image_t>() - 8usize];
    ["Offset of field: _cef_image_t::base"][::std::mem::offset_of!(_cef_image_t, base) - 0usize];
    ["Offset of field: _cef_image_t::is_empty"]
        [::std::mem::offset_of!(_cef_image_t, is_empty) - 40usize];
    ["Offset of field: _cef_image_t::is_same"]
        [::std::mem::offset_of!(_cef_image_t, is_same) - 48usize];
    ["Offset of field: _cef_image_t::add_bitmap"]
        [::std::mem::offset_of!(_cef_image_t, add_bitmap) - 56usize];
    ["Offset of field: _cef_image_t::add_png"]
        [::std::mem::offset_of!(_cef_image_t, add_png) - 64usize];
    ["Offset of field: _cef_image_t::add_jpeg"]
        [::std::mem::offset_of!(_cef_image_t, add_jpeg) - 72usize];
    ["Offset of field: _cef_image_t::get_width"]
        [::std::mem::offset_of!(_cef_image_t, get_width) - 80usize];
    ["Offset of field: _cef_image_t::get_height"]
        [::std::mem::offset_of!(_cef_image_t, get_height) - 88usize];
    ["Offset of field: _cef_image_t::has_representation"]
        [::std::mem::offset_of!(_cef_image_t, has_representation) - 96usize];
    ["Offset of field: _cef_image_t::remove_representation"]
        [::std::mem::offset_of!(_cef_image_t, remove_representation) - 104usize];
    ["Offset of field: _cef_image_t::get_representation_info"]
        [::std::mem::offset_of!(_cef_image_t, get_representation_info) - 112usize];
    ["Offset of field: _cef_image_t::get_as_bitmap"]
        [::std::mem::offset_of!(_cef_image_t, get_as_bitmap) - 120usize];
    ["Offset of field: _cef_image_t::get_as_png"]
        [::std::mem::offset_of!(_cef_image_t, get_as_png) - 128usize];
    ["Offset of field: _cef_image_t::get_as_jpeg"]
        [::std::mem::offset_of!(_cef_image_t, get_as_jpeg) - 136usize];
};
#[doc = "\n Container for a single image represented at different scale factors. All\n image representations should be the same size in density independent pixel\n (DIP) units. For example, if the image at scale factor 1.0 is 100x100 pixels\n then the image at scale factor 2.0 should be 200x200 pixels -- both images\n will display with a DIP size of 100x100 units. The functions of this\n structure can be called on any browser process thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_image_t = _cef_image_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_image_t. It will initially be NULL. Use the Add*()\n functions to add representations at different scale factors.\n"]
    pub fn cef_image_create() -> *mut cef_image_t;
}
#[doc = "\n Structure the client can implement to provide a custom stream reader. The\n functions of this structure may be called on any thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_read_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Read raw binary data.\n"]
    pub read: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_read_handler_t,
            ptr: *mut ::std::os::raw::c_void,
            size: usize,
            n: usize,
        ) -> usize,
    >,
    #[doc = "\n Seek to the specified offset position. |whence| may be any one of\n SEEK_CUR, SEEK_END or SEEK_SET. Return zero on success and non-zero on\n failure.\n"]
    pub seek: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_read_handler_t,
            offset: i64,
            whence: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return the current offset position.\n"]
    pub tell: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_read_handler_t) -> i64>,
    #[doc = "\n Return non-zero if at end of file.\n"]
    pub eof: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_read_handler_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return true (1) if this handler performs work like accessing the file\n system which may block. Used as a hint for determining the thread to\n access the handler from.\n"]
    pub may_block: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_read_handler_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_read_handler_t"][::std::mem::size_of::<_cef_read_handler_t>() - 80usize];
    ["Alignment of _cef_read_handler_t"][::std::mem::align_of::<_cef_read_handler_t>() - 8usize];
    ["Offset of field: _cef_read_handler_t::base"]
        [::std::mem::offset_of!(_cef_read_handler_t, base) - 0usize];
    ["Offset of field: _cef_read_handler_t::read"]
        [::std::mem::offset_of!(_cef_read_handler_t, read) - 40usize];
    ["Offset of field: _cef_read_handler_t::seek"]
        [::std::mem::offset_of!(_cef_read_handler_t, seek) - 48usize];
    ["Offset of field: _cef_read_handler_t::tell"]
        [::std::mem::offset_of!(_cef_read_handler_t, tell) - 56usize];
    ["Offset of field: _cef_read_handler_t::eof"]
        [::std::mem::offset_of!(_cef_read_handler_t, eof) - 64usize];
    ["Offset of field: _cef_read_handler_t::may_block"]
        [::std::mem::offset_of!(_cef_read_handler_t, may_block) - 72usize];
};
#[doc = "\n Structure the client can implement to provide a custom stream reader. The\n functions of this structure may be called on any thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_read_handler_t = _cef_read_handler_t;
#[doc = "\n Structure used to read data from a stream. The functions of this structure\n may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_stream_reader_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Read raw binary data.\n"]
    pub read: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_stream_reader_t,
            ptr: *mut ::std::os::raw::c_void,
            size: usize,
            n: usize,
        ) -> usize,
    >,
    #[doc = "\n Seek to the specified offset position. |whence| may be any one of\n SEEK_CUR, SEEK_END or SEEK_SET. Returns zero on success and non-zero on\n failure.\n"]
    pub seek: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_stream_reader_t,
            offset: i64,
            whence: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return the current offset position.\n"]
    pub tell: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_stream_reader_t) -> i64>,
    #[doc = "\n Return non-zero if at end of file.\n"]
    pub eof: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_stream_reader_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this reader performs work like accessing the file\n system which may block. Used as a hint for determining the thread to\n access the reader from.\n"]
    pub may_block: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_stream_reader_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_stream_reader_t"][::std::mem::size_of::<_cef_stream_reader_t>() - 80usize];
    ["Alignment of _cef_stream_reader_t"][::std::mem::align_of::<_cef_stream_reader_t>() - 8usize];
    ["Offset of field: _cef_stream_reader_t::base"]
        [::std::mem::offset_of!(_cef_stream_reader_t, base) - 0usize];
    ["Offset of field: _cef_stream_reader_t::read"]
        [::std::mem::offset_of!(_cef_stream_reader_t, read) - 40usize];
    ["Offset of field: _cef_stream_reader_t::seek"]
        [::std::mem::offset_of!(_cef_stream_reader_t, seek) - 48usize];
    ["Offset of field: _cef_stream_reader_t::tell"]
        [::std::mem::offset_of!(_cef_stream_reader_t, tell) - 56usize];
    ["Offset of field: _cef_stream_reader_t::eof"]
        [::std::mem::offset_of!(_cef_stream_reader_t, eof) - 64usize];
    ["Offset of field: _cef_stream_reader_t::may_block"]
        [::std::mem::offset_of!(_cef_stream_reader_t, may_block) - 72usize];
};
#[doc = "\n Structure used to read data from a stream. The functions of this structure\n may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_stream_reader_t = _cef_stream_reader_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_stream_reader_t object from a file.\n"]
    pub fn cef_stream_reader_create_for_file(
        fileName: *const cef_string_t,
    ) -> *mut cef_stream_reader_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_stream_reader_t object from data.\n"]
    pub fn cef_stream_reader_create_for_data(
        data: *mut ::std::os::raw::c_void,
        size: usize,
    ) -> *mut cef_stream_reader_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_stream_reader_t object from a custom handler.\n"]
    pub fn cef_stream_reader_create_for_handler(
        handler: *mut cef_read_handler_t,
    ) -> *mut cef_stream_reader_t;
}
#[doc = "\n Structure the client can implement to provide a custom stream writer. The\n functions of this structure may be called on any thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_write_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Write raw binary data.\n"]
    pub write: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_write_handler_t,
            ptr: *const ::std::os::raw::c_void,
            size: usize,
            n: usize,
        ) -> usize,
    >,
    #[doc = "\n Seek to the specified offset position. |whence| may be any one of\n SEEK_CUR, SEEK_END or SEEK_SET. Return zero on success and non-zero on\n failure.\n"]
    pub seek: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_write_handler_t,
            offset: i64,
            whence: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return the current offset position.\n"]
    pub tell: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_write_handler_t) -> i64>,
    #[doc = "\n Flush the stream.\n"]
    pub flush: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_write_handler_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return true (1) if this handler performs work like accessing the file\n system which may block. Used as a hint for determining the thread to\n access the handler from.\n"]
    pub may_block: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_write_handler_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_write_handler_t"][::std::mem::size_of::<_cef_write_handler_t>() - 80usize];
    ["Alignment of _cef_write_handler_t"][::std::mem::align_of::<_cef_write_handler_t>() - 8usize];
    ["Offset of field: _cef_write_handler_t::base"]
        [::std::mem::offset_of!(_cef_write_handler_t, base) - 0usize];
    ["Offset of field: _cef_write_handler_t::write"]
        [::std::mem::offset_of!(_cef_write_handler_t, write) - 40usize];
    ["Offset of field: _cef_write_handler_t::seek"]
        [::std::mem::offset_of!(_cef_write_handler_t, seek) - 48usize];
    ["Offset of field: _cef_write_handler_t::tell"]
        [::std::mem::offset_of!(_cef_write_handler_t, tell) - 56usize];
    ["Offset of field: _cef_write_handler_t::flush"]
        [::std::mem::offset_of!(_cef_write_handler_t, flush) - 64usize];
    ["Offset of field: _cef_write_handler_t::may_block"]
        [::std::mem::offset_of!(_cef_write_handler_t, may_block) - 72usize];
};
#[doc = "\n Structure the client can implement to provide a custom stream writer. The\n functions of this structure may be called on any thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_write_handler_t = _cef_write_handler_t;
#[doc = "\n Structure used to write data to a stream. The functions of this structure\n may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_stream_writer_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Write raw binary data.\n"]
    pub write: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_stream_writer_t,
            ptr: *const ::std::os::raw::c_void,
            size: usize,
            n: usize,
        ) -> usize,
    >,
    #[doc = "\n Seek to the specified offset position. |whence| may be any one of\n SEEK_CUR, SEEK_END or SEEK_SET. Returns zero on success and non-zero on\n failure.\n"]
    pub seek: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_stream_writer_t,
            offset: i64,
            whence: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return the current offset position.\n"]
    pub tell: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_stream_writer_t) -> i64>,
    #[doc = "\n Flush the stream.\n"]
    pub flush: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_stream_writer_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this writer performs work like accessing the file\n system which may block. Used as a hint for determining the thread to\n access the writer from.\n"]
    pub may_block: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_stream_writer_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_stream_writer_t"][::std::mem::size_of::<_cef_stream_writer_t>() - 80usize];
    ["Alignment of _cef_stream_writer_t"][::std::mem::align_of::<_cef_stream_writer_t>() - 8usize];
    ["Offset of field: _cef_stream_writer_t::base"]
        [::std::mem::offset_of!(_cef_stream_writer_t, base) - 0usize];
    ["Offset of field: _cef_stream_writer_t::write"]
        [::std::mem::offset_of!(_cef_stream_writer_t, write) - 40usize];
    ["Offset of field: _cef_stream_writer_t::seek"]
        [::std::mem::offset_of!(_cef_stream_writer_t, seek) - 48usize];
    ["Offset of field: _cef_stream_writer_t::tell"]
        [::std::mem::offset_of!(_cef_stream_writer_t, tell) - 56usize];
    ["Offset of field: _cef_stream_writer_t::flush"]
        [::std::mem::offset_of!(_cef_stream_writer_t, flush) - 64usize];
    ["Offset of field: _cef_stream_writer_t::may_block"]
        [::std::mem::offset_of!(_cef_stream_writer_t, may_block) - 72usize];
};
#[doc = "\n Structure used to write data to a stream. The functions of this structure\n may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_stream_writer_t = _cef_stream_writer_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_stream_writer_t object for a file.\n"]
    pub fn cef_stream_writer_create_for_file(
        fileName: *const cef_string_t,
    ) -> *mut cef_stream_writer_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_stream_writer_t object for a custom handler.\n"]
    pub fn cef_stream_writer_create_for_handler(
        handler: *mut cef_write_handler_t,
    ) -> *mut cef_stream_writer_t;
}
#[doc = "\n Structure used to represent drag data. The functions of this structure may\n be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_drag_data_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns a copy of the current object.\n"]
    pub clone: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> *mut _cef_drag_data_t,
    >,
    #[doc = "\n Returns true (1) if this object is read-only.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the drag data is a link.\n"]
    pub is_link: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the drag data is a text or html fragment.\n"]
    pub is_fragment: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the drag data is a file.\n"]
    pub is_file: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return the link URL that is being dragged.\n"]
    pub get_link_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Return the title associated with the link being dragged.\n"]
    pub get_link_title: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Return the metadata, if any, associated with the link being dragged.\n"]
    pub get_link_metadata: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Return the plain text fragment that is being dragged.\n"]
    pub get_fragment_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Return the text/html fragment that is being dragged.\n"]
    pub get_fragment_html: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Return the base URL that the fragment came from. This value is used for\n resolving relative URLs and may be NULL.\n"]
    pub get_fragment_base_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Return the name of the file being dragged out of the browser window.\n"]
    pub get_file_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Write the contents of the file being dragged out of the web view into\n |writer|. Returns the number of bytes sent to |writer|. If |writer| is\n NULL this function will return the size of the file contents in bytes.\n Call get_file_name() to get a suggested name for the file.\n"]
    pub get_file_contents: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_drag_data_t,
            writer: *mut _cef_stream_writer_t,
        ) -> usize,
    >,
    #[doc = "\n Retrieve the list of file names that are being dragged into the browser\n window.\n"]
    pub get_file_names: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_drag_data_t,
            names: cef_string_list_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Retrieve the list of file paths that are being dragged into the browser\n window.\n"]
    pub get_file_paths: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_drag_data_t,
            paths: cef_string_list_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the link URL that is being dragged.\n"]
    pub set_link_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t, url: *const cef_string_t),
    >,
    #[doc = "\n Set the title associated with the link being dragged.\n"]
    pub set_link_title: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t, title: *const cef_string_t),
    >,
    #[doc = "\n Set the metadata associated with the link being dragged.\n"]
    pub set_link_metadata: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t, data: *const cef_string_t),
    >,
    #[doc = "\n Set the plain text fragment that is being dragged.\n"]
    pub set_fragment_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t, text: *const cef_string_t),
    >,
    #[doc = "\n Set the text/html fragment that is being dragged.\n"]
    pub set_fragment_html: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t, html: *const cef_string_t),
    >,
    #[doc = "\n Set the base URL that the fragment came from.\n"]
    pub set_fragment_base_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t, base_url: *const cef_string_t),
    >,
    #[doc = "\n Reset the file contents. You should do this before calling\n cef_browser_host_t::DragTargetDragEnter as the web view does not allow us\n to drag in this kind of data.\n"]
    pub reset_file_contents:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_drag_data_t)>,
    #[doc = "\n Add a file that is being dragged into the webview.\n"]
    pub add_file: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_drag_data_t,
            path: *const cef_string_t,
            display_name: *const cef_string_t,
        ),
    >,
    #[doc = "\n Clear list of filenames.\n"]
    pub clear_filenames: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_drag_data_t)>,
    #[doc = "\n Get the image representation of drag data. May return NULL if no image\n representation is available.\n"]
    pub get_image: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> *mut _cef_image_t,
    >,
    #[doc = "\n Get the image hotspot (drag start location relative to image dimensions).\n"]
    pub get_image_hotspot:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> cef_point_t>,
    #[doc = "\n Returns true (1) if an image representation of drag data is available.\n"]
    pub has_image: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_drag_data_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_drag_data_t"][::std::mem::size_of::<_cef_drag_data_t>() - 256usize];
    ["Alignment of _cef_drag_data_t"][::std::mem::align_of::<_cef_drag_data_t>() - 8usize];
    ["Offset of field: _cef_drag_data_t::base"]
        [::std::mem::offset_of!(_cef_drag_data_t, base) - 0usize];
    ["Offset of field: _cef_drag_data_t::clone"]
        [::std::mem::offset_of!(_cef_drag_data_t, clone) - 40usize];
    ["Offset of field: _cef_drag_data_t::is_read_only"]
        [::std::mem::offset_of!(_cef_drag_data_t, is_read_only) - 48usize];
    ["Offset of field: _cef_drag_data_t::is_link"]
        [::std::mem::offset_of!(_cef_drag_data_t, is_link) - 56usize];
    ["Offset of field: _cef_drag_data_t::is_fragment"]
        [::std::mem::offset_of!(_cef_drag_data_t, is_fragment) - 64usize];
    ["Offset of field: _cef_drag_data_t::is_file"]
        [::std::mem::offset_of!(_cef_drag_data_t, is_file) - 72usize];
    ["Offset of field: _cef_drag_data_t::get_link_url"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_link_url) - 80usize];
    ["Offset of field: _cef_drag_data_t::get_link_title"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_link_title) - 88usize];
    ["Offset of field: _cef_drag_data_t::get_link_metadata"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_link_metadata) - 96usize];
    ["Offset of field: _cef_drag_data_t::get_fragment_text"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_fragment_text) - 104usize];
    ["Offset of field: _cef_drag_data_t::get_fragment_html"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_fragment_html) - 112usize];
    ["Offset of field: _cef_drag_data_t::get_fragment_base_url"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_fragment_base_url) - 120usize];
    ["Offset of field: _cef_drag_data_t::get_file_name"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_file_name) - 128usize];
    ["Offset of field: _cef_drag_data_t::get_file_contents"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_file_contents) - 136usize];
    ["Offset of field: _cef_drag_data_t::get_file_names"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_file_names) - 144usize];
    ["Offset of field: _cef_drag_data_t::get_file_paths"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_file_paths) - 152usize];
    ["Offset of field: _cef_drag_data_t::set_link_url"]
        [::std::mem::offset_of!(_cef_drag_data_t, set_link_url) - 160usize];
    ["Offset of field: _cef_drag_data_t::set_link_title"]
        [::std::mem::offset_of!(_cef_drag_data_t, set_link_title) - 168usize];
    ["Offset of field: _cef_drag_data_t::set_link_metadata"]
        [::std::mem::offset_of!(_cef_drag_data_t, set_link_metadata) - 176usize];
    ["Offset of field: _cef_drag_data_t::set_fragment_text"]
        [::std::mem::offset_of!(_cef_drag_data_t, set_fragment_text) - 184usize];
    ["Offset of field: _cef_drag_data_t::set_fragment_html"]
        [::std::mem::offset_of!(_cef_drag_data_t, set_fragment_html) - 192usize];
    ["Offset of field: _cef_drag_data_t::set_fragment_base_url"]
        [::std::mem::offset_of!(_cef_drag_data_t, set_fragment_base_url) - 200usize];
    ["Offset of field: _cef_drag_data_t::reset_file_contents"]
        [::std::mem::offset_of!(_cef_drag_data_t, reset_file_contents) - 208usize];
    ["Offset of field: _cef_drag_data_t::add_file"]
        [::std::mem::offset_of!(_cef_drag_data_t, add_file) - 216usize];
    ["Offset of field: _cef_drag_data_t::clear_filenames"]
        [::std::mem::offset_of!(_cef_drag_data_t, clear_filenames) - 224usize];
    ["Offset of field: _cef_drag_data_t::get_image"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_image) - 232usize];
    ["Offset of field: _cef_drag_data_t::get_image_hotspot"]
        [::std::mem::offset_of!(_cef_drag_data_t, get_image_hotspot) - 240usize];
    ["Offset of field: _cef_drag_data_t::has_image"]
        [::std::mem::offset_of!(_cef_drag_data_t, has_image) - 248usize];
};
#[doc = "\n Structure used to represent drag data. The functions of this structure may\n be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_drag_data_t = _cef_drag_data_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_drag_data_t object.\n"]
    pub fn cef_drag_data_create() -> *mut cef_drag_data_t;
}
#[doc = "\n Structure to implement for visiting the DOM. The functions of this structure\n will be called on the render process main thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_domvisitor_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method executed for visiting the DOM. The document object passed to this\n function represents a snapshot of the DOM at the time this function is\n executed. DOM objects are only valid for the scope of this function. Do\n not keep references to or attempt to access any DOM objects outside the\n scope of this function.\n"]
    pub visit: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domvisitor_t, document: *mut _cef_domdocument_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_domvisitor_t"][::std::mem::size_of::<_cef_domvisitor_t>() - 48usize];
    ["Alignment of _cef_domvisitor_t"][::std::mem::align_of::<_cef_domvisitor_t>() - 8usize];
    ["Offset of field: _cef_domvisitor_t::base"]
        [::std::mem::offset_of!(_cef_domvisitor_t, base) - 0usize];
    ["Offset of field: _cef_domvisitor_t::visit"]
        [::std::mem::offset_of!(_cef_domvisitor_t, visit) - 40usize];
};
#[doc = "\n Structure to implement for visiting the DOM. The functions of this structure\n will be called on the render process main thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_domvisitor_t = _cef_domvisitor_t;
#[doc = "\n Structure used to represent a DOM document. The functions of this structure\n should only be called on the render process main thread thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_domdocument_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the document type.\n"]
    pub get_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> cef_dom_document_type_t,
    >,
    #[doc = "\n Returns the root document node.\n"]
    pub get_document: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns the BODY node of an HTML document.\n"]
    pub get_body: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns the HEAD node of an HTML document.\n"]
    pub get_head: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns the title of an HTML document.\n"]
    pub get_title: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the document element with the specified ID value.\n"]
    pub get_element_by_id: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_domdocument_t,
            id: *const cef_string_t,
        ) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns the node that currently has keyboard focus.\n"]
    pub get_focused_node: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns true (1) if a portion of the document is selected.\n"]
    pub has_selection: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the selection offset within the start node.\n"]
    pub get_selection_start_offset: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the selection offset within the end node.\n"]
    pub get_selection_end_offset: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the contents of this selection as markup.\n"]
    pub get_selection_as_markup: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the contents of this selection as text.\n"]
    pub get_selection_as_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the base URL for the document.\n"]
    pub get_base_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domdocument_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns a complete URL based on the document base URL and the specified\n partial URL.\n"]
    pub get_complete_url: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_domdocument_t,
            partialURL: *const cef_string_t,
        ) -> cef_string_userfree_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_domdocument_t"][::std::mem::size_of::<_cef_domdocument_t>() - 152usize];
    ["Alignment of _cef_domdocument_t"][::std::mem::align_of::<_cef_domdocument_t>() - 8usize];
    ["Offset of field: _cef_domdocument_t::base"]
        [::std::mem::offset_of!(_cef_domdocument_t, base) - 0usize];
    ["Offset of field: _cef_domdocument_t::get_type"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_type) - 40usize];
    ["Offset of field: _cef_domdocument_t::get_document"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_document) - 48usize];
    ["Offset of field: _cef_domdocument_t::get_body"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_body) - 56usize];
    ["Offset of field: _cef_domdocument_t::get_head"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_head) - 64usize];
    ["Offset of field: _cef_domdocument_t::get_title"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_title) - 72usize];
    ["Offset of field: _cef_domdocument_t::get_element_by_id"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_element_by_id) - 80usize];
    ["Offset of field: _cef_domdocument_t::get_focused_node"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_focused_node) - 88usize];
    ["Offset of field: _cef_domdocument_t::has_selection"]
        [::std::mem::offset_of!(_cef_domdocument_t, has_selection) - 96usize];
    ["Offset of field: _cef_domdocument_t::get_selection_start_offset"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_selection_start_offset) - 104usize];
    ["Offset of field: _cef_domdocument_t::get_selection_end_offset"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_selection_end_offset) - 112usize];
    ["Offset of field: _cef_domdocument_t::get_selection_as_markup"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_selection_as_markup) - 120usize];
    ["Offset of field: _cef_domdocument_t::get_selection_as_text"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_selection_as_text) - 128usize];
    ["Offset of field: _cef_domdocument_t::get_base_url"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_base_url) - 136usize];
    ["Offset of field: _cef_domdocument_t::get_complete_url"]
        [::std::mem::offset_of!(_cef_domdocument_t, get_complete_url) - 144usize];
};
#[doc = "\n Structure used to represent a DOM document. The functions of this structure\n should only be called on the render process main thread thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_domdocument_t = _cef_domdocument_t;
#[doc = "\n Structure used to represent a DOM node. The functions of this structure\n should only be called on the render process main thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_domnode_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the type for this node.\n"]
    pub get_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> cef_dom_node_type_t,
    >,
    #[doc = "\n Returns true (1) if this is a text node.\n"]
    pub is_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this is an element node.\n"]
    pub is_element: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this is an editable node.\n"]
    pub is_editable: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this is a form control element node.\n"]
    pub is_form_control_element: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the type of this form control element node.\n"]
    pub get_form_control_element_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> cef_dom_form_control_type_t,
    >,
    #[doc = "\n Returns true (1) if this object is pointing to the same handle as |that|\n object.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_domnode_t,
            that: *mut _cef_domnode_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the name of this node.\n"]
    pub get_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the value of this node.\n"]
    pub get_value: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the value of this node. Returns true (1) on success.\n"]
    pub set_value: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_domnode_t,
            value: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the contents of this node as markup.\n"]
    pub get_as_markup: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the document associated with this node.\n"]
    pub get_document: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> *mut _cef_domdocument_t,
    >,
    #[doc = "\n Returns the parent node.\n"]
    pub get_parent: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns the previous sibling node.\n"]
    pub get_previous_sibling: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns the next sibling node.\n"]
    pub get_next_sibling: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns true (1) if this node has child nodes.\n"]
    pub has_children: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return the first child node.\n"]
    pub get_first_child: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns the last child node.\n"]
    pub get_last_child: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> *mut _cef_domnode_t,
    >,
    #[doc = "\n Returns the tag name of this element.\n"]
    pub get_element_tag_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns true (1) if this element has attributes.\n"]
    pub has_element_attributes: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this element has an attribute named |attrName|.\n"]
    pub has_element_attribute: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_domnode_t,
            attrName: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the element attribute named |attrName|.\n"]
    pub get_element_attribute: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_domnode_t,
            attrName: *const cef_string_t,
        ) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns a map of all element attributes.\n"]
    pub get_element_attributes: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t, attrMap: cef_string_map_t),
    >,
    #[doc = "\n Set the value for the element attribute named |attrName|. Returns true (1)\n on success.\n"]
    pub set_element_attribute: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_domnode_t,
            attrName: *const cef_string_t,
            value: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the inner text of the element.\n"]
    pub get_element_inner_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the bounds of the element in device pixels. Use\n \"window.devicePixelRatio\" to convert to/from CSS pixels.\n"]
    pub get_element_bounds:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_domnode_t) -> cef_rect_t>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_domnode_t"][::std::mem::size_of::<_cef_domnode_t>() - 248usize];
    ["Alignment of _cef_domnode_t"][::std::mem::align_of::<_cef_domnode_t>() - 8usize];
    ["Offset of field: _cef_domnode_t::base"]
        [::std::mem::offset_of!(_cef_domnode_t, base) - 0usize];
    ["Offset of field: _cef_domnode_t::get_type"]
        [::std::mem::offset_of!(_cef_domnode_t, get_type) - 40usize];
    ["Offset of field: _cef_domnode_t::is_text"]
        [::std::mem::offset_of!(_cef_domnode_t, is_text) - 48usize];
    ["Offset of field: _cef_domnode_t::is_element"]
        [::std::mem::offset_of!(_cef_domnode_t, is_element) - 56usize];
    ["Offset of field: _cef_domnode_t::is_editable"]
        [::std::mem::offset_of!(_cef_domnode_t, is_editable) - 64usize];
    ["Offset of field: _cef_domnode_t::is_form_control_element"]
        [::std::mem::offset_of!(_cef_domnode_t, is_form_control_element) - 72usize];
    ["Offset of field: _cef_domnode_t::get_form_control_element_type"]
        [::std::mem::offset_of!(_cef_domnode_t, get_form_control_element_type) - 80usize];
    ["Offset of field: _cef_domnode_t::is_same"]
        [::std::mem::offset_of!(_cef_domnode_t, is_same) - 88usize];
    ["Offset of field: _cef_domnode_t::get_name"]
        [::std::mem::offset_of!(_cef_domnode_t, get_name) - 96usize];
    ["Offset of field: _cef_domnode_t::get_value"]
        [::std::mem::offset_of!(_cef_domnode_t, get_value) - 104usize];
    ["Offset of field: _cef_domnode_t::set_value"]
        [::std::mem::offset_of!(_cef_domnode_t, set_value) - 112usize];
    ["Offset of field: _cef_domnode_t::get_as_markup"]
        [::std::mem::offset_of!(_cef_domnode_t, get_as_markup) - 120usize];
    ["Offset of field: _cef_domnode_t::get_document"]
        [::std::mem::offset_of!(_cef_domnode_t, get_document) - 128usize];
    ["Offset of field: _cef_domnode_t::get_parent"]
        [::std::mem::offset_of!(_cef_domnode_t, get_parent) - 136usize];
    ["Offset of field: _cef_domnode_t::get_previous_sibling"]
        [::std::mem::offset_of!(_cef_domnode_t, get_previous_sibling) - 144usize];
    ["Offset of field: _cef_domnode_t::get_next_sibling"]
        [::std::mem::offset_of!(_cef_domnode_t, get_next_sibling) - 152usize];
    ["Offset of field: _cef_domnode_t::has_children"]
        [::std::mem::offset_of!(_cef_domnode_t, has_children) - 160usize];
    ["Offset of field: _cef_domnode_t::get_first_child"]
        [::std::mem::offset_of!(_cef_domnode_t, get_first_child) - 168usize];
    ["Offset of field: _cef_domnode_t::get_last_child"]
        [::std::mem::offset_of!(_cef_domnode_t, get_last_child) - 176usize];
    ["Offset of field: _cef_domnode_t::get_element_tag_name"]
        [::std::mem::offset_of!(_cef_domnode_t, get_element_tag_name) - 184usize];
    ["Offset of field: _cef_domnode_t::has_element_attributes"]
        [::std::mem::offset_of!(_cef_domnode_t, has_element_attributes) - 192usize];
    ["Offset of field: _cef_domnode_t::has_element_attribute"]
        [::std::mem::offset_of!(_cef_domnode_t, has_element_attribute) - 200usize];
    ["Offset of field: _cef_domnode_t::get_element_attribute"]
        [::std::mem::offset_of!(_cef_domnode_t, get_element_attribute) - 208usize];
    ["Offset of field: _cef_domnode_t::get_element_attributes"]
        [::std::mem::offset_of!(_cef_domnode_t, get_element_attributes) - 216usize];
    ["Offset of field: _cef_domnode_t::set_element_attribute"]
        [::std::mem::offset_of!(_cef_domnode_t, set_element_attribute) - 224usize];
    ["Offset of field: _cef_domnode_t::get_element_inner_text"]
        [::std::mem::offset_of!(_cef_domnode_t, get_element_inner_text) - 232usize];
    ["Offset of field: _cef_domnode_t::get_element_bounds"]
        [::std::mem::offset_of!(_cef_domnode_t, get_element_bounds) - 240usize];
};
#[doc = "\n Structure used to represent a DOM node. The functions of this structure\n should only be called on the render process main thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_domnode_t = _cef_domnode_t;
#[doc = "\n Structure that wraps platform-dependent share memory region mapping.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_shared_memory_region_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if the mapping is valid.\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_shared_memory_region_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the size of the mapping in bytes. Returns 0 for invalid instances.\n"]
    pub size: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_shared_memory_region_t) -> usize,
    >,
    #[doc = "\n Returns the pointer to the memory. Returns nullptr for invalid instances.\n The returned pointer is only valid for the life span of this object.\n"]
    pub memory: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_shared_memory_region_t,
        ) -> *mut ::std::os::raw::c_void,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_shared_memory_region_t"]
        [::std::mem::size_of::<_cef_shared_memory_region_t>() - 64usize];
    ["Alignment of _cef_shared_memory_region_t"]
        [::std::mem::align_of::<_cef_shared_memory_region_t>() - 8usize];
    ["Offset of field: _cef_shared_memory_region_t::base"]
        [::std::mem::offset_of!(_cef_shared_memory_region_t, base) - 0usize];
    ["Offset of field: _cef_shared_memory_region_t::is_valid"]
        [::std::mem::offset_of!(_cef_shared_memory_region_t, is_valid) - 40usize];
    ["Offset of field: _cef_shared_memory_region_t::size"]
        [::std::mem::offset_of!(_cef_shared_memory_region_t, size) - 48usize];
    ["Offset of field: _cef_shared_memory_region_t::memory"]
        [::std::mem::offset_of!(_cef_shared_memory_region_t, memory) - 56usize];
};
#[doc = "\n Structure that wraps platform-dependent share memory region mapping.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_shared_memory_region_t = _cef_shared_memory_region_t;
#[doc = "\n Structure representing a message. Can be used on any process and thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_process_message_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is valid. Do not call any other functions\n if this function returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_process_message_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the values of this object are read-only. Some APIs may\n expose read-only objects.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_process_message_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns a writable copy of this object. Returns nullptr when message\n contains a shared memory region.\n"]
    pub copy: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_process_message_t) -> *mut _cef_process_message_t,
    >,
    #[doc = "\n Returns the message name.\n"]
    pub get_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_process_message_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the list of arguments. Returns nullptr when message contains a\n shared memory region.\n"]
    pub get_argument_list: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_process_message_t) -> *mut _cef_list_value_t,
    >,
    #[doc = "\n Returns the shared memory region. Returns nullptr when message contains an\n argument list.\n"]
    pub get_shared_memory_region: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_process_message_t,
        ) -> *mut _cef_shared_memory_region_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_process_message_t"][::std::mem::size_of::<_cef_process_message_t>() - 88usize];
    ["Alignment of _cef_process_message_t"]
        [::std::mem::align_of::<_cef_process_message_t>() - 8usize];
    ["Offset of field: _cef_process_message_t::base"]
        [::std::mem::offset_of!(_cef_process_message_t, base) - 0usize];
    ["Offset of field: _cef_process_message_t::is_valid"]
        [::std::mem::offset_of!(_cef_process_message_t, is_valid) - 40usize];
    ["Offset of field: _cef_process_message_t::is_read_only"]
        [::std::mem::offset_of!(_cef_process_message_t, is_read_only) - 48usize];
    ["Offset of field: _cef_process_message_t::copy"]
        [::std::mem::offset_of!(_cef_process_message_t, copy) - 56usize];
    ["Offset of field: _cef_process_message_t::get_name"]
        [::std::mem::offset_of!(_cef_process_message_t, get_name) - 64usize];
    ["Offset of field: _cef_process_message_t::get_argument_list"]
        [::std::mem::offset_of!(_cef_process_message_t, get_argument_list) - 72usize];
    ["Offset of field: _cef_process_message_t::get_shared_memory_region"]
        [::std::mem::offset_of!(_cef_process_message_t, get_shared_memory_region) - 80usize];
};
#[doc = "\n Structure representing a message. Can be used on any process and thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_process_message_t = _cef_process_message_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_process_message_t object with the specified name.\n"]
    pub fn cef_process_message_create(name: *const cef_string_t) -> *mut cef_process_message_t;
}
#[doc = "\n Structure used to represent a web request. The functions of this structure\n may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_request_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is read-only.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Get the fully qualified URL.\n"]
    pub get_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the fully qualified URL.\n"]
    pub set_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t, url: *const cef_string_t),
    >,
    #[doc = "\n Get the request function type. The value will default to POST if post data\n is provided and GET otherwise.\n"]
    pub get_method: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the request function type.\n"]
    pub set_method: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t, method: *const cef_string_t),
    >,
    #[doc = "\n Set the referrer URL and policy. If non-NULL the referrer URL must be\n fully qualified with an HTTP or HTTPS scheme component. Any username,\n password or ref component will be removed.\n"]
    pub set_referrer: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_t,
            referrer_url: *const cef_string_t,
            policy: cef_referrer_policy_t,
        ),
    >,
    #[doc = "\n Get the referrer URL.\n"]
    pub get_referrer_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Get the referrer policy.\n"]
    pub get_referrer_policy: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> cef_referrer_policy_t,
    >,
    #[doc = "\n Get the post data.\n"]
    pub get_post_data: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> *mut _cef_post_data_t,
    >,
    #[doc = "\n Set the post data.\n"]
    pub set_post_data: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t, postData: *mut _cef_post_data_t),
    >,
    #[doc = "\n Get the header values. Will not include the Referer value if any.\n"]
    pub get_header_map: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t, headerMap: cef_string_multimap_t),
    >,
    #[doc = "\n Set the header values. If a Referer value exists in the header map it will\n be removed and ignored.\n"]
    pub set_header_map: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t, headerMap: cef_string_multimap_t),
    >,
    #[doc = "\n Returns the first header value for |name| or an NULL string if not found.\n Will not return the Referer value if any. Use GetHeaderMap instead if\n |name| might have multiple values.\n"]
    pub get_header_by_name: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_t,
            name: *const cef_string_t,
        ) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the header |name| to |value|. If |overwrite| is true (1) any existing\n values will be replaced with the new value. If |overwrite| is false (0)\n any existing values will not be overwritten. The Referer value cannot be\n set using this function.\n"]
    pub set_header_by_name: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_t,
            name: *const cef_string_t,
            value: *const cef_string_t,
            overwrite: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Set all values at one time.\n"]
    pub set: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_t,
            url: *const cef_string_t,
            method: *const cef_string_t,
            postData: *mut _cef_post_data_t,
            headerMap: cef_string_multimap_t,
        ),
    >,
    #[doc = "\n Get the flags used in combination with cef_urlrequest_t. See\n cef_urlrequest_flags_t for supported values.\n"]
    pub get_flags: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the flags used in combination with cef_urlrequest_t.  See\n cef_urlrequest_flags_t for supported values.\n"]
    pub set_flags: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t, flags: ::std::os::raw::c_int),
    >,
    #[doc = "\n Get the URL to the first party for cookies used in combination with\n cef_urlrequest_t.\n"]
    pub get_first_party_for_cookies: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the URL to the first party for cookies used in combination with\n cef_urlrequest_t.\n"]
    pub set_first_party_for_cookies: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t, url: *const cef_string_t),
    >,
    #[doc = "\n Get the resource type for this request. Only available in the browser\n process.\n"]
    pub get_resource_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> cef_resource_type_t,
    >,
    #[doc = "\n Get the transition type for this request. Only available in the browser\n process and only applies to requests that represent a main frame or sub-\n frame navigation.\n"]
    pub get_transition_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_t) -> cef_transition_type_t,
    >,
    #[doc = "\n Returns the globally unique identifier for this request or 0 if not\n specified. Can be used by cef_resource_request_handler_t implementations\n in the browser process to track a single request across multiple\n callbacks.\n"]
    pub get_identifier:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_request_t) -> u64>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_request_t"][::std::mem::size_of::<_cef_request_t>() - 216usize];
    ["Alignment of _cef_request_t"][::std::mem::align_of::<_cef_request_t>() - 8usize];
    ["Offset of field: _cef_request_t::base"]
        [::std::mem::offset_of!(_cef_request_t, base) - 0usize];
    ["Offset of field: _cef_request_t::is_read_only"]
        [::std::mem::offset_of!(_cef_request_t, is_read_only) - 40usize];
    ["Offset of field: _cef_request_t::get_url"]
        [::std::mem::offset_of!(_cef_request_t, get_url) - 48usize];
    ["Offset of field: _cef_request_t::set_url"]
        [::std::mem::offset_of!(_cef_request_t, set_url) - 56usize];
    ["Offset of field: _cef_request_t::get_method"]
        [::std::mem::offset_of!(_cef_request_t, get_method) - 64usize];
    ["Offset of field: _cef_request_t::set_method"]
        [::std::mem::offset_of!(_cef_request_t, set_method) - 72usize];
    ["Offset of field: _cef_request_t::set_referrer"]
        [::std::mem::offset_of!(_cef_request_t, set_referrer) - 80usize];
    ["Offset of field: _cef_request_t::get_referrer_url"]
        [::std::mem::offset_of!(_cef_request_t, get_referrer_url) - 88usize];
    ["Offset of field: _cef_request_t::get_referrer_policy"]
        [::std::mem::offset_of!(_cef_request_t, get_referrer_policy) - 96usize];
    ["Offset of field: _cef_request_t::get_post_data"]
        [::std::mem::offset_of!(_cef_request_t, get_post_data) - 104usize];
    ["Offset of field: _cef_request_t::set_post_data"]
        [::std::mem::offset_of!(_cef_request_t, set_post_data) - 112usize];
    ["Offset of field: _cef_request_t::get_header_map"]
        [::std::mem::offset_of!(_cef_request_t, get_header_map) - 120usize];
    ["Offset of field: _cef_request_t::set_header_map"]
        [::std::mem::offset_of!(_cef_request_t, set_header_map) - 128usize];
    ["Offset of field: _cef_request_t::get_header_by_name"]
        [::std::mem::offset_of!(_cef_request_t, get_header_by_name) - 136usize];
    ["Offset of field: _cef_request_t::set_header_by_name"]
        [::std::mem::offset_of!(_cef_request_t, set_header_by_name) - 144usize];
    ["Offset of field: _cef_request_t::set"]
        [::std::mem::offset_of!(_cef_request_t, set) - 152usize];
    ["Offset of field: _cef_request_t::get_flags"]
        [::std::mem::offset_of!(_cef_request_t, get_flags) - 160usize];
    ["Offset of field: _cef_request_t::set_flags"]
        [::std::mem::offset_of!(_cef_request_t, set_flags) - 168usize];
    ["Offset of field: _cef_request_t::get_first_party_for_cookies"]
        [::std::mem::offset_of!(_cef_request_t, get_first_party_for_cookies) - 176usize];
    ["Offset of field: _cef_request_t::set_first_party_for_cookies"]
        [::std::mem::offset_of!(_cef_request_t, set_first_party_for_cookies) - 184usize];
    ["Offset of field: _cef_request_t::get_resource_type"]
        [::std::mem::offset_of!(_cef_request_t, get_resource_type) - 192usize];
    ["Offset of field: _cef_request_t::get_transition_type"]
        [::std::mem::offset_of!(_cef_request_t, get_transition_type) - 200usize];
    ["Offset of field: _cef_request_t::get_identifier"]
        [::std::mem::offset_of!(_cef_request_t, get_identifier) - 208usize];
};
#[doc = "\n Structure used to represent a web request. The functions of this structure\n may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_request_t = _cef_request_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_request_t object.\n"]
    pub fn cef_request_create() -> *mut cef_request_t;
}
#[doc = "\n Structure used to represent post data for a web request. The functions of\n this structure may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_post_data_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is read-only.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_post_data_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the underlying POST data includes elements that are\n not represented by this cef_post_data_t object (for example, multi-part\n file upload data). Modifying cef_post_data_t objects with excluded\n elements may result in the request failing.\n"]
    pub has_excluded_elements: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_post_data_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the number of existing post data elements.\n"]
    pub get_element_count:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_post_data_t) -> usize>,
    #[doc = "\n Retrieve the post data elements.\n"]
    pub get_elements: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_post_data_t,
            elementsCount: *mut usize,
            elements: *mut *mut _cef_post_data_element_t,
        ),
    >,
    #[doc = "\n Remove the specified post data element.  Returns true (1) if the removal\n succeeds.\n"]
    pub remove_element: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_post_data_t,
            element: *mut _cef_post_data_element_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add the specified post data element.  Returns true (1) if the add\n succeeds.\n"]
    pub add_element: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_post_data_t,
            element: *mut _cef_post_data_element_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Remove all existing post data elements.\n"]
    pub remove_elements: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_post_data_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_post_data_t"][::std::mem::size_of::<_cef_post_data_t>() - 96usize];
    ["Alignment of _cef_post_data_t"][::std::mem::align_of::<_cef_post_data_t>() - 8usize];
    ["Offset of field: _cef_post_data_t::base"]
        [::std::mem::offset_of!(_cef_post_data_t, base) - 0usize];
    ["Offset of field: _cef_post_data_t::is_read_only"]
        [::std::mem::offset_of!(_cef_post_data_t, is_read_only) - 40usize];
    ["Offset of field: _cef_post_data_t::has_excluded_elements"]
        [::std::mem::offset_of!(_cef_post_data_t, has_excluded_elements) - 48usize];
    ["Offset of field: _cef_post_data_t::get_element_count"]
        [::std::mem::offset_of!(_cef_post_data_t, get_element_count) - 56usize];
    ["Offset of field: _cef_post_data_t::get_elements"]
        [::std::mem::offset_of!(_cef_post_data_t, get_elements) - 64usize];
    ["Offset of field: _cef_post_data_t::remove_element"]
        [::std::mem::offset_of!(_cef_post_data_t, remove_element) - 72usize];
    ["Offset of field: _cef_post_data_t::add_element"]
        [::std::mem::offset_of!(_cef_post_data_t, add_element) - 80usize];
    ["Offset of field: _cef_post_data_t::remove_elements"]
        [::std::mem::offset_of!(_cef_post_data_t, remove_elements) - 88usize];
};
#[doc = "\n Structure used to represent post data for a web request. The functions of\n this structure may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_post_data_t = _cef_post_data_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_post_data_t object.\n"]
    pub fn cef_post_data_create() -> *mut cef_post_data_t;
}
#[doc = "\n Structure used to represent a single element in the request post data. The\n functions of this structure may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_post_data_element_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is read-only.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_post_data_element_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Remove all contents from the post data element.\n"]
    pub set_to_empty:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_post_data_element_t)>,
    #[doc = "\n The post data element will represent a file.\n"]
    pub set_to_file: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_post_data_element_t, fileName: *const cef_string_t),
    >,
    #[doc = "\n The post data element will represent bytes.  The bytes passed in will be\n copied.\n"]
    pub set_to_bytes: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_post_data_element_t,
            size: usize,
            bytes: *const ::std::os::raw::c_void,
        ),
    >,
    #[doc = "\n Return the type of this post data element.\n"]
    pub get_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_post_data_element_t) -> cef_postdataelement_type_t,
    >,
    #[doc = "\n Return the file name.\n"]
    pub get_file: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_post_data_element_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Return the number of bytes.\n"]
    pub get_bytes_count:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_post_data_element_t) -> usize>,
    #[doc = "\n Read up to |size| bytes into |bytes| and return the number of bytes\n actually read.\n"]
    pub get_bytes: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_post_data_element_t,
            size: usize,
            bytes: *mut ::std::os::raw::c_void,
        ) -> usize,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_post_data_element_t"]
        [::std::mem::size_of::<_cef_post_data_element_t>() - 104usize];
    ["Alignment of _cef_post_data_element_t"]
        [::std::mem::align_of::<_cef_post_data_element_t>() - 8usize];
    ["Offset of field: _cef_post_data_element_t::base"]
        [::std::mem::offset_of!(_cef_post_data_element_t, base) - 0usize];
    ["Offset of field: _cef_post_data_element_t::is_read_only"]
        [::std::mem::offset_of!(_cef_post_data_element_t, is_read_only) - 40usize];
    ["Offset of field: _cef_post_data_element_t::set_to_empty"]
        [::std::mem::offset_of!(_cef_post_data_element_t, set_to_empty) - 48usize];
    ["Offset of field: _cef_post_data_element_t::set_to_file"]
        [::std::mem::offset_of!(_cef_post_data_element_t, set_to_file) - 56usize];
    ["Offset of field: _cef_post_data_element_t::set_to_bytes"]
        [::std::mem::offset_of!(_cef_post_data_element_t, set_to_bytes) - 64usize];
    ["Offset of field: _cef_post_data_element_t::get_type"]
        [::std::mem::offset_of!(_cef_post_data_element_t, get_type) - 72usize];
    ["Offset of field: _cef_post_data_element_t::get_file"]
        [::std::mem::offset_of!(_cef_post_data_element_t, get_file) - 80usize];
    ["Offset of field: _cef_post_data_element_t::get_bytes_count"]
        [::std::mem::offset_of!(_cef_post_data_element_t, get_bytes_count) - 88usize];
    ["Offset of field: _cef_post_data_element_t::get_bytes"]
        [::std::mem::offset_of!(_cef_post_data_element_t, get_bytes) - 96usize];
};
#[doc = "\n Structure used to represent a single element in the request post data. The\n functions of this structure may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_post_data_element_t = _cef_post_data_element_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_post_data_element_t object.\n"]
    pub fn cef_post_data_element_create() -> *mut cef_post_data_element_t;
}
#[doc = "\n Implement this structure to receive string values asynchronously.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_string_visitor_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be executed.\n"]
    pub visit: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_string_visitor_t, string: *const cef_string_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_string_visitor_t"][::std::mem::size_of::<_cef_string_visitor_t>() - 48usize];
    ["Alignment of _cef_string_visitor_t"]
        [::std::mem::align_of::<_cef_string_visitor_t>() - 8usize];
    ["Offset of field: _cef_string_visitor_t::base"]
        [::std::mem::offset_of!(_cef_string_visitor_t, base) - 0usize];
    ["Offset of field: _cef_string_visitor_t::visit"]
        [::std::mem::offset_of!(_cef_string_visitor_t, visit) - 40usize];
};
#[doc = "\n Implement this structure to receive string values asynchronously.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_string_visitor_t = _cef_string_visitor_t;
#[doc = "\n Structure used to represent a frame in the browser window. When used in the\n browser process the functions of this structure may be called on any thread\n unless otherwise indicated in the comments. When used in the render process\n the functions of this structure may only be called on the main thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_frame_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n True if this object is currently attached to a valid frame.\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Execute undo in this frame.\n"]
    pub undo: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Execute redo in this frame.\n"]
    pub redo: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Execute cut in this frame.\n"]
    pub cut: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Execute copy in this frame.\n"]
    pub copy: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Execute paste in this frame.\n"]
    pub paste: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Execute paste and match style in this frame.\n"]
    pub paste_and_match_style:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Execute delete in this frame.\n"]
    pub del: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Execute select all in this frame.\n"]
    pub select_all: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Save this frame's HTML source to a temporary file and open it in the\n default text viewing application. This function can only be called from\n the browser process.\n"]
    pub view_source: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t)>,
    #[doc = "\n Retrieve this frame's HTML source as a string sent to the specified\n visitor.\n"]
    pub get_source: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t, visitor: *mut _cef_string_visitor_t),
    >,
    #[doc = "\n Retrieve this frame's display text as a string sent to the specified\n visitor.\n"]
    pub get_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t, visitor: *mut _cef_string_visitor_t),
    >,
    #[doc = "\n Load the request represented by the |request| object.\n\n WARNING: This function will fail with \"bad IPC message\" reason\n INVALID_INITIATOR_ORIGIN (213) unless you first navigate to the request\n origin using some other mechanism (LoadURL, link click, etc).\n"]
    pub load_request: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t, request: *mut _cef_request_t),
    >,
    #[doc = "\n Load the specified |url|.\n"]
    pub load_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t, url: *const cef_string_t),
    >,
    #[doc = "\n Execute a string of JavaScript code in this frame. The |script_url|\n parameter is the URL where the script in question can be found, if any.\n The renderer may request this URL to show the developer the source of the\n error.  The |start_line| parameter is the base line number to use for\n error reporting.\n"]
    pub execute_java_script: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_frame_t,
            code: *const cef_string_t,
            script_url: *const cef_string_t,
            start_line: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Returns true (1) if this is the main (top-level) frame.\n"]
    pub is_main: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this is the focused frame.\n"]
    pub is_focused: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the name for this frame. If the frame has an assigned name (for\n example, set via the iframe \"name\" attribute) then that value will be\n returned. Otherwise a unique name will be constructed based on the frame\n parent hierarchy. The main (top-level) frame will always have an NULL name\n value.\n"]
    pub get_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the globally unique identifier for this frame or NULL if the\n underlying frame does not yet exist.\n"]
    pub get_identifier: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the parent of this frame or NULL if this is the main (top-level)\n frame.\n"]
    pub get_parent:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_frame_t) -> *mut _cef_frame_t>,
    #[doc = "\n Returns the URL currently loaded in this frame.\n"]
    pub get_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the browser that this frame belongs to.\n"]
    pub get_browser: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t) -> *mut _cef_browser_t,
    >,
    #[doc = "\n Get the V8 context associated with the frame. This function can only be\n called from the render process.\n"]
    pub get_v8_context: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t) -> *mut _cef_v8_context_t,
    >,
    #[doc = "\n Visit the DOM document. This function can only be called from the render\n process.\n"]
    pub visit_dom: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_frame_t, visitor: *mut _cef_domvisitor_t),
    >,
    #[doc = "\n Create a new URL request that will be treated as originating from this\n frame and the associated browser. Use cef_urlrequest_t::Create instead if\n you do not want the request to have this association, in which case it may\n be handled differently (see documentation on that function). A request\n created with this function may only originate from the browser process,\n and will behave as follows:\n   - It may be intercepted by the client via CefResourceRequestHandler or\n     CefSchemeHandlerFactory.\n   - POST data may only contain a single element of type PDE_TYPE_FILE or\n     PDE_TYPE_BYTES.\n\n The |request| object will be marked as read-only after calling this\n function.\n"]
    pub create_urlrequest: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            client: *mut _cef_urlrequest_client_t,
        ) -> *mut _cef_urlrequest_t,
    >,
    #[doc = "\n Send a message to the specified |target_process|. Ownership of the message\n contents will be transferred and the |message| reference will be\n invalidated. Message delivery is not guaranteed in all cases (for example,\n if the browser is closing, navigating, or if the target process crashes).\n Send an ACK message back from the target process if confirmation is\n required.\n"]
    pub send_process_message: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_frame_t,
            target_process: cef_process_id_t,
            message: *mut _cef_process_message_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_frame_t"][::std::mem::size_of::<_cef_frame_t>() - 248usize];
    ["Alignment of _cef_frame_t"][::std::mem::align_of::<_cef_frame_t>() - 8usize];
    ["Offset of field: _cef_frame_t::base"][::std::mem::offset_of!(_cef_frame_t, base) - 0usize];
    ["Offset of field: _cef_frame_t::is_valid"]
        [::std::mem::offset_of!(_cef_frame_t, is_valid) - 40usize];
    ["Offset of field: _cef_frame_t::undo"][::std::mem::offset_of!(_cef_frame_t, undo) - 48usize];
    ["Offset of field: _cef_frame_t::redo"][::std::mem::offset_of!(_cef_frame_t, redo) - 56usize];
    ["Offset of field: _cef_frame_t::cut"][::std::mem::offset_of!(_cef_frame_t, cut) - 64usize];
    ["Offset of field: _cef_frame_t::copy"][::std::mem::offset_of!(_cef_frame_t, copy) - 72usize];
    ["Offset of field: _cef_frame_t::paste"][::std::mem::offset_of!(_cef_frame_t, paste) - 80usize];
    ["Offset of field: _cef_frame_t::paste_and_match_style"]
        [::std::mem::offset_of!(_cef_frame_t, paste_and_match_style) - 88usize];
    ["Offset of field: _cef_frame_t::del"][::std::mem::offset_of!(_cef_frame_t, del) - 96usize];
    ["Offset of field: _cef_frame_t::select_all"]
        [::std::mem::offset_of!(_cef_frame_t, select_all) - 104usize];
    ["Offset of field: _cef_frame_t::view_source"]
        [::std::mem::offset_of!(_cef_frame_t, view_source) - 112usize];
    ["Offset of field: _cef_frame_t::get_source"]
        [::std::mem::offset_of!(_cef_frame_t, get_source) - 120usize];
    ["Offset of field: _cef_frame_t::get_text"]
        [::std::mem::offset_of!(_cef_frame_t, get_text) - 128usize];
    ["Offset of field: _cef_frame_t::load_request"]
        [::std::mem::offset_of!(_cef_frame_t, load_request) - 136usize];
    ["Offset of field: _cef_frame_t::load_url"]
        [::std::mem::offset_of!(_cef_frame_t, load_url) - 144usize];
    ["Offset of field: _cef_frame_t::execute_java_script"]
        [::std::mem::offset_of!(_cef_frame_t, execute_java_script) - 152usize];
    ["Offset of field: _cef_frame_t::is_main"]
        [::std::mem::offset_of!(_cef_frame_t, is_main) - 160usize];
    ["Offset of field: _cef_frame_t::is_focused"]
        [::std::mem::offset_of!(_cef_frame_t, is_focused) - 168usize];
    ["Offset of field: _cef_frame_t::get_name"]
        [::std::mem::offset_of!(_cef_frame_t, get_name) - 176usize];
    ["Offset of field: _cef_frame_t::get_identifier"]
        [::std::mem::offset_of!(_cef_frame_t, get_identifier) - 184usize];
    ["Offset of field: _cef_frame_t::get_parent"]
        [::std::mem::offset_of!(_cef_frame_t, get_parent) - 192usize];
    ["Offset of field: _cef_frame_t::get_url"]
        [::std::mem::offset_of!(_cef_frame_t, get_url) - 200usize];
    ["Offset of field: _cef_frame_t::get_browser"]
        [::std::mem::offset_of!(_cef_frame_t, get_browser) - 208usize];
    ["Offset of field: _cef_frame_t::get_v8_context"]
        [::std::mem::offset_of!(_cef_frame_t, get_v8_context) - 216usize];
    ["Offset of field: _cef_frame_t::visit_dom"]
        [::std::mem::offset_of!(_cef_frame_t, visit_dom) - 224usize];
    ["Offset of field: _cef_frame_t::create_urlrequest"]
        [::std::mem::offset_of!(_cef_frame_t, create_urlrequest) - 232usize];
    ["Offset of field: _cef_frame_t::send_process_message"]
        [::std::mem::offset_of!(_cef_frame_t, send_process_message) - 240usize];
};
#[doc = "\n Structure used to represent a frame in the browser window. When used in the\n browser process the functions of this structure may be called on any thread\n unless otherwise indicated in the comments. When used in the render process\n the functions of this structure may only be called on the main thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_frame_t = _cef_frame_t;
#[doc = "\n Structure representing the issuer or subject field of an X.509 certificate.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_x509_cert_principal_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns a name that can be used to represent the issuer. It tries in this\n order: Common Name (CN), Organization Name (O) and Organizational Unit\n Name (OU) and returns the first non-NULL one found.\n"]
    pub get_display_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_cert_principal_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the common name.\n"]
    pub get_common_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_cert_principal_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the locality name.\n"]
    pub get_locality_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_cert_principal_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the state or province name.\n"]
    pub get_state_or_province_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_cert_principal_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the country name.\n"]
    pub get_country_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_cert_principal_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Retrieve the list of organization names.\n"]
    pub get_organization_names: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_cert_principal_t, names: cef_string_list_t),
    >,
    #[doc = "\n Retrieve the list of organization unit names.\n"]
    pub get_organization_unit_names: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_cert_principal_t, names: cef_string_list_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_x509_cert_principal_t"]
        [::std::mem::size_of::<_cef_x509_cert_principal_t>() - 96usize];
    ["Alignment of _cef_x509_cert_principal_t"]
        [::std::mem::align_of::<_cef_x509_cert_principal_t>() - 8usize];
    ["Offset of field: _cef_x509_cert_principal_t::base"]
        [::std::mem::offset_of!(_cef_x509_cert_principal_t, base) - 0usize];
    ["Offset of field: _cef_x509_cert_principal_t::get_display_name"]
        [::std::mem::offset_of!(_cef_x509_cert_principal_t, get_display_name) - 40usize];
    ["Offset of field: _cef_x509_cert_principal_t::get_common_name"]
        [::std::mem::offset_of!(_cef_x509_cert_principal_t, get_common_name) - 48usize];
    ["Offset of field: _cef_x509_cert_principal_t::get_locality_name"]
        [::std::mem::offset_of!(_cef_x509_cert_principal_t, get_locality_name) - 56usize];
    ["Offset of field: _cef_x509_cert_principal_t::get_state_or_province_name"]
        [::std::mem::offset_of!(_cef_x509_cert_principal_t, get_state_or_province_name) - 64usize];
    ["Offset of field: _cef_x509_cert_principal_t::get_country_name"]
        [::std::mem::offset_of!(_cef_x509_cert_principal_t, get_country_name) - 72usize];
    ["Offset of field: _cef_x509_cert_principal_t::get_organization_names"]
        [::std::mem::offset_of!(_cef_x509_cert_principal_t, get_organization_names) - 80usize];
    ["Offset of field: _cef_x509_cert_principal_t::get_organization_unit_names"]
        [::std::mem::offset_of!(_cef_x509_cert_principal_t, get_organization_unit_names) - 88usize];
};
#[doc = "\n Structure representing the issuer or subject field of an X.509 certificate.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_x509_cert_principal_t = _cef_x509_cert_principal_t;
#[doc = "\n Structure representing a X.509 certificate.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_x509_certificate_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the subject of the X.509 certificate. For HTTPS server\n certificates this represents the web server.  The common name of the\n subject should match the host name of the web server.\n"]
    pub get_subject: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_x509_certificate_t,
        ) -> *mut _cef_x509_cert_principal_t,
    >,
    #[doc = "\n Returns the issuer of the X.509 certificate.\n"]
    pub get_issuer: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_x509_certificate_t,
        ) -> *mut _cef_x509_cert_principal_t,
    >,
    #[doc = "\n Returns the DER encoded serial number for the X.509 certificate. The value\n possibly includes a leading 00 byte.\n"]
    pub get_serial_number: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_certificate_t) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns the date before which the X.509 certificate is invalid.\n CefBaseTime.GetTimeT() will return 0 if no date was specified.\n"]
    pub get_valid_start: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_certificate_t) -> cef_basetime_t,
    >,
    #[doc = "\n Returns the date after which the X.509 certificate is invalid.\n CefBaseTime.GetTimeT() will return 0 if no date was specified.\n"]
    pub get_valid_expiry: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_certificate_t) -> cef_basetime_t,
    >,
    #[doc = "\n Returns the DER encoded data for the X.509 certificate.\n"]
    pub get_derencoded: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_certificate_t) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns the PEM encoded data for the X.509 certificate.\n"]
    pub get_pemencoded: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_x509_certificate_t) -> *mut _cef_binary_value_t,
    >,
    #[doc = "\n Returns the number of certificates in the issuer chain. If 0, the\n certificate is self-signed.\n"]
    pub get_issuer_chain_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_x509_certificate_t) -> usize>,
    #[doc = "\n Returns the DER encoded data for the certificate issuer chain. If we\n failed to encode a certificate in the chain it is still present in the\n array but is an NULL string.\n"]
    pub get_derencoded_issuer_chain: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_x509_certificate_t,
            chainCount: *mut usize,
            chain: *mut *mut _cef_binary_value_t,
        ),
    >,
    #[doc = "\n Returns the PEM encoded data for the certificate issuer chain. If we\n failed to encode a certificate in the chain it is still present in the\n array but is an NULL string.\n"]
    pub get_pemencoded_issuer_chain: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_x509_certificate_t,
            chainCount: *mut usize,
            chain: *mut *mut _cef_binary_value_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_x509_certificate_t"]
        [::std::mem::size_of::<_cef_x509_certificate_t>() - 120usize];
    ["Alignment of _cef_x509_certificate_t"]
        [::std::mem::align_of::<_cef_x509_certificate_t>() - 8usize];
    ["Offset of field: _cef_x509_certificate_t::base"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, base) - 0usize];
    ["Offset of field: _cef_x509_certificate_t::get_subject"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_subject) - 40usize];
    ["Offset of field: _cef_x509_certificate_t::get_issuer"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_issuer) - 48usize];
    ["Offset of field: _cef_x509_certificate_t::get_serial_number"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_serial_number) - 56usize];
    ["Offset of field: _cef_x509_certificate_t::get_valid_start"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_valid_start) - 64usize];
    ["Offset of field: _cef_x509_certificate_t::get_valid_expiry"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_valid_expiry) - 72usize];
    ["Offset of field: _cef_x509_certificate_t::get_derencoded"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_derencoded) - 80usize];
    ["Offset of field: _cef_x509_certificate_t::get_pemencoded"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_pemencoded) - 88usize];
    ["Offset of field: _cef_x509_certificate_t::get_issuer_chain_size"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_issuer_chain_size) - 96usize];
    ["Offset of field: _cef_x509_certificate_t::get_derencoded_issuer_chain"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_derencoded_issuer_chain) - 104usize];
    ["Offset of field: _cef_x509_certificate_t::get_pemencoded_issuer_chain"]
        [::std::mem::offset_of!(_cef_x509_certificate_t, get_pemencoded_issuer_chain) - 112usize];
};
#[doc = "\n Structure representing a X.509 certificate.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_x509_certificate_t = _cef_x509_certificate_t;
#[doc = "\n Structure representing the SSL information for a navigation entry.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_sslstatus_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if the status is related to a secure SSL/TLS connection.\n"]
    pub is_secure_connection: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_sslstatus_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns a bitmask containing any and all problems verifying the server\n certificate.\n"]
    pub get_cert_status: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_sslstatus_t) -> cef_cert_status_t,
    >,
    #[doc = "\n Returns the SSL version used for the SSL connection.\n"]
    pub get_sslversion: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_sslstatus_t) -> cef_ssl_version_t,
    >,
    #[doc = "\n Returns a bitmask containing the page security content status.\n"]
    pub get_content_status: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_sslstatus_t) -> cef_ssl_content_status_t,
    >,
    #[doc = "\n Returns the X.509 certificate.\n"]
    pub get_x509_certificate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_sslstatus_t) -> *mut _cef_x509_certificate_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_sslstatus_t"][::std::mem::size_of::<_cef_sslstatus_t>() - 80usize];
    ["Alignment of _cef_sslstatus_t"][::std::mem::align_of::<_cef_sslstatus_t>() - 8usize];
    ["Offset of field: _cef_sslstatus_t::base"]
        [::std::mem::offset_of!(_cef_sslstatus_t, base) - 0usize];
    ["Offset of field: _cef_sslstatus_t::is_secure_connection"]
        [::std::mem::offset_of!(_cef_sslstatus_t, is_secure_connection) - 40usize];
    ["Offset of field: _cef_sslstatus_t::get_cert_status"]
        [::std::mem::offset_of!(_cef_sslstatus_t, get_cert_status) - 48usize];
    ["Offset of field: _cef_sslstatus_t::get_sslversion"]
        [::std::mem::offset_of!(_cef_sslstatus_t, get_sslversion) - 56usize];
    ["Offset of field: _cef_sslstatus_t::get_content_status"]
        [::std::mem::offset_of!(_cef_sslstatus_t, get_content_status) - 64usize];
    ["Offset of field: _cef_sslstatus_t::get_x509_certificate"]
        [::std::mem::offset_of!(_cef_sslstatus_t, get_x509_certificate) - 72usize];
};
#[doc = "\n Structure representing the SSL information for a navigation entry.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_sslstatus_t = _cef_sslstatus_t;
#[doc = "\n Structure used to represent an entry in navigation history.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_navigation_entry_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is valid. Do not call any other functions\n if this function returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the actual URL of the page. For some pages this may be data: URL\n or similar. Use get_display_url() to return a display-friendly version.\n"]
    pub get_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns a display-friendly version of the URL.\n"]
    pub get_display_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the original URL that was entered by the user before any\n redirects.\n"]
    pub get_original_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the title set by the page. This value may be NULL.\n"]
    pub get_title: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the transition type which indicates what the user did to move to\n this page from the previous page.\n"]
    pub get_transition_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> cef_transition_type_t,
    >,
    #[doc = "\n Returns true (1) if this navigation includes post data.\n"]
    pub has_post_data: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the time for the last known successful navigation completion. A\n navigation may be completed more than once if the page is reloaded. May be\n 0 if the navigation has not yet completed.\n"]
    pub get_completion_time: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> cef_basetime_t,
    >,
    #[doc = "\n Returns the HTTP status code for the last known successful navigation\n response. May be 0 if the response has not yet been received or if the\n navigation has not yet completed.\n"]
    pub get_http_status_code: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the SSL information for this navigation entry.\n"]
    pub get_sslstatus: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_navigation_entry_t) -> *mut _cef_sslstatus_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_navigation_entry_t"]
        [::std::mem::size_of::<_cef_navigation_entry_t>() - 120usize];
    ["Alignment of _cef_navigation_entry_t"]
        [::std::mem::align_of::<_cef_navigation_entry_t>() - 8usize];
    ["Offset of field: _cef_navigation_entry_t::base"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, base) - 0usize];
    ["Offset of field: _cef_navigation_entry_t::is_valid"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, is_valid) - 40usize];
    ["Offset of field: _cef_navigation_entry_t::get_url"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, get_url) - 48usize];
    ["Offset of field: _cef_navigation_entry_t::get_display_url"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, get_display_url) - 56usize];
    ["Offset of field: _cef_navigation_entry_t::get_original_url"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, get_original_url) - 64usize];
    ["Offset of field: _cef_navigation_entry_t::get_title"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, get_title) - 72usize];
    ["Offset of field: _cef_navigation_entry_t::get_transition_type"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, get_transition_type) - 80usize];
    ["Offset of field: _cef_navigation_entry_t::has_post_data"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, has_post_data) - 88usize];
    ["Offset of field: _cef_navigation_entry_t::get_completion_time"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, get_completion_time) - 96usize];
    ["Offset of field: _cef_navigation_entry_t::get_http_status_code"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, get_http_status_code) - 104usize];
    ["Offset of field: _cef_navigation_entry_t::get_sslstatus"]
        [::std::mem::offset_of!(_cef_navigation_entry_t, get_sslstatus) - 112usize];
};
#[doc = "\n Structure used to represent an entry in navigation history.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_navigation_entry_t = _cef_navigation_entry_t;
#[doc = "\n Generic callback structure used for managing the lifespan of a registration.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_registration_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_registration_t"][::std::mem::size_of::<_cef_registration_t>() - 40usize];
    ["Alignment of _cef_registration_t"][::std::mem::align_of::<_cef_registration_t>() - 8usize];
    ["Offset of field: _cef_registration_t::base"]
        [::std::mem::offset_of!(_cef_registration_t, base) - 0usize];
};
#[doc = "\n Generic callback structure used for managing the lifespan of a registration.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_registration_t = _cef_registration_t;
#[doc = "\n Generic callback structure used for asynchronous continuation.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Continue processing.\n"]
    pub cont: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_callback_t)>,
    #[doc = "\n Cancel processing.\n"]
    pub cancel: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_callback_t"][::std::mem::size_of::<_cef_callback_t>() - 56usize];
    ["Alignment of _cef_callback_t"][::std::mem::align_of::<_cef_callback_t>() - 8usize];
    ["Offset of field: _cef_callback_t::base"]
        [::std::mem::offset_of!(_cef_callback_t, base) - 0usize];
    ["Offset of field: _cef_callback_t::cont"]
        [::std::mem::offset_of!(_cef_callback_t, cont) - 40usize];
    ["Offset of field: _cef_callback_t::cancel"]
        [::std::mem::offset_of!(_cef_callback_t, cancel) - 48usize];
};
#[doc = "\n Generic callback structure used for asynchronous continuation.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_callback_t = _cef_callback_t;
#[doc = "\n Generic callback structure used for asynchronous completion.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_completion_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be called once the task is complete.\n"]
    pub on_complete:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_completion_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_completion_callback_t"]
        [::std::mem::size_of::<_cef_completion_callback_t>() - 48usize];
    ["Alignment of _cef_completion_callback_t"]
        [::std::mem::align_of::<_cef_completion_callback_t>() - 8usize];
    ["Offset of field: _cef_completion_callback_t::base"]
        [::std::mem::offset_of!(_cef_completion_callback_t, base) - 0usize];
    ["Offset of field: _cef_completion_callback_t::on_complete"]
        [::std::mem::offset_of!(_cef_completion_callback_t, on_complete) - 40usize];
};
#[doc = "\n Generic callback structure used for asynchronous completion.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_completion_callback_t = _cef_completion_callback_t;
#[doc = "\n Structure used for managing cookies. The functions of this structure may be\n called on any thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_cookie_manager_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Visit all cookies on the UI thread. The returned cookies are ordered by\n longest path, then by earliest creation date. Returns false (0) if cookies\n cannot be accessed.\n"]
    pub visit_all_cookies: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_cookie_manager_t,
            visitor: *mut _cef_cookie_visitor_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Visit a subset of cookies on the UI thread. The results are filtered by\n the given url scheme, host, domain and path. If |includeHttpOnly| is true\n (1) HTTP-only cookies will also be included in the results. The returned\n cookies are ordered by longest path, then by earliest creation date.\n Returns false (0) if cookies cannot be accessed.\n"]
    pub visit_url_cookies: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_cookie_manager_t,
            url: *const cef_string_t,
            includeHttpOnly: ::std::os::raw::c_int,
            visitor: *mut _cef_cookie_visitor_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets a cookie given a valid URL and explicit user-provided cookie\n attributes. This function expects each attribute to be well-formed. It\n will check for disallowed characters (e.g. the ';' character is disallowed\n within the cookie value attribute) and fail without setting the cookie if\n such characters are found. If |callback| is non-NULL it will be executed\n asnychronously on the UI thread after the cookie has been set. Returns\n false (0) if an invalid URL is specified or if cookies cannot be accessed.\n"]
    pub set_cookie: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_cookie_manager_t,
            url: *const cef_string_t,
            cookie: *const _cef_cookie_t,
            callback: *mut _cef_set_cookie_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Delete all cookies that match the specified parameters. If both |url| and\n |cookie_name| values are specified all host and domain cookies matching\n both will be deleted. If only |url| is specified all host cookies (but not\n domain cookies) irrespective of path will be deleted. If |url| is NULL all\n cookies for all hosts and domains will be deleted. If |callback| is non-\n NULL it will be executed asnychronously on the UI thread after the cookies\n have been deleted. Returns false (0) if a non-NULL invalid URL is\n specified or if cookies cannot be accessed. Cookies can alternately be\n deleted using the Visit*Cookies() functions.\n"]
    pub delete_cookies: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_cookie_manager_t,
            url: *const cef_string_t,
            cookie_name: *const cef_string_t,
            callback: *mut _cef_delete_cookies_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Flush the backing store (if any) to disk. If |callback| is non-NULL it\n will be executed asnychronously on the UI thread after the flush is\n complete. Returns false (0) if cookies cannot be accessed.\n"]
    pub flush_store: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_cookie_manager_t,
            callback: *mut _cef_completion_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_cookie_manager_t"][::std::mem::size_of::<_cef_cookie_manager_t>() - 80usize];
    ["Alignment of _cef_cookie_manager_t"]
        [::std::mem::align_of::<_cef_cookie_manager_t>() - 8usize];
    ["Offset of field: _cef_cookie_manager_t::base"]
        [::std::mem::offset_of!(_cef_cookie_manager_t, base) - 0usize];
    ["Offset of field: _cef_cookie_manager_t::visit_all_cookies"]
        [::std::mem::offset_of!(_cef_cookie_manager_t, visit_all_cookies) - 40usize];
    ["Offset of field: _cef_cookie_manager_t::visit_url_cookies"]
        [::std::mem::offset_of!(_cef_cookie_manager_t, visit_url_cookies) - 48usize];
    ["Offset of field: _cef_cookie_manager_t::set_cookie"]
        [::std::mem::offset_of!(_cef_cookie_manager_t, set_cookie) - 56usize];
    ["Offset of field: _cef_cookie_manager_t::delete_cookies"]
        [::std::mem::offset_of!(_cef_cookie_manager_t, delete_cookies) - 64usize];
    ["Offset of field: _cef_cookie_manager_t::flush_store"]
        [::std::mem::offset_of!(_cef_cookie_manager_t, flush_store) - 72usize];
};
#[doc = "\n Structure used for managing cookies. The functions of this structure may be\n called on any thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_cookie_manager_t = _cef_cookie_manager_t;
unsafe extern "C" {
    #[doc = "\n Returns the global cookie manager. By default data will be stored at\n cef_settings_t.cache_path if specified or in memory otherwise. If |callback|\n is non-NULL it will be executed asnychronously on the UI thread after the\n manager's storage has been initialized. Using this function is equivalent to\n calling cef_request_context_t::cef_request_context_get_global_context()-\n >GetDefaultCookieManager().\n"]
    pub fn cef_cookie_manager_get_global_manager(
        callback: *mut _cef_completion_callback_t,
    ) -> *mut cef_cookie_manager_t;
}
#[doc = "\n Structure to implement for visiting cookie values. The functions of this\n structure will always be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_cookie_visitor_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be called once for each cookie. |count| is the 0-based\n index for the current cookie. |total| is the total number of cookies. Set\n |deleteCookie| to true (1) to delete the cookie currently being visited.\n Return false (0) to stop visiting cookies. This function may never be\n called if no cookies are found.\n"]
    pub visit: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_cookie_visitor_t,
            cookie: *const _cef_cookie_t,
            count: ::std::os::raw::c_int,
            total: ::std::os::raw::c_int,
            deleteCookie: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_cookie_visitor_t"][::std::mem::size_of::<_cef_cookie_visitor_t>() - 48usize];
    ["Alignment of _cef_cookie_visitor_t"]
        [::std::mem::align_of::<_cef_cookie_visitor_t>() - 8usize];
    ["Offset of field: _cef_cookie_visitor_t::base"]
        [::std::mem::offset_of!(_cef_cookie_visitor_t, base) - 0usize];
    ["Offset of field: _cef_cookie_visitor_t::visit"]
        [::std::mem::offset_of!(_cef_cookie_visitor_t, visit) - 40usize];
};
#[doc = "\n Structure to implement for visiting cookie values. The functions of this\n structure will always be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_cookie_visitor_t = _cef_cookie_visitor_t;
#[doc = "\n Structure to implement to be notified of asynchronous completion via\n cef_cookie_manager_t::set_cookie().\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_set_cookie_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be called upon completion. |success| will be true (1) if\n the cookie was set successfully.\n"]
    pub on_complete: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_set_cookie_callback_t,
            success: ::std::os::raw::c_int,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_set_cookie_callback_t"]
        [::std::mem::size_of::<_cef_set_cookie_callback_t>() - 48usize];
    ["Alignment of _cef_set_cookie_callback_t"]
        [::std::mem::align_of::<_cef_set_cookie_callback_t>() - 8usize];
    ["Offset of field: _cef_set_cookie_callback_t::base"]
        [::std::mem::offset_of!(_cef_set_cookie_callback_t, base) - 0usize];
    ["Offset of field: _cef_set_cookie_callback_t::on_complete"]
        [::std::mem::offset_of!(_cef_set_cookie_callback_t, on_complete) - 40usize];
};
#[doc = "\n Structure to implement to be notified of asynchronous completion via\n cef_cookie_manager_t::set_cookie().\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_set_cookie_callback_t = _cef_set_cookie_callback_t;
#[doc = "\n Structure to implement to be notified of asynchronous completion via\n cef_cookie_manager_t::delete_cookies().\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_delete_cookies_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be called upon completion. |num_deleted| will be the\n number of cookies that were deleted.\n"]
    pub on_complete: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_delete_cookies_callback_t,
            num_deleted: ::std::os::raw::c_int,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_delete_cookies_callback_t"]
        [::std::mem::size_of::<_cef_delete_cookies_callback_t>() - 48usize];
    ["Alignment of _cef_delete_cookies_callback_t"]
        [::std::mem::align_of::<_cef_delete_cookies_callback_t>() - 8usize];
    ["Offset of field: _cef_delete_cookies_callback_t::base"]
        [::std::mem::offset_of!(_cef_delete_cookies_callback_t, base) - 0usize];
    ["Offset of field: _cef_delete_cookies_callback_t::on_complete"]
        [::std::mem::offset_of!(_cef_delete_cookies_callback_t, on_complete) - 40usize];
};
#[doc = "\n Structure to implement to be notified of asynchronous completion via\n cef_cookie_manager_t::delete_cookies().\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_delete_cookies_callback_t = _cef_delete_cookies_callback_t;
#[doc = "\n Supports discovery of and communication with media devices on the local\n network via the Cast and DIAL protocols. The functions of this structure may\n be called on any browser process thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_router_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Add an observer for MediaRouter events. The observer will remain\n registered until the returned Registration object is destroyed.\n"]
    pub add_observer: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_router_t,
            observer: *mut _cef_media_observer_t,
        ) -> *mut _cef_registration_t,
    >,
    #[doc = "\n Returns a MediaSource object for the specified media source URN. Supported\n URN schemes include \"cast:\" and \"dial:\", and will be already known by the\n client application (e.g. \"cast:<appId>?clientId=<clientId>\").\n"]
    pub get_source: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_router_t,
            urn: *const cef_string_t,
        ) -> *mut _cef_media_source_t,
    >,
    #[doc = "\n Trigger an asynchronous call to cef_media_observer_t::OnSinks on all\n registered observers.\n"]
    pub notify_current_sinks:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_media_router_t)>,
    #[doc = "\n Create a new route between |source| and |sink|. Source and sink must be\n valid, compatible (as reported by cef_media_sink_t::IsCompatibleWith), and\n a route between them must not already exist. |callback| will be executed\n on success or failure. If route creation succeeds it will also trigger an\n asynchronous call to cef_media_observer_t::OnRoutes on all registered\n observers.\n"]
    pub create_route: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_router_t,
            source: *mut _cef_media_source_t,
            sink: *mut _cef_media_sink_t,
            callback: *mut _cef_media_route_create_callback_t,
        ),
    >,
    #[doc = "\n Trigger an asynchronous call to cef_media_observer_t::OnRoutes on all\n registered observers.\n"]
    pub notify_current_routes:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_media_router_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_router_t"][::std::mem::size_of::<_cef_media_router_t>() - 80usize];
    ["Alignment of _cef_media_router_t"][::std::mem::align_of::<_cef_media_router_t>() - 8usize];
    ["Offset of field: _cef_media_router_t::base"]
        [::std::mem::offset_of!(_cef_media_router_t, base) - 0usize];
    ["Offset of field: _cef_media_router_t::add_observer"]
        [::std::mem::offset_of!(_cef_media_router_t, add_observer) - 40usize];
    ["Offset of field: _cef_media_router_t::get_source"]
        [::std::mem::offset_of!(_cef_media_router_t, get_source) - 48usize];
    ["Offset of field: _cef_media_router_t::notify_current_sinks"]
        [::std::mem::offset_of!(_cef_media_router_t, notify_current_sinks) - 56usize];
    ["Offset of field: _cef_media_router_t::create_route"]
        [::std::mem::offset_of!(_cef_media_router_t, create_route) - 64usize];
    ["Offset of field: _cef_media_router_t::notify_current_routes"]
        [::std::mem::offset_of!(_cef_media_router_t, notify_current_routes) - 72usize];
};
#[doc = "\n Supports discovery of and communication with media devices on the local\n network via the Cast and DIAL protocols. The functions of this structure may\n be called on any browser process thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_media_router_t = _cef_media_router_t;
unsafe extern "C" {
    #[doc = "\n Returns the MediaRouter object associated with the global request context.\n If |callback| is non-NULL it will be executed asnychronously on the UI\n thread after the manager's storage has been initialized. Equivalent to\n calling cef_request_context_t::cef_request_context_get_global_context()-\n >get_media_router().\n"]
    pub fn cef_media_router_get_global(
        callback: *mut _cef_completion_callback_t,
    ) -> *mut cef_media_router_t;
}
#[doc = "\n Implemented by the client to observe MediaRouter events and registered via\n cef_media_router_t::AddObserver. The functions of this structure will be\n called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_observer_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n The list of available media sinks has changed or\n cef_media_router_t::NotifyCurrentSinks was called.\n"]
    pub on_sinks: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_observer_t,
            sinksCount: usize,
            sinks: *const *mut _cef_media_sink_t,
        ),
    >,
    #[doc = "\n The list of available media routes has changed or\n cef_media_router_t::NotifyCurrentRoutes was called.\n"]
    pub on_routes: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_observer_t,
            routesCount: usize,
            routes: *const *mut _cef_media_route_t,
        ),
    >,
    #[doc = "\n The connection state of |route| has changed.\n"]
    pub on_route_state_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_observer_t,
            route: *mut _cef_media_route_t,
            state: cef_media_route_connection_state_t,
        ),
    >,
    #[doc = "\n A message was received over |route|. |message| is only valid for the scope\n of this callback and should be copied if necessary.\n"]
    pub on_route_message_received: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_observer_t,
            route: *mut _cef_media_route_t,
            message: *const ::std::os::raw::c_void,
            message_size: usize,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_observer_t"][::std::mem::size_of::<_cef_media_observer_t>() - 72usize];
    ["Alignment of _cef_media_observer_t"]
        [::std::mem::align_of::<_cef_media_observer_t>() - 8usize];
    ["Offset of field: _cef_media_observer_t::base"]
        [::std::mem::offset_of!(_cef_media_observer_t, base) - 0usize];
    ["Offset of field: _cef_media_observer_t::on_sinks"]
        [::std::mem::offset_of!(_cef_media_observer_t, on_sinks) - 40usize];
    ["Offset of field: _cef_media_observer_t::on_routes"]
        [::std::mem::offset_of!(_cef_media_observer_t, on_routes) - 48usize];
    ["Offset of field: _cef_media_observer_t::on_route_state_changed"]
        [::std::mem::offset_of!(_cef_media_observer_t, on_route_state_changed) - 56usize];
    ["Offset of field: _cef_media_observer_t::on_route_message_received"]
        [::std::mem::offset_of!(_cef_media_observer_t, on_route_message_received) - 64usize];
};
#[doc = "\n Implemented by the client to observe MediaRouter events and registered via\n cef_media_router_t::AddObserver. The functions of this structure will be\n called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_media_observer_t = _cef_media_observer_t;
#[doc = "\n Represents the route between a media source and sink. Instances of this\n object are created via cef_media_router_t::CreateRoute and retrieved via\n cef_media_observer_t::OnRoutes. Contains the status and metadata of a\n routing operation. The functions of this structure may be called on any\n browser process thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_route_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the ID for this route.\n"]
    pub get_id: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_route_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the source associated with this route.\n"]
    pub get_source: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_route_t) -> *mut _cef_media_source_t,
    >,
    #[doc = "\n Returns the sink associated with this route.\n"]
    pub get_sink: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_route_t) -> *mut _cef_media_sink_t,
    >,
    #[doc = "\n Send a message over this route. |message| will be copied if necessary.\n"]
    pub send_route_message: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_route_t,
            message: *const ::std::os::raw::c_void,
            message_size: usize,
        ),
    >,
    #[doc = "\n Terminate this route. Will result in an asynchronous call to\n cef_media_observer_t::OnRoutes on all registered observers.\n"]
    pub terminate: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_media_route_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_route_t"][::std::mem::size_of::<_cef_media_route_t>() - 80usize];
    ["Alignment of _cef_media_route_t"][::std::mem::align_of::<_cef_media_route_t>() - 8usize];
    ["Offset of field: _cef_media_route_t::base"]
        [::std::mem::offset_of!(_cef_media_route_t, base) - 0usize];
    ["Offset of field: _cef_media_route_t::get_id"]
        [::std::mem::offset_of!(_cef_media_route_t, get_id) - 40usize];
    ["Offset of field: _cef_media_route_t::get_source"]
        [::std::mem::offset_of!(_cef_media_route_t, get_source) - 48usize];
    ["Offset of field: _cef_media_route_t::get_sink"]
        [::std::mem::offset_of!(_cef_media_route_t, get_sink) - 56usize];
    ["Offset of field: _cef_media_route_t::send_route_message"]
        [::std::mem::offset_of!(_cef_media_route_t, send_route_message) - 64usize];
    ["Offset of field: _cef_media_route_t::terminate"]
        [::std::mem::offset_of!(_cef_media_route_t, terminate) - 72usize];
};
#[doc = "\n Represents the route between a media source and sink. Instances of this\n object are created via cef_media_router_t::CreateRoute and retrieved via\n cef_media_observer_t::OnRoutes. Contains the status and metadata of a\n routing operation. The functions of this structure may be called on any\n browser process thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_media_route_t = _cef_media_route_t;
#[doc = "\n Callback structure for cef_media_router_t::CreateRoute. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_route_create_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be executed when the route creation has finished.\n |result| will be CEF_MRCR_OK if the route creation succeeded. |error| will\n be a description of the error if the route creation failed. |route| is the\n resulting route, or NULL if the route creation failed.\n"]
    pub on_media_route_create_finished: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_route_create_callback_t,
            result: cef_media_route_create_result_t,
            error: *const cef_string_t,
            route: *mut _cef_media_route_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_route_create_callback_t"]
        [::std::mem::size_of::<_cef_media_route_create_callback_t>() - 48usize];
    ["Alignment of _cef_media_route_create_callback_t"]
        [::std::mem::align_of::<_cef_media_route_create_callback_t>() - 8usize];
    ["Offset of field: _cef_media_route_create_callback_t::base"]
        [::std::mem::offset_of!(_cef_media_route_create_callback_t, base) - 0usize];
    ["Offset of field: _cef_media_route_create_callback_t::on_media_route_create_finished"][::std::mem::offset_of!(
        _cef_media_route_create_callback_t,
        on_media_route_create_finished
    )
        - 40usize];
};
#[doc = "\n Callback structure for cef_media_router_t::CreateRoute. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_media_route_create_callback_t = _cef_media_route_create_callback_t;
#[doc = "\n Represents a sink to which media can be routed. Instances of this object are\n retrieved via cef_media_observer_t::OnSinks. The functions of this structure\n may be called on any browser process thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_sink_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the ID for this sink.\n"]
    pub get_id: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_sink_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the name of this sink.\n"]
    pub get_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_sink_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the icon type for this sink.\n"]
    pub get_icon_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_sink_t) -> cef_media_sink_icon_type_t,
    >,
    #[doc = "\n Asynchronously retrieves device info.\n"]
    pub get_device_info: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_sink_t,
            callback: *mut _cef_media_sink_device_info_callback_t,
        ),
    >,
    #[doc = "\n Returns true (1) if this sink accepts content via Cast.\n"]
    pub is_cast_sink: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_sink_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this sink accepts content via DIAL.\n"]
    pub is_dial_sink: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_sink_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this sink is compatible with |source|.\n"]
    pub is_compatible_with: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_sink_t,
            source: *mut _cef_media_source_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_sink_t"][::std::mem::size_of::<_cef_media_sink_t>() - 96usize];
    ["Alignment of _cef_media_sink_t"][::std::mem::align_of::<_cef_media_sink_t>() - 8usize];
    ["Offset of field: _cef_media_sink_t::base"]
        [::std::mem::offset_of!(_cef_media_sink_t, base) - 0usize];
    ["Offset of field: _cef_media_sink_t::get_id"]
        [::std::mem::offset_of!(_cef_media_sink_t, get_id) - 40usize];
    ["Offset of field: _cef_media_sink_t::get_name"]
        [::std::mem::offset_of!(_cef_media_sink_t, get_name) - 48usize];
    ["Offset of field: _cef_media_sink_t::get_icon_type"]
        [::std::mem::offset_of!(_cef_media_sink_t, get_icon_type) - 56usize];
    ["Offset of field: _cef_media_sink_t::get_device_info"]
        [::std::mem::offset_of!(_cef_media_sink_t, get_device_info) - 64usize];
    ["Offset of field: _cef_media_sink_t::is_cast_sink"]
        [::std::mem::offset_of!(_cef_media_sink_t, is_cast_sink) - 72usize];
    ["Offset of field: _cef_media_sink_t::is_dial_sink"]
        [::std::mem::offset_of!(_cef_media_sink_t, is_dial_sink) - 80usize];
    ["Offset of field: _cef_media_sink_t::is_compatible_with"]
        [::std::mem::offset_of!(_cef_media_sink_t, is_compatible_with) - 88usize];
};
#[doc = "\n Represents a sink to which media can be routed. Instances of this object are\n retrieved via cef_media_observer_t::OnSinks. The functions of this structure\n may be called on any browser process thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_media_sink_t = _cef_media_sink_t;
#[doc = "\n Callback structure for cef_media_sink_t::GetDeviceInfo. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_sink_device_info_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be executed asyncronously once device information has\n been retrieved.\n"]
    pub on_media_sink_device_info: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_media_sink_device_info_callback_t,
            device_info: *const _cef_media_sink_device_info_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_sink_device_info_callback_t"]
        [::std::mem::size_of::<_cef_media_sink_device_info_callback_t>() - 48usize];
    ["Alignment of _cef_media_sink_device_info_callback_t"]
        [::std::mem::align_of::<_cef_media_sink_device_info_callback_t>() - 8usize];
    ["Offset of field: _cef_media_sink_device_info_callback_t::base"]
        [::std::mem::offset_of!(_cef_media_sink_device_info_callback_t, base) - 0usize];
    ["Offset of field: _cef_media_sink_device_info_callback_t::on_media_sink_device_info"][::std::mem::offset_of!(
        _cef_media_sink_device_info_callback_t,
        on_media_sink_device_info
    )
        - 40usize];
};
#[doc = "\n Callback structure for cef_media_sink_t::GetDeviceInfo. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_media_sink_device_info_callback_t = _cef_media_sink_device_info_callback_t;
#[doc = "\n Represents a source from which media can be routed. Instances of this object\n are retrieved via cef_media_router_t::GetSource. The functions of this\n structure may be called on any browser process thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_source_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the ID (media source URN or URL) for this source.\n"]
    pub get_id: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_source_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns true (1) if this source outputs its content via Cast.\n"]
    pub is_cast_source: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_source_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this source outputs its content via DIAL.\n"]
    pub is_dial_source: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_source_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_source_t"][::std::mem::size_of::<_cef_media_source_t>() - 64usize];
    ["Alignment of _cef_media_source_t"][::std::mem::align_of::<_cef_media_source_t>() - 8usize];
    ["Offset of field: _cef_media_source_t::base"]
        [::std::mem::offset_of!(_cef_media_source_t, base) - 0usize];
    ["Offset of field: _cef_media_source_t::get_id"]
        [::std::mem::offset_of!(_cef_media_source_t, get_id) - 40usize];
    ["Offset of field: _cef_media_source_t::is_cast_source"]
        [::std::mem::offset_of!(_cef_media_source_t, is_cast_source) - 48usize];
    ["Offset of field: _cef_media_source_t::is_dial_source"]
        [::std::mem::offset_of!(_cef_media_source_t, is_dial_source) - 56usize];
};
#[doc = "\n Represents a source from which media can be routed. Instances of this object\n are retrieved via cef_media_router_t::GetSource. The functions of this\n structure may be called on any browser process thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_media_source_t = _cef_media_source_t;
#[doc = "\n Structure that manages custom preference registrations.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_preference_registrar_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_scoped_t,
    #[doc = "\n Register a preference with the specified |name| and |default_value|. To\n avoid conflicts with built-in preferences the |name| value should contain\n an application-specific prefix followed by a period (e.g. \"myapp.value\").\n The contents of |default_value| will be copied. The data type for the\n preference will be inferred from |default_value|'s type and cannot be\n changed after registration. Returns true (1) on success. Returns false (0)\n if |name| is already registered or if |default_value| has an invalid type.\n This function must be called from within the scope of the\n cef_browser_process_handler_t::OnRegisterCustomPreferences callback.\n"]
    pub add_preference: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_preference_registrar_t,
            name: *const cef_string_t,
            default_value: *mut _cef_value_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_preference_registrar_t"]
        [::std::mem::size_of::<_cef_preference_registrar_t>() - 24usize];
    ["Alignment of _cef_preference_registrar_t"]
        [::std::mem::align_of::<_cef_preference_registrar_t>() - 8usize];
    ["Offset of field: _cef_preference_registrar_t::base"]
        [::std::mem::offset_of!(_cef_preference_registrar_t, base) - 0usize];
    ["Offset of field: _cef_preference_registrar_t::add_preference"]
        [::std::mem::offset_of!(_cef_preference_registrar_t, add_preference) - 16usize];
};
#[doc = "\n Structure that manages custom preference registrations.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_preference_registrar_t = _cef_preference_registrar_t;
#[doc = "\n Implemented by the client to observe preference changes and registered via\n cef_preference_manager_t::AddPreferenceObserver. The functions of this\n structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_preference_observer_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when a preference has changed. The new value can be retrieved using\n cef_preference_manager_t::GetPreference.\n"]
    pub on_preference_changed: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_preference_observer_t, name: *const cef_string_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_preference_observer_t"]
        [::std::mem::size_of::<_cef_preference_observer_t>() - 48usize];
    ["Alignment of _cef_preference_observer_t"]
        [::std::mem::align_of::<_cef_preference_observer_t>() - 8usize];
    ["Offset of field: _cef_preference_observer_t::base"]
        [::std::mem::offset_of!(_cef_preference_observer_t, base) - 0usize];
    ["Offset of field: _cef_preference_observer_t::on_preference_changed"]
        [::std::mem::offset_of!(_cef_preference_observer_t, on_preference_changed) - 40usize];
};
#[doc = "\n Implemented by the client to observe preference changes and registered via\n cef_preference_manager_t::AddPreferenceObserver. The functions of this\n structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_preference_observer_t = _cef_preference_observer_t;
#[doc = "\n Manage access to preferences. Many built-in preferences are registered by\n Chromium. Custom preferences can be registered in\n cef_browser_process_handler_t::OnRegisterCustomPreferences.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_preference_manager_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if a preference with the specified |name| exists. This\n function must be called on the browser process UI thread.\n"]
    pub has_preference: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_preference_manager_t,
            name: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value for the preference with the specified |name|. Returns\n NULL if the preference does not exist. The returned object contains a copy\n of the underlying preference value and modifications to the returned\n object will not modify the underlying preference value. This function must\n be called on the browser process UI thread.\n"]
    pub get_preference: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_preference_manager_t,
            name: *const cef_string_t,
        ) -> *mut _cef_value_t,
    >,
    #[doc = "\n Returns all preferences as a dictionary. If |include_defaults| is true (1)\n then preferences currently at their default value will be included. The\n returned object contains a copy of the underlying preference values and\n modifications to the returned object will not modify the underlying\n preference values. This function must be called on the browser process UI\n thread.\n"]
    pub get_all_preferences: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_preference_manager_t,
            include_defaults: ::std::os::raw::c_int,
        ) -> *mut _cef_dictionary_value_t,
    >,
    #[doc = "\n Returns true (1) if the preference with the specified |name| can be\n modified using SetPreference. As one example preferences set via the\n command-line usually cannot be modified. This function must be called on\n the browser process UI thread.\n"]
    pub can_set_preference: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_preference_manager_t,
            name: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the |value| associated with preference |name|. Returns true (1) if the\n value is set successfully and false (0) otherwise. If |value| is NULL the\n preference will be restored to its default value. If setting the\n preference fails then |error| will be populated with a detailed\n description of the problem. This function must be called on the browser\n process UI thread.\n"]
    pub set_preference: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_preference_manager_t,
            name: *const cef_string_t,
            value: *mut _cef_value_t,
            error: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add an observer for preference changes. |name| is the name of the\n preference to observe. If |name| is NULL then all preferences will be\n observed. Observing all preferences has performance consequences and is\n not recommended outside of testing scenarios. The observer will remain\n registered until the returned Registration object is destroyed. This\n function must be called on the browser process UI thread.\n"]
    pub add_preference_observer: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_preference_manager_t,
            name: *const cef_string_t,
            observer: *mut _cef_preference_observer_t,
        ) -> *mut _cef_registration_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_preference_manager_t"]
        [::std::mem::size_of::<_cef_preference_manager_t>() - 88usize];
    ["Alignment of _cef_preference_manager_t"]
        [::std::mem::align_of::<_cef_preference_manager_t>() - 8usize];
    ["Offset of field: _cef_preference_manager_t::base"]
        [::std::mem::offset_of!(_cef_preference_manager_t, base) - 0usize];
    ["Offset of field: _cef_preference_manager_t::has_preference"]
        [::std::mem::offset_of!(_cef_preference_manager_t, has_preference) - 40usize];
    ["Offset of field: _cef_preference_manager_t::get_preference"]
        [::std::mem::offset_of!(_cef_preference_manager_t, get_preference) - 48usize];
    ["Offset of field: _cef_preference_manager_t::get_all_preferences"]
        [::std::mem::offset_of!(_cef_preference_manager_t, get_all_preferences) - 56usize];
    ["Offset of field: _cef_preference_manager_t::can_set_preference"]
        [::std::mem::offset_of!(_cef_preference_manager_t, can_set_preference) - 64usize];
    ["Offset of field: _cef_preference_manager_t::set_preference"]
        [::std::mem::offset_of!(_cef_preference_manager_t, set_preference) - 72usize];
    ["Offset of field: _cef_preference_manager_t::add_preference_observer"]
        [::std::mem::offset_of!(_cef_preference_manager_t, add_preference_observer) - 80usize];
};
#[doc = "\n Manage access to preferences. Many built-in preferences are registered by\n Chromium. Custom preferences can be registered in\n cef_browser_process_handler_t::OnRegisterCustomPreferences.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_preference_manager_t = _cef_preference_manager_t;
unsafe extern "C" {
    #[doc = "\n Returns the current Chrome Variations configuration (combination of field\n trials and chrome://flags) as equivalent command-line switches\n (`--[enable|disable]-features=XXXX`, etc). These switches can be used to\n apply the same configuration when launching a CEF-based application. See\n https://developer.chrome.com/docs/web-platform/chrome-variations for\n background and details. Note that field trial tests are disabled by default\n in Official CEF builds (via the `disable_fieldtrial_testing_config=true (1)`\n GN flag). This function must be called on the browser process UI thread.\n"]
    pub fn cef_preference_manager_get_chrome_variations_as_switches(switches: cef_string_list_t);
}
unsafe extern "C" {
    #[doc = "\n Returns the current Chrome Variations configuration (combination of field\n trials and chrome://flags) as human-readable strings. This is the human-\n readable equivalent of the \"Active Variations\" section of chrome://version.\n See https://developer.chrome.com/docs/web-platform/chrome-variations for\n background and details. Note that field trial tests are disabled by default\n in Official CEF builds (via the `disable_fieldtrial_testing_config=true (1)`\n GN flag). This function must be called on the browser process UI thread.\n"]
    pub fn cef_preference_manager_get_chrome_variations_as_strings(strings: cef_string_list_t);
}
unsafe extern "C" {
    #[doc = "\n Returns the global preference manager object.\n"]
    pub fn cef_preference_manager_get_global() -> *mut cef_preference_manager_t;
}
#[doc = "\n Callback structure for cef_request_context_t::ResolveHost.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_resolve_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called on the UI thread after the ResolveHost request has completed.\n |result| will be the result code. |resolved_ips| will be the list of\n resolved IP addresses or NULL if the resolution failed.\n"]
    pub on_resolve_completed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resolve_callback_t,
            result: cef_errorcode_t,
            resolved_ips: cef_string_list_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_resolve_callback_t"][::std::mem::size_of::<_cef_resolve_callback_t>() - 48usize];
    ["Alignment of _cef_resolve_callback_t"]
        [::std::mem::align_of::<_cef_resolve_callback_t>() - 8usize];
    ["Offset of field: _cef_resolve_callback_t::base"]
        [::std::mem::offset_of!(_cef_resolve_callback_t, base) - 0usize];
    ["Offset of field: _cef_resolve_callback_t::on_resolve_completed"]
        [::std::mem::offset_of!(_cef_resolve_callback_t, on_resolve_completed) - 40usize];
};
#[doc = "\n Callback structure for cef_request_context_t::ResolveHost.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_resolve_callback_t = _cef_resolve_callback_t;
#[doc = "\n Implemented by the client to observe content and website setting changes and\n registered via cef_request_context_t::AddSettingObserver. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_setting_observer_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when a content or website setting has changed. The new value can be\n retrieved using cef_request_context_t::GetContentSetting or\n cef_request_context_t::GetWebsiteSetting.\n"]
    pub on_setting_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_setting_observer_t,
            requesting_url: *const cef_string_t,
            top_level_url: *const cef_string_t,
            content_type: cef_content_setting_types_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_setting_observer_t"][::std::mem::size_of::<_cef_setting_observer_t>() - 48usize];
    ["Alignment of _cef_setting_observer_t"]
        [::std::mem::align_of::<_cef_setting_observer_t>() - 8usize];
    ["Offset of field: _cef_setting_observer_t::base"]
        [::std::mem::offset_of!(_cef_setting_observer_t, base) - 0usize];
    ["Offset of field: _cef_setting_observer_t::on_setting_changed"]
        [::std::mem::offset_of!(_cef_setting_observer_t, on_setting_changed) - 40usize];
};
#[doc = "\n Implemented by the client to observe content and website setting changes and\n registered via cef_request_context_t::AddSettingObserver. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_setting_observer_t = _cef_setting_observer_t;
#[doc = "\n A request context provides request handling for a set of related browser or\n URL request objects. A request context can be specified when creating a new\n browser via the cef_browser_host_t static factory functions or when creating\n a new URL request via the cef_urlrequest_t static factory functions. Browser\n objects with different request contexts will never be hosted in the same\n render process. Browser objects with the same request context may or may not\n be hosted in the same render process depending on the process model. Browser\n objects created indirectly via the JavaScript window.open function or\n targeted links will share the same render process and the same request\n context as the source browser. When running in single-process mode there is\n only a single render process (the main process) and so all browsers created\n in single-process mode will share the same request context. This will be the\n first request context passed into a cef_browser_host_t static factory\n function and all other request context objects will be ignored.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_request_context_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_preference_manager_t,
    #[doc = "\n Returns true (1) if this object is pointing to the same context as |that|\n object.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            other: *mut _cef_request_context_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object is sharing the same storage as |that|\n object.\n"]
    pub is_sharing_with: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            other: *mut _cef_request_context_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object is the global context. The global context\n is used by default when creating a browser or URL request with a NULL\n context argument.\n"]
    pub is_global: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_context_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the handler for this context if any.\n"]
    pub get_handler: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
        ) -> *mut _cef_request_context_handler_t,
    >,
    #[doc = "\n Returns the cache path for this object. If NULL an \"incognito mode\" in-\n memory cache is being used.\n"]
    pub get_cache_path: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_context_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the cookie manager for this object. If |callback| is non-NULL it\n will be executed asnychronously on the UI thread after the manager's\n storage has been initialized.\n"]
    pub get_cookie_manager: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            callback: *mut _cef_completion_callback_t,
        ) -> *mut _cef_cookie_manager_t,
    >,
    #[doc = "\n Register a scheme handler factory for the specified |scheme_name| and\n optional |domain_name|. An NULL |domain_name| value for a standard scheme\n will cause the factory to match all domain names. The |domain_name| value\n will be ignored for non-standard schemes. If |scheme_name| is a built-in\n scheme and no handler is returned by |factory| then the built-in scheme\n handler factory will be called. If |scheme_name| is a custom scheme then\n you must also implement the cef_app_t::on_register_custom_schemes()\n function in all processes. This function may be called multiple times to\n change or remove the factory that matches the specified |scheme_name| and\n optional |domain_name|. Returns false (0) if an error occurs. This\n function may be called on any thread in the browser process.\n"]
    pub register_scheme_handler_factory: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            scheme_name: *const cef_string_t,
            domain_name: *const cef_string_t,
            factory: *mut _cef_scheme_handler_factory_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Clear all registered scheme handler factories. Returns false (0) on error.\n This function may be called on any thread in the browser process.\n"]
    pub clear_scheme_handler_factories: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_context_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Clears all certificate exceptions that were added as part of handling\n cef_request_handler_t::on_certificate_error(). If you call this it is\n recommended that you also call close_all_connections() or you risk not\n being prompted again for server certificates if you reconnect quickly. If\n |callback| is non-NULL it will be executed on the UI thread after\n completion.\n"]
    pub clear_certificate_exceptions: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            callback: *mut _cef_completion_callback_t,
        ),
    >,
    #[doc = "\n Clears all HTTP authentication credentials that were added as part of\n handling GetAuthCredentials. If |callback| is non-NULL it will be executed\n on the UI thread after completion.\n"]
    pub clear_http_auth_credentials: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            callback: *mut _cef_completion_callback_t,
        ),
    >,
    #[doc = "\n Clears all active and idle connections that Chromium currently has. This\n is only recommended if you have released all other CEF objects but don't\n yet want to call cef_shutdown(). If |callback| is non-NULL it will be\n executed on the UI thread after completion.\n"]
    pub close_all_connections: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            callback: *mut _cef_completion_callback_t,
        ),
    >,
    #[doc = "\n Attempts to resolve |origin| to a list of associated IP addresses.\n |callback| will be executed on the UI thread after completion.\n"]
    pub resolve_host: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            origin: *const cef_string_t,
            callback: *mut _cef_resolve_callback_t,
        ),
    >,
    #[doc = "\n Returns the MediaRouter object associated with this context.  If\n |callback| is non-NULL it will be executed asnychronously on the UI thread\n after the manager's context has been initialized.\n"]
    pub get_media_router: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            callback: *mut _cef_completion_callback_t,
        ) -> *mut _cef_media_router_t,
    >,
    #[doc = "\n Returns the current value for |content_type| that applies for the\n specified URLs. If both URLs are NULL the default value will be returned.\n Returns nullptr if no value is configured. Must be called on the browser\n process UI thread.\n"]
    pub get_website_setting: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            requesting_url: *const cef_string_t,
            top_level_url: *const cef_string_t,
            content_type: cef_content_setting_types_t,
        ) -> *mut _cef_value_t,
    >,
    #[doc = "\n Sets the current value for |content_type| for the specified URLs in the\n default scope. If both URLs are NULL, and the context is not incognito,\n the default value will be set. Pass nullptr for |value| to remove the\n default value for this content type.\n\n WARNING: Incorrect usage of this function may cause instability or\n security issues in Chromium. Make sure that you first understand the\n potential impact of any changes to |content_type| by reviewing the related\n source code in Chromium. For example, if you plan to modify\n CEF_CONTENT_SETTING_TYPE_POPUPS, first review and understand the usage of\n ContentSettingsType::POPUPS in Chromium:\n https://source.chromium.org/search?q=ContentSettingsType::POPUPS\n"]
    pub set_website_setting: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            requesting_url: *const cef_string_t,
            top_level_url: *const cef_string_t,
            content_type: cef_content_setting_types_t,
            value: *mut _cef_value_t,
        ),
    >,
    #[doc = "\n Returns the current value for |content_type| that applies for the\n specified URLs. If both URLs are NULL the default value will be returned.\n Returns CEF_CONTENT_SETTING_VALUE_DEFAULT if no value is configured. Must\n be called on the browser process UI thread.\n"]
    pub get_content_setting: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            requesting_url: *const cef_string_t,
            top_level_url: *const cef_string_t,
            content_type: cef_content_setting_types_t,
        ) -> cef_content_setting_values_t,
    >,
    #[doc = "\n Sets the current value for |content_type| for the specified URLs in the\n default scope. If both URLs are NULL, and the context is not incognito,\n the default value will be set. Pass CEF_CONTENT_SETTING_VALUE_DEFAULT for\n |value| to use the default value for this content type.\n\n WARNING: Incorrect usage of this function may cause instability or\n security issues in Chromium. Make sure that you first understand the\n potential impact of any changes to |content_type| by reviewing the related\n source code in Chromium. For example, if you plan to modify\n CEF_CONTENT_SETTING_TYPE_POPUPS, first review and understand the usage of\n ContentSettingsType::POPUPS in Chromium:\n https://source.chromium.org/search?q=ContentSettingsType::POPUPS\n"]
    pub set_content_setting: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            requesting_url: *const cef_string_t,
            top_level_url: *const cef_string_t,
            content_type: cef_content_setting_types_t,
            value: cef_content_setting_values_t,
        ),
    >,
    #[doc = "\n Sets the Chrome color scheme for all browsers that share this request\n context. |variant| values of SYSTEM, LIGHT and DARK change the underlying\n color mode (e.g. light vs dark). Other |variant| values determine how\n |user_color| will be applied in the current color mode. If |user_color| is\n transparent (0) the default color will be used.\n"]
    pub set_chrome_color_scheme: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            variant: cef_color_variant_t,
            user_color: cef_color_t,
        ),
    >,
    #[doc = "\n Returns the current Chrome color scheme mode (SYSTEM, LIGHT or DARK). Must\n be called on the browser process UI thread.\n"]
    pub get_chrome_color_scheme_mode: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_context_t) -> cef_color_variant_t,
    >,
    #[doc = "\n Returns the current Chrome color scheme color, or transparent (0) for the\n default color. Must be called on the browser process UI thread.\n"]
    pub get_chrome_color_scheme_color: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_context_t) -> cef_color_t,
    >,
    #[doc = "\n Returns the current Chrome color scheme variant. Must be called on the\n browser process UI thread.\n"]
    pub get_chrome_color_scheme_variant: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_context_t) -> cef_color_variant_t,
    >,
    #[doc = "\n Add an observer for content and website setting changes. The observer will\n remain registered until the returned Registration object is destroyed.\n This function must be called on the browser process UI thread.\n"]
    pub add_setting_observer: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_t,
            observer: *mut _cef_setting_observer_t,
        ) -> *mut _cef_registration_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_request_context_t"][::std::mem::size_of::<_cef_request_context_t>() - 264usize];
    ["Alignment of _cef_request_context_t"]
        [::std::mem::align_of::<_cef_request_context_t>() - 8usize];
    ["Offset of field: _cef_request_context_t::base"]
        [::std::mem::offset_of!(_cef_request_context_t, base) - 0usize];
    ["Offset of field: _cef_request_context_t::is_same"]
        [::std::mem::offset_of!(_cef_request_context_t, is_same) - 88usize];
    ["Offset of field: _cef_request_context_t::is_sharing_with"]
        [::std::mem::offset_of!(_cef_request_context_t, is_sharing_with) - 96usize];
    ["Offset of field: _cef_request_context_t::is_global"]
        [::std::mem::offset_of!(_cef_request_context_t, is_global) - 104usize];
    ["Offset of field: _cef_request_context_t::get_handler"]
        [::std::mem::offset_of!(_cef_request_context_t, get_handler) - 112usize];
    ["Offset of field: _cef_request_context_t::get_cache_path"]
        [::std::mem::offset_of!(_cef_request_context_t, get_cache_path) - 120usize];
    ["Offset of field: _cef_request_context_t::get_cookie_manager"]
        [::std::mem::offset_of!(_cef_request_context_t, get_cookie_manager) - 128usize];
    ["Offset of field: _cef_request_context_t::register_scheme_handler_factory"][::std::mem::offset_of!(
        _cef_request_context_t,
        register_scheme_handler_factory
    ) - 136usize];
    ["Offset of field: _cef_request_context_t::clear_scheme_handler_factories"]
        [::std::mem::offset_of!(_cef_request_context_t, clear_scheme_handler_factories) - 144usize];
    ["Offset of field: _cef_request_context_t::clear_certificate_exceptions"]
        [::std::mem::offset_of!(_cef_request_context_t, clear_certificate_exceptions) - 152usize];
    ["Offset of field: _cef_request_context_t::clear_http_auth_credentials"]
        [::std::mem::offset_of!(_cef_request_context_t, clear_http_auth_credentials) - 160usize];
    ["Offset of field: _cef_request_context_t::close_all_connections"]
        [::std::mem::offset_of!(_cef_request_context_t, close_all_connections) - 168usize];
    ["Offset of field: _cef_request_context_t::resolve_host"]
        [::std::mem::offset_of!(_cef_request_context_t, resolve_host) - 176usize];
    ["Offset of field: _cef_request_context_t::get_media_router"]
        [::std::mem::offset_of!(_cef_request_context_t, get_media_router) - 184usize];
    ["Offset of field: _cef_request_context_t::get_website_setting"]
        [::std::mem::offset_of!(_cef_request_context_t, get_website_setting) - 192usize];
    ["Offset of field: _cef_request_context_t::set_website_setting"]
        [::std::mem::offset_of!(_cef_request_context_t, set_website_setting) - 200usize];
    ["Offset of field: _cef_request_context_t::get_content_setting"]
        [::std::mem::offset_of!(_cef_request_context_t, get_content_setting) - 208usize];
    ["Offset of field: _cef_request_context_t::set_content_setting"]
        [::std::mem::offset_of!(_cef_request_context_t, set_content_setting) - 216usize];
    ["Offset of field: _cef_request_context_t::set_chrome_color_scheme"]
        [::std::mem::offset_of!(_cef_request_context_t, set_chrome_color_scheme) - 224usize];
    ["Offset of field: _cef_request_context_t::get_chrome_color_scheme_mode"]
        [::std::mem::offset_of!(_cef_request_context_t, get_chrome_color_scheme_mode) - 232usize];
    ["Offset of field: _cef_request_context_t::get_chrome_color_scheme_color"]
        [::std::mem::offset_of!(_cef_request_context_t, get_chrome_color_scheme_color) - 240usize];
    ["Offset of field: _cef_request_context_t::get_chrome_color_scheme_variant"][::std::mem::offset_of!(
        _cef_request_context_t,
        get_chrome_color_scheme_variant
    ) - 248usize];
    ["Offset of field: _cef_request_context_t::add_setting_observer"]
        [::std::mem::offset_of!(_cef_request_context_t, add_setting_observer) - 256usize];
};
#[doc = "\n A request context provides request handling for a set of related browser or\n URL request objects. A request context can be specified when creating a new\n browser via the cef_browser_host_t static factory functions or when creating\n a new URL request via the cef_urlrequest_t static factory functions. Browser\n objects with different request contexts will never be hosted in the same\n render process. Browser objects with the same request context may or may not\n be hosted in the same render process depending on the process model. Browser\n objects created indirectly via the JavaScript window.open function or\n targeted links will share the same render process and the same request\n context as the source browser. When running in single-process mode there is\n only a single render process (the main process) and so all browsers created\n in single-process mode will share the same request context. This will be the\n first request context passed into a cef_browser_host_t static factory\n function and all other request context objects will be ignored.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_request_context_t = _cef_request_context_t;
unsafe extern "C" {
    #[doc = "\n Returns the global context object.\n"]
    pub fn cef_request_context_get_global_context() -> *mut cef_request_context_t;
}
unsafe extern "C" {
    #[doc = "\n Creates a new context object with the specified |settings| and optional\n |handler|.\n"]
    pub fn cef_request_context_create_context(
        settings: *const _cef_request_context_settings_t,
        handler: *mut _cef_request_context_handler_t,
    ) -> *mut cef_request_context_t;
}
unsafe extern "C" {
    #[doc = "\n Creates a new context object that shares storage with |other| and uses an\n optional |handler|.\n"]
    pub fn cef_request_context_cef_create_context_shared(
        other: *mut cef_request_context_t,
        handler: *mut _cef_request_context_handler_t,
    ) -> *mut cef_request_context_t;
}
#[doc = "\n Structure used to represent a browser. When used in the browser process the\n functions of this structure may be called on any thread unless otherwise\n indicated in the comments. When used in the render process the functions of\n this structure may only be called on the main thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_browser_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n True if this object is currently valid. This will return false (0) after\n cef_life_span_handler_t::OnBeforeClose is called.\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the browser host object. This function can only be called in the\n browser process.\n"]
    pub get_host: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> *mut _cef_browser_host_t,
    >,
    #[doc = "\n Returns true (1) if the browser can navigate backwards.\n"]
    pub can_go_back: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Navigate backwards.\n"]
    pub go_back: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_t)>,
    #[doc = "\n Returns true (1) if the browser can navigate forwards.\n"]
    pub can_go_forward: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Navigate forwards.\n"]
    pub go_forward: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_t)>,
    #[doc = "\n Returns true (1) if the browser is currently loading.\n"]
    pub is_loading: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Reload the current page.\n"]
    pub reload: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_t)>,
    #[doc = "\n Reload the current page ignoring any cached data.\n"]
    pub reload_ignore_cache:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_t)>,
    #[doc = "\n Stop loading the page.\n"]
    pub stop_load: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_t)>,
    #[doc = "\n Returns the globally unique identifier for this browser. This value is\n also used as the tabId for extension APIs.\n"]
    pub get_identifier: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object is pointing to the same handle as |that|\n object.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_t,
            that: *mut _cef_browser_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the browser is a popup.\n"]
    pub is_popup: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if a document has been loaded in the browser.\n"]
    pub has_document: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the main (top-level) frame for the browser. In the browser process\n this will return a valid object until after\n cef_life_span_handler_t::OnBeforeClose is called. In the renderer process\n this will return NULL if the main frame is hosted in a different renderer\n process (e.g. for cross-origin sub-frames). The main frame object will\n change during cross-origin navigation or re-navigation after renderer\n process termination (due to crashes, etc).\n"]
    pub get_main_frame: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> *mut _cef_frame_t,
    >,
    #[doc = "\n Returns the focused frame for the browser.\n"]
    pub get_focused_frame: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t) -> *mut _cef_frame_t,
    >,
    #[doc = "\n Returns the frame with the specified identifier, or NULL if not found.\n"]
    pub get_frame_by_identifier: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_t,
            identifier: *const cef_string_t,
        ) -> *mut _cef_frame_t,
    >,
    #[doc = "\n Returns the frame with the specified name, or NULL if not found.\n"]
    pub get_frame_by_name: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_t,
            name: *const cef_string_t,
        ) -> *mut _cef_frame_t,
    >,
    #[doc = "\n Returns the number of frames that currently exist.\n"]
    pub get_frame_count:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_t) -> usize>,
    #[doc = "\n Returns the identifiers of all existing frames.\n"]
    pub get_frame_identifiers: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t, identifiers: cef_string_list_t),
    >,
    #[doc = "\n Returns the names of all existing frames.\n"]
    pub get_frame_names: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_t, names: cef_string_list_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_browser_t"][::std::mem::size_of::<_cef_browser_t>() - 208usize];
    ["Alignment of _cef_browser_t"][::std::mem::align_of::<_cef_browser_t>() - 8usize];
    ["Offset of field: _cef_browser_t::base"]
        [::std::mem::offset_of!(_cef_browser_t, base) - 0usize];
    ["Offset of field: _cef_browser_t::is_valid"]
        [::std::mem::offset_of!(_cef_browser_t, is_valid) - 40usize];
    ["Offset of field: _cef_browser_t::get_host"]
        [::std::mem::offset_of!(_cef_browser_t, get_host) - 48usize];
    ["Offset of field: _cef_browser_t::can_go_back"]
        [::std::mem::offset_of!(_cef_browser_t, can_go_back) - 56usize];
    ["Offset of field: _cef_browser_t::go_back"]
        [::std::mem::offset_of!(_cef_browser_t, go_back) - 64usize];
    ["Offset of field: _cef_browser_t::can_go_forward"]
        [::std::mem::offset_of!(_cef_browser_t, can_go_forward) - 72usize];
    ["Offset of field: _cef_browser_t::go_forward"]
        [::std::mem::offset_of!(_cef_browser_t, go_forward) - 80usize];
    ["Offset of field: _cef_browser_t::is_loading"]
        [::std::mem::offset_of!(_cef_browser_t, is_loading) - 88usize];
    ["Offset of field: _cef_browser_t::reload"]
        [::std::mem::offset_of!(_cef_browser_t, reload) - 96usize];
    ["Offset of field: _cef_browser_t::reload_ignore_cache"]
        [::std::mem::offset_of!(_cef_browser_t, reload_ignore_cache) - 104usize];
    ["Offset of field: _cef_browser_t::stop_load"]
        [::std::mem::offset_of!(_cef_browser_t, stop_load) - 112usize];
    ["Offset of field: _cef_browser_t::get_identifier"]
        [::std::mem::offset_of!(_cef_browser_t, get_identifier) - 120usize];
    ["Offset of field: _cef_browser_t::is_same"]
        [::std::mem::offset_of!(_cef_browser_t, is_same) - 128usize];
    ["Offset of field: _cef_browser_t::is_popup"]
        [::std::mem::offset_of!(_cef_browser_t, is_popup) - 136usize];
    ["Offset of field: _cef_browser_t::has_document"]
        [::std::mem::offset_of!(_cef_browser_t, has_document) - 144usize];
    ["Offset of field: _cef_browser_t::get_main_frame"]
        [::std::mem::offset_of!(_cef_browser_t, get_main_frame) - 152usize];
    ["Offset of field: _cef_browser_t::get_focused_frame"]
        [::std::mem::offset_of!(_cef_browser_t, get_focused_frame) - 160usize];
    ["Offset of field: _cef_browser_t::get_frame_by_identifier"]
        [::std::mem::offset_of!(_cef_browser_t, get_frame_by_identifier) - 168usize];
    ["Offset of field: _cef_browser_t::get_frame_by_name"]
        [::std::mem::offset_of!(_cef_browser_t, get_frame_by_name) - 176usize];
    ["Offset of field: _cef_browser_t::get_frame_count"]
        [::std::mem::offset_of!(_cef_browser_t, get_frame_count) - 184usize];
    ["Offset of field: _cef_browser_t::get_frame_identifiers"]
        [::std::mem::offset_of!(_cef_browser_t, get_frame_identifiers) - 192usize];
    ["Offset of field: _cef_browser_t::get_frame_names"]
        [::std::mem::offset_of!(_cef_browser_t, get_frame_names) - 200usize];
};
#[doc = "\n Structure used to represent a browser. When used in the browser process the\n functions of this structure may be called on any thread unless otherwise\n indicated in the comments. When used in the render process the functions of\n this structure may only be called on the main thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_browser_t = _cef_browser_t;
#[doc = "\n Callback structure for cef_browser_host_t::RunFileDialog. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_run_file_dialog_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called asynchronously after the file dialog is dismissed. |file_paths|\n will be a single value or a list of values depending on the dialog mode.\n If the selection was cancelled |file_paths| will be NULL.\n"]
    pub on_file_dialog_dismissed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_run_file_dialog_callback_t,
            file_paths: cef_string_list_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_run_file_dialog_callback_t"]
        [::std::mem::size_of::<_cef_run_file_dialog_callback_t>() - 48usize];
    ["Alignment of _cef_run_file_dialog_callback_t"]
        [::std::mem::align_of::<_cef_run_file_dialog_callback_t>() - 8usize];
    ["Offset of field: _cef_run_file_dialog_callback_t::base"]
        [::std::mem::offset_of!(_cef_run_file_dialog_callback_t, base) - 0usize];
    ["Offset of field: _cef_run_file_dialog_callback_t::on_file_dialog_dismissed"][::std::mem::offset_of!(
        _cef_run_file_dialog_callback_t,
        on_file_dialog_dismissed
    ) - 40usize];
};
#[doc = "\n Callback structure for cef_browser_host_t::RunFileDialog. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_run_file_dialog_callback_t = _cef_run_file_dialog_callback_t;
#[doc = "\n Callback structure for cef_browser_host_t::GetNavigationEntries. The\n functions of this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_navigation_entry_visitor_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be executed. Do not keep a reference to |entry| outside\n of this callback. Return true (1) to continue visiting entries or false\n (0) to stop. |current| is true (1) if this entry is the currently loaded\n navigation entry. |index| is the 0-based index of this entry and |total|\n is the total number of entries.\n"]
    pub visit: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_navigation_entry_visitor_t,
            entry: *mut _cef_navigation_entry_t,
            current: ::std::os::raw::c_int,
            index: ::std::os::raw::c_int,
            total: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_navigation_entry_visitor_t"]
        [::std::mem::size_of::<_cef_navigation_entry_visitor_t>() - 48usize];
    ["Alignment of _cef_navigation_entry_visitor_t"]
        [::std::mem::align_of::<_cef_navigation_entry_visitor_t>() - 8usize];
    ["Offset of field: _cef_navigation_entry_visitor_t::base"]
        [::std::mem::offset_of!(_cef_navigation_entry_visitor_t, base) - 0usize];
    ["Offset of field: _cef_navigation_entry_visitor_t::visit"]
        [::std::mem::offset_of!(_cef_navigation_entry_visitor_t, visit) - 40usize];
};
#[doc = "\n Callback structure for cef_browser_host_t::GetNavigationEntries. The\n functions of this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_navigation_entry_visitor_t = _cef_navigation_entry_visitor_t;
#[doc = "\n Callback structure for cef_browser_host_t::PrintToPDF. The functions of this\n structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_pdf_print_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be executed when the PDF printing has completed. |path|\n is the output path. |ok| will be true (1) if the printing completed\n successfully or false (0) otherwise.\n"]
    pub on_pdf_print_finished: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_pdf_print_callback_t,
            path: *const cef_string_t,
            ok: ::std::os::raw::c_int,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_pdf_print_callback_t"]
        [::std::mem::size_of::<_cef_pdf_print_callback_t>() - 48usize];
    ["Alignment of _cef_pdf_print_callback_t"]
        [::std::mem::align_of::<_cef_pdf_print_callback_t>() - 8usize];
    ["Offset of field: _cef_pdf_print_callback_t::base"]
        [::std::mem::offset_of!(_cef_pdf_print_callback_t, base) - 0usize];
    ["Offset of field: _cef_pdf_print_callback_t::on_pdf_print_finished"]
        [::std::mem::offset_of!(_cef_pdf_print_callback_t, on_pdf_print_finished) - 40usize];
};
#[doc = "\n Callback structure for cef_browser_host_t::PrintToPDF. The functions of this\n structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_pdf_print_callback_t = _cef_pdf_print_callback_t;
#[doc = "\n Callback structure for cef_browser_host_t::DownloadImage. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_download_image_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be executed when the image download has completed.\n |image_url| is the URL that was downloaded and |http_status_code| is the\n resulting HTTP status code. |image| is the resulting image, possibly at\n multiple scale factors, or NULL if the download failed.\n"]
    pub on_download_image_finished: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_download_image_callback_t,
            image_url: *const cef_string_t,
            http_status_code: ::std::os::raw::c_int,
            image: *mut _cef_image_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_download_image_callback_t"]
        [::std::mem::size_of::<_cef_download_image_callback_t>() - 48usize];
    ["Alignment of _cef_download_image_callback_t"]
        [::std::mem::align_of::<_cef_download_image_callback_t>() - 8usize];
    ["Offset of field: _cef_download_image_callback_t::base"]
        [::std::mem::offset_of!(_cef_download_image_callback_t, base) - 0usize];
    ["Offset of field: _cef_download_image_callback_t::on_download_image_finished"][::std::mem::offset_of!(
        _cef_download_image_callback_t,
        on_download_image_finished
    ) - 40usize];
};
#[doc = "\n Callback structure for cef_browser_host_t::DownloadImage. The functions of\n this structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_download_image_callback_t = _cef_download_image_callback_t;
#[doc = "\n Structure used to represent the browser process aspects of a browser. The\n functions of this structure can only be called in the browser process. They\n may be called on any thread in that process unless otherwise indicated in\n the comments.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_browser_host_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the hosted browser object.\n"]
    pub get_browser: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> *mut _cef_browser_t,
    >,
    #[doc = "\n Request that the browser close. Closing a browser is a multi-stage process\n that may complete either synchronously or asynchronously, and involves\n callbacks such as cef_life_span_handler_t::DoClose (Alloy style only),\n cef_life_span_handler_t::OnBeforeClose, and a top-level window close\n handler such as cef_window_delegate_t::CanClose (or platform-specific\n equivalent). In some cases a close request may be delayed or canceled by\n the user. Using try_close_browser() instead of close_browser() is\n recommended for most use cases. See cef_life_span_handler_t::do_close()\n documentation for detailed usage and examples.\n\n If |force_close| is false (0) then JavaScript unload handlers, if any, may\n be fired and the close may be delayed or canceled by the user. If\n |force_close| is true (1) then the user will not be prompted and the close\n will proceed immediately (possibly asynchronously). If browser close is\n delayed and not canceled the default behavior is to call the top-level\n window close handler once the browser is ready to be closed. This default\n behavior can be changed for Alloy style browsers by implementing\n cef_life_span_handler_t::do_close(). is_ready_to_be_closed() can be used\n to detect mandatory browser close events when customizing close behavior\n on the browser process UI thread.\n"]
    pub close_browser: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, force_close: ::std::os::raw::c_int),
    >,
    #[doc = "\n Helper for closing a browser. This is similar in behavior to\n CLoseBrowser(false (0)) but returns a boolean to reflect the immediate\n close status. Call this function from a top-level window close handler\n such as cef_window_delegate_t::CanClose (or platform-specific equivalent)\n to request that the browser close, and return the result to indicate if\n the window close should proceed. Returns false (0) if the close will be\n delayed (JavaScript unload handlers triggered but still pending) or true\n (1) if the close will proceed immediately (possibly asynchronously). See\n close_browser() documentation for additional usage information. This\n function must be called on the browser process UI thread.\n"]
    pub try_close_browser: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the browser is ready to be closed, meaning that the\n close has already been initiated and that JavaScript unload handlers have\n already executed or should be ignored. This can be used from a top-level\n window close handler such as cef_window_delegate_t::CanClose (or platform-\n specific equivalent) to distringuish between potentially cancelable\n browser close events (like the user clicking the top-level window close\n button before browser close has started) and mandatory browser close\n events (like JavaScript `window.close()` or after browser close has\n started in response to [Try]close_browser()). Not completing the browser\n close for mandatory close events (when this function returns true (1))\n will leave the browser in a partially closed state that interferes with\n proper functioning. See close_browser() documentation for additional usage\n information. This function must be called on the browser process UI\n thread.\n"]
    pub is_ready_to_be_closed: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set whether the browser is focused.\n"]
    pub set_focus: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, focus: ::std::os::raw::c_int),
    >,
    #[doc = "\n Retrieve the window handle (if any) for this browser. If this browser is\n wrapped in a cef_browser_view_t this function should be called on the\n browser process UI thread and it will return the handle for the top-level\n native window.\n"]
    pub get_window_handle: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> cef_window_handle_t,
    >,
    #[doc = "\n Retrieve the window handle (if any) of the browser that opened this\n browser. Will return NULL for non-popup browsers or if this browser is\n wrapped in a cef_browser_view_t. This function can be used in combination\n with custom handling of modal windows.\n"]
    pub get_opener_window_handle: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> cef_window_handle_t,
    >,
    #[doc = "\n Retrieve the unique identifier of the browser that opened this browser.\n Will return 0 for non-popup browsers.\n"]
    pub get_opener_identifier: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this browser is wrapped in a cef_browser_view_t.\n"]
    pub has_view: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the client for this browser.\n"]
    pub get_client: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> *mut _cef_client_t,
    >,
    #[doc = "\n Returns the request context for this browser.\n"]
    pub get_request_context: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> *mut _cef_request_context_t,
    >,
    #[doc = "\n Returns true (1) if this browser can execute the specified zoom command.\n This function can only be called on the UI thread.\n"]
    pub can_zoom: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            command: cef_zoom_command_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Execute a zoom command in this browser. If called on the UI thread the\n change will be applied immediately. Otherwise, the change will be applied\n asynchronously on the UI thread.\n"]
    pub zoom: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, command: cef_zoom_command_t),
    >,
    #[doc = "\n Get the default zoom level. This value will be 0.0 by default but can be\n configured. This function can only be called on the UI thread.\n"]
    pub get_default_zoom_level:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> f64>,
    #[doc = "\n Get the current zoom level. This function can only be called on the UI\n thread.\n"]
    pub get_zoom_level:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> f64>,
    #[doc = "\n Change the zoom level to the specified value. Specify 0.0 to reset the\n zoom level to the default. If called on the UI thread the change will be\n applied immediately. Otherwise, the change will be applied asynchronously\n on the UI thread.\n"]
    pub set_zoom_level: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, zoomLevel: f64),
    >,
    #[doc = "\n Call to run a file chooser dialog. Only a single file chooser dialog may\n be pending at any given time. |mode| represents the type of dialog to\n display. |title| to the title to be used for the dialog and may be NULL to\n show the default title (\"Open\" or \"Save\" depending on the mode).\n |default_file_path| is the path with optional directory and/or file name\n component that will be initially selected in the dialog. |accept_filters|\n are used to restrict the selectable file types and may any combination of\n (a) valid lower-cased MIME types (e.g. \"text/*\" or \"image/*\"), (b)\n individual file extensions (e.g. \".txt\" or \".png\"), or (c) combined\n description and file extension delimited using \"|\" and \";\" (e.g. \"Image\n Types|.png;.gif;.jpg\"). |callback| will be executed after the dialog is\n dismissed or immediately if another dialog is already pending. The dialog\n will be initiated asynchronously on the UI thread.\n"]
    pub run_file_dialog: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            mode: cef_file_dialog_mode_t,
            title: *const cef_string_t,
            default_file_path: *const cef_string_t,
            accept_filters: cef_string_list_t,
            callback: *mut _cef_run_file_dialog_callback_t,
        ),
    >,
    #[doc = "\n Download the file at |url| using cef_download_handler_t.\n"]
    pub start_download: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, url: *const cef_string_t),
    >,
    #[doc = "\n Download |image_url| and execute |callback| on completion with the images\n received from the renderer. If |is_favicon| is true (1) then cookies are\n not sent and not accepted during download. Images with density independent\n pixel (DIP) sizes larger than |max_image_size| are filtered out from the\n image results. Versions of the image at different scale factors may be\n downloaded up to the maximum scale factor supported by the system. If\n there are no image results <= |max_image_size| then the smallest image is\n resized to |max_image_size| and is the only result. A |max_image_size| of\n 0 means unlimited. If |bypass_cache| is true (1) then |image_url| is\n requested from the server even if it is present in the browser cache.\n"]
    pub download_image: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            image_url: *const cef_string_t,
            is_favicon: ::std::os::raw::c_int,
            max_image_size: u32,
            bypass_cache: ::std::os::raw::c_int,
            callback: *mut _cef_download_image_callback_t,
        ),
    >,
    #[doc = "\n Print the current browser contents.\n"]
    pub print: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Print the current browser contents to the PDF file specified by |path| and\n execute |callback| on completion. The caller is responsible for deleting\n |path| when done. For PDF printing to work on Linux you must implement the\n cef_print_handler_t::GetPdfPaperSize function.\n"]
    pub print_to_pdf: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            path: *const cef_string_t,
            settings: *const _cef_pdf_print_settings_t,
            callback: *mut _cef_pdf_print_callback_t,
        ),
    >,
    #[doc = "\n Search for |searchText|. |forward| indicates whether to search forward or\n backward within the page. |matchCase| indicates whether the search should\n be case-sensitive. |findNext| indicates whether this is the first request\n or a follow-up. The search will be restarted if |searchText| or\n |matchCase| change. The search will be stopped if |searchText| is NULL.\n The cef_find_handler_t instance, if any, returned via\n cef_client_t::GetFindHandler will be called to report find results.\n"]
    pub find: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            searchText: *const cef_string_t,
            forward: ::std::os::raw::c_int,
            matchCase: ::std::os::raw::c_int,
            findNext: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Cancel all searches that are currently going on.\n"]
    pub stop_finding: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            clearSelection: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Open developer tools (DevTools) in its own browser. The DevTools browser\n will remain associated with this browser. If the DevTools browser is\n already open then it will be focused, in which case the |windowInfo|,\n |client| and |settings| parameters will be ignored. If\n |inspect_element_at| is non-NULL then the element at the specified (x,y)\n location will be inspected. The |windowInfo| parameter will be ignored if\n this browser is wrapped in a cef_browser_view_t.\n"]
    pub show_dev_tools: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            windowInfo: *const _cef_window_info_t,
            client: *mut _cef_client_t,
            settings: *const _cef_browser_settings_t,
            inspect_element_at: *const cef_point_t,
        ),
    >,
    #[doc = "\n Explicitly close the associated DevTools browser, if any.\n"]
    pub close_dev_tools:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Returns true (1) if this browser currently has an associated DevTools\n browser. Must be called on the browser process UI thread.\n"]
    pub has_dev_tools: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Send a function call message over the DevTools protocol. |message| must be\n a UTF8-encoded JSON dictionary that contains \"id\" (int), \"function\"\n (string) and \"params\" (dictionary, optional) values. See the DevTools\n protocol documentation at https://chromedevtools.github.io/devtools-\n protocol/ for details of supported functions and the expected \"params\"\n dictionary contents. |message| will be copied if necessary. This function\n will return true (1) if called on the UI thread and the message was\n successfully submitted for validation, otherwise false (0). Validation\n will be applied asynchronously and any messages that fail due to\n formatting errors or missing parameters may be discarded without\n notification. Prefer ExecuteDevToolsMethod if a more structured approach\n to message formatting is desired.\n\n Every valid function call will result in an asynchronous function result\n or error message that references the sent message \"id\". Event messages are\n received while notifications are enabled (for example, between function\n calls for \"Page.enable\" and \"Page.disable\"). All received messages will be\n delivered to the observer(s) registered with AddDevToolsMessageObserver.\n See cef_dev_tools_message_observer_t::OnDevToolsMessage documentation for\n details of received message contents.\n\n Usage of the SendDevToolsMessage, ExecuteDevToolsMethod and\n AddDevToolsMessageObserver functions does not require an active DevTools\n front-end or remote-debugging session. Other active DevTools sessions will\n continue to function independently. However, any modification of global\n browser state by one session may not be reflected in the UI of other\n sessions.\n\n Communication with the DevTools front-end (when displayed) can be logged\n for development purposes by passing the `--devtools-protocol-log-\n file=<path>` command-line flag.\n"]
    pub send_dev_tools_message: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            message: *const ::std::os::raw::c_void,
            message_size: usize,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Execute a function call over the DevTools protocol. This is a more\n structured version of SendDevToolsMessage. |message_id| is an incremental\n number that uniquely identifies the message (pass 0 to have the next\n number assigned automatically based on previous values). |function| is the\n function name. |params| are the function parameters, which may be NULL.\n See the DevTools protocol documentation (linked above) for details of\n supported functions and the expected |params| dictionary contents. This\n function will return the assigned message ID if called on the UI thread\n and the message was successfully submitted for validation, otherwise 0.\n See the SendDevToolsMessage documentation for additional usage\n information.\n"]
    pub execute_dev_tools_method: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            message_id: ::std::os::raw::c_int,
            method: *const cef_string_t,
            params: *mut _cef_dictionary_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add an observer for DevTools protocol messages (function results and\n events). The observer will remain registered until the returned\n Registration object is destroyed. See the SendDevToolsMessage\n documentation for additional usage information.\n"]
    pub add_dev_tools_message_observer: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            observer: *mut _cef_dev_tools_message_observer_t,
        ) -> *mut _cef_registration_t,
    >,
    #[doc = "\n Retrieve a snapshot of current navigation entries as values sent to the\n specified visitor. If |current_only| is true (1) only the current\n navigation entry will be sent, otherwise all navigation entries will be\n sent.\n"]
    pub get_navigation_entries: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            visitor: *mut _cef_navigation_entry_visitor_t,
            current_only: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n If a misspelled word is currently selected in an editable node calling\n this function will replace it with the specified |word|.\n"]
    pub replace_misspelling: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, word: *const cef_string_t),
    >,
    #[doc = "\n Add the specified |word| to the spelling dictionary.\n"]
    pub add_word_to_dictionary: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, word: *const cef_string_t),
    >,
    #[doc = "\n Returns true (1) if window rendering is disabled.\n"]
    pub is_window_rendering_disabled: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Notify the browser that the widget has been resized. The browser will\n first call cef_render_handler_t::GetViewRect to get the new size and then\n call cef_render_handler_t::OnPaint asynchronously with the updated\n regions. This function is only used when window rendering is disabled.\n"]
    pub was_resized: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Notify the browser that it has been hidden or shown. Layouting and\n cef_render_handler_t::OnPaint notification will stop when the browser is\n hidden. This function is only used when window rendering is disabled.\n"]
    pub was_hidden: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, hidden: ::std::os::raw::c_int),
    >,
    #[doc = "\n Notify the browser that screen information has changed. Updated\n information will be sent to the renderer process to configure screen size\n and position values used by CSS and JavaScript (window.deviceScaleFactor,\n window.screenX/Y, window.outerWidth/Height, etc.). For background see\n https://bitbucket.org/chromiumembedded/cef/wiki/GeneralUsage.md#markdown-\n header-coordinate-systems\n\n This function is used with (a) windowless rendering and (b) windowed\n rendering with external (client-provided) root window.\n\n With windowless rendering the browser will call\n cef_render_handler_t::GetScreenInfo,\n cef_render_handler_t::GetRootScreenRect and\n cef_render_handler_t::GetViewRect. This simulates moving or resizing the\n root window in the current display, moving the root window from one\n display to another, or changing the properties of the current display.\n\n With windowed rendering the browser will call\n cef_display_handler_t::GetRootWindowScreenRect and use the associated\n display properties.\n"]
    pub notify_screen_info_changed:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Invalidate the view. The browser will call cef_render_handler_t::OnPaint\n asynchronously. This function is only used when window rendering is\n disabled.\n"]
    pub invalidate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, type_: cef_paint_element_type_t),
    >,
    #[doc = "\n Issue a BeginFrame request to Chromium.  Only valid when\n cef_window_tInfo::external_begin_frame_enabled is set to true (1).\n"]
    pub send_external_begin_frame:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Send a key event to the browser.\n"]
    pub send_key_event: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, event: *const cef_key_event_t),
    >,
    #[doc = "\n Send a mouse click event to the browser. The |x| and |y| coordinates are\n relative to the upper-left corner of the view.\n"]
    pub send_mouse_click_event: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            event: *const cef_mouse_event_t,
            type_: cef_mouse_button_type_t,
            mouseUp: ::std::os::raw::c_int,
            clickCount: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Send a mouse move event to the browser. The |x| and |y| coordinates are\n relative to the upper-left corner of the view.\n"]
    pub send_mouse_move_event: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            event: *const cef_mouse_event_t,
            mouseLeave: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Send a mouse wheel event to the browser. The |x| and |y| coordinates are\n relative to the upper-left corner of the view. The |deltaX| and |deltaY|\n values represent the movement delta in the X and Y directions\n respectively. In order to scroll inside select popups with window\n rendering disabled cef_render_handler_t::GetScreenPoint should be\n implemented properly.\n"]
    pub send_mouse_wheel_event: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            event: *const cef_mouse_event_t,
            deltaX: ::std::os::raw::c_int,
            deltaY: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Send a touch event to the browser for a windowless browser.\n"]
    pub send_touch_event: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, event: *const cef_touch_event_t),
    >,
    #[doc = "\n Send a capture lost event to the browser.\n"]
    pub send_capture_lost_event:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Notify the browser that the window hosting it is about to be moved or\n resized. This function is only used on Windows and Linux.\n"]
    pub notify_move_or_resize_started:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Returns the maximum rate in frames per second (fps) that\n cef_render_handler_t::OnPaint will be called for a windowless browser. The\n actual fps may be lower if the browser cannot generate frames at the\n requested rate. The minimum value is 1 and the maximum value is 60\n (default 30). This function can only be called on the UI thread.\n"]
    pub get_windowless_frame_rate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the maximum rate in frames per second (fps) that\n cef_render_handler_t:: OnPaint will be called for a windowless browser.\n The actual fps may be lower if the browser cannot generate frames at the\n requested rate. The minimum value is 1 and the maximum value is 60\n (default 30). Can also be set at browser creation via\n cef_browser_tSettings.windowless_frame_rate.\n"]
    pub set_windowless_frame_rate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, frame_rate: ::std::os::raw::c_int),
    >,
    #[doc = "\n Begins a new composition or updates the existing composition. Blink has a\n special node (a composition node) that allows the input function to change\n text without affecting other DOM nodes. |text| is the optional text that\n will be inserted into the composition node. |underlines| is an optional\n set of ranges that will be underlined in the resulting text.\n |replacement_range| is an optional range of the existing text that will be\n replaced. |selection_range| is an optional range of the resulting text\n that will be selected after insertion or replacement. The\n |replacement_range| value is only used on OS X.\n\n This function may be called multiple times as the composition changes.\n When the client is done making changes the composition should either be\n canceled or completed. To cancel the composition call\n ImeCancelComposition. To complete the composition call either\n ImeCommitText or ImeFinishComposingText. Completion is usually signaled\n when:\n\n 1. The client receives a WM_IME_COMPOSITION message with a GCS_RESULTSTR\n    flag (on Windows), or;\n 2. The client receives a \"commit\" signal of GtkIMContext (on Linux), or;\n 3. insertText of NSTextInput is called (on Mac).\n\n This function is only used when window rendering is disabled.\n"]
    pub ime_set_composition: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            text: *const cef_string_t,
            underlinesCount: usize,
            underlines: *const cef_composition_underline_t,
            replacement_range: *const cef_range_t,
            selection_range: *const cef_range_t,
        ),
    >,
    #[doc = "\n Completes the existing composition by optionally inserting the specified\n |text| into the composition node. |replacement_range| is an optional range\n of the existing text that will be replaced. |relative_cursor_pos| is where\n the cursor will be positioned relative to the current cursor position. See\n comments on ImeSetComposition for usage. The |replacement_range| and\n |relative_cursor_pos| values are only used on OS X. This function is only\n used when window rendering is disabled.\n"]
    pub ime_commit_text: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            text: *const cef_string_t,
            replacement_range: *const cef_range_t,
            relative_cursor_pos: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Completes the existing composition by applying the current composition\n node contents. If |keep_selection| is false (0) the current selection, if\n any, will be discarded. See comments on ImeSetComposition for usage. This\n function is only used when window rendering is disabled.\n"]
    pub ime_finish_composing_text: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            keep_selection: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Cancels the existing composition and discards the composition node\n contents without applying them. See comments on ImeSetComposition for\n usage. This function is only used when window rendering is disabled.\n"]
    pub ime_cancel_composition:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Call this function when the user drags the mouse into the web view (before\n calling DragTargetDragOver/DragTargetLeave/DragTargetDrop). |drag_data|\n should not contain file contents as this type of data is not allowed to be\n dragged into the web view. File contents can be removed using\n cef_drag_data_t::ResetFileContents (for example, if |drag_data| comes from\n cef_render_handler_t::StartDragging). This function is only used when\n window rendering is disabled.\n"]
    pub drag_target_drag_enter: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            drag_data: *mut _cef_drag_data_t,
            event: *const cef_mouse_event_t,
            allowed_ops: cef_drag_operations_mask_t,
        ),
    >,
    #[doc = "\n Call this function each time the mouse is moved across the web view during\n a drag operation (after calling DragTargetDragEnter and before calling\n DragTargetDragLeave/DragTargetDrop). This function is only used when\n window rendering is disabled.\n"]
    pub drag_target_drag_over: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            event: *const cef_mouse_event_t,
            allowed_ops: cef_drag_operations_mask_t,
        ),
    >,
    #[doc = "\n Call this function when the user drags the mouse out of the web view\n (after calling DragTargetDragEnter). This function is only used when\n window rendering is disabled.\n"]
    pub drag_target_drag_leave:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Call this function when the user completes the drag operation by dropping\n the object onto the web view (after calling DragTargetDragEnter). The\n object being dropped is |drag_data|, given as an argument to the previous\n DragTargetDragEnter call. This function is only used when window rendering\n is disabled.\n"]
    pub drag_target_drop: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, event: *const cef_mouse_event_t),
    >,
    #[doc = "\n Call this function when the drag operation started by a\n cef_render_handler_t::StartDragging call has ended either in a drop or by\n being cancelled. |x| and |y| are mouse coordinates relative to the upper-\n left corner of the view. If the web view is both the drag source and the\n drag target then all DragTarget* functions should be called before\n DragSource* mthods. This function is only used when window rendering is\n disabled.\n"]
    pub drag_source_ended_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            x: ::std::os::raw::c_int,
            y: ::std::os::raw::c_int,
            op: cef_drag_operations_mask_t,
        ),
    >,
    #[doc = "\n Call this function when the drag operation started by a\n cef_render_handler_t::StartDragging call has completed. This function may\n be called immediately without first calling DragSourceEndedAt to cancel a\n drag operation. If the web view is both the drag source and the drag\n target then all DragTarget* functions should be called before DragSource*\n mthods. This function is only used when window rendering is disabled.\n"]
    pub drag_source_system_drag_ended:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_host_t)>,
    #[doc = "\n Returns the current visible navigation entry for this browser. This\n function can only be called on the UI thread.\n"]
    pub get_visible_navigation_entry: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> *mut _cef_navigation_entry_t,
    >,
    #[doc = "\n Set accessibility state for all frames. |accessibility_state| may be\n default, enabled or disabled. If |accessibility_state| is STATE_DEFAULT\n then accessibility will be disabled by default and the state may be\n further controlled with the \"force-renderer-accessibility\" and \"disable-\n renderer-accessibility\" command-line switches. If |accessibility_state| is\n STATE_ENABLED then accessibility will be enabled. If |accessibility_state|\n is STATE_DISABLED then accessibility will be completely disabled.\n\n For windowed browsers accessibility will be enabled in Complete mode\n (which corresponds to kAccessibilityModeComplete in Chromium). In this\n mode all platform accessibility objects will be created and managed by\n Chromium's internal implementation. The client needs only to detect the\n screen reader and call this function appropriately. For example, on macOS\n the client can handle the @\"AXEnhancedUserStructure\" accessibility\n attribute to detect VoiceOver state changes and on Windows the client can\n handle WM_GETOBJECT with OBJID_CLIENT to detect accessibility readers.\n\n For windowless browsers accessibility will be enabled in TreeOnly mode\n (which corresponds to kAccessibilityModeWebContentsOnly in Chromium). In\n this mode renderer accessibility is enabled, the full tree is computed,\n and events are passed to CefAccessibiltyHandler, but platform\n accessibility objects are not created. The client may implement platform\n accessibility objects using CefAccessibiltyHandler callbacks if desired.\n"]
    pub set_accessibility_state: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, accessibility_state: cef_state_t),
    >,
    #[doc = "\n Enable notifications of auto resize via\n cef_display_handler_t::OnAutoResize. Notifications are disabled by\n default. |min_size| and |max_size| define the range of allowed sizes.\n"]
    pub set_auto_resize_enabled: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            enabled: ::std::os::raw::c_int,
            min_size: *const cef_size_t,
            max_size: *const cef_size_t,
        ),
    >,
    #[doc = "\n Set whether the browser's audio is muted.\n"]
    pub set_audio_muted: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t, mute: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns true (1) if the browser's audio is muted.  This function can only\n be called on the UI thread.\n"]
    pub is_audio_muted: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the renderer is currently in browser fullscreen. This\n differs from window fullscreen in that browser fullscreen is entered using\n the JavaScript Fullscreen API and modifies CSS attributes such as the\n ::backdrop pseudo-element and :fullscreen pseudo-structure. This function\n can only be called on the UI thread.\n"]
    pub is_fullscreen: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Requests the renderer to exit browser fullscreen. In most cases exiting\n window fullscreen should also exit browser fullscreen. With Alloy style\n this function should be called in response to a user action such as\n clicking the green traffic light button on MacOS\n (cef_window_delegate_t::OnWindowFullscreenTransition callback) or pressing\n the \"ESC\" key (cef_keyboard_handler_t::OnPreKeyEvent callback). With\n Chrome style these standard exit actions are handled internally but\n new/additional user actions can use this function. Set |will_cause_resize|\n to true (1) if exiting browser fullscreen will cause a view resize.\n"]
    pub exit_fullscreen: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            will_cause_resize: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Returns true (1) if a Chrome command is supported and enabled. Use the\n cef_id_for_command_id_name() function for version-safe mapping of command\n IDC names from cef_command_ids.h to version-specific numerical\n |command_id| values. This function can only be called on the UI thread.\n Only used with Chrome style.\n"]
    pub can_execute_chrome_command: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Execute a Chrome command. Use the cef_id_for_command_id_name() function\n for version-safe mapping of command IDC names from cef_command_ids.h to\n version-specific numerical |command_id| values. |disposition| provides\n information about the intended command target. Only used with Chrome\n style.\n"]
    pub execute_chrome_command: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_host_t,
            command_id: ::std::os::raw::c_int,
            disposition: cef_window_open_disposition_t,
        ),
    >,
    #[doc = "\n Returns true (1) if the render process associated with this browser is\n currently unresponsive as indicated by a lack of input event processing\n for at least 15 seconds. To receive associated state change notifications\n and optionally handle an unresponsive render process implement\n cef_request_handler_t::OnRenderProcessUnresponsive. This function can only\n be called on the UI thread.\n"]
    pub is_render_process_unresponsive: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the runtime style for this browser (ALLOY or CHROME). See\n cef_runtime_style_t documentation for details.\n"]
    pub get_runtime_style: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_host_t) -> cef_runtime_style_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_browser_host_t"][::std::mem::size_of::<_cef_browser_host_t>() - 584usize];
    ["Alignment of _cef_browser_host_t"][::std::mem::align_of::<_cef_browser_host_t>() - 8usize];
    ["Offset of field: _cef_browser_host_t::base"]
        [::std::mem::offset_of!(_cef_browser_host_t, base) - 0usize];
    ["Offset of field: _cef_browser_host_t::get_browser"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_browser) - 40usize];
    ["Offset of field: _cef_browser_host_t::close_browser"]
        [::std::mem::offset_of!(_cef_browser_host_t, close_browser) - 48usize];
    ["Offset of field: _cef_browser_host_t::try_close_browser"]
        [::std::mem::offset_of!(_cef_browser_host_t, try_close_browser) - 56usize];
    ["Offset of field: _cef_browser_host_t::is_ready_to_be_closed"]
        [::std::mem::offset_of!(_cef_browser_host_t, is_ready_to_be_closed) - 64usize];
    ["Offset of field: _cef_browser_host_t::set_focus"]
        [::std::mem::offset_of!(_cef_browser_host_t, set_focus) - 72usize];
    ["Offset of field: _cef_browser_host_t::get_window_handle"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_window_handle) - 80usize];
    ["Offset of field: _cef_browser_host_t::get_opener_window_handle"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_opener_window_handle) - 88usize];
    ["Offset of field: _cef_browser_host_t::get_opener_identifier"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_opener_identifier) - 96usize];
    ["Offset of field: _cef_browser_host_t::has_view"]
        [::std::mem::offset_of!(_cef_browser_host_t, has_view) - 104usize];
    ["Offset of field: _cef_browser_host_t::get_client"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_client) - 112usize];
    ["Offset of field: _cef_browser_host_t::get_request_context"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_request_context) - 120usize];
    ["Offset of field: _cef_browser_host_t::can_zoom"]
        [::std::mem::offset_of!(_cef_browser_host_t, can_zoom) - 128usize];
    ["Offset of field: _cef_browser_host_t::zoom"]
        [::std::mem::offset_of!(_cef_browser_host_t, zoom) - 136usize];
    ["Offset of field: _cef_browser_host_t::get_default_zoom_level"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_default_zoom_level) - 144usize];
    ["Offset of field: _cef_browser_host_t::get_zoom_level"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_zoom_level) - 152usize];
    ["Offset of field: _cef_browser_host_t::set_zoom_level"]
        [::std::mem::offset_of!(_cef_browser_host_t, set_zoom_level) - 160usize];
    ["Offset of field: _cef_browser_host_t::run_file_dialog"]
        [::std::mem::offset_of!(_cef_browser_host_t, run_file_dialog) - 168usize];
    ["Offset of field: _cef_browser_host_t::start_download"]
        [::std::mem::offset_of!(_cef_browser_host_t, start_download) - 176usize];
    ["Offset of field: _cef_browser_host_t::download_image"]
        [::std::mem::offset_of!(_cef_browser_host_t, download_image) - 184usize];
    ["Offset of field: _cef_browser_host_t::print"]
        [::std::mem::offset_of!(_cef_browser_host_t, print) - 192usize];
    ["Offset of field: _cef_browser_host_t::print_to_pdf"]
        [::std::mem::offset_of!(_cef_browser_host_t, print_to_pdf) - 200usize];
    ["Offset of field: _cef_browser_host_t::find"]
        [::std::mem::offset_of!(_cef_browser_host_t, find) - 208usize];
    ["Offset of field: _cef_browser_host_t::stop_finding"]
        [::std::mem::offset_of!(_cef_browser_host_t, stop_finding) - 216usize];
    ["Offset of field: _cef_browser_host_t::show_dev_tools"]
        [::std::mem::offset_of!(_cef_browser_host_t, show_dev_tools) - 224usize];
    ["Offset of field: _cef_browser_host_t::close_dev_tools"]
        [::std::mem::offset_of!(_cef_browser_host_t, close_dev_tools) - 232usize];
    ["Offset of field: _cef_browser_host_t::has_dev_tools"]
        [::std::mem::offset_of!(_cef_browser_host_t, has_dev_tools) - 240usize];
    ["Offset of field: _cef_browser_host_t::send_dev_tools_message"]
        [::std::mem::offset_of!(_cef_browser_host_t, send_dev_tools_message) - 248usize];
    ["Offset of field: _cef_browser_host_t::execute_dev_tools_method"]
        [::std::mem::offset_of!(_cef_browser_host_t, execute_dev_tools_method) - 256usize];
    ["Offset of field: _cef_browser_host_t::add_dev_tools_message_observer"]
        [::std::mem::offset_of!(_cef_browser_host_t, add_dev_tools_message_observer) - 264usize];
    ["Offset of field: _cef_browser_host_t::get_navigation_entries"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_navigation_entries) - 272usize];
    ["Offset of field: _cef_browser_host_t::replace_misspelling"]
        [::std::mem::offset_of!(_cef_browser_host_t, replace_misspelling) - 280usize];
    ["Offset of field: _cef_browser_host_t::add_word_to_dictionary"]
        [::std::mem::offset_of!(_cef_browser_host_t, add_word_to_dictionary) - 288usize];
    ["Offset of field: _cef_browser_host_t::is_window_rendering_disabled"]
        [::std::mem::offset_of!(_cef_browser_host_t, is_window_rendering_disabled) - 296usize];
    ["Offset of field: _cef_browser_host_t::was_resized"]
        [::std::mem::offset_of!(_cef_browser_host_t, was_resized) - 304usize];
    ["Offset of field: _cef_browser_host_t::was_hidden"]
        [::std::mem::offset_of!(_cef_browser_host_t, was_hidden) - 312usize];
    ["Offset of field: _cef_browser_host_t::notify_screen_info_changed"]
        [::std::mem::offset_of!(_cef_browser_host_t, notify_screen_info_changed) - 320usize];
    ["Offset of field: _cef_browser_host_t::invalidate"]
        [::std::mem::offset_of!(_cef_browser_host_t, invalidate) - 328usize];
    ["Offset of field: _cef_browser_host_t::send_external_begin_frame"]
        [::std::mem::offset_of!(_cef_browser_host_t, send_external_begin_frame) - 336usize];
    ["Offset of field: _cef_browser_host_t::send_key_event"]
        [::std::mem::offset_of!(_cef_browser_host_t, send_key_event) - 344usize];
    ["Offset of field: _cef_browser_host_t::send_mouse_click_event"]
        [::std::mem::offset_of!(_cef_browser_host_t, send_mouse_click_event) - 352usize];
    ["Offset of field: _cef_browser_host_t::send_mouse_move_event"]
        [::std::mem::offset_of!(_cef_browser_host_t, send_mouse_move_event) - 360usize];
    ["Offset of field: _cef_browser_host_t::send_mouse_wheel_event"]
        [::std::mem::offset_of!(_cef_browser_host_t, send_mouse_wheel_event) - 368usize];
    ["Offset of field: _cef_browser_host_t::send_touch_event"]
        [::std::mem::offset_of!(_cef_browser_host_t, send_touch_event) - 376usize];
    ["Offset of field: _cef_browser_host_t::send_capture_lost_event"]
        [::std::mem::offset_of!(_cef_browser_host_t, send_capture_lost_event) - 384usize];
    ["Offset of field: _cef_browser_host_t::notify_move_or_resize_started"]
        [::std::mem::offset_of!(_cef_browser_host_t, notify_move_or_resize_started) - 392usize];
    ["Offset of field: _cef_browser_host_t::get_windowless_frame_rate"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_windowless_frame_rate) - 400usize];
    ["Offset of field: _cef_browser_host_t::set_windowless_frame_rate"]
        [::std::mem::offset_of!(_cef_browser_host_t, set_windowless_frame_rate) - 408usize];
    ["Offset of field: _cef_browser_host_t::ime_set_composition"]
        [::std::mem::offset_of!(_cef_browser_host_t, ime_set_composition) - 416usize];
    ["Offset of field: _cef_browser_host_t::ime_commit_text"]
        [::std::mem::offset_of!(_cef_browser_host_t, ime_commit_text) - 424usize];
    ["Offset of field: _cef_browser_host_t::ime_finish_composing_text"]
        [::std::mem::offset_of!(_cef_browser_host_t, ime_finish_composing_text) - 432usize];
    ["Offset of field: _cef_browser_host_t::ime_cancel_composition"]
        [::std::mem::offset_of!(_cef_browser_host_t, ime_cancel_composition) - 440usize];
    ["Offset of field: _cef_browser_host_t::drag_target_drag_enter"]
        [::std::mem::offset_of!(_cef_browser_host_t, drag_target_drag_enter) - 448usize];
    ["Offset of field: _cef_browser_host_t::drag_target_drag_over"]
        [::std::mem::offset_of!(_cef_browser_host_t, drag_target_drag_over) - 456usize];
    ["Offset of field: _cef_browser_host_t::drag_target_drag_leave"]
        [::std::mem::offset_of!(_cef_browser_host_t, drag_target_drag_leave) - 464usize];
    ["Offset of field: _cef_browser_host_t::drag_target_drop"]
        [::std::mem::offset_of!(_cef_browser_host_t, drag_target_drop) - 472usize];
    ["Offset of field: _cef_browser_host_t::drag_source_ended_at"]
        [::std::mem::offset_of!(_cef_browser_host_t, drag_source_ended_at) - 480usize];
    ["Offset of field: _cef_browser_host_t::drag_source_system_drag_ended"]
        [::std::mem::offset_of!(_cef_browser_host_t, drag_source_system_drag_ended) - 488usize];
    ["Offset of field: _cef_browser_host_t::get_visible_navigation_entry"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_visible_navigation_entry) - 496usize];
    ["Offset of field: _cef_browser_host_t::set_accessibility_state"]
        [::std::mem::offset_of!(_cef_browser_host_t, set_accessibility_state) - 504usize];
    ["Offset of field: _cef_browser_host_t::set_auto_resize_enabled"]
        [::std::mem::offset_of!(_cef_browser_host_t, set_auto_resize_enabled) - 512usize];
    ["Offset of field: _cef_browser_host_t::set_audio_muted"]
        [::std::mem::offset_of!(_cef_browser_host_t, set_audio_muted) - 520usize];
    ["Offset of field: _cef_browser_host_t::is_audio_muted"]
        [::std::mem::offset_of!(_cef_browser_host_t, is_audio_muted) - 528usize];
    ["Offset of field: _cef_browser_host_t::is_fullscreen"]
        [::std::mem::offset_of!(_cef_browser_host_t, is_fullscreen) - 536usize];
    ["Offset of field: _cef_browser_host_t::exit_fullscreen"]
        [::std::mem::offset_of!(_cef_browser_host_t, exit_fullscreen) - 544usize];
    ["Offset of field: _cef_browser_host_t::can_execute_chrome_command"]
        [::std::mem::offset_of!(_cef_browser_host_t, can_execute_chrome_command) - 552usize];
    ["Offset of field: _cef_browser_host_t::execute_chrome_command"]
        [::std::mem::offset_of!(_cef_browser_host_t, execute_chrome_command) - 560usize];
    ["Offset of field: _cef_browser_host_t::is_render_process_unresponsive"]
        [::std::mem::offset_of!(_cef_browser_host_t, is_render_process_unresponsive) - 568usize];
    ["Offset of field: _cef_browser_host_t::get_runtime_style"]
        [::std::mem::offset_of!(_cef_browser_host_t, get_runtime_style) - 576usize];
};
#[doc = "\n Structure used to represent the browser process aspects of a browser. The\n functions of this structure can only be called in the browser process. They\n may be called on any thread in that process unless otherwise indicated in\n the comments.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_browser_host_t = _cef_browser_host_t;
unsafe extern "C" {
    #[doc = "\n Create a new browser using the window parameters specified by |windowInfo|.\n All values will be copied internally and the actual window (if any) will be\n created on the UI thread. If |request_context| is NULL the global request\n context will be used. This function can be called on any browser process\n thread and will not block. The optional |extra_info| parameter provides an\n opportunity to specify extra information specific to the created browser\n that will be passed to cef_render_process_handler_t::on_browser_created() in\n the render process.\n"]
    pub fn cef_browser_host_create_browser(
        windowInfo: *const cef_window_info_t,
        client: *mut _cef_client_t,
        url: *const cef_string_t,
        settings: *const _cef_browser_settings_t,
        extra_info: *mut _cef_dictionary_value_t,
        request_context: *mut _cef_request_context_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Create a new browser using the window parameters specified by |windowInfo|.\n If |request_context| is NULL the global request context will be used. This\n function can only be called on the browser process UI thread. The optional\n |extra_info| parameter provides an opportunity to specify extra information\n specific to the created browser that will be passed to\n cef_render_process_handler_t::on_browser_created() in the render process.\n"]
    pub fn cef_browser_host_create_browser_sync(
        windowInfo: *const cef_window_info_t,
        client: *mut _cef_client_t,
        url: *const cef_string_t,
        settings: *const _cef_browser_settings_t,
        extra_info: *mut _cef_dictionary_value_t,
        request_context: *mut _cef_request_context_t,
    ) -> *mut cef_browser_t;
}
unsafe extern "C" {
    #[doc = "\n Returns the browser (if any) with the specified identifier.\n"]
    pub fn cef_browser_host_get_browser_by_identifier(
        browser_id: ::std::os::raw::c_int,
    ) -> *mut cef_browser_t;
}
#[doc = "\n Implement this structure to handle audio events.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_audio_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called on the UI thread to allow configuration of audio stream parameters.\n Return true (1) to proceed with audio stream capture, or false (0) to\n cancel it. All members of |params| can optionally be configured here, but\n they are also pre-filled with some sensible defaults.\n"]
    pub get_audio_parameters: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_audio_handler_t,
            browser: *mut _cef_browser_t,
            params: *mut cef_audio_parameters_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on a browser audio capture thread when the browser starts streaming\n audio. OnAudioStreamStopped will always be called after\n OnAudioStreamStarted; both functions may be called multiple times for the\n same browser. |params| contains the audio parameters like sample rate and\n channel layout. |channels| is the number of channels.\n"]
    pub on_audio_stream_started: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_audio_handler_t,
            browser: *mut _cef_browser_t,
            params: *const cef_audio_parameters_t,
            channels: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called on the audio stream thread when a PCM packet is received for the\n stream. |data| is an array representing the raw PCM data as a floating\n point type, i.e. 4-byte value(s). |frames| is the number of frames in the\n PCM packet. |pts| is the presentation timestamp (in milliseconds since the\n Unix Epoch) and represents the time at which the decompressed packet\n should be presented to the user. Based on |frames| and the\n |channel_layout| value passed to OnAudioStreamStarted you can calculate\n the size of the |data| array in bytes.\n"]
    pub on_audio_stream_packet: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_audio_handler_t,
            browser: *mut _cef_browser_t,
            data: *mut *const f32,
            frames: ::std::os::raw::c_int,
            pts: i64,
        ),
    >,
    #[doc = "\n Called on the UI thread when the stream has stopped. OnAudioSteamStopped\n will always be called after OnAudioStreamStarted; both functions may be\n called multiple times for the same stream.\n"]
    pub on_audio_stream_stopped: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_audio_handler_t, browser: *mut _cef_browser_t),
    >,
    #[doc = "\n Called on the UI or audio stream thread when an error occurred. During the\n stream creation phase this callback will be called on the UI thread while\n in the capturing phase it will be called on the audio stream thread. The\n stream will be stopped immediately.\n"]
    pub on_audio_stream_error: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_audio_handler_t,
            browser: *mut _cef_browser_t,
            message: *const cef_string_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_audio_handler_t"][::std::mem::size_of::<_cef_audio_handler_t>() - 80usize];
    ["Alignment of _cef_audio_handler_t"][::std::mem::align_of::<_cef_audio_handler_t>() - 8usize];
    ["Offset of field: _cef_audio_handler_t::base"]
        [::std::mem::offset_of!(_cef_audio_handler_t, base) - 0usize];
    ["Offset of field: _cef_audio_handler_t::get_audio_parameters"]
        [::std::mem::offset_of!(_cef_audio_handler_t, get_audio_parameters) - 40usize];
    ["Offset of field: _cef_audio_handler_t::on_audio_stream_started"]
        [::std::mem::offset_of!(_cef_audio_handler_t, on_audio_stream_started) - 48usize];
    ["Offset of field: _cef_audio_handler_t::on_audio_stream_packet"]
        [::std::mem::offset_of!(_cef_audio_handler_t, on_audio_stream_packet) - 56usize];
    ["Offset of field: _cef_audio_handler_t::on_audio_stream_stopped"]
        [::std::mem::offset_of!(_cef_audio_handler_t, on_audio_stream_stopped) - 64usize];
    ["Offset of field: _cef_audio_handler_t::on_audio_stream_error"]
        [::std::mem::offset_of!(_cef_audio_handler_t, on_audio_stream_error) - 72usize];
};
#[doc = "\n Implement this structure to handle audio events.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_audio_handler_t = _cef_audio_handler_t;
#[doc = "\n Implement this structure to handle events related to commands. The functions\n of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_command_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called to execute a Chrome command triggered via menu selection or\n keyboard shortcut. Use the cef_id_for_command_id_name() function for\n version-safe mapping of command IDC names from cef_command_ids.h to\n version-specific numerical |command_id| values. |disposition| provides\n information about the intended command target. Return true (1) if the\n command was handled or false (0) for the default implementation. For\n context menu commands this will be called after\n cef_context_menu_handler_t::OnContextMenuCommand. Only used with Chrome\n style.\n"]
    pub on_chrome_command: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_handler_t,
            browser: *mut _cef_browser_t,
            command_id: ::std::os::raw::c_int,
            disposition: cef_window_open_disposition_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to check if a Chrome app menu item should be visible. Use the\n cef_id_for_command_id_name() function for version-safe mapping of command\n IDC names from cef_command_ids.h to version-specific numerical\n |command_id| values. Only called for menu items that would be visible by\n default. Only used with Chrome style.\n"]
    pub is_chrome_app_menu_item_visible: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_handler_t,
            browser: *mut _cef_browser_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to check if a Chrome app menu item should be enabled. Use the\n cef_id_for_command_id_name() function for version-safe mapping of command\n IDC names from cef_command_ids.h to version-specific numerical\n |command_id| values. Only called for menu items that would be enabled by\n default. Only used with Chrome style.\n"]
    pub is_chrome_app_menu_item_enabled: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_handler_t,
            browser: *mut _cef_browser_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called during browser creation to check if a Chrome page action icon\n should be visible. Only called for icons that would be visible by default.\n Only used with Chrome style.\n"]
    pub is_chrome_page_action_icon_visible: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_handler_t,
            icon_type: cef_chrome_page_action_icon_type_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called during browser creation to check if a Chrome toolbar button should\n be visible. Only called for buttons that would be visible by default. Only\n used with Chrome style.\n"]
    pub is_chrome_toolbar_button_visible: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_handler_t,
            button_type: cef_chrome_toolbar_button_type_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_command_handler_t"][::std::mem::size_of::<_cef_command_handler_t>() - 80usize];
    ["Alignment of _cef_command_handler_t"]
        [::std::mem::align_of::<_cef_command_handler_t>() - 8usize];
    ["Offset of field: _cef_command_handler_t::base"]
        [::std::mem::offset_of!(_cef_command_handler_t, base) - 0usize];
    ["Offset of field: _cef_command_handler_t::on_chrome_command"]
        [::std::mem::offset_of!(_cef_command_handler_t, on_chrome_command) - 40usize];
    ["Offset of field: _cef_command_handler_t::is_chrome_app_menu_item_visible"]
        [::std::mem::offset_of!(_cef_command_handler_t, is_chrome_app_menu_item_visible) - 48usize];
    ["Offset of field: _cef_command_handler_t::is_chrome_app_menu_item_enabled"]
        [::std::mem::offset_of!(_cef_command_handler_t, is_chrome_app_menu_item_enabled) - 56usize];
    ["Offset of field: _cef_command_handler_t::is_chrome_page_action_icon_visible"][::std::mem::offset_of!(
        _cef_command_handler_t,
        is_chrome_page_action_icon_visible
    ) - 64usize];
    ["Offset of field: _cef_command_handler_t::is_chrome_toolbar_button_visible"][::std::mem::offset_of!(
        _cef_command_handler_t,
        is_chrome_toolbar_button_visible
    ) - 72usize];
};
#[doc = "\n Implement this structure to handle events related to commands. The functions\n of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_command_handler_t = _cef_command_handler_t;
#[doc = "\n Implement this structure to handle menu model events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_menu_model_delegate_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Perform the action associated with the specified |command_id| and optional\n |event_flags|.\n"]
    pub execute_command: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_delegate_t,
            menu_model: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            event_flags: cef_event_flags_t,
        ),
    >,
    #[doc = "\n Called when the user moves the mouse outside the menu and over the owning\n window.\n"]
    pub mouse_outside_menu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_delegate_t,
            menu_model: *mut _cef_menu_model_t,
            screen_point: *const cef_point_t,
        ),
    >,
    #[doc = "\n Called on unhandled open submenu keyboard commands. |is_rtl| will be true\n (1) if the menu is displaying a right-to-left language.\n"]
    pub unhandled_open_submenu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_delegate_t,
            menu_model: *mut _cef_menu_model_t,
            is_rtl: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called on unhandled close submenu keyboard commands. |is_rtl| will be true\n (1) if the menu is displaying a right-to-left language.\n"]
    pub unhandled_close_submenu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_delegate_t,
            menu_model: *mut _cef_menu_model_t,
            is_rtl: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n The menu is about to show.\n"]
    pub menu_will_show: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_delegate_t,
            menu_model: *mut _cef_menu_model_t,
        ),
    >,
    #[doc = "\n The menu has closed.\n"]
    pub menu_closed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_delegate_t,
            menu_model: *mut _cef_menu_model_t,
        ),
    >,
    #[doc = "\n Optionally modify a menu item label. Return true (1) if |label| was\n modified.\n"]
    pub format_label: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_delegate_t,
            menu_model: *mut _cef_menu_model_t,
            label: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_menu_model_delegate_t"]
        [::std::mem::size_of::<_cef_menu_model_delegate_t>() - 96usize];
    ["Alignment of _cef_menu_model_delegate_t"]
        [::std::mem::align_of::<_cef_menu_model_delegate_t>() - 8usize];
    ["Offset of field: _cef_menu_model_delegate_t::base"]
        [::std::mem::offset_of!(_cef_menu_model_delegate_t, base) - 0usize];
    ["Offset of field: _cef_menu_model_delegate_t::execute_command"]
        [::std::mem::offset_of!(_cef_menu_model_delegate_t, execute_command) - 40usize];
    ["Offset of field: _cef_menu_model_delegate_t::mouse_outside_menu"]
        [::std::mem::offset_of!(_cef_menu_model_delegate_t, mouse_outside_menu) - 48usize];
    ["Offset of field: _cef_menu_model_delegate_t::unhandled_open_submenu"]
        [::std::mem::offset_of!(_cef_menu_model_delegate_t, unhandled_open_submenu) - 56usize];
    ["Offset of field: _cef_menu_model_delegate_t::unhandled_close_submenu"]
        [::std::mem::offset_of!(_cef_menu_model_delegate_t, unhandled_close_submenu) - 64usize];
    ["Offset of field: _cef_menu_model_delegate_t::menu_will_show"]
        [::std::mem::offset_of!(_cef_menu_model_delegate_t, menu_will_show) - 72usize];
    ["Offset of field: _cef_menu_model_delegate_t::menu_closed"]
        [::std::mem::offset_of!(_cef_menu_model_delegate_t, menu_closed) - 80usize];
    ["Offset of field: _cef_menu_model_delegate_t::format_label"]
        [::std::mem::offset_of!(_cef_menu_model_delegate_t, format_label) - 88usize];
};
#[doc = "\n Implement this structure to handle menu model events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_menu_model_delegate_t = _cef_menu_model_delegate_t;
#[doc = "\n Supports creation and modification of menus. See cef_menu_id_t for the\n command ids that have default implementations. All user-defined command ids\n should be between MENU_ID_USER_FIRST and MENU_ID_USER_LAST. The functions of\n this structure can only be accessed on the browser process the UI thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_menu_model_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this menu is a submenu.\n"]
    pub is_sub_menu: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Clears the menu. Returns true (1) on success.\n"]
    pub clear: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the number of items in this menu.\n"]
    pub get_count:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_menu_model_t) -> usize>,
    #[doc = "\n Add a separator to the menu. Returns true (1) on success.\n"]
    pub add_separator: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add an item to the menu. Returns true (1) on success.\n"]
    pub add_item: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add a check item to the menu. Returns true (1) on success.\n"]
    pub add_check_item: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add a radio item to the menu. Only a single item with the specified\n |group_id| can be checked at a time. Returns true (1) on success.\n"]
    pub add_radio_item: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
            group_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Add a sub-menu to the menu. The new sub-menu is returned.\n"]
    pub add_sub_menu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
        ) -> *mut _cef_menu_model_t,
    >,
    #[doc = "\n Insert a separator in the menu at the specified |index|. Returns true (1)\n on success.\n"]
    pub insert_separator_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Insert an item in the menu at the specified |index|. Returns true (1) on\n success.\n"]
    pub insert_item_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Insert a check item in the menu at the specified |index|. Returns true (1)\n on success.\n"]
    pub insert_check_item_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Insert a radio item in the menu at the specified |index|. Only a single\n item with the specified |group_id| can be checked at a time. Returns true\n (1) on success.\n"]
    pub insert_radio_item_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
            group_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Insert a sub-menu in the menu at the specified |index|. The new sub-menu\n is returned.\n"]
    pub insert_sub_menu_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
        ) -> *mut _cef_menu_model_t,
    >,
    #[doc = "\n Removes the item with the specified |command_id|. Returns true (1) on\n success.\n"]
    pub remove: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Removes the item at the specified |index|. Returns true (1) on success.\n"]
    pub remove_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the index associated with the specified |command_id| or -1 if not\n found due to the command id not existing in the menu.\n"]
    pub get_index_of: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the command id at the specified |index| or -1 if not found due to\n invalid range or the index being a separator.\n"]
    pub get_command_id_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the command id at the specified |index|. Returns true (1) on success.\n"]
    pub set_command_id_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the label for the specified |command_id| or NULL if not found.\n"]
    pub get_label: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the label at the specified |index| or NULL if not found due to\n invalid range or the index being a separator.\n"]
    pub get_label_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> cef_string_userfree_t,
    >,
    #[doc = "\n Sets the label for the specified |command_id|. Returns true (1) on\n success.\n"]
    pub set_label: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            label: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the label at the specified |index|. Returns true (1) on success.\n"]
    pub set_label_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            label: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the item type for the specified |command_id|.\n"]
    pub get_type: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> cef_menu_item_type_t,
    >,
    #[doc = "\n Returns the item type at the specified |index|.\n"]
    pub get_type_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> cef_menu_item_type_t,
    >,
    #[doc = "\n Returns the group id for the specified |command_id| or -1 if invalid.\n"]
    pub get_group_id: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the group id at the specified |index| or -1 if invalid.\n"]
    pub get_group_id_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the group id for the specified |command_id|. Returns true (1) on\n success.\n"]
    pub set_group_id: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            group_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the group id at the specified |index|. Returns true (1) on success.\n"]
    pub set_group_id_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            group_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the submenu for the specified |command_id| or NULL if invalid.\n"]
    pub get_sub_menu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> *mut _cef_menu_model_t,
    >,
    #[doc = "\n Returns the submenu at the specified |index| or NULL if invalid.\n"]
    pub get_sub_menu_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> *mut _cef_menu_model_t,
    >,
    #[doc = "\n Returns true (1) if the specified |command_id| is visible.\n"]
    pub is_visible: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the specified |index| is visible.\n"]
    pub is_visible_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Change the visibility of the specified |command_id|. Returns true (1) on\n success.\n"]
    pub set_visible: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            visible: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Change the visibility at the specified |index|. Returns true (1) on\n success.\n"]
    pub set_visible_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            visible: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the specified |command_id| is enabled.\n"]
    pub is_enabled: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the specified |index| is enabled.\n"]
    pub is_enabled_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Change the enabled status of the specified |command_id|. Returns true (1)\n on success.\n"]
    pub set_enabled: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            enabled: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Change the enabled status at the specified |index|. Returns true (1) on\n success.\n"]
    pub set_enabled_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            enabled: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the specified |command_id| is checked. Only applies to\n check and radio items.\n"]
    pub is_checked: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the specified |index| is checked. Only applies to\n check and radio items.\n"]
    pub is_checked_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Check the specified |command_id|. Only applies to check and radio items.\n Returns true (1) on success.\n"]
    pub set_checked: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            checked: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Check the specified |index|. Only applies to check and radio items.\n Returns true (1) on success.\n"]
    pub set_checked_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            checked: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the specified |command_id| has a keyboard accelerator\n assigned.\n"]
    pub has_accelerator: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the specified |index| has a keyboard accelerator\n assigned.\n"]
    pub has_accelerator_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the keyboard accelerator for the specified |command_id|. |key_code|\n can be any virtual key or character value. Returns true (1) on success.\n"]
    pub set_accelerator: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            key_code: ::std::os::raw::c_int,
            shift_pressed: ::std::os::raw::c_int,
            ctrl_pressed: ::std::os::raw::c_int,
            alt_pressed: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the keyboard accelerator at the specified |index|. |key_code| can be\n any virtual key or character value. Returns true (1) on success.\n"]
    pub set_accelerator_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            key_code: ::std::os::raw::c_int,
            shift_pressed: ::std::os::raw::c_int,
            ctrl_pressed: ::std::os::raw::c_int,
            alt_pressed: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Remove the keyboard accelerator for the specified |command_id|. Returns\n true (1) on success.\n"]
    pub remove_accelerator: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Remove the keyboard accelerator at the specified |index|. Returns true (1)\n on success.\n"]
    pub remove_accelerator_at: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_menu_model_t, index: usize) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Retrieves the keyboard accelerator for the specified |command_id|. Returns\n true (1) on success.\n"]
    pub get_accelerator: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            key_code: *mut ::std::os::raw::c_int,
            shift_pressed: *mut ::std::os::raw::c_int,
            ctrl_pressed: *mut ::std::os::raw::c_int,
            alt_pressed: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Retrieves the keyboard accelerator for the specified |index|. Returns true\n (1) on success.\n"]
    pub get_accelerator_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: usize,
            key_code: *mut ::std::os::raw::c_int,
            shift_pressed: *mut ::std::os::raw::c_int,
            ctrl_pressed: *mut ::std::os::raw::c_int,
            alt_pressed: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the explicit color for |command_id| and |color_type| to |color|.\n Specify a |color| value of 0 to remove the explicit color. If no explicit\n color or default color is set for |color_type| then the system color will\n be used. Returns true (1) on success.\n"]
    pub set_color: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            color_type: cef_menu_color_type_t,
            color: cef_color_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the explicit color for |command_id| and |index| to |color|. Specify a\n |color| value of 0 to remove the explicit color. Specify an |index| value\n of -1 to set the default color for items that do not have an explicit\n color set. If no explicit color or default color is set for |color_type|\n then the system color will be used. Returns true (1) on success.\n"]
    pub set_color_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: ::std::os::raw::c_int,
            color_type: cef_menu_color_type_t,
            color: cef_color_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns in |color| the color that was explicitly set for |command_id| and\n |color_type|. If a color was not set then 0 will be returned in |color|.\n Returns true (1) on success.\n"]
    pub get_color: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            color_type: cef_menu_color_type_t,
            color: *mut cef_color_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns in |color| the color that was explicitly set for |command_id| and\n |color_type|. Specify an |index| value of -1 to return the default color\n in |color|. If a color was not set then 0 will be returned in |color|.\n Returns true (1) on success.\n"]
    pub get_color_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: ::std::os::raw::c_int,
            color_type: cef_menu_color_type_t,
            color: *mut cef_color_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the font list for the specified |command_id|. If |font_list| is NULL\n the system font will be used. Returns true (1) on success. The format is\n \"<FONT_FAMILY_LIST>,[STYLES] <SIZE>\", where:\n - FONT_FAMILY_LIST is a comma-separated list of font family names,\n - STYLES is an optional space-separated list of style names (case-\n   sensitive \"Bold\" and \"Italic\" are supported), and\n - SIZE is an integer font size in pixels with the suffix \"px\".\n\n Here are examples of valid font description strings:\n - \"Arial, Helvetica, Bold Italic 14px\"\n - \"Arial, 14px\"\n"]
    pub set_font_list: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            command_id: ::std::os::raw::c_int,
            font_list: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the font list for the specified |index|. Specify an |index| value of\n - 1 to set the default font. If |font_list| is NULL the system font will\n - FONT_FAMILY_LIST is a comma-separated list of font family names,\n - STYLES is an optional space-separated list of style names (case-\n   sensitive \"Bold\" and \"Italic\" are supported), and\n - SIZE is an integer font size in pixels with the suffix \"px\".\n\n Here are examples of valid font description strings:\n - \"Arial, Helvetica, Bold Italic 14px\"\n - \"Arial, 14px\"\n"]
    pub set_font_list_at: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_model_t,
            index: ::std::os::raw::c_int,
            font_list: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_menu_model_t"][::std::mem::size_of::<_cef_menu_model_t>() - 488usize];
    ["Alignment of _cef_menu_model_t"][::std::mem::align_of::<_cef_menu_model_t>() - 8usize];
    ["Offset of field: _cef_menu_model_t::base"]
        [::std::mem::offset_of!(_cef_menu_model_t, base) - 0usize];
    ["Offset of field: _cef_menu_model_t::is_sub_menu"]
        [::std::mem::offset_of!(_cef_menu_model_t, is_sub_menu) - 40usize];
    ["Offset of field: _cef_menu_model_t::clear"]
        [::std::mem::offset_of!(_cef_menu_model_t, clear) - 48usize];
    ["Offset of field: _cef_menu_model_t::get_count"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_count) - 56usize];
    ["Offset of field: _cef_menu_model_t::add_separator"]
        [::std::mem::offset_of!(_cef_menu_model_t, add_separator) - 64usize];
    ["Offset of field: _cef_menu_model_t::add_item"]
        [::std::mem::offset_of!(_cef_menu_model_t, add_item) - 72usize];
    ["Offset of field: _cef_menu_model_t::add_check_item"]
        [::std::mem::offset_of!(_cef_menu_model_t, add_check_item) - 80usize];
    ["Offset of field: _cef_menu_model_t::add_radio_item"]
        [::std::mem::offset_of!(_cef_menu_model_t, add_radio_item) - 88usize];
    ["Offset of field: _cef_menu_model_t::add_sub_menu"]
        [::std::mem::offset_of!(_cef_menu_model_t, add_sub_menu) - 96usize];
    ["Offset of field: _cef_menu_model_t::insert_separator_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, insert_separator_at) - 104usize];
    ["Offset of field: _cef_menu_model_t::insert_item_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, insert_item_at) - 112usize];
    ["Offset of field: _cef_menu_model_t::insert_check_item_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, insert_check_item_at) - 120usize];
    ["Offset of field: _cef_menu_model_t::insert_radio_item_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, insert_radio_item_at) - 128usize];
    ["Offset of field: _cef_menu_model_t::insert_sub_menu_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, insert_sub_menu_at) - 136usize];
    ["Offset of field: _cef_menu_model_t::remove"]
        [::std::mem::offset_of!(_cef_menu_model_t, remove) - 144usize];
    ["Offset of field: _cef_menu_model_t::remove_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, remove_at) - 152usize];
    ["Offset of field: _cef_menu_model_t::get_index_of"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_index_of) - 160usize];
    ["Offset of field: _cef_menu_model_t::get_command_id_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_command_id_at) - 168usize];
    ["Offset of field: _cef_menu_model_t::set_command_id_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_command_id_at) - 176usize];
    ["Offset of field: _cef_menu_model_t::get_label"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_label) - 184usize];
    ["Offset of field: _cef_menu_model_t::get_label_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_label_at) - 192usize];
    ["Offset of field: _cef_menu_model_t::set_label"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_label) - 200usize];
    ["Offset of field: _cef_menu_model_t::set_label_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_label_at) - 208usize];
    ["Offset of field: _cef_menu_model_t::get_type"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_type) - 216usize];
    ["Offset of field: _cef_menu_model_t::get_type_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_type_at) - 224usize];
    ["Offset of field: _cef_menu_model_t::get_group_id"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_group_id) - 232usize];
    ["Offset of field: _cef_menu_model_t::get_group_id_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_group_id_at) - 240usize];
    ["Offset of field: _cef_menu_model_t::set_group_id"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_group_id) - 248usize];
    ["Offset of field: _cef_menu_model_t::set_group_id_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_group_id_at) - 256usize];
    ["Offset of field: _cef_menu_model_t::get_sub_menu"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_sub_menu) - 264usize];
    ["Offset of field: _cef_menu_model_t::get_sub_menu_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_sub_menu_at) - 272usize];
    ["Offset of field: _cef_menu_model_t::is_visible"]
        [::std::mem::offset_of!(_cef_menu_model_t, is_visible) - 280usize];
    ["Offset of field: _cef_menu_model_t::is_visible_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, is_visible_at) - 288usize];
    ["Offset of field: _cef_menu_model_t::set_visible"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_visible) - 296usize];
    ["Offset of field: _cef_menu_model_t::set_visible_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_visible_at) - 304usize];
    ["Offset of field: _cef_menu_model_t::is_enabled"]
        [::std::mem::offset_of!(_cef_menu_model_t, is_enabled) - 312usize];
    ["Offset of field: _cef_menu_model_t::is_enabled_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, is_enabled_at) - 320usize];
    ["Offset of field: _cef_menu_model_t::set_enabled"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_enabled) - 328usize];
    ["Offset of field: _cef_menu_model_t::set_enabled_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_enabled_at) - 336usize];
    ["Offset of field: _cef_menu_model_t::is_checked"]
        [::std::mem::offset_of!(_cef_menu_model_t, is_checked) - 344usize];
    ["Offset of field: _cef_menu_model_t::is_checked_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, is_checked_at) - 352usize];
    ["Offset of field: _cef_menu_model_t::set_checked"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_checked) - 360usize];
    ["Offset of field: _cef_menu_model_t::set_checked_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_checked_at) - 368usize];
    ["Offset of field: _cef_menu_model_t::has_accelerator"]
        [::std::mem::offset_of!(_cef_menu_model_t, has_accelerator) - 376usize];
    ["Offset of field: _cef_menu_model_t::has_accelerator_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, has_accelerator_at) - 384usize];
    ["Offset of field: _cef_menu_model_t::set_accelerator"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_accelerator) - 392usize];
    ["Offset of field: _cef_menu_model_t::set_accelerator_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_accelerator_at) - 400usize];
    ["Offset of field: _cef_menu_model_t::remove_accelerator"]
        [::std::mem::offset_of!(_cef_menu_model_t, remove_accelerator) - 408usize];
    ["Offset of field: _cef_menu_model_t::remove_accelerator_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, remove_accelerator_at) - 416usize];
    ["Offset of field: _cef_menu_model_t::get_accelerator"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_accelerator) - 424usize];
    ["Offset of field: _cef_menu_model_t::get_accelerator_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_accelerator_at) - 432usize];
    ["Offset of field: _cef_menu_model_t::set_color"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_color) - 440usize];
    ["Offset of field: _cef_menu_model_t::set_color_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_color_at) - 448usize];
    ["Offset of field: _cef_menu_model_t::get_color"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_color) - 456usize];
    ["Offset of field: _cef_menu_model_t::get_color_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, get_color_at) - 464usize];
    ["Offset of field: _cef_menu_model_t::set_font_list"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_font_list) - 472usize];
    ["Offset of field: _cef_menu_model_t::set_font_list_at"]
        [::std::mem::offset_of!(_cef_menu_model_t, set_font_list_at) - 480usize];
};
#[doc = "\n Supports creation and modification of menus. See cef_menu_id_t for the\n command ids that have default implementations. All user-defined command ids\n should be between MENU_ID_USER_FIRST and MENU_ID_USER_LAST. The functions of\n this structure can only be accessed on the browser process the UI thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_menu_model_t = _cef_menu_model_t;
unsafe extern "C" {
    #[doc = "\n Create a new MenuModel with the specified |delegate|.\n"]
    pub fn cef_menu_model_create(
        delegate: *mut _cef_menu_model_delegate_t,
    ) -> *mut cef_menu_model_t;
}
#[doc = "\n Callback structure used for continuation of custom context menu display.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_run_context_menu_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Complete context menu display by selecting the specified |command_id| and\n |event_flags|.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_run_context_menu_callback_t,
            command_id: ::std::os::raw::c_int,
            event_flags: cef_event_flags_t,
        ),
    >,
    #[doc = "\n Cancel context menu display.\n"]
    pub cancel:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_run_context_menu_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_run_context_menu_callback_t"]
        [::std::mem::size_of::<_cef_run_context_menu_callback_t>() - 56usize];
    ["Alignment of _cef_run_context_menu_callback_t"]
        [::std::mem::align_of::<_cef_run_context_menu_callback_t>() - 8usize];
    ["Offset of field: _cef_run_context_menu_callback_t::base"]
        [::std::mem::offset_of!(_cef_run_context_menu_callback_t, base) - 0usize];
    ["Offset of field: _cef_run_context_menu_callback_t::cont"]
        [::std::mem::offset_of!(_cef_run_context_menu_callback_t, cont) - 40usize];
    ["Offset of field: _cef_run_context_menu_callback_t::cancel"]
        [::std::mem::offset_of!(_cef_run_context_menu_callback_t, cancel) - 48usize];
};
#[doc = "\n Callback structure used for continuation of custom context menu display.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_run_context_menu_callback_t = _cef_run_context_menu_callback_t;
#[doc = "\n Callback structure used for continuation of custom quick menu display.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_run_quick_menu_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Complete quick menu display by selecting the specified |command_id| and\n |event_flags|.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_run_quick_menu_callback_t,
            command_id: ::std::os::raw::c_int,
            event_flags: cef_event_flags_t,
        ),
    >,
    #[doc = "\n Cancel quick menu display.\n"]
    pub cancel:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_run_quick_menu_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_run_quick_menu_callback_t"]
        [::std::mem::size_of::<_cef_run_quick_menu_callback_t>() - 56usize];
    ["Alignment of _cef_run_quick_menu_callback_t"]
        [::std::mem::align_of::<_cef_run_quick_menu_callback_t>() - 8usize];
    ["Offset of field: _cef_run_quick_menu_callback_t::base"]
        [::std::mem::offset_of!(_cef_run_quick_menu_callback_t, base) - 0usize];
    ["Offset of field: _cef_run_quick_menu_callback_t::cont"]
        [::std::mem::offset_of!(_cef_run_quick_menu_callback_t, cont) - 40usize];
    ["Offset of field: _cef_run_quick_menu_callback_t::cancel"]
        [::std::mem::offset_of!(_cef_run_quick_menu_callback_t, cancel) - 48usize];
};
#[doc = "\n Callback structure used for continuation of custom quick menu display.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_run_quick_menu_callback_t = _cef_run_quick_menu_callback_t;
#[doc = "\n Implement this structure to handle context menu events. The functions of\n this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_context_menu_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called before a context menu is displayed. |params| provides information\n about the context menu state. |model| initially contains the default\n context menu. The |model| can be cleared to show no context menu or\n modified to show a custom menu. Do not keep references to |params| or\n |model| outside of this callback.\n"]
    pub on_before_context_menu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            params: *mut _cef_context_menu_params_t,
            model: *mut _cef_menu_model_t,
        ),
    >,
    #[doc = "\n Called to allow custom display of the context menu. |params| provides\n information about the context menu state. |model| contains the context\n menu model resulting from OnBeforeContextMenu. For custom display return\n true (1) and execute |callback| either synchronously or asynchronously\n with the selected command ID. For default display return false (0). Do not\n keep references to |params| or |model| outside of this callback.\n"]
    pub run_context_menu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            params: *mut _cef_context_menu_params_t,
            model: *mut _cef_menu_model_t,
            callback: *mut _cef_run_context_menu_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to execute a command selected from the context menu. Return true\n (1) if the command was handled or false (0) for the default\n implementation. See cef_menu_id_t for the command ids that have default\n implementations. All user-defined command ids should be between\n MENU_ID_USER_FIRST and MENU_ID_USER_LAST. |params| will have the same\n values as what was passed to on_before_context_menu(). Do not keep a\n reference to |params| outside of this callback.\n"]
    pub on_context_menu_command: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            params: *mut _cef_context_menu_params_t,
            command_id: ::std::os::raw::c_int,
            event_flags: cef_event_flags_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the context menu is dismissed irregardless of whether the menu\n was canceled or a command was selected.\n"]
    pub on_context_menu_dismissed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
        ),
    >,
    #[doc = "\n Called to allow custom display of the quick menu for a windowless browser.\n |location| is the top left corner of the selected region. |size| is the\n size of the selected region. |edit_state_flags| is a combination of flags\n that represent the state of the quick menu. Return true (1) if the menu\n will be handled and execute |callback| either synchronously or\n asynchronously with the selected command ID. Return false (0) to cancel\n the menu.\n"]
    pub run_quick_menu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            location: *const cef_point_t,
            size: *const cef_size_t,
            edit_state_flags: cef_quick_menu_edit_state_flags_t,
            callback: *mut _cef_run_quick_menu_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to execute a command selected from the quick menu for a windowless\n browser. Return true (1) if the command was handled or false (0) for the\n default implementation. See cef_menu_id_t for command IDs that have\n default implementations.\n"]
    pub on_quick_menu_command: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            command_id: ::std::os::raw::c_int,
            event_flags: cef_event_flags_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the quick menu for a windowless browser is dismissed\n irregardless of whether the menu was canceled or a command was selected.\n"]
    pub on_quick_menu_dismissed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_context_menu_handler_t"]
        [::std::mem::size_of::<_cef_context_menu_handler_t>() - 96usize];
    ["Alignment of _cef_context_menu_handler_t"]
        [::std::mem::align_of::<_cef_context_menu_handler_t>() - 8usize];
    ["Offset of field: _cef_context_menu_handler_t::base"]
        [::std::mem::offset_of!(_cef_context_menu_handler_t, base) - 0usize];
    ["Offset of field: _cef_context_menu_handler_t::on_before_context_menu"]
        [::std::mem::offset_of!(_cef_context_menu_handler_t, on_before_context_menu) - 40usize];
    ["Offset of field: _cef_context_menu_handler_t::run_context_menu"]
        [::std::mem::offset_of!(_cef_context_menu_handler_t, run_context_menu) - 48usize];
    ["Offset of field: _cef_context_menu_handler_t::on_context_menu_command"]
        [::std::mem::offset_of!(_cef_context_menu_handler_t, on_context_menu_command) - 56usize];
    ["Offset of field: _cef_context_menu_handler_t::on_context_menu_dismissed"]
        [::std::mem::offset_of!(_cef_context_menu_handler_t, on_context_menu_dismissed) - 64usize];
    ["Offset of field: _cef_context_menu_handler_t::run_quick_menu"]
        [::std::mem::offset_of!(_cef_context_menu_handler_t, run_quick_menu) - 72usize];
    ["Offset of field: _cef_context_menu_handler_t::on_quick_menu_command"]
        [::std::mem::offset_of!(_cef_context_menu_handler_t, on_quick_menu_command) - 80usize];
    ["Offset of field: _cef_context_menu_handler_t::on_quick_menu_dismissed"]
        [::std::mem::offset_of!(_cef_context_menu_handler_t, on_quick_menu_dismissed) - 88usize];
};
#[doc = "\n Implement this structure to handle context menu events. The functions of\n this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_context_menu_handler_t = _cef_context_menu_handler_t;
#[doc = "\n Provides information about the context menu state. The functions of this\n structure can only be accessed on browser process the UI thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_context_menu_params_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the X coordinate of the mouse where the context menu was invoked.\n Coords are relative to the associated RenderView's origin.\n"]
    pub get_xcoord: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the Y coordinate of the mouse where the context menu was invoked.\n Coords are relative to the associated RenderView's origin.\n"]
    pub get_ycoord: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns flags representing the type of node that the context menu was\n invoked on.\n"]
    pub get_type_flags: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_params_t,
        ) -> cef_context_menu_type_flags_t,
    >,
    #[doc = "\n Returns the URL of the link, if any, that encloses the node that the\n context menu was invoked on.\n"]
    pub get_link_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the link URL, if any, to be used ONLY for \"copy link address\". We\n don't validate this field in the frontend process.\n"]
    pub get_unfiltered_link_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the source URL, if any, for the element that the context menu was\n invoked on. Example of elements with source URLs are img, audio, and\n video.\n"]
    pub get_source_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns true (1) if the context menu was invoked on an image which has\n non-NULL contents.\n"]
    pub has_image_contents: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the title text or the alt text if the context menu was invoked on\n an image.\n"]
    pub get_title_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the URL of the top level page that the context menu was invoked\n on.\n"]
    pub get_page_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the URL of the subframe that the context menu was invoked on.\n"]
    pub get_frame_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the character encoding of the subframe that the context menu was\n invoked on.\n"]
    pub get_frame_charset: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the type of context node that the context menu was invoked on.\n"]
    pub get_media_type: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_params_t,
        ) -> cef_context_menu_media_type_t,
    >,
    #[doc = "\n Returns flags representing the actions supported by the media element, if\n any, that the context menu was invoked on.\n"]
    pub get_media_state_flags: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_params_t,
        ) -> cef_context_menu_media_state_flags_t,
    >,
    #[doc = "\n Returns the text of the selection, if any, that the context menu was\n invoked on.\n"]
    pub get_selection_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the text of the misspelled word, if any, that the context menu was\n invoked on.\n"]
    pub get_misspelled_word: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns true (1) if suggestions exist, false (0) otherwise. Fills in\n |suggestions| from the spell check service for the misspelled word if\n there is one.\n"]
    pub get_dictionary_suggestions: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_params_t,
            suggestions: cef_string_list_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the context menu was invoked on an editable node.\n"]
    pub is_editable: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the context menu was invoked on an editable node where\n spell-check is enabled.\n"]
    pub is_spell_check_enabled: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns flags representing the actions supported by the editable node, if\n any, that the context menu was invoked on.\n"]
    pub get_edit_state_flags: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_context_menu_params_t,
        ) -> cef_context_menu_edit_state_flags_t,
    >,
    #[doc = "\n Returns true (1) if the context menu contains items specified by the\n renderer process.\n"]
    pub is_custom_menu: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_context_menu_params_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_context_menu_params_t"]
        [::std::mem::size_of::<_cef_context_menu_params_t>() - 200usize];
    ["Alignment of _cef_context_menu_params_t"]
        [::std::mem::align_of::<_cef_context_menu_params_t>() - 8usize];
    ["Offset of field: _cef_context_menu_params_t::base"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, base) - 0usize];
    ["Offset of field: _cef_context_menu_params_t::get_xcoord"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_xcoord) - 40usize];
    ["Offset of field: _cef_context_menu_params_t::get_ycoord"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_ycoord) - 48usize];
    ["Offset of field: _cef_context_menu_params_t::get_type_flags"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_type_flags) - 56usize];
    ["Offset of field: _cef_context_menu_params_t::get_link_url"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_link_url) - 64usize];
    ["Offset of field: _cef_context_menu_params_t::get_unfiltered_link_url"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_unfiltered_link_url) - 72usize];
    ["Offset of field: _cef_context_menu_params_t::get_source_url"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_source_url) - 80usize];
    ["Offset of field: _cef_context_menu_params_t::has_image_contents"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, has_image_contents) - 88usize];
    ["Offset of field: _cef_context_menu_params_t::get_title_text"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_title_text) - 96usize];
    ["Offset of field: _cef_context_menu_params_t::get_page_url"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_page_url) - 104usize];
    ["Offset of field: _cef_context_menu_params_t::get_frame_url"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_frame_url) - 112usize];
    ["Offset of field: _cef_context_menu_params_t::get_frame_charset"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_frame_charset) - 120usize];
    ["Offset of field: _cef_context_menu_params_t::get_media_type"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_media_type) - 128usize];
    ["Offset of field: _cef_context_menu_params_t::get_media_state_flags"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_media_state_flags) - 136usize];
    ["Offset of field: _cef_context_menu_params_t::get_selection_text"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_selection_text) - 144usize];
    ["Offset of field: _cef_context_menu_params_t::get_misspelled_word"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_misspelled_word) - 152usize];
    ["Offset of field: _cef_context_menu_params_t::get_dictionary_suggestions"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_dictionary_suggestions) - 160usize];
    ["Offset of field: _cef_context_menu_params_t::is_editable"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, is_editable) - 168usize];
    ["Offset of field: _cef_context_menu_params_t::is_spell_check_enabled"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, is_spell_check_enabled) - 176usize];
    ["Offset of field: _cef_context_menu_params_t::get_edit_state_flags"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, get_edit_state_flags) - 184usize];
    ["Offset of field: _cef_context_menu_params_t::is_custom_menu"]
        [::std::mem::offset_of!(_cef_context_menu_params_t, is_custom_menu) - 192usize];
};
#[doc = "\n Provides information about the context menu state. The functions of this\n structure can only be accessed on browser process the UI thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_context_menu_params_t = _cef_context_menu_params_t;
#[doc = "\n Callback structure for asynchronous continuation of file dialog requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_file_dialog_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Continue the file selection. |file_paths| should be a single value or a\n list of values depending on the dialog mode. An NULL |file_paths| value is\n treated the same as calling cancel().\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_file_dialog_callback_t,
            file_paths: cef_string_list_t,
        ),
    >,
    #[doc = "\n Cancel the file selection.\n"]
    pub cancel:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_file_dialog_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_file_dialog_callback_t"]
        [::std::mem::size_of::<_cef_file_dialog_callback_t>() - 56usize];
    ["Alignment of _cef_file_dialog_callback_t"]
        [::std::mem::align_of::<_cef_file_dialog_callback_t>() - 8usize];
    ["Offset of field: _cef_file_dialog_callback_t::base"]
        [::std::mem::offset_of!(_cef_file_dialog_callback_t, base) - 0usize];
    ["Offset of field: _cef_file_dialog_callback_t::cont"]
        [::std::mem::offset_of!(_cef_file_dialog_callback_t, cont) - 40usize];
    ["Offset of field: _cef_file_dialog_callback_t::cancel"]
        [::std::mem::offset_of!(_cef_file_dialog_callback_t, cancel) - 48usize];
};
#[doc = "\n Callback structure for asynchronous continuation of file dialog requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_file_dialog_callback_t = _cef_file_dialog_callback_t;
#[doc = "\n Implement this structure to handle dialog events. The functions of this\n structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_dialog_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called to run a file chooser dialog. |mode| represents the type of dialog\n to display. |title| to the title to be used for the dialog and may be NULL\n to show the default title (\"Open\" or \"Save\" depending on the mode).\n |default_file_path| is the path with optional directory and/or file name\n component that should be initially selected in the dialog.\n |accept_filters| are used to restrict the selectable file types and may be\n any combination of valid lower-cased MIME types (e.g. \"text/*\" or\n \"image/*\") and individual file extensions (e.g. \".txt\" or \".png\").\n |accept_extensions| provides the semicolon-delimited expansion of MIME\n types to file extensions (if known, or NULL string otherwise).\n |accept_descriptions| provides the descriptions for MIME types (if known,\n or NULL string otherwise). For example, the \"image/*\" mime type might have\n extensions \".png;.jpg;.bmp;...\" and description \"Image Files\".\n |accept_filters|, |accept_extensions| and |accept_descriptions| will all\n be the same size. To display a custom dialog return true (1) and execute\n |callback| either inline or at a later time. To display the default dialog\n return false (0). If this function returns false (0) it may be called an\n additional time for the same dialog (both before and after MIME type\n expansion).\n"]
    pub on_file_dialog: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_dialog_handler_t,
            browser: *mut _cef_browser_t,
            mode: cef_file_dialog_mode_t,
            title: *const cef_string_t,
            default_file_path: *const cef_string_t,
            accept_filters: cef_string_list_t,
            accept_extensions: cef_string_list_t,
            accept_descriptions: cef_string_list_t,
            callback: *mut _cef_file_dialog_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_dialog_handler_t"][::std::mem::size_of::<_cef_dialog_handler_t>() - 48usize];
    ["Alignment of _cef_dialog_handler_t"]
        [::std::mem::align_of::<_cef_dialog_handler_t>() - 8usize];
    ["Offset of field: _cef_dialog_handler_t::base"]
        [::std::mem::offset_of!(_cef_dialog_handler_t, base) - 0usize];
    ["Offset of field: _cef_dialog_handler_t::on_file_dialog"]
        [::std::mem::offset_of!(_cef_dialog_handler_t, on_file_dialog) - 40usize];
};
#[doc = "\n Implement this structure to handle dialog events. The functions of this\n structure will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_dialog_handler_t = _cef_dialog_handler_t;
#[doc = "\n Implement this structure to handle events related to browser display state.\n The functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_display_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when a frame's address has changed.\n"]
    pub on_address_change: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            url: *const cef_string_t,
        ),
    >,
    #[doc = "\n Called when the page title changes.\n"]
    pub on_title_change: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            title: *const cef_string_t,
        ),
    >,
    #[doc = "\n Called when the page icon changes.\n"]
    pub on_favicon_urlchange: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            icon_urls: cef_string_list_t,
        ),
    >,
    #[doc = "\n Called when web content in the page has toggled fullscreen mode. If\n |fullscreen| is true (1) the content will automatically be sized to fill\n the browser content area. If |fullscreen| is false (0) the content will\n automatically return to its original size and position. With Alloy style\n the client is responsible for triggering the fullscreen transition (for\n example, by calling cef_window_t::SetFullscreen when using Views). With\n Chrome style the fullscreen transition will be triggered automatically.\n The cef_window_delegate_t::OnWindowFullscreenTransition function will be\n called during the fullscreen transition for notification purposes.\n"]
    pub on_fullscreen_mode_change: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            fullscreen: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called when the browser is about to display a tooltip. |text| contains the\n text that will be displayed in the tooltip. To handle the display of the\n tooltip yourself return true (1). Otherwise, you can optionally modify\n |text| and then return false (0) to allow the browser to display the\n tooltip. When window rendering is disabled the application is responsible\n for drawing tooltips and the return value is ignored.\n"]
    pub on_tooltip: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            text: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the browser receives a status message. |value| contains the\n text that will be displayed in the status message.\n"]
    pub on_status_message: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            value: *const cef_string_t,
        ),
    >,
    #[doc = "\n Called to display a console message. Return true (1) to stop the message\n from being output to the console.\n"]
    pub on_console_message: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            level: cef_log_severity_t,
            message: *const cef_string_t,
            source: *const cef_string_t,
            line: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when auto-resize is enabled via\n cef_browser_host_t::SetAutoResizeEnabled and the contents have auto-\n resized. |new_size| will be the desired size in DIP coordinates. Return\n true (1) if the resize was handled or false (0) for default handling.\n"]
    pub on_auto_resize: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            new_size: *const cef_size_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the overall page loading progress has changed. |progress|\n ranges from 0.0 to 1.0.\n"]
    pub on_loading_progress_change: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            progress: f64,
        ),
    >,
    #[doc = "\n Called when the browser's cursor has changed. If |type| is CT_CUSTOM then\n |custom_cursor_info| will be populated with the custom cursor information.\n Return true (1) if the cursor change was handled or false (0) for default\n handling.\n"]
    pub on_cursor_change: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            cursor: cef_cursor_handle_t,
            type_: cef_cursor_type_t,
            custom_cursor_info: *const cef_cursor_info_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the browser's access to an audio and/or video source has\n changed.\n"]
    pub on_media_access_change: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            has_video_access: ::std::os::raw::c_int,
            has_audio_access: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called when JavaScript is requesting new bounds via window.moveTo/By() or\n window.resizeTo/By(). |new_bounds| are in DIP screen coordinates.\n\n With Views-hosted browsers |new_bounds| are the desired bounds for the\n containing cef_window_t and may be passed directly to\n cef_window_t::SetBounds. With external (client-provided) parent on macOS\n and Windows |new_bounds| are the desired frame bounds for the containing\n root window. With other non-Views browsers |new_bounds| are the desired\n bounds for the browser content only unless the client implements either\n cef_display_handler_t::GetRootWindowScreenRect for windowed browsers or\n cef_render_handler_t::GetWindowScreenRect for windowless browsers. Clients\n may expand browser content bounds to window bounds using OS-specific or\n cef_display_t functions.\n\n Return true (1) if this function was handled or false (0) for default\n handling. Default move/resize behavior is only provided with Views-hosted\n Chrome style browsers.\n"]
    pub on_contents_bounds_change: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            new_bounds: *const cef_rect_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to retrieve the external (client-provided) root window rectangle in\n screen DIP coordinates. Only called for windowed browsers on Windows and\n Linux. Return true (1) if the rectangle was provided. Return false (0) to\n use the root window bounds on Windows or the browser content bounds on\n Linux. For additional usage details see\n cef_browser_host_t::NotifyScreenInfoChanged.\n"]
    pub get_root_window_screen_rect: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_display_handler_t,
            browser: *mut _cef_browser_t,
            rect: *mut cef_rect_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_display_handler_t"][::std::mem::size_of::<_cef_display_handler_t>() - 144usize];
    ["Alignment of _cef_display_handler_t"]
        [::std::mem::align_of::<_cef_display_handler_t>() - 8usize];
    ["Offset of field: _cef_display_handler_t::base"]
        [::std::mem::offset_of!(_cef_display_handler_t, base) - 0usize];
    ["Offset of field: _cef_display_handler_t::on_address_change"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_address_change) - 40usize];
    ["Offset of field: _cef_display_handler_t::on_title_change"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_title_change) - 48usize];
    ["Offset of field: _cef_display_handler_t::on_favicon_urlchange"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_favicon_urlchange) - 56usize];
    ["Offset of field: _cef_display_handler_t::on_fullscreen_mode_change"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_fullscreen_mode_change) - 64usize];
    ["Offset of field: _cef_display_handler_t::on_tooltip"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_tooltip) - 72usize];
    ["Offset of field: _cef_display_handler_t::on_status_message"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_status_message) - 80usize];
    ["Offset of field: _cef_display_handler_t::on_console_message"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_console_message) - 88usize];
    ["Offset of field: _cef_display_handler_t::on_auto_resize"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_auto_resize) - 96usize];
    ["Offset of field: _cef_display_handler_t::on_loading_progress_change"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_loading_progress_change) - 104usize];
    ["Offset of field: _cef_display_handler_t::on_cursor_change"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_cursor_change) - 112usize];
    ["Offset of field: _cef_display_handler_t::on_media_access_change"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_media_access_change) - 120usize];
    ["Offset of field: _cef_display_handler_t::on_contents_bounds_change"]
        [::std::mem::offset_of!(_cef_display_handler_t, on_contents_bounds_change) - 128usize];
    ["Offset of field: _cef_display_handler_t::get_root_window_screen_rect"]
        [::std::mem::offset_of!(_cef_display_handler_t, get_root_window_screen_rect) - 136usize];
};
#[doc = "\n Implement this structure to handle events related to browser display state.\n The functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_display_handler_t = _cef_display_handler_t;
#[doc = "\n Structure used to represent a download item.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_download_item_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is valid. Do not call any other functions\n if this function returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the download is in progress.\n"]
    pub is_in_progress: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the download is complete.\n"]
    pub is_complete: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the download has been canceled.\n"]
    pub is_canceled: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the download has been interrupted.\n"]
    pub is_interrupted: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the most recent interrupt reason.\n"]
    pub get_interrupt_reason: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_download_interrupt_reason_t,
    >,
    #[doc = "\n Returns a simple speed estimate in bytes/s.\n"]
    pub get_current_speed:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> i64>,
    #[doc = "\n Returns the rough percent complete or -1 if the receive total size is\n unknown.\n"]
    pub get_percent_complete: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the total number of bytes.\n"]
    pub get_total_bytes:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> i64>,
    #[doc = "\n Returns the number of received bytes.\n"]
    pub get_received_bytes:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> i64>,
    #[doc = "\n Returns the time that the download started.\n"]
    pub get_start_time: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_basetime_t,
    >,
    #[doc = "\n Returns the time that the download ended.\n"]
    pub get_end_time: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_basetime_t,
    >,
    #[doc = "\n Returns the full path to the downloaded or downloading file.\n"]
    pub get_full_path: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the unique identifier for this download.\n"]
    pub get_id:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> u32>,
    #[doc = "\n Returns the URL.\n"]
    pub get_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the original URL before any redirections.\n"]
    pub get_original_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the suggested file name.\n"]
    pub get_suggested_file_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the content disposition.\n"]
    pub get_content_disposition: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the mime type.\n"]
    pub get_mime_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_download_item_t) -> cef_string_userfree_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_download_item_t"][::std::mem::size_of::<_cef_download_item_t>() - 192usize];
    ["Alignment of _cef_download_item_t"][::std::mem::align_of::<_cef_download_item_t>() - 8usize];
    ["Offset of field: _cef_download_item_t::base"]
        [::std::mem::offset_of!(_cef_download_item_t, base) - 0usize];
    ["Offset of field: _cef_download_item_t::is_valid"]
        [::std::mem::offset_of!(_cef_download_item_t, is_valid) - 40usize];
    ["Offset of field: _cef_download_item_t::is_in_progress"]
        [::std::mem::offset_of!(_cef_download_item_t, is_in_progress) - 48usize];
    ["Offset of field: _cef_download_item_t::is_complete"]
        [::std::mem::offset_of!(_cef_download_item_t, is_complete) - 56usize];
    ["Offset of field: _cef_download_item_t::is_canceled"]
        [::std::mem::offset_of!(_cef_download_item_t, is_canceled) - 64usize];
    ["Offset of field: _cef_download_item_t::is_interrupted"]
        [::std::mem::offset_of!(_cef_download_item_t, is_interrupted) - 72usize];
    ["Offset of field: _cef_download_item_t::get_interrupt_reason"]
        [::std::mem::offset_of!(_cef_download_item_t, get_interrupt_reason) - 80usize];
    ["Offset of field: _cef_download_item_t::get_current_speed"]
        [::std::mem::offset_of!(_cef_download_item_t, get_current_speed) - 88usize];
    ["Offset of field: _cef_download_item_t::get_percent_complete"]
        [::std::mem::offset_of!(_cef_download_item_t, get_percent_complete) - 96usize];
    ["Offset of field: _cef_download_item_t::get_total_bytes"]
        [::std::mem::offset_of!(_cef_download_item_t, get_total_bytes) - 104usize];
    ["Offset of field: _cef_download_item_t::get_received_bytes"]
        [::std::mem::offset_of!(_cef_download_item_t, get_received_bytes) - 112usize];
    ["Offset of field: _cef_download_item_t::get_start_time"]
        [::std::mem::offset_of!(_cef_download_item_t, get_start_time) - 120usize];
    ["Offset of field: _cef_download_item_t::get_end_time"]
        [::std::mem::offset_of!(_cef_download_item_t, get_end_time) - 128usize];
    ["Offset of field: _cef_download_item_t::get_full_path"]
        [::std::mem::offset_of!(_cef_download_item_t, get_full_path) - 136usize];
    ["Offset of field: _cef_download_item_t::get_id"]
        [::std::mem::offset_of!(_cef_download_item_t, get_id) - 144usize];
    ["Offset of field: _cef_download_item_t::get_url"]
        [::std::mem::offset_of!(_cef_download_item_t, get_url) - 152usize];
    ["Offset of field: _cef_download_item_t::get_original_url"]
        [::std::mem::offset_of!(_cef_download_item_t, get_original_url) - 160usize];
    ["Offset of field: _cef_download_item_t::get_suggested_file_name"]
        [::std::mem::offset_of!(_cef_download_item_t, get_suggested_file_name) - 168usize];
    ["Offset of field: _cef_download_item_t::get_content_disposition"]
        [::std::mem::offset_of!(_cef_download_item_t, get_content_disposition) - 176usize];
    ["Offset of field: _cef_download_item_t::get_mime_type"]
        [::std::mem::offset_of!(_cef_download_item_t, get_mime_type) - 184usize];
};
#[doc = "\n Structure used to represent a download item.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_download_item_t = _cef_download_item_t;
#[doc = "\n Callback structure used to asynchronously continue a download.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_before_download_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Call to continue the download. Set |download_path| to the full file path\n for the download including the file name or leave blank to use the\n suggested name and the default temp directory. Set |show_dialog| to true\n (1) if you do wish to show the default \"Save As\" dialog.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_before_download_callback_t,
            download_path: *const cef_string_t,
            show_dialog: ::std::os::raw::c_int,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_before_download_callback_t"]
        [::std::mem::size_of::<_cef_before_download_callback_t>() - 48usize];
    ["Alignment of _cef_before_download_callback_t"]
        [::std::mem::align_of::<_cef_before_download_callback_t>() - 8usize];
    ["Offset of field: _cef_before_download_callback_t::base"]
        [::std::mem::offset_of!(_cef_before_download_callback_t, base) - 0usize];
    ["Offset of field: _cef_before_download_callback_t::cont"]
        [::std::mem::offset_of!(_cef_before_download_callback_t, cont) - 40usize];
};
#[doc = "\n Callback structure used to asynchronously continue a download.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_before_download_callback_t = _cef_before_download_callback_t;
#[doc = "\n Callback structure used to asynchronously cancel a download.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_download_item_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Call to cancel the download.\n"]
    pub cancel:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_download_item_callback_t)>,
    #[doc = "\n Call to pause the download.\n"]
    pub pause:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_download_item_callback_t)>,
    #[doc = "\n Call to resume the download.\n"]
    pub resume:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_download_item_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_download_item_callback_t"]
        [::std::mem::size_of::<_cef_download_item_callback_t>() - 64usize];
    ["Alignment of _cef_download_item_callback_t"]
        [::std::mem::align_of::<_cef_download_item_callback_t>() - 8usize];
    ["Offset of field: _cef_download_item_callback_t::base"]
        [::std::mem::offset_of!(_cef_download_item_callback_t, base) - 0usize];
    ["Offset of field: _cef_download_item_callback_t::cancel"]
        [::std::mem::offset_of!(_cef_download_item_callback_t, cancel) - 40usize];
    ["Offset of field: _cef_download_item_callback_t::pause"]
        [::std::mem::offset_of!(_cef_download_item_callback_t, pause) - 48usize];
    ["Offset of field: _cef_download_item_callback_t::resume"]
        [::std::mem::offset_of!(_cef_download_item_callback_t, resume) - 56usize];
};
#[doc = "\n Callback structure used to asynchronously cancel a download.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_download_item_callback_t = _cef_download_item_callback_t;
#[doc = "\n Structure used to handle file downloads. The functions of this structure\n will called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_download_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called before a download begins in response to a user-initiated action\n (e.g. alt + link click or link click that returns a `Content-Disposition:\n attachment` response from the server). |url| is the target download URL\n and |request_function| is the target function (GET, POST, etc). Return\n true (1) to proceed with the download or false (0) to cancel the download.\n"]
    pub can_download: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_download_handler_t,
            browser: *mut _cef_browser_t,
            url: *const cef_string_t,
            request_method: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called before a download begins. |suggested_name| is the suggested name\n for the download file. Return true (1) and execute |callback| either\n asynchronously or in this function to continue or cancel the download.\n Return false (0) to proceed with default handling (cancel with Alloy\n style, download shelf with Chrome style). Do not keep a reference to\n |download_item| outside of this function.\n"]
    pub on_before_download: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_download_handler_t,
            browser: *mut _cef_browser_t,
            download_item: *mut _cef_download_item_t,
            suggested_name: *const cef_string_t,
            callback: *mut _cef_before_download_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when a download's status or progress information has been updated.\n This may be called multiple times before and after on_before_download().\n Execute |callback| either asynchronously or in this function to cancel the\n download if desired. Do not keep a reference to |download_item| outside of\n this function.\n"]
    pub on_download_updated: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_download_handler_t,
            browser: *mut _cef_browser_t,
            download_item: *mut _cef_download_item_t,
            callback: *mut _cef_download_item_callback_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_download_handler_t"][::std::mem::size_of::<_cef_download_handler_t>() - 64usize];
    ["Alignment of _cef_download_handler_t"]
        [::std::mem::align_of::<_cef_download_handler_t>() - 8usize];
    ["Offset of field: _cef_download_handler_t::base"]
        [::std::mem::offset_of!(_cef_download_handler_t, base) - 0usize];
    ["Offset of field: _cef_download_handler_t::can_download"]
        [::std::mem::offset_of!(_cef_download_handler_t, can_download) - 40usize];
    ["Offset of field: _cef_download_handler_t::on_before_download"]
        [::std::mem::offset_of!(_cef_download_handler_t, on_before_download) - 48usize];
    ["Offset of field: _cef_download_handler_t::on_download_updated"]
        [::std::mem::offset_of!(_cef_download_handler_t, on_download_updated) - 56usize];
};
#[doc = "\n Structure used to handle file downloads. The functions of this structure\n will called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_download_handler_t = _cef_download_handler_t;
#[doc = "\n Implement this structure to handle events related to dragging. The functions\n of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_drag_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when an external drag event enters the browser window. |dragData|\n contains the drag event data and |mask| represents the type of drag\n operation. Return false (0) for default drag handling behavior or true (1)\n to cancel the drag event.\n"]
    pub on_drag_enter: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_drag_handler_t,
            browser: *mut _cef_browser_t,
            dragData: *mut _cef_drag_data_t,
            mask: cef_drag_operations_mask_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called whenever draggable regions for the browser window change. These can\n be specified using the '-webkit-app-region: drag/no-drag' CSS-property. If\n draggable regions are never defined in a document this function will also\n never be called. If the last draggable region is removed from a document\n this function will be called with an NULL vector.\n"]
    pub on_draggable_regions_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_drag_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            regionsCount: usize,
            regions: *const cef_draggable_region_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_drag_handler_t"][::std::mem::size_of::<_cef_drag_handler_t>() - 56usize];
    ["Alignment of _cef_drag_handler_t"][::std::mem::align_of::<_cef_drag_handler_t>() - 8usize];
    ["Offset of field: _cef_drag_handler_t::base"]
        [::std::mem::offset_of!(_cef_drag_handler_t, base) - 0usize];
    ["Offset of field: _cef_drag_handler_t::on_drag_enter"]
        [::std::mem::offset_of!(_cef_drag_handler_t, on_drag_enter) - 40usize];
    ["Offset of field: _cef_drag_handler_t::on_draggable_regions_changed"]
        [::std::mem::offset_of!(_cef_drag_handler_t, on_draggable_regions_changed) - 48usize];
};
#[doc = "\n Implement this structure to handle events related to dragging. The functions\n of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_drag_handler_t = _cef_drag_handler_t;
#[doc = "\n Implement this structure to handle events related to find results. The\n functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_find_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called to report find results returned by cef_browser_host_t::find().\n |identifer| is a unique incremental identifier for the currently active\n search, |count| is the number of matches currently identified,\n |selectionRect| is the location of where the match was found (in window\n coordinates), |activeMatchOrdinal| is the current position in the search\n results, and |finalUpdate| is true (1) if this is the last find\n notification.\n"]
    pub on_find_result: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_find_handler_t,
            browser: *mut _cef_browser_t,
            identifier: ::std::os::raw::c_int,
            count: ::std::os::raw::c_int,
            selectionRect: *const cef_rect_t,
            activeMatchOrdinal: ::std::os::raw::c_int,
            finalUpdate: ::std::os::raw::c_int,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_find_handler_t"][::std::mem::size_of::<_cef_find_handler_t>() - 48usize];
    ["Alignment of _cef_find_handler_t"][::std::mem::align_of::<_cef_find_handler_t>() - 8usize];
    ["Offset of field: _cef_find_handler_t::base"]
        [::std::mem::offset_of!(_cef_find_handler_t, base) - 0usize];
    ["Offset of field: _cef_find_handler_t::on_find_result"]
        [::std::mem::offset_of!(_cef_find_handler_t, on_find_result) - 40usize];
};
#[doc = "\n Implement this structure to handle events related to find results. The\n functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_find_handler_t = _cef_find_handler_t;
#[doc = "\n Implement this structure to handle events related to focus. The functions of\n this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_focus_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when the browser component is about to loose focus. For instance,\n if focus was on the last HTML element and the user pressed the TAB key.\n |next| will be true (1) if the browser is giving focus to the next\n component and false (0) if the browser is giving focus to the previous\n component.\n"]
    pub on_take_focus: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_focus_handler_t,
            browser: *mut _cef_browser_t,
            next: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called when the browser component is requesting focus. |source| indicates\n where the focus request is originating from. Return false (0) to allow the\n focus to be set or true (1) to cancel setting the focus.\n"]
    pub on_set_focus: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_focus_handler_t,
            browser: *mut _cef_browser_t,
            source: cef_focus_source_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the browser component has received focus.\n"]
    pub on_got_focus: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_focus_handler_t, browser: *mut _cef_browser_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_focus_handler_t"][::std::mem::size_of::<_cef_focus_handler_t>() - 64usize];
    ["Alignment of _cef_focus_handler_t"][::std::mem::align_of::<_cef_focus_handler_t>() - 8usize];
    ["Offset of field: _cef_focus_handler_t::base"]
        [::std::mem::offset_of!(_cef_focus_handler_t, base) - 0usize];
    ["Offset of field: _cef_focus_handler_t::on_take_focus"]
        [::std::mem::offset_of!(_cef_focus_handler_t, on_take_focus) - 40usize];
    ["Offset of field: _cef_focus_handler_t::on_set_focus"]
        [::std::mem::offset_of!(_cef_focus_handler_t, on_set_focus) - 48usize];
    ["Offset of field: _cef_focus_handler_t::on_got_focus"]
        [::std::mem::offset_of!(_cef_focus_handler_t, on_got_focus) - 56usize];
};
#[doc = "\n Implement this structure to handle events related to focus. The functions of\n this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_focus_handler_t = _cef_focus_handler_t;
#[doc = "\n Implement this structure to handle events related to cef_frame_t life span.\n The order of callbacks is:\n\n (1) During initial cef_browser_host_t creation and navigation of the main\n frame:\n - cef_frame_handler_t::OnFrameCreated => The initial main frame object has\n   been created. Any commands will be queued until the frame is attached.\n - cef_frame_handler_t::OnMainFrameChanged => The initial main frame object\n   has been assigned to the browser.\n - cef_life_span_handler_t::OnAfterCreated => The browser is now valid and\n   can be used.\n - cef_frame_handler_t::OnFrameAttached => The initial main frame object is\n   now connected to its peer in the renderer process. Commands can be routed.\n\n (2) During further cef_browser_host_t navigation/loading of the main frame\n     and/or sub-frames:\n - cef_frame_handler_t::OnFrameCreated => A new main frame or sub-frame\n   object has been created. Any commands will be queued until the frame is\n   attached.\n - cef_frame_handler_t::OnFrameAttached => A new main frame or sub-frame\n   object is now connected to its peer in the renderer process. Commands can\n   be routed.\n - cef_frame_handler_t::OnFrameDetached => An existing main frame or sub-\n   frame object has lost its connection to the renderer process. If multiple\n   objects are detached at the same time then notifications will be sent for\n   any sub-frame objects before the main frame object. Commands can no longer\n   be routed and will be discarded.\n - CefFremeHadler::OnFrameDestroyed => An existing main frame or sub-frame\n   object has been destroyed.\n - cef_frame_handler_t::OnMainFrameChanged => A new main frame object has\n   been assigned to the browser. This will only occur with cross-origin\n   navigation or re-navigation after renderer process termination (due to\n   crashes, etc).\n\n (3) During final cef_browser_host_t destruction of the main frame:\n - cef_frame_handler_t::OnFrameDetached => Any sub-frame objects have lost\n   their connection to the renderer process. Commands can no longer be routed\n   and will be discarded.\n - CefFreameHandler::OnFrameDestroyed => Any sub-frame objects have been\n   destroyed.\n - cef_life_span_handler_t::OnBeforeClose => The browser has been destroyed.\n - cef_frame_handler_t::OnFrameDetached => The main frame object have lost\n   its connection to the renderer process. Notifications will be sent for any\n   sub-frame objects before the main frame object. Commands can no longer be\n   routed and will be discarded.\n - CefFreameHandler::OnFrameDestroyed => The main frame object has been\n   destroyed.\n - cef_frame_handler_t::OnMainFrameChanged => The final main frame object has\n   been removed from the browser.\n\n Special handling applies for cross-origin loading on creation/navigation of\n sub-frames, and cross-origin loading on creation of new popup browsers. A\n temporary frame will first be created in the parent frame's renderer\n process. This temporary frame will never attach and will be discarded after\n the real cross-origin frame is created in the new/target renderer process.\n The client will receive creation callbacks for the temporary frame, followed\n by cross-origin navigation callbacks (2) for the transition from the\n temporary frame to the real frame. The temporary frame will not receive or\n execute commands during this transitional period (any sent commands will be\n discarded).\n\n When the main frame navigates to a different origin the OnMainFrameChanged\n callback (2) will be executed with the old and new main frame objects.\n\n Callbacks will not be executed for placeholders that may be created during\n pre-commit navigation for sub-frames that do not yet exist in the renderer\n process. Placeholders will have cef_frame_t::get_identifier() == -4.\n\n The functions of this structure will be called on the UI thread unless\n otherwise indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_frame_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when a new frame is created. This will be the first notification\n that references |frame|. Any commands that require transport to the\n associated renderer process (LoadRequest, SendProcessMessage, GetSource,\n etc.) will be queued. The queued commands will be sent before\n OnFrameAttached or discarded before OnFrameDestroyed if the frame never\n attaches.\n"]
    pub on_frame_created: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_frame_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
        ),
    >,
    #[doc = "\n Called when an existing frame is destroyed. This will be the last\n notification that references |frame| and cef_frame_t::is_valid() will\n return false (0) for |frame|. If called during browser destruction and\n after cef_life_span_handler_t::on_before_close() then\n cef_browser_t::is_valid() will return false (0) for |browser|. Any queued\n commands that have not been sent will be discarded before this callback.\n"]
    pub on_frame_destroyed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_frame_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
        ),
    >,
    #[doc = "\n Called when a frame can begin routing commands to/from the associated\n renderer process. |reattached| will be true (1) if the frame was re-\n attached after exiting the BackForwardCache or after encountering a\n recoverable connection error. Any queued commands will now have been\n dispatched. This function will not be called for temporary frames created\n during cross-origin navigation.\n"]
    pub on_frame_attached: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_frame_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            reattached: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called when a frame loses its connection to the renderer process. This may\n occur when a frame is destroyed, enters the BackForwardCache, or\n encounters a rare connection error. In the case of frame destruction this\n call will be followed by a (potentially async) call to OnFrameDestroyed.\n If frame destruction is occuring synchronously then\n cef_frame_t::is_valid() will return false (0) for |frame|. If called\n during browser destruction and after\n cef_life_span_handler_t::on_before_close() then cef_browser_t::is_valid()\n will return false (0) for |browser|. If, in the non-destruction case, the\n same frame later exits the BackForwardCache or recovers from a connection\n error then there will be a follow-up call to OnFrameAttached. This\n function will not be called for temporary frames created during cross-\n origin navigation.\n"]
    pub on_frame_detached: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_frame_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
        ),
    >,
    #[doc = "\n Called when the main frame changes due to (a) initial browser creation,\n (b) final browser destruction, (c) cross-origin navigation or (d) re-\n navigation after renderer process termination (due to crashes, etc).\n |old_frame| will be NULL and |new_frame| will be non-NULL when a main\n frame is assigned to |browser| for the first time. |old_frame| will be\n non-NULL and |new_frame| will be NULL when a main frame is removed from\n |browser| for the last time. Both |old_frame| and |new_frame| will be non-\n NULL for cross-origin navigations or re-navigation after renderer process\n termination. This function will be called after on_frame_created() for\n |new_frame| and/or after on_frame_destroyed() for |old_frame|. If called\n during browser destruction and after\n cef_life_span_handler_t::on_before_close() then cef_browser_t::is_valid()\n will return false (0) for |browser|.\n"]
    pub on_main_frame_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_frame_handler_t,
            browser: *mut _cef_browser_t,
            old_frame: *mut _cef_frame_t,
            new_frame: *mut _cef_frame_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_frame_handler_t"][::std::mem::size_of::<_cef_frame_handler_t>() - 80usize];
    ["Alignment of _cef_frame_handler_t"][::std::mem::align_of::<_cef_frame_handler_t>() - 8usize];
    ["Offset of field: _cef_frame_handler_t::base"]
        [::std::mem::offset_of!(_cef_frame_handler_t, base) - 0usize];
    ["Offset of field: _cef_frame_handler_t::on_frame_created"]
        [::std::mem::offset_of!(_cef_frame_handler_t, on_frame_created) - 40usize];
    ["Offset of field: _cef_frame_handler_t::on_frame_destroyed"]
        [::std::mem::offset_of!(_cef_frame_handler_t, on_frame_destroyed) - 48usize];
    ["Offset of field: _cef_frame_handler_t::on_frame_attached"]
        [::std::mem::offset_of!(_cef_frame_handler_t, on_frame_attached) - 56usize];
    ["Offset of field: _cef_frame_handler_t::on_frame_detached"]
        [::std::mem::offset_of!(_cef_frame_handler_t, on_frame_detached) - 64usize];
    ["Offset of field: _cef_frame_handler_t::on_main_frame_changed"]
        [::std::mem::offset_of!(_cef_frame_handler_t, on_main_frame_changed) - 72usize];
};
#[doc = "\n Implement this structure to handle events related to cef_frame_t life span.\n The order of callbacks is:\n\n (1) During initial cef_browser_host_t creation and navigation of the main\n frame:\n - cef_frame_handler_t::OnFrameCreated => The initial main frame object has\n   been created. Any commands will be queued until the frame is attached.\n - cef_frame_handler_t::OnMainFrameChanged => The initial main frame object\n   has been assigned to the browser.\n - cef_life_span_handler_t::OnAfterCreated => The browser is now valid and\n   can be used.\n - cef_frame_handler_t::OnFrameAttached => The initial main frame object is\n   now connected to its peer in the renderer process. Commands can be routed.\n\n (2) During further cef_browser_host_t navigation/loading of the main frame\n     and/or sub-frames:\n - cef_frame_handler_t::OnFrameCreated => A new main frame or sub-frame\n   object has been created. Any commands will be queued until the frame is\n   attached.\n - cef_frame_handler_t::OnFrameAttached => A new main frame or sub-frame\n   object is now connected to its peer in the renderer process. Commands can\n   be routed.\n - cef_frame_handler_t::OnFrameDetached => An existing main frame or sub-\n   frame object has lost its connection to the renderer process. If multiple\n   objects are detached at the same time then notifications will be sent for\n   any sub-frame objects before the main frame object. Commands can no longer\n   be routed and will be discarded.\n - CefFremeHadler::OnFrameDestroyed => An existing main frame or sub-frame\n   object has been destroyed.\n - cef_frame_handler_t::OnMainFrameChanged => A new main frame object has\n   been assigned to the browser. This will only occur with cross-origin\n   navigation or re-navigation after renderer process termination (due to\n   crashes, etc).\n\n (3) During final cef_browser_host_t destruction of the main frame:\n - cef_frame_handler_t::OnFrameDetached => Any sub-frame objects have lost\n   their connection to the renderer process. Commands can no longer be routed\n   and will be discarded.\n - CefFreameHandler::OnFrameDestroyed => Any sub-frame objects have been\n   destroyed.\n - cef_life_span_handler_t::OnBeforeClose => The browser has been destroyed.\n - cef_frame_handler_t::OnFrameDetached => The main frame object have lost\n   its connection to the renderer process. Notifications will be sent for any\n   sub-frame objects before the main frame object. Commands can no longer be\n   routed and will be discarded.\n - CefFreameHandler::OnFrameDestroyed => The main frame object has been\n   destroyed.\n - cef_frame_handler_t::OnMainFrameChanged => The final main frame object has\n   been removed from the browser.\n\n Special handling applies for cross-origin loading on creation/navigation of\n sub-frames, and cross-origin loading on creation of new popup browsers. A\n temporary frame will first be created in the parent frame's renderer\n process. This temporary frame will never attach and will be discarded after\n the real cross-origin frame is created in the new/target renderer process.\n The client will receive creation callbacks for the temporary frame, followed\n by cross-origin navigation callbacks (2) for the transition from the\n temporary frame to the real frame. The temporary frame will not receive or\n execute commands during this transitional period (any sent commands will be\n discarded).\n\n When the main frame navigates to a different origin the OnMainFrameChanged\n callback (2) will be executed with the old and new main frame objects.\n\n Callbacks will not be executed for placeholders that may be created during\n pre-commit navigation for sub-frames that do not yet exist in the renderer\n process. Placeholders will have cef_frame_t::get_identifier() == -4.\n\n The functions of this structure will be called on the UI thread unless\n otherwise indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_frame_handler_t = _cef_frame_handler_t;
#[doc = "\n Callback structure used for asynchronous continuation of JavaScript dialog\n requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_jsdialog_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Continue the JS dialog request. Set |success| to true (1) if the OK button\n was pressed. The |user_input| value should be specified for prompt\n dialogs.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_jsdialog_callback_t,
            success: ::std::os::raw::c_int,
            user_input: *const cef_string_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_jsdialog_callback_t"]
        [::std::mem::size_of::<_cef_jsdialog_callback_t>() - 48usize];
    ["Alignment of _cef_jsdialog_callback_t"]
        [::std::mem::align_of::<_cef_jsdialog_callback_t>() - 8usize];
    ["Offset of field: _cef_jsdialog_callback_t::base"]
        [::std::mem::offset_of!(_cef_jsdialog_callback_t, base) - 0usize];
    ["Offset of field: _cef_jsdialog_callback_t::cont"]
        [::std::mem::offset_of!(_cef_jsdialog_callback_t, cont) - 40usize];
};
#[doc = "\n Callback structure used for asynchronous continuation of JavaScript dialog\n requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_jsdialog_callback_t = _cef_jsdialog_callback_t;
#[doc = "\n Implement this structure to handle events related to JavaScript dialogs. The\n functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_jsdialog_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called to run a JavaScript dialog. If |origin_url| is non-NULL it can be\n passed to the CefFormatUrlForSecurityDisplay function to retrieve a secure\n and user-friendly display string. The |default_prompt_text| value will be\n specified for prompt dialogs only. Set |suppress_message| to true (1) and\n return false (0) to suppress the message (suppressing messages is\n preferable to immediately executing the callback as this is used to detect\n presumably malicious behavior like spamming alert messages in\n onbeforeunload). Set |suppress_message| to false (0) and return false (0)\n to use the default implementation (the default implementation will show\n one modal dialog at a time and suppress any additional dialog requests\n until the displayed dialog is dismissed). Return true (1) if the\n application will use a custom dialog or if the callback has been executed\n immediately. Custom dialogs may be either modal or modeless. If a custom\n dialog is used the application must execute |callback| once the custom\n dialog is dismissed.\n"]
    pub on_jsdialog: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_jsdialog_handler_t,
            browser: *mut _cef_browser_t,
            origin_url: *const cef_string_t,
            dialog_type: cef_jsdialog_type_t,
            message_text: *const cef_string_t,
            default_prompt_text: *const cef_string_t,
            callback: *mut _cef_jsdialog_callback_t,
            suppress_message: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to run a dialog asking the user if they want to leave a page.\n Return false (0) to use the default dialog implementation. Return true (1)\n if the application will use a custom dialog or if the callback has been\n executed immediately. Custom dialogs may be either modal or modeless. If a\n custom dialog is used the application must execute |callback| once the\n custom dialog is dismissed.\n"]
    pub on_before_unload_dialog: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_jsdialog_handler_t,
            browser: *mut _cef_browser_t,
            message_text: *const cef_string_t,
            is_reload: ::std::os::raw::c_int,
            callback: *mut _cef_jsdialog_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to cancel any pending dialogs and reset any saved dialog state.\n Will be called due to events like page navigation irregardless of whether\n any dialogs are currently pending.\n"]
    pub on_reset_dialog_state: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_jsdialog_handler_t, browser: *mut _cef_browser_t),
    >,
    #[doc = "\n Called when the dialog is closed.\n"]
    pub on_dialog_closed: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_jsdialog_handler_t, browser: *mut _cef_browser_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_jsdialog_handler_t"][::std::mem::size_of::<_cef_jsdialog_handler_t>() - 72usize];
    ["Alignment of _cef_jsdialog_handler_t"]
        [::std::mem::align_of::<_cef_jsdialog_handler_t>() - 8usize];
    ["Offset of field: _cef_jsdialog_handler_t::base"]
        [::std::mem::offset_of!(_cef_jsdialog_handler_t, base) - 0usize];
    ["Offset of field: _cef_jsdialog_handler_t::on_jsdialog"]
        [::std::mem::offset_of!(_cef_jsdialog_handler_t, on_jsdialog) - 40usize];
    ["Offset of field: _cef_jsdialog_handler_t::on_before_unload_dialog"]
        [::std::mem::offset_of!(_cef_jsdialog_handler_t, on_before_unload_dialog) - 48usize];
    ["Offset of field: _cef_jsdialog_handler_t::on_reset_dialog_state"]
        [::std::mem::offset_of!(_cef_jsdialog_handler_t, on_reset_dialog_state) - 56usize];
    ["Offset of field: _cef_jsdialog_handler_t::on_dialog_closed"]
        [::std::mem::offset_of!(_cef_jsdialog_handler_t, on_dialog_closed) - 64usize];
};
#[doc = "\n Implement this structure to handle events related to JavaScript dialogs. The\n functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_jsdialog_handler_t = _cef_jsdialog_handler_t;
#[doc = "\n Implement this structure to handle events related to keyboard input. The\n functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_keyboard_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called before a keyboard event is sent to the renderer. |event| contains\n information about the keyboard event. |os_event| is the operating system\n event message, if any. Return true (1) if the event was handled or false\n (0) otherwise. If the event will be handled in on_key_event() as a\n keyboard shortcut set |is_keyboard_shortcut| to true (1) and return false\n (0).\n"]
    pub on_pre_key_event: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_keyboard_handler_t,
            browser: *mut _cef_browser_t,
            event: *const cef_key_event_t,
            os_event: cef_event_handle_t,
            is_keyboard_shortcut: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called after the renderer and JavaScript in the page has had a chance to\n handle the event. |event| contains information about the keyboard event.\n |os_event| is the operating system event message, if any. Return true (1)\n if the keyboard event was handled or false (0) otherwise.\n"]
    pub on_key_event: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_keyboard_handler_t,
            browser: *mut _cef_browser_t,
            event: *const cef_key_event_t,
            os_event: cef_event_handle_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_keyboard_handler_t"][::std::mem::size_of::<_cef_keyboard_handler_t>() - 56usize];
    ["Alignment of _cef_keyboard_handler_t"]
        [::std::mem::align_of::<_cef_keyboard_handler_t>() - 8usize];
    ["Offset of field: _cef_keyboard_handler_t::base"]
        [::std::mem::offset_of!(_cef_keyboard_handler_t, base) - 0usize];
    ["Offset of field: _cef_keyboard_handler_t::on_pre_key_event"]
        [::std::mem::offset_of!(_cef_keyboard_handler_t, on_pre_key_event) - 40usize];
    ["Offset of field: _cef_keyboard_handler_t::on_key_event"]
        [::std::mem::offset_of!(_cef_keyboard_handler_t, on_key_event) - 48usize];
};
#[doc = "\n Implement this structure to handle events related to keyboard input. The\n functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_keyboard_handler_t = _cef_keyboard_handler_t;
#[doc = "\n Implement this structure to handle events related to browser life span. The\n functions of this structure will be called on the UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _cef_life_span_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called on the UI thread before a new popup browser is created. The\n |browser| and |frame| values represent the source of the popup request\n (opener browser and frame). The |popup_id| value uniquely identifies the\n popup in the context of the opener browser. The |target_url| and\n |target_frame_name| values indicate where the popup browser should\n navigate and may be NULL if not specified with the request. The\n |target_disposition| value indicates where the user intended to open the\n popup (e.g. current tab, new tab, etc). The |user_gesture| value will be\n true (1) if the popup was opened via explicit user gesture (e.g. clicking\n a link) or false (0) if the popup opened automatically (e.g. via the\n DomContentLoaded event). The |popupFeatures| structure contains additional\n information about the requested popup window. To allow creation of the\n popup browser optionally modify |windowInfo|, |client|, |settings| and\n |no_javascript_access| and return false (0). To cancel creation of the\n popup browser return true (1). The |client| and |settings| values will\n default to the source browser's values. If the |no_javascript_access|\n value is set to false (0) the new browser will not be scriptable and may\n not be hosted in the same renderer process as the source browser. Any\n modifications to |windowInfo| will be ignored if the parent browser is\n wrapped in a cef_browser_view_t. The |extra_info| parameter provides an\n opportunity to specify extra information specific to the created popup\n browser that will be passed to\n cef_render_process_handler_t::on_browser_created() in the render process.\n\n If popup browser creation succeeds then OnAfterCreated will be called for\n the new popup browser. If popup browser creation fails, and if the opener\n browser has not yet been destroyed, then OnBeforePopupAborted will be\n called for the opener browser. See OnBeforePopupAborted documentation for\n additional details.\n"]
    pub on_before_popup: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_life_span_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            popup_id: ::std::os::raw::c_int,
            target_url: *const cef_string_t,
            target_frame_name: *const cef_string_t,
            target_disposition: cef_window_open_disposition_t,
            user_gesture: ::std::os::raw::c_int,
            popupFeatures: *const cef_popup_features_t,
            windowInfo: *mut _cef_window_info_t,
            client: *mut *mut _cef_client_t,
            settings: *mut _cef_browser_settings_t,
            extra_info: *mut *mut _cef_dictionary_value_t,
            no_javascript_access: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the UI thread if a new popup browser is aborted. This only\n occurs if the popup is allowed in OnBeforePopup and creation fails before\n OnAfterCreated is called for the new popup browser. The |browser| value is\n the source of the popup request (opener browser). The |popup_id| value\n uniquely identifies the popup in the context of the opener browser, and is\n the same value that was passed to OnBeforePopup.\n\n Any client state associated with pending popups should be cleared in\n OnBeforePopupAborted, OnAfterCreated of the popup browser, or\n OnBeforeClose of the opener browser. OnBeforeClose of the opener browser\n may be called before this function in cases where the opener is closing\n during popup creation, in which case cef_browser_host_t::IsValid will\n return false (0) in this function.\n"]
    pub on_before_popup_aborted: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_life_span_handler_t,
            browser: *mut _cef_browser_t,
            popup_id: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called on the UI thread before a new DevTools popup browser is created.\n The |browser| value represents the source of the popup request. Optionally\n modify |windowInfo|, |client|, |settings| and |extra_info| values. The\n |client|, |settings| and |extra_info| values will default to the source\n browser's values. Any modifications to |windowInfo| will be ignored if the\n parent browser is Views-hosted (wrapped in a cef_browser_view_t).\n\n The |extra_info| parameter provides an opportunity to specify extra\n information specific to the created popup browser that will be passed to\n cef_render_process_handler_t::on_browser_created() in the render process.\n The existing |extra_info| object, if any, will be read-only but may be\n replaced with a new object.\n\n Views-hosted source browsers will create Views-hosted DevTools popups\n unless |use_default_window| is set to to true (1). DevTools popups can be\n blocked by returning true (1) from cef_command_handler_t::OnChromeCommand\n for IDC_DEV_TOOLS. Only used with Chrome style.\n"]
    pub on_before_dev_tools_popup: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_life_span_handler_t,
            browser: *mut _cef_browser_t,
            windowInfo: *mut _cef_window_info_t,
            client: *mut *mut _cef_client_t,
            settings: *mut _cef_browser_settings_t,
            extra_info: *mut *mut _cef_dictionary_value_t,
            use_default_window: *mut ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called after a new browser is created. It is now safe to begin performing\n actions with |browser|. cef_frame_handler_t callbacks related to initial\n main frame creation will arrive before this callback. See\n cef_frame_handler_t documentation for additional usage information.\n"]
    pub on_after_created: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_life_span_handler_t, browser: *mut _cef_browser_t),
    >,
    #[doc = "\n Called when an Alloy style browser is ready to be closed, meaning that the\n close has already been initiated and that JavaScript unload handlers have\n already executed or should be ignored. This may result directly from a\n call to cef_browser_host_t::[Try]close_browser() or indirectly if the\n browser's top-level parent window was created by CEF and the user attempts\n to close that window (by clicking the 'X', for example). do_close() will\n not be called if the browser's host window/view has already been destroyed\n (via parent window/view hierarchy tear-down, for example), as it is no\n longer possible to customize the close behavior at that point.\n\n An application should handle top-level parent window close notifications\n by calling cef_browser_host_t::try_close_browser() or\n cef_browser_host_t::CloseBrowser(false (0)) instead of allowing the window\n to close immediately (see the examples below). This gives CEF an\n opportunity to process JavaScript unload handlers and optionally cancel\n the close before do_close() is called.\n\n When windowed rendering is enabled CEF will create an internal child\n window/view to host the browser. In that case returning false (0) from\n do_close() will send the standard close notification to the browser's top-\n level parent window (e.g. WM_CLOSE on Windows, performClose: on OS X,\n \"delete_event\" on Linux or cef_window_delegate_t::can_close() callback\n from Views).\n\n When windowed rendering is disabled there is no internal window/view and\n returning false (0) from do_close() will cause the browser object to be\n destroyed immediately.\n\n If the browser's top-level parent window requires a non-standard close\n notification then send that notification from do_close() and return true\n (1). You are still required to complete the browser close as soon as\n possible (either by calling [Try]close_browser() or by proceeding with\n window/view hierarchy tear-down), otherwise the browser will be left in a\n partially closed state that interferes with proper functioning. Top-level\n windows created on the browser process UI thread can alternately call\n cef_browser_host_t::is_ready_to_be_closed() in the close handler to check\n close status instead of relying on custom do_close() handling. See\n documentation on that function for additional details.\n\n The cef_life_span_handler_t::on_before_close() function will be called\n after do_close() (if do_close() is called) and immediately before the\n browser object is destroyed. The application should only exit after\n on_before_close() has been called for all existing browsers.\n\n The below examples describe what should happen during window close when\n the browser is parented to an application-provided top-level window.\n\n Example 1: Using cef_browser_host_t::try_close_browser(). This is\n recommended for clients using standard close handling and windows created\n on the browser process UI thread. 1.  User clicks the window close button\n which sends a close notification\n     to the application's top-level window.\n 2.  Application's top-level window receives the close notification and\n     calls TryCloseBrowser() (similar to calling CloseBrowser(false)).\n     TryCloseBrowser() returns false so the client cancels the window\n     close.\n 3.  JavaScript 'onbeforeunload' handler executes and shows the close\n     confirmation dialog (which can be overridden via\n     CefJSDialogHandler::OnBeforeUnloadDialog()).\n 4.  User approves the close. 5.  JavaScript 'onunload' handler executes.\n 6.  Application's do_close() handler is called and returns false (0) by\n     default.\n 7.  CEF sends a close notification to the application's top-level window\n     (because DoClose() returned false).\n 8.  Application's top-level window receives the close notification and\n     calls TryCloseBrowser(). TryCloseBrowser() returns true so the client\n     allows the window close.\n 9.  Application's top-level window is destroyed, triggering destruction\n     of the child browser window.\n 10. Application's on_before_close() handler is called and the browser\n object\n     is destroyed.\n 11. Application exits by calling cef_quit_message_loop() if no other\n browsers\n     exist.\n\n Example 2: Using cef_browser_host_t::CloseBrowser(false (0)) and\n implementing the do_close() callback. This is recommended for clients\n using non-standard close handling or windows that were not created on the\n browser process UI thread. 1.  User clicks the window close button which\n sends a close notification\n     to the application's top-level window.\n 2.  Application's top-level window receives the close notification and:\n     A. Calls CefBrowserHost::CloseBrowser(false).\n     B. Cancels the window close.\n 3.  JavaScript 'onbeforeunload' handler executes and shows the close\n     confirmation dialog (which can be overridden via\n     CefJSDialogHandler::OnBeforeUnloadDialog()).\n 4.  User approves the close. 5.  JavaScript 'onunload' handler executes.\n 6.  Application's do_close() handler is called. Application will:\n     A. Set a flag to indicate that the next top-level window close attempt\n        will be allowed.\n     B. Return false.\n 7.  CEF sends a close notification to the application's top-level window\n     (because DoClose() returned false).\n 8.  Application's top-level window receives the close notification and\n     allows the window to close based on the flag from #6A.\n 9.  Application's top-level window is destroyed, triggering destruction\n     of the child browser window.\n 10. Application's on_before_close() handler is called and the browser\n object\n     is destroyed.\n 11. Application exits by calling cef_quit_message_loop() if no other\n browsers\n     exist.\n"]
    pub do_close: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_life_span_handler_t,
            browser: *mut _cef_browser_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called just before a browser is destroyed. Release all references to the\n browser object and do not attempt to execute any functions on the browser\n object (other than IsValid, GetIdentifier or IsSame) after this callback\n returns. cef_frame_handler_t callbacks related to final main frame\n destruction, and OnBeforePopupAborted callbacks for any pending popups,\n will arrive after this callback and cef_browser_t::IsValid will return\n false (0) at that time. Any in-progress network requests associated with\n |browser| will be aborted when the browser is destroyed, and\n cef_resource_request_handler_t callbacks related to those requests may\n still arrive on the IO thread after this callback. See cef_frame_handler_t\n and do_close() documentation for additional usage information.\n"]
    pub on_before_close: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_life_span_handler_t, browser: *mut _cef_browser_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_life_span_handler_t"]
        [::std::mem::size_of::<_cef_life_span_handler_t>() - 88usize];
    ["Alignment of _cef_life_span_handler_t"]
        [::std::mem::align_of::<_cef_life_span_handler_t>() - 8usize];
    ["Offset of field: _cef_life_span_handler_t::base"]
        [::std::mem::offset_of!(_cef_life_span_handler_t, base) - 0usize];
    ["Offset of field: _cef_life_span_handler_t::on_before_popup"]
        [::std::mem::offset_of!(_cef_life_span_handler_t, on_before_popup) - 40usize];
    ["Offset of field: _cef_life_span_handler_t::on_before_popup_aborted"]
        [::std::mem::offset_of!(_cef_life_span_handler_t, on_before_popup_aborted) - 48usize];
    ["Offset of field: _cef_life_span_handler_t::on_before_dev_tools_popup"]
        [::std::mem::offset_of!(_cef_life_span_handler_t, on_before_dev_tools_popup) - 56usize];
    ["Offset of field: _cef_life_span_handler_t::on_after_created"]
        [::std::mem::offset_of!(_cef_life_span_handler_t, on_after_created) - 64usize];
    ["Offset of field: _cef_life_span_handler_t::do_close"]
        [::std::mem::offset_of!(_cef_life_span_handler_t, do_close) - 72usize];
    ["Offset of field: _cef_life_span_handler_t::on_before_close"]
        [::std::mem::offset_of!(_cef_life_span_handler_t, on_before_close) - 80usize];
};
#[doc = "\n Implement this structure to handle events related to browser life span. The\n functions of this structure will be called on the UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_life_span_handler_t = _cef_life_span_handler_t;
#[doc = "\n Implement this structure to handle events related to browser load status.\n The functions of this structure will be called on the browser process UI\n thread or render process main thread (TID_RENDERER).\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_load_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when the loading state has changed. This callback will be executed\n twice -- once when loading is initiated either programmatically or by user\n action, and once when loading is terminated due to completion,\n cancellation of failure. It will be called before any calls to OnLoadStart\n and after all calls to OnLoadError and/or OnLoadEnd.\n"]
    pub on_loading_state_change: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_load_handler_t,
            browser: *mut _cef_browser_t,
            isLoading: ::std::os::raw::c_int,
            canGoBack: ::std::os::raw::c_int,
            canGoForward: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called after a navigation has been committed and before the browser begins\n loading contents in the frame. The |frame| value will never be NULL --\n call the is_main() function to check if this frame is the main frame.\n |transition_type| provides information about the source of the navigation\n and an accurate value is only available in the browser process. Multiple\n frames may be loading at the same time. Sub-frames may start or continue\n loading after the main frame load has ended. This function will not be\n called for same page navigations (fragments, history state, etc.) or for\n navigations that fail or are canceled before commit. For notification of\n overall browser load status use OnLoadingStateChange instead.\n"]
    pub on_load_start: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_load_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            transition_type: cef_transition_type_t,
        ),
    >,
    #[doc = "\n Called when the browser is done loading a frame. The |frame| value will\n never be NULL -- call the is_main() function to check if this frame is the\n main frame. Multiple frames may be loading at the same time. Sub-frames\n may start or continue loading after the main frame load has ended. This\n function will not be called for same page navigations (fragments, history\n state, etc.) or for navigations that fail or are canceled before commit.\n For notification of overall browser load status use OnLoadingStateChange\n instead.\n"]
    pub on_load_end: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_load_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            httpStatusCode: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called when a navigation fails or is canceled. This function may be called\n by itself if before commit or in combination with OnLoadStart/OnLoadEnd if\n after commit. |errorCode| is the error code number, |errorText| is the\n error text and |failedUrl| is the URL that failed to load. See\n net\\base\\net_error_list.h for complete descriptions of the error codes.\n"]
    pub on_load_error: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_load_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            errorCode: cef_errorcode_t,
            errorText: *const cef_string_t,
            failedUrl: *const cef_string_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_load_handler_t"][::std::mem::size_of::<_cef_load_handler_t>() - 72usize];
    ["Alignment of _cef_load_handler_t"][::std::mem::align_of::<_cef_load_handler_t>() - 8usize];
    ["Offset of field: _cef_load_handler_t::base"]
        [::std::mem::offset_of!(_cef_load_handler_t, base) - 0usize];
    ["Offset of field: _cef_load_handler_t::on_loading_state_change"]
        [::std::mem::offset_of!(_cef_load_handler_t, on_loading_state_change) - 40usize];
    ["Offset of field: _cef_load_handler_t::on_load_start"]
        [::std::mem::offset_of!(_cef_load_handler_t, on_load_start) - 48usize];
    ["Offset of field: _cef_load_handler_t::on_load_end"]
        [::std::mem::offset_of!(_cef_load_handler_t, on_load_end) - 56usize];
    ["Offset of field: _cef_load_handler_t::on_load_error"]
        [::std::mem::offset_of!(_cef_load_handler_t, on_load_error) - 64usize];
};
#[doc = "\n Implement this structure to handle events related to browser load status.\n The functions of this structure will be called on the browser process UI\n thread or render process main thread (TID_RENDERER).\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_load_handler_t = _cef_load_handler_t;
#[doc = "\n Callback structure used for asynchronous continuation of media access\n permission requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_media_access_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Call to allow or deny media access. If this callback was initiated in\n response to a getUserMedia (indicated by\n CEF_MEDIA_PERMISSION_DEVICE_AUDIO_CAPTURE and/or\n CEF_MEDIA_PERMISSION_DEVICE_VIDEO_CAPTURE being set) then\n |allowed_permissions| must match |required_permissions| passed to\n OnRequestMediaAccessPermission.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_media_access_callback_t, allowed_permissions: u32),
    >,
    #[doc = "\n Cancel the media access request.\n"]
    pub cancel:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_media_access_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_media_access_callback_t"]
        [::std::mem::size_of::<_cef_media_access_callback_t>() - 56usize];
    ["Alignment of _cef_media_access_callback_t"]
        [::std::mem::align_of::<_cef_media_access_callback_t>() - 8usize];
    ["Offset of field: _cef_media_access_callback_t::base"]
        [::std::mem::offset_of!(_cef_media_access_callback_t, base) - 0usize];
    ["Offset of field: _cef_media_access_callback_t::cont"]
        [::std::mem::offset_of!(_cef_media_access_callback_t, cont) - 40usize];
    ["Offset of field: _cef_media_access_callback_t::cancel"]
        [::std::mem::offset_of!(_cef_media_access_callback_t, cancel) - 48usize];
};
#[doc = "\n Callback structure used for asynchronous continuation of media access\n permission requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_media_access_callback_t = _cef_media_access_callback_t;
#[doc = "\n Callback structure used for asynchronous continuation of permission prompts.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_permission_prompt_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Complete the permissions request with the specified |result|.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_permission_prompt_callback_t,
            result: cef_permission_request_result_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_permission_prompt_callback_t"]
        [::std::mem::size_of::<_cef_permission_prompt_callback_t>() - 48usize];
    ["Alignment of _cef_permission_prompt_callback_t"]
        [::std::mem::align_of::<_cef_permission_prompt_callback_t>() - 8usize];
    ["Offset of field: _cef_permission_prompt_callback_t::base"]
        [::std::mem::offset_of!(_cef_permission_prompt_callback_t, base) - 0usize];
    ["Offset of field: _cef_permission_prompt_callback_t::cont"]
        [::std::mem::offset_of!(_cef_permission_prompt_callback_t, cont) - 40usize];
};
#[doc = "\n Callback structure used for asynchronous continuation of permission prompts.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_permission_prompt_callback_t = _cef_permission_prompt_callback_t;
#[doc = "\n Implement this structure to handle events related to permission requests.\n The functions of this structure will be called on the browser process UI\n thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_permission_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when a page requests permission to access media.\n |requesting_origin| is the URL origin requesting permission.\n |requested_permissions| is a combination of values from\n cef_media_access_permission_types_t that represent the requested\n permissions. Return true (1) and call cef_media_access_callback_t\n functions either in this function or at a later time to continue or cancel\n the request. Return false (0) to proceed with default handling. With\n Chrome style, default handling will display the permission request UI.\n With Alloy style, default handling will deny the request. This function\n will not be called if the \"--enable-media-stream\" command-line switch is\n used to grant all permissions.\n"]
    pub on_request_media_access_permission: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_permission_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            requesting_origin: *const cef_string_t,
            requested_permissions: u32,
            callback: *mut _cef_media_access_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when a page should show a permission prompt. |prompt_id| uniquely\n identifies the prompt. |requesting_origin| is the URL origin requesting\n permission. |requested_permissions| is a combination of values from\n cef_permission_request_types_t that represent the requested permissions.\n Return true (1) and call cef_permission_prompt_callback_t::Continue either\n in this function or at a later time to continue or cancel the request.\n Return false (0) to proceed with default handling. With Chrome style,\n default handling will display the permission prompt UI. With Alloy style,\n default handling is CEF_PERMISSION_RESULT_IGNORE.\n"]
    pub on_show_permission_prompt: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_permission_handler_t,
            browser: *mut _cef_browser_t,
            prompt_id: u64,
            requesting_origin: *const cef_string_t,
            requested_permissions: u32,
            callback: *mut _cef_permission_prompt_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when a permission prompt handled via OnShowPermissionPrompt is\n dismissed. |prompt_id| will match the value that was passed to\n OnShowPermissionPrompt. |result| will be the value passed to\n cef_permission_prompt_callback_t::Continue or CEF_PERMISSION_RESULT_IGNORE\n if the dialog was dismissed for other reasons such as navigation, browser\n closure, etc. This function will not be called if OnShowPermissionPrompt\n returned false (0) for |prompt_id|.\n"]
    pub on_dismiss_permission_prompt: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_permission_handler_t,
            browser: *mut _cef_browser_t,
            prompt_id: u64,
            result: cef_permission_request_result_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_permission_handler_t"]
        [::std::mem::size_of::<_cef_permission_handler_t>() - 64usize];
    ["Alignment of _cef_permission_handler_t"]
        [::std::mem::align_of::<_cef_permission_handler_t>() - 8usize];
    ["Offset of field: _cef_permission_handler_t::base"]
        [::std::mem::offset_of!(_cef_permission_handler_t, base) - 0usize];
    ["Offset of field: _cef_permission_handler_t::on_request_media_access_permission"][::std::mem::offset_of!(
        _cef_permission_handler_t,
        on_request_media_access_permission
    ) - 40usize];
    ["Offset of field: _cef_permission_handler_t::on_show_permission_prompt"]
        [::std::mem::offset_of!(_cef_permission_handler_t, on_show_permission_prompt) - 48usize];
    ["Offset of field: _cef_permission_handler_t::on_dismiss_permission_prompt"]
        [::std::mem::offset_of!(_cef_permission_handler_t, on_dismiss_permission_prompt) - 56usize];
};
#[doc = "\n Implement this structure to handle events related to permission requests.\n The functions of this structure will be called on the browser process UI\n thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_permission_handler_t = _cef_permission_handler_t;
#[doc = "\n Structure representing print settings.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_print_settings_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is valid. Do not call any other functions\n if this function returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the values of this object are read-only. Some APIs may\n expose read-only objects.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the page orientation.\n"]
    pub set_orientation: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t, landscape: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns true (1) if the orientation is landscape.\n"]
    pub is_landscape: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the printer printable area in device units. Some platforms already\n provide flipped area. Set |landscape_needs_flip| to false (0) on those\n platforms to avoid double flipping.\n"]
    pub set_printer_printable_area: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_settings_t,
            physical_size_device_units: *const cef_size_t,
            printable_area_device_units: *const cef_rect_t,
            landscape_needs_flip: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Set the device name.\n"]
    pub set_device_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t, name: *const cef_string_t),
    >,
    #[doc = "\n Get the device name.\n"]
    pub get_device_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the DPI (dots per inch).\n"]
    pub set_dpi: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t, dpi: ::std::os::raw::c_int),
    >,
    #[doc = "\n Get the DPI (dots per inch).\n"]
    pub get_dpi: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the page ranges.\n"]
    pub set_page_ranges: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_settings_t,
            rangesCount: usize,
            ranges: *const cef_range_t,
        ),
    >,
    #[doc = "\n Returns the number of page ranges that currently exist.\n"]
    pub get_page_ranges_count:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> usize>,
    #[doc = "\n Retrieve the page ranges.\n"]
    pub get_page_ranges: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_settings_t,
            rangesCount: *mut usize,
            ranges: *mut cef_range_t,
        ),
    >,
    #[doc = "\n Set whether only the selection will be printed.\n"]
    pub set_selection_only: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_settings_t,
            selection_only: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Returns true (1) if only the selection will be printed.\n"]
    pub is_selection_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set whether pages will be collated.\n"]
    pub set_collate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t, collate: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns true (1) if pages will be collated.\n"]
    pub will_collate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the color model.\n"]
    pub set_color_model: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t, model: cef_color_model_t),
    >,
    #[doc = "\n Get the color model.\n"]
    pub get_color_model: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> cef_color_model_t,
    >,
    #[doc = "\n Set the number of copies.\n"]
    pub set_copies: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t, copies: ::std::os::raw::c_int),
    >,
    #[doc = "\n Get the number of copies.\n"]
    pub get_copies: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the duplex mode.\n"]
    pub set_duplex_mode: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t, mode: cef_duplex_mode_t),
    >,
    #[doc = "\n Get the duplex mode.\n"]
    pub get_duplex_mode: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_settings_t) -> cef_duplex_mode_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_print_settings_t"][::std::mem::size_of::<_cef_print_settings_t>() - 216usize];
    ["Alignment of _cef_print_settings_t"]
        [::std::mem::align_of::<_cef_print_settings_t>() - 8usize];
    ["Offset of field: _cef_print_settings_t::base"]
        [::std::mem::offset_of!(_cef_print_settings_t, base) - 0usize];
    ["Offset of field: _cef_print_settings_t::is_valid"]
        [::std::mem::offset_of!(_cef_print_settings_t, is_valid) - 40usize];
    ["Offset of field: _cef_print_settings_t::is_read_only"]
        [::std::mem::offset_of!(_cef_print_settings_t, is_read_only) - 48usize];
    ["Offset of field: _cef_print_settings_t::set_orientation"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_orientation) - 56usize];
    ["Offset of field: _cef_print_settings_t::is_landscape"]
        [::std::mem::offset_of!(_cef_print_settings_t, is_landscape) - 64usize];
    ["Offset of field: _cef_print_settings_t::set_printer_printable_area"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_printer_printable_area) - 72usize];
    ["Offset of field: _cef_print_settings_t::set_device_name"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_device_name) - 80usize];
    ["Offset of field: _cef_print_settings_t::get_device_name"]
        [::std::mem::offset_of!(_cef_print_settings_t, get_device_name) - 88usize];
    ["Offset of field: _cef_print_settings_t::set_dpi"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_dpi) - 96usize];
    ["Offset of field: _cef_print_settings_t::get_dpi"]
        [::std::mem::offset_of!(_cef_print_settings_t, get_dpi) - 104usize];
    ["Offset of field: _cef_print_settings_t::set_page_ranges"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_page_ranges) - 112usize];
    ["Offset of field: _cef_print_settings_t::get_page_ranges_count"]
        [::std::mem::offset_of!(_cef_print_settings_t, get_page_ranges_count) - 120usize];
    ["Offset of field: _cef_print_settings_t::get_page_ranges"]
        [::std::mem::offset_of!(_cef_print_settings_t, get_page_ranges) - 128usize];
    ["Offset of field: _cef_print_settings_t::set_selection_only"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_selection_only) - 136usize];
    ["Offset of field: _cef_print_settings_t::is_selection_only"]
        [::std::mem::offset_of!(_cef_print_settings_t, is_selection_only) - 144usize];
    ["Offset of field: _cef_print_settings_t::set_collate"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_collate) - 152usize];
    ["Offset of field: _cef_print_settings_t::will_collate"]
        [::std::mem::offset_of!(_cef_print_settings_t, will_collate) - 160usize];
    ["Offset of field: _cef_print_settings_t::set_color_model"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_color_model) - 168usize];
    ["Offset of field: _cef_print_settings_t::get_color_model"]
        [::std::mem::offset_of!(_cef_print_settings_t, get_color_model) - 176usize];
    ["Offset of field: _cef_print_settings_t::set_copies"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_copies) - 184usize];
    ["Offset of field: _cef_print_settings_t::get_copies"]
        [::std::mem::offset_of!(_cef_print_settings_t, get_copies) - 192usize];
    ["Offset of field: _cef_print_settings_t::set_duplex_mode"]
        [::std::mem::offset_of!(_cef_print_settings_t, set_duplex_mode) - 200usize];
    ["Offset of field: _cef_print_settings_t::get_duplex_mode"]
        [::std::mem::offset_of!(_cef_print_settings_t, get_duplex_mode) - 208usize];
};
#[doc = "\n Structure representing print settings.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_print_settings_t = _cef_print_settings_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_print_settings_t object.\n"]
    pub fn cef_print_settings_create() -> *mut cef_print_settings_t;
}
#[doc = "\n Callback structure for asynchronous continuation of print dialog requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_print_dialog_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Continue printing with the specified |settings|.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_dialog_callback_t,
            settings: *mut _cef_print_settings_t,
        ),
    >,
    #[doc = "\n Cancel the printing.\n"]
    pub cancel:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_print_dialog_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_print_dialog_callback_t"]
        [::std::mem::size_of::<_cef_print_dialog_callback_t>() - 56usize];
    ["Alignment of _cef_print_dialog_callback_t"]
        [::std::mem::align_of::<_cef_print_dialog_callback_t>() - 8usize];
    ["Offset of field: _cef_print_dialog_callback_t::base"]
        [::std::mem::offset_of!(_cef_print_dialog_callback_t, base) - 0usize];
    ["Offset of field: _cef_print_dialog_callback_t::cont"]
        [::std::mem::offset_of!(_cef_print_dialog_callback_t, cont) - 40usize];
    ["Offset of field: _cef_print_dialog_callback_t::cancel"]
        [::std::mem::offset_of!(_cef_print_dialog_callback_t, cancel) - 48usize];
};
#[doc = "\n Callback structure for asynchronous continuation of print dialog requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_print_dialog_callback_t = _cef_print_dialog_callback_t;
#[doc = "\n Callback structure for asynchronous continuation of print job requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_print_job_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Indicate completion of the print job.\n"]
    pub cont: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_print_job_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_print_job_callback_t"]
        [::std::mem::size_of::<_cef_print_job_callback_t>() - 48usize];
    ["Alignment of _cef_print_job_callback_t"]
        [::std::mem::align_of::<_cef_print_job_callback_t>() - 8usize];
    ["Offset of field: _cef_print_job_callback_t::base"]
        [::std::mem::offset_of!(_cef_print_job_callback_t, base) - 0usize];
    ["Offset of field: _cef_print_job_callback_t::cont"]
        [::std::mem::offset_of!(_cef_print_job_callback_t, cont) - 40usize];
};
#[doc = "\n Callback structure for asynchronous continuation of print job requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_print_job_callback_t = _cef_print_job_callback_t;
#[doc = "\n Implement this structure to handle printing on Linux. Each browser will have\n only one print job in progress at a time. The functions of this structure\n will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_print_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called when printing has started for the specified |browser|. This\n function will be called before the other OnPrint*() functions and\n irrespective of how printing was initiated (e.g.\n cef_browser_host_t::print(), JavaScript window.print() or PDF extension\n print button).\n"]
    pub on_print_start: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_handler_t, browser: *mut _cef_browser_t),
    >,
    #[doc = "\n Synchronize |settings| with client state. If |get_defaults| is true (1)\n then populate |settings| with the default print settings. Do not keep a\n reference to |settings| outside of this callback.\n"]
    pub on_print_settings: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_handler_t,
            browser: *mut _cef_browser_t,
            settings: *mut _cef_print_settings_t,
            get_defaults: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Show the print dialog. Execute |callback| once the dialog is dismissed.\n Return true (1) if the dialog will be displayed or false (0) to cancel the\n printing immediately.\n"]
    pub on_print_dialog: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_handler_t,
            browser: *mut _cef_browser_t,
            has_selection: ::std::os::raw::c_int,
            callback: *mut _cef_print_dialog_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Send the print job to the printer. Execute |callback| once the job is\n completed. Return true (1) if the job will proceed or false (0) to cancel\n the job immediately.\n"]
    pub on_print_job: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_handler_t,
            browser: *mut _cef_browser_t,
            document_name: *const cef_string_t,
            pdf_file_path: *const cef_string_t,
            callback: *mut _cef_print_job_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Reset client state related to printing.\n"]
    pub on_print_reset: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_print_handler_t, browser: *mut _cef_browser_t),
    >,
    #[doc = "\n Return the PDF paper size in device units. Used in combination with\n cef_browser_host_t::print_to_pdf().\n"]
    pub get_pdf_paper_size: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_print_handler_t,
            browser: *mut _cef_browser_t,
            device_units_per_inch: ::std::os::raw::c_int,
        ) -> cef_size_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_print_handler_t"][::std::mem::size_of::<_cef_print_handler_t>() - 88usize];
    ["Alignment of _cef_print_handler_t"][::std::mem::align_of::<_cef_print_handler_t>() - 8usize];
    ["Offset of field: _cef_print_handler_t::base"]
        [::std::mem::offset_of!(_cef_print_handler_t, base) - 0usize];
    ["Offset of field: _cef_print_handler_t::on_print_start"]
        [::std::mem::offset_of!(_cef_print_handler_t, on_print_start) - 40usize];
    ["Offset of field: _cef_print_handler_t::on_print_settings"]
        [::std::mem::offset_of!(_cef_print_handler_t, on_print_settings) - 48usize];
    ["Offset of field: _cef_print_handler_t::on_print_dialog"]
        [::std::mem::offset_of!(_cef_print_handler_t, on_print_dialog) - 56usize];
    ["Offset of field: _cef_print_handler_t::on_print_job"]
        [::std::mem::offset_of!(_cef_print_handler_t, on_print_job) - 64usize];
    ["Offset of field: _cef_print_handler_t::on_print_reset"]
        [::std::mem::offset_of!(_cef_print_handler_t, on_print_reset) - 72usize];
    ["Offset of field: _cef_print_handler_t::get_pdf_paper_size"]
        [::std::mem::offset_of!(_cef_print_handler_t, get_pdf_paper_size) - 80usize];
};
#[doc = "\n Implement this structure to handle printing on Linux. Each browser will have\n only one print job in progress at a time. The functions of this structure\n will be called on the browser process UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_print_handler_t = _cef_print_handler_t;
#[doc = "\n Implement this structure to receive accessibility notification when\n accessibility events have been registered. The functions of this structure\n will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_accessibility_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called after renderer process sends accessibility tree changes to the\n browser process.\n"]
    pub on_accessibility_tree_change: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_accessibility_handler_t, value: *mut _cef_value_t),
    >,
    #[doc = "\n Called after renderer process sends accessibility location changes to the\n browser process.\n"]
    pub on_accessibility_location_change: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_accessibility_handler_t, value: *mut _cef_value_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_accessibility_handler_t"]
        [::std::mem::size_of::<_cef_accessibility_handler_t>() - 56usize];
    ["Alignment of _cef_accessibility_handler_t"]
        [::std::mem::align_of::<_cef_accessibility_handler_t>() - 8usize];
    ["Offset of field: _cef_accessibility_handler_t::base"]
        [::std::mem::offset_of!(_cef_accessibility_handler_t, base) - 0usize];
    ["Offset of field: _cef_accessibility_handler_t::on_accessibility_tree_change"][::std::mem::offset_of!(
        _cef_accessibility_handler_t,
        on_accessibility_tree_change
    ) - 40usize];
    ["Offset of field: _cef_accessibility_handler_t::on_accessibility_location_change"][::std::mem::offset_of!(
        _cef_accessibility_handler_t,
        on_accessibility_location_change
    )
        - 48usize];
};
#[doc = "\n Implement this structure to receive accessibility notification when\n accessibility events have been registered. The functions of this structure\n will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_accessibility_handler_t = _cef_accessibility_handler_t;
#[doc = "\n Implement this structure to handle events when window rendering is disabled.\n The functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_render_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Return the handler for accessibility notifications. If no handler is\n provided the default implementation will be used.\n"]
    pub get_accessibility_handler: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
        ) -> *mut _cef_accessibility_handler_t,
    >,
    #[doc = "\n Called to retrieve the root window rectangle in screen DIP coordinates.\n Return true (1) if the rectangle was provided. If this function returns\n false (0) the rectangle from GetViewRect will be used.\n"]
    pub get_root_screen_rect: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            rect: *mut cef_rect_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to retrieve the view rectangle in screen DIP coordinates. This\n function must always provide a non-NULL rectangle.\n"]
    pub get_view_rect: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            rect: *mut cef_rect_t,
        ),
    >,
    #[doc = "\n Called to retrieve the translation from view DIP coordinates to screen\n coordinates. Windows/Linux should provide screen device (pixel)\n coordinates and MacOS should provide screen DIP coordinates. Return true\n (1) if the requested coordinates were provided.\n"]
    pub get_screen_point: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            viewX: ::std::os::raw::c_int,
            viewY: ::std::os::raw::c_int,
            screenX: *mut ::std::os::raw::c_int,
            screenY: *mut ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to allow the client to fill in the CefScreenInfo object with\n appropriate values. Return true (1) if the |screen_info| structure has\n been modified.\n\n If the screen info rectangle is left NULL the rectangle from GetViewRect\n will be used. If the rectangle is still NULL or invalid popups may not be\n drawn correctly.\n"]
    pub get_screen_info: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            screen_info: *mut cef_screen_info_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the browser wants to show or hide the popup widget. The popup\n should be shown if |show| is true (1) and hidden if |show| is false (0).\n"]
    pub on_popup_show: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            show: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called when the browser wants to move or resize the popup widget. |rect|\n contains the new location and size in view coordinates.\n"]
    pub on_popup_size: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            rect: *const cef_rect_t,
        ),
    >,
    #[doc = "\n Called when an element should be painted. Pixel values passed to this\n function are scaled relative to view coordinates based on the value of\n CefScreenInfo.device_scale_factor returned from GetScreenInfo. |type|\n indicates whether the element is the view or the popup widget. |buffer|\n contains the pixel data for the whole image. |dirtyRects| contains the set\n of rectangles in pixel coordinates that need to be repainted. |buffer|\n will be |width|*|height|*4 bytes in size and represents a BGRA image with\n an upper-left origin. This function is only called when\n cef_window_tInfo::shared_texture_enabled is set to false (0).\n"]
    pub on_paint: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            type_: cef_paint_element_type_t,
            dirtyRectsCount: usize,
            dirtyRects: *const cef_rect_t,
            buffer: *const ::std::os::raw::c_void,
            width: ::std::os::raw::c_int,
            height: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called when an element has been rendered to the shared texture handle.\n |type| indicates whether the element is the view or the popup widget.\n |dirtyRects| contains the set of rectangles in pixel coordinates that need\n to be repainted. |info| contains the shared handle; on Windows it is a\n HANDLE to a texture that can be opened with D3D11 OpenSharedResource, on\n macOS it is an IOSurface pointer that can be opened with Metal or OpenGL,\n and on Linux it contains several planes, each with an fd to the underlying\n system native buffer.\n\n The underlying implementation uses a pool to deliver frames. As a result,\n the handle may differ every frame depending on how many frames are in-\n progress. The handle's resource cannot be cached and cannot be accessed\n outside of this callback. It should be reopened each time this callback is\n executed and the contents should be copied to a texture owned by the\n client application. The contents of |info| will be released back to the\n pool after this callback returns.\n"]
    pub on_accelerated_paint: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            type_: cef_paint_element_type_t,
            dirtyRectsCount: usize,
            dirtyRects: *const cef_rect_t,
            info: *const cef_accelerated_paint_info_t,
        ),
    >,
    #[doc = "\n Called to retrieve the size of the touch handle for the specified\n |orientation|.\n"]
    pub get_touch_handle_size: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            orientation: cef_horizontal_alignment_t,
            size: *mut cef_size_t,
        ),
    >,
    #[doc = "\n Called when touch handle state is updated. The client is responsible for\n rendering the touch handles.\n"]
    pub on_touch_handle_state_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            state: *const cef_touch_handle_state_t,
        ),
    >,
    #[doc = "\n Called when the user starts dragging content in the web view. Contextual\n information about the dragged content is supplied by |drag_data|. (|x|,\n |y|) is the drag start location in screen coordinates. OS APIs that run a\n system message loop may be used within the StartDragging call.\n\n Return false (0) to abort the drag operation. Don't call any of\n cef_browser_host_t::DragSource*Ended* functions after returning false (0).\n\n Return true (1) to handle the drag operation. Call\n cef_browser_host_t::DragSourceEndedAt and DragSourceSystemDragEnded either\n synchronously or asynchronously to inform the web view that the drag\n operation has ended.\n"]
    pub start_dragging: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            drag_data: *mut _cef_drag_data_t,
            allowed_ops: cef_drag_operations_mask_t,
            x: ::std::os::raw::c_int,
            y: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the web view wants to update the mouse cursor during a drag &\n drop operation. |operation| describes the allowed operation (none, move,\n copy, link).\n"]
    pub update_drag_cursor: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            operation: cef_drag_operations_mask_t,
        ),
    >,
    #[doc = "\n Called when the scroll offset has changed.\n"]
    pub on_scroll_offset_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            x: f64,
            y: f64,
        ),
    >,
    #[doc = "\n Called when the IME composition range has changed. |selected_range| is the\n range of characters that have been selected. |character_bounds| is the\n bounds of each character in view coordinates.\n"]
    pub on_ime_composition_range_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            selected_range: *const cef_range_t,
            character_boundsCount: usize,
            character_bounds: *const cef_rect_t,
        ),
    >,
    #[doc = "\n Called when text selection has changed for the specified |browser|.\n |selected_text| is the currently selected text and |selected_range| is the\n character range.\n"]
    pub on_text_selection_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            selected_text: *const cef_string_t,
            selected_range: *const cef_range_t,
        ),
    >,
    #[doc = "\n Called when an on-screen keyboard should be shown or hidden for the\n specified |browser|. |input_mode| specifies what kind of keyboard should\n be opened. If |input_mode| is CEF_TEXT_INPUT_MODE_NONE, any existing\n keyboard for this browser should be hidden.\n"]
    pub on_virtual_keyboard_requested: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_handler_t,
            browser: *mut _cef_browser_t,
            input_mode: cef_text_input_mode_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_render_handler_t"][::std::mem::size_of::<_cef_render_handler_t>() - 176usize];
    ["Alignment of _cef_render_handler_t"]
        [::std::mem::align_of::<_cef_render_handler_t>() - 8usize];
    ["Offset of field: _cef_render_handler_t::base"]
        [::std::mem::offset_of!(_cef_render_handler_t, base) - 0usize];
    ["Offset of field: _cef_render_handler_t::get_accessibility_handler"]
        [::std::mem::offset_of!(_cef_render_handler_t, get_accessibility_handler) - 40usize];
    ["Offset of field: _cef_render_handler_t::get_root_screen_rect"]
        [::std::mem::offset_of!(_cef_render_handler_t, get_root_screen_rect) - 48usize];
    ["Offset of field: _cef_render_handler_t::get_view_rect"]
        [::std::mem::offset_of!(_cef_render_handler_t, get_view_rect) - 56usize];
    ["Offset of field: _cef_render_handler_t::get_screen_point"]
        [::std::mem::offset_of!(_cef_render_handler_t, get_screen_point) - 64usize];
    ["Offset of field: _cef_render_handler_t::get_screen_info"]
        [::std::mem::offset_of!(_cef_render_handler_t, get_screen_info) - 72usize];
    ["Offset of field: _cef_render_handler_t::on_popup_show"]
        [::std::mem::offset_of!(_cef_render_handler_t, on_popup_show) - 80usize];
    ["Offset of field: _cef_render_handler_t::on_popup_size"]
        [::std::mem::offset_of!(_cef_render_handler_t, on_popup_size) - 88usize];
    ["Offset of field: _cef_render_handler_t::on_paint"]
        [::std::mem::offset_of!(_cef_render_handler_t, on_paint) - 96usize];
    ["Offset of field: _cef_render_handler_t::on_accelerated_paint"]
        [::std::mem::offset_of!(_cef_render_handler_t, on_accelerated_paint) - 104usize];
    ["Offset of field: _cef_render_handler_t::get_touch_handle_size"]
        [::std::mem::offset_of!(_cef_render_handler_t, get_touch_handle_size) - 112usize];
    ["Offset of field: _cef_render_handler_t::on_touch_handle_state_changed"]
        [::std::mem::offset_of!(_cef_render_handler_t, on_touch_handle_state_changed) - 120usize];
    ["Offset of field: _cef_render_handler_t::start_dragging"]
        [::std::mem::offset_of!(_cef_render_handler_t, start_dragging) - 128usize];
    ["Offset of field: _cef_render_handler_t::update_drag_cursor"]
        [::std::mem::offset_of!(_cef_render_handler_t, update_drag_cursor) - 136usize];
    ["Offset of field: _cef_render_handler_t::on_scroll_offset_changed"]
        [::std::mem::offset_of!(_cef_render_handler_t, on_scroll_offset_changed) - 144usize];
    ["Offset of field: _cef_render_handler_t::on_ime_composition_range_changed"][::std::mem::offset_of!(
        _cef_render_handler_t,
        on_ime_composition_range_changed
    ) - 152usize];
    ["Offset of field: _cef_render_handler_t::on_text_selection_changed"]
        [::std::mem::offset_of!(_cef_render_handler_t, on_text_selection_changed) - 160usize];
    ["Offset of field: _cef_render_handler_t::on_virtual_keyboard_requested"]
        [::std::mem::offset_of!(_cef_render_handler_t, on_virtual_keyboard_requested) - 168usize];
};
#[doc = "\n Implement this structure to handle events when window rendering is disabled.\n The functions of this structure will be called on the UI thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_render_handler_t = _cef_render_handler_t;
#[doc = "\n Callback structure used for asynchronous continuation of authentication\n requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_auth_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Continue the authentication request.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_auth_callback_t,
            username: *const cef_string_t,
            password: *const cef_string_t,
        ),
    >,
    #[doc = "\n Cancel the authentication request.\n"]
    pub cancel: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_auth_callback_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_auth_callback_t"][::std::mem::size_of::<_cef_auth_callback_t>() - 56usize];
    ["Alignment of _cef_auth_callback_t"][::std::mem::align_of::<_cef_auth_callback_t>() - 8usize];
    ["Offset of field: _cef_auth_callback_t::base"]
        [::std::mem::offset_of!(_cef_auth_callback_t, base) - 0usize];
    ["Offset of field: _cef_auth_callback_t::cont"]
        [::std::mem::offset_of!(_cef_auth_callback_t, cont) - 40usize];
    ["Offset of field: _cef_auth_callback_t::cancel"]
        [::std::mem::offset_of!(_cef_auth_callback_t, cancel) - 48usize];
};
#[doc = "\n Callback structure used for asynchronous continuation of authentication\n requests.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_auth_callback_t = _cef_auth_callback_t;
#[doc = "\n Structure used to represent a web response. The functions of this structure\n may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_response_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is read-only.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Get the response error code. Returns ERR_NONE if there was no error.\n"]
    pub get_error:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_response_t) -> cef_errorcode_t>,
    #[doc = "\n Set the response error code. This can be used by custom scheme handlers to\n return errors during initial request processing.\n"]
    pub set_error: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t, error: cef_errorcode_t),
    >,
    #[doc = "\n Get the response status code.\n"]
    pub get_status: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set the response status code.\n"]
    pub set_status: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t, status: ::std::os::raw::c_int),
    >,
    #[doc = "\n Get the response status text.\n"]
    pub get_status_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the response status text.\n"]
    pub set_status_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t, statusText: *const cef_string_t),
    >,
    #[doc = "\n Get the response mime type.\n"]
    pub get_mime_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the response mime type.\n"]
    pub set_mime_type: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t, mimeType: *const cef_string_t),
    >,
    #[doc = "\n Get the response charset.\n"]
    pub get_charset: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the response charset.\n"]
    pub set_charset: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t, charset: *const cef_string_t),
    >,
    #[doc = "\n Get the value for the specified response header field.\n"]
    pub get_header_by_name: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_response_t,
            name: *const cef_string_t,
        ) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the header |name| to |value|. If |overwrite| is true (1) any existing\n values will be replaced with the new value. If |overwrite| is false (0)\n any existing values will not be overwritten.\n"]
    pub set_header_by_name: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_response_t,
            name: *const cef_string_t,
            value: *const cef_string_t,
            overwrite: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Get all response header fields.\n"]
    pub get_header_map: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t, headerMap: cef_string_multimap_t),
    >,
    #[doc = "\n Set all response header fields.\n"]
    pub set_header_map: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t, headerMap: cef_string_multimap_t),
    >,
    #[doc = "\n Get the resolved URL after redirects or changed as a result of HSTS.\n"]
    pub get_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the resolved URL after redirects or changed as a result of HSTS.\n"]
    pub set_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_t, url: *const cef_string_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_response_t"][::std::mem::size_of::<_cef_response_t>() - 176usize];
    ["Alignment of _cef_response_t"][::std::mem::align_of::<_cef_response_t>() - 8usize];
    ["Offset of field: _cef_response_t::base"]
        [::std::mem::offset_of!(_cef_response_t, base) - 0usize];
    ["Offset of field: _cef_response_t::is_read_only"]
        [::std::mem::offset_of!(_cef_response_t, is_read_only) - 40usize];
    ["Offset of field: _cef_response_t::get_error"]
        [::std::mem::offset_of!(_cef_response_t, get_error) - 48usize];
    ["Offset of field: _cef_response_t::set_error"]
        [::std::mem::offset_of!(_cef_response_t, set_error) - 56usize];
    ["Offset of field: _cef_response_t::get_status"]
        [::std::mem::offset_of!(_cef_response_t, get_status) - 64usize];
    ["Offset of field: _cef_response_t::set_status"]
        [::std::mem::offset_of!(_cef_response_t, set_status) - 72usize];
    ["Offset of field: _cef_response_t::get_status_text"]
        [::std::mem::offset_of!(_cef_response_t, get_status_text) - 80usize];
    ["Offset of field: _cef_response_t::set_status_text"]
        [::std::mem::offset_of!(_cef_response_t, set_status_text) - 88usize];
    ["Offset of field: _cef_response_t::get_mime_type"]
        [::std::mem::offset_of!(_cef_response_t, get_mime_type) - 96usize];
    ["Offset of field: _cef_response_t::set_mime_type"]
        [::std::mem::offset_of!(_cef_response_t, set_mime_type) - 104usize];
    ["Offset of field: _cef_response_t::get_charset"]
        [::std::mem::offset_of!(_cef_response_t, get_charset) - 112usize];
    ["Offset of field: _cef_response_t::set_charset"]
        [::std::mem::offset_of!(_cef_response_t, set_charset) - 120usize];
    ["Offset of field: _cef_response_t::get_header_by_name"]
        [::std::mem::offset_of!(_cef_response_t, get_header_by_name) - 128usize];
    ["Offset of field: _cef_response_t::set_header_by_name"]
        [::std::mem::offset_of!(_cef_response_t, set_header_by_name) - 136usize];
    ["Offset of field: _cef_response_t::get_header_map"]
        [::std::mem::offset_of!(_cef_response_t, get_header_map) - 144usize];
    ["Offset of field: _cef_response_t::set_header_map"]
        [::std::mem::offset_of!(_cef_response_t, set_header_map) - 152usize];
    ["Offset of field: _cef_response_t::get_url"]
        [::std::mem::offset_of!(_cef_response_t, get_url) - 160usize];
    ["Offset of field: _cef_response_t::set_url"]
        [::std::mem::offset_of!(_cef_response_t, set_url) - 168usize];
};
#[doc = "\n Structure used to represent a web response. The functions of this structure\n may be called on any thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_response_t = _cef_response_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_response_t object.\n"]
    pub fn cef_response_create() -> *mut cef_response_t;
}
#[doc = "\n Callback for asynchronous continuation of cef_resource_handler_t::skip().\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_resource_skip_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Callback for asynchronous continuation of skip(). If |bytes_skipped| > 0\n then either skip() will be called again until the requested number of\n bytes have been skipped or the request will proceed. If |bytes_skipped| <=\n 0 the request will fail with ERR_REQUEST_RANGE_NOT_SATISFIABLE.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_resource_skip_callback_t, bytes_skipped: i64),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_resource_skip_callback_t"]
        [::std::mem::size_of::<_cef_resource_skip_callback_t>() - 48usize];
    ["Alignment of _cef_resource_skip_callback_t"]
        [::std::mem::align_of::<_cef_resource_skip_callback_t>() - 8usize];
    ["Offset of field: _cef_resource_skip_callback_t::base"]
        [::std::mem::offset_of!(_cef_resource_skip_callback_t, base) - 0usize];
    ["Offset of field: _cef_resource_skip_callback_t::cont"]
        [::std::mem::offset_of!(_cef_resource_skip_callback_t, cont) - 40usize];
};
#[doc = "\n Callback for asynchronous continuation of cef_resource_handler_t::skip().\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_resource_skip_callback_t = _cef_resource_skip_callback_t;
#[doc = "\n Callback for asynchronous continuation of cef_resource_handler_t::read().\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_resource_read_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Callback for asynchronous continuation of read(). If |bytes_read| == 0 the\n response will be considered complete. If |bytes_read| > 0 then read() will\n be called again until the request is complete (based on either the result\n or the expected content length). If |bytes_read| < 0 then the request will\n fail and the |bytes_read| value will be treated as the error code.\n"]
    pub cont: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_read_callback_t,
            bytes_read: ::std::os::raw::c_int,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_resource_read_callback_t"]
        [::std::mem::size_of::<_cef_resource_read_callback_t>() - 48usize];
    ["Alignment of _cef_resource_read_callback_t"]
        [::std::mem::align_of::<_cef_resource_read_callback_t>() - 8usize];
    ["Offset of field: _cef_resource_read_callback_t::base"]
        [::std::mem::offset_of!(_cef_resource_read_callback_t, base) - 0usize];
    ["Offset of field: _cef_resource_read_callback_t::cont"]
        [::std::mem::offset_of!(_cef_resource_read_callback_t, cont) - 40usize];
};
#[doc = "\n Callback for asynchronous continuation of cef_resource_handler_t::read().\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_resource_read_callback_t = _cef_resource_read_callback_t;
#[doc = "\n Structure used to implement a custom request handler structure. The\n functions of this structure will be called on the IO thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_resource_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Open the response stream. To handle the request immediately set\n |handle_request| to true (1) and return true (1). To decide at a later\n time set |handle_request| to false (0), return true (1), and execute\n |callback| to continue or cancel the request. To cancel the request\n immediately set |handle_request| to true (1) and return false (0). This\n function will be called in sequence but not from a dedicated thread. For\n backwards compatibility set |handle_request| to false (0) and return false\n (0) and the ProcessRequest function will be called.\n"]
    pub open: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_handler_t,
            request: *mut _cef_request_t,
            handle_request: *mut ::std::os::raw::c_int,
            callback: *mut _cef_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Begin processing the request. To handle the request return true (1) and\n call cef_callback_t::cont() once the response header information is\n available (cef_callback_t::cont() can also be called from inside this\n function if header information is available immediately). To cancel the\n request return false (0).\n\n WARNING: This function is deprecated. Use Open instead.\n"]
    pub process_request: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_handler_t,
            request: *mut _cef_request_t,
            callback: *mut _cef_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Retrieve response header information. If the response length is not known\n set |response_length| to -1 and read_response() will be called until it\n returns false (0). If the response length is known set |response_length|\n to a positive value and read_response() will be called until it returns\n false (0) or the specified number of bytes have been read. Use the\n |response| object to set the mime type, http status code and other\n optional header values. To redirect the request to a new URL set\n |redirectUrl| to the new URL. |redirectUrl| can be either a relative or\n fully qualified URL. It is also possible to set |response| to a redirect\n http status code and pass the new URL via a Location header. Likewise with\n |redirectUrl| it is valid to set a relative or fully qualified URL as the\n Location header value. If an error occured while setting up the request\n you can call set_error() on |response| to indicate the error condition.\n"]
    pub get_response_headers: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_handler_t,
            response: *mut _cef_response_t,
            response_length: *mut i64,
            redirectUrl: *mut cef_string_t,
        ),
    >,
    #[doc = "\n Skip response data when requested by a Range header. Skip over and discard\n |bytes_to_skip| bytes of response data. If data is available immediately\n set |bytes_skipped| to the number of bytes skipped and return true (1). To\n read the data at a later time set |bytes_skipped| to 0, return true (1)\n and execute |callback| when the data is available. To indicate failure set\n |bytes_skipped| to < 0 (e.g. -2 for ERR_FAILED) and return false (0). This\n function will be called in sequence but not from a dedicated thread.\n"]
    pub skip: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_handler_t,
            bytes_to_skip: i64,
            bytes_skipped: *mut i64,
            callback: *mut _cef_resource_skip_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Read response data. If data is available immediately copy up to\n |bytes_to_read| bytes into |data_out|, set |bytes_read| to the number of\n bytes copied, and return true (1). To read the data at a later time keep a\n pointer to |data_out|, set |bytes_read| to 0, return true (1) and execute\n |callback| when the data is available (|data_out| will remain valid until\n the callback is executed). To indicate response completion set\n |bytes_read| to 0 and return false (0). To indicate failure set\n |bytes_read| to < 0 (e.g. -2 for ERR_FAILED) and return false (0). This\n function will be called in sequence but not from a dedicated thread. For\n backwards compatibility set |bytes_read| to -1 and return false (0) and\n the ReadResponse function will be called.\n"]
    pub read: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_handler_t,
            data_out: *mut ::std::os::raw::c_void,
            bytes_to_read: ::std::os::raw::c_int,
            bytes_read: *mut ::std::os::raw::c_int,
            callback: *mut _cef_resource_read_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Read response data. If data is available immediately copy up to\n |bytes_to_read| bytes into |data_out|, set |bytes_read| to the number of\n bytes copied, and return true (1). To read the data at a later time set\n |bytes_read| to 0, return true (1) and call cef_callback_t::cont() when\n the data is available. To indicate response completion return false (0).\n\n WARNING: This function is deprecated. Use Skip and Read instead.\n"]
    pub read_response: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_handler_t,
            data_out: *mut ::std::os::raw::c_void,
            bytes_to_read: ::std::os::raw::c_int,
            bytes_read: *mut ::std::os::raw::c_int,
            callback: *mut _cef_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Request processing has been canceled.\n"]
    pub cancel: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_resource_handler_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_resource_handler_t"][::std::mem::size_of::<_cef_resource_handler_t>() - 96usize];
    ["Alignment of _cef_resource_handler_t"]
        [::std::mem::align_of::<_cef_resource_handler_t>() - 8usize];
    ["Offset of field: _cef_resource_handler_t::base"]
        [::std::mem::offset_of!(_cef_resource_handler_t, base) - 0usize];
    ["Offset of field: _cef_resource_handler_t::open"]
        [::std::mem::offset_of!(_cef_resource_handler_t, open) - 40usize];
    ["Offset of field: _cef_resource_handler_t::process_request"]
        [::std::mem::offset_of!(_cef_resource_handler_t, process_request) - 48usize];
    ["Offset of field: _cef_resource_handler_t::get_response_headers"]
        [::std::mem::offset_of!(_cef_resource_handler_t, get_response_headers) - 56usize];
    ["Offset of field: _cef_resource_handler_t::skip"]
        [::std::mem::offset_of!(_cef_resource_handler_t, skip) - 64usize];
    ["Offset of field: _cef_resource_handler_t::read"]
        [::std::mem::offset_of!(_cef_resource_handler_t, read) - 72usize];
    ["Offset of field: _cef_resource_handler_t::read_response"]
        [::std::mem::offset_of!(_cef_resource_handler_t, read_response) - 80usize];
    ["Offset of field: _cef_resource_handler_t::cancel"]
        [::std::mem::offset_of!(_cef_resource_handler_t, cancel) - 88usize];
};
#[doc = "\n Structure used to implement a custom request handler structure. The\n functions of this structure will be called on the IO thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_resource_handler_t = _cef_resource_handler_t;
#[doc = "\n Implement this structure to filter resource response content. The functions\n of this structure will be called on the browser process IO thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_response_filter_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Initialize the response filter. Will only be called a single time. The\n filter will not be installed if this function returns false (0).\n"]
    pub init_filter: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_response_filter_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to filter a chunk of data. Expected usage is as follows:\n\n  1. Read input data from |data_in| and set |data_in_read| to the number of\n     bytes that were read up to a maximum of |data_in_size|. |data_in| will\n     be NULL if |data_in_size| is zero.\n  2. Write filtered output data to |data_out| and set |data_out_written| to\n     the number of bytes that were written up to a maximum of\n     |data_out_size|. If no output data was written then all data must be\n     read from |data_in| (user must set |data_in_read| = |data_in_size|).\n  3. Return RESPONSE_FILTER_DONE if all output data was written or\n     RESPONSE_FILTER_NEED_MORE_DATA if output data is still pending.\n\n This function will be called repeatedly until the input buffer has been\n fully read (user sets |data_in_read| = |data_in_size|) and there is no\n more input data to filter (the resource response is complete). This\n function may then be called an additional time with an NULL input buffer\n if the user filled the output buffer (set |data_out_written| =\n |data_out_size|) and returned RESPONSE_FILTER_NEED_MORE_DATA to indicate\n that output data is still pending.\n\n Calls to this function will stop when one of the following conditions is\n met:\n\n  1. There is no more input data to filter (the resource response is\n     complete) and the user sets |data_out_written| = 0 or returns\n     RESPONSE_FILTER_DONE to indicate that all data has been written, or;\n  2. The user returns RESPONSE_FILTER_ERROR to indicate an error.\n\n Do not keep a reference to the buffers passed to this function.\n"]
    pub filter: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_response_filter_t,
            data_in: *mut ::std::os::raw::c_void,
            data_in_size: usize,
            data_in_read: *mut usize,
            data_out: *mut ::std::os::raw::c_void,
            data_out_size: usize,
            data_out_written: *mut usize,
        ) -> cef_response_filter_status_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_response_filter_t"][::std::mem::size_of::<_cef_response_filter_t>() - 56usize];
    ["Alignment of _cef_response_filter_t"]
        [::std::mem::align_of::<_cef_response_filter_t>() - 8usize];
    ["Offset of field: _cef_response_filter_t::base"]
        [::std::mem::offset_of!(_cef_response_filter_t, base) - 0usize];
    ["Offset of field: _cef_response_filter_t::init_filter"]
        [::std::mem::offset_of!(_cef_response_filter_t, init_filter) - 40usize];
    ["Offset of field: _cef_response_filter_t::filter"]
        [::std::mem::offset_of!(_cef_response_filter_t, filter) - 48usize];
};
#[doc = "\n Implement this structure to filter resource response content. The functions\n of this structure will be called on the browser process IO thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_response_filter_t = _cef_response_filter_t;
#[doc = "\n Implement this structure to handle events related to browser requests. The\n functions of this structure will be called on the IO thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_resource_request_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called on the IO thread before a resource request is loaded. The |browser|\n and |frame| values represent the source of the request, and may be NULL\n for requests originating from service workers or cef_urlrequest_t. To\n optionally filter cookies for the request return a\n cef_cookie_access_filter_t object. The |request| object cannot not be\n modified in this callback.\n"]
    pub get_cookie_access_filter: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
        ) -> *mut _cef_cookie_access_filter_t,
    >,
    #[doc = "\n Called on the IO thread before a resource request is loaded. The |browser|\n and |frame| values represent the source of the request, and may be NULL\n for requests originating from service workers or cef_urlrequest_t. To\n redirect or change the resource load optionally modify |request|.\n Modification of the request URL will be treated as a redirect. Return\n RV_CONTINUE to continue the request immediately. Return RV_CONTINUE_ASYNC\n and call cef_callback_t functions at a later time to continue or cancel\n the request asynchronously. Return RV_CANCEL to cancel the request\n immediately.\n"]
    pub on_before_resource_load: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            callback: *mut _cef_callback_t,
        ) -> cef_return_value_t,
    >,
    #[doc = "\n Called on the IO thread before a resource is loaded. The |browser| and\n |frame| values represent the source of the request, and may be NULL for\n requests originating from service workers or cef_urlrequest_t. To allow\n the resource to load using the default network loader return NULL. To\n specify a handler for the resource return a cef_resource_handler_t object.\n The |request| object cannot not be modified in this callback.\n"]
    pub get_resource_handler: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
        ) -> *mut _cef_resource_handler_t,
    >,
    #[doc = "\n Called on the IO thread when a resource load is redirected. The |browser|\n and |frame| values represent the source of the request, and may be NULL\n for requests originating from service workers or cef_urlrequest_t. The\n |request| parameter will contain the old URL and other request-related\n information. The |response| parameter will contain the response that\n resulted in the redirect. The |new_url| parameter will contain the new URL\n and can be changed if desired. The |request| and |response| objects cannot\n be modified in this callback.\n"]
    pub on_resource_redirect: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            response: *mut _cef_response_t,
            new_url: *mut cef_string_t,
        ),
    >,
    #[doc = "\n Called on the IO thread when a resource response is received. The\n |browser| and |frame| values represent the source of the request, and may\n be NULL for requests originating from service workers or cef_urlrequest_t.\n To allow the resource load to proceed without modification return false\n (0). To redirect or retry the resource load optionally modify |request|\n and return true (1). Modification of the request URL will be treated as a\n redirect. Requests handled using the default network loader cannot be\n redirected in this callback. The |response| object cannot be modified in\n this callback.\n\n WARNING: Redirecting using this function is deprecated. Use\n OnBeforeResourceLoad or GetResourceHandler to perform redirects.\n"]
    pub on_resource_response: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            response: *mut _cef_response_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the IO thread to optionally filter resource response content.\n The |browser| and |frame| values represent the source of the request, and\n may be NULL for requests originating from service workers or\n cef_urlrequest_t. |request| and |response| represent the request and\n response respectively and cannot be modified in this callback.\n"]
    pub get_resource_response_filter: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            response: *mut _cef_response_t,
        ) -> *mut _cef_response_filter_t,
    >,
    #[doc = "\n Called on the IO thread when a resource load has completed. The |browser|\n and |frame| values represent the source of the request, and may be NULL\n for requests originating from service workers or cef_urlrequest_t.\n |request| and |response| represent the request and response respectively\n and cannot be modified in this callback. |status| indicates the load\n completion status. |received_content_length| is the number of response\n bytes actually read. This function will be called for all requests,\n including requests that are aborted due to CEF shutdown or destruction of\n the associated browser. In cases where the associated browser is destroyed\n this callback may arrive after the cef_life_span_handler_t::OnBeforeClose\n callback for that browser. The cef_frame_t::IsValid function can be used\n to test for this situation, and care should be taken not to call |browser|\n or |frame| functions that modify state (like LoadURL, SendProcessMessage,\n etc.) if the frame is invalid.\n"]
    pub on_resource_load_complete: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            response: *mut _cef_response_t,
            status: cef_urlrequest_status_t,
            received_content_length: i64,
        ),
    >,
    #[doc = "\n Called on the IO thread to handle requests for URLs with an unknown\n protocol component. The |browser| and |frame| values represent the source\n of the request, and may be NULL for requests originating from service\n workers or cef_urlrequest_t. |request| cannot be modified in this\n callback. Set |allow_os_execution| to true (1) to attempt execution via\n the registered OS protocol handler, if any. SECURITY WARNING: YOU SHOULD\n USE THIS METHOD TO ENFORCE RESTRICTIONS BASED ON SCHEME, HOST OR OTHER URL\n ANALYSIS BEFORE ALLOWING OS EXECUTION.\n"]
    pub on_protocol_execution: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            allow_os_execution: *mut ::std::os::raw::c_int,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_resource_request_handler_t"]
        [::std::mem::size_of::<_cef_resource_request_handler_t>() - 104usize];
    ["Alignment of _cef_resource_request_handler_t"]
        [::std::mem::align_of::<_cef_resource_request_handler_t>() - 8usize];
    ["Offset of field: _cef_resource_request_handler_t::base"]
        [::std::mem::offset_of!(_cef_resource_request_handler_t, base) - 0usize];
    ["Offset of field: _cef_resource_request_handler_t::get_cookie_access_filter"][::std::mem::offset_of!(
        _cef_resource_request_handler_t,
        get_cookie_access_filter
    ) - 40usize];
    ["Offset of field: _cef_resource_request_handler_t::on_before_resource_load"][::std::mem::offset_of!(
        _cef_resource_request_handler_t,
        on_before_resource_load
    ) - 48usize];
    ["Offset of field: _cef_resource_request_handler_t::get_resource_handler"]
        [::std::mem::offset_of!(_cef_resource_request_handler_t, get_resource_handler) - 56usize];
    ["Offset of field: _cef_resource_request_handler_t::on_resource_redirect"]
        [::std::mem::offset_of!(_cef_resource_request_handler_t, on_resource_redirect) - 64usize];
    ["Offset of field: _cef_resource_request_handler_t::on_resource_response"]
        [::std::mem::offset_of!(_cef_resource_request_handler_t, on_resource_response) - 72usize];
    ["Offset of field: _cef_resource_request_handler_t::get_resource_response_filter"][::std::mem::offset_of!(
        _cef_resource_request_handler_t,
        get_resource_response_filter
    ) - 80usize];
    ["Offset of field: _cef_resource_request_handler_t::on_resource_load_complete"][::std::mem::offset_of!(
        _cef_resource_request_handler_t,
        on_resource_load_complete
    ) - 88usize];
    ["Offset of field: _cef_resource_request_handler_t::on_protocol_execution"]
        [::std::mem::offset_of!(_cef_resource_request_handler_t, on_protocol_execution) - 96usize];
};
#[doc = "\n Implement this structure to handle events related to browser requests. The\n functions of this structure will be called on the IO thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_resource_request_handler_t = _cef_resource_request_handler_t;
#[doc = "\n Implement this structure to filter cookies that may be sent or received from\n resource requests. The functions of this structure will be called on the IO\n thread unless otherwise indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_cookie_access_filter_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called on the IO thread before a resource request is sent. The |browser|\n and |frame| values represent the source of the request, and may be NULL\n for requests originating from service workers or cef_urlrequest_t.\n |request| cannot be modified in this callback. Return true (1) if the\n specified cookie can be sent with the request or false (0) otherwise.\n"]
    pub can_send_cookie: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_cookie_access_filter_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            cookie: *const _cef_cookie_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the IO thread after a resource response is received. The\n |browser| and |frame| values represent the source of the request, and may\n be NULL for requests originating from service workers or cef_urlrequest_t.\n |request| cannot be modified in this callback. Return true (1) if the\n specified cookie returned with the response can be saved or false (0)\n otherwise.\n"]
    pub can_save_cookie: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_cookie_access_filter_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            response: *mut _cef_response_t,
            cookie: *const _cef_cookie_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_cookie_access_filter_t"]
        [::std::mem::size_of::<_cef_cookie_access_filter_t>() - 56usize];
    ["Alignment of _cef_cookie_access_filter_t"]
        [::std::mem::align_of::<_cef_cookie_access_filter_t>() - 8usize];
    ["Offset of field: _cef_cookie_access_filter_t::base"]
        [::std::mem::offset_of!(_cef_cookie_access_filter_t, base) - 0usize];
    ["Offset of field: _cef_cookie_access_filter_t::can_send_cookie"]
        [::std::mem::offset_of!(_cef_cookie_access_filter_t, can_send_cookie) - 40usize];
    ["Offset of field: _cef_cookie_access_filter_t::can_save_cookie"]
        [::std::mem::offset_of!(_cef_cookie_access_filter_t, can_save_cookie) - 48usize];
};
#[doc = "\n Implement this structure to filter cookies that may be sent or received from\n resource requests. The functions of this structure will be called on the IO\n thread unless otherwise indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_cookie_access_filter_t = _cef_cookie_access_filter_t;
#[doc = "\n Structure representing SSL information.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_sslinfo_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns a bitmask containing any and all problems verifying the server\n certificate.\n"]
    pub get_cert_status: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_sslinfo_t) -> cef_cert_status_t,
    >,
    #[doc = "\n Returns the X.509 certificate.\n"]
    pub get_x509_certificate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_sslinfo_t) -> *mut _cef_x509_certificate_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_sslinfo_t"][::std::mem::size_of::<_cef_sslinfo_t>() - 56usize];
    ["Alignment of _cef_sslinfo_t"][::std::mem::align_of::<_cef_sslinfo_t>() - 8usize];
    ["Offset of field: _cef_sslinfo_t::base"]
        [::std::mem::offset_of!(_cef_sslinfo_t, base) - 0usize];
    ["Offset of field: _cef_sslinfo_t::get_cert_status"]
        [::std::mem::offset_of!(_cef_sslinfo_t, get_cert_status) - 40usize];
    ["Offset of field: _cef_sslinfo_t::get_x509_certificate"]
        [::std::mem::offset_of!(_cef_sslinfo_t, get_x509_certificate) - 48usize];
};
#[doc = "\n Structure representing SSL information.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_sslinfo_t = _cef_sslinfo_t;
unsafe extern "C" {
    #[doc = "\n Returns true (1) if the certificate status represents an error.\n"]
    pub fn cef_is_cert_status_error(status: cef_cert_status_t) -> ::std::os::raw::c_int;
}
#[doc = "\n Callback structure for asynchronous handling of an unresponsive process.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_unresponsive_process_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Reset the timeout for the unresponsive process.\n"]
    pub wait: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_unresponsive_process_callback_t),
    >,
    #[doc = "\n Terminate the unresponsive process.\n"]
    pub terminate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_unresponsive_process_callback_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_unresponsive_process_callback_t"]
        [::std::mem::size_of::<_cef_unresponsive_process_callback_t>() - 56usize];
    ["Alignment of _cef_unresponsive_process_callback_t"]
        [::std::mem::align_of::<_cef_unresponsive_process_callback_t>() - 8usize];
    ["Offset of field: _cef_unresponsive_process_callback_t::base"]
        [::std::mem::offset_of!(_cef_unresponsive_process_callback_t, base) - 0usize];
    ["Offset of field: _cef_unresponsive_process_callback_t::wait"]
        [::std::mem::offset_of!(_cef_unresponsive_process_callback_t, wait) - 40usize];
    ["Offset of field: _cef_unresponsive_process_callback_t::terminate"]
        [::std::mem::offset_of!(_cef_unresponsive_process_callback_t, terminate) - 48usize];
};
#[doc = "\n Callback structure for asynchronous handling of an unresponsive process.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_unresponsive_process_callback_t = _cef_unresponsive_process_callback_t;
#[doc = "\n Callback structure used to select a client certificate for authentication.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_select_client_certificate_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Chooses the specified certificate for client certificate authentication.\n NULL value means that no client certificate should be used.\n"]
    pub select: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_select_client_certificate_callback_t,
            cert: *mut _cef_x509_certificate_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_select_client_certificate_callback_t"]
        [::std::mem::size_of::<_cef_select_client_certificate_callback_t>() - 48usize];
    ["Alignment of _cef_select_client_certificate_callback_t"]
        [::std::mem::align_of::<_cef_select_client_certificate_callback_t>() - 8usize];
    ["Offset of field: _cef_select_client_certificate_callback_t::base"]
        [::std::mem::offset_of!(_cef_select_client_certificate_callback_t, base) - 0usize];
    ["Offset of field: _cef_select_client_certificate_callback_t::select"]
        [::std::mem::offset_of!(_cef_select_client_certificate_callback_t, select) - 40usize];
};
#[doc = "\n Callback structure used to select a client certificate for authentication.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_select_client_certificate_callback_t = _cef_select_client_certificate_callback_t;
#[doc = "\n Implement this structure to handle events related to browser requests. The\n functions of this structure will be called on the thread indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_request_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called on the UI thread before browser navigation. Return true (1) to\n cancel the navigation or false (0) to allow the navigation to proceed. The\n |request| object cannot be modified in this callback.\n cef_load_handler_t::OnLoadingStateChange will be called twice in all\n cases. If the navigation is allowed cef_load_handler_t::OnLoadStart and\n cef_load_handler_t::OnLoadEnd will be called. If the navigation is\n canceled cef_load_handler_t::OnLoadError will be called with an\n |errorCode| value of ERR_ABORTED. The |user_gesture| value will be true\n (1) if the browser navigated via explicit user gesture (e.g. clicking a\n link) or false (0) if it navigated automatically (e.g. via the\n DomContentLoaded event).\n"]
    pub on_before_browse: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            user_gesture: ::std::os::raw::c_int,
            is_redirect: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the UI thread before OnBeforeBrowse in certain limited cases\n where navigating a new or different browser might be desirable. This\n includes user-initiated navigation that might open in a special way (e.g.\n links clicked via middle-click or ctrl + left-click) and certain types of\n cross-origin navigation initiated from the renderer process (e.g.\n navigating the top-level frame to/from a file URL). The |browser| and\n |frame| values represent the source of the navigation. The\n |target_disposition| value indicates where the user intended to navigate\n the browser based on standard Chromium behaviors (e.g. current tab, new\n tab, etc). The |user_gesture| value will be true (1) if the browser\n navigated via explicit user gesture (e.g. clicking a link) or false (0) if\n it navigated automatically (e.g. via the DomContentLoaded event). Return\n true (1) to cancel the navigation or false (0) to allow the navigation to\n proceed in the source browser's top-level frame.\n"]
    pub on_open_urlfrom_tab: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            target_url: *const cef_string_t,
            target_disposition: cef_window_open_disposition_t,
            user_gesture: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the browser process IO thread before a resource request is\n initiated. The |browser| and |frame| values represent the source of the\n request. |request| represents the request contents and cannot be modified\n in this callback. |is_navigation| will be true (1) if the resource request\n is a navigation. |is_download| will be true (1) if the resource request is\n a download. |request_initiator| is the origin (scheme + domain) of the\n page that initiated the request. Set |disable_default_handling| to true\n (1) to disable default handling of the request, in which case it will need\n to be handled via cef_resource_request_handler_t::GetResourceHandler or it\n will be canceled. To allow the resource load to proceed with default\n handling return NULL. To specify a handler for the resource return a\n cef_resource_request_handler_t object. If this callback returns NULL the\n same function will be called on the associated\n cef_request_context_handler_t, if any.\n"]
    pub get_resource_request_handler: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            is_navigation: ::std::os::raw::c_int,
            is_download: ::std::os::raw::c_int,
            request_initiator: *const cef_string_t,
            disable_default_handling: *mut ::std::os::raw::c_int,
        ) -> *mut _cef_resource_request_handler_t,
    >,
    #[doc = "\n Called on the IO thread when the browser needs credentials from the user.\n |origin_url| is the origin making this authentication request. |isProxy|\n indicates whether the host is a proxy server. |host| contains the hostname\n and |port| contains the port number. |realm| is the realm of the challenge\n and may be NULL. |scheme| is the authentication scheme used, such as\n \"basic\" or \"digest\", and will be NULL if the source of the request is an\n FTP server. Return true (1) to continue the request and call\n cef_auth_callback_t::cont() either in this function or at a later time\n when the authentication information is available. Return false (0) to\n cancel the request immediately.\n"]
    pub get_auth_credentials: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_handler_t,
            browser: *mut _cef_browser_t,
            origin_url: *const cef_string_t,
            isProxy: ::std::os::raw::c_int,
            host: *const cef_string_t,
            port: ::std::os::raw::c_int,
            realm: *const cef_string_t,
            scheme: *const cef_string_t,
            callback: *mut _cef_auth_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the UI thread to handle requests for URLs with an invalid SSL\n certificate. Return true (1) and call cef_callback_t functions either in\n this function or at a later time to continue or cancel the request. Return\n false (0) to cancel the request immediately. If\n cef_settings_t.ignore_certificate_errors is set all invalid certificates\n will be accepted without calling this function.\n"]
    pub on_certificate_error: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_handler_t,
            browser: *mut _cef_browser_t,
            cert_error: cef_errorcode_t,
            request_url: *const cef_string_t,
            ssl_info: *mut _cef_sslinfo_t,
            callback: *mut _cef_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the UI thread when a client certificate is being requested for\n authentication. Return false (0) to use the default behavior.  If the\n |certificates| list is not NULL the default behavior will be to display a\n dialog for certificate selection. If the |certificates| list is NULL then\n the default behavior will be not to show a dialog and it will continue\n without using any certificate. Return true (1) and call\n cef_select_client_certificate_callback_t::Select either in this function\n or at a later time to select a certificate. Do not call Select or call it\n with NULL to continue without using any certificate. |isProxy| indicates\n whether the host is an HTTPS proxy or the origin server. |host| and |port|\n contains the hostname and port of the SSL server. |certificates| is the\n list of certificates to choose from; this list has already been pruned by\n Chromium so that it only contains certificates from issuers that the\n server trusts.\n"]
    pub on_select_client_certificate: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_handler_t,
            browser: *mut _cef_browser_t,
            isProxy: ::std::os::raw::c_int,
            host: *const cef_string_t,
            port: ::std::os::raw::c_int,
            certificatesCount: usize,
            certificates: *const *mut _cef_x509_certificate_t,
            callback: *mut _cef_select_client_certificate_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the browser process UI thread when the render view associated\n with |browser| is ready to receive/handle IPC messages in the render\n process.\n"]
    pub on_render_view_ready: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_handler_t, browser: *mut _cef_browser_t),
    >,
    #[doc = "\n Called on the browser process UI thread when the render process is\n unresponsive as indicated by a lack of input event processing for at least\n 15 seconds. Return false (0) for the default behavior which is an\n indefinite wait with Alloy style or display of the \"Page unresponsive\"\n dialog with Chrome style. Return true (1) and don't execute the callback\n for an indefinite wait without display of the Chrome style dialog. Return\n true (1) and call cef_unresponsive_process_callback_t::Wait either in this\n function or at a later time to reset the wait timer, potentially\n triggering another call to this function if the process remains\n unresponsive. Return true (1) and call\n cef_unresponsive_process_callback_t:: Terminate either in this function or\n at a later time to terminate the unresponsive process, resulting in a call\n to OnRenderProcessTerminated. OnRenderProcessResponsive will be called if\n the process becomes responsive after this function is called. This\n functionality depends on the hang monitor which can be disabled by passing\n the `--disable-hang-monitor` command-line flag.\n"]
    pub on_render_process_unresponsive: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_handler_t,
            browser: *mut _cef_browser_t,
            callback: *mut _cef_unresponsive_process_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called on the browser process UI thread when the render process becomes\n responsive after previously being unresponsive. See documentation on\n OnRenderProcessUnresponsive.\n"]
    pub on_render_process_responsive: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_handler_t, browser: *mut _cef_browser_t),
    >,
    #[doc = "\n Called on the browser process UI thread when the render process terminates\n unexpectedly. |status| indicates how the process terminated. |error_code|\n and |error_string| represent the error that would be displayed in Chrome's\n \"Aw, Snap!\" view. Possible |error_code| values include cef_resultcode_t\n non-normal exit values and platform-specific crash values (for example, a\n Posix signal or Windows hardware exception).\n"]
    pub on_render_process_terminated: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_handler_t,
            browser: *mut _cef_browser_t,
            status: cef_termination_status_t,
            error_code: ::std::os::raw::c_int,
            error_string: *const cef_string_t,
        ),
    >,
    #[doc = "\n Called on the browser process UI thread when the window.document object of\n the main frame has been created.\n"]
    pub on_document_available_in_main_frame: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_request_handler_t, browser: *mut _cef_browser_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_request_handler_t"][::std::mem::size_of::<_cef_request_handler_t>() - 128usize];
    ["Alignment of _cef_request_handler_t"]
        [::std::mem::align_of::<_cef_request_handler_t>() - 8usize];
    ["Offset of field: _cef_request_handler_t::base"]
        [::std::mem::offset_of!(_cef_request_handler_t, base) - 0usize];
    ["Offset of field: _cef_request_handler_t::on_before_browse"]
        [::std::mem::offset_of!(_cef_request_handler_t, on_before_browse) - 40usize];
    ["Offset of field: _cef_request_handler_t::on_open_urlfrom_tab"]
        [::std::mem::offset_of!(_cef_request_handler_t, on_open_urlfrom_tab) - 48usize];
    ["Offset of field: _cef_request_handler_t::get_resource_request_handler"]
        [::std::mem::offset_of!(_cef_request_handler_t, get_resource_request_handler) - 56usize];
    ["Offset of field: _cef_request_handler_t::get_auth_credentials"]
        [::std::mem::offset_of!(_cef_request_handler_t, get_auth_credentials) - 64usize];
    ["Offset of field: _cef_request_handler_t::on_certificate_error"]
        [::std::mem::offset_of!(_cef_request_handler_t, on_certificate_error) - 72usize];
    ["Offset of field: _cef_request_handler_t::on_select_client_certificate"]
        [::std::mem::offset_of!(_cef_request_handler_t, on_select_client_certificate) - 80usize];
    ["Offset of field: _cef_request_handler_t::on_render_view_ready"]
        [::std::mem::offset_of!(_cef_request_handler_t, on_render_view_ready) - 88usize];
    ["Offset of field: _cef_request_handler_t::on_render_process_unresponsive"]
        [::std::mem::offset_of!(_cef_request_handler_t, on_render_process_unresponsive) - 96usize];
    ["Offset of field: _cef_request_handler_t::on_render_process_responsive"]
        [::std::mem::offset_of!(_cef_request_handler_t, on_render_process_responsive) - 104usize];
    ["Offset of field: _cef_request_handler_t::on_render_process_terminated"]
        [::std::mem::offset_of!(_cef_request_handler_t, on_render_process_terminated) - 112usize];
    ["Offset of field: _cef_request_handler_t::on_document_available_in_main_frame"][::std::mem::offset_of!(
        _cef_request_handler_t,
        on_document_available_in_main_frame
    ) - 120usize];
};
#[doc = "\n Implement this structure to handle events related to browser requests. The\n functions of this structure will be called on the thread indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_request_handler_t = _cef_request_handler_t;
#[doc = "\n Implement this structure to provide handler implementations.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_client_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Return the handler for audio rendering events.\n"]
    pub get_audio_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_audio_handler_t,
    >,
    #[doc = "\n Return the handler for commands. If no handler is provided the default\n implementation will be used.\n"]
    pub get_command_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_command_handler_t,
    >,
    #[doc = "\n Return the handler for context menus. If no handler is provided the\n default implementation will be used.\n"]
    pub get_context_menu_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_context_menu_handler_t,
    >,
    #[doc = "\n Return the handler for dialogs. If no handler is provided the default\n implementation will be used.\n"]
    pub get_dialog_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_dialog_handler_t,
    >,
    #[doc = "\n Return the handler for browser display state events.\n"]
    pub get_display_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_display_handler_t,
    >,
    #[doc = "\n Return the handler for download events. If no handler is returned\n downloads will not be allowed.\n"]
    pub get_download_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_download_handler_t,
    >,
    #[doc = "\n Return the handler for drag events.\n"]
    pub get_drag_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_drag_handler_t,
    >,
    #[doc = "\n Return the handler for find result events.\n"]
    pub get_find_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_find_handler_t,
    >,
    #[doc = "\n Return the handler for focus events.\n"]
    pub get_focus_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_focus_handler_t,
    >,
    #[doc = "\n Return the handler for events related to cef_frame_t lifespan. This\n function will be called once during cef_browser_t creation and the result\n will be cached for performance reasons.\n"]
    pub get_frame_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_frame_handler_t,
    >,
    #[doc = "\n Return the handler for permission requests.\n"]
    pub get_permission_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_permission_handler_t,
    >,
    #[doc = "\n Return the handler for JavaScript dialogs. If no handler is provided the\n default implementation will be used.\n"]
    pub get_jsdialog_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_jsdialog_handler_t,
    >,
    #[doc = "\n Return the handler for keyboard events.\n"]
    pub get_keyboard_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_keyboard_handler_t,
    >,
    #[doc = "\n Return the handler for browser life span events.\n"]
    pub get_life_span_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_life_span_handler_t,
    >,
    #[doc = "\n Return the handler for browser load status events.\n"]
    pub get_load_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_load_handler_t,
    >,
    #[doc = "\n Return the handler for printing on Linux. If a print handler is not\n provided then printing will not be supported on the Linux platform.\n"]
    pub get_print_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_print_handler_t,
    >,
    #[doc = "\n Return the handler for off-screen rendering events.\n"]
    pub get_render_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_render_handler_t,
    >,
    #[doc = "\n Return the handler for browser request events.\n"]
    pub get_request_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_client_t) -> *mut _cef_request_handler_t,
    >,
    #[doc = "\n Called when a new message is received from a different process. Return\n true (1) if the message was handled or false (0) otherwise.  It is safe to\n keep a reference to |message| outside of this callback.\n"]
    pub on_process_message_received: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_client_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            source_process: cef_process_id_t,
            message: *mut _cef_process_message_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_client_t"][::std::mem::size_of::<_cef_client_t>() - 192usize];
    ["Alignment of _cef_client_t"][::std::mem::align_of::<_cef_client_t>() - 8usize];
    ["Offset of field: _cef_client_t::base"][::std::mem::offset_of!(_cef_client_t, base) - 0usize];
    ["Offset of field: _cef_client_t::get_audio_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_audio_handler) - 40usize];
    ["Offset of field: _cef_client_t::get_command_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_command_handler) - 48usize];
    ["Offset of field: _cef_client_t::get_context_menu_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_context_menu_handler) - 56usize];
    ["Offset of field: _cef_client_t::get_dialog_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_dialog_handler) - 64usize];
    ["Offset of field: _cef_client_t::get_display_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_display_handler) - 72usize];
    ["Offset of field: _cef_client_t::get_download_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_download_handler) - 80usize];
    ["Offset of field: _cef_client_t::get_drag_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_drag_handler) - 88usize];
    ["Offset of field: _cef_client_t::get_find_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_find_handler) - 96usize];
    ["Offset of field: _cef_client_t::get_focus_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_focus_handler) - 104usize];
    ["Offset of field: _cef_client_t::get_frame_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_frame_handler) - 112usize];
    ["Offset of field: _cef_client_t::get_permission_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_permission_handler) - 120usize];
    ["Offset of field: _cef_client_t::get_jsdialog_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_jsdialog_handler) - 128usize];
    ["Offset of field: _cef_client_t::get_keyboard_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_keyboard_handler) - 136usize];
    ["Offset of field: _cef_client_t::get_life_span_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_life_span_handler) - 144usize];
    ["Offset of field: _cef_client_t::get_load_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_load_handler) - 152usize];
    ["Offset of field: _cef_client_t::get_print_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_print_handler) - 160usize];
    ["Offset of field: _cef_client_t::get_render_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_render_handler) - 168usize];
    ["Offset of field: _cef_client_t::get_request_handler"]
        [::std::mem::offset_of!(_cef_client_t, get_request_handler) - 176usize];
    ["Offset of field: _cef_client_t::on_process_message_received"]
        [::std::mem::offset_of!(_cef_client_t, on_process_message_received) - 184usize];
};
#[doc = "\n Implement this structure to provide handler implementations.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_client_t = _cef_client_t;
#[doc = "\n Structure used to create and/or parse command line arguments. Arguments with\n \"--\", \"-\" and, on Windows, \"/\" prefixes are considered switches. Switches\n will always precede any arguments without switch prefixes. Switches can\n optionally have a value specified using the \"=\" delimiter (e.g.\n \"-switch=value\"). An argument of \"--\" will terminate switch parsing with all\n subsequent tokens, regardless of prefix, being interpreted as non-switch\n arguments. Switch names should be lowercase ASCII and will be converted to\n such if necessary. Switch values will retain the original case and UTF8\n encoding. This structure can be used before cef_initialize() is called.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_command_line_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is valid. Do not call any other functions\n if this function returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the values of this object are read-only. Some APIs may\n expose read-only objects.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns a writable copy of this object.\n"]
    pub copy: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t) -> *mut _cef_command_line_t,
    >,
    #[doc = "\n Initialize the command line with the specified |argc| and |argv| values.\n The first argument must be the name of the program. This function is only\n supported on non-Windows platforms.\n"]
    pub init_from_argv: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_line_t,
            argc: ::std::os::raw::c_int,
            argv: *const *const ::std::os::raw::c_char,
        ),
    >,
    #[doc = "\n Initialize the command line with the string returned by calling\n GetCommandLineW(). This function is only supported on Windows.\n"]
    pub init_from_string: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t, command_line: *const cef_string_t),
    >,
    #[doc = "\n Reset the command-line switches and arguments but leave the program\n component unchanged.\n"]
    pub reset: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_command_line_t)>,
    #[doc = "\n Retrieve the original command line string as a vector of strings. The argv\n array: `{ program, [(--|-|/)switch[=value]]*, [--], [argument]* }`\n"]
    pub get_argv: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t, argv: cef_string_list_t),
    >,
    #[doc = "\n Constructs and returns the represented command line string. Use this\n function cautiously because quoting behavior is unclear.\n"]
    pub get_command_line_string: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Get the program part of the command line string (the first item).\n"]
    pub get_program: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Set the program part of the command line string (the first item).\n"]
    pub set_program: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t, program: *const cef_string_t),
    >,
    #[doc = "\n Returns true (1) if the command line has switches.\n"]
    pub has_switches: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the command line contains the given switch.\n"]
    pub has_switch: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_line_t,
            name: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value associated with the given switch. If the switch has no\n value or isn't present this function returns the NULL string.\n"]
    pub get_switch_value: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_line_t,
            name: *const cef_string_t,
        ) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the map of switch names and values. If a switch has no value an\n NULL string is returned.\n"]
    pub get_switches: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t, switches: cef_string_map_t),
    >,
    #[doc = "\n Add a switch to the end of the command line.\n"]
    pub append_switch: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t, name: *const cef_string_t),
    >,
    #[doc = "\n Add a switch with the specified value to the end of the command line. If\n the switch has no value pass an NULL value string.\n"]
    pub append_switch_with_value: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_command_line_t,
            name: *const cef_string_t,
            value: *const cef_string_t,
        ),
    >,
    #[doc = "\n True if there are remaining command line arguments.\n"]
    pub has_arguments: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Get the remaining command line arguments.\n"]
    pub get_arguments: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t, arguments: cef_string_list_t),
    >,
    #[doc = "\n Add an argument to the end of the command line.\n"]
    pub append_argument: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t, argument: *const cef_string_t),
    >,
    #[doc = "\n Insert a command before the current command. Common for debuggers, like\n \"valgrind\" or \"gdb --args\".\n"]
    pub prepend_wrapper: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_command_line_t, wrapper: *const cef_string_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_command_line_t"][::std::mem::size_of::<_cef_command_line_t>() - 200usize];
    ["Alignment of _cef_command_line_t"][::std::mem::align_of::<_cef_command_line_t>() - 8usize];
    ["Offset of field: _cef_command_line_t::base"]
        [::std::mem::offset_of!(_cef_command_line_t, base) - 0usize];
    ["Offset of field: _cef_command_line_t::is_valid"]
        [::std::mem::offset_of!(_cef_command_line_t, is_valid) - 40usize];
    ["Offset of field: _cef_command_line_t::is_read_only"]
        [::std::mem::offset_of!(_cef_command_line_t, is_read_only) - 48usize];
    ["Offset of field: _cef_command_line_t::copy"]
        [::std::mem::offset_of!(_cef_command_line_t, copy) - 56usize];
    ["Offset of field: _cef_command_line_t::init_from_argv"]
        [::std::mem::offset_of!(_cef_command_line_t, init_from_argv) - 64usize];
    ["Offset of field: _cef_command_line_t::init_from_string"]
        [::std::mem::offset_of!(_cef_command_line_t, init_from_string) - 72usize];
    ["Offset of field: _cef_command_line_t::reset"]
        [::std::mem::offset_of!(_cef_command_line_t, reset) - 80usize];
    ["Offset of field: _cef_command_line_t::get_argv"]
        [::std::mem::offset_of!(_cef_command_line_t, get_argv) - 88usize];
    ["Offset of field: _cef_command_line_t::get_command_line_string"]
        [::std::mem::offset_of!(_cef_command_line_t, get_command_line_string) - 96usize];
    ["Offset of field: _cef_command_line_t::get_program"]
        [::std::mem::offset_of!(_cef_command_line_t, get_program) - 104usize];
    ["Offset of field: _cef_command_line_t::set_program"]
        [::std::mem::offset_of!(_cef_command_line_t, set_program) - 112usize];
    ["Offset of field: _cef_command_line_t::has_switches"]
        [::std::mem::offset_of!(_cef_command_line_t, has_switches) - 120usize];
    ["Offset of field: _cef_command_line_t::has_switch"]
        [::std::mem::offset_of!(_cef_command_line_t, has_switch) - 128usize];
    ["Offset of field: _cef_command_line_t::get_switch_value"]
        [::std::mem::offset_of!(_cef_command_line_t, get_switch_value) - 136usize];
    ["Offset of field: _cef_command_line_t::get_switches"]
        [::std::mem::offset_of!(_cef_command_line_t, get_switches) - 144usize];
    ["Offset of field: _cef_command_line_t::append_switch"]
        [::std::mem::offset_of!(_cef_command_line_t, append_switch) - 152usize];
    ["Offset of field: _cef_command_line_t::append_switch_with_value"]
        [::std::mem::offset_of!(_cef_command_line_t, append_switch_with_value) - 160usize];
    ["Offset of field: _cef_command_line_t::has_arguments"]
        [::std::mem::offset_of!(_cef_command_line_t, has_arguments) - 168usize];
    ["Offset of field: _cef_command_line_t::get_arguments"]
        [::std::mem::offset_of!(_cef_command_line_t, get_arguments) - 176usize];
    ["Offset of field: _cef_command_line_t::append_argument"]
        [::std::mem::offset_of!(_cef_command_line_t, append_argument) - 184usize];
    ["Offset of field: _cef_command_line_t::prepend_wrapper"]
        [::std::mem::offset_of!(_cef_command_line_t, prepend_wrapper) - 192usize];
};
#[doc = "\n Structure used to create and/or parse command line arguments. Arguments with\n \"--\", \"-\" and, on Windows, \"/\" prefixes are considered switches. Switches\n will always precede any arguments without switch prefixes. Switches can\n optionally have a value specified using the \"=\" delimiter (e.g.\n \"-switch=value\"). An argument of \"--\" will terminate switch parsing with all\n subsequent tokens, regardless of prefix, being interpreted as non-switch\n arguments. Switch names should be lowercase ASCII and will be converted to\n such if necessary. Switch values will retain the original case and UTF8\n encoding. This structure can be used before cef_initialize() is called.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_command_line_t = _cef_command_line_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_command_line_t instance.\n"]
    pub fn cef_command_line_create() -> *mut cef_command_line_t;
}
unsafe extern "C" {
    #[doc = "\n Returns the singleton global cef_command_line_t object. The returned object\n will be read-only.\n"]
    pub fn cef_command_line_get_global() -> *mut cef_command_line_t;
}
#[doc = "\n Implement this structure to provide handler implementations. The handler\n instance will not be released until all objects related to the context have\n been destroyed.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_request_context_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called on the browser process UI thread immediately after the request\n context has been initialized.\n"]
    pub on_request_context_initialized: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_handler_t,
            request_context: *mut _cef_request_context_t,
        ),
    >,
    #[doc = "\n Called on the browser process IO thread before a resource request is\n initiated. The |browser| and |frame| values represent the source of the\n request, and may be NULL for requests originating from service workers or\n cef_urlrequest_t. |request| represents the request contents and cannot be\n modified in this callback. |is_navigation| will be true (1) if the\n resource request is a navigation. |is_download| will be true (1) if the\n resource request is a download. |request_initiator| is the origin (scheme\n + domain) of the page that initiated the request. Set\n |disable_default_handling| to true (1) to disable default handling of the\n request, in which case it will need to be handled via\n cef_resource_request_handler_t::GetResourceHandler or it will be canceled.\n To allow the resource load to proceed with default handling return NULL.\n To specify a handler for the resource return a\n cef_resource_request_handler_t object. This function will not be called if\n the client associated with |browser| returns a non-NULL value from\n cef_request_handler_t::GetResourceRequestHandler for the same request\n (identified by cef_request_t::GetIdentifier).\n"]
    pub get_resource_request_handler: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_request_context_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            request: *mut _cef_request_t,
            is_navigation: ::std::os::raw::c_int,
            is_download: ::std::os::raw::c_int,
            request_initiator: *const cef_string_t,
            disable_default_handling: *mut ::std::os::raw::c_int,
        ) -> *mut _cef_resource_request_handler_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_request_context_handler_t"]
        [::std::mem::size_of::<_cef_request_context_handler_t>() - 56usize];
    ["Alignment of _cef_request_context_handler_t"]
        [::std::mem::align_of::<_cef_request_context_handler_t>() - 8usize];
    ["Offset of field: _cef_request_context_handler_t::base"]
        [::std::mem::offset_of!(_cef_request_context_handler_t, base) - 0usize];
    ["Offset of field: _cef_request_context_handler_t::on_request_context_initialized"][::std::mem::offset_of!(
        _cef_request_context_handler_t,
        on_request_context_initialized
    )
        - 40usize];
    ["Offset of field: _cef_request_context_handler_t::get_resource_request_handler"][::std::mem::offset_of!(
        _cef_request_context_handler_t,
        get_resource_request_handler
    ) - 48usize];
};
#[doc = "\n Implement this structure to provide handler implementations. The handler\n instance will not be released until all objects related to the context have\n been destroyed.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_request_context_handler_t = _cef_request_context_handler_t;
#[doc = "\n Structure used to implement browser process callbacks. The functions of this\n structure will be called on the browser process main thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_browser_process_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Provides an opportunity to register custom preferences prior to global and\n request context initialization.\n\n If |type| is CEF_PREFERENCES_TYPE_GLOBAL the registered preferences can be\n accessed via cef_preference_manager_t::GetGlobalPreferences after\n OnContextInitialized is called. Global preferences are registered a single\n time at application startup. See related cef_settings_t.cache_path\n configuration.\n\n If |type| is CEF_PREFERENCES_TYPE_REQUEST_CONTEXT the preferences can be\n accessed via the cef_request_context_t after\n cef_request_context_handler_t::OnRequestContextInitialized is called.\n Request context preferences are registered each time a new\n cef_request_context_t is created. It is intended but not required that all\n request contexts have the same registered preferences. See related\n cef_request_context_settings_t.cache_path configuration.\n\n Do not keep a reference to the |registrar| object. This function is called\n on the browser process UI thread.\n"]
    pub on_register_custom_preferences: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_process_handler_t,
            type_: cef_preferences_type_t,
            registrar: *mut _cef_preference_registrar_t,
        ),
    >,
    #[doc = "\n Called on the browser process UI thread immediately after the CEF context\n has been initialized.\n"]
    pub on_context_initialized:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_browser_process_handler_t)>,
    #[doc = "\n Called before a child process is launched. Will be called on the browser\n process UI thread when launching a render process and on the browser\n process IO thread when launching a GPU process. Provides an opportunity to\n modify the child process command line. Do not keep a reference to\n |command_line| outside of this function.\n"]
    pub on_before_child_process_launch: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_process_handler_t,
            command_line: *mut _cef_command_line_t,
        ),
    >,
    #[doc = "\n Implement this function to provide app-specific behavior when an already\n running app is relaunched with the same CefSettings.root_cache_path value.\n For example, activate an existing app window or create a new app window.\n |command_line| will be read-only. Do not keep a reference to\n |command_line| outside of this function. Return true (1) if the relaunch\n is handled or false (0) for default relaunch behavior. Default behavior\n will create a new default styled Chrome window.\n\n To avoid cache corruption only a single app instance is allowed to run for\n a given CefSettings.root_cache_path value. On relaunch the app checks a\n process singleton lock and then forwards the new launch arguments to the\n already running app process before exiting early. Client apps should\n therefore check the cef_initialize() return value for early exit before\n proceeding.\n\n This function will be called on the browser process UI thread.\n"]
    pub on_already_running_app_relaunch: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_process_handler_t,
            command_line: *mut _cef_command_line_t,
            current_directory: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called from any thread when work has been scheduled for the browser\n process main (UI) thread. This callback is used in combination with\n cef_settings_t.external_message_pump and cef_do_message_loop_work() in\n cases where the CEF message loop must be integrated into an existing\n application message loop (see additional comments and warnings on\n CefDoMessageLoopWork). This callback should schedule a\n cef_do_message_loop_work() call to happen on the main (UI) thread.\n |delay_ms| is the requested delay in milliseconds. If |delay_ms| is <= 0\n then the call should happen reasonably soon. If |delay_ms| is > 0 then the\n call should be scheduled to happen after the specified delay and any\n currently pending scheduled call should be cancelled.\n"]
    pub on_schedule_message_pump_work: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_process_handler_t, delay_ms: i64),
    >,
    #[doc = "\n Return the default client for use with a newly created browser window\n (cef_browser_t object). If null is returned the cef_browser_t will be\n unmanaged (no callbacks will be executed for that cef_browser_t) and\n application shutdown will be blocked until the browser window is closed\n manually. This function is currently only used with Chrome style when\n creating new browser windows via Chrome UI.\n"]
    pub get_default_client: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_process_handler_t) -> *mut _cef_client_t,
    >,
    #[doc = "\n Return the default handler for use with a new user or incognito profile\n (cef_request_context_t object). If null is returned the\n cef_request_context_t will be unmanaged (no callbacks will be executed for\n that cef_request_context_t). This function is currently only used with\n Chrome style when creating new browser windows via Chrome UI.\n"]
    pub get_default_request_context_handler: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_process_handler_t,
        ) -> *mut _cef_request_context_handler_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_browser_process_handler_t"]
        [::std::mem::size_of::<_cef_browser_process_handler_t>() - 96usize];
    ["Alignment of _cef_browser_process_handler_t"]
        [::std::mem::align_of::<_cef_browser_process_handler_t>() - 8usize];
    ["Offset of field: _cef_browser_process_handler_t::base"]
        [::std::mem::offset_of!(_cef_browser_process_handler_t, base) - 0usize];
    ["Offset of field: _cef_browser_process_handler_t::on_register_custom_preferences"][::std::mem::offset_of!(
        _cef_browser_process_handler_t,
        on_register_custom_preferences
    )
        - 40usize];
    ["Offset of field: _cef_browser_process_handler_t::on_context_initialized"]
        [::std::mem::offset_of!(_cef_browser_process_handler_t, on_context_initialized) - 48usize];
    ["Offset of field: _cef_browser_process_handler_t::on_before_child_process_launch"][::std::mem::offset_of!(
        _cef_browser_process_handler_t,
        on_before_child_process_launch
    )
        - 56usize];
    ["Offset of field: _cef_browser_process_handler_t::on_already_running_app_relaunch"][::std::mem::offset_of!(
        _cef_browser_process_handler_t,
        on_already_running_app_relaunch
    )
        - 64usize];
    ["Offset of field: _cef_browser_process_handler_t::on_schedule_message_pump_work"][::std::mem::offset_of!(
        _cef_browser_process_handler_t,
        on_schedule_message_pump_work
    ) - 72usize];
    ["Offset of field: _cef_browser_process_handler_t::get_default_client"]
        [::std::mem::offset_of!(_cef_browser_process_handler_t, get_default_client) - 80usize];
    ["Offset of field: _cef_browser_process_handler_t::get_default_request_context_handler"][::std::mem::offset_of!(
        _cef_browser_process_handler_t,
        get_default_request_context_handler
    )
        - 88usize];
};
#[doc = "\n Structure used to implement browser process callbacks. The functions of this\n structure will be called on the browser process main thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_browser_process_handler_t = _cef_browser_process_handler_t;
#[doc = "\n Implement this structure for asynchronous task execution. If the task is\n posted successfully and if the associated message loop is still running then\n the execute() function will be called on the target thread. If the task\n fails to post then the task object may be destroyed on the source thread\n instead of the target thread. For this reason be cautious when performing\n work in the task object destructor.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_task_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Method that will be executed on the target thread.\n"]
    pub execute: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_task_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_task_t"][::std::mem::size_of::<_cef_task_t>() - 48usize];
    ["Alignment of _cef_task_t"][::std::mem::align_of::<_cef_task_t>() - 8usize];
    ["Offset of field: _cef_task_t::base"][::std::mem::offset_of!(_cef_task_t, base) - 0usize];
    ["Offset of field: _cef_task_t::execute"]
        [::std::mem::offset_of!(_cef_task_t, execute) - 40usize];
};
#[doc = "\n Implement this structure for asynchronous task execution. If the task is\n posted successfully and if the associated message loop is still running then\n the execute() function will be called on the target thread. If the task\n fails to post then the task object may be destroyed on the source thread\n instead of the target thread. For this reason be cautious when performing\n work in the task object destructor.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_task_t = _cef_task_t;
#[doc = "\n Structure that asynchronously executes tasks on the associated thread. It is\n safe to call the functions of this structure on any thread.\n\n CEF maintains multiple internal threads that are used for handling different\n types of tasks in different processes. The cef_thread_id_t definitions in\n cef_types.h list the common CEF threads. Task runners are also available for\n other CEF threads as appropriate (for example, V8 WebWorker threads).\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_task_runner_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if this object is pointing to the same task runner as\n |that| object.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_task_runner_t,
            that: *mut _cef_task_runner_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this task runner belongs to the current thread.\n"]
    pub belongs_to_current_thread: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_task_runner_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this task runner is for the specified CEF thread.\n"]
    pub belongs_to_thread: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_task_runner_t,
            threadId: cef_thread_id_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Post a task for execution on the thread associated with this task runner.\n Execution will occur asynchronously.\n"]
    pub post_task: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_task_runner_t,
            task: *mut _cef_task_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Post a task for delayed execution on the thread associated with this task\n runner. Execution will occur asynchronously. Delayed tasks are not\n supported on V8 WebWorker threads and will be executed without the\n specified delay.\n"]
    pub post_delayed_task: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_task_runner_t,
            task: *mut _cef_task_t,
            delay_ms: i64,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_task_runner_t"][::std::mem::size_of::<_cef_task_runner_t>() - 80usize];
    ["Alignment of _cef_task_runner_t"][::std::mem::align_of::<_cef_task_runner_t>() - 8usize];
    ["Offset of field: _cef_task_runner_t::base"]
        [::std::mem::offset_of!(_cef_task_runner_t, base) - 0usize];
    ["Offset of field: _cef_task_runner_t::is_same"]
        [::std::mem::offset_of!(_cef_task_runner_t, is_same) - 40usize];
    ["Offset of field: _cef_task_runner_t::belongs_to_current_thread"]
        [::std::mem::offset_of!(_cef_task_runner_t, belongs_to_current_thread) - 48usize];
    ["Offset of field: _cef_task_runner_t::belongs_to_thread"]
        [::std::mem::offset_of!(_cef_task_runner_t, belongs_to_thread) - 56usize];
    ["Offset of field: _cef_task_runner_t::post_task"]
        [::std::mem::offset_of!(_cef_task_runner_t, post_task) - 64usize];
    ["Offset of field: _cef_task_runner_t::post_delayed_task"]
        [::std::mem::offset_of!(_cef_task_runner_t, post_delayed_task) - 72usize];
};
#[doc = "\n Structure that asynchronously executes tasks on the associated thread. It is\n safe to call the functions of this structure on any thread.\n\n CEF maintains multiple internal threads that are used for handling different\n types of tasks in different processes. The cef_thread_id_t definitions in\n cef_types.h list the common CEF threads. Task runners are also available for\n other CEF threads as appropriate (for example, V8 WebWorker threads).\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_task_runner_t = _cef_task_runner_t;
unsafe extern "C" {
    #[doc = "\n Returns the task runner for the current thread. Only CEF threads will have\n task runners. An NULL reference will be returned if this function is called\n on an invalid thread.\n"]
    pub fn cef_task_runner_get_for_current_thread() -> *mut cef_task_runner_t;
}
unsafe extern "C" {
    #[doc = "\n Returns the task runner for the specified CEF thread.\n"]
    pub fn cef_task_runner_get_for_thread(threadId: cef_thread_id_t) -> *mut cef_task_runner_t;
}
unsafe extern "C" {
    #[doc = "\n Returns true (1) if called on the specified thread. Equivalent to using\n cef_task_runner_t::GetForThread(threadId)->belongs_to_current_thread().\n"]
    pub fn cef_currently_on(threadId: cef_thread_id_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Post a task for execution on the specified thread. Equivalent to using\n cef_task_runner_t::GetForThread(threadId)->PostTask(task).\n"]
    pub fn cef_post_task(threadId: cef_thread_id_t, task: *mut cef_task_t)
        -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Post a task for delayed execution on the specified thread. Equivalent to\n using cef_task_runner_t::GetForThread(threadId)->PostDelayedTask(task,\n delay_ms).\n"]
    pub fn cef_post_delayed_task(
        threadId: cef_thread_id_t,
        task: *mut cef_task_t,
        delay_ms: i64,
    ) -> ::std::os::raw::c_int;
}
#[doc = "\n Structure representing a V8 context handle. V8 handles can only be accessed\n from the thread on which they are created. Valid threads for creating a V8\n handle include the render process main thread (TID_RENDERER) and WebWorker\n threads. A task runner for posting tasks on the associated thread can be\n retrieved via the cef_v8_context_t::get_task_runner() function.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_context_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the task runner associated with this context. V8 handles can only\n be accessed from the thread on which they are created. This function can\n be called on any render process thread.\n"]
    pub get_task_runner: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_context_t) -> *mut _cef_task_runner_t,
    >,
    #[doc = "\n Returns true (1) if the underlying handle is valid and it can be accessed\n on the current thread. Do not call any other functions if this function\n returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_context_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the browser for this context. This function will return an NULL\n reference for WebWorker contexts.\n"]
    pub get_browser: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_context_t) -> *mut _cef_browser_t,
    >,
    #[doc = "\n Returns the frame for this context. This function will return an NULL\n reference for WebWorker contexts.\n"]
    pub get_frame: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_context_t) -> *mut _cef_frame_t,
    >,
    #[doc = "\n Returns the global object for this context. The context must be entered\n before calling this function.\n"]
    pub get_global: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_context_t) -> *mut _cef_v8_value_t,
    >,
    #[doc = "\n Enter this context. A context must be explicitly entered before creating a\n V8 Object, Array, Function or Date asynchronously. exit() must be called\n the same number of times as enter() before releasing this context. V8\n objects belong to the context in which they are created. Returns true (1)\n if the scope was entered successfully.\n"]
    pub enter: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_context_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Exit this context. Call this function only after calling enter(). Returns\n true (1) if the scope was exited successfully.\n"]
    pub exit: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_context_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object is pointing to the same handle as |that|\n object.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_context_t,
            that: *mut _cef_v8_context_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Execute a string of JavaScript code in this V8 context. The |script_url|\n parameter is the URL where the script in question can be found, if any.\n The |start_line| parameter is the base line number to use for error\n reporting. On success |retval| will be set to the return value, if any,\n and the function will return true (1). On failure |exception| will be set\n to the exception, if any, and the function will return false (0).\n"]
    pub eval: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_context_t,
            code: *const cef_string_t,
            script_url: *const cef_string_t,
            start_line: ::std::os::raw::c_int,
            retval: *mut *mut _cef_v8_value_t,
            exception: *mut *mut _cef_v8_exception_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_context_t"][::std::mem::size_of::<_cef_v8_context_t>() - 112usize];
    ["Alignment of _cef_v8_context_t"][::std::mem::align_of::<_cef_v8_context_t>() - 8usize];
    ["Offset of field: _cef_v8_context_t::base"]
        [::std::mem::offset_of!(_cef_v8_context_t, base) - 0usize];
    ["Offset of field: _cef_v8_context_t::get_task_runner"]
        [::std::mem::offset_of!(_cef_v8_context_t, get_task_runner) - 40usize];
    ["Offset of field: _cef_v8_context_t::is_valid"]
        [::std::mem::offset_of!(_cef_v8_context_t, is_valid) - 48usize];
    ["Offset of field: _cef_v8_context_t::get_browser"]
        [::std::mem::offset_of!(_cef_v8_context_t, get_browser) - 56usize];
    ["Offset of field: _cef_v8_context_t::get_frame"]
        [::std::mem::offset_of!(_cef_v8_context_t, get_frame) - 64usize];
    ["Offset of field: _cef_v8_context_t::get_global"]
        [::std::mem::offset_of!(_cef_v8_context_t, get_global) - 72usize];
    ["Offset of field: _cef_v8_context_t::enter"]
        [::std::mem::offset_of!(_cef_v8_context_t, enter) - 80usize];
    ["Offset of field: _cef_v8_context_t::exit"]
        [::std::mem::offset_of!(_cef_v8_context_t, exit) - 88usize];
    ["Offset of field: _cef_v8_context_t::is_same"]
        [::std::mem::offset_of!(_cef_v8_context_t, is_same) - 96usize];
    ["Offset of field: _cef_v8_context_t::eval"]
        [::std::mem::offset_of!(_cef_v8_context_t, eval) - 104usize];
};
#[doc = "\n Structure representing a V8 context handle. V8 handles can only be accessed\n from the thread on which they are created. Valid threads for creating a V8\n handle include the render process main thread (TID_RENDERER) and WebWorker\n threads. A task runner for posting tasks on the associated thread can be\n retrieved via the cef_v8_context_t::get_task_runner() function.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_v8_context_t = _cef_v8_context_t;
unsafe extern "C" {
    #[doc = "\n Returns the current (top) context object in the V8 context stack.\n"]
    pub fn cef_v8_context_get_current_context() -> *mut cef_v8_context_t;
}
unsafe extern "C" {
    #[doc = "\n Returns the entered (bottom) context object in the V8 context stack.\n"]
    pub fn cef_v8_context_get_entered_context() -> *mut cef_v8_context_t;
}
unsafe extern "C" {
    #[doc = "\n Returns true (1) if V8 is currently inside a context.\n"]
    pub fn cef_v8_context_in_context() -> ::std::os::raw::c_int;
}
#[doc = "\n Structure that should be implemented to handle V8 function calls. The\n functions of this structure will be called on the thread associated with the\n V8 function.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Handle execution of the function identified by |name|. |object| is the\n receiver ('this' object) of the function. |arguments| is the list of\n arguments passed to the function. If execution succeeds set |retval| to\n the function return value. If execution fails set |exception| to the\n exception that will be thrown. Return true (1) if execution was handled.\n"]
    pub execute: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_handler_t,
            name: *const cef_string_t,
            object: *mut _cef_v8_value_t,
            argumentsCount: usize,
            arguments: *const *mut _cef_v8_value_t,
            retval: *mut *mut _cef_v8_value_t,
            exception: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_handler_t"][::std::mem::size_of::<_cef_v8_handler_t>() - 48usize];
    ["Alignment of _cef_v8_handler_t"][::std::mem::align_of::<_cef_v8_handler_t>() - 8usize];
    ["Offset of field: _cef_v8_handler_t::base"]
        [::std::mem::offset_of!(_cef_v8_handler_t, base) - 0usize];
    ["Offset of field: _cef_v8_handler_t::execute"]
        [::std::mem::offset_of!(_cef_v8_handler_t, execute) - 40usize];
};
#[doc = "\n Structure that should be implemented to handle V8 function calls. The\n functions of this structure will be called on the thread associated with the\n V8 function.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_v8_handler_t = _cef_v8_handler_t;
#[doc = "\n Structure that should be implemented to handle V8 accessor calls. Accessor\n identifiers are registered by calling cef_v8_value_t::set_value(). The\n functions of this structure will be called on the thread associated with the\n V8 accessor.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_accessor_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Handle retrieval the accessor value identified by |name|. |object| is the\n receiver ('this' object) of the accessor. If retrieval succeeds set\n |retval| to the return value. If retrieval fails set |exception| to the\n exception that will be thrown. Return true (1) if accessor retrieval was\n handled.\n"]
    pub get: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_accessor_t,
            name: *const cef_string_t,
            object: *mut _cef_v8_value_t,
            retval: *mut *mut _cef_v8_value_t,
            exception: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Handle assignment of the accessor value identified by |name|. |object| is\n the receiver ('this' object) of the accessor. |value| is the new value\n being assigned to the accessor. If assignment fails set |exception| to the\n exception that will be thrown. Return true (1) if accessor assignment was\n handled.\n"]
    pub set: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_accessor_t,
            name: *const cef_string_t,
            object: *mut _cef_v8_value_t,
            value: *mut _cef_v8_value_t,
            exception: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_accessor_t"][::std::mem::size_of::<_cef_v8_accessor_t>() - 56usize];
    ["Alignment of _cef_v8_accessor_t"][::std::mem::align_of::<_cef_v8_accessor_t>() - 8usize];
    ["Offset of field: _cef_v8_accessor_t::base"]
        [::std::mem::offset_of!(_cef_v8_accessor_t, base) - 0usize];
    ["Offset of field: _cef_v8_accessor_t::get"]
        [::std::mem::offset_of!(_cef_v8_accessor_t, get) - 40usize];
    ["Offset of field: _cef_v8_accessor_t::set"]
        [::std::mem::offset_of!(_cef_v8_accessor_t, set) - 48usize];
};
#[doc = "\n Structure that should be implemented to handle V8 accessor calls. Accessor\n identifiers are registered by calling cef_v8_value_t::set_value(). The\n functions of this structure will be called on the thread associated with the\n V8 accessor.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_v8_accessor_t = _cef_v8_accessor_t;
#[doc = "\n Structure that should be implemented to handle V8 interceptor calls. The\n functions of this structure will be called on the thread associated with the\n V8 interceptor. Interceptor's named property handlers (with first argument\n of type CefString) are called when object is indexed by string. Indexed\n property handlers (with first argument of type int) are called when object\n is indexed by integer.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_interceptor_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Handle retrieval of the interceptor value identified by |name|. |object|\n is the receiver ('this' object) of the interceptor. If retrieval succeeds,\n set |retval| to the return value. If the requested value does not exist,\n don't set either |retval| or |exception|. If retrieval fails, set\n |exception| to the exception that will be thrown. If the property has an\n associated accessor, it will be called only if you don't set |retval|.\n Return true (1) if interceptor retrieval was handled, false (0) otherwise.\n"]
    pub get_byname: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_interceptor_t,
            name: *const cef_string_t,
            object: *mut _cef_v8_value_t,
            retval: *mut *mut _cef_v8_value_t,
            exception: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Handle retrieval of the interceptor value identified by |index|. |object|\n is the receiver ('this' object) of the interceptor. If retrieval succeeds,\n set |retval| to the return value. If the requested value does not exist,\n don't set either |retval| or |exception|. If retrieval fails, set\n |exception| to the exception that will be thrown. Return true (1) if\n interceptor retrieval was handled, false (0) otherwise.\n"]
    pub get_byindex: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_interceptor_t,
            index: ::std::os::raw::c_int,
            object: *mut _cef_v8_value_t,
            retval: *mut *mut _cef_v8_value_t,
            exception: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Handle assignment of the interceptor value identified by |name|. |object|\n is the receiver ('this' object) of the interceptor. |value| is the new\n value being assigned to the interceptor. If assignment fails, set\n |exception| to the exception that will be thrown. This setter will always\n be called, even when the property has an associated accessor. Return true\n (1) if interceptor assignment was handled, false (0) otherwise.\n"]
    pub set_byname: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_interceptor_t,
            name: *const cef_string_t,
            object: *mut _cef_v8_value_t,
            value: *mut _cef_v8_value_t,
            exception: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Handle assignment of the interceptor value identified by |index|. |object|\n is the receiver ('this' object) of the interceptor. |value| is the new\n value being assigned to the interceptor. If assignment fails, set\n |exception| to the exception that will be thrown. Return true (1) if\n interceptor assignment was handled, false (0) otherwise.\n"]
    pub set_byindex: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_interceptor_t,
            index: ::std::os::raw::c_int,
            object: *mut _cef_v8_value_t,
            value: *mut _cef_v8_value_t,
            exception: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_interceptor_t"][::std::mem::size_of::<_cef_v8_interceptor_t>() - 72usize];
    ["Alignment of _cef_v8_interceptor_t"]
        [::std::mem::align_of::<_cef_v8_interceptor_t>() - 8usize];
    ["Offset of field: _cef_v8_interceptor_t::base"]
        [::std::mem::offset_of!(_cef_v8_interceptor_t, base) - 0usize];
    ["Offset of field: _cef_v8_interceptor_t::get_byname"]
        [::std::mem::offset_of!(_cef_v8_interceptor_t, get_byname) - 40usize];
    ["Offset of field: _cef_v8_interceptor_t::get_byindex"]
        [::std::mem::offset_of!(_cef_v8_interceptor_t, get_byindex) - 48usize];
    ["Offset of field: _cef_v8_interceptor_t::set_byname"]
        [::std::mem::offset_of!(_cef_v8_interceptor_t, set_byname) - 56usize];
    ["Offset of field: _cef_v8_interceptor_t::set_byindex"]
        [::std::mem::offset_of!(_cef_v8_interceptor_t, set_byindex) - 64usize];
};
#[doc = "\n Structure that should be implemented to handle V8 interceptor calls. The\n functions of this structure will be called on the thread associated with the\n V8 interceptor. Interceptor's named property handlers (with first argument\n of type CefString) are called when object is indexed by string. Indexed\n property handlers (with first argument of type int) are called when object\n is indexed by integer.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_v8_interceptor_t = _cef_v8_interceptor_t;
#[doc = "\n Structure representing a V8 exception. The functions of this structure may\n be called on any render process thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_exception_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the exception message.\n"]
    pub get_message: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_exception_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the line of source code that the exception occurred within.\n"]
    pub get_source_line: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_exception_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the resource name for the script from where the function causing\n the error originates.\n"]
    pub get_script_resource_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_exception_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the 1-based number of the line where the error occurred or 0 if\n the line number is unknown.\n"]
    pub get_line_number: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_exception_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the index within the script of the first character where the error\n occurred.\n"]
    pub get_start_position: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_exception_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the index within the script of the last character where the error\n occurred.\n"]
    pub get_end_position: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_exception_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the index within the line of the first character where the error\n occurred.\n"]
    pub get_start_column: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_exception_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the index within the line of the last character where the error\n occurred.\n"]
    pub get_end_column: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_exception_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_exception_t"][::std::mem::size_of::<_cef_v8_exception_t>() - 104usize];
    ["Alignment of _cef_v8_exception_t"][::std::mem::align_of::<_cef_v8_exception_t>() - 8usize];
    ["Offset of field: _cef_v8_exception_t::base"]
        [::std::mem::offset_of!(_cef_v8_exception_t, base) - 0usize];
    ["Offset of field: _cef_v8_exception_t::get_message"]
        [::std::mem::offset_of!(_cef_v8_exception_t, get_message) - 40usize];
    ["Offset of field: _cef_v8_exception_t::get_source_line"]
        [::std::mem::offset_of!(_cef_v8_exception_t, get_source_line) - 48usize];
    ["Offset of field: _cef_v8_exception_t::get_script_resource_name"]
        [::std::mem::offset_of!(_cef_v8_exception_t, get_script_resource_name) - 56usize];
    ["Offset of field: _cef_v8_exception_t::get_line_number"]
        [::std::mem::offset_of!(_cef_v8_exception_t, get_line_number) - 64usize];
    ["Offset of field: _cef_v8_exception_t::get_start_position"]
        [::std::mem::offset_of!(_cef_v8_exception_t, get_start_position) - 72usize];
    ["Offset of field: _cef_v8_exception_t::get_end_position"]
        [::std::mem::offset_of!(_cef_v8_exception_t, get_end_position) - 80usize];
    ["Offset of field: _cef_v8_exception_t::get_start_column"]
        [::std::mem::offset_of!(_cef_v8_exception_t, get_start_column) - 88usize];
    ["Offset of field: _cef_v8_exception_t::get_end_column"]
        [::std::mem::offset_of!(_cef_v8_exception_t, get_end_column) - 96usize];
};
#[doc = "\n Structure representing a V8 exception. The functions of this structure may\n be called on any render process thread.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_v8_exception_t = _cef_v8_exception_t;
#[doc = "\n Callback structure that is passed to cef_v8_value_t::CreateArrayBuffer.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_array_buffer_release_callback_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called to release |buffer| when the ArrayBuffer JS object is garbage\n collected. |buffer| is the value that was passed to CreateArrayBuffer\n along with this object.\n"]
    pub release_buffer: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_array_buffer_release_callback_t,
            buffer: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_array_buffer_release_callback_t"]
        [::std::mem::size_of::<_cef_v8_array_buffer_release_callback_t>() - 48usize];
    ["Alignment of _cef_v8_array_buffer_release_callback_t"]
        [::std::mem::align_of::<_cef_v8_array_buffer_release_callback_t>() - 8usize];
    ["Offset of field: _cef_v8_array_buffer_release_callback_t::base"]
        [::std::mem::offset_of!(_cef_v8_array_buffer_release_callback_t, base) - 0usize];
    ["Offset of field: _cef_v8_array_buffer_release_callback_t::release_buffer"]
        [::std::mem::offset_of!(_cef_v8_array_buffer_release_callback_t, release_buffer) - 40usize];
};
#[doc = "\n Callback structure that is passed to cef_v8_value_t::CreateArrayBuffer.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_v8_array_buffer_release_callback_t = _cef_v8_array_buffer_release_callback_t;
#[doc = "\n Structure representing a V8 value handle. V8 handles can only be accessed\n from the thread on which they are created. Valid threads for creating a V8\n handle include the render process main thread (TID_RENDERER) and WebWorker\n threads. A task runner for posting tasks on the associated thread can be\n retrieved via the cef_v8_context_t::get_task_runner() function.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_value_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if the underlying handle is valid and it can be accessed\n on the current thread. Do not call any other functions if this function\n returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is undefined.\n"]
    pub is_undefined: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is null.\n"]
    pub is_null: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is bool.\n"]
    pub is_bool: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is int.\n"]
    pub is_int: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is unsigned int.\n"]
    pub is_uint: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is double.\n"]
    pub is_double: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is Date.\n"]
    pub is_date: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is string.\n"]
    pub is_string: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is object.\n"]
    pub is_object: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is array.\n"]
    pub is_array: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is an ArrayBuffer.\n"]
    pub is_array_buffer: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is function.\n"]
    pub is_function: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n True if the value type is a Promise.\n"]
    pub is_promise: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object is pointing to the same handle as |that|\n object.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            that: *mut _cef_v8_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return a bool value.\n"]
    pub get_bool_value: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return an int value.\n"]
    pub get_int_value:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> i32>,
    #[doc = "\n Return an unsigned int value.\n"]
    pub get_uint_value:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> u32>,
    #[doc = "\n Return a double value.\n"]
    pub get_double_value:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> f64>,
    #[doc = "\n Return a Date value.\n"]
    pub get_date_value:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> cef_basetime_t>,
    #[doc = "\n Return a string value.\n"]
    pub get_string_value: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns true (1) if this is a user created object.\n"]
    pub is_user_created: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the last function call resulted in an exception. This\n attribute exists only in the scope of the current CEF value object.\n"]
    pub has_exception: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the exception resulting from the last function call. This\n attribute exists only in the scope of the current CEF value object.\n"]
    pub get_exception: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> *mut _cef_v8_exception_t,
    >,
    #[doc = "\n Clears the last exception and returns true (1) on success.\n"]
    pub clear_exception: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this object will re-throw future exceptions. This\n attribute exists only in the scope of the current CEF value object.\n"]
    pub will_rethrow_exceptions: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set whether this object will re-throw future exceptions. By default\n exceptions are not re-thrown. If a exception is re-thrown the current\n context should not be accessed again until after the exception has been\n caught and not re-thrown. Returns true (1) on success. This attribute\n exists only in the scope of the current CEF value object.\n"]
    pub set_rethrow_exceptions: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            rethrow: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the object has a value with the specified identifier.\n"]
    pub has_value_bykey: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            key: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the object has a value with the specified identifier.\n"]
    pub has_value_byindex: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            index: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Deletes the value with the specified identifier and returns true (1) on\n success. Returns false (0) if this function is called incorrectly or an\n exception is thrown. For read-only and don't-delete values this function\n will return true (1) even though deletion failed.\n"]
    pub delete_value_bykey: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            key: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Deletes the value with the specified identifier and returns true (1) on\n success. Returns false (0) if this function is called incorrectly,\n deletion fails or an exception is thrown. For read-only and don't-delete\n values this function will return true (1) even though deletion failed.\n"]
    pub delete_value_byindex: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            index: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the value with the specified identifier on success. Returns NULL\n if this function is called incorrectly or an exception is thrown.\n"]
    pub get_value_bykey: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            key: *const cef_string_t,
        ) -> *mut _cef_v8_value_t,
    >,
    #[doc = "\n Returns the value with the specified identifier on success. Returns NULL\n if this function is called incorrectly or an exception is thrown.\n"]
    pub get_value_byindex: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            index: ::std::os::raw::c_int,
        ) -> *mut _cef_v8_value_t,
    >,
    #[doc = "\n Associates a value with the specified identifier and returns true (1) on\n success. Returns false (0) if this function is called incorrectly or an\n exception is thrown. For read-only values this function will return true\n (1) even though assignment failed.\n"]
    pub set_value_bykey: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            key: *const cef_string_t,
            value: *mut _cef_v8_value_t,
            attribute: cef_v8_propertyattribute_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Associates a value with the specified identifier and returns true (1) on\n success. Returns false (0) if this function is called incorrectly or an\n exception is thrown. For read-only values this function will return true\n (1) even though assignment failed.\n"]
    pub set_value_byindex: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            index: ::std::os::raw::c_int,
            value: *mut _cef_v8_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Registers an identifier and returns true (1) on success. Access to the\n identifier will be forwarded to the cef_v8_accessor_t instance passed to\n cef_v8_value_t::cef_v8_value_create_object(). Returns false (0) if this\n function is called incorrectly or an exception is thrown. For read-only\n values this function will return true (1) even though assignment failed.\n"]
    pub set_value_byaccessor: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            key: *const cef_string_t,
            attribute: cef_v8_propertyattribute_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Read the keys for the object's values into the specified vector. Integer-\n based keys will also be returned as strings.\n"]
    pub get_keys: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            keys: cef_string_list_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the user data for this object and returns true (1) on success.\n Returns false (0) if this function is called incorrectly. This function\n can only be called on user created objects.\n"]
    pub set_user_data: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            user_data: *mut _cef_base_ref_counted_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the user data, if any, assigned to this object.\n"]
    pub get_user_data: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> *mut _cef_base_ref_counted_t,
    >,
    #[doc = "\n Returns the amount of externally allocated memory registered for the\n object.\n"]
    pub get_externally_allocated_memory: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Adjusts the amount of registered external memory for the object. Used to\n give V8 an indication of the amount of externally allocated memory that is\n kept alive by JavaScript objects. V8 uses this information to decide when\n to perform global garbage collection. Each cef_v8_value_t tracks the\n amount of external memory associated with it and automatically decreases\n the global total by the appropriate amount on its destruction.\n |change_in_bytes| specifies the number of bytes to adjust by. This\n function returns the number of bytes associated with the object after the\n adjustment. This function can only be called on user created objects.\n"]
    pub adjust_externally_allocated_memory: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            change_in_bytes: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the number of elements in the array.\n"]
    pub get_array_length: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the ReleaseCallback object associated with the ArrayBuffer or NULL\n if the ArrayBuffer was not created with CreateArrayBuffer.\n"]
    pub get_array_buffer_release_callback: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
        ) -> *mut _cef_v8_array_buffer_release_callback_t,
    >,
    #[doc = "\n Prevent the ArrayBuffer from using it's memory block by setting the length\n to zero. This operation cannot be undone. If the ArrayBuffer was created\n with CreateArrayBuffer then\n cef_v8_array_buffer_release_callback_t::ReleaseBuffer will be called to\n release the underlying buffer.\n"]
    pub neuter_array_buffer: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the length (in bytes) of the ArrayBuffer.\n"]
    pub get_array_buffer_byte_length:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> usize>,
    #[doc = "\n Returns a pointer to the beginning of the memory block for this\n ArrayBuffer backing store. The returned pointer is valid as long as the\n cef_v8_value_t is alive.\n"]
    pub get_array_buffer_data: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> *mut ::std::os::raw::c_void,
    >,
    #[doc = "\n Returns the function name.\n"]
    pub get_function_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the function handler or NULL if not a CEF-created function.\n"]
    pub get_function_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_value_t) -> *mut _cef_v8_handler_t,
    >,
    #[doc = "\n Execute the function using the current V8 context. This function should\n only be called from within the scope of a cef_v8_handler_t or\n cef_v8_accessor_t callback, or in combination with calling enter() and\n exit() on a stored cef_v8_context_t reference. |object| is the receiver\n ('this' object) of the function. If |object| is NULL the current context's\n global object will be used. |arguments| is the list of arguments that will\n be passed to the function. Returns the function return value on success.\n Returns NULL if this function is called incorrectly or an exception is\n thrown.\n"]
    pub execute_function: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            object: *mut _cef_v8_value_t,
            argumentsCount: usize,
            arguments: *const *mut _cef_v8_value_t,
        ) -> *mut _cef_v8_value_t,
    >,
    #[doc = "\n Execute the function using the specified V8 context. |object| is the\n receiver ('this' object) of the function. If |object| is NULL the\n specified context's global object will be used. |arguments| is the list of\n arguments that will be passed to the function. Returns the function return\n value on success. Returns NULL if this function is called incorrectly or\n an exception is thrown.\n"]
    pub execute_function_with_context: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            context: *mut _cef_v8_context_t,
            object: *mut _cef_v8_value_t,
            argumentsCount: usize,
            arguments: *const *mut _cef_v8_value_t,
        ) -> *mut _cef_v8_value_t,
    >,
    #[doc = "\n Resolve the Promise using the current V8 context. This function should\n only be called from within the scope of a cef_v8_handler_t or\n cef_v8_accessor_t callback, or in combination with calling enter() and\n exit() on a stored cef_v8_context_t reference. |arg| is the argument\n passed to the resolved promise. Returns true (1) on success. Returns false\n (0) if this function is called incorrectly or an exception is thrown.\n"]
    pub resolve_promise: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            arg: *mut _cef_v8_value_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Reject the Promise using the current V8 context. This function should only\n be called from within the scope of a cef_v8_handler_t or cef_v8_accessor_t\n callback, or in combination with calling enter() and exit() on a stored\n cef_v8_context_t reference. Returns true (1) on success. Returns false (0)\n if this function is called incorrectly or an exception is thrown.\n"]
    pub reject_promise: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_value_t,
            errorMsg: *const cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_value_t"][::std::mem::size_of::<_cef_v8_value_t>() - 456usize];
    ["Alignment of _cef_v8_value_t"][::std::mem::align_of::<_cef_v8_value_t>() - 8usize];
    ["Offset of field: _cef_v8_value_t::base"]
        [::std::mem::offset_of!(_cef_v8_value_t, base) - 0usize];
    ["Offset of field: _cef_v8_value_t::is_valid"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_valid) - 40usize];
    ["Offset of field: _cef_v8_value_t::is_undefined"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_undefined) - 48usize];
    ["Offset of field: _cef_v8_value_t::is_null"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_null) - 56usize];
    ["Offset of field: _cef_v8_value_t::is_bool"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_bool) - 64usize];
    ["Offset of field: _cef_v8_value_t::is_int"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_int) - 72usize];
    ["Offset of field: _cef_v8_value_t::is_uint"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_uint) - 80usize];
    ["Offset of field: _cef_v8_value_t::is_double"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_double) - 88usize];
    ["Offset of field: _cef_v8_value_t::is_date"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_date) - 96usize];
    ["Offset of field: _cef_v8_value_t::is_string"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_string) - 104usize];
    ["Offset of field: _cef_v8_value_t::is_object"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_object) - 112usize];
    ["Offset of field: _cef_v8_value_t::is_array"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_array) - 120usize];
    ["Offset of field: _cef_v8_value_t::is_array_buffer"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_array_buffer) - 128usize];
    ["Offset of field: _cef_v8_value_t::is_function"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_function) - 136usize];
    ["Offset of field: _cef_v8_value_t::is_promise"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_promise) - 144usize];
    ["Offset of field: _cef_v8_value_t::is_same"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_same) - 152usize];
    ["Offset of field: _cef_v8_value_t::get_bool_value"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_bool_value) - 160usize];
    ["Offset of field: _cef_v8_value_t::get_int_value"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_int_value) - 168usize];
    ["Offset of field: _cef_v8_value_t::get_uint_value"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_uint_value) - 176usize];
    ["Offset of field: _cef_v8_value_t::get_double_value"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_double_value) - 184usize];
    ["Offset of field: _cef_v8_value_t::get_date_value"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_date_value) - 192usize];
    ["Offset of field: _cef_v8_value_t::get_string_value"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_string_value) - 200usize];
    ["Offset of field: _cef_v8_value_t::is_user_created"]
        [::std::mem::offset_of!(_cef_v8_value_t, is_user_created) - 208usize];
    ["Offset of field: _cef_v8_value_t::has_exception"]
        [::std::mem::offset_of!(_cef_v8_value_t, has_exception) - 216usize];
    ["Offset of field: _cef_v8_value_t::get_exception"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_exception) - 224usize];
    ["Offset of field: _cef_v8_value_t::clear_exception"]
        [::std::mem::offset_of!(_cef_v8_value_t, clear_exception) - 232usize];
    ["Offset of field: _cef_v8_value_t::will_rethrow_exceptions"]
        [::std::mem::offset_of!(_cef_v8_value_t, will_rethrow_exceptions) - 240usize];
    ["Offset of field: _cef_v8_value_t::set_rethrow_exceptions"]
        [::std::mem::offset_of!(_cef_v8_value_t, set_rethrow_exceptions) - 248usize];
    ["Offset of field: _cef_v8_value_t::has_value_bykey"]
        [::std::mem::offset_of!(_cef_v8_value_t, has_value_bykey) - 256usize];
    ["Offset of field: _cef_v8_value_t::has_value_byindex"]
        [::std::mem::offset_of!(_cef_v8_value_t, has_value_byindex) - 264usize];
    ["Offset of field: _cef_v8_value_t::delete_value_bykey"]
        [::std::mem::offset_of!(_cef_v8_value_t, delete_value_bykey) - 272usize];
    ["Offset of field: _cef_v8_value_t::delete_value_byindex"]
        [::std::mem::offset_of!(_cef_v8_value_t, delete_value_byindex) - 280usize];
    ["Offset of field: _cef_v8_value_t::get_value_bykey"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_value_bykey) - 288usize];
    ["Offset of field: _cef_v8_value_t::get_value_byindex"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_value_byindex) - 296usize];
    ["Offset of field: _cef_v8_value_t::set_value_bykey"]
        [::std::mem::offset_of!(_cef_v8_value_t, set_value_bykey) - 304usize];
    ["Offset of field: _cef_v8_value_t::set_value_byindex"]
        [::std::mem::offset_of!(_cef_v8_value_t, set_value_byindex) - 312usize];
    ["Offset of field: _cef_v8_value_t::set_value_byaccessor"]
        [::std::mem::offset_of!(_cef_v8_value_t, set_value_byaccessor) - 320usize];
    ["Offset of field: _cef_v8_value_t::get_keys"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_keys) - 328usize];
    ["Offset of field: _cef_v8_value_t::set_user_data"]
        [::std::mem::offset_of!(_cef_v8_value_t, set_user_data) - 336usize];
    ["Offset of field: _cef_v8_value_t::get_user_data"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_user_data) - 344usize];
    ["Offset of field: _cef_v8_value_t::get_externally_allocated_memory"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_externally_allocated_memory) - 352usize];
    ["Offset of field: _cef_v8_value_t::adjust_externally_allocated_memory"]
        [::std::mem::offset_of!(_cef_v8_value_t, adjust_externally_allocated_memory) - 360usize];
    ["Offset of field: _cef_v8_value_t::get_array_length"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_array_length) - 368usize];
    ["Offset of field: _cef_v8_value_t::get_array_buffer_release_callback"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_array_buffer_release_callback) - 376usize];
    ["Offset of field: _cef_v8_value_t::neuter_array_buffer"]
        [::std::mem::offset_of!(_cef_v8_value_t, neuter_array_buffer) - 384usize];
    ["Offset of field: _cef_v8_value_t::get_array_buffer_byte_length"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_array_buffer_byte_length) - 392usize];
    ["Offset of field: _cef_v8_value_t::get_array_buffer_data"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_array_buffer_data) - 400usize];
    ["Offset of field: _cef_v8_value_t::get_function_name"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_function_name) - 408usize];
    ["Offset of field: _cef_v8_value_t::get_function_handler"]
        [::std::mem::offset_of!(_cef_v8_value_t, get_function_handler) - 416usize];
    ["Offset of field: _cef_v8_value_t::execute_function"]
        [::std::mem::offset_of!(_cef_v8_value_t, execute_function) - 424usize];
    ["Offset of field: _cef_v8_value_t::execute_function_with_context"]
        [::std::mem::offset_of!(_cef_v8_value_t, execute_function_with_context) - 432usize];
    ["Offset of field: _cef_v8_value_t::resolve_promise"]
        [::std::mem::offset_of!(_cef_v8_value_t, resolve_promise) - 440usize];
    ["Offset of field: _cef_v8_value_t::reject_promise"]
        [::std::mem::offset_of!(_cef_v8_value_t, reject_promise) - 448usize];
};
#[doc = "\n Structure representing a V8 value handle. V8 handles can only be accessed\n from the thread on which they are created. Valid threads for creating a V8\n handle include the render process main thread (TID_RENDERER) and WebWorker\n threads. A task runner for posting tasks on the associated thread can be\n retrieved via the cef_v8_context_t::get_task_runner() function.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_v8_value_t = _cef_v8_value_t;
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type undefined.\n"]
    pub fn cef_v8_value_create_undefined() -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type null.\n"]
    pub fn cef_v8_value_create_null() -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type bool.\n"]
    pub fn cef_v8_value_create_bool(value: ::std::os::raw::c_int) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type int.\n"]
    pub fn cef_v8_value_create_int(value: i32) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type unsigned int.\n"]
    pub fn cef_v8_value_create_uint(value: u32) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type double.\n"]
    pub fn cef_v8_value_create_double(value: f64) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type Date. This function should only\n be called from within the scope of a cef_render_process_handler_t,\n cef_v8_handler_t or cef_v8_accessor_t callback, or in combination with\n calling enter() and exit() on a stored cef_v8_context_t reference.\n"]
    pub fn cef_v8_value_create_date(date: cef_basetime_t) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type string.\n"]
    pub fn cef_v8_value_create_string(value: *const cef_string_t) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type object with optional accessor\n and/or interceptor. This function should only be called from within the\n scope of a cef_render_process_handler_t, cef_v8_handler_t or\n cef_v8_accessor_t callback, or in combination with calling enter() and\n exit() on a stored cef_v8_context_t reference.\n"]
    pub fn cef_v8_value_create_object(
        accessor: *mut cef_v8_accessor_t,
        interceptor: *mut cef_v8_interceptor_t,
    ) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type array with the specified\n |length|. If |length| is negative the returned array will have length 0.\n This function should only be called from within the scope of a\n cef_render_process_handler_t, cef_v8_handler_t or cef_v8_accessor_t\n callback, or in combination with calling enter() and exit() on a stored\n cef_v8_context_t reference.\n"]
    pub fn cef_v8_value_create_array(length: ::std::os::raw::c_int) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type ArrayBuffer which wraps the\n provided |buffer| of size |length| bytes. The ArrayBuffer is externalized,\n meaning that it does not own |buffer|. The caller is responsible for freeing\n |buffer| when requested via a call to\n cef_v8_array_buffer_release_callback_t::ReleaseBuffer. This function should\n only be called from within the scope of a cef_render_process_handler_t,\n cef_v8_handler_t or cef_v8_accessor_t callback, or in combination with\n calling enter() and exit() on a stored cef_v8_context_t reference.\n\n NOTE: Always returns nullptr when V8 sandbox is enabled.\n"]
    pub fn cef_v8_value_create_array_buffer(
        buffer: *mut ::std::os::raw::c_void,
        length: usize,
        release_callback: *mut cef_v8_array_buffer_release_callback_t,
    ) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type ArrayBuffer which copies the\n provided |buffer| of size |length| bytes. This function should only be\n called from within the scope of a cef_render_process_handler_t,\n cef_v8_handler_t or cef_v8_accessor_t callback, or in combination with\n calling enter() and exit() on a stored cef_v8_context_t reference.\n"]
    pub fn cef_v8_value_create_array_buffer_with_copy(
        buffer: *mut ::std::os::raw::c_void,
        length: usize,
    ) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type function. This function should\n only be called from within the scope of a cef_render_process_handler_t,\n cef_v8_handler_t or cef_v8_accessor_t callback, or in combination with\n calling enter() and exit() on a stored cef_v8_context_t reference.\n"]
    pub fn cef_v8_value_create_function(
        name: *const cef_string_t,
        handler: *mut cef_v8_handler_t,
    ) -> *mut cef_v8_value_t;
}
unsafe extern "C" {
    #[doc = "\n Create a new cef_v8_value_t object of type Promise. This function should\n only be called from within the scope of a cef_render_process_handler_t,\n cef_v8_handler_t or cef_v8_accessor_t callback, or in combination with\n calling enter() and exit() on a stored cef_v8_context_t reference.\n"]
    pub fn cef_v8_value_create_promise() -> *mut cef_v8_value_t;
}
#[doc = "\n Structure representing a V8 stack trace handle. V8 handles can only be\n accessed from the thread on which they are created. Valid threads for\n creating a V8 handle include the render process main thread (TID_RENDERER)\n and WebWorker threads. A task runner for posting tasks on the associated\n thread can be retrieved via the cef_v8_context_t::get_task_runner()\n function.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_stack_trace_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if the underlying handle is valid and it can be accessed\n on the current thread. Do not call any other functions if this function\n returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_trace_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the number of stack frames.\n"]
    pub get_frame_count: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_trace_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the stack frame at the specified 0-based index.\n"]
    pub get_frame: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_v8_stack_trace_t,
            index: ::std::os::raw::c_int,
        ) -> *mut _cef_v8_stack_frame_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_stack_trace_t"][::std::mem::size_of::<_cef_v8_stack_trace_t>() - 64usize];
    ["Alignment of _cef_v8_stack_trace_t"]
        [::std::mem::align_of::<_cef_v8_stack_trace_t>() - 8usize];
    ["Offset of field: _cef_v8_stack_trace_t::base"]
        [::std::mem::offset_of!(_cef_v8_stack_trace_t, base) - 0usize];
    ["Offset of field: _cef_v8_stack_trace_t::is_valid"]
        [::std::mem::offset_of!(_cef_v8_stack_trace_t, is_valid) - 40usize];
    ["Offset of field: _cef_v8_stack_trace_t::get_frame_count"]
        [::std::mem::offset_of!(_cef_v8_stack_trace_t, get_frame_count) - 48usize];
    ["Offset of field: _cef_v8_stack_trace_t::get_frame"]
        [::std::mem::offset_of!(_cef_v8_stack_trace_t, get_frame) - 56usize];
};
#[doc = "\n Structure representing a V8 stack trace handle. V8 handles can only be\n accessed from the thread on which they are created. Valid threads for\n creating a V8 handle include the render process main thread (TID_RENDERER)\n and WebWorker threads. A task runner for posting tasks on the associated\n thread can be retrieved via the cef_v8_context_t::get_task_runner()\n function.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_v8_stack_trace_t = _cef_v8_stack_trace_t;
unsafe extern "C" {
    #[doc = "\n Returns the stack trace for the currently active context. |frame_limit| is\n the maximum number of frames that will be captured.\n"]
    pub fn cef_v8_stack_trace_get_current(
        frame_limit: ::std::os::raw::c_int,
    ) -> *mut cef_v8_stack_trace_t;
}
#[doc = "\n Structure representing a V8 stack frame handle. V8 handles can only be\n accessed from the thread on which they are created. Valid threads for\n creating a V8 handle include the render process main thread (TID_RENDERER)\n and WebWorker threads. A task runner for posting tasks on the associated\n thread can be retrieved via the cef_v8_context_t::get_task_runner()\n function.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_v8_stack_frame_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns true (1) if the underlying handle is valid and it can be accessed\n on the current thread. Do not call any other functions if this function\n returns false (0).\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_frame_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the name of the resource script that contains the function.\n"]
    pub get_script_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_frame_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the name of the resource script that contains the function or the\n sourceURL value if the script name is undefined and its source ends with a\n \"//@ sourceURL=...\" string.\n"]
    pub get_script_name_or_source_url: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_frame_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the name of the function.\n"]
    pub get_function_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_frame_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns the 1-based line number for the function call or 0 if unknown.\n"]
    pub get_line_number: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_frame_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the 1-based column offset on the line for the function call or 0\n if unknown.\n"]
    pub get_column: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_frame_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the function was compiled using eval().\n"]
    pub is_eval: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_frame_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the function was called as a constructor via \"new\".\n"]
    pub is_constructor: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_v8_stack_frame_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_v8_stack_frame_t"][::std::mem::size_of::<_cef_v8_stack_frame_t>() - 104usize];
    ["Alignment of _cef_v8_stack_frame_t"]
        [::std::mem::align_of::<_cef_v8_stack_frame_t>() - 8usize];
    ["Offset of field: _cef_v8_stack_frame_t::base"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, base) - 0usize];
    ["Offset of field: _cef_v8_stack_frame_t::is_valid"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, is_valid) - 40usize];
    ["Offset of field: _cef_v8_stack_frame_t::get_script_name"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, get_script_name) - 48usize];
    ["Offset of field: _cef_v8_stack_frame_t::get_script_name_or_source_url"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, get_script_name_or_source_url) - 56usize];
    ["Offset of field: _cef_v8_stack_frame_t::get_function_name"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, get_function_name) - 64usize];
    ["Offset of field: _cef_v8_stack_frame_t::get_line_number"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, get_line_number) - 72usize];
    ["Offset of field: _cef_v8_stack_frame_t::get_column"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, get_column) - 80usize];
    ["Offset of field: _cef_v8_stack_frame_t::is_eval"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, is_eval) - 88usize];
    ["Offset of field: _cef_v8_stack_frame_t::is_constructor"]
        [::std::mem::offset_of!(_cef_v8_stack_frame_t, is_constructor) - 96usize];
};
#[doc = "\n Structure representing a V8 stack frame handle. V8 handles can only be\n accessed from the thread on which they are created. Valid threads for\n creating a V8 handle include the render process main thread (TID_RENDERER)\n and WebWorker threads. A task runner for posting tasks on the associated\n thread can be retrieved via the cef_v8_context_t::get_task_runner()\n function.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_v8_stack_frame_t = _cef_v8_stack_frame_t;
unsafe extern "C" {
    #[doc = "\n Register a new V8 extension with the specified JavaScript extension code and\n handler. Functions implemented by the handler are prototyped using the\n keyword 'native'. The calling of a native function is restricted to the\n scope in which the prototype of the native function is defined. This\n function may only be called on the render process main thread.\n\n Example JavaScript extension code: <pre>\n   // create the 'example' global object if it doesn't already exist.\n   if (!example)\n     example = {};\n   // create the 'example.test' global object if it doesn't already exist.\n   if (!example.test)\n     example.test = {};\n   (function() {\n     // Define the function 'example.test.myfunction'.\n     example.test.myfunction = function() {\n       // Call CefV8Handler::Execute() with the function name 'MyFunction'\n       // and no arguments.\n       native function MyFunction();\n       return MyFunction();\n     };\n     // Define the getter function for parameter 'example.test.myparam'.\n     example.test.__defineGetter__('myparam', function() {\n       // Call CefV8Handler::Execute() with the function name 'GetMyParam'\n       // and no arguments.\n       native function GetMyParam();\n       return GetMyParam();\n     });\n     // Define the setter function for parameter 'example.test.myparam'.\n     example.test.__defineSetter__('myparam', function(b) {\n       // Call CefV8Handler::Execute() with the function name 'SetMyParam'\n       // and a single argument.\n       native function SetMyParam();\n       if(b) SetMyParam(b);\n     });\n\n     // Extension definitions can also contain normal JavaScript variables\n     // and functions.\n     var myint = 0;\n     example.test.increment = function() {\n       myint += 1;\n       return myint;\n     };\n   })();\n </pre>\n\n Example usage in the page: <pre>\n   // Call the function.\n   example.test.myfunction();\n   // Set the parameter.\n   example.test.myparam = value;\n   // Get the parameter.\n   value = example.test.myparam;\n   // Call another function.\n   example.test.increment();\n </pre>\n"]
    pub fn cef_register_extension(
        extension_name: *const cef_string_t,
        javascript_code: *const cef_string_t,
        handler: *mut cef_v8_handler_t,
    ) -> ::std::os::raw::c_int;
}
#[doc = "\n Structure used to implement render process callbacks. The functions of this\n structure will be called on the render process main thread (TID_RENDERER)\n unless otherwise indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_render_process_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called after WebKit has been initialized.\n"]
    pub on_web_kit_initialized:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_render_process_handler_t)>,
    #[doc = "\n Called after a browser has been created. When browsing cross-origin a new\n browser will be created before the old browser with the same identifier is\n destroyed. |extra_info| is an optional read-only value originating from\n cef_browser_host_t::cef_browser_host_create_browser(),\n cef_browser_host_t::cef_browser_host_create_browser_sync(),\n cef_life_span_handler_t::on_before_popup() or\n cef_browser_view_t::cef_browser_view_create().\n"]
    pub on_browser_created: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_process_handler_t,
            browser: *mut _cef_browser_t,
            extra_info: *mut _cef_dictionary_value_t,
        ),
    >,
    #[doc = "\n Called before a browser is destroyed.\n"]
    pub on_browser_destroyed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_process_handler_t,
            browser: *mut _cef_browser_t,
        ),
    >,
    #[doc = "\n Return the handler for browser load status events.\n"]
    pub get_load_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_render_process_handler_t) -> *mut _cef_load_handler_t,
    >,
    #[doc = "\n Called immediately after the V8 context for a frame has been created. To\n retrieve the JavaScript 'window' object use the\n cef_v8_context_t::get_global() function. V8 handles can only be accessed\n from the thread on which they are created. A task runner for posting tasks\n on the associated thread can be retrieved via the\n cef_v8_context_t::get_task_runner() function.\n"]
    pub on_context_created: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_process_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            context: *mut _cef_v8_context_t,
        ),
    >,
    #[doc = "\n Called immediately before the V8 context for a frame is released. No\n references to the context should be kept after this function is called.\n"]
    pub on_context_released: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_process_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            context: *mut _cef_v8_context_t,
        ),
    >,
    #[doc = "\n Called for global uncaught exceptions in a frame. Execution of this\n callback is disabled by default. To enable set\n cef_settings_t.uncaught_exception_stack_size > 0.\n"]
    pub on_uncaught_exception: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_process_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            context: *mut _cef_v8_context_t,
            exception: *mut _cef_v8_exception_t,
            stackTrace: *mut _cef_v8_stack_trace_t,
        ),
    >,
    #[doc = "\n Called when a new node in the the browser gets focus. The |node| value may\n be NULL if no specific node has gained focus. The node object passed to\n this function represents a snapshot of the DOM at the time this function\n is executed. DOM objects are only valid for the scope of this function. Do\n not keep references to or attempt to access any DOM objects outside the\n scope of this function.\n"]
    pub on_focused_node_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_process_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            node: *mut _cef_domnode_t,
        ),
    >,
    #[doc = "\n Called when a new message is received from a different process. Return\n true (1) if the message was handled or false (0) otherwise. It is safe to\n keep a reference to |message| outside of this callback.\n"]
    pub on_process_message_received: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_render_process_handler_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            source_process: cef_process_id_t,
            message: *mut _cef_process_message_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_render_process_handler_t"]
        [::std::mem::size_of::<_cef_render_process_handler_t>() - 112usize];
    ["Alignment of _cef_render_process_handler_t"]
        [::std::mem::align_of::<_cef_render_process_handler_t>() - 8usize];
    ["Offset of field: _cef_render_process_handler_t::base"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, base) - 0usize];
    ["Offset of field: _cef_render_process_handler_t::on_web_kit_initialized"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, on_web_kit_initialized) - 40usize];
    ["Offset of field: _cef_render_process_handler_t::on_browser_created"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, on_browser_created) - 48usize];
    ["Offset of field: _cef_render_process_handler_t::on_browser_destroyed"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, on_browser_destroyed) - 56usize];
    ["Offset of field: _cef_render_process_handler_t::get_load_handler"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, get_load_handler) - 64usize];
    ["Offset of field: _cef_render_process_handler_t::on_context_created"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, on_context_created) - 72usize];
    ["Offset of field: _cef_render_process_handler_t::on_context_released"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, on_context_released) - 80usize];
    ["Offset of field: _cef_render_process_handler_t::on_uncaught_exception"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, on_uncaught_exception) - 88usize];
    ["Offset of field: _cef_render_process_handler_t::on_focused_node_changed"]
        [::std::mem::offset_of!(_cef_render_process_handler_t, on_focused_node_changed) - 96usize];
    ["Offset of field: _cef_render_process_handler_t::on_process_message_received"][::std::mem::offset_of!(
        _cef_render_process_handler_t,
        on_process_message_received
    ) - 104usize];
};
#[doc = "\n Structure used to implement render process callbacks. The functions of this\n structure will be called on the render process main thread (TID_RENDERER)\n unless otherwise indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_render_process_handler_t = _cef_render_process_handler_t;
#[doc = "\n Structure used to implement a custom resource bundle structure. See\n CefSettings for additional options related to resource bundle loading. The\n functions of this structure may be called on multiple threads.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_resource_bundle_handler_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Called to retrieve a localized translation for the specified |string_id|.\n To provide the translation set |string| to the translation string and\n return true (1). To use the default translation return false (0). Use the\n cef_id_for_pack_string_name() function for version-safe mapping of string\n IDS names from cef_pack_strings.h to version-specific numerical\n |string_id| values.\n"]
    pub get_localized_string: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_bundle_handler_t,
            string_id: ::std::os::raw::c_int,
            string: *mut cef_string_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to retrieve data for the specified scale independent |resource_id|.\n To provide the resource data set |data| and |data_size| to the data\n pointer and size respectively and return true (1). To use the default\n resource data return false (0). The resource data will not be copied and\n must remain resident in memory. Use the cef_id_for_pack_resource_name()\n function for version-safe mapping of resource IDR names from\n cef_pack_resources.h to version-specific numerical |resource_id| values.\n"]
    pub get_data_resource: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_bundle_handler_t,
            resource_id: ::std::os::raw::c_int,
            data: *mut *mut ::std::os::raw::c_void,
            data_size: *mut usize,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called to retrieve data for the specified |resource_id| nearest the scale\n factor |scale_factor|. To provide the resource data set |data| and\n |data_size| to the data pointer and size respectively and return true (1).\n To use the default resource data return false (0). The resource data will\n not be copied and must remain resident in memory. Use the\n cef_id_for_pack_resource_name() function for version-safe mapping of\n resource IDR names from cef_pack_resources.h to version-specific numerical\n |resource_id| values.\n"]
    pub get_data_resource_for_scale: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_resource_bundle_handler_t,
            resource_id: ::std::os::raw::c_int,
            scale_factor: cef_scale_factor_t,
            data: *mut *mut ::std::os::raw::c_void,
            data_size: *mut usize,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_resource_bundle_handler_t"]
        [::std::mem::size_of::<_cef_resource_bundle_handler_t>() - 64usize];
    ["Alignment of _cef_resource_bundle_handler_t"]
        [::std::mem::align_of::<_cef_resource_bundle_handler_t>() - 8usize];
    ["Offset of field: _cef_resource_bundle_handler_t::base"]
        [::std::mem::offset_of!(_cef_resource_bundle_handler_t, base) - 0usize];
    ["Offset of field: _cef_resource_bundle_handler_t::get_localized_string"]
        [::std::mem::offset_of!(_cef_resource_bundle_handler_t, get_localized_string) - 40usize];
    ["Offset of field: _cef_resource_bundle_handler_t::get_data_resource"]
        [::std::mem::offset_of!(_cef_resource_bundle_handler_t, get_data_resource) - 48usize];
    ["Offset of field: _cef_resource_bundle_handler_t::get_data_resource_for_scale"][::std::mem::offset_of!(
        _cef_resource_bundle_handler_t,
        get_data_resource_for_scale
    ) - 56usize];
};
#[doc = "\n Structure used to implement a custom resource bundle structure. See\n CefSettings for additional options related to resource bundle loading. The\n functions of this structure may be called on multiple threads.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_resource_bundle_handler_t = _cef_resource_bundle_handler_t;
#[doc = "\n Structure that manages custom scheme registrations.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_scheme_registrar_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_scoped_t,
    #[doc = "\n Register a custom scheme. This function should not be called for the\n built-in HTTP, HTTPS, FILE, FTP, ABOUT and DATA schemes.\n\n See cef_scheme_options_t for possible values for |options|.\n\n This function may be called on any thread. It should only be called once\n per unique |scheme_name| value. If |scheme_name| is already registered or\n if an error occurs this function will return false (0).\n"]
    pub add_custom_scheme: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_scheme_registrar_t,
            scheme_name: *const cef_string_t,
            options: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_scheme_registrar_t"][::std::mem::size_of::<_cef_scheme_registrar_t>() - 24usize];
    ["Alignment of _cef_scheme_registrar_t"]
        [::std::mem::align_of::<_cef_scheme_registrar_t>() - 8usize];
    ["Offset of field: _cef_scheme_registrar_t::base"]
        [::std::mem::offset_of!(_cef_scheme_registrar_t, base) - 0usize];
    ["Offset of field: _cef_scheme_registrar_t::add_custom_scheme"]
        [::std::mem::offset_of!(_cef_scheme_registrar_t, add_custom_scheme) - 16usize];
};
#[doc = "\n Structure that manages custom scheme registrations.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_scheme_registrar_t = _cef_scheme_registrar_t;
#[doc = "\n Structure that creates cef_resource_handler_t instances for handling scheme\n requests. The functions of this structure will always be called on the IO\n thread.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_scheme_handler_factory_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Return a new resource handler instance to handle the request or an NULL\n reference to allow default handling of the request. |browser| and |frame|\n will be the browser window and frame respectively that originated the\n request or NULL if the request did not originate from a browser window\n (for example, if the request came from cef_urlrequest_t). The |request|\n object passed to this function cannot be modified.\n"]
    pub create: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_scheme_handler_factory_t,
            browser: *mut _cef_browser_t,
            frame: *mut _cef_frame_t,
            scheme_name: *const cef_string_t,
            request: *mut _cef_request_t,
        ) -> *mut _cef_resource_handler_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_scheme_handler_factory_t"]
        [::std::mem::size_of::<_cef_scheme_handler_factory_t>() - 48usize];
    ["Alignment of _cef_scheme_handler_factory_t"]
        [::std::mem::align_of::<_cef_scheme_handler_factory_t>() - 8usize];
    ["Offset of field: _cef_scheme_handler_factory_t::base"]
        [::std::mem::offset_of!(_cef_scheme_handler_factory_t, base) - 0usize];
    ["Offset of field: _cef_scheme_handler_factory_t::create"]
        [::std::mem::offset_of!(_cef_scheme_handler_factory_t, create) - 40usize];
};
#[doc = "\n Structure that creates cef_resource_handler_t instances for handling scheme\n requests. The functions of this structure will always be called on the IO\n thread.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_scheme_handler_factory_t = _cef_scheme_handler_factory_t;
unsafe extern "C" {
    #[doc = "\n Register a scheme handler factory with the global request context. An NULL\n |domain_name| value for a standard scheme will cause the factory to match\n all domain names. The |domain_name| value will be ignored for non-standard\n schemes. If |scheme_name| is a built-in scheme and no handler is returned by\n |factory| then the built-in scheme handler factory will be called. If\n |scheme_name| is a custom scheme then you must also implement the\n cef_app_t::on_register_custom_schemes() function in all processes. This\n function may be called multiple times to change or remove the factory that\n matches the specified |scheme_name| and optional |domain_name|. Returns\n false (0) if an error occurs. This function may be called on any thread in\n the browser process. Using this function is equivalent to calling cef_reques\n t_context_t::cef_request_context_get_global_context()-\n >register_scheme_handler_factory().\n"]
    pub fn cef_register_scheme_handler_factory(
        scheme_name: *const cef_string_t,
        domain_name: *const cef_string_t,
        factory: *mut cef_scheme_handler_factory_t,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n Clear all scheme handler factories registered with the global request\n context. Returns false (0) on error. This function may be called on any\n thread in the browser process. Using this function is equivalent to calling\n cef_request_context_t::cef_request_context_get_global_context()-\n >clear_scheme_handler_factories().\n"]
    pub fn cef_clear_scheme_handler_factories() -> ::std::os::raw::c_int;
}
#[doc = "\n Implement this structure to provide handler implementations. Methods will be\n called by the process and/or thread indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_app_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Provides an opportunity to view and/or modify command-line arguments\n before processing by CEF and Chromium. The |process_type| value will be\n NULL for the browser process. Do not keep a reference to the\n cef_command_line_t object passed to this function. The\n cef_settings_t.command_line_args_disabled value can be used to start with\n an NULL command-line object. Any values specified in CefSettings that\n equate to command-line arguments will be set before this function is\n called. Be cautious when using this function to modify command-line\n arguments for non-browser processes as this may result in undefined\n behavior including crashes.\n"]
    pub on_before_command_line_processing: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_app_t,
            process_type: *const cef_string_t,
            command_line: *mut _cef_command_line_t,
        ),
    >,
    #[doc = "\n Provides an opportunity to register custom schemes. Do not keep a\n reference to the |registrar| object. This function is called on the main\n thread for each process and the registered schemes should be the same\n across all processes.\n"]
    pub on_register_custom_schemes: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_app_t, registrar: *mut _cef_scheme_registrar_t),
    >,
    #[doc = "\n Return the handler for resource bundle events. If no handler is returned\n resources will be loaded from pack files. This function is called by the\n browser and render processes on multiple threads.\n"]
    pub get_resource_bundle_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_app_t) -> *mut _cef_resource_bundle_handler_t,
    >,
    #[doc = "\n Return the handler for functionality specific to the browser process. This\n function is called on multiple threads in the browser process.\n"]
    pub get_browser_process_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_app_t) -> *mut _cef_browser_process_handler_t,
    >,
    #[doc = "\n Return the handler for functionality specific to the render process. This\n function is called on the render process main thread.\n"]
    pub get_render_process_handler: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_app_t) -> *mut _cef_render_process_handler_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_app_t"][::std::mem::size_of::<_cef_app_t>() - 80usize];
    ["Alignment of _cef_app_t"][::std::mem::align_of::<_cef_app_t>() - 8usize];
    ["Offset of field: _cef_app_t::base"][::std::mem::offset_of!(_cef_app_t, base) - 0usize];
    ["Offset of field: _cef_app_t::on_before_command_line_processing"]
        [::std::mem::offset_of!(_cef_app_t, on_before_command_line_processing) - 40usize];
    ["Offset of field: _cef_app_t::on_register_custom_schemes"]
        [::std::mem::offset_of!(_cef_app_t, on_register_custom_schemes) - 48usize];
    ["Offset of field: _cef_app_t::get_resource_bundle_handler"]
        [::std::mem::offset_of!(_cef_app_t, get_resource_bundle_handler) - 56usize];
    ["Offset of field: _cef_app_t::get_browser_process_handler"]
        [::std::mem::offset_of!(_cef_app_t, get_browser_process_handler) - 64usize];
    ["Offset of field: _cef_app_t::get_render_process_handler"]
        [::std::mem::offset_of!(_cef_app_t, get_render_process_handler) - 72usize];
};
#[doc = "\n Implement this structure to provide handler implementations. Methods will be\n called by the process and/or thread indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_app_t = _cef_app_t;
unsafe extern "C" {
    #[doc = "\n This function should be called from the application entry point function to\n execute a secondary process. It can be used to run secondary processes from\n the browser client executable (default behavior) or from a separate\n executable specified by the cef_settings_t.browser_subprocess_path value. If\n called for the browser process (identified by no \"type\" command-line value)\n it will return immediately with a value of -1. If called for a recognized\n secondary process it will block until the process should exit and then\n return the process exit code. The |application| parameter may be NULL. The\n |windows_sandbox_info| parameter is only used on Windows and may be NULL\n (see cef_sandbox_win.h for details).\n"]
    pub fn cef_execute_process(
        args: *const cef_main_args_t,
        application: *mut cef_app_t,
        windows_sandbox_info: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n This function should be called on the main application thread to initialize\n the CEF browser process. The |application| parameter may be NULL. Returns\n true (1) if initialization succeeds. Returns false (0) if initialization\n fails or if early exit is desired (for example, due to process singleton\n relaunch behavior). If this function returns false (0) then the application\n should exit immediately without calling any other CEF functions except,\n optionally, CefGetExitCode. The |windows_sandbox_info| parameter is only\n used on Windows and may be NULL (see cef_sandbox_win.h for details).\n"]
    pub fn cef_initialize(
        args: *const cef_main_args_t,
        settings: *const _cef_settings_t,
        application: *mut cef_app_t,
        windows_sandbox_info: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n This function can optionally be called on the main application thread after\n CefInitialize to retrieve the initialization exit code. When CefInitialize\n returns true (1) the exit code will be 0 (CEF_RESULT_CODE_NORMAL_EXIT).\n Otherwise, see cef_resultcode_t for possible exit code values including\n browser process initialization errors and normal early exit conditions (such\n as CEF_RESULT_CODE_NORMAL_EXIT_PROCESS_NOTIFIED for process singleton\n relaunch behavior).\n"]
    pub fn cef_get_exit_code() -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = "\n This function should be called on the main application thread to shut down\n the CEF browser process before the application exits. Do not call any other\n CEF functions after calling this function.\n"]
    pub fn cef_shutdown();
}
unsafe extern "C" {
    #[doc = "\n Perform a single iteration of CEF message loop processing. This function is\n provided for cases where the CEF message loop must be integrated into an\n existing application message loop. Use of this function is not recommended\n for most users; use either the cef_run_message_loop() function or\n cef_settings_t.multi_threaded_message_loop if possible. When using this\n function care must be taken to balance performance against excessive CPU\n usage. It is recommended to enable the cef_settings_t.external_message_pump\n option when using this function so that\n cef_browser_process_handler_t::on_schedule_message_pump_work() callbacks can\n facilitate the scheduling process. This function should only be called on\n the main application thread and only if cef_initialize() is called with a\n cef_settings_t.multi_threaded_message_loop value of false (0). This function\n will not block.\n"]
    pub fn cef_do_message_loop_work();
}
unsafe extern "C" {
    #[doc = "\n Run the CEF message loop. Use this function instead of an application-\n provided message loop to get the best balance between performance and CPU\n usage. This function should only be called on the main application thread\n and only if cef_initialize() is called with a\n cef_settings_t.multi_threaded_message_loop value of false (0). This function\n will block until a quit message is received by the system.\n"]
    pub fn cef_run_message_loop();
}
unsafe extern "C" {
    #[doc = "\n Quit the CEF message loop that was started by calling\n cef_run_message_loop(). This function should only be called on the main\n application thread and only if cef_run_message_loop() was used.\n"]
    pub fn cef_quit_message_loop();
}
#[doc = "\n Structure used to make a URL request. URL requests are not associated with a\n browser instance so no cef_client_t callbacks will be executed. URL requests\n can be created on any valid CEF thread in either the browser or render\n process. Once created the functions of the URL request object must be\n accessed on the same thread that created it.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_urlrequest_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns the request object used to create this URL request. The returned\n object is read-only and should not be modified.\n"]
    pub get_request: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_urlrequest_t) -> *mut _cef_request_t,
    >,
    #[doc = "\n Returns the client.\n"]
    pub get_client: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_urlrequest_t) -> *mut _cef_urlrequest_client_t,
    >,
    #[doc = "\n Returns the request status.\n"]
    pub get_request_status: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_urlrequest_t) -> cef_urlrequest_status_t,
    >,
    #[doc = "\n Returns the request error if status is UR_CANCELED or UR_FAILED, or 0\n otherwise.\n"]
    pub get_request_error: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_urlrequest_t) -> cef_errorcode_t,
    >,
    #[doc = "\n Returns the response, or NULL if no response information is available.\n Response information will only be available after the upload has\n completed. The returned object is read-only and should not be modified.\n"]
    pub get_response: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_urlrequest_t) -> *mut _cef_response_t,
    >,
    #[doc = "\n Returns true (1) if the response body was served from the cache. This\n includes responses for which revalidation was required.\n"]
    pub response_was_cached: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_urlrequest_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Cancel the request.\n"]
    pub cancel: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_urlrequest_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_urlrequest_t"][::std::mem::size_of::<_cef_urlrequest_t>() - 96usize];
    ["Alignment of _cef_urlrequest_t"][::std::mem::align_of::<_cef_urlrequest_t>() - 8usize];
    ["Offset of field: _cef_urlrequest_t::base"]
        [::std::mem::offset_of!(_cef_urlrequest_t, base) - 0usize];
    ["Offset of field: _cef_urlrequest_t::get_request"]
        [::std::mem::offset_of!(_cef_urlrequest_t, get_request) - 40usize];
    ["Offset of field: _cef_urlrequest_t::get_client"]
        [::std::mem::offset_of!(_cef_urlrequest_t, get_client) - 48usize];
    ["Offset of field: _cef_urlrequest_t::get_request_status"]
        [::std::mem::offset_of!(_cef_urlrequest_t, get_request_status) - 56usize];
    ["Offset of field: _cef_urlrequest_t::get_request_error"]
        [::std::mem::offset_of!(_cef_urlrequest_t, get_request_error) - 64usize];
    ["Offset of field: _cef_urlrequest_t::get_response"]
        [::std::mem::offset_of!(_cef_urlrequest_t, get_response) - 72usize];
    ["Offset of field: _cef_urlrequest_t::response_was_cached"]
        [::std::mem::offset_of!(_cef_urlrequest_t, response_was_cached) - 80usize];
    ["Offset of field: _cef_urlrequest_t::cancel"]
        [::std::mem::offset_of!(_cef_urlrequest_t, cancel) - 88usize];
};
#[doc = "\n Structure used to make a URL request. URL requests are not associated with a\n browser instance so no cef_client_t callbacks will be executed. URL requests\n can be created on any valid CEF thread in either the browser or render\n process. Once created the functions of the URL request object must be\n accessed on the same thread that created it.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_urlrequest_t = _cef_urlrequest_t;
unsafe extern "C" {
    #[doc = "\n Create a new URL request that is not associated with a specific browser or\n frame. Use cef_frame_t::CreateURLRequest instead if you want the request to\n have this association, in which case it may be handled differently (see\n documentation on that function). A request created with this function may\n only originate from the browser process, and will behave as follows:\n   - It may be intercepted by the client via CefResourceRequestHandler or\n     CefSchemeHandlerFactory.\n   - POST data may only contain only a single element of type PDE_TYPE_FILE\n     or PDE_TYPE_BYTES.\n   - If |request_context| is empty the global request context will be used.\n\n The |request| object will be marked as read-only after calling this\n function.\n"]
    pub fn cef_urlrequest_create(
        request: *mut _cef_request_t,
        client: *mut _cef_urlrequest_client_t,
        request_context: *mut _cef_request_context_t,
    ) -> *mut cef_urlrequest_t;
}
#[doc = "\n Structure that should be implemented by the cef_urlrequest_t client. The\n functions of this structure will be called on the same thread that created\n the request unless otherwise documented.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_urlrequest_client_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Notifies the client that the request has completed. Use the\n cef_urlrequest_t::GetRequestStatus function to determine if the request\n was successful or not.\n"]
    pub on_request_complete: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_urlrequest_client_t, request: *mut _cef_urlrequest_t),
    >,
    #[doc = "\n Notifies the client of upload progress. |current| denotes the number of\n bytes sent so far and |total| is the total size of uploading data (or -1\n if chunked upload is enabled). This function will only be called if the\n UR_FLAG_REPORT_UPLOAD_PROGRESS flag is set on the request.\n"]
    pub on_upload_progress: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_urlrequest_client_t,
            request: *mut _cef_urlrequest_t,
            current: i64,
            total: i64,
        ),
    >,
    #[doc = "\n Notifies the client of download progress. |current| denotes the number of\n bytes received up to the call and |total| is the expected total size of\n the response (or -1 if not determined).\n"]
    pub on_download_progress: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_urlrequest_client_t,
            request: *mut _cef_urlrequest_t,
            current: i64,
            total: i64,
        ),
    >,
    #[doc = "\n Called when some part of the response is read. |data| contains the current\n bytes received since the last call. This function will not be called if\n the UR_FLAG_NO_DOWNLOAD_DATA flag is set on the request.\n"]
    pub on_download_data: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_urlrequest_client_t,
            request: *mut _cef_urlrequest_t,
            data: *const ::std::os::raw::c_void,
            data_length: usize,
        ),
    >,
    #[doc = "\n Called on the IO thread when the browser needs credentials from the user.\n |isProxy| indicates whether the host is a proxy server. |host| contains\n the hostname and |port| contains the port number. Return true (1) to\n continue the request and call cef_auth_callback_t::cont() when the\n authentication information is available. If the request has an associated\n browser/frame then returning false (0) will result in a call to\n GetAuthCredentials on the cef_request_handler_t associated with that\n browser, if any. Otherwise, returning false (0) will cancel the request\n immediately. This function will only be called for requests initiated from\n the browser process.\n"]
    pub get_auth_credentials: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_urlrequest_client_t,
            isProxy: ::std::os::raw::c_int,
            host: *const cef_string_t,
            port: ::std::os::raw::c_int,
            realm: *const cef_string_t,
            scheme: *const cef_string_t,
            callback: *mut _cef_auth_callback_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_urlrequest_client_t"]
        [::std::mem::size_of::<_cef_urlrequest_client_t>() - 80usize];
    ["Alignment of _cef_urlrequest_client_t"]
        [::std::mem::align_of::<_cef_urlrequest_client_t>() - 8usize];
    ["Offset of field: _cef_urlrequest_client_t::base"]
        [::std::mem::offset_of!(_cef_urlrequest_client_t, base) - 0usize];
    ["Offset of field: _cef_urlrequest_client_t::on_request_complete"]
        [::std::mem::offset_of!(_cef_urlrequest_client_t, on_request_complete) - 40usize];
    ["Offset of field: _cef_urlrequest_client_t::on_upload_progress"]
        [::std::mem::offset_of!(_cef_urlrequest_client_t, on_upload_progress) - 48usize];
    ["Offset of field: _cef_urlrequest_client_t::on_download_progress"]
        [::std::mem::offset_of!(_cef_urlrequest_client_t, on_download_progress) - 56usize];
    ["Offset of field: _cef_urlrequest_client_t::on_download_data"]
        [::std::mem::offset_of!(_cef_urlrequest_client_t, on_download_data) - 64usize];
    ["Offset of field: _cef_urlrequest_client_t::get_auth_credentials"]
        [::std::mem::offset_of!(_cef_urlrequest_client_t, get_auth_credentials) - 72usize];
};
#[doc = "\n Structure that should be implemented by the cef_urlrequest_t client. The\n functions of this structure will be called on the same thread that created\n the request unless otherwise documented.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_urlrequest_client_t = _cef_urlrequest_client_t;
#[doc = "\n A Layout handles the sizing of the children of a Panel according to\n implementation-specific heuristics. Methods must be called on the browser\n process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_layout_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns this Layout as a BoxLayout or NULL if this is not a BoxLayout.\n"]
    pub as_box_layout: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_layout_t) -> *mut _cef_box_layout_t,
    >,
    #[doc = "\n Returns this Layout as a FillLayout or NULL if this is not a FillLayout.\n"]
    pub as_fill_layout: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_layout_t) -> *mut _cef_fill_layout_t,
    >,
    #[doc = "\n Returns true (1) if this Layout is valid.\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_layout_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_layout_t"][::std::mem::size_of::<_cef_layout_t>() - 64usize];
    ["Alignment of _cef_layout_t"][::std::mem::align_of::<_cef_layout_t>() - 8usize];
    ["Offset of field: _cef_layout_t::base"][::std::mem::offset_of!(_cef_layout_t, base) - 0usize];
    ["Offset of field: _cef_layout_t::as_box_layout"]
        [::std::mem::offset_of!(_cef_layout_t, as_box_layout) - 40usize];
    ["Offset of field: _cef_layout_t::as_fill_layout"]
        [::std::mem::offset_of!(_cef_layout_t, as_fill_layout) - 48usize];
    ["Offset of field: _cef_layout_t::is_valid"]
        [::std::mem::offset_of!(_cef_layout_t, is_valid) - 56usize];
};
#[doc = "\n A Layout handles the sizing of the children of a Panel according to\n implementation-specific heuristics. Methods must be called on the browser\n process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_layout_t = _cef_layout_t;
#[doc = "\n A Layout manager that arranges child views vertically or horizontally in a\n side-by-side fashion with spacing around and between the child views. The\n child views are always sized according to their preferred size. If the\n host's bounds provide insufficient space, child views will be clamped.\n Excess space will not be distributed. Methods must be called on the browser\n process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_box_layout_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_layout_t,
    #[doc = "\n Set the flex weight for the given |view|. Using the preferred size as the\n basis, free space along the main axis is distributed to views in the ratio\n of their flex weights. Similarly, if the views will overflow the parent,\n space is subtracted in these ratios. A flex of 0 means this view is not\n resized. Flex values must not be negative.\n"]
    pub set_flex_for_view: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_box_layout_t,
            view: *mut _cef_view_t,
            flex: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Clears the flex for the given |view|, causing it to use the default flex\n specified via cef_box_layout_tSettings.default_flex.\n"]
    pub clear_flex_for_view: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_box_layout_t, view: *mut _cef_view_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_box_layout_t"][::std::mem::size_of::<_cef_box_layout_t>() - 80usize];
    ["Alignment of _cef_box_layout_t"][::std::mem::align_of::<_cef_box_layout_t>() - 8usize];
    ["Offset of field: _cef_box_layout_t::base"]
        [::std::mem::offset_of!(_cef_box_layout_t, base) - 0usize];
    ["Offset of field: _cef_box_layout_t::set_flex_for_view"]
        [::std::mem::offset_of!(_cef_box_layout_t, set_flex_for_view) - 64usize];
    ["Offset of field: _cef_box_layout_t::clear_flex_for_view"]
        [::std::mem::offset_of!(_cef_box_layout_t, clear_flex_for_view) - 72usize];
};
#[doc = "\n A Layout manager that arranges child views vertically or horizontally in a\n side-by-side fashion with spacing around and between the child views. The\n child views are always sized according to their preferred size. If the\n host's bounds provide insufficient space, child views will be clamped.\n Excess space will not be distributed. Methods must be called on the browser\n process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_box_layout_t = _cef_box_layout_t;
#[doc = "\n A simple Layout that causes the associated Panel's one child to be sized to\n match the bounds of its parent. Methods must be called on the browser\n process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_fill_layout_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_layout_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_fill_layout_t"][::std::mem::size_of::<_cef_fill_layout_t>() - 64usize];
    ["Alignment of _cef_fill_layout_t"][::std::mem::align_of::<_cef_fill_layout_t>() - 8usize];
    ["Offset of field: _cef_fill_layout_t::base"]
        [::std::mem::offset_of!(_cef_fill_layout_t, base) - 0usize];
};
#[doc = "\n A simple Layout that causes the associated Panel's one child to be sized to\n match the bounds of its parent. Methods must be called on the browser\n process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_fill_layout_t = _cef_fill_layout_t;
#[doc = "\n Implement this structure to handle view events. All size and position values\n are in density independent pixels (DIP) unless otherwise indicated. The\n functions of this structure will be called on the browser process UI thread\n unless otherwise indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_view_delegate_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Return the preferred size for |view|. The Layout will use this information\n to determine the display size.\n"]
    pub get_preferred_size: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_delegate_t,
            view: *mut _cef_view_t,
        ) -> cef_size_t,
    >,
    #[doc = "\n Return the minimum size for |view|.\n"]
    pub get_minimum_size: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_delegate_t,
            view: *mut _cef_view_t,
        ) -> cef_size_t,
    >,
    #[doc = "\n Return the maximum size for |view|.\n"]
    pub get_maximum_size: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_delegate_t,
            view: *mut _cef_view_t,
        ) -> cef_size_t,
    >,
    #[doc = "\n Return the height necessary to display |view| with the provided |width|.\n If not specified the result of get_preferred_size().height will be used by\n default. Override if |view|'s preferred height depends upon the width (for\n example, with Labels).\n"]
    pub get_height_for_width: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_delegate_t,
            view: *mut _cef_view_t,
            width: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when the parent of |view| has changed. If |view| is being added to\n |parent| then |added| will be true (1). If |view| is being removed from\n |parent| then |added| will be false (0). If |view| is being reparented the\n remove notification will be sent before the add notification. Do not\n modify the view hierarchy in this callback.\n"]
    pub on_parent_view_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_delegate_t,
            view: *mut _cef_view_t,
            added: ::std::os::raw::c_int,
            parent: *mut _cef_view_t,
        ),
    >,
    #[doc = "\n Called when a child of |view| has changed. If |child| is being added to\n |view| then |added| will be true (1). If |child| is being removed from\n |view| then |added| will be false (0). If |child| is being reparented the\n remove notification will be sent to the old parent before the add\n notification is sent to the new parent. Do not modify the view hierarchy\n in this callback.\n"]
    pub on_child_view_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_delegate_t,
            view: *mut _cef_view_t,
            added: ::std::os::raw::c_int,
            child: *mut _cef_view_t,
        ),
    >,
    #[doc = "\n Called when |view| is added or removed from the cef_window_t.\n"]
    pub on_window_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_delegate_t,
            view: *mut _cef_view_t,
            added: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Called when the layout of |view| has changed.\n"]
    pub on_layout_changed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_delegate_t,
            view: *mut _cef_view_t,
            new_bounds: *const cef_rect_t,
        ),
    >,
    #[doc = "\n Called when |view| gains focus.\n"]
    pub on_focus: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_delegate_t, view: *mut _cef_view_t),
    >,
    #[doc = "\n Called when |view| loses focus.\n"]
    pub on_blur: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_delegate_t, view: *mut _cef_view_t),
    >,
    #[doc = "\n Called when the theme for |view| has changed, after the new theme colors\n have already been applied. Views are notified via the component hierarchy\n in depth-first reverse order (children before parents).\n\n This will be called in the following cases:\n\n 1. When |view|, or a parent of |view|, is added to a Window. 2. When the\n native/OS or Chrome theme changes for the Window that contains\n    |view|. See CefWindowDelegate::OnThemeColorsChanged documentation.\n 3. When the client explicitly calls cef_window_t::ThemeChanged on the\n Window\n    that contains |view|.\n\n Optionally use this callback to override the new per-View theme colors by\n calling cef_view_t::SetBackgroundColor or the appropriate component-\n specific function. See cef_window_t::SetThemeColor documentation for how\n to customize additional Window theme colors.\n"]
    pub on_theme_changed: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_delegate_t, view: *mut _cef_view_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_view_delegate_t"][::std::mem::size_of::<_cef_view_delegate_t>() - 128usize];
    ["Alignment of _cef_view_delegate_t"][::std::mem::align_of::<_cef_view_delegate_t>() - 8usize];
    ["Offset of field: _cef_view_delegate_t::base"]
        [::std::mem::offset_of!(_cef_view_delegate_t, base) - 0usize];
    ["Offset of field: _cef_view_delegate_t::get_preferred_size"]
        [::std::mem::offset_of!(_cef_view_delegate_t, get_preferred_size) - 40usize];
    ["Offset of field: _cef_view_delegate_t::get_minimum_size"]
        [::std::mem::offset_of!(_cef_view_delegate_t, get_minimum_size) - 48usize];
    ["Offset of field: _cef_view_delegate_t::get_maximum_size"]
        [::std::mem::offset_of!(_cef_view_delegate_t, get_maximum_size) - 56usize];
    ["Offset of field: _cef_view_delegate_t::get_height_for_width"]
        [::std::mem::offset_of!(_cef_view_delegate_t, get_height_for_width) - 64usize];
    ["Offset of field: _cef_view_delegate_t::on_parent_view_changed"]
        [::std::mem::offset_of!(_cef_view_delegate_t, on_parent_view_changed) - 72usize];
    ["Offset of field: _cef_view_delegate_t::on_child_view_changed"]
        [::std::mem::offset_of!(_cef_view_delegate_t, on_child_view_changed) - 80usize];
    ["Offset of field: _cef_view_delegate_t::on_window_changed"]
        [::std::mem::offset_of!(_cef_view_delegate_t, on_window_changed) - 88usize];
    ["Offset of field: _cef_view_delegate_t::on_layout_changed"]
        [::std::mem::offset_of!(_cef_view_delegate_t, on_layout_changed) - 96usize];
    ["Offset of field: _cef_view_delegate_t::on_focus"]
        [::std::mem::offset_of!(_cef_view_delegate_t, on_focus) - 104usize];
    ["Offset of field: _cef_view_delegate_t::on_blur"]
        [::std::mem::offset_of!(_cef_view_delegate_t, on_blur) - 112usize];
    ["Offset of field: _cef_view_delegate_t::on_theme_changed"]
        [::std::mem::offset_of!(_cef_view_delegate_t, on_theme_changed) - 120usize];
};
#[doc = "\n Implement this structure to handle view events. All size and position values\n are in density independent pixels (DIP) unless otherwise indicated. The\n functions of this structure will be called on the browser process UI thread\n unless otherwise indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_view_delegate_t = _cef_view_delegate_t;
#[doc = "\n A View is a rectangle within the views View hierarchy. It is the base\n structure for all Views. All size and position values are in density\n independent pixels (DIP) unless otherwise indicated. Methods must be called\n on the browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_view_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
    #[doc = "\n Returns this View as a BrowserView or NULL if this is not a BrowserView.\n"]
    pub as_browser_view: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> *mut _cef_browser_view_t,
    >,
    #[doc = "\n Returns this View as a Button or NULL if this is not a Button.\n"]
    pub as_button:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> *mut _cef_button_t>,
    #[doc = "\n Returns this View as a Panel or NULL if this is not a Panel.\n"]
    pub as_panel:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> *mut _cef_panel_t>,
    #[doc = "\n Returns this View as a ScrollView or NULL if this is not a ScrollView.\n"]
    pub as_scroll_view: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> *mut _cef_scroll_view_t,
    >,
    #[doc = "\n Returns this View as a Textfield or NULL if this is not a Textfield.\n"]
    pub as_textfield: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> *mut _cef_textfield_t,
    >,
    #[doc = "\n Returns the type of this View as a string. Used primarily for testing\n purposes.\n"]
    pub get_type_string: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns a string representation of this View which includes the type and\n various type-specific identifying attributes. If |include_children| is\n true (1) any child Views will also be included. Used primarily for testing\n purposes.\n"]
    pub to_string: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            include_children: ::std::os::raw::c_int,
        ) -> cef_string_userfree_t,
    >,
    #[doc = "\n Returns true (1) if this View is valid.\n"]
    pub is_valid: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this View is currently attached to another View. A\n View can only be attached to one View at a time.\n"]
    pub is_attached: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this View is the same as |that| View.\n"]
    pub is_same: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            that: *mut _cef_view_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the delegate associated with this View, if any.\n"]
    pub get_delegate: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> *mut _cef_view_delegate_t,
    >,
    #[doc = "\n Returns the top-level Window hosting this View, if any.\n"]
    pub get_window:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> *mut _cef_window_t>,
    #[doc = "\n Returns the ID for this View.\n"]
    pub get_id: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets the ID for this View. ID should be unique within the subtree that you\n intend to search for it. 0 is the default ID for views.\n"]
    pub set_id: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, id: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns the group id of this View, or -1 if not set.\n"]
    pub get_group_id: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n A group id is used to tag Views which are part of the same logical group.\n Focus can be moved between views with the same group using the arrow keys.\n The group id is immutable once it's set.\n"]
    pub set_group_id: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, group_id: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns the View that contains this View, if any.\n"]
    pub get_parent_view:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> *mut _cef_view_t>,
    #[doc = "\n Recursively descends the view tree starting at this View, and returns the\n first child that it encounters with the given ID. Returns NULL if no\n matching child view is found.\n"]
    pub get_view_for_id: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            id: ::std::os::raw::c_int,
        ) -> *mut _cef_view_t,
    >,
    #[doc = "\n Sets the bounds (size and position) of this View. |bounds| is in parent\n coordinates, or DIP screen coordinates if there is no parent.\n"]
    pub set_bounds: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, bounds: *const cef_rect_t),
    >,
    #[doc = "\n Returns the bounds (size and position) of this View in parent coordinates,\n or DIP screen coordinates if there is no parent.\n"]
    pub get_bounds:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_rect_t>,
    #[doc = "\n Returns the bounds (size and position) of this View in DIP screen\n coordinates.\n"]
    pub get_bounds_in_screen:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_rect_t>,
    #[doc = "\n Sets the size of this View without changing the position. |size| in parent\n coordinates, or DIP screen coordinates if there is no parent.\n"]
    pub set_size: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, size: *const cef_size_t),
    >,
    #[doc = "\n Returns the size of this View in parent coordinates, or DIP screen\n coordinates if there is no parent.\n"]
    pub get_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_size_t>,
    #[doc = "\n Sets the position of this View without changing the size. |position| is in\n parent coordinates, or DIP screen coordinates if there is no parent.\n"]
    pub set_position: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, position: *const cef_point_t),
    >,
    #[doc = "\n Returns the position of this View. Position is in parent coordinates, or\n DIP screen coordinates if there is no parent.\n"]
    pub get_position:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_point_t>,
    #[doc = "\n Sets the insets for this View. |insets| is in parent coordinates, or DIP\n screen coordinates if there is no parent.\n"]
    pub set_insets: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, insets: *const cef_insets_t),
    >,
    #[doc = "\n Returns the insets for this View in parent coordinates, or DIP screen\n coordinates if there is no parent.\n"]
    pub get_insets:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_insets_t>,
    #[doc = "\n Returns the size this View would like to be if enough space is available.\n Size is in parent coordinates, or DIP screen coordinates if there is no\n parent.\n"]
    pub get_preferred_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_size_t>,
    #[doc = "\n Size this View to its preferred size. Size is in parent coordinates, or\n DIP screen coordinates if there is no parent.\n"]
    pub size_to_preferred_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t)>,
    #[doc = "\n Returns the minimum size for this View. Size is in parent coordinates, or\n DIP screen coordinates if there is no parent.\n"]
    pub get_minimum_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_size_t>,
    #[doc = "\n Returns the maximum size for this View. Size is in parent coordinates, or\n DIP screen coordinates if there is no parent.\n"]
    pub get_maximum_size:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_size_t>,
    #[doc = "\n Returns the height necessary to display this View with the provided width.\n"]
    pub get_height_for_width: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            width: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Indicate that this View and all parent Views require a re-layout. This\n ensures the next call to layout() will propagate to this View even if the\n bounds of parent Views do not change.\n"]
    pub invalidate_layout: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t)>,
    #[doc = "\n Sets whether this View is visible. Windows are hidden by default and other\n views are visible by default. This View and any parent views must be set\n as visible for this View to be drawn in a Window. If this View is set as\n hidden then it and any child views will not be drawn and, if any of those\n views currently have focus, then focus will also be cleared. Painting is\n scheduled as needed. If this View is a Window then calling this function\n is equivalent to calling the Window show() and hide() functions.\n"]
    pub set_visible: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, visible: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns whether this View is visible. A view may be visible but still not\n drawn in a Window if any parent views are hidden. If this View is a Window\n then a return value of true (1) indicates that this Window is currently\n visible to the user on-screen. If this View is not a Window then call\n is_drawn() to determine whether this View and all parent views are visible\n and will be drawn.\n"]
    pub is_visible: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns whether this View is visible and drawn in a Window. A view is\n drawn if it and all parent views are visible. If this View is a Window\n then calling this function is equivalent to calling is_visible().\n Otherwise, to determine if the containing Window is visible to the user\n on-screen call is_visible() on the Window.\n"]
    pub is_drawn: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Set whether this View is enabled. A disabled View does not receive\n keyboard or mouse inputs. If |enabled| differs from the current value the\n View will be repainted. Also, clears focus if the focused View is\n disabled.\n"]
    pub set_enabled: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, enabled: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns whether this View is enabled.\n"]
    pub is_enabled: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets whether this View is capable of taking focus. It will clear focus if\n the focused View is set to be non-focusable. This is false (0) by default\n so that a View used as a container does not get the focus.\n"]
    pub set_focusable: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t, focusable: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns true (1) if this View is focusable, enabled and drawn.\n"]
    pub is_focusable: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Return whether this View is focusable when the user requires full keyboard\n access, even though it may not be normally focusable.\n"]
    pub is_accessibility_focusable: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if this View has focus in the context of the containing\n Window. Check both this function and cef_window_t::IsActive to determine\n global keyboard focus.\n"]
    pub has_focus: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Request focus for this View in the context of the containing Window. If\n this View is focusable it will become the focused View. Any focus changes\n while a Window is not active may be applied after that Window next becomes\n active.\n"]
    pub request_focus: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t)>,
    #[doc = "\n Sets the background color for this View. The background color will be\n automatically reset when cef_view_delegate_t::OnThemeChanged is called.\n"]
    pub set_background_color:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t, color: cef_color_t)>,
    #[doc = "\n Returns the background color for this View. If the background color is\n unset then the current `GetThemeColor(CEF_ColorPrimaryBackground)` value\n will be returned. If this View belongs to an overlay (created with\n cef_window_t::AddOverlayView), and the background color is unset, then a\n value of transparent (0) will be returned.\n"]
    pub get_background_color:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_view_t) -> cef_color_t>,
    #[doc = "\n Returns the current theme color associated with |color_id|, or the\n placeholder color (red) if unset. See cef_color_ids.h for standard ID\n values. Standard colors can be overridden and custom colors can be added\n using cef_window_t::SetThemeColor.\n"]
    pub get_theme_color: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            color_id: ::std::os::raw::c_int,
        ) -> cef_color_t,
    >,
    #[doc = "\n Convert |point| from this View's coordinate system to DIP screen\n coordinates. This View must belong to a Window when calling this function.\n Returns true (1) if the conversion is successful or false (0) otherwise.\n Use cef_display_t::convert_point_to_pixels() after calling this function\n if further conversion to display-specific pixel coordinates is desired.\n"]
    pub convert_point_to_screen: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            point: *mut cef_point_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Convert |point| to this View's coordinate system from DIP screen\n coordinates. This View must belong to a Window when calling this function.\n Returns true (1) if the conversion is successful or false (0) otherwise.\n Use cef_display_t::convert_point_from_pixels() before calling this\n function if conversion from display-specific pixel coordinates is\n necessary.\n"]
    pub convert_point_from_screen: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            point: *mut cef_point_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Convert |point| from this View's coordinate system to that of the Window.\n This View must belong to a Window when calling this function. Returns true\n (1) if the conversion is successful or false (0) otherwise.\n"]
    pub convert_point_to_window: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            point: *mut cef_point_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Convert |point| to this View's coordinate system from that of the Window.\n This View must belong to a Window when calling this function. Returns true\n (1) if the conversion is successful or false (0) otherwise.\n"]
    pub convert_point_from_window: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            point: *mut cef_point_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Convert |point| from this View's coordinate system to that of |view|.\n |view| needs to be in the same Window but not necessarily the same view\n hierarchy. Returns true (1) if the conversion is successful or false (0)\n otherwise.\n"]
    pub convert_point_to_view: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            view: *mut _cef_view_t,
            point: *mut cef_point_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Convert |point| to this View's coordinate system from that |view|. |view|\n needs to be in the same Window but not necessarily the same view\n hierarchy. Returns true (1) if the conversion is successful or false (0)\n otherwise.\n"]
    pub convert_point_from_view: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_view_t,
            view: *mut _cef_view_t,
            point: *mut cef_point_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_view_t"][::std::mem::size_of::<_cef_view_t>() - 456usize];
    ["Alignment of _cef_view_t"][::std::mem::align_of::<_cef_view_t>() - 8usize];
    ["Offset of field: _cef_view_t::base"][::std::mem::offset_of!(_cef_view_t, base) - 0usize];
    ["Offset of field: _cef_view_t::as_browser_view"]
        [::std::mem::offset_of!(_cef_view_t, as_browser_view) - 40usize];
    ["Offset of field: _cef_view_t::as_button"]
        [::std::mem::offset_of!(_cef_view_t, as_button) - 48usize];
    ["Offset of field: _cef_view_t::as_panel"]
        [::std::mem::offset_of!(_cef_view_t, as_panel) - 56usize];
    ["Offset of field: _cef_view_t::as_scroll_view"]
        [::std::mem::offset_of!(_cef_view_t, as_scroll_view) - 64usize];
    ["Offset of field: _cef_view_t::as_textfield"]
        [::std::mem::offset_of!(_cef_view_t, as_textfield) - 72usize];
    ["Offset of field: _cef_view_t::get_type_string"]
        [::std::mem::offset_of!(_cef_view_t, get_type_string) - 80usize];
    ["Offset of field: _cef_view_t::to_string"]
        [::std::mem::offset_of!(_cef_view_t, to_string) - 88usize];
    ["Offset of field: _cef_view_t::is_valid"]
        [::std::mem::offset_of!(_cef_view_t, is_valid) - 96usize];
    ["Offset of field: _cef_view_t::is_attached"]
        [::std::mem::offset_of!(_cef_view_t, is_attached) - 104usize];
    ["Offset of field: _cef_view_t::is_same"]
        [::std::mem::offset_of!(_cef_view_t, is_same) - 112usize];
    ["Offset of field: _cef_view_t::get_delegate"]
        [::std::mem::offset_of!(_cef_view_t, get_delegate) - 120usize];
    ["Offset of field: _cef_view_t::get_window"]
        [::std::mem::offset_of!(_cef_view_t, get_window) - 128usize];
    ["Offset of field: _cef_view_t::get_id"]
        [::std::mem::offset_of!(_cef_view_t, get_id) - 136usize];
    ["Offset of field: _cef_view_t::set_id"]
        [::std::mem::offset_of!(_cef_view_t, set_id) - 144usize];
    ["Offset of field: _cef_view_t::get_group_id"]
        [::std::mem::offset_of!(_cef_view_t, get_group_id) - 152usize];
    ["Offset of field: _cef_view_t::set_group_id"]
        [::std::mem::offset_of!(_cef_view_t, set_group_id) - 160usize];
    ["Offset of field: _cef_view_t::get_parent_view"]
        [::std::mem::offset_of!(_cef_view_t, get_parent_view) - 168usize];
    ["Offset of field: _cef_view_t::get_view_for_id"]
        [::std::mem::offset_of!(_cef_view_t, get_view_for_id) - 176usize];
    ["Offset of field: _cef_view_t::set_bounds"]
        [::std::mem::offset_of!(_cef_view_t, set_bounds) - 184usize];
    ["Offset of field: _cef_view_t::get_bounds"]
        [::std::mem::offset_of!(_cef_view_t, get_bounds) - 192usize];
    ["Offset of field: _cef_view_t::get_bounds_in_screen"]
        [::std::mem::offset_of!(_cef_view_t, get_bounds_in_screen) - 200usize];
    ["Offset of field: _cef_view_t::set_size"]
        [::std::mem::offset_of!(_cef_view_t, set_size) - 208usize];
    ["Offset of field: _cef_view_t::get_size"]
        [::std::mem::offset_of!(_cef_view_t, get_size) - 216usize];
    ["Offset of field: _cef_view_t::set_position"]
        [::std::mem::offset_of!(_cef_view_t, set_position) - 224usize];
    ["Offset of field: _cef_view_t::get_position"]
        [::std::mem::offset_of!(_cef_view_t, get_position) - 232usize];
    ["Offset of field: _cef_view_t::set_insets"]
        [::std::mem::offset_of!(_cef_view_t, set_insets) - 240usize];
    ["Offset of field: _cef_view_t::get_insets"]
        [::std::mem::offset_of!(_cef_view_t, get_insets) - 248usize];
    ["Offset of field: _cef_view_t::get_preferred_size"]
        [::std::mem::offset_of!(_cef_view_t, get_preferred_size) - 256usize];
    ["Offset of field: _cef_view_t::size_to_preferred_size"]
        [::std::mem::offset_of!(_cef_view_t, size_to_preferred_size) - 264usize];
    ["Offset of field: _cef_view_t::get_minimum_size"]
        [::std::mem::offset_of!(_cef_view_t, get_minimum_size) - 272usize];
    ["Offset of field: _cef_view_t::get_maximum_size"]
        [::std::mem::offset_of!(_cef_view_t, get_maximum_size) - 280usize];
    ["Offset of field: _cef_view_t::get_height_for_width"]
        [::std::mem::offset_of!(_cef_view_t, get_height_for_width) - 288usize];
    ["Offset of field: _cef_view_t::invalidate_layout"]
        [::std::mem::offset_of!(_cef_view_t, invalidate_layout) - 296usize];
    ["Offset of field: _cef_view_t::set_visible"]
        [::std::mem::offset_of!(_cef_view_t, set_visible) - 304usize];
    ["Offset of field: _cef_view_t::is_visible"]
        [::std::mem::offset_of!(_cef_view_t, is_visible) - 312usize];
    ["Offset of field: _cef_view_t::is_drawn"]
        [::std::mem::offset_of!(_cef_view_t, is_drawn) - 320usize];
    ["Offset of field: _cef_view_t::set_enabled"]
        [::std::mem::offset_of!(_cef_view_t, set_enabled) - 328usize];
    ["Offset of field: _cef_view_t::is_enabled"]
        [::std::mem::offset_of!(_cef_view_t, is_enabled) - 336usize];
    ["Offset of field: _cef_view_t::set_focusable"]
        [::std::mem::offset_of!(_cef_view_t, set_focusable) - 344usize];
    ["Offset of field: _cef_view_t::is_focusable"]
        [::std::mem::offset_of!(_cef_view_t, is_focusable) - 352usize];
    ["Offset of field: _cef_view_t::is_accessibility_focusable"]
        [::std::mem::offset_of!(_cef_view_t, is_accessibility_focusable) - 360usize];
    ["Offset of field: _cef_view_t::has_focus"]
        [::std::mem::offset_of!(_cef_view_t, has_focus) - 368usize];
    ["Offset of field: _cef_view_t::request_focus"]
        [::std::mem::offset_of!(_cef_view_t, request_focus) - 376usize];
    ["Offset of field: _cef_view_t::set_background_color"]
        [::std::mem::offset_of!(_cef_view_t, set_background_color) - 384usize];
    ["Offset of field: _cef_view_t::get_background_color"]
        [::std::mem::offset_of!(_cef_view_t, get_background_color) - 392usize];
    ["Offset of field: _cef_view_t::get_theme_color"]
        [::std::mem::offset_of!(_cef_view_t, get_theme_color) - 400usize];
    ["Offset of field: _cef_view_t::convert_point_to_screen"]
        [::std::mem::offset_of!(_cef_view_t, convert_point_to_screen) - 408usize];
    ["Offset of field: _cef_view_t::convert_point_from_screen"]
        [::std::mem::offset_of!(_cef_view_t, convert_point_from_screen) - 416usize];
    ["Offset of field: _cef_view_t::convert_point_to_window"]
        [::std::mem::offset_of!(_cef_view_t, convert_point_to_window) - 424usize];
    ["Offset of field: _cef_view_t::convert_point_from_window"]
        [::std::mem::offset_of!(_cef_view_t, convert_point_from_window) - 432usize];
    ["Offset of field: _cef_view_t::convert_point_to_view"]
        [::std::mem::offset_of!(_cef_view_t, convert_point_to_view) - 440usize];
    ["Offset of field: _cef_view_t::convert_point_from_view"]
        [::std::mem::offset_of!(_cef_view_t, convert_point_from_view) - 448usize];
};
#[doc = "\n A View is a rectangle within the views View hierarchy. It is the base\n structure for all Views. All size and position values are in density\n independent pixels (DIP) unless otherwise indicated. Methods must be called\n on the browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_view_t = _cef_view_t;
#[doc = "\n A View representing a button. Depending on the specific type, the button\n could be implemented by a native control or custom rendered. Methods must be\n called on the browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_button_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_view_t,
    #[doc = "\n Returns this Button as a LabelButton or NULL if this is not a LabelButton.\n"]
    pub as_label_button: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_button_t) -> *mut _cef_label_button_t,
    >,
    #[doc = "\n Sets the current display state of the Button.\n"]
    pub set_state: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_button_t, state: cef_button_state_t),
    >,
    #[doc = "\n Returns the current display state of the Button.\n"]
    pub get_state: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_button_t) -> cef_button_state_t,
    >,
    #[doc = "\n Sets the Button will use an ink drop effect for displaying state changes.\n"]
    pub set_ink_drop_enabled: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_button_t, enabled: ::std::os::raw::c_int),
    >,
    #[doc = "\n Sets the tooltip text that will be displayed when the user hovers the\n mouse cursor over the Button.\n"]
    pub set_tooltip_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_button_t, tooltip_text: *const cef_string_t),
    >,
    #[doc = "\n Sets the accessible name that will be exposed to assistive technology\n (AT).\n"]
    pub set_accessible_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_button_t, name: *const cef_string_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_button_t"][::std::mem::size_of::<_cef_button_t>() - 504usize];
    ["Alignment of _cef_button_t"][::std::mem::align_of::<_cef_button_t>() - 8usize];
    ["Offset of field: _cef_button_t::base"][::std::mem::offset_of!(_cef_button_t, base) - 0usize];
    ["Offset of field: _cef_button_t::as_label_button"]
        [::std::mem::offset_of!(_cef_button_t, as_label_button) - 456usize];
    ["Offset of field: _cef_button_t::set_state"]
        [::std::mem::offset_of!(_cef_button_t, set_state) - 464usize];
    ["Offset of field: _cef_button_t::get_state"]
        [::std::mem::offset_of!(_cef_button_t, get_state) - 472usize];
    ["Offset of field: _cef_button_t::set_ink_drop_enabled"]
        [::std::mem::offset_of!(_cef_button_t, set_ink_drop_enabled) - 480usize];
    ["Offset of field: _cef_button_t::set_tooltip_text"]
        [::std::mem::offset_of!(_cef_button_t, set_tooltip_text) - 488usize];
    ["Offset of field: _cef_button_t::set_accessible_name"]
        [::std::mem::offset_of!(_cef_button_t, set_accessible_name) - 496usize];
};
#[doc = "\n A View representing a button. Depending on the specific type, the button\n could be implemented by a native control or custom rendered. Methods must be\n called on the browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_button_t = _cef_button_t;
#[doc = "\n Implement this structure to handle Button events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_button_delegate_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_view_delegate_t,
    #[doc = "\n Called when |button| is pressed.\n"]
    pub on_button_pressed: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_button_delegate_t, button: *mut _cef_button_t),
    >,
    #[doc = "\n Called when the state of |button| changes.\n"]
    pub on_button_state_changed: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_button_delegate_t, button: *mut _cef_button_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_button_delegate_t"][::std::mem::size_of::<_cef_button_delegate_t>() - 144usize];
    ["Alignment of _cef_button_delegate_t"]
        [::std::mem::align_of::<_cef_button_delegate_t>() - 8usize];
    ["Offset of field: _cef_button_delegate_t::base"]
        [::std::mem::offset_of!(_cef_button_delegate_t, base) - 0usize];
    ["Offset of field: _cef_button_delegate_t::on_button_pressed"]
        [::std::mem::offset_of!(_cef_button_delegate_t, on_button_pressed) - 128usize];
    ["Offset of field: _cef_button_delegate_t::on_button_state_changed"]
        [::std::mem::offset_of!(_cef_button_delegate_t, on_button_state_changed) - 136usize];
};
#[doc = "\n Implement this structure to handle Button events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_button_delegate_t = _cef_button_delegate_t;
#[doc = "\n LabelButton is a button with optional text and/or icon. Methods must be\n called on the browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_label_button_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_button_t,
    #[doc = "\n Returns this LabelButton as a MenuButton or NULL if this is not a\n MenuButton.\n"]
    pub as_menu_button: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_label_button_t) -> *mut _cef_menu_button_t,
    >,
    #[doc = "\n Sets the text shown on the LabelButton. By default |text| will also be\n used as the accessible name.\n"]
    pub set_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_label_button_t, text: *const cef_string_t),
    >,
    #[doc = "\n Returns the text shown on the LabelButton.\n"]
    pub get_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_label_button_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Sets the image shown for |button_state|. When this Button is drawn if no\n image exists for the current state then the image for\n CEF_BUTTON_STATE_NORMAL, if any, will be shown.\n"]
    pub set_image: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_label_button_t,
            button_state: cef_button_state_t,
            image: *mut _cef_image_t,
        ),
    >,
    #[doc = "\n Returns the image shown for |button_state|. If no image exists for that\n state then the image for CEF_BUTTON_STATE_NORMAL will be returned.\n"]
    pub get_image: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_label_button_t,
            button_state: cef_button_state_t,
        ) -> *mut _cef_image_t,
    >,
    #[doc = "\n Sets the text color shown for the specified button |for_state| to |color|.\n"]
    pub set_text_color: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_label_button_t,
            for_state: cef_button_state_t,
            color: cef_color_t,
        ),
    >,
    #[doc = "\n Sets the text colors shown for the non-disabled states to |color|.\n"]
    pub set_enabled_text_colors: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_label_button_t, color: cef_color_t),
    >,
    #[doc = "\n Sets the font list. The format is \"<FONT_FAMILY_LIST>,[STYLES] <SIZE>\",\n where:\n - FONT_FAMILY_LIST is a comma-separated list of font family names,\n - STYLES is an optional space-separated list of style names (case-\n   sensitive \"Bold\" and \"Italic\" are supported), and\n - SIZE is an integer font size in pixels with the suffix \"px\".\n\n Here are examples of valid font description strings:\n - \"Arial, Helvetica, Bold Italic 14px\"\n - \"Arial, 14px\"\n"]
    pub set_font_list: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_label_button_t, font_list: *const cef_string_t),
    >,
    #[doc = "\n Sets the horizontal alignment; reversed in RTL. Default is\n CEF_HORIZONTAL_ALIGNMENT_CENTER.\n"]
    pub set_horizontal_alignment: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_label_button_t,
            alignment: cef_horizontal_alignment_t,
        ),
    >,
    #[doc = "\n Reset the minimum size of this LabelButton to |size|.\n"]
    pub set_minimum_size: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_label_button_t, size: *const cef_size_t),
    >,
    #[doc = "\n Reset the maximum size of this LabelButton to |size|.\n"]
    pub set_maximum_size: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_label_button_t, size: *const cef_size_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_label_button_t"][::std::mem::size_of::<_cef_label_button_t>() - 592usize];
    ["Alignment of _cef_label_button_t"][::std::mem::align_of::<_cef_label_button_t>() - 8usize];
    ["Offset of field: _cef_label_button_t::base"]
        [::std::mem::offset_of!(_cef_label_button_t, base) - 0usize];
    ["Offset of field: _cef_label_button_t::as_menu_button"]
        [::std::mem::offset_of!(_cef_label_button_t, as_menu_button) - 504usize];
    ["Offset of field: _cef_label_button_t::set_text"]
        [::std::mem::offset_of!(_cef_label_button_t, set_text) - 512usize];
    ["Offset of field: _cef_label_button_t::get_text"]
        [::std::mem::offset_of!(_cef_label_button_t, get_text) - 520usize];
    ["Offset of field: _cef_label_button_t::set_image"]
        [::std::mem::offset_of!(_cef_label_button_t, set_image) - 528usize];
    ["Offset of field: _cef_label_button_t::get_image"]
        [::std::mem::offset_of!(_cef_label_button_t, get_image) - 536usize];
    ["Offset of field: _cef_label_button_t::set_text_color"]
        [::std::mem::offset_of!(_cef_label_button_t, set_text_color) - 544usize];
    ["Offset of field: _cef_label_button_t::set_enabled_text_colors"]
        [::std::mem::offset_of!(_cef_label_button_t, set_enabled_text_colors) - 552usize];
    ["Offset of field: _cef_label_button_t::set_font_list"]
        [::std::mem::offset_of!(_cef_label_button_t, set_font_list) - 560usize];
    ["Offset of field: _cef_label_button_t::set_horizontal_alignment"]
        [::std::mem::offset_of!(_cef_label_button_t, set_horizontal_alignment) - 568usize];
    ["Offset of field: _cef_label_button_t::set_minimum_size"]
        [::std::mem::offset_of!(_cef_label_button_t, set_minimum_size) - 576usize];
    ["Offset of field: _cef_label_button_t::set_maximum_size"]
        [::std::mem::offset_of!(_cef_label_button_t, set_maximum_size) - 584usize];
};
#[doc = "\n LabelButton is a button with optional text and/or icon. Methods must be\n called on the browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_label_button_t = _cef_label_button_t;
unsafe extern "C" {
    #[doc = "\n Create a new LabelButton. A |delegate| must be provided to handle the button\n click. |text| will be shown on the LabelButton and used as the default\n accessible name.\n"]
    pub fn cef_label_button_create(
        delegate: *mut _cef_button_delegate_t,
        text: *const cef_string_t,
    ) -> *mut cef_label_button_t;
}
#[doc = "\n MenuButton pressed lock is released when this object is destroyed.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_menu_button_pressed_lock_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_base_ref_counted_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_menu_button_pressed_lock_t"]
        [::std::mem::size_of::<_cef_menu_button_pressed_lock_t>() - 40usize];
    ["Alignment of _cef_menu_button_pressed_lock_t"]
        [::std::mem::align_of::<_cef_menu_button_pressed_lock_t>() - 8usize];
    ["Offset of field: _cef_menu_button_pressed_lock_t::base"]
        [::std::mem::offset_of!(_cef_menu_button_pressed_lock_t, base) - 0usize];
};
#[doc = "\n MenuButton pressed lock is released when this object is destroyed.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_menu_button_pressed_lock_t = _cef_menu_button_pressed_lock_t;
#[doc = "\n Implement this structure to handle MenuButton events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_menu_button_delegate_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_button_delegate_t,
    #[doc = "\n Called when |button| is pressed. Call cef_menu_button_t::show_menu() to\n show a popup menu at |screen_point|. When showing a custom popup such as a\n window keep a reference to |button_pressed_lock| until the popup is hidden\n to maintain the pressed button state.\n"]
    pub on_menu_button_pressed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_button_delegate_t,
            menu_button: *mut _cef_menu_button_t,
            screen_point: *const cef_point_t,
            button_pressed_lock: *mut _cef_menu_button_pressed_lock_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_menu_button_delegate_t"]
        [::std::mem::size_of::<_cef_menu_button_delegate_t>() - 152usize];
    ["Alignment of _cef_menu_button_delegate_t"]
        [::std::mem::align_of::<_cef_menu_button_delegate_t>() - 8usize];
    ["Offset of field: _cef_menu_button_delegate_t::base"]
        [::std::mem::offset_of!(_cef_menu_button_delegate_t, base) - 0usize];
    ["Offset of field: _cef_menu_button_delegate_t::on_menu_button_pressed"]
        [::std::mem::offset_of!(_cef_menu_button_delegate_t, on_menu_button_pressed) - 144usize];
};
#[doc = "\n Implement this structure to handle MenuButton events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_menu_button_delegate_t = _cef_menu_button_delegate_t;
#[doc = "\n MenuButton is a button with optional text, icon and/or menu marker that\n shows a menu when clicked with the left mouse button. All size and position\n values are in density independent pixels (DIP) unless otherwise indicated.\n Methods must be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_menu_button_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_label_button_t,
    #[doc = "\n Show a menu with contents |menu_model|. |screen_point| specifies the menu\n position in screen coordinates. |anchor_position| specifies how the menu\n will be anchored relative to |screen_point|. This function should be\n called from cef_menu_button_delegate_t::on_menu_button_pressed().\n"]
    pub show_menu: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_menu_button_t,
            menu_model: *mut _cef_menu_model_t,
            screen_point: *const cef_point_t,
            anchor_position: cef_menu_anchor_position_t,
        ),
    >,
    #[doc = "\n Show the menu for this button. Results in a call to\n cef_menu_button_delegate_t::on_menu_button_pressed().\n"]
    pub trigger_menu: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_menu_button_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_menu_button_t"][::std::mem::size_of::<_cef_menu_button_t>() - 608usize];
    ["Alignment of _cef_menu_button_t"][::std::mem::align_of::<_cef_menu_button_t>() - 8usize];
    ["Offset of field: _cef_menu_button_t::base"]
        [::std::mem::offset_of!(_cef_menu_button_t, base) - 0usize];
    ["Offset of field: _cef_menu_button_t::show_menu"]
        [::std::mem::offset_of!(_cef_menu_button_t, show_menu) - 592usize];
    ["Offset of field: _cef_menu_button_t::trigger_menu"]
        [::std::mem::offset_of!(_cef_menu_button_t, trigger_menu) - 600usize];
};
#[doc = "\n MenuButton is a button with optional text, icon and/or menu marker that\n shows a menu when clicked with the left mouse button. All size and position\n values are in density independent pixels (DIP) unless otherwise indicated.\n Methods must be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_menu_button_t = _cef_menu_button_t;
unsafe extern "C" {
    #[doc = "\n Create a new MenuButton. A |delegate| must be provided to call show_menu()\n when the button is clicked. |text| will be shown on the MenuButton and used\n as the default accessible name. If |with_frame| is true (1) the button will\n have a visible frame at all times, center alignment, additional padding and\n a default minimum size of 70x33 DIP. If |with_frame| is false (0) the button\n will only have a visible frame on hover/press, left alignment, less padding\n and no default minimum size.\n"]
    pub fn cef_menu_button_create(
        delegate: *mut _cef_menu_button_delegate_t,
        text: *const cef_string_t,
    ) -> *mut cef_menu_button_t;
}
#[doc = "\n Implement this structure to handle Textfield events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_textfield_delegate_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_view_delegate_t,
    #[doc = "\n Called when |textfield| receives a keyboard event. |event| contains\n information about the keyboard event. Return true (1) if the keyboard\n event was handled or false (0) otherwise for default handling.\n"]
    pub on_key_event: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_textfield_delegate_t,
            textfield: *mut _cef_textfield_t,
            event: *const cef_key_event_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called after performing a user action that may change |textfield|.\n"]
    pub on_after_user_action: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_textfield_delegate_t,
            textfield: *mut _cef_textfield_t,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_textfield_delegate_t"]
        [::std::mem::size_of::<_cef_textfield_delegate_t>() - 144usize];
    ["Alignment of _cef_textfield_delegate_t"]
        [::std::mem::align_of::<_cef_textfield_delegate_t>() - 8usize];
    ["Offset of field: _cef_textfield_delegate_t::base"]
        [::std::mem::offset_of!(_cef_textfield_delegate_t, base) - 0usize];
    ["Offset of field: _cef_textfield_delegate_t::on_key_event"]
        [::std::mem::offset_of!(_cef_textfield_delegate_t, on_key_event) - 128usize];
    ["Offset of field: _cef_textfield_delegate_t::on_after_user_action"]
        [::std::mem::offset_of!(_cef_textfield_delegate_t, on_after_user_action) - 136usize];
};
#[doc = "\n Implement this structure to handle Textfield events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_textfield_delegate_t = _cef_textfield_delegate_t;
#[doc = "\n A Textfield supports editing of text. This control is custom rendered with\n no platform-specific code. Methods must be called on the browser process UI\n thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_textfield_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_view_t,
    #[doc = "\n Sets whether the text will be displayed as asterisks.\n"]
    pub set_password_input: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, password_input: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns true (1) if the text will be displayed as asterisks.\n"]
    pub is_password_input: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Sets whether the text will read-only.\n"]
    pub set_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, read_only: ::std::os::raw::c_int),
    >,
    #[doc = "\n Returns true (1) if the text is read-only.\n"]
    pub is_read_only: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the currently displayed text.\n"]
    pub get_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Sets the contents to |text|. The cursor will be moved to end of the text\n if the current position is outside of the text range.\n"]
    pub set_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, text: *const cef_string_t),
    >,
    #[doc = "\n Appends |text| to the previously-existing text.\n"]
    pub append_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, text: *const cef_string_t),
    >,
    #[doc = "\n Inserts |text| at the current cursor position replacing any selected text.\n"]
    pub insert_or_replace_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, text: *const cef_string_t),
    >,
    #[doc = "\n Returns true (1) if there is any selected text.\n"]
    pub has_selection: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the currently selected text.\n"]
    pub get_selected_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Selects all text. If |reversed| is true (1) the range will end at the\n logical beginning of the text; this generally shows the leading portion of\n text that overflows its display area.\n"]
    pub select_all: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, reversed: ::std::os::raw::c_int),
    >,
    #[doc = "\n Clears the text selection and sets the caret to the end.\n"]
    pub clear_selection: ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_textfield_t)>,
    #[doc = "\n Returns the selected logical text range.\n"]
    pub get_selected_range:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> cef_range_t>,
    #[doc = "\n Selects the specified logical text range.\n"]
    pub select_range: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, range: *const cef_range_t),
    >,
    #[doc = "\n Returns the current cursor position.\n"]
    pub get_cursor_position:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> usize>,
    #[doc = "\n Sets the text color.\n"]
    pub set_text_color: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, color: cef_color_t),
    >,
    #[doc = "\n Returns the text color.\n"]
    pub get_text_color:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> cef_color_t>,
    #[doc = "\n Sets the selection text color.\n"]
    pub set_selection_text_color: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, color: cef_color_t),
    >,
    #[doc = "\n Returns the selection text color.\n"]
    pub get_selection_text_color:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> cef_color_t>,
    #[doc = "\n Sets the selection background color.\n"]
    pub set_selection_background_color: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, color: cef_color_t),
    >,
    #[doc = "\n Returns the selection background color.\n"]
    pub get_selection_background_color:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> cef_color_t>,
    #[doc = "\n Sets the font list. The format is \"<FONT_FAMILY_LIST>,[STYLES] <SIZE>\",\n where:\n - FONT_FAMILY_LIST is a comma-separated list of font family names,\n - STYLES is an optional space-separated list of style names (case-\n   sensitive \"Bold\" and \"Italic\" are supported), and\n - SIZE is an integer font size in pixels with the suffix \"px\".\n\n Here are examples of valid font description strings:\n - \"Arial, Helvetica, Bold Italic 14px\"\n - \"Arial, 14px\"\n"]
    pub set_font_list: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, font_list: *const cef_string_t),
    >,
    #[doc = "\n Applies |color| to the specified |range| without changing the default\n color. If |range| is NULL the color will be set on the complete text\n contents.\n"]
    pub apply_text_color: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_textfield_t,
            color: cef_color_t,
            range: *const cef_range_t,
        ),
    >,
    #[doc = "\n Applies |style| to the specified |range| without changing the default\n style. If |add| is true (1) the style will be added, otherwise the style\n will be removed. If |range| is NULL the style will be set on the complete\n text contents.\n"]
    pub apply_text_style: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_textfield_t,
            style: cef_text_style_t,
            add: ::std::os::raw::c_int,
            range: *const cef_range_t,
        ),
    >,
    #[doc = "\n Returns true (1) if the action associated with the specified command id is\n enabled. See additional comments on execute_command().\n"]
    pub is_command_enabled: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_textfield_t,
            command_id: cef_text_field_commands_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Performs the action associated with the specified command id.\n"]
    pub execute_command: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, command_id: cef_text_field_commands_t),
    >,
    #[doc = "\n Clears Edit history.\n"]
    pub clear_edit_history:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_textfield_t)>,
    #[doc = "\n Sets the placeholder text that will be displayed when the Textfield is\n NULL.\n"]
    pub set_placeholder_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, text: *const cef_string_t),
    >,
    #[doc = "\n Returns the placeholder text that will be displayed when the Textfield is\n NULL.\n"]
    pub get_placeholder_text: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t) -> cef_string_userfree_t,
    >,
    #[doc = "\n Sets the placeholder text color.\n"]
    pub set_placeholder_text_color: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, color: cef_color_t),
    >,
    #[doc = "\n Set the accessible name that will be exposed to assistive technology (AT).\n"]
    pub set_accessible_name: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_textfield_t, name: *const cef_string_t),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_textfield_t"][::std::mem::size_of::<_cef_textfield_t>() - 704usize];
    ["Alignment of _cef_textfield_t"][::std::mem::align_of::<_cef_textfield_t>() - 8usize];
    ["Offset of field: _cef_textfield_t::base"]
        [::std::mem::offset_of!(_cef_textfield_t, base) - 0usize];
    ["Offset of field: _cef_textfield_t::set_password_input"]
        [::std::mem::offset_of!(_cef_textfield_t, set_password_input) - 456usize];
    ["Offset of field: _cef_textfield_t::is_password_input"]
        [::std::mem::offset_of!(_cef_textfield_t, is_password_input) - 464usize];
    ["Offset of field: _cef_textfield_t::set_read_only"]
        [::std::mem::offset_of!(_cef_textfield_t, set_read_only) - 472usize];
    ["Offset of field: _cef_textfield_t::is_read_only"]
        [::std::mem::offset_of!(_cef_textfield_t, is_read_only) - 480usize];
    ["Offset of field: _cef_textfield_t::get_text"]
        [::std::mem::offset_of!(_cef_textfield_t, get_text) - 488usize];
    ["Offset of field: _cef_textfield_t::set_text"]
        [::std::mem::offset_of!(_cef_textfield_t, set_text) - 496usize];
    ["Offset of field: _cef_textfield_t::append_text"]
        [::std::mem::offset_of!(_cef_textfield_t, append_text) - 504usize];
    ["Offset of field: _cef_textfield_t::insert_or_replace_text"]
        [::std::mem::offset_of!(_cef_textfield_t, insert_or_replace_text) - 512usize];
    ["Offset of field: _cef_textfield_t::has_selection"]
        [::std::mem::offset_of!(_cef_textfield_t, has_selection) - 520usize];
    ["Offset of field: _cef_textfield_t::get_selected_text"]
        [::std::mem::offset_of!(_cef_textfield_t, get_selected_text) - 528usize];
    ["Offset of field: _cef_textfield_t::select_all"]
        [::std::mem::offset_of!(_cef_textfield_t, select_all) - 536usize];
    ["Offset of field: _cef_textfield_t::clear_selection"]
        [::std::mem::offset_of!(_cef_textfield_t, clear_selection) - 544usize];
    ["Offset of field: _cef_textfield_t::get_selected_range"]
        [::std::mem::offset_of!(_cef_textfield_t, get_selected_range) - 552usize];
    ["Offset of field: _cef_textfield_t::select_range"]
        [::std::mem::offset_of!(_cef_textfield_t, select_range) - 560usize];
    ["Offset of field: _cef_textfield_t::get_cursor_position"]
        [::std::mem::offset_of!(_cef_textfield_t, get_cursor_position) - 568usize];
    ["Offset of field: _cef_textfield_t::set_text_color"]
        [::std::mem::offset_of!(_cef_textfield_t, set_text_color) - 576usize];
    ["Offset of field: _cef_textfield_t::get_text_color"]
        [::std::mem::offset_of!(_cef_textfield_t, get_text_color) - 584usize];
    ["Offset of field: _cef_textfield_t::set_selection_text_color"]
        [::std::mem::offset_of!(_cef_textfield_t, set_selection_text_color) - 592usize];
    ["Offset of field: _cef_textfield_t::get_selection_text_color"]
        [::std::mem::offset_of!(_cef_textfield_t, get_selection_text_color) - 600usize];
    ["Offset of field: _cef_textfield_t::set_selection_background_color"]
        [::std::mem::offset_of!(_cef_textfield_t, set_selection_background_color) - 608usize];
    ["Offset of field: _cef_textfield_t::get_selection_background_color"]
        [::std::mem::offset_of!(_cef_textfield_t, get_selection_background_color) - 616usize];
    ["Offset of field: _cef_textfield_t::set_font_list"]
        [::std::mem::offset_of!(_cef_textfield_t, set_font_list) - 624usize];
    ["Offset of field: _cef_textfield_t::apply_text_color"]
        [::std::mem::offset_of!(_cef_textfield_t, apply_text_color) - 632usize];
    ["Offset of field: _cef_textfield_t::apply_text_style"]
        [::std::mem::offset_of!(_cef_textfield_t, apply_text_style) - 640usize];
    ["Offset of field: _cef_textfield_t::is_command_enabled"]
        [::std::mem::offset_of!(_cef_textfield_t, is_command_enabled) - 648usize];
    ["Offset of field: _cef_textfield_t::execute_command"]
        [::std::mem::offset_of!(_cef_textfield_t, execute_command) - 656usize];
    ["Offset of field: _cef_textfield_t::clear_edit_history"]
        [::std::mem::offset_of!(_cef_textfield_t, clear_edit_history) - 664usize];
    ["Offset of field: _cef_textfield_t::set_placeholder_text"]
        [::std::mem::offset_of!(_cef_textfield_t, set_placeholder_text) - 672usize];
    ["Offset of field: _cef_textfield_t::get_placeholder_text"]
        [::std::mem::offset_of!(_cef_textfield_t, get_placeholder_text) - 680usize];
    ["Offset of field: _cef_textfield_t::set_placeholder_text_color"]
        [::std::mem::offset_of!(_cef_textfield_t, set_placeholder_text_color) - 688usize];
    ["Offset of field: _cef_textfield_t::set_accessible_name"]
        [::std::mem::offset_of!(_cef_textfield_t, set_accessible_name) - 696usize];
};
#[doc = "\n A Textfield supports editing of text. This control is custom rendered with\n no platform-specific code. Methods must be called on the browser process UI\n thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_textfield_t = _cef_textfield_t;
unsafe extern "C" {
    #[doc = "\n Create a new Textfield.\n"]
    pub fn cef_textfield_create(delegate: *mut _cef_textfield_delegate_t) -> *mut cef_textfield_t;
}
#[doc = "\n Implement this structure to handle BrowserView events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_browser_view_delegate_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_view_delegate_t,
    #[doc = "\n Called when |browser| associated with |browser_view| is created. This\n function will be called after cef_life_span_handler_t::on_after_created()\n is called for |browser| and before on_popup_browser_view_created() is\n called for |browser|'s parent delegate if |browser| is a popup.\n"]
    pub on_browser_created: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_delegate_t,
            browser_view: *mut _cef_browser_view_t,
            browser: *mut _cef_browser_t,
        ),
    >,
    #[doc = "\n Called when |browser| associated with |browser_view| is destroyed. Release\n all references to |browser| and do not attempt to execute any functions on\n |browser| after this callback returns. This function will be called before\n cef_life_span_handler_t::on_before_close() is called for |browser|.\n"]
    pub on_browser_destroyed: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_delegate_t,
            browser_view: *mut _cef_browser_view_t,
            browser: *mut _cef_browser_t,
        ),
    >,
    #[doc = "\n Called before a new popup BrowserView is created. The popup originated\n from |browser_view|. |settings| and |client| are the values returned from\n cef_life_span_handler_t::on_before_popup(). |is_devtools| will be true (1)\n if the popup will be a DevTools browser. Return the delegate that will be\n used for the new popup BrowserView.\n"]
    pub get_delegate_for_popup_browser_view: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_delegate_t,
            browser_view: *mut _cef_browser_view_t,
            settings: *const _cef_browser_settings_t,
            client: *mut _cef_client_t,
            is_devtools: ::std::os::raw::c_int,
        ) -> *mut _cef_browser_view_delegate_t,
    >,
    #[doc = "\n Called after |popup_browser_view| is created. This function will be called\n after cef_life_span_handler_t::on_after_created() and on_browser_created()\n are called for the new popup browser. The popup originated from\n |browser_view|. |is_devtools| will be true (1) if the popup is a DevTools\n browser. Optionally add |popup_browser_view| to the views hierarchy\n yourself and return true (1). Otherwise return false (0) and a default\n cef_window_t will be created for the popup.\n"]
    pub on_popup_browser_view_created: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_delegate_t,
            browser_view: *mut _cef_browser_view_t,
            popup_browser_view: *mut _cef_browser_view_t,
            is_devtools: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the Chrome toolbar type that will be available via\n cef_browser_view_t::get_chrome_toolbar(). See that function for related\n documentation.\n"]
    pub get_chrome_toolbar_type: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_delegate_t,
            browser_view: *mut _cef_browser_view_t,
        ) -> cef_chrome_toolbar_type_t,
    >,
    #[doc = "\n Return true (1) to create frameless windows for Document picture-in-\n picture popups. Content in frameless windows should specify draggable\n regions using \"-webkit-app-region: drag\" CSS.\n"]
    pub use_frameless_window_for_picture_in_picture: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_delegate_t,
            browser_view: *mut _cef_browser_view_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Called when |browser_view| receives a gesture command. Return true (1) to\n handle (or disable) a |gesture_command| or false (0) to propagate the\n gesture to the browser for default handling. With Chrome style these\n commands can also be handled via cef_command_handler_t::OnChromeCommand.\n"]
    pub on_gesture_command: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_delegate_t,
            browser_view: *mut _cef_browser_view_t,
            gesture_command: cef_gesture_command_t,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Optionally change the runtime style for this BrowserView. See\n cef_runtime_style_t documentation for details.\n"]
    pub get_browser_runtime_style: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_view_delegate_t) -> cef_runtime_style_t,
    >,
    #[doc = "\n Return true (1) to allow the use of JavaScript moveTo/By() and\n resizeTo/By() (without user activation) with Document picture-in-picture\n popups.\n"]
    pub allow_move_for_picture_in_picture: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_delegate_t,
            browser_view: *mut _cef_browser_view_t,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_browser_view_delegate_t"]
        [::std::mem::size_of::<_cef_browser_view_delegate_t>() - 200usize];
    ["Alignment of _cef_browser_view_delegate_t"]
        [::std::mem::align_of::<_cef_browser_view_delegate_t>() - 8usize];
    ["Offset of field: _cef_browser_view_delegate_t::base"]
        [::std::mem::offset_of!(_cef_browser_view_delegate_t, base) - 0usize];
    ["Offset of field: _cef_browser_view_delegate_t::on_browser_created"]
        [::std::mem::offset_of!(_cef_browser_view_delegate_t, on_browser_created) - 128usize];
    ["Offset of field: _cef_browser_view_delegate_t::on_browser_destroyed"]
        [::std::mem::offset_of!(_cef_browser_view_delegate_t, on_browser_destroyed) - 136usize];
    ["Offset of field: _cef_browser_view_delegate_t::get_delegate_for_popup_browser_view"][::std::mem::offset_of!(
        _cef_browser_view_delegate_t,
        get_delegate_for_popup_browser_view
    )
        - 144usize];
    ["Offset of field: _cef_browser_view_delegate_t::on_popup_browser_view_created"][::std::mem::offset_of!(
        _cef_browser_view_delegate_t,
        on_popup_browser_view_created
    ) - 152usize];
    ["Offset of field: _cef_browser_view_delegate_t::get_chrome_toolbar_type"]
        [::std::mem::offset_of!(_cef_browser_view_delegate_t, get_chrome_toolbar_type) - 160usize];
    ["Offset of field: _cef_browser_view_delegate_t::use_frameless_window_for_picture_in_picture"] [:: std :: mem :: offset_of ! (_cef_browser_view_delegate_t , use_frameless_window_for_picture_in_picture) - 168usize] ;
    ["Offset of field: _cef_browser_view_delegate_t::on_gesture_command"]
        [::std::mem::offset_of!(_cef_browser_view_delegate_t, on_gesture_command) - 176usize];
    ["Offset of field: _cef_browser_view_delegate_t::get_browser_runtime_style"][::std::mem::offset_of!(
        _cef_browser_view_delegate_t,
        get_browser_runtime_style
    ) - 184usize];
    ["Offset of field: _cef_browser_view_delegate_t::allow_move_for_picture_in_picture"][::std::mem::offset_of!(
        _cef_browser_view_delegate_t,
        allow_move_for_picture_in_picture
    )
        - 192usize];
};
#[doc = "\n Implement this structure to handle BrowserView events. The functions of this\n structure will be called on the browser process UI thread unless otherwise\n indicated.\n\n NOTE: This struct is allocated client-side.\n"]
pub type cef_browser_view_delegate_t = _cef_browser_view_delegate_t;
#[doc = "\n A View hosting a cef_browser_t instance. Methods must be called on the\n browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_browser_view_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_view_t,
    #[doc = "\n Returns the cef_browser_t hosted by this BrowserView. Will return NULL if\n the browser has not yet been created or has already been destroyed.\n"]
    pub get_browser: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_view_t) -> *mut _cef_browser_t,
    >,
    #[doc = "\n Returns the Chrome toolbar associated with this BrowserView. Only\n supported when using Chrome style. The cef_browser_view_delegate_t::\n get_chrome_toolbar_type() function must return a value other than\n CEF_CTT_NONE and the toolbar will not be available until after this\n BrowserView is added to a cef_window_t and\n cef_view_delegate_t::on_window_changed() has been called.\n"]
    pub get_chrome_toolbar: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_view_t) -> *mut _cef_view_t,
    >,
    #[doc = "\n Sets whether normal priority accelerators are first forwarded to the web\n content (`keydown` event handler) or cef_keyboard_handler_t. Normal\n priority accelerators can be registered via cef_window_t::SetAccelerator\n (with |high_priority|=false (0)) or internally for standard accelerators\n supported by Chrome style. If |prefer_accelerators| is true (1) then the\n matching accelerator will be triggered immediately (calling\n cef_window_delegate_t::OnAccelerator or\n cef_command_handler_t::OnChromeCommand respectively) and the event will\n not be forwarded to the web content or cef_keyboard_handler_t first. If\n |prefer_accelerators| is false (0) then the matching accelerator will only\n be triggered if the event is not handled by web content (`keydown` event\n handler that calls `event.preventDefault()`) or by cef_keyboard_handler_t.\n The default value is false (0).\n"]
    pub set_prefer_accelerators: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut _cef_browser_view_t,
            prefer_accelerators: ::std::os::raw::c_int,
        ),
    >,
    #[doc = "\n Returns the runtime style for this BrowserView (ALLOY or CHROME). See\n cef_runtime_style_t documentation for details.\n"]
    pub get_runtime_style: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_browser_view_t) -> cef_runtime_style_t,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_browser_view_t"][::std::mem::size_of::<_cef_browser_view_t>() - 488usize];
    ["Alignment of _cef_browser_view_t"][::std::mem::align_of::<_cef_browser_view_t>() - 8usize];
    ["Offset of field: _cef_browser_view_t::base"]
        [::std::mem::offset_of!(_cef_browser_view_t, base) - 0usize];
    ["Offset of field: _cef_browser_view_t::get_browser"]
        [::std::mem::offset_of!(_cef_browser_view_t, get_browser) - 456usize];
    ["Offset of field: _cef_browser_view_t::get_chrome_toolbar"]
        [::std::mem::offset_of!(_cef_browser_view_t, get_chrome_toolbar) - 464usize];
    ["Offset of field: _cef_browser_view_t::set_prefer_accelerators"]
        [::std::mem::offset_of!(_cef_browser_view_t, set_prefer_accelerators) - 472usize];
    ["Offset of field: _cef_browser_view_t::get_runtime_style"]
        [::std::mem::offset_of!(_cef_browser_view_t, get_runtime_style) - 480usize];
};
#[doc = "\n A View hosting a cef_browser_t instance. Methods must be called on the\n browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_browser_view_t = _cef_browser_view_t;
unsafe extern "C" {
    #[doc = "\n Create a new BrowserView. The underlying cef_browser_t will not be created\n until this view is added to the views hierarchy. The optional |extra_info|\n parameter provides an opportunity to specify extra information specific to\n the created browser that will be passed to\n cef_render_process_handler_t::on_browser_created() in the render process.\n"]
    pub fn cef_browser_view_create(
        client: *mut _cef_client_t,
        url: *const cef_string_t,
        settings: *const _cef_browser_settings_t,
        extra_info: *mut _cef_dictionary_value_t,
        request_context: *mut _cef_request_context_t,
        delegate: *mut _cef_browser_view_delegate_t,
    ) -> *mut cef_browser_view_t;
}
unsafe extern "C" {
    #[doc = "\n Returns the BrowserView associated with |browser|.\n"]
    pub fn cef_browser_view_get_for_browser(
        browser: *mut _cef_browser_t,
    ) -> *mut cef_browser_view_t;
}
#[doc = "\n A ScrollView will show horizontal and/or vertical scrollbars when necessary\n based on the size of the attached content view. Methods must be called on\n the browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_scroll_view_t {
    #[doc = "\n Base structure.\n"]
    pub base: cef_view_t,
    #[doc = "\n Set the content View. The content View must have a specified size (e.g.\n via cef_view_t::SetBounds or cef_view_delegate_t::GetPreferredSize).\n"]
    pub set_content_view: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_scroll_view_t, view: *mut _cef_view_t),
    >,
    #[doc = "\n Returns the content View.\n"]
    pub get_content_view: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_scroll_view_t) -> *mut _cef_view_t,
    >,
    #[doc = "\n Returns the visible region of the content View.\n"]
    pub get_visible_content_rect:
        ::std::option::Option<unsafe extern "C" fn(self_: *mut _cef_scroll_view_t) -> cef_rect_t>,
    #[doc = "\n Returns true (1) if the horizontal scrollbar is currently showing.\n"]
    pub has_horizontal_scrollbar: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_scroll_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the height of the horizontal scrollbar.\n"]
    pub get_horizontal_scrollbar_height: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_scroll_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns true (1) if the vertical scrollbar is currently showing.\n"]
    pub has_vertical_scrollbar: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_scroll_view_t) -> ::std::os::raw::c_int,
    >,
    #[doc = "\n Returns the width of the vertical scrollbar.\n"]
    pub get_vertical_scrollbar_width: ::std::option::Option<
        unsafe extern "C" fn(self_: *mut _cef_scroll_view_t) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _cef_scroll_view_t"][::std::mem::size_of::<_cef_scroll_view_t>() - 512usize];
    ["Alignment of _cef_scroll_view_t"][::std::mem::align_of::<_cef_scroll_view_t>() - 8usize];
    ["Offset of field: _cef_scroll_view_t::base"]
        [::std::mem::offset_of!(_cef_scroll_view_t, base) - 0usize];
    ["Offset of field: _cef_scroll_view_t::set_content_view"]
        [::std::mem::offset_of!(_cef_scroll_view_t, set_content_view) - 456usize];
    ["Offset of field: _cef_scroll_view_t::get_content_view"]
        [::std::mem::offset_of!(_cef_scroll_view_t, get_content_view) - 464usize];
    ["Offset of field: _cef_scroll_view_t::get_visible_content_rect"]
        [::std::mem::offset_of!(_cef_scroll_view_t, get_visible_content_rect) - 472usize];
    ["Offset of field: _cef_scroll_view_t::has_horizontal_scrollbar"]
        [::std::mem::offset_of!(_cef_scroll_view_t, has_horizontal_scrollbar) - 480usize];
    ["Offset of field: _cef_scroll_view_t::get_horizontal_scrollbar_height"]
        [::std::mem::offset_of!(_cef_scroll_view_t, get_horizontal_scrollbar_height) - 488usize];
    ["Offset of field: _cef_scroll_view_t::has_vertical_scrollbar"]
        [::std::mem::offset_of!(_cef_scroll_view_t, has_vertical_scrollbar) - 496usize];
    ["Offset of field: _cef_scroll_view_t::get_vertical_scrollbar_width"]
        [::std::mem::offset_of!(_cef_scroll_view_t, get_vertical_scrollbar_width) - 504usize];
};
#[doc = "\n A ScrollView will show horizontal and/or vertical scrollbars when necessary\n based on the size of the attached content view. Methods must be called on\n the browser process UI thread unless otherwise indicated.\n\n NOTE: This struct is allocated DLL-side.\n"]
pub type cef_scroll_view_t = _cef_scroll_view_t;
unsafe extern "C" {
    #[doc = "\n Create a new ScrollView.\n"]
    pub fn cef_scroll_view_create(delegate: *mut _cef_view_delegate_t) -> *mut cef_scroll_view_t;
}
#[doc = "\n This structure typically, but not always, corresponds to a physical display\n connected to the system. A fake Display may exist on a headless system, or a\n Display may correspond to a remote, virtual display. All size and position\n values are in density independent pixel (DIP) coordinates unless otherwise\n indicated. Methods must be called on the browser process UI thread unless\n otherwise indicated.\n\n For details on coordinate systems and usage see\n https://bitbucket.org/chromiumembedded/cef/wiki/GeneralUsage#markdown-\n header-coordinate-systems\n\n NOTE: This struct is allocated DLL-side.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cef_display_t {
    #[do