add_library(3rdparty_qt6 INTERFACE)

set(QT_MIN_VER 6.7.0)

find_package(Qt6 ${QT_MIN_VER} CONFIG COMPONENTS Widgets Concurrent Multimedia MultimediaWidgets Svg SvgWidgets)
if(WIN32)
	target_link_libraries(3rdparty_qt6 INTERFACE Qt6::Widgets Qt6::Concurrent Qt6::Multimedia Qt6::MultimediaWidgets Qt6::Svg Qt6::SvgWidgets)
else()
	find_package(Qt6 ${QT_MIN_VER} COMPONENTS DBus Gui)
	if(Qt6DBus_FOUND)
		target_link_libraries(3rdparty_qt6 INTERFACE Qt6::Widgets Qt6::DBus Qt6::Concurrent Qt6::Multimedia Qt6::MultimediaWidgets Qt6::Svg Qt6::SvgWidgets)
		target_compile_definitions(3rdparty_qt6 INTERFACE -DHAVE_QTDBUS)
	else()
		target_link_libraries(3rdparty_qt6 INTERFACE Qt6::Widgets Qt6::Concurrent Qt6::Multimedia Qt6::MultimediaWidgets Qt6::Svg Qt6::SvgWidgets)
	endif()
	target_include_directories(3rdparty_qt6 INTERFACE ${Qt6Gui_PRIVATE_INCLUDE_DIRS})
endif()

if(Qt6Widgets_FOUND)
	if(Qt6Widgets_VERSION VERSION_LESS ${QT_MIN_VER})
		message("Minimum supported Qt version is ${QT_MIN_VER}! You have version ${Qt6Widgets_VERSION} installed, please upgrade!")
		if(CMAKE_SYSTEM_NAME STREQUAL "Linux")
			message(FATAL_ERROR "Most distros do not provide an up-to-date version of Qt.
If you're on Ubuntu or Linux Mint, there are PPAs you can use to install one of the latest qt6 versions.
Find the correct ppa at https://launchpad.net/~beineri and follow the instructions.")
		elseif(WIN32)
			message(FATAL_ERROR "You can download the latest version of Qt6 here: https://www.qt.io/download-open-source/")
		else()
			message(FATAL_ERROR "Look online for instructions on installing an up-to-date Qt6 on ${CMAKE_SYSTEM}.")
		endif()
	endif()
else()
	message("CMake was unable to find Qt6!")
	if(WIN32)
		message(FATAL_ERROR "Make sure the Qt6_ROOT environment variable has been set properly. (for example C:\\Qt\\${QT_MIN_VER}\\msvc2022_64\\)")
	elseif(CMAKE_SYSTEM_NAME STREQUAL "Linux")
		message(FATAL_ERROR "Make sure to install your distro's qt6 package!")
	else()
		message(FATAL_ERROR "You need to have Qt6 installed, look online for instructions on installing Qt6 on ${CMAKE_SYSTEM}.")
	endif()
endif()

add_library(3rdparty::qt6 ALIAS 3rdparty_qt6)
