# Community Guidelines

## Bug Reports
For bug reports please open a new issue. Include a [minimal reproducible example](https://stackoverflow.com/help/minimal-reproducible-example) and state your operating system, as well as the versions of all relevant Python packages you are using.

**Important:** Before opening a new issue, make sure to check whether a similar issue already exists.

## Questions

If you have any other questions about the usage of the library feel free to open an issue or chat with us on [gitter](https://gitter.im/pymatting/community).

**Important:** Before opening a new issue, make sure to check whether a similar issue already exists.

## Contributing Source Code

Thank you for considering to contribute to the PyMatting project!

To make a contribution, follow those steps:

1. [Fork the repository.](https://guides.github.com/activities/forking/)
2. Make your changes.
3. Add tests if appropriate.
4. Add yourself to [CONTRIBUTORS.md](https://github.com/pymatting/pymatting/blob/master/CONTRIBUTORS.md) if you want to.
5. [Run the black code formatter.](https://pypi.org/project/black/)
6. [Run the tests.](https://github.com/pymatting/pymatting#testing)
7. Create a pull request.
8. State in your pull request
    * the changes made
    * if you agree to release the code under the MIT license

For larger changes, it is probably a good idea to open an issue and discuss them first.

### Licensing

* All contributed code must be released under the MIT license.
* You must be legally allowed to release the contributed code under the MIT license.
