<!-- last update: 15/11/2025

Special symbols:
Unchecked: &#9744;
Checked: &#9745;
Error: ⛔
Warning: ⚠️
Information: ❕
-->

Tasks to do before releasing a new translation of OpenMoneyBox.
===========================================================

## MAKEFILE:  
 1. &#9744; Add mo creation commands in Makefile 'create_translation_messages_application' section;  
 2. &#9744; Add mo installation commands in Makefile 'install' section  
    1. &#9744; main MAKEFILE;  
    2. &#9744; MSW makefile;  
    3. &#9744; FreeBSD makefile;  
    4. &#9744; OpenSolaris makefile;  
    5. &#9744; MacOS makefile;  
 3. &#9744; Add mo uninstallation commands in Makefile 'uninstall' section  
    1. &#9744; main MAKEFILE;  
    2. &#9744; MSW makefile;  
    3. &#9744; FreeBSD makefile;  
    4. &#9744; OpenSolaris makefile;  
    5. &#9744; MacOS makefile;  
 4. &#9744; `make create_translation_messages_application`  

## Debian packaging files:  
 1. &#9744; Control: add language package entry;  
 2. &#9744; openmoneybox-locale-<lan>.install: to be created;  

## MSW packaging files:  
 1. &#9744; openmoneybox.nsi: add language package entry;  

## TechDetails.ods:  
 1. &#9744; Add translation information;  

## Translator information:  
 1. &#9744; Check if email information is available;  
 2. &#9744; Check if the author likes for the email to be shown in the app and in the code;  
 3. &#9744; Desktop app: add contribution in About dialog;  

## i18n/en/en.pot:  
 1. &#9744; Add language name string;  
 2. &#9744; Add language name translations in *.po strings (eg. `it.po`);  
 3. &#9744; `make create_translation_messages_application`  

## Changelogs:  
 1. &#9744; Add change entry in `help/en/History.xml`;  
 2. &#9744; Add change entry in `android/help/en/History.xml`;  
 2. &#9744; Add change entry in Android app master language strings`res/values/strings.xml`;  

## Translation hosts:  
 1. &#9744; Check import in [Weblate](https://hosted.weblate.org/projects/openmoneybox/);  
 1. &#9744; Import and check in [Launchpad](https://hosted.weblate.org/projects/openmoneybox/);  

## Websites:  
 1. &#9744; Update Language information in [AlternativeTo](https://alternativeto.net/software/openmoneybox/about/);  
