/***************************************************************
 * Name:      main_wx.h
 * Purpose:   Code for OpenMoneyBox fund groups
 * Author:    Igor Calì (igor.cali0@gmail.com)
 * Created:   2024-09-05
 * Copyright: Igor Calì (igor.cali0@gmail.com)
 * License:		GNU
 **************************************************************/

#ifndef __ombFundGroups__
	#define __ombFundGroups__

	/**
	@file
	Subclass of wxFundGroups, which is generated by wxFormBuilder.
	*/

	//// end generated include

	#ifndef WX_PRECOMP
		#include <wx/wx.h>
	#else
		#include <wx/wxprec.h>
	#endif

	#include "wxFundGroups.h"

	typedef struct TFundIndexes{
		int ID;
		wxString FundName;
		int Owner;
		wxString OwnerName;
	} FundIndexes;

	/** Implementing wxFundGroups */
	class ombFundGroups : public wxFundGroups
	{
		public:

			bool AddedOrModifiedGroups, DeletedGroups;
			TFundIndexes *FundIndexes;

			/** Constructor */
			explicit ombFundGroups( wxWindow* parent );
			//// end generated class members
			void RefreshControls(void);
			void AddGroupClick( wxCommandEvent& event ) override;
			void GroupSelected( wxCommandEvent& event ) override;
			void DeleteGroupClick( wxCommandEvent& event ) override;
			void FundToggled( wxCommandEvent& event ) override;
			void OKBtnClick( wxCommandEvent& event ) override;

	};

	// Calls to module omblogo
	extern wxString iUpperCase(wxString S);
	// Calls to module omberr
	extern void Error(int Err, const wxString &Opt);

#endif // __ombFundGroups__
