# 故障排除指南

本指南帮助您诊断并解决使用NodePass时可能遇到的常见问题。对于每个问题，我们提供可能的原因和逐步解决方案。

## 连接问题

### 无法建立隧道连接

**症状**：客户端无法连接到服务器的隧道端点，或连接立即断开。

**可能的原因和解决方案**：

1. **网络连接问题**
   - 使用`ping`或`telnet`验证与服务器地址的基本连接
   - 检查指定的端口是否可达：`telnet server.example.com 10101`
   - 确保没有防火墙阻止隧道端口（通常为10101）

2. **服务器未运行**
   - 在Linux/macOS上使用`ps aux | grep nodepass`验证NodePass服务器是否运行
   - 检查服务器日志中的任何启动错误
   - 尝试重启服务器进程

3. **地址错误**
   - 仔细检查客户端命令中的隧道地址格式
   - 确保使用了正确的主机名/IP和端口
   - 如果使用DNS名称，验证它们是否解析为正确的IP地址

4. **TLS配置不匹配**
   - 如果服务器需要TLS但客户端不支持，连接将失败
   - 检查服务器日志中的TLS握手错误
   - 如果使用TLS模式2，确保证书配置正确

### 数据未通过隧道流动

**症状**：隧道连接已建立，但应用程序数据未到达目的地。

**可能的原因和解决方案**：

1. **目标服务未运行**
   - 验证目标服务在服务器和客户端两侧是否运行
   - 检查是否可以在本地直接连接到该服务

2. **端口冲突**
   - 确保目标端口没有被其他应用程序占用
   - 使用`netstat -tuln`检查端口使用情况

3. **协议不匹配**
   - 验证您是否在隧道传输正确的协议（TCP与UDP）
   - 某些应用程序需要特定的协议支持

4. **目标地址错误**
   - 仔细检查服务器和客户端命令中的目标地址
   - 对于服务器端目标，确保它们可从服务器访问
   - 对于客户端目标，确保它们可从客户端访问

### 连接稳定性问题

**症状**：隧道最初工作但频繁断开或变得无响应。

**可能的原因和解决方案**：

1. **网络不稳定**
   - 检查您的网络中是否有数据包丢失或高延迟
   - 考虑为生产部署使用更稳定的网络连接

2. **资源限制**
   - 监控客户端和服务器的CPU和内存使用情况
   - 如果资源耗尽，调整池参数（参见性能部分）
   - 在Linux/macOS上使用`ulimit -n`检查文件描述符限制

3. **超时配置**
   - 如果使用具有慢响应时间的UDP，调整`NP_UDP_DIAL_TIMEOUT`
   - 增加URL中的`read`参数用于长时间传输（默认：0）
   - 考虑为不稳定网络条件调整`NP_TCP_DIAL_TIMEOUT`

4. **服务器过载**
   - 检查服务器日志中的连接过载迹象
   - 调整`max`参数和`NP_SEMAPHORE_LIMIT`以处理负载
   - 考虑用多个NodePass实例水平扩展

## 证书问题

### TLS握手失败

**症状**：连接尝试因TLS握手错误而失败。

**可能的原因和解决方案**：

1. **无效证书**
   - 验证证书有效性：`openssl x509 -in cert.pem -text -noout`
   - 确保证书没有过期
   - 检查证书是否针对正确的域名/IP颁发

2. **证书文件丢失或无法访问**
   - 确认证书和密钥的文件路径正确
   - 验证文件权限允许NodePass进程读取它们
   - 通过文本编辑器打开证书检查文件是否损坏

3. **证书信任问题**
   - 如果使用自定义CA，确保它们被正确信任
   - 对于自签名证书，确认使用TLS模式1
   - 对于验证证书，确保CA链完整

4. **密钥格式问题**
   - 确保私钥格式正确（通常为PEM）
   - 检查私钥是否有密码保护（不直接支持）

### 证书更新问题

**症状**：证书更新后，安全连接开始失败。

**可能的原因和解决方案**：

1. **新证书未加载**
   - 重启NodePass强制加载新证书
   - 检查`RELOAD_INTERVAL`是否设置正确以自动检测变更

2. **证书链不完整**
   - 确保证书文件中包含完整的证书链
   - 验证链顺序：首先是您的证书，然后是中间证书

3. **密钥不匹配**
   - 验证新证书是否与私钥匹配：
     ```bash
     openssl x509 -noout -modulus -in cert.pem | openssl md5
     openssl rsa -noout -modulus -in key.pem | openssl md5
     ```
   - 如果输出不同，证书和密钥不匹配

## 性能优化

### 高延迟

**症状**：连接工作但有明显延迟。

**可能的原因和解决方案**：

1. **池配置**
   - 增加`min`参数以准备更多连接
   - 减少`MIN_POOL_INTERVAL`以更快创建连接
   - 如果连接队列堆积，调整`NP_SEMAPHORE_LIMIT`

2. **网络路径**
   - 检查网络拥塞或高延迟链路
   - 考虑将NodePass部署在更靠近客户端或服务器的位置
   - 使用traceroute识别潜在瓶颈

3. **TLS开销**
   - 如果需要极低延迟且安全性不太重要，考虑使用TLS模式0
   - 为了平衡，使用带会话恢复的TLS模式1

4. **资源竞争**
   - 确保主机系统有足够的CPU和内存
   - 检查是否有其他进程竞争资源
   - 考虑为高流量部署使用专用主机

### CPU使用率高

**症状**：NodePass进程消耗过多CPU资源。

**可能的原因和解决方案**：

1. **池抖动**
   - 如果池不断创建和销毁连接，调整时间
   - 增加`MIN_POOL_INTERVAL`以减少连接创建频率
   - 为`min`和`max`连接池参数找到良好平衡

2. **过度日志记录**
   - 在生产环境中将日志级别从debug降低到info或warn
   - 检查日志是否写入缓慢设备

3. **TLS开销**
   - TLS握手需要大量CPU；考虑会话缓存
   - 如果证书验证不太重要，使用TLS模式1而不是模式2

4. **流量体积**
   - 高吞吐量可能导致CPU饱和
   - 考虑跨多个NodePass实例分配流量
   - 对于非常高的吞吐量，可能需要垂直扩展（更多CPU核心）

### 内存泄漏

**症状**：NodePass内存使用随时间持续增长。

**可能的原因和解决方案**：

1. **连接泄漏**
   - 确保`NP_SHUTDOWN_TIMEOUT`足够长以正确关闭连接
   - 检查自定义脚本或管理代码中的错误处理
   - 使用系统工具如`netstat`监控连接数量

2. **池大小问题**
   - 如果`max`参数非常大，内存使用会更高
   - 监控实际池使用情况与配置容量
   - 根据实际并发连接需求调整容量

3. **调试日志**
   - 在高流量场景中，大量调试日志可能消耗内存
   - 在生产环境中使用适当的日志级别

## UDP特定问题

### UDP数据丢失

**症状**：UDP数据包无法通过隧道可靠转发。

**可能的原因和解决方案**：

1. **缓冲区大小限制**
   - 如果UDP数据包较大，增加`UDP_DATA_BUF_SIZE`
   - 默认8192字节对某些应用程序可能太小

2. **超时问题**
   - 如果响应较慢，增加`NP_UDP_DIAL_TIMEOUT`
   - 调整`read`参数以获得更长的会话超时
   - 对于响应时间变化的应用程序，找到最佳平衡点

3. **高数据包率**
   - UDP一次处理一个数据报；非常高的速率可能导致问题
   - 考虑为高流量UDP应用增加池容量

4. **协议期望**
   - 一些UDP应用期望特定的数据包顺序或时序行为
   - NodePass提供尽力转发，但无法保证超出网络提供的UDP属性

### UDP连接跟踪

**症状**：UDP会话过早断开或无法建立。

**可能的原因和解决方案**：

1. **连接映射**
   - 验证客户端配置是否符合服务器期望
   - 检查防火墙是否超时UDP会话跟踪

2. **应用UDP超时**
   - 一些应用有内置UDP会话超时
   - 可能需要调整应用特定的keepalive设置

## 主控API问题

### API可访问性问题

**症状**：无法连接到主控API端点。

**可能的原因和解决方案**：

1. **端点配置**
   - 验证主控命令中的API地址和端口
   - 检查API服务器是否绑定到正确的网络接口

2. **TLS配置**
   - 如果使用HTTPS（TLS模式1或2），确保客户端工具支持TLS
   - 对于测试，使用`curl -k`跳过证书验证

3. **自定义前缀问题**
   - 如果使用自定义API前缀，确保所有请求中都包含它
   - 检查API客户端和脚本中的URL格式

### 实例管理失败

**症状**：无法通过API创建、控制或删除实例。

**可能的原因和解决方案**：

1. **JSON格式问题**
   - 验证请求体是有效的JSON
   - 检查API请求中的必填字段

2. **URL解析问题**
   - 确保实例URL格式正确，必要时进行URL编码
   - 验证URL参数使用正确格式

3. **实例状态冲突**
   - 无法删除运行中的实例，必须先停止
   - 在执行操作前先用GET检查当前实例状态

4. **权限问题**
   - 确保NodePass主控具有创建进程的足够权限
   - 检查任何引用的证书或密钥的文件系统权限

## 数据恢复

### 主控状态文件损坏

**症状**：主控模式启动失败，显示状态文件损坏错误，或实例数据丢失。

**可能的原因和解决方案**：

1. **使用自动备份文件恢复**
   - NodePass每小时自动创建备份文件 `nodepass.gob.backup`
   - 停止NodePass主控服务
   - 将备份文件复制为主文件：`cp nodepass.gob.backup nodepass.gob`
   - 重新启动主控服务

2. **手动状态文件恢复**
   ```bash
   # 停止NodePass服务
   pkill nodepass
   
   # 备份损坏的文件（可选）
   mv nodepass.gob nodepass.gob.corrupted
   
   # 使用备份文件
   cp nodepass.gob.backup nodepass.gob
   
   # 重新启动服务
   nodepass "master://0.0.0.0:9090?log=info"
   ```

3. **备份文件也损坏时**
   - 删除损坏的状态文件：`rm nodepass.gob*`
   - 重新启动主控，将创建新的状态文件
   - 需要重新配置所有实例和设置

4. **预防性备份建议**
   - 定期备份 `nodepass.gob` 到外部存储
   - 调整备份频率：设置环境变量 `export NP_RELOAD_INTERVAL=30m`
   - 监控状态文件大小，异常增长可能表示问题

**最佳实践**：
- 在生产环境中，建议将 `nodepass.gob` 定期备份到不同的存储位置
- 使用配置管理工具保存实例配置的文本形式备份

## 下一步

如果您遇到本指南未涵盖的问题：

- 查看[项目仓库](https://github.com/yosebyte/nodepass)中的已知问题
- 将日志级别增加到`debug`以获取更详细信息
- 查看[工作原理](/docs/zh/how-it-works.md)部分以更好地理解内部机制
- 考虑加入社区讨论，从其他用户处获取帮助