class Util {
    public static string mime_of (File file) {
        try {
            GLib.FileInfo fi = file.query_info ("standard::*", 0, null);
            return fi.get_content_type ();
        } catch (GLib.Error e) {
            warning (e.message);
            return "application/octet-stream";
        }
    }

    public static string escape_html (string html) {
        return html.replace ("&", "&amp;")
            .replace ("<", "&lt;")
            .replace (">", "&gt;");
    }

    public static string unescape_html (string html) {
        return html.replace ("&amp;", "&")
            .replace ("&agrave;", "à")
            .replace ("&eacute;", "é")
            .replace ("&egrave;", "è")
            .replace ("&ecirc;", "ê")
            .replace ("&icirc;", "î")
            .replace ("&lt;", "<")
            .replace ("&gt;", ">")
            .replace ("&#34;", "\"")
            .replace ("&#39;", "'");
    }

    public static string strip_html_markup (string html) {
        var re = new Regex("<[^>]+>([^<]*)</[^>]+>");
        return re.replace (html, html.length, 0, "\\1");
    }

    public static string strip_md_markup (string md) {
        var re = new Regex("[*=]+([^*=]+)[*=]+");
        var link = new Regex("!?\\[([^\\]]*)]\\([^)]*\\)");

        string unlink = link.replace (md, md.length, 0, "\\1");
        return re.replace (unlink, unlink.length, 0, "\\1");
    }

    public static string escape_latex (string latex) {
        return latex.replace ("\\", "\\textbackslash ")
            .replace ("_", "\\_")
            .replace ("#", "\\#")
            .replace ("$", "\\$")
            .replace ("%", "\\%")
            .replace ("^", "\\^")
            .replace ("&", "\\&")
            .replace ("{", "\\{")
            .replace ("}", "\\}")
            .replace ("~", "\\~");
    }

    public static string unescape_latex (string latex) {
        return latex.replace ("\\textbackslash ", "\\")
            .replace ("\\textbackslash{}", "\\")
            .replace ("\\_", "_")
            .replace ("\\#", "#")
            .replace ("\\$", "$")
            .replace ("\\%", "%")
            .replace ("\\^", "^")
            .replace ("\\&", "&")
            .replace ("\\{", "{")
            .replace ("\\}", "}")
            .replace ("\\~", "~");
    }

    public static string strip_latex_markup (string latex) {
        var math = new Regex("\\$([^$]+)\\$");
        string strip = math.replace (latex, latex.length, 0, "\\1");

        bool arg1cont = true;
        bool args2cont = true;
        while (arg1cont || args2cont) {
            var arg1 = new Regex("\\\\[^{[]+{(.+)}");
            if (arg1.match (strip)) {
                strip = arg1.replace (strip, strip.length, 0, "\\1");
                arg1cont = true;
            } else {
                arg1cont = false;
            }

            var args2 = new Regex("\\\\[^{[]+\\[[^\\]]+]{[^}]+}{(.+)}");
            if (args2.match (strip)) {
                strip = args2.replace (strip, strip.length, 0, "\\1");
                args2cont = true;
            } else {
                args2cont = false;
            }
        }

        var block = new Regex("{\\\\[^ ]+ (.+)}");
        return block.replace (strip, strip.length, 0, "\\1");
    }
}
