public class UserDataBackend : Backend, GLib.Object {
    public static string default_list = "default";
    private string? current = null;

    public string[] list () {
        string directory = get_default_dirname ();
        string [] list = {};

        try {
            Dir dir = Dir.open (directory, 0);
            string? name = null;
            while ((name = dir.read_name ()) != null) {
                string path = Path.build_filename (directory, name);

                if (FileUtils.test (path, FileTest.IS_REGULAR)) {
                    list += name;
                }
            }
        } catch (FileError err) {
            warning (err.message);
        }

        if (list.length > 0)
            return list;

	/* default list */
        return { UserDataBackend.default_list };
    }

    public void remove (string name) {
        debug ("removing list %s", name);
        GLib.FileUtils.remove (get_default_dirname () + "/" + name);
    }

    public Item[] use (string name) {
        current = name;

        Item[] items = {};

        File file = File.new_for_path (get_default_dirname () + "/" + name);
        try {
            string line;
            var file_input_stream = file.read ();
            var f_dis = new DataInputStream (file_input_stream);

            while ((line = f_dis.read_line (null)) != null) {
                Item item = new Item.from_string (line);
                items += item;
            }
        } catch (Error e) {
            if (e is IOError.NOT_FOUND) {
                info ("%s", e.message);
            } else {
                warning ("%s", e.message);
            }
        }

        return items;
    }

    public void save (Item[] items) {
        string[] lines = {};
        File file = File.new_for_path (get_default_dirname () + "/" + current);

        foreach (var item in items) {
            lines += item.to_string ();
        }

        save_to_file (lines, file);
    }

    private string get_default_dirname () {
        string user_data = Environment.get_user_data_dir () + "/" + APP_BIN;
        if (!GLib.FileUtils.test (user_data, FileTest.EXISTS)) {
            GLib.DirUtils.create_with_parents (user_data, 0700);
        }

        return user_data;
    }

    private void save_to_file (string[] lines, File file) {
        try {
            var file_fos = file.replace (null, false, FileCreateFlags.NONE);
            var file_dos = new DataOutputStream (file_fos);
            foreach (string line in lines) {
                file_dos.put_string (line + "\n");
            }
        } catch (Error e) {
            warning ("Error: %s\n", e.message);
        }
    }
}
