class UndoRedo {
    private GLib.ListStore[] state = {};
    private int state_index = -1;

    public void clear () {
            foreach (ListStore ls in state) {
                    ls.remove_all();
            }

            state = {};
            state_index = -1;
    }

    public void push (GLib.ListStore model) {
        GLib.ListStore m = new GLib.ListStore (typeof (Item));
        set (m, model);
        if (++state_index < state.length) {
            state[state_index] = m;
            state = state[0:state_index+1];
        } else {
            state += m;
        }
    }

    protected void set (GLib.ListStore model, GLib.ListStore? m) {
        if (m != null) {
            model.remove_all ();
            for (int i = 0; i < m.get_n_items (); i++) {
                model.append (((Item) m.get_item (i)).copy ());
            }
        } else {
            debug ("no model to set");
        }
    }

    public void undo (GLib.ListStore model) {
        set (model, prev ());
    }

    public void redo (GLib.ListStore model) {
        set (model, next());
    }

    protected GLib.ListStore? prev () {
        if (state_index - 1 >= 0) {
            state_index--;
            return state[state_index];
        }

        return null;
    }

    protected GLib.ListStore? next () {
        if (state_index + 1 < state.length) {
            state_index++;
            return state[state_index];
        }

        return null;
    }
}
