/***

  Copyright (C) 2024 Agenda Developers
  Copyright (C) 2025 Benoît Rouits

  This file is part of Myosotis.

  Myosotis is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Myosotis is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Myosotis.  If not, see <http://www.gnu.org/licenses/>.

 ***/


public class PrefsWindow : Gtk.Window {
    public static GLib.Settings settings = new GLib.Settings (APP_ID);
    Gtk.FontButton font_button;
    Gtk.Switch sort_switch;
    Gtk.Switch strike_switch;
    Gtk.Entry important_entry;
    Gtk.ColorDialogButton important_color;

    public PrefsWindow (Gtk.Window parent) {
        Object ();

        this.set_transient_for (parent);
        this.set_modal (true);

        setup_ui ();
    }

    private void setup_ui () {
        this.set_title (_("Preferences"));

        var font_hbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6);
        Gtk.Label font_label = new Gtk.Label (_("Printing font"));
        font_label.hexpand = true;

        this.font_button = new Gtk.FontButton ();
        font_button.set_font (settings.get_string ("print-font-description"));

        font_hbox.homogeneous = true;
        font_hbox.append (font_label);
        font_hbox.append (font_button);

        var sort_hbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6);
        Gtk.Label sort_label = new Gtk.Label (_("Sort checked items upward"));
        sort_label.hexpand = true;

        var hhbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6);
        this.sort_switch = new Gtk.Switch ();
        sort_switch.set_active (settings.get_boolean ("sort-checked-upward"));
        hhbox.append (sort_switch);

        sort_hbox.homogeneous = true;
        sort_hbox.append (sort_label);
        sort_hbox.append (hhbox);

        var strike_hbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6);
        Gtk.Label strike_label = new Gtk.Label (_("Strikethrough checked items"));
        strike_label.hexpand = true;

        hhbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6);
        this.strike_switch = new Gtk.Switch ();
        strike_switch.set_active (settings.get_boolean ("strikethrough-checked"));
        hhbox.append (strike_switch);

        strike_hbox.homogeneous = true;
        strike_hbox.append (strike_label);
        strike_hbox.append (hhbox);

        var important_hbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6);
        Gtk.Label important_label = new Gtk.Label (_("Important word and color"));
        important_label.hexpand = true;

        hhbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6);
        this.important_entry = new Gtk.Entry ();
        important_entry.set_text (settings.get_string ("important-word"));
        hhbox.append (important_entry);

        this.important_color = new Gtk.ColorDialogButton (new Gtk.ColorDialog ());
        Gdk.RGBA color = Gdk.RGBA ();
        color.parse (settings.get_string ("important-color"));
        important_color.set_rgba (color);
        hhbox.append (important_color);


        important_hbox.homogeneous = true;
        important_hbox.append (important_label);
        important_hbox.append (hhbox);

        var buttonbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 6);
        buttonbox.homogeneous = true;
        buttonbox.hexpand = true;

        Gtk.Button cancel = new Gtk.Button.with_label (_("Cancel"));
        cancel.halign = Gtk.Align.START;
        Gtk.Button ok = new Gtk.Button.with_label (_("OK"));
        ok.halign = Gtk.Align.END;

        buttonbox.append (cancel);
        buttonbox.append (ok);

        var vbox = new Gtk.Box (Gtk.Orientation.VERTICAL, 6);
        vbox.margin_end = vbox.margin_start = vbox.margin_top = vbox.margin_bottom = 6;
        vbox.append (font_hbox);
        vbox.append (sort_hbox);
        vbox.append (strike_hbox);
        vbox.append (important_hbox);
        vbox.append (buttonbox);

        ok.clicked.connect (this.on_ok);
        cancel.clicked.connect (this.on_cancel);
        this.set_child (vbox);
    }

    void on_ok () {
        settings.set_string ("print-font-description", font_button.get_font ());
        settings.set_boolean ("sort-checked-upward", sort_switch.get_active ());
        settings.set_boolean ("strikethrough-checked", strike_switch.get_active ());
        settings.set_string ("important-word", important_entry.get_text ());
        settings.set_string ("important-color", important_color.get_rgba ().to_string ());
        this.destroy ();
    }

    void on_cancel () {
        this.destroy ();
    }
}
