public class Ini {
    public Ini () {
        kf = new GLib.KeyFile ();
        var dir = GLib.Environment.get_user_config_dir ();
        path = dir + "/" + APP_BIN + "/" + APP_BIN + ".ini";
        if (!GLib.FileUtils.test (path, FileTest.EXISTS)) {
            DirUtils.create_with_parents (dir + "/" + APP_BIN, 0700);
        }
        try {
            kf.load_from_file (path, 0);
        } catch (Error e) {
            warning ("Could not load KeyFile from %s\n", path);
        }
    }

    public string get_list_name () {
        try {
            return kf.get_string (group, "list_name");
        } catch (Error e) {
            return "default";
        }
    }

    public void set_list_name (string name) {
        kf.set_string (group, "list_name", name);
    }

    public void sync () {
        try {
            kf.save_to_file (path);
        } catch (Error e) {
            warning ("Cannot sync ini file to %s\n", path);
        }
    }
    
    private const string group = "Myosotis";
    private GLib.KeyFile kf;
    private string path;
}
