# myosotis

Small grocery check list application with import/export and printing capability, Myosotis can also be used as a basic todo reminder.

Blue flower icon by [il](https://openclipart.org/detail/327189/pretty-little-flower) released in Public Domain.

## features

- [x] Filtering HTML, LaTeX and Markdown list items on import
- [x] Appending Drag'n'Dropped text file content (filtered)
- [x] Appending text files given by CLI (filtered)
- [x] Sending list by email
- [x] Printing support
- [x] Exporting to Markdown and LaTeX
- [x] Reordering items by dragging them
- [x] Modifying item label afterward
- [x] Supporting undo / redo
- [x] Fetching and appending content of Drag'n'Dropped URI
- [x] Detecting configurable important word and colorizing item
- [x] Multiple lists support

## screenshots
![dark theme screenshot](dark.png)

![light theme screenshot](light.png)

## building and installing

```
$ meson setup build
$ ninja -C build
$ ninja -C build install
```

## debugging

```
$ G_MESSAGES_DEBUG=myosotis myosotis
```

## translating

```
$ ninja -C build myosotis-pot
$ ninja -C build myosotis-update-po
$ edit po/$LANG.po
```

## issues

- pressing Ctrl-Z or Shift-Ctrl-Z during edition of an item does not trigger local undo/redo.


