/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         JSON_STYPE
/* Substitute the variable and function names.  */
#define yyparse         json_parse
#define yylex           json_lex
#define yyerror         json_error
#define yydebug         json_debug
#define yynerrs         json_nerrs
#define yylval          json_lval
#define yychar          json_char

/* First part of user prologue.  */
#line 1 "jsonparser.y"

/*
 * Copyright (C) 2021-2026 Pierre POMES <pierre.pomes@gmail.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#include "config.h"
#include "myanon.h"
#include "json.h"

#define JSON_PATH_SEGMENT_SIZE 256

int json_line_nb = 1;

typedef enum {
    JSON_STRING,
    JSON_NUMBER,
    JSON_OBJECT,
    JSON_ARRAY,
    JSON_TRUE,
    JSON_FALSE,
    JSON_NULL
} json_value_type;

struct json_value_st {
    json_value_type type;
    union {
        char *string;
        double number;
        json_object_st *object;
        json_array_st *array;
    } data;
};

struct json_member_st {
    char *key;
    json_value_st *value;
    json_member_st *next;
};

struct json_object_st {
    json_member_st *members;
};

struct json_array_st {
    json_value_st **elements;
    size_t size;
    size_t capacity;
};

static json_value_st *json_root = NULL;

static json_value_st *create_json_value(json_value_type type);
static json_object_st *create_json_object(void);
static json_array_st *create_json_array(void);
static void add_member_to_object(json_object_st *obj, char *key, json_value_st *value);
static void add_element_to_array(json_array_st *arr, json_value_st *value);
static void free_json_value(json_value_st *value);
static void print_json_value(json_value_st *value, int indent);

typedef void (*json_visitor_fn)(const char *path, json_value_st *value, void *context);
static void visit_json_value(json_value_st *value, const char *path, json_visitor_fn visitor, void *context);

/* Utility function - safe strdup using myanon's utilities */
static char *mystrdup(const char *s) {
    if (!s) return NULL;
    size_t len = strlen(s) + 1;
    char *p = mymalloc(len);
    mystrcpy(p, s, len);
    return p;
}

/* Safe realloc wrapper */
static void *myrealloc(void *ptr, size_t size) {
    void *new_ptr = realloc(ptr, size);
    if (!new_ptr && size > 0) {
        fprintf(stderr, "ERROR: realloc failed for size %zu\n", size);
        exit(1);
    }
    return new_ptr;
}


#line 192 "jsonparser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_JSON_JSONPARSER_H_INCLUDED
# define YY_JSON_JSONPARSER_H_INCLUDED
/* Debug traces.  */
#ifndef JSON_DEBUG
# if defined YYDEBUG
#if YYDEBUG
#   define JSON_DEBUG 1
#  else
#   define JSON_DEBUG 0
#  endif
# else /* ! defined YYDEBUG */
#  define JSON_DEBUG 0
# endif /* ! defined YYDEBUG */
#endif  /* ! defined JSON_DEBUG */
#if JSON_DEBUG
extern int json_debug;
#endif

/* Token kinds.  */
#ifndef JSON_TOKENTYPE
# define JSON_TOKENTYPE
  enum json_tokentype
  {
    JSON_EMPTY = -2,
    JSON_EOF = 0,                  /* "end of file"  */
    JSON_error = 256,              /* error  */
    JSON_UNDEF = 257,              /* "invalid token"  */
    LBRACE = 258,                  /* LBRACE  */
    RBRACE = 259,                  /* RBRACE  */
    LBRACKET = 260,                /* LBRACKET  */
    RBRACKET = 261,                /* RBRACKET  */
    COMMA = 262,                   /* COMMA  */
    COLON = 263,                   /* COLON  */
    TRUE_VAL = 264,                /* TRUE_VAL  */
    FALSE_VAL = 265,               /* FALSE_VAL  */
    NULL_VAL = 266,                /* NULL_VAL  */
    ERROR = 267,                   /* ERROR  */
    STRING = 268,                  /* STRING  */
    NUMBER_INT = 269,              /* NUMBER_INT  */
    NUMBER_FLOAT = 270             /* NUMBER_FLOAT  */
  };
  typedef enum json_tokentype json_token_kind_t;
#endif
/* Token kinds.  */
#define JSON_EMPTY -2
#define JSON_EOF 0
#define JSON_error 256
#define JSON_UNDEF 257
#define LBRACE 258
#define RBRACE 259
#define LBRACKET 260
#define RBRACKET 261
#define COMMA 262
#define COLON 263
#define TRUE_VAL 264
#define FALSE_VAL 265
#define NULL_VAL 266
#define ERROR 267
#define STRING 268
#define NUMBER_INT 269
#define NUMBER_FLOAT 270

/* Value type.  */
#if ! defined JSON_STYPE && ! defined JSON_STYPE_IS_DECLARED
union JSON_STYPE
{
#line 116 "jsonparser.y"

    char strval[CONFIG_SIZE];
    long intval;
    double dblval;
    json_value_st *jsonval;
    json_object_st *objval;
    json_array_st *arrval;
    json_member_st *memberval;

#line 293 "jsonparser.c"

};
typedef union JSON_STYPE JSON_STYPE;
# define JSON_STYPE_IS_TRIVIAL 1
# define JSON_STYPE_IS_DECLARED 1
#endif


extern JSON_STYPE json_lval;


int json_parse (void);


#endif /* !YY_JSON_JSONPARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_LBRACE = 3,                     /* LBRACE  */
  YYSYMBOL_RBRACE = 4,                     /* RBRACE  */
  YYSYMBOL_LBRACKET = 5,                   /* LBRACKET  */
  YYSYMBOL_RBRACKET = 6,                   /* RBRACKET  */
  YYSYMBOL_COMMA = 7,                      /* COMMA  */
  YYSYMBOL_COLON = 8,                      /* COLON  */
  YYSYMBOL_TRUE_VAL = 9,                   /* TRUE_VAL  */
  YYSYMBOL_FALSE_VAL = 10,                 /* FALSE_VAL  */
  YYSYMBOL_NULL_VAL = 11,                  /* NULL_VAL  */
  YYSYMBOL_ERROR = 12,                     /* ERROR  */
  YYSYMBOL_STRING = 13,                    /* STRING  */
  YYSYMBOL_NUMBER_INT = 14,                /* NUMBER_INT  */
  YYSYMBOL_NUMBER_FLOAT = 15,              /* NUMBER_FLOAT  */
  YYSYMBOL_YYACCEPT = 16,                  /* $accept  */
  YYSYMBOL_json = 17,                      /* json  */
  YYSYMBOL_value = 18,                     /* value  */
  YYSYMBOL_object = 19,                    /* object  */
  YYSYMBOL_object_content = 20,            /* object_content  */
  YYSYMBOL_members = 21,                   /* members  */
  YYSYMBOL_member = 22,                    /* member  */
  YYSYMBOL_array = 23,                     /* array  */
  YYSYMBOL_array_content = 24              /* array_content  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined JSON_STYPE_IS_TRIVIAL && JSON_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  21
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   30

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  16
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  9
/* YYNRULES -- Number of rules.  */
#define YYNRULES  20
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  30

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   270


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15
};

#if JSON_DEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint8 yyrline[] =
{
       0,   142,   142,   146,   147,   148,   152,   156,   160,   161,
     162,   166,   170,   177,   191,   192,   201,   210,   214,   228,
     233
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if JSON_DEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "LBRACE", "RBRACE",
  "LBRACKET", "RBRACKET", "COMMA", "COLON", "TRUE_VAL", "FALSE_VAL",
  "NULL_VAL", "ERROR", "STRING", "NUMBER_INT", "NUMBER_FLOAT", "$accept",
  "json", "value", "object", "object_content", "members", "member",
  "array", "array_content", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-5)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
      14,     1,    -2,    -5,    -5,    -5,    -5,    -5,    -5,     2,
      -5,    -5,    -5,    -5,     7,     6,    -1,    -5,    -5,     9,
      12,    -5,    14,    -5,     8,    14,    -5,    -5,    -5,    -5
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,     0,     0,     8,     9,    10,     5,     6,     7,     0,
       2,     3,     4,    11,     0,     0,    13,    14,    17,    19,
       0,     1,     0,    12,     0,     0,    18,    16,    15,    20
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
      -5,    -5,     0,    -5,    -5,    -5,    -4,    -5,     5
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     9,    19,    11,    15,    16,    17,    12,    20
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      10,     1,    21,     2,    18,    13,    24,     3,     4,     5,
      23,     6,     7,     8,    14,    22,    25,     1,    26,     2,
      28,    14,    27,     3,     4,     5,     0,     6,     7,     8,
      29
};

static const yytype_int8 yycheck[] =
{
       0,     3,     0,     5,     6,     4,     7,     9,    10,    11,
       4,    13,    14,    15,    13,     8,     7,     3,     6,     5,
      24,    13,    22,     9,    10,    11,    -1,    13,    14,    15,
      25
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     5,     9,    10,    11,    13,    14,    15,    17,
      18,    19,    23,     4,    13,    20,    21,    22,     6,    18,
      24,     0,     8,     4,     7,     7,     6,    18,    22,    24
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    16,    17,    18,    18,    18,    18,    18,    18,    18,
      18,    19,    19,    20,    21,    21,    22,    23,    23,    24,
      24
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     1,     1,     3,     3,     2,     3,     1,
       3
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = JSON_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == JSON_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use JSON_error or JSON_UNDEF. */
#define YYERRCODE JSON_UNDEF


/* Enable debugging if requested.  */
#if JSON_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !JSON_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !JSON_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = JSON_EMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == JSON_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= JSON_EOF)
    {
      yychar = JSON_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == JSON_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = JSON_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = JSON_EMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* json: value  */
#line 142 "jsonparser.y"
          { json_root = (yyvsp[0].jsonval); (yyval.jsonval) = (yyvsp[0].jsonval); }
#line 1305 "jsonparser.c"
    break;

  case 3: /* value: object  */
#line 146 "jsonparser.y"
                { (yyval.jsonval) = (yyvsp[0].jsonval); }
#line 1311 "jsonparser.c"
    break;

  case 4: /* value: array  */
#line 147 "jsonparser.y"
                { (yyval.jsonval) = (yyvsp[0].jsonval); }
#line 1317 "jsonparser.c"
    break;

  case 5: /* value: STRING  */
#line 148 "jsonparser.y"
                { 
                  (yyval.jsonval) = create_json_value(JSON_STRING);
                  (yyval.jsonval)->data.string = mystrdup((yyvsp[0].strval));
                }
#line 1326 "jsonparser.c"
    break;

  case 6: /* value: NUMBER_INT  */
#line 152 "jsonparser.y"
                 { 
                  (yyval.jsonval) = create_json_value(JSON_NUMBER);
                  (yyval.jsonval)->data.number = (double)(yyvsp[0].intval);
                }
#line 1335 "jsonparser.c"
    break;

  case 7: /* value: NUMBER_FLOAT  */
#line 156 "jsonparser.y"
                   { 
                  (yyval.jsonval) = create_json_value(JSON_NUMBER);
                  (yyval.jsonval)->data.number = (yyvsp[0].dblval);
                }
#line 1344 "jsonparser.c"
    break;

  case 8: /* value: TRUE_VAL  */
#line 160 "jsonparser.y"
                { (yyval.jsonval) = create_json_value(JSON_TRUE); }
#line 1350 "jsonparser.c"
    break;

  case 9: /* value: FALSE_VAL  */
#line 161 "jsonparser.y"
                { (yyval.jsonval) = create_json_value(JSON_FALSE); }
#line 1356 "jsonparser.c"
    break;

  case 10: /* value: NULL_VAL  */
#line 162 "jsonparser.y"
                { (yyval.jsonval) = create_json_value(JSON_NULL); }
#line 1362 "jsonparser.c"
    break;

  case 11: /* object: LBRACE RBRACE  */
#line 166 "jsonparser.y"
                  { 
        (yyval.jsonval) = create_json_value(JSON_OBJECT);
        (yyval.jsonval)->data.object = create_json_object();
    }
#line 1371 "jsonparser.c"
    break;

  case 12: /* object: LBRACE object_content RBRACE  */
#line 170 "jsonparser.y"
                                   { 
        (yyval.jsonval) = create_json_value(JSON_OBJECT);
        (yyval.jsonval)->data.object = (yyvsp[-1].objval);
    }
#line 1380 "jsonparser.c"
    break;

  case 13: /* object_content: members  */
#line 177 "jsonparser.y"
            { 
        json_object_st *obj = create_json_object();
        json_member_st *m = (yyvsp[0].memberval);
        while (m) {
            add_member_to_object(obj, m->key, m->value);
            json_member_st *next = m->next;
            free(m);
            m = next;
        }
        (yyval.objval) = obj;
    }
#line 1396 "jsonparser.c"
    break;

  case 14: /* members: member  */
#line 191 "jsonparser.y"
           { (yyval.memberval) = (yyvsp[0].memberval); }
#line 1402 "jsonparser.c"
    break;

  case 15: /* members: members COMMA member  */
#line 192 "jsonparser.y"
                           { 
        json_member_st *m = (yyvsp[-2].memberval);
        while (m->next != NULL) m = m->next;
        m->next = (yyvsp[0].memberval);
        (yyval.memberval) = (yyvsp[-2].memberval);
    }
#line 1413 "jsonparser.c"
    break;

  case 16: /* member: STRING COLON value  */
#line 201 "jsonparser.y"
                       { 
        (yyval.memberval) = mymalloc(sizeof(json_member_st));
        (yyval.memberval)->key = mystrdup((yyvsp[-2].strval));
        (yyval.memberval)->value = (yyvsp[0].jsonval);
        (yyval.memberval)->next = NULL;
    }
#line 1424 "jsonparser.c"
    break;

  case 17: /* array: LBRACKET RBRACKET  */
#line 210 "jsonparser.y"
                      { 
        (yyval.jsonval) = create_json_value(JSON_ARRAY);
        (yyval.jsonval)->data.array = create_json_array();
    }
#line 1433 "jsonparser.c"
    break;

  case 18: /* array: LBRACKET array_content RBRACKET  */
#line 214 "jsonparser.y"
                                      { 
        (yyval.jsonval) = create_json_value(JSON_ARRAY);
        /* Reverse the array to get correct order */
        size_t i, j;
        for (i = 0, j = (yyvsp[-1].arrval)->size - 1; i < j; i++, j--) {
            json_value_st *temp = (yyvsp[-1].arrval)->elements[i];
            (yyvsp[-1].arrval)->elements[i] = (yyvsp[-1].arrval)->elements[j];
            (yyvsp[-1].arrval)->elements[j] = temp;
        }
        (yyval.jsonval)->data.array = (yyvsp[-1].arrval);
    }
#line 1449 "jsonparser.c"
    break;

  case 19: /* array_content: value  */
#line 228 "jsonparser.y"
          { 
        json_array_st *arr = create_json_array();
        add_element_to_array(arr, (yyvsp[0].jsonval));
        (yyval.arrval) = arr;
    }
#line 1459 "jsonparser.c"
    break;

  case 20: /* array_content: value COMMA array_content  */
#line 233 "jsonparser.y"
                                { 
        add_element_to_array((yyvsp[0].arrval), (yyvsp[-2].jsonval));
        (yyval.arrval) = (yyvsp[0].arrval);
    }
#line 1468 "jsonparser.c"
    break;


#line 1472 "jsonparser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == JSON_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= JSON_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == JSON_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = JSON_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != JSON_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 239 "jsonparser.y"


static json_value_st *create_json_value(json_value_type type) {
    json_value_st *val = mymalloc(sizeof(json_value_st));
    val->type = type;
    return val;
}

static json_object_st *create_json_object(void) {
    json_object_st *obj = mymalloc(sizeof(json_object_st));
    obj->members = NULL;
    return obj;
}

static json_array_st *create_json_array(void) {
    json_array_st *arr = mymalloc(sizeof(json_array_st));
    arr->elements = NULL;
    arr->size = 0;
    arr->capacity = 0;
    return arr;
}

static void add_member_to_object(json_object_st *obj, char *key, json_value_st *value) {
    json_member_st *member = mymalloc(sizeof(json_member_st));
    member->key = key;
    member->value = value;
    member->next = NULL;
    
    if (obj->members == NULL) {
        obj->members = member;
    } else {
        json_member_st *last = obj->members;
        while (last->next != NULL) {
            last = last->next;
        }
        last->next = member;
    }
}

static void add_element_to_array(json_array_st *arr, json_value_st *value) {
    if (arr->size >= arr->capacity) {
        size_t new_capacity = arr->capacity == 0 ? 8 : arr->capacity * 2;
        arr->elements = myrealloc(arr->elements, new_capacity * sizeof(json_value_st *));
        arr->capacity = new_capacity;
    }
    arr->elements[arr->size++] = value;
}

static void free_json_value(json_value_st *value) {
    if (!value) return;
    
    switch (value->type) {
        case JSON_STRING:
            free(value->data.string);
            break;
        case JSON_OBJECT:
            if (value->data.object) {
                json_member_st *m = value->data.object->members;
                while (m) {
                    json_member_st *next = m->next;
                    free(m->key);
                    free_json_value(m->value);
                    free(m);
                    m = next;
                }
                free(value->data.object);
            }
            break;
        case JSON_ARRAY:
            if (value->data.array) {
                for (size_t i = 0; i < value->data.array->size; i++) {
                    free_json_value(value->data.array->elements[i]);
                }
                free(value->data.array->elements);
                free(value->data.array);
            }
            break;
        default:
            break;
    }
    free(value);
}

static void print_json_value(json_value_st *value, int indent) {
    if (!value) return;
    
    switch (value->type) {
        case JSON_STRING:
            printf("\"%s\"", value->data.string);
            break;
        case JSON_NUMBER:
            if (value->data.number == (long)value->data.number) {
                printf("%ld", (long)value->data.number);
            } else {
                printf("%g", value->data.number);
            }
            break;
        case JSON_OBJECT:
            printf("{");
            if (value->data.object && value->data.object->members) {
                printf("\n");
                json_member_st *m = value->data.object->members;
                while (m) {
                    for (int i = 0; i < indent + 2; i++) printf(" ");
                    printf("\"%s\": ", m->key);
                    print_json_value(m->value, indent + 2);
                    if (m->next) printf(",");
                    printf("\n");
                    m = m->next;
                }
                for (int i = 0; i < indent; i++) printf(" ");
            }
            printf("}");
            break;
        case JSON_ARRAY:
            printf("[");
            if (value->data.array && value->data.array->size > 0) {
                printf("\n");
                for (size_t i = 0; i < value->data.array->size; i++) {
                    for (int j = 0; j < indent + 2; j++) printf(" ");
                    print_json_value(value->data.array->elements[i], indent + 2);
                    if (i < value->data.array->size - 1) printf(",");
                    printf("\n");
                }
                for (int i = 0; i < indent; i++) printf(" ");
            }
            printf("]");
            break;
        case JSON_TRUE:
            printf("true");
            break;
        case JSON_FALSE:
            printf("false");
            break;
        case JSON_NULL:
            printf("null");
            break;
    }
}

static void visit_json_value(json_value_st *value, const char *path, json_visitor_fn visitor, void *context) {
    if (!value) return;
    
    visitor(path, value, context);
    
    switch (value->type) {
        case JSON_OBJECT:
            if (value->data.object && value->data.object->members) {
                json_member_st *m = value->data.object->members;
                while (m) {
                    size_t path_len = strlen(path) + strlen(m->key) + 2;
                    char *new_path = mymalloc(path_len);
                    snprintf(new_path, path_len, "%s.%s", path, m->key);
                    visit_json_value(m->value, new_path, visitor, context);
                    free(new_path);
                    m = m->next;
                }
            }
            break;
        case JSON_ARRAY:
            if (value->data.array) {
                for (size_t i = 0; i < value->data.array->size; i++) {
                    size_t path_len = strlen(path) + 20;
                    char *new_path = mymalloc(path_len);
                    snprintf(new_path, path_len, "%s[%zu]", path, i);
                    visit_json_value(value->data.array->elements[i], new_path, visitor, context);
                    free(new_path);
                }
            }
            break;
        default:
            break;
    }
}

static bool json_set_value_at_path(json_value_st *value, const char *path, const char *new_value);
static void json_to_string_internal(json_value_st *value, char **buffer, size_t *size, size_t *pos);

json_value_st *json_parse_string(const char *input) {
    json_root = NULL;
    json_line_nb = 1;
    
    FILE *tmp = tmpfile();
    if (!tmp) return NULL;
    
    fwrite(input, 1, strlen(input), tmp);
    rewind(tmp);
    
    json_in = tmp;
    int ret = json_parse();
    fclose(tmp);
    
    /* Clean up lexer buffers */
    json_lex_destroy();
    
    if (ret != 0) {
        if (json_root) {
            free_json_value(json_root);
            json_root = NULL;
        }
    }
    
    return json_root;
}

void json_replace_value_at_path(json_value_st *root, const char *path, const char *new_value) {
    if (!root || !path || !new_value) return;
    
    /* Skip leading dot if present */
    if (*path == '.') path++;
    
    json_set_value_at_path(root, path, new_value);
}

static json_value_st *json_get_value_at_path(json_value_st *value, const char *path) {
    if (!value || !path) return NULL;
    
    if (*path == '\0') {
        return value;
    }
    
    char segment[JSON_PATH_SEGMENT_SIZE];
    const char *next_path = path;
    size_t i = 0;
    
    while (*next_path && *next_path != '.' && *next_path != '[' && i < sizeof(segment) - 1) {
        segment[i++] = *next_path++;
    }
    segment[i] = '\0';
    
    if (*next_path == '.') next_path++;
    
    if (value->type == JSON_OBJECT && value->data.object) {
        json_member_st *m = value->data.object->members;
        while (m) {
            if (strcmp(m->key, segment) == 0) {
                return json_get_value_at_path(m->value, next_path);
            }
            m = m->next;
        }
    } else if (value->type == JSON_ARRAY && value->data.array && *segment == '[') {
        char *end;
        long index = strtol(segment + 1, &end, 10);
        if (*end == ']' && index >= 0 && (size_t)index < value->data.array->size) {
            return json_get_value_at_path(value->data.array->elements[index], next_path);
        }
    }
    
    return NULL;
}

char *json_get_string_at_path(json_value_st *root, const char *path) {
    if (!root || !path) return NULL;
    
    /* Skip leading dot if present */
    if (*path == '.') path++;
    
    json_value_st *value = json_get_value_at_path(root, path);
    if (value && value->type == JSON_STRING) {
        return value->data.string;
    }
    return NULL;
}

typedef bool (*json_value_processor)(json_value_st *value, void *context);

static bool json_set_value_at_path_with_processor(json_value_st *value, const char *path, 
                                                  json_value_processor processor, void *context);

static bool json_set_value_at_path(json_value_st *value, const char *path, const char *new_value) {
    if (!value || !path || !new_value) return false;
    
    if (*path == '\0') {
        if (value->type == JSON_STRING) {
            free(value->data.string);
            value->data.string = mystrdup(new_value);
            return true;
        }
        return false;
    }
    
    /* Handle array wildcard at start of path */
    if (*path == '[') {
        if (*(path + 1) == ']') {
            /* Wildcard array access [] */
            if (value->type == JSON_ARRAY && value->data.array) {
                bool any_success = false;
                const char *remaining_path = path + 2;
                if (*remaining_path == '.') remaining_path++;
                
                for (size_t i = 0; i < value->data.array->size; i++) {
                    if (json_set_value_at_path(value->data.array->elements[i], remaining_path, new_value)) {
                        any_success = true;
                    }
                }
                return any_success;
            }
        } else {
            /* Specific index [n] */
            char *end;
            long index = strtol(path + 1, &end, 10);
            if (*end == ']' && index >= 0 && (size_t)index < value->data.array->size) {
                const char *remaining_path = end + 1;
                if (*remaining_path == '.') remaining_path++;
                return json_set_value_at_path(value->data.array->elements[index], remaining_path, new_value);
            }
        }
        return false;
    }
    
    char segment[JSON_PATH_SEGMENT_SIZE];
    const char *next_path = path;
    size_t i = 0;
    
    while (*next_path && *next_path != '.' && *next_path != '[' && i < sizeof(segment) - 1) {
        segment[i++] = *next_path++;
    }
    segment[i] = '\0';
    
    if (*next_path == '.') next_path++;
    
    if (value->type == JSON_OBJECT && value->data.object) {
        json_member_st *m = value->data.object->members;
        while (m) {
            if (strcmp(m->key, segment) == 0) {
                /* Check if next_path starts with array access */
                if (*next_path == '[') {
                    if (*(next_path + 1) == ']') {
                        /* Wildcard array access */
                        if (m->value->type == JSON_ARRAY && m->value->data.array) {
                            bool any_success = false;
                            const char *remaining_path = next_path + 2;
                            if (*remaining_path == '.') remaining_path++;
                            
                            for (size_t i = 0; i < m->value->data.array->size; i++) {
                                if (json_set_value_at_path(m->value->data.array->elements[i], remaining_path, new_value)) {
                                    any_success = true;
                                }
                            }
                            return any_success;
                        }
                    } else {
                        /* Specific index */
                        char *end;
                        long index = strtol(next_path + 1, &end, 10);
                        if (*end == ']' && m->value->type == JSON_ARRAY && 
                            m->value->data.array && index >= 0 && 
                            (size_t)index < m->value->data.array->size) {
                            const char *remaining_path = end + 1;
                            if (*remaining_path == '.') remaining_path++;
                            return json_set_value_at_path(m->value->data.array->elements[index], remaining_path, new_value);
                        }
                    }
                    return false;
                } else {
                    return json_set_value_at_path(m->value, next_path, new_value);
                }
            }
            m = m->next;
        }
    }
    
    return false;
}

char *json_to_string(json_value_st *value) {
    if (!value) return NULL;
    
    size_t size = 1024;
    size_t pos = 0;
    char *buffer = mymalloc(size);
    
    json_to_string_internal(value, &buffer, &size, &pos);
    buffer[pos] = '\0';
    
    return buffer;
}

static void json_to_string_internal(json_value_st *value, char **buffer, size_t *size, size_t *pos) {
    if (!value) return;
    
    #define APPEND_STR(str) do { \
        size_t len = strlen(str); \
        while (*pos + len >= *size) { \
            *size *= 2; \
            *buffer = myrealloc(*buffer, *size); \
        } \
        memcpy(*buffer + *pos, str, len); \
        *pos += len; \
    } while(0)
    
    #define APPEND_CHAR(c) do { \
        if (*pos + 1 >= *size) { \
            *size *= 2; \
            *buffer = myrealloc(*buffer, *size); \
        } \
        (*buffer)[(*pos)++] = c; \
    } while(0)
    
    switch (value->type) {
        case JSON_STRING:
            APPEND_CHAR('"');
            /* Strings already contain escape sequences from parsing, just output as-is */
            APPEND_STR(value->data.string);
            APPEND_CHAR('"');
            break;
            
        case JSON_NUMBER:
            {
                char num_str[64];
                if (value->data.number == (long)value->data.number) {
                    snprintf(num_str, sizeof(num_str), "%ld", (long)value->data.number);
                } else {
                    snprintf(num_str, sizeof(num_str), "%g", value->data.number);
                }
                APPEND_STR(num_str);
            }
            break;
            
        case JSON_OBJECT:
            APPEND_CHAR('{');
            if (value->data.object && value->data.object->members) {
                json_member_st *m = value->data.object->members;
                bool first = true;
                while (m) {
                    if (!first) APPEND_CHAR(',');
                    APPEND_CHAR('"');
                    APPEND_STR(m->key);
                    APPEND_STR("\":");
                    json_to_string_internal(m->value, buffer, size, pos);
                    first = false;
                    m = m->next;
                }
            }
            APPEND_CHAR('}');
            break;
            
        case JSON_ARRAY:
            APPEND_CHAR('[');
            if (value->data.array && value->data.array->size > 0) {
                for (size_t i = 0; i < value->data.array->size; i++) {
                    if (i > 0) APPEND_CHAR(',');
                    json_to_string_internal(value->data.array->elements[i], buffer, size, pos);
                }
            }
            APPEND_CHAR(']');
            break;
            
        case JSON_TRUE:
            APPEND_STR("true");
            break;
            
        case JSON_FALSE:
            APPEND_STR("false");
            break;
            
        case JSON_NULL:
            APPEND_STR("null");
            break;
    }
    
    #undef APPEND_STR
    #undef APPEND_CHAR
}

void json_free_value(json_value_st *value) {
    free_json_value(value);
}

bool json_path_has_wildcards(const char *path) {
    if (!path) return false;
    return strstr(path, "[]") != NULL;
}

typedef struct {
    char *value;
    char *new_value;
} json_replacement_st;

static bool json_process_wildcard_values(json_value_st *value, const char *path, 
                                        bool (*processor)(const char *value, void *context),
                                        void *context) {
    if (!value || !path || !processor) return false;
    
    /* Skip leading dot if present */
    if (*path == '.') path++;
    
    if (*path == '\0') {
        if (value->type == JSON_STRING) {
            return processor(value->data.string, context);
        }
        return false;
    }
    
    /* Handle array wildcard at start of path */
    if (*path == '[') {
        if (*(path + 1) == ']') {
            /* Wildcard array access [] */
            if (value->type == JSON_ARRAY && value->data.array) {
                bool any_success = false;
                const char *remaining_path = path + 2;
                if (*remaining_path == '.') remaining_path++;
                
                for (size_t i = 0; i < value->data.array->size; i++) {
                    if (json_process_wildcard_values(value->data.array->elements[i], 
                                                   remaining_path, processor, context)) {
                        any_success = true;
                    }
                }
                return any_success;
            }
        }
        return false;
    }
    
    char segment[JSON_PATH_SEGMENT_SIZE];
    const char *next_path = path;
    size_t i = 0;
    
    while (*next_path && *next_path != '.' && *next_path != '[' && i < sizeof(segment) - 1) {
        segment[i++] = *next_path++;
    }
    segment[i] = '\0';
    
    if (*next_path == '.') next_path++;
    
    if (value->type == JSON_OBJECT && value->data.object) {
        json_member_st *m = value->data.object->members;
        while (m) {
            if (strcmp(m->key, segment) == 0) {
                /* Check if next_path starts with array access */
                if (*next_path == '[') {
                    if (*(next_path + 1) == ']') {
                        /* Wildcard array access */
                        if (m->value->type == JSON_ARRAY && m->value->data.array) {
                            bool any_success = false;
                            const char *remaining_path = next_path + 2;
                            if (*remaining_path == '.') remaining_path++;
                            
                            for (size_t i = 0; i < m->value->data.array->size; i++) {
                                if (json_process_wildcard_values(m->value->data.array->elements[i], 
                                                               remaining_path, processor, context)) {
                                    any_success = true;
                                }
                            }
                            return any_success;
                        }
                    }
                    return false;
                } else {
                    return json_process_wildcard_values(m->value, next_path, processor, context);
                }
            }
            m = m->next;
        }
    }
    
    return false;
}

typedef struct {
    anon_base_st *infos;
    bool is_fixed;
    char *fixed_value;
} wildcard_context_st;

static bool wildcard_anonymize_processor(const char *value, void *context) {
    wildcard_context_st *ctx = (wildcard_context_st *)context;
    
    if (ctx->is_fixed) {
        /* For fixed values, we don't need to process, just mark success */
        return true;
    } else {
        /* For anonymization, we need to process each value */
        anonymized_res_st *res = anonymize_token(false, ctx->infos, (char *)value, strlen(value), NULL);
        anonymized_res_free(res);
        /* The actual replacement happens in the main function */
        return true;
    }
}

typedef struct {
    anon_base_st *infos;
    char *fixed_value;
} json_anonymize_context_st;

static bool json_anonymize_value(json_value_st *value, const char *path, json_anonymize_context_st *ctx);

static bool json_anonymize_at_path(json_value_st *value, const char *path, json_anonymize_context_st *ctx) {
    if (!value || !path || !ctx) return false;
    
    /* Skip leading dot if present */
    if (*path == '.') path++;
    
    if (*path == '\0') {
        if (value->type == JSON_STRING) {
            if (ctx->fixed_value) {
                free(value->data.string);
                value->data.string = mystrdup(ctx->fixed_value);
            } else {
                anonymized_res_st *res = anonymize_token(false, ctx->infos, value->data.string, strlen(value->data.string), NULL);
                char *new_string = mymalloc(res->len + 1);
                memcpy(new_string, res->data, res->len);
                new_string[res->len] = '\0';
                free(value->data.string);
                value->data.string = new_string;
                anonymized_res_free(res);
            }
            return true;
        }
        return false;
    }
    
    /* Handle array wildcard at start of path */
    if (*path == '[') {
        if (*(path + 1) == ']') {
            /* Wildcard array access [] */
            if (value->type == JSON_ARRAY && value->data.array) {
                bool any_success = false;
                const char *remaining_path = path + 2;
                if (*remaining_path == '.') remaining_path++;
                
                for (size_t i = 0; i < value->data.array->size; i++) {
                    if (json_anonymize_at_path(value->data.array->elements[i], remaining_path, ctx)) {
                        any_success = true;
                    }
                }
                return any_success;
            }
        } else {
            /* Specific index [n] */
            char *end;
            long index = strtol(path + 1, &end, 10);
            if (*end == ']' && value->type == JSON_ARRAY && value->data.array &&
                index >= 0 && (size_t)index < value->data.array->size) {
                const char *remaining_path = end + 1;
                if (*remaining_path == '.') remaining_path++;
                return json_anonymize_at_path(value->data.array->elements[index], remaining_path, ctx);
            }
        }
        return false;
    }
    
    char segment[JSON_PATH_SEGMENT_SIZE];
    const char *next_path = path;
    size_t i = 0;
    
    while (*next_path && *next_path != '.' && *next_path != '[' && i < sizeof(segment) - 1) {
        segment[i++] = *next_path++;
    }
    segment[i] = '\0';
    
    if (*next_path == '.') next_path++;
    
    if (value->type == JSON_OBJECT && value->data.object) {
        json_member_st *m = value->data.object->members;
        while (m) {
            if (strcmp(m->key, segment) == 0) {
                /* Check if next_path starts with array access */
                if (*next_path == '[') {
                    if (*(next_path + 1) == ']') {
                        /* Wildcard array access */
                        if (m->value->type == JSON_ARRAY && m->value->data.array) {
                            bool any_success = false;
                            const char *remaining_path = next_path + 2;
                            if (*remaining_path == '.') remaining_path++;
                            
                            for (size_t i = 0; i < m->value->data.array->size; i++) {
                                if (json_anonymize_at_path(m->value->data.array->elements[i], remaining_path, ctx)) {
                                    any_success = true;
                                }
                            }
                            return any_success;
                        }
                    } else {
                        /* Specific index */
                        char *end;
                        long index = strtol(next_path + 1, &end, 10);
                        if (*end == ']' && m->value->type == JSON_ARRAY && 
                            m->value->data.array && index >= 0 && 
                            (size_t)index < m->value->data.array->size) {
                            const char *remaining_path = end + 1;
                            if (*remaining_path == '.') remaining_path++;
                            return json_anonymize_at_path(m->value->data.array->elements[index], remaining_path, ctx);
                        }
                    }
                    return false;
                } else {
                    return json_anonymize_at_path(m->value, next_path, ctx);
                }
            }
            m = m->next;
        }
    }
    
    return false;
}

void json_anonymize_path(json_value_st *root, const char *path, anon_base_st *infos, char *fixed_value) {
    if (!root || !path) return;
    
    json_anonymize_context_st ctx = {
        .infos = infos,
        .fixed_value = fixed_value
    };
    
    json_anonymize_at_path(root, path, &ctx);
}

void json_error(const char *s) {
    fprintf(stderr, "JSON parse error at line %d: %s\n", json_line_nb, s);
}

extern int json_lex();
extern FILE *json_in;
