#include <iostream>
#include <random>

#include "test.h"

#include "typing_line.h"

TEST_CASE("insertion") {
	TypingLine tl;
	tl.process('h');
	tl.process('l');
	tl.process('l');
	tl.process(KEY_LEFT);
	tl.process(KEY_LEFT);
	tl.process('e');
	tl.process(KEY_END);
	tl.process('o');
	tl.process('\n');
	CHECK(tl.result());
	CHECK(tl.typed() == "hello");
}

TEST_CASE("insertion home") {
	TypingLine tl;
	tl.process('l');
	tl.process('l');
	tl.process(KEY_HOME);
	tl.process('e');
	tl.process(KEY_LEFT);
	tl.process('h');
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process('o');
	tl.process('\n');
	CHECK(tl.result());
	CHECK(tl.typed() == "hello");
}

TEST_CASE("insertion empty") {
	TypingLine tl;
	tl.process(KEY_HOME);
	tl.process(KEY_LEFT);
	tl.process(KEY_LEFT);
	tl.process(KEY_LEFT);
	tl.process('h');
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process(KEY_RIGHT);
	tl.process('i');
	tl.process('\n');
	CHECK(tl.result());
	CHECK(tl.typed() == "hi");
}

TEST_CASE("completion") {
	TypingLine tl;
	tl.set_type("hello");
	tl.process('\n');
	tl.set_type("world");
	tl.process('\n');

	TypingLine other_tl;
	other_tl.process('h');
	other_tl.process('\t');
	CHECK(other_tl.typed() == "hello");
	other_tl.process(KEY_HOME);
	other_tl.process('w');
	other_tl.process('\t');
	CHECK(other_tl.typed() == "world");
}

TEST_CASE("completion order") {
	TypingLine tl;
	tl.set_type("hello");
	tl.process('\n');
	tl.set_type("heath");
	tl.process('\n');

	TypingLine other_tl;
	other_tl.process('h');
	other_tl.process('e');
	other_tl.process('\t');
	CHECK(other_tl.typed() == "heath");
	other_tl.process('\b');
	other_tl.process('\b');
	other_tl.process('\b');
	other_tl.process('\b');
	other_tl.process('\b');
	other_tl.process('\b');
	other_tl.process('\b');
	other_tl.process('w');
	other_tl.process('w');
	other_tl.process('w');
	other_tl.process('\t');
	CHECK(other_tl.typed() == "www");
}

// must be after completion test because it add random words to dictionary
TEST_CASE("random typing") {
	mt19937 rng(random_device{}());
	uniform_int_distribution<int> action(0, 1);
	uniform_int_distribution<unsigned char> chardist('a', 'z');
	for (int i = 0; i < 100; ++i) {
		TypingLine tl;
		CHECK(!tl.has_result());
		string s;
		for (int j = 0; j < 1000; ++j) {
			if (action(rng)) {
				char c = chardist(rng);
				s.push_back(c);
				tl.process(c);
			} else {
				if (!s.empty()) s.pop_back();
				tl.process('\b');
			}
			CHECK(!tl.has_result());
			CHECK(tl.typed() == s);
		}
		tl.process('\n');
		CHECK(tl.result());
	}
}
