/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __VIEW__H__
#define __VIEW__H__

#include <memory>
#include <mutex>
#include <optional>
#include <string>
#include <sstream>
#include <vector>

#include "config.h"
#include "constants.h"
#include "epoch.h"
#include "filter_manager.h"
#include "format_string.h"
#include "log_lines.h"
#include "match.h"
#include "navigation.h"
#include "renderer.h"

using namespace std;
using namespace std::placeholders;

/* View holds an element of the stack of logs in logserer. Each view has its own
 * navigation, filterer, and loglines. When different views are added, old ones
 * track their keyword being sought and where the navigation is when the user
 * returns.
 */
class View {
public:
	// contructs a view with the loglines, filter runner, and navigation
	// trinity.
	View(LogLines* ll, FilterManager* fm, Navigation* navi)
			: _ll(ll), _fm(fm), _navi(navi) {
	}

	// returns the filter manager for this view
	FilterManager* fm() { return _fm.get(); }

	// returns the loglines for this view
	LogLines* ll() { return _ll.get(); }

	// returns the navigation for this view
	Navigation* navi() { return _navi.get(); }

protected:
	// the loglines instance
	unique_ptr<LogLines> _ll;

	// the filter manager instance
	unique_ptr<FilterManager> _fm;

	// the navigation instance
	unique_ptr<Navigation> _navi;
};

#endif  //  __VIEW__H__
