/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __STORY__H__
#define __STORY__H__

#include <cstdint>
#include <fstream>
#include <string>
#include <vector>

#include "log_lines.h"
#include "navigation.h"

using namespace std;

/* Story class wraps around an fstream for a file and uses that to write
 * comments and snippits. Used for doing analysis work and wanting to keep a
 * record or notes while doing it */
class Story {
public:
	Story() {
	}

	virtual ~Story() {
	}

	/* user has provided a comment in data for a line in ll at position in
	 * navi. The current viewport as line numbers in view. Creates a
	 * snippet of the current position with nearby context and writes it to
	 * the story file. */
	// TODO: make 6 radius configurable
	virtual void write(const string& data, LogLines* ll,
			   Navigation* navi, const set<size_t>& view) {
		if (!_fout.is_open()) open();
		size_t pos = navi->cur();
		if (navi->at_end()) pos = ll->length();
		_fout << "--" << endl << endl;
		_fout << "@" << ll->file_name() << ":" << pos << endl;
		_fout << data << endl << endl;
		stringstream ss;
		ll->quote(pos, view, 6, &ss);
		_fout << ss.str() << endl << endl;
		_fout.flush();

		ofstream f_summary("SUMMARY", fstream::out | fstream::app);
		f_summary <<  "@" << ll->file_name() << ":" << pos << "    "
		          << data << endl;

	}

protected:
	// TODO: make this file configurable
	/* Opens the storytime.txt file for appending data from comments */
	virtual void open() {
		 _fout.open("storytime.txt", fstream::out | fstream::app);
	}

	ofstream _fout;
};

#endif  // __STORY__H__
