/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __STATIC_DEMO__H__
#define __STATIC_DEMO__H__

#include <sstream>
#include <string>
#include <vector>

#include "version.h"

using namespace std;

/* Another static help-like page that shows some of the features of logserver */
class StaticDemo {
public:
	static inline const string NAME = "demo";

	static void render(ILogLines* out) {
		for (const auto& x : demo_lines) out->add_line(x);
	}

protected:
	static inline const vector<string> demo_lines = {
"Look! This is a long line below. Hit 'b' to break it up:",
"",
"Shem was a sham and a low sham and his lowness creeped out first via foodstuffs. So low was he that he preferred Gibsen's teatime salmon tinned, as inexpensive as pleasing, to the plumpest roeheavy lax or the friskiest parr or smolt troutlet that ever was gaffed between Leixlip and Island Bridge and many was the time he repeated in his botulism that no junglegrown pineapple ever smacked like the whoppers you shook out of Ananias' cans, Findlater and Gladstone's, Corner House, Englend. None of your inchthick blueblooded Balaclava fried-at-belief-stakes or juicejelly legs of the Grex's molten mutton or greasilygristly grunters' goupons or slice upon slab of luscious goosebosom with lump after load of plumpudding stuffing all aswim in a swamp of bogoakgravy for that greekenhearted yude! Rosbif of Old Zealand! he could not attouch it. See what happens when your somatophage merman takes his fancy to our virgitarian swan? He even ran away with hunself and became a farsoonerite, saying he would far sooner muddle through the hash of lentils in Europe than meddle with Irrland's split little pea. Once when among those rebels in a state of hopelessly helpless intoxication the piscivore strove to lift a czitround peel to either nostril, hiccupping, apparently impromptued by the hibat he had with his glottal stop, that he kukkakould flowrish for ever by the smell, as the czitr, as the kcedron, like a scedar, of the founts, on mountains, with limon on, of Lebanon. O! the lowness of him was beneath all up to that sunk to! No likedbylike firewater or firstserved firstshot or gulletburn gin or honest brewbarrett beer either. (notice after breaking it doesn't cut sharply mid word?)",
"",
"but if there is no decent line breaks within a reasonable range it just does it sharply",
"aaaaaaaaa bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc ddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd",
"",
"if it notices there is a frequently occuring possible line break signature it uses that: either  \\n or |",
"hello\\nthere\\nlook\\nat\\nall\\nthese\\nlines!",
"hello|there|look|at|all|these|lines!",
"",
"if you want to break on your own choice of symbol when there it isn't automatic",
"then use B followed by the character you want to break on, even a letter. you can do two tries.",
"try.it.out.here,and,see.what,happens",
"try.it.out.here,and,see.what,happens",
"",
"if it looks like an http query string it just splits it on the ampersand",
"lang=en&event=pageview&referer=someserver.com&width=780&height=1080&battery=empty&sun=shining&birds=chirping",
"",
"breaking also does JSON too nicely, give it a try",
"{\"a\":{\"b\":[1,2,3], \"c\":{\"d\":\"hello\", \"e\":\"there\"}, \"f\":15}, \"g\":{}}",
"",
"",
"you know what time it is? 1702154596",
"(use 'i' to turn the time stamp into human time",
"it also works in millis 1702154596123",
"",
"",
"ooo this looks like base64, hit 'i' to see what it is!",
"aGVsbG8gdGhlcmUhCg==",
"",
"this one is base64 wrapping base64 wrapping base64 . keep trying!",
"WVZoUmJtTjVRbXRpTWpWc1EyYzlQUW89Cg=="
"",
"hexencoding: referrer=https%3A%2F%2Fpotatocrunchcereal.com%2F",
"",
"you can select a subset of lines. hit ! on this line to add a divider, then go DOWN TO SIGNAL",
"",
"maybe these",
"lines are",
"interesting to",
"look at",
"in isolation",
"use ESC to return",
"",
"SIGNAL! hit ! again, and then  go into the middle part and hit '%' to take a subset",
"these ! lines will also stick around during filter mode",
"",
"this line is special. let's mark it with J (capital)",
"there should be a * next to the number now. hit 'n' to hide numbers and special marker",
"move down to here and hit lower case j to jump back",
"",
"you can have many special lines with J and use j to jump among them.",
"special lines can be made unspecial also with J, it toggles"
"",
"you can also jump directly to a line by number",
"hit : and type a number",
"behold!"
"",
"",
"things before a colon are signalled as they may be keys in various formats",
"httpheader_key: httpheader_value",
"otherheader: othervalue",
"{",
"    \"jsonkey\": \"jsonvalue\",",
"    \"otherkey\": \"other value\"",
"}",
	};
};

#endif  // __STATIC_DEMO__H__
