/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __MOCK_LINE_PROVIDER__H__
#define __MOCK_LINE_PROVIDER__H__

#include <string>

#include "base_line_provider.h"
#include "i_log_lines.h"

using namespace std;

/* Used for testing as a slow source of continual line input */
class MockLineProvider : public BaseLineProvider {
public:
	MockLineProvider(ILogLines* ll, int delay)
		: BaseLineProvider(ll), _delay(delay) {}

	virtual ~MockLineProvider() {}

protected:
	virtual void loader() override {
		while (!ExitSignal::check(false)) {
			add_line("..............");
			if (_delay) {
				this_thread::sleep_for(
					chrono::milliseconds(_delay));
			}
		}
	}

	// milliseconds between adding new lines
	int _delay;
};

#endif // __MOCK_LINE_PROVIDER__H__
