/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __I_LOG_LINES_EVENTS__H__
#define __I_LOG_LINES_EVENTS__H__

class Line;
class LogLines;

// interface for loglines's event for relevant listeners
class ILogLinesEvents {
public:
	// allow subclasses
	virtual ~ILogLinesEvents() {}

	// an existing line was changed
	virtual void edit_line(LogLines* ll, size_t pos, Line* line) = 0;

	// a new line was added
	virtual void append_line(LogLines* ll, size_t pos, Line* line) = 0;

	// an insertion event
	virtual void insertion(LogLines* ll, size_t pos, size_t amount) = 0;

	// a deletion event
	virtual void deletion(LogLines* ll, size_t pos, size_t amount) = 0;

	// clear all lines
	virtual void clear_lines(LogLines* ll) = 0;
};

#endif // __I_LOG_LINES_EVENT__H__
