/*
 * Logserver
 * Copyright (C) 2017-2025 Joel Reardon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef __I_LOG_LINES__H__
#define __I_LOG_LINES__H__

#include <string>

using namespace std;

class Line;

// interface for line providers to not need to include loglines.h
class ILogLines {
public:
	// allow subclasses
	virtual ~ILogLines() {}

	// adds a new line to the log lines and returns its pos
	virtual size_t add_line(const string& line) = 0;

	// adds a Line object to log lines and returns its pos
	virtual size_t add_line(Line* line) = 0;

	// batch adds Line objects to log lines and removes them from the passed
	// in list
	virtual void add_lines(list<Line*>* line) = 0;

	// sets eof if input reader is done
	virtual bool eof() const = 0;

	// unset eof, e.g., if the file being tailed is updated
	virtual void set_eof(bool value) = 0;
};

#endif // __I_LOG_LINES__H__
