#!/bin/bash
# 检查翻译文件目录是否存在
if [ ! -d "translations" ]; then
    echo "错误: translations目录不存在"
    exit 1
fi

# 遍历目录中的所有.ts文件
for ts_file in translations/*.ts; do
    if [ -f "$ts_file" ]; then
        # 获取文件名（不含扩展名）
        base_name=$(basename "$ts_file" .ts)
        # 执行lrelease生成.qm文件
        lrelease "$ts_file" -qm "translations/${base_name}.qm"
        echo "已生成: translations/${base_name}.qm"
    fi
done

echo "所有翻译文件处理完成"
