// SPDX-FileCopyrightText: 2025 KylinSoft Co., Ltd.
//
// SPDX-License-Identifier: Expat

#ifndef MAGNIFIER_H
#define MAGNIFIER_H

#include <QGSettings>
#include <QLabel>
#include <QPainter>
#include <QPushButton>
#include <QWidget>

class ComKylinWlcomEffectInterface;
class OrgUkuiMagnifierInterface;

class Magnifier : public QWidget
{
    Q_OBJECT

  public:
    explicit Magnifier(int type = 1, QWidget *parent = nullptr);
    ~Magnifier();

  protected:
    void paintEvent(QPaintEvent *event) override;

  private slots:
    void on_zoomIn_clicked();
    void on_zoomOut_clicked();
    void on_scaleChanged(uint scale);
    void on_zoomStop();
    void on_themeChanged();
    void on_TransChanged();

  private:
    int m_type;
    OrgUkuiMagnifierInterface *ukui_magnifier;
    ComKylinWlcomEffectInterface *wlcom_effect;

    QPushButton *button_zoomIn;
    QPushButton *button_zoomOut;
    QLabel *scale_label;
    QGSettings *m_settingsTheme = nullptr;
    QGSettings *m_settingsTrans = nullptr;
    QColor m_bgColor;
    double m_bgColorAlpha = 1.0;
    bool flag_zoomIn = false;
    bool flag_zoomOut = false;

    void setupUI();
    void setupConnection();
    void enableZoom();
};

#endif // MAGNIFIER_H
