// SPDX-FileCopyrightText: 2024 KylinSoft Co., Ltd.
//
// SPDX-License-Identifier: Expat

#ifndef WIDGET_H
#define WIDGET_H

#include <QLabel>
#include <QMainWindow>
#include <QPushButton>
#include <QTabWidget>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QWidget>

#include "context.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

  public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

  private Q_SLOTS:
    void add_output_item(Output *output);
    void update_output_item(Output::Masks mask);
    void delete_output_item();

    void add_toplevel_item(Toplevel *toplevel);
    void update_toplevel_item(Toplevel::Masks mask);
    void delete_toplevel_item();

    void add_workspace_item(Workspace *workspace);
    void delete_workspace_item();
    void update_workspace_item(Workspace::Masks mask);

    void add_btn_clicked();
    void move_up_btn_clicked();
    void move_down_btn_clicked();
    void delete_btn_clicked();
    void activited_btn_clicked();
    void item_double_clicked(int row, int column);
    void text_changed(int row, int column);

    void toplevel_set_maximized();
    void toplevel_unset_maximized();
    void toplevel_set_minimized();
    void toplevel_unset_minimized();
    void toplevel_set_fullscreen();
    void toplevel_unset_fullscreen();
    void toplevel_set_activate();
    void toplevel_close();
    void toplevel_set_position();
    void toplevel_set_size();
    void toplevel_enter_workspace();
    void toplevel_leave_workspace();
    void toplevel_send_to_output();
    void toplevel_move_to_workspace();
    void toplevel_update_has_children();

    void show_menu(const QPoint pos);
    void toplevel_menu(const QPoint pos);

    void show_toplevel_thumbnail();
    void show_output_thumbnail();
    void show_workspace_thumbnail();

  private:
    Context *context = nullptr;
    QTabWidget *tabWidget = nullptr;
    QTableWidget *tableWidget_0 = nullptr;
    QTableWidget *tableWidget_1 = nullptr;
    QTableWidget *tableWidget_2 = nullptr;
    QLabel *pri_label = nullptr;
    QString primaryOutput = "";
    int workspace_count;
    int toplevel_count;
    int outputs_count;
    bool table_is_double_clicked;
    void init_form();
    void init_workspace_widget(QWidget *widget);
    void init_output_widget(QWidget *widget);
    void init_toplevel_widget(QWidget *widget);

    void autoAdjustTableItemWidth();
    void autoAdjustTableItemHeight();
};
#endif // MAINWINDOW_H
