<!--
SPDX-FileCopyrightText: AISEC Pentesting Team

SPDX-License-Identifier: CC0-1.0
-->

# Configuration

## gallia.toml

All `gallia` settings stem from the commandline interface.
The documentation for all available settings per subcommand is available via `-h/--help`.
Frequently used settings can be put in a configfile which is called `gallia.toml`.
Settings from the config file set the **default** of the respective commandline option.
The config can always be overwritten by manually setting the relevant cli option.

The configuration file `gallia.toml` is written in [TOML](https://toml.io/en/). 
Inheritence is not supported; the first file is loaded.
The `gallia.toml` file is loaded from these locations (in this particular order):

* path specified in the env variable `GALLIA_CONFIG`; see {doc}`../env`.
* current directory
* current Git root (if the current directory is a Git repository)
* `$XDG_CONFIG_HOME/gallia/gallia.toml`
* `~/.config/gallia/gallia.toml`

Only some cli options are exposed to the config file.
The available config settings can be obtained from `gallia --template`.
The output of `--template` is maintained to be up to date and is intended as a starting point.
