#!/bin/bash
#
# This script is based on debian/sanitize-gdb.sh from the Debian
# gdb source package.
#
# It is assumed that it's called like:
#
#   SCRIPT --upstream-version VERSION
#

set -ex

UPSTREAM_VERSION="${2}"

TARBALL=$(realpath -e "../gdb-${UPSTREAM_VERSION}.tar.gz")

tmpdir=$(mktemp -d)
trap 'rm -rf "${tmpdir}"' EXIT ERR INT

cd "${tmpdir}"
tar -xf "${TARBALL}"

# All of the gdb manpages are GFDL'd now
find */gdb -type f -name '*.[1-9]' -delete

# Almost all of the texinfo documentation is GFDL.  PSIM's is not, but
# we don't need that manual especially anyway.  Remove all pregenerated
# info files, then replace all texinfo files with dummy  versions.

find . -type f \( -name '*.info' -o -name '*.info-*' \) -delete
find . -type f -name '*.chm' -delete
find . -type f \( -name '*.texinfo' -o -name '*.texi' \) -exec sh -c 'echo > "$1"' _ {} \;

# Repack the tarball
tar --auto-compress -cf "${TARBALL}" .
