#include <boost/certify/detail/spki_digest.hpp>

#include <boost/certify/verification_utils.hpp>
#include <boost/core/lightweight_test.hpp>

int
main()
{
    ::SSL_library_init();

    auto chain = boost::certify::certificate_chain::from_file(
      "libs/certify/tests/res/fail_chains/github.com.crt");

    std::array<std::array<unsigned char, 32>, 3> const expected = {
      {{{0xa3, 0x9a, 0x1a, 0xe4, 0x5e, 0x0b, 0x6d, 0x91, 0x1f, 0x79, 0x9d,
         0x24, 0x5c, 0x38, 0x26, 0x69, 0x4d, 0x8a, 0xde, 0xc2, 0x0f, 0x62,
         0xd6, 0xd0, 0xa5, 0x3d, 0xc4, 0x40, 0xb2, 0x59, 0xaa, 0xe3}},
       {{0x45, 0x13, 0x35, 0x74, 0x6a, 0xa7, 0x0c, 0x5b, 0x02, 0x25, 0x70,
         0x53, 0x1e, 0x4c, 0xb5, 0xea, 0xf8, 0xb5, 0xa1, 0xb3, 0xa5, 0x0a,
         0x01, 0x45, 0x9f, 0xfc, 0x8e, 0x84, 0x8f, 0xf2, 0xfa, 0x1a}},
       {{0x5a, 0x88, 0x96, 0x47, 0x22, 0x0e, 0x54, 0xd6, 0xbd, 0x8a, 0x16,
         0x81, 0x72, 0x24, 0x52, 0x0b, 0xb5, 0xc7, 0x8e, 0x58, 0x98, 0x4b,
         0xd5, 0x70, 0x50, 0x63, 0x88, 0xb9, 0xde, 0x0f, 0x07, 0x5f}}}};

    for (int i = 0; i < sk_X509_num(chain.native_handle()); ++i)
    {
        auto digest = boost::certify::detail::spki_digest(
          sk_X509_value(chain.native_handle(), i));
        BOOST_TEST(expected.at(i) == digest);
    }

    return boost::report_errors();
}
