---@meta _

-- This file is automatically generated from src/controllers/plugins/LuaAPI.hpp by the scripts/make_luals_meta.py script
-- This file is intended to be used with LuaLS (https://luals.github.io/).
-- Add the folder this file is in to "Lua.workspace.library".

c2 = {}
---@enum c2.LogLevel
c2.LogLevel = {
    Debug = {}, ---@type c2.LogLevel.Debug
    Info = {}, ---@type c2.LogLevel.Info
    Warning = {}, ---@type c2.LogLevel.Warning
    Critical = {}, ---@type c2.LogLevel.Critical
}

-- Begin src/controllers/plugins/api/EventType.hpp

---@enum c2.EventType
c2.EventType = {
    CompletionRequested = {}, ---@type c2.EventType.CompletionRequested
}

-- End src/controllers/plugins/api/EventType.hpp

---@class CommandContext
---@field words string[] The words typed when executing the command. For example `/foo bar baz` will result in `{"/foo", "bar", "baz"}`.
---@field channel c2.Channel The channel the command was executed in.

---@class CompletionList
---@field values string[] The completions
---@field hide_others boolean Whether other completions from Chatterino should be hidden/ignored.

---@class CompletionEvent
---@field query string The word being completed
---@field full_text_content string Content of the text input
---@field cursor_position integer Position of the cursor in the text input in unicode codepoints (not bytes)
---@field is_first_word boolean True if this is the first word in the input

-- Begin src/common/Channel.hpp

---@enum c2.ChannelType
c2.ChannelType = {
    None = {}, ---@type c2.ChannelType.None
    Direct = {}, ---@type c2.ChannelType.Direct
    Twitch = {}, ---@type c2.ChannelType.Twitch
    TwitchWhispers = {}, ---@type c2.ChannelType.TwitchWhispers
    TwitchWatching = {}, ---@type c2.ChannelType.TwitchWatching
    TwitchMentions = {}, ---@type c2.ChannelType.TwitchMentions
    TwitchLive = {}, ---@type c2.ChannelType.TwitchLive
    TwitchAutomod = {}, ---@type c2.ChannelType.TwitchAutomod
    TwitchEnd = {}, ---@type c2.ChannelType.TwitchEnd
    Misc = {}, ---@type c2.ChannelType.Misc
}

-- End src/common/Channel.hpp

-- Begin src/controllers/plugins/api/ChannelRef.hpp

-- Begin src/providers/twitch/TwitchChannel.hpp

---@class StreamStatus
---@field live boolean
---@field viewer_count number
---@field title string Stream title or last stream title
---@field game_name string
---@field game_id string
---@field uptime number Seconds since the stream started.

---@class RoomModes
---@field subscriber_only boolean
---@field unique_chat boolean You might know this as r9kbeta or robot9000.
---@field emotes_only boolean Whether or not text is allowed in messages. Note that "emotes" here only means Twitch emotes, not Unicode emoji, nor 3rd party text-based emotes
---@field follower_only number? Time in minutes you need to follow to chat or nil.
---@field slow_mode number? Time in seconds you need to wait before sending messages or nil.

-- End src/providers/twitch/TwitchChannel.hpp

---@class c2.Channel
c2.Channel = {}

--- Returns true if the channel this object points to is valid.
--- If the object expired, returns false
--- If given a non-Channel object, it errors.
---
---@return boolean success
function c2.Channel:is_valid() end

--- Gets the channel's name. This is the lowercase login name.
---
---@return string name
function c2.Channel:get_name() end

--- Gets the channel's type
---
---@return c2.ChannelType
function c2.Channel:get_type() end

--- Get the channel owner's display name. This may contain non-lowercase ascii characters.
---
---@return string name
function c2.Channel:get_display_name() end

--- Sends a message to the target channel.
--- Note that this does not execute client-commands.
---
---@param message string
---@param execute_commands? boolean Should commands be run on the text?
function c2.Channel:send_message(message, execute_commands) end

--- Adds a system message client-side
---
---@param message string
function c2.Channel:add_system_message(message) end

--- Adds a message client-side
---
---@param message c2.Message
---@param context? c2.MessageContext The context of the message being added
---@param override_flags? c2.MessageFlag|nil Flags to override the message's flags (some splits might filter for this)
function c2.Channel:add_message(message, context, override_flags) end

--- Returns true for twitch channels.
--- Compares the channel Type. Note that enum values aren't guaranteed, just
--- that they are equal to the exposed enum.
---
---@return boolean
function c2.Channel:is_twitch_channel() end

--- Returns a copy of the channel mode settings (subscriber only, r9k etc.)
---
---@return RoomModes
function c2.Channel:get_room_modes() end

--- Returns a copy of the stream status.
---
---@return StreamStatus
function c2.Channel:get_stream_status() end

--- Returns the Twitch user ID of the owner of the channel.
---
---@return string
function c2.Channel:get_twitch_id() end

--- Returns true if the channel is a Twitch channel and the user owns it
---
---@return boolean
function c2.Channel:is_broadcaster() end

--- Returns true if the channel is a Twitch channel and the user is a moderator in the channel
--- Returns false for broadcaster.
---
---@return boolean
function c2.Channel:is_mod() end

--- Returns true if the channel is a Twitch channel and the user is a VIP in the channel
--- Returns false for broadcaster.
---
---@return boolean
function c2.Channel:is_vip() end

---@return string
function c2.Channel:__tostring() end

--- Finds a channel by name.
--- Misc channels are marked as Twitch:
--- - /whispers
--- - /mentions
--- - /watching
--- - /live
--- - /automod
---
---@param name string Which channel are you looking for?
---@return c2.Channel?
function c2.Channel.by_name(name) end

--- Finds a channel by the Twitch user ID of its owner.
---
---@param id string ID of the owner of the channel.
---@return c2.Channel?
function c2.Channel.by_twitch_id(id) end

-- End src/controllers/plugins/api/ChannelRef.hpp

-- Begin src/controllers/plugins/api/HTTPResponse.hpp

---@class c2.HTTPResponse
c2.HTTPResponse = {}

--- Returns the data. This is not guaranteed to be encoded using any
--- particular encoding scheme. It's just the bytes the server returned.
---
---@return string
---@nodiscard
function c2.HTTPResponse:data() end

--- Returns the status code.
---
---@return number|nil
---@nodiscard
function c2.HTTPResponse:status() end

--- A somewhat human readable description of an error if such happened
---
---@return string
---@nodiscard
function c2.HTTPResponse:error() end

---@return string
---@nodiscard
function c2.HTTPResponse:__tostring() end

-- End src/controllers/plugins/api/HTTPResponse.hpp

-- Begin src/controllers/plugins/api/HTTPRequest.hpp

---@alias c2.HTTPCallback fun(result: c2.HTTPResponse): nil
---@class c2.HTTPRequest
c2.HTTPRequest = {}

--- Sets the success callback
---
---@param callback c2.HTTPCallback Function to call when the HTTP request succeeds
function c2.HTTPRequest:on_success(callback) end

--- Sets the failure callback
---
---@param callback c2.HTTPCallback Function to call when the HTTP request fails or returns a non-ok status
function c2.HTTPRequest:on_error(callback) end

--- Sets the finally callback
---
---@param callback fun(): nil Function to call when the HTTP request finishes
function c2.HTTPRequest:finally(callback) end

--- Sets the timeout
---
---@param timeout integer How long in milliseconds until the times out
function c2.HTTPRequest:set_timeout(timeout) end

--- Sets the request payload
---
---@param data string
function c2.HTTPRequest:set_payload(data) end

--- Sets a header in the request
---
---@param name string
---@param value string
function c2.HTTPRequest:set_header(name, value) end

--- Executes the HTTP request
---
function c2.HTTPRequest:execute() end

---@return string
function c2.HTTPRequest:__tostring() end

--- Creates a new HTTPRequest
---
---@param method c2.HTTPMethod Method to use
---@param url string Where to send the request to
---@return c2.HTTPRequest
function c2.HTTPRequest.create(method, url) end

-- End src/controllers/plugins/api/HTTPRequest.hpp

-- Begin src/controllers/plugins/api/Message.hpp


---A chat message
---@class c2.Message
c2.Message = {}

---A table to initialize a new message
---@class MessageInit
---@field flags? c2.MessageFlag Message flags (see `c2.MessageFlags`)
---@field id? string The (ideally unique) message ID
---@field parse_time? number Time the message was parsed (in milliseconds since epoch)
---@field search_text? string Text to that is compared when searching for messages
---@field message_text? string The message text (used for filters for example)
---@field login_name? string The login name of the sender
---@field display_name? string The display name of the sender
---@field localized_name? string The localized name of the sender (this is used for CJK names, otherwise it's empty)
---@field user_id? string The ID of the user who sent the message
---@field channel_name? string The name of the channel this message appeared in
---@field username_color? string The color of the username
---@field server_received_time? number The time the server received the message (in milliseconds since epoch)
---@field highlight_color? string|nil The color of the highlight (if any)
---@field elements? MessageElementInit[] The elements of the message

---A base table to initialize a new message element
---@class MessageElementInitBase
---@field tooltip? string Tooltip text
---@field trailing_space? boolean Whether to add a trailing space after the element (default: true)
---@field link? c2.Link An action when clicking on this element. Mention and Link elements don't support this. They manage the link themselves.

---@alias MessageColor "text"|"link"|"system"|string A color for a text element - "text", "link", and "system" are special values that take the current theme into account

---A table to initialize a new message text element
---@class TextElementInit : MessageElementInitBase
---@field type "text" The type of the element
---@field text string The text of this element
---@field flags? c2.MessageElementFlag Message element flags (see `c2.MessageElementFlags`)
---@field color? MessageColor The color of the text
---@field style? c2.FontStyle The font style of the text

---A table to initialize a new message single-line text element
---@class SingleLineTextElementInit : MessageElementInitBase
---@field type "single-line-text" The type of the element
---@field text string The text of this element
---@field flags? c2.MessageElementFlag Message element flags (see `c2.MessageElementFlags`)
---@field color? MessageColor The color of the text
---@field style? c2.FontStyle The font style of the text

---A table to initialize a new mention element
---@class MentionElementInit : MessageElementInitBase
---@field type "mention" The type of the element
---@field display_name string The display name of the mentioned user
---@field login_name string The login name of the mentioned user
---@field fallback_color MessageColor The color of the element in case the "Colorize @usernames" is disabled
---@field user_color MessageColor The color of the element in case the "Colorize @usernames" is enabled

---A table to initialize a new timestamp element
---@class TimestampElementInit : MessageElementInitBase
---@field type "timestamp" The type of the element
---@field time number? The time of the timestamp (in milliseconds since epoch). If not provided, the current time is used.

---A table to initialize a new Twitch moderation element (all the custom moderation buttons)
---@class TwitchModerationElementInit : MessageElementInitBase
---@field type "twitch-moderation" The type of the element

---A table to initialize a new linebreak element
---@class LinebreakElementInit : MessageElementInitBase
---@field type "linebreak" The type of the element
---@field flags? c2.MessageElementFlag Message element flags (see `c2.MessageElementFlags`)

---A table to initialize a new reply curve element
---@class ReplyCurveElementInit : MessageElementInitBase
---@field type "reply-curve" The type of the element

---@alias MessageElementInit TextElementInit|SingleLineTextElementInit|MentionElementInit|TimestampElementInit|TwitchModerationElementInit|LinebreakElementInit|ReplyCurveElementInit

--- Creates a new message
---
---@param init MessageInit The message initialization table
---@return c2.Message msg The new message
function c2.Message.new(init) end
---@alias c2.Link { type: c2.LinkType, value: string } A link on a message element.
---@enum c2.LinkType
c2.LinkType = {
    Url = {}, ---@type c2.LinkType.Url
    UserInfo = {}, ---@type c2.LinkType.UserInfo
    UserAction = {}, ---@type c2.LinkType.UserAction
    JumpToChannel = {}, ---@type c2.LinkType.JumpToChannel
    CopyToClipboard = {}, ---@type c2.LinkType.CopyToClipboard
    JumpToMessage = {}, ---@type c2.LinkType.JumpToMessage
    InsertText = {}, ---@type c2.LinkType.InsertText
}

-- Begin src/singletons/Fonts.hpp

---@enum c2.FontStyle
c2.FontStyle = {
    Tiny = {}, ---@type c2.FontStyle.Tiny
    ChatSmall = {}, ---@type c2.FontStyle.ChatSmall
    ChatMediumSmall = {}, ---@type c2.FontStyle.ChatMediumSmall
    ChatMedium = {}, ---@type c2.FontStyle.ChatMedium
    ChatMediumBold = {}, ---@type c2.FontStyle.ChatMediumBold
    ChatMediumItalic = {}, ---@type c2.FontStyle.ChatMediumItalic
    ChatLarge = {}, ---@type c2.FontStyle.ChatLarge
    ChatVeryLarge = {}, ---@type c2.FontStyle.ChatVeryLarge
    TimestampMedium = {}, ---@type c2.FontStyle.TimestampMedium
    UiMedium = {}, ---@type c2.FontStyle.UiMedium
    UiMediumBold = {}, ---@type c2.FontStyle.UiMediumBold
    UiTabs = {}, ---@type c2.FontStyle.UiTabs
    EndType = {}, ---@type c2.FontStyle.EndType
    ChatStart = {}, ---@type c2.FontStyle.ChatStart
    ChatEnd = {}, ---@type c2.FontStyle.ChatEnd
}

-- End src/singletons/Fonts.hpp

-- Begin src/messages/MessageElement.hpp

---@enum c2.MessageElementFlag
c2.MessageElementFlag = {
    None = 0,
    Misc = 0,
    Text = 0,
    Username = 0,
    Timestamp = 0,
    EmoteImage = 0,
    EmoteText = 0,
    Emote = 0,
    ChannelPointReward = 0,
    ChannelPointRewardImage = 0,
    BitsStatic = 0,
    BitsAnimated = 0,
    BadgeSharedChannel = 0,
    BadgeGlobalAuthority = 0,
    BadgePredictions = 0,
    BadgeChannelAuthority = 0,
    BadgeSubscription = 0,
    BadgeVanity = 0,
    BadgeChatterino = 0,
    BadgeSevenTV = 0,
    BadgeFfz = 0,
    Badges = 0,
    ChannelName = 0,
    BitsAmount = 0,
    ModeratorTools = 0,
    EmojiImage = 0,
    EmojiText = 0,
    EmojiAll = 0,
    AlwaysShow = 0,
    Collapsed = 0,
    Mention = 0,
    LowercaseLinks = 0,
    RepliedMessage = 0,
    ReplyButton = 0,
    Default = 0,
}

-- End src/messages/MessageElement.hpp

-- Begin src/messages/MessageFlag.hpp

---@enum c2.MessageFlag
c2.MessageFlag = {
    None = 0,
    System = 0,
    Timeout = 0,
    Highlighted = 0,
    DoNotTriggerNotification = 0,
    Centered = 0,
    Disabled = 0,
    DisableCompactEmotes = 0,
    Collapsed = 0,
    ConnectedMessage = 0,
    DisconnectedMessage = 0,
    Untimeout = 0,
    PubSub = 0,
    Subscription = 0,
    DoNotLog = 0,
    AutoMod = 0,
    RecentMessage = 0,
    Whisper = 0,
    HighlightedWhisper = 0,
    Debug = 0,
    Similar = 0,
    RedeemedHighlight = 0,
    RedeemedChannelPointReward = 0,
    ShowInMentions = 0,
    FirstMessage = 0,
    ReplyMessage = 0,
    ElevatedMessage = 0,
    SubscribedThread = 0,
    CheerMessage = 0,
    LiveUpdatesAdd = 0,
    LiveUpdatesRemove = 0,
    LiveUpdatesUpdate = 0,
    AutoModOffendingMessageHeader = 0,
    AutoModOffendingMessage = 0,
    LowTrustUsers = 0,
    RestrictedMessage = 0,
    MonitoredMessage = 0,
    Action = 0,
    SharedMessage = 0,
    AutoModBlockedTerm = 0,
    ClearChat = 0,
    EventSub = 0,
    ModerationAction = 0,
    InvalidReplyTarget = 0,
}

-- End src/messages/MessageFlag.hpp

-- Begin src/common/enums/MessageContext.hpp

---@enum c2.MessageContext
c2.MessageContext = {
    Original = {}, ---@type c2.MessageContext.Original
    Repost = {}, ---@type c2.MessageContext.Repost
}

-- End src/common/enums/MessageContext.hpp

-- End src/controllers/plugins/api/Message.hpp

-- Begin src/controllers/plugins/api/WebSocket.hpp

---@class c2.WebSocket
---@field on_close fun()|nil Handler called when the socket is closed.
---@field on_text fun(data: string)|nil Handler called when the socket receives a text message.
---@field on_binary fun(data: string)|nil Handler called when the socket receives a binary message.
---@field on_open fun()|nil Handler called when the websocket handshake has been completed successfully.
c2.WebSocket = {}

--- Creates and connects to a WebSocket server. Upon calling this, a
--- connection is made immediately.
---
---@param url string The URL to connect to. Must start with `wss://` or `ws://`.
---@param options? { headers?: table<string, string>, on_close?: fun(), on_text?: fun(data: string), on_binary?: fun(data: string), on_open?: fun() } Additional options for the connection.
---@return c2.WebSocket
---@nodiscard
function c2.WebSocket.new(url, options) end

--- Closes the socket.
---
function c2.WebSocket:close() end

--- Sends a text message on the socket.
---
---@param data string The text to send.
function c2.WebSocket:send_text(data) end

--- Sends a binary message on the socket.
---
---@param data string The binary data to send.
function c2.WebSocket:send_binary(data) end

-- End src/controllers/plugins/api/WebSocket.hpp

-- Begin src/common/network/NetworkCommon.hpp

---@enum c2.HTTPMethod
c2.HTTPMethod = {
    Get = {}, ---@type c2.HTTPMethod.Get
    Post = {}, ---@type c2.HTTPMethod.Post
    Put = {}, ---@type c2.HTTPMethod.Put
    Delete = {}, ---@type c2.HTTPMethod.Delete
    Patch = {}, ---@type c2.HTTPMethod.Patch
}

-- End src/common/network/NetworkCommon.hpp

--- Registers a new command called `name` which when executed will call `handler`.
---
---@param name string The name of the command.
---@param handler fun(ctx: CommandContext) The handler to be invoked when the command gets executed.
---@return boolean ok  Returns `true` if everything went ok, `false` if a command with this name exists.
function c2.register_command(name, handler) end

--- Registers a callback to be invoked when completions for a term are requested.
---
---@param type c2.EventType.CompletionRequested
---@param func fun(event: CompletionEvent): CompletionList The callback to be invoked.
function c2.register_callback(type, func) end

--- Writes a message to the Chatterino log.
---
---@param level c2.LogLevel The desired level.
---@param ... any Values to log. Should be convertible to a string with `tostring()`.
function c2.log(level, ...) end

--- Calls callback around msec milliseconds later. Does not freeze Chatterino.
---
---@param callback fun() The callback that will be called.
---@param msec number How long to wait.
function c2.later(callback, msec) end

