# Changelog

## Unversioned

- Minor: Badges now link to their home page like emotes in the context menu. (#6437)
- Minor: Fixed usercard resizing improperly without recent messages. (#6496)
- Minor: Added setting for character limit of deleted messages. (#6491)
- Minor: Added link support to plugin message API. (#6386, #6527)
- Minor: Added a description for the logging option under moderation tab. (#6514)
- Minor: Consolidate font picking into one dialog. (#6531)
- Minor: Added a menu action to sort tabs alphabetically. (#6551)
- Minor: Fixed "edit hotkey" dialog opening like a normal window. (#6540)
- Bugfix: Expose the "Extra extension IDs" setting on non-Windows systems too. (#6509)
- Bugfix: Fixed some commands and filters not working as expected in seach popups. (#6539)
- Bugfix: Fixed settings occasionally not opening when clicking on "Manage Accounts" in the account switcher. (#6543)
- Bugfix: Fixed font change not resulting in forced layout update. (#6536)
- Bugfix: Fixed scrollbar rect computation potentially resulting in overflows. (#6547)
- Bugfix: Forward query params to websocket URLs. (#6141)
- Bugfix: Fixed Lua errors from handlers of HTTP requests not being logged. (#6452)
- Bugfix: Fixed restore button not showing on Windows. (#6565)
- Bugfix: Fixed popups and the overlay not being draggable on Wayland. (#6573)
- Dev: Update release documentation. (#6498)
- Dev: Make code sanitizers opt in with the `CHATTERINO_SANITIZER_SUPPORT` CMake option. After that's enabled, use the `SANITIZE_*` flag to enable individual sanitizers. (#6493)
- Dev: Remove unused QTextCodec includes. (#6487)
- Dev: Stopped building AppImage in CI. (#6504)
- Dev: Find Boost's CMake Config file instead of module file. (#6499)
- Dev: Fix 32-bit compile in PluginRepl. (#6483)
- Dev: Fix the WinGet release workflow. (#6497)
- Dev: Correct handling of eventsubs without any account. (#6503)
- Dev: Removed dependency to Qt5 Compatibility module by updating libcommuni. (#6500)
- Dev: Merged emote element flags from different providers into two. (#6511)
- Dev: Fixed warnings on Qt 6.10. (#6422)
- Dev: Removed unused method in `Emojis`. (#6517)
- Dev: Refactored `Emotes` into `EmoteController`. (#6516)
- Dev: Fix Arch Linux partial upgrade error in CI. (#6553)
- Dev: Added Qt keyword and warning flags project wide. (#6520)
- Def: Fixed compilation error in tests with Clang 21. (#6519)
- Dev: The 7TV and BTTV liveupdates now use Boost.Beast's WebSockets. (#6308)
- Dev: Fixed compilation warnings on clang-cl. (#6528)
- Dev: Fixed compilation error in tests with Clang 21. (#6519)
- Dev: Use CMake's `FetchContent` for RapidJSON, PajladaSignals, PajladaSerialize, and PajladaSettings. (#6560, #6567, #6569)
- Dev: The LuaLS meta files moved from `docs/plugin-meta.lua` to `docs/lua-meta/globals.lua`. (#6530)
- Dev: Compile time definitions for `Windows.h` are now conditional based on `WIN32` instead of `MSVC`. (#6534)
- Dev: Refactored split container nodes to use shared pointers. (#6435)
- Dev: Mock headers are now added as a header set if supported by CMake. (#6561)

## 2.5.4

- Bugfix: Fixed crashes that could occur when Lua functions errored with values other than strings. (#6441)
- Bugfix: Fixed zero-width global BTTV emotes not showing in the `:~` completions. (#6440)
- Bugfix: Fixed an issue where the update button would be unclickable on macOS and Linux. (#6447, #6453)
- Bugfix: Fixed flickering tooltips on Wayland when the mouse cursor is over them. (#6451)
- Bugfix: Fixed `c2.Channel` comparing `false` to the same channel. (#6456)
- Bugfix: Fixed an issue where the moderation icon was missing from the Moderation tab. (#6457)
- Bugfix: Update the message length font when updating your chat font. (#6462)
- Bugfix: Fixed "_A message from X has been deleted_" messages logging empty messages to disk. (#6465)
- Bugfix: Do not set default hotkeys for focusing splits on macOS, as <kbd>Option</kbd> + <kbd>Arrows</kbd> are used for cursor navigation. (#6470)
- Bugfix: Fixed <kbd>CMD</kbd>+<kbd>Backspace</kbd> not working in the input on macOS if there was a selection. (#6469)
- Dev: Added documentation for WebSockets to `wip-plugins.md`. (#6432)
- Dev: Enable the hardened runtime on macOS. (#6467)

## 2.5.4-beta.1

- Minor: Added `Open in custom player` to `twitch.tv/<channel>` link context menus. (#6403)
- Minor: Added user notes to the user info dialog (when clicking a username). (#6122, #6318)
- Minor: Added cached emotes fallback when fetching from a provider fails. (#6125, #6229)
- Minor: Add an option for the reduced opacity of message history. (#6121)
- Minor: Make paused chat indicator more visible, and fix its zoom behavior. (#6123)
- Minor: Added interactive REPL for plugins. (#6120)
- Minor: Added WebSocket API for plugins. (#6076, #6186, #6314, #6315)
- Minor: Allow for themes to set transparent values for window background on Linux. (#6137)
- Minor: Popup overlay now only draws an outline when being interacted with. (#6140)
- Minor: Added basic message API to plugins. (#5754)
- Minor: Made filters searchable in the Settings dialog search bar. (#5890)
- Minor: Updated emojis to Unicode 16.0. (#6155)
- Minor: Allow disabling of double-click tab renaming through setting. (#6163, #6184)
- Minor: The JSON selector in the upload response can now query arrays using their indices like `foo.0`. (#6193)
- Minor: Made nicknames searchable in the Settings dialog search bar. (#5886)
- Minor: Made commands searchable using the Settings dialog search bar. (#5891)
- Minor: Added hotkey Action for opening account selector. (#6192)
- Minor: Add a setting to change the emote and badge thumbnail size. (#6126)
- Minor: Add an import and export button to image uploader settings. (#6284, #6394, #6387)
- Minor: Message character length label is now monospaced. (#6366)
- Minor: Add a setting under Moderation -> Logs to customize the timestamp used for chat logs. (#6338)
- Minor: Add a setting under Moderation -> Logs to use server timestamp from the message instead of the local clock time for logging. (#6346)
- Minor: Add a setting under Chat that, when enabled, pulses the text input whenever one of your messages is successfully sent to the chat. (#6380)
- Minor: Add feature to search for only zero-width emotes when prepended by `:~`. (#6362)
- Minor: The follow and sub dates now show the duration in a tooltip. (#6384)
- Minor: Usercards now show a live indicator if the user is currently streaming. (#6383)
- Minor: Consolidate twitch.tv URLs to start with www (#6407)
- Bugfix: Fixed duplicate message sending for single-worded messages. (#6417)
- Bugfix: Commands are no longer tab-completable in the middle of messages. (#6273)
- Bugfix: Automatic streamer mode detection now works from Flatpak. (#6250)
- Bugfix: Don't create native messaging manifest file if browser directory doesn't exist. (#6116)
- Bugfix: Fixed scrolling now working on inputs in the settings. (#6128)
- Bugfix: Make reply-cancel button less coarse-grained. (#6106)
- Bugfix: Fixed missing BetterTTV live updates of emotes. (#6132)
- Bugfix: Fixed message contents being cleared when using the close button for replies. (#6145)
- Bugfix: Fixed the emote popup erroneously logging messages to the `Other` directory. (#6165)
- Bugfix: Handle <kbd>CMD</kbd> + <kbd>BACKSPACE</kbd> behavior explicitly in main chat dialog input for macOS. (#6111)
- Bugfix: Fixed an on-shutdown-crash that could occur when we didn't wait long enough for 7TV/BetterTTV live update connections to close. (#6197)
- Bugfix: Fixed a small typo in the settings page. (#6134)
- Bugfix: Fixed blocked users showing up in "Users joined:" and "Users parted:" messages. (#6181)
- Bugfix: Fixed an issue where text boxes in the settings dialog could be stuck with an old value. (#6286)
- Bugfix: Fixed an issue where Splits could get lost by dragging it onto your Recycle Bin. (#6147)
- Bugfix: Correctly color gifter & recipient usernames in subscription gift messages, taking all color sources into consideration. (#6322)
- Bugfix: Correctly color usernames in subscription, announcement, bits badge tier update, raid, and other similar notification messages, taking all color sources into consideration. (#6323)
- Bugfix: Fixed some Twitch commands not getting tab-completed correctly. (#6143)
- Bugfix: Fixed shared chat badges displaying pixelated when Chatterino is scaled too much. (#6146)
- Bugfix: Fixed a few crashes that could occur when Chatterino was shutting down, some related to network tasks still firing despite us shutting down. (#6187)
- Bugfix: Fixed a crash that could occur when eventsub was enabled and Chatterino was attached to a conhost on Windows that was later gone. (#6161)
- Bugfix: Fixed a crash that could occur an eventsub connection's keepalive timer would run after the connection was dead, causing the keepalive timer to use-itself-after-free. (#6204)
- Bugfix: Fixed a crash that could occur when an image started loading mid app shutdown. (#6213)
- Bugfix: Fixed a crash that could occur on exit if a ping played less than 30 seconds prior. (#6332)
- Bugfix: Fixed a crash that could occur on exit on newer versions of Qt. (#6368)
- Bugfix: Fixed notebook buttons (settings, account switcher, streamer mode) not performing a relayout when their visibility changed, causing a gap until resize. Linux / macOS only. (#6328)
- Bugfix: Fixed split resizing mode sometimes getting stuck or acting weird if you released Ctrl before the left mouse button. (#6396)
- Bugfix: Fixed some minor typos. (#6196)
- Bugfix: Fixed inconsistent spaces in messages when using fractional scaling. (#6231, #6254)
- Bugfix: Fixed eventsub message delete notifications not being affected by "Show deletions of single messages". (#6233)
- Bugfix: Fixed an issue where eventsub subscriptions might fail after changing user. (#6348)
- Bugfix: Don't add reply buttons to messages that are invalid reply targets. (#6119)
- Bugfix: Fixed invalid commands from being forwarded to Helix, making it possible for information to leak (e.g. if you typed `/bann username ban reason` it would be seen by others in chat as `username ban reason`). (#6272, #6330)
- Bugfix: Emotes that failed to load their images now show as text. (#6355)
- Bugfix: Fixed a crash that occurs when searching for emotes in channel-less contexts. (#6357)
- Bugfix: Fixed theme changes not instantly applying to messages. (#6373)
- Bugfix: Fixed command triggers showing as '/...' when the value is longer than the column width. (#6369)
- Bugfix: Fixed a crash that could occur when making HTTP requests from a timeout handler. (#6375)
- Bugfix: Fixed a setting description not filtering correctly on search. (#6389)
- Bugfix: Disable note creation on users without an ID. (#6413)
- Bugfix: Fixed the split input not updating its height upon tab-completion. (#6411)
- Dev: Mini refactor of Split. (#6148)
- Dev: Conan will no longer generate a `CMakeUserPresets.json` file. (#6117)
- Dev: Pass `--force-openssl` when installing from CMake in Qt 6.8+. (#6129)
- Dev: Fixed `<build-tool> clean` not working correctly with generated sources. (#6154)
- Dev: Removed authenticated PubSub implementation. (#6158)
- Dev: Removed unused `ignoredPhraseReplace` setting. (#6304)
- Dev: Save settings in `aboutToQuit`. (#6159)
- Dev: Bumped deprecation cutoff to Qt 6.4.3. (#6169)
- Dev: Use `QMetaObject::invokeMethod` to run code on a specific thread. (#6203, #6278)
- Dev: Added a `run-and-kill.sh` script to help debug crash-on-exit bugs. (#6188)
- Dev: Refactored the `TimeoutStackStyle` enum into its own file. (#6216)
- Dev: Refactored `Notebook`-related enums into their own file. (#6220)
- Dev: Refactored `SettingWidget::dropdown` for string enums to the source file. (#6293)
- Dev: Don't try to save emote popup bounds if we're quitting. (#6292)
- Dev: Only carefully join EventSub controller thread. (#6136)
- Dev: Remove `ChannelPageView::addCheckbox`. (#6305)
- Dev: Remove `ChannelPageView::addIntInput`. (#6306)
- Dev: Implemented customizable display names for enums. (#6238)
- Dev: Refactored event API initialization away from Application and into TwitchIrcServer. (#6198)
- Dev: Updated GoogleTest to v1.17.0. (#6180)
- Dev: Don't detach threads. (#6333)
- Dev: Mini refactor of `TwitchAccount`. (#6182)
- Dev: Refactored away some `getApp` usages in `WindowManager`. (#6194)
- Dev: Refactored the Chatter List window into its own widget. (#6365)
- Dev: Simplified string literals to be a re-export of Qt functions. (#6175)
- Dev: Fixed incorrect lua generation of static methods for typescript plugins. (#6190, #6223)
- Dev: Merged top/bottom and left/right notebook layouts. (#6215)
- Dev: Refactored `Button` and friends. (#6102, #6255, #6266, #6302, #6268, #6334, #6371, #6372, #6423)
- Dev: Made "add split" button (part of the split header) a natively rendered button. (#6349, #6385)
- Dev: Made Settings & Account button on Linux/macOS SVGs. (#6267)
- Dev: Made "Chatters" button an SVG. (#6397)
- Dev: Made "Moderation" button an SVG. (#6398, #6412, #6414)
- Dev: Made user card "pin" button SVGs. (#6399, #6426)
- Dev: Some more setting widget refactors. (#6317)
- Dev: Emoji style / set is now stored lowercase (and matched case-insensitively). Changing emoji style from this point on and then running an old version might mean you will use the Twitter emoji style by default. (#6300)
- Dev: Refactored `OnceFlag`. (#6237, #6316)
- Dev: Bumped clang-format requirement to 19. (#6236)
- Dev: Added optional improved text wrapping through private Qt APIs. (#6265)
- Dev: Factored out AUMID to `Version`. (#6321)
- Dev: Silenced some warnings when compiling with clang-cl. (#6331)
- Dev: Update tooltip for colon completion setting. (#6370)
- Dev: Added some commands for forcing a relayout (and related things) in channel views. (#6342)
- Dev: Update vcpkg baseline. (#6359)
- Dev: Added an explicit `frozen` flag to `Message`. (#6367)
- Dev: Stop sending `JOIN`/`PART` commands for channels starting with `/`. (#6376)
- Dev: Error handlers for Sol check functions now take a function reference over an owning type. (#6393)
- Dev: Fix macOS CI build issues. (#6430)

## 2.5.3

- Minor: Shared chat messages now use the source channel's profile picture to denote it's a shared chat message. (#5760)
- Minor: Moved the "Delete message" menu option into a "Moderate" sub-menu. (#6100)
- Bugfix: Fixed the channel name input not being focused when opening the select-channel dialog. (#6096)
- Bugfix: Fixed inputs in dialogs not having a border around and padding in them. (#6098)
- Bugfix: Don't set default binding for "Toggle local R9K" on macOS. Was <kbd>CTRL</kbd> + <kdb>H</kdb> before, which clashes with a system binding. (#5764)
- Bugfix: Don't add moderation buttons to your own Usercard. (#6107)
- Dev: Temporarily disable precompiled header support for macOS. (#6104)

## 2.5.3-beta.1

- Minor: Added an option to allow multiple user-selected extensions to interact with Chatterino. (#5997)
- Minor: Add `Set highlight sounds` and `Open subscription page` split hotkeys. (#5856, #6030)
- Minor: `/clear` messages are now stacked like timeouts. (#5806)
- Minor: Treat all browsers starting with `firefox` as a Firefox browser. (#5805)
- Minor: Timestamps are now monospaced. (#6062)
- Minor: Remove incognito browser support for `opera/launcher` (this should no longer be a thing). (#5805)
- Minor: Remove incognito browser support for `iexplore`, because internet explorer is EOL. (#5810)
- Minor: When (re-)connecting, visible channels are now joined first. (#5850)
- Minor: Added the ability to filter on messages by the author's user ID (example: `author.user_id == "22484632"`). (#5862)
- Minor: Improved error messaging of the `/clip` command. (#5879)
- Minor: Clicking on a live notification can now open the channel in a custom player. (#5880)
- Minor: Added searchable hotkeys to global search and make keybinds searchable in the Hotkeys settings. (#5884)
- Minor: Added Linux support for Live Notifications toasts. (#5881, #5971, #5976)
- Minor: Messages can now be deleted from the context menu in a channel. (#5956)
- Minor: Overlay windows now inherit the global zoom level and can be zoomed independently. (#6016)
- Minor: The `/watching` channel is now supported on all platforms. (#6031, #6043)
- Minor: The font weight of chat messages can now be changed. (#6037)
- Minor: Messages from restricted users can now be hidden when in streamer mode. This is enabled by default. (#6042, #6049)
- Minor: Added a tab style option allowing you to make your tabs more compact. (#5858)
- Minor: Chatterino now warns about missing scopes when logging in. (#6072, #6083)
- Bugfix: Fixed a potential way to escape the Lua Plugin sandbox. (#5846)
- Bugfix: Fixed a crash relating to Lua HTTP. (#5800)
- Bugfix: Fixed a crash that could occur on Linux and macOS when clicking "Install" from the update prompt. (#5818)
- Bugfix: Fixed a crash related to image loading that could occur when closing Chatterino. (#6018)
- Bugfix: Fixed missing word wrap in update popup. (#5811)
- Bugfix: Fixed tabs not scaling to the default scale when changing the scale from a non-default value. (#5794)
- Bugfix: Closing a usercard will no longer cause stop-logging messages to be generated in channel logs. (#5828)
- Bugfix: Fixed tabs not scaling to the default scale when changing the scale from a non-default value. (#5794, #5833)
- Bugfix: Fixed deleted messages not immediately disappearing when "Hide deleted messages" is enabled. (#5844, #5854)
- Bugfix: Fixed announcements not showing up in mentions tab. (#5857)
- Bugfix: Fixed the reply button showing for inline whispers and announcements. (#5863)
- Bugfix: Fixed suspicious user treatment update messages not being searchable. (#5865)
- Bugfix: Ensure settings save after reauthenticating with a Twitch account. (#5901)
- Bugfix: Fixed user info popup's opened from `/live` making some network requests that always failed. (#5959)
- Bugfix: Ensure miniaudio backend exits even if it doesn't exit cleanly. (#5896)
- Bugfix: Fixed search in emote popup not always working correctly. (#5946)
- Bugfix: Fixed some text inputs being dark in light themes. (#6055)
- Bugfix: Fixed channel point redemptions with messages not showing up if PubSub is disconnected. (#5948)
- Bugfix: Fixed the input font not immediately updating when zooming in/out. (#5960)
- Bugfix: Fixed missing special shortcut for Windows live notifications. (#5975)
- Bugfix: Fixed color input thinking blue is also red. (#5982)
- Bugfix: Fixed a crash that would occurr if the user tried to open the search popup in an uninitialized split. (#6057)
- Bugfix: Fixed an issue where commands would sometimes reset if Chatterino was improperly shut down. (#6011)
- Bugfix: Fixed a thick border on Windows 11. (#5836)
- Bugfix: Fixed an issue where the Select Channel Dialog did not correctly scale when your window scale was too high. (#6081)
- Bugfix: Fixed some windows not immediately closing. (#6054)
- Bugfix: The emote button no longer looks crunchy. (#6080, #6085)
- Dev: Subscriptions to PubSub channel points redemption topics now use no auth token, making it continue to work during PubSub shutdown. (#5947)
- Dev: Add initial experimental EventSub support. (#5837, #5895, #5897, #5904, #5910, #5903, #5915, #5916, #5930, #5935, #5932, #5943, #5952, #5953, #5968, #5973, #5974, #5980, #5981, #5985, #5990, #5992, #5993, #5996, #5995, #6000, #6001, #6002, #6003, #6005, #6007, #6010, #6008, #6012, #6013, #6015, #6017, #6027, #6028, #6035, #6036, #6040, #6041, #6048, #6058, #6059, #6078, #6079, #6086, #6092, #6093)
- Dev: Remove unneeded platform specifier for toasts. (#5914)
- Dev: Cleanly shutdown on `SIGINT`/`SIGTERM` on Linux & macOS. (#6053)
- Dev: Highlight checks now use non-capturing groups for the boundaries. (#5784)
- Dev: Removed unused PubSub whisper code. (#5898)
- Dev: Updated Conan dependencies. (#5776)
- Dev: Added the `externally-packaged` mode. (#5975)
- Dev: Disable QT keywords (i.e. `emit`, `slots`, and `signals`). (#5882)
- Dev: Replaced usage of `parseTime` with `serverReceivedTime` for clearchat messages. (#5824, #5855)
- Dev: Support Boost 1.87. (#5832)
- Dev: Stopped building Qt5 builds in CI. (#5933)
- Dev: Updated CI macOS versions from 13 to 14. (#5934)
- Dev: Words from `TextElement`s are now combined where possible. (#5847)
- Dev: Fixed assertion failure when closing the edit-hotkey dialog. (#5869)
- Dev: Bumped FreeBSD CI image from 14.0 to 14.2. (#5949)
- Dev: Updated `qtkeychain` to 0.15.0. (#5871)
- Dev: Updated `googletest` to 1.16.0. (#5942)
- Dev: Fixed duplicate CMake configure in clean builds. (#5940)
- Dev: Enable plugins in builds by default. (#6075)
- Dev: BTTV emotes are now loaded as WEBP. (#5957)
- Dev: Reduced time we wait for PubSub connections to cleanly exit from 1s to 100ms. (#6019)
- Dev: Build with Qt 6.4.3 in CI. (#6032)
- Dev: Refactored some settings styles/APIs. (#6023)
- Dev: Added snapshot tests for EventSub. (#5965)
- Dev: Updated crashpad. (#6026)
- Dev: Mini feature refactor of BaseWindow. (#6074)
- Dev: Removed dead code and some MSVC warnings. (#6024)
- Dev: Added check if WEBP is supported. (#6073)
- Dev: Tests won't add themselves to the autostart on Windows anymore. (#6084)

## 2.5.2

- Bugfix: Fixed a crash in the 7TV EventApi when closing Chatterino. (#5768)
- Bugfix: Fixed scrollbar highlights being visible in overlay windows. (#5769)
- Bugfix: Make macos fonts look the same as v2.5.1. (#5775)
- Bugfix: Fixed 7TV usernames messing with Qt's HTML (#5780)
- Bugfix: Fixed BTTV emotes occasionally showing the wrong author. (#5783)
- Bugfix: Fixed some Twitch emotes containing HTML entities. (#5786)
- Bugfix: Fixed the same blocked term showing up more than once. (#5789)
- Dev: Hard-code Boost 1.86.0 in macos CI builders. (#5774)

## 2.5.2-beta.1

- Major: Add option to show pronouns in user card. (#5442, #5583)
- Major: Release plugins alpha. (#5288)
- Major: Improve high-DPI support on Windows. (#4868, #5391, #5664, #5666)
- Major: Added transparent overlay window (default keybind: <kbd>CTRL</kbd> + <kbd>ALT</kbd> + <kbd>N</kbd>). (#4746, #5643, #5659)
- Minor: Removed the Ctrl+Shift+L hotkey for toggling the "live only" tab visibility state. (#5530)
- Minor: Add support for Shared Chat messages. Shared chat messages can be filtered with the `flags.shared` filter variable, or with search using `is:shared`. Some messages like subscriptions are filtered on purpose to avoid confusion for the broadcaster. If you have both channels participating in Shared Chat open, only one of the message triggering your highlight will trigger. (#5606, #5625, #5661)
- Minor: Moved tab visibility control to a submenu, without any toggle actions. (#5530)
- Minor: Add option to customise Moderation buttons with images. (#5369)
- Minor: Colored usernames now update on the fly when changing the "Color @usernames" setting. (#5300)
- Minor: Added `flags.action` filter variable, allowing you to filter on `/me` messages. (#5397)
- Minor: Added the ability for `/ban`, `/timeout`, `/unban`, and `/untimeout` to specify multiple channels to duplicate the action to. Example: `/timeout --channel id:11148817 --channel testaccount_420 forsen 7m game complaining`. (#5402)
- Minor: The size of the emote popup is now saved. (#5415, #5751)
- Minor: Added the ability to duplicate tabs. (#5277)
- Minor: Improved error messages for channel update commands. (#5429)
- Minor: Moderators can now see when users are warned. (#5441)
- Minor: Added support for Brave & google-chrome-stable browsers. (#5452)
- Minor: Added drop indicator line while dragging in tables. (#5256)
- Minor: Add channel points indication for new bits power-up redemptions. (#5471)
- Minor: Added option to log streams by their ID, allowing for easier "per-stream" log analyzing. (#5507)
- Minor: Added `/warn <username> <reason>` command for mods. This prevents the user from chatting until they acknowledge the warning. (#5474)
- Minor: Added option to suppress live notifictions on startup. (#5388)
- Minor: Improve appearance of reply button. (#5491)
- Minor: Introduce HTTP API for plugins. (#5383, #5492, #5494)
- Minor: Support more Firefox variants for incognito link opening. (#5503)
- Minor: Replying to a message will now display the message being replied to. (#4350, #5519, #5586)
- Minor: Links can now have prefixes and suffixes such as parentheses. (#5486, #5515)
- Minor: Added support for scrolling in splits with touchscreen panning gestures. (#5524)
- Minor: Removed experimental IRC support. (#5547)
- Minor: Remember last popup size for next popup. (#5635)
- Minor: Moderators can now see which mods start and cancel raids. (#5563)
- Minor: The emote popup now reloads when Twitch emotes are reloaded. (#5580)
- Minor: Added `--login <username>` CLI argument to specify which account to start logged in as. (#5626)
- Minor: When blocking a channel, Chatterino will now warn you about that action. (#5615)
- Minor: Indicate when subscriptions and resubscriptions are for multiple months. (#5642)
- Minor: Added a setting to control whether or not to show "Blocked Term" automod messages. (#5690)
- Minor: Improved AutoMod messaging when messages are blocked due to containing blocked terms. (#5699, #5759)
- Minor: Proxy URL information is now included in the `/debug-env` command. (#5648)
- Minor: Make raid entry message usernames clickable. (#5651)
- Minor: Tabs unhighlight when their content is read in other tabs. (#5649)
- Minor: Made usernames in bits and sub messages clickable. (#5686)
- Minor: Mentions of FrankerFaceZ and BetterTTV in settings are standardized as such. (#5698)
- Minor: Emote names are no longer duplicated when using smarter emote completion. (#5705)
- Minor: Added a setting to hide the scrollbar thumb (the handle you can drag). Hiding the scrollbar thumb will disable mouse click & drag interactions in the scrollbar. (#5731)
- Minor: Added a setting to hide the scrollbar highlights. (#5732)
- Minor: The window layout is now backed up like the other settings. (#5647)
- Minor: Added `flags.similar` filter variable, allowing you to filter messages filtered by the R9K feature. (#5747)
- Bugfix: Fixed tab move animation occasionally failing to start after closing a tab. (#5426, #5612)
- Bugfix: If a network request errors with 200 OK, Qt's error code is now reported instead of the HTTP status. (#5378)
- Bugfix: Fixed restricted users usernames not being clickable. (#5405)
- Bugfix: Fixed a crash that could occur when logging was enabled in IRC servers that were removed. (#5419)
- Bugfix: Fixed message history occasionally not loading after a sleep. (#5457)
- Bugfix: Fixed a crash when tab completing while having an invalid plugin loaded. (#5401)
- Bugfix: Fixed windows on Windows not saving correctly when snapping them to the edges. (#5478)
- Bugfix: Fixed user info card popups adding duplicate line to log files. (#5499)
- Bugfix: Fixed tooltips and input completion popups not working after moving a split. (#5541, #5576)
- Bugfix: Fixed rare issue on shutdown where the client would hang. (#5557)
- Bugfix: Fixed `/clearmessages` not working with more than one window. (#5489)
- Bugfix: Fixed splits staying paused after unfocusing Chatterino in certain configurations. (#5504, #5637)
- Bugfix: Links with invalid characters in the domain are no longer detected. (#5509)
- Bugfix: Fixed janky selection for messages with RTL segments (selection is still wrong, but consistently wrong). (#5525)
- Bugfix: Fixed event emotes not showing up in autocomplete and popups. (#5239, #5580, #5582, #5632)
- Bugfix: Fixed tab visibility being controllable in the emote popup. (#5530)
- Bugfix: Fixed account switch not being saved if no other settings were changed. (#5558)
- Bugfix: Fixed a crash that could occur when handling the quick switcher popup really quickly. (#5687)
- Bugfix: Fixed 7TV badges being inadvertently animated. (#5674)
- Bugfix: Fixed some tooltips not being readable. (#5578)
- Bugfix: Fixed log files being locked longer than needed. (#5592)
- Bugfix: Fixed global badges not showing in anonymous mode. (#5599)
- Bugfix: Fixed grammar in the user highlight page. (#5602)
- Bugfix: Fixed incorrect message being disabled in some cases upon approving or denying an automod caught message. (#5611)
- Bugfix: Fixed network requests timing out despite them not being in flight for that long, for Qt 6.3+ where we have the technology. (#5729)
- Bugfix: Fixed double-click selection not working when clicking outside a message. (#5617)
- Bugfix: Fixed a rare crash that could occur on Windows if a toast was about to fire just as we were shutting down. (#5728, #5752)
- Bugfix: Fixed emotes starting with ":" not tab-completing. (#5603)
- Bugfix: Fixed 7TV emotes messing with Qt's HTML. (#5677)
- Bugfix: Fixed incorrect messages getting replaced visually. (#5683)
- Bugfix: Fixed rendering of multi-line selection that starts at a trailing space. (#5691)
- Bugfix: Fixed pause indicator not appearing in certain cases. (#5707)
- Bugfix: Fixed usercards not showing the login name in specific cases. (#5738)
- Dev: Default build with Qt6 on all platforms. (#5716)
- Dev: Update Windows build from Qt 6.5.0 to Qt 6.7.1. (#5420)
- Dev: Update vcpkg build Qt from 6.5.0 to 6.7.0, boost from 1.83.0 to 1.85.0, openssl from 3.1.3 to 3.3.0. (#5422)
- Dev: Unsingletonize `ISoundController`. (#5462)
- Dev: Use Qt's high DPI scaling. (#4868, #5400)
- Dev: Removed cosmetic "Also match the trigger at the end of the message" setting. (#5745)
- Dev: Add doxygen build target. (#5377)
- Dev: Make printing of strings in tests easier. (#5379)
- Dev: Refactor and document `Scrollbar`. (#5334, #5393)
- Dev: Refactor `TwitchIrcServer`, making it abstracted. (#5421, #5435)
- Dev: Reduced the amount of scale events. (#5404, #5406)
- Dev: Refactored settings widget creation. (#5585)
- Dev: Removed unused timegate settings. (#5361)
- Dev: Add `Channel::addSystemMessage` helper function, allowing us to avoid the common `channel->addMessage(makeSystemMessage(...));` pattern. (#5500)
- Dev: Unsingletonize `Resources2`. (#5460)
- Dev: All Lua globals now show in the `c2` global in the LuaLS metadata. (#5385, #5682)
- Dev: Images are now loaded in worker threads. (#5431)
- Dev: Fixed broken `SignalVector::operator[]` implementation. (#5556)
- Dev: Qt Creator now auto-configures Conan when loading the project and skips vcpkg. (#5305)
- Dev: The MSVC CRT is now bundled with Chatterino as it depends on having a recent version installed. (#5447)
- Dev: Refactor/unsingletonize `UserDataController`. (#5459)
- Dev: Cleanup `BrowserExtension`. (#5465)
- Dev: Deprecate Qt 5.12. (#5396)
- Dev: Refactored `MessageFlag` into its own file. (#5549)
- Dev: The running Qt version is now shown in the about page if it differs from the compiled version. (#5501)
- Dev: `FlagsEnum` is now `constexpr`. (#5510)
- Dev: Documented and added tests to RTL handling. (#5473)
- Dev: Refactored 7TV/BTTV definitions out of `TwitchIrcServer` into `Application`. (#5532)
- Dev: Refactored code that's responsible for deleting old update files. (#5535)
- Dev: Cleanly exit on shutdown. (#5537)
- Dev: Removed the `getTwitchAbstract` method in `Application`. (#5560)
- Dev: Renamed threads created by Chatterino on Linux and Windows. (#5538, #5539, #5544)
- Dev: Refactored a few `#define`s into `const(expr)` and cleaned includes. (#5527)
- Dev: Added `FlagsEnum::isEmpty`. (#5550)
- Dev: Prepared for Qt 6.8 by addressing some deprecations. (#5529)
- Dev: Moved some responsibility away from Application into WindowManager. (#5551)
- Dev: Fixed benchmarks segfaulting on run. (#5559)
- Dev: Refactored `MessageBuilder` to be a single class. (#5548)
- Dev: Recent changes are now shown in the nightly release description. (#5553, #5554, #5593)
- Dev: The timer for `StreamerMode` is now destroyed on the correct thread. (#5571, #5624)
- Dev: Cleanup some parts of the `magic_enum` adaptation for Qt. (#5587)
- Dev: Refactored `static`s in headers to only be present once in the final app. (#5588)
- Dev: Run benchmarks in CI. (#5610)
- Dev: Added more tests for input completion. (#5604)
- Dev: Refactored legacy Unicode zero-width-joiner replacement. (#5594)
- Dev: The JSON output when copying a message (<kbd>SHIFT</kbd> + right-click) is now more extensive. (#5600)
- Dev: Added more tests for message building. (#5598, #5654, #5656, #5671)
- Dev: `GIFTimer` is no longer initialized in tests. (#5608)
- Dev: Emojis now use flags instead of a set of strings for capabilities. (#5616)
- Dev: Move plugins to Sol2. (#5622, #5682)
- Dev: Clarified our Lua dependency's version. (#5693)
- Dev: Specified qtkeychain dependency version. (#5695, #5697)
- Dev: Refactored static `MessageBuilder` helpers to standalone functions. (#5652)
- Dev: Decoupled reply parsing from `MessageBuilder`. (#5660, #5668)
- Dev: Refactored IRC message building. (#5663)
- Dev: Fixed some compiler warnings. (#5672)
- Dev: Explicitly print output from `--version` to `stdout`. (#5727)
- Dev: Unified parsing of historic and live IRC messages. (#5678)
- Dev: 7TV's `entitlement.reset` is now explicitly ignored. (#5685)
- Dev: Qt 6.8 and later now default to the GDI fontengine. (#5710)
- Dev: Moved to condition variables when shutting down worker threads. (#5721, #5733)
- Dev: Reduced layouts in channel views when setting a channel. (#5737, #5748, #5757)

## 2.5.1

- Bugfix: Fixed links without a protocol not being clickable. (#5345)

## 2.5.0

- Major: Twitch follower emotes can now be correctly tabbed in other channels when you are subscribed to the channel the emote is from. (#4922)
- Major: Added `/automod` split to track automod caught messages across all open channels the user moderates. (#4986, #5026)
- Major: Moderators can now see restricted chat messages and suspicious treatment updates. (#5056, #5060)
- Minor: Migrated to the new Get Channel Followers Helix endpoint, fixing follower count not showing up in usercards. (#4809)
- Minor: Moderation commands such as `/ban`, `/timeout`, `/unban`, and `/untimeout` can now be used via User IDs by using the `id:123` syntax (e.g. `/timeout id:22484632 1m stop winning`). (#4945, #4956, #4957)
- Minor: The `/usercard` command now accepts user ids. (`/usercard id:22484632`) (#4934)
- Minor: Added menu actions to reply directly to a message or the original thread root. (#4923)
- Minor: The `/reply` command now replies to the latest message from the user. Due to this change, the message you intended to reply to is now shown in the reply context, instead of the first message in a thread. (#4919)
- Minor: The chatter list button is now hidden if you don't have moderator privileges. (#5245)
- Minor: Live streams that are marked as reruns now mark a tab as yellow instead of red. (#5176, #5237)
- Minor: Allowed theming of tab live and rerun indicators. (#5188)
- Minor: The _Restart on crash_ setting works again on Windows. (#5012)
- Minor: Added an option to use new experimental smarter emote completion. (#4987)
- Minor: Added support for FrankerFaceZ channel badges. These can be configured at https://www.frankerfacez.com/channel/mine - currently only supports bot badges for your chat bots. (#5119)
- Minor: Added support to send /announce[color] commands. Colored announcements only appear with the chosen color in Twitch chat. (#5250)
- Minor: The whisper highlight color can now be configured through the settings. (#5053)
- Minor: Added an option to always include the broadcaster in user completions. This is enabled by default. (#5193, #5244)
- Minor: Added a warning message if you have multiple commands with the same trigger. (#4322)
- Minor: Chatters from message history are now added to autocompletion. (#5116)
- Minor: Added support for the `{input.text}` placeholder in the **Split** -> **Run a command** hotkey. (#5130)
- Minor: Added `--activate <channel>` (or `-a`) command line option to focus or add a certain Twitch channel on startup. (#5111)
- Minor: Added the `--incognito/--no-incognito` options to the `/openurl` command, allowing you to override the "Open links in incognito/private mode" setting. (#5149, #5197)
- Minor: Added the ability to change the top-most status of a window regardless of the _Always on top_ setting (right click the notebook). (#5135)
- Minor: Added the ability to show AutoMod caught messages in mentions. (#5215)
- Minor: Added the ability to configure the color of highlighted AutoMod caught messages. (#5215)
- Minor: Updated to Emoji v15.1. Google emojis are now used as the fallback instead of Twitter emojis. (#5182)
- Minor: Added icons for newer versions of macOS. (#5148)
- Minor: Added more menu items in macOS menu bar. (#5266)
- Minor: Improved color selection and display. (#5057)
- Minor: Added a _System_ theme setting that updates according to the system's color scheme (requires Qt 6.5). (#5118)
- Minor: Normalized the input padding between light & dark themes. (#5095)
- Minor: The account switcher is now styled to match your theme. (#4817)
- Minor: Added a fallback theme field to custom themes that will be used in case the custom theme does not contain a color Chatterino needs. If no fallback theme is specified, we'll pull the color from the included Dark or Light theme. (#5198)
- Minor: Added a new completion API for experimental plugins feature. (#5000, #5047)
- Minor: Added a new Channel API for experimental plugins feature. (#5141, #5184, #5187)
- Minor: Introduce `c2.later()` function to Lua API. (#5154)
- Minor: Added `--safe-mode` command line option that can be used for troubleshooting when Chatterino is misbehaving or is misconfigured. It disables hiding the settings button & prevents plugins from loading. (#4985)
- Minor: Added wrappers for Lua `io` library for experimental plugins feature. (#5231)
- Minor: Added permissions to experimental plugins feature. (#5231)
- Minor: Added missing periods at various moderator messages and commands. (#5061)
- Minor: Improved Streamlink documentation in the settings dialog. (#5076)
- Minor: The installer now checks for the VC Runtime version and shows more info when it's outdated. (#4847)
- Minor: All sound capabilities can now be disabled by setting your "Sound backend" setting to "Null" and restarting Chatterino. (#4978)
- Minor: Added an invisible resize handle to the bottom of frameless user info popups and reply thread popups. (#4795)
- Minor: Updated the flatpakref link included with nightly builds to point to up-to-date flathub-beta builds. (#5008)
- Minor: Image links now reflect the scale of their image instead of an internal label. (#5201)
- Minor: IPC files are now stored in the Chatterino directory instead of system directories on Windows. (#5226)
- Minor: 7TV emotes now have a 4x image rather than a 3x image. (#5209)
- Minor: Add `reward.cost` `reward.id`, `reward.title` filter variables. (#5275)
- Minor: Change Lua `CompletionRequested` handler to use an event table. (#5280)
- Minor: Changed the layout of the about page. (#5287)
- Minor: Add duration to multi-month anon sub gift messages. (#5293)
- Minor: Added context menu action to toggle visibility of offline tabs. (#5318)
- Minor: Report sub duration for more multi-month gift cases. (#5319)
- Minor: Improved error reporting for the automatic streamer mode detection on Linux and macOS. (#5321)
- Bugfix: Fixed a crash that could occur on Wayland when using the image uploader. (#5314)
- Bugfix: Fixed split tooltip getting stuck in some cases. (#5309)
- Bugfix: Fixed the version string not showing up as expected in Finder on macOS. (#5311)
- Bugfix: Fixed links having `http://` added to the beginning in certain cases. (#5323)
- Bugfix: Fixed topmost windows from losing their status after opening dialogs on Windows. (#5330)
- Bugfix: Fixed a gap appearing when using filters on `/watching`. (#5329)
- Bugfix: Removed the remnant "Show chatter list" menu entry for non-moderators. (#5336)
- Bugfix: Fixed an issue where certain emojis did not send to Twitch chat correctly. (#4840)
- Bugfix: Fixed the `/shoutout` command not working with usernames starting with @'s (e.g. `/shoutout @forsen`). (#4800)
- Bugfix: Fixed capitalized channel names in log inclusion list not being logged. (#4848)
- Bugfix: Trimmed custom streamlink paths on all platforms making sure you don't accidentally add spaces at the beginning or end of its path. (#4834)
- Bugfix: Fixed a performance issue when displaying replies to certain messages. (#4807)
- Bugfix: Fixed an issue where certain parts of the split input wouldn't focus the split when clicked. (#4958)
- Bugfix: Fixed an issue in the `/live` split that caused some channels to not get grayed-out when they went offline. (#5172)\
- Bugfix: User text input within watch streak notices now correctly shows up. (#5029)
- Bugfix: Fixed selection of tabs after closing a tab when using "Live Tabs Only". (#4770)
- Bugfix: Fixed input in the reply thread popup losing focus when dragging said window. (#4815)
- Bugfix: Fixed the Quick Switcher (CTRL+K) sometimes showing up on the wrong window. (#4819)
- Bugfix: Fixed the font switcher not remembering what font you had previously selected. (#5224)
- Bugfix: Fixed too much text being copied when copying chat messages. (#4812, #4830, #4839)
- Bugfix: Fixed issue on Windows preventing the title bar from being dragged in the top left corner. (#4873)
- Bugfix: Fixed an issue where Streamer Mode did not detect that OBS was running on MacOS. (#5260)
- Bugfix: Remove ":" from the message the user is replying to if it's a /me message. (#5263)
- Bugfix: Fixed the "Cancel" button in the settings dialog only working after opening the settings dialog twice. (#5229)
- Bugfix: Fixed an issue where the setting `Only search for emote autocompletion at the start of emote names` wouldn't disable if it was enabled when the client started. (#4855)
- Bugfix: Fixed an empty page being added when showing the out of bounds dialog. (#4849)
- Bugfix: Fixed an issue preventing searching a redemption by it's title when the redemption contained user text input. (#5117)
- Bugfix: Fixed an issue where reply context didn't render correctly if an emoji was touching text. (#4875, #4977, #5174)
- Bugfix: Fixed the input completion popup sometimes disappearing when clicking on it on Windows and macOS. (#4876)
- Bugfix: Fixed Twitch badges not loading correctly in the badge highlighting setting page. (#5223)
- Bugfix: Fixed double-click text selection moving its position with each new message. (#4898)
- Bugfix: Fixed an issue where notifications on Windows would contain no or an old avatar. (#4899)
- Bugfix: Fixed headers of tables in the settings switching to bold text when selected. (#4913)
- Bugfix: Fixed tooltips appearing too large and/or away from the cursor. (#4920)
- Bugfix: Fixed thread popup window missing messages for nested threads. (#4923)
- Bugfix: Fixed an occasional crash for channel point redemptions with text input. (#4949)
- Bugfix: Fixed triple-click on message also selecting moderation buttons. (#4961)
- Bugfix: Fixed badge highlight changes not immediately being reflected. (#5110)
- Bugfix: Fixed emotes being reloaded when pressing "Cancel" in the settings dialog, causing a slowdown. (#5240)
- Bugfix: Fixed double-click selection not correctly selecting words that were split onto multiple lines. (#5243)
- Bugfix: Fixed some emotes not appearing when using _Ignores_. (#4965, #5126)
- Bugfix: Fixed a freeze from a bad regex in _Ignores_. (#4965, #5126)
- Bugfix: Fixed lookahead/-behind not working in _Ignores_. (#4965, #5126)
- Bugfix: Fixed Image Uploader accidentally deleting images with some hosts when link resolver was enabled. (#4971)
- Bugfix: Fixed a rare crash with the Image Uploader when closing a split right after starting an upload. (#4971)
- Bugfix: Fixed an issue on macOS where the Image Uploader would keep prompting the user even after they clicked "Yes, don't ask again". (#5011)
- Bugfix: The usercard button is now hidden in the User Info Popup when in special channels. (#4972)
- Bugfix: Fixed support for Windows 11 Snap layouts. (#4994, #5175)
- Bugfix: Fixed some windows appearing between screens. (#4797)
- Bugfix: Fixed a crash that could occur when clicking `More messages below` button in a usercard and closing it quickly. (#4933)
- Bugfix: Fixed a crash that could occur when using certain features in a Usercard after closing the split from which it was created. (#5034, #5051)
- Bugfix: Fixed a crash that could occur when using certain features in a Reply popup after closing the split from which it was created. (#5036, #5051)
- Bugfix: Fixed a bug on Wayland where tooltips would spawn as separate windows instead of behaving like tooltips. (#4998, #5040)
- Bugfix: Fixes to section deletion in text input fields. (#5013)
- Bugfix: Fixed avatar in usercard and moderation button triggering when releasing the mouse outside their area. (#5052)
- Bugfix: Fixed a bug where buttons would remain in a hovered state after leaving them. (#5077)
- Bugfix: Fixed an issue where you had to click the `reply` button twice if you already had that users @ in your input box. (#5173)
- Bugfix: Fixed popup windows not persisting between restarts. (#5081)
- Bugfix: Fixed splits not retaining their focus after minimizing. (#5080)
- Bugfix: Fixed _Copy message_ copying the channel name in global search. (#5106)
- Bugfix: Fixed some Twitch emotes sizes being wrong at certain zoom levels. (#5279, #5291)
- Bugfix: Fixed a missing space when the image uploader provided a delete link. (#5269)
- Bugfix: Reply contexts now use the color of the replied-to message. (#5145)
- Bugfix: Fixed top-level window getting stuck after opening settings. (#5161, #5166)
- Bugfix: Fixed link info not updating without moving the cursor. (#5178)
- Bugfix: Fixed an upload sometimes failing when copying an image from a browser if it contained extra properties. (#5156)
- Bugfix: Fixed tooltips getting out of bounds when loading images. (#5186)
- Bugfix: Fixed split header tooltips showing in the wrong position on Windows. (#5230)
- Bugfix: Fixed split header tooltips appearing too tall. (#5232)
- Bugfix: Fixed past messages not showing in the search popup after adding a channel. (#5248)
- Bugfix: Fixed pause indicator not disappearing in some cases. (#5265)
- Bugfix: Fixed the usercard popup not floating on tiling WMs on Linux when "Automatically close user popup when it loses focus" setting is enabled. (#3511)
- Bugfix: Fixed moderator-only topics being subscribed to for non-moderators. (#5056)
- Bugfix: Truncated IRC messages to be at most 512 bytes. (#5246)
- Bugfix: Fixed a data race when disconnecting from Twitch PubSub. (#4771)
- Bugfix: Fixed messages not immediately disappearing when clearing the chat. (#5282)
- Bugfix: Fixed highlights triggering for ignored users in announcements. (#5295)
- Dev: Changed the order of the query parameters for Twitch player URLs. (#5326)
- Dev: Run miniaudio in a separate thread, and simplify it to not manage the device ourselves. There's a chance the simplification is a bad idea. (#4978)
- Dev: Change clang-format from v14 to v16. (#4929)
- Dev: Fixed UTF16 encoding of `modes` file for the installer. (#4791)
- Dev: Temporarily disable High DPI scaling on Qt6 builds on Windows. (#4767)
- Dev: Tests now run on Ubuntu 22.04 instead of 20.04 to loosen C++ restrictions in tests. (#4774)
- Dev: Do a pretty major refactor of the Settings classes. List settings (e.g. highlights) are most heavily modified, and should have an extra eye kept on them. (#4775)
- Dev: conan: Update Boost to 1.83 & OpenSSL to 3.2.0. (#5007)
- Dev: Remove `boost::noncopyable` use & `boost_random` dependency. (#4776)
- Dev: Fix clang-tidy `cppcoreguidelines-pro-type-member-init` warnings. (#4426)
- Dev: Immediate layout for invisible `ChannelView`s is skipped. (#4811)
- Dev: Refactor `Image` & Image's `Frames`. (#4773)
- Dev: Add `WindowManager::getLastSelectedWindow()` to replace `getMainWindow()`. (#4816)
- Dev: Clarify signal connection lifetimes where applicable. (#4818)
- Dev: Laid the groundwork for advanced input completion strategies. (#4639, #4846, #4853, #4893)
- Dev: Fixed flickering when running with Direct2D on Windows. (#4851)
- Dev: Fix qtkeychain include for Qt6 users. (#4863)
- Dev: Add a compile-time flag `CHATTERINO_UPDATER` which can be turned off to disable update checks. (#4854)
- Dev: Add a compile-time flag `USE_SYSTEM_MINIAUDIO` which can be turned on to use the system miniaudio. (#4867)
- Dev: Update vcpkg to use Qt6. (#4872)
- Dev: Update `magic_enum` to v0.9.5. (#4992)
- Dev: Replace `boost::optional` with `std::optional`. (#4877)
- Dev: Improve performance of selecting text. (#4889, #4911)
- Dev: Removed direct dependency on Qt 5 compatibility module. (#4906)
- Dev: Added unit test capabilities to SplitInput. (#5179)
- Dev: Refactor `Emoji`'s EmojiMap into a vector. (#4980)
- Dev: Refactor `DebugCount` and add copy button to debug popup. (#4921)
- Dev: Refactor `common/Credentials`. (#4979)
- Dev: Refactor chat logger. (#5058)
- Dev: Refactor Twitch PubSub client. (#5059)
- Dev: Changed lifetime of context menus. (#4924)
- Dev: Renamed `tools` directory to `scripts`. (#5035)
- Dev: Refactor `ChannelView`, removing a bunch of clang-tidy warnings. (#4926)
- Dev: Refactor `IrcMessageHandler`, removing a bunch of clang-tidy warnings & changing its public API. (#4927)
- Dev: Removed almost all raw accesses into Application. (#5104)
- Dev: `Details` file properties tab is now populated on Windows. (#4912)
- Dev: Removed `Outcome` from network requests. (#4959)
- Dev: Added Tests for Windows and MacOS in CI. (#4970, #5032)
- Dev: Added "Copy message as JSON" option when shift-right-clicking a message. (#5150)
- Dev: Windows now builds with Qt6 by default. (#5155)
- Dev: Conan now uses OpenSSL 3 by default. (#5159)
- Dev: Move `clang-tidy` checker to its own CI job. (#4996)
- Dev: Refactored the Image Uploader feature. (#4971)
- Dev: Refactored the SplitOverlay code. (#5082)
- Dev: Refactored the Fonts code, making it less of a singleton. (#5228)
- Dev: Refactored the TwitchBadges structure, making it less of a singleton. (#5096, #5144)
- Dev: Refactored emotes out of TwitchIrcServer. (#5120, #5146)
- Dev: Refactored the ChatterinoBadges structure, making it less of a singleton. (#5103)
- Dev: Refactored the ColorProvider class a bit. (#5112)
- Dev: Moved the Network files to their own folder. (#5089)
- Dev: Fixed deadlock and use-after-free in tests. (#4981)
- Dev: Moved all `.clang-format` files to the root directory. (#5037)
- Dev: Load less message history upon reconnects. (#5001, #5018)
- Dev: Removed the `NullablePtr` class. (#5091)
- Dev: BREAKING: Replace custom `import()` with normal Lua `require()`. (#5014, #5108)
- Dev: Compile Lua as a C library. (#5251)
- Dev: Fixed most compiler warnings. (#5028, #5137)
- Dev: Added the ability to show `ChannelView`s without a `Split`. (#4747)
- Dev: Refactor Args to be less of a singleton. (#5041)
- Dev: Channels without any animated elements on screen will skip updates from the GIF timer. (#5042, #5043, #5045)
- Dev: Autogenerate docs/plugin-meta.lua. (#5055, #5283)
- Dev: Changed Ubuntu & AppImage builders to statically link Qt. (#5151)
- Dev: Refactor `NetworkPrivate`. (#5063)
- Dev: Refactor `Paths` & `Updates`, focusing on reducing their singletoniability. (#5092, #5102)
- Dev: Removed duplicate scale in settings dialog. (#5069)
- Dev: Fix `NotebookTab` emitting updates for every message. (#5068)
- Dev: Added benchmark for parsing and building recent messages. (#5071)
- Dev: Boost is depended on as a header-only library when using conan. (#5107)
- Dev: Added signal to invalidate paint buffers of channel views without forcing a relayout. (#5123)
- Dev: Specialize `Atomic<std::shared_ptr<T>>` if underlying standard library supports it. (#5133)
- Dev: Added the `developer_name` field to the Linux AppData specification. (#5138)
- Dev: Twitch messages can be sent using Twitch's Helix API instead of IRC (disabled by default). (#5200, #5276)
- Dev: Added estimation for image sizes to avoid layout shifts. (#5192)
- Dev: Added the `launachable` entry to Linux AppData. (#5210)
- Dev: Cleaned up and optimized resources. (#5222)
- Dev: Refactor `StreamerMode`. (#5216, #5236)
- Dev: Cleaned up unused code in `MessageElement` and `MessageLayoutElement`. (#5225)
- Dev: Adapted `magic_enum` to Qt's Utf-16 strings. (#5258)
- Dev: `NetworkManager`'s statics are now created in its `init` method. (#5254, #5297)
- Dev: `clang-tidy` CI now uses Qt 6. (#5273)
- Dev: Enabled `InsertNewlineAtEOF` in `clang-format`. (#5278)

## 2.4.6

- Minor: Migrate to the new Get Channel Followers Helix endpoint, fixing follower count not showing up in usercards. (#4809)
- Bugfix: Update Qt version, fixing a security issue with webp loading (see https://www.qt.io/blog/two-qt-security-advisorys-gdi-font-engine-webp-image-format) (#4843)
- Dev: Temporarily disable High DPI scaling on Qt6 builds on Windows. (#4767)

## 2.4.5

- Major: AutoMod term management messages (e.g. testaccount added "noob" as a blocked term on AutoMod.) are now hidden in Streamer Mode if you have the "Hide moderation actions" setting enabled. (#4758)
- Minor: Added `/shoutout <username>` command to shoutout a specified user. Note: This is only the /command, we are still unable to display when a shoutout happens. (#4638)
- Minor: Added a setting to only show tabs with live channels (default toggle hotkey: Ctrl+Shift+L). (#4358)
- Minor: Added an option to subscribe to and unsubscribe from reply threads. (#4680, #4739)
- Minor: Added the ability to pin Reply threads to stay open while using the setting "Automatically close reply thread popup when it loses focus". (#4680)
- Minor: Highlights loaded from message history will now correctly appear in the /mentions tab. (#4475)
- Minor: Added hotkey Action for pinning usercards and reply threads. (#4692)
- Minor: Added missing hotkey Action for Open Player in Browser. (#4756)
- Minor: Added an icon showing when streamer mode is enabled (#4410, #4690)
- Minor: Message input is now focused when clicking on emotes. (#4719)
- Minor: Changed viewer list to chatter list to more match Twitch's terminology. (#4732)
- Minor: Added currency & duration to Hype Chat messages. (#4715)
- Minor: Added `is:hype-chat` search option. (#4766)
- Minor: Added `flags.hype_chat` filter variable. (#4766)
- Minor: Nicknames are now taken into consideration when searching for messages. (#4663, #4742)
- Minor: Added a message for when Chatterino joins a channel (#4616)
- Minor: 7TV badges now automatically update upon changing them. (#4512)
- Minor: Removed restriction on Go To Message on system messages from search. (#4614)
- Minor: Channel point redemptions without custom text are now shown in the usercard. (#4557)
- Minor: Added settings for customizing the behavior of `Right Click`ing a usernames. (#4622, #4751)
- Minor: The input completion and quick switcher are now styled to match your theme. (#4671)
- Minor: All channels opened in browser tabs are synced when using the extension for quicker switching between tabs. (#4741)
- Minor: Added support for opening incognito links in firefox-esr and chromium. (#4745)
- Minor: Added support for opening incognito links under Linux/BSD using XDG. (#4745)
- Minor: Added accelerators to the right click menu for messages (#4705)
- Minor: Improved editing hotkeys. (#4628)
- Minor: Added `/c2-theme-autoreload` command to automatically reload a custom theme. This is useful for when you're developing your own theme. (#4718)
- Bugfix: Fixed an issue where Subscriptions & Announcements that contained ignored phrases would still appear if the Block option was enabled. (#4748)
- Bugfix: Increased amount of blocked users loaded from 100 to 1,000. (#4721)
- Bugfix: Fixed pings firing for the "Your username" highlight when not signed in. (#4698)
- Bugfix: Fixed a crash that could happen when closing splits before their display name was updated. This was especially noticeable after the live controller changes. (#4731)
- Bugfix: Fixed highlights sometimes not working after changing sound device, or switching users in your operating system. (#4729)
- Bugfix: Fixed a spacing issue with mentions inside RTL text. (#4677)
- Bugfix: Fixed a crash when opening and closing a reply thread and switching the user. (#4675)
- Bugfix: Fixed a crash that could occur when closing the usercard too quickly after blocking or unblocking a user. (#4711)
- Bugfix: Fixed visual glitches with smooth scrolling. (#4501)
- Bugfix: Fixed key bindings not showing in context menus on Mac. (#4722)
- Bugfix: Fixed timeouts from message history not behaving consistently. (#4760)
- Bugfix: Fixed partially broken filters on Qt 6 builds. (#4702)
- Bugfix: Fixed tooltips & popups sometimes showing up on the wrong monitor. (#4740)
- Bugfix: Fixed some network errors having `0` as their HTTP status. (#4704)
- Bugfix: Fixed tab completion rarely completing the wrong word. (#4735)
- Bugfix: Fixed generation of crashdumps by the browser-extension process when the browser was closed. (#4667)
- Dev: Stream status requests are now batched. (#4713)
- Dev: Added command to set Qt's logging filter/rules at runtime (`/c2-set-logging-rules`). (#4637)
- Dev: Added the ability to see & load custom themes from the Themes directory. No stable promises are made of this feature, changes might be made that breaks custom themes without notice. (#4570)
- Dev: Added test cases for emote and tab completion. (#4644)
- Dev: Fixed `clang-tidy-review` action not picking up dependencies. (#4648)
- Dev: Expanded upon `$$$` test channels. (#4655)
- Dev: Added tools to help debug image GC. (#4578)
- Dev: Removed duplicate license when having plugins enabled. (#4665)
- Dev: Replace our QObjectRef class with Qt's QPointer class. (#4666)
- Dev: Fixed warnings about QWidgets already having a QLayout. (#4672)
- Dev: Fixed undefined behavior when loading non-existent credentials. (#4673)
- Dev: Small refactor of the recent-messages API, splitting its internal API and its internal implementation up into separate files. (#4763)
- Dev: Added support for compiling with `sccache`. (#4678)
- Dev: Added `sccache` in Windows CI. (#4678)
- Dev: Moved preprocessor Git and date definitions to executables only. (#4681)
- Dev: Refactored tests to be able to use `ctest` and run in debug builds. (#4700)
- Dev: Added the ability to use an alternate linker using the `-DUSE_ALTERNATE_LINKER=...` CMake parameter. (#4711)
- Dev: The Windows installer is now built in CI. (#4408)
- Dev: Removed `getApp` and `getSettings` calls from message rendering. (#4535)
- Dev: Get the default browser executable instead of the entire command line when opening incognito links. (#4745)
- Dev: Removed unused code hidden behind the USEWEBENGINE define (#4757)

## 2.4.4

- Minor: Added a Send button in the input box so you can click to send a message. This is disabled by default and can be enabled with the "Show send message button" setting. (#4607)
- Minor: Improved error messages when the updater fails a download. (#4594)
- Minor: Added `/shield` and `/shieldoff` commands to toggle shield mode. (#4580)
- Bugfix: Fixed the menu warping on macOS on Qt6. (#4595)
- Bugfix: Fixed link tooltips not showing unless the thumbnail setting was enabled. (#4597)
- Bugfix: Domains starting with `http` are now parsed as links again. (#4598)
- Bugfix: Reduced the size of the update prompt to prevent it from going off the users screen. (#4626)
- Bugfix: Fixed click effects on buttons not being antialiased. (#4473)
- Bugfix: Fixed Ctrl+Backspace not working after Select All in chat search popup. (#4461)
- Bugfix: Fixed crash when scrolling up really fast. (#4621)
- Dev: Added the ability to control the `followRedirect` mode for requests. (#4594)

## 2.4.3

- Major: Added support for FrankerFaceZ animated emotes. (#4434)
- Minor: Added the ability to reply to a message by `Shift + Right Click`ing the username. (#4424)
- Minor: Reply context now censors blocked users. (#4502)
- Minor: Migrated the viewer list to Helix API. (#4117)
- Minor: Migrated badges to Helix API. (#4537)
- Minor: Added `/lowtrust` command to open the suspicious user activity feed in browser. (#4542)
- Minor: Added better filter validation and error messages. (#4364)
- Minor: Updated the look of the Black Theme to be more in line with the other themes. (#4523)
- Minor: Re-added leading @mentions from replies in chat logs. These were accidentally removed during the reply overhaul. (#4420)
- Minor: Added a local backup of the Twitch Badges API in case the request fails. (#4463)
- Minor: Updated the macOS icon to be consistent with the design of other applications on macOS. (#4577)
- Bugfix: Fixed an issue where Chatterino could lose track of the sound device in certain scenarios. (#4549)
- Bugfix: Fixed an issue where animated emotes would render on top of zero-width emotes. (#4314)
- Bugfix: Fixed an issue where it was difficult to hover a zero-width emote. (#4314)
- Bugfix: Fixed an issue where context-menu items for zero-width emotes displayed the wrong provider. (#4460)
- Bugfix: Fixed an issue where the "Enable zero-width emotes" setting was showing the inverse state. (#4462)
- Bugfix: Fixed blocked user list being empty when opening the settings dialog for the first time. (#4437)
- Bugfix: Fixed blocked user list sticking around when switching from a logged in user to being logged out. (#4437)
- Bugfix: Fixed search popup ignoring setting for message scrollback limit. (#4496)
- Bugfix: Fixed a memory leak that occurred when loading message history. This was mostly noticeable with unstable internet connections where reconnections were frequent or long-running instances of Chatterino. (#4499)
- Bugfix: Fixed Twitch channel-specific filters not being applied correctly. (#4529)
- Bugfix: Fixed `/mods` displaying incorrectly when the channel has no mods. (#4546)
- Bugfix: Fixed emote & badge tooltips not showing up when thumbnails were hidden. (#4509)
- Bugfix: Fixed links with invalid IPv4 addresses being parsed. (#4576)
- Bugfix: Fixed the macOS icon changing to the wrong icon when the application is open. (#4577)
- Dev: Disabling precompiled headers on Windows is now tested in CI. (#4472)
- Dev: Themes are now stored as JSON files in `resources/themes`. (#4471, #4533)
- Dev: Ignore unhandled BTTV user-events. (#4438)
- Dev: Only log debug messages when NDEBUG is not defined. (#4442)
- Dev: Cleaned up theme related code. (#4450)
- Dev: Ensure tests have default-initialized settings. (#4498)
- Dev: Add scripting capabilities with Lua (#4341, #4504)
- Dev: Conan 2.0 is now used instead of Conan 1.0. (#4417)
- Dev: Added tests and benchmarks for `LinkParser`. (#4436)
- Dev: Removed redundant parsing of links. (#4507)
- Dev: Experimental builds with Qt 6 are now provided. (#4522, #4551, #4553, #4554, #4555, #4556)
- Dev: Fixed username rendering in Qt 6. (#4476, #4568)
- Dev: Fixed placeholder color in Qt 6. (#4477)
- Dev: Removed `CHATTERINO_TEST` definitions. (#4526)
- Dev: Builds for macOS now have `macos` in their name (previously: `osx`). (#4550)
- Dev: Fixed a crash when dragging rows in table-views in builds with Qt 6. (#4567)

## 2.4.2

- Minor: Added `/banid` command that allows banning by user ID. (#4411)
- Bugfix: Fixed FrankerFaceZ emotes/badges not loading due to an API change. (#4432)
- Bugfix: Fixed uploaded AppImage not being able to execute most web requests. (#4400)
- Bugfix: Fixed a potential race condition due to using the wrong lock when loading 7TV badges. (#4402)
- Dev: Delete all but the last 5 crashdumps on application start. (#4392)
- Dev: Added capability to build Chatterino with Qt6. (#4393)
- Dev: Fixed homebrew update action. (#4394)

## 2.4.1

- Major: Added live emote updates for BTTV. (#4147)
- Minor: Added setting to turn off rendering of reply context. (#4224)
- Minor: Changed the highlight order to prioritize Message highlights over User highlights. (#4303)
- Minor: Added a setting to highlight your own messages in `Highlights -> Users`. (#3833)
- Minor: Added the ability to negate search options by prefixing it with an exclamation mark (e.g. `!badge:mod` to search for messages where the author does not have the moderator badge). (#4207)
- Minor: Search window input will automatically use currently selected text if present. (#4178)
- Minor: Grouped highlight sound columns together and improved wording for the default sound setting. (#4194)
- Minor: Tables in settings window will now scroll to newly added rows. (#4216)
- Minor: Added setting to select which channels to log. (#4302)
- Minor: Added channel name to /mentions log entries. (#4371)
- Minor: Added link to streamlink docs for easier user setup. (#4217)
- Minor: Added support for HTTP and Socks5 proxies through environment variables. (#4321)
- Minor: Added crashpad to capture crashes on Windows locally. See PR for build/crash analysis instructions. (#4351)
- Minor: Github releases now include flatpakref files for nightly builds
- Bugfix: Fixed User Card moderation actions not working after Twitch IRC chat command deprecation. (#4378)
- Bugfix: Fixed User Card broadcaster actions (mod, unmod, vip, unvip) not working after Twitch IRC chat command deprecation. (#4387)
- Bugfix: Fixed crash that would occur when performing certain actions after removing all tabs. (#4271)
- Bugfix: Fixed highlight sounds not reloading on change properly. (#4194)
- Bugfix: Fixed CTRL + C not working in reply thread popups. (#4209)
- Bugfix: Fixed message input showing as red after removing a message that was more than 500 characters. (#4204)
- Bugfix: Fixed unnecessary saving of windows layout. (#4201)
- Bugfix: Fixed Reply window missing selection clear behaviour between chat and input box. (#4218)
- Bugfix: Fixed crash that could occur when changing Tab layout and utilizing multiple windows. (#4248)
- Bugfix: Fixed text sometimes not pasting properly when image uploader was disabled. (#4246)
- Bugfix: Fixed text cursor(caret) not showing in open channel dialog. (#4196)
- Bugfix: Fixed tooltip images not appearing if mouse hovered only first pixel. (#4268)
- Bugfix: Fixed crash that could occur when closing down a split at the wrong time. (#4277)
- Bugfix: Fixed crash that could occur when closing down the last of a channel when reloading emotes. (#4278)
- Bugfix: Fixed scrollbar highlight colors when changing message history limit. (#4288)
- Bugfix: Fixed the split "Search" menu action not opening the correct search window. (#4305)
- Bugfix: Fixed an issue on Windows when opening links in incognito mode that contained forward slashes in hash (#4307)
- Bugfix: Fixed an issue where beta versions wouldn't update to stable versions correctly. (#4329)
- Bugfix: Fixed builds from GitHub showing up as modified. (#4384)
- Bugfix: Avoided crash that could occur when receiving channel point reward information. (#4360)
- Dev: Changed sound backend from Qt to miniaudio. (#4334)
- Dev: Removed sending part of the multipart emoji workaround. (#4361)
- Dev: Removed protocol from QApplication's Organization Domain (so changed from `https://www.chatterino.com` to `chatterino.com`). (#4256)
- Dev: Ignore `WM_SHOWWINDOW` hide events, causing fewer attempted rescales. (#4198)
- Dev: Migrated to C++ 20 (#4252, #4257)
- Dev: Enable LTO for main branch builds. (#4258, #4260)
- Dev: Removed unused include directives. (#4266, #4275, #4294)
- Dev: Removed TooltipPreviewImage. (#4268)
- Dev: Removed unused operators in `Image` (#4267)
- Dev: Removed usage of deprecated `QDesktopWidget` (#4287)
- Dev: Bump Cirrus CI FreeBSD image from 12.1 to 13.1. (#4295)
- Dev: Fixed `inconsistent-missing-override` warnings. (#4296)
- Dev: Fixed `final-dtor-non-final-class` warnings. (#4296)
- Dev: Fixed `ambiguous-reversed-operator` warnings. (#4296)
- Dev: Format YAML and JSON files with prettier. (#4304)
- Dev: Added CMake Install Support on Windows. (#4300)
- Dev: Changed conan generator to [`CMakeDeps`](https://docs.conan.io/en/latest/reference/conanfile/tools/cmake/cmakedeps.html) and [`CMakeToolchain`](https://docs.conan.io/en/latest/reference/conanfile/tools/cmake/cmaketoolchain.html). See PR for migration notes. (#4335)
- Dev: Refactored 7TV EventAPI implementation. (#4342)
- Dev: Disabled ImageExpirationPool in tests. (#4363)
- Dev: Don't rely on undocumented registry keys to find the default browser on Windows. (#4362)
- Dev: Use `QEnterEvent` for `QWidget::enterEvent` on Qt 6. (#4365)
- Dev: Use `qintptr` in `QWidget::nativeEvent` on Qt 6. (#4376)

## 2.4.0

- Major: Added support for emotes, badges, and live emote updates from [7TV](https://7tv.app). [Wiki Page](https://wiki.chatterino.com/Third_party_services/#7tv) (#4002, #4062, #4090)
- Major: Added support for Right-to-Left Languages (#3958, #4139, #4168)
- Major: Added support for Twitch's Chat Replies. [Wiki Page](https://wiki.chatterino.com/Features/#message-replies) (#3722, #3989, #4041, #4047, #4055, #4067, #4077, #3905, #4131)
- Major: Added multi-channel searching to search dialog via keyboard shortcut. (Ctrl+Shift+F by default) (#3694, #3875)
- Minor: Added setting to keep more message history in splits. (#3811)
- Minor: Added setting to keep more message history in usercards. (#3811)
- Minor: Added ability to pin Usercards to stay open even if it loses focus. Only available if "Automatically close usercard when it loses focus" is enabled. (#3884)
- Minor: Allow hiding moderation actions in streamer mode. (#3926)
- Minor: Added highlights for `Elevated Messages`. (#4016)
- Minor: Removed total views from the usercard, as Twitch no longer updates the number. (#3792)
- Minor: Load missing messages from Recent Messages API upon reconnecting (#3878, #3932)
- Minor: Reduced image memory usage when running Chatterino for a long time. (#3915)
- Minor: Added the ability to execute commands on chat messages using the message context menu. (#3738, #3765)
- Minor: Added settings to toggle BTTV/FFZ global/channel emotes (#3935, #3990)
- Minor: Added an option to display tabs on the right and bottom. (#3847)
- Minor: Added a `Scroll to top` keyboard shortcut for splits. (#3802)
- Minor: Added `/copy` command. Usage: `/copy <text>`. Copies provided text to clipboard - can be useful with custom commands. (#3763)
- Minor: Added `/requests` command. Usage: `/requests [channel]`. Opens the channel points requests queue for the provided channel or the current channel if no input is provided. (#3746)
- Minor: Added `Go to message` context menu action to search popup, mentions, usercard and reply threads. (#3953)
- Minor: Clicking `A message from x was deleted` messages will now jump to the message in question. (#3953)
- Minor: Added `is:first-msg` search option. (#3700)
- Minor: Added `is:elevated-msg` search option. (#4018)
- Minor: Added `is:cheer-msg` search option. (#4069)
- Minor: Added `is:redemption` search option. (#4118)
- Minor: Added `is:reply` search option. (#4119)
- Minor: Added `subtier:` search option (e.g. `subtier:3` to find Tier 3 subs). (#4013)
- Minor: Added `badge:` search option (e.g. `badge:mod` to users with the moderator badge). (#4013)
- Minor: Added AutoMod message flag filter. (#3938)
- Minor: Added `showInMentions` toggle for Badge Highlights. (#4034)
- Minor: Added chatter count for each category in viewer list. (#3683, #3719)
- Minor: Added option to open a user's chat in a new tab from the usercard profile picture context menu. (#3625)
- Minor: Added scrollbar to `Select filters` dialog. (#3737)
- Minor: Added quotation marks in the permitted/blocked Automod messages for clarity. (#3654)
- Minor: Added Quick Switcher item to open a channel in a new popup window. (#3828)
- Minor: Added information about the user's operating system in the About page. (#3663)
- Minor: Added option to hide inline whispers in streamer mode (#4076)
- Minor: Adjusted large stream thumbnail to 16:9 (#3655)
- Minor: Prevented user from entering incorrect characters in Live Notifications channels list. (#3715, #3730)
- Minor: Sorted usernames in /vips message to be case-insensitive. (#3696)
- Minor: Streamer mode now automatically detects if XSplit, PRISM Live Studio, Twitch Studio, or vMix are running. (#3740)
- Minor: Fixed automod caught message notice appearing twice for mods. (#3717)
- Minor: Fixed being unable to load Twitch Usercards from the `/mentions` tab. (#3623)
- Minor: Strip leading @ and trailing , from usernames in the `/block` and `/unblock` commands. (#3816)
- Minor: Fixed tag parsing for consecutive escaped characters. (#3711)
- Minor: Reduced GIF frame window from 30ms to 20ms, causing fewer frame skips in animated emotes. (#3886, #3907)
- Minor: Warn when parsing an environment variable fails. (#3904)
- Minor: Migrated /announce command to Helix API. (#4003)
- Minor: Migrated /clear command to Helix API. (#3994)
- Minor: Migrated /color command to Helix API. (#3988)
- Minor: Migrated /delete command to Helix API. (#3999)
- Minor: Migrated /emoteonly command to Helix API. (#4015)
- Minor: Migrated /emoteonlyoff command to Helix API. (#4015)
- Minor: Migrated /mod command to Helix API. (#4000)
- Minor: Migrated /unmod command to Helix API. (#4001)
- Minor: Migrated /vip command to Helix API. (#4010)
- Minor: Migrated /unvip command to Helix API. (#4025)
- Minor: Migrated /untimeout to Helix API. (#4026)
- Minor: Migrated /unban to Helix API. (#4026, #4050)
- Minor: Migrated /subscribers to Helix API. (#4040)
- Minor: Migrated /subscribersoff to Helix API. (#4040)
- Minor: Migrated /slow to Helix API. (#4040)
- Minor: Migrated /slowoff to Helix API. (#4040)
- Minor: Migrated /followers to Helix API. (#4040)
- Minor: Migrated /followersoff to Helix API. (#4040)
- Minor: Migrated /raid command to Helix API. Chat command will continue to be used until February 11th 2023. (#4029)
- Minor: Migrated /unraid command to Helix API. Chat command will continue to be used until February 11th 2023. (#4030)
- Minor: Migrated /ban to Helix API. (#4049, #4164)
- Minor: Migrated /timeout to Helix API. (#4049, #4164)
- Minor: Migrated /w to Helix API. Chat command will continue to be used until February 11th 2023. (#4052)
- Minor: Migrated /vips to Helix API. Chat command will continue to be used until February 11th 2023. (#4053)
- Minor: Migrated /uniquechat and /r9kbeta to Helix API. (#4057)
- Minor: Migrated /uniquechatoff and /r9kbetaoff to Helix API. (#4057)
- Minor: Migrated /commercial to Helix API. (#4094, #4141)
- Minor: Added stream titles to windows live toast notifications. (#1297)
- Minor: Make menus and placeholders display appropriate custom key combos. (#4045)
- Minor: Migrated /chatters to Helix API. (#4088, #4097, #4114)
- Minor: Migrated /mods to Helix API. (#4103)
- Minor: Improved text selection to match Windows native behaviour. (#4127)
- Minor: Add settings tooltips. (#3437)
- Minor: Add setting to limit message input length. (#3418)
- Minor: Make built-in commands work in IRC channels. (#4160)
- Minor: Add support for `echo-message` capabilities for IRC. (#4157)
- Minor: Add proper support for IRC private messages. (#4158)
- Minor: Improved look of tabs when using a layout other than top. (#3925, #4152)
- Minor: Added support for Nicknames on IRC. (#4170)
- Bugfix: Fixed crash happening when QuickSwitcher is used with a popout window. (#4187)
- Bugfix: Fixed low contrast of text in settings tooltips. (#4188)
- Bugfix: Fixed being unable to see the usercard of VIPs who have Asian language display names. (#4174)
- Bugfix: Fixed whispers always being shown in the /mentions split. (#4389)
- Bugfix: Fixed messages where Right-to-Left order is mixed in multiple lines. (#4173)
- Bugfix: Fixed the wrong right-click menu showing in the chat input box. (#4177)
- Bugfix: Fixed popup windows not appearing/minimizing correctly on the Windows taskbar. (#4181)
- Bugfix: Fixed white border appearing around maximized window on Windows. (#4190)
- Bugfix: Fixed window scaling being applied too many times on startup, causing windows like Settings to be slow. (#4193)
- Bugfix: Fixed input text cursor flickering when selecting text in a split. (#4197)
- Bugfix: Fixed shipped resources having incorrect ICC profile (#4199)
- Bugfix: Fixed channels with two leading `#`s not being usable on IRC (#4154)
- Bugfix: Fixed `Add new account` dialog causing main chatterino window to be non movable. (#4121)
- Bugfix: Connection to Twitch PubSub now recovers more reliably. (#3643, #3716)
- Bugfix: Fixed `Smooth scrolling on new messages` setting sometimes hiding messages. (#4028)
- Bugfix: Fixed context menu not opening when username is right clicked from usercard/search/reply window. (#4122)
- Bugfix: Fixed a crash that can occur when closing and quickly reopening a split, then running a command. (#3852)
- Bugfix: Fixed a crash that can occur when changing channels. (#3799)
- Bugfix: Fixed viewers list search not working when used before loading finishes. (#3774)
- Bugfix: Fixed live notifications for usernames containing uppercase characters. (#3646)
- Bugfix: Fixed live notifications not getting updated for closed streams going offline. (#3678)
- Bugfix: Fixed certain settings dialogs appearing behind the main window, when `Always on top` was used. (#3679)
- Bugfix: Fixed an issue in the emote picker where an emotes tooltip would not properly disappear. (#3686)
- Bugfix: Fixed incorrect spacing of settings icons at high DPI. (#3698)
- Bugfix: Fixed highlights triggering from own resub messages. (#3707)
- Bugfix: Fixed existing emote popups not being raised from behind other windows when refocusing them on macOS (#3713)
- Bugfix: Fixed automod queue pubsub topic persisting after user change. (#3718)
- Bugfix: Fixed viewer list not closing after pressing escape key. (#3734)
- Bugfix: Fixed users being assigned duplicate FrankerFaceZ badges. (#4155)
- Bugfix: Fixed links with no thumbnail having previous link's thumbnail. (#3720)
- Bugfix: Fixed message only showing a maximum of one global FrankerFaceZ badge even if the user has multiple. (#3818)
- Bugfix: Added an icon in the CMake macOS bundle. (#3832)
- Bugfix: Adopted popup windows in order to force floating behavior on some window managers. (#3836)
- Bugfix: Fixed split focusing being broken in certain circumstances when the "Show input when it's empty" setting was disabled. (#3838, #3860)
- Bugfix: Always refresh tab when a contained split's channel is set. (#3849)
- Bugfix: Fixed an issue where Anonymous gift messages appeared larger than normal gift messages. (#3888)
- Bugfix: Fixed crash related to logging IRC channels (#3918)
- Bugfix: Mentions of "You" in timeouts will link to your own user now instead of the user "You". (#3922)
- Bugfix: Fixed emoji popup not being shown in IRC channels (#4021)
- Bugfix: Display sent IRC messages like received ones (#4027)
- Bugfix: Fixed non-global FrankerFaceZ emotes from being loaded as global emotes. (#3921)
- Bugfix: Fixed trailing spaces from preventing Nicknames from working correctly. (#3946)
- Bugfix: Fixed crashes that can occur while selecting/copying messages and they are removed. (#4153)
- Bugfix: Fixed trailing spaces from preventing User Highlights from working correctly. (#4051)
- Bugfix: Fixed channel-based popups from rewriting messages to file log (#4060)
- Bugfix: Fixed invalid/dangling completion when cycling through previous messages or replying (#4072)
- Bugfix: Fixed incorrect .desktop icon path. (#4078)
- Bugfix: Mark bad or invalid images as empty. (#4151)
- Bugfix: Fixed `/watching` channel jumping around. (#4169)
- Dev: Got rid of BaseTheme (#4132)
- Dev: Removed official support for QMake. (#3839, #3883)
- Dev: Rewrote LimitedQueue (#3798)
- Dev: Set cmake `QT_DISABLE_DEPRECATED_BEFORE` to disable deprecated APIs up to Qt 5.15.0 (#4133)
- Dev: Overhauled highlight system by moving all checks into a Controller allowing for easier tests. (#3399, #3801, #3835)
- Dev: Use Game Name returned by Get Streams instead of querying it from the Get Games API. (#3662)
- Dev: Batched checking live status for all channels after startup. (#3757, #3762, #3767)
- Dev: Moved most command context into the command controller. (#3824)
- Dev: Error NetworkResults now include the body data. (#3987)
- Dev: Automatically generate resources files with cmake. (#4159, #4167)

## 2.3.5

- Major: Added highlights for first messages (#3267)
- Major: Added customizable shortcuts. (#2340, #3633)
- Minor: Make animated emote playback speed match browser (Firefox and Chrome) behaviour. (#3506)
- Minor: Added middle click split to open in browser (#3356)
- Minor: Added new search predicate to filter for messages matching a regex (#3282)
- Minor: Add `{channel.name}`, `{channel.id}`, `{stream.game}`, `{stream.title}`, `{my.id}`, `{my.name}` placeholders for commands (#3155)
- Minor: Remove TwitchEmotes.com attribution and the open/copy options when right-clicking a Twitch Emote. (#2214, #3136)
- Minor: Strip leading @ and trailing , from username in /user and /usercard commands. (#3143)
- Minor: Display a system message when reloading subscription emotes to match BTTV/FFZ behavior (#3135)
- Minor: Allow resub messages to show in `/mentions` tab (#3148)
- Minor: Added a setting to hide similar messages by any user. (#2716)
- Minor: Duplicate spaces now count towards the display message length. (#3002)
- Minor: Commands are now backed up. (#3168)
- Minor: Subcategories in settings are now searchable. (#3157)
- Minor: Added the ability to open an entire tab as a popup. (#3082)
- Minor: Added optional parameter to /usercard command for opening a usercard in a different channel context. (#3172)
- Minor: Added regex option to Nicknames. (#3146)
- Minor: Highlight usernames in /mods and /vips messages (#3187)
- Minor: Added `/raw` command. (#3189)
- Minor: Colorizing usernames on IRC, originally made for Mm2PL/dankerino (#3206)
- Minor: Fixed `/streamlink` command not stripping leading @'s or #'s (#3215)
- Minor: Strip leading @ and trailing , from username in `/popout` command. (#3217)
- Minor: Added `flags.reward_message` filter variable (#3231)
- Minor: Added `flags.elevated_message` filter variable. (#4017)
- Minor: Added `flags.cheer_message` filter variable. (#4069)
- Minor: Added chatter count to viewer list popout (#3261)
- Minor: Ignore out of bounds check for tiling wms (#3270)
- Minor: Add clear cache button to cache settings section (#3277)
- Minor: Added `flags.first_message` filter variable (#3292)
- Minor: Removed duplicate setting for toggling `Channel Point Redeemed Message` highlights (#3296)
- Minor: Added support for opening channels from twitch.tv/popout links. (#3309)
- Minor: Clean up chat messages of special line characters prior to sending. (#3312)
- Minor: IRC now parses/displays links like Twitch chat. (#3334)
- Minor: Added button & label for copying login name of user instead of display name in the user info popout. (#3335)
- Minor: Make `/delete` errors a bit more verbose (#3350)
- Minor: Made join and part message have links to usercards. (#3358)
- Minor: Show picked outcome in prediction badges. (#3357)
- Minor: Add support for Emoji in IRC (#3354)
- Minor: Added logging to experimental IRC (#2996)
- Minor: Moved `/live` logs to its own subdirectory. (Logs from before this change will still be available in `Channels -> live`). (#3393)
- Minor: Added clear button to settings search bar. (#3403)
- Minor: Added autocompletion for default Twitch commands starting with the dot (e.g. `.mods` which does the same as `/mods`). (#3144)
- Minor: Sorted usernames in `Users joined/parted` messages alphabetically. (#3421)
- Minor: Mod list, VIP list, and Users joined/parted messages are now searchable. (#3426)
- Minor: Add search to emote popup. (#3404, #3527, #3543)
- Minor: Messages can now be highlighted by subscriber or founder badges. (#3445)
- Minor: User timeout buttons can now be triggered using hotkeys. (#3483)
- Minor: Add workaround for multipart emoji as described in [the RFC](https://mm2pl.github.io/emoji_rfc.pdf). (#3469)
- Minor: Added a way to open channel popup by right-clicking the avatar in a usercard. (#3486)
- Minor: Add feedback when using the whisper command `/w` incorrectly. (#3439)
- Minor: Add feedback when writing a non-command message in the `/whispers` split. (#3439)
- Minor: Opening streamlink through hotkeys and/or split header menu matches `/streamlink` command and shows feedback in chat as well. (#3510)
- Minor: Removed timestamp from AutoMod messages. (#3503)
- Minor: Added ability to copy message ID with `Shift + Right Click`. (#3481)
- Minor: Added /popup command to open currently focused split or supplied channel in a new window. (#3529)
- Minor: Colorize the entire split header when focused. (#3379)
- Minor: Added incremental search to channel search. (#3544)
- Minor: Show right click context menu anywhere within a message's line. (#3566)
- Minor: Make Tab Layout setting only accept predefined values (#3564)
- Minor: Added librewolf, icecat, and waterfox incognito support. (#3588)
- Minor: Updated to Emoji v14.0 (#3612)
- Minor: Add support for locking tab arrangement (#3627)
- Bugfix: Fixed rendering of moderator announcements. (#3639)
- Bugfix: Fix Split Input hotkeys not being available when input is hidden (#3362)
- Bugfix: Fixed colored usernames sometimes not working. (#3170)
- Bugfix: Restored ability to send duplicate `/me` messages. (#3166)
- Bugfix: Notifications for moderators about other moderators deleting messages can now be disabled. (#3121)
- Bugfix: Moderation mode and active filters are now preserved when opening a split as a popup. (#3113, #3130)
- Bugfix: Fixed a bug that caused all badge highlights to use the same color. (#3132, #3134)
- Bugfix: Allow starting Streamlink from Chatterino when running as a Flatpak. (#3178)
- Bugfix: Fixed own IRC messages not having metadata and a link to a usercard. (#3203)
- Bugfix: Fixed some channels still not loading in rare cases. (#3219)
- Bugfix: Fixed a bug with usernames or emotes completing from the wrong position. (#3229)
- Bugfix: Fixed a bug that caused zero-width emotes to be misaligned when the "Remove spaces between emotes" setting is on. (#3249)
- Bugfix: Fixed second chatterino icon appearing in the dock when restarting on a crash in macOS. (#3268)
- Bugfix: Fixed the "Change channel" popup showing a wrong window title (#3273)
- Bugfix: Fixed built-in Chatterino commands not working in whispers and mentions special channels (#3288)
- Bugfix: Fixed `QCharRef with an index pointing outside the valid range of a QString` warning that was emitted on every Tab press. (#3234)
- Bugfix: Fixed being unable to disable `First Message` highlights (#3293)
- Bugfix: Fixed `First Message` custom sound not persisting through restart. (#3303)
- Bugfix: Fixed `First Message` scrollbar highlights not being disabled. (#3325)
- Bugfix: Fixed the reconnection backoff accidentally resetting when thrown out of certain IRC servers. (#3328)
- Bugfix: Fixed underlying text from disabled emotes not being colorized properly. (#3333)
- Bugfix: Fixed IRC ACTION messages (/me) not being colorized properly. (#3341)
- Bugfix: Fixed splits losing filters when closing and reopening them (#3351)
- Bugfix: Fixed the first usercard being broken in `/mods` and `/vips` (#3349)
- Bugfix: Fixed IRC colors not being applied correctly to NOTICE messages. (#3383)
- Bugfix: Fixed Chatterino attempting to send empty messages (#3355)
- Bugfix: Fixed IRC highlights not triggering sounds or alerts properly. (#3368)
- Bugfix: Fixed IRC /kick command crashing if parameters were malformed. (#3382)
- Bugfix: Fixed crash that would occur if the user tries to modify the currently connected IRC connection. (#3398)
- Bugfix: Fixed IRC mentions not showing up in the /mentions split. (#3400)
- Bugfix: Fixed a crash that could occur on certain Linux systems when toggling the Always on Top flag. (#3385)
- Bugfix: Fixed zero-width emotes sometimes wrapping lines incorrectly. (#3389)
- Bugfix: Fixed using special chars in Windows username breaking the storage of custom commands (#3397)
- Bugfix: Fixed character counter changing fonts after going over the limit. (#3422)
- Bugfix: Fixed crash that could occur if the user opens/closes ChannelViews (e.g. EmotePopup, or Splits) then modifies the showLastMessageIndicator setting. (#3444)
- Bugfix: Removed ability to reload emotes really fast (#3450)
- Bugfix: Re-add date of build to the "About" page on nightly versions. (#3464)
- Bugfix: Fixed crash that would occur if the user right-clicked AutoMod badge. (#3496)
- Bugfix: Fixed being unable to drag the user card window from certain spots. (#3508)
- Bugfix: Fixed being unable to open a usercard from inside a usercard while "Automatically close user popup when it loses focus" was enabled. (#3518)
- Bugfix: Usercards no longer close when the originating window (e.g. a search popup) is closed. (#3518)
- Bugfix: Disabled /popout and /streamlink from working in non-twitch channels (e.g. /whispers) when supplied no arguments. (#3541)
- Bugfix: Fixed automod and unban messages showing when moderation actions were disabled (#3548)
- Bugfix: Fixed crash when rendering a highlight inside of a sub message, with sub message highlights themselves turned off. (#3556)
- Bugfix: Don't grab the keyboard in channel picker dialog (#3575)
- BugFix: Fixed SplitInput placeholder color. (#3606)
- BugFix: Remove game from stream/split title when set to "nothing." (#3609)
- BugFix: Fixed double-clicking on usernames with right/middle click causing text selection. (#3608)
- Dev: Batch checking live status for channels with live notifications that aren't connected. (#3442)
- Dev: Add GitHub action to test builds without precompiled headers enabled. (#3327)
- Dev: Renamed CMake's build option `USE_SYSTEM_QT5KEYCHAIN` to `USE_SYSTEM_QTKEYCHAIN`. (#3103)
- Dev: Add benchmarks that can be compiled with the `BUILD_BENCHMARKS` CMake flag. Off by default. (#3038)
- Dev: Added CMake build option `BUILD_WITH_QTKEYCHAIN` to build with or without Qt5Keychain support (On by default). (#3318)
- Dev: Added /fakemsg command for debugging (#3448)
- Dev: Notebook::select\* functions now take an optional `focusPage` parameter (true by default) which keeps the default behaviour of selecting the page after it has been selected. If set to false, the page is _not_ focused after being selected. (#3446)
- Dev: Updated PubSub client to use TLS v1.2 (#3599)
- Dev: Use system logical core count for Ubuntu/macOS GitHub actions builds. (#3602)

## 2.3.4

- Major: Newly uploaded Twitch emotes are once again present in emote picker and can be autocompleted with Tab as well. (#2992)
- Major: Deprecated `/(un)follow` commands and (un)following in the usercards as Twitch has removed this feature for 3rd party applications. (#3076, #3078)
- Major: Added the ability to add nicknames for users. (#137, #2981)
- Major: Fixed constant disconnections with more than 20 channels by rate-limiting outgoing JOIN messages. (#3112, #3115)
- Minor: Added autocompletion in /whispers for Twitch emotes, Global Bttv/Ffz emotes and emojis. (#2999, #3033)
- Minor: Received Twitch messages now use the exact same timestamp (obtained from Twitch's server) for every Chatterino user instead of assuming message timestamp on client's side. (#3021)
- Minor: Received IRC messages use `time` message tag for timestamp if it's available. (#3021)
- Minor: Added informative messages for recent-messages API's errors. (#3029)
- Minor: Added section with helpful Chatterino-related links to the About page. (#3068)
- Minor: Now uses spaces instead of magic Unicode character for sending duplicate messages (#3081)
- Minor: Added `channel.live` filter variable (#3092, #3110)
- Bugfix: Fixed "smiley" emotes being unable to be "Tabbed" with autocompletion, introduced in v2.3.3. (#3010)
- Bugfix: Fixed PubSub not properly trying to resolve pending listens when the pending listens list was larger than 50. (#3037)
- Bugfix: Copy buttons in usercard now show properly in light mode (#3057)
- Bugfix: Fixed comma appended to username completion when not at the beginning of the message. (#3060)
- Bugfix: Fixed bug misplacing chat when zooming on Chrome with Chatterino Native Host extension (#1936)
- Bugfix: Channel point redemptions from ignored users are now properly blocked. (#3102)
- Dev: Allow building against Qt 5.11 (#3105)
- Dev: Ubuntu packages are now available (#2936)
- Dev: Disabled update checker on Flatpak. (#3051)
- Dev: Add logging for HTTP requests (#2991)

## 2.3.3

- Major: Added username autocompletion popup menu when typing usernames with an @ prefix. (#1979, #2866)
- Major: Added ability to toggle visibility of Channel Tabs - This can be done by right-clicking the tab area or pressing the keyboard shortcut (default: Ctrl+U). (#2600)
- Minor: Username in channel points rewards redemption messages is now clickable. (#2673, #2953)
- Minor: Channel name in `<channel> has gone offline. Exiting host mode.` messages is now clickable. (#2922)
- Minor: Added `/openurl` command. Usage: `/openurl <URL>`. Opens the provided URL in the browser. (#2461, #2926)
- Minor: Updated to Emoji v13.1 (#2958)
- Minor: Added "Open in: new tab, browser player, streamlink" in twitch link context menu. (#2988)
- Minor: Sender username in automod messages shown to moderators shows correct color and display name. (#2967)
- Minor: The /live split now shows channels going offline. (#2880)
- Minor: Restore automod functionality for moderators (#2817, #2887)
- Minor: Add setting for username style (#2889, #2891)
- Minor: Searching for users in the viewer list now searches anywhere in the user's name. (#2861)
- Minor: Added moderation buttons to search popup when searching in a split with moderation mode enabled. (#2148, #2803)
- Minor: Made "#channel" in `/mentions` tab show in usercards and in the search popup. (#2802)
- Minor: Added settings to disable custom FrankerFaceZ VIP/mod badges. (#2693, #2759)
- Minor: Limit the number of recent chatters to improve memory usage and reduce freezes. (#2796, #2814)
- Minor: Added `/popout` command. Usage: `/popout [channel]`. It opens browser chat for the provided channel. Can also be used without arguments to open current channels browser chat. (#2556, #2812)
- Minor: Improved matching of game names when using `/setgame` command (#2636)
- Minor: Now shows deletions of messages like timeouts (#1155, #2841, #2867, #2874)
- Minor: Added a link to accounts page in settings to "You need to be logged in to send messages" message. (#2862)
- Minor: Switch to Twitch v2 emote API for animated emote support. (#2863)
- Bugfix: Now deleting cache files that weren't modified in the past 14 days. (#2947)
- Bugfix: Fixed large timeout durations in moderation buttons overlapping with usernames or other buttons. (#2865, #2921)
- Bugfix: Middle mouse click no longer scrolls in not fully populated usercards and splits. (#2933)
- Bugfix: Fix bad behavior of the HTML color picker edit when user input is being entered. (#2942)
- Bugfix: Made follower emotes suggested (in emote popup menu, tab completion, emote input menu) only in their origin channel, not globally. (#2951)
- Bugfix: Fixed founder badge not being respected by `author.subbed` filter. (#2971)
- Bugfix: Usercards on IRC will now only show user's messages. (#1780, #2979)
- Bugfix: Messages that couldn't be searched or filtered are now handled correctly. (#2962)
- Bugfix: Moderation buttons now show the correct time unit when using units other than seconds. (#1719, #2864)
- Bugfix: Fixed FFZ emote links for global emotes (#2807, #2808)
- Bugfix: Fixed pasting text with URLs included (#1688, #2855)
- Bugfix: Fix reconnecting when IRC write connection is lost (#1831, #2356, #2850, #2892)
- Bugfix: Fixed bit and new subscriber emotes not (re)loading in some rare cases. (#2856, #2857)
- Bugfix: Fixed subscription emotes showing up incorrectly in the emote menu. (#2905)

## 2.3.2

- Major: New split for channels going live! /live. (#1797)
- Minor: Added a message that displays a new date on new day. (#1016)
- Minor: Hosting messages are now clickable. (#2655)
- Minor: Messages held by automod are now shown to the user. (#2626)
- Minor: Load 100 blocked users rather than the default 20. (#2772)
- Bugfix: Fixed a potential crashing issue related to the browser extension. (#2774)
- Bugfix: Strip newlines from stream titles to prevent text going off of split header (#2755)
- Bugfix: Automod messages now work properly again. (#2682)
- Bugfix: `Login expired` message no longer highlights all tabs. (#2735)
- Bugfix: Fix a deadlock that would occur during user badge loading. (#1704, #2756)
- Bugfix: Tabbing in `Select a channel to open` is now consistent. (#1797)
- Bugfix: Fix Ctrl + Backspace not closing colon emote picker. (#2780)
- Bugfix: Approving/denying AutoMod messages works again. (#2779)
- Dev: Migrated AutoMod approve/deny endpoints to Helix. (#2779)
- Dev: Migrated Get Cheermotes endpoint to Helix. (#2440)

## 2.3.1

- Major: Fixed crashing with the extension (#2704)
- Major: Added the ability to highlight messages based on user badges. (#1704)
- Minor: Added visual indicator to message length if over 500 characters long (#2659)
- Minor: Added `is:<flags>` search filter to find messages of specific types. (#2653, #2671)
- Minor: Added image links to the badge context menu. (#2667)
- Minor: Added a setting to hide Twitch Predictions badges. (#2668)
- Minor: Optionally remove spaces between emotes, originally made for Mm2PL/Dankerino. (#2651)
- Minor: Improved UX of `Rename Tab` dialog. (#2713)
- Bugfix: Added missing Copy/Open link context menu entries to emotes in Emote Picker. (#2670)
- Bugfix: Fixed visual glitch with smooth scrolling. (#2084)
- Bugfix: Clicking on split header focuses its split. (#2720)
- Bugfix: Handle new user messages ("rituals") properly. (#2703)

## 2.3.0

- Major: Added custom FrankerFaceZ VIP Badges. (#2628)
- Minor: Added `in:<channels>` search filter to find messages sent in specific channels. (#2299, #2634)
- Minor: Allow for built-in Chatterino commands to be used in custom commands. (#2632)
- Bugfix: Size of splits not saved properly (#2362, #2548)
- Bugfix: Fix crash that could occur when the user changed the "Custom stream player URI Scheme" setting if the user had closed down and splits in the application runtime. (#2592)
- Major: Added clip creation support. You can create clips with `/clip` command, `Alt+X` keybind or `Create a clip` option in split header's context menu. This requires a new authentication scope so re-authentication will be required to use it. (#2271, #2377, #2528)
- Major: Added "Channel Filters". See https://wiki.chatterino.com/Filters/ for how they work or how to configure them. (#1748, #2083, #2090, #2200, #2225)
- Major: Added Streamer Mode configuration (under `Settings -> General`), where you can select which features of Chatterino should behave differently when you are in Streamer Mode. (#2001, #2316, #2342, #2376)
- Major: Add `/settitle` and `/setgame` commands, originally made for Mm2PL/Dankerino. (#2534, #2609)
- Major: Color mentions to match the mentioned users. You can disable this by unchecking "Color @usernames" under `Settings -> General -> Advanced (misc.)`. (#1963, #2284, #2597)
- Major: Commands `/ignore` and `/unignore` have been renamed to `/block` and `/unblock` in order to keep consistency with Twitch's terms. (#2370)
- Major: Added support for bit emotes - the ones you unlock after cheering to streamer. (#2550)
- Minor: Added `/clearmessages` command - does what "Burger menu -> More -> Clear messages" does. (#2485)
- Minor: Added `/marker` command - similar to webchat, it creates a stream marker. (#2360)
- Minor: Added `/chatters` command showing chatter count. (#2344)
- Minor: Added a button to the split context menu to open the moderation view for a channel when the account selected has moderator permissions. (#2321)
- Minor: Made BetterTTV emote tooltips use authors' display name. (#2267)
- Minor: Added Ctrl + 1/2/3/... and Ctrl+9 shortcuts to Emote Popup (activated with Ctrl+E). They work exactly the same as shortcuts in main window. (#2263)
- Minor: Added reconnect link to the "You are banned" message. (#2266)
- Minor: Improved search popup window titles. (#2268)
- Minor: Made "#channel" in `/mentions` tab a clickable link which takes you to the channel that you were mentioned in. (#2220)
- Minor: Added a keyboard shortcut (Ctrl+F5) for "Reconnect" (#2215)
- Minor: Made `Try to find usernames without @ prefix` option still resolve usernames when special characters (commas, dots, (semi)colons, exclamation mark, question mark) are appended to them. (#2212)
- Minor: Made usercard update user's display name (#2160)
- Minor: Added placeholder text for message text input box. (#2143, #2149, #2264)
- Minor: Added support for FrankerFaceZ badges. (#2101, part of #1658)
- Minor: Added a navigation list to the settings and reordered them.
- Minor: Added a link to twitchemotes.com to context menu when right-clicking Twitch emotes. (#2214)
- Minor: Improved viewer list window.
- Minor: Added emote completion with `:` to the whispers channel (#2075)
- Minor: Made the current channels emotes appear at the top of the emote picker popup. (#2057)
- Minor: Added viewer list button to twitch channel header. (#1978)
- Minor: Added followage and subage information to usercard. (#2023)
- Minor: Added an option to only open channels specified in command line with `-c` parameter. You can also use `--help` to display short help message (#1940, #2368)
- Minor: Added customizable timeout buttons to the user info popup
- Minor: Deprecate loading of "v1" window layouts. If you haven't updated Chatterino in more than 2 years, there's a chance you will lose your window layout.
- Minor: User popup will now automatically display messages as they are received. (#1982, #2514)
- Minor: Changed the English in two rate-limited system messages (#1878)
- Minor: Added a setting to disable messages sent to /mentions split from making the tab highlight with the red marker (#1994)
- Minor: Added image for streamer mode in the user popup icon.
- Minor: Added vip and unvip buttons.
- Minor: Added settings for displaying where the last message was.
- Minor: Commands are now saved upon pressing Ok in the settings window
- Minor: Colorized nicknames now enabled by default
- Minor: Show channels live now enabled by default
- Minor: Bold usernames enabled by default
- Minor: Improve UX of the "Login expired!" message (#2029)
- Minor: PageUp and PageDown now scroll in the selected split and in the emote popup (#2070, #2081, #2410, #2607)
- Minor: Allow highlights to be excluded from `/mentions`. Excluded highlights will not trigger tab highlights either. (#1793, #2036)
- Minor: Flag all popup dialogs as actual dialogs so they get the relevant window manager hints (#1843, #2182, #2185, #2232, #2234)
- Minor: Don't show update button for nightly builds on macOS and Linux, this was already the case for Windows (#2163, #2164)
- Minor: Tab and split titles now use display/localized channel names (#2189)
- Minor: Add a setting to limit the amount of historical messages loaded from the Recent Messages API (#2250, #2252)
- Minor: Made username autocompletion truecase (#1199, #1883)
- Minor: Update the listing of top-level domains. (#2345)
- Minor: Properly respect RECONNECT messages from Twitch (#2347)
- Minor: Added command line option to attach chatterino to another window.
- Minor: Hide "Case-sensitive" column for user highlights. (#2404)
- Minor: Added human-readable formatting to remaining timeout duration. (#2398)
- Minor: Update emojis version to 13 (2020). (#1555)
- Minor: Remove EmojiOne 2 and 3 due to license restrictions. (#1555)
- Minor: Added `/streamlink` command. Usage: `/streamlink <channel>`. You can also use the command without arguments in any twitch channel to open it in streamlink. (#2443, #2495)
- Minor: Humanized all numbers visible to end-users. (#2488)
- Minor: Added a context menu to avatar in usercard. It opens on right-clicking the avatar in usercard. (#2517)
- Minor: Handle messages that users can share after unlocking a new bits badge. (#2611)
- Bugfix: Fix crash occurring when pressing Escape in the Color Picker Dialog (#1843)
- Bugfix: Fix bug where the "check user follow state" event could trigger a network request requesting the user to follow or unfollow a user. By itself its quite harmless as it just repeats to Twitch the same follow state we had, so no follows should have been lost by this but it meant there was a rogue network request that was fired that could cause a crash (#1906)
- Bugfix: /usercard command will now respect the "Automatically close user popup" setting (#1918)
- Bugfix: Handle symlinks properly when saving commands & settings (#1856, #1908)
- Bugfix: Starting Chatterino in a minimized state after an update will no longer cause a crash
- Bugfix: Modify the emote parsing to handle some edge-cases with dots and stuff. (#1704, #1714, #2490)
- Bugfix: Fixed timestamps being incorrect on some messages loaded from the recent-messages service on startup (#1286, #2020)
- Bugfix: Fixed timestamps missing on channel point redemption messages (#1943)
- Bugfix: Fixed tooltip didn't show in `EmotePopup` depending on the `Link preview` setting enabled or no (#2008)
- Bugfix: Fixed Stream thumbnail not updating after using the "Change channel" feature (#2074, #2080)
- Bugfix: Fixed previous link info not updating after `Link information` setting is enabled (#2054)
- Bugfix: Fix Tab key not working in the Ctrl+K Quick Switcher (#2065)
- Bugfix: Fix bug preventing moderator actions when viewing a user card from the search window (#1089)
- Bugfix: Fix `:` emote completion menu ignoring emote capitalization and inconsistent emote names. (#1962, #2543)
- Bugfix: Fix a bug that caused `Ignore page` to fall into an infinity loop with an empty pattern and regex enabled (#2125)
- Bugfix: Fix a crash caused by FrankerFaceZ responding with invalid emote links (#2191)
- Bugfix: Fix a freeze caused by ignored & replaced phrases followed by Twitch Emotes (#2231)
- Bugfix: Fix a crash bug that occurred when moving splits across windows and closing the "parent tab" (#2249, #2259)
- Bugfix: Fix a crash bug that occurred when the "Limit message height" setting was enabled and a message was being split up into multiple lines. IRC only. (#2329)
- Bugfix: Fix anonymous users being pinged by "username" justinfan64537 (#2156, #2352)
- Bugfix: Fixed hidden tooltips when always on top is active (#2384)
- Bugfix: Fix CLI arguments (`--help`, `--version`, `--channels`) not being respected (#2368, #2190)
- Bugfix: Fixed search field not being focused on popup open (#2540)
- Bugfix: Fix Twitch cheer emotes not displaying tooltips when hovered (#2434, #2503)
- Bugfix: Fix BTTV/FFZ channel emotes saying unknown error when no emotes found (#2542)
- Bugfix: Fix directory not opening when clicking "Open AppData Directory" setting button on macOS (#2531, #2537)
- Bugfix: Fix quickswitcher not respecting order of tabs when filtering (#2519, #2561)
- Bugfix: Fix GNOME not associating Chatterino's window with its desktop entry (#1863, #2587)
- Bugfix: Fix buffer overflow in emoji parsing. (#2602)
- Bugfix: Fix windows being brought back to life after the settings dialog was closed. (#1892, #2613)
- Dev: Updated minimum required Qt framework version to 5.12. (#2210)
- Dev: Migrated `Kraken::getUser` to Helix (#2260)
- Dev: Migrated `TwitchAccount::(un)followUser` from Kraken to Helix and moved it to `Helix::(un)followUser`. (#2306)
- Dev: Migrated `Kraken::getChannel` to Helix. (#2381)
- Dev: Migrated `TwitchAccount::(un)ignoreUser` to Helix and made `TwitchAccount::loadIgnores` use Helix call. (#2370)
- Dev: Build in CI with multiple Qt versions (#2349)
- Dev: Updated minimum required macOS version to 10.14 (#2386)
- Dev: Removed unused `humanize` library (#2422)

## 2.2.2

- Bugfix: Fix a potential crash related to channel point rewards (279a80b)

## 2.2.1

- Minor: Disable checking for updates on unsupported platforms (#1874)
- Bugfix: Fix bug preventing users from setting the highlight color of the second entry in the "User" highlights tab (#1898)

## 2.2.0

- Major: We now support image thumbnails coming from the link resolver. This feature is off by default and can be enabled in the settings with the "Show link thumbnail" setting. This feature also requires the "Show link info when hovering" setting to be enabled (#1664)
- Major: Added image upload functionality to i.nuuls.com with an ability to change upload destination. This works by dragging and dropping an image into a split, or pasting an image into the text edit field. (#1332, #1741)
- Major: Added option to display tabs vertically. (#1815)
- Major: Support the highlighted messages redeemed with channel points on twitch.tv.
- Major: Added emote completion with `:`
- Minor: Added a "Streamer Mode" that hides user generated images while obs is open.
- Minor: Added extension support for Brave browser and Microsoft Edge. (#1862)
- Minor: Add a switcher widget, similar to Discord. It can be opened by pressing Ctrl+K. (#1588)
- Minor: Clicking on `Open in browser` in a whisper split will now open your whispers on twitch. (#1828)
- Minor: Clicking on @mentions will open the User Popup. (#1674)
- Minor: You can now open the Twitch User Card by middle-mouse clicking a username. (#1669)
- Minor: User Popup now also includes recent user messages (#1729)
- Minor: BetterTTV / FrankerFaceZ emote tooltips now also have emote authors' name (#1721)
- Minor: Emotes in the emote popup are now sorted in the same order as the tab completion (#1549)
- Minor: Removed "Online Logs" functionality as services are shut down (#1640)
- Minor: CTRL+F now selects the Find text input field in the Settings Dialog (#1806 #1811)
- Minor: CTRL+F now selects the search text input field in the Search Popup (#1812)
- Minor: Modify our word boundary logic in highlight phrase searching to accomodate non-regex phrases with "word-boundary-creating" characters like ! (#1885, #1890)
- Bugfix: Fixed not being able to open links in incognito with Microsoft Edge (Chromium) (#1875)
- Bugfix: Fix the incorrect `Open stream in browser` labelling in the whisper split (#1860)
- Bugfix: Fix preview on hover not working when Animated emotes options was disabled (#1546)
- Bugfix: FFZ custom mod badges no longer scale with the emote scale options (#1602)
- Bugfix: MacOS updater looked for non-existing fields, causing it to always fail the update check (#1642)
- Bugfix: Fixed message menu crashing if the message you right-clicked goes out of scope before you select an action (#1783) (#1787)
- Bugfix: Fixed alternate messages flickering in UserInfoPopup when clicking Refresh if there was an odd number of messages in there (#1789 #1810)
- Bugfix: Fix a crash when using middle click scroll on a chat window. (#1870)
- Settings open faster
- Dev: Fully remove Twitch Chatroom support
- Dev: Handle conversion of historical CLEARCHAT messages to NOTICE messages in Chatterino instead of relying on the Recent Messages API to handle it for us. (#1804)
