# Contributing to Asus Screen Toggle

First of all, thank you for considering contributing to this project! It's people like you that make the Linux ecosystem on Asus laptops better.

## How Can I Contribute?

### Reporting Bugs
- Check the [Issues](../../issues) tab to see if the bug has already been reported.
- If not, open a new issue. Include your laptop model, Linux distribution, and desktop environment (KDE/GNOME/etc.).
- Provide logs if possible: `journalctl -u asus-screen-toggle`.

### Suggesting Enhancements
- Open an issue with the tag `enhancement`.
- Describe the feature and why it would be useful.

### Pull Requests
1. Fork the repository.
2. Create a new branch for your feature (`git checkout -b feature/amazing-feature`).
3. Commit your changes.
4. Push to the branch.
5. Open a Pull Request.

## Code Style
- **Python:** Please follow PEP 8.
- **Shell:** Use `shellcheck` before submitting scripts.
- **Translations:** If you want to add a new language, look into the `po/` directory.

## License
By contributing, you agree that your contributions will be licensed under its GPL-3.0 License.
