#!/bin/sh

# SPDX-License-Identifier: MIT
# Copyright (c) 2024 Linaro Ltd
# Author: Dmitry Baryshkov

FW_PKG_NAME="firmware-x1e80100-crd"
FW_SUBDIR="8380_CRD"
FW_VER="200.0.56.0"
LIB_FW_DIR="x1e80100"
FW_DEVNAME="Qualcomm X Elite Compute Reference Device"
DSP_DIR="x1e80100/Qualcomm/CRD"

SHAREDIR=/usr/share/firmware-qcom-woa

PNAME=`basename "$0" .sh`

while [ $# -gt 0 ]
do
	case "$1" in
		"-c")
			DLDIR="$2"
			mkdir -p "${DLDIR}"
			shift
			shift
			;;
		"-d")
			SHAREDIR="$2"
			shift
			shift
			;;
		"-l")
			LISTREMAIN=true
			shift
			;;
		"-o")
			OUTDIR="$2"
			shift
			shift
			;;
		"-h" | "--help")
			echo "Usage: $PNAME [OPTION]..."
			echo "Generate firmware package for ${FW_DEVNAME}"
			echo
			echo "Options:"
			echo " -c CACHEDIR  place downloaded files into that directory"
			echo " -d DATADIR   use specified dir as package-specific data location"
			echo " -l           list remaining files not added to the Debian packages"
			echo " -o OUTDIR    place generated files to that directory"
			exit 0
			;;
		*)
			echo "Unsupported option '$1'"
			exit 1
	esac
done

. ${SHAREDIR}/common.sh

do_prepare

do_dl \
	b7820a67e0543c7b08eeb56800c296dde9ffdc3843fb478d62dc9689f929b512 qcdx8380.cab \
	184e04c27e0bee350da28a2a60dbcd248f6ad844f68ad72e01f53668dafe2cad qcsubsys_ext_adsp8380.cab \
	1beb28c99d964f9b6af5b928cd29eb2257865082ad86c092dcb1d88aba3570b6 qcnspmcdm_ext_cdsp8380.cab \

do_install \
	qcadsp8380.mbn qccdsp8380.mbn qcdxkmsuc8380.mbn qcvss8380.mbn adsp_dtbs.elf cdsp_dtbs.elf

do_install \
	adspr.jsn adspua.jsn adsps.jsn battmgr.jsn cdspr.jsn

do_dsp adsp \
	ADSP/fastrpc_shell_0 ADSP/*Module.so.1 ADSP/*module.so.1 ADSP/*_module_fvxiii.so.1 ADSP/*_viii.so.1 \
	ADSP/libc++abi.so.1 ADSP/libc++.so.1 ADSP/libsns_*.so ADSP/sns_tppe.so \
	ADSP/libstabilitydomain_skel.so ADSP/libsysmon_skel.so \
	ADSP/libsysmondomain_skel.so ADSP/libsysmonquery_skel.so \
	ADSP/CFCM.so.1 ADSP/libaptXAdaptiveEnc3.so ADSP/libaptXAdaptiveEnc.so ADSP/liblc3qDec.so \
	ADSP/aptx_adaptive_speech_dec_module.1 ADSP/aptx_adaptive_speech_enc_module.2

do_dsp cdsp \
	CDSP/fastrpc_shell_3 CDSP/fastrpc_shell_unsigned_3 \
	CDSP/libbenchmark_skel.so CDSP/libc++abi.so.1 CDSP/libc++.so.1 \
	CDSP/libstabilitydomain_skel.so CDSP/libsysmon_skel.so \
	CDSP/libsysmondomain_skel.so CDSP/libsysmonhvxthrottle_skel.so CDSP/libsysmonquery_skel.so \
	CDSP/example_image.so CDSP/example_image_runner.so CDSP/version.so \
	CDSP/libcrm_test_skel.so CDSP/libloadalgo_skel.so CDSP/libQ6MSFR_manager_skel.so CDSP/libQ6MSFR_manager_skel_intermediate.so

ln -s qcadsp8380.mbn "${FW_OUT}"/adsp.mbn
ln -s qccdsp8380.mbn "${FW_OUT}"/cdsp.mbn

ln -s adsp_dtbs.elf "${FW_OUT}"/adsp_dtb.mbn
ln -s cdsp_dtbs.elf "${FW_OUT}"/cdsp_dtb.mbn
ln -s qcdxkmsuc8380.mbn "${FW_OUT}"/gen70500_zap.mbn

do_divert qcom/${LIB_FW_DIR}/gen70500_zap.mbn

do_ignore \
	libqcdx12arm64wslum.so qcdxkmbase8380*.bin \
	qcav1e8380.mbn qcgpuarm64compilercore.so qcvk_icd_arm64x.json vulkaninfo.exe VulkanRT-License.txt \
	sequence_manifest.bin unified_kbcs_*.bin unified_ksqs.bin \
	RADS.bin

# Purwa
do_ignore \
	qcdxkmsucpurwa.mbn qcvss8380_pa.mbn

do_build

