#!/bin/sh

# SPDX-License-Identifier: MIT
# Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
# Author: Dmitry Baryshkov

FW_PKG_NAME="firmware-sc8280xp-qrd"
FW_SUBDIR="8280_QRD"
FW_VER="200.0.68.0"
LIB_FW_DIR="sc8280xp"
FW_DEVNAME="Qualcomm SC8280XP Reference Device"
DSP_DIR="sc8280xp/Qualcomm/QRD"

SHAREDIR=/usr/share/firmware-qcom-woa

PNAME=`basename "$0" .sh`

while [ $# -gt 0 ]
do
	case "$1" in
		"-c")
			DLDIR="$2"
			mkdir -p "${DLDIR}"
			shift
			shift
			;;
		"-d")
			SHAREDIR="$2"
			shift
			shift
			;;
		"-l")
			LISTREMAIN=true
			shift
			;;
		"-o")
			OUTDIR="$2"
			shift
			shift
			;;
		"-h" | "--help")
			echo "Usage: $PNAME [OPTION]..."
			echo "Generate firmware package for ${FW_DEVNAME}"
			echo
			echo "Options:"
			echo " -c CACHEDIR  place downloaded files into that directory"
			echo " -d DATADIR   use specified dir as package-specific data location"
			echo " -l           list remaining files not added to the Debian packages"
			echo " -o OUTDIR    place generated files to that directory"
			exit 0
			;;
		*)
			echo "Unsupported option '$1'"
			exit 1
	esac
done

. ${SHAREDIR}/common.sh

do_prepare

do_dl \
	5c952c09bb1d92d6a872b2b10a36e2b009570813b5c2720fe4ee26584cca4a97  qcdx8280.cab \
	20d8f58b418ab808cc66bf74113f2298fc38d34c2564a8a49044bbfc737342ee  qcsubsys_ext_adsp8280.cab \
	fb7d25acd7927f15d26c0ba59eeb4650d0d886bdd8d6f56cd5c927a4ede7194a  qcsubsys_ext_cdsp8280.cab \
	804dd03d711efc3f703aad87f6c59cfac451b1ce879c67dd0414e8ab6f8f48ad  qcsubsys_ext_scss8280.cab \
	6ee9728e474f5800eff240fb913f008eeee1ab60a912f7903d599e554f9c36ad  qcwlan8280.cab \

do_install \
	qcadsp8280.mbn qccdsp8280.mbn qcdxkmsuc8280.mbn qcvss8280.mbn qcslpi8280.mbn

do_install \
	adspr.jsn adspua.jsn battmgr.jsn cdspr.jsn

do_install \
	bdwlan.e* bdwlang.e*

do_dsp adsp \
	ADSP/fastrpc_shell_0 ADSP/*Module.so.1 ADSP/*module.so.1 ADSP/*_module_fvx.so.1 \
	ADSP/libstabilitydomain_skel.so ADSP/libsysmon_skel.so \
	ADSP/libsysmondomain_skel.so ADSP/libsysmonquery_skel.so \
	ADSP/CFCM.so.1 ADSP/libaptXAdaptiveEnc3.so ADSP/libaptXAdaptiveEnc.so ADSP/liblc3qDec.so

do_dsp cdsp \
	CDSP/fastrpc_shell_3 CDSP/fastrpc_shell_unsigned_3 \
	CDSP/libbenchmark_skel.so CDSP/libc++abi.so.1 CDSP/libc++.so.1 \
	CDSP/libstabilitydomain_skel.so CDSP/libsysmon_skel.so \
	CDSP/libsysmondomain_skel.so CDSP/libsysmonhvxthrottle_skel.so CDSP/libsysmonquery_skel.so \
	CDSP/example_image.so CDSP/libcvpdsp_2_1.so CDSP/libcvpdsp_2_1_intermediate.so CDSP/libloadalgo_skel.so

do_dsp sdsp \
	SLPI/fastrpc_shell_2 \
	SLPI/libstabilitydomain_skel.so SLPI/libsysmon_skel.so SLPI/libsysmondomain_skel.so SLPI/libsysmonquery_skel.so

do_ignore \
	Data.msc Data20.msc m3.bin m320.bin wlanfw.mbn wlanfw20.mbn regdb.bin \
	libqcdx12arm64wslum.so libqcdxarm64wslcompiler.so qcdxkmbase8280*.bin qcdxwsaum.img \
	RADS.bin RCDS.bin RSCS.bin

do_build
