#!/bin/sh

# SPDX-License-Identifier: MIT
# Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
# Author: Dmitry Baryshkov

FW_PKG_NAME="firmware-sc8180x-primus"
FW_SUBDIR="8180_CLS"
FW_VER="200.0.117.0"
LIB_FW_DIR="sc8180x"
FW_DEVNAME="Qualcomm SC8180X Primus laptop"
DSP_DIR="sc8180x/Qualcomm/Primus"

SHAREDIR=/usr/share/firmware-qcom-woa

PNAME=`basename "$0" .sh`

while [ $# -gt 0 ]
do
	case "$1" in
		"-c")
			DLDIR="$2"
			mkdir -p "${DLDIR}"
			shift
			shift
			;;
		"-d")
			SHAREDIR="$2"
			shift
			shift
			;;
		"-l")
			LISTREMAIN=true
			shift
			;;
		"-o")
			OUTDIR="$2"
			shift
			shift
			;;
		"-h" | "--help")
			echo "Usage: $PNAME [OPTION]..."
			echo "Generate firmware package for ${FW_DEVNAME}"
			echo
			echo "Options:"
			echo " -c CACHEDIR  place downloaded files into that directory"
			echo " -d DATADIR   use specified dir as package-specific data location"
			echo " -l           list remaining files not added to the Debian packages"
			echo " -o OUTDIR    place generated files to that directory"
			exit 0
			;;
		*)
			echo "Unsupported option '$1'"
			exit 1
	esac
done

. ${SHAREDIR}/common.sh

do_prepare

do_dl \
	bfb3fdf600035d8b533639fed9207ecad15c74c432ad554e1ac57f199b57ffa8 qcdx8180.cab \
	5ad8841c3e3843c8aff5ba700c7a430b8e96613c050c06950588774975b7ec27 qcipa8180.cab \
	f8d933268225fc622f15c7013570fc4ccd9227f35c8e7b759deb3926005f8101 qcsubsys_ext_adsp8180.cab \
	ee4308c785c34249d715e38e9b08264fcd9e2b9860528d2791b2a0306fe9cb87 qcsubsys_ext_cdsp8180.cab \
	46f81f4b4ef915bd6bc48c406b954dd8ed26e35fa13f4c06946c6ce0a643f006 qcsubsys_ext_mpss8180.cab \
	d6ba9bbf9c4981342e740bfd304985af1104c213a8d12f1edcbc16c366e76a2e qcsubsys_ext_scss8180.cab \
	0609fc0e5b8bee7eb82cff52965a10d7ce7224ff4595e2c059041ce49abc543a qcwlan8180.cab \

do_install \
	qcadsp8180.mbn qccdsp8180.mbn qcdxkmsuc8180.mbn qcvss8180.mbn ipa_fws.elf qcmpss8180.mbn qcmpss8180_nm.mbn qcslpi8180.mbn wlanmdsp.mbn

do_install_jsn \
	adspr.jsn adspua.jsn battmgr.jsn cdspr.jsn slpir.jsn slpius.jsn

do_install \
	bdwlan.b* bdwlanu.b*

do_dsp adsp \
	ADSP/fastrpc_shell_0 ADSP/*Module.so.1 ADSP/*module.so.1 \
	ADSP/AudioContextDetection.so.1 \
	ADSP/libstabilitydomain_skel.so ADSP/libsysmon_skel.so \
	ADSP/libsysmondomain_skel.so ADSP/libsysmonquery_skel.so

do_dsp cdsp \
	CDSP/fastrpc_shell_3 CDSP/fastrpc_shell_unsigned_3 CDSP/libvpp_*so CDSP/ubwcdma_dynlib.so \
	CDSP/libbenchmark_skel.so CDSP/libc++abi.so.1 CDSP/libc++.so.1 CDSP/libhcp_rpc_skel.so \
	CDSP/libhta_dsp_skel.so CDSP/libstabilitydomain_skel.so CDSP/libsysmon_skel.so \
	CDSP/libsysmondomain_skel.so CDSP/libsysmonhvxthrottle_skel.so CDSP/libsysmonquery_skel.so

do_ignore \
	Data.msc libqcdx12arm64wslum.so libqcdxarm64wslcompiler.so qcdxwsaum.img RCDS.bin RSCS.bin

do_build
